/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.J9ConstantHelper;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9JavaClassFlags;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ValueTypeHelper {
    protected static final Logger logger = Logger.getLogger("j9ddr.interactive.context");
    private static ValueTypeHelper helper = null;

    private ValueTypeHelper() {
    }

    private static boolean checkIfValueTypesAreSupported() {
        return J9ConstantHelper.getBoolean(J9BuildFlags.class, "J9VM_OPT_VALHALLA_VALUE_TYPES", false) || J9ConstantHelper.getBoolean(J9BuildFlags.class, "opt_valhallaValueTypes", false);
    }

    public static ValueTypeHelper getValueTypeHelper() {
        if (helper == null) {
            helper = ValueTypeHelper.checkIfValueTypesAreSupported() ? new ValueTypeSupportEnabledHelper() : new ValueTypeHelper();
        }
        return helper;
    }

    public boolean areValueTypesSupported() {
        return false;
    }

    public J9ClassPointer findJ9ClassInFlattenedClassCacheWithFieldName(J9ClassPointer j9ClassPointer, String string) throws CorruptDataException {
        logger.log(Level.SEVERE, "Value types were not enabled in the JVM that produced this core file.");
        throw new RuntimeException("Invalid operation");
    }

    public J9ClassPointer[] findNestedClassHierarchy(J9ClassPointer j9ClassPointer, String[] stringArray) throws CorruptDataException {
        logger.log(Level.SEVERE, "Value types were not enabled in the JVM that produced this core file.");
        throw new RuntimeException("Invalid operation");
    }

    public J9ClassPointer findJ9ClassInFlattenedClassCacheWithSigName(J9ClassPointer j9ClassPointer, String string) throws CorruptDataException {
        logger.log(Level.SEVERE, "Value types were not enabled in the JVM that produced this core file.");
        throw new RuntimeException("Invalid operation");
    }

    public boolean isRomClassAValueType(J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        return false;
    }

    public boolean isJ9ClassAValueType(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return false;
    }

    public boolean isFieldInClassFlattened(J9ClassPointer j9ClassPointer, String string) throws CorruptDataException {
        return false;
    }

    public boolean isFlattenableFieldSignature(String string) {
        return false;
    }

    public boolean isJ9ClassLargestAlignmentConstraintDouble(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return false;
    }

    public boolean isJ9ClassLargestAlignmentConstraintReference(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return false;
    }

    public boolean isJ9ClassIsFlattened(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return false;
    }

    public boolean classRequires4BytePrePadding(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return false;
    }

    private static class ValueTypeSupportEnabledHelper
    extends ValueTypeHelper {
        private static final long J9AccValueType = J9ConstantHelper.getLong(J9JavaAccessFlags.class, "J9AccValueType", 0L);
        private static final long J9ClassIsValueType = J9ConstantHelper.getLong(J9JavaClassFlags.class, "J9ClassIsValueType", 0L);
        private static final long J9ClassLargestAlignmentConstraintDouble = J9ConstantHelper.getLong(J9JavaClassFlags.class, "J9ClassLargestAlignmentConstraintDouble", 0L);
        private static final long J9ClassLargestAlignmentConstraintReference = J9ConstantHelper.getLong(J9JavaClassFlags.class, "J9ClassLargestAlignmentConstraintReference", 0L);
        private static final long J9ClassIsFlattened = J9ConstantHelper.getLong(J9JavaClassFlags.class, "J9ClassIsFlattened", 0L);
        private static final long J9ClassRequiresPrePadding = J9ConstantHelper.getLong(J9JavaClassFlags.class, "J9ClassRequiresPrePadding", 0L);
        private static final UDATA J9ClassFlagsMask = new UDATA(255L);
        private static final UDATA J9ClazzInEntryMask = new UDATA(J9ClassFlagsMask.bitNot());
        private MethodHandle getFlattenedClassCachePointer = null;
        private Class<?> flattenedClassCachePointer = null;
        private MethodHandle flattenedClassCache_numberOfEntries = null;
        private MethodHandle flattenedClassCacheEntry_field = null;
        private MethodHandle flattenedClassCacheEntry_clazz = null;
        private MethodHandle flattenedClassCacheEntry_cast = null;
        private Class<?> flattenedClassCacheEntryPointer = null;

        ValueTypeSupportEnabledHelper() {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                this.flattenedClassCachePointer = Class.forName("com.ibm.j9ddr.vm29.pointer.generated.J9FlattenedClassCachePointer");
                this.getFlattenedClassCachePointer = lookup.findVirtual(J9ClassPointer.class, "flattenedClassCache", MethodType.methodType(this.flattenedClassCachePointer));
                this.flattenedClassCache_numberOfEntries = lookup.findVirtual(this.flattenedClassCachePointer, "numberOfEntries", MethodType.methodType(UDATA.class));
                this.flattenedClassCacheEntryPointer = Class.forName("com.ibm.j9ddr.vm29.pointer.generated.J9FlattenedClassCacheEntryPointer");
                this.flattenedClassCacheEntry_field = lookup.findVirtual(this.flattenedClassCacheEntryPointer, "field", MethodType.methodType(J9ROMFieldShapePointer.class));
                this.flattenedClassCacheEntry_clazz = lookup.findVirtual(this.flattenedClassCacheEntryPointer, "clazz", MethodType.methodType(J9ClassPointer.class));
                this.flattenedClassCacheEntry_cast = lookup.findStatic(this.flattenedClassCacheEntryPointer, "cast", MethodType.methodType(this.flattenedClassCacheEntryPointer, AbstractPointer.class));
            }
            catch (Throwable throwable) {
                ValueTypeSupportEnabledHelper.throwUncheckedExceptions(throwable);
                logger.log(Level.SEVERE, "ValueTypeHelper: failed to get ValueTypeHelper method handles", throwable);
            }
        }

        private static void throwUncheckedExceptions(Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
        }

        private static CorruptDataException handleThrowable(Throwable throwable) throws CorruptDataException {
            ValueTypeSupportEnabledHelper.throwUncheckedExceptions(throwable);
            throw new CorruptDataException(throwable);
        }

        @Override
        public boolean areValueTypesSupported() {
            return true;
        }

        private J9ClassPointer findJ9ClassInFlattenedClassCacheWithFieldNameImpl(StructurePointer structurePointer, String string) throws CorruptDataException {
            J9ClassPointer j9ClassPointer = J9ClassPointer.NULL;
            try {
                UDATA uDATA = this.flattenedClassCache_numberOfEntries.invoke(structurePointer);
                StructurePointer structurePointer2 = this.flattenedClassCacheEntry_cast.invoke(structurePointer.add(1L));
                int n = uDATA.intValue();
                for (int i = 0; i < n; ++i) {
                    String string2 = J9UTF8Helper.stringValue(this.flattenedClassCacheEntry_field.invoke(structurePointer2).nameAndSignature().name());
                    if (string2.equals(string)) {
                        j9ClassPointer = this.flattenedClassCacheEntry_clazz.invoke(structurePointer2);
                        UDATA uDATA2 = UDATA.cast(j9ClassPointer);
                        j9ClassPointer = J9ClassPointer.cast(uDATA2.bitAnd(J9ClazzInEntryMask));
                        break;
                    }
                    structurePointer2 = (StructurePointer)structurePointer2.add(1L);
                }
            }
            catch (ClassCastException | WrongMethodTypeException runtimeException) {
                logger.log(Level.SEVERE, "ValueTypeHelper: failed to find field in flattened class cache with field name.", runtimeException);
            }
            catch (Throwable throwable) {
                throw ValueTypeSupportEnabledHelper.handleThrowable(throwable);
            }
            return j9ClassPointer;
        }

        @Override
        public J9ClassPointer findJ9ClassInFlattenedClassCacheWithFieldName(J9ClassPointer j9ClassPointer, String string) throws CorruptDataException {
            J9ClassPointer j9ClassPointer2 = J9ClassPointer.NULL;
            try {
                StructurePointer structurePointer = this.getFlattenedClassCachePointer.invoke(j9ClassPointer);
                if (!structurePointer.isNull()) {
                    j9ClassPointer2 = this.findJ9ClassInFlattenedClassCacheWithFieldNameImpl(structurePointer, string);
                }
            }
            catch (ClassCastException | WrongMethodTypeException runtimeException) {
                logger.log(Level.SEVERE, "ValueTypeHelper: failed to find field in flattened class cache with field name", runtimeException);
            }
            catch (Throwable throwable) {
                throw ValueTypeSupportEnabledHelper.handleThrowable(throwable);
            }
            return j9ClassPointer2;
        }

        private J9ClassPointer findJ9ClassInFlattenedClassCacheWithFieldSigImpl(StructurePointer structurePointer, String string) throws CorruptDataException {
            J9ClassPointer j9ClassPointer = J9ClassPointer.NULL;
            try {
                UDATA uDATA = this.flattenedClassCache_numberOfEntries.invoke(structurePointer);
                StructurePointer structurePointer2 = this.flattenedClassCacheEntry_cast.invoke(structurePointer.add(1L));
                int n = uDATA.intValue();
                for (int i = 0; i < n; ++i) {
                    String string2 = J9UTF8Helper.stringValue(this.flattenedClassCacheEntry_field.invoke(structurePointer2).nameAndSignature().signature());
                    if ((string2 = string2.substring(1, string2.length() - 1)).equals(string)) {
                        j9ClassPointer = this.flattenedClassCacheEntry_clazz.invoke(structurePointer2);
                        UDATA uDATA2 = UDATA.cast(j9ClassPointer);
                        j9ClassPointer = J9ClassPointer.cast(uDATA2.bitAnd(J9ClazzInEntryMask));
                        break;
                    }
                    structurePointer2 = (StructurePointer)structurePointer2.add(1L);
                }
            }
            catch (ClassCastException | WrongMethodTypeException runtimeException) {
                logger.log(Level.SEVERE, "ValueTypeHelper: failed to find field in flattened class cache with field signature", runtimeException);
            }
            catch (Throwable throwable) {
                throw ValueTypeSupportEnabledHelper.handleThrowable(throwable);
            }
            return j9ClassPointer;
        }

        @Override
        public J9ClassPointer[] findNestedClassHierarchy(J9ClassPointer j9ClassPointer, String[] stringArray) throws CorruptDataException {
            J9ClassPointer[] j9ClassPointerArray = new J9ClassPointer[stringArray.length + 1];
            J9ClassPointer j9ClassPointer2 = j9ClassPointer;
            int n = 0;
            if (Pattern.matches("\\[\\d+\\]", stringArray[0])) {
                j9ClassPointerArray[0] = j9ClassPointer.arrayClass();
                n = 1;
            }
            j9ClassPointerArray[n] = j9ClassPointer;
            while (n < stringArray.length) {
                j9ClassPointerArray[n + 1] = j9ClassPointer2 = this.findJ9ClassInFlattenedClassCacheWithFieldName(j9ClassPointer2, stringArray[n]);
                ++n;
            }
            return j9ClassPointerArray;
        }

        @Override
        public J9ClassPointer findJ9ClassInFlattenedClassCacheWithSigName(J9ClassPointer j9ClassPointer, String string) throws CorruptDataException {
            J9ClassPointer j9ClassPointer2 = J9ClassPointer.NULL;
            try {
                StructurePointer structurePointer = this.getFlattenedClassCachePointer.invoke(j9ClassPointer);
                if (!structurePointer.isNull()) {
                    j9ClassPointer2 = this.findJ9ClassInFlattenedClassCacheWithFieldSigImpl(structurePointer, string);
                }
            }
            catch (ClassCastException | WrongMethodTypeException runtimeException) {
                logger.log(Level.SEVERE, "ValueTypeHelper: failed to find field in flattened class cache with field signature", runtimeException);
            }
            catch (Throwable throwable) {
                throw ValueTypeSupportEnabledHelper.handleThrowable(throwable);
            }
            return j9ClassPointer2;
        }

        @Override
        public boolean isRomClassAValueType(J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
            if (J9AccValueType != 0L) {
                return j9ROMClassPointer.modifiers().allBitsIn(J9AccValueType);
            }
            return false;
        }

        @Override
        public boolean isJ9ClassAValueType(J9ClassPointer j9ClassPointer) throws CorruptDataException {
            if (J9ClassIsValueType != 0L) {
                return j9ClassPointer.classFlags().allBitsIn(J9ClassIsValueType);
            }
            return false;
        }

        @Override
        public boolean isFieldInClassFlattened(J9ClassPointer j9ClassPointer, String string) throws CorruptDataException {
            boolean bl = false;
            try {
                J9ClassPointer j9ClassPointer2;
                StructurePointer structurePointer = this.getFlattenedClassCachePointer.invoke(j9ClassPointer);
                if (!structurePointer.isNull() && !(j9ClassPointer2 = this.findJ9ClassInFlattenedClassCacheWithFieldNameImpl(structurePointer, string)).isNull()) {
                    bl = this.isJ9ClassIsFlattened(j9ClassPointer2);
                }
            }
            catch (ClassCastException | WrongMethodTypeException runtimeException) {
                logger.log(Level.SEVERE, "ValueTypeHelper: failed to determine if field is flattened", runtimeException);
                throw new RuntimeException(runtimeException);
            }
            catch (Throwable throwable) {
                throw ValueTypeSupportEnabledHelper.handleThrowable(throwable);
            }
            return bl;
        }

        @Override
        public boolean isJ9ClassLargestAlignmentConstraintDouble(J9ClassPointer j9ClassPointer) throws CorruptDataException {
            if (J9ClassLargestAlignmentConstraintDouble != 0L) {
                return J9ClassHelper.extendedClassFlags(j9ClassPointer).allBitsIn(J9ClassLargestAlignmentConstraintDouble);
            }
            return false;
        }

        @Override
        public boolean isJ9ClassLargestAlignmentConstraintReference(J9ClassPointer j9ClassPointer) throws CorruptDataException {
            if (J9ClassLargestAlignmentConstraintReference != 0L) {
                return J9ClassHelper.extendedClassFlags(j9ClassPointer).allBitsIn(J9ClassLargestAlignmentConstraintReference);
            }
            return false;
        }

        @Override
        public boolean isJ9ClassIsFlattened(J9ClassPointer j9ClassPointer) throws CorruptDataException {
            if (J9ClassIsFlattened != 0L) {
                return J9ClassHelper.extendedClassFlags(j9ClassPointer).allBitsIn(J9ClassIsFlattened);
            }
            return false;
        }

        @Override
        public boolean classRequires4BytePrePadding(J9ClassPointer j9ClassPointer) throws CorruptDataException {
            if (J9ClassRequiresPrePadding != 0L) {
                return J9ClassHelper.extendedClassFlags(j9ClassPointer).allBitsIn(J9ClassRequiresPrePadding);
            }
            return false;
        }

        @Override
        public boolean isFlattenableFieldSignature(String string) {
            return string.startsWith("Q");
        }
    }
}

