/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.OMR_VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class J9ThreadHelper {
    private static WeakReference<Map<Long, IOSThread>> cachedThreads = null;

    public static VoidPointer getTLS(J9ThreadPointer j9ThreadPointer, UDATA uDATA) throws CorruptDataException {
        return VoidPointer.cast(j9ThreadPointer.tlsEA().at(uDATA.sub(1L)));
    }

    public static J9VMThreadPointer getVMThread(J9ThreadPointer j9ThreadPointer) throws CorruptDataException {
        J9VMThreadPointer j9VMThreadPointer = null;
        OMR_VMThreadPointer oMR_VMThreadPointer = OMR_VMThreadPointer.cast(J9ThreadHelper.getTLS(j9ThreadPointer, J9RASHelper.getVM(DataType.getJ9RASPointer()).omrVM()._vmThreadKey()));
        j9VMThreadPointer = oMR_VMThreadPointer.isNull() ? J9VMThreadPointer.NULL : J9VMThreadPointer.cast(oMR_VMThreadPointer._language_vmthread());
        return j9VMThreadPointer;
    }

    public static IOSThread getOSThread(J9ThreadPointer j9ThreadPointer) throws CorruptDataException {
        return J9ThreadHelper.getOSThread(j9ThreadPointer.tid().longValue());
    }

    public static IOSThread getOSThread(long l) throws CorruptDataException {
        Map<Long, IOSThread> map = J9ThreadHelper.getThreadMap();
        return map.get(l);
    }

    public static Iterator<IOSThread> getOSThreads() throws CorruptDataException {
        Map<Long, IOSThread> map = J9ThreadHelper.getThreadMap();
        return map.values().iterator();
    }

    private static Map<Long, IOSThread> getThreadMap() throws CorruptDataException {
        TreeMap<Long, IOSThread> treeMap = null;
        if (cachedThreads != null) {
            treeMap = (TreeMap<Long, IOSThread>)cachedThreads.get();
        }
        if (treeMap != null) {
            return treeMap;
        }
        treeMap = new TreeMap<Long, IOSThread>();
        for (IOSThread iOSThread : DataType.getProcess().getThreads()) {
            treeMap.put(iOSThread.getThreadId(), iOSThread);
        }
        cachedThreads = new WeakReference(treeMap);
        return treeMap;
    }
}

