/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.Pointer;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

public class UDATAPointer
extends Pointer {
    public static final int SIZEOF = UDATA.SIZEOF;
    public static final UDATAPointer NULL = new UDATAPointer(0L);

    protected UDATAPointer(long l) {
        super(l);
    }

    public static UDATAPointer cast(AbstractPointer abstractPointer) {
        return UDATAPointer.cast(abstractPointer.getAddress());
    }

    public static UDATAPointer cast(UDATA uDATA) {
        return UDATAPointer.cast(uDATA.longValue());
    }

    public static UDATAPointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new UDATAPointer(l);
    }

    @Override
    public UDATA at(long l) throws CorruptDataException {
        return this.getUDATAAtOffset((long)SIZEOF * l);
    }

    @Override
    public UDATA at(Scalar scalar) throws CorruptDataException {
        return this.at(scalar.longValue());
    }

    @Override
    public UDATAPointer untag() {
        return this.untag(SIZEOF - 1);
    }

    @Override
    public UDATAPointer untag(long l) {
        return new UDATAPointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public UDATAPointer add(long l) {
        return new UDATAPointer(this.address + (long)SIZEOF * l);
    }

    @Override
    public UDATAPointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public UDATAPointer addOffset(long l) {
        return new UDATAPointer(this.address + l);
    }

    @Override
    public UDATAPointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public UDATAPointer sub(long l) {
        return new UDATAPointer(this.address - (long)SIZEOF * l);
    }

    @Override
    public UDATAPointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    public IDATA sub(UDATAPointer uDATAPointer) {
        long l = this.sizeOfBaseType();
        if (l != uDATAPointer.sizeOfBaseType()) {
            throw new UnsupportedOperationException("Cannot subtract pointers to types of different sizes; this type = " + this.getClass() + ", parameter type = " + uDATAPointer.getClass());
        }
        IDATA iDATA = new IDATA(this.address).sub(new IDATA(uDATAPointer.address));
        return new IDATA(iDATA.longValue() / l);
    }

    @Override
    public UDATAPointer subOffset(long l) {
        return new UDATAPointer(this.address - l);
    }

    @Override
    public UDATAPointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return SIZEOF;
    }
}

