/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.walkers.LineNumber;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9LineNumberPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodDebugInfoPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodDebugInfoHelper;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U8;
import java.util.Iterator;

public abstract class LineNumberIterator
implements Iterator<LineNumber> {
    public static LineNumberIterator lineNumberIteratorFor(J9MethodDebugInfoPointer j9MethodDebugInfoPointer) throws CorruptDataException {
        if (AlgorithmVersion.getVersionOf("VM_LINE_NUMBER_TABLE_VERSION").getAlgorithmVersion() < 1) {
            return new LineNumberIterator_V0(j9MethodDebugInfoPointer);
        }
        return new LineNumberIterator_V1(j9MethodDebugInfoPointer);
    }

    public abstract U8Pointer getLineNumberTablePtr();

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class LineNumberIterator_V1
    extends LineNumberIterator {
        private J9MethodDebugInfoPointer methodInfo;
        private U32 count = new U32(0L);
        private U8Pointer lineNumberTablePtr;
        private U32 lineNumber = new U32(0L);
        private U32 location = new U32(0L);

        public LineNumberIterator_V1(J9MethodDebugInfoPointer j9MethodDebugInfoPointer) throws CorruptDataException {
            this.methodInfo = j9MethodDebugInfoPointer;
            this.lineNumberTablePtr = J9MethodDebugInfoHelper.getCompressedLineNumberTableForROMClassV1(j9MethodDebugInfoPointer);
        }

        @Override
        public boolean hasNext() {
            try {
                return this.count.lt(J9MethodDebugInfoHelper.getLineNumberCount(this.methodInfo));
            }
            catch (CorruptDataException corruptDataException) {
                return false;
            }
        }

        @Override
        public U8Pointer getLineNumberTablePtr() {
            return this.lineNumberTablePtr;
        }

        @Override
        public LineNumber next() {
            block7: {
                this.count = this.count.add(1);
                try {
                    U8 u8 = this.lineNumberTablePtr.at(0L);
                    if (u8.bitAnd(128).eq(0L)) {
                        this.location = this.location.add(u8.rightShift(2).bitAnd(31));
                        this.lineNumber = this.lineNumber.add(u8.bitAnd(3));
                        this.lineNumberTablePtr = this.lineNumberTablePtr.add(1L);
                        break block7;
                    }
                    if (u8.bitAnd(192).eq(128L)) {
                        U16 u16 = new U16(u8).leftShift(8);
                        this.lineNumberTablePtr = this.lineNumberTablePtr.add(1L);
                        u16 = new U16(u16.bitOr(this.lineNumberTablePtr.at(0L)));
                        this.location = this.location.add(u16.rightShift(9).bitAnd(31));
                        this.lineNumber = this.lineNumber.add(LineNumberIterator_V1.signExtend(new I16(u16.bitAnd(511)), 9));
                        this.lineNumberTablePtr = this.lineNumberTablePtr.add(1L);
                        break block7;
                    }
                    if (u8.bitAnd(224).eq(192L)) {
                        U32 u32 = new U32(u8).leftShift(16);
                        this.lineNumberTablePtr = this.lineNumberTablePtr.add(1L);
                        u32 = u32.bitOr(U16Pointer.cast(this.lineNumberTablePtr).at(0L));
                        this.location = this.location.add(u32.rightShift(14).bitAnd(127));
                        this.lineNumber = this.lineNumber.add(LineNumberIterator_V1.signExtend(new I16(u32.bitAnd(16383)), 14));
                        this.lineNumberTablePtr = this.lineNumberTablePtr.add(2L);
                        break block7;
                    }
                    if (u8.bitAnd(240).eq(224L)) {
                        this.lineNumberTablePtr = this.lineNumberTablePtr.add(1L);
                        this.location = this.location.add(U16Pointer.cast(this.lineNumberTablePtr).at(0L));
                        this.lineNumberTablePtr = this.lineNumberTablePtr.add(2L);
                        I32 i32 = new I32(U16Pointer.cast(this.lineNumberTablePtr).at(0L));
                        if (u8.bitAnd(1).eq(1L)) {
                            i32 = i32.bitAnd(65535);
                        }
                        this.lineNumber = this.lineNumber.add(i32);
                        this.lineNumberTablePtr = this.lineNumberTablePtr.add(2L);
                        break block7;
                    }
                    return null;
                }
                catch (CorruptDataException corruptDataException) {
                    EventManager.raiseCorruptDataEvent("CorruptData encountered walking port LineNumbers.", corruptDataException, false);
                    return null;
                }
            }
            return new LineNumber(this.lineNumber, this.location);
        }

        private static I16 signExtend(I16 i16, int n) {
            int n2 = 16 - n;
            return i16.leftShift(n2).rightShift(n2);
        }
    }

    private static class LineNumberIterator_V0
    extends LineNumberIterator {
        private J9MethodDebugInfoPointer methodInfo;
        private J9LineNumberPointer lineNumberPtr;
        private U32 count = new U32(0L);
        private U32 location = new U32(0L);

        public LineNumberIterator_V0(J9MethodDebugInfoPointer j9MethodDebugInfoPointer) throws CorruptDataException {
            this.methodInfo = j9MethodDebugInfoPointer;
            this.lineNumberPtr = J9MethodDebugInfoHelper.getLineNumberTableForROMClass(j9MethodDebugInfoPointer);
        }

        @Override
        public boolean hasNext() {
            try {
                return this.count.lt(this.methodInfo.lineNumberCount());
            }
            catch (CorruptDataException corruptDataException) {
                return false;
            }
        }

        @Override
        public LineNumber next() {
            this.count = this.count.add(1);
            try {
                LineNumber lineNumber = new LineNumber(new U32(this.lineNumberPtr.lineNumber()), this.location);
                this.lineNumberPtr = this.lineNumberPtr.add(1L);
                return lineNumber;
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("CorruptData encountered walking port LineNumbers.", corruptDataException, false);
                return null;
            }
        }

        @Override
        public U8Pointer getLineNumberTablePtr() {
            return U8Pointer.cast(this.lineNumberPtr);
        }
    }
}

