/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.structure.J9JavaClassFlags;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.ArrayList;
import java.util.Iterator;

public class GCClassStaticsIterator
extends GCIterator {
    Iterator<J9ObjectPointer> slotsIterator;
    Iterator<VoidPointer> addressIterator;

    protected GCClassStaticsIterator(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        UDATAPointer uDATAPointer;
        long l;
        ArrayList<VoidPointer> arrayList;
        ArrayList<J9ObjectPointer> arrayList2;
        block6: {
            Object var2_2 = null;
            arrayList2 = new ArrayList<J9ObjectPointer>();
            arrayList = new ArrayList<VoidPointer>();
            l = j9ClassPointer.romClass().objectStaticCount().longValue();
            uDATAPointer = j9ClassPointer.ramStatics();
            if (uDATAPointer.isNull()) {
                l = 0L;
            }
            try {
                if (J9ClassHelper.extendedClassFlags(j9ClassPointer).allBitsIn(J9JavaClassFlags.J9ClassReusedStatics)) {
                    l = 0L;
                }
            }
            catch (NoSuchFieldError noSuchFieldError) {
                if (!J9ClassHelper.isSwappedOut(j9ClassPointer) || J9ClassHelper.areExtensionsEnabled()) break block6;
                l = 0L;
            }
        }
        while (l > 0L) {
            UDATA uDATA = uDATAPointer.at(0L);
            if (!uDATA.eq(0L)) {
                arrayList2.add(J9ObjectPointer.cast(uDATA));
                arrayList.add(VoidPointer.cast(uDATAPointer));
            }
            uDATAPointer = uDATAPointer.add(1L);
            --l;
        }
        this.slotsIterator = arrayList2.iterator();
        this.addressIterator = arrayList.iterator();
    }

    public static GCClassStaticsIterator fromJ9Class(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return new GCClassStaticsIterator(j9ClassPointer);
    }

    @Override
    public boolean hasNext() {
        return this.slotsIterator.hasNext();
    }

    @Override
    public J9ObjectPointer next() {
        this.addressIterator.next();
        return this.slotsIterator.next();
    }

    @Override
    public VoidPointer nextAddress() {
        this.slotsIterator.next();
        return this.addressIterator.next();
    }
}

