/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.IBootstrapRunnable;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.J9DDRClassLoader;
import com.ibm.j9ddr.StructureReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;

public class VMData
implements IVMData {
    private static final String version = "29";

    @Override
    public void bootstrapRelative(String string, Object ... objectArray) throws ClassNotFoundException {
        Class<?> clazz = this.getClassLoader().loadClassRelativeToStream(string, true);
        this.bootstrapClass(clazz, objectArray);
    }

    @Override
    public void bootstrap(String string, Object ... objectArray) throws ClassNotFoundException {
        Class<?> clazz = this.getClassLoader().loadClass(string);
        this.bootstrapClass(clazz, objectArray);
    }

    @Override
    public J9DDRClassLoader getClassLoader() {
        return (J9DDRClassLoader)VMData.class.getClassLoader();
    }

    private void bootstrapClass(Class<?> clazz, Object[] objectArray) {
        try {
            IBootstrapRunnable iBootstrapRunnable = (IBootstrapRunnable)clazz.newInstance();
            Method method = clazz.getMethod("run", IVMData.class, Object[].class);
            method.invoke((Object)iBootstrapRunnable, this, objectArray);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    @Override
    public Collection<StructureReader.StructureDescriptor> getStructures() {
        ClassLoader classLoader = VMData.class.getClassLoader();
        if (classLoader instanceof J9DDRClassLoader) {
            return ((J9DDRClassLoader)classLoader).getStructures();
        }
        throw new UnsupportedOperationException("This VMData wasn't loaded through a J9DDRClassLoader. Loaded by: " + classLoader + ", loader class: " + classLoader.getClass().getName());
    }

    @Override
    public String getVersion() {
        return version;
    }
}

