/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.ObjectMonitor;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.structure.J9AbstractThread;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9VMThread;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.HashMap;

public class J9VMThreadPointerUtil {
    private static int STATE_ALIVE = 1;
    private static int STATE_TERMINATED = 2;
    private static int STATE_RUNNABLE = 4;
    private static int STATE_WAITING_INDEFINITELY = 16;
    private static int STATE_WAITING_WITH_TIMEOUT = 32;
    private static int STATE_SLEEPING = 64;
    private static int STATE_WAITING = 128;
    private static int STATE_IN_OBJECT_WAIT = 256;
    private static int STATE_PARKED = 512;
    private static int STATE_BLOCKED_ON_MONITOR_ENTER = 1024;
    private static int STATE_SUSPENDED = 0x100000;
    private static int STATE_INTERRUPTED = 0x200000;
    private static int STATE_IN_NATIVE = 0x400000;
    private static int STATE_VENDOR_1 = 0x10000000;
    private static int STATE_VENDOR_2 = 0x20000000;
    private static int STATE_VENDOR_3 = 0x40000000;
    private static final int J9THREAD_MONITOR_OBJECT = 393216;
    private static final HashMap<Long, Integer> threadStateMap = new HashMap(9);

    public static int getDTFJState(J9VMThreadPointer j9VMThreadPointer) throws CorruptDataException {
        try {
            return threadStateMap.get(J9VMThreadPointerUtil.getJ9State(j9VMThreadPointer).state);
        }
        catch (NullPointerException nullPointerException) {
            return STATE_VENDOR_3;
        }
    }

    public static ThreadInfo getJ9State(J9VMThreadPointer j9VMThreadPointer) throws CorruptDataException {
        ThreadInfo threadInfo = new ThreadInfo();
        if (j9VMThreadPointer.isNull()) {
            threadInfo.state = new UDATA(J9VMThread.J9VMTHREAD_STATE_UNKNOWN).longValue();
            return threadInfo;
        }
        threadInfo.thread = j9VMThreadPointer;
        long l = J9VMThread.J9VMTHREAD_STATE_RUNNING;
        UDATA uDATA = j9VMThreadPointer.publicFlags();
        J9ThreadPointer j9ThreadPointer = j9VMThreadPointer.osThread();
        ThreadState threadState = new ThreadState(j9ThreadPointer);
        if (uDATA.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_BLOCKED | J9Consts.J9_PUBLIC_FLAGS_THREAD_WAITING)) {
            threadInfo.lockObject = j9VMThreadPointer.blockingEnterObject();
            ObjectMonitor objectMonitor = ObjectMonitor.fromJ9Object(threadInfo.lockObject);
            if (objectMonitor.isInflated()) {
                if (uDATA.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_BLOCKED)) {
                    if (objectMonitor.getOwner().notNull() && !objectMonitor.getOwner().equals(j9ThreadPointer)) {
                        l = J9VMThread.J9VMTHREAD_STATE_BLOCKED;
                        threadInfo.rawLock = J9ThreadMonitorPointer.cast(objectMonitor.getInflatedMonitor());
                    }
                } else if (j9ThreadPointer.isNull()) {
                    l = uDATA.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_TIMED) ? J9VMThread.J9VMTHREAD_STATE_WAITING_TIMED : J9VMThread.J9VMTHREAD_STATE_WAITING;
                    threadInfo.rawLock = J9ThreadMonitorPointer.cast(objectMonitor.getInflatedMonitor());
                } else if (objectMonitor.getInflatedMonitor().equals(threadState.blocker)) {
                    l = J9VMThreadPointerUtil.getInflatedMonitorState(j9ThreadPointer, threadState, threadInfo);
                }
            } else if (objectMonitor.getOwner().notNull() && !objectMonitor.getOwner().equals(j9VMThreadPointer)) {
                l = J9VMThread.J9VMTHREAD_STATE_BLOCKED;
            }
        } else if (uDATA.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_PARKED)) {
            if (j9ThreadPointer.isNull() || threadState.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_PARKED)) {
                threadInfo.lockObject = j9VMThreadPointer.blockingEnterObject();
                l = uDATA.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_TIMED) ? J9VMThread.J9VMTHREAD_STATE_PARKED_TIMED : J9VMThread.J9VMTHREAD_STATE_PARKED;
            }
        } else if (uDATA.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_SLEEPING)) {
            if (j9ThreadPointer.isNull() || threadState.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_SLEEPING)) {
                l = J9VMThread.J9VMTHREAD_STATE_SLEEPING;
            }
        } else if (j9ThreadPointer.isNull()) {
            l = J9VMThread.J9VMTHREAD_STATE_UNKNOWN;
        } else if (threadState.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_PARKED)) {
            l = threadState.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_TIMER_SET) ? J9VMThread.J9VMTHREAD_STATE_PARKED_TIMED : J9VMThread.J9VMTHREAD_STATE_PARKED;
        } else if (threadState.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_SLEEPING)) {
            l = J9VMThread.J9VMTHREAD_STATE_SLEEPING;
        } else if (threadState.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_DEAD)) {
            l = J9VMThread.J9VMTHREAD_STATE_DEAD;
        }
        if (J9VMThread.J9VMTHREAD_STATE_RUNNING == l) {
            threadInfo.lockObject = null;
            l = J9VMThreadPointerUtil.getInflatedMonitorState(j9ThreadPointer, threadState, threadInfo);
        }
        if ((threadInfo.lockObject == null || threadInfo.lockObject.isNull()) && threadInfo.rawLock != null && !threadInfo.rawLock.isNull() && threadInfo.rawLock.flags().allBitsIn(393216L)) {
            threadInfo.lockObject = J9ObjectPointer.cast(threadInfo.rawLock.userData());
        }
        if (threadState.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_INTERRUPTED)) {
            l |= J9VMThread.J9VMTHREAD_STATE_INTERRUPTED;
        }
        if (threadState.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_SUSPENDED)) {
            l |= J9VMThread.J9VMTHREAD_STATE_SUSPENDED;
        }
        if (uDATA.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_HALT_THREAD_JAVA_SUSPEND)) {
            l |= J9VMThread.J9VMTHREAD_STATE_SUSPENDED;
        }
        threadInfo.state = new UDATA(l).longValue();
        return threadInfo;
    }

    private static long getInflatedMonitorState(J9ThreadPointer j9ThreadPointer, ThreadState threadState, ThreadInfo threadInfo) {
        if (j9ThreadPointer.isNull()) {
            return J9VMThread.J9VMTHREAD_STATE_UNKNOWN;
        }
        if (threadState.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_BLOCKED) && threadState.owner.notNull() && !threadState.owner.equals(j9ThreadPointer)) {
            threadInfo.rawLock = threadState.blocker;
            return J9VMThread.J9VMTHREAD_STATE_BLOCKED;
        }
        if (threadState.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_WAITING) && !threadState.owner.equals(j9ThreadPointer)) {
            threadInfo.rawLock = threadState.blocker;
            if (threadState.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_TIMER_SET)) {
                return J9VMThread.J9VMTHREAD_STATE_WAITING_TIMED;
            }
            return J9VMThread.J9VMTHREAD_STATE_WAITING;
        }
        return J9VMThread.J9VMTHREAD_STATE_RUNNING;
    }

    static {
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_DEAD, STATE_TERMINATED);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_SUSPENDED, STATE_ALIVE | STATE_SUSPENDED);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_RUNNING, STATE_ALIVE | STATE_RUNNABLE);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_BLOCKED, STATE_ALIVE | STATE_BLOCKED_ON_MONITOR_ENTER);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_WAITING, STATE_ALIVE | STATE_WAITING | STATE_WAITING_INDEFINITELY | STATE_IN_OBJECT_WAIT);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_WAITING_TIMED, STATE_ALIVE | STATE_WAITING | STATE_WAITING_WITH_TIMEOUT | STATE_IN_OBJECT_WAIT);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_SLEEPING, STATE_ALIVE | STATE_WAITING | STATE_SLEEPING);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_PARKED, STATE_ALIVE | STATE_WAITING | STATE_WAITING_INDEFINITELY | STATE_PARKED);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_PARKED_TIMED, STATE_ALIVE | STATE_WAITING | STATE_WAITING_WITH_TIMEOUT | STATE_PARKED);
    }

    public static class ThreadInfo {
        private long state = 0L;
        private J9ObjectPointer lockObject;
        private J9ThreadMonitorPointer rawLock;
        private J9VMThreadPointer lockOwner;
        private J9VMThreadPointer thread;

        private ThreadInfo() {
        }

        public long getState() {
            return this.state;
        }

        public J9ObjectPointer getLockObject() {
            return this.lockObject;
        }

        public J9ThreadMonitorPointer getRawLock() {
            return this.rawLock;
        }

        public J9VMThreadPointer getLockOwner() {
            return this.lockOwner;
        }

        public J9VMThreadPointer getThread() {
            return this.thread;
        }
    }

    private static class ThreadState {
        private UDATA flags;
        private J9ThreadMonitorPointer blocker;
        private J9ThreadPointer owner;

        public ThreadState(J9ThreadPointer j9ThreadPointer) throws CorruptDataException {
            if (j9ThreadPointer.isNull()) {
                this.flags = new UDATA(0L);
                this.blocker = J9ThreadMonitorPointer.NULL;
                this.owner = J9ThreadPointer.NULL;
            } else {
                this.flags = j9ThreadPointer.flags();
                this.blocker = j9ThreadPointer.monitor();
                this.owner = this.blocker.isNull() ? J9ThreadPointer.NULL : this.blocker.owner();
            }
        }
    }
}

