/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.events;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.vm29.events.DefaultEventListener;
import java.util.LinkedList;
import java.util.logging.Logger;

public class EventManager {
    private static Logger log = Logger.getLogger(EventManager.class.getPackage().getName());
    private static LinkedList<IEventListener> listeners = null;
    private static DefaultEventListener defaultListener = null;

    public static void register(IEventListener iEventListener) {
        IEventListener iEventListener2;
        if (!listeners.isEmpty() && (iEventListener2 = listeners.peek()) == iEventListener) {
            log.warning(String.format("The specified event listener was already registered : %s", iEventListener.getClass().getName()));
            return;
        }
        listeners.addFirst(iEventListener);
    }

    public static void unregister(IEventListener iEventListener) {
        if (listeners.isEmpty()) {
            log.warning("There are no listeners left on the stack, skipping unregistration");
            return;
        }
        IEventListener iEventListener2 = listeners.peek();
        if (iEventListener2 != iEventListener) {
            String string = String.format("The top listener on the stack does not match : expected [%s] actual [%s]", iEventListener.getClass().getName(), iEventListener2.getClass().getName());
            log.warning(string);
            return;
        }
        listeners.removeFirst();
    }

    public static void raiseCorruptDataEvent(String string, CorruptDataException corruptDataException, boolean bl) {
        if (listeners.isEmpty()) {
            defaultListener.corruptData(string, corruptDataException, bl);
        } else {
            IEventListener iEventListener = listeners.peek();
            iEventListener.corruptData(string, corruptDataException, bl);
        }
    }

    static {
        listeners = new LinkedList();
        defaultListener = new DefaultEventListener();
    }
}

