/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;

public class FindInMemoryCommand
extends Command {
    private byte[] currentPattern;
    private int currentAlignment;
    private long currentAddress = -1L;
    private static final int TYPE_NONE = 0;
    private static final int TYPE_U8 = 1;
    private static final int TYPE_U16 = 2;
    private static final int TYPE_U32 = 3;
    private static final int TYPE_U64 = 4;
    private static final int TYPE_ASCII = 5;

    public FindInMemoryCommand() {
        this.addCommand("find", "<width|ascii pattern startaddr>", "Find first number or a search string in memory starting at an address");
        this.addCommand("findall", "<width|ascii pattern startaddr>", "Find all occurances of number or a search string in memory starting at an address");
        this.addCommand("findnext", "", "Find next match in the search initiated by find");
    }

    private void printHelp(PrintStream printStream) {
        printStream.append("Usage: \n");
        printStream.append("  !find u8|u16|u32|u64|udata|pointer 0xHEX|HEX [0xHexStartAddr|LongStartAddr]\n");
        printStream.append("  !find ascii <string> [0xHexStartAddr|LongStartAddr]\n");
        printStream.append("  !findall u8|u16|u32|u64|udata|pointer 0xHEX|HEX [0xHexStartAddr|LongStartAddr]\n");
        printStream.append("  !findall ascii <string> [0xHexStartAddr|LongStartAddr]\n");
        printStream.append("  !findnext\n");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        byte[] byArray;
        int n;
        String string2;
        IProcess iProcess = context.process;
        boolean bl = iProcess.getByteOrder().equals(ByteOrder.LITTLE_ENDIAN);
        int n2 = iProcess.bytesPerPointer();
        int n3 = n2 == 4 ? 3 : 4;
        int n4 = 0;
        boolean bl2 = false;
        int n5 = 0;
        if (string.endsWith("findnext")) {
            this.findNext(printStream, iProcess);
            return;
        }
        if (string.endsWith("findall")) {
            bl2 = true;
        }
        if (stringArray.length == 0) {
            this.printHelp(printStream);
            return;
        }
        String string3 = string2 = stringArray[n5++];
        if (string2.equalsIgnoreCase("u8")) {
            n4 = 1;
            n = 1;
        } else if (string2.equalsIgnoreCase("u16")) {
            n4 = 2;
            n = 2;
        } else if (string2.equalsIgnoreCase("u32")) {
            n4 = 3;
            n = 4;
        } else if (string2.equalsIgnoreCase("u64")) {
            n4 = 4;
            n = 8;
        } else if (string2.equalsIgnoreCase("udata")) {
            n4 = n3;
            n = n2;
        } else if (string2.equalsIgnoreCase("pointer")) {
            n4 = n3;
            n = n2;
        } else if (string2.equalsIgnoreCase("ascii")) {
            n4 = 5;
            n = 1;
        } else {
            this.printHelp(printStream);
            printStream.println("Unknown search type '" + string3 + "'\n");
            return;
        }
        if (stringArray.length <= n5) {
            this.printHelp(printStream);
            printStream.println("Expected pattern as argument " + (n5 + 1) + "\n");
            return;
        }
        string2 = stringArray[n5++];
        if (n4 == 5) {
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1, string2.lastIndexOf(34));
            }
            try {
                byArray = string2.getBytes("ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string2.getBytes();
            }
        } else {
            int n6;
            byArray = new byte[n];
            if (string2.startsWith("0x")) {
                string2 = string2.substring(2);
            }
            if ((n6 = (string2.length() + 1) / 2) > n) {
                printStream.println("Search pattern too long for type '" + string3 + "'");
                return;
            }
            string2 = "0000000000000000".concat(string2);
            string2 = string2.substring(string2.length() - n * 2);
            for (int i = 0; i < n; ++i) {
                int n7 = Integer.parseInt(string2.substring(i * 2, i * 2 + 2), 16);
                if (bl) {
                    byArray[n - i - 1] = (byte)(n7 & 0xFF);
                    continue;
                }
                byArray[i] = (byte)(n7 & 0xFF);
            }
        }
        long l = stringArray.length <= n5 ? 0L : ((string2 = stringArray[n5++]).startsWith("0x") ? Long.decode(string2) : Long.parseLong(string2, 16));
        this.currentAddress = l;
        this.currentAlignment = n;
        this.currentPattern = byArray;
        boolean bl3 = this.findFirst(printStream, iProcess);
        if (bl2) {
            while (bl3) {
                bl3 = this.findNext(printStream, iProcess);
            }
        }
    }

    private boolean findNext(PrintStream printStream, IProcess iProcess) {
        if (this.currentAddress == -1L) {
            printStream.println("No current search");
            return false;
        }
        long l = this.currentAddress + (long)this.currentAlignment;
        long l2 = iProcess.findPattern(this.currentPattern, this.currentAlignment, l);
        if (l2 == -1L) {
            printStream.println("No more matches");
            this.currentPattern = null;
            this.currentAlignment = 1;
            this.currentAddress = -1L;
            return false;
        }
        String string = "0x" + Long.toHexString(l2);
        printStream.println("Match found at " + string);
        this.currentAddress = l2;
        return true;
    }

    private boolean findFirst(PrintStream printStream, IProcess iProcess) {
        printStream.print("Scanning memory for ");
        for (int i = 0; i < this.currentPattern.length; ++i) {
            printStream.print(String.format("%02x ", this.currentPattern[i] & 0xFF));
        }
        printStream.println("aligned to " + this.currentAlignment + " starting from 0x" + Long.toHexString(this.currentAddress));
        long l = iProcess.findPattern(this.currentPattern, this.currentAlignment, this.currentAddress);
        if (l == -1L) {
            printStream.println("Search term not found");
            this.currentPattern = null;
            this.currentAlignment = 1;
            this.currentAddress = -1L;
            return false;
        }
        String string = "0x" + Long.toHexString(l);
        printStream.println("Match found at " + string);
        this.currentAddress = l;
        return true;
    }
}

