/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.le;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpaceImageInputStream;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexedb32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexedb64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexedbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexqpcb32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexqpcb64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexqpcbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexqpcbpool32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexqpcbpool64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexqpcbpoolTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Dll;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.EnsmTemplate;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Logger;

public class Edb {
    private long address;
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private Properties envVars;
    CeexedbTemplate ceexedbTemplate;
    private CeexqpcbTemplate ceexqpcbTemplate;
    private CeexqpcbpoolTemplate ceexqpcbpoolTemplate;
    private boolean is64bit;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");
    private Dll firstDll = null;

    public Edb(long l, AddressSpace addressSpace, boolean bl) {
        this.address = l;
        this.space = addressSpace;
        this.is64bit = bl;
        this.inputStream = addressSpace.getImageInputStream();
        this.createTemplates(addressSpace);
    }

    void createTemplates(AddressSpace addressSpace) {
        if (this.is64bit) {
            this.ceexedbTemplate = new Ceexedb64Template();
            this.ceexqpcbTemplate = new Ceexqpcb64Template();
            this.ceexqpcbpoolTemplate = new Ceexqpcbpool64Template();
        } else {
            this.ceexedbTemplate = new Ceexedb32Template();
            this.ceexqpcbTemplate = new Ceexqpcb32Template();
            this.ceexqpcbpoolTemplate = new Ceexqpcbpool32Template();
        }
    }

    public long address() {
        return this.address;
    }

    public long ceeedbensm() throws IOException {
        return this.ceexedbTemplate.getCeeedbensm(this.inputStream, this.address);
    }

    public long ensm_aheap() throws IOException {
        assert (!this.space.is64bit());
        return this.ceeedbensm() + (long)EnsmTemplate.getEnsm_aheap$offset();
    }

    public long ensm_uheap() throws IOException {
        assert (!this.space.is64bit());
        return this.ceeedbensm() + (long)EnsmTemplate.getEnsm_uheap$offset();
    }

    public long ceeedboptcb() throws IOException {
        return this.ceexedbTemplate.getCeeedboptcb(this.inputStream, this.address);
    }

    public long ceeedb_ceeosigr() throws IOException {
        return this.ceexedbTemplate.getCeeedb_ceeosigr(this.inputStream, this.address);
    }

    public long ceeedb_qpcb() throws IOException {
        return this.ceexedbTemplate.getCeeedb_qpcb(this.inputStream, this.address);
    }

    public long getMallocSize(long l) throws IOException, IllegalArgumentException {
        long l2;
        long l3 = this.space.readWord(l - (long)(2 * this.space.getWordLength()));
        if (l3 != (l2 = this.space.readWord(l - (long)this.space.getWordLength()))) {
            try {
                String string = this.space.readEbcdicString(l3, 4);
                if (!string.equals("HANC")) {
                    throw new IllegalArgumentException("Did not find HANC eyecatcher at index1 " + Edb.hex(l3) + " given ptr " + Edb.hex(l) + " index2 " + Edb.hex(l2));
                }
                if (l2 < 0L) {
                    throw new IllegalArgumentException("Negative size " + l2 + " given ptr " + Edb.hex(l));
                }
                return l2;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Got exception while reading hanc pointer " + Edb.hex(l3) + " given ptr " + Edb.hex(l));
            }
        }
        if (l3 < 1L || l3 > 12L) {
            throw new IllegalArgumentException("Unexpected index1 " + Edb.hex(l3) + " for ptr " + Edb.hex(l));
        }
        long l4 = this.ceeedb_qpcb();
        assert (this.space.readEbcdicString(l4, 4).equals("QPCB"));
        long l5 = l4 + (long)this.ceexqpcbTemplate.getQpcb_pool_data_array$offset();
        long l6 = this.ceexqpcbpoolTemplate.getQpcb_pool_index(this.inputStream, l5 += (l3 - 1L) * (long)this.ceexqpcbpoolTemplate.length());
        if (l6 != l3) {
            log.fine("bad pool index " + l6 + " does not match " + l3);
            return 0L;
        }
        long l7 = this.ceexqpcbpoolTemplate.getQpcb_input_cell_size(this.inputStream, l5);
        assert (l7 + (long)(2 * this.space.getWordLength()) == this.ceexqpcbpoolTemplate.getQpcb_cell_size(this.inputStream, l5));
        return l7;
    }

    public long ceeedbdba() throws IOException {
        return this.ceexedbTemplate.getCeeedbdba(this.inputStream, this.address);
    }

    public static Edb getSampleEdb(AddressSpace addressSpace) {
        Caa[] caaArray = Caa.getCaas(addressSpace);
        for (int i = 0; i < caaArray.length; ++i) {
            Edb edb = caaArray[i].getEdb();
            log.fine("found edb " + edb + " for caa " + caaArray[i]);
            try {
                if (edb.getFirstDll() == null) continue;
                log.fine("edb has a dll: " + edb.getFirstDll());
                return edb;
            }
            catch (IOException iOException) {
                log.fine("caught exception: " + iOException);
            }
        }
        log.fine("no sample edb found");
        return null;
    }

    public static Edb[] getEdbs(AddressSpace addressSpace) {
        HashSet<Edb> hashSet = new HashSet<Edb>();
        Caa[] caaArray = Caa.getCaas(addressSpace);
        for (int i = 0; i < caaArray.length; ++i) {
            Edb edb = caaArray[i].getEdb();
            log.fine("found edb " + edb + " for caa " + caaArray[i]);
            try {
                if (edb.getFirstDll() == null) continue;
                log.fine("edb has a dll: " + edb.getFirstDll());
                hashSet.add(edb);
                continue;
            }
            catch (IOException iOException) {
                log.fine("caught exception: " + iOException);
            }
        }
        log.fine("no sample edb found");
        return hashSet.toArray(new Edb[0]);
    }

    public Dll getFirstDll() throws IOException {
        if (this.firstDll == null) {
            long l = this.ceexedbTemplate.getCeeedb_dlcb_first(this.inputStream, this.address);
            log.fine("ceeedb_dlcb_first = " + Edb.hex(l));
            if (l != 0L) {
                this.firstDll = new Dll(l, this.space);
            }
        }
        return this.firstDll;
    }

    public Properties getEnvVars() throws IOException {
        if (this.envVars != null) {
            return this.envVars;
        }
        this.envVars = new Properties();
        long l = this.ceexedbTemplate.getCeeedbenvar(this.inputStream, this.address);
        long l2 = 0L;
        while ((l2 = this.space.readWord(l, this.is64bit)) != 0L) {
            String string = this.space.readEbcdicCString(l2);
            int n = string.indexOf(61);
            if (n <= 0) {
                log.fine("bad name: " + string);
            } else {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                this.envVars.put(string2, string3);
            }
            l += (long)(this.is64bit ? 8 : 4);
        }
        return this.envVars;
    }

    public boolean rptstg() throws IOException {
        return (this.space.readUnsignedByte(this.ceeedboptcb() + 204L) & 0x80) != 0;
    }

    public boolean storage() throws IOException {
        return (this.space.readUnsignedByte(this.ceeedboptcb() + 236L) & 0x80) != 0;
    }

    public boolean equals(Object object) {
        Edb edb = (Edb)object;
        return edb.space == this.space && edb.address == this.address;
    }

    public int hashCode() {
        return (int)this.address;
    }

    private static String hex(long l) {
        return Long.toHexString(l);
    }

    private static String hex(int n) {
        return Integer.toHexString(n);
    }

    public String toString() {
        return Edb.hex(this.address);
    }
}

