/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.memory.IMemory;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import java.io.IOException;
import javax.imageio.stream.ImageInputStreamImpl;

public class IMemoryImageInputStream
extends ImageInputStreamImpl {
    private final IMemory memory;
    private long address;

    public IMemoryImageInputStream(IMemory iMemory, long l) {
        this.memory = iMemory;
        this.address = l;
        this.setByteOrder(iMemory.getByteOrder());
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        try {
            n3 = this.memory.getBytesAt(this.address, byArray, n, n2);
        }
        catch (MemoryFault memoryFault) {
            if (memoryFault.getAddress() == this.address) {
                return -1;
            }
            n3 = (int)(memoryFault.getAddress() - this.address);
        }
        this.address += (long)n3;
        return n3;
    }

    @Override
    public int read() throws IOException {
        int n = 0;
        try {
            n = 0xFF & this.memory.getByteAt(this.address);
        }
        catch (MemoryFault memoryFault) {
            return -1;
        }
        ++this.address;
        return n;
    }

    @Override
    public long getStreamPosition() throws IOException {
        return this.address;
    }

    @Override
    public void seek(long l) throws IOException {
        this.address = l;
    }
}

