/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.macho;

import com.ibm.j9ddr.corereaders.macho.LoadCommand;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.stream.ImageInputStream;

public class SymtabCommand
extends LoadCommand {
    int symtabOffset;
    int numSymbols;
    int stringsOffset;
    int stringsSize;
    List<SymtabEntry64> entries;
    byte[] stringsBytes;
    List<String> strings;

    @Override
    public SymtabCommand readCommand(ImageInputStream imageInputStream, long l) throws IOException {
        super.readCommand(imageInputStream, l);
        this.symtabOffset = imageInputStream.readInt();
        this.numSymbols = imageInputStream.readInt();
        this.stringsOffset = imageInputStream.readInt();
        this.stringsSize = imageInputStream.readInt();
        this.stringsBytes = null;
        return this;
    }

    public void readSymbolTable(ImageInputStream imageInputStream) throws IOException {
        int n;
        imageInputStream.seek((long)this.symtabOffset + this.segmentOffset);
        this.entries = new ArrayList<SymtabEntry64>(this.numSymbols);
        for (n = 0; n < this.numSymbols; ++n) {
            SymtabEntry64 symtabEntry64 = new SymtabEntry64();
            symtabEntry64.strIndex = imageInputStream.readInt();
            symtabEntry64.nType = imageInputStream.readByte();
            symtabEntry64.nSect = imageInputStream.readByte();
            symtabEntry64.nDesc = imageInputStream.readShort();
            symtabEntry64.nValue = imageInputStream.readLong();
            this.entries.add(symtabEntry64);
        }
        imageInputStream.seek((long)this.stringsOffset + this.segmentOffset);
        this.strings = new ArrayList<String>();
        this.stringsBytes = new byte[this.stringsSize];
        imageInputStream.readFully(this.stringsBytes);
        n = 0;
        while (n < this.stringsBytes.length) {
            int n2;
            for (n2 = n; n2 < this.stringsBytes.length && this.stringsBytes[n2] != 0; ++n2) {
            }
            String string = new String(this.stringsBytes, n, n2 - n, StandardCharsets.US_ASCII);
            this.strings.add(string);
            n = n2 + 1;
        }
    }

    public static class SymtabEntry64 {
        int strIndex;
        byte nType;
        byte nSect;
        short nDesc;
        long nValue;
        public static final int N_UNDF = 0;
        public static final int N_ABS = 2;
        public static final int N_SECT = 14;
        public static final int N_PBUD = 12;
        public static final int N_INDR = 10;
        public static final int REFERENCE_FLAG_UNDEFINED_NON_LAZY = 0;
        public static final int REFERENCE_FLAG_UNDEFINED_LAZY = 1;
        public static final int REFERENCE_FLAG_DEFINED = 2;
        public static final int REFERENCE_FLAG_PRIVATE_DEFINED = 3;
        public static final int REFERENCE_FLAG_PRIVATE_UNDEFINED_NON_LAZY = 4;
        public static final int REFERENCE_FLAG_PRIVATE_UNDEFINED_LAZY = 5;

        public boolean isStab() {
            return 0 != (this.nType & 0xFFFFFFE0);
        }

        public byte getStab() {
            return (byte)(this.nType & 0xFFFFFFE0);
        }

        public boolean isPrivateExternal() {
            return 0 != (this.nType & 0x10);
        }

        public byte getType() {
            return (byte)(this.nType & 0xE);
        }

        public boolean isExternal() {
            return 0 != (this.nType & 1);
        }

        public int getCommonAlignment() {
            return this.nDesc >>> 8 & 0xF;
        }

        public int getReferenceType() {
            return this.nDesc & 7;
        }
    }
}

