/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.macho;

import com.ibm.j9ddr.corereaders.CoreReader;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ICoreFileReader;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.macho.MachoDumpReader;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class MachoDumpReaderFactory
implements ICoreFileReader {
    @Override
    public ICore processDump(String string) throws InvalidDumpFormatException, IOException {
        return MachoDumpReader.getReaderForFile(new File(string));
    }

    @Override
    public ICore processDump(ImageInputStream imageInputStream) throws InvalidDumpFormatException, IOException {
        return MachoDumpReader.getReaderForFile(imageInputStream);
    }

    @Override
    public ICoreFileReader.DumpTestResult testDump(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            return ICoreFileReader.DumpTestResult.FILE_NOT_FOUND;
        }
        return MachoDumpReader.isMACHO(CoreReader.getFileHeader(string)) ? ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT : ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
    }

    @Override
    public ICoreFileReader.DumpTestResult testDump(ImageInputStream imageInputStream) throws IOException {
        return MachoDumpReader.isMACHO(CoreReader.getFileHeader(imageInputStream)) ? ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT : ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
    }
}

