/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders;

import com.ibm.j9ddr.corereaders.ILibraryResolver;
import com.ibm.j9ddr.corereaders.LibraryDataSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class ZipFileResolver
implements ILibraryResolver {
    private static Logger log = Logger.getLogger("com.ibm.j9ddr.library.path");
    private final File zipfile;
    private ArrayList<String> entryNames = null;
    private ZipFile zip = null;

    public ZipFileResolver(ImageInputStream imageInputStream) {
        URI uRI = null;
        try {
            uRI = new URI(imageInputStream.toString());
            if (uRI.getFragment() != null && uRI.getFragment().length() != 0) {
                uRI = new URI(uRI.getScheme() + "://" + uRI.getPath());
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            log.log(Level.FINE, "Skipping zip resolver as the supplied stream was not a ZipMemoryCacheImageInputStream");
            this.zipfile = null;
            return;
        }
        this.zipfile = uRI.getScheme().equals("file") ? new File(uRI) : null;
    }

    @Override
    public LibraryDataSource getLibrary(String string, boolean bl) throws FileNotFoundException {
        if (this.zipfile == null) {
            throw new FileNotFoundException(string);
        }
        ZipEntry zipEntry = null;
        try {
            Object object;
            this.zip = new ZipFile(this.zipfile);
            if (this.entryNames == null) {
                this.entryNames = new ArrayList();
                object = this.zip.entries();
                while (object.hasMoreElements()) {
                    ZipEntry zipEntry2 = object.nextElement();
                    this.entryNames.add(zipEntry2.getName());
                    if (!zipEntry2.getName().equals(string)) continue;
                    zipEntry = zipEntry2;
                }
                if (zipEntry == null) {
                    throw new FileNotFoundException(string);
                }
            } else if (this.entryNames.contains(string)) {
                zipEntry = this.zip.getEntry(string);
            } else {
                throw new FileNotFoundException(string);
            }
            object = new MemoryCacheImageInputStream(this.zip.getInputStream(zipEntry));
            log.fine("Resolved library " + string + " in zip file " + this.zipfile.getAbsolutePath());
            return new LibraryDataSource(string, (ImageInputStream)object);
        }
        catch (IOException iOException) {
            log.log(Level.FINE, "Error resolving library in zip file " + this.zipfile.getAbsolutePath(), iOException);
            throw new FileNotFoundException(string + " (due to underlying IOException)");
        }
    }

    @Override
    public LibraryDataSource getLibrary(String string) throws FileNotFoundException {
        return this.getLibrary(string, true);
    }

    @Override
    public void dispose() {
        if (this.zip != null) {
            try {
                this.zip.close();
            }
            catch (IOException iOException) {
                log.log(Level.FINE, "Error closing zip file", iOException);
            }
        }
    }
}

