/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.utils.file;

import com.ibm.dtfj.utils.file.CompressedFileManager;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class GZipFileManager
extends CompressedFileManager {
    public GZipFileManager(File file) {
        super(file);
    }

    @Override
    public void extract(ManagedImageSource managedImageSource, File file) throws IOException {
        this.validateImageSource(managedImageSource);
        this.extract(file);
    }

    @Override
    public ImageInputStream getStream(ManagedImageSource managedImageSource) throws IOException {
        this.validateImageSource(managedImageSource);
        return this.getStream();
    }

    private void validateImageSource(ManagedImageSource managedImageSource) throws IOException {
        File file = new File(managedImageSource.getPath());
        if (!file.equals(this.managedFile)) {
            throw new IOException("The specified Image Source : " + managedImageSource.getArchive().getAbsolutePath() + " does not match the contents of " + this.managedFile.getAbsolutePath());
        }
    }

    @Override
    public ImageInputStream getStream() throws IOException {
        FileInputStream fileInputStream = new FileInputStream(this.managedFile);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
        return new MemoryCacheImageInputStream(gZIPInputStream);
    }

    @Override
    public void extract(File file) throws IOException {
        this.checkDirectoryToExtractTo(file);
        FileInputStream fileInputStream = new FileInputStream(this.managedFile);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
        File file2 = new File(file, this.managedFile.getName());
        file2.deleteOnExit();
        this.extractEntry(gZIPInputStream, file2);
    }
}

