/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.phd.PHDCorruptData;
import com.ibm.dtfj.phd.PHDCorruptImageModule;
import com.ibm.dtfj.phd.PHDCorruptImageThread;
import com.ibm.dtfj.phd.PHDImage;
import com.ibm.dtfj.phd.PHDImageFactory;
import com.ibm.dtfj.phd.PHDImageModule;
import com.ibm.dtfj.phd.PHDImageThread;
import com.ibm.dtfj.phd.PHDJavaRuntime;
import com.ibm.dtfj.phd.parser.HeapdumpReader;
import java.io.File;
import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.imageio.stream.ImageInputStream;

class PHDImageProcess
implements ImageProcess {
    private final boolean is64bit;
    private final List<JavaRuntime> runtimes;
    private final String pid;
    private final ImageProcess metaImageProcess;
    private final ArrayList<ImageModule> modules = new ArrayList();
    private final LinkedHashMap<Object, ImageThread> threads = new LinkedHashMap();
    private CorruptData modules_cd;
    private ImageThread currentThread;

    PHDImageProcess(ImageInputStream imageInputStream, PHDImage pHDImage, ImageAddressSpace imageAddressSpace, ImageProcess imageProcess) throws IOException {
        this.metaImageProcess = imageProcess;
        JavaRuntime javaRuntime = this.getJavaRuntime(imageProcess);
        HeapdumpReader heapdumpReader = new HeapdumpReader(imageInputStream, pHDImage);
        this.is64bit = heapdumpReader.is64Bit();
        this.processData(imageAddressSpace);
        this.pid = "<unknown pid>";
        this.runtimes = new ArrayList<JavaRuntime>();
        this.runtimes.add(new PHDJavaRuntime(imageInputStream, pHDImage, imageAddressSpace, this, javaRuntime));
    }

    PHDImageProcess(File file, PHDImage pHDImage, ImageAddressSpace imageAddressSpace, ImageProcess imageProcess) throws IOException {
        this.metaImageProcess = imageProcess;
        JavaRuntime javaRuntime = this.getJavaRuntime(imageProcess);
        HeapdumpReader heapdumpReader = new HeapdumpReader(file, pHDImage);
        this.is64bit = heapdumpReader.is64Bit();
        this.processData(imageAddressSpace);
        this.pid = this.getPID(file);
        this.runtimes = new ArrayList<JavaRuntime>();
        this.runtimes.add(new PHDJavaRuntime(file, pHDImage, imageAddressSpace, this, javaRuntime));
    }

    private JavaRuntime getJavaRuntime(ImageProcess imageProcess) {
        Object e;
        Iterator iterator;
        JavaRuntime javaRuntime = null;
        if (imageProcess != null && (iterator = imageProcess.getRuntimes()).hasNext() && !((e = iterator.next()) instanceof CorruptData) && e instanceof JavaRuntime) {
            javaRuntime = (JavaRuntime)e;
        }
        return javaRuntime;
    }

    private void processData(ImageAddressSpace imageAddressSpace) {
        if (this.metaImageProcess != null) {
            ImageModule imageModule;
            Object object;
            Object object2;
            try {
                object2 = this.metaImageProcess.getLibraries();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (object instanceof CorruptData) {
                        this.modules.add(new PHDCorruptImageModule(imageAddressSpace, (CorruptData)object));
                        continue;
                    }
                    try {
                        imageModule = (ImageModule)object;
                        this.modules.add(new PHDImageModule(imageModule.getName()));
                    }
                    catch (CorruptDataException corruptDataException) {
                        this.modules.add(new PHDCorruptImageModule(imageAddressSpace, corruptDataException));
                    }
                }
            }
            catch (CorruptDataException corruptDataException) {
                this.modules_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
            }
            catch (DataUnavailable dataUnavailable) {
                // empty catch block
            }
            try {
                object2 = this.metaImageProcess.getCurrentThread();
            }
            catch (CorruptDataException corruptDataException) {
                this.currentThread = new PHDCorruptImageThread(imageAddressSpace, corruptDataException.getCorruptData());
                object2 = null;
            }
            object = this.metaImageProcess.getThreads();
            while (object.hasNext()) {
                imageModule = object.next();
                if (imageModule instanceof CorruptData) {
                    this.threads.put(imageModule, new PHDCorruptImageThread(imageAddressSpace, (CorruptData)((Object)imageModule)));
                    continue;
                }
                ImageThread imageThread = (ImageThread)((Object)imageModule);
                ImageThread imageThread2 = this.getThread(imageAddressSpace, imageThread);
                if (!imageThread.equals(object2)) continue;
                this.currentThread = imageThread2;
            }
        }
    }

    private String getPID(File file) {
        String string = null;
        String string2 = file.getName();
        string = this.getPID(string2, PHDImageFactory.earliestDump, PHDImageFactory.latestDump);
        if (string == null) {
            string = this.getPIDAIX(string2, PHDImageFactory.earliestDump, PHDImageFactory.latestDump);
        }
        return string;
    }

    private String getPID(String string, Date date, Date date2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd.HHmmss");
        ParsePosition parsePosition = new ParsePosition(0);
        block2: for (int i = 0; i < string.length(); ++i) {
            parsePosition.setIndex(i);
            Date date3 = simpleDateFormat.parse(string, parsePosition);
            if (date3 == null || date.before(date3) || !date2.after(date3)) continue;
            String[] stringArray = string.substring(parsePosition.getIndex()).split("\\.");
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].equals("")) continue;
                try {
                    Integer.parseInt(stringArray[j]);
                    return stringArray[j];
                }
                catch (NumberFormatException numberFormatException) {
                    continue block2;
                }
            }
        }
        return null;
    }

    private String getPIDAIX(String string, Date date, Date date2) {
        String string2 = "heapdump";
        int n = Math.max(0, string.indexOf(string2));
        String[] stringArray = (string = string.substring(n)).split("\\.");
        if ((stringArray.length == 3 || stringArray.length == 4 && stringArray[3].equals("gz")) && stringArray[0].startsWith(string2)) {
            try {
                int n2 = Integer.parseInt(stringArray[0].substring(string2.length()));
                long l = Long.parseLong(stringArray[1]);
                Date date3 = new Date(l * 1000L);
                if (!date3.before(date) && date3.before(date2)) {
                    return Integer.toString(n2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getCommandLine() throws DataUnavailable, CorruptDataException {
        if (this.metaImageProcess != null) {
            return this.metaImageProcess.getCommandLine();
        }
        throw new DataUnavailable();
    }

    @Override
    public ImageThread getCurrentThread() throws CorruptDataException {
        return this.currentThread;
    }

    @Override
    public Properties getEnvironment() throws DataUnavailable, CorruptDataException {
        if (this.metaImageProcess != null) {
            return this.metaImageProcess.getEnvironment();
        }
        throw new DataUnavailable();
    }

    @Override
    public ImageModule getExecutable() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable();
    }

    @Override
    public String getID() throws DataUnavailable, CorruptDataException {
        if (this.pid != null) {
            return this.pid;
        }
        throw new DataUnavailable();
    }

    @Override
    public Iterator<ImageModule> getLibraries() throws DataUnavailable, CorruptDataException {
        if (this.modules_cd != null) {
            throw new CorruptDataException(this.modules_cd);
        }
        if (this.modules.size() == 0) {
            throw new DataUnavailable();
        }
        return this.modules.iterator();
    }

    @Override
    public int getPointerSize() {
        return this.is64bit ? 64 : 32;
    }

    @Override
    public Iterator<JavaRuntime> getRuntimes() {
        return this.runtimes.iterator();
    }

    @Override
    public String getSignalName() throws DataUnavailable, CorruptDataException {
        if (this.metaImageProcess != null) {
            return this.metaImageProcess.getSignalName();
        }
        throw new DataUnavailable();
    }

    @Override
    public int getSignalNumber() throws DataUnavailable, CorruptDataException {
        if (this.metaImageProcess != null) {
            return this.metaImageProcess.getSignalNumber();
        }
        throw new DataUnavailable();
    }

    @Override
    public Iterator<ImageThread> getThreads() {
        return this.threads.values().iterator();
    }

    ImageThread getThread(ImageAddressSpace imageAddressSpace, ImageThread imageThread) {
        if (!this.threads.containsKey(imageThread)) {
            PHDImageThread pHDImageThread = new PHDImageThread(imageAddressSpace, imageThread);
            this.threads.put(imageThread, pHDImageThread);
        }
        return this.threads.get(imageThread);
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }
}

