/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.framework.scanner;

import com.ibm.dtfj.javacore.parser.framework.input.IInputBuffer;
import com.ibm.dtfj.javacore.parser.framework.scanner.IParserToken;
import com.ibm.dtfj.javacore.parser.framework.scanner.IScanner;
import com.ibm.dtfj.javacore.parser.framework.scanner.ScannerException;
import com.ibm.dtfj.javacore.parser.framework.scanner.TokenManager;
import com.ibm.dtfj.javacore.parser.j9.J9TagManager;
import java.io.IOException;
import java.util.ArrayList;

public class JavaCoreScanner
implements IScanner {
    private IInputBuffer fInputBuffer;
    private StringBuffer fLocalCache;
    private int fLineNumber;
    private String fUnknownType;
    private String fUnparsedType;
    private J9TagManager fTagManager;
    private int fMaxLineLength;
    private ArrayList fTokenCache;
    private static final short SEPARATE_ON_WHITESPACE = 1;
    private static final short GRAB_ALL = 2;

    public JavaCoreScanner(IInputBuffer iInputBuffer, J9TagManager j9TagManager) {
        this.fTagManager = j9TagManager;
        this.fUnknownType = "UNKNOWN_TAG";
        this.fUnparsedType = "UNPARSED";
        this.fInputBuffer = iInputBuffer;
        this.fLocalCache = new StringBuffer();
        this.fLineNumber = 0;
        this.fTokenCache = new ArrayList();
        this.fMaxLineLength = 32768;
    }

    @Override
    public IParserToken next() throws IOException, ScannerException {
        IParserToken iParserToken = null;
        if (this.fTokenCache.isEmpty()) {
            this.fillTokenCache();
        }
        if (this.fTokenCache.size() > 0) {
            iParserToken = (IParserToken)this.fTokenCache.remove(0);
        }
        return iParserToken;
    }

    private void fillTokenCache() throws IOException, ScannerException {
        this.readNextLine();
        boolean bl = false;
        while (!bl && !this.fInputBuffer.endReached()) {
            this.clear(this.fLocalCache);
            this.nextCharacterSequence(1, this.fLocalCache);
            if (this.fLocalCache.length() > 0) {
                if (this.fTagManager.isComment(this.fLocalCache)) {
                    this.consume(this.fLocalCache);
                    if (this.moreLeftInLine()) {
                        this.nextCharacterSequence(2, this.fLocalCache);
                        this.consume(this.fLocalCache);
                    }
                    this.readNextLine();
                    continue;
                }
                this.processTag();
                bl = true;
                continue;
            }
            if (this.moreLeftInLine()) {
                this.consume(1);
            }
            this.readNextLine();
        }
    }

    private boolean readNextLine() throws IOException {
        boolean bl = false;
        if (this.fInputBuffer.length() == 0 && (bl = this.fInputBuffer.nextLine())) {
            ++this.fLineNumber;
        }
        return bl;
    }

    private int consume(StringBuffer stringBuffer) throws IOException {
        int n = this.consume(stringBuffer.length());
        this.clear(stringBuffer);
        return n;
    }

    private int consume(int n) throws IOException {
        return this.fInputBuffer.consume(n);
    }

    private boolean moreLeftInLine() {
        return this.fInputBuffer.length() > 0;
    }

    private void processTag() throws IOException, ScannerException {
        String string = this.fLocalCache.toString();
        String string2 = this.fTagManager.hasTag(string) ? string : this.fUnknownType;
        int n = string.length();
        int n2 = this.consume(this.fLocalCache);
        this.fTokenCache.add(TokenManager.getToken(n, n2, this.fLineNumber, string2, string));
        if (this.moreLeftInLine()) {
            string2 = this.fUnparsedType;
            this.nextCharacterSequence(2, this.fLocalCache);
            string = this.fLocalCache.toString();
            n = this.fLocalCache.length();
            this.consume(this.fLocalCache);
            this.fTokenCache.add(TokenManager.getToken(n, n2, this.fLineNumber, string2, string));
        }
    }

    private void nextCharacterSequence(int n, StringBuffer stringBuffer) throws ScannerException {
        int n2 = n;
        n2 &= 0xFFFFFFFE;
        int n3 = this.fInputBuffer.length();
        for (int i = 0; i < n3 && (n2 & 1) == 0; ++i) {
            char c = this.fInputBuffer.charAt(i);
            if (Character.isWhitespace(c) && (n & 1) == 1) {
                n2 |= 1;
            } else {
                stringBuffer.append(c);
            }
            if (i <= this.fMaxLineLength) continue;
            throw new ScannerException("Maximum line length (" + this.fMaxLineLength + ") exceeded. Input file corrupt or not a javacore.");
        }
    }

    private void clear(StringBuffer stringBuffer) {
        stringBuffer.delete(0, stringBuffer.length());
    }

    @Override
    public boolean allTokensGenerated() {
        return this.fInputBuffer.endReached() && this.fTokenCache.isEmpty();
    }

    public void setMaximumLineLength(int n) {
        this.fMaxLineLength = n;
    }

    public int getMaximumLineLength() {
        return this.fMaxLineLength;
    }
}

