/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.j9.JavaMethod;
import com.ibm.dtfj.java.j9.JavaReference;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Iterator;
import java.util.Vector;

public class JavaStackFrame
implements com.ibm.dtfj.java.JavaStackFrame {
    private JavaRuntime _javaVM;
    private ImagePointer _basePointer;
    private JavaMethod _method;
    private ImagePointer _methodID;
    private ImagePointer _pc;
    private int _lineNumber;
    private Vector _stackRoots = new Vector();

    private JavaStackFrame(JavaRuntime javaRuntime, ImagePointer imagePointer, ImagePointer imagePointer2, int n) {
        if (null == imagePointer) {
            throw new IllegalArgumentException("A Java stack frame must have a non-null base pointer");
        }
        if (null == imagePointer2) {
            throw new IllegalArgumentException("A Java stack frame must have a non-null program counter");
        }
        this._javaVM = javaRuntime;
        this._basePointer = imagePointer;
        this._pc = imagePointer2;
        this._lineNumber = n;
    }

    public JavaStackFrame(JavaRuntime javaRuntime, ImagePointer imagePointer, JavaMethod javaMethod, ImagePointer imagePointer2, int n) {
        this(javaRuntime, imagePointer, imagePointer2, n);
        if (null == javaMethod) {
            throw new IllegalArgumentException("A Java stack frame must refer to a non-null method");
        }
        this._method = javaMethod;
    }

    public JavaStackFrame(JavaRuntime javaRuntime, ImagePointer imagePointer, ImagePointer imagePointer2, ImagePointer imagePointer3, int n) {
        this(javaRuntime, imagePointer, imagePointer3, n);
        this._methodID = imagePointer2;
    }

    @Override
    public ImagePointer getBasePointer() throws CorruptDataException {
        return this._basePointer;
    }

    @Override
    public JavaLocation getLocation() throws CorruptDataException {
        if (this._method != null) {
            return new com.ibm.dtfj.java.j9.JavaLocation(this._method, this._pc, this._lineNumber);
        }
        return new com.ibm.dtfj.java.j9.JavaLocation(this._methodID, this._pc, this._lineNumber);
    }

    public void createObjectRef(long l) {
        JavaReference javaReference = new JavaReference(this._javaVM, (Object)this, l, "StackFrame Root", 0, 4, 1);
        this._stackRoots.add(javaReference);
    }

    private static boolean equals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JavaStackFrame) {
            JavaStackFrame javaStackFrame = (JavaStackFrame)object;
            bl = JavaStackFrame.equals(this._method, javaStackFrame._method) && JavaStackFrame.equals(this._pc, javaStackFrame._pc);
        }
        return bl;
    }

    private static int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    @Override
    public int hashCode() {
        return JavaStackFrame.hashCode(this._method) ^ this._pc.hashCode() ^ JavaStackFrame.hashCode(this._methodID);
    }

    @Override
    public Iterator getHeapRoots() {
        return this._stackRoots.iterator();
    }
}

