/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CalendarNameProvider;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.TimeZoneNameProvider;
import sun.util.locale.provider.JRELocaleConstants;
import sun.util.spi.CalendarProvider;

public class HostLocaleProviderAdapterImpl {
    private static ConcurrentMap<Locale, SoftReference<AtomicReferenceArray<String>>> dateFormatPatternsMap = new ConcurrentHashMap<Locale, SoftReference<AtomicReferenceArray<String>>>(2);
    private static ConcurrentMap<Locale, SoftReference<AtomicReferenceArray<String>>> numberFormatPatternsMap = new ConcurrentHashMap<Locale, SoftReference<AtomicReferenceArray<String>>>(2);
    private static ConcurrentMap<Locale, SoftReference<DateFormatSymbols>> dateFormatSymbolsMap = new ConcurrentHashMap<Locale, SoftReference<DateFormatSymbols>>(2);
    private static ConcurrentMap<Locale, SoftReference<DecimalFormatSymbols>> decimalFormatSymbolsMap = new ConcurrentHashMap<Locale, SoftReference<DecimalFormatSymbols>>(2);
    private static final int CAT_DISPLAY = 0;
    private static final int CAT_FORMAT = 1;
    private static final int NF_NUMBER = 0;
    private static final int NF_CURRENCY = 1;
    private static final int NF_PERCENT = 2;
    private static final int NF_INTEGER = 3;
    private static final int NF_MAX = 3;
    private static final int CD_FIRSTDAYOFWEEK = 0;
    private static final int CD_MINIMALDAYSINFIRSTWEEK = 1;
    private static final int DN_LOCALE_LANGUAGE = 0;
    private static final int DN_LOCALE_SCRIPT = 1;
    private static final int DN_LOCALE_REGION = 2;
    private static final int DN_LOCALE_VARIANT = 3;
    private static final int DN_CURRENCY_CODE = 4;
    private static final int DN_CURRENCY_SYMBOL = 5;
    private static final int DN_TZ_SHORT_STANDARD = 0;
    private static final int DN_TZ_SHORT_DST = 1;
    private static final int DN_TZ_LONG_STANDARD = 2;
    private static final int DN_TZ_LONG_DST = 3;
    private static final Set<Locale> supportedLocaleSet;
    private static final Locale[] supportedLocale;

    private static Locale convertMacOSXLocaleToJavaLocale(String string) {
        String[] stringArray = string.split("@");
        String string2 = stringArray[0].replace('_', '-');
        if (stringArray.length > 1) {
            String[] stringArray2;
            block8: for (String string3 : stringArray2 = stringArray[1].split(";")) {
                String string4;
                if (!string3.startsWith("calendar=")) continue;
                switch (string4 = string3.substring(string3.indexOf(61) + 1)) {
                    case "gregorian": {
                        string2 = string2 + "-u-ca-gregory";
                        continue block8;
                    }
                    case "japanese": {
                        if (stringArray[0].equals("ja_JP")) {
                            return JRELocaleConstants.JA_JP_JP;
                        }
                    }
                    default: {
                        string2 = string2 + "-u-ca-" + string4;
                    }
                }
            }
        }
        return Locale.forLanguageTag(string2);
    }

    public static DateFormatProvider getDateFormatProvider() {
        return new DateFormatProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedCalendarLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedCalendarLocale(locale);
            }

            @Override
            public DateFormat getDateInstance(int n, Locale locale) {
                return new SimpleDateFormat(this.getDateTimePattern(n, -1, locale), HostLocaleProviderAdapterImpl.getCalendarLocale(locale));
            }

            @Override
            public DateFormat getTimeInstance(int n, Locale locale) {
                return new SimpleDateFormat(this.getDateTimePattern(-1, n, locale), HostLocaleProviderAdapterImpl.getCalendarLocale(locale));
            }

            @Override
            public DateFormat getDateTimeInstance(int n, int n2, Locale locale) {
                return new SimpleDateFormat(this.getDateTimePattern(n, n2, locale), HostLocaleProviderAdapterImpl.getCalendarLocale(locale));
            }

            private String getDateTimePattern(int n, int n2, Locale locale) {
                String string;
                int n3;
                String string2;
                AtomicReferenceArray<String> atomicReferenceArray;
                SoftReference softReference = (SoftReference)dateFormatPatternsMap.get(locale);
                if (softReference == null || (atomicReferenceArray = (AtomicReferenceArray<String>)softReference.get()) == null) {
                    atomicReferenceArray = new AtomicReferenceArray<String>(25);
                    softReference = new SoftReference(atomicReferenceArray);
                    dateFormatPatternsMap.put(locale, softReference);
                }
                if ((string2 = (String)atomicReferenceArray.get(n3 = (n + 1) * 5 + n2 + 1)) == null && !atomicReferenceArray.compareAndSet(n3, null, string2 = HostLocaleProviderAdapterImpl.translateDateFormatLetters(HostLocaleProviderAdapterImpl.getCalendarID(string = locale.toLanguageTag()), HostLocaleProviderAdapterImpl.getDateTimePatternNative(n, n2, string)))) {
                    string2 = (String)atomicReferenceArray.get(n3);
                }
                return string2;
            }
        };
    }

    public static DateFormatSymbolsProvider getDateFormatSymbolsProvider() {
        return new DateFormatSymbolsProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                if (this.isSupportedLocale(Locale.getDefault(Locale.Category.FORMAT))) {
                    return supportedLocale;
                }
                return new Locale[0];
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                Locale locale2 = locale.stripExtensions();
                if (supportedLocaleSet.contains(locale2)) {
                    return HostLocaleProviderAdapterImpl.getCalendarID(locale.toLanguageTag()).equals("gregorian");
                }
                return false;
            }

            @Override
            public DateFormatSymbols getInstance(Locale locale) {
                DateFormatSymbols dateFormatSymbols;
                SoftReference<DateFormatSymbols> softReference = (SoftReference<DateFormatSymbols>)dateFormatSymbolsMap.get(locale);
                if (softReference == null || (dateFormatSymbols = (DateFormatSymbols)softReference.get()) == null) {
                    dateFormatSymbols = new DateFormatSymbols(locale);
                    String string = locale.toLanguageTag();
                    dateFormatSymbols.setAmPmStrings(HostLocaleProviderAdapterImpl.getAmPmStrings(string, dateFormatSymbols.getAmPmStrings()));
                    dateFormatSymbols.setEras(HostLocaleProviderAdapterImpl.getEras(string, dateFormatSymbols.getEras()));
                    dateFormatSymbols.setMonths(HostLocaleProviderAdapterImpl.getMonths(string, dateFormatSymbols.getMonths()));
                    dateFormatSymbols.setShortMonths(HostLocaleProviderAdapterImpl.getShortMonths(string, dateFormatSymbols.getShortMonths()));
                    dateFormatSymbols.setWeekdays(HostLocaleProviderAdapterImpl.getWeekdays(string, dateFormatSymbols.getWeekdays()));
                    dateFormatSymbols.setShortWeekdays(HostLocaleProviderAdapterImpl.getShortWeekdays(string, dateFormatSymbols.getShortWeekdays()));
                    softReference = new SoftReference<DateFormatSymbols>(dateFormatSymbols);
                    dateFormatSymbolsMap.put(locale, softReference);
                }
                return (DateFormatSymbols)dateFormatSymbols.clone();
            }
        };
    }

    public static NumberFormatProvider getNumberFormatProvider() {
        return new NumberFormatProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return supportedLocale;
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return supportedLocaleSet.contains(locale.stripExtensions());
            }

            @Override
            public NumberFormat getCurrencyInstance(Locale locale) {
                return new DecimalFormat(this.getNumberPattern(1, locale), DecimalFormatSymbols.getInstance(locale));
            }

            @Override
            public NumberFormat getIntegerInstance(Locale locale) {
                return new DecimalFormat(this.getNumberPattern(3, locale), DecimalFormatSymbols.getInstance(locale));
            }

            @Override
            public NumberFormat getNumberInstance(Locale locale) {
                return new DecimalFormat(this.getNumberPattern(0, locale), DecimalFormatSymbols.getInstance(locale));
            }

            @Override
            public NumberFormat getPercentInstance(Locale locale) {
                return new DecimalFormat(this.getNumberPattern(2, locale), DecimalFormatSymbols.getInstance(locale));
            }

            private String getNumberPattern(int n, Locale locale) {
                String string;
                AtomicReferenceArray<String> atomicReferenceArray;
                SoftReference softReference = (SoftReference)numberFormatPatternsMap.get(locale);
                if (softReference == null || (atomicReferenceArray = (AtomicReferenceArray<String>)softReference.get()) == null) {
                    atomicReferenceArray = new AtomicReferenceArray<String>(4);
                    softReference = new SoftReference(atomicReferenceArray);
                    numberFormatPatternsMap.put(locale, softReference);
                }
                if ((string = (String)atomicReferenceArray.get(n)) == null && !atomicReferenceArray.compareAndSet(n, null, string = HostLocaleProviderAdapterImpl.getNumberPatternNative(n, locale.toLanguageTag()))) {
                    string = (String)atomicReferenceArray.get(n);
                }
                return string;
            }
        };
    }

    public static DecimalFormatSymbolsProvider getDecimalFormatSymbolsProvider() {
        return new DecimalFormatSymbolsProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return supportedLocale;
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return supportedLocaleSet.contains(locale.stripExtensions());
            }

            @Override
            public DecimalFormatSymbols getInstance(Locale locale) {
                DecimalFormatSymbols decimalFormatSymbols;
                SoftReference<DecimalFormatSymbols> softReference = (SoftReference<DecimalFormatSymbols>)decimalFormatSymbolsMap.get(locale);
                if (softReference == null || (decimalFormatSymbols = (DecimalFormatSymbols)softReference.get()) == null) {
                    decimalFormatSymbols = new DecimalFormatSymbols(locale);
                    String string = locale.toLanguageTag();
                    decimalFormatSymbols.setInternationalCurrencySymbol(HostLocaleProviderAdapterImpl.getInternationalCurrencySymbol(string, decimalFormatSymbols.getInternationalCurrencySymbol()));
                    decimalFormatSymbols.setCurrencySymbol(HostLocaleProviderAdapterImpl.getCurrencySymbol(string, decimalFormatSymbols.getCurrencySymbol()));
                    decimalFormatSymbols.setDecimalSeparator(HostLocaleProviderAdapterImpl.getDecimalSeparator(string, decimalFormatSymbols.getDecimalSeparator()));
                    decimalFormatSymbols.setGroupingSeparator(HostLocaleProviderAdapterImpl.getGroupingSeparator(string, decimalFormatSymbols.getGroupingSeparator()));
                    decimalFormatSymbols.setInfinity(HostLocaleProviderAdapterImpl.getInfinity(string, decimalFormatSymbols.getInfinity()));
                    decimalFormatSymbols.setMinusSign(HostLocaleProviderAdapterImpl.getMinusSign(string, decimalFormatSymbols.getMinusSign()));
                    decimalFormatSymbols.setMonetaryDecimalSeparator(HostLocaleProviderAdapterImpl.getMonetaryDecimalSeparator(string, decimalFormatSymbols.getMonetaryDecimalSeparator()));
                    decimalFormatSymbols.setNaN(HostLocaleProviderAdapterImpl.getNaN(string, decimalFormatSymbols.getNaN()));
                    decimalFormatSymbols.setPercent(HostLocaleProviderAdapterImpl.getPercent(string, decimalFormatSymbols.getPercent()));
                    decimalFormatSymbols.setPerMill(HostLocaleProviderAdapterImpl.getPerMill(string, decimalFormatSymbols.getPerMill()));
                    decimalFormatSymbols.setZeroDigit(HostLocaleProviderAdapterImpl.getZeroDigit(string, decimalFormatSymbols.getZeroDigit()));
                    decimalFormatSymbols.setExponentSeparator(HostLocaleProviderAdapterImpl.getExponentSeparator(string, decimalFormatSymbols.getExponentSeparator()));
                    softReference = new SoftReference<DecimalFormatSymbols>(decimalFormatSymbols);
                    decimalFormatSymbolsMap.put(locale, softReference);
                }
                return (DecimalFormatSymbols)decimalFormatSymbols.clone();
            }
        };
    }

    public static CalendarDataProvider getCalendarDataProvider() {
        return new CalendarDataProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedCalendarLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedCalendarLocale(locale);
            }

            @Override
            public int getFirstDayOfWeek(Locale locale) {
                return HostLocaleProviderAdapterImpl.getCalendarInt(locale.toLanguageTag(), 0);
            }

            @Override
            public int getMinimalDaysInFirstWeek(Locale locale) {
                return HostLocaleProviderAdapterImpl.getCalendarInt(locale.toLanguageTag(), 1);
            }
        };
    }

    public static CalendarNameProvider getCalendarNameProvider() {
        return new CalendarNameProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedCalendarLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedCalendarLocale(locale);
            }

            @Override
            public String getDisplayName(String string, int n, int n2, int n3, Locale locale) {
                return null;
            }

            @Override
            public Map<String, Integer> getDisplayNames(String string, int n, int n2, Locale locale) {
                return null;
            }
        };
    }

    public static CalendarProvider getCalendarProvider() {
        return new CalendarProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedCalendarLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedCalendarLocale(locale);
            }

            @Override
            public Calendar getInstance(TimeZone timeZone, Locale locale) {
                return new Calendar.Builder().setLocale(locale).setCalendarType(HostLocaleProviderAdapterImpl.getCalendarID(locale.toLanguageTag())).setTimeZone(timeZone).setInstant(System.currentTimeMillis()).build();
            }
        };
    }

    public static CurrencyNameProvider getCurrencyNameProvider() {
        return new CurrencyNameProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return supportedLocale;
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return supportedLocaleSet.contains(locale.stripExtensions());
            }

            @Override
            public String getDisplayName(String string, Locale locale) {
                return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 4, string);
            }

            @Override
            public String getSymbol(String string, Locale locale) {
                return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 5, string);
            }
        };
    }

    public static LocaleNameProvider getLocaleNameProvider() {
        return new LocaleNameProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return supportedLocale;
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return supportedLocaleSet.contains(locale.stripExtensions());
            }

            @Override
            public String getDisplayLanguage(String string, Locale locale) {
                return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 0, string);
            }

            @Override
            public String getDisplayCountry(String string, Locale locale) {
                return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 2, string);
            }

            @Override
            public String getDisplayScript(String string, Locale locale) {
                return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 1, string);
            }

            @Override
            public String getDisplayVariant(String string, Locale locale) {
                return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 3, string);
            }
        };
    }

    public static TimeZoneNameProvider getTimeZoneNameProvider() {
        return new TimeZoneNameProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return supportedLocale;
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return supportedLocaleSet.contains(locale.stripExtensions());
            }

            @Override
            public String getDisplayName(String string, boolean bl, int n, Locale locale) {
                return HostLocaleProviderAdapterImpl.getTimeZoneDisplayString(locale.toLanguageTag(), n * 2 + (bl ? 1 : 0), string);
            }
        };
    }

    private static Locale[] getSupportedCalendarLocales() {
        if (supportedLocale.length != 0 && supportedLocaleSet.contains(Locale.JAPAN) && HostLocaleProviderAdapterImpl.isJapaneseCalendar()) {
            Locale[] localeArray = new Locale[supportedLocale.length + 1];
            localeArray[0] = JRELocaleConstants.JA_JP_JP;
            System.arraycopy((Object)supportedLocale, 0, (Object)localeArray, 1, supportedLocale.length);
            return localeArray;
        }
        return supportedLocale;
    }

    private static boolean isSupportedCalendarLocale(Locale locale) {
        Locale locale2 = locale;
        if (locale2.hasExtensions() || locale2.getVariant() != "") {
            locale2 = new Locale.Builder().setLocale(locale).clearExtensions().build();
        }
        if (!supportedLocaleSet.contains(locale2)) {
            return false;
        }
        String string = locale.getUnicodeLocaleType("ca");
        String string2 = HostLocaleProviderAdapterImpl.getCalendarID(locale2.toLanguageTag()).replaceFirst("gregorian", "gregory");
        if (string == null) {
            return Calendar.getAvailableCalendarTypes().contains(string2);
        }
        return string.equals(string2);
    }

    private static boolean isJapaneseCalendar() {
        return HostLocaleProviderAdapterImpl.getCalendarID("ja-JP").equals("japanese");
    }

    private static Locale getCalendarLocale(Locale locale) {
        String string = HostLocaleProviderAdapterImpl.getCalendarID(locale.toLanguageTag()).replaceFirst("gregorian", "gregory");
        if (Calendar.getAvailableCalendarTypes().contains(string)) {
            return new Locale.Builder().setLocale(locale).setUnicodeLocaleKeyword("ca", string).build();
        }
        return locale;
    }

    private static String translateDateFormatLetters(String string, String string2) {
        String string3 = string2;
        int n = string3.length();
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            char c2 = string3.charAt(i);
            if (c2 == '\'') {
                char c3;
                if (i + 1 < n && (c3 = string3.charAt(i + 1)) == '\'') {
                    ++i;
                    if (n2 != 0) {
                        HostLocaleProviderAdapterImpl.convert(string, c, n2, stringBuilder);
                        c = '\u0000';
                        n2 = 0;
                    }
                    stringBuilder.append("''");
                    continue;
                }
                if (!bl) {
                    if (n2 != 0) {
                        HostLocaleProviderAdapterImpl.convert(string, c, n2, stringBuilder);
                        c = '\u0000';
                        n2 = 0;
                    }
                    bl = true;
                } else {
                    bl = false;
                }
                stringBuilder.append(c2);
                continue;
            }
            if (bl) {
                stringBuilder.append(c2);
                continue;
            }
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                if (n2 != 0) {
                    HostLocaleProviderAdapterImpl.convert(string, c, n2, stringBuilder);
                    c = '\u0000';
                    n2 = 0;
                }
                stringBuilder.append(c2);
                continue;
            }
            if (c == '\u0000' || c == c2) {
                c = c2;
                ++n2;
                continue;
            }
            HostLocaleProviderAdapterImpl.convert(string, c, n2, stringBuilder);
            c = c2;
            n2 = 1;
        }
        if (n2 != 0) {
            HostLocaleProviderAdapterImpl.convert(string, c, n2, stringBuilder);
        }
        if (string2.contentEquals(stringBuilder)) {
            return string2;
        }
        return stringBuilder.toString();
    }

    private static void convert(String string, char c, int n, StringBuilder stringBuilder) {
        switch (c) {
            case 'G': {
                if (!string.equals("gregorian")) {
                    if (n == 5) {
                        n = 1;
                    } else if (n == 1) {
                        n = 4;
                    }
                }
                HostLocaleProviderAdapterImpl.appendN(c, n, stringBuilder);
                break;
            }
            case 'c': 
            case 'e': {
                switch (n) {
                    case 1: {
                        stringBuilder.append('u');
                        break;
                    }
                    case 3: 
                    case 4: {
                        HostLocaleProviderAdapterImpl.appendN('E', n, stringBuilder);
                        break;
                    }
                    case 5: {
                        HostLocaleProviderAdapterImpl.appendN('E', 3, stringBuilder);
                    }
                }
                break;
            }
            case 'V': 
            case 'v': {
                HostLocaleProviderAdapterImpl.appendN('z', n, stringBuilder);
                break;
            }
            case 'Z': {
                if (n != 4 && n != 5) break;
                stringBuilder.append("XXX");
                break;
            }
            case 'A': 
            case 'Q': 
            case 'U': 
            case 'g': 
            case 'j': 
            case 'l': 
            case 'q': 
            case 'u': {
                stringBuilder.append('\'');
                stringBuilder.append(c);
                stringBuilder.append('\'');
                break;
            }
            default: {
                HostLocaleProviderAdapterImpl.appendN(c, n, stringBuilder);
            }
        }
    }

    private static void appendN(char c, int n, StringBuilder stringBuilder) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(c);
        }
    }

    private static native String getDefaultLocale(int var0);

    private static native String getDateTimePatternNative(int var0, int var1, String var2);

    private static native String getCalendarID(String var0);

    private static native String getNumberPatternNative(int var0, String var1);

    private static native String[] getAmPmStrings(String var0, String[] var1);

    private static native String[] getEras(String var0, String[] var1);

    private static native String[] getMonths(String var0, String[] var1);

    private static native String[] getShortMonths(String var0, String[] var1);

    private static native String[] getWeekdays(String var0, String[] var1);

    private static native String[] getShortWeekdays(String var0, String[] var1);

    private static native String getCurrencySymbol(String var0, String var1);

    private static native char getDecimalSeparator(String var0, char var1);

    private static native char getGroupingSeparator(String var0, char var1);

    private static native String getInfinity(String var0, String var1);

    private static native String getInternationalCurrencySymbol(String var0, String var1);

    private static native char getMinusSign(String var0, char var1);

    private static native char getMonetaryDecimalSeparator(String var0, char var1);

    private static native String getNaN(String var0, String var1);

    private static native char getPercent(String var0, char var1);

    private static native char getPerMill(String var0, char var1);

    private static native char getZeroDigit(String var0, char var1);

    private static native String getExponentSeparator(String var0, String var1);

    private static native int getCalendarInt(String var0, int var1);

    private static native String getDisplayString(String var0, int var1, String var2);

    private static native String getTimeZoneDisplayString(String var0, int var1, String var2);

    static {
        HashSet<Locale> hashSet = new HashSet<Locale>();
        Locale locale = HostLocaleProviderAdapterImpl.convertMacOSXLocaleToJavaLocale(HostLocaleProviderAdapterImpl.getDefaultLocale(1));
        hashSet.addAll(ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT).getCandidateLocales("", locale));
        locale = HostLocaleProviderAdapterImpl.convertMacOSXLocaleToJavaLocale(HostLocaleProviderAdapterImpl.getDefaultLocale(0));
        hashSet.addAll(ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT).getCandidateLocales("", locale));
        supportedLocaleSet = Collections.unmodifiableSet(hashSet);
        supportedLocale = supportedLocaleSet.toArray(new Locale[0]);
    }
}

