/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.util;

import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import sun.invoke.util.Wrapper;

public class BytecodeDescriptor {
    private BytecodeDescriptor() {
    }

    public static List<Class<?>> parseMethod(String string, ClassLoader classLoader) {
        return BytecodeDescriptor.parseMethod(string, 0, string.length(), classLoader);
    }

    static List<Class<?>> parseMethod(String string, int n, int n2, ClassLoader classLoader) {
        Class<?> clazz;
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        String string2 = string;
        int[] nArray = new int[]{n};
        ArrayList arrayList = new ArrayList();
        if (nArray[0] < n2 && string2.charAt(nArray[0]) == '(') {
            nArray[0] = nArray[0] + 1;
            while (nArray[0] < n2 && string2.charAt(nArray[0]) != ')') {
                clazz = BytecodeDescriptor.parseSig(string2, nArray, n2, classLoader);
                if (clazz == null || clazz == Void.TYPE) {
                    BytecodeDescriptor.parseError(string2, "bad argument type");
                }
                arrayList.add(clazz);
            }
            nArray[0] = nArray[0] + 1;
        } else {
            BytecodeDescriptor.parseError(string2, "not a method type");
        }
        clazz = BytecodeDescriptor.parseSig(string2, nArray, n2, classLoader);
        if (clazz == null || nArray[0] != n2) {
            BytecodeDescriptor.parseError(string2, "bad return type");
        }
        arrayList.add(clazz);
        return arrayList;
    }

    private static void parseError(String string, String string2) {
        throw new IllegalArgumentException("bad signature: " + string + ": " + string2);
    }

    private static Class<?> parseSig(String string, int[] nArray, int n, ClassLoader classLoader) {
        if (nArray[0] == n) {
            return null;
        }
        int n2 = nArray[0];
        nArray[0] = n2 + 1;
        char c = string.charAt(n2);
        if (c == 'L') {
            int n3 = nArray[0];
            int n4 = string.indexOf(59, n3);
            if (n4 < 0) {
                return null;
            }
            nArray[0] = n4 + 1;
            String string2 = string.substring(n3, n4).replace('/', '.');
            try {
                return classLoader.loadClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new TypeNotPresentException(string2, classNotFoundException);
            }
        }
        if (c == '[') {
            Class<Object> clazz = BytecodeDescriptor.parseSig(string, nArray, n, classLoader);
            if (clazz != null) {
                clazz = Array.newInstance(clazz, 0).getClass();
            }
            return clazz;
        }
        return Wrapper.forBasicType(c).primitiveType();
    }

    public static String unparse(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        BytecodeDescriptor.unparseSig(clazz, stringBuilder);
        return stringBuilder.toString();
    }

    public static String unparse(MethodType methodType) {
        return BytecodeDescriptor.unparseMethod(methodType.returnType(), methodType.parameterList());
    }

    public static String unparse(Object object) {
        if (object instanceof Class) {
            return BytecodeDescriptor.unparse((Class)object);
        }
        if (object instanceof MethodType) {
            return BytecodeDescriptor.unparse((MethodType)object);
        }
        return (String)object;
    }

    public static String unparseMethod(Class<?> clazz, List<Class<?>> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (Class<?> clazz2 : list) {
            BytecodeDescriptor.unparseSig(clazz2, stringBuilder);
        }
        stringBuilder.append(')');
        BytecodeDescriptor.unparseSig(clazz, stringBuilder);
        return stringBuilder.toString();
    }

    private static void unparseSig(Class<?> clazz, StringBuilder stringBuilder) {
        char c = Wrapper.forBasicType(clazz).basicTypeChar();
        if (c != 'L') {
            stringBuilder.append(c);
        } else {
            boolean bl;
            boolean bl2 = bl = !clazz.isArray();
            if (bl) {
                stringBuilder.append('L');
            }
            stringBuilder.append(clazz.getName().replace('.', '/'));
            if (bl) {
                stringBuilder.append(';');
            }
        }
    }
}

