/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.java.lang.management.internal.LockInfoUtil;
import com.ibm.java.lang.management.internal.ManagementAccessControl;
import com.ibm.java.lang.management.internal.MonitorInfoUtil;
import com.ibm.java.lang.management.internal.StackTraceElementUtil;
import com.ibm.java.lang.management.internal.ThreadInfoUtil;
import com.ibm.oti.util.Msg;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfoAccessImpl;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import openj9.management.internal.LockInfoBase;
import openj9.management.internal.MonitorInfoBase;
import openj9.management.internal.ThreadInfoBase;

public class ThreadInfo {
    private static final MonitorInfo[] EMPTY_MONITORINFO_ARRAY = new MonitorInfo[0];
    private final ThreadInfoBase baseInfo;
    private static final LockInfo[] EMPTY_LOCKINFO_ARRAY;

    private ThreadInfo(long l, String string, Thread.State state, boolean bl, boolean bl2, long l2, long l3, long l4, long l5, String string2, long l6, String string3, StackTraceElement[] stackTraceElementArray, LockInfo lockInfo, MonitorInfo[] monitorInfoArray, LockInfo[] lockInfoArray) {
        MonitorInfoBase[] monitorInfoBaseArray = null;
        if (null != monitorInfoArray) {
            monitorInfoBaseArray = (MonitorInfoBase[])Arrays.stream(monitorInfoArray).map(MonitorInfo::getBaseInfo).toArray(MonitorInfoBase[]::new);
        }
        LockInfoBase[] lockInfoBaseArray = null;
        if (null != lockInfoArray) {
            lockInfoBaseArray = (LockInfoBase[])Arrays.stream(lockInfoArray).map(LockInfo::getBaseInfo).toArray(LockInfoBase[]::new);
        }
        LockInfoBase lockInfoBase = null;
        if (null != lockInfo) {
            lockInfoBase = lockInfo.getBaseInfo();
        }
        this.baseInfo = new ThreadInfoBase(l, string, state, bl, bl2, l2, l3, l4, l5, string2, l6, string3, stackTraceElementArray, lockInfoBase, monitorInfoBaseArray, lockInfoBaseArray);
    }

    private ThreadInfo(ThreadInfoBase threadInfoBase) {
        this.baseInfo = threadInfoBase;
    }

    public long getBlockedCount() {
        return this.baseInfo.getBlockedCount();
    }

    public long getBlockedTime() {
        return this.baseInfo.getBlockedTime();
    }

    public String getLockName() {
        return this.baseInfo.getLockName();
    }

    public long getLockOwnerId() {
        return this.baseInfo.getLockOwnerId();
    }

    public String getLockOwnerName() {
        return this.baseInfo.getLockOwnerName();
    }

    public LockInfo getLockInfo() {
        LockInfoBase lockInfoBase = this.baseInfo.getBlockingLockInfo();
        return null == lockInfoBase ? null : new LockInfo(lockInfoBase);
    }

    long getNativeThreadId() {
        return this.baseInfo.getNativeTId();
    }

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.baseInfo.getStackTrace().clone();
    }

    public long getThreadId() {
        return this.baseInfo.getThreadId();
    }

    public String getThreadName() {
        return this.baseInfo.getThreadName();
    }

    public Thread.State getThreadState() {
        return this.baseInfo.getThreadState();
    }

    public long getWaitedCount() {
        return this.baseInfo.getWaitedCount();
    }

    public long getWaitedTime() {
        return this.baseInfo.getWaitedTime();
    }

    public boolean isInNative() {
        return this.baseInfo.isInNative();
    }

    public boolean isSuspended() {
        return this.baseInfo.isSuspended();
    }

    public MonitorInfo[] getLockedMonitors() {
        MonitorInfo[] monitorInfoArray = null;
        MonitorInfoBase[] monitorInfoBaseArray = this.baseInfo.getLockedMonitors();
        if (null != monitorInfoBaseArray) {
            monitorInfoArray = (MonitorInfo[])Arrays.stream(monitorInfoBaseArray).map(MonitorInfo::new).toArray(MonitorInfo[]::new);
        }
        return monitorInfoArray;
    }

    public LockInfo[] getLockedSynchronizers() {
        LockInfo[] lockInfoArray = null;
        LockInfoBase[] lockInfoBaseArray = this.baseInfo.getLockedSynchronizers();
        lockInfoArray = (LockInfo[])Arrays.stream(lockInfoBaseArray).map(LockInfo::new).toArray(LockInfo[]::new);
        return lockInfoArray;
    }

    public static ThreadInfo from(CompositeData compositeData) {
        ThreadInfo threadInfo = null;
        if (compositeData != null) {
            StackTraceElement[] stackTraceElementArray;
            String string;
            long l;
            String string2;
            long l2;
            long l3;
            long l4;
            long l5;
            boolean bl;
            boolean bl2;
            Thread.State state;
            String string3;
            long l6;
            if (!ThreadInfoUtil.getCompositeType().isValue(compositeData)) {
                throw new IllegalArgumentException(Msg.getString("K05E5"));
            }
            try {
                l6 = (Long)compositeData.get("threadId");
                string3 = (String)compositeData.get("threadName");
                String string4 = (String)compositeData.get("threadState");
                try {
                    state = Thread.State.valueOf(string4);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException(Msg.getString("K0612", illegalArgumentException));
                }
                bl2 = (Boolean)compositeData.get("suspended");
                bl = (Boolean)compositeData.get("inNative");
                l5 = (Long)compositeData.get("blockedCount");
                l4 = (Long)compositeData.get("blockedTime");
                l3 = (Long)compositeData.get("waitedCount");
                l2 = (Long)compositeData.get("waitedTime");
                string2 = (String)compositeData.get("lockName");
                l = (Long)compositeData.get("lockOwnerId");
                string = (String)compositeData.get("lockOwnerName");
                CompositeData[] compositeDataArray = (CompositeData[])compositeData.get("stackTrace");
                stackTraceElementArray = StackTraceElementUtil.fromArray(compositeDataArray);
            }
            catch (NullPointerException | InvalidKeyException runtimeException) {
                throw new IllegalArgumentException(Msg.getString("K05E6"));
            }
            LockInfo lockInfo = ThreadInfo.recoverLockInfoAttribute(compositeData, string2);
            MonitorInfo[] monitorInfoArray = ThreadInfo.recoverLockedMonitors(compositeData);
            LockInfo[] lockInfoArray = ThreadInfo.recoverLockedSynchronizers(compositeData);
            threadInfo = new ThreadInfo(l6, string3, state, bl2, bl, l5, l4, l3, l2, string2, l, string, stackTraceElementArray, lockInfo, monitorInfoArray, lockInfoArray);
        }
        return threadInfo;
    }

    private static LockInfo[] recoverLockedSynchronizers(CompositeData compositeData) {
        LockInfo[] lockInfoArray;
        try {
            CompositeData[] compositeDataArray = (CompositeData[])compositeData.get("lockedSynchronizers");
            lockInfoArray = LockInfoUtil.fromArray(compositeDataArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            lockInfoArray = EMPTY_LOCKINFO_ARRAY;
        }
        return lockInfoArray;
    }

    private static MonitorInfo[] recoverLockedMonitors(CompositeData compositeData) {
        MonitorInfo[] monitorInfoArray;
        try {
            CompositeData[] compositeDataArray = (CompositeData[])compositeData.get("lockedMonitors");
            monitorInfoArray = MonitorInfoUtil.fromArray(compositeDataArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            monitorInfoArray = EMPTY_MONITORINFO_ARRAY;
        }
        return monitorInfoArray;
    }

    private static LockInfo recoverLockInfoAttribute(CompositeData compositeData, String string) {
        LockInfo lockInfo = null;
        try {
            CompositeData compositeData2;
            CompositeData compositeData3 = compositeData2 = compositeData.get("lockInfo") != null ? (CompositeData)compositeData.get("lockInfo") : null;
            if (compositeData2 != null) {
                if (!LockInfoUtil.getCompositeType().isValue(compositeData2)) {
                    throw new IllegalArgumentException(Msg.getString("K05E5"));
                }
                lockInfo = new LockInfo((String)compositeData2.get("className"), (Integer)compositeData2.get("identityHashCode"));
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            lockInfo = ThreadInfo.createLockInfoFromLockName(string);
        }
        return lockInfo;
    }

    public String toString() {
        return this.baseInfo.toString();
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && null != object && object instanceof ThreadInfo) {
            bl = this.baseInfo.equals(((ThreadInfo)object).baseInfo);
        }
        return bl;
    }

    public int hashCode() {
        return this.baseInfo.hashCode();
    }

    private static LockInfo createLockInfoFromLockName(String string) {
        StringTokenizer stringTokenizer;
        LockInfo lockInfo = null;
        if (string != null && string.length() > 0 && (stringTokenizer = new StringTokenizer(string, "@")).countTokens() == 2) {
            try {
                lockInfo = new LockInfo(stringTokenizer.nextToken(), Integer.parseInt(stringTokenizer.nextToken(), 16));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return lockInfo;
    }

    static {
        ManagementAccessControl.setThreadInfoAccess(new ThreadInfoAccessImpl());
        EMPTY_LOCKINFO_ARRAY = new LockInfo[0];
    }
}

