/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.invoke.InvokeExactHandle;
import java.lang.invoke.MethodTypeForm;
import java.lang.invoke.MethodTypeHelper;
import java.lang.invoke.OpenJDKCompileStub;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public final class MethodType
implements Serializable {
    static final Class<?>[] EMTPY_PARAMS = new Class[0];
    private static Map<MethodType, WeakReference<MethodType>> internTable = Collections.synchronizedMap(new WeakHashMap());
    private static InternTableAddLock internTableAddLock = new InternTableAddLock();
    final Class<?> rtype;
    final Class<?>[] ptypes;
    int argSlots;
    int[] stackDescriptionBits;
    private String methodDescriptor;
    private int hashcode = 0;
    private InvokeExactHandle invoker;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    private static final long serialVersionUID = 292L;
    private DeserializedFieldsHolder deserializedFields;

    private MethodType(Class<?> clazz, Class<?>[] classArray, boolean bl) {
        this.rtype = clazz;
        if (bl) {
            this.ptypes = new Class[classArray.length];
            System.arraycopy(classArray, 0, this.ptypes, 0, classArray.length);
        } else {
            this.ptypes = classArray;
        }
    }

    private final int[] stackDescriptionBits(Class<?>[] classArray, int n) {
        int n2 = (n + 1 + 31) / 32;
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        n5 |= n4;
        n4 <<= 1;
        for (Class<?> clazz : classArray) {
            if (clazz.isPrimitive()) {
                if ((clazz.equals(Double.TYPE) || clazz.equals(Long.TYPE)) && (n4 <<= 1) == 0) {
                    n4 = 1;
                    nArray[n3] = n5;
                    ++n3;
                    n5 = 0;
                }
            } else {
                n5 |= n4;
            }
            if ((n4 <<= 1) != 0) continue;
            n4 = 1;
            nArray[n3] = n5;
            ++n3;
            n5 = 0;
        }
        if (n3 < nArray.length) {
            nArray[n3] = n5;
        }
        return nArray;
    }

    public MethodType changeParameterType(int n, Class<?> clazz) {
        Class[] classArray = (Class[])this.ptypes.clone();
        classArray[n] = clazz;
        return MethodType.methodType(this.rtype, classArray, false);
    }

    public MethodType changeReturnType(Class<?> clazz) {
        return MethodType.methodType(clazz, this.ptypes, false);
    }

    public MethodType dropParameterTypes(int n, int n2) throws IndexOutOfBoundsException {
        if (n >= 0 && n2 >= 0 && n <= n2 && n2 <= this.ptypes.length) {
            int n3 = n2 - n;
            Class[] classArray = new Class[this.ptypes.length - n3];
            System.arraycopy(this.ptypes, 0, (Object)classArray, 0, n);
            System.arraycopy(this.ptypes, n2, (Object)classArray, n, this.ptypes.length - n2);
            return MethodType.methodType(this.rtype, classArray, false);
        }
        throw new IndexOutOfBoundsException("'" + this + "' startPosition=" + n + " endPosition=" + n2);
    }

    MethodType dropFirstParameterType() throws IndexOutOfBoundsException {
        if (this.ptypes.length == 0) {
            throw new IndexOutOfBoundsException();
        }
        return MethodType.methodType(this.rtype, Arrays.copyOfRange(this.ptypes, 1, this.ptypes.length), false);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MethodType)) {
            return false;
        }
        MethodType methodType = (MethodType)object;
        if (this.ptypes.length != methodType.ptypes.length || this.rtype != methodType.rtype) {
            return false;
        }
        return Arrays.equals(this.ptypes, methodType.ptypes);
    }

    public MethodType erase() {
        Class[] classArray = (Class[])this.ptypes.clone();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i].isPrimitive()) continue;
            classArray[i] = Object.class;
        }
        return MethodType.methodType(this.rtype.isPrimitive() ? this.rtype : Object.class, classArray, false);
    }

    public static MethodType fromMethodDescriptorString(String string, ClassLoader classLoader) {
        Map<String, MethodType> map;
        MethodType methodType;
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = ClassLoader.getSystemClassLoader();
        }
        MethodType methodType2 = methodType = (map = VM.getVMLangAccess().getMethodTypeCache(classLoader2)) != null ? map.get(string) : null;
        if (null == methodType) {
            if (string.indexOf(46) != -1) {
                throw new IllegalArgumentException(string);
            }
            ArrayList<Class<?>> arrayList = MethodType.parseIntoClasses(string, classLoader2);
            if (arrayList.size() == 0) {
                throw new IllegalArgumentException(string);
            }
            Class<?> clazz = arrayList.remove(arrayList.size() - 1);
            methodType = MethodType.methodType(clazz, arrayList);
            if (map != null) {
                map.put(methodType.methodDescriptor, methodType);
            }
        }
        return methodType;
    }

    private static final MethodType fromMethodDescriptorStringAppendArg(String string, ClassLoader classLoader, Class<?> clazz) {
        ArrayList<Class<?>> arrayList = MethodType.parseIntoClasses(string, classLoader);
        Class clazz2 = (Class)arrayList.remove(arrayList.size() - 1);
        arrayList.add(clazz);
        return MethodType.methodType(clazz2, arrayList);
    }

    private static final Throwable throwNoClassDefFoundError(TypeNotPresentException typeNotPresentException) {
        Throwable throwable = typeNotPresentException.getCause();
        if (throwable instanceof ClassNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(throwable.getMessage());
            noClassDefFoundError.initCause(throwable);
            throw noClassDefFoundError;
        }
        throw typeNotPresentException;
    }

    private static final ArrayList<Class<?>> parseIntoClasses(String string, ClassLoader classLoader) {
        int n = string.length();
        if (n == 0) {
            throw new IllegalArgumentException(Msg.getString("K05d3", string));
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        boolean bl = false;
        if (cArray[n2] != '(') {
            throw new IllegalArgumentException(Msg.getString("K05d4", string));
        }
        ++n2;
        ArrayList arrayList = new ArrayList();
        while (n2 < n) {
            if (cArray[n2] == ')') {
                if (bl) {
                    throw new IllegalArgumentException(Msg.getString("K05d5", string));
                }
                bl = true;
                ++n2;
                continue;
            }
            n2 = MethodTypeHelper.parseIntoClass(cArray, n2, arrayList, classLoader, string);
            ++n2;
        }
        return arrayList;
    }

    public MethodType generic() {
        return MethodType.genericMethodType(this.ptypes.length);
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            int n = 31 + this.rtype.hashCode();
            for (Class<?> clazz : this.ptypes) {
                n = 31 * n + clazz.hashCode();
            }
            this.hashcode = n;
        }
        return this.hashcode;
    }

    public boolean hasPrimitives() {
        if (this.rtype.isPrimitive()) {
            return true;
        }
        for (Class<?> clazz : this.ptypes) {
            if (!clazz.isPrimitive()) continue;
            return true;
        }
        return false;
    }

    public boolean hasWrappers() {
        if (MethodTypeHelper.WRAPPER_SET.contains(this.rtype) || this.rtype == Void.class) {
            return true;
        }
        for (Class<?> clazz : this.ptypes) {
            if (!MethodTypeHelper.WRAPPER_SET.contains(clazz)) continue;
            return true;
        }
        return false;
    }

    public MethodType insertParameterTypes(int n, Class<?> ... classArray) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.ptypes.length) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = classArray.length;
        if (n2 == 0) {
            return this;
        }
        Class[] classArray2 = new Class[this.ptypes.length + n2];
        System.arraycopy(this.ptypes, 0, (Object)classArray2, 0, n);
        System.arraycopy(classArray, 0, (Object)classArray2, n, n2);
        System.arraycopy(this.ptypes, n, (Object)classArray2, n + n2, this.ptypes.length - n);
        return MethodType.methodType(this.rtype, classArray2, false);
    }

    public MethodType insertParameterTypes(int n, List<Class<?>> list) {
        return this.insertParameterTypes(n, list.toArray(new Class[list.size()]));
    }

    public static MethodType methodType(Class<?> clazz) {
        return MethodType.methodType(clazz, EMTPY_PARAMS, false);
    }

    public static MethodType methodType(Class<?> clazz, Class<?> clazz2) {
        return MethodType.methodType(clazz, new Class[]{clazz2}, false);
    }

    public static MethodType methodType(Class<?> clazz, Class<?>[] classArray) {
        return MethodType.methodType(clazz, classArray, true);
    }

    private static MethodType methodType(Class<?> clazz, Class<?>[] classArray, boolean bl) {
        clazz.getClass();
        MethodType methodType = new MethodType(clazz, classArray, bl);
        return methodType.intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodType intern() {
        MethodType methodType = this.probeTable();
        if (methodType != null) {
            return methodType;
        }
        InternTableAddLock internTableAddLock = MethodType.internTableAddLock;
        synchronized (internTableAddLock) {
            methodType = this.probeTable();
            if (methodType != null) {
                return methodType;
            }
            int n = this.ptypes.length;
            for (Class<?> clazz : this.ptypes) {
                clazz.getClass();
                if (clazz == Double.TYPE || clazz == Long.TYPE) {
                    ++n;
                    continue;
                }
                if (clazz != Void.TYPE) continue;
                throw new IllegalArgumentException(Msg.getString("K05d9", Void.TYPE));
            }
            if (n > 255) {
                throw new IllegalArgumentException(Msg.getString("K05d8", n));
            }
            this.argSlots = n;
            this.stackDescriptionBits = this.stackDescriptionBits(this.ptypes, this.argSlots);
            this.methodDescriptor = this.createMethodDescriptorString();
            MethodType methodType2 = MethodType.makeTenured(this);
            internTable.put(methodType2, new WeakReference<MethodType>(methodType2));
            return methodType2;
        }
    }

    private MethodType probeTable() {
        Reference reference = internTable.get(this);
        if (reference != null) {
            return (MethodType)reference.get();
        }
        return null;
    }

    private static native MethodType makeTenured(MethodType var0);

    public static MethodType methodType(Class<?> clazz, Class<?> clazz2, Class<?> ... classArray) {
        Class[] classArray2 = new Class[classArray.length + 1];
        classArray2[0] = clazz2;
        System.arraycopy(classArray, 0, (Object)classArray2, 1, classArray.length);
        return MethodType.methodType(clazz, classArray2, false);
    }

    public static MethodType methodType(Class<?> clazz, List<Class<?>> list) {
        return MethodType.methodType(clazz, list.toArray(new Class[list.size()]), false);
    }

    public static MethodType methodType(Class<?> clazz, MethodType methodType) {
        return MethodType.methodType(clazz, methodType.ptypes, false);
    }

    public static MethodType genericMethodType(int n) throws IllegalArgumentException {
        return MethodType.genericMethodType(n, false);
    }

    public static MethodType genericMethodType(int n, boolean bl) throws IllegalArgumentException {
        if (n < 0 || n > (bl ? 254 : 255)) {
            throw new IllegalArgumentException();
        }
        int n2 = n;
        if (bl) {
            ++n2;
        }
        Object[] objectArray = new Class[n2];
        Arrays.fill(objectArray, Object.class);
        if (bl) {
            objectArray[n] = Object[].class;
        }
        return MethodType.methodType(Object.class, objectArray, false);
    }

    public Class<?>[] parameterArray() {
        return (Class[])this.ptypes.clone();
    }

    public int parameterCount() {
        return this.ptypes.length;
    }

    Class<?>[] ptypes() {
        return this.ptypes;
    }

    public List<Class<?>> parameterList() {
        List<Object> list = Arrays.asList((Object[])this.ptypes.clone());
        return Collections.unmodifiableList(list);
    }

    public Class<?> parameterType(int n) throws IndexOutOfBoundsException {
        return this.ptypes[n];
    }

    public Class<?> returnType() {
        return this.rtype;
    }

    Class<?> lastParameterType() {
        Class<Void> clazz = Void.TYPE;
        if (this.ptypes.length > 0) {
            clazz = this.ptypes[this.ptypes.length - 1];
        }
        return clazz;
    }

    public String toMethodDescriptorString() {
        return this.methodDescriptor;
    }

    private String createMethodDescriptorString() {
        StringBuilder stringBuilder = new StringBuilder("(");
        for (Class<?> clazz : this.ptypes) {
            stringBuilder.append(MethodTypeHelper.getBytecodeStringName(clazz));
        }
        stringBuilder.append(")");
        stringBuilder.append(MethodTypeHelper.getBytecodeStringName(this.rtype));
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("(");
        for (int i = 0; i < this.ptypes.length; ++i) {
            stringBuilder.append(this.ptypes[i].getSimpleName());
            if (i >= this.ptypes.length - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        stringBuilder.append(this.rtype.getSimpleName());
        return stringBuilder.toString();
    }

    public MethodType unwrap() {
        Class[] classArray = (Class[])this.ptypes.clone();
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = MethodTypeHelper.unwrapPrimitive(classArray[i]);
        }
        Class<Object> clazz = MethodTypeHelper.unwrapPrimitive(this.rtype);
        if (MethodTypeHelper.unwrapPrimitive(this.rtype) == Void.class) {
            clazz = Void.TYPE;
        }
        return MethodType.methodType(clazz, classArray, false);
    }

    public MethodType wrap() {
        Class[] classArray = (Class[])this.ptypes.clone();
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = MethodTypeHelper.wrapPrimitive(classArray[i]);
        }
        return MethodType.methodType(MethodTypeHelper.wrapPrimitive(this.rtype), classArray, false);
    }

    public MethodType appendParameterTypes(Class<?> ... classArray) throws IllegalArgumentException, NullPointerException {
        if (classArray == null) {
            throw new NullPointerException();
        }
        return this.appendParameterTypes(Arrays.asList(classArray));
    }

    public MethodType appendParameterTypes(List<Class<?>> list) throws IllegalArgumentException, NullPointerException {
        if (list == null) {
            throw new NullPointerException();
        }
        ArrayList arrayList = new ArrayList(Arrays.asList(this.ptypes));
        arrayList.addAll(list);
        return MethodType.methodType(this.rtype, arrayList);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.returnType());
        objectOutputStream.writeObject(this.parameterArray());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            final Field field = this.getClass().getDeclaredField("rtype");
            final Field field2 = this.getClass().getDeclaredField("ptypes");
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    field.setAccessible(true);
                    field2.setAccessible(true);
                    return null;
                }
            });
            field.set(this, Void.TYPE);
            field2.set(this, EMTPY_PARAMS);
            this.methodDescriptor = "()V";
            this.stackDescriptionBits = this.stackDescriptionBits(EMTPY_PARAMS, 0);
            Class clazz = (Class)objectInputStream.readObject();
            Class[] classArray = (Class[])objectInputStream.readObject();
            this.deserializedFields = new DeserializedFieldsHolder(clazz, classArray);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private Object readResolve() throws ObjectStreamException {
        Class<Void> clazz = Void.TYPE;
        Class<?>[] classArray = EMTPY_PARAMS;
        DeserializedFieldsHolder deserializedFieldsHolder = this.deserializedFields;
        if (deserializedFieldsHolder != null) {
            clazz = this.deserializedFields.returnType;
            classArray = this.deserializedFields.arguments;
        }
        return MethodType.methodType(clazz, classArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InvokeExactHandle getInvokeExactHandle() {
        if (null == this.invoker) {
            MethodType methodType = this;
            synchronized (methodType) {
                if (null == this.invoker) {
                    this.invoker = new InvokeExactHandle(this);
                }
            }
        }
        return this.invoker;
    }

    MethodType basicType() {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    MethodType invokerType() {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    MethodType replaceParameterTypes(int n, int n2, Class<?> ... classArray) {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    MethodTypeForm form() {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    Class<?> rtype() {
        return this.rtype;
    }

    MethodType asCollectorType(Class<?> clazz, int n) {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    private static class DeserializedFieldsHolder {
        Class<?> returnType;
        Class<?>[] arguments;

        DeserializedFieldsHolder(Class<?> clazz, Class<?>[] classArray) {
            this.returnType = clazz == null ? Void.TYPE : clazz;
            this.arguments = classArray == null ? EMTPY_PARAMS : classArray;
        }
    }

    static final class InternTableAddLock {
        InternTableAddLock() {
        }
    }
}

