/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Cache;
import java.lang.invoke.CacheKey;
import java.lang.invoke.FieldCacheKey;
import java.lang.invoke.MethodCacheKey;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import java.util.Map;

final class HandleCache {
    private static final Cache findVirtualCache = new Cache();
    private static final Cache findStaticCache = new Cache();
    private static final Cache findSpecialCache = new Cache();
    private static final Cache findConstructorCache = new Cache();
    private static final Cache staticFieldSetterCache = new Cache();
    private static final Cache staticFieldGetterCache = new Cache();
    private static final Cache fieldSetterCache = new Cache();
    private static final Cache fieldGetterCache = new Cache();

    HandleCache() {
    }

    static Map<CacheKey, WeakReference<MethodHandle>> getVirtualCache(Class<?> clazz) {
        return (Map)findVirtualCache.get(clazz);
    }

    static Map<CacheKey, WeakReference<MethodHandle>> getStaticCache(Class<?> clazz) {
        return (Map)findStaticCache.get(clazz);
    }

    static Map<CacheKey, WeakReference<MethodHandle>> getSpecialCache(Class<?> clazz) {
        return (Map)findSpecialCache.get(clazz);
    }

    static Map<CacheKey, WeakReference<MethodHandle>> getConstructorCache(Class<?> clazz) {
        return (Map)findConstructorCache.get(clazz);
    }

    static Map<CacheKey, WeakReference<MethodHandle>> getFieldSetterCache(Class<?> clazz) {
        return (Map)fieldSetterCache.get(clazz);
    }

    static Map<CacheKey, WeakReference<MethodHandle>> getFieldGetterCache(Class<?> clazz) {
        return (Map)fieldGetterCache.get(clazz);
    }

    static Map<CacheKey, WeakReference<MethodHandle>> getStaticFieldSetterCache(Class<?> clazz) {
        return (Map)staticFieldSetterCache.get(clazz);
    }

    static Map<CacheKey, WeakReference<MethodHandle>> getStaticFieldGetterCache(Class<?> clazz) {
        return (Map)staticFieldGetterCache.get(clazz);
    }

    public static MethodHandle getMethodFromPerClassCache(Map<CacheKey, WeakReference<MethodHandle>> map, String string, MethodType methodType) {
        return HandleCache.getMethodWithSpecialCallerFromPerClassCache(map, string, methodType, null);
    }

    public static MethodHandle getMethodWithSpecialCallerFromPerClassCache(Map<CacheKey, WeakReference<MethodHandle>> map, String string, MethodType methodType, Class<?> clazz) {
        WeakReference<MethodHandle> weakReference = map.get(new MethodCacheKey(string, methodType, clazz));
        if (weakReference != null) {
            return (MethodHandle)weakReference.get();
        }
        return null;
    }

    public static MethodHandle getFieldFromPerClassCache(Map<CacheKey, WeakReference<MethodHandle>> map, String string, Class<?> clazz) {
        WeakReference<MethodHandle> weakReference = map.get(new FieldCacheKey(string, clazz));
        if (weakReference != null) {
            return (MethodHandle)weakReference.get();
        }
        return null;
    }

    public static MethodHandle putMethodInPerClassCache(Map<CacheKey, WeakReference<MethodHandle>> map, String string, MethodType methodType, MethodHandle methodHandle) {
        return HandleCache.putMethodWithSpecialCallerInPerClassCache(map, string, methodType, methodHandle, null);
    }

    public static MethodHandle putMethodWithSpecialCallerInPerClassCache(Map<CacheKey, WeakReference<MethodHandle>> map, String string, MethodType methodType, MethodHandle methodHandle, Class<?> clazz) {
        return HandleCache.cacheHandle(map, new MethodCacheKey(string, methodType, clazz), methodHandle);
    }

    public static MethodHandle putFieldInPerClassCache(Map<CacheKey, WeakReference<MethodHandle>> map, String string, Class<?> clazz, MethodHandle methodHandle) {
        return HandleCache.cacheHandle(map, new FieldCacheKey(string, clazz), methodHandle);
    }

    private static MethodHandle cacheHandle(Map<CacheKey, WeakReference<MethodHandle>> map, CacheKey cacheKey, MethodHandle methodHandle) {
        methodHandle.cacheKey = cacheKey;
        map.put(methodHandle.cacheKey, new WeakReference<MethodHandle>(methodHandle));
        return methodHandle;
    }
}

