/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.FoldNonvoidHandle;
import java.lang.invoke.FoldVoidHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkKeyWithObjectArray;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;

abstract class FoldHandle
extends MethodHandle {
    protected final MethodHandle next;
    protected final MethodHandle combiner;
    private final int foldPosition;
    private final int[] argumentIndices;
    private static final ThunkTable _thunkTable = new ThunkTable();

    protected FoldHandle(MethodHandle methodHandle, MethodHandle methodHandle2, MethodType methodType, int n, int ... nArray) {
        super(methodType, (byte)27, FoldHandle.infoAffectingThunks(methodHandle2.type(), n, nArray));
        this.next = methodHandle;
        this.combiner = methodHandle2;
        this.foldPosition = n;
        this.argumentIndices = nArray;
    }

    FoldHandle(FoldHandle foldHandle, MethodType methodType) {
        super(foldHandle, methodType);
        this.next = foldHandle.next;
        this.combiner = foldHandle.combiner;
        this.foldPosition = foldHandle.foldPosition;
        this.argumentIndices = foldHandle.argumentIndices;
    }

    public static FoldHandle get(MethodHandle methodHandle, MethodHandle methodHandle2, MethodType methodType, int n, int ... nArray) {
        if (methodHandle2.type().returnType() == Void.TYPE) {
            return new FoldVoidHandle(methodHandle, methodHandle2, methodType, n, nArray);
        }
        return new FoldNonvoidHandle(methodHandle, methodHandle2, methodType, n, nArray);
    }

    private static Object[] infoAffectingThunks(MethodType methodType, int n, int ... nArray) {
        Object[] objectArray = new Object[]{methodType, n, nArray};
        return objectArray;
    }

    @Override
    protected ThunkTable thunkTable() {
        return _thunkTable;
    }

    @Override
    protected final ThunkTuple computeThunks(Object object) {
        return this.thunkTable().get(new ThunkKeyWithObjectArray(ThunkKey.computeThunkableType(this.type()), (Object[])object));
    }

    @Override
    final void compareWith(MethodHandle methodHandle, Comparator comparator) {
        if (methodHandle instanceof FoldHandle) {
            ((FoldHandle)methodHandle).compareWithFold(this, comparator);
        } else {
            comparator.fail();
        }
    }

    final void compareWithFold(FoldHandle foldHandle, Comparator comparator) {
        comparator.compareChildHandle(foldHandle.next, this.next);
        comparator.compareChildHandle(foldHandle.combiner, this.combiner);
        comparator.compareStructuralParameter(foldHandle.foldPosition, this.foldPosition);
        comparator.compareStructuralParameter(foldHandle.argumentIndices, this.argumentIndices);
    }

    protected static native int foldPosition();

    protected static native int argIndices();

    protected static native int argumentsForCombiner(int var0, int var1);
}

