/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.ComputedCalls;
import java.lang.invoke.DirectHandle;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.PrimitiveHandle;
import java.lang.invoke.ThunkTable;
import java.lang.reflect.Constructor;

final class ConstructorHandle
extends PrimitiveHandle {
    private static final ThunkTable _thunkTable;

    public ConstructorHandle(Class<?> clazz, MethodType methodType) throws NoSuchMethodException, IllegalAccessException {
        super(ConstructorHandle.constructorMethodType(methodType, clazz), clazz, "<init>", (byte)8, null);
        this.defc = this.finishMethodInitialization(clazz, methodType);
    }

    public ConstructorHandle(Constructor<?> constructor) throws IllegalAccessException {
        super(ConstructorHandle.constructorMethodType(constructor), constructor.getDeclaringClass(), "<init>", (byte)8, constructor.getModifiers(), constructor.getDeclaringClass());
        boolean bl = ConstructorHandle.setVMSlotAndRawModifiersFromConstructor(this, constructor);
        if (!bl) {
            throw new IllegalAccessException();
        }
    }

    ConstructorHandle(ConstructorHandle constructorHandle, MethodType methodType) {
        super(constructorHandle, methodType);
    }

    private static final MethodType constructorMethodType(MethodType methodType, Class<?> clazz) {
        return methodType.changeReturnType(clazz);
    }

    private static final MethodType constructorMethodType(Constructor<?> constructor) {
        Class<?> clazz = constructor.getDeclaringClass();
        return MethodType.methodType(clazz, constructor.getParameterTypes());
    }

    @Override
    boolean canRevealDirect() {
        return true;
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    @MethodHandle.FrameIteratorSkip
    private final Object invokeExact_thunkArchetype_L(int n) {
        if (ILGenMacros.isCustomThunk()) {
            DirectHandle.directCall_V(ILGenMacros.push(ILGenMacros.rawNew(this.referenceClass)), n);
        } else if (DirectHandle.isAlreadyCompiled(this.vmSlot)) {
            ComputedCalls.dispatchDirect_V(DirectHandle.compiledEntryPoint(this.vmSlot), ILGenMacros.push(ILGenMacros.rawNew(this.referenceClass)), n);
        } else {
            ComputedCalls.dispatchJ9Method_V(this.vmSlot, ILGenMacros.push(ILGenMacros.rawNew(this.referenceClass)), n);
        }
        return ILGenMacros.pop_L();
    }

    @Override
    MethodHandle cloneWithNewType(MethodType methodType) {
        return new ConstructorHandle(this, methodType);
    }

    @Override
    final void compareWith(MethodHandle methodHandle, Comparator comparator) {
        if (methodHandle instanceof ConstructorHandle) {
            ((ConstructorHandle)methodHandle).compareWithConstructor(this, comparator);
        } else {
            comparator.fail();
        }
    }

    final void compareWithConstructor(ConstructorHandle constructorHandle, Comparator comparator) {
        comparator.compareStructuralParameter(constructorHandle.referenceClass, this.referenceClass);
    }

    static {
        DirectHandle.load();
        _thunkTable = new ThunkTable();
    }
}

