/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;

public final class Util {
    private static final String defaultEncoding;
    private static final String[] digitChars;

    public static byte[] getBytes(String string) {
        if (defaultEncoding != null) {
            try {
                return string.getBytes(defaultEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return string.getBytes();
    }

    public static String toString(byte[] byArray) {
        if (defaultEncoding != null) {
            try {
                return new String(byArray, 0, byArray.length, defaultEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new String(byArray, 0, byArray.length);
    }

    public static String convertFromUTF8(byte[] byArray, int n, int n2) throws UTFDataFormatException {
        return Util.convertUTF8WithBuf(byArray, new char[n2], n, n2);
    }

    public static String convertUTF8WithBuf(byte[] byArray, char[] cArray, int n, int n2) throws UTFDataFormatException {
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            byte by;
            if ((cArray[n4] = (char)byArray[n + n3++]) < '\u0080') {
                ++n4;
                continue;
            }
            char c = cArray[n4];
            if ((c & 0xE0) == 192) {
                if (n3 >= n2) {
                    throw new UTFDataFormatException(Msg.getString("K0062", n3));
                }
                if (((by = byArray[n3++]) & 0xC0) != 128) {
                    throw new UTFDataFormatException(Msg.getString("K0062", n3 - 1));
                }
                cArray[n4++] = (char)((c & 0x1F) << 6 | by & 0x3F);
                continue;
            }
            if ((c & 0xF0) == 224) {
                if (n3 + 1 >= n2) {
                    throw new UTFDataFormatException(Msg.getString("K0063", n3 + 1));
                }
                by = byArray[n3++];
                byte by2 = byArray[n3++];
                if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                    throw new UTFDataFormatException(Msg.getString("K0064", n3 - 2));
                }
                cArray[n4++] = (char)((c & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                continue;
            }
            throw new UTFDataFormatException(Msg.getString("K0065", n3 - 1));
        }
        return new String(cArray, 0, n4);
    }

    public static String urlEncode(String string) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || "_-!.~'()*,:$&+/@".indexOf(c) > -1) {
                if (n >= 0) {
                    bl = true;
                    Util.convert(string.substring(n, i), stringBuilder);
                    n = -1;
                }
                stringBuilder.append(c);
                continue;
            }
            if (n >= 0) continue;
            n = i;
        }
        if (n >= 0) {
            bl = true;
            Util.convert(string.substring(n, string.length()), stringBuilder);
        }
        return bl ? stringBuilder.toString() : string;
    }

    private static void convert(String string, StringBuilder stringBuilder) {
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append('%');
            stringBuilder.append("0123456789abcdef".charAt((byArray[i] & 0xF0) >> 4));
            stringBuilder.append("0123456789abcdef".charAt(byArray[i] & 0xF));
        }
    }

    public static boolean startsWithDriveLetter(String string) {
        if (string.charAt(1) != ':') {
            return false;
        }
        char c = string.charAt(0);
        return (c = Character.toLowerCase(c)) >= 'a' && c <= 'z';
    }

    public static String canonicalizePath(String string) {
        int n;
        while ((n = string.indexOf("/./")) >= 0) {
            string = string.substring(0, n + 1) + string.substring(n + 3);
        }
        if (string.endsWith("/.")) {
            string = string.substring(0, string.length() - 1);
        }
        while ((n = string.indexOf("/../")) >= 0) {
            if (n != 0) {
                string = string.substring(0, string.lastIndexOf(47, n - 1)) + string.substring(n + 3);
                continue;
            }
            string = string.substring(n + 3);
        }
        if (string.endsWith("/..") && string.length() > 3) {
            string = string.substring(0, string.lastIndexOf(47, string.length() - 4) + 1);
        }
        return string;
    }

    public static boolean doesClassLoaderDescendFrom(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader2 == null) {
            return true;
        }
        if (classLoader != classLoader2) {
            while (classLoader != null) {
                if (classLoader == classLoader2) {
                    return true;
                }
                classLoader = classLoader.getParent();
            }
            return false;
        }
        return true;
    }

    public static void appendTo(Appendable appendable, CharSequence charSequence) {
        try {
            appendable.append(charSequence);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void appendTo(Appendable appendable, int n) {
        int n2 = 1;
        int n3 = 0;
        for (n3 = n; n3 >= 10; n3 /= 10) {
            n2 *= 10;
        }
        Util.appendTo(appendable, digitChars[n3]);
        while (n2 >= 10) {
            n3 = (n -= n2 * n3) / (n2 /= 10);
            Util.appendTo(appendable, digitChars[n3]);
        }
    }

    public static void appendTo(Appendable appendable, CharSequence charSequence, int n) {
        for (int i = 0; i < n; ++i) {
            Util.appendTo(appendable, "\t");
        }
        Util.appendTo(appendable, charSequence);
    }

    public static void appendLnTo(Appendable appendable) {
        if (appendable instanceof PrintStream) {
            ((PrintStream)appendable).println();
        } else if (appendable instanceof PrintWriter) {
            ((PrintWriter)appendable).println();
        } else {
            Util.appendTo(appendable, "\n");
        }
    }

    public static void printStackTraceElement(StackTraceElement stackTraceElement, Object object, Appendable appendable, boolean bl) {
        Object object2;
        Util.appendTo(appendable, stackTraceElement.getClassName());
        Util.appendTo(appendable, ".");
        Util.appendTo(appendable, stackTraceElement.getMethodName());
        Util.appendTo(appendable, "(");
        if (stackTraceElement.isNativeMethod()) {
            Util.appendTo(appendable, "Native Method");
        } else {
            object2 = stackTraceElement.getFileName();
            if (object2 == null) {
                Util.appendTo(appendable, "Unknown Source");
            } else {
                int n = stackTraceElement.getLineNumber();
                Util.appendTo(appendable, (CharSequence)object2);
                if (n >= 0) {
                    Util.appendTo(appendable, ":");
                    Util.appendTo(appendable, n);
                }
            }
        }
        Util.appendTo(appendable, ")");
        if (object != null) {
            Util.appendTo(appendable, " from ");
            if (object instanceof String) {
                Util.appendTo(appendable, (String)object);
            } else if (object instanceof ProtectionDomain) {
                URL uRL;
                object2 = (ProtectionDomain)object;
                Util.appendTo(appendable, String.valueOf(((ProtectionDomain)object2).getClassLoader()));
                CodeSource codeSource = ((ProtectionDomain)object2).getCodeSource();
                if (codeSource != null && (uRL = codeSource.getLocation()) != null) {
                    Util.appendTo(appendable, "(");
                    Util.appendTo(appendable, uRL.toString());
                    Util.appendTo(appendable, ")");
                }
            }
        }
    }

    static {
        String string = VM.getVMLangAccess().internalGetProperties().getProperty("os.encoding");
        if (string != null) {
            try {
                "".getBytes(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = null;
            }
        }
        defaultEncoding = string;
        digitChars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    }
}

