/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.internal.JvmCpuMonitorInfoUtil;
import com.ibm.oti.util.Msg;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;

public final class JvmCpuMonitorInfo {
    private static final int HASHMASK = 0xFFFFFFF;
    private static final int NUM_USER_DEFINED_CATEGORY = 5;
    private long timestamp;
    private long applicationCpuTime;
    private long resourceMonitorCpuTime;
    private long systemJvmCpuTime;
    private long gcCpuTime;
    private long jitCpuTime;
    private final long[] applicationUserCpuTime = new long[5];

    public JvmCpuMonitorInfo() {
    }

    private JvmCpuMonitorInfo(long l, long l2, long l3, long l4, long l5, long l6, long[] lArray) throws IllegalArgumentException {
        if (l < 0L || l2 < 0L || l3 < 0L || l4 < 0L || l5 < 0L || l6 < 0L) {
            throw new IllegalArgumentException();
        }
        this.timestamp = l;
        this.applicationCpuTime = l2;
        this.resourceMonitorCpuTime = l3;
        this.systemJvmCpuTime = l4;
        this.gcCpuTime = l5;
        this.jitCpuTime = l6;
        System.arraycopy((Object)lArray, 0, (Object)this.applicationUserCpuTime, 0, lArray.length);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getApplicationCpuTime() {
        return this.applicationCpuTime;
    }

    public long getResourceMonitorCpuTime() {
        return this.resourceMonitorCpuTime;
    }

    public long getSystemJvmCpuTime() {
        return this.systemJvmCpuTime;
    }

    public long getGcCpuTime() {
        return this.gcCpuTime;
    }

    public long getJitCpuTime() {
        return this.jitCpuTime;
    }

    public long[] getApplicationUserCpuTime() {
        long[] lArray = (long[])this.applicationUserCpuTime.clone();
        return lArray;
    }

    void updateValues(long l, long l2, long l3, long l4, long l5, long l6, long[] lArray) {
        this.timestamp = l;
        this.applicationCpuTime = l2;
        this.resourceMonitorCpuTime = l3;
        this.systemJvmCpuTime = l4;
        this.gcCpuTime = l5;
        this.jitCpuTime = l6;
        System.arraycopy((Object)lArray, 0, (Object)this.applicationUserCpuTime, 0, lArray.length);
    }

    public static JvmCpuMonitorInfo from(CompositeData compositeData) {
        JvmCpuMonitorInfo jvmCpuMonitorInfo = null;
        if (null != compositeData) {
            long[] lArray;
            long l;
            long l2;
            long l3;
            long l4;
            long l5;
            long l6;
            if (!JvmCpuMonitorInfoUtil.getCompositeType().isValue(compositeData)) {
                throw new IllegalArgumentException(Msg.getString("K05E5"));
            }
            try {
                l6 = (Long)compositeData.get("timestamp");
                l5 = (Long)compositeData.get("applicationCpuTime");
                l4 = (Long)compositeData.get("resourceMonitorCpuTime");
                l3 = (Long)compositeData.get("systemJvmCpuTime");
                l2 = (Long)compositeData.get("gcCpuTime");
                l = (Long)compositeData.get("jitCpuTime");
                lArray = (long[])compositeData.get("applicationUserCpuTime");
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IllegalArgumentException(Msg.getString("K05E6"));
            }
            jvmCpuMonitorInfo = new JvmCpuMonitorInfo(l6, l5, l4, l3, l2, l, lArray);
        }
        return jvmCpuMonitorInfo;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n========== ");
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" ==========\n\n");
        stringBuilder.append("             timestamp = ");
        stringBuilder.append(this.timestamp);
        stringBuilder.append("\n");
        stringBuilder.append("      systemJvmCpuTime = ");
        stringBuilder.append(this.systemJvmCpuTime);
        stringBuilder.append("\n");
        stringBuilder.append("             gcCpuTime = ");
        stringBuilder.append(this.gcCpuTime);
        stringBuilder.append("\n");
        stringBuilder.append("            jitCpuTime = ");
        stringBuilder.append(this.jitCpuTime);
        stringBuilder.append("\n");
        stringBuilder.append("resourceMonitorCpuTime = ");
        stringBuilder.append(this.resourceMonitorCpuTime);
        stringBuilder.append("\n");
        stringBuilder.append("    applicationCpuTime = ");
        stringBuilder.append(this.applicationCpuTime);
        stringBuilder.append("\n");
        for (int i = 0; i < this.applicationUserCpuTime.length; ++i) {
            stringBuilder.append("      applicationUser");
            stringBuilder.append(i + 1);
            stringBuilder.append(" = ");
            stringBuilder.append(this.applicationUserCpuTime[i]);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object) {
            return false;
        }
        if (!(object instanceof JvmCpuMonitorInfo)) {
            return false;
        }
        JvmCpuMonitorInfo jvmCpuMonitorInfo = (JvmCpuMonitorInfo)object;
        if (jvmCpuMonitorInfo.getTimestamp() != this.getTimestamp()) {
            return false;
        }
        if (jvmCpuMonitorInfo.getApplicationCpuTime() != this.getApplicationCpuTime()) {
            return false;
        }
        if (jvmCpuMonitorInfo.getResourceMonitorCpuTime() != this.getResourceMonitorCpuTime()) {
            return false;
        }
        if (jvmCpuMonitorInfo.getSystemJvmCpuTime() != this.getSystemJvmCpuTime()) {
            return false;
        }
        if (jvmCpuMonitorInfo.getGcCpuTime() != this.getGcCpuTime()) {
            return false;
        }
        if (jvmCpuMonitorInfo.getJitCpuTime() != this.getJitCpuTime()) {
            return false;
        }
        long[] lArray = jvmCpuMonitorInfo.getApplicationUserCpuTime();
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == this.applicationUserCpuTime[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long l = this.getTimestamp() + this.getApplicationCpuTime() + this.getResourceMonitorCpuTime() + this.getSystemJvmCpuTime() + this.getGcCpuTime() + this.getJitCpuTime();
        for (int i = 0; i < this.applicationUserCpuTime.length; ++i) {
            l += this.applicationUserCpuTime[i];
        }
        return (int)(((l >> 32) + l & 0xFFFFFFFL) * 23L);
    }
}

