/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.oti.util.Msg;
import java.lang.management.PlatformLoggingMXBean;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.LoggingMXBean;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public final class LoggingMXBeanImpl
extends StandardMBean
implements LoggingMXBean,
PlatformLoggingMXBean {
    private static final LoggingMXBeanImpl instance = LoggingMXBeanImpl.createInstance();
    private ObjectName objectName;

    private static LoggingMXBeanImpl createInstance() {
        return new LoggingMXBeanImpl();
    }

    private LoggingMXBeanImpl() {
        super(PlatformLoggingMXBean.class, true);
    }

    @Override
    public ObjectName getObjectName() {
        if (this.objectName == null) {
            this.objectName = ManagementUtils.createObjectName("java.util.logging:type=Logging");
        }
        return this.objectName;
    }

    public static LoggingMXBeanImpl getInstance() {
        return instance;
    }

    @Override
    public String getLoggerLevel(String string) {
        String string2 = null;
        Logger logger = LogManager.getLogManager().getLogger(string);
        if (logger != null) {
            Level level = logger.getLevel();
            string2 = level != null ? level.getName() : "";
        }
        return string2;
    }

    @Override
    public List<String> getLoggerNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<String> enumeration = LogManager.getLogManager().getLoggerNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        }
        return arrayList;
    }

    @Override
    public String getParentLoggerName(String string) {
        String string2 = null;
        Logger logger = LogManager.getLogManager().getLogger(string);
        if (logger != null) {
            Logger logger2 = logger.getParent();
            string2 = logger2 != null ? logger2.getName() : "";
        }
        return string2;
    }

    @Override
    public void setLoggerLevel(String string, String string2) {
        Level level;
        Logger logger = LogManager.getLogManager().getLogger(string);
        if (logger != null) {
            level = null;
            if (string2 != null) {
                level = Level.parse(string2);
            }
        } else {
            throw new IllegalArgumentException(Msg.getString("K05E7", string));
        }
        logger.setLevel(level);
    }
}

