/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.CudaBuffer;
import com.ibm.cuda.CudaDevice;
import com.ibm.cuda.CudaException;
import com.ibm.cuda.CudaFunction;
import com.ibm.cuda.CudaGrid;
import com.ibm.cuda.CudaModule;

public class CudaKernel {
    private final CudaFunction function;

    public CudaKernel(CudaModule cudaModule, CudaFunction cudaFunction) {
        if (cudaFunction.deviceId != cudaModule.deviceId) {
            throw new IllegalArgumentException();
        }
        this.function = cudaFunction;
    }

    public CudaKernel(CudaModule cudaModule, String string) throws CudaException {
        this(cudaModule, cudaModule.getFunction(string));
    }

    public final int getAttribute(int n) throws CudaException {
        return this.function.getAttribute(n);
    }

    public final void launch(CudaGrid cudaGrid, Object ... objectArray) throws CudaException {
        this.function.launch(cudaGrid, objectArray);
    }

    public final void launch(CudaGrid cudaGrid, Parameters parameters) throws CudaException {
        this.function.launch(cudaGrid, parameters);
    }

    public final void setCacheConfig(CudaDevice.CacheConfig cacheConfig) throws CudaException {
        this.function.setCacheConfig(cacheConfig);
    }

    public final void setSharedMemConfig(CudaDevice.SharedMemConfig sharedMemConfig) throws CudaException {
        this.function.setSharedMemConfig(sharedMemConfig);
    }

    public static final class Parameters
    implements Cloneable {
        private long mask;
        final long[] values;

        public Parameters(int n) {
            if (0 > n || n > 64) {
                throw new IllegalArgumentException();
            }
            this.mask = n == 64 ? -1L : (1L << n) - 1L;
            this.values = new long[n];
        }

        public Parameters(Object ... objectArray) {
            int n = objectArray.length;
            this.mask = 0L;
            this.values = new long[n];
            for (int i = 0; i < n; ++i) {
                this.values[i] = CudaFunction.nativeValueOf(objectArray[i]);
            }
        }

        public Parameters(Parameters parameters) {
            this.mask = parameters.mask;
            this.values = (long[])parameters.values.clone();
        }

        public Parameters add(byte by) {
            return this.add((long)by);
        }

        public Parameters add(char c) {
            return this.add((long)c);
        }

        public Parameters add(CudaBuffer cudaBuffer) {
            return this.add(cudaBuffer == null ? 0L : cudaBuffer.getAddress());
        }

        public Parameters add(double d) {
            return this.add(Double.doubleToRawLongBits(d));
        }

        public Parameters add(float f) {
            return this.add((long)Float.floatToRawIntBits(f));
        }

        public Parameters add(int n) {
            return this.add((long)n);
        }

        public Parameters add(long l) {
            if (this.isComplete()) {
                throw new IndexOutOfBoundsException();
            }
            int n = Long.numberOfTrailingZeros(this.mask);
            return this.set(n, l);
        }

        public Parameters add(short s) {
            return this.add((long)s);
        }

        public Parameters clone() {
            return new Parameters(this);
        }

        boolean isComplete() {
            return this.mask == 0L;
        }

        public Parameters set(int n, byte by) {
            return this.set(n, (long)by);
        }

        public Parameters set(int n, char c) {
            return this.set(n, (long)c);
        }

        public Parameters set(int n, CudaBuffer cudaBuffer) {
            return this.set(n, cudaBuffer == null ? 0L : cudaBuffer.getAddress());
        }

        public Parameters set(int n, double d) {
            return this.set(n, Double.doubleToRawLongBits(d));
        }

        public Parameters set(int n, float f) {
            return this.set(n, (long)Float.floatToRawIntBits(f));
        }

        public Parameters set(int n, int n2) {
            return this.set(n, (long)n2);
        }

        public Parameters set(int n, long l) {
            if (0 <= n && n < this.values.length) {
                this.mask &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL;
                this.values[n] = l;
                return this;
            }
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }

        public Parameters set(int n, short s) {
            return this.set(n, (long)s);
        }
    }
}

