/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_wo extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_BY = "Belaris";
        final String metaValue_MT = "Malt";
        final String metaValue_ar = "Araab";
        final String metaValue_la = "Latin";
        final Object[][] data = new Object[][] {
            { "fil", "Filipiye" },
            { "ban", "Bali" },
            { "AD", "Andoor" },
            { "AE", "Emira Arab Ini" },
            { "AF", "Afganista\u014b" },
            { "af", "Afrikaans" },
            { "AG", "Antiguwa ak Barbuda" },
            { "AI", "Angiiy" },
            { "AL", "Albani" },
            { "AM", "Armeni" },
            { "am", "Amharik" },
            { "Arab", metaValue_ar },
            { "AO", "\u00c0ngolaa" },
            { "AQ", "Antarktik" },
            { "ar", metaValue_ar },
            { "AR", "Ars\u00e0ntin" },
            { "AS", "Samowa bu Amerig" },
            { "as", "Asame" },
            { "AT", "\u00d3tiriis" },
            { "AU", "Ostarali" },
            { "AW", "Aruba" },
            { "AX", "Duni Aal\u00e0nd" },
            { "AZ", "Aserbayja\u014b" },
            { "az", "Aserbayjane" },
            { "BA", "Bosni Ersegowin" },
            { "ba", "Baskir" },
            { "BB", "Barbad" },
            { "ceb", "Sibiyanoo" },
            { "BD", "Bengalades" },
            { "be", metaValue_BY },
            { "BE", "Belsig" },
            { "BF", "Burkina Faaso" },
            { "BG", "Bilgari" },
            { "bg", "Bilgaar" },
            { "BH", "Bahreyin" },
            { "BI", "Burundi" },
            { "BJ", "Benee" },
            { "BL", "Sa\u014b Bartalemi" },
            { "BM", "Bermid" },
            { "BN", "Burney" },
            { "bn", "Ba\u014bla" },
            { "BO", "Boliwi" },
            { "bo", "Tibetan" },
            { "BR", "Beresil" },
            { "br", "Breton" },
            { "BS", "Bahamas" },
            { "bs", "Bos\u00f1ak" },
            { "BT", "Buta\u014b" },
            { "BV", "Dunu Buwet" },
            { "BW", "Botswana" },
            { "BY", metaValue_BY },
            { "BZ", "Belis" },
            { "CA", "Kanadaa" },
            { "ca", "Katalan" },
            { "CC", "Duni Koko (Kilin)" },
            { "CF", "Repiblik S\u00e0ntar Afrik" },
            { "CH", "Siwis" },
            { "CI", "Kodiwaar (C\u00f4te d\u2019Ivoire)" },
            { "CK", "Duni Kuuk" },
            { "CL", "Sili" },
            { "CM", "Kamerun" },
            { "CN", "Siin" },
            { "CO", "Kolombi" },
            { "co", "Kors" },
            { "CR", "Kosta Rika" },
            { "cs", "Cek" },
            { "CU", "Kuba" },
            { "CV", "Kabo Werde" },
            { "CW", "Kursawo" },
            { "CX", "Dunu Kirismas" },
            { "CY", "Siipar" },
            { "cy", "Wels" },
            { "CZ", "R\u00e9ewum Cek" },
            { "da", "Danuwa" },
            { "DE", "Almaa\u00f1" },
            { "de", "Almaa" },
            { "DJ", "Jibuti" },
            { "DK", "Danm\u00e0rk" },
            { "DM", "Dominik" },
            { "DO", "Repiblik Dominiken" },
            { "bem", "Bemba" },
            { "dv", "Diweyi" },
            { "es_419", "Espa\u00f1ol (Amerik Latin)" },
            { "DZ", "Alseri" },
            { "dz", "Dsongkaa" },
            { "EC", "Ekwaat\u00ebr" },
            { "pap", "Papiyamento" },
            { "EE", "Estoni" },
            { "EG", "Esipt" },
            { "el", "Gereg" },
            { "en", "\u00c0ngale" },
            { "chm", "Mari" },
            { "eo", "Esperantoo" },
            { "chr", "Ceroki" },
            { "ER", "Eritere" },
            { "ES", "Espa\u00f1" },
            { "es", "Espa\u00f1ol" },
            { "ET", "Ecopi" },
            { "et", "Esto\u00f1iye" },
            { "eu", "Bask" },
            { "type.ca.gregorian", "Arminaatu Gregoriyee" },
            { "hsb", "Sorab-Kaw" },
            { "fa", "Pers" },
            { "Hans", "Bu\u00f1 woyofal" },
            { "type.nu.latn", "Siifari Tugal" },
            { "Hant", "Cosaan" },
            { "ff", "P\u00ebl" },
            { "FI", "Finl\u00e0nd" },
            { "fi", "Feyl\u00e0nde" },
            { "FJ", "Fijji" },
            { "FK", "Duni Falkland" },
            { "FM", "Mikoronesi" },
            { "FO", "Duni Faro" },
            { "fo", "Feroos" },
            { "FR", "Faraans" },
            { "fr", "Fara\u00f1se" },
            { "GA", "Gabo\u014b" },
            { "ga", "Irl\u00e0nde" },
            { "GB", "Ruwaayom Ini" },
            { "GD", "Garanad" },
            { "gd", "Galuwaa bu Ekos" },
            { "GE", "Seworsi" },
            { "GF", "Guyaan Fara\u00f1se" },
            { "GG", "Gernase" },
            { "GH", "Gana" },
            { "GI", "Sibraltaar" },
            { "GL", "Girinl\u00e0nd" },
            { "gl", "Galisiye" },
            { "GM", "G\u00e0mbi" },
            { "GN", "Gine" },
            { "gn", "Garani" },
            { "GP", "Guwaadelup" },
            { "GQ", "Gine Ekuwatoriyal" },
            { "und", "L\u00e0kk wu\u00f1 xamul" },
            { "GR", "Gerees" },
            { "GS", "Seworsi di Sid ak Duni S\u00e0ndwiis di Sid" },
            { "GT", "Guwatemala" },
            { "GU", "Guwam" },
            { "gu", "Gujarati" },
            { "GW", "Gine-Bisaaw\u00f3o" },
            { "GY", "Giyaan" },
            { "ha", "Hawsa" },
            { "ckb", "Kurdi gu Diggu" },
            { "he", "Ebr\u00eb" },
            { "hi", "Endo" },
            { "HM", "Duni H\u00ebrd ak Duni MakDonald" },
            { "HN", "Onduraas" },
            { "HR", "Korowasi" },
            { "hr", "Krowat" },
            { "HT", "Ayti" },
            { "ht", "Kereyolu Ayti" },
            { "HU", "Ongari" },
            { "hu", "Ongruwaa" },
            { "hy", "Armaniye" },
            { "hz", "Herero" },
            { "ID", "Indonesi" },
            { "id", "Endonesiye" },
            { "IE", "Irl\u00e0nd" },
            { "ig", "Igbo" },
            { "IL", "Israyel" },
            { "IM", "Dunu Maan" },
            { "IN", "End" },
            { "IO", "Terituwaaru Br\u00ebtaa\u00f1 ci Oseyaa Enje\u014b" },
            { "IQ", "Irag" },
            { "IR", "Ira\u014b" },
            { "IS", "Isl\u00e0nd" },
            { "is", "Isl\u00e0nde" },
            { "IT", "Itali" },
            { "it", "Italiye" },
            { "iu", "Inuktitit" },
            { "ja", "Sapone" },
            { "JE", "Serse" },
            { "JM", "Samayig" },
            { "JO", "Sordani" },
            { "JP", "S\u00e0ppo\u014b" },
            { "sma", "Sami gu Saalum" },
            { "smj", "Lule Sami" },
            { "smn", "Inari Sami" },
            { "ka", "Sorsiye" },
            { "sms", "Eskolt Sami" },
            { "KE", "Kee\u00f1a" },
            { "KG", "Kirgista\u014b" },
            { "KH", "K\u00e0mboj" },
            { "KI", "Kiribati" },
            { "kk", "Kasax" },
            { "KM", "Komoor" },
            { "km", "Xmer" },
            { "KN", "Sa\u014b Kits ak Newis" },
            { "kn", "Kannadaa" },
            { "ko", "Koreye" },
            { "KP", "Kore Noor" },
            { "kr", "Kanuri" },
            { "ks", "Kashmiri" },
            { "ku", "Kurdi" },
            { "KW", "Kowet" },
            { "KY", "Duni Kayma\u014b" },
            { "ky", "Kirgiis" },
            { "KZ", "Kasaxsta\u014b" },
            { "Cyrl", "Sirilik" },
            { "la", metaValue_la },
            { "LA", "Lawos" },
            { "LB", "Libaa" },
            { "lb", "Liks\u00e0mbursuwaa" },
            { "LC", "Sa\u014b Lusi" },
            { "LI", "Liktensteyin" },
            { "LK", "Siri L\u00e0nka" },
            { "lo", "Laaw" },
            { "LR", "Liberiya" },
            { "LS", "Lesoto" },
            { "LT", "Litiyani" },
            { "lt", "Lituyaniye" },
            { "LU", "Liks\u00e0mbur" },
            { "LV", "Letoni" },
            { "lv", "Letoniye" },
            { "LY", "Libi" },
            { "MA", "Marog" },
            { "MC", "Monako" },
            { "MD", "Moldawi" },
            { "ME", "Montenegoro" },
            { "MF", "Sa\u014b Marte\u014b" },
            { "MG", "Madagaskaar" },
            { "mg", "Malagasi" },
            { "MH", "Duni Marsaal" },
            { "mi", "Mawri" },
            { "MK", "Maseduwaan" },
            { "mk", "Maseduwaane" },
            { "ML", "Mali" },
            { "ml", "Malayalam" },
            { "MM", "Miyanmaar" },
            { "MN", "Mongoli" },
            { "mn", "Mongoliye" },
            { "MP", "Duni Mariyaan Noor" },
            { "MQ", "Martinik" },
            { "MR", "Mooritani" },
            { "mr", "Marati" },
            { "MS", "Mooseraa" },
            { "ms", "Malay" },
            { "mt", metaValue_MT },
            { "MT", metaValue_MT },
            { "MU", "Moriis" },
            { "MV", "Maldiiw" },
            { "MW", "Malawi" },
            { "MX", "Meksiko" },
            { "MY", "Malesi" },
            { "my", "Birmes" },
            { "MZ", "Mos\u00e0mbig" },
            { "dsb", "Sorab-Suuf" },
            { "NA", "Namibi" },
            { "NC", "Nuwel Kaledoni" },
            { "NE", "Niiseer" },
            { "ne", "Nepale" },
            { "NF", "Dunu Norfolk" },
            { "NG", "Niseriya" },
            { "NI", "Nikaraguwa" },
            { "NL", "Peyi Baa" },
            { "nl", "Neyerl\u00e0nde" },
            { "NO", "Norwees" },
            { "no", "Nerwesiye" },
            { "NP", "Nepaal" },
            { "NR", "Nawru" },
            { "NU", "Niw" },
            { "ny", "Sewa" },
            { "NZ", "Nuwel Sel\u00e0nd" },
            { "oc", "Ositan" },
            { "men", "Mende" },
            { "OM", "Omaan" },
            { "om", "Oromo" },
            { "or", "Oja" },
            { "PA", "Panama" },
            { "pa", "Punjabi" },
            { "PE", "Peru" },
            { "PF", "Polinesi Fara\u00f1se" },
            { "PG", "Papuwasi Gine Gu Bees" },
            { "PH", "Filipin" },
            { "PK", "Pakista\u014b" },
            { "PL", "Polo\u00f1" },
            { "pl", "Polone" },
            { "PM", "Sa\u014b Peer ak Mikelo\u014b" },
            { "PN", "Duni Pitkayirn" },
            { "PR", "Porto Riko" },
            { "ps", "Pasto" },
            { "PT", "Portigaal" },
            { "pt", "Purtugees" },
            { "PW", "Palaw" },
            { "PY", "Paraguwe" },
            { "QA", "Kataar" },
            { "niu", "Niweyan" },
            { "qu", "Kesuwa" },
            { "RE", "Ree\u00f1oo" },
            { "rm", "Romaas" },
            { "RO", "Rumani" },
            { "ro", "Rumaniyee" },
            { "RS", "Serbi" },
            { "RU", "Risi" },
            { "ru", "Rus" },
            { "RW", "Ruw\u00e0nda" },
            { "rw", "Kinyarw\u00e0nda" },
            { "SA", "Arabi Sawudi" },
            { "sa", "Sanskrit" },
            { "SB", "Duni Salmoon" },
            { "SC", "Seysel" },
            { "SD", "Suda\u014b" },
            { "sd", "Sindi" },
            { "SE", "Suwed" },
            { "se", "Penku Sami" },
            { "SG", "Singapuur" },
            { "SH", "Sa\u014b Eleen" },
            { "SI", "Esloweni" },
            { "si", "Sinala" },
            { "SJ", "Swalbaar ak Jan Mayen" },
            { "SK", "Eslowaki" },
            { "sk", "Eslowaki (Eslowak)" },
            { "SL", "Siyera Lewon" },
            { "sl", "Esloweniye" },
            { "SM", "San Marino" },
            { "SN", "Senegaal" },
            { "SO", "Somali" },
            { "so", "Somali (l\u00e0kk)" },
            { "sq", "Albane" },
            { "SR", "Sirinam" },
            { "sr", "Serb" },
            { "SS", "Suda\u014b di Sid" },
            { "ST", "Sawo Tome ak Pirinsipe" },
            { "SV", "El Salwadoor" },
            { "sv", "Suweduwaa" },
            { "SX", "Sin Marten" },
            { "SY", "Siri" },
            { "SZ", "Suwasil\u00e0nd" },
            { "ibb", "Ibibiyo" },
            { "ta", "Tamil" },
            { "TC", "Duni Tirk ak Kaykos" },
            { "TD", "C\u00e0dd" },
            { "te", "Telugu" },
            { "TF", "Teer Ostraal gu Fraas" },
            { "TG", "Togo" },
            { "tg", "Tajis" },
            { "TH", "Tayl\u00e0nd" },
            { "th", "Tay" },
            { "ti", "Tigri\u00f1a" },
            { "TJ", "Tajikista\u014b" },
            { "TK", "Tokoloo" },
            { "tk", "Tirkmen" },
            { "TL", "Timor Leste" },
            { "TM", "Tirkmenista\u014b" },
            { "TN", "Tinisi" },
            { "TO", "Tonga" },
            { "to", "Tongan" },
            { "TR", "Tirki" },
            { "tr", "Tirk" },
            { "TT", "Tirinite ak Tobago" },
            { "tt", "Tatar" },
            { "TV", "Tuwalo" },
            { "TW", "Taywan" },
            { "TZ", "Ta\u014bsani" },
            { "Zzzz", "Mbind mu\u00f1 xamul" },
            { "UA", "Ikeren" },
            { "UG", "Ug\u00e0nda" },
            { "ug", "Uygur" },
            { "uk", "Ikreniye" },
            { "UM", "Duni Amerig Utar meer" },
            { "ur", "Urdu" },
            { "US", "Etaa Sini" },
            { "haw", "Hawaye" },
            { "UY", "Uruge" },
            { "UZ", "Usbekista\u014b" },
            { "uz", "Usbek" },
            { "tzm", "Tamasis gu Digg Atlaas" },
            { "VA", "Site bu Watikaa" },
            { "VC", "Sa\u014b Weesaa ak Garanadin" },
            { "VE", "Wenesiyela" },
            { "ve", "Wenda" },
            { "VG", "Duni Wirsin yu Br\u00ebtaa\u00f1" },
            { "VI", "Duni Wirsin yu Etaa-sini" },
            { "vi", "Wiyetnaamiye" },
            { "VN", "Wiyetnam" },
            { "quc", "Kishe" },
            { "VU", "Wanuatu" },
            { "syr", "Siryak" },
            { "WF", "Walis ak Futuna" },
            { "wo", "Wolof" },
            { "WS", "Samowa" },
            { "mni", "Manipuri" },
            { "Latn", metaValue_la },
            { "XK", "Kosowo" },
            { "Zxxx", "Lu\u00f1 bindul" },
            { "moh", "Mowak" },
            { "YE", "Yaman" },
            { "type.co.standard", "SSO (Toftalin wi\u00f1 g\u00ebn a xam)" },
            { "yi", "Yidis" },
            { "yo", "Yoruba" },
            { "YT", "Mayot" },
            { "ZA", "Afrik di Sid" },
            { "zh", "Sinuwaa" },
            { "ZM", "S\u00e0mbi" },
            { "ZW", "Simbabwe" },
            { "ZZ", "Gox bu\u00f1 xamul" },
            { "zh_Hans", "Sinuwaa bu\u00f1 woyofal" },
            { "kok", "Konkani" },
            { "hil", "Hiligaynon" },
            { "zh_Hant", "Sinuwaa bu cosaan" },
            { "sah", "Saxa" },
            { "sat", "Santali" },
            { "kru", "Kuruks" },
        };
        return data;
    }
}
