/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.J9ConstantHelper;
import com.ibm.j9ddr.vm29.j9.J9ROMFieldShapeIterator;
import com.ibm.j9ddr.vm29.j9.OptInfo;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.walkers.LineNumber;
import com.ibm.j9ddr.vm29.j9.walkers.LineNumberIterator;
import com.ibm.j9ddr.vm29.j9.walkers.LocalVariableTable;
import com.ibm.j9ddr.vm29.j9.walkers.LocalVariableTableIterator;
import com.ibm.j9ddr.vm29.pointer.FloatPointer;
import com.ibm.j9ddr.vm29.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9EnclosingObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ExceptionHandlerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ExceptionInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodDebugInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodParameterPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodParametersDataPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMConstantPoolItemPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodHandleRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodTypeRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMNameAndSignaturePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMSingleSlotConstantRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMStringRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SourceDebugExtensionPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodDebugInfoHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMFieldShapeHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9BCTranslationData;
import com.ibm.j9ddr.vm29.structure.J9CfrClassFile;
import com.ibm.j9ddr.vm29.structure.J9ConstantPool;
import com.ibm.j9ddr.vm29.structure.J9DescriptionBits;
import com.ibm.j9ddr.vm29.structure.J9FieldFlags;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9ROMMethodHandleRef;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.commands.ByteCodeDumper;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class J9BCUtil {
    private static final String nl = System.getProperty("line.separator");
    private static final int MODIFIERSOURCE_CLASS = 1;
    private static final int MODIFIERSOURCE_METHOD = 2;
    private static final int MODIFIERSOURCE_FIELD = 3;
    private static final int MODIFIERSOURCE_METHODPARAMETER = 4;
    private static final int ONLY_SPEC_MODIFIERS = 1;
    private static final int INCLUDE_INTERNAL_MODIFIERS = 2;
    public static int BCUtil_DumpAnnotations = 1;
    private static final long J9AccClassIsUnmodifiableBit = J9ConstantHelper.getLong(J9JavaAccessFlags.class, "J9AccClassIsUnmodifiable", 0L);

    public static void j9bcutil_dumpRomMethod(PrintStream out, J9ROMMethodPointer romMethod, J9ROMClassPointer romClass, long flags, int options) throws CorruptDataException {
        J9ROMNameAndSignaturePointer nameAndSignature = romMethod.nameAndSignature();
        J9UTF8Pointer name = nameAndSignature.name();
        J9UTF8Pointer signature = nameAndSignature.signature();
        J9ROMConstantPoolItemPointer constantPool = J9ROMClassHelper.constantPool(romClass);
        out.append("  Name: " + J9UTF8Helper.stringValue(name) + nl);
        out.append("  Signature: " + J9UTF8Helper.stringValue(signature) + nl);
        out.append(String.format("  Access Flags (%s): ", Long.toHexString(romMethod.modifiers().longValue())));
        J9BCUtil.dumpModifiers(out, romMethod.modifiers().longValue(), 2, 2);
        out.append(nl);
        out.append("  Max Stack: " + romMethod.maxStack().longValue() + nl);
        if (J9ROMMethodHelper.hasExceptionInfo(romMethod)) {
            long throwCount;
            J9ExceptionInfoPointer exceptionData = ROMHelp.J9_EXCEPTION_DATA_FROM_ROM_METHOD(romMethod);
            long catchCount = exceptionData.catchCount().longValue();
            if (catchCount > 0L) {
                J9ExceptionHandlerPointer handler = ROMHelp.J9EXCEPTIONINFO_HANDLERS(exceptionData);
                out.append(String.format("  Caught Exceptions (%d):", catchCount));
                out.append(nl);
                out.append("     start   end   handler   catch type" + nl);
                out.append("     -----   ---   -------   ----------" + nl);
                int i = 0;
                while ((long)i < catchCount) {
                    out.append(String.format("     %d  %d  %d   ", handler.startPC().longValue(), handler.endPC().longValue(), handler.handlerPC().longValue()));
                    long exceptionClassIndex = handler.exceptionClassIndex().longValue();
                    if (exceptionClassIndex != 0L) {
                        J9ROMConstantPoolItemPointer addOffset = constantPool.add(exceptionClassIndex);
                        J9ROMStringRefPointer romStringRefPointer = J9ROMStringRefPointer.cast(addOffset.longValue());
                        out.append(J9UTF8Helper.stringValue(romStringRefPointer.utf8Data()));
                    } else {
                        out.append("(any)");
                    }
                    out.append(nl);
                    handler = handler.add(1L);
                    ++i;
                }
            }
            if ((throwCount = exceptionData.throwCount().longValue()) > 0L) {
                out.append(String.format("  Thrown Exceptions (%d):", throwCount));
                out.append(nl);
                SelfRelativePointer currentThrowName = ROMHelp.J9EXCEPTIONINFO_THROWNAMES(exceptionData);
                for (long i = 0L; i < throwCount; ++i) {
                    J9UTF8Pointer currentName = J9UTF8Pointer.cast(currentThrowName.get());
                    out.append("    ");
                    out.append(J9UTF8Helper.stringValue(currentName));
                    out.append(nl);
                }
            }
        }
        if (romMethod.modifiers().anyBitsIn(J9CfrClassFile.CFR_ACC_NATIVE)) {
            J9BCUtil.dumpNative(out, romMethod, flags);
        } else {
            J9BCUtil.dumpBytecodes(out, romClass, romMethod, flags);
        }
        J9BCUtil.dumpMethodDebugInfo(out, romClass, romMethod, flags);
        J9BCUtil.dumpStackMapTable(out, romClass, romMethod, flags);
        J9BCUtil.dumpMethodParameters(out, romClass, romMethod, flags);
        if (0 != (BCUtil_DumpAnnotations & options)) {
            J9BCUtil.dumpMethodAnnotations(out, romMethod);
        }
        out.append(nl);
    }

    private static void dumpModifiers(PrintStream out, long modifiers, int modifierSrc, int modScope) {
        switch (modifierSrc) {
            case 1: {
                modifiers &= J9CfrClassFile.CFR_CLASS_ACCESS_MASK;
                break;
            }
            case 2: {
                if (1 == modScope) {
                    modifiers &= J9CfrClassFile.CFR_METHOD_ACCESS_MASK;
                    break;
                }
                modifiers &= J9CfrClassFile.CFR_METHOD_ACCESS_MASK | J9CfrClassFile.CFR_ACC_EMPTY_METHOD | J9CfrClassFile.CFR_ACC_FORWARDER_METHOD;
                break;
            }
            case 3: {
                if (1 == modScope) {
                    modifiers &= J9CfrClassFile.CFR_FIELD_ACCESS_MASK;
                    break;
                }
                modifiers &= J9CfrClassFile.CFR_FIELD_ACCESS_MASK | J9FieldFlags.J9FieldFlagConstant;
                break;
            }
            case 4: {
                if (1 == modScope) {
                    modifiers &= J9CfrClassFile.CFR_ATTRIBUTE_METHOD_PARAMETERS_MASK;
                    break;
                }
                modifiers &= J9CfrClassFile.CFR_ATTRIBUTE_METHOD_PARAMETERS_MASK;
                break;
            }
            default: {
                out.append("TYPE OF MODIFIER IS INVALID");
                return;
            }
        }
        if (2 == modScope) {
            if (2 == modifierSrc) {
                if ((modifiers & J9CfrClassFile.CFR_ACC_EMPTY_METHOD) != 0L) {
                    out.append("(empty) ");
                    modifiers &= J9CfrClassFile.CFR_ACC_EMPTY_METHOD ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if ((modifiers & J9CfrClassFile.CFR_ACC_FORWARDER_METHOD) != 0L) {
                    out.append("(forwarder) ");
                    modifiers &= J9CfrClassFile.CFR_ACC_FORWARDER_METHOD ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if ((modifiers & J9CfrClassFile.CFR_ACC_VTABLE) != 0L) {
                    out.append("(vtable) ");
                    modifiers &= J9CfrClassFile.CFR_ACC_VTABLE ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if ((modifiers & J9CfrClassFile.CFR_ACC_HAS_EXCEPTION_INFO) != 0L) {
                    out.append("(hasExceptionInfo) ");
                    modifiers &= J9CfrClassFile.CFR_ACC_HAS_EXCEPTION_INFO ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
            if (3 == modifierSrc && (modifiers & J9FieldFlags.J9FieldFlagConstant) != 0L) {
                out.append("(constant) ");
                modifiers &= J9FieldFlags.J9FieldFlagConstant ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (4 != modifierSrc) {
            if ((modifiers & J9CfrClassFile.CFR_PUBLIC_PRIVATE_PROTECTED_MASK) == 0L) {
                out.append("default ");
            } else {
                if ((modifiers & J9CfrClassFile.CFR_ACC_PUBLIC) != 0L) {
                    out.append("public ");
                    modifiers &= J9CfrClassFile.CFR_ACC_PUBLIC ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if ((modifiers & J9CfrClassFile.CFR_ACC_PROTECTED) != 0L) {
                    out.append("protected ");
                    modifiers &= J9CfrClassFile.CFR_ACC_PROTECTED ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if ((modifiers & J9CfrClassFile.CFR_ACC_PRIVATE) != 0L) {
                    out.append("private ");
                    modifiers &= J9CfrClassFile.CFR_ACC_PRIVATE ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
        }
        if ((modifiers & J9CfrClassFile.CFR_ACC_STATIC) != 0L) {
            out.append("static ");
            modifiers &= J9CfrClassFile.CFR_ACC_STATIC ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if ((modifiers & J9CfrClassFile.CFR_ACC_FINAL) != 0L) {
            out.append("final ");
            modifiers &= J9CfrClassFile.CFR_ACC_FINAL ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if ((modifiers & J9CfrClassFile.CFR_ACC_SYNTHETIC) != 0L) {
            out.append("synthetic ");
            modifiers &= J9CfrClassFile.CFR_ACC_SYNTHETIC ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (4 == modifierSrc && 0L != (modifiers & J9CfrClassFile.CFR_ACC_MANDATED)) {
            out.append("mandated");
            modifiers &= J9CfrClassFile.CFR_ACC_MANDATED ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (modifierSrc != 2) {
            if ((modifiers & J9CfrClassFile.CFR_ACC_ABSTRACT) != 0L) {
                out.append("abstract ");
                modifiers &= J9CfrClassFile.CFR_ACC_ABSTRACT ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((modifiers & J9CfrClassFile.CFR_ACC_ENUM) != 0L) {
                out.append("enum ");
                modifiers &= J9CfrClassFile.CFR_ACC_ENUM ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (modifierSrc == 1) {
            if ((modifiers & J9CfrClassFile.CFR_ACC_INTERFACE) != 0L) {
                out.append("interface ");
                modifiers &= J9CfrClassFile.CFR_ACC_INTERFACE ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((modifiers & J9CfrClassFile.CFR_ACC_SUPER) != 0L) {
                out.append("super ");
                modifiers &= J9CfrClassFile.CFR_ACC_SUPER ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((modifiers & J9CfrClassFile.CFR_ACC_ANNOTATION) != 0L) {
                out.append("annotation ");
                modifiers &= J9CfrClassFile.CFR_ACC_ANNOTATION ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (modifierSrc == 2) {
            if ((modifiers & J9CfrClassFile.CFR_ACC_SYNCHRONIZED) != 0L) {
                out.append("synchronized ");
                modifiers &= J9CfrClassFile.CFR_ACC_SYNCHRONIZED ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((modifiers & J9CfrClassFile.CFR_ACC_BRIDGE) != 0L) {
                out.append("bridge ");
                modifiers &= J9CfrClassFile.CFR_ACC_BRIDGE ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((modifiers & J9CfrClassFile.CFR_ACC_VARARGS) != 0L) {
                out.append("varargs ");
                modifiers &= J9CfrClassFile.CFR_ACC_VARARGS ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((modifiers & J9CfrClassFile.CFR_ACC_NATIVE) != 0L) {
                out.append("native ");
                modifiers &= J9CfrClassFile.CFR_ACC_NATIVE ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((modifiers & J9CfrClassFile.CFR_ACC_STRICT) != 0L) {
                out.append("strict ");
                modifiers &= J9CfrClassFile.CFR_ACC_STRICT ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (modifierSrc == 3) {
            if ((modifiers & J9CfrClassFile.CFR_ACC_VOLATILE) != 0L) {
                out.append("volatile ");
                modifiers &= J9CfrClassFile.CFR_ACC_VOLATILE ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((modifiers & J9CfrClassFile.CFR_ACC_TRANSIENT) != 0L) {
                out.append("transient ");
                modifiers &= J9CfrClassFile.CFR_ACC_TRANSIENT ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (modifiers != 0L) {
            out.append(String.format("unknown_flags = 0x%X", modifiers));
        }
    }

    private static void dumpNative(PrintStream out, J9ROMMethodPointer romMethod, long flags) throws CorruptDataException {
        U8Pointer bytecodes = J9ROMMethodHelper.bytecodes(romMethod);
        long argCount = bytecodes.at(0L).longValue();
        U8 returnType = bytecodes.at(1L);
        U8Pointer currentDescription = bytecodes.add(2L);
        String[] descriptions = new String[]{"void", "boolean", "byte", "char", "short", "float", "int", "double", "long", "object"};
        out.append(String.format("  Argument Count: %d", romMethod.argCount().longValue()));
        out.append(nl);
        out.append(String.format("  Temp Count: %d", romMethod.tempCount().longValue()));
        out.append(nl);
        out.append(String.format("  Native Argument Count: %d, types: (", argCount));
        for (long i = argCount; i > 0L; --i) {
            out.append(descriptions[currentDescription.at(0L).intValue()]);
            currentDescription = currentDescription.add(1L);
            if (i == 1L) continue;
            out.append(",");
        }
        out.append(String.format(") %s ", descriptions[returnType.intValue()]));
        out.append(nl);
    }

    private static void dumpBytecodes(PrintStream out, J9ROMClassPointer romClass, J9ROMMethodPointer romMethod, long flags) throws CorruptDataException {
        try {
            ByteCodeDumper.dumpBytecodes(out, romClass, romMethod, new U32(flags));
        }
        catch (Exception e) {
            throw new CorruptDataException(e);
        }
    }

    private static void dumpMethodDebugInfo(PrintStream out, J9ROMClassPointer romClass, J9ROMMethodPointer romMethod, long flags) throws CorruptDataException {
        J9MethodDebugInfoPointer methodInfo;
        if ((flags & J9BCTranslationData.BCT_StripDebugAttributes) == 0L && !(methodInfo = ROMHelp.getMethodDebugInfoFromROMMethod(romMethod)).isNull()) {
            out.append(nl);
            out.append("  Debug Info:");
            out.append(nl);
            out.append(String.format("    Line Number Table (%d):", J9MethodDebugInfoHelper.getLineNumberCount(methodInfo).intValue()));
            out.append(nl);
            LineNumberIterator lineNumberIterator = LineNumberIterator.lineNumberIteratorFor(methodInfo);
            while (lineNumberIterator.hasNext()) {
                LineNumber lineNumber = (LineNumber)lineNumberIterator.next();
                if (null == lineNumber) {
                    out.append("      Bad compressed data \n");
                    U8Pointer currentLineNumberPtr = lineNumberIterator.getLineNumberTablePtr();
                    int sizeLeft = J9MethodDebugInfoHelper.getLineNumberCompressedSize(methodInfo).sub(currentLineNumberPtr.sub(J9MethodDebugInfoHelper.getLineNumberTableForROMClass(methodInfo))).intValue();
                    while (0 < sizeLeft--) {
                        out.append("      " + currentLineNumberPtr.at(0L));
                        out.append(nl);
                        currentLineNumberPtr = currentLineNumberPtr.add(1L);
                    }
                    break;
                }
                out.append(String.format("      Line: %5d PC: %5d", lineNumber.getLineNumber().longValue(), lineNumber.getLocation().longValue()));
                out.append(nl);
            }
            out.append(nl);
            out.append(String.format("    Variables (%d):", methodInfo.varInfoCount().longValue()));
            out.append(nl);
            LocalVariableTableIterator variableInfoValuesIterator = LocalVariableTableIterator.localVariableTableIteratorFor(methodInfo);
            while (variableInfoValuesIterator.hasNext()) {
                LocalVariableTable values = (LocalVariableTable)variableInfoValuesIterator.next();
                out.append(String.format("      Slot: %d", values.getSlotNumber().intValue()));
                out.append(nl);
                out.append(String.format("      Visibility Start: %d", values.getStartVisibility().intValue()));
                out.append(nl);
                out.append(String.format("      Visibility End: %d", values.getStartVisibility().intValue() + values.getVisibilityLength().intValue()));
                out.append(nl);
                out.append(String.format("      Visibility Length: %d", values.getVisibilityLength().intValue()));
                out.append(nl);
                out.append("      Name: ");
                if (null != values.getName() && !values.getName().isNull()) {
                    out.append(String.format("%s", J9UTF8Helper.stringValue(values.getName())));
                } else {
                    out.append("None");
                }
                out.append(nl);
                out.append("      Signature: ");
                if (null != values.getSignature() && !values.getSignature().isNull()) {
                    out.append(String.format("%s", J9UTF8Helper.stringValue(values.getSignature())));
                } else {
                    out.append("None");
                }
                out.append(nl);
                out.append("      Generic Signature: ");
                if (null != values.getGenericSignature() && !values.getGenericSignature().isNull()) {
                    out.append(String.format("%s", J9UTF8Helper.stringValue(values.getGenericSignature())));
                } else {
                    out.append("None");
                }
                out.append(nl);
            }
        }
    }

    public static void j9bcutil_dumpRomClass(PrintStream out, J9ROMClassPointer romClass, long flags) throws CorruptDataException {
        long innerClassCount;
        J9UTF8Pointer outerClassName;
        out.append(String.format("ROM Size: 0x%s (%d)", Long.toHexString(romClass.romSize().longValue()), romClass.romSize().longValue()));
        out.append(nl);
        out.append(String.format("Class Name: %s", J9UTF8Helper.stringValue(romClass.className())));
        out.append(nl);
        if (romClass.superclassName().isNull()) {
            out.append("Superclass Name: <none>");
        } else {
            out.append(String.format("Superclass Name: %s", J9UTF8Helper.stringValue(romClass.superclassName())));
        }
        out.append(nl);
        J9BCUtil.dumpSourceFileName(out, romClass, flags);
        J9BCUtil.dumpSimpleName(out, romClass, flags);
        J9BCUtil.dumpGenericSignature(out, romClass, flags);
        J9BCUtil.dumpEnclosingMethod(out, romClass, flags);
        out.append(String.format("Basic Access Flags (0x%s): ", Long.toHexString(romClass.modifiers().longValue())));
        J9BCUtil.dumpModifiers(out, romClass.modifiers().longValue(), 1, 1);
        out.append(nl);
        out.append(String.format("J9 Access Flags (0x%s): ", Long.toHexString(romClass.extraModifiers().longValue())));
        J9BCUtil.dumpClassJ9ExtraModifiers(out, romClass.extraModifiers().longValue());
        out.append(nl);
        out.append(String.format("Class file version: %d.%d", romClass.majorVersion().longValue(), romClass.minorVersion().longValue()));
        out.append(nl);
        out.append(String.format("Instance Shape: 0x%s", Long.toHexString(romClass.instanceShape().longValue())));
        out.append(nl);
        out.append(String.format("Intermediate Class Data (%d bytes): %s", romClass.intermediateClassDataLength().longValue(), Long.toHexString(romClass.intermediateClassData().longValue())));
        out.append(nl);
        out.append(String.format("Maximum Branch Count: %d", romClass.maxBranchCount().longValue()));
        out.append(nl);
        out.append(String.format("Interfaces (%d):" + nl, romClass.interfaceCount().longValue()));
        if (!romClass.interfaceCount().eq(0L)) {
            SelfRelativePointer interfaces = romClass.interfaces();
            long interfaceCount = romClass.interfaceCount().longValue();
            int i = 0;
            while ((long)i < interfaceCount) {
                out.append("  ");
                J9UTF8Pointer interfaceName = J9UTF8Pointer.cast(interfaces.get());
                out.append(J9UTF8Helper.stringValue(interfaceName));
                out.append(nl);
                interfaces = interfaces.add(1L);
                ++i;
            }
        }
        if (!(outerClassName = romClass.outerClassName()).isNull()) {
            out.append("Declaring Class: " + J9UTF8Helper.stringValue(romClass.outerClassName()));
            out.append(nl);
            out.append(String.format("Member Access Flags (0x%s): ", Long.toHexString(romClass.memberAccessFlags().longValue())));
            J9BCUtil.dumpModifiers(out, romClass.memberAccessFlags().longValue(), 1, 1);
            out.append(nl);
            outerClassName = outerClassName.add(1L);
        }
        if ((innerClassCount = romClass.innerClassCount().longValue()) != 0L) {
            SelfRelativePointer innerClasses = romClass.innerClasses();
            out.append(String.format("Declared Classes (%d):" + nl, innerClassCount));
            int i = 0;
            while ((long)i < innerClassCount) {
                J9UTF8Pointer innerClassName = J9UTF8Pointer.cast(innerClasses.get());
                out.append("   " + J9UTF8Helper.stringValue(innerClassName));
                innerClasses = innerClasses.add(1L);
                ++i;
            }
        }
        if (J9ROMClassHelper.isSealed(romClass)) {
            int permittedSubclassCount = OptInfo.getPermittedSubclassCount(romClass);
            out.format("Permitted subclasses (%d):%n", permittedSubclassCount);
            for (int i = 0; i < permittedSubclassCount; ++i) {
                J9UTF8Pointer permittedSubclassName = OptInfo.getPermittedSubclassNameAtIndex(romClass, i);
                out.format("   %s%n", J9UTF8Helper.stringValue(permittedSubclassName));
            }
        }
        UDATA romFieldCount = romClass.romFieldCount();
        out.append(String.format("Fields (%d):" + nl, romFieldCount.longValue()));
        J9ROMFieldShapeIterator iterator = new J9ROMFieldShapeIterator(romClass.romFields(), romFieldCount);
        while (iterator.hasNext()) {
            J9ROMFieldShapePointer currentField = (J9ROMFieldShapePointer)iterator.next();
            if (!currentField.modifiers().bitAnd(J9JavaAccessFlags.J9AccStatic).eq(0L)) {
                J9BCUtil.dumpRomStaticField(out, currentField, flags);
            } else {
                J9BCUtil.dumpRomField(out, currentField, flags);
            }
            out.append(nl);
        }
        J9BCUtil.dumpCPShapeDescription(out, romClass, flags);
        long romMethodsCount = romClass.romMethodCount().longValue();
        out.append(String.format("Methods (%d):" + nl, romMethodsCount));
        J9ROMMethodPointer romMethod = romClass.romMethods();
        for (int i = 0; i < romClass.romMethodCount().intValue(); ++i) {
            J9BCUtil.j9bcutil_dumpRomMethod(out, romMethod, romClass, flags, 0);
            romMethod = ROMHelp.nextROMMethod(romMethod);
        }
        J9BCUtil.dumpSourceDebugExtension(out, romClass, flags);
        J9BCUtil.dumpAnnotationInfo(out, romClass, flags);
        J9BCUtil.dumpCallSiteData(out, romClass);
        J9BCUtil.dumpStaticSplitSideTable(out, romClass);
        J9BCUtil.dumpSpecialSplitSideTable(out, romClass);
    }

    private static void dumpCPShapeDescription(PrintStream out, J9ROMClassPointer romClass, long flags) throws CorruptDataException {
        U32Pointer cpDescription = J9ROMClassHelper.cpShapeDescription(romClass);
        char[] symbols = new char[]{'.', 'C', 'S', 'I', 'F', 'J', 'D', 'i', 's', 'v', 'x', 'y', 'z', 'T', 'H', 'A', '.', 'c', 'x', 'v'};
        symbols[(int)J9ConstantPool.J9CPTYPE_UNUSED8] = 46;
        long numberOfLongs = (romClass.romConstantPoolCount().longValue() + J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32 - 1L) / J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32;
        out.append("CP Shape Description:" + nl);
        long k = romClass.romConstantPoolCount().longValue();
        for (long i = 0L; i < numberOfLongs; ++i) {
            out.append("  ");
            long descriptionLong = cpDescription.at(i).longValue();
            for (long j = 0L; j < J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32 && k != 0L; ++j, --k) {
                out.append(String.format("%c ", Character.valueOf(symbols[(int)(descriptionLong & J9ConstantPool.J9_CP_DESCRIPTION_MASK)])));
                descriptionLong >>= (int)J9ConstantPool.J9_CP_BITS_PER_DESCRIPTION;
            }
            out.append(nl);
        }
        out.append(nl);
    }

    private static void dumpRomField(PrintStream out, J9ROMFieldShapePointer romField, long flags) throws CorruptDataException {
        out.append("  Name: " + J9UTF8Helper.stringValue(romField.nameAndSignature().name()) + nl);
        out.append("  Signature: " + J9UTF8Helper.stringValue(romField.nameAndSignature().signature()) + nl);
        out.append(String.format("  Access Flags (%s): ", Long.toHexString(romField.modifiers().longValue())));
        J9BCUtil.dumpModifiers(out, romField.modifiers().longValue(), 3, 1);
        out.append(nl);
    }

    private static void dumpRomStaticField(PrintStream out, J9ROMFieldShapePointer romStatic, long flags) throws CorruptDataException {
        out.append("  Name: " + J9UTF8Helper.stringValue(romStatic.nameAndSignature().name()) + nl);
        out.append("  Signature: " + J9UTF8Helper.stringValue(romStatic.nameAndSignature().signature()) + nl);
        out.append(String.format("  Access Flags (%s): ", Long.toHexString(romStatic.modifiers().longValue())));
        J9BCUtil.dumpModifiers(out, romStatic.modifiers().longValue(), 3, 1);
        out.append(nl);
    }

    private static void dumpClassJ9ExtraModifiers(PrintStream out, long accessFlags) {
        if ((accessFlags & J9CfrClassFile.CFR_ACC_REFERENCE_WEAK) != 0L) {
            out.append("(weak) ");
        }
        if ((accessFlags & J9CfrClassFile.CFR_ACC_REFERENCE_SOFT) != 0L) {
            out.append("(soft) ");
        }
        if ((accessFlags & J9CfrClassFile.CFR_ACC_REFERENCE_PHANTOM) != 0L) {
            out.append("(phantom) ");
        }
        if ((accessFlags & J9CfrClassFile.CFR_ACC_HAS_FINAL_FIELDS) != 0L) {
            out.append("(final fields) ");
        }
        if ((accessFlags & J9CfrClassFile.CFR_ACC_HAS_VERIFY_DATA) != 0L) {
            out.append("(preverified) ");
        }
        if ((accessFlags & J9JavaAccessFlags.J9AccClassAnonClass) != 0L) {
            out.append("(anonClass) ");
        }
        if ((accessFlags & J9AccClassIsUnmodifiableBit) != 0L) {
            out.append("(unmodifiable) ");
        }
        if ((accessFlags & J9JavaAccessFlags.J9AccRecord) != 0L) {
            out.append("(record) ");
        }
        if ((accessFlags & J9JavaAccessFlags.J9AccSealed) != 0L) {
            out.append("(sealed) ");
        }
    }

    private static void dumpEnclosingMethod(PrintStream out, J9ROMClassPointer romClass, long flags) throws CorruptDataException {
        J9EnclosingObjectPointer enclosingMethodForROMClass = OptInfo.getEnclosingMethodForROMClass(romClass);
        if (!enclosingMethodForROMClass.isNull()) {
            J9ROMConstantPoolItemPointer constantPool = ConstantPoolHelpers.J9_ROM_CP_FROM_ROM_CLASS(romClass);
            J9ROMClassRefPointer romClassRefPointer = J9ROMClassRefPointer.cast(constantPool);
            String className = romClassRefPointer.name().toString();
            J9ROMNameAndSignaturePointer nameAndSignature = enclosingMethodForROMClass.nameAndSignature();
            if (!nameAndSignature.isNull()) {
                out.append(String.format("Enclosing Method: %s%s%s", className, J9UTF8Helper.stringValue(nameAndSignature.name()), J9UTF8Helper.stringValue(nameAndSignature.signature())));
            } else {
                out.append(String.format("Enclosing Class: %s", className));
            }
        }
    }

    private static void dumpGenericSignature(PrintStream out, J9ROMClassPointer romClass, long flags) throws CorruptDataException {
        String simpleNameForROMClass = OptInfo.getGenericSignatureForROMClass(romClass);
        if (simpleNameForROMClass != null) {
            out.append(String.format("Generic Signature: %s", simpleNameForROMClass));
            out.append(nl);
        }
    }

    private static void dumpSimpleName(PrintStream out, J9ROMClassPointer romClass, long flags) throws CorruptDataException {
        String simpleNameForROMClass = OptInfo.getSimpleNameForROMClass(romClass);
        if (simpleNameForROMClass != null) {
            out.append(String.format("Simple Name: %s", simpleNameForROMClass));
            out.append(nl);
        }
    }

    private static void dumpSourceFileName(PrintStream out, J9ROMClassPointer romClass, long flags) throws CorruptDataException {
        String sourceFileNameForROMClass;
        if ((flags & J9BCTranslationData.BCT_StripDebugAttributes) == 0L && (sourceFileNameForROMClass = OptInfo.getSourceFileNameForROMClass(romClass)) != null) {
            out.append(String.format("Source File Name: %s", sourceFileNameForROMClass));
            out.append(nl);
        }
    }

    private static void dumpSourceDebugExtension(PrintStream out, J9ROMClassPointer romClass, long flags) throws CorruptDataException {
        UDATA temp;
        J9SourceDebugExtensionPointer sde;
        if (J9BuildFlags.opt_debugInfoServer && (flags & J9BCTranslationData.BCT_StripDebugAttributes) == 0L && !(sde = OptInfo.getSourceDebugExtensionForROMClass(romClass)).isNull() && !(temp = sde.size()).eq(0L)) {
            U8Pointer current = U8Pointer.cast(sde.add(1L));
            out.append(String.format("  Source debug extension (%d bytes):    ", temp.longValue()));
            out.append(nl);
            while (!temp.eq(0L)) {
                temp = temp.sub(1L);
                U8 c = current.at(0L);
                current = current.add(1L);
                if (c.eq(13L)) {
                    if (temp.eq(0L)) continue;
                    if (current.at(0L).eq(10L)) {
                        current = current.add(1L);
                    }
                    out.append(nl + "    ");
                    continue;
                }
                if (c.eq(10L)) {
                    out.append(nl + "    ");
                    continue;
                }
                out.append((char)c.intValue());
            }
        }
    }

    private static void dumpAnnotationInfo(PrintStream out, J9ROMClassPointer romClass, long flags) throws CorruptDataException {
        U32Pointer data;
        U32 length;
        U32Pointer classAnnotationData = OptInfo.getClassAnnotationsDataForROMClass(romClass);
        U32Pointer classTypeAnnotationData = OptInfo.getClassTypeAnnotationsDataForROMClass(romClass);
        out.append("  Annotation Info:" + nl);
        if (!classAnnotationData.isNull()) {
            length = classAnnotationData.at(0L);
            data = classAnnotationData.add(1L);
            out.append(String.format("    Class Annotations (%d bytes): %s" + nl, length.intValue(), data.getHexAddress()));
        }
        if (!classTypeAnnotationData.isNull()) {
            length = classTypeAnnotationData.at(0L);
            data = classTypeAnnotationData.add(1L);
            out.append(String.format("    Class Type Annotations (%d bytes): %s" + nl, length.intValue(), data.getHexAddress()));
        }
        J9ROMFieldShapeIterator iterator = new J9ROMFieldShapeIterator(romClass.romFields(), romClass.romFieldCount());
        out.append("    Field Annotations:" + nl);
        while (iterator.hasNext()) {
            U32Pointer data2;
            U32 length2;
            J9ROMFieldShapePointer currentField = (J9ROMFieldShapePointer)iterator.next();
            U32Pointer fieldAnnotationData = J9ROMFieldShapeHelper.getFieldAnnotationsDataFromROMField(currentField);
            U32Pointer fieldTypeAnnotationData = J9ROMFieldShapeHelper.getFieldTypeAnnotationsDataFromROMField(currentField);
            if (!fieldAnnotationData.isNull()) {
                length2 = fieldAnnotationData.at(0L);
                data2 = fieldAnnotationData.add(1L);
                out.append("     Name: " + J9UTF8Helper.stringValue(currentField.nameAndSignature().name()) + nl);
                out.append("     Signature: " + J9UTF8Helper.stringValue(currentField.nameAndSignature().signature()) + nl);
                out.append(String.format("      Annotations (%d bytes): %s" + nl, length2.intValue(), data2.getHexAddress()));
            }
            if (fieldTypeAnnotationData.isNull()) continue;
            length2 = fieldTypeAnnotationData.at(0L);
            data2 = fieldTypeAnnotationData.add(1L);
            out.append(String.format("      Type Annotations (%d bytes): %s" + nl, length2.intValue(), data2.getHexAddress()));
        }
        out.append(nl);
        J9ROMMethodPointer romMethod = romClass.romMethods();
        out.append("    Method Annotations:" + nl);
        for (int i = 0; i < romClass.romMethodCount().intValue(); ++i) {
            J9BCUtil.dumpMethodAnnotations(out, romMethod);
            romMethod = ROMHelp.nextROMMethod(romMethod);
        }
        out.append(nl);
    }

    private static void dumpMethodAnnotations(PrintStream out, J9ROMMethodPointer romMethod) throws CorruptDataException {
        U32Pointer data;
        U32 length;
        U32Pointer methodAnnotationData = ROMHelp.getMethodAnnotationsDataFromROMMethod(romMethod);
        U32Pointer parametersAnnotationData = ROMHelp.getParameterAnnotationsDataFromROMMethod(romMethod);
        U32Pointer defaultAnnotationData = ROMHelp.getDefaultAnnotationDataFromROMMethod(romMethod);
        U32Pointer methodTypeAnnotations = ROMHelp.getMethodTypeAnnotationDataFromROMMethod(romMethod);
        U32Pointer codeTypeAnnotations = ROMHelp.getCodeTypeAnnotationDataFromROMMethod(romMethod);
        if (!(methodAnnotationData.isNull() && parametersAnnotationData.isNull() && defaultAnnotationData.isNull())) {
            J9ROMNameAndSignaturePointer nameAndSignature = romMethod.nameAndSignature();
            J9UTF8Pointer name = nameAndSignature.name();
            J9UTF8Pointer signature = nameAndSignature.signature();
            out.append("      Name: " + J9UTF8Helper.stringValue(name) + nl);
            out.append("      Signature: " + J9UTF8Helper.stringValue(signature) + nl);
        }
        if (!methodAnnotationData.isNull()) {
            length = methodAnnotationData.at(0L);
            data = methodAnnotationData.add(1L);
            out.append(String.format("      Annotations (%d bytes): %s" + nl, length.intValue(), data.getHexAddress()));
        }
        if (!parametersAnnotationData.isNull()) {
            length = parametersAnnotationData.at(0L);
            data = parametersAnnotationData.add(1L);
            out.append(String.format("      Parameters Annotations (%d bytes): %s" + nl, length.intValue(), data.getHexAddress()));
        }
        if (!defaultAnnotationData.isNull()) {
            length = defaultAnnotationData.at(0L);
            data = defaultAnnotationData.add(1L);
            out.append(String.format("      Default Annotations (%d bytes): %s" + nl, length.intValue(), data.getHexAddress()));
        }
        if (!methodTypeAnnotations.isNull()) {
            length = methodTypeAnnotations.at(0L);
            data = methodTypeAnnotations.add(1L);
            out.append(String.format("      Method Type Annotations (%d bytes): %s" + nl, length.intValue(), data.getHexAddress()));
        }
        if (!codeTypeAnnotations.isNull()) {
            length = codeTypeAnnotations.at(0L);
            data = codeTypeAnnotations.add(1L);
            out.append(String.format("      Code Type Annotations (%d bytes): %s" + nl, length.intValue(), data.getHexAddress()));
        }
    }

    private static void dumpCallSiteData(PrintStream out, J9ROMClassPointer romClass) throws CorruptDataException {
        int HEX_RADIX = 16;
        long callSiteCount = romClass.callSiteCount().longValue();
        long bsmCount = romClass.bsmCount().longValue();
        SelfRelativePointer callSiteData = SelfRelativePointer.cast(romClass.callSiteData());
        U16Pointer bsmIndices = U16Pointer.cast(callSiteData.addOffset(4L * callSiteCount));
        if (0L != callSiteCount) {
            out.println(String.format("  Call Sites (%d):\n", callSiteCount));
            int i = 0;
            while ((long)i < callSiteCount) {
                J9ROMNameAndSignaturePointer nameAndSig = J9ROMNameAndSignaturePointer.cast(callSiteData.add(i).get());
                out.println("    Name: " + J9UTF8Helper.stringValue(nameAndSig.name()));
                out.println("    Signature: " + J9UTF8Helper.stringValue(nameAndSig.signature()));
                out.println("    Bootstrap Method Index: " + bsmIndices.at(i).longValue());
                out.println();
                ++i;
            }
        }
        if (0L != bsmCount) {
            J9ROMConstantPoolItemPointer constantPool = ConstantPoolHelpers.J9_ROM_CP_FROM_ROM_CLASS(romClass);
            U32Pointer cpShapeDescription = J9ROMClassHelper.cpShapeDescription(romClass);
            U16Pointer bsmDataCursor = bsmIndices.add(callSiteCount);
            out.println(String.format("  Bootstrap Methods (%d):", bsmCount));
            int i = 0;
            while ((long)i < bsmCount) {
                J9ROMMethodHandleRefPointer methodHandleRef = J9ROMMethodHandleRefPointer.cast(constantPool.add(bsmDataCursor.at(0L).longValue()));
                bsmDataCursor = bsmDataCursor.add(1L);
                J9ROMMethodRefPointer methodRef = J9ROMMethodRefPointer.cast(constantPool.add(methodHandleRef.methodOrFieldRefIndex().longValue()));
                J9ROMClassRefPointer classRef = J9ROMClassRefPointer.cast(constantPool.add(methodRef.classRefCPIndex().longValue()));
                J9ROMNameAndSignaturePointer nameAndSig = methodRef.nameAndSignature();
                long bsmArgumentCount = bsmDataCursor.at(0L).longValue();
                bsmDataCursor = bsmDataCursor.add(1L);
                out.println("    Name: " + J9UTF8Helper.stringValue(classRef.name()) + "." + J9UTF8Helper.stringValue(nameAndSig.name()));
                out.println("    Signature: " + J9UTF8Helper.stringValue(nameAndSig.signature()));
                out.println(String.format("    Bootstrap Method Arguments (%d):", bsmArgumentCount));
                while (0L != bsmArgumentCount) {
                    long argCPIndex = bsmDataCursor.at(0L).longValue();
                    bsmDataCursor = bsmDataCursor.add(1L);
                    J9ROMConstantPoolItemPointer item = constantPool.add(argCPIndex);
                    long shapeDesc = ConstantPoolHelpers.J9_CP_TYPE(cpShapeDescription, (int)argCPIndex);
                    if (shapeDesc == J9ConstantPool.J9CPTYPE_CLASS) {
                        J9ROMClassRefPointer romClassRef = J9ROMClassRefPointer.cast(item);
                        out.println("      Class: " + J9UTF8Helper.stringValue(romClassRef.name()));
                    } else if (shapeDesc == J9ConstantPool.J9CPTYPE_STRING) {
                        J9ROMStringRefPointer romStringRef = J9ROMStringRefPointer.cast(item);
                        out.println("      String: " + J9UTF8Helper.stringValue(romStringRef.utf8Data()));
                    } else if (shapeDesc == J9ConstantPool.J9CPTYPE_INT) {
                        J9ROMSingleSlotConstantRefPointer singleSlotConstantRef = J9ROMSingleSlotConstantRefPointer.cast(item);
                        out.println("      Int: " + singleSlotConstantRef.data().getHexValue());
                    } else if (shapeDesc == J9ConstantPool.J9CPTYPE_FLOAT) {
                        J9ROMSingleSlotConstantRefPointer singleSlotConstantRef = J9ROMSingleSlotConstantRefPointer.cast(item);
                        FloatPointer floatPtr = FloatPointer.cast(singleSlotConstantRef.dataEA());
                        out.println("      Float: " + floatPtr.getHexValue() + " (" + floatPtr.floatAt(0L) + ")");
                    } else if (shapeDesc == J9ConstantPool.J9CPTYPE_LONG) {
                        Object hexValue = "";
                        if (J9BuildFlags.env_littleEndian) {
                            hexValue = (String)hexValue + item.slot2().getHexValue();
                            hexValue = (String)hexValue + item.slot1().getHexValue().substring(2);
                        } else {
                            hexValue = (String)hexValue + item.slot1().getHexValue();
                            hexValue = (String)hexValue + item.slot2().getHexValue().substring(2);
                        }
                        long longValue = Long.parseLong(((String)hexValue).substring(2), HEX_RADIX);
                        out.println("      Long: " + (String)hexValue + "(" + longValue + ")");
                    } else if (shapeDesc == J9ConstantPool.J9CPTYPE_DOUBLE) {
                        Object hexValue = "";
                        if (J9BuildFlags.env_littleEndian) {
                            hexValue = (String)hexValue + item.slot2().getHexValue();
                            hexValue = (String)hexValue + item.slot1().getHexValue().substring(2);
                        } else {
                            hexValue = (String)hexValue + item.slot1().getHexValue();
                            hexValue = (String)hexValue + item.slot2().getHexValue().substring(2);
                        }
                        long longValue = Long.parseLong(((String)hexValue).substring(2), HEX_RADIX);
                        double doubleValue = Double.longBitsToDouble(longValue);
                        out.println("      Double: " + (String)hexValue + "(" + Double.toString(doubleValue) + ")");
                    } else if (shapeDesc == J9ConstantPool.J9CPTYPE_FIELD) {
                        J9ROMFieldRefPointer romFieldRef = J9ROMFieldRefPointer.cast(item);
                        classRef = J9ROMClassRefPointer.cast(constantPool.add(romFieldRef.classRefCPIndex()));
                        nameAndSig = romFieldRef.nameAndSignature();
                        out.println("      Field: " + J9UTF8Helper.stringValue(classRef.name()) + "." + J9UTF8Helper.stringValue(nameAndSig.name()) + " " + J9UTF8Helper.stringValue(nameAndSig.signature()));
                    } else if (shapeDesc == J9ConstantPool.J9CPTYPE_INSTANCE_METHOD || shapeDesc == J9ConstantPool.J9CPTYPE_STATIC_METHOD || shapeDesc == J9ConstantPool.J9CPTYPE_HANDLE_METHOD || shapeDesc == J9ConstantPool.J9CPTYPE_INTERFACE_METHOD) {
                        J9ROMMethodRefPointer romMethodRef = J9ROMMethodRefPointer.cast(item);
                        classRef = J9ROMClassRefPointer.cast(constantPool.add(romMethodRef.classRefCPIndex()));
                        nameAndSig = romMethodRef.nameAndSignature();
                        out.println("      Method: " + J9UTF8Helper.stringValue(classRef.name()) + "." + J9UTF8Helper.stringValue(nameAndSig.name()) + " " + J9UTF8Helper.stringValue(nameAndSig.signature()));
                    } else if (shapeDesc == J9ConstantPool.J9CPTYPE_METHOD_TYPE) {
                        J9ROMMethodTypeRefPointer romMethodTypeRef = J9ROMMethodTypeRefPointer.cast(item);
                        out.println("      Method Type: " + J9UTF8Helper.stringValue(J9UTF8Pointer.cast(romMethodTypeRef.signature())));
                    } else if (shapeDesc == J9ConstantPool.J9CPTYPE_METHODHANDLE) {
                        methodHandleRef = J9ROMMethodHandleRefPointer.cast(item);
                        methodRef = J9ROMMethodRefPointer.cast(constantPool.add(methodHandleRef.methodOrFieldRefIndex()));
                        classRef = J9ROMClassRefPointer.cast(constantPool.add(methodRef.classRefCPIndex()));
                        nameAndSig = methodRef.nameAndSignature();
                        out.print("      Method Handle: " + J9UTF8Helper.stringValue(classRef.name()) + "." + J9UTF8Helper.stringValue(nameAndSig.name()));
                        long methodType = methodHandleRef.handleTypeAndCpType().rightShift((int)J9DescriptionBits.J9DescriptionCpTypeShift).longValue();
                        if (methodType == J9ROMMethodHandleRef.MH_REF_GETFIELD || methodType == J9ROMMethodHandleRef.MH_REF_PUTFIELD || methodType == J9ROMMethodHandleRef.MH_REF_GETSTATIC || methodType == J9ROMMethodHandleRef.MH_REF_PUTSTATIC) {
                            out.print(" ");
                        }
                        out.println(J9UTF8Helper.stringValue(nameAndSig.signature()));
                    } else {
                        out.println("      <unknown type>");
                    }
                    --bsmArgumentCount;
                }
                ++i;
            }
        }
    }

    private static void dumpStaticSplitSideTable(PrintStream out, J9ROMClassPointer romClass) throws CorruptDataException {
        int splitTableCount = romClass.staticSplitMethodRefCount().intValue();
        if (splitTableCount > 0) {
            out.println(String.format("Static Split Table (%d):\n", splitTableCount));
            out.println("    SplitTable Index -> CP Index");
            U16Pointer cursor = romClass.staticSplitMethodRefIndexes();
            for (int i = 0; i < splitTableCount; ++i) {
                cursor.add(i);
                out.println(String.format("    %16d -> %d", i, cursor.at(i).intValue()));
            }
        }
    }

    private static void dumpSpecialSplitSideTable(PrintStream out, J9ROMClassPointer romClass) throws CorruptDataException {
        int splitTableCount = romClass.specialSplitMethodRefCount().intValue();
        if (splitTableCount > 0) {
            out.println(String.format("Special Split Table (%d):\n", splitTableCount));
            out.println("    SplitTable Index -> CP Index");
            U16Pointer cursor = romClass.specialSplitMethodRefIndexes();
            for (int i = 0; i < splitTableCount; ++i) {
                cursor.add(i);
                out.println(String.format("    %16d -> %d", i, cursor.at(i).intValue()));
            }
        }
    }

    private static void dumpStackMapTable(PrintStream out, J9ROMClassPointer romclass, J9ROMMethodPointer romMethod, long flags) throws CorruptDataException {
        U32Pointer stackMapMethod = ROMHelp.getStackMapFromROMMethod(romMethod);
        long mapPC = -1L;
        if (stackMapMethod.notNull()) {
            U8Pointer stackMapData = U8Pointer.cast(stackMapMethod.add(1L));
            U16 stackMapCount = new U16(stackMapData.at(0L)).leftShift(8).bitOr(stackMapData.at(1L));
            stackMapData = stackMapData.add(2L);
            out.println("\n  StackMapTable\n    Stackmaps(" + stackMapCount.intValue() + "):");
            for (int i = 0; i < stackMapCount.intValue(); ++i) {
                long offset;
                ++mapPC;
                long mapType = stackMapData.at(0L).longValue();
                stackMapData = stackMapData.add(1L);
                if (mapType < 64L) {
                    out.println("      pc: " + (mapPC += mapType) + " same");
                    continue;
                }
                if (mapType < 128L) {
                    out.print("      pc: " + (mapPC += mapType - 64L) + " same_locals_1_stack_item: ");
                    stackMapData = J9BCUtil.dumpStackMapSlots(out, romclass, stackMapData, 1L);
                    out.println();
                    continue;
                }
                if (mapType < 247L) {
                    out.println("      UNKNOWN FRAME TAG: (" + mapType + ")\n");
                    continue;
                }
                if (mapType == 247L) {
                    offset = new U16(stackMapData.at(0L)).leftShift(8).add(stackMapData.at(1L)).longValue();
                    stackMapData = stackMapData.add(2L);
                    out.print("      pc: " + (mapPC += offset) + " same_locals_1_stack_item_extended: ");
                    stackMapData = J9BCUtil.dumpStackMapSlots(out, romclass, stackMapData, 1L);
                    out.println();
                    continue;
                }
                if (mapType < 251L) {
                    offset = new U16(stackMapData.at(0L)).leftShift(8).add(stackMapData.at(1L)).longValue();
                    stackMapData = stackMapData.add(2L);
                    out.println("      pc: " + (mapPC += offset) + " chop " + (251L - mapType));
                    continue;
                }
                if (mapType == 251L) {
                    offset = new U16(stackMapData.at(0L)).leftShift(8).add(stackMapData.at(1L)).longValue();
                    stackMapData = stackMapData.add(2L);
                    out.println("      pc: " + (mapPC += offset) + " same_extended\n");
                    continue;
                }
                if (mapType < 255L) {
                    offset = new U16(stackMapData.at(0L)).leftShift(8).add(stackMapData.at(1L)).longValue();
                    stackMapData = stackMapData.add(2L);
                    out.print("      pc: " + (mapPC += offset) + " append: ");
                    stackMapData = J9BCUtil.dumpStackMapSlots(out, romclass, stackMapData, mapType - 251L);
                    out.println();
                    continue;
                }
                if (mapType != 255L) continue;
                offset = new U16(stackMapData.at(0L)).leftShift(8).add(stackMapData.at(1L)).longValue();
                stackMapData = stackMapData.add(2L);
                out.print("      pc: " + (mapPC += offset) + " full, local(s): ");
                offset = new U16(stackMapData.at(0L)).leftShift(8).add(stackMapData.at(1L)).longValue();
                stackMapData = stackMapData.add(2L);
                stackMapData = J9BCUtil.dumpStackMapSlots(out, romclass, stackMapData, offset);
                out.print(", stack: ");
                offset = new U16(stackMapData.at(0L)).leftShift(8).add(stackMapData.at(1L)).longValue();
                stackMapData = stackMapData.add(2L);
                stackMapData = J9BCUtil.dumpStackMapSlots(out, romclass, stackMapData, offset);
                out.println();
            }
        }
    }

    private static void dumpMethodParameters(PrintStream out, J9ROMClassPointer romclass, J9ROMMethodPointer romMethod, long flags) throws CorruptDataException {
        J9MethodParametersDataPointer methodParameters = ROMHelp.getMethodParametersFromROMMethod(romMethod);
        if (methodParameters != J9MethodParametersDataPointer.NULL) {
            J9MethodParameterPointer parameters = methodParameters.parameters();
            out.println(String.format("  Method Parameters (%d):\n", methodParameters.parameterCount().longValue()));
            int i = 0;
            while ((long)i < methodParameters.parameterCount().longValue()) {
                J9UTF8Pointer name = J9UTF8Pointer.cast(parameters.nameEA().get());
                long parameterFlags = parameters.flags().longValue();
                if (name.isNull()) {
                    out.print("    <no name>");
                } else {
                    out.print("    " + J9UTF8Helper.stringValue(name));
                }
                out.print(String.format("    0x%x ( ", parameterFlags));
                J9BCUtil.dumpModifiers(out, parameterFlags, 1, 4);
                out.println(" )\n");
                ++i;
            }
            out.println("\n");
        }
    }

    static U8Pointer dumpStackMapSlots(PrintStream out, J9ROMClassPointer classfile, U8Pointer slotData, long slotCount) throws CorruptDataException {
        String[] slotTypes = new String[]{"top", "int", "float", "double", "long", "null", "uninitialized_this"};
        String[] primitiveArrayTypes = new String[]{"I", "F", "D", "J", "S", "B", "C", "Z"};
        out.print("(");
        int i = 0;
        while ((long)i < slotCount) {
            int slotType = slotData.at(0L).intValue();
            slotData = slotData.add(1L);
            if (slotType <= 6) {
                out.print(slotTypes[slotType]);
            } else if (slotType == 7) {
                long index = new U16(slotData.at(0L)).leftShift(8).add(slotData.at(1L)).longValue();
                J9ROMConstantPoolItemPointer constantPool = ConstantPoolHelpers.J9_ROM_CP_FROM_ROM_CLASS(classfile);
                J9ROMStringRefPointer item = J9ROMStringRefPointer.cast(constantPool.add(index));
                J9UTF8Pointer data = item.utf8Data();
                String s = J9UTF8Helper.stringValue(data);
                if (s.charAt(0) != '[') {
                    out.print("L");
                }
                out.print(s);
                slotData = slotData.add(2L);
            } else if (slotType == 8) {
                long index = new U16(slotData.at(0L)).leftShift(8).add(slotData.at(1L)).longValue();
                out.print("this pc:" + index);
                slotData = slotData.add(2L);
            } else {
                StringBuffer primitiveType = new StringBuffer("[");
                long index = new U16(slotData.at(0L)).leftShift(8).add(slotData.at(1L)).longValue();
                while (index-- > 0L) {
                    primitiveType.append("[");
                }
                primitiveType.append(primitiveArrayTypes[slotType - 9]);
                out.print(primitiveType.toString());
                slotData = slotData.add(2L);
            }
            if ((long)i != slotCount - 1L) {
                out.print(", ");
            }
            ++i;
        }
        out.print(")");
        return slotData;
    }
}

