/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U64Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.pointer.helper.ValueTypeHelper;
import com.ibm.j9ddr.vm29.structure.J9FieldFlags;
import com.ibm.j9ddr.vm29.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;

public class PrintObjectFieldsHelper {
    private static ValueTypeHelper valueTypeHelper = ValueTypeHelper.getValueTypeHelper();
    private static final String PADDING = "\t";

    public static void printJ9ObjectFields(PrintStream out, int tabLevel, J9ClassPointer localClazz, U8Pointer dataStart, J9ObjectPointer localObject, long address) throws CorruptDataException {
        PrintObjectFieldsHelper.printJ9ObjectFields(out, tabLevel, localClazz, dataStart, localObject, address, null, false);
    }

    public static void printJ9ObjectFields(PrintStream out, int tabLevel, J9ClassPointer localClazz, U8Pointer dataStart, J9ObjectPointer localObject, long address, String[] nestingHierarchy, boolean showNestedFields) throws CorruptDataException {
        long superclassIndex;
        long depth;
        U32 flags;
        boolean showObjectHeader;
        J9ClassPointer previousSuperclass = J9ClassPointer.NULL;
        boolean lockwordPrinted = false;
        UDATA nestedFieldOffset = new UDATA(0L);
        boolean flatObject = false;
        J9ClassPointer[] nestedClassHierarchy = null;
        boolean bl = showObjectHeader = tabLevel <= 1;
        if (null != nestingHierarchy && nestingHierarchy.length > 0) {
            flatObject = true;
        }
        if (flatObject) {
            nestedClassHierarchy = valueTypeHelper.findNestedClassHierarchy(localClazz, nestingHierarchy);
            J9ClassPointer clazz = null;
            flags = new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_HIDDEN);
            for (int i = 0; i < nestedClassHierarchy.length - 1; ++i) {
                clazz = nestedClassHierarchy[i];
                depth = J9ClassHelper.classDepth(clazz).longValue();
                boolean found = false;
                if (J9ClassHelper.isArrayClass(clazz)) {
                    int index = Integer.parseInt(nestingHierarchy[0].substring(1, nestingHierarchy[0].length() - 1));
                    int stride = J9ArrayClassPointer.cast(clazz).flattenedElementSize().intValue();
                    dataStart = dataStart.add(index * stride);
                    continue;
                }
                for (superclassIndex = 0L; superclassIndex <= depth && !found; ++superclassIndex) {
                    J9ClassPointer superclass = superclassIndex == depth ? clazz : J9ClassPointer.cast(clazz.superclasses().at(superclassIndex));
                    Iterator<J9ObjectFieldOffset> iterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(superclass.romClass(), clazz, previousSuperclass, flags);
                    while (iterator.hasNext()) {
                        J9ObjectFieldOffset result = iterator.next();
                        if (!result.getName().equals(nestingHierarchy[i])) continue;
                        nestedFieldOffset = nestedFieldOffset.add(result.getOffsetOrAddress());
                        found = true;
                        break;
                    }
                    previousSuperclass = superclass;
                }
            }
            localClazz = nestedClassHierarchy[nestedClassHierarchy.length - 1];
            dataStart = dataStart.add(nestedFieldOffset);
            previousSuperclass = J9ClassPointer.NULL;
        }
        if (showObjectHeader) {
            if (flatObject) {
                PrintObjectFieldsHelper.padding(out, tabLevel);
                out.format("// EA = %s, offset in top level container = %d;%n", dataStart.getHexAddress(), nestedFieldOffset.add(ObjectModel.getHeaderSize(localObject)).intValue());
            }
            J9UTF8Pointer classNameUTF = localClazz.romClass().className();
            PrintObjectFieldsHelper.padding(out, tabLevel);
            out.format("struct J9Class* clazz = !j9class 0x%X // %s%n", localClazz.getAddress(), J9UTF8Helper.stringValue(classNameUTF));
            PrintObjectFieldsHelper.padding(out, tabLevel);
            out.format("Object flags = %s;%n", J9ObjectHelper.flags(localObject).getHexValue());
        }
        depth = J9ClassHelper.classDepth(localClazz).longValue();
        for (superclassIndex = 0L; superclassIndex <= depth; ++superclassIndex) {
            J9ClassPointer superclass = superclassIndex == depth ? localClazz : J9ClassPointer.cast(localClazz.superclasses().at(superclassIndex));
            flags = new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_HIDDEN);
            Iterator<J9ObjectFieldOffset> iterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(superclass.romClass(), localClazz, previousSuperclass, flags);
            while (iterator.hasNext()) {
                boolean isLockword;
                J9ObjectFieldOffset result = iterator.next();
                boolean printField = true;
                boolean isHiddenField = result.isHidden();
                boolean bl2 = isLockword = isHiddenField && result.getOffsetOrAddress().add(J9ObjectHelper.headerSize()).eq(superclass.lockOffset());
                if (isLockword) {
                    boolean bl3 = printField = !lockwordPrinted && localClazz.lockOffset().eq(superclass.lockOffset());
                    if (printField) {
                        lockwordPrinted = true;
                    }
                }
                if (!printField) continue;
                if (showNestedFields) {
                    J9ClassPointer containerClazz = null;
                    if (null == nestedClassHierarchy) {
                        containerClazz = localClazz;
                    } else {
                        int containerClassIndex = Pattern.matches("\\[\\d+\\]", nestingHierarchy[0]) ? 1 : 0;
                        containerClazz = nestedClassHierarchy[containerClassIndex];
                    }
                    PrintObjectFieldsHelper.printNestedObjectField(out, tabLevel, localClazz, dataStart, superclass, result, address, nestingHierarchy, containerClazz);
                } else {
                    PrintObjectFieldsHelper.printObjectField(out, tabLevel, localClazz, dataStart, superclass, result, address, nestingHierarchy);
                }
                out.println();
            }
            previousSuperclass = superclass;
        }
    }

    private static void printObjectField(PrintStream out, int tabLevel, J9ClassPointer localClazz, U8Pointer dataStart, J9ClassPointer fromClass, J9ObjectFieldOffset objectFieldOffset, long address, String[] nestingHierarchy) throws CorruptDataException {
        J9ROMFieldShapePointer fieldShape = objectFieldOffset.getField();
        UDATA fieldOffset = objectFieldOffset.getOffsetOrAddress();
        boolean isHiddenField = objectFieldOffset.isHidden();
        boolean containerIsFlatObject = nestingHierarchy != null && nestingHierarchy.length > 0;
        String className = J9ClassHelper.getName(fromClass);
        String fieldName = J9UTF8Helper.stringValue(fieldShape.nameAndSignature().name());
        String fieldSignature = J9UTF8Helper.stringValue(fieldShape.nameAndSignature().signature());
        boolean fieldIsFlattened = valueTypeHelper.isFieldInClassFlattened(localClazz, fieldName);
        U8Pointer valuePtr = dataStart.add(fieldOffset);
        PrintObjectFieldsHelper.padding(out, tabLevel);
        out.format("%s %s = ", fieldSignature, fieldName);
        if (fieldShape.modifiers().anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
            out.print(U64Pointer.cast(valuePtr).at(0L).getHexValue());
        } else if (fieldShape.modifiers().anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
            if (fieldIsFlattened) {
                J9ObjectPointer object = J9ObjectPointer.cast(address);
                StringBuilder hierarchy = new StringBuilder("");
                if (containerIsFlatObject) {
                    for (int i = 0; i < nestingHierarchy.length; ++i) {
                        hierarchy.append(nestingHierarchy[i]);
                        hierarchy.append(".");
                    }
                }
                hierarchy.append(fieldName);
                out.format("!j9object 0x%x %s", object.getAddress(), hierarchy);
            } else {
                UDATAPointer ptr = J9ObjectHelper.compressObjectReferences ? U32Pointer.cast(valuePtr) : UDATAPointer.cast(valuePtr);
                out.format("!fj9object 0x%x", ((AbstractPointer)ptr).at(0L).longValue());
            }
        } else {
            out.print(I32Pointer.cast(valuePtr).at(0L).getHexValue());
        }
        if (fieldIsFlattened) {
            out.format(" (offset = %d) (%s)", fieldOffset.longValue(), fieldSignature.substring(1, fieldSignature.length() - 1));
        } else {
            out.format(" (offset = %d) (%s)", fieldOffset.longValue(), className);
        }
        if (isHiddenField) {
            out.print(" <hidden>");
        }
    }

    private static void printNestedObjectField(PrintStream out, int tabLevel, J9ClassPointer localClazz, U8Pointer dataStart, J9ClassPointer fromClass, J9ObjectFieldOffset objectFieldOffset, long address, String[] nestingHierarchy, J9ClassPointer containerClazz) throws CorruptDataException {
        J9ROMFieldShapePointer fieldShape = objectFieldOffset.getField();
        UDATA fieldOffset = objectFieldOffset.getOffsetOrAddress();
        boolean isHiddenField = objectFieldOffset.isHidden();
        String fieldName = J9UTF8Helper.stringValue(fieldShape.nameAndSignature().name());
        String fieldSignature = J9UTF8Helper.stringValue(fieldShape.nameAndSignature().signature());
        boolean fieldIsFlattened = valueTypeHelper.isFieldInClassFlattened(localClazz, fieldName);
        U8Pointer valuePtr = dataStart.add(fieldOffset);
        PrintObjectFieldsHelper.padding(out, tabLevel);
        if (fieldIsFlattened) {
            out.format("%s %s { // EA = %s (offset = %d)%n", fieldSignature.substring(1, fieldSignature.length() - 1), fieldName, valuePtr.getHexAddress(), fieldOffset.longValue());
        } else {
            out.format("%s %s = ", fieldSignature, fieldName);
        }
        if (fieldShape.modifiers().anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
            out.print(U64Pointer.cast(valuePtr).at(0L).getHexValue());
        } else if (fieldShape.modifiers().anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
            if (fieldIsFlattened) {
                String[] newNestingHierarchy = null;
                if (nestingHierarchy == null) {
                    newNestingHierarchy = new String[]{fieldName};
                } else {
                    newNestingHierarchy = Arrays.copyOf(nestingHierarchy, nestingHierarchy.length + 1);
                    newNestingHierarchy[nestingHierarchy.length] = fieldName;
                }
                J9ObjectPointer obj = J9ObjectPointer.cast(address);
                dataStart = U8Pointer.cast(obj).add(ObjectModel.getHeaderSize(obj));
                PrintObjectFieldsHelper.printJ9ObjectFields(out, tabLevel + 1, containerClazz, dataStart, null, address, newNestingHierarchy, true);
            } else {
                UDATAPointer ptr = J9ObjectHelper.compressObjectReferences ? U32Pointer.cast(valuePtr) : UDATAPointer.cast(valuePtr);
                out.format("!fj9object 0x%x%n", ((AbstractPointer)ptr).at(0L).longValue());
            }
        } else {
            out.print(I32Pointer.cast(valuePtr).at(0L).getHexValue());
        }
        if (fieldIsFlattened) {
            PrintObjectFieldsHelper.padding(out, tabLevel);
            out.print("}");
        }
        if (isHiddenField) {
            out.print(" <hidden>");
        }
    }

    public static void padding(PrintStream out, int level) {
        for (int i = 0; i < level; ++i) {
            out.print(PADDING);
        }
    }
}

