/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractive;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.commands.SnapBaseCommand;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class SnapTraceCommand
extends SnapBaseCommand {
    private String fileName = null;

    public SnapTraceCommand() {
        this.addCommand("snaptrace", "<filename>", "extract trace buffers to a file");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length > 0) {
            this.fileName = args[0];
        } else {
            this.fileName = DDRInteractive.getPath();
            if (this.fileName == null) {
                this.fileName = "snap.trc";
            } else {
                File coreFile = new File(this.fileName);
                this.fileName = coreFile.getParentFile().getPath() + File.separator + "Snap." + coreFile.getName() + ".trc";
            }
        }
        out.println("Writing snap trace to: " + this.fileName);
        this.extractTraceData(context, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeBytesToTrace(Context context, long address, int bufferSize, PrintStream out) {
        if (this.fileName != null) {
            File snapfile = new File(this.fileName);
            byte[] data = new byte[bufferSize];
            try {
                context.process.getBytesAt(address, data);
            }
            catch (CorruptDataException e) {
                out.println("Problem reading " + bufferSize + " bytes from 0x" + Long.toHexString(address) + ". Trace file may contain partial or damaged data.");
            }
            FileOutputStream fOut = null;
            try {
                fOut = new FileOutputStream(snapfile, true);
                fOut.write(data);
            }
            catch (FileNotFoundException e) {
                out.println("FileNotFound " + this.fileName);
            }
            catch (IOException e) {
                out.println("IO Error writing to file " + this.fileName);
            }
            finally {
                if (fOut != null) {
                    try {
                        fOut.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    @Override
    public String getCStringAtAddress(IProcess process, long address) throws CorruptDataException {
        return this.getCStringAtAddress(process, address, Long.MAX_VALUE);
    }

    @Override
    public String getCStringAtAddress(IProcess process, long address, long maxLength) throws CorruptDataException {
        int length = 0;
        while (0 != process.getByteAt(address + (long)length) && (long)length < maxLength) {
            ++length;
        }
        byte[] buffer = new byte[length];
        process.getBytesAt(address, buffer);
        try {
            return new String(buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeHeaderBytesToTrace(Context context, byte[] headerBytes, PrintStream out) {
        if (this.fileName != null) {
            File snapfile = new File(this.fileName);
            FileOutputStream fOut = null;
            try {
                fOut = new FileOutputStream(snapfile, true);
                fOut.write(headerBytes);
            }
            catch (FileNotFoundException e) {
                out.println("FileNotFound " + this.fileName);
            }
            catch (IOException e) {
                out.println("IO Error writing to file " + this.fileName);
            }
            finally {
                if (fOut != null) {
                    try {
                        fOut.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

