/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.ICommand;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public abstract class Command
implements ICommand {
    protected static final String nl = System.getProperty("line.separator");
    private HashMap<String, CommandDescription> _commandNames = new HashMap();

    public CommandDescription addCommand(String name, String argDescription, String helpDescription) {
        CommandDescription description = new CommandDescription(name, argDescription, helpDescription);
        this._commandNames.put(name, description);
        return description;
    }

    public void addSubCommand(CommandDescription command, String name, String argDescription, String helpDescription) {
        command.addSubCommand(name, argDescription, helpDescription);
    }

    @Override
    public boolean recognises(String command, Context context) {
        if (command.charAt(0) == '!') {
            command = command.substring(1);
        }
        Iterator<String> iterator = this._commandNames.keySet().iterator();
        while (iterator.hasNext()) {
            if (!command.equalsIgnoreCase(iterator.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> getCommandDescriptions() {
        Object desc = new String();
        for (CommandDescription cmd : this._commandNames.values()) {
            desc = (String)desc + String.format("%-25s %-20s %s\n", cmd.commandName, cmd.argumentDescription, cmd.helpDescription);
        }
        return Collections.singleton(desc);
    }

    public Set<String> getCommandNames() {
        return this._commandNames.keySet();
    }

    public void printDetailedHelp(PrintStream out) {
        for (CommandDescription cmd : this._commandNames.values()) {
            out.println(cmd.getCommandName() + "\t" + cmd.getArgumentDescription() + "\t\t" + cmd.helpDescription);
            for (CommandDescription subcmd : cmd._subCommandNames.values()) {
                out.println("\t" + subcmd.getCommandName() + "\t" + subcmd.getArgumentDescription() + "\t\t" + subcmd.helpDescription);
            }
        }
    }

    protected long dbgFindPatternInRange(Context context, byte[] pattern, int patternAlignment, long startSearchFrom, BigInteger bytesToSearch) throws MemoryFault {
        long page = startSearchFrom;
        BigInteger startSearchFrom2 = new BigInteger(Long.toBinaryString(startSearchFrom), 2);
        BigInteger udataMax = context.process.bytesPerPointer() == 4 ? CommandUtils.UDATA_MAX_32BIT : CommandUtils.UDATA_MAX_64BIT;
        if (startSearchFrom2.add(bytesToSearch).compareTo(udataMax) == 1) {
            bytesToSearch = udataMax.subtract(startSearchFrom2);
        }
        while ((page & 0xFFFL) != 0L) {
            --page;
            bytesToSearch = bytesToSearch.add(BigInteger.ONE);
        }
        BigInteger bytesSearched = BigInteger.ZERO;
        while (true) {
            byte[] data = new byte[4096];
            try {
                int bytesRead = context.process.getBytesAt(page, data);
                bytesSearched = bytesSearched.add(new BigInteger(Integer.toString(bytesRead)));
                for (int i = 0; i < bytesRead - pattern.length; i += patternAlignment) {
                    if (!this.compare(data, pattern, i) || page + (long)i < startSearchFrom) continue;
                    return page + (long)i;
                }
            }
            catch (MemoryFault memoryFault) {
                // empty catch block
            }
            if (bytesToSearch.compareTo(new BigInteger("4096")) == -1) break;
            page += 4096L;
            bytesToSearch = bytesToSearch.subtract(new BigInteger("4096"));
        }
        return 0L;
    }

    private boolean compare(byte[] data, byte[] pattern, int dataStart) {
        for (int i = 0; i < pattern.length; ++i) {
            if (data[dataStart + i] == pattern[i]) continue;
            return false;
        }
        return true;
    }

    protected class CommandDescription {
        private String commandName;
        private String argumentDescription;
        private String helpDescription;
        private HashMap<String, CommandDescription> _subCommandNames = new HashMap();

        public CommandDescription(String name, String argDescription, String help) {
            this.commandName = name;
            this.argumentDescription = argDescription;
            this.helpDescription = help;
        }

        public void addSubCommand(String name, String argDescription, String help) {
            CommandDescription subCommand = new CommandDescription(name, argDescription, help);
            this._subCommandNames.put(name, subCommand);
        }

        public String getCommandName() {
            return this.commandName;
        }

        public String getArgumentDescription() {
            return this.argumentDescription;
        }

        public String getCommandDescription() {
            return this.helpDescription;
        }
    }
}

