/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.DataEntry;
import com.ibm.j9ddr.corereaders.elf.ELFDumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ELFAMD64DumpReader
extends ELFDumpReader {
    protected ELFAMD64DumpReader(ELFFileReader reader) throws IOException, InvalidDumpFormatException {
        super(reader);
    }

    @Override
    protected long readUID() throws IOException {
        return (long)this._reader.readInt() & 0xFFFFFFFFL;
    }

    @Override
    protected String getProcessorType() {
        return "amd64";
    }

    @Override
    protected long getBasePointerFrom(Map<String, Number> registers) {
        return registers.get("rbp").longValue();
    }

    @Override
    protected long getInstructionPointerFrom(Map<String, Number> registers) {
        return registers.get("rip").longValue();
    }

    @Override
    protected long getLinkRegisterFrom(Map<String, Number> registers) {
        return 0L;
    }

    @Override
    protected String getStackPointerRegisterName() {
        return "rsp";
    }

    @Override
    protected String[] getDwarfRegisterKeys() {
        String[] registerNames = new String[17];
        for (int i = 0; i < registerNames.length; ++i) {
            registerNames[i] = "r" + i;
        }
        registerNames[0] = "rax";
        registerNames[1] = "rdx";
        registerNames[2] = "rcx";
        registerNames[3] = "rbx";
        registerNames[4] = "rsi";
        registerNames[5] = "rdi";
        registerNames[6] = "rbp";
        registerNames[7] = "rsp";
        registerNames[16] = "rip";
        return registerNames;
    }

    @Override
    protected SortedMap<String, Number> readRegisters() throws IOException {
        int i;
        String[] names1 = new String[]{"r15", "r14", "r13", "r12", "rbp", "rbx", "r11", "r10", "r9", "r8", "rax", "rcx", "rdx", "rsi", "rdi"};
        String[] names2 = new String[]{"rip", "cs", "eflags", "rsp", "ss", "fs_base", "gs_base", "ds", "es", "fs", "gs"};
        TreeMap<String, Number> registers = new TreeMap<String, Number>(new ELFDumpReader.RegisterComparator());
        for (i = 0; i < names1.length; ++i) {
            registers.put(names1[i], this._reader.readLong());
        }
        this._reader.readLong();
        for (i = 0; i < names2.length; ++i) {
            registers.put(names2[i], this._reader.readLong());
        }
        return registers;
    }

    @Override
    protected void readHighwordRegisters(DataEntry entry, Map<String, Number> registers) throws IOException, InvalidDumpFormatException {
        throw new InvalidDumpFormatException("Unexpected data entry in AMD64 ELF dump");
    }
}

