function GetOciTopLevelCommand_iam() {
    return 'iam'
}

function GetOciSubcommands_iam() {
    $ociSubcommands = @{
        'iam' = 'api-key auth-token authentication-policy availability-domain bulk-action-resource-type-collection bulk-edit-tags-resource-type-collection compartment customer-secret-key domain dynamic-group fault-domain group iam-work-request iam-work-request-log identity-provider identity-provider-group idp-group-mapping mfa-totp-device network-sources policy region region-subscription scim-client-credentials smtp-credential standard-tag-namespace-template swift-password tag tag-default tag-namespace tagging-work-request tagging-work-request-error tagging-work-request-log tenancy ui-password ui-password-information user user-group-membership work-request'
        'iam api-key' = 'delete list upload'
        'iam auth-token' = 'create delete list update'
        'iam authentication-policy' = 'get update'
        'iam availability-domain' = 'list'
        'iam bulk-action-resource-type-collection' = 'list-bulk-action-resource-types'
        'iam bulk-edit-tags-resource-type-collection' = 'list-bulk-edit-tags-resource-types'
        'iam compartment' = 'bulk-delete-resources bulk-move-resources create delete get list move recover update'
        'iam customer-secret-key' = 'create delete list update'
        'iam domain' = 'activate change-compartment change-domain-license-type create deactivate delete enable-replication-to-region get list list-allowed-domain-license-types update'
        'iam dynamic-group' = 'create delete get list update'
        'iam fault-domain' = 'list'
        'iam group' = 'create delete get list update'
        'iam iam-work-request' = 'get list list-iam-work-request-errors'
        'iam iam-work-request-log' = 'list'
        'iam identity-provider' = 'create create-identity-provider-create-saml2-identity-provider-details delete get list update update-identity-provider-update-saml2-identity-provider-details'
        'iam identity-provider-group' = 'list'
        'iam idp-group-mapping' = 'create delete get list update'
        'iam mfa-totp-device' = 'activate create delete generate-totp-seed get list'
        'iam network-sources' = 'create delete get list update'
        'iam policy' = 'create delete get list update'
        'iam region' = 'list'
        'iam region-subscription' = 'create list'
        'iam scim-client-credentials' = 'reset-idp-scim-client'
        'iam smtp-credential' = 'create delete list update'
        'iam standard-tag-namespace-template' = 'get-standard-tag-template list-standard-tag-namespaces'
        'iam swift-password' = 'create delete list update'
        'iam tag' = 'bulk-delete bulk-edit create create-tag-default-tag-definition-validator create-tag-enum-tag-definition-validator delete get import-standard-tags list list-cost-tracking update update-tag-default-tag-definition-validator update-tag-enum-tag-definition-validator'
        'iam tag-default' = 'add assemble-effective-tag-set create delete get list remove update'
        'iam tag-namespace' = 'add cascade-delete change-compartment create delete get list remove update'
        'iam tagging-work-request' = 'get list'
        'iam tagging-work-request-error' = 'list'
        'iam tagging-work-request-log' = 'list'
        'iam tenancy' = 'get'
        'iam ui-password' = 'create-or-reset'
        'iam ui-password-information' = 'get-user'
        'iam user' = 'create create-db-credential create-o-auth-client-credential delete delete-db-credential delete-o-auth-client-credential get list list-db-credentials list-o-auth-client-credentials update update-o-auth-client-credential update-user-capabilities update-user-state'
        'iam user-group-membership' = 'add get list remove'
        'iam work-request' = 'get list'
    }
    return $ociSubcommands
}

function GetOciCommandsToLongParams_iam() {
    $ociCommandsToLongParams = @{
        'iam api-key delete' = 'fingerprint force from-json help if-match user-id'
        'iam api-key list' = 'all from-json help user-id'
        'iam api-key upload' = 'from-json help key user-id'
        'iam auth-token create' = 'description from-json help user-id'
        'iam auth-token delete' = 'auth-token-id force from-json help if-match user-id'
        'iam auth-token list' = 'all from-json help user-id'
        'iam auth-token update' = 'auth-token-id description from-json help if-match user-id'
        'iam authentication-policy get' = 'compartment-id from-json help'
        'iam authentication-policy update' = 'compartment-id force from-json help if-match network-policy password-policy'
        'iam availability-domain list' = 'all compartment-id from-json help'
        'iam bulk-action-resource-type-collection list-bulk-action-resource-types' = 'all bulk-action-type from-json help limit page page-size'
        'iam bulk-edit-tags-resource-type-collection list-bulk-edit-tags-resource-types' = 'all from-json help limit page page-size'
        'iam compartment bulk-delete-resources' = 'compartment-id from-json help max-wait-seconds resources wait-for-state wait-interval-seconds'
        'iam compartment bulk-move-resources' = 'compartment-id from-json help max-wait-seconds resources target-compartment-id wait-for-state wait-interval-seconds'
        'iam compartment create' = 'compartment-id defined-tags description freeform-tags from-json help max-wait-seconds name wait-for-state wait-interval-seconds'
        'iam compartment delete' = 'compartment-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'iam compartment get' = 'compartment-id from-json help'
        'iam compartment list' = 'access-level all compartment-id compartment-id-in-subtree from-json help lifecycle-state limit name page page-size sort-by sort-order'
        'iam compartment move' = 'compartment-id from-json help if-match max-wait-seconds target-compartment-id wait-for-state wait-interval-seconds'
        'iam compartment recover' = 'compartment-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'iam compartment update' = 'compartment-id defined-tags description force freeform-tags from-json help if-match max-wait-seconds name wait-for-state wait-interval-seconds'
        'iam customer-secret-key create' = 'display-name from-json help user-id'
        'iam customer-secret-key delete' = 'customer-secret-key-id force from-json help if-match user-id'
        'iam customer-secret-key list' = 'all from-json help user-id'
        'iam customer-secret-key update' = 'customer-secret-key-id display-name from-json help if-match user-id'
        'iam domain activate' = 'domain-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'iam domain change-compartment' = 'compartment-id domain-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'iam domain change-domain-license-type' = 'domain-id from-json help if-match license-type max-wait-seconds wait-for-state wait-interval-seconds'
        'iam domain create' = 'admin-email admin-first-name admin-last-name admin-user-name compartment-id defined-tags description display-name freeform-tags from-json help home-region is-hidden-on-login is-notification-bypassed is-primary-email-required license-type max-wait-seconds wait-for-state wait-interval-seconds'
        'iam domain deactivate' = 'domain-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'iam domain delete' = 'domain-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'iam domain enable-replication-to-region' = 'domain-id from-json help if-match max-wait-seconds replica-region wait-for-state wait-interval-seconds'
        'iam domain get' = 'domain-id from-json help'
        'iam domain list' = 'all compartment-id display-name from-json help home-region-url is-hidden-on-login license-type lifecycle-state limit name page page-size sort-by sort-order type url'
        'iam domain list-allowed-domain-license-types' = 'all current-license-type-name from-json help'
        'iam domain update' = 'defined-tags description display-name domain-id force freeform-tags from-json help if-match is-hidden-on-login max-wait-seconds wait-for-state wait-interval-seconds'
        'iam dynamic-group create' = 'compartment-id defined-tags description freeform-tags from-json help matching-rule max-wait-seconds name wait-for-state wait-interval-seconds'
        'iam dynamic-group delete' = 'dynamic-group-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'iam dynamic-group get' = 'dynamic-group-id from-json help'
        'iam dynamic-group list' = 'all compartment-id from-json help lifecycle-state limit name page page-size sort-by sort-order'
        'iam dynamic-group update' = 'defined-tags description dynamic-group-id force freeform-tags from-json help if-match matching-rule max-wait-seconds wait-for-state wait-interval-seconds'
        'iam fault-domain list' = 'all availability-domain compartment-id from-json help'
        'iam group create' = 'compartment-id defined-tags description freeform-tags from-json help max-wait-seconds name wait-for-state wait-interval-seconds'
        'iam group delete' = 'force from-json group-id help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'iam group get' = 'from-json group-id help'
        'iam group list' = 'all compartment-id from-json help lifecycle-state limit name page page-size sort-by sort-order'
        'iam group update' = 'defined-tags description force freeform-tags from-json group-id help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'iam iam-work-request get' = 'from-json help iam-work-request-id'
        'iam iam-work-request list' = 'all compartment-id from-json help limit page page-size resource-identifier'
        'iam iam-work-request list-iam-work-request-errors' = 'all from-json help iam-work-request-id limit page page-size sort-order'
        'iam iam-work-request-log list' = 'all from-json help iam-work-request-id limit page page-size sort-order'
        'iam identity-provider create' = 'compartment-id defined-tags description freeform-tags from-json help max-wait-seconds name product-type protocol wait-for-state wait-interval-seconds'
        'iam identity-provider create-identity-provider-create-saml2-identity-provider-details' = 'compartment-id defined-tags description freeform-attributes freeform-tags from-json help max-wait-seconds metadata metadata-url name product-type wait-for-state wait-interval-seconds'
        'iam identity-provider delete' = 'force from-json help identity-provider-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'iam identity-provider get' = 'from-json help identity-provider-id'
        'iam identity-provider list' = 'all compartment-id from-json help lifecycle-state limit name page page-size protocol sort-by sort-order'
        'iam identity-provider update' = 'defined-tags description force freeform-tags from-json help identity-provider-id if-match max-wait-seconds protocol wait-for-state wait-interval-seconds'
        'iam identity-provider update-identity-provider-update-saml2-identity-provider-details' = 'defined-tags description force freeform-attributes freeform-tags from-json help identity-provider-id if-match max-wait-seconds metadata metadata-url wait-for-state wait-interval-seconds'
        'iam identity-provider-group list' = 'all from-json help identity-provider-id lifecycle-state limit name page page-size'
        'iam idp-group-mapping create' = 'from-json group-id help identity-provider-id idp-group-name max-wait-seconds wait-for-state wait-interval-seconds'
        'iam idp-group-mapping delete' = 'force from-json help identity-provider-id if-match mapping-id'
        'iam idp-group-mapping get' = 'from-json help identity-provider-id mapping-id'
        'iam idp-group-mapping list' = 'all from-json help identity-provider-id limit page page-size'
        'iam idp-group-mapping update' = 'from-json group-id help identity-provider-id idp-group-name if-match mapping-id max-wait-seconds wait-for-state wait-interval-seconds'
        'iam mfa-totp-device activate' = 'from-json help if-match mfa-totp-device-id totp-token user-id'
        'iam mfa-totp-device create' = 'from-json help max-wait-seconds user-id wait-for-state wait-interval-seconds'
        'iam mfa-totp-device delete' = 'force from-json help if-match mfa-totp-device-id user-id'
        'iam mfa-totp-device generate-totp-seed' = 'from-json help if-match max-wait-seconds mfa-totp-device-id user-id wait-for-state wait-interval-seconds'
        'iam mfa-totp-device get' = 'from-json help mfa-totp-device-id user-id'
        'iam mfa-totp-device list' = 'all from-json help limit page page-size sort-by sort-order user-id'
        'iam network-sources create' = 'compartment-id defined-tags description freeform-tags from-json help name public-source-list services virtual-source-list'
        'iam network-sources delete' = 'force from-json help if-match network-source-id'
        'iam network-sources get' = 'from-json help network-source-id'
        'iam network-sources list' = 'all compartment-id from-json help lifecycle-state limit name page page-size sort-by sort-order'
        'iam network-sources update' = 'defined-tags description force freeform-tags from-json help if-match network-source-id public-source-list services virtual-source-list'
        'iam policy create' = 'compartment-id defined-tags description freeform-tags from-json help max-wait-seconds name statements version-date wait-for-state wait-interval-seconds'
        'iam policy delete' = 'force from-json help if-match max-wait-seconds policy-id wait-for-state wait-interval-seconds'
        'iam policy get' = 'from-json help policy-id'
        'iam policy list' = 'all compartment-id from-json help lifecycle-state limit name page page-size sort-by sort-order'
        'iam policy update' = 'defined-tags description force freeform-tags from-json help if-match max-wait-seconds policy-id statements version-date wait-for-state wait-interval-seconds'
        'iam region list' = 'all from-json help'
        'iam region-subscription create' = 'from-json help region-key tenancy-id'
        'iam region-subscription list' = 'all from-json help tenancy-id'
        'iam scim-client-credentials reset-idp-scim-client' = 'from-json help identity-provider-id'
        'iam smtp-credential create' = 'description from-json help user-id'
        'iam smtp-credential delete' = 'force from-json help if-match smtp-credential-id user-id'
        'iam smtp-credential list' = 'all from-json help user-id'
        'iam smtp-credential update' = 'description from-json help if-match smtp-credential-id user-id'
        'iam standard-tag-namespace-template get-standard-tag-template' = 'compartment-id from-json help standard-tag-namespace-name'
        'iam standard-tag-namespace-template list-standard-tag-namespaces' = 'all compartment-id from-json help limit page page-size'
        'iam swift-password create' = 'description from-json help user-id'
        'iam swift-password delete' = 'force from-json help if-match swift-password-id user-id'
        'iam swift-password list' = 'all from-json help user-id'
        'iam swift-password update' = 'description from-json help if-match swift-password-id user-id'
        'iam tag bulk-delete' = 'from-json help is-lock-override max-wait-seconds tag-definition-ids wait-for-state wait-interval-seconds'
        'iam tag bulk-edit' = 'bulk-edit-operations compartment-id from-json help max-wait-seconds resources wait-for-state wait-interval-seconds'
        'iam tag create' = 'defined-tags description freeform-tags from-json help is-cost-tracking is-lock-override max-wait-seconds name tag-namespace-id validator wait-for-state wait-interval-seconds'
        'iam tag create-tag-default-tag-definition-validator' = 'defined-tags description freeform-tags from-json help is-cost-tracking is-lock-override max-wait-seconds name tag-namespace-id wait-for-state wait-interval-seconds'
        'iam tag create-tag-enum-tag-definition-validator' = 'defined-tags description freeform-tags from-json help is-cost-tracking is-lock-override max-wait-seconds name tag-namespace-id validator-values wait-for-state wait-interval-seconds'
        'iam tag delete' = 'force from-json help if-match is-lock-override max-wait-seconds tag-name tag-namespace-id wait-for-state wait-interval-seconds'
        'iam tag get' = 'from-json help tag-name tag-namespace-id'
        'iam tag import-standard-tags' = 'compartment-id from-json help max-wait-seconds standard-tag-namespace-name wait-for-state wait-interval-seconds'
        'iam tag list' = 'all from-json help lifecycle-state limit page page-size tag-namespace-id'
        'iam tag list-cost-tracking' = 'all compartment-id from-json help limit page page-size'
        'iam tag update' = 'defined-tags description force freeform-tags from-json help if-match is-cost-tracking is-lock-override is-retired max-wait-seconds tag-name tag-namespace-id validator wait-for-state wait-interval-seconds'
        'iam tag update-tag-default-tag-definition-validator' = 'defined-tags description force freeform-tags from-json help if-match is-cost-tracking is-lock-override is-retired max-wait-seconds tag-name tag-namespace-id wait-for-state wait-interval-seconds'
        'iam tag update-tag-enum-tag-definition-validator' = 'defined-tags description force freeform-tags from-json help if-match is-cost-tracking is-lock-override is-retired max-wait-seconds tag-name tag-namespace-id validator-values wait-for-state wait-interval-seconds'
        'iam tag-default add' = 'from-json help if-match max-wait-seconds message related-resource-id tag-default-id type wait-for-state wait-interval-seconds'
        'iam tag-default assemble-effective-tag-set' = 'compartment-id from-json help lifecycle-state'
        'iam tag-default create' = 'compartment-id from-json help is-required locks max-wait-seconds tag-definition-id value wait-for-state wait-interval-seconds'
        'iam tag-default delete' = 'force from-json help if-match is-lock-override max-wait-seconds tag-default-id wait-for-state wait-interval-seconds'
        'iam tag-default get' = 'from-json help tag-default-id'
        'iam tag-default list' = 'all compartment-id from-json help id lifecycle-state limit page page-size tag-definition-id'
        'iam tag-default remove' = 'from-json help if-match max-wait-seconds tag-default-id type wait-for-state wait-interval-seconds'
        'iam tag-default update' = 'from-json help if-match is-lock-override is-required max-wait-seconds tag-default-id value wait-for-state wait-interval-seconds'
        'iam tag-namespace add' = 'from-json help if-match max-wait-seconds message related-resource-id tag-namespace-id type wait-for-state wait-interval-seconds'
        'iam tag-namespace cascade-delete' = 'from-json help if-match is-lock-override max-wait-seconds tag-namespace-id wait-for-state wait-interval-seconds'
        'iam tag-namespace change-compartment' = 'compartment-id from-json help is-lock-override tag-namespace-id'
        'iam tag-namespace create' = 'compartment-id defined-tags description freeform-tags from-json help locks max-wait-seconds name wait-for-state wait-interval-seconds'
        'iam tag-namespace delete' = 'force from-json help if-match is-lock-override max-wait-seconds tag-namespace-id wait-for-state wait-interval-seconds'
        'iam tag-namespace get' = 'from-json help tag-namespace-id'
        'iam tag-namespace list' = 'all compartment-id from-json help include-subcompartments lifecycle-state limit page page-size'
        'iam tag-namespace remove' = 'from-json help if-match max-wait-seconds tag-namespace-id type wait-for-state wait-interval-seconds'
        'iam tag-namespace update' = 'defined-tags description force freeform-tags from-json help is-lock-override is-retired max-wait-seconds tag-namespace-id wait-for-state wait-interval-seconds'
        'iam tagging-work-request get' = 'from-json help work-request-id'
        'iam tagging-work-request list' = 'all compartment-id from-json help limit page page-size resource-identifier'
        'iam tagging-work-request-error list' = 'all from-json help limit page page-size work-request-id'
        'iam tagging-work-request-log list' = 'all from-json help limit page page-size work-request-id'
        'iam tenancy get' = 'from-json help tenancy-id'
        'iam ui-password create-or-reset' = 'from-json help user-id'
        'iam ui-password-information get-user' = 'from-json help user-id'
        'iam user create' = 'compartment-id defined-tags description email freeform-tags from-json help max-wait-seconds name wait-for-state wait-interval-seconds'
        'iam user create-db-credential' = 'description from-json help password user-id'
        'iam user create-o-auth-client-credential' = 'description from-json help name scopes user-id'
        'iam user delete' = 'force from-json help if-match max-wait-seconds user-id wait-for-state wait-interval-seconds'
        'iam user delete-db-credential' = 'db-credential-id force from-json help if-match user-id'
        'iam user delete-o-auth-client-credential' = 'force from-json help if-match oauth2-client-credential-id user-id'
        'iam user get' = 'from-json help user-id'
        'iam user list' = 'all compartment-id external-identifier from-json help identity-provider-id lifecycle-state limit name page page-size sort-by sort-order'
        'iam user list-db-credentials' = 'all from-json help lifecycle-state limit name page page-size sort-by sort-order user-id'
        'iam user list-o-auth-client-credentials' = 'all from-json help lifecycle-state limit page page-size user-id'
        'iam user update' = 'db-user-name defined-tags description email force freeform-tags from-json help if-match max-wait-seconds user-id wait-for-state wait-interval-seconds'
        'iam user update-o-auth-client-credential' = 'description force from-json help if-match is-reset-password oauth2-client-credential-id scopes user-id'
        'iam user update-user-capabilities' = 'can-use-api-keys can-use-auth-tokens can-use-console-password can-use-customer-secret-keys can-use-db-credentials can-use-o-auth2-client-credentials can-use-smtp-credentials from-json help if-match max-wait-seconds user-id wait-for-state wait-interval-seconds'
        'iam user update-user-state' = 'blocked from-json help if-match max-wait-seconds user-id wait-for-state wait-interval-seconds'
        'iam user-group-membership add' = 'from-json group-id help max-wait-seconds user-id wait-for-state wait-interval-seconds'
        'iam user-group-membership get' = 'from-json help user-group-membership-id'
        'iam user-group-membership list' = 'all compartment-id from-json group-id help limit page page-size user-id'
        'iam user-group-membership remove' = 'force from-json help if-match user-group-membership-id'
        'iam work-request get' = 'from-json help work-request-id'
        'iam work-request list' = 'all compartment-id from-json help limit page page-size resource-identifier'
    }
    return $ociCommandsToLongParams
}

function GetOciCommandsToShortParams_iam() {
    $ociCommandsToShortParams = @{
        'iam api-key delete' = '? h'
        'iam api-key list' = '? h'
        'iam api-key upload' = '? h'
        'iam auth-token create' = '? h'
        'iam auth-token delete' = '? h'
        'iam auth-token list' = '? h'
        'iam auth-token update' = '? h'
        'iam authentication-policy get' = '? c h'
        'iam authentication-policy update' = '? c h'
        'iam availability-domain list' = '? c h'
        'iam bulk-action-resource-type-collection list-bulk-action-resource-types' = '? h'
        'iam bulk-edit-tags-resource-type-collection list-bulk-edit-tags-resource-types' = '? h'
        'iam compartment bulk-delete-resources' = '? c h'
        'iam compartment bulk-move-resources' = '? c h'
        'iam compartment create' = '? c h'
        'iam compartment delete' = '? c h'
        'iam compartment get' = '? c h'
        'iam compartment list' = '? c h'
        'iam compartment move' = '? c h'
        'iam compartment recover' = '? c h'
        'iam compartment update' = '? c h'
        'iam customer-secret-key create' = '? h'
        'iam customer-secret-key delete' = '? h'
        'iam customer-secret-key list' = '? h'
        'iam customer-secret-key update' = '? h'
        'iam domain activate' = '? h'
        'iam domain change-compartment' = '? c h'
        'iam domain change-domain-license-type' = '? h'
        'iam domain create' = '? c h'
        'iam domain deactivate' = '? h'
        'iam domain delete' = '? h'
        'iam domain enable-replication-to-region' = '? h'
        'iam domain get' = '? h'
        'iam domain list' = '? c h'
        'iam domain list-allowed-domain-license-types' = '? h'
        'iam domain update' = '? h'
        'iam dynamic-group create' = '? c h'
        'iam dynamic-group delete' = '? h'
        'iam dynamic-group get' = '? h'
        'iam dynamic-group list' = '? c h'
        'iam dynamic-group update' = '? h'
        'iam fault-domain list' = '? c h'
        'iam group create' = '? c h'
        'iam group delete' = '? h'
        'iam group get' = '? h'
        'iam group list' = '? c h'
        'iam group update' = '? h'
        'iam iam-work-request get' = '? h'
        'iam iam-work-request list' = '? c h'
        'iam iam-work-request list-iam-work-request-errors' = '? h'
        'iam iam-work-request-log list' = '? h'
        'iam identity-provider create' = '? c h'
        'iam identity-provider create-identity-provider-create-saml2-identity-provider-details' = '? c h'
        'iam identity-provider delete' = '? h'
        'iam identity-provider get' = '? h'
        'iam identity-provider list' = '? c h'
        'iam identity-provider update' = '? h'
        'iam identity-provider update-identity-provider-update-saml2-identity-provider-details' = '? h'
        'iam identity-provider-group list' = '? h'
        'iam idp-group-mapping create' = '? h'
        'iam idp-group-mapping delete' = '? h'
        'iam idp-group-mapping get' = '? h'
        'iam idp-group-mapping list' = '? h'
        'iam idp-group-mapping update' = '? h'
        'iam mfa-totp-device activate' = '? h'
        'iam mfa-totp-device create' = '? h'
        'iam mfa-totp-device delete' = '? h'
        'iam mfa-totp-device generate-totp-seed' = '? h'
        'iam mfa-totp-device get' = '? h'
        'iam mfa-totp-device list' = '? h'
        'iam network-sources create' = '? c h'
        'iam network-sources delete' = '? h'
        'iam network-sources get' = '? h'
        'iam network-sources list' = '? c h'
        'iam network-sources update' = '? h'
        'iam policy create' = '? c h'
        'iam policy delete' = '? h'
        'iam policy get' = '? h'
        'iam policy list' = '? c h'
        'iam policy update' = '? h'
        'iam region list' = '? h'
        'iam region-subscription create' = '? h'
        'iam region-subscription list' = '? h'
        'iam scim-client-credentials reset-idp-scim-client' = '? h'
        'iam smtp-credential create' = '? h'
        'iam smtp-credential delete' = '? h'
        'iam smtp-credential list' = '? h'
        'iam smtp-credential update' = '? h'
        'iam standard-tag-namespace-template get-standard-tag-template' = '? c h'
        'iam standard-tag-namespace-template list-standard-tag-namespaces' = '? c h'
        'iam swift-password create' = '? h'
        'iam swift-password delete' = '? h'
        'iam swift-password list' = '? h'
        'iam swift-password update' = '? h'
        'iam tag bulk-delete' = '? h'
        'iam tag bulk-edit' = '? c h'
        'iam tag create' = '? h'
        'iam tag create-tag-default-tag-definition-validator' = '? h'
        'iam tag create-tag-enum-tag-definition-validator' = '? h'
        'iam tag delete' = '? h'
        'iam tag get' = '? h'
        'iam tag import-standard-tags' = '? c h'
        'iam tag list' = '? h'
        'iam tag list-cost-tracking' = '? c h'
        'iam tag update' = '? h'
        'iam tag update-tag-default-tag-definition-validator' = '? h'
        'iam tag update-tag-enum-tag-definition-validator' = '? h'
        'iam tag-default add' = '? h'
        'iam tag-default assemble-effective-tag-set' = '? c h'
        'iam tag-default create' = '? c h'
        'iam tag-default delete' = '? h'
        'iam tag-default get' = '? h'
        'iam tag-default list' = '? c h'
        'iam tag-default remove' = '? h'
        'iam tag-default update' = '? h'
        'iam tag-namespace add' = '? h'
        'iam tag-namespace cascade-delete' = '? h'
        'iam tag-namespace change-compartment' = '? c h'
        'iam tag-namespace create' = '? c h'
        'iam tag-namespace delete' = '? h'
        'iam tag-namespace get' = '? h'
        'iam tag-namespace list' = '? c h'
        'iam tag-namespace remove' = '? h'
        'iam tag-namespace update' = '? h'
        'iam tagging-work-request get' = '? h'
        'iam tagging-work-request list' = '? c h'
        'iam tagging-work-request-error list' = '? h'
        'iam tagging-work-request-log list' = '? h'
        'iam tenancy get' = '? h'
        'iam ui-password create-or-reset' = '? h'
        'iam ui-password-information get-user' = '? h'
        'iam user create' = '? c h'
        'iam user create-db-credential' = '? h'
        'iam user create-o-auth-client-credential' = '? h'
        'iam user delete' = '? h'
        'iam user delete-db-credential' = '? h'
        'iam user delete-o-auth-client-credential' = '? h'
        'iam user get' = '? h'
        'iam user list' = '? c h'
        'iam user list-db-credentials' = '? h'
        'iam user list-o-auth-client-credentials' = '? h'
        'iam user update' = '? h'
        'iam user update-o-auth-client-credential' = '? h'
        'iam user update-user-capabilities' = '? h'
        'iam user update-user-state' = '? h'
        'iam user-group-membership add' = '? h'
        'iam user-group-membership get' = '? h'
        'iam user-group-membership list' = '? c h'
        'iam user-group-membership remove' = '? h'
        'iam work-request get' = '? h'
        'iam work-request list' = '? c h'
    }
    return $ociCommandsToShortParams
}