# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240430

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli.cli_root import cli
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias


@cli.command(cli_util.override('demand_signal.demand_signal_root_group.command_name', 'demand-signal'), cls=CommandGroupWithAlias, help=cli_util.override('demand_signal.demand_signal_root_group.help', """Use the OCI Control Center Demand Signal API to manage Demand Signals."""), short_help=cli_util.override('demand_signal.demand_signal_root_group.short_help', """OCI Control Center Demand Signal API"""))
@cli_util.help_option_group
def demand_signal_root_group():
    pass


@click.command(cli_util.override('demand_signal.occ_demand_signal_collection_group.command_name', 'occ-demand-signal-collection'), cls=CommandGroupWithAlias, help="""Results of a occDemandSignal search. Contains both OccDemandSignalSummary items and other information, such as metadata.""")
@cli_util.help_option_group
def occ_demand_signal_collection_group():
    pass


@click.command(cli_util.override('demand_signal.occ_demand_signal_group.command_name', 'occ-demand-signal'), cls=CommandGroupWithAlias, help="""An OccDemandSignal is a forecast created for different Resource Types.

To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies].""")
@cli_util.help_option_group
def occ_demand_signal_group():
    pass


demand_signal_root_group.add_command(occ_demand_signal_collection_group)
demand_signal_root_group.add_command(occ_demand_signal_group)


@occ_demand_signal_group.command(name=cli_util.override('demand_signal.change_occ_demand_signal_compartment.command_name', 'change-compartment'), help=u"""Moves a OccDemandSignal into a different compartment within the same tenancy. For information about moving resources between compartments, see [Moving Resources to a Different Compartment]. \n[Command Reference](changeOccDemandSignalCompartment)""")
@cli_util.option('--occ-demand-signal-id', required=True, help=u"""The [OCID] of the OccDemandSignal.""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment to move the OccDemandSignal to.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_occ_demand_signal_compartment(ctx, from_json, occ_demand_signal_id, compartment_id, if_match):

    if isinstance(occ_demand_signal_id, six.string_types) and len(occ_demand_signal_id.strip()) == 0:
        raise click.UsageError('Parameter --occ-demand-signal-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('demand_signal', 'occ_demand_signal', ctx)
    result = client.change_occ_demand_signal_compartment(
        occ_demand_signal_id=occ_demand_signal_id,
        change_occ_demand_signal_compartment_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@occ_demand_signal_group.command(name=cli_util.override('demand_signal.create_occ_demand_signal.command_name', 'create'), help=u"""Creates a OccDemandSignal. \n[Command Reference](createOccDemandSignal)""")
@cli_util.option('--occ-demand-signals', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""The OccDemandSignal data.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--is-active', required=True, type=click.BOOL, help=u"""Indicator of whether to share the data with Oracle.""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment to create the OccDemandSignal in.""")
@cli_util.option('--display-name', help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'occ-demand-signals': {'module': 'demand_signal', 'class': 'list[OccDemandSignalData]'}, 'freeform-tags': {'module': 'demand_signal', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'demand_signal', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'occ-demand-signals': {'module': 'demand_signal', 'class': 'list[OccDemandSignalData]'}, 'freeform-tags': {'module': 'demand_signal', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'demand_signal', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'demand_signal', 'class': 'OccDemandSignal'})
@cli_util.wrap_exceptions
def create_occ_demand_signal(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, occ_demand_signals, is_active, compartment_id, display_name, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['occDemandSignals'] = cli_util.parse_json_parameter("occ_demand_signals", occ_demand_signals)
    _details['isActive'] = is_active
    _details['compartmentId'] = compartment_id

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('demand_signal', 'occ_demand_signal', ctx)
    result = client.create_occ_demand_signal(
        create_occ_demand_signal_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_occ_demand_signal') and callable(getattr(client, 'get_occ_demand_signal')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_occ_demand_signal(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@occ_demand_signal_group.command(name=cli_util.override('demand_signal.delete_occ_demand_signal.command_name', 'delete'), help=u"""Deletes a OccDemandSignal. \n[Command Reference](deleteOccDemandSignal)""")
@cli_util.option('--occ-demand-signal-id', required=True, help=u"""The [OCID] of the OccDemandSignal.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_occ_demand_signal(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, occ_demand_signal_id, if_match):

    if isinstance(occ_demand_signal_id, six.string_types) and len(occ_demand_signal_id.strip()) == 0:
        raise click.UsageError('Parameter --occ-demand-signal-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('demand_signal', 'occ_demand_signal', ctx)
    result = client.delete_occ_demand_signal(
        occ_demand_signal_id=occ_demand_signal_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_occ_demand_signal') and callable(getattr(client, 'get_occ_demand_signal')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                oci.wait_until(client, client.get_occ_demand_signal(occ_demand_signal_id), 'lifecycle_state', wait_for_state, succeed_on_not_found=True, **wait_period_kwargs)
            except oci.exceptions.ServiceError as e:
                # We make an initial service call so we can pass the result to oci.wait_until(), however if we are waiting on the
                # outcome of a delete operation it is possible that the resource is already gone and so the initial service call
                # will result in an exception that reflects a HTTP 404. In this case, we can exit with success (rather than raising
                # the exception) since this would have been the behaviour in the waiter anyway (as for delete we provide the argument
                # succeed_on_not_found=True to the waiter).
                #
                # Any non-404 should still result in the exception being thrown.
                if e.status == 404:
                    pass
                else:
                    raise
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Please retrieve the resource to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@occ_demand_signal_group.command(name=cli_util.override('demand_signal.get_occ_demand_signal.command_name', 'get'), help=u"""Gets information about a OccDemandSignal. \n[Command Reference](getOccDemandSignal)""")
@cli_util.option('--occ-demand-signal-id', required=True, help=u"""The [OCID] of the OccDemandSignal.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'demand_signal', 'class': 'OccDemandSignal'})
@cli_util.wrap_exceptions
def get_occ_demand_signal(ctx, from_json, occ_demand_signal_id):

    if isinstance(occ_demand_signal_id, six.string_types) and len(occ_demand_signal_id.strip()) == 0:
        raise click.UsageError('Parameter --occ-demand-signal-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('demand_signal', 'occ_demand_signal', ctx)
    result = client.get_occ_demand_signal(
        occ_demand_signal_id=occ_demand_signal_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@occ_demand_signal_collection_group.command(name=cli_util.override('demand_signal.list_occ_demand_signals.command_name', 'list-occ-demand-signals'), help=u"""Gets a list of OccDemandSignals. \n[Command Reference](listOccDemandSignals)""")
@cli_util.option('--compartment-id', help=u"""The [OCID] of the compartment in which to list resources.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the given display name exactly.""")
@cli_util.option('--id', help=u"""The [OCID] of the OccDemandSignal.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--page', help=u"""For list pagination. The value of the opc-next-page response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either ascending (`ASC`) or descending (`DESC`).""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. You can provide only one sort order. Default order for `timeCreated` is descending. Default order for `displayName` is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'demand_signal', 'class': 'OccDemandSignalCollection'})
@cli_util.wrap_exceptions
def list_occ_demand_signals(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, display_name, id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if display_name is not None:
        kwargs['display_name'] = display_name
    if id is not None:
        kwargs['id'] = id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('demand_signal', 'occ_demand_signal', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_occ_demand_signals,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_occ_demand_signals,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_occ_demand_signals(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@occ_demand_signal_group.command(name=cli_util.override('demand_signal.patch_occ_demand_signal.command_name', 'patch'), help=u"""Updates the data of an OccDemandSignal. \n[Command Reference](patchOccDemandSignal)""")
@cli_util.option('--occ-demand-signal-id', required=True, help=u"""The [OCID] of the OccDemandSignal.""")
@cli_util.option('--items', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of patch instructions.

This option is a JSON list with items of type PatchInstruction.  For documentation on PatchInstruction please see our API reference: https://docs.cloud.oracle.com/api/#/en/occdemandsignal/20240430/datatypes/PatchInstruction.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({'items': {'module': 'demand_signal', 'class': 'list[PatchInstruction]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'items': {'module': 'demand_signal', 'class': 'list[PatchInstruction]'}}, output_type={'module': 'demand_signal', 'class': 'OccDemandSignal'})
@cli_util.wrap_exceptions
def patch_occ_demand_signal(ctx, from_json, occ_demand_signal_id, items, if_match):

    if isinstance(occ_demand_signal_id, six.string_types) and len(occ_demand_signal_id.strip()) == 0:
        raise click.UsageError('Parameter --occ-demand-signal-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if items is not None:
        _details['items'] = cli_util.parse_json_parameter("items", items)

    client = cli_util.build_client('demand_signal', 'occ_demand_signal', ctx)
    result = client.patch_occ_demand_signal(
        occ_demand_signal_id=occ_demand_signal_id,
        patch_occ_demand_signal_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@occ_demand_signal_group.command(name=cli_util.override('demand_signal.update_occ_demand_signal.command_name', 'update'), help=u"""Updates a OccDemandSignal. \n[Command Reference](updateOccDemandSignal)""")
@cli_util.option('--occ-demand-signal-id', required=True, help=u"""The [OCID] of the OccDemandSignal.""")
@cli_util.option('--display-name', help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.""")
@cli_util.option('--is-active', type=click.BOOL, help=u"""Indicator of whether to share the data with Oracle.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'demand_signal', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'demand_signal', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'demand_signal', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'demand_signal', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'demand_signal', 'class': 'OccDemandSignal'})
@cli_util.wrap_exceptions
def update_occ_demand_signal(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, occ_demand_signal_id, display_name, is_active, freeform_tags, defined_tags, if_match):

    if isinstance(occ_demand_signal_id, six.string_types) and len(occ_demand_signal_id.strip()) == 0:
        raise click.UsageError('Parameter --occ-demand-signal-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if is_active is not None:
        _details['isActive'] = is_active

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('demand_signal', 'occ_demand_signal', ctx)
    result = client.update_occ_demand_signal(
        occ_demand_signal_id=occ_demand_signal_id,
        update_occ_demand_signal_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_occ_demand_signal') and callable(getattr(client, 'get_occ_demand_signal')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_occ_demand_signal(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
