// Code generated by metricgen; DO NOT EDIT.
// source: contexts.yaml

package contexts

import (
	"github.com/netdata/netdata/go/plugins/plugin/go.d/agent/module"
	"github.com/netdata/netdata/go/plugins/plugin/ibm.d/framework"
	"strings"
)

// cleanLabelValue cleans a label value for use in instance/dimension IDs
func cleanLabelValue(value string) string {
	// Replace problematic characters
	r := strings.NewReplacer(
		" ", "_",
		".", "_",
		"-", "_",
		"/", "_",
		":", "_",
		"=", "_",
		",", "_",
		"(", "_",
		")", "_",
	)
	return strings.ToLower(r.Replace(value))
}

// EmptyLabels is used for contexts without labels
type EmptyLabels struct{}

// InstanceID for empty labels just returns the context name
func (EmptyLabels) InstanceID(contextName string) string {
	return contextName
}

// --- Bufferpool ---

// BufferpoolHitRatioValues defines the type-safe values for Bufferpool.HitRatio context
type BufferpoolHitRatioValues struct {
	Overall int64
}

// BufferpoolHitRatioContext provides type-safe operations for Bufferpool.HitRatio context
type BufferpoolHitRatioContext struct {
	framework.Context[BufferpoolLabels]
}

// Set provides type-safe dimension setting for Bufferpool.HitRatio context
func (c BufferpoolHitRatioContext) Set(state *framework.CollectorState, labels BufferpoolLabels, values BufferpoolHitRatioValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"overall": values.Overall,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c BufferpoolHitRatioContext) SetUpdateEvery(state *framework.CollectorState, labels BufferpoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// BufferpoolDetailedHitRatioValues defines the type-safe values for Bufferpool.DetailedHitRatio context
type BufferpoolDetailedHitRatioValues struct {
	Data   int64
	Index  int64
	Xda    int64
	Column int64
}

// BufferpoolDetailedHitRatioContext provides type-safe operations for Bufferpool.DetailedHitRatio context
type BufferpoolDetailedHitRatioContext struct {
	framework.Context[BufferpoolLabels]
}

// Set provides type-safe dimension setting for Bufferpool.DetailedHitRatio context
func (c BufferpoolDetailedHitRatioContext) Set(state *framework.CollectorState, labels BufferpoolLabels, values BufferpoolDetailedHitRatioValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"data":   values.Data,
		"index":  values.Index,
		"xda":    values.Xda,
		"column": values.Column,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c BufferpoolDetailedHitRatioContext) SetUpdateEvery(state *framework.CollectorState, labels BufferpoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// BufferpoolReadsValues defines the type-safe values for Bufferpool.Reads context
type BufferpoolReadsValues struct {
	Logical  int64
	Physical int64
}

// BufferpoolReadsContext provides type-safe operations for Bufferpool.Reads context
type BufferpoolReadsContext struct {
	framework.Context[BufferpoolLabels]
}

// Set provides type-safe dimension setting for Bufferpool.Reads context
func (c BufferpoolReadsContext) Set(state *framework.CollectorState, labels BufferpoolLabels, values BufferpoolReadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"logical":  values.Logical,
		"physical": values.Physical,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c BufferpoolReadsContext) SetUpdateEvery(state *framework.CollectorState, labels BufferpoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// BufferpoolDataReadsValues defines the type-safe values for Bufferpool.DataReads context
type BufferpoolDataReadsValues struct {
	Logical  int64
	Physical int64
}

// BufferpoolDataReadsContext provides type-safe operations for Bufferpool.DataReads context
type BufferpoolDataReadsContext struct {
	framework.Context[BufferpoolLabels]
}

// Set provides type-safe dimension setting for Bufferpool.DataReads context
func (c BufferpoolDataReadsContext) Set(state *framework.CollectorState, labels BufferpoolLabels, values BufferpoolDataReadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"logical":  values.Logical,
		"physical": values.Physical,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c BufferpoolDataReadsContext) SetUpdateEvery(state *framework.CollectorState, labels BufferpoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// BufferpoolIndexReadsValues defines the type-safe values for Bufferpool.IndexReads context
type BufferpoolIndexReadsValues struct {
	Logical  int64
	Physical int64
}

// BufferpoolIndexReadsContext provides type-safe operations for Bufferpool.IndexReads context
type BufferpoolIndexReadsContext struct {
	framework.Context[BufferpoolLabels]
}

// Set provides type-safe dimension setting for Bufferpool.IndexReads context
func (c BufferpoolIndexReadsContext) Set(state *framework.CollectorState, labels BufferpoolLabels, values BufferpoolIndexReadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"logical":  values.Logical,
		"physical": values.Physical,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c BufferpoolIndexReadsContext) SetUpdateEvery(state *framework.CollectorState, labels BufferpoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// BufferpoolPagesValues defines the type-safe values for Bufferpool.Pages context
type BufferpoolPagesValues struct {
	Used  int64
	Total int64
}

// BufferpoolPagesContext provides type-safe operations for Bufferpool.Pages context
type BufferpoolPagesContext struct {
	framework.Context[BufferpoolLabels]
}

// Set provides type-safe dimension setting for Bufferpool.Pages context
func (c BufferpoolPagesContext) Set(state *framework.CollectorState, labels BufferpoolLabels, values BufferpoolPagesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"used":  values.Used,
		"total": values.Total,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c BufferpoolPagesContext) SetUpdateEvery(state *framework.CollectorState, labels BufferpoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// BufferpoolWritesValues defines the type-safe values for Bufferpool.Writes context
type BufferpoolWritesValues struct {
	Writes int64
}

// BufferpoolWritesContext provides type-safe operations for Bufferpool.Writes context
type BufferpoolWritesContext struct {
	framework.Context[BufferpoolLabels]
}

// Set provides type-safe dimension setting for Bufferpool.Writes context
func (c BufferpoolWritesContext) Set(state *framework.CollectorState, labels BufferpoolLabels, values BufferpoolWritesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"writes": values.Writes,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c BufferpoolWritesContext) SetUpdateEvery(state *framework.CollectorState, labels BufferpoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// BufferpoolLabels defines the required labels for Bufferpool contexts
type BufferpoolLabels struct {
	Bufferpool string
	Page_size  string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l BufferpoolLabels) InstanceID(contextName string) string {
	// Label order from YAML: bufferpool, page_size
	return contextName + "." + cleanLabelValue(l.Bufferpool) + "_" + cleanLabelValue(l.Page_size)
}

// Bufferpool contains all metric contexts for Bufferpool
var Bufferpool = struct {
	HitRatio         BufferpoolHitRatioContext
	DetailedHitRatio BufferpoolDetailedHitRatioContext
	Reads            BufferpoolReadsContext
	DataReads        BufferpoolDataReadsContext
	IndexReads       BufferpoolIndexReadsContext
	Pages            BufferpoolPagesContext
	Writes           BufferpoolWritesContext
}{
	HitRatio: BufferpoolHitRatioContext{
		Context: framework.Context[BufferpoolLabels]{
			Name:        "db2.bufferpool_instance_hit_ratio",
			Family:      "bufferpools/instances",
			Title:       "Buffer Pool Hit Ratio",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    1110,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "overall",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{
				"bufferpool",
				"page_size",
			},
		},
	},
	DetailedHitRatio: BufferpoolDetailedHitRatioContext{
		Context: framework.Context[BufferpoolLabels]{
			Name:        "db2.bufferpool_instance_detailed_hit_ratio",
			Family:      "bufferpools/instances",
			Title:       "Buffer Pool Detailed Hit Ratios",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    1111,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "data",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "index",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "xda",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "column",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{
				"bufferpool",
				"page_size",
			},
		},
	},
	Reads: BufferpoolReadsContext{
		Context: framework.Context[BufferpoolLabels]{
			Name:        "db2.bufferpool_instance_reads",
			Family:      "bufferpools/instances",
			Title:       "Buffer Pool Reads",
			Units:       "reads/s",
			Type:        module.Stacked,
			Priority:    1112,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "logical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "physical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"bufferpool",
				"page_size",
			},
		},
	},
	DataReads: BufferpoolDataReadsContext{
		Context: framework.Context[BufferpoolLabels]{
			Name:        "db2.bufferpool_instance_data_reads",
			Family:      "bufferpools/instances",
			Title:       "Buffer Pool Data Page Reads",
			Units:       "reads/s",
			Type:        module.Stacked,
			Priority:    1113,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "logical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "physical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"bufferpool",
				"page_size",
			},
		},
	},
	IndexReads: BufferpoolIndexReadsContext{
		Context: framework.Context[BufferpoolLabels]{
			Name:        "db2.bufferpool_instance_index_reads",
			Family:      "bufferpools/instances",
			Title:       "Buffer Pool Index Page Reads",
			Units:       "reads/s",
			Type:        module.Stacked,
			Priority:    1114,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "logical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "physical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"bufferpool",
				"page_size",
			},
		},
	},
	Pages: BufferpoolPagesContext{
		Context: framework.Context[BufferpoolLabels]{
			Name:        "db2.bufferpool_instance_pages",
			Family:      "bufferpools/instances",
			Title:       "Buffer Pool Pages",
			Units:       "pages",
			Type:        module.Stacked,
			Priority:    1115,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"bufferpool",
				"page_size",
			},
		},
	},
	Writes: BufferpoolWritesContext{
		Context: framework.Context[BufferpoolLabels]{
			Name:        "db2.bufferpool_instance_writes",
			Family:      "bufferpools/instances",
			Title:       "Buffer Pool Writes",
			Units:       "writes/s",
			Type:        module.Line,
			Priority:    1116,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "writes",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"bufferpool",
				"page_size",
			},
		},
	},
}

// --- BufferpoolGroup ---

// BufferpoolGroupHitRatioValues defines the type-safe values for BufferpoolGroup.HitRatio context
type BufferpoolGroupHitRatioValues struct {
	Overall int64
}

// BufferpoolGroupHitRatioContext provides type-safe operations for BufferpoolGroup.HitRatio context
type BufferpoolGroupHitRatioContext struct {
	framework.Context[BufferpoolGroupLabels]
}

// Set provides type-safe dimension setting for BufferpoolGroup.HitRatio context
func (c BufferpoolGroupHitRatioContext) Set(state *framework.CollectorState, labels BufferpoolGroupLabels, values BufferpoolGroupHitRatioValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"overall": values.Overall,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c BufferpoolGroupHitRatioContext) SetUpdateEvery(state *framework.CollectorState, labels BufferpoolGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// BufferpoolGroupDetailedHitRatioValues defines the type-safe values for BufferpoolGroup.DetailedHitRatio context
type BufferpoolGroupDetailedHitRatioValues struct {
	Data   int64
	Index  int64
	Xda    int64
	Column int64
}

// BufferpoolGroupDetailedHitRatioContext provides type-safe operations for BufferpoolGroup.DetailedHitRatio context
type BufferpoolGroupDetailedHitRatioContext struct {
	framework.Context[BufferpoolGroupLabels]
}

// Set provides type-safe dimension setting for BufferpoolGroup.DetailedHitRatio context
func (c BufferpoolGroupDetailedHitRatioContext) Set(state *framework.CollectorState, labels BufferpoolGroupLabels, values BufferpoolGroupDetailedHitRatioValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"data":   values.Data,
		"index":  values.Index,
		"xda":    values.Xda,
		"column": values.Column,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c BufferpoolGroupDetailedHitRatioContext) SetUpdateEvery(state *framework.CollectorState, labels BufferpoolGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// BufferpoolGroupReadsValues defines the type-safe values for BufferpoolGroup.Reads context
type BufferpoolGroupReadsValues struct {
	Logical  int64
	Physical int64
}

// BufferpoolGroupReadsContext provides type-safe operations for BufferpoolGroup.Reads context
type BufferpoolGroupReadsContext struct {
	framework.Context[BufferpoolGroupLabels]
}

// Set provides type-safe dimension setting for BufferpoolGroup.Reads context
func (c BufferpoolGroupReadsContext) Set(state *framework.CollectorState, labels BufferpoolGroupLabels, values BufferpoolGroupReadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"logical":  values.Logical,
		"physical": values.Physical,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c BufferpoolGroupReadsContext) SetUpdateEvery(state *framework.CollectorState, labels BufferpoolGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// BufferpoolGroupDataReadsValues defines the type-safe values for BufferpoolGroup.DataReads context
type BufferpoolGroupDataReadsValues struct {
	Logical  int64
	Physical int64
}

// BufferpoolGroupDataReadsContext provides type-safe operations for BufferpoolGroup.DataReads context
type BufferpoolGroupDataReadsContext struct {
	framework.Context[BufferpoolGroupLabels]
}

// Set provides type-safe dimension setting for BufferpoolGroup.DataReads context
func (c BufferpoolGroupDataReadsContext) Set(state *framework.CollectorState, labels BufferpoolGroupLabels, values BufferpoolGroupDataReadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"logical":  values.Logical,
		"physical": values.Physical,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c BufferpoolGroupDataReadsContext) SetUpdateEvery(state *framework.CollectorState, labels BufferpoolGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// BufferpoolGroupIndexReadsValues defines the type-safe values for BufferpoolGroup.IndexReads context
type BufferpoolGroupIndexReadsValues struct {
	Logical  int64
	Physical int64
}

// BufferpoolGroupIndexReadsContext provides type-safe operations for BufferpoolGroup.IndexReads context
type BufferpoolGroupIndexReadsContext struct {
	framework.Context[BufferpoolGroupLabels]
}

// Set provides type-safe dimension setting for BufferpoolGroup.IndexReads context
func (c BufferpoolGroupIndexReadsContext) Set(state *framework.CollectorState, labels BufferpoolGroupLabels, values BufferpoolGroupIndexReadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"logical":  values.Logical,
		"physical": values.Physical,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c BufferpoolGroupIndexReadsContext) SetUpdateEvery(state *framework.CollectorState, labels BufferpoolGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// BufferpoolGroupPagesValues defines the type-safe values for BufferpoolGroup.Pages context
type BufferpoolGroupPagesValues struct {
	Used  int64
	Total int64
}

// BufferpoolGroupPagesContext provides type-safe operations for BufferpoolGroup.Pages context
type BufferpoolGroupPagesContext struct {
	framework.Context[BufferpoolGroupLabels]
}

// Set provides type-safe dimension setting for BufferpoolGroup.Pages context
func (c BufferpoolGroupPagesContext) Set(state *framework.CollectorState, labels BufferpoolGroupLabels, values BufferpoolGroupPagesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"used":  values.Used,
		"total": values.Total,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c BufferpoolGroupPagesContext) SetUpdateEvery(state *framework.CollectorState, labels BufferpoolGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// BufferpoolGroupWritesValues defines the type-safe values for BufferpoolGroup.Writes context
type BufferpoolGroupWritesValues struct {
	Writes int64
}

// BufferpoolGroupWritesContext provides type-safe operations for BufferpoolGroup.Writes context
type BufferpoolGroupWritesContext struct {
	framework.Context[BufferpoolGroupLabels]
}

// Set provides type-safe dimension setting for BufferpoolGroup.Writes context
func (c BufferpoolGroupWritesContext) Set(state *framework.CollectorState, labels BufferpoolGroupLabels, values BufferpoolGroupWritesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"writes": values.Writes,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c BufferpoolGroupWritesContext) SetUpdateEvery(state *framework.CollectorState, labels BufferpoolGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// BufferpoolGroupLabels defines the required labels for BufferpoolGroup contexts
type BufferpoolGroupLabels struct {
	Group string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l BufferpoolGroupLabels) InstanceID(contextName string) string {
	// Label order from YAML: group
	return contextName + "." + cleanLabelValue(l.Group)
}

// BufferpoolGroup contains all metric contexts for BufferpoolGroup
var BufferpoolGroup = struct {
	HitRatio         BufferpoolGroupHitRatioContext
	DetailedHitRatio BufferpoolGroupDetailedHitRatioContext
	Reads            BufferpoolGroupReadsContext
	DataReads        BufferpoolGroupDataReadsContext
	IndexReads       BufferpoolGroupIndexReadsContext
	Pages            BufferpoolGroupPagesContext
	Writes           BufferpoolGroupWritesContext
}{
	HitRatio: BufferpoolGroupHitRatioContext{
		Context: framework.Context[BufferpoolGroupLabels]{
			Name:        "db2.bufferpool_group_hit_ratio",
			Family:      "bufferpools/groups",
			Title:       "Buffer Pool Group Hit Ratio",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    1117,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "overall",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	DetailedHitRatio: BufferpoolGroupDetailedHitRatioContext{
		Context: framework.Context[BufferpoolGroupLabels]{
			Name:        "db2.bufferpool_group_detailed_hit_ratio",
			Family:      "bufferpools/groups",
			Title:       "Buffer Pool Group Detailed Hit Ratios",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    1118,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "data",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "index",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "xda",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "column",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	Reads: BufferpoolGroupReadsContext{
		Context: framework.Context[BufferpoolGroupLabels]{
			Name:        "db2.bufferpool_group_reads",
			Family:      "bufferpools/groups",
			Title:       "Buffer Pool Group Reads",
			Units:       "reads/s",
			Type:        module.Stacked,
			Priority:    1119,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "logical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "physical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	DataReads: BufferpoolGroupDataReadsContext{
		Context: framework.Context[BufferpoolGroupLabels]{
			Name:        "db2.bufferpool_group_data_reads",
			Family:      "bufferpools/groups",
			Title:       "Buffer Pool Group Data Reads",
			Units:       "reads/s",
			Type:        module.Stacked,
			Priority:    1120,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "logical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "physical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	IndexReads: BufferpoolGroupIndexReadsContext{
		Context: framework.Context[BufferpoolGroupLabels]{
			Name:        "db2.bufferpool_group_index_reads",
			Family:      "bufferpools/groups",
			Title:       "Buffer Pool Group Index Reads",
			Units:       "reads/s",
			Type:        module.Stacked,
			Priority:    1121,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "logical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "physical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	Pages: BufferpoolGroupPagesContext{
		Context: framework.Context[BufferpoolGroupLabels]{
			Name:        "db2.bufferpool_group_pages",
			Family:      "bufferpools/groups",
			Title:       "Buffer Pool Group Pages",
			Units:       "pages",
			Type:        module.Stacked,
			Priority:    1122,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	Writes: BufferpoolGroupWritesContext{
		Context: framework.Context[BufferpoolGroupLabels]{
			Name:        "db2.bufferpool_group_writes",
			Family:      "bufferpools/groups",
			Title:       "Buffer Pool Group Writes",
			Units:       "writes/s",
			Type:        module.Line,
			Priority:    1123,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "writes",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
}

// --- Connection ---

// ConnectionStateValues defines the type-safe values for Connection.State context
type ConnectionStateValues struct {
	State int64
}

// ConnectionStateContext provides type-safe operations for Connection.State context
type ConnectionStateContext struct {
	framework.Context[ConnectionLabels]
}

// Set provides type-safe dimension setting for Connection.State context
func (c ConnectionStateContext) Set(state *framework.CollectorState, labels ConnectionLabels, values ConnectionStateValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"state": values.State,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ConnectionStateContext) SetUpdateEvery(state *framework.CollectorState, labels ConnectionLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ConnectionActivityValues defines the type-safe values for Connection.Activity context
type ConnectionActivityValues struct {
	Read    int64
	Written int64
}

// ConnectionActivityContext provides type-safe operations for Connection.Activity context
type ConnectionActivityContext struct {
	framework.Context[ConnectionLabels]
}

// Set provides type-safe dimension setting for Connection.Activity context
func (c ConnectionActivityContext) Set(state *framework.CollectorState, labels ConnectionLabels, values ConnectionActivityValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"read":    values.Read,
		"written": values.Written,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ConnectionActivityContext) SetUpdateEvery(state *framework.CollectorState, labels ConnectionLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ConnectionWaitTimeValues defines the type-safe values for Connection.WaitTime context
type ConnectionWaitTimeValues struct {
	Lock         int64
	Log_disk     int64
	Log_buffer   int64
	Pool_read    int64
	Pool_write   int64
	Direct_read  int64
	Direct_write int64
	Fcm_recv     int64
	Fcm_send     int64
}

// ConnectionWaitTimeContext provides type-safe operations for Connection.WaitTime context
type ConnectionWaitTimeContext struct {
	framework.Context[ConnectionLabels]
}

// Set provides type-safe dimension setting for Connection.WaitTime context
func (c ConnectionWaitTimeContext) Set(state *framework.CollectorState, labels ConnectionLabels, values ConnectionWaitTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"lock":         values.Lock,
		"log_disk":     values.Log_disk,
		"log_buffer":   values.Log_buffer,
		"pool_read":    values.Pool_read,
		"pool_write":   values.Pool_write,
		"direct_read":  values.Direct_read,
		"direct_write": values.Direct_write,
		"fcm_recv":     values.Fcm_recv,
		"fcm_send":     values.Fcm_send,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ConnectionWaitTimeContext) SetUpdateEvery(state *framework.CollectorState, labels ConnectionLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ConnectionProcessingTimeValues defines the type-safe values for Connection.ProcessingTime context
type ConnectionProcessingTimeValues struct {
	Routine  int64
	Compile  int64
	Section  int64
	Commit   int64
	Rollback int64
}

// ConnectionProcessingTimeContext provides type-safe operations for Connection.ProcessingTime context
type ConnectionProcessingTimeContext struct {
	framework.Context[ConnectionLabels]
}

// Set provides type-safe dimension setting for Connection.ProcessingTime context
func (c ConnectionProcessingTimeContext) Set(state *framework.CollectorState, labels ConnectionLabels, values ConnectionProcessingTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"routine":  values.Routine,
		"compile":  values.Compile,
		"section":  values.Section,
		"commit":   values.Commit,
		"rollback": values.Rollback,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ConnectionProcessingTimeContext) SetUpdateEvery(state *framework.CollectorState, labels ConnectionLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ConnectionLabels defines the required labels for Connection contexts
type ConnectionLabels struct {
	Application_id   string
	Application_name string
	Client_hostname  string
	Client_ip        string
	Client_user      string
	State            string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l ConnectionLabels) InstanceID(contextName string) string {
	// Label order from YAML: application_id, application_name, client_hostname, client_ip, client_user, state
	return contextName + "." + cleanLabelValue(l.Application_id) + "_" + cleanLabelValue(l.Application_name) + "_" + cleanLabelValue(l.Client_hostname) + "_" + cleanLabelValue(l.Client_ip) + "_" + cleanLabelValue(l.Client_user) + "_" + cleanLabelValue(l.State)
}

// Connection contains all metric contexts for Connection
var Connection = struct {
	State          ConnectionStateContext
	Activity       ConnectionActivityContext
	WaitTime       ConnectionWaitTimeContext
	ProcessingTime ConnectionProcessingTimeContext
}{
	State: ConnectionStateContext{
		Context: framework.Context[ConnectionLabels]{
			Name:        "db2.connection_state",
			Family:      "connections/instances",
			Title:       "Connection State",
			Units:       "state",
			Type:        module.Line,
			Priority:    1130,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "state",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"application_id",
				"application_name",
				"client_hostname",
				"client_ip",
				"client_user",
				"state",
			},
		},
	},
	Activity: ConnectionActivityContext{
		Context: framework.Context[ConnectionLabels]{
			Name:        "db2.connection_activity",
			Family:      "connections/instances",
			Title:       "Connection Row Activity",
			Units:       "rows/s",
			Type:        module.Area,
			Priority:    1131,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "read",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "written",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"application_id",
				"application_name",
				"client_hostname",
				"client_ip",
				"client_user",
				"state",
			},
		},
	},
	WaitTime: ConnectionWaitTimeContext{
		Context: framework.Context[ConnectionLabels]{
			Name:        "db2.connection_wait_time",
			Family:      "connections/instances",
			Title:       "Connection Wait Time",
			Units:       "milliseconds",
			Type:        module.Stacked,
			Priority:    1132,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "lock",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "log_disk",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "log_buffer",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "pool_read",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "pool_write",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "direct_read",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "direct_write",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "fcm_recv",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "fcm_send",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"application_id",
				"application_name",
				"client_hostname",
				"client_ip",
				"client_user",
				"state",
			},
		},
	},
	ProcessingTime: ConnectionProcessingTimeContext{
		Context: framework.Context[ConnectionLabels]{
			Name:        "db2.connection_processing_time",
			Family:      "connections/instances",
			Title:       "Connection Processing Time",
			Units:       "milliseconds",
			Type:        module.Stacked,
			Priority:    1133,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "routine",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "compile",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "section",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "commit",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "rollback",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"application_id",
				"application_name",
				"client_hostname",
				"client_ip",
				"client_user",
				"state",
			},
		},
	},
}

// --- ConnectionGroup ---

// ConnectionGroupCountValues defines the type-safe values for ConnectionGroup.Count context
type ConnectionGroupCountValues struct {
	Count int64
}

// ConnectionGroupCountContext provides type-safe operations for ConnectionGroup.Count context
type ConnectionGroupCountContext struct {
	framework.Context[ConnectionGroupLabels]
}

// Set provides type-safe dimension setting for ConnectionGroup.Count context
func (c ConnectionGroupCountContext) Set(state *framework.CollectorState, labels ConnectionGroupLabels, values ConnectionGroupCountValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"count": values.Count,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ConnectionGroupCountContext) SetUpdateEvery(state *framework.CollectorState, labels ConnectionGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ConnectionGroupStateValues defines the type-safe values for ConnectionGroup.State context
type ConnectionGroupStateValues struct {
	State int64
}

// ConnectionGroupStateContext provides type-safe operations for ConnectionGroup.State context
type ConnectionGroupStateContext struct {
	framework.Context[ConnectionGroupLabels]
}

// Set provides type-safe dimension setting for ConnectionGroup.State context
func (c ConnectionGroupStateContext) Set(state *framework.CollectorState, labels ConnectionGroupLabels, values ConnectionGroupStateValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"state": values.State,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ConnectionGroupStateContext) SetUpdateEvery(state *framework.CollectorState, labels ConnectionGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ConnectionGroupActivityValues defines the type-safe values for ConnectionGroup.Activity context
type ConnectionGroupActivityValues struct {
	Read    int64
	Written int64
}

// ConnectionGroupActivityContext provides type-safe operations for ConnectionGroup.Activity context
type ConnectionGroupActivityContext struct {
	framework.Context[ConnectionGroupLabels]
}

// Set provides type-safe dimension setting for ConnectionGroup.Activity context
func (c ConnectionGroupActivityContext) Set(state *framework.CollectorState, labels ConnectionGroupLabels, values ConnectionGroupActivityValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"read":    values.Read,
		"written": values.Written,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ConnectionGroupActivityContext) SetUpdateEvery(state *framework.CollectorState, labels ConnectionGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ConnectionGroupWaitTimeValues defines the type-safe values for ConnectionGroup.WaitTime context
type ConnectionGroupWaitTimeValues struct {
	Lock         int64
	Log_disk     int64
	Log_buffer   int64
	Pool_read    int64
	Pool_write   int64
	Direct_read  int64
	Direct_write int64
	Fcm_recv     int64
	Fcm_send     int64
}

// ConnectionGroupWaitTimeContext provides type-safe operations for ConnectionGroup.WaitTime context
type ConnectionGroupWaitTimeContext struct {
	framework.Context[ConnectionGroupLabels]
}

// Set provides type-safe dimension setting for ConnectionGroup.WaitTime context
func (c ConnectionGroupWaitTimeContext) Set(state *framework.CollectorState, labels ConnectionGroupLabels, values ConnectionGroupWaitTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"lock":         values.Lock,
		"log_disk":     values.Log_disk,
		"log_buffer":   values.Log_buffer,
		"pool_read":    values.Pool_read,
		"pool_write":   values.Pool_write,
		"direct_read":  values.Direct_read,
		"direct_write": values.Direct_write,
		"fcm_recv":     values.Fcm_recv,
		"fcm_send":     values.Fcm_send,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ConnectionGroupWaitTimeContext) SetUpdateEvery(state *framework.CollectorState, labels ConnectionGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ConnectionGroupProcessingTimeValues defines the type-safe values for ConnectionGroup.ProcessingTime context
type ConnectionGroupProcessingTimeValues struct {
	Routine  int64
	Compile  int64
	Section  int64
	Commit   int64
	Rollback int64
}

// ConnectionGroupProcessingTimeContext provides type-safe operations for ConnectionGroup.ProcessingTime context
type ConnectionGroupProcessingTimeContext struct {
	framework.Context[ConnectionGroupLabels]
}

// Set provides type-safe dimension setting for ConnectionGroup.ProcessingTime context
func (c ConnectionGroupProcessingTimeContext) Set(state *framework.CollectorState, labels ConnectionGroupLabels, values ConnectionGroupProcessingTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"routine":  values.Routine,
		"compile":  values.Compile,
		"section":  values.Section,
		"commit":   values.Commit,
		"rollback": values.Rollback,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ConnectionGroupProcessingTimeContext) SetUpdateEvery(state *framework.CollectorState, labels ConnectionGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ConnectionGroupLabels defines the required labels for ConnectionGroup contexts
type ConnectionGroupLabels struct {
	Group string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l ConnectionGroupLabels) InstanceID(contextName string) string {
	// Label order from YAML: group
	return contextName + "." + cleanLabelValue(l.Group)
}

// ConnectionGroup contains all metric contexts for ConnectionGroup
var ConnectionGroup = struct {
	Count          ConnectionGroupCountContext
	State          ConnectionGroupStateContext
	Activity       ConnectionGroupActivityContext
	WaitTime       ConnectionGroupWaitTimeContext
	ProcessingTime ConnectionGroupProcessingTimeContext
}{
	Count: ConnectionGroupCountContext{
		Context: framework.Context[ConnectionGroupLabels]{
			Name:        "db2.connection_group.count",
			Family:      "connections/groups",
			Title:       "Connection Group Count",
			Units:       "connections",
			Type:        module.Line,
			Priority:    1134,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "count",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	State: ConnectionGroupStateContext{
		Context: framework.Context[ConnectionGroupLabels]{
			Name:        "db2.connection_group.state",
			Family:      "connections/groups",
			Title:       "Connection Group State Sum",
			Units:       "state",
			Type:        module.Line,
			Priority:    1135,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "state",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	Activity: ConnectionGroupActivityContext{
		Context: framework.Context[ConnectionGroupLabels]{
			Name:        "db2.connection_group.activity",
			Family:      "connections/groups",
			Title:       "Connection Group Row Activity",
			Units:       "rows/s",
			Type:        module.Area,
			Priority:    1136,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "read",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "written",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	WaitTime: ConnectionGroupWaitTimeContext{
		Context: framework.Context[ConnectionGroupLabels]{
			Name:        "db2.connection_group.wait_time",
			Family:      "connections/groups",
			Title:       "Connection Group Wait Time",
			Units:       "milliseconds",
			Type:        module.Stacked,
			Priority:    1137,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "lock",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "log_disk",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "log_buffer",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "pool_read",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "pool_write",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "direct_read",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "direct_write",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "fcm_recv",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "fcm_send",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	ProcessingTime: ConnectionGroupProcessingTimeContext{
		Context: framework.Context[ConnectionGroupLabels]{
			Name:        "db2.connection_group.processing_time",
			Family:      "connections/groups",
			Title:       "Connection Group Processing Time",
			Units:       "milliseconds",
			Type:        module.Stacked,
			Priority:    1138,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "routine",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "compile",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "section",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "commit",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "rollback",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
}

// --- Database ---

// DatabaseStatusValues defines the type-safe values for Database.Status context
type DatabaseStatusValues struct {
	Status int64
}

// DatabaseStatusContext provides type-safe operations for Database.Status context
type DatabaseStatusContext struct {
	framework.Context[DatabaseLabels]
}

// Set provides type-safe dimension setting for Database.Status context
func (c DatabaseStatusContext) Set(state *framework.CollectorState, labels DatabaseLabels, values DatabaseStatusValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"status": values.Status,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c DatabaseStatusContext) SetUpdateEvery(state *framework.CollectorState, labels DatabaseLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// DatabaseApplicationsValues defines the type-safe values for Database.Applications context
type DatabaseApplicationsValues struct {
	Applications int64
}

// DatabaseApplicationsContext provides type-safe operations for Database.Applications context
type DatabaseApplicationsContext struct {
	framework.Context[DatabaseLabels]
}

// Set provides type-safe dimension setting for Database.Applications context
func (c DatabaseApplicationsContext) Set(state *framework.CollectorState, labels DatabaseLabels, values DatabaseApplicationsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"applications": values.Applications,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c DatabaseApplicationsContext) SetUpdateEvery(state *framework.CollectorState, labels DatabaseLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// DatabaseLabels defines the required labels for Database contexts
type DatabaseLabels struct {
	Database string
	Status   string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l DatabaseLabels) InstanceID(contextName string) string {
	// Label order from YAML: database, status
	return contextName + "." + cleanLabelValue(l.Database) + "_" + cleanLabelValue(l.Status)
}

// Database contains all metric contexts for Database
var Database = struct {
	Status       DatabaseStatusContext
	Applications DatabaseApplicationsContext
}{
	Status: DatabaseStatusContext{
		Context: framework.Context[DatabaseLabels]{
			Name:        "db2.database_instance_status",
			Family:      "databases",
			Title:       "Database Status",
			Units:       "status",
			Type:        module.Line,
			Priority:    1100,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "status",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"database",
				"status",
			},
		},
	},
	Applications: DatabaseApplicationsContext{
		Context: framework.Context[DatabaseLabels]{
			Name:        "db2.database_applications",
			Family:      "databases",
			Title:       "Database Applications",
			Units:       "applications",
			Type:        module.Line,
			Priority:    1101,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "applications",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"database",
				"status",
			},
		},
	},
}

// --- Index ---

// IndexUsageValues defines the type-safe values for Index.Usage context
type IndexUsageValues struct {
	Index int64
	Full  int64
}

// IndexUsageContext provides type-safe operations for Index.Usage context
type IndexUsageContext struct {
	framework.Context[IndexLabels]
}

// Set provides type-safe dimension setting for Index.Usage context
func (c IndexUsageContext) Set(state *framework.CollectorState, labels IndexLabels, values IndexUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"index": values.Index,
		"full":  values.Full,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c IndexUsageContext) SetUpdateEvery(state *framework.CollectorState, labels IndexLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// IndexLabels defines the required labels for Index contexts
type IndexLabels struct {
	Index string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l IndexLabels) InstanceID(contextName string) string {
	// Label order from YAML: index
	return contextName + "." + cleanLabelValue(l.Index)
}

// Index contains all metric contexts for Index
var Index = struct {
	Usage IndexUsageContext
}{
	Usage: IndexUsageContext{
		Context: framework.Context[IndexLabels]{
			Name:        "db2.index_usage",
			Family:      "indexes",
			Title:       "Index Usage",
			Units:       "scans/s",
			Type:        module.Area,
			Priority:    1150,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "index",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "full",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"index",
			},
		},
	},
}

// --- IndexGroup ---

// IndexGroupUsageValues defines the type-safe values for IndexGroup.Usage context
type IndexGroupUsageValues struct {
	Index int64
	Full  int64
}

// IndexGroupUsageContext provides type-safe operations for IndexGroup.Usage context
type IndexGroupUsageContext struct {
	framework.Context[IndexGroupLabels]
}

// Set provides type-safe dimension setting for IndexGroup.Usage context
func (c IndexGroupUsageContext) Set(state *framework.CollectorState, labels IndexGroupLabels, values IndexGroupUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"index": values.Index,
		"full":  values.Full,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c IndexGroupUsageContext) SetUpdateEvery(state *framework.CollectorState, labels IndexGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// IndexGroupLabels defines the required labels for IndexGroup contexts
type IndexGroupLabels struct {
	Group string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l IndexGroupLabels) InstanceID(contextName string) string {
	// Label order from YAML: group
	return contextName + "." + cleanLabelValue(l.Group)
}

// IndexGroup contains all metric contexts for IndexGroup
var IndexGroup = struct {
	Usage IndexGroupUsageContext
}{
	Usage: IndexGroupUsageContext{
		Context: framework.Context[IndexGroupLabels]{
			Name:        "db2.index_group_usage",
			Family:      "indexes/groups",
			Title:       "Index Group Usage",
			Units:       "scans/s",
			Type:        module.Area,
			Priority:    1151,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "index",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "full",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
}

// --- MemoryPool ---

// MemoryPoolUsageValues defines the type-safe values for MemoryPool.Usage context
type MemoryPoolUsageValues struct {
	Used int64
}

// MemoryPoolUsageContext provides type-safe operations for MemoryPool.Usage context
type MemoryPoolUsageContext struct {
	framework.Context[MemoryPoolLabels]
}

// Set provides type-safe dimension setting for MemoryPool.Usage context
func (c MemoryPoolUsageContext) Set(state *framework.CollectorState, labels MemoryPoolLabels, values MemoryPoolUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"used": values.Used,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c MemoryPoolUsageContext) SetUpdateEvery(state *framework.CollectorState, labels MemoryPoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// MemoryPoolHighWaterMarkValues defines the type-safe values for MemoryPool.HighWaterMark context
type MemoryPoolHighWaterMarkValues struct {
	Hwm int64
}

// MemoryPoolHighWaterMarkContext provides type-safe operations for MemoryPool.HighWaterMark context
type MemoryPoolHighWaterMarkContext struct {
	framework.Context[MemoryPoolLabels]
}

// Set provides type-safe dimension setting for MemoryPool.HighWaterMark context
func (c MemoryPoolHighWaterMarkContext) Set(state *framework.CollectorState, labels MemoryPoolLabels, values MemoryPoolHighWaterMarkValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"hwm": values.Hwm,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c MemoryPoolHighWaterMarkContext) SetUpdateEvery(state *framework.CollectorState, labels MemoryPoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// MemoryPoolLabels defines the required labels for MemoryPool contexts
type MemoryPoolLabels struct {
	Pool_type string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l MemoryPoolLabels) InstanceID(contextName string) string {
	// Label order from YAML: pool_type
	return contextName + "." + cleanLabelValue(l.Pool_type)
}

// MemoryPool contains all metric contexts for MemoryPool
var MemoryPool = struct {
	Usage         MemoryPoolUsageContext
	HighWaterMark MemoryPoolHighWaterMarkContext
}{
	Usage: MemoryPoolUsageContext{
		Context: framework.Context[MemoryPoolLabels]{
			Name:        "db2.memory_pool_usage",
			Family:      "memory",
			Title:       "Memory Pool Usage",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    1160,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"pool_type",
			},
		},
	},
	HighWaterMark: MemoryPoolHighWaterMarkContext{
		Context: framework.Context[MemoryPoolLabels]{
			Name:        "db2.memory_pool_hwm",
			Family:      "memory",
			Title:       "Memory Pool High Water Mark",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    1161,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "hwm",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"pool_type",
			},
		},
	},
}

// --- MemorySet ---

// MemorySetUsageValues defines the type-safe values for MemorySet.Usage context
type MemorySetUsageValues struct {
	Used int64
}

// MemorySetUsageContext provides type-safe operations for MemorySet.Usage context
type MemorySetUsageContext struct {
	framework.Context[MemorySetLabels]
}

// Set provides type-safe dimension setting for MemorySet.Usage context
func (c MemorySetUsageContext) Set(state *framework.CollectorState, labels MemorySetLabels, values MemorySetUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"used": values.Used,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c MemorySetUsageContext) SetUpdateEvery(state *framework.CollectorState, labels MemorySetLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// MemorySetCommittedValues defines the type-safe values for MemorySet.Committed context
type MemorySetCommittedValues struct {
	Committed int64
}

// MemorySetCommittedContext provides type-safe operations for MemorySet.Committed context
type MemorySetCommittedContext struct {
	framework.Context[MemorySetLabels]
}

// Set provides type-safe dimension setting for MemorySet.Committed context
func (c MemorySetCommittedContext) Set(state *framework.CollectorState, labels MemorySetLabels, values MemorySetCommittedValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"committed": values.Committed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c MemorySetCommittedContext) SetUpdateEvery(state *framework.CollectorState, labels MemorySetLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// MemorySetHighWaterMarkValues defines the type-safe values for MemorySet.HighWaterMark context
type MemorySetHighWaterMarkValues struct {
	Hwm int64
}

// MemorySetHighWaterMarkContext provides type-safe operations for MemorySet.HighWaterMark context
type MemorySetHighWaterMarkContext struct {
	framework.Context[MemorySetLabels]
}

// Set provides type-safe dimension setting for MemorySet.HighWaterMark context
func (c MemorySetHighWaterMarkContext) Set(state *framework.CollectorState, labels MemorySetLabels, values MemorySetHighWaterMarkValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"hwm": values.Hwm,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c MemorySetHighWaterMarkContext) SetUpdateEvery(state *framework.CollectorState, labels MemorySetLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// MemorySetAdditionalCommittedValues defines the type-safe values for MemorySet.AdditionalCommitted context
type MemorySetAdditionalCommittedValues struct {
	Additional int64
}

// MemorySetAdditionalCommittedContext provides type-safe operations for MemorySet.AdditionalCommitted context
type MemorySetAdditionalCommittedContext struct {
	framework.Context[MemorySetLabels]
}

// Set provides type-safe dimension setting for MemorySet.AdditionalCommitted context
func (c MemorySetAdditionalCommittedContext) Set(state *framework.CollectorState, labels MemorySetLabels, values MemorySetAdditionalCommittedValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"additional": values.Additional,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c MemorySetAdditionalCommittedContext) SetUpdateEvery(state *framework.CollectorState, labels MemorySetLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// MemorySetPercentUsedHWMValues defines the type-safe values for MemorySet.PercentUsedHWM context
type MemorySetPercentUsedHWMValues struct {
	Used_hwm int64
}

// MemorySetPercentUsedHWMContext provides type-safe operations for MemorySet.PercentUsedHWM context
type MemorySetPercentUsedHWMContext struct {
	framework.Context[MemorySetLabels]
}

// Set provides type-safe dimension setting for MemorySet.PercentUsedHWM context
func (c MemorySetPercentUsedHWMContext) Set(state *framework.CollectorState, labels MemorySetLabels, values MemorySetPercentUsedHWMValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"used_hwm": values.Used_hwm,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c MemorySetPercentUsedHWMContext) SetUpdateEvery(state *framework.CollectorState, labels MemorySetLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// MemorySetLabels defines the required labels for MemorySet contexts
type MemorySetLabels struct {
	Host     string
	Database string
	Set_type string
	Member   string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l MemorySetLabels) InstanceID(contextName string) string {
	// Label order from YAML: host, database, set_type, member
	return contextName + "." + cleanLabelValue(l.Host) + "_" + cleanLabelValue(l.Database) + "_" + cleanLabelValue(l.Set_type) + "_" + cleanLabelValue(l.Member)
}

// MemorySet contains all metric contexts for MemorySet
var MemorySet = struct {
	Usage               MemorySetUsageContext
	Committed           MemorySetCommittedContext
	HighWaterMark       MemorySetHighWaterMarkContext
	AdditionalCommitted MemorySetAdditionalCommittedContext
	PercentUsedHWM      MemorySetPercentUsedHWMContext
}{
	Usage: MemorySetUsageContext{
		Context: framework.Context[MemorySetLabels]{
			Name:        "db2.memory_set_usage",
			Family:      "memory_sets",
			Title:       "Memory Set Usage",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    1180,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"host",
				"database",
				"set_type",
				"member",
			},
		},
	},
	Committed: MemorySetCommittedContext{
		Context: framework.Context[MemorySetLabels]{
			Name:        "db2.memory_set_committed",
			Family:      "memory_sets",
			Title:       "Memory Set Committed",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    1181,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "committed",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"host",
				"database",
				"set_type",
				"member",
			},
		},
	},
	HighWaterMark: MemorySetHighWaterMarkContext{
		Context: framework.Context[MemorySetLabels]{
			Name:        "db2.memory_set_high_water_mark",
			Family:      "memory_sets",
			Title:       "Memory Set High Water Mark",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    1182,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "hwm",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"host",
				"database",
				"set_type",
				"member",
			},
		},
	},
	AdditionalCommitted: MemorySetAdditionalCommittedContext{
		Context: framework.Context[MemorySetLabels]{
			Name:        "db2.memory_set_additional_committed",
			Family:      "memory_sets",
			Title:       "Memory Set Additional Committed",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    1183,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "additional",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"host",
				"database",
				"set_type",
				"member",
			},
		},
	},
	PercentUsedHWM: MemorySetPercentUsedHWMContext{
		Context: framework.Context[MemorySetLabels]{
			Name:        "db2.memory_set_percent_used_hwm",
			Family:      "memory_sets",
			Title:       "Memory Set Percent Used vs HWM",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    1184,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "used_hwm",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{
				"host",
				"database",
				"set_type",
				"member",
			},
		},
	},
}

// --- Prefetcher ---

// PrefetcherPrefetchRatioValues defines the type-safe values for Prefetcher.PrefetchRatio context
type PrefetcherPrefetchRatioValues struct {
	Ratio int64
}

// PrefetcherPrefetchRatioContext provides type-safe operations for Prefetcher.PrefetchRatio context
type PrefetcherPrefetchRatioContext struct {
	framework.Context[PrefetcherLabels]
}

// Set provides type-safe dimension setting for Prefetcher.PrefetchRatio context
func (c PrefetcherPrefetchRatioContext) Set(state *framework.CollectorState, labels PrefetcherLabels, values PrefetcherPrefetchRatioValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"ratio": values.Ratio,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c PrefetcherPrefetchRatioContext) SetUpdateEvery(state *framework.CollectorState, labels PrefetcherLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// PrefetcherCleanerRatioValues defines the type-safe values for Prefetcher.CleanerRatio context
type PrefetcherCleanerRatioValues struct {
	Ratio int64
}

// PrefetcherCleanerRatioContext provides type-safe operations for Prefetcher.CleanerRatio context
type PrefetcherCleanerRatioContext struct {
	framework.Context[PrefetcherLabels]
}

// Set provides type-safe dimension setting for Prefetcher.CleanerRatio context
func (c PrefetcherCleanerRatioContext) Set(state *framework.CollectorState, labels PrefetcherLabels, values PrefetcherCleanerRatioValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"ratio": values.Ratio,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c PrefetcherCleanerRatioContext) SetUpdateEvery(state *framework.CollectorState, labels PrefetcherLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// PrefetcherPhysicalReadsValues defines the type-safe values for Prefetcher.PhysicalReads context
type PrefetcherPhysicalReadsValues struct {
	Reads int64
}

// PrefetcherPhysicalReadsContext provides type-safe operations for Prefetcher.PhysicalReads context
type PrefetcherPhysicalReadsContext struct {
	framework.Context[PrefetcherLabels]
}

// Set provides type-safe dimension setting for Prefetcher.PhysicalReads context
func (c PrefetcherPhysicalReadsContext) Set(state *framework.CollectorState, labels PrefetcherLabels, values PrefetcherPhysicalReadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"reads": values.Reads,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c PrefetcherPhysicalReadsContext) SetUpdateEvery(state *framework.CollectorState, labels PrefetcherLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// PrefetcherAsyncReadsValues defines the type-safe values for Prefetcher.AsyncReads context
type PrefetcherAsyncReadsValues struct {
	Reads int64
}

// PrefetcherAsyncReadsContext provides type-safe operations for Prefetcher.AsyncReads context
type PrefetcherAsyncReadsContext struct {
	framework.Context[PrefetcherLabels]
}

// Set provides type-safe dimension setting for Prefetcher.AsyncReads context
func (c PrefetcherAsyncReadsContext) Set(state *framework.CollectorState, labels PrefetcherLabels, values PrefetcherAsyncReadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"reads": values.Reads,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c PrefetcherAsyncReadsContext) SetUpdateEvery(state *framework.CollectorState, labels PrefetcherLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// PrefetcherWaitTimeValues defines the type-safe values for Prefetcher.WaitTime context
type PrefetcherWaitTimeValues struct {
	Wait_time int64
}

// PrefetcherWaitTimeContext provides type-safe operations for Prefetcher.WaitTime context
type PrefetcherWaitTimeContext struct {
	framework.Context[PrefetcherLabels]
}

// Set provides type-safe dimension setting for Prefetcher.WaitTime context
func (c PrefetcherWaitTimeContext) Set(state *framework.CollectorState, labels PrefetcherLabels, values PrefetcherWaitTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"wait_time": values.Wait_time,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c PrefetcherWaitTimeContext) SetUpdateEvery(state *framework.CollectorState, labels PrefetcherLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// PrefetcherUnreadPagesValues defines the type-safe values for Prefetcher.UnreadPages context
type PrefetcherUnreadPagesValues struct {
	Unread int64
}

// PrefetcherUnreadPagesContext provides type-safe operations for Prefetcher.UnreadPages context
type PrefetcherUnreadPagesContext struct {
	framework.Context[PrefetcherLabels]
}

// Set provides type-safe dimension setting for Prefetcher.UnreadPages context
func (c PrefetcherUnreadPagesContext) Set(state *framework.CollectorState, labels PrefetcherLabels, values PrefetcherUnreadPagesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"unread": values.Unread,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c PrefetcherUnreadPagesContext) SetUpdateEvery(state *framework.CollectorState, labels PrefetcherLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// PrefetcherLabels defines the required labels for Prefetcher contexts
type PrefetcherLabels struct {
	Bufferpool string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l PrefetcherLabels) InstanceID(contextName string) string {
	// Label order from YAML: bufferpool
	return contextName + "." + cleanLabelValue(l.Bufferpool)
}

// Prefetcher contains all metric contexts for Prefetcher
var Prefetcher = struct {
	PrefetchRatio PrefetcherPrefetchRatioContext
	CleanerRatio  PrefetcherCleanerRatioContext
	PhysicalReads PrefetcherPhysicalReadsContext
	AsyncReads    PrefetcherAsyncReadsContext
	WaitTime      PrefetcherWaitTimeContext
	UnreadPages   PrefetcherUnreadPagesContext
}{
	PrefetchRatio: PrefetcherPrefetchRatioContext{
		Context: framework.Context[PrefetcherLabels]{
			Name:        "db2.prefetcher_prefetch_ratio",
			Family:      "prefetchers",
			Title:       "Prefetcher Prefetch Ratio",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    1190,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "ratio",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{
				"bufferpool",
			},
		},
	},
	CleanerRatio: PrefetcherCleanerRatioContext{
		Context: framework.Context[PrefetcherLabels]{
			Name:        "db2.prefetcher_cleaner_ratio",
			Family:      "prefetchers",
			Title:       "Prefetcher Cleaner Ratio",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    1191,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "ratio",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{
				"bufferpool",
			},
		},
	},
	PhysicalReads: PrefetcherPhysicalReadsContext{
		Context: framework.Context[PrefetcherLabels]{
			Name:        "db2.prefetcher_physical_reads",
			Family:      "prefetchers",
			Title:       "Prefetcher Physical Reads",
			Units:       "reads/s",
			Type:        module.Line,
			Priority:    1192,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "reads",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"bufferpool",
			},
		},
	},
	AsyncReads: PrefetcherAsyncReadsContext{
		Context: framework.Context[PrefetcherLabels]{
			Name:        "db2.prefetcher_async_reads",
			Family:      "prefetchers",
			Title:       "Prefetcher Asynchronous Reads",
			Units:       "reads/s",
			Type:        module.Line,
			Priority:    1193,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "reads",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"bufferpool",
			},
		},
	},
	WaitTime: PrefetcherWaitTimeContext{
		Context: framework.Context[PrefetcherLabels]{
			Name:        "db2.prefetcher_wait_time",
			Family:      "prefetchers",
			Title:       "Prefetcher Wait Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    1194,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "wait_time",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"bufferpool",
			},
		},
	},
	UnreadPages: PrefetcherUnreadPagesContext{
		Context: framework.Context[PrefetcherLabels]{
			Name:        "db2.prefetcher_unread_pages",
			Family:      "prefetchers",
			Title:       "Prefetcher Unread Pages",
			Units:       "pages/s",
			Type:        module.Line,
			Priority:    1195,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "unread",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"bufferpool",
			},
		},
	},
}

// --- System ---

// SystemServiceHealthValues defines the type-safe values for System.ServiceHealth context
type SystemServiceHealthValues struct {
	Connection int64
	Database   int64
}

// SystemServiceHealthContext provides type-safe operations for System.ServiceHealth context
type SystemServiceHealthContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.ServiceHealth context
func (c SystemServiceHealthContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemServiceHealthValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"connection": values.Connection,
		"database":   values.Database,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemServiceHealthContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemConnectionsValues defines the type-safe values for System.Connections context
type SystemConnectionsValues struct {
	Total       int64
	Active      int64
	Executing   int64
	Idle        int64
	Max_allowed int64
}

// SystemConnectionsContext provides type-safe operations for System.Connections context
type SystemConnectionsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.Connections context
func (c SystemConnectionsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemConnectionsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"total":       values.Total,
		"active":      values.Active,
		"executing":   values.Executing,
		"idle":        values.Idle,
		"max_allowed": values.Max_allowed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemConnectionsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemLockingValues defines the type-safe values for System.Locking context
type SystemLockingValues struct {
	Waits       int64
	Timeouts    int64
	Escalations int64
}

// SystemLockingContext provides type-safe operations for System.Locking context
type SystemLockingContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.Locking context
func (c SystemLockingContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemLockingValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"waits":       values.Waits,
		"timeouts":    values.Timeouts,
		"escalations": values.Escalations,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemLockingContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemDeadlocksValues defines the type-safe values for System.Deadlocks context
type SystemDeadlocksValues struct {
	Deadlocks int64
}

// SystemDeadlocksContext provides type-safe operations for System.Deadlocks context
type SystemDeadlocksContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.Deadlocks context
func (c SystemDeadlocksContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemDeadlocksValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"deadlocks": values.Deadlocks,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemDeadlocksContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemLockDetailsValues defines the type-safe values for System.LockDetails context
type SystemLockDetailsValues struct {
	Active         int64
	Waiting_agents int64
	Memory_pages   int64
}

// SystemLockDetailsContext provides type-safe operations for System.LockDetails context
type SystemLockDetailsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.LockDetails context
func (c SystemLockDetailsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemLockDetailsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"active":         values.Active,
		"waiting_agents": values.Waiting_agents,
		"memory_pages":   values.Memory_pages,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemLockDetailsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemLockWaitTimeValues defines the type-safe values for System.LockWaitTime context
type SystemLockWaitTimeValues struct {
	Wait_time int64
}

// SystemLockWaitTimeContext provides type-safe operations for System.LockWaitTime context
type SystemLockWaitTimeContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.LockWaitTime context
func (c SystemLockWaitTimeContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemLockWaitTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"wait_time": values.Wait_time,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemLockWaitTimeContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemSortingValues defines the type-safe values for System.Sorting context
type SystemSortingValues struct {
	Sorts     int64
	Overflows int64
}

// SystemSortingContext provides type-safe operations for System.Sorting context
type SystemSortingContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.Sorting context
func (c SystemSortingContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemSortingValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"sorts":     values.Sorts,
		"overflows": values.Overflows,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemSortingContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemRowActivityValues defines the type-safe values for System.RowActivity context
type SystemRowActivityValues struct {
	Read     int64
	Returned int64
	Modified int64
}

// SystemRowActivityContext provides type-safe operations for System.RowActivity context
type SystemRowActivityContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.RowActivity context
func (c SystemRowActivityContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemRowActivityValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"read":     values.Read,
		"returned": values.Returned,
		"modified": values.Modified,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemRowActivityContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemBufferpoolHitRatioValues defines the type-safe values for System.BufferpoolHitRatio context
type SystemBufferpoolHitRatioValues struct {
	Hits   int64
	Misses int64
}

// SystemBufferpoolHitRatioContext provides type-safe operations for System.BufferpoolHitRatio context
type SystemBufferpoolHitRatioContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.BufferpoolHitRatio context
func (c SystemBufferpoolHitRatioContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemBufferpoolHitRatioValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"hits":   values.Hits,
		"misses": values.Misses,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemBufferpoolHitRatioContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemBufferpoolDataHitRatioValues defines the type-safe values for System.BufferpoolDataHitRatio context
type SystemBufferpoolDataHitRatioValues struct {
	Hits   int64
	Misses int64
}

// SystemBufferpoolDataHitRatioContext provides type-safe operations for System.BufferpoolDataHitRatio context
type SystemBufferpoolDataHitRatioContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.BufferpoolDataHitRatio context
func (c SystemBufferpoolDataHitRatioContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemBufferpoolDataHitRatioValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"hits":   values.Hits,
		"misses": values.Misses,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemBufferpoolDataHitRatioContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemBufferpoolIndexHitRatioValues defines the type-safe values for System.BufferpoolIndexHitRatio context
type SystemBufferpoolIndexHitRatioValues struct {
	Hits   int64
	Misses int64
}

// SystemBufferpoolIndexHitRatioContext provides type-safe operations for System.BufferpoolIndexHitRatio context
type SystemBufferpoolIndexHitRatioContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.BufferpoolIndexHitRatio context
func (c SystemBufferpoolIndexHitRatioContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemBufferpoolIndexHitRatioValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"hits":   values.Hits,
		"misses": values.Misses,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemBufferpoolIndexHitRatioContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemBufferpoolXDAHitRatioValues defines the type-safe values for System.BufferpoolXDAHitRatio context
type SystemBufferpoolXDAHitRatioValues struct {
	Hits   int64
	Misses int64
}

// SystemBufferpoolXDAHitRatioContext provides type-safe operations for System.BufferpoolXDAHitRatio context
type SystemBufferpoolXDAHitRatioContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.BufferpoolXDAHitRatio context
func (c SystemBufferpoolXDAHitRatioContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemBufferpoolXDAHitRatioValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"hits":   values.Hits,
		"misses": values.Misses,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemBufferpoolXDAHitRatioContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemBufferpoolColumnHitRatioValues defines the type-safe values for System.BufferpoolColumnHitRatio context
type SystemBufferpoolColumnHitRatioValues struct {
	Hits   int64
	Misses int64
}

// SystemBufferpoolColumnHitRatioContext provides type-safe operations for System.BufferpoolColumnHitRatio context
type SystemBufferpoolColumnHitRatioContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.BufferpoolColumnHitRatio context
func (c SystemBufferpoolColumnHitRatioContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemBufferpoolColumnHitRatioValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"hits":   values.Hits,
		"misses": values.Misses,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemBufferpoolColumnHitRatioContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemBufferpoolReadsValues defines the type-safe values for System.BufferpoolReads context
type SystemBufferpoolReadsValues struct {
	Logical  int64
	Physical int64
}

// SystemBufferpoolReadsContext provides type-safe operations for System.BufferpoolReads context
type SystemBufferpoolReadsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.BufferpoolReads context
func (c SystemBufferpoolReadsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemBufferpoolReadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"logical":  values.Logical,
		"physical": values.Physical,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemBufferpoolReadsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemBufferpoolDataReadsValues defines the type-safe values for System.BufferpoolDataReads context
type SystemBufferpoolDataReadsValues struct {
	Logical  int64
	Physical int64
}

// SystemBufferpoolDataReadsContext provides type-safe operations for System.BufferpoolDataReads context
type SystemBufferpoolDataReadsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.BufferpoolDataReads context
func (c SystemBufferpoolDataReadsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemBufferpoolDataReadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"logical":  values.Logical,
		"physical": values.Physical,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemBufferpoolDataReadsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemBufferpoolIndexReadsValues defines the type-safe values for System.BufferpoolIndexReads context
type SystemBufferpoolIndexReadsValues struct {
	Logical  int64
	Physical int64
}

// SystemBufferpoolIndexReadsContext provides type-safe operations for System.BufferpoolIndexReads context
type SystemBufferpoolIndexReadsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.BufferpoolIndexReads context
func (c SystemBufferpoolIndexReadsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemBufferpoolIndexReadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"logical":  values.Logical,
		"physical": values.Physical,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemBufferpoolIndexReadsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemBufferpoolXDAReadsValues defines the type-safe values for System.BufferpoolXDAReads context
type SystemBufferpoolXDAReadsValues struct {
	Logical  int64
	Physical int64
}

// SystemBufferpoolXDAReadsContext provides type-safe operations for System.BufferpoolXDAReads context
type SystemBufferpoolXDAReadsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.BufferpoolXDAReads context
func (c SystemBufferpoolXDAReadsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemBufferpoolXDAReadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"logical":  values.Logical,
		"physical": values.Physical,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemBufferpoolXDAReadsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemBufferpoolColumnReadsValues defines the type-safe values for System.BufferpoolColumnReads context
type SystemBufferpoolColumnReadsValues struct {
	Logical  int64
	Physical int64
}

// SystemBufferpoolColumnReadsContext provides type-safe operations for System.BufferpoolColumnReads context
type SystemBufferpoolColumnReadsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.BufferpoolColumnReads context
func (c SystemBufferpoolColumnReadsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemBufferpoolColumnReadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"logical":  values.Logical,
		"physical": values.Physical,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemBufferpoolColumnReadsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemBufferpoolWritesValues defines the type-safe values for System.BufferpoolWrites context
type SystemBufferpoolWritesValues struct {
	Writes int64
}

// SystemBufferpoolWritesContext provides type-safe operations for System.BufferpoolWrites context
type SystemBufferpoolWritesContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.BufferpoolWrites context
func (c SystemBufferpoolWritesContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemBufferpoolWritesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"writes": values.Writes,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemBufferpoolWritesContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemLogSpaceValues defines the type-safe values for System.LogSpace context
type SystemLogSpaceValues struct {
	Used      int64
	Available int64
}

// SystemLogSpaceContext provides type-safe operations for System.LogSpace context
type SystemLogSpaceContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.LogSpace context
func (c SystemLogSpaceContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemLogSpaceValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"used":      values.Used,
		"available": values.Available,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemLogSpaceContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemLogUtilizationValues defines the type-safe values for System.LogUtilization context
type SystemLogUtilizationValues struct {
	Utilization int64
}

// SystemLogUtilizationContext provides type-safe operations for System.LogUtilization context
type SystemLogUtilizationContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.LogUtilization context
func (c SystemLogUtilizationContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemLogUtilizationValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"utilization": values.Utilization,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemLogUtilizationContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemLogIOValues defines the type-safe values for System.LogIO context
type SystemLogIOValues struct {
	Reads  int64
	Writes int64
}

// SystemLogIOContext provides type-safe operations for System.LogIO context
type SystemLogIOContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.LogIO context
func (c SystemLogIOContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemLogIOValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"reads":  values.Reads,
		"writes": values.Writes,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemLogIOContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemLogOperationsValues defines the type-safe values for System.LogOperations context
type SystemLogOperationsValues struct {
	Commits   int64
	Rollbacks int64
	Reads     int64
	Writes    int64
}

// SystemLogOperationsContext provides type-safe operations for System.LogOperations context
type SystemLogOperationsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.LogOperations context
func (c SystemLogOperationsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemLogOperationsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"commits":   values.Commits,
		"rollbacks": values.Rollbacks,
		"reads":     values.Reads,
		"writes":    values.Writes,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemLogOperationsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemLogTimingValues defines the type-safe values for System.LogTiming context
type SystemLogTimingValues struct {
	Avg_commit int64
	Avg_read   int64
	Avg_write  int64
}

// SystemLogTimingContext provides type-safe operations for System.LogTiming context
type SystemLogTimingContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.LogTiming context
func (c SystemLogTimingContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemLogTimingValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"avg_commit": values.Avg_commit,
		"avg_read":   values.Avg_read,
		"avg_write":  values.Avg_write,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemLogTimingContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemLogBufferEventsValues defines the type-safe values for System.LogBufferEvents context
type SystemLogBufferEventsValues struct {
	Buffer_full int64
}

// SystemLogBufferEventsContext provides type-safe operations for System.LogBufferEvents context
type SystemLogBufferEventsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.LogBufferEvents context
func (c SystemLogBufferEventsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemLogBufferEventsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"buffer_full": values.Buffer_full,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemLogBufferEventsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemLongRunningQueriesValues defines the type-safe values for System.LongRunningQueries context
type SystemLongRunningQueriesValues struct {
	Total    int64
	Warning  int64
	Critical int64
}

// SystemLongRunningQueriesContext provides type-safe operations for System.LongRunningQueries context
type SystemLongRunningQueriesContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.LongRunningQueries context
func (c SystemLongRunningQueriesContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemLongRunningQueriesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"total":    values.Total,
		"warning":  values.Warning,
		"critical": values.Critical,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemLongRunningQueriesContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemBackupStatusValues defines the type-safe values for System.BackupStatus context
type SystemBackupStatusValues struct {
	Status int64
}

// SystemBackupStatusContext provides type-safe operations for System.BackupStatus context
type SystemBackupStatusContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.BackupStatus context
func (c SystemBackupStatusContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemBackupStatusValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"status": values.Status,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemBackupStatusContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemBackupAgeValues defines the type-safe values for System.BackupAge context
type SystemBackupAgeValues struct {
	Full        int64
	Incremental int64
}

// SystemBackupAgeContext provides type-safe operations for System.BackupAge context
type SystemBackupAgeContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.BackupAge context
func (c SystemBackupAgeContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemBackupAgeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"full":        values.Full,
		"incremental": values.Incremental,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemBackupAgeContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemFederationConnectionsValues defines the type-safe values for System.FederationConnections context
type SystemFederationConnectionsValues struct {
	Active int64
	Idle   int64
}

// SystemFederationConnectionsContext provides type-safe operations for System.FederationConnections context
type SystemFederationConnectionsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.FederationConnections context
func (c SystemFederationConnectionsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemFederationConnectionsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"active": values.Active,
		"idle":   values.Idle,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemFederationConnectionsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemFederationOperationsValues defines the type-safe values for System.FederationOperations context
type SystemFederationOperationsValues struct {
	Rows_read int64
	Selects   int64
	Waits     int64
}

// SystemFederationOperationsContext provides type-safe operations for System.FederationOperations context
type SystemFederationOperationsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.FederationOperations context
func (c SystemFederationOperationsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemFederationOperationsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"rows_read": values.Rows_read,
		"selects":   values.Selects,
		"waits":     values.Waits,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemFederationOperationsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemDatabaseStatusValues defines the type-safe values for System.DatabaseStatus context
type SystemDatabaseStatusValues struct {
	Active   int64
	Inactive int64
}

// SystemDatabaseStatusContext provides type-safe operations for System.DatabaseStatus context
type SystemDatabaseStatusContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.DatabaseStatus context
func (c SystemDatabaseStatusContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemDatabaseStatusValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"active":   values.Active,
		"inactive": values.Inactive,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemDatabaseStatusContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemDatabaseCountValues defines the type-safe values for System.DatabaseCount context
type SystemDatabaseCountValues struct {
	Active   int64
	Inactive int64
}

// SystemDatabaseCountContext provides type-safe operations for System.DatabaseCount context
type SystemDatabaseCountContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.DatabaseCount context
func (c SystemDatabaseCountContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemDatabaseCountValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"active":   values.Active,
		"inactive": values.Inactive,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemDatabaseCountContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemCPUUsageValues defines the type-safe values for System.CPUUsage context
type SystemCPUUsageValues struct {
	User   int64
	System int64
	Idle   int64
	Iowait int64
}

// SystemCPUUsageContext provides type-safe operations for System.CPUUsage context
type SystemCPUUsageContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.CPUUsage context
func (c SystemCPUUsageContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemCPUUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"user":   values.User,
		"system": values.System,
		"idle":   values.Idle,
		"iowait": values.Iowait,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemCPUUsageContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemActiveConnectionsValues defines the type-safe values for System.ActiveConnections context
type SystemActiveConnectionsValues struct {
	Active int64
	Total  int64
}

// SystemActiveConnectionsContext provides type-safe operations for System.ActiveConnections context
type SystemActiveConnectionsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.ActiveConnections context
func (c SystemActiveConnectionsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemActiveConnectionsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"active": values.Active,
		"total":  values.Total,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemActiveConnectionsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemMemoryUsageValues defines the type-safe values for System.MemoryUsage context
type SystemMemoryUsageValues struct {
	Database    int64
	Instance    int64
	Bufferpool  int64
	Shared_sort int64
}

// SystemMemoryUsageContext provides type-safe operations for System.MemoryUsage context
type SystemMemoryUsageContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.MemoryUsage context
func (c SystemMemoryUsageContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemMemoryUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"database":    values.Database,
		"instance":    values.Instance,
		"bufferpool":  values.Bufferpool,
		"shared_sort": values.Shared_sort,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemMemoryUsageContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemSQLStatementsValues defines the type-safe values for System.SQLStatements context
type SystemSQLStatementsValues struct {
	Selects       int64
	Modifications int64
}

// SystemSQLStatementsContext provides type-safe operations for System.SQLStatements context
type SystemSQLStatementsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.SQLStatements context
func (c SystemSQLStatementsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemSQLStatementsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"selects":       values.Selects,
		"modifications": values.Modifications,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemSQLStatementsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemTransactionActivityValues defines the type-safe values for System.TransactionActivity context
type SystemTransactionActivityValues struct {
	Committed int64
	Aborted   int64
}

// SystemTransactionActivityContext provides type-safe operations for System.TransactionActivity context
type SystemTransactionActivityContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.TransactionActivity context
func (c SystemTransactionActivityContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemTransactionActivityValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"committed": values.Committed,
		"aborted":   values.Aborted,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemTransactionActivityContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemTimeSpentValues defines the type-safe values for System.TimeSpent context
type SystemTimeSpentValues struct {
	Direct_read  int64
	Direct_write int64
	Pool_read    int64
	Pool_write   int64
}

// SystemTimeSpentContext provides type-safe operations for System.TimeSpent context
type SystemTimeSpentContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.TimeSpent context
func (c SystemTimeSpentContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemTimeSpentValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"direct_read":  values.Direct_read,
		"direct_write": values.Direct_write,
		"pool_read":    values.Pool_read,
		"pool_write":   values.Pool_write,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemTimeSpentContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// System contains all metric contexts for System
var System = struct {
	ServiceHealth            SystemServiceHealthContext
	Connections              SystemConnectionsContext
	Locking                  SystemLockingContext
	Deadlocks                SystemDeadlocksContext
	LockDetails              SystemLockDetailsContext
	LockWaitTime             SystemLockWaitTimeContext
	Sorting                  SystemSortingContext
	RowActivity              SystemRowActivityContext
	BufferpoolHitRatio       SystemBufferpoolHitRatioContext
	BufferpoolDataHitRatio   SystemBufferpoolDataHitRatioContext
	BufferpoolIndexHitRatio  SystemBufferpoolIndexHitRatioContext
	BufferpoolXDAHitRatio    SystemBufferpoolXDAHitRatioContext
	BufferpoolColumnHitRatio SystemBufferpoolColumnHitRatioContext
	BufferpoolReads          SystemBufferpoolReadsContext
	BufferpoolDataReads      SystemBufferpoolDataReadsContext
	BufferpoolIndexReads     SystemBufferpoolIndexReadsContext
	BufferpoolXDAReads       SystemBufferpoolXDAReadsContext
	BufferpoolColumnReads    SystemBufferpoolColumnReadsContext
	BufferpoolWrites         SystemBufferpoolWritesContext
	LogSpace                 SystemLogSpaceContext
	LogUtilization           SystemLogUtilizationContext
	LogIO                    SystemLogIOContext
	LogOperations            SystemLogOperationsContext
	LogTiming                SystemLogTimingContext
	LogBufferEvents          SystemLogBufferEventsContext
	LongRunningQueries       SystemLongRunningQueriesContext
	BackupStatus             SystemBackupStatusContext
	BackupAge                SystemBackupAgeContext
	FederationConnections    SystemFederationConnectionsContext
	FederationOperations     SystemFederationOperationsContext
	DatabaseStatus           SystemDatabaseStatusContext
	DatabaseCount            SystemDatabaseCountContext
	CPUUsage                 SystemCPUUsageContext
	ActiveConnections        SystemActiveConnectionsContext
	MemoryUsage              SystemMemoryUsageContext
	SQLStatements            SystemSQLStatementsContext
	TransactionActivity      SystemTransactionActivityContext
	TimeSpent                SystemTimeSpentContext
}{
	ServiceHealth: SystemServiceHealthContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.service_health",
			Family:      "overview",
			Title:       "Service Health Status",
			Units:       "status",
			Type:        module.Line,
			Priority:    990,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "connection",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "database",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	Connections: SystemConnectionsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.connections",
			Family:      "connections/overview",
			Title:       "Database Connections",
			Units:       "connections",
			Type:        module.Line,
			Priority:    1000,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "active",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "executing",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "idle",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "max_allowed",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	Locking: SystemLockingContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.locking",
			Family:      "locking",
			Title:       "Database Locking",
			Units:       "events/s",
			Type:        module.Line,
			Priority:    1010,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "waits",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "timeouts",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "escalations",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	Deadlocks: SystemDeadlocksContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.deadlocks",
			Family:      "locking",
			Title:       "Database Deadlocks",
			Units:       "deadlocks/s",
			Type:        module.Line,
			Priority:    1011,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "deadlocks",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	LockDetails: SystemLockDetailsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.lock_details",
			Family:      "locking",
			Title:       "Lock Details",
			Units:       "locks",
			Type:        module.Line,
			Priority:    1012,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "active",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "waiting_agents",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "memory_pages",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	LockWaitTime: SystemLockWaitTimeContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.lock_wait_time",
			Family:      "locking",
			Title:       "Average Lock Wait Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    1013,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "wait_time",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{},
		},
	},
	Sorting: SystemSortingContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.sorting",
			Family:      "activity/sorting",
			Title:       "Database Sorting",
			Units:       "sorts/s",
			Type:        module.Stacked,
			Priority:    1020,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "sorts",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "overflows",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	RowActivity: SystemRowActivityContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.row_activity",
			Family:      "activity/rows",
			Title:       "Row Activity",
			Units:       "rows/s",
			Type:        module.Area,
			Priority:    1030,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "read",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "returned",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "modified",
					Algorithm: module.Incremental,
					Mul:       -1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	BufferpoolHitRatio: SystemBufferpoolHitRatioContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.bufferpool_hit_ratio",
			Family:      "bufferpools/overview",
			Title:       "Buffer Pool Hit Ratio",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    1040,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "hits",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "misses",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{},
		},
	},
	BufferpoolDataHitRatio: SystemBufferpoolDataHitRatioContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.bufferpool_data_hit_ratio",
			Family:      "bufferpools/data",
			Title:       "Buffer Pool Data Page Hit Ratio",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    1041,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "hits",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "misses",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{},
		},
	},
	BufferpoolIndexHitRatio: SystemBufferpoolIndexHitRatioContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.bufferpool_index_hit_ratio",
			Family:      "bufferpools/index",
			Title:       "Buffer Pool Index Page Hit Ratio",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    1042,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "hits",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "misses",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{},
		},
	},
	BufferpoolXDAHitRatio: SystemBufferpoolXDAHitRatioContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.bufferpool_xda_hit_ratio",
			Family:      "bufferpools/xda",
			Title:       "Buffer Pool XDA Page Hit Ratio",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    1043,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "hits",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "misses",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{},
		},
	},
	BufferpoolColumnHitRatio: SystemBufferpoolColumnHitRatioContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.bufferpool_column_hit_ratio",
			Family:      "bufferpools/columns",
			Title:       "Buffer Pool Column Page Hit Ratio",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    1044,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "hits",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "misses",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{},
		},
	},
	BufferpoolReads: SystemBufferpoolReadsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.bufferpool_reads",
			Family:      "bufferpools/overview",
			Title:       "Buffer Pool Reads",
			Units:       "reads/s",
			Type:        module.Stacked,
			Priority:    1045,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "logical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "physical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	BufferpoolDataReads: SystemBufferpoolDataReadsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.bufferpool_data_reads",
			Family:      "bufferpools/data",
			Title:       "Buffer Pool Data Page Reads",
			Units:       "reads/s",
			Type:        module.Stacked,
			Priority:    1043,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "logical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "physical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	BufferpoolIndexReads: SystemBufferpoolIndexReadsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.bufferpool_index_reads",
			Family:      "bufferpools/index",
			Title:       "Buffer Pool Index Page Reads",
			Units:       "reads/s",
			Type:        module.Stacked,
			Priority:    1044,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "logical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "physical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	BufferpoolXDAReads: SystemBufferpoolXDAReadsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.bufferpool_xda_reads",
			Family:      "bufferpools/xda",
			Title:       "Buffer Pool XDA Page Reads",
			Units:       "reads/s",
			Type:        module.Stacked,
			Priority:    1045,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "logical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "physical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	BufferpoolColumnReads: SystemBufferpoolColumnReadsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.bufferpool_column_reads",
			Family:      "bufferpools/columns",
			Title:       "Buffer Pool Column Page Reads",
			Units:       "reads/s",
			Type:        module.Stacked,
			Priority:    1046,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "logical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "physical",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	BufferpoolWrites: SystemBufferpoolWritesContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.bufferpool_writes",
			Family:      "bufferpools/overview",
			Title:       "Buffer Pool Writes",
			Units:       "writes/s",
			Type:        module.Line,
			Priority:    1047,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "writes",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	LogSpace: SystemLogSpaceContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.log_space",
			Family:      "storage/space",
			Title:       "Log Space Usage",
			Units:       "bytes",
			Type:        module.Stacked,
			Priority:    1050,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "available",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	LogUtilization: SystemLogUtilizationContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.log_utilization",
			Family:      "storage/space",
			Title:       "Log Space Utilization",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    1051,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "utilization",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{},
		},
	},
	LogIO: SystemLogIOContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.log_io",
			Family:      "storage/operations",
			Title:       "Log I/O Operations",
			Units:       "operations/s",
			Type:        module.Area,
			Priority:    1052,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "reads",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "writes",
					Algorithm: module.Incremental,
					Mul:       -1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	LogOperations: SystemLogOperationsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.log_operations",
			Family:      "storage/operations",
			Title:       "Log Operations",
			Units:       "operations/s",
			Type:        module.Line,
			Priority:    1053,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "commits",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "rollbacks",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "reads",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "writes",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	LogTiming: SystemLogTimingContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.log_timing",
			Family:      "storage/operations",
			Title:       "Log Operation Times",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    1054,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "avg_commit",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "avg_read",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "avg_write",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{},
		},
	},
	LogBufferEvents: SystemLogBufferEventsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.log_buffer_events",
			Family:      "storage/operations",
			Title:       "Log Buffer Full Events",
			Units:       "events/s",
			Type:        module.Line,
			Priority:    1055,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "buffer_full",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	LongRunningQueries: SystemLongRunningQueriesContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.long_running_queries",
			Family:      "activity/requests",
			Title:       "Long Running Queries",
			Units:       "queries",
			Type:        module.Stacked,
			Priority:    1060,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "warning",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "critical",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	BackupStatus: SystemBackupStatusContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.backup_status",
			Family:      "storage/backup",
			Title:       "Last Backup Status",
			Units:       "status",
			Type:        module.Line,
			Priority:    1070,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "status",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	BackupAge: SystemBackupAgeContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.backup_age",
			Family:      "storage/backup",
			Title:       "Time Since Last Backup",
			Units:       "hours",
			Type:        module.Line,
			Priority:    1071,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "full",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "incremental",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	FederationConnections: SystemFederationConnectionsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.federation_connections",
			Family:      "federation",
			Title:       "Federated Connections",
			Units:       "connections",
			Type:        module.Line,
			Priority:    1080,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "active",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "idle",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	FederationOperations: SystemFederationOperationsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.federation_operations",
			Family:      "federation",
			Title:       "Federated Operations",
			Units:       "operations/s",
			Type:        module.Line,
			Priority:    1081,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "rows_read",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "selects",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "waits",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	DatabaseStatus: SystemDatabaseStatusContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.database_status",
			Family:      "overview",
			Title:       "Current Database Status",
			Units:       "status",
			Type:        module.Line,
			Priority:    900,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "active",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "inactive",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	DatabaseCount: SystemDatabaseCountContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.database_count",
			Family:      "overview",
			Title:       "Database Count",
			Units:       "databases",
			Type:        module.Line,
			Priority:    899,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "active",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "inactive",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	CPUUsage: SystemCPUUsageContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.cpu_usage",
			Family:      "overview",
			Title:       "CPU Usage (100% = 1 CPU core)",
			Units:       "percentage",
			Type:        module.Stacked,
			Priority:    901,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "user",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "system",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "idle",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "iowait",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{},
		},
	},
	ActiveConnections: SystemActiveConnectionsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.active_connections",
			Family:      "connections/overview",
			Title:       "Active Connections",
			Units:       "connections",
			Type:        module.Line,
			Priority:    902,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "active",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	MemoryUsage: SystemMemoryUsageContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.memory_usage",
			Family:      "overview",
			Title:       "Memory Usage",
			Units:       "MiB",
			Type:        module.Stacked,
			Priority:    903,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "database",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1048576,
					Precision: 1,
				},
				{
					Name:      "instance",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1048576,
					Precision: 1,
				},
				{
					Name:      "bufferpool",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1048576,
					Precision: 1,
				},
				{
					Name:      "shared_sort",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1048576,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	SQLStatements: SystemSQLStatementsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.sql_statements",
			Family:      "activity/requests",
			Title:       "SQL Statements",
			Units:       "statements/s",
			Type:        module.Stacked,
			Priority:    904,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "selects",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "modifications",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	TransactionActivity: SystemTransactionActivityContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.transaction_activity",
			Family:      "activity/transactions",
			Title:       "Transaction Activity",
			Units:       "transactions/s",
			Type:        module.Stacked,
			Priority:    905,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "committed",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "aborted",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	TimeSpent: SystemTimeSpentContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "db2.time_spent",
			Family:      "activity/time-spent",
			Title:       "Average Operation Times",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    905,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "direct_read",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "direct_write",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "pool_read",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
				{
					Name:      "pool_write",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{},
		},
	},
}

// --- Table ---

// TableSizeValues defines the type-safe values for Table.Size context
type TableSizeValues struct {
	Data     int64
	Index    int64
	Long_obj int64
}

// TableSizeContext provides type-safe operations for Table.Size context
type TableSizeContext struct {
	framework.Context[TableLabels]
}

// Set provides type-safe dimension setting for Table.Size context
func (c TableSizeContext) Set(state *framework.CollectorState, labels TableLabels, values TableSizeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"data":     values.Data,
		"index":    values.Index,
		"long_obj": values.Long_obj,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TableSizeContext) SetUpdateEvery(state *framework.CollectorState, labels TableLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TableActivityValues defines the type-safe values for Table.Activity context
type TableActivityValues struct {
	Read    int64
	Written int64
}

// TableActivityContext provides type-safe operations for Table.Activity context
type TableActivityContext struct {
	framework.Context[TableLabels]
}

// Set provides type-safe dimension setting for Table.Activity context
func (c TableActivityContext) Set(state *framework.CollectorState, labels TableLabels, values TableActivityValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"read":    values.Read,
		"written": values.Written,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TableActivityContext) SetUpdateEvery(state *framework.CollectorState, labels TableLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TableLabels defines the required labels for Table contexts
type TableLabels struct {
	Table string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l TableLabels) InstanceID(contextName string) string {
	// Label order from YAML: table
	return contextName + "." + cleanLabelValue(l.Table)
}

// Table contains all metric contexts for Table
var Table = struct {
	Size     TableSizeContext
	Activity TableActivityContext
}{
	Size: TableSizeContext{
		Context: framework.Context[TableLabels]{
			Name:        "db2.table_size",
			Family:      "tables",
			Title:       "Table Size",
			Units:       "bytes",
			Type:        module.Stacked,
			Priority:    1140,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "data",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "index",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "long_obj",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"table",
			},
		},
	},
	Activity: TableActivityContext{
		Context: framework.Context[TableLabels]{
			Name:        "db2.table_activity",
			Family:      "tables",
			Title:       "Table Activity",
			Units:       "rows/s",
			Type:        module.Area,
			Priority:    1141,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "read",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "written",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"table",
			},
		},
	},
}

// --- TableGroup ---

// TableGroupSizeValues defines the type-safe values for TableGroup.Size context
type TableGroupSizeValues struct {
	Data     int64
	Index    int64
	Long_obj int64
}

// TableGroupSizeContext provides type-safe operations for TableGroup.Size context
type TableGroupSizeContext struct {
	framework.Context[TableGroupLabels]
}

// Set provides type-safe dimension setting for TableGroup.Size context
func (c TableGroupSizeContext) Set(state *framework.CollectorState, labels TableGroupLabels, values TableGroupSizeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"data":     values.Data,
		"index":    values.Index,
		"long_obj": values.Long_obj,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TableGroupSizeContext) SetUpdateEvery(state *framework.CollectorState, labels TableGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TableGroupActivityValues defines the type-safe values for TableGroup.Activity context
type TableGroupActivityValues struct {
	Read    int64
	Written int64
}

// TableGroupActivityContext provides type-safe operations for TableGroup.Activity context
type TableGroupActivityContext struct {
	framework.Context[TableGroupLabels]
}

// Set provides type-safe dimension setting for TableGroup.Activity context
func (c TableGroupActivityContext) Set(state *framework.CollectorState, labels TableGroupLabels, values TableGroupActivityValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"read":    values.Read,
		"written": values.Written,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TableGroupActivityContext) SetUpdateEvery(state *framework.CollectorState, labels TableGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TableGroupLabels defines the required labels for TableGroup contexts
type TableGroupLabels struct {
	Group string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l TableGroupLabels) InstanceID(contextName string) string {
	// Label order from YAML: group
	return contextName + "." + cleanLabelValue(l.Group)
}

// TableGroup contains all metric contexts for TableGroup
var TableGroup = struct {
	Size     TableGroupSizeContext
	Activity TableGroupActivityContext
}{
	Size: TableGroupSizeContext{
		Context: framework.Context[TableGroupLabels]{
			Name:        "db2.table_group_size",
			Family:      "tables/groups",
			Title:       "Table Group Size",
			Units:       "bytes",
			Type:        module.Stacked,
			Priority:    1142,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "data",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "index",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "long_obj",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	Activity: TableGroupActivityContext{
		Context: framework.Context[TableGroupLabels]{
			Name:        "db2.table_group_activity",
			Family:      "tables/groups",
			Title:       "Table Group Activity",
			Units:       "rows/s",
			Type:        module.Area,
			Priority:    1143,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "read",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "written",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
}

// --- TableIO ---

// TableIOScansValues defines the type-safe values for TableIO.Scans context
type TableIOScansValues struct {
	Scans int64
}

// TableIOScansContext provides type-safe operations for TableIO.Scans context
type TableIOScansContext struct {
	framework.Context[TableIOLabels]
}

// Set provides type-safe dimension setting for TableIO.Scans context
func (c TableIOScansContext) Set(state *framework.CollectorState, labels TableIOLabels, values TableIOScansValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"scans": values.Scans,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TableIOScansContext) SetUpdateEvery(state *framework.CollectorState, labels TableIOLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TableIORowsValues defines the type-safe values for TableIO.Rows context
type TableIORowsValues struct {
	Read int64
}

// TableIORowsContext provides type-safe operations for TableIO.Rows context
type TableIORowsContext struct {
	framework.Context[TableIOLabels]
}

// Set provides type-safe dimension setting for TableIO.Rows context
func (c TableIORowsContext) Set(state *framework.CollectorState, labels TableIOLabels, values TableIORowsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"read": values.Read,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TableIORowsContext) SetUpdateEvery(state *framework.CollectorState, labels TableIOLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TableIOActivityValues defines the type-safe values for TableIO.Activity context
type TableIOActivityValues struct {
	Inserts int64
	Updates int64
	Deletes int64
}

// TableIOActivityContext provides type-safe operations for TableIO.Activity context
type TableIOActivityContext struct {
	framework.Context[TableIOLabels]
}

// Set provides type-safe dimension setting for TableIO.Activity context
func (c TableIOActivityContext) Set(state *framework.CollectorState, labels TableIOLabels, values TableIOActivityValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"inserts": values.Inserts,
		"updates": values.Updates,
		"deletes": values.Deletes,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TableIOActivityContext) SetUpdateEvery(state *framework.CollectorState, labels TableIOLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TableIOOverflowValues defines the type-safe values for TableIO.Overflow context
type TableIOOverflowValues struct {
	Overflow int64
}

// TableIOOverflowContext provides type-safe operations for TableIO.Overflow context
type TableIOOverflowContext struct {
	framework.Context[TableIOLabels]
}

// Set provides type-safe dimension setting for TableIO.Overflow context
func (c TableIOOverflowContext) Set(state *framework.CollectorState, labels TableIOLabels, values TableIOOverflowValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"overflow": values.Overflow,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TableIOOverflowContext) SetUpdateEvery(state *framework.CollectorState, labels TableIOLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TableIOLabels defines the required labels for TableIO contexts
type TableIOLabels struct {
	Table string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l TableIOLabels) InstanceID(contextName string) string {
	// Label order from YAML: table
	return contextName + "." + cleanLabelValue(l.Table)
}

// TableIO contains all metric contexts for TableIO
var TableIO = struct {
	Scans    TableIOScansContext
	Rows     TableIORowsContext
	Activity TableIOActivityContext
	Overflow TableIOOverflowContext
}{
	Scans: TableIOScansContext{
		Context: framework.Context[TableIOLabels]{
			Name:        "db2.table_io_scans",
			Family:      "table_io",
			Title:       "Table Scans",
			Units:       "scans/s",
			Type:        module.Line,
			Priority:    1170,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "scans",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"table",
			},
		},
	},
	Rows: TableIORowsContext{
		Context: framework.Context[TableIOLabels]{
			Name:        "db2.table_io_rows",
			Family:      "table_io",
			Title:       "Table Row Operations",
			Units:       "rows/s",
			Type:        module.Line,
			Priority:    1171,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "read",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"table",
			},
		},
	},
	Activity: TableIOActivityContext{
		Context: framework.Context[TableIOLabels]{
			Name:        "db2.table_io_activity",
			Family:      "table_io",
			Title:       "Table DML Activity",
			Units:       "operations/s",
			Type:        module.Stacked,
			Priority:    1172,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "inserts",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "updates",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "deletes",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"table",
			},
		},
	},
	Overflow: TableIOOverflowContext{
		Context: framework.Context[TableIOLabels]{
			Name:        "db2.table_io_overflow",
			Family:      "table_io",
			Title:       "Table Overflow Accesses",
			Units:       "accesses/s",
			Type:        module.Line,
			Priority:    1173,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "overflow",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"table",
			},
		},
	},
}

// --- Tablespace ---

// TablespaceUsageValues defines the type-safe values for Tablespace.Usage context
type TablespaceUsageValues struct {
	Used int64
}

// TablespaceUsageContext provides type-safe operations for Tablespace.Usage context
type TablespaceUsageContext struct {
	framework.Context[TablespaceLabels]
}

// Set provides type-safe dimension setting for Tablespace.Usage context
func (c TablespaceUsageContext) Set(state *framework.CollectorState, labels TablespaceLabels, values TablespaceUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"used": values.Used,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TablespaceUsageContext) SetUpdateEvery(state *framework.CollectorState, labels TablespaceLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TablespaceSizeValues defines the type-safe values for Tablespace.Size context
type TablespaceSizeValues struct {
	Used int64
	Free int64
}

// TablespaceSizeContext provides type-safe operations for Tablespace.Size context
type TablespaceSizeContext struct {
	framework.Context[TablespaceLabels]
}

// Set provides type-safe dimension setting for Tablespace.Size context
func (c TablespaceSizeContext) Set(state *framework.CollectorState, labels TablespaceLabels, values TablespaceSizeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"used": values.Used,
		"free": values.Free,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TablespaceSizeContext) SetUpdateEvery(state *framework.CollectorState, labels TablespaceLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TablespaceUsableSizeValues defines the type-safe values for Tablespace.UsableSize context
type TablespaceUsableSizeValues struct {
	Total  int64
	Usable int64
}

// TablespaceUsableSizeContext provides type-safe operations for Tablespace.UsableSize context
type TablespaceUsableSizeContext struct {
	framework.Context[TablespaceLabels]
}

// Set provides type-safe dimension setting for Tablespace.UsableSize context
func (c TablespaceUsableSizeContext) Set(state *framework.CollectorState, labels TablespaceLabels, values TablespaceUsableSizeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"total":  values.Total,
		"usable": values.Usable,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TablespaceUsableSizeContext) SetUpdateEvery(state *framework.CollectorState, labels TablespaceLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TablespaceStateValues defines the type-safe values for Tablespace.State context
type TablespaceStateValues struct {
	State int64
}

// TablespaceStateContext provides type-safe operations for Tablespace.State context
type TablespaceStateContext struct {
	framework.Context[TablespaceLabels]
}

// Set provides type-safe dimension setting for Tablespace.State context
func (c TablespaceStateContext) Set(state *framework.CollectorState, labels TablespaceLabels, values TablespaceStateValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"state": values.State,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TablespaceStateContext) SetUpdateEvery(state *framework.CollectorState, labels TablespaceLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TablespaceLabels defines the required labels for Tablespace contexts
type TablespaceLabels struct {
	Tablespace   string
	Type         string
	Content_type string
	State        string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l TablespaceLabels) InstanceID(contextName string) string {
	// Label order from YAML: tablespace, type, content_type, state
	return contextName + "." + cleanLabelValue(l.Tablespace) + "_" + cleanLabelValue(l.Type) + "_" + cleanLabelValue(l.Content_type) + "_" + cleanLabelValue(l.State)
}

// Tablespace contains all metric contexts for Tablespace
var Tablespace = struct {
	Usage      TablespaceUsageContext
	Size       TablespaceSizeContext
	UsableSize TablespaceUsableSizeContext
	State      TablespaceStateContext
}{
	Usage: TablespaceUsageContext{
		Context: framework.Context[TablespaceLabels]{
			Name:        "db2.tablespace_usage",
			Family:      "tablespaces",
			Title:       "Tablespace Usage",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    1120,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{
				"tablespace",
				"type",
				"content_type",
				"state",
			},
		},
	},
	Size: TablespaceSizeContext{
		Context: framework.Context[TablespaceLabels]{
			Name:        "db2.tablespace_size",
			Family:      "tablespaces",
			Title:       "Tablespace Size",
			Units:       "bytes",
			Type:        module.Stacked,
			Priority:    1121,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "free",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"tablespace",
				"type",
				"content_type",
				"state",
			},
		},
	},
	UsableSize: TablespaceUsableSizeContext{
		Context: framework.Context[TablespaceLabels]{
			Name:        "db2.tablespace_usable_size",
			Family:      "tablespaces",
			Title:       "Tablespace Usable Size",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    1122,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "usable",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"tablespace",
				"type",
				"content_type",
				"state",
			},
		},
	},
	State: TablespaceStateContext{
		Context: framework.Context[TablespaceLabels]{
			Name:        "db2.tablespace_state",
			Family:      "tablespaces",
			Title:       "Tablespace State",
			Units:       "state",
			Type:        module.Line,
			Priority:    1123,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "state",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"tablespace",
				"type",
				"content_type",
				"state",
			},
		},
	},
}

// --- TablespaceGroup ---

// TablespaceGroupUsageValues defines the type-safe values for TablespaceGroup.Usage context
type TablespaceGroupUsageValues struct {
	Used int64
}

// TablespaceGroupUsageContext provides type-safe operations for TablespaceGroup.Usage context
type TablespaceGroupUsageContext struct {
	framework.Context[TablespaceGroupLabels]
}

// Set provides type-safe dimension setting for TablespaceGroup.Usage context
func (c TablespaceGroupUsageContext) Set(state *framework.CollectorState, labels TablespaceGroupLabels, values TablespaceGroupUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"used": values.Used,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TablespaceGroupUsageContext) SetUpdateEvery(state *framework.CollectorState, labels TablespaceGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TablespaceGroupSizeValues defines the type-safe values for TablespaceGroup.Size context
type TablespaceGroupSizeValues struct {
	Used int64
	Free int64
}

// TablespaceGroupSizeContext provides type-safe operations for TablespaceGroup.Size context
type TablespaceGroupSizeContext struct {
	framework.Context[TablespaceGroupLabels]
}

// Set provides type-safe dimension setting for TablespaceGroup.Size context
func (c TablespaceGroupSizeContext) Set(state *framework.CollectorState, labels TablespaceGroupLabels, values TablespaceGroupSizeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"used": values.Used,
		"free": values.Free,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TablespaceGroupSizeContext) SetUpdateEvery(state *framework.CollectorState, labels TablespaceGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TablespaceGroupUsableSizeValues defines the type-safe values for TablespaceGroup.UsableSize context
type TablespaceGroupUsableSizeValues struct {
	Total  int64
	Usable int64
}

// TablespaceGroupUsableSizeContext provides type-safe operations for TablespaceGroup.UsableSize context
type TablespaceGroupUsableSizeContext struct {
	framework.Context[TablespaceGroupLabels]
}

// Set provides type-safe dimension setting for TablespaceGroup.UsableSize context
func (c TablespaceGroupUsableSizeContext) Set(state *framework.CollectorState, labels TablespaceGroupLabels, values TablespaceGroupUsableSizeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"total":  values.Total,
		"usable": values.Usable,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TablespaceGroupUsableSizeContext) SetUpdateEvery(state *framework.CollectorState, labels TablespaceGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TablespaceGroupStateValues defines the type-safe values for TablespaceGroup.State context
type TablespaceGroupStateValues struct {
	State int64
}

// TablespaceGroupStateContext provides type-safe operations for TablespaceGroup.State context
type TablespaceGroupStateContext struct {
	framework.Context[TablespaceGroupLabels]
}

// Set provides type-safe dimension setting for TablespaceGroup.State context
func (c TablespaceGroupStateContext) Set(state *framework.CollectorState, labels TablespaceGroupLabels, values TablespaceGroupStateValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"state": values.State,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TablespaceGroupStateContext) SetUpdateEvery(state *framework.CollectorState, labels TablespaceGroupLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TablespaceGroupLabels defines the required labels for TablespaceGroup contexts
type TablespaceGroupLabels struct {
	Group string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l TablespaceGroupLabels) InstanceID(contextName string) string {
	// Label order from YAML: group
	return contextName + "." + cleanLabelValue(l.Group)
}

// TablespaceGroup contains all metric contexts for TablespaceGroup
var TablespaceGroup = struct {
	Usage      TablespaceGroupUsageContext
	Size       TablespaceGroupSizeContext
	UsableSize TablespaceGroupUsableSizeContext
	State      TablespaceGroupStateContext
}{
	Usage: TablespaceGroupUsageContext{
		Context: framework.Context[TablespaceGroupLabels]{
			Name:        "db2.tablespace_group_usage",
			Family:      "tablespaces/groups",
			Title:       "Tablespace Group Usage",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    1124,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1000,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	Size: TablespaceGroupSizeContext{
		Context: framework.Context[TablespaceGroupLabels]{
			Name:        "db2.tablespace_group_size",
			Family:      "tablespaces/groups",
			Title:       "Tablespace Group Size",
			Units:       "bytes",
			Type:        module.Stacked,
			Priority:    1125,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "free",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	UsableSize: TablespaceGroupUsableSizeContext{
		Context: framework.Context[TablespaceGroupLabels]{
			Name:        "db2.tablespace_group_usable_size",
			Family:      "tablespaces/groups",
			Title:       "Tablespace Group Usable Size",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    1126,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "usable",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
	State: TablespaceGroupStateContext{
		Context: framework.Context[TablespaceGroupLabels]{
			Name:        "db2.tablespace_group_state",
			Family:      "tablespaces/groups",
			Title:       "Tablespace Group State",
			Units:       "state",
			Type:        module.Line,
			Priority:    1127,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "state",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"group",
			},
		},
	},
}

// GetAllContexts returns all contexts for framework registration
func GetAllContexts() []interface{} {
	return []interface{}{
		&Bufferpool.HitRatio.Context,
		&Bufferpool.DetailedHitRatio.Context,
		&Bufferpool.Reads.Context,
		&Bufferpool.DataReads.Context,
		&Bufferpool.IndexReads.Context,
		&Bufferpool.Pages.Context,
		&Bufferpool.Writes.Context,
		&BufferpoolGroup.HitRatio.Context,
		&BufferpoolGroup.DetailedHitRatio.Context,
		&BufferpoolGroup.Reads.Context,
		&BufferpoolGroup.DataReads.Context,
		&BufferpoolGroup.IndexReads.Context,
		&BufferpoolGroup.Pages.Context,
		&BufferpoolGroup.Writes.Context,
		&Connection.State.Context,
		&Connection.Activity.Context,
		&Connection.WaitTime.Context,
		&Connection.ProcessingTime.Context,
		&ConnectionGroup.Count.Context,
		&ConnectionGroup.State.Context,
		&ConnectionGroup.Activity.Context,
		&ConnectionGroup.WaitTime.Context,
		&ConnectionGroup.ProcessingTime.Context,
		&Database.Status.Context,
		&Database.Applications.Context,
		&Index.Usage.Context,
		&IndexGroup.Usage.Context,
		&MemoryPool.Usage.Context,
		&MemoryPool.HighWaterMark.Context,
		&MemorySet.Usage.Context,
		&MemorySet.Committed.Context,
		&MemorySet.HighWaterMark.Context,
		&MemorySet.AdditionalCommitted.Context,
		&MemorySet.PercentUsedHWM.Context,
		&Prefetcher.PrefetchRatio.Context,
		&Prefetcher.CleanerRatio.Context,
		&Prefetcher.PhysicalReads.Context,
		&Prefetcher.AsyncReads.Context,
		&Prefetcher.WaitTime.Context,
		&Prefetcher.UnreadPages.Context,
		&System.ServiceHealth.Context,
		&System.Connections.Context,
		&System.Locking.Context,
		&System.Deadlocks.Context,
		&System.LockDetails.Context,
		&System.LockWaitTime.Context,
		&System.Sorting.Context,
		&System.RowActivity.Context,
		&System.BufferpoolHitRatio.Context,
		&System.BufferpoolDataHitRatio.Context,
		&System.BufferpoolIndexHitRatio.Context,
		&System.BufferpoolXDAHitRatio.Context,
		&System.BufferpoolColumnHitRatio.Context,
		&System.BufferpoolReads.Context,
		&System.BufferpoolDataReads.Context,
		&System.BufferpoolIndexReads.Context,
		&System.BufferpoolXDAReads.Context,
		&System.BufferpoolColumnReads.Context,
		&System.BufferpoolWrites.Context,
		&System.LogSpace.Context,
		&System.LogUtilization.Context,
		&System.LogIO.Context,
		&System.LogOperations.Context,
		&System.LogTiming.Context,
		&System.LogBufferEvents.Context,
		&System.LongRunningQueries.Context,
		&System.BackupStatus.Context,
		&System.BackupAge.Context,
		&System.FederationConnections.Context,
		&System.FederationOperations.Context,
		&System.DatabaseStatus.Context,
		&System.DatabaseCount.Context,
		&System.CPUUsage.Context,
		&System.ActiveConnections.Context,
		&System.MemoryUsage.Context,
		&System.SQLStatements.Context,
		&System.TransactionActivity.Context,
		&System.TimeSpent.Context,
		&Table.Size.Context,
		&Table.Activity.Context,
		&TableGroup.Size.Context,
		&TableGroup.Activity.Context,
		&TableIO.Scans.Context,
		&TableIO.Rows.Context,
		&TableIO.Activity.Context,
		&TableIO.Overflow.Context,
		&Tablespace.Usage.Context,
		&Tablespace.Size.Context,
		&Tablespace.UsableSize.Context,
		&Tablespace.State.Context,
		&TablespaceGroup.Usage.Context,
		&TablespaceGroup.Size.Context,
		&TablespaceGroup.UsableSize.Context,
		&TablespaceGroup.State.Context,
	}
}
