<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/oracledb/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/oracledb/metadata.yaml"
sidebar_label: "Oracle DB"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Databases"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Oracle DB


<img src="https://netdata.cloud/img/oracle.svg" width="150"/>


Plugin: go.d.plugin
Module: oracledb

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors the health and performance of Oracle DB servers and collects general statistics, replication and user metrics.


It establishes a connection to the Oracle DB instance via a TCP or UNIX socket and extracts metrics from the following database tables:

- `v$sysmetric`
- `v$sysstat`
- `v$waitclassmetric`
- `v$system_wait_class`
- `dba_data_files`
- `dba_free_space`
- `dba_segments`
- `dba_temp_files`
- `dba_tablespaces`
- `v$temp_space_header`


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

The collector can automatically detect Oracle DB instances running on:

- Localhost, listening on port 1521
- Within Docker containers

> **Note**: Oracle DB requires a username and password. While Netdata can automatically discover Oracle DB instances and create data collection jobs, these jobs will fail unless you provide the correct credentials.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Oracle DB instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| oracledb.sessions | session | sessions |
| oracledb.average_active_sessions | active | sessions |
| oracledb.sessions_utilization | session_limit | percent |
| oracledb.current_logons | logons | logons |
| oracledb.logons | logons | logons/s |
| oracledb.database_wait_time_ratio | db_wait_time | percent |
| oracledb.sql_service_response_time | sql_resp_time | seconds |
| oracledb.enqueue_timeouts | enqueue | timeouts/s |
| oracledb.disk_io | read, written | bytes/s |
| oracledb.disk_iops | read, write | operations/s |
| oracledb.sorts | memory, disk | sorts/s |
| oracledb.table_scans | short_table, long_table | scans/s |
| oracledb.cache_hit_ratio | buffer, cursor, library, row | percent |
| oracledb.global_cache_blocks | corrupted, lost | blocks/s |
| oracledb.activity | parse, execute, user_commits, user_rollbacks | events/s |

### Per tablespace

These metrics refer to the Tablespace.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| tablespace | Tablespace name. |
| autoextend_status | Autoextend status (enabled, disabled, mixed). |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| oracledb.tablespace_utilization | utilization | percent |
| oracledb.tablespace_usage | avail, used | bytes |

### Per wait class

These metrics refer to the [Wait Class](https://docs.oracle.com/en/database/oracle/oracle-database/19/refrn/classes-of-wait-events.html).

Labels:

| Label      | Description     |
|:-----------|:----------------|
| wait_class | [Wait Class name](https://docs.oracle.com/en/database/oracle/oracle-database/19/refrn/classes-of-wait-events.html). |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| oracledb.wait_class_wait_time | wait_time | milliseconds |



## Alerts

There are no alerts configured by default for this integration.


## Setup


You can configure the **oracledb** collector in two ways:

| Method                | Best for                                                                                 | How to                                                                                                                                 |
|-----------------------|------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------|
| [**UI**](#via-ui)     | Fast setup without editing files                                                         | Go to **Nodes → Configure this node → Collectors → Jobs**, search for **oracledb**, then click **+** to add a job. |
| [**File**](#via-file) | If you prefer configuring via file, or need to automate deployments (e.g., with Ansible) | Edit `go.d/oracledb.conf` and add a job.                                                                        |

:::important

UI configuration requires paid Netdata Cloud plan.

:::


### Prerequisites

#### Create a read only user for netdata

Follow the official instructions for your oracle RDBMS to create a read-only user for netdata. The operation may follow this approach

Connect to your Oracle database with an administrative user and execute:

```bash
CREATE USER netdata IDENTIFIED BY <PASSWORD>;

GRANT CONNECT TO netdata;
GRANT SELECT_CATALOG_ROLE TO netdata;
```



### Configuration

#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>



| Group | Option | Description | Default | Required |
|:------|:-----|:------------|:--------|:---------:|
| **Collection** | update_every | Data collection interval (seconds). | 1 | no |
|  | autodetection_retry | Autodetection retry interval (seconds). Set 0 to disable. | 0 | no |
| **Target** | dsn | Oracle server DSN (Data Source Name). Format: `oracle://username:password@host:port/service?param1=value1&...&paramN=valueN`. |  | yes |
|  | timeout | Query timeout (seconds). | 1 | no |
| **Virtual Node** | vnode | Associates this data collection job with a [Virtual Node](https://learn.netdata.cloud/docs/netdata-agent/configuration/organize-systems-metrics-and-alerts#virtual-nodes). |  | no |


</details>


#### via UI

Configure the **oracledb** collector from the Netdata web interface:

1. Go to **Nodes**.
2. Select the node **where you want the oracledb data-collection job to run** and click the :gear: (**Configure this node**). That node will run the data collection.
3. The **Collectors → Jobs** view opens by default.
4. In the Search box, type _oracledb_ (or scroll the list) to locate the **oracledb** collector.
5. Click the **+** next to the **oracledb** collector to add a new job.
6. Fill in the job fields, then click **Test** to verify the configuration and **Submit** to save.
    - **Test** runs the job with the provided settings and shows whether data can be collected.
    - If it fails, an error message appears with details (for example, connection refused, timeout, or command execution errors), so you can adjust and retest.


#### via File

The configuration file name for this integration is `go.d/oracledb.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name2
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/oracledb.conf
```

##### Examples

###### TCP socket

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    dsn: oracle://netdata:secret@127.0.0.1:1521/XE

```
</details>

###### TLS connection (TCPS)

An example configuration for TLS connection.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    dsn: 'oracle://netdata:secret@127.0.0.1:1521/XE?ssl=true&ssl verify=true'

```
</details>

###### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    dsn: oracle://netdata:secret@127.0.0.1:1521/XE

  - name: remote
    dsn: oracle://netdata:secret@203.0.113.0:1521/XE

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `oracledb` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m oracledb
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m oracledb -j jobName
  ```

### Getting Logs

If you're encountering problems with the `oracledb` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep oracledb
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep oracledb /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep oracledb
```


