/**
  ******************************************************************************
  * @file    stm32n657xx.h
  * @author  MCD Application Team
  * @brief   CMSIS STM32N657xx Device Peripheral Access Layer Header File.
  *
  *          This file contains:
  *           - Data structures and the address mapping for all peripherals
  *           - Peripheral's registers declarations and bits definition
  *           - Macros to access peripheral's registers hardware
  *
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */

#ifndef STM32N657xx_H
#define STM32N657xx_H

#ifdef __cplusplus
extern "C" {
#endif

/** @addtogroup ST
  * @{
  */

/** @addtogroup STM32N657xx
  * @{
  */

/** @addtogroup Configuration_of_CMSIS
  * @{
  */

/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */
typedef enum
{
/* ======================================  ARM Cortex-M55 Specific Interrupt Numbers  ======================================== */
  NonMaskableInt_IRQn        = -14,    /*!< -14 Non maskable Interrupt, cannot be stopped or preempted                         */
  HardFault_IRQn             = -13,    /*!< -13 Hard Fault, all classes of Fault                                               */
  MemoryManagement_IRQn      = -12,    /*!< -12 Memory Management, MPU mismatch, including Access Violation and No Match       */
  BusFault_IRQn              = -11,    /*!< -11 Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory related Fault */
  UsageFault_IRQn            = -10,    /*!< -10 Usage Fault, i.e. Undef Instruction, Illegal State Transition                  */
#if defined (__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE == 3U)
  SecureFault_IRQn           = -9,     /*!< -9  Secure Fault                                                                   */
#endif
  SVCall_IRQn                = -5,     /*!< -5  System Service Call via SVC instruction                                        */
  DebugMonitor_IRQn          = -4,     /*!< -4  Debug Monitor                                                                  */
  PendSV_IRQn                = -2,     /*!< -2  Pendable request for system service                                            */
  SysTick_IRQn               = -1,     /*!< -1  System Tick Timer                                                              */

/* ======================================  STM32N6xx Specific Interrupt Numbers  ============================================= */
  PVD_PVM_IRQn               = 0,      /*!< PVD/PVM1/PVM2/PVM3/PVM4 through EXTI Line detection                                */
  DTS_IRQn                   = 2,      /*!< Thermal Sensor interruption                                                        */
  RCC_IRQn                   = 3,      /*!< RCC non-secure global interrupts through EXTI Line detection                       */
  LOCKUP_IRQn                = 4,      /*!< LOCKUP / (no Overstack in CM55)                                                    */
  CACHE_ECC_IRQn             = 5,      /*!< Error ECC cache interrupt                                                          */
  TCM_ECC_IRQn               = 6,      /*!< TCM ECC interrupts                                                                 */
  BKP_ECC_IRQn               = 7,      /*!< Backup RAM Interrupts                                                              */
  FPU_IRQn                   = 8,      /*!< FPU interrupt                                                                      */
  RTC_S_IRQn                 = 10,     /*!< RTC secure interrupts through EXTI Line detection                                  */
  TAMP_IRQn                  = 11,     /*!< Tamper secure and non-secure interrupts through EXTI Line detection                */
  RIFSC_TAMPER_IRQn          = 12,     /*!< RIF Tamper interrupts                                                              */
  IAC_IRQn                   = 13,     /*!< IAC interrupt                                                                      */
  RCC_S_IRQn                 = 14,     /*!< RCC secure global interrupts through EXTI Line detection                           */
  RTC_IRQn                   = 16,     /*!< RTC non-secure interrupts through EXTI Line detection                              */
  IWDG_IRQn                  = 18,     /*!< Internal Watchdog interrupt                                                        */
  WWDG_IRQn                  = 19,     /*!< Window Watchdog interrupt                                                          */
  EXTI0_IRQn                 = 20,     /*!< EXTI Line0 interrupt                                                               */
  EXTI1_IRQn                 = 21,     /*!< EXTI Line1 interrupt                                                               */
  EXTI2_IRQn                 = 22,     /*!< EXTI Line2 interrupt                                                               */
  EXTI3_IRQn                 = 23,     /*!< EXTI Line3 interrupt                                                               */
  EXTI4_IRQn                 = 24,     /*!< EXTI Line4 interrupt                                                               */
  EXTI5_IRQn                 = 25,     /*!< EXTI Line5 interrupt                                                               */
  EXTI6_IRQn                 = 26,     /*!< EXTI Line6 interrupt                                                               */
  EXTI7_IRQn                 = 27,     /*!< EXTI Line7 interrupt                                                               */
  EXTI8_IRQn                 = 28,     /*!< EXTI Line8 interrupt                                                               */
  EXTI9_IRQn                 = 29,     /*!< EXTI Line9 interrupt                                                               */
  EXTI10_IRQn                = 30,     /*!< EXTI Line10 interrupt                                                              */
  EXTI11_IRQn                = 31,     /*!< EXTI Line11 interrupt                                                              */
  EXTI12_IRQn                = 32,     /*!< EXTI Line12 interrupt                                                              */
  EXTI13_IRQn                = 33,     /*!< EXTI Line13 interrupt                                                              */
  EXTI14_IRQn                = 34,     /*!< EXTI Line14 interrupt                                                              */
  EXTI15_IRQn                = 35,     /*!< EXTI Line15 interrupt                                                              */
  SAES_IRQn                  = 36,     /*!< SAES interrupt                                                                     */
  CRYP_IRQn                  = 37,     /*!< CRYP interrupt                                                                     */
  PKA_IRQn                   = 38,     /*!< PKA interrupt                                                                      */
  HASH_IRQn                  = 39,     /*!< HASH interrupt                                                                     */
  RNG_IRQn                   = 40,     /*!< RNG global interrupt                                                               */
  MCE1_IRQn                  = 42,     /*!< MCE1 global interrupt                                                              */
  MCE2_IRQn                  = 43,     /*!< MCE2 global interrupt                                                              */
  MCE3_IRQn                  = 44,     /*!< MCE3 global interrupt                                                              */
  MCE4_IRQn                  = 45,     /*!< MCE4 global interrupt                                                              */
  ADC1_2_IRQn                = 46,     /*!< ADC1 & ADC2 interrupt                                                              */
  CSI_IRQn                   = 47,     /*!< CSI global interrupt                                                               */
  DCMIPP_IRQn                = 48,     /*!< DCMIPP global interrupt                                                            */
  PAHB_ERR_IRQn              = 52,     /*!< PAHB error interrupt                                                               */
  NPU0_IRQn                  = 53,     /*!< NPU mst_ints[0] line interrupt                                                     */
  NPU1_IRQn                  = 54,     /*!< NPU mst_ints[1] line interrupt                                                     */
  NPU2_IRQn                  = 55,     /*!< NPU mst_ints[2] line interrupt                                                     */
  NPU3_IRQn                  = 56,     /*!< NPU mst_ints[3] line interrupt                                                     */
  CACHEAXI_IRQn              = 57,     /*!< NPU cache interrupt                                                                */
  LTDC_LO_IRQn               = 58,     /*!< LTDC low-layer global interrupt                                                    */
  LTDC_LO_ERR_IRQn           = 59,     /*!< LTDC low-layer error interrupt                                                     */
  DMA2D_IRQn                 = 60,     /*!< DMA2D global interrupt                                                             */
  JPEG_IRQn                  = 61,     /*!< JPEG global interrupt                                                              */
  VENC_IRQn                  = 62,     /*!< VENC global interrupt                                                              */
  GFXMMU_IRQn                = 63,     /*!< GFXMMU global interrupt                                                            */
  GFXTIM_IRQn                = 64,     /*!< GFXTIM global interrupt                                                            */
  GPU2D_IRQn                 = 65,     /*!< GPU2D interrupt                                                                    */
  GPU2D_ER_IRQn              = 66,     /*!< GPU2D error interrupt                                                              */
  ICACHE_IRQn                = 67,     /*!< GPU2D cache interrupt                                                              */
  HPDMA1_Channel0_IRQn       = 68,     /*!< HPDMA1 Channel 0 global interrupt                                                  */
  HPDMA1_Channel1_IRQn       = 69,     /*!< HPDMA1 Channel 1 global interrupt                                                  */
  HPDMA1_Channel2_IRQn       = 70,     /*!< HPDMA1 Channel 2 global interrupt                                                  */
  HPDMA1_Channel3_IRQn       = 71,     /*!< HPDMA1 Channel 3 global interrupt                                                  */
  HPDMA1_Channel4_IRQn       = 72,     /*!< HPDMA1 Channel 4 global interrupt                                                  */
  HPDMA1_Channel5_IRQn       = 73,     /*!< HPDMA1 Channel 5 global interrupt                                                  */
  HPDMA1_Channel6_IRQn       = 74,     /*!< HPDMA1 Channel 6 global interrupt                                                  */
  HPDMA1_Channel7_IRQn       = 75,     /*!< HPDMA1 Channel 7 global interrupt                                                  */
  HPDMA1_Channel8_IRQn       = 76,     /*!< HPDMA1 Channel 8 global interrupt                                                  */
  HPDMA1_Channel9_IRQn       = 77,     /*!< HPDMA1 Channel 9 global interrupt                                                  */
  HPDMA1_Channel10_IRQn      = 78,     /*!< HPDMA1 Channel 10 global interrupt                                                 */
  HPDMA1_Channel11_IRQn      = 79,     /*!< HPDMA1 Channel 11 global interrupt                                                 */
  HPDMA1_Channel12_IRQn      = 80,     /*!< HPDMA1 Channel 12 global interrupt                                                 */
  HPDMA1_Channel13_IRQn      = 81,     /*!< HPDMA1 Channel 13 global interrupt                                                 */
  HPDMA1_Channel14_IRQn      = 82,     /*!< HPDMA1 Channel 14 global interrupt                                                 */
  HPDMA1_Channel15_IRQn      = 83,     /*!< HPDMA1 Channel 15 global interrupt                                                 */
  GPDMA1_Channel0_IRQn       = 84,     /*!< GPDMA1 Channel 0 interrupt                                                         */
  GPDMA1_Channel1_IRQn       = 85,     /*!< GPDMA1 Channel 1 interrupt                                                         */
  GPDMA1_Channel2_IRQn       = 86,     /*!< GPDMA1 Channel 2 interrupt                                                         */
  GPDMA1_Channel3_IRQn       = 87,     /*!< GPDMA1 Channel 3 interrupt                                                         */
  GPDMA1_Channel4_IRQn       = 88,     /*!< GPDMA1 Channel 4 interrupt                                                         */
  GPDMA1_Channel5_IRQn       = 89,     /*!< GPDMA1 Channel 5 interrupt                                                         */
  GPDMA1_Channel6_IRQn       = 90,     /*!< GPDMA1 Channel 6 interrupt                                                         */
  GPDMA1_Channel7_IRQn       = 91,     /*!< GPDMA1 Channel 7 interrupt                                                         */
  GPDMA1_Channel8_IRQn       = 92,     /*!< GPDMA1 Channel 8 interrupt                                                         */
  GPDMA1_Channel9_IRQn       = 93,     /*!< GPDMA1 Channel 9 interrupt                                                         */
  GPDMA1_Channel10_IRQn      = 94,     /*!< GPDMA1 Channel 10 interrupt                                                        */
  GPDMA1_Channel11_IRQn      = 95,     /*!< GPDMA1 Channel 11 interrupt                                                        */
  GPDMA1_Channel12_IRQn      = 96,     /*!< GPDMA1 Channel 12 interrupt                                                        */
  GPDMA1_Channel13_IRQn      = 97,     /*!< GPDMA1 Channel 13 interrupt                                                        */
  GPDMA1_Channel14_IRQn      = 98,     /*!< GPDMA1 Channel 14 interrupt                                                        */
  GPDMA1_Channel15_IRQn      = 99,     /*!< GPDMA1 Channel 15 interrupt                                                        */
  I2C1_EV_IRQn               = 100,    /*!< I2C1 event interrupt                                                               */
  I2C1_ER_IRQn               = 101,    /*!< I2C1 error interrupt                                                               */
  I2C2_EV_IRQn               = 102,    /*!< I2C2 event interrupt                                                               */
  I2C2_ER_IRQn               = 103,    /*!< I2C2 error interrupt                                                               */
  I2C3_EV_IRQn               = 104,    /*!< I2C3 event interrupt                                                               */
  I2C3_ER_IRQn               = 105,    /*!< I2C3 error interrupt                                                               */
  I2C4_EV_IRQn               = 106,    /*!< I2C4 event interrupt                                                               */
  I2C4_ER_IRQn               = 107,    /*!< I2C4 error interrupt                                                               */
  I3C1_EV_IRQn               = 108,    /*!< I3C1 event interrupt                                                               */
  I3C1_ER_IRQn               = 109,    /*!< I3C1 error interrupt                                                               */
  I3C2_EV_IRQn               = 110,    /*!< I3C2 event interrupt                                                               */
  I3C2_ER_IRQn               = 111,    /*!< I3C2 error interrupt                                                               */
  TIM1_BRK_IRQn              = 112,    /*!< TIM1 Break interrupt                                                               */
  TIM1_UP_IRQn               = 113,    /*!< TIM1 Update interrupt                                                              */
  TIM1_TRG_COM_IRQn          = 114,    /*!< TIM1 Trigger and Commutation interrupt                                             */
  TIM1_CC_IRQn               = 115,    /*!< TIM1 Capture Compare interrupt                                                     */
  TIM2_IRQn                  = 116,    /*!< TIM2 global interrupt                                                              */
  TIM3_IRQn                  = 117,    /*!< TIM3 global interrupt                                                              */
  TIM4_IRQn                  = 118,    /*!< TIM4 global interrupt                                                              */
  TIM5_IRQn                  = 119,    /*!< TIM5 global interrupt                                                              */
  TIM6_IRQn                  = 120,    /*!< TIM6 global interrupt                                                              */
  TIM7_IRQn                  = 121,    /*!< TIM7 global interrupt                                                              */
  TIM8_BRK_IRQn              = 122,    /*!< TIM8 Break interrupt                                                               */
  TIM8_UP_IRQn               = 123,    /*!< TIM8 Update interrupt                                                              */
  TIM8_TRG_COM_IRQn          = 124,    /*!< TIM8 Trigger and Commutation interrupt                                             */
  TIM8_CC_IRQn               = 125,    /*!< TIM8 Capture Compare interrupt                                                     */
  TIM9_IRQn                  = 126,    /*!< TIM9 global interrupt                                                              */
  TIM10_IRQn                 = 127,    /*!< TIM10 global interrupt                                                             */
  TIM11_IRQn                 = 128,    /*!< TIM11 global interrupt                                                             */
  TIM12_IRQn                 = 129,    /*!< TIM12 global interrupt                                                             */
  TIM13_IRQn                 = 130,    /*!< TIM13 global interrupt                                                             */
  TIM14_IRQn                 = 131,    /*!< TIM14 global interrupt                                                             */
  TIM15_IRQn                 = 132,    /*!< TIM15 global interrupt                                                             */
  TIM16_IRQn                 = 133,    /*!< TIM16 global interrupt                                                             */
  TIM17_IRQn                 = 134,    /*!< TIM17 global interrupt                                                             */
  TIM18_IRQn                 = 135,    /*!< TIM18 global interrupt                                                             */
  LPTIM1_IRQn                = 136,    /*!< LPTIM1 global interrupt                                                            */
  LPTIM2_IRQn                = 137,    /*!< LPTIM2 global interrupt                                                            */
  LPTIM3_IRQn                = 138,    /*!< LPTIM3 global interrupt                                                            */
  LPTIM4_IRQn                = 139,    /*!< LPTIM4 global interrupt                                                            */
  LPTIM5_IRQn                = 140,    /*!< LPTIM5 global interrupt                                                            */
  ADF1_FLT0_IRQn             = 141,    /*!< ADF1 Filter 0 global interrupt                                                     */
  MDF1_FLT0_IRQn             = 142,    /*!< MDF1 Filter 0 global interrupt                                                     */
  MDF1_FLT1_IRQn             = 143,    /*!< MDF1 Filter 1 global interrupt                                                     */
  MDF1_FLT2_IRQn             = 144,    /*!< MDF1 Filter 2 global interrupt                                                     */
  MDF1_FLT3_IRQn             = 145,    /*!< MDF1 Filter 3 global interrupt                                                     */
  MDF1_FLT4_IRQn             = 146,    /*!< MDF1 Filter 4 global interrupt                                                     */
  MDF1_FLT5_IRQn             = 147,    /*!< MDF1 Filter 5 global interrupt                                                     */
  SAI1_A_IRQn                = 148,    /*!< Serial Audio Interface 1 block A interrupt                                         */
  SAI1_B_IRQn                = 149,    /*!< Serial Audio Interface 1 block B interrupt                                         */
  SAI2_A_IRQn                = 150,    /*!< Serial Audio Interface 2 block A interrupt                                         */
  SAI2_B_IRQn                = 151,    /*!< Serial Audio Interface 2 block B interrupt                                         */
  SPDIFRX1_IRQn              = 152,    /*!< SPDIFRX1 interrupt                                                                 */
  SPI1_IRQn                  = 153,    /*!< SPI1 global interrupt                                                              */
  SPI2_IRQn                  = 154,    /*!< SPI2 global interrupt                                                              */
  SPI3_IRQn                  = 155,    /*!< SPI3 global interrupt                                                              */
  SPI4_IRQn                  = 156,    /*!< SPI4 global interrupt                                                              */
  SPI5_IRQn                  = 157,    /*!< SPI5 global interrupt                                                              */
  SPI6_IRQn                  = 158,    /*!< SPI6 global interrupt                                                              */
  USART1_IRQn                = 159,    /*!< USART1 global interrupt                                                            */
  USART2_IRQn                = 160,    /*!< USART2 global interrupt                                                            */
  USART3_IRQn                = 161,    /*!< USART3 global interrupt                                                            */
  UART4_IRQn                 = 162,    /*!< UART4 global interrupt                                                             */
  UART5_IRQn                 = 163,    /*!< UART5 global interrupt                                                             */
  USART6_IRQn                = 164,    /*!< USART3 global interrupt                                                            */
  UART7_IRQn                 = 165,    /*!< UART7 global interrupt                                                             */
  UART8_IRQn                 = 166,    /*!< UART8 global interrupt                                                             */
  UART9_IRQn                 = 167,    /*!< UART9 global interrupt                                                             */
  USART10_IRQn               = 168,    /*!< USART10 global interrupt                                                           */
  LPUART1_IRQn               = 169,    /*!< LPUART1 global interrupt                                                           */
  XSPI1_IRQn                 = 170,    /*!< XSPI1 global interrupt                                                             */
  XSPI2_IRQn                 = 171,    /*!< XSPI2 global interrupt                                                             */
  XSPI3_IRQn                 = 172,    /*!< XSPI3 global interrupt                                                             */
  FMC_IRQn                   = 173,    /*!< FMC global interrupt                                                               */
  SDMMC1_IRQn                = 174,    /*!< SDMMC1 global interrupt                                                            */
  SDMMC2_IRQn                = 175,    /*!< SDMMC2 global interrupt                                                            */
  UCPD1_IRQn                 = 176,    /*!< UCPD1 global interrupt                                                             */
  USB1_OTG_HS_IRQn           = 177,    /*!< USB1 OTG HS interrupt                                                              */
  USB2_OTG_HS_IRQn           = 178,    /*!< USB2 OTG HS interrupt                                                              */
  ETH1_IRQn                  = 179,    /*!< ETH1 global interrupt                                                              */
  FDCAN1_IT0_IRQn            = 180,    /*!< FDCAN1 interrupt 0                                                                 */
  FDCAN1_IT1_IRQn            = 181,    /*!< FDCAN1 interrupt 1                                                                 */
  FDCAN2_IT0_IRQn            = 182,    /*!< FDCAN2 interrupt 0                                                                 */
  FDCAN2_IT1_IRQn            = 183,    /*!< FDCAN2 interrupt 1                                                                 */
  FDCAN3_IT0_IRQn            = 184,    /*!< FDCAN3 interrupt 0                                                                 */
  FDCAN3_IT1_IRQn            = 185,    /*!< FDCAN3 interrupt 1                                                                 */
  FDCAN_CU_IRQn              = 186,    /*!< FDCAN Clock Unit interrupt                                                         */
  MDIOS_IRQn                 = 187,    /*!< MDIOS global interrupt                                                             */
  DCMI_PSSI_IRQn             = 188,    /*!< DCMI/PSSI global interrupt                                                         */
  WAKEUP_PIN_IRQn            = 189,    /*!< Wake-up pins interrupt                                                             */
  CTI_INT0_IRQn              = 190,    /*!< CTI INT0 interrupt                                                                 */
  CTI_INT1_IRQn              = 191,    /*!< CTI INT1 interrupt                                                                 */
  LTDC_UP_IRQn               = 193,    /*!< LTDC up-layer global interrupt                                                     */
  LTDC_UP_ERR_IRQn           = 194,    /*!< LTDC up-layer error interrupt                                                      */
} IRQn_Type;


/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/**
  * @brief Configuration of the Cortex-M55 Processor and Core Peripherals
   */
#define __CM55_REV                0x0101U /*!< Cortex-M55 revision r1p1                      */
#define __FPU_PRESENT             1U      /*!< CM55 Floating Point Unit present              */
#define __DSP_PRESENT             1U      /*!< CM55 Digital Signal Processing Unit present   */
#define __MPU_PRESENT             1U      /*!< CM55 Memory Programming Unit present          */
#define __ICACHE_PRESENT          1U      /*!< CM55 Instruction cache present                */
#define __DCACHE_PRESENT          1U      /*!< CM55 Data cache present                       */
#define __VTOR_PRESENT            1U      /*!< CM55 Vector table offset register present     */
#define __PMU_PRESENT             1U      /*!< CM55 Performance Monitoring Unit present      */
#define __PMU_NUM_EVENTCNT        8U      /*!< CM55 can monitor up to 8 PMU events           */
#define __NVIC_PRIO_BITS          4U      /*!< CM55 uses 4 bits for the Priority Levels      */
#define __Vendor_SysTickConfig    0U      /*!< Set to 1 if different SysTick Config is used  */
#define __SAUREGION_PRESENT       1U      /*!< SAU regions present                           */

/** @} */ /* End of group Configuration_of_CMSIS */

#if defined (__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE == 3U)
#define CPU_IN_SECURE_STATE
#endif

#define CPU_AS_TRUSTED_DOMAIN

#include "core_cm55.h"                    /*!< ARM Cortex-M55 processor and core peripherals */
#include "system_stm32n6xx.h"             /*!< STM32N6xx System */

/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */

/** @addtogroup STM32N6xx_peripherals
  * @{
  */

/**
  * @brief Analog to Digital Converter (ADC)
  */
typedef struct
{
  __IO uint32_t ISR;           /*!< ADC interrupt and status register,                     Address offset: 0x00 */
  __IO uint32_t IER;           /*!< ADC interrupt enable register,                         Address offset: 0x04 */
  __IO uint32_t CR;            /*!< ADC control register,                                  Address offset: 0x08 */
  __IO uint32_t CFGR1;         /*!< ADC configuration register 1,                          Address offset: 0x0C */
  __IO uint32_t CFGR2;         /*!< ADC configuration register 2,                          Address offset: 0x10 */
  __IO uint32_t SMPR1;         /*!< ADC sample time register 1,                            Address offset: 0x14 */
  __IO uint32_t SMPR2;         /*!< ADC sample time register 2,                            Address offset: 0x18 */
  __IO uint32_t PCSEL;         /*!< ADC channel preselection register,                     Address offset: 0x1C */
  uint32_t      RESERVED1[4];  /*!< Reserved,                                              Address offset: 0x020-0x02C */
  __IO uint32_t SQR1;          /*!< ADC regular sequence register 1,                       Address offset: 0x30 */
  __IO uint32_t SQR2;          /*!< ADC regular sequence register 2,                       Address offset: 0x34 */
  __IO uint32_t SQR3;          /*!< ADC regular sequence register 3,                       Address offset: 0x38 */
  __IO uint32_t SQR4;          /*!< ADC regular sequence register 4,                       Address offset: 0x3C */
  __IO uint32_t DR;            /*!< ADC regular data register,                             Address offset: 0x40 */
  uint32_t      RESERVED2[2];  /*!< Reserved,                                              Address offset: 0x044-0x048 */
  __IO uint32_t JSQR;          /*!< ADC injected sequence register,                        Address offset: 0x4C */
  __IO uint32_t OFCFGR1;       /*!< ADC offset configuration register 1,                   Address offset: 0x50 */
  __IO uint32_t OFCFGR2;       /*!< ADC offset configuration register 2,                   Address offset: 0x54 */
  __IO uint32_t OFCFGR3;       /*!< ADC offset configuration register 3,                   Address offset: 0x58 */
  __IO uint32_t OFCFGR4;       /*!< ADC offset configuration register 4,                   Address offset: 0x5C */
  __IO uint32_t OFR1;          /*!< ADC offset register 1,                                 Address offset: 0x60 */
  __IO uint32_t OFR2;          /*!< ADC offset register 2,                                 Address offset: 0x64 */
  __IO uint32_t OFR3;          /*!< ADC offset register 3,                                 Address offset: 0x68 */
  __IO uint32_t OFR4;          /*!< ADC offset register 4,                                 Address offset: 0x6C */
  __IO uint32_t GCOMP;         /*!< ADC gain compensation register,                        Address offset: 0x70 */
  uint32_t      RESERVED3[3];  /*!< Reserved,                                              Address offset: 0x074-0x07C */
  __IO uint32_t JDR1;          /*!< ADC injected data register 1,                          Address offset: 0x80 */
  __IO uint32_t JDR2;          /*!< ADC injected data register 2,                          Address offset: 0x84 */
  __IO uint32_t JDR3;          /*!< ADC injected data register 3,                          Address offset: 0x88 */
  __IO uint32_t JDR4;          /*!< ADC injected data register 4,                          Address offset: 0x8C */
  uint32_t      RESERVED4[4];  /*!< Reserved,                                              Address offset: 0x090-0x09C */
  __IO uint32_t AWD2CR;        /*!< ADC analog watchdog 2 configuration register,          Address offset: 0xA0 */
  __IO uint32_t AWD3CR;        /*!< ADC analog watchdog 3 configuration register,          Address offset: 0xA4 */
  __IO uint32_t AWD1LTR;       /*!< ADC analog watchdog 1 low threshold register,          Address offset: 0xA8 */
  __IO uint32_t AWD1HTR;       /*!< ADC analog watchdog 1 high threshold register,         Address offset: 0xAC */
  __IO uint32_t AWD2LTR;       /*!< ADC analog watchdog 2 low threshold register,          Address offset: 0xB0 */
  __IO uint32_t AWD2HTR;       /*!< ADC analog watchdog 2 high threshold register,         Address offset: 0xB4 */
  __IO uint32_t AWD3LTR;       /*!< ADC analog watchdog 3 low threshold register,          Address offset: 0xB8 */
  __IO uint32_t AWD3HTR;       /*!< ADC analog watchdog 3 high threshold register,         Address offset: 0xBC */
  __IO uint32_t DIFSEL;        /*!< ADC differential mode selection register,              Address offset: 0xC0 */
  __IO uint32_t CALFACT;       /*!< ADC calibration factors,                               Address offset: 0xC4 */
  uint32_t      RESERVED5[2];  /*!< Reserved,                                              Address offset: 0x0C8-0x0CC */
  __IO uint32_t OR;            /*!< ADC option register,                                   Address offset: 0xD0 */
} ADC_TypeDef;

typedef struct
{
  __IO uint32_t CSR;           /*!< ADC common status register,                            Address offset: 0x300 */
  uint32_t RESERVED;           /*!< Reserved,                                              Address offset: 0x304 */
  __IO uint32_t CCR;           /*!< ADC common control register,                           Address offset: 0x308 */
  __IO uint32_t CDR;           /*!< ADC common regular data register for dual mode,        Address offset: 0x30C */
  __IO uint32_t CDR2;          /*!< ADC common regular data register for dual mode 32-bit, Address offset: 0x310 */
} ADC_Common_TypeDef;

/**
  * @brief Boot and Security
  */

typedef struct
{
  __IO uint32_t FVRw[384];       /*!< BSEC fuse word (0-383) value register,       Address offset: 0x000-0x5FC */
       uint32_t RESERVED0[128];  /*!< Reserved,                                    Address offset: 0x600-0x7FC */
  __IO uint32_t SPLOCKx[12];     /*!< BSEC sticky program lock register (0-11),    Address offset: 0x800-0x82C */
       uint32_t RESERVED1[4];    /*!< Reserved,                                    Address offset: 0x830-0x83C */
  __IO uint32_t SWLOCKx[12];     /*!< BSEC sticky write lock register (0-11),      Address offset: 0x840-0x86C */
       uint32_t RESERVED2[4];    /*!< Reserved,                                    Address offset: 0x870-0x87C */
  __IO uint32_t SRLOCKx[12];     /*!< BSEC sticky reload lock register (0-11),     Address offset: 0x880-0x8AC */
       uint32_t RESERVED3[4];    /*!< Reserved,                                    Address offset: 0x8B0-0x8BC */
  __IO uint32_t OTPVLDRx[12];    /*!< BSEC OTP valid register (0-11),              Address offset: 0x8C0-0x8EC */
       uint32_t RESERVED4[20];   /*!< Reserved,                                    Address offset: 0x8F0-0x93C */
  __IO uint32_t SFSRx[12];       /*!< BSEC shadowed fuses status register (0-11),  Address offset: 0x940-0x96C */
       uint32_t RESERVED5[165];  /*!< Reserved,                                    Address offset: 0x970-0xC00 */
  __IO uint32_t OTPCR;           /*!< BSEC OTP control register,                   Address offset: 0xC04 */
  __IO uint32_t WDR;             /*!< BSEC write data register,                    Address offset: 0xC08 */
       uint32_t RESERVED6[125];  /*!< Reserved,                                    Address offset: 0xC0C-0xDFC */
  __IO uint32_t SCRATCHRx[4];    /*!< BSEC scratch register (0-3),                 Address offset: 0xE00-0xE0C */
  __IO uint32_t LOCKR;           /*!< BSEC lock register,                          Address offset: 0xE10 */
  __IO uint32_t JTAGINR;         /*!< BSEC JTAG input register,                    Address offset: 0xE14 */
  __IO uint32_t JTAGOUTR;        /*!< BSEC JTAG output register,                   Address offset: 0xE18 */
       uint32_t RESERVED7[2];    /*!< Reserved,                                    Address offset: 0xE1C-0xE20 */
  __IO uint32_t UNMAPR;          /*!< BSEC unmap register,                         Address offset: 0xE24 */
       uint32_t RESERVED8[6];    /*!< Reserved,                                    Address offset: 0xE28-0xE3C */
  __IO uint32_t SR;              /*!< BSEC status register,                        Address offset: 0xE40 */
  __IO uint32_t OTPSR;           /*!< BSEC OTP status register,                    Address offset: 0xE44 */
       uint32_t RESERVED9[14];   /*!< Reserved,                                    Address offset: 0xE48-0xE7C */
  __IO uint32_t EPOCHRx[2];      /*!< BSEC epoch register (0-1),                   Address offset: 0xE80-0xE84 */
  __IO uint32_t EPOCHSELR;       /*!< BSEC epoch select register,                  Address offset: 0xE88 */
  __IO uint32_t DBGCR;           /*!< BSEC debug control register,                 Address offset: 0xE8C */
  __IO uint32_t AP_UNLOCK;       /*!< BSEC AP unlock,                              Address offset: 0xE90 */
  __IO uint32_t HDPLSR;          /*!< BSEC hide protection level status register,  Address offset: 0xE94 */
  __IO uint32_t HDPLCR;          /*!< BSEC hide protection level control register, Address offset: 0xE98 */
  __IO uint32_t NEXTLR;          /*!< BSEC next hide protection level register,    Address offset: 0xE9C */
       uint32_t RESERVED10[40];  /*!< Reserved,                                    Address offset: 0xEA0-0xF3C */
  __IO uint32_t WOSCRx[8];       /*!< BSEC write once scratch register (0-7),      Address offset: 0xF40-0xF5C */
       uint32_t RESERVED11[34];  /*!< Reserved,                                    Address offset: 0xF60-0xFE4 */
  __IO uint32_t HRCR;            /*!< BSEC hot reset count register,               Address offset: 0xFE8 */
  __IO uint32_t WRCR;            /*!< BSEC warm reset count register,              Address offset: 0xFEC */
} BSEC_TypeDef;

/**
  * @brief Axi Cache
  */
typedef struct
{
  __IO uint32_t CR1;            /*!< CACHEAXI control register 1,                   Address offset: 0x00 */
  __IO uint32_t SR;             /*!< CACHEAXI status register,                      Address offset: 0x04 */
  __IO uint32_t IER;            /*!< CACHEAXI interrupt enable register,            Address offset: 0x08 */
  __IO uint32_t FCR;            /*!< CACHEAXI flag clear register,                  Address offset: 0x0C */
  __IO uint32_t RHMONR;         /*!< CACHEAXI read hit monitor register,            Address offset: 0x10 */
  __IO uint32_t RMMONR;         /*!< CACHEAXI read miss monitor register,           Address offset: 0x14 */
  __IO uint32_t RAMMONR;        /*!< CACHEAXI read-allocate miss monitor register,  Address offset: 0x18 */
  __IO uint32_t EVIMONR;        /*!< CACHEAXI eviction monitor register,            Address offset: 0x1C */
  __IO uint32_t WHMONR;         /*!< CACHEAXI write-hit monitor register,           Address offset: 0x20 */
  __IO uint32_t WMMONR;         /*!< CACHEAXI write-miss monitor register,          Address offset: 0x24 */
  __IO uint32_t WAMMONR;        /*!< CACHEAXI write-allocate miss monitor register, Address offset: 0x28 */
  __IO uint32_t WTMONR;         /*!< CACHEAXI write-through monitor register,       Address offset: 0x2C */
       uint32_t RESERVED1[52];  /*!< Reserved,                                      Address offset: 0x30-0xFC */
  __IO uint32_t CR2;            /*!< CACHEAXI control register 2,                   Address offset: 0x100 */
  __IO uint32_t CMDRSADDRR;     /*!< CACHEAXI command start address register,       Address offset: 0x104 */
  __IO uint32_t CMDREADDRR;     /*!< CACHEAXI command end address register,         Address offset: 0x108 */
} CACHEAXI_TypeDef;

/**
  * @brief CRC calculation unit
  */
typedef struct
{
  __IO uint32_t DR;            /*!< CRC Data register,                              Address offset: 0x00 */
  __IO uint32_t IDR;           /*!< CRC Independent data register,                  Address offset: 0x04 */
  __IO uint32_t CR;            /*!< CRC Control register,                           Address offset: 0x08 */
       uint32_t RESERVED1;     /*!< Reserved,                                                       0x0C */
  __IO uint32_t INIT;          /*!< Initial CRC value register,                     Address offset: 0x10 */
  __IO uint32_t POL;           /*!< CRC polynomial register,                        Address offset: 0x14 */
} CRC_TypeDef;


/**
  * @brief Cryp Processor
  */
typedef struct
{
  __IO uint32_t CR;         /*!< CRYP control register,                                    Address offset: 0x00 */
  __IO uint32_t SR;         /*!< CRYP status register,                                     Address offset: 0x04 */
  __IO uint32_t DIN;        /*!< CRYP data input register,                                 Address offset: 0x08 */
  __IO uint32_t DOUT;       /*!< CRYP data output register,                                Address offset: 0x0C */
  __IO uint32_t DMACR;      /*!< CRYP DMA control register,                                Address offset: 0x10 */
  __IO uint32_t IMSCR;      /*!< CRYP interrupt mask set/clear register,                   Address offset: 0x14 */
  __IO uint32_t RISR;       /*!< CRYP raw interrupt status register,                       Address offset: 0x18 */
  __IO uint32_t MISR;       /*!< CRYP masked interrupt status register,                    Address offset: 0x1C */
  __IO uint32_t K0LR;       /*!< CRYP key left  register 0,                                Address offset: 0x20 */
  __IO uint32_t K0RR;       /*!< CRYP key right register 0,                                Address offset: 0x24 */
  __IO uint32_t K1LR;       /*!< CRYP key left  register 1,                                Address offset: 0x28 */
  __IO uint32_t K1RR;       /*!< CRYP key right register 1,                                Address offset: 0x2C */
  __IO uint32_t K2LR;       /*!< CRYP key left  register 2,                                Address offset: 0x30 */
  __IO uint32_t K2RR;       /*!< CRYP key right register 2,                                Address offset: 0x34 */
  __IO uint32_t K3LR;       /*!< CRYP key left  register 3,                                Address offset: 0x38 */
  __IO uint32_t K3RR;       /*!< CRYP key right register 3,                                Address offset: 0x3C */
  __IO uint32_t IV0LR;      /*!< CRYP initialization vector left-word  register 0,         Address offset: 0x40 */
  __IO uint32_t IV0RR;      /*!< CRYP initialization vector right-word register 0,         Address offset: 0x44 */
  __IO uint32_t IV1LR;      /*!< CRYP initialization vector left-word  register 1,         Address offset: 0x48 */
  __IO uint32_t IV1RR;      /*!< CRYP initialization vector right-word register 1,         Address offset: 0x4C */
  __IO uint32_t CSGCMCCM0R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 0,        Address offset: 0x50 */
  __IO uint32_t CSGCMCCM1R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 1,        Address offset: 0x54 */
  __IO uint32_t CSGCMCCM2R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 2,        Address offset: 0x58 */
  __IO uint32_t CSGCMCCM3R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 3,        Address offset: 0x5C */
  __IO uint32_t CSGCMCCM4R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 4,        Address offset: 0x60 */
  __IO uint32_t CSGCMCCM5R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 5,        Address offset: 0x64 */
  __IO uint32_t CSGCMCCM6R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 6,        Address offset: 0x68 */
  __IO uint32_t CSGCMCCM7R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 7,        Address offset: 0x6C */
  __IO uint32_t CSGCM0R;    /*!< CRYP GCM/GMAC context swap register 0,                    Address offset: 0x70 */
  __IO uint32_t CSGCM1R;    /*!< CRYP GCM/GMAC context swap register 1,                    Address offset: 0x74 */
  __IO uint32_t CSGCM2R;    /*!< CRYP GCM/GMAC context swap register 2,                    Address offset: 0x78 */
  __IO uint32_t CSGCM3R;    /*!< CRYP GCM/GMAC context swap register 3,                    Address offset: 0x7C */
  __IO uint32_t CSGCM4R;    /*!< CRYP GCM/GMAC context swap register 4,                    Address offset: 0x80 */
  __IO uint32_t CSGCM5R;    /*!< CRYP GCM/GMAC context swap register 5,                    Address offset: 0x84 */
  __IO uint32_t CSGCM6R;    /*!< CRYP GCM/GMAC context swap register 6,                    Address offset: 0x88 */
  __IO uint32_t CSGCM7R;    /*!< CRYP GCM/GMAC context swap register 7,                    Address offset: 0x8C */
} CRYP_TypeDef;

/*
 * @brief  (CSI)
 */
typedef struct
{
  __IO uint32_t CR;               /*!< CSI-2 Host control register                           Address offset: 0x0000 */
  __IO uint32_t PCR;              /*!< CSI-2 Host DPHY_RX control register                   Address offset: 0x0004 */
       uint32_t RESERVED0[2];     /*!< Reserved                                              Address offset: 0x0008-0x000C */
  __IO uint32_t VC0CFGR1;         /*!< CSI-2 Host virtual channel 0 configuration register 1 Address offset: 0x0010 */
  __IO uint32_t VC0CFGR2;         /*!< CSI-2 Host virtual channel 0 configuration register 2 Address offset: 0x0014 */
  __IO uint32_t VC0CFGR3;         /*!< CSI-2 Host virtual channel 0 configuration register 3 Address offset: 0x0018 */
  __IO uint32_t VC0CFGR4;         /*!< CSI-2 Host virtual channel 0 configuration register 4 Address offset: 0x001C */
  __IO uint32_t VC1CFGR1;         /*!< CSI-2 Host virtual channel 1 configuration register 1 Address offset: 0x0020 */
  __IO uint32_t VC1CFGR2;         /*!< CSI-2 Host virtual channel 1 configuration register 2 Address offset: 0x0024 */
  __IO uint32_t VC1CFGR3;         /*!< CSI-2 Host virtual channel 1 configuration register 3 Address offset: 0x0028 */
  __IO uint32_t VC1CFGR4;         /*!< CSI-2 Host virtual channel 1 configuration register 4 Address offset: 0x002C */
  __IO uint32_t VC2CFGR1;         /*!< CSI-2 Host virtual channel 2 configuration register 1 Address offset: 0x0030 */
  __IO uint32_t VC2CFGR2;         /*!< CSI-2 Host virtual channel 2 configuration register 2 Address offset: 0x0034 */
  __IO uint32_t VC2CFGR3;         /*!< CSI-2 Host virtual channel 2 configuration register 3 Address offset: 0x0038 */
  __IO uint32_t VC2CFGR4;         /*!< CSI-2 Host virtual channel 2 configuration register 4 Address offset: 0x003C */
  __IO uint32_t VC3CFGR1;         /*!< CSI-2 Host virtual channel 3 configuration register 1 Address offset: 0x0040 */
  __IO uint32_t VC3CFGR2;         /*!< CSI-2 Host virtual channel 3 configuration register 2 Address offset: 0x0044 */
  __IO uint32_t VC3CFGR3;         /*!< CSI-2 Host virtual channel 3 configuration register 3 Address offset: 0x0048 */
  __IO uint32_t VC3CFGR4;         /*!< CSI-2 Host virtual channel 3 configuration register 4 Address offset: 0x004C */
  __IO uint32_t LB0CFGR;          /*!< CSI-2 Host line byte 0 configuration register         Address offset: 0x0050 */
  __IO uint32_t LB1CFGR;          /*!< CSI-2 Host line byte 1 configuration register         Address offset: 0x0054 */
  __IO uint32_t LB2CFGR;          /*!< CSI-2 Host line byte 2 configuration register         Address offset: 0x0058 */
  __IO uint32_t LB3CFGR;          /*!< CSI-2 Host line byte 3 configuration register         Address offset: 0x005C */
  __IO uint32_t TIM0CFGR;         /*!< CSI-2 Host timer 0 configuration register             Address offset: 0x0060 */
  __IO uint32_t TIM1CFGR;         /*!< CSI-2 Host timer 1 configuration register             Address offset: 0x0064 */
  __IO uint32_t TIM2CFGR;         /*!< CSI-2 Host timer 2 configuration register             Address offset: 0x0068 */
  __IO uint32_t TIM3CFGR;         /*!< CSI-2 Host timer 3 configuration register             Address offset: 0x006C */
  __IO uint32_t LMCFGR;           /*!< CSI-2 Host lane merger configuration register         Address offset: 0x0070 */
  __IO uint32_t PRGITR;           /*!< CSI-2 Host program interrupt register                 Address offset: 0x0074 */
  __IO uint32_t WDR;              /*!< CSI-2 Host watchdog register                          Address offset: 0x0078 */
       uint32_t RESERVED1;        /*!< Reserved                                              Address offset: 0x007C */
  __IO uint32_t IER0;             /*!< CSI-2 Host Interrupt enable register 0                Address offset: 0x0080 */
  __IO uint32_t IER1;             /*!< CSI-2 Host Interrupt enable register 1                Address offset: 0x0084 */
       uint32_t RESERVED2[2];     /*!< Reserved                                              Address offset: 0x0088-0x008C */
  __IO uint32_t SR0;              /*!< CSI-2 Host status register 0                          Address offset: 0x0090 */
  __IO uint32_t SR1;              /*!< CSI-2 Host status register 1                          Address offset: 0x0094 */
       uint32_t RESERVED3[26];    /*!< Reserved                                              Address offset: 0x0098-0x00FC */
  __IO uint32_t FCR0;             /*!< CSI-2 Host Flag clear register 0                      Address offset: 0x0100 */
  __IO uint32_t FCR1;             /*!< CSI-2 Host Flag clear register 1                      Address offset: 0x0104 */
       uint32_t RESERVED4[2];     /*!< Reserved                                              Address offset: 0x0108-0x010C */
  __IO uint32_t SPDFR;            /*!< CSI-2 Host short packet data field register           Address offset: 0x0110 */
  __IO uint32_t ERR1;             /*!< CSI-2 Host error register 1                           Address offset: 0x0114 */
  __IO uint32_t ERR2;             /*!< CSI-2 Host error register 2                           Address offset: 0x0118 */
       uint32_t RESERVED5[953];   /*!< Reserved                                              Address offset: 0x011C-0x0FFC */
  __IO uint32_t PRCR;             /*!< CSI PHY reset control register                        Address offset: 0x1000 */
  __IO uint32_t PMCR;             /*!< CSI PHY mode control register                         Address offset: 0x1004 */
  __IO uint32_t PFCR;             /*!< CSI PHY frequency control register                    Address offset: 0x1008 */
       uint32_t RESERVED6;        /*!< Reserved                                              Address offset: 0x100C */
  __IO uint32_t PTCR0;            /*!< CSI PHY test control register 0                       Address offset: 0x1010 */
  __IO uint32_t PTCR1;            /*!< CSI PHY test control register 1                       Address offset: 0x1014 */
  __IO uint32_t PTSR;             /*!< CSI PHY test status register                          Address offset: 0x1018 */
       uint32_t RESERVED7[1017];  /*!< Reserved                                              Address offset: 0x101C-0x1FFC */
} CSI_TypeDef;

/**
  * @brief Debug MCU
  */
typedef struct
{
  __IO uint32_t IDCODE;        /*!< MCU device ID code,                            Address offset: 0x00  */
  __IO uint32_t CR;            /*!< Debug MCU configuration register,              Address offset: 0x04  */
  uint32_t RESERVED1[2];       /*!< Reserved,                                  Address offset: 0x08-0x0C */
  __IO uint32_t APB1LFZ1;      /*!< Debug MCU APB1LFZ1 freeze register,            Address offset: 0x10  */
  __IO uint32_t APB1HFZ1;      /*!< Debug MCU APB1HFZ1 freeze register,            Address offset: 0x14  */
  __IO uint32_t APB2FZ1;       /*!< Debug MCU APB2FZ1 freeze register,             Address offset: 0x18  */
  __IO uint32_t APB4FZ1;       /*!< Debug MCU APB4FZ1 freeze register,             Address offset: 0x1C  */
  __IO uint32_t APB5FZ1;       /*!< Debug MCU APB5FZ1 freeze register,             Address offset: 0x20  */
  __IO uint32_t AHB1FZ1;       /*!< Debug MCU AHB1FZ1 freeze register,             Address offset: 0x24  */
  __IO uint32_t AHB5FZ1;       /*!< Debug MCU AHB5FZ1 freeze register,             Address offset: 0x28  */
  uint32_t RESERVED2[52];      /*!< Reserved,                                  Address offset: 0x2C-0xF8 */
  __IO uint32_t SR;            /*!< Debug MCU status register,                     Address offset: 0xFC  */
  __IO uint32_t DBG_AUTH_HOST; /*!< Debug MCU authentication host register,        Address offset: 0x100 */
  __IO uint32_t DBG_AUTH_DEV;  /*!< Debug MCU authentication device register,      Address offset: 0x104 */
  __IO uint32_t DBG_AUTH_ACK;  /*!< Debug MCU acknowledge authentication register, Address offset: 0x104 */
} DBGMCU_TypeDef;

/**
  * @brief DCMI
  */
typedef struct
{
  __IO uint32_t CR;       /*!< DCMI control register 1,                       Address offset: 0x00 */
  __IO uint32_t SR;       /*!< DCMI status register,                          Address offset: 0x04 */
  __IO uint32_t RISR;     /*!< DCMI raw interrupt status register,            Address offset: 0x08 */
  __IO uint32_t IER;      /*!< DCMI interrupt enable register,                Address offset: 0x0C */
  __IO uint32_t MISR;     /*!< DCMI masked interrupt status register,         Address offset: 0x10 */
  __IO uint32_t ICR;      /*!< DCMI interrupt clear register,                 Address offset: 0x14 */
  __IO uint32_t ESCR;     /*!< DCMI embedded synchronization code register,   Address offset: 0x18 */
  __IO uint32_t ESUR;     /*!< DCMI embedded synchronization unmask register, Address offset: 0x1C */
  __IO uint32_t CWSTRTR;  /*!< DCMI crop window start,                        Address offset: 0x20 */
  __IO uint32_t CWSIZER;  /*!< DCMI crop window size,                         Address offset: 0x24 */
  __IO uint32_t DR;       /*!< DCMI data register,                            Address offset: 0x28 */
} DCMI_TypeDef;

#define DCMIPP_NUM_OF_PIPES 0x03U

typedef struct
{
  uint32_t PxRIxCR1;      /*! DCMIPP Pipex ROIx configuration register 1  Address offset: 0x924 + (x - 1) * 0x400, (x = 1 to 2)  */
  uint32_t PxRIxCR2;      /*! DCMIPP Pipex ROIx configuration register 2  Address offset: 0x928 + (x - 1) * 0x400, (x = 1 to 2)  */
} DCMIPP_Region_TypeDef;

/*
 * @brief Digital camera interface pixel pipeline DCMIPP
 */
typedef struct
{
  __IO uint32_t IPGR1;           /*!< DCMIPP IPPLUG global register 1                                    Address offset: 0x000 */
  __IO uint32_t IPGR2;           /*!< DCMIPP IPPLUG global register 2                                    Address offset: 0x004 */
  __IO uint32_t IPGR3;           /*!< DCMIPP IPPLUG global register 3                                    Address offset: 0x008 */
       uint32_t RESERVED0[4];    /*!< Reserved                                                           Address offset: 0x00C-0x018 */
  __IO uint32_t IPGR8;           /*!< DCMIPP IPPLUG identification register                              Address offset: 0x01C */
  __IO uint32_t IPC1R1;          /*!< DCMIPP IPPLUG Clientx register 1                                   Address offset: 0x020 + 0x10 * (x - 1), (x = 1 to 5) */
  __IO uint32_t IPC1R2;          /*!< DCMIPP IPPLUG Clientx register 2                                   Address offset: 0x024 + 0x10 * (x - 1), (x = 1 to 5) */
  __IO uint32_t IPC1R3;          /*!< DCMIPP IPPLUG Clientx register 3                                   Address offset: 0x028 + 0x10 * (x - 1), (x = 1 to 5) */
       uint32_t RESERVED1;       /*!< Reserved                                                           Address offset: 0x02C */
  __IO uint32_t IPC2R1;          /*!< DCMIPP IPPLUG Clientx register 1                                   Address offset: 0x030 */
  __IO uint32_t IPC2R2;          /*!< DCMIPP IPPLUG Clientx register 2                                   Address offset: 0x034 */
  __IO uint32_t IPC2R3;          /*!< DCMIPP IPPLUG Clientx register 3                                   Address offset: 0x038 */
       uint32_t RESERVED2;       /*!< Reserved                                                           Address offset: 0x03C */
  __IO uint32_t IPC3R1;          /*!< DCMIPP IPPLUG Clientx register 1                                   Address offset: 0x040 */
  __IO uint32_t IPC3R2;          /*!< DCMIPP IPPLUG Clientx register 2                                   Address offset: 0x044 */
  __IO uint32_t IPC3R3;          /*!< DCMIPP IPPLUG Clientx register 3                                   Address offset: 0x048 */
       uint32_t RESERVED3;       /*!< Reserved                                                           Address offset: 0x04C */
  __IO uint32_t IPC4R1;          /*!< DCMIPP IPPLUG Clientx register 1                                   Address offset: 0x050 */
  __IO uint32_t IPC4R2;          /*!< DCMIPP IPPLUG Clientx register 2                                   Address offset: 0x054 */
  __IO uint32_t IPC4R3;          /*!< DCMIPP IPPLUG Clientx register 3                                   Address offset: 0x058 */
       uint32_t RESERVED4;       /*!< Reserved                                                           Address offset: 0x05C */
  __IO uint32_t IPC5R1;          /*!< DCMIPP IPPLUG Clientx register 1                                   Address offset: 0x060 */
  __IO uint32_t IPC5R2;          /*!< DCMIPP IPPLUG Clientx register 2                                   Address offset: 0x064 */
  __IO uint32_t IPC5R3;          /*!< DCMIPP IPPLUG Clientx register 3                                   Address offset: 0x068 */
       uint32_t RESERVED5[38];   /*!< Reserved                                                           Address offset: 0x06C-0x100 */
  __IO uint32_t PRCR;            /*!< DCMIPP parallel interface control register                         Address offset: 0x104 */
  __IO uint32_t PRESCR;          /*!< DCMIPP parallel interface embedded synchronization code register   Address offset: 0x108 */
  __IO uint32_t PRESUR;          /*!< DCMIPP parallel interface embedded synchronization unmask register Address offset: 0x10C */
       uint32_t RESERVED6[57];   /*!< Reserved                                                           Address offset: 0x110-0x1F0 */
  __IO uint32_t PRIER;           /*!< DCMIPP parallel interface interrupt enable register                Address offset: 0x1F4 */
  __IO uint32_t PRSR;            /*!< DCMIPP parallel interface status register                          Address offset: 0x1F8 */
  __IO uint32_t PRFCR;           /*!< DCMIPP parallel interface interrupt clear register                 Address offset: 0x1FC */
       uint32_t RESERVED7;       /*!< Reserved                                                           Address offset: 0x200 */
  __IO uint32_t CMCR;            /*!< DCMIPP common configuration register                               Address offset: 0x204 */
  __IO uint32_t CMFRCR;          /*!< DCMIPP common frame counter register                               Address offset: 0x208 */
       uint32_t RESERVED8[121];  /*!< Reserved                                                           Address offset: 0x20C-0x3EC */
  __IO uint32_t CMIER;           /*!< DCMIPP common interrupt enable register                            Address offset: 0x3F0 */
  __IO uint32_t CMSR1;           /*!< DCMIPP common status register 1                                    Address offset: 0x3F4 */
  __IO uint32_t CMSR2;           /*!< DCMIPP common status register 2                                    Address offset: 0x3F8 */
  __IO uint32_t CMFCR;           /*!< DCMIPP common interrupt clear register                             Address offset: 0x3FC */
       uint32_t RESERVED9;            /*!< Reserved                                                      Address offset: 0x400 */
  __IO uint32_t P0FSCR;          /*!< DCMIPP Pipe0 flow selection configuration register                 Address offset: 0x404 */
       uint32_t RESERVED10[62];  /*!< Reserved                                                           Address offset: 0x408-0x4FC */
  __IO uint32_t P0FCTCR;         /*!< DCMIPP Pipe0 flow control configuration register                   Address offset: 0x500 */
  __IO uint32_t P0SCSTR;         /*!< DCMIPP Pipe0 stat/crop start register                              Address offset: 0x504 */
  __IO uint32_t P0SCSZR;         /*!< DCMIPP Pipe0 stat/crop size register                               Address offset: 0x508 */
       uint32_t RESERVED11[41];  /*!< Reserved                                                           Address offset: 0x50C-0x5AC */
  __IO uint32_t P0DCCNTR;        /*!< DCMIPP Pipe0 dump counter register                                 Address offset: 0x5B0 */
  __IO uint32_t P0DCLMTR;        /*!< DCMIPP Pipe0 dump limit register                                   Address offset: 0x5B4 */
       uint32_t RESERVED12[2];   /*!< Reserved                                                           Address offset: 0x5B8-0x5BC */
  __IO uint32_t P0PPCR;          /*!< DCMIPP Pipe0 pixel packer configuration register                   Address offset: 0x5C0 */
  __IO uint32_t P0PPM0AR1;       /*!< DCMIPP Pipe0 pixel packer Memory0 address register 1               Address offset: 0x5C4 */
  __IO uint32_t P0PPM0AR2;       /*!< DCMIPP Pipe0 pixel packer Memory0 address register 2               Address offset: 0x5C8 */
       uint32_t RESERVED13;      /*!< Reserved                                                           Address offset: 0x5C8-0x5CC */
  __IO uint32_t P0STM0AR;        /*!< DCMIPP Pipe0 status Memory0 address register                       Address offset: 0x5D0 */
       uint32_t RESERVED14[8];   /*!< Reserved                                                           Address offset: 0x5D4-0x5F0 */
  __IO uint32_t P0IER;           /*!< DCMIPP Pipe0 interrupt enable register                             Address offset: 0x5F4 */
  __IO uint32_t P0SR;            /*!< DCMIPP Pipe0 status register                                       Address offset: 0x5F8 */
  __IO uint32_t P0FCR;           /*!< DCMIPP Pipe0 interrupt clear register                              Address offset: 0x5FC */
       uint32_t RESERVED15;      /*!< Reserved                                                           Address offset: 0x600 */
  __IO uint32_t P0CFSCR;         /*!< DCMIPP Pipe0 current flow selection configuration register         Address offset: 0x604 */
       uint32_t RESERVED17[62];  /*!< Reserved                                                           Address offset: 0x608-0x6FC */
  __IO uint32_t P0CFCTCR;        /*!< DCMIPP Pipe0 current flow control configuration register           Address offset: 0x700 */
  __IO uint32_t P0CSCSTR;        /*!< DCMIPP Pipe0 current stat/crop start register                      Address offset: 0x704 */
  __IO uint32_t P0CSCSZR;        /*!< DCMIPP Pipe0 current stat/crop size register                       Address offset: 0x708 */
       uint32_t RESERVED18[45];  /*!< Reserved                                                           Address offset: 0x70C-0x7BC */
  __IO uint32_t P0CPPCR;         /*!< DCMIPP Pipe0 current pixel packer configuration register           Address offset: 0x7C0 */
  __IO uint32_t P0CPPM0AR1;      /*!< DCMIPP Pipe0 current pixel packer Memory0 address register 1       Address offset: 0x7C4 */
  __IO uint32_t P0CPPM0AR2;      /*!< DCMIPP Pipe0 current pixel packer Memory0 address register 2       Address offset: */
       uint32_t RESERVED19[14];  /*!< Reserved                                                           Address offset: 0x7C8-0x7FC */
  __IO uint32_t P1FSCR;          /*!< DCMIPP Pipe1 flow selection configuration register                 Address offset: 0x804 */
       uint32_t RESERVED20[6];   /*!< Reserved                                                           Address offset: 0x808-0x81C */
  __IO uint32_t P1SRCR;          /*!< DCMIPP Pipe1 stat removal configuration register                   Address offset: 0x820 */
  __IO uint32_t P1BPRCR;         /*!< DCMIPP Pipe1 bad pixel removal control register                    Address offset: 0x824 */
  __IO uint32_t P1BPRSR;         /*!< DCMIPP Pipe1 bad pixel removal status register                     Address offset: 0x828 */
       uint32_t RESERVED21;      /*!< Reserved                                                           Address offset: 0x82C */
  __IO uint32_t P1DECR;          /*!< DCMIPP Pipe1 decimation register                                   Address offset: 0x830 */
       uint32_t RESERVED22[3];   /*!< Reserved                                                           Address offset: 0x834-0x83C */
  __IO uint32_t P1BLCCR;         /*!< DCMIPP Pipe1 black level calibration control register              Address offset: 0x840 */
  __IO uint32_t P1EXCR1;         /*!< DCMIPP Pipe1 exposure control register 1                           Address offset: 0x844 */
  __IO uint32_t P1EXCR2;         /*!< DCMIPP Pipe1 exposure control register 2                           Address offset: 0x848 */
       uint32_t RESERVED23;      /*!< Reserved                                                           Address offset: 0x84C */
  __IO uint32_t P1ST1CR;         /*!< DCMIPP Pipe1 statistics 1 control register                         Address offset: 0x850 */
  __IO uint32_t P1ST2CR;         /*!< DCMIPP Pipe1 statistics 2 control register                         Address offset: 0x854 */
  __IO uint32_t P1ST3CR;         /*!< DCMIPP Pipe1 statistics 3 control register                         Address offset: 0x858 */
  __IO uint32_t P1STSTR;         /*!< DCMIPP Pipe1 statistics window start register                      Address offset: 0x85C */
  __IO uint32_t P1STSZR;         /*!< DCMIPP Pipe1 statistics window size register                       Address offset: 0x860 */
  __IO uint32_t P1ST1SR;         /*!< DCMIPP Pipe1 statistics 1 status register                          Address offset: 0x864 */
  __IO uint32_t P1ST2SR;         /*!< DCMIPP Pipe1 statistics 2 status register                          Address offset: 0x868 */
  __IO uint32_t P1ST3SR;         /*!< DCMIPP Pipe1 statistics 3 status register                          Address offset: 0x86C */
  __IO uint32_t P1DMCR;          /*!< DCMIPP Pipe1 demosaicing configuration register                    Address offset: 0x870 */
       uint32_t RESERVED24[3];   /*!< Reserved                                                           Address offset: 0x874-0x87C */
  __IO uint32_t P1CCCR;          /*!< DCMIPP Pipe1 ColorConv configuration register                      Address offset: 0x880 */
  __IO uint32_t P1CCRR1;         /*!< DCMIPP Pipe1 ColorConv red coefficient register 1                  Address offset: 0x884 */
  __IO uint32_t P1CCRR2;         /*!< DCMIPP Pipe1 ColorConv red coefficient register 2                  Address offset: 0x888 */
  __IO uint32_t P1CCGR1;         /*!< DCMIPP Pipe1 ColorConv green coefficient register 1                Address offset: 0x88C */
  __IO uint32_t P1CCGR2;         /*!< DCMIPP Pipe1 ColorConv green coefficient register 2                Address offset: 0x890 */
  __IO uint32_t P1CCBR1;         /*!< DCMIPP Pipe1 ColorConv blue coefficient register 1                 Address offset: 0x894 */
  __IO uint32_t P1CCBR2;         /*!< DCMIPP Pipe1 ColorConv blue coefficient register 2                 Address offset: 0x898 */
       uint32_t RESERVED25;      /*!< Reserved                                                           Address offset: 0x89C */
  __IO uint32_t P1CTCR1;         /*!< DCMIPP Pipe1 contrast control register 1                           Address offset: 0x8A0 */
  __IO uint32_t P1CTCR2;         /*!< DCMIPP Pipe1 contrast control register 2                           Address offset: 0x8A4 */
  __IO uint32_t P1CTCR3;         /*!< DCMIPP Pipe1 contrast control register 3                           Address offset: 0x8A8 */
       uint32_t RESERVED26[21];  /*!< Reserved                                                           Address offset: 0x8AC-0x8FC */
  __IO uint32_t P1FCTCR;         /*!< DCMIPP Pipe1 flow control configuration register                   Address offset: 0x900 */
  __IO uint32_t P1CRSTR;         /*!< DCMIPP Pipe1 crop window start register                            Address offset: 0x904 */
  __IO uint32_t P1CRSZR;         /*!< DCMIPP Pipe1 crop window size register                             Address offset: 0x908 */
  __IO uint32_t P1DCCR;          /*!< DCMIPP Pipe1 decimation register                                   Address offset: 0x90C */
  __IO uint32_t P1DSCR;          /*!< DCMIPP Pipe1 downsize configuration register                       Address offset: 0x910 */
  __IO uint32_t P1DSRTIOR;       /*!< DCMIPP Pipe1 downsize ratio register                               Address offset: 0x914 */
  __IO uint32_t P1DSSZR;         /*!< DCMIPP Pipe1 downsize destination size register                    Address offset: 0x918 */
       uint32_t RESERVED28;      /*!< Reserved                                                           Address offset:  */
  __IO uint32_t P1CMRICR;        /*!< DCMIPP Pipe1 common ROI configuration register                     Address offset: 0x920 */
  __IO uint32_t P1RIxCR1;        /*!< DCMIPP Pipe1 ROIx configuration register 1                         Address offset: 0x924 + (x - 1) * 0x8, (x = 1 to 8) */
  __IO uint32_t P1RIxCR2;        /*!< DCMIPP Pipe1 ROIx configuration register 2                         Address offset: 0x928 + (x - 1) * 0x8, (x = 1 to 8) */
       uint32_t RESERVED29[17];      /*!< Reserved                                                       Address offset:  */
  __IO uint32_t P1GMCR;          /*!< DCMIPP Pipe1 gamma configuration register                          Address offset: 0x970 */
       uint32_t RESERVED30[3];   /*!< Reserved                                                           Address offset: 0x974-0x97C */
  __IO uint32_t P1YUVCR;         /*!< DCMIPP Pipe1 YUVConv configuration register                        Address offset: 0x980 */
  __IO uint32_t P1YUVRR1;        /*!< DCMIPP Pipe1 YUVConv red coefficient register 1                    Address offset: 0x984 */
  __IO uint32_t P1YUVRR2;        /*!< DCMIPP Pipe1 YUVConv red coefficient register 2                    Address offset: 0x988 */
  __IO uint32_t P1YUVGR1;        /*!< DCMIPP Pipe1 YUVConv green coefficient register 1                  Address offset: 0x98C */
  __IO uint32_t P1YUVGR2;        /*!< DCMIPP Pipe1 YUVConv green coefficient register 2                  Address offset: 0x990 */
  __IO uint32_t P1YUVBR1;        /*!< DCMIPP Pipe1 YUVConv blue coefficient register 1                   Address offset: 0x994 */
  __IO uint32_t P1YUVBR2;        /*!< DCMIPP Pipe1 YUV blue coefficient register 2                       Address offset: 0x998 */
       uint32_t RESERVED31[9];   /*!< Reserved                                                           Address offset: 0x99C-0x9BC */
  __IO uint32_t P1PPCR;          /*!< DCMIPP Pipe1 pixel packer configuration register                   Address offset: 0x9C0 */
  __IO uint32_t P1PPM0AR1;       /*!< DCMIPP Pipe1 pixel packer Memory0 address register 1               Address offset: 0x9C4 */
  __IO uint32_t P1PPM0AR2;       /*!< DCMIPP Pipe1 pixel packer Memory0 address register 2               Address offset: 0x9C8 */
  __IO uint32_t P1PPM0PR;        /*!< DCMIPP Pipe1 pixel packer Memory0 pitch register                   Address offset: 0x9CC */
  __IO uint32_t P1STM0AR;        /*!< DCMIPP Pipe1 status Memory0 address register                       Address offset: 0x9D0 */
  __IO uint32_t P1PPM1AR1;       /*!< DCMIPP Pipe1 pixel packer Memory1 address register 1               Address offset: 0x9D4 */
  __IO uint32_t P1PPM1AR2;       /*!< DCMIPP Pipe1 pixel packer Memory1 address register 2               Address offset: 0x9D8 */
  __IO uint32_t P1PPM1PR;        /*!< DCMIPP Pipe1 pixel packer Memory1 pitch register                   Address offset: 0x9DC */
  __IO uint32_t P1STM1AR;        /*!< DCMIPP Pipe1 status Memory1 address register                       Address offset: 0x9E0 */
  __IO uint32_t P1PPM2AR1;       /*!< DCMIPP Pipe1 pixel packer memory2 address register 1               Address offset: 0x9E4 */
  __IO uint32_t P1PPM2AR2;       /*!< DCMIPP Pipe1 pixel packer memory2 address register 2               Address offset: 0x9E8 */
  __IO uint32_t RESERVED34;      /*!< Reserved                                                           Address offset: 0x9EC */
  __IO uint32_t P1STM2AR;        /*!< DCMIPP Pipe1 status Memory2 address register                       Address offset: 0x9F0 */
  __IO uint32_t P1IER;           /*!< DCMIPP Pipe1 interrupt enable register                             Address offset: 0x9F4 */
  __IO uint32_t P1SR;            /*!< DCMIPP Pipe1 status register                                       Address offset: 0x9F8 */
  __IO uint32_t P1FCR;           /*!< DCMIPP Pipe1 interrupt clear register                              Address offset: 0x9FC */
       uint32_t RESERVED35;      /*!< Reserved                                                           Address offset: 0xA00 */
  __IO uint32_t P1CFSCR;         /*!< DCMIPP Pipe1 current flow selection configuration register         Address offset: 0xA04 */
       uint32_t RESERVED36[7];   /*!< Reserved                                                           Address offset: 0xA08-0xA20 */
  __IO uint32_t P1CBPRCR;        /*!< DCMIPP Pipe1 current bad pixel removal register                    Address offset: 0xA24 */
       uint32_t RESERVED37[6];   /*!< Reserved                                                           Address offset: 0xA28-0xA3C */
  __IO uint32_t P1CBLCCR;        /*!< DCMIPP Pipe1 current black level calibration control register      Address offset: 0xA40 */
  __IO uint32_t P1CEXCR1;        /*!< DCMIPP Pipe1 current exposure control register 1                   Address offset: 0xA44 */
  __IO uint32_t P1CEXCR2;        /*!< DCMIPP Pipe1 current exposure control register 2                   Address offset: 0xA48 */
       uint32_t RESERVED38;      /*!< Reserved                                                           Address offset: 0xA4C */
  __IO uint32_t P1CST1CR;        /*!< DCMIPP Pipe1 current statistics 1 control register                 Address offset: 0xA50 */
  __IO uint32_t P1CST2CR;        /*!< DCMIPP Pipe1 current statistics 2 control register                 Address offset: 0xA54 */
  __IO uint32_t P1CST3CR;        /*!< DCMIPP Pipe1 current statistics 3 control register                 Address offset: 0xA58 */
  __IO uint32_t P1CSTSTR;        /*!< DCMIPP Pipe1 current statistics window start register              Address offset: 0xA5C */
  __IO uint32_t P1CSTSZR;        /*!< DCMIPP Pipe1 current statistics window size register               Address offset: 0xA60 */
       uint32_t RESERVED39[7];   /*!< Reserved                                                           Address offset: 0xA64-0xA7C */
  __IO uint32_t P1CCCCR;         /*!< DCMIPP Pipe1 current ColorConv configuration register              Address offset: 0xA80 */
  __IO uint32_t P1CCCRR1;        /*!< DCMIPP Pipe1 current ColorConv red coefficient register 1          Address offset: 0xA84 */
  __IO uint32_t P1CCCRR2;        /*!< DCMIPP Pipe1 current ColorConv red coefficient register 2          Address offset: 0xA88 */
  __IO uint32_t P1CCCGR1;        /*!< DCMIPP Pipe1 current ColorConv green coefficient register 1        Address offset: 0xA8C */
  __IO uint32_t P1CCCGR2;        /*!< DCMIPP Pipe1 current ColorConv green coefficient register 2        Address offset: 0xA90 */
  __IO uint32_t P1CCCBR1;        /*!< DCMIPP Pipe1 current ColorConv blue coefficient register 1         Address offset: 0xA94 */
  __IO uint32_t P1CCCBR2;        /*!< DCMIPP Pipe1 current ColorConv blue coefficient register 2         Address offset: 0xA98 */
       uint32_t RESERVED40;      /*!< Reserved                                                           Address offset: 0xA9C */
  __IO uint32_t P1CCTCR1;        /*!< DCMIPP Pipe1 current contrast control register 1                   Address offset: 0xAA0 */
  __IO uint32_t P1CCTCR2;        /*!< DCMIPP Pipe1 current contrast control register 2                   Address offset: 0xAA4 */
  __IO uint32_t P1CCTCR3;        /*!< DCMIPP Pipe1 current contrast control register 3                   Address offset: 0xAA8 */
       uint32_t RESERVED41[21];  /*!< Reserved                                                           Address offset: 0xAAC-0xAFC */
  __IO uint32_t P1CFCTCR;        /*!< DCMIPP Pipe1 current flow control configuration register           Address offset: 0xB00 */
  __IO uint32_t P1CCRSTR;        /*!< DCMIPP Pipe1 current crop window start register                    Address offset: 0xB04 */
  __IO uint32_t P1CCRSZR;        /*!< DCMIPP Pipe1 current crop window size register                     Address offset: 0xB08 */
  __IO uint32_t P1CDCCR;         /*!< DCMIPP Pipe1 current decimation register                           Address offset: 0xB0C */
  __IO uint32_t P1CDSCR;         /*!< DCMIPP Pipe1 current downsize configuration register               Address offset: 0xB10 */
  __IO uint32_t P1CDSRTIOR;      /*!< DCMIPP Pipe1 current downsize ratio register                       Address offset: 0xB14 */
  __IO uint32_t P1CDSSZR;        /*!< DCMIPP Pipe1 current downsize destination size register            Address offset: 0xB18 */
       uint32_t RESERVED43;      /*!< Reserved                                                           Address offset: 0xB1C */
       uint32_t P1CCMRICR;       /*!< DCMIPP Pipe1 current common ROI configuration register             Address offset: 0xB20 */
  __IO uint32_t P1CRIxCR1;       /*!< DCMIPP Pipe1 current ROIx configuration register 1                 Address offset: 0xB24 + 0x8 * (x - 1), (x = 1 to 8) */
  __IO uint32_t P1CRIxCR2;       /*!< DCMIPP Pipe1 current ROIx configuration register 2                 Address offset: 0xB28 + 0x8 * (x - 1), (x = 1 to 8) */
  uint32_t RESERVED44[37];       /*!< Reserved                                                           Address offset: 0xB64-0xBBC */
  __IO uint32_t P1CPPCR;         /*!< DCMIPP Pipe1 current pixel packer configuration register           Address offset: 0xBC0 */
  __IO uint32_t P1CPPM0AR1;      /*!< DCMIPP Pipe1 current pixel packer Memory0 address register 1       Address offset: 0xBC4 */
  __IO uint32_t P1CPPM0AR2;      /*!< DCMIPP Pipe1 current pixel packer Memory0 address register 1       Address offset: 0xBC8 */
  __IO uint32_t P1CPPM0PR;       /*!< DCMIPP Pipe1 current pixel packer Memory0 pitch register           Address offset: 0xBCC */
       uint32_t RESERVED45;      /*!< Reserved                                                           Address offset: 0xBD0 */
  __IO uint32_t P1CPPM1AR1;      /*!< DCMIPP Pipe1 current pixel packer Memory1 address register 1       Address offset: 0xBD4 */
  __IO uint32_t P1CPPM1AR2;      /*!< DCMIPP Pipe1 current pixel packer Memory1 address register 2       Address offset: 0xBD8 */
  __IO uint32_t P1CPPM1PR;       /*!< DCMIPP Pipe1 current pixel packer Memory1 pitch register           Address offset: 0xBDC */
       uint32_t RESERVED47;      /*!< Reserved                                                           Address offset: 0xBE0 */
  __IO uint32_t P1CPPM2AR1;      /*!< DCMIPP Pipe1 current pixel packer memory2 address register 1       Address offset: 0xBE4 */
  __IO uint32_t P1CPPM2AR2;      /*!< DCMIPP Pipe1 current pixel packer Memory2 address register 2       Address offset: 0xBE8 */
       uint32_t RESERVED48[6];   /*!< Reserved                                                           Address offset: 0xBE8-0xBFC */
  __IO uint32_t P2FSCR;          /*!< DCMIPP Pipe2 flow selection configuration register                 Address offset: 0xC04 */
       uint32_t RESERVED49[62];  /*!< Reserved                                                           Address offset: 0xC08-0xCFC */
  __IO uint32_t P2FCTCR;         /*!< DCMIPP Pipe2 flow control configuration register                   Address offset: 0xD00 */
  __IO uint32_t P2CRSTR;         /*!< DCMIPP Pipe2 crop window start register                            Address offset: 0xD04 */
  __IO uint32_t P2CRSZR;         /*!< DCMIPP Pipe2 crop window size register                             Address offset: 0xD08 */
  __IO uint32_t P2DCCR;          /*!< DCMIPP Pipe2 decimation register                                   Address offset: 0xD0C */
  __IO uint32_t P2DSCR;          /*!< DCMIPP Pipe2 downsize configuration register                       Address offset: 0xD10 */
  __IO uint32_t P2DSRTIOR;       /*!< DCMIPP Pipe2 downsize ratio register                               Address offset: 0xD14 */
  __IO uint32_t P2DSSZR;         /*!< DCMIPP Pipe2 downsize destination size register                    Address offset: 0xD18 */
       uint32_t RESERVED51;      /*!< Reserved                                                           Address offset:  0xD1C */
  __IO uint32_t P2CMRICR;        /*!< DCMIPP Pipe2 common ROI configuration register                     Address offset:  0xD20 */
  __IO uint32_t P2RIxCR1;        /*!< DCMIPP Pipe2 ROIx configuration register 1                         Address offset: 0xD24 + (x - 1) * 0x8, (x = 1 to 8) */
  __IO uint32_t P2RIxCR2;        /*!< DCMIPP Pipe2 ROIx configuration register 2                         Address offset: 0xD28 + (x - 1) * 0x8, (x = 1 to 8) */
       uint32_t RESERVED53[17];  /*!< Reserved                                                           Address offset: */
  __IO uint32_t P2GMCR;          /*!< DCMIPP Pipe2 gamma configuration register                          Address offset: 0xD70 */
       uint32_t RESERVED54[19];  /*!< Reserved                                                           Address offset: 0xD74-0xDBC */
  __IO uint32_t P2PPCR;          /*!< DCMIPP Pipe2 pixel packer configuration register                   Address offset: 0xDC0 */
  __IO uint32_t P2PPM0AR1;       /*!< DCMIPP Pipe2 pixel packer Memory0 address register 1               Address offset: 0xDC4 */
  __IO uint32_t P2PPM0AR2;       /*!< DCMIPP Pipe2 pixel packer Memory0 address register 2               Address offset: 0xDC8 */
  __IO uint32_t P2PPM0PR;        /*!< DCMIPP Pipe2 pixel packer Memory0 pitch register                   Address offset: 0xDCC */
  __IO uint32_t P2STM0AR;        /*!< DCMIPP Pipe2 status Memory0 address register                       Address offset: 0xDD0 */
       uint32_t RESERVED55[8];   /*!< Reserved                                                           Address offset: 0xDD4-0xDF0 */
  __IO uint32_t P2IER;           /*!< DCMIPP Pipe2 interrupt enable register                             Address offset: 0xDF4 */
  __IO uint32_t P2SR;            /*!< DCMIPP Pipe2 status register                                       Address offset: 0xDF8 */
  __IO uint32_t P2FCR;           /*!< DCMIPP Pipe2 interrupt clear register                              Address offset: 0xDFC */
       uint32_t RESERVED56;      /*!< Reserved                                                           Address offset: 0xE00 */
  __IO uint32_t P2CFSCR;         /*!< DCMIPP Pipe2 current flow selection configuration register         Address offset: 0xE04 */
       uint32_t RESERVED57[62];  /*!< Reserved                                                           Address offset: 0xE08-0xEFC */
  __IO uint32_t P2CFCTCR;        /*!< DCMIPP Pipe2 current flow control configuration register           Address offset: 0xF00 */
  __IO uint32_t P2CCRSTR;        /*!< DCMIPP Pipe2 current crop window start register                    Address offset: 0xF04 */
  __IO uint32_t P2CCRSZR;        /*!< DCMIPP Pipe2 current crop window size register                     Address offset: 0xF08 */
  __IO uint32_t P2CDCCR;         /*!< DCMIPP Pipe2 current decimation register                           Address offset: 0xF0C */
  __IO uint32_t P2CDSCR;         /*!< DCMIPP Pipe2 current downsize configuration register               Address offset: 0xF10 */
  __IO uint32_t P2CDSRTIOR;      /*!< DCMIPP Pipe2 current downsize ratio register                       Address offset: 0xF14 */
  __IO uint32_t P2CDSSZR;        /*!< DCMIPP Pipe2 current downsize destination size register            Address offset: 0xF18 */
  __IO uint32_t RESERVED59[2];   /*!< Reserved                                                           Address offset: 0xF1C-0xF20 */
  __IO uint32_t P2CRIxCR1;       /*!< Pipe2 current ROIx configuration register 1                        Address offset: 0xF24 + (x - 1) * 0x8, (x = 1 to 8)*/
  __IO uint32_t P2CRIxCR2;       /*!< Pipe2 current ROIx configuration register 2                        Address offset: 0xF28 + (x - 1) * 0x8, (x = 1 to 8)*/
       uint32_t RESERVED60[37];  /*!< Reserved                                                           Address offset: 0xF64-0xFBC */
  __IO uint32_t P2CPPCR;         /*!< DCMIPP Pipe2 current pixel packer configuration register           Address offset: 0xFC0 */
  __IO uint32_t P2CPPM0AR1;      /*!< DCMIPP Pipe2 current pixel packer Memory0 address register 1       Address offset: 0xFC4 */
  __IO uint32_t P2CPPM0AR2;      /*!< DCMIPP Pipe2 current pixel packer Memory0 address register 2       Address offset: 0xFC8 */
  __IO uint32_t P2CPPM0PR;       /*!< DCMIPP Pipe2 current pixel packer Memory0 pitch register           Address offset: 0xFCC */
       uint32_t RESERVED61[7];   /*!< Reserved                                                           Address offset: 0xFD0-0xFE8 */
  __IO uint32_t HWCFGR2;         /*!< DCMIPP hardware configuration register 2                           Address offset: 0xFEC */
  __IO uint32_t HWCFGR1;         /*!< DCMIPP hardware configuration register 1                           Address offset: 0xFF0 */
  __IO uint32_t VERR;            /*!< DCMIPP version register                                            Address offset: 0xFF4 */
  __IO uint32_t IPIDR;           /*!< DCMIPP identification register                                     Address offset: 0xFF8 */
  __IO uint32_t SIDR;            /*!< DCMIPP size identification register                                Address offset: 0xFFC */
} DCMIPP_TypeDef;

/**
  * @ brief Delay Block
  */
typedef struct
{
  __IO uint32_t CR;   /*!< Delay Block Control Register,       Address offset: 0x00 */
  __IO uint32_t CFGR; /*!< Delay Block Configuration Register, Address offset: 0x04 */
} DLYB_TypeDef;

/**
  * @brief DMA Controller
  */

typedef struct
{
  __IO uint32_t SECCFGR;      /*!< DMA secure configuration register,               Address offset: 0x00  */
  __IO uint32_t PRIVCFGR;     /*!< DMA privileged configuration register,           Address offset: 0x04 */
  __IO uint32_t RCFGLOCKR;    /*!< DMA configuration lock register,                 Address offset: 0x08 */
  __IO uint32_t MISR;         /*!< DMA non secure masked interrupt status register, Address offset: 0x0C  */
  __IO uint32_t SMISR;        /*!< DMA secure masked interrupt status register,     Address offset: 0x10  */
} DMA_TypeDef;

typedef struct
{
  __IO uint32_t CLBAR;         /*!< DMA channel x linked-list base address register, Address offset: 0x50 + (x * 0x80) */
  __IO uint32_t CCIDCFGR;      /*!< DMA channel x CID register,                      Address offset: 0x54 + (x * 0x80) */
       uint32_t RESERVED1[1];  /*!< Reserved 1,                                      Address offset: 0x58 + (x * 0x80) */
  __IO uint32_t CFCR;          /*!< DMA channel x flag clear register,               Address offset: 0x5C + (x * 0x80) */
  __IO uint32_t CSR;           /*!< DMA channel x flag status register,              Address offset: 0x60 + (x * 0x80) */
  __IO uint32_t CCR;           /*!< DMA channel x control register,                  Address offset: 0x64 + (x * 0x80) */
       uint32_t RESERVED2[10]; /*!< Reserved 2,                                      Address offset: 0x68 -- 0x8C + (x * 0x80) */
  __IO uint32_t CTR1;          /*!< DMA channel x transfer register 1,               Address offset: 0x90 + (x * 0x80) */
  __IO uint32_t CTR2;          /*!< DMA channel x transfer register 2,               Address offset: 0x94 + (x * 0x80) */
  __IO uint32_t CBR1;          /*!< DMA channel x block register 1,                  Address offset: 0x98 + (x * 0x80) */
  __IO uint32_t CSAR;          /*!< DMA channel x source address register,           Address offset: 0x9C + (x * 0x80) */
  __IO uint32_t CDAR;          /*!< DMA channel x destination address register,      Address offset: 0xA0 + (x * 0x80) */
  __IO uint32_t CTR3;          /*!< DMA channel x transfer register 3,               Address offset: 0xA4 + (x * 0x80) */
  __IO uint32_t CBR2;          /*!< DMA channel x block register 2,                  Address offset: 0xA8 + (x * 0x80) */
       uint32_t RESERVED3[8];  /*!< Reserved 3,                                      Address offset: 0xAC -- 0xC8 + (x * 0x80) */
  __IO uint32_t CLLR;          /*!< DMA channel x linked-list address register,      Address offset: 0xCC + (x * 0x80) */
} DMA_Channel_TypeDef;

/**
  * @brief DMA2D Controller
  */
typedef struct
{
  __IO uint32_t CR;            /*!< DMA2D Control Register,                         Address offset: 0x00 */
  __IO uint32_t ISR;           /*!< DMA2D Interrupt Status Register,                Address offset: 0x04 */
  __IO uint32_t IFCR;          /*!< DMA2D Interrupt Flag Clear Register,            Address offset: 0x08 */
  __IO uint32_t FGMAR;         /*!< DMA2D Foreground Memory Address Register,       Address offset: 0x0C */
  __IO uint32_t FGOR;          /*!< DMA2D Foreground Offset Register,               Address offset: 0x10 */
  __IO uint32_t BGMAR;         /*!< DMA2D Background Memory Address Register,       Address offset: 0x14 */
  __IO uint32_t BGOR;          /*!< DMA2D Background Offset Register,               Address offset: 0x18 */
  __IO uint32_t FGPFCCR;       /*!< DMA2D Foreground PFC Control Register,          Address offset: 0x1C */
  __IO uint32_t FGCOLR;        /*!< DMA2D Foreground Color Register,                Address offset: 0x20 */
  __IO uint32_t BGPFCCR;       /*!< DMA2D Background PFC Control Register,          Address offset: 0x24 */
  __IO uint32_t BGCOLR;        /*!< DMA2D Background Color Register,                Address offset: 0x28 */
  __IO uint32_t FGCMAR;        /*!< DMA2D Foreground CLUT Memory Address Register,  Address offset: 0x2C */
  __IO uint32_t BGCMAR;        /*!< DMA2D Background CLUT Memory Address Register,  Address offset: 0x30 */
  __IO uint32_t OPFCCR;        /*!< DMA2D Output PFC Control Register,              Address offset: 0x34 */
  __IO uint32_t OCOLR;         /*!< DMA2D Output Color Register,                    Address offset: 0x38 */
  __IO uint32_t OMAR;          /*!< DMA2D Output Memory Address Register,           Address offset: 0x3C */
  __IO uint32_t OOR;           /*!< DMA2D Output Offset Register,                   Address offset: 0x40 */
  __IO uint32_t NLR;           /*!< DMA2D Number of Line Register,                  Address offset: 0x44 */
  __IO uint32_t LWR;           /*!< DMA2D Line Watermark Register,                  Address offset: 0x48 */
  __IO uint32_t AMTCR;         /*!< DMA2D AHB Master Timer Configuration Register,  Address offset: 0x4C */
  uint32_t      RESERVED[236]; /*!< Reserved,                                 Address offset: 0x50-0x3FF */
  __IO uint32_t FGCLUT[256];   /*!< DMA2D Foreground CLUT,                    Address offset:0x400-0x7FF */
  __IO uint32_t BGCLUT[256];   /*!< DMA2D Background CLUT,                    Address offset:0x800-0xBFF */
} DMA2D_TypeDef;

/**
  * @brief DTS Controller
  */
typedef struct
{
  uint32_t      RESERVED1[4];    /*!< Reserved,                                 Address offset: 0x00-0x0F */
  __IO uint32_t PVTREG_LOCKR;    /*!< DTS PVT Register Lock Register,           Address offset: 0x10 */
  __IO uint32_t PVTLOCK_SR;      /*!< DTS PVT Lock Status Register,             Address offset: 0x14 */
  uint32_t      RESERVED2[2];    /*!< Reserved,                                 Address offset: 0x18-0x1F */
  __IO uint32_t PVTTMR_CR;       /*!< DTS PVT Timer Control Register,           Address offset: 0x20 */
  __IO uint32_t PVTTMR_SR;       /*!< DTS PVT Timer Status Register,            Address offset: 0x24 */
  uint32_t      RESERVED3[6];    /*!< Reserved,                                 Address offset: 0x28-0x3F */
  __IO uint32_t PVT_IER;         /*!< DTS PVT IRQ Enable Register,              Address offset: 0x40 */
  uint32_t      RESERVED4[3];    /*!< Reserved,                                 Address offset: 0x44-0x4F */
  __IO uint32_t PVTIRQTRMASKR;   /*!< DTS PVT IRQ Timer Mask Register,          Address offset: 0x50 */
  __IO uint32_t TS_MR;           /*!< DTS PVT IRQ TS Mask Register,             Address offset: 0x54 */
  uint32_t      RESERVED5[2];    /*!< Reserved,                                 Address offset: 0x58-0x5F */
  __IO uint32_t PVTTR_SR;        /*!< DTS PVT IRQ Timer Status Register,        Address offset: 0x60 */
  __IO uint32_t TS_ISR;          /*!< DTS PVT IRQ TS Status Register,           Address offset: 0x64 */
  uint32_t      RESERVED6[2];    /*!< Reserved,                                 Address offset: 0x68-0x6F */
  __IO uint32_t PVTTMRRAW_ISR;   /*!< DTS PVT IRQ Timer Raw Status Register,    Address offset: 0x70 */
  __IO uint32_t TSRAW_ISR;       /*!< DTS PVT IRQ TS Raw Status Register,       Address offset: 0x74 */
  uint32_t      RESERVED7[2];    /*!< Reserved,                                 Address offset: 0x78-0x7F */
  __IO uint32_t TSCCLKSYNTHR;    /*!< DTS TSC Clock Synthesizer Register,       Address offset: 0x80 */
  __IO uint32_t TSCSDIFDISABLER; /*!< DTS TSC SDIF Interface Disable Register,  Address offset: 0x84 */
  __IO uint32_t TSCSDIF_SR;      /*!< DTS TSC SDIF Status Register,             Address offset: 0x88 */
  __IO uint32_t TSCSDIF_CR;      /*!< DTS TSC SDIF Register,                    Address offset: 0x8C */
  __IO uint32_t TSCSDIFHALTR;    /*!< DTS TSC SDIF Halt Register,               Address offset: 0x90 */
  __IO uint32_t TSCSDIF_CFGR;    /*!< DTS TSC SDIF Control Register,            Address offset: 0x94 */
  uint32_t      RESERVED8[2];    /*!< Reserved,                                 Address offset: 0x98-0x9F */
  __IO uint32_t TSCSMPL_CR;      /*!< DTS TSC Sample Control Register,          Address offset: 0xA0 */
  __IO uint32_t TSCSDIFSMPLCLRR; /*!< DTS TSC Sample Clear Register,            Address offset: 0xA4 */
  __IO uint32_t TSCSMPLCNTR;     /*!< DTS TSC Sample Count Register,            Address offset: 0xA8 */
} DTS_TypeDef;

/**
  * @brief DTS Sensor Controller
  */
typedef struct
{
  __IO uint32_t TS_IER;          /*!< DTS TSx IRQ Enable Register,              Address offset: 0xC0 + 0x40 * x, (x = 0 to 1) */
  __IO uint32_t TS_ISR;          /*!< DTS TSx IRQ Status Register,              Address offset: 0xC4 + 0x40 * x, (x = 0 to 1) */
  __IO uint32_t TS_ICR;          /*!< DTS TSx IRQ Clear Register,               Address offset: 0xC8 + 0x40 * x, (x = 0 to 1) */
  __IO uint32_t TSIRQTESTR;      /*!< DTS TSx IRQ Test Register,                Address offset: 0xCC + 0x40 * x, (x = 0 to 1) */
  __IO uint32_t TSSDIFRDATAR;    /*!< DTS TSx SDIF RDATA Register,              Address offset: 0xD0 + 0x40 * x, (x = 0 to 1) */
  __IO uint32_t TSSDIFDONER;     /*!< DTS TSx SDIF Done Register,               Address offset: 0xD4 + 0x40 * x, (x = 0 to 1) */
  __IO uint32_t TSSDIFDATAR;     /*!< DTS TSx SDIF Data Register,               Address offset: 0xD8 + 0x40 * x, (x = 0 to 1) */
  uint32_t      RESERVED1[1];    /*!< Reserved,                                 Address offset: 0xDC + 0x40 * x, (x = 0 to 1) */
  __IO uint32_t TSALARMA_CFGR;   /*!< DTS TSx Alarm A Configuration Register,   Address offset: 0xE0 + 0x40 * x, (x = 0 to 1) */
  __IO uint32_t TSALARMB_CFGR;   /*!< DTS TSx Alarm B Configuration Register,   Address offset: 0xE4 + 0x40 * x, (x = 0 to 1) */
  __IO uint32_t TSHLSAMPLER;     /*!< DTS TSx High/Low Sample Register,         Address offset: 0xE8 + 0x40 * x, (x = 0 to 1) */
  __IO uint32_t TSHILORESETR;    /*!< DTS TSx High/Low Reset Register,          Address offset: 0xEC + 0x40 * x, (x = 0 to 1) */
} DTS_SensorTypeDef;

/**
  * @brief Ethernet MAC
  */
typedef struct
{
  __IO uint32_t MACCR;               /*!< Operating mode configuration register,                        Address offset: 0x00 */
  __IO uint32_t MACECR;              /*!< Extended operating mode configuration register,               Address offset: 0x04 */
  __IO uint32_t MACPFR;              /*!< Packet filtering control register             ,               Address offset: 0x08 */
  __IO uint32_t MACWTR;              /*!< Watchdog timeout register,                                    Address offset: 0x0C */
  __IO uint32_t MACHT0R;             /*!< Hash Table 0 register,                                        Address offset: 0x10 */
  __IO uint32_t MACHT1R;             /*!< Hash Table 1 register,                                        Address offset: 0x14 */
  uint32_t      RESERVED1[14];
  __IO uint32_t MACVTCR;             /*!< VLAN tag Control register,                                    Address offset: 0x50 */
  __IO uint32_t MACVTDR;             /*!< VLAN tag data register,                                       Address offset: 0x54 */
  __IO uint32_t MACVHTR;             /*!< VLAN Hash table register,                                     Address offset: 0x58 */
  uint32_t      RESERVED2;
  __IO uint32_t MACVIR;              /*!< VLAN inclusion register,                                      Address offset: 0x60 */
  __IO uint32_t MACIVIR;             /*!< Inner VLAN inclusion register,                                Address offset: 0x64 */
  uint32_t      RESERVED3[2];
  __IO uint32_t MACQ0TXFCR;          /*!< Tx Queue 0 flow control register,                             Address offset: 0x70 */
  uint32_t      RESERVED4[7];
  __IO uint32_t MACRXFCR;            /*!< Rx flow control register,                                     Address offset: 0x90 */
  __IO uint32_t MACRXQCR;            /*!< Rx Queue control register,                                    Address offset: 0x94 */
  uint32_t      RESERVED5[2];
  __IO uint32_t MACRXQC0R;           /*!< Rx queue control 0 register,                                  Address offset: 0xA0 */
  __IO uint32_t MACRXQC1R;           /*!< Rx queue control 1 register,                                  Address offset: 0xA4 */
  __IO uint32_t MACRXQC2R;           /*!< Rx queue control 2 register,                                  Address offset: 0xA8 */
  uint32_t      RESERVED6;
  __IO uint32_t MACISR;              /*!< Interrupt status register,                                    Address offset: 0xB0 */
  __IO uint32_t MACIER;              /*!< Interrupt enable register,                                    Address offset: 0xB4 */
  __IO uint32_t MACRXTXSR;           /*!< Rx Tx status register,                                        Address offset: 0xB8 */
  uint32_t      RESERVED7;
  __IO uint32_t MACPCSR;             /*!< PMT control status register,                                  Address offset: 0xC0 */
  __IO uint32_t MACRWKPFR;           /*!< Remote wakeup packet filter register,                         Address offset: 0xC4 */
  uint32_t      RESERVED8[2];
  __IO uint32_t MACLCSR;             /*!< LPI control and status register,                              Address offset: 0xD0 */
  __IO uint32_t MACLTCR;             /*!< LPI timers control register,                                  Address offset: 0xD4 */
  __IO uint32_t MACLETR;             /*!< LPI entry timer register,                                     Address offset: 0xD8 */
  __IO uint32_t MAC1USTCR;           /*!< One-microsecond-tick counter register,                        Address offset: 0xDC */
  uint32_t      RESERVED9[6];
  __IO uint32_t MACPHYCSR;           /*!< PHYIF control status register,                                Address offset: 0xF8 */
  uint32_t      RESERVED10[5];
  __IO uint32_t MACVR;               /*!< Version register,                                             Address offset: 0x110 */
  __IO uint32_t MACDR;               /*!< Debug register,                                               Address offset: 0x114 */
  uint32_t      RESERVED11;
  __IO uint32_t MACHWF0R;            /*!< HW feature 0 register,                                        Address offset: 0x11C */
  __IO uint32_t MACHWF1R;            /*!< HW feature 1 register,                                        Address offset: 0x120 */
  __IO uint32_t MACHWF2R;            /*!< HW feature 2 register,                                        Address offset: 0x124 */
  __IO uint32_t MACHWF3R;            /*!< HW feature 3 register,                                        Address offset: 0x128 */
  uint32_t      RESERVED12[53];
  __IO uint32_t MACMDIOAR;           /*!< MDIO address register,                                        Address offset: 0x200 */
  __IO uint32_t MACMDIODR;           /*!< MDIO data register,                                           Address offset: 0x204 */
  uint32_t      RESERVED13[2];
  __IO uint32_t MACARPAR;            /*!< ARP address register,                                         Address offset: 0x210 */
  uint32_t      RESERVED14[7];
  __IO uint32_t MACCSRSWCR;          /*!< CSR software control register,                                Address offset: 0x230 */
  __IO uint32_t MACFPECSR;           /*!< FPE control and status register,                              Address offset: 0x234 */
   uint32_t     RESERVED15[2];
  __IO uint32_t MACPRSTIMR;          /*!< MAC presentation time register,                               Address offset: 0x0240 */
  __IO uint32_t MACPRSTIMUR;         /*!< MAC presentation time update register,                        Address offset: 0x0244 */
   uint32_t     RESERVED16[46];
  __IO uint32_t MACA0HR;             /*!< MAC Address 0 high register,                                  Address offset: 0x0300 */
  __IO uint32_t MACA0LR;             /*!< MAC Address 0 low register,                                   Address offset: 0x0304 */
  __IO uint32_t MACA1HR;             /*!< MAC Address 1 high register,                                  Address offset: 0x0308 */
  __IO uint32_t MACA1LR;             /*!< MAC Address 1 low register,                                   Address offset: 0x030C */
  __IO uint32_t MACA2HR;             /*!< MAC Address 2 high register,                                  Address offset: 0x0310 */
  __IO uint32_t MACA2LR;             /*!< MAC Address 2 low register,                                   Address offset: 0x0314 */
  __IO uint32_t MACA3HR;             /*!< MAC Address 3 high register,                                  Address offset: 0x0318 */
  __IO uint32_t MACA3LR;             /*!< MAC Address 3 low register,                                   Address offset: 0x031C */
  uint32_t      RESERVED17[248];
  __IO uint32_t MMCCR;               /*!< MMC control register,                                         Address offset: 0x0700 */
  __IO uint32_t MMCRIR;              /*!< MMC Rx interrupt register,                                    Address offset: 0x0704 */
  __IO uint32_t MMCTIR;              /*!< MMC Tx interrupt register,                                    Address offset: 0x0708 */
  __IO uint32_t MMCRIMR;             /*!< MMC Rx interrupt mask register,                               Address offset: 0x070C */
  __IO uint32_t MMCTIMR;             /*!< MMC Tx interrupt mask register,                               Address offset: 0x0710 */
  uint32_t      RESERVED18[14];
  __IO uint32_t MMCTSCGPR;           /*!< Tx single collision good packets register,                    Address offset: 0x074C */
  __IO uint32_t MMCTMCGPR;           /*!< Tx multiple collision good packets register,                  Address offset: 0x0750 */
  uint32_t      RESERVED19[5];
  __IO uint32_t MMCTPCGR;            /*!< Tx packet count good register,                                Address offset: 0x0768 */
  uint32_t      RESERVED20[10];
  __IO uint32_t MMCRCRCEPR;          /*!< Rx CRC error packets register,                                Address offset: 0x0794 */
  __IO uint32_t MMCRAEPR;            /*!< Rx alignment error packets register,                          Address offset: 0x0798 */
  uint32_t      RESERVED21[10];
  __IO uint32_t MMCRUPGR;            /*!< Rx unicast packets good register,                             Address offset: 0x07C4 */
  uint32_t      RESERVED22[9];
  __IO uint32_t MMCTLPIMSTR;         /*!< Tx LPI microsecond timer register,                            Address offset: 0x07EC */
  __IO uint32_t MMCTLPITCR;          /*!< Tx LPI transition counter register,                           Address offset: 0x07F0 */
  __IO uint32_t MMCRLPIMSTR;         /*!< Rx LPI microsecond counter register,                          Address offset: 0x07F4 */
  __IO uint32_t MMCRLPITCR;          /*!< Rx LPI transition counter register,                           Address offset: 0x07F8 */
  uint32_t      RESERVED23[41];
  __IO uint32_t MMCFPETISR;          /*!< MMC FPE Tx interrupt status register,                         Address offset: 0x08A0 */
  __IO uint32_t MMCFPETIMR;          /*!< MMC FPE Tx interrupt mask register,                           Address offset: 0x08A4 */
  __IO uint32_t MMCFPETFCR;          /*!< MMC FPE Tx fragment counter register,       -                 Address offset: 0x08A8 */
  __IO uint32_t MMCTHRCR;            /*!< MMC Tx hold request counter register,                         Address offset: 0x08AC */
  uint32_t      RESERVED24[4];
  __IO uint32_t MMCFPERISR;          /*!< MMC FPE Rx interrupt status register,                         Address offset: 0x08C0 */
  __IO uint32_t MMCFPERIMR;          /*!< MMC FPE Rx interrupt mask register,                           Address offset: 0x08C4 */
  __IO uint32_t MMCRPAER;            /*!< MMC Rx packet assembly error register,                        Address offset: 0x08C8 */
  __IO uint32_t MMCRPSMDER;          /*!< MMC Rx packet SMD error register,                             Address offset: 0x08CC */
  __IO uint32_t MMCRPAOKR;           /*!< MMC Rx packet assembly OK register,                           Address offset: 0x08D0 */
  __IO uint32_t MMCFPERFCR;          /*!< MMC Rx FPE fragments counter register,                        Address offset: 0x08D4 */
  uint32_t      RESERVED25[10];
  __IO uint32_t MACL3L4C0R;          /*!< L3 and L4 control 0 register,                                 Address offset: 0x0900 */
  __IO uint32_t MACL4A0R;            /*!< Layer4 Address filter 0 register,                             Address offset: 0x0904 */
  uint32_t      RESERVED26[2];
  __IO uint32_t MACL3A0R0R;           /*!< Layer3 Address 0 filter 0 register,                           Address offset: 0x0910 */
  __IO uint32_t MACL3A1R0R;           /*!< Layer3 Address 1 filter 0 register,                           Address offset: 0x0914 */
  __IO uint32_t MACL3A2R0R;           /*!< Layer3 Address 2 filter 0 register,                           Address offset: 0x0918 */
  __IO uint32_t MACL3A3R0R;           /*!< Layer3 Address 3 filter 0 register,                           Address offset: 0x091C */
  uint32_t      RESERVED27[4];
  __IO uint32_t MACL3L4C1R;          /*!< L3 and L4 control 1 register,                                 Address offset: 0x0930 */
  __IO uint32_t MACL4A1R;            /*!< Layer 4 address filter 1 register,                            Address offset: 0x0934 */
  uint32_t      RESERVED28[2];
  __IO uint32_t MACL3A01R;           /*!< Layer3 address 0 filter 1 Register,                           Address offset: 0x0940 */
  __IO uint32_t MACL3A11R;           /*!< Layer3 address 1 filter 1 register,                           Address offset: 0x0944 */
  __IO uint32_t MACL3A21R;           /*!< Layer3 address 2 filter 1 Register,                           Address offset: 0x0948 */
  __IO uint32_t MACL3A31R;           /*!< Layer3 address 3 filter 1 register,                           Address offset: 0x094C */
  uint32_t      RESERVED29[72];
  __IO uint32_t MACIACR;             /*!< MAC Indirect Access Control register,                         Address offset: 0x0A70 */
  __IO uint32_t MACTMRQR;            /*!< MAC type-based Rx Queue mapping register,                     Address offset: 0x0A74 */
  uint32_t      RESERVED30[34];
  __IO uint32_t MACTSCR;             /*!< Timestamp control Register,                                   Address offset: 0x0B00 */
  __IO uint32_t MACSSIR;             /*!< Subsecond increment register,                                 Address offset: 0x0B04 */
  __IO uint32_t MACSTSR;             /*!< System time seconds register,                                 Address offset: 0x0B08 */
  __IO uint32_t MACSTNR;             /*!< System time nanoseconds register,                             Address offset: 0x0B0C */
  __IO uint32_t MACSTSUR;            /*!< System time seconds update register,                          Address offset: 0x0B10 */
  __IO uint32_t MACSTNUR;            /*!< System time nanoseconds update register,                      Address offset: 0x0B14 */
  __IO uint32_t MACTSAR;             /*!< Timestamp addend register,                                    Address offset: 0x0B18 */
  uint32_t      RESERVED31;
  __IO uint32_t MACTSSR;             /*!< Timestamp status register,                                    Address offset: 0x0B20 */
  uint32_t      RESERVED32[3];
  __IO uint32_t MACTXTSSNR;          /*!< Tx timestamp status nanoseconds register,                     Address offset: 0x0B30 */
  __IO uint32_t MACTXTSSSR;          /*!< Tx timestamp status seconds register,                         Address offset: 0x0B34 */
  uint32_t      RESERVED33[2];
  __IO uint32_t MACACR;              /*!< Auxiliary control register,                                   Address offset: 0x0B40 */
  uint32_t      RESERVED34;
  __IO uint32_t MACATSNR;            /*!< Auxiliary timestamp nanoseconds register,                     Address offset: 0x0B48 */
  __IO uint32_t MACATSSR;            /*!< Auxiliary timestamp seconds register,                         Address offset: 0x0B4C */
  __IO uint32_t MACTSIACR;           /*!< Timestamp Ingress asymmetric correction register,             Address offset: 0x0B50 */
  __IO uint32_t MACTSEACR;           /*!< Timestamp Egress asymmetric correction register,              Address offset: 0x0B54 */
  __IO uint32_t MACTSICNR;           /*!< Timestamp Ingress correction nanosecond register,             Address offset: 0x0B58 */
  __IO uint32_t MACTSECNR;           /*!< Timestamp Egress correction nanosecond register,              Address offset: 0x0B5C */
  uint32_t      RESERVED35[2];
  __IO uint32_t MACTSILR;            /*!< Timestamp Ingress Latency register,                           Address offset: 0x0B68 */
  __IO uint32_t MACTSELR;            /*!< Timestamp Egress Latency register,                            Address offset: 0x0B6C */
  __IO uint32_t MACPPSCR;            /*!< PPS control register,                                         Address offset: 0x0B70 */
  uint32_t      RESERVED36[3];
  __IO uint32_t MACPPSTTS0R;         /*!< PPS 0 target time seconds register,                           Address offset: 0x0B80 */
  __IO uint32_t MACPPSTTN0R;         /*!< PPS 0 target time nanoseconds register,                       Address offset: 0x0B84 */
  __IO uint32_t MACPPSI0R;           /*!< PPS 0 interval register,                                      Address offset: 0x0B88 */
  __IO uint32_t MACPPSW0R;           /*!< PPS 0 width register,                                         Address offset: 0x0B8C */
  __IO uint32_t MACPPSTTS1R;         /*!< PPS 1 target time seconds register,                           Address offset: 0x0B90 */
  __IO uint32_t MACPPSTTN1R;         /*!< PPS 1 target time nanoseconds register,                       Address offset: 0x0B94 */
  __IO uint32_t MACPPSI1R;           /*!< PPS 1 interval register,                                      Address offset: 0x0B98 */
  __IO uint32_t MACPPSW1R;           /*!< PPS 1 width register,                                         Address offset: 0x0B9C */
  uint32_t      RESERVED37[8];
  __IO uint32_t MACPOCR;             /*!< PTP Offload control register,                                 Address offset: 0x0BC0 */
  __IO uint32_t MACSPI0R;            /*!< PTP Source Port Identity 0 Register,                          Address offset: 0x0BC4 */
  __IO uint32_t MACSPI1R;            /*!< PTP Source port identity 1 register,                          Address offset: 0x0BC8 */
  __IO uint32_t MACSPI2R;            /*!< PTP Source port identity 2 register,                          Address offset: 0x0BCC */
  __IO uint32_t MACLMIR;             /*!< Log message interval register,                                Address offset: 0x0BD0 */
  uint32_t      RESERVED38[11];
  __IO uint32_t MTLOMR;              /*!< Operating mode Register,                                      Address offset: 0x0C00 */
  uint32_t      RESERVED39[7];
  __IO uint32_t MTLISR;              /*!< Interrupt status Register,                                    Address offset: 0x0C20 */
  uint32_t      RESERVED40[3];
  __IO uint32_t MTLRXQDMAMR;         /*!< Rx Queue and DMA Channel Mapping Register,                    Address offset: 0x0C30 */
  uint32_t      RESERVED41[3];
  __IO uint32_t MTLTBSCR;            /*!< TBS control register,                                         Address offset: 0x0C40 */
  uint32_t      RESERVED42[3];
  __IO uint32_t MTLESTCR;            /*!< EST Control Register,                                         Address offset: 0x0C50 */
  __IO uint32_t MTLESTECR;           /*!< EST Extended Control Register,                                Address offset: 0x0C54 */
  __IO uint32_t MTLESTSR;            /*!< EST Status Register,                                          Address offset: 0x0C58 */
  uint32_t      RESERVED43;
  __IO uint32_t MTLESTSCHER;         /*!< EST Schedule Error Register,                                  Address offset: 0x0C60 */
  __IO uint32_t MTLESTFSER;          /*!< EST Frame size Error Register,                                Address offset: 0x0C64 */
  __IO uint32_t MTLESTFSCR;          /*!< EST Frame size Capture Register,                              Address offset: 0x0C68 */
  uint32_t      RESERVED44;
  __IO uint32_t MTLESTIER;           /*!< EST Interrupt Enable Register,                                Address offset: 0x0C70 */
  uint32_t      RESERVED45[3];
  __IO uint32_t MTLESTGCLCR;         /*!< EST Gate Control List Register,                               Address offset: 0x0C80 */
  __IO uint32_t MTLESTGCLDR;         /*!< EST Gate Control List Data Register,                          Address offset: 0x0C84 */
  uint32_t      RESERVED46[2];
  __IO uint32_t MTLFPECSR;           /*!< FPE Frame Preemption Control Status Register,                 Address offset: 0x0C90 */
  __IO uint32_t MTLFPEAR;            /*!< FPE Frame Preemption Advance Register,                        Address offset: 0x0C94 */
  uint32_t      RESERVED47[26];
  struct {
  __IO uint32_t MTLTXQOMR;           /*!< Tx queue x operating mode Register,                           Address offset: 0x0D00 */
  __IO uint32_t MTLTXQUR;            /*!< Tx queue x underflow register,                                Address offset: 0x0D04 */
  __IO uint32_t MTLTXQDR;            /*!< Tx queue x debug register,                                    Address offset: 0x0D08 */
  uint32_t      RESERVED48[1];
  __IO uint32_t MTLTXQ1ECR;           /*!< Tx queue 1 ETS control Register,                              Address offset: 0x0D50 */
  __IO uint32_t MTLTXQESR;           /*!< Tx queue x ETS status Register,                               Address offset: 0x0D14 */
  __IO uint32_t MTLTXQQWR;           /*!< Tx queue x quantum weight register,                           Address offset: 0x0D18 */
  __IO uint32_t MTLTXQ1SSCR;          /*!< Tx queue 1 send slope credit Register,                        Address offset: 0x0D5C */
  __IO uint32_t MTLTXQ1HCR;           /*!< Tx Queue 1 hiCredit register,                                 Address offset: 0x0D60 */
  __IO uint32_t MTLTXQ1LCR;           /*!< Tx queue 1 loCredit register,                                 Address offset: 0x0D64 */
  uint32_t      RESERVED49[1];
  __IO uint32_t MTLQICSR;           /*!< Queue 0 interrupt control status Register,                    Address offset: 0x0D2C */
  __IO uint32_t MTLRXQOMR;          /*!< Rx queue x operating mode register,                           Address offset: 0x0D30 */
  __IO uint32_t MTLRXQMPOCR;        /*!< Rx queue x missed packet and overflow counter register,       Address offset: 0x0D34 */
  __IO uint32_t MTLRXQDR;           /*!< Rx queue x debug register,                                    Address offset: 0x0D38 */
  __IO uint32_t MTLRXQCR;           /*!< Rx queue x control register,                                  Address offset: 0x0D3C */
  } MTL_QUEUE[2];
  uint32_t      RESERVED52[160];
  __IO uint32_t DMAMR;               /*!< DMA mode register,                                            Address offset: 0x1000 */
  __IO uint32_t DMASBMR;             /*!< System bus mode register,                                     Address offset: 0x1004 */
  __IO uint32_t DMAISR;              /*!< Interrupt status register,                                    Address offset: 0x1008 */
  __IO uint32_t DMADSR;              /*!< Debug status register,                                        Address offset: 0x100C */
  uint32_t      RESERVED53[4];
  __IO uint32_t DMAA4TXACR;          /*!< AXI4 transmit channel ACE control register,                   Address offset: 0x1020 */
  __IO uint32_t DMAA4RXACR;          /*!< AXI4 receive channel ACE control register,                    Address offset: 0x1024 */
  __IO uint32_t DMAA4DACR;           /*!< AXI4 descriptor ACE control register,                         Address offset: 0x1028 */
  uint32_t      RESERVED54[5];
  __IO uint32_t DMALPIEI;            /*!< AXI4 LPI Entry Interval register,                             Address offset: 0x1040 */
  uint32_t      RESERVED55[3];
  __IO uint32_t DMATBSCTRL0R;        /*!< DMA TBS control register 0,                                   Address offset: 0x1050 */
  uint32_t      RESERVED56[37];
  struct {
  uint32_t      RESERVED57[6];
  __IO uint32_t DMACCR;             /*!< Channel x control register,                                   Address offset: 0x1100 */
  __IO uint32_t DMACTXCR;           /*!< Channel x transmit control register,                          Address offset: 0x1104 */
  __IO uint32_t DMACRXCR;           /*!< Channel x receive control register,                           Address offset: 0x1108 */
  uint32_t      RESERVED58[2];
  __IO uint32_t DMACTXDLAR;         /*!< Channel x Tx descriptor list address register,                Address offset: 0x1114 */
  uint32_t      RESERVED59;
  __IO uint32_t DMACRXDLAR;         /*!< Channel x Rx descriptor list address register,                Address offset: 0x111C */
  __IO uint32_t DMACTXDTPR;         /*!< Channel x Tx descriptor tail pointer register,                Address offset: 0x1120 */
  uint32_t      RESERVED60;
  __IO uint32_t DMACRXDTPR;         /*!< Channel x Rx descriptor tail pointer register,                Address offset: 0x1128 */
  __IO uint32_t DMACTXRLR;          /*!< Channel x Tx descriptor ring length register,                 Address offset: 0x112C */
  __IO uint32_t DMACRXRLR;          /*!< Channel x Rx descriptor ring length register,                 Address offset: 0x1130 */
  __IO uint32_t DMACIER;            /*!< Channel x interrupt enable register,                          Address offset: 0x1134 */
  __IO uint32_t DMACRXIWTR;         /*!< Channel x Rx interrupt watchdog timer register,               Address offset: 0x1138 */
  __IO uint32_t DMACSFCSR;          /*!< Channel x slot function control status register,              Address offset: 0x113C */
  uint32_t      RESERVED61;
  __IO uint32_t DMACCATXDR;         /*!< Channel x current application transmit descriptor register,   Address offset: 0x1144 */
  uint32_t      RESERVED62;
  __IO uint32_t DMACCARXDR;         /*!< Channel x current application receive descriptor register,    Address offset: 0x114C */
  uint32_t      RESERVED63;
  __IO uint32_t DMACCATXBR;         /*!< Channel x current application transmit buffer register,       Address offset: 0x1154 */
  uint32_t      RESERVED64;
  __IO uint32_t DMACCARXBR;         /*!< Channel x current application receive buffer register,        Address offset: 0x115C */
  __IO uint32_t DMACSR;             /*!< Channel x status register,                                    Address offset: 0x1160 */
  __IO uint32_t DMACMFCR;            /*!< Channel x missed frame count register,                        Address offset: 0x1164 */
  } DMA_CH[2];
}ETH_TypeDef;

/**
  * @brief External Interrupt/Event Controller
  */
typedef struct
{
  __IO uint32_t RTSR1;          /*!< EXTI Rising Trigger Selection Register 1,        Address offset:   0x00 */
  __IO uint32_t FTSR1;          /*!< EXTI Falling Trigger Selection Register 1,       Address offset:   0x04 */
  __IO uint32_t SWIER1;         /*!< EXTI Software Interrupt event Register 1,        Address offset:   0x08 */
  __IO uint32_t RPR1;           /*!< EXTI Rising Pending Register 1,                  Address offset:   0x0C */
  __IO uint32_t FPR1;           /*!< EXTI Falling Pending Register 1,                 Address offset:   0x10 */
  __IO uint32_t SECCFGR1;       /*!< EXTI Security Configuration Register 1,          Address offset:   0x14 */
  __IO uint32_t PRIVCFGR1;      /*!< EXTI Privilege Configuration Register 1,         Address offset:   0x18 */
       uint32_t RESERVED1;      /*!< Reserved 1,                                      Address offset:   0x1C */
  __IO uint32_t RTSR2;          /*!< EXTI Rising Trigger Selection Register 2,        Address offset:   0x20 */
  __IO uint32_t FTSR2;          /*!< EXTI Falling Trigger Selection Register 2,       Address offset:   0x24 */
  __IO uint32_t SWIER2;         /*!< EXTI Software Interrupt event Register 2,        Address offset:   0x28 */
  __IO uint32_t RPR2;           /*!< EXTI Rising Pending Register 2,                  Address offset:   0x2C */
  __IO uint32_t FPR2;           /*!< EXTI Falling Pending Register 2,                 Address offset:   0x30 */
  __IO uint32_t SECCFGR2;       /*!< EXTI Security Configuration Register 2,          Address offset:   0x34 */
  __IO uint32_t PRIVCFGR2;      /*!< EXTI Privilege Configuration Register 2,         Address offset:   0x38 */
       uint32_t RESERVED2;      /*!< Reserved 2,                                      Address offset:   0x3C */
  __IO uint32_t RTSR3;          /*!< EXTI Rising Trigger Selection Register 3,        Address offset:   0x40 */
  __IO uint32_t FTSR3;          /*!< EXTI Falling Trigger Selection Register 3,       Address offset:   0x44 */
  __IO uint32_t SWIER3;         /*!< EXTI Software Interrupt event Register 3,        Address offset:   0x48 */
  __IO uint32_t RPR3;           /*!< EXTI Rising Pending Register 3,                  Address offset:   0x4C */
  __IO uint32_t FPR3;           /*!< EXTI Falling Pending Register 3,                 Address offset:   0x50 */
  __IO uint32_t SECCFGR3;       /*!< EXTI Security Configuration Register 3,          Address offset:   0x54 */
  __IO uint32_t PRIVCFGR3;      /*!< EXTI Privilege Configuration Register 3,         Address offset:   0x58 */
       uint32_t RESERVED3;      /*!< Reserved 3,                                      Address offset:   0x5C */
  __IO uint32_t EXTICR[4];      /*!< EXIT External Interrupt Configuration Register,            0x60 -- 0x6C */
  __IO uint32_t LOCKR;          /*!< EXTI Lock Register,                              Address offset:   0x70 */
       uint32_t RESERVED4[3];   /*!< Reserved 4,                                                0x74 -- 0x7C */
  __IO uint32_t IMR1;           /*!< EXTI Interrupt Mask Register 1,                  Address offset:   0x80 */
  __IO uint32_t EMR1;           /*!< EXTI Event Mask Register 1,                      Address offset:   0x84 */
       uint32_t RESERVED5[2];   /*!< Reserved 5,                                                0x88 -- 0x8C */
  __IO uint32_t IMR2;           /*!< EXTI Interrupt Mask Register 2,                  Address offset:   0x90 */
  __IO uint32_t EMR2;           /*!< EXTI Event Mask Register 2,                      Address offset:   0x94 */
       uint32_t RESERVED6[2];   /*!< Reserved 6,                                                0x98 -- 0x9C */
  __IO uint32_t IMR3;           /*!< EXTI Interrupt Mask Register 3,                  Address offset:   0xA0 */
  __IO uint32_t EMR3;           /*!< EXTI Event Mask Register 3,                      Address offset:   0xA4 */
} EXTI_TypeDef;

/**
 * @brief FD Controller Area Network
 */

typedef struct
{
 __IO uint32_t CREL;           /*!< FDCAN Core Release register,                                     Address offset: 0x000 */
 __IO uint32_t ENDN;           /*!< FDCAN Endian register,                                           Address offset: 0x004 */
 __IO uint32_t RESERVED1;      /*!< Reserved,                                                                        0x008 */
 __IO uint32_t DBTP;           /*!< FDCAN Data Bit Timing & Prescaler register,                      Address offset: 0x00C */
 __IO uint32_t TEST;           /*!< FDCAN Test register,                                             Address offset: 0x010 */
 __IO uint32_t RWD;            /*!< FDCAN RAM Watchdog register,                                     Address offset: 0x014 */
 __IO uint32_t CCCR;           /*!< FDCAN CC Control register,                                       Address offset: 0x018 */
 __IO uint32_t NBTP;           /*!< FDCAN Nominal Bit Timing & Prescaler register,                   Address offset: 0x01C */
 __IO uint32_t TSCC;           /*!< FDCAN Timestamp Counter Configuration register,                  Address offset: 0x020 */
 __IO uint32_t TSCV;           /*!< FDCAN Timestamp Counter Value register,                          Address offset: 0x024 */
 __IO uint32_t TOCC;           /*!< FDCAN Timeout Counter Configuration register,                    Address offset: 0x028 */
 __IO uint32_t TOCV;           /*!< FDCAN Timeout Counter Value register,                            Address offset: 0x02C */
 __IO uint32_t RESERVED2[4];   /*!< Reserved,                                                                0x030 - 0x03C */
 __IO uint32_t ECR;            /*!< FDCAN Error Counter register,                                    Address offset: 0x040 */
 __IO uint32_t PSR;            /*!< FDCAN Protocol Status register,                                  Address offset: 0x044 */
 __IO uint32_t TDCR;           /*!< FDCAN Transmitter Delay Compensation register,                   Address offset: 0x048 */
 __IO uint32_t RESERVED3;      /*!< Reserved,                                                                        0x04C */
 __IO uint32_t IR;             /*!< FDCAN Interrupt register,                                        Address offset: 0x050 */
 __IO uint32_t IE;             /*!< FDCAN Interrupt Enable register,                                 Address offset: 0x054 */
 __IO uint32_t ILS;            /*!< FDCAN Interrupt Line Select register,                            Address offset: 0x058 */
 __IO uint32_t ILE;            /*!< FDCAN Interrupt Line Enable register,                            Address offset: 0x05C */
 __IO uint32_t RESERVED4[8];   /*!< Reserved,                                                                0x060 - 0x07C */
 __IO uint32_t GFC;            /*!< FDCAN Global Filter Configuration register,                      Address offset: 0x080 */
 __IO uint32_t SIDFC;          /*!< FDCAN Standard ID Filter Configuration register,                 Address offset: 0x084 */
 __IO uint32_t XIDFC;          /*!< FDCAN Extended ID Filter Configuration register,                 Address offset: 0x088 */
 __IO uint32_t RESERVED5;      /*!< Reserved,                                                                        0x08C */
 __IO uint32_t XIDAM;          /*!< FDCAN Extended ID AND Mask register,                             Address offset: 0x090 */
 __IO uint32_t HPMS;           /*!< FDCAN High Priority Message Status register,                     Address offset: 0x094 */
 __IO uint32_t NDAT1;          /*!< FDCAN New Data 1 register,                                       Address offset: 0x098 */
 __IO uint32_t NDAT2;          /*!< FDCAN New Data 2 register,                                       Address offset: 0x09C */
 __IO uint32_t RXF0C;          /*!< FDCAN Rx FIFO 0 Configuration register,                          Address offset: 0x0A0 */
 __IO uint32_t RXF0S;          /*!< FDCAN Rx FIFO 0 Status register,                                 Address offset: 0x0A4 */
 __IO uint32_t RXF0A;          /*!< FDCAN Rx FIFO 0 Acknowledge register,                            Address offset: 0x0A8 */
 __IO uint32_t RXBC;           /*!< FDCAN Rx Buffer Configuration register,                          Address offset: 0x0AC */
 __IO uint32_t RXF1C;          /*!< FDCAN Rx FIFO 1 Configuration register,                          Address offset: 0x0B0 */
 __IO uint32_t RXF1S;          /*!< FDCAN Rx FIFO 1 Status register,                                 Address offset: 0x0B4 */
 __IO uint32_t RXF1A;          /*!< FDCAN Rx FIFO 1 Acknowledge register,                            Address offset: 0x0B8 */
 __IO uint32_t RXESC;          /*!< FDCAN Rx Buffer/FIFO Element Size Configuration register,        Address offset: 0x0BC */
 __IO uint32_t TXBC;           /*!< FDCAN Tx Buffer Configuration register,                          Address offset: 0x0C0 */
 __IO uint32_t TXFQS;          /*!< FDCAN Tx FIFO/Queue Status register,                             Address offset: 0x0C4 */
 __IO uint32_t TXESC;          /*!< FDCAN Tx Buffer Element Size Configuration register,             Address offset: 0x0C8 */
 __IO uint32_t TXBRP;          /*!< FDCAN Tx Buffer Request Pending register,                        Address offset: 0x0CC */
 __IO uint32_t TXBAR;          /*!< FDCAN Tx Buffer Add Request register,                            Address offset: 0x0D0 */
 __IO uint32_t TXBCR;          /*!< FDCAN Tx Buffer Cancellation Request register,                   Address offset: 0x0D4 */
 __IO uint32_t TXBTO;          /*!< FDCAN Tx Buffer Transmission Occurred register,                  Address offset: 0x0D8 */
 __IO uint32_t TXBCF;          /*!< FDCAN Tx Buffer Cancellation Finished register,                  Address offset: 0x0DC */
 __IO uint32_t TXBTIE;         /*!< FDCAN Tx Buffer Transmission Interrupt Enable register,          Address offset: 0x0E0 */
 __IO uint32_t TXBCIE;         /*!< FDCAN Tx Buffer Cancellation Finished Interrupt Enable register, Address offset: 0x0E4 */
 __IO uint32_t RESERVED6[2];   /*!< Reserved,                                                                0x0E8 - 0x0EC */
 __IO uint32_t TXEFC;          /*!< FDCAN Tx Event FIFO Configuration register,                      Address offset: 0x0F0 */
 __IO uint32_t TXEFS;          /*!< FDCAN Tx Event FIFO Status register,                             Address offset: 0x0F4 */
 __IO uint32_t TXEFA;          /*!< FDCAN Tx Event FIFO Acknowledge register,                        Address offset: 0x0F8 */
 __IO uint32_t RESERVED7;      /*!< Reserved,                                                                        0x0FC */
} FDCAN_GlobalTypeDef;

/**
  * @brief TTFD Controller Area Network
  */

typedef struct
{
  __IO uint32_t TTTMC;         /*!< TT Trigger Memory Configuration register,        Address offset: 0x100 */
  __IO uint32_t TTRMC;         /*!< TT Reference Message Configuration register,     Address offset: 0x104 */
  __IO uint32_t TTOCF;         /*!< TT Operation Configuration register,             Address offset: 0x108 */
  __IO uint32_t TTMLM;         /*!< TT Matrix Limits register,                       Address offset: 0x10C */
  __IO uint32_t TURCF;         /*!< TUR Configuration register,                      Address offset: 0x110 */
  __IO uint32_t TTOCN;         /*!< TT Operation Control register,                   Address offset: 0x114 */
  __IO uint32_t TTGTP;         /*!< TT Global Time Preset register,                  Address offset: 0x118 */
  __IO uint32_t TTTMK;         /*!< TT Time Mark register,                          Address offset: 0x11C */
  __IO uint32_t TTIR;          /*!< TT Interrupt register,                           Address offset: 0x120 */
  __IO uint32_t TTIE;          /*!< TT Interrupt Enable register,                    Address offset: 0x124 */
  __IO uint32_t TTILS;         /*!< TT Interrupt Line Select register,               Address offset: 0x128 */
  __IO uint32_t TTOST;         /*!< TT Operation Status register,                    Address offset: 0x12C */
  __IO uint32_t TURNA;         /*!< TT TUR Numerator Actual register,                Address offset: 0x130 */
  __IO uint32_t TTLGT;         /*!< TT Local and Global Time register,               Address offset: 0x134 */
  __IO uint32_t TTCTC;         /*!< TT Cycle Time and Count register,                Address offset: 0x138 */
  __IO uint32_t TTCPT;         /*!< TT Capture Time register,                        Address offset: 0x13C */
  __IO uint32_t TTCSM;         /*!< TT Cycle Sync Mark register,                     Address offset: 0x140 */
  __IO uint32_t RESERVED1[111];/*!< Reserved,                                                0x144 - 0x2FC */
  __IO uint32_t TTTS;          /*!< TT Trigger Select register,                      Address offset: 0x300 */
} TTCAN_TypeDef;

/**
  * @brief FD Controller Area Network
  */

typedef struct
{
  __IO uint32_t CREL;          /*!< Clock Calibration Unit Core Release register,    Address offset: 0x00 */
  __IO uint32_t CCFG;          /*!< Calibration Configuration register,              Address offset: 0x04 */
  __IO uint32_t CSTAT;         /*!< Calibration Status register,                     Address offset: 0x08 */
  __IO uint32_t CWD;           /*!< Calibration Watchdog register,                   Address offset: 0x0C */
  __IO uint32_t IR;            /*!< CCU Interrupt register,                          Address offset: 0x10 */
  __IO uint32_t IE;            /*!< CCU Interrupt Enable register,                   Address offset: 0x14 */
} FDCAN_ClockCalibrationUnit_TypeDef;

/**
  * @brief Flexible Memory Controller Bank1
  */
typedef struct
{
  __IO uint32_t BTCR[8];    /*!< NOR/PSRAM chip-select control register(BCR) and chip-select timing register(BTR), Address offset: 0x00-1C */
} FMC_Bank1_TypeDef;

/**
  * @brief Flexible Memory Controller Bank1E
  */
typedef struct
{
  __IO uint32_t BWTR[7];    /*!< NOR/PSRAM write timing registers, Address offset: 0x104-0x11C */
} FMC_Bank1E_TypeDef;

/**
  * @brief Flexible Memory Controller Bank2
  */
typedef struct
{
  __IO uint32_t SDCR[2];         /*!< SDRAM device 1/2 control register                      Address offset: 0x140-0x144 */
  __IO uint32_t SDTR;            /*!< SDRAM timing register                                  Address offset: 0x148 */
       uint32_t RESERVED0;       /*!< Reserved                                               Address offset: 0x14C */
  __IO uint32_t SDCMR;           /*!< SDRAM command mode register                            Address offset: 0x150 */
  __IO uint32_t SDRTR;           /*!< SDRAM refresh timer register                           Address offset: 0x154 */
  __IO uint32_t SDSR;            /*!< SDRAM status register                                  Address offset: 0x158 */
} FMC_Bank5_6_TypeDef;

/**
  * @brief Flexible Memory Controller Bank3
  */
typedef struct
{
  __IO uint32_t PCR;             /*!< NAND Flash Programmable control register               Address offset: 0x080 */
  __IO uint32_t SR;              /*!< FMC status register                                    Address offset: 0x084 */
  __IO uint32_t PMEM;            /*!< Common memory space timing register                    Address offset: 0x088 */
  __IO uint32_t PATT;            /*!< Attribute memory space timing registers                Address offset: 0x08C */
  __IO uint32_t HPR;             /*!< FMC Hamming parity result registers                    Address offset: 0x090 */
  __IO uint32_t HECCR;           /*!< FMC Hamming code ECC result register                   Address offset: 0x094 */
       uint32_t RESERVED0[58];   /*!< Reserved                                               Address offset: 0x098-0x17C */
  __IO uint32_t IER;             /*!< FMC NAND Interrupt Enable Register                     Address offset: 0x180 */
  __IO uint32_t ISR;             /*!< FMC Controller Interrupt Status Register               Address offset: 0x184 */
  __IO uint32_t ICR;             /*!< FMC NAND Controller Interrupt Clear Register           Address offset: 0x188 */
       uint32_t RESERVED1[29];   /*!< Reserved                                               Address offset: 0x18C-0x1FC */
  __IO uint32_t CSQCR;           /*!< FMC NAND Command Sequencer Control Register            Address offset: 0x200 */
  __IO uint32_t CSQCFGR1;        /*!< FMC NAND Command Sequencer Configuration Register 1    Address offset: 0x204 */
  __IO uint32_t CSQCFGR2;        /*!< FMC NAND Command Sequencer Configuration Register 2    Address offset: 0x208 */
  __IO uint32_t CSQCFGR3;        /*!< FMC NAND sequencer configuration register 3            Address offset: 0x20C */
  __IO uint32_t CSQAR1;          /*!< FMC NAND Command Sequencer Address Register 1          Address offset: 0x210 */
  __IO uint32_t CSQAR2;          /*!< FMC NAND Command Sequencer Address Register 2          Address offset: 0x214 */
       uint32_t RESERVED2[2];    /*!< Reserved                                               Address offset: 0x218-0x21C */
  __IO uint32_t CSQIER;          /*!< FMC NAND Command Sequencer Interrupt Enable Register   Address offset: 0x220 */
  __IO uint32_t CSQISR;          /*!< FMC NAND Command Sequencer Interrupt Status Register   Address offset: 0x224 */
  __IO uint32_t CSQICR;          /*!< FMC NAND Command Sequencer Interrupt Clear Register    Address offset: 0x228 */
       uint32_t RESERVED3;       /*!< Reserved                                               Address offset: 0x22C */
  __IO uint32_t CSQEMSR;         /*!< FMC Command Sequencer Error Mapping Status register    Address offset: 0x230 */
       uint32_t RESERVED4[7];    /*!< Reserved                                               Address offset: 0x234-0x24C */
  __IO uint32_t BCHIER;          /*!< FMC BCH Interrupt enable register                      Address offset: 0x250 */
  __IO uint32_t BCHISR;          /*!< FMC BCH Interrupt and Status Register                  Address offset: 0x254 */
  __IO uint32_t BCHICR;          /*!< FMC BCH Interrupt Clear Register                       Address offset: 0x258 */
       uint32_t RESERVED5;       /*!< Reserved                                               Address offset: 0x25C */
  __IO uint32_t BCHPBR1;         /*!< FMC BCH Parity Bits Register 1                         Address offset: 0x260 */
  __IO uint32_t BCHPBR2;         /*!< FMC BCH Parity Bits Register 2                         Address offset: 0x264 */
  __IO uint32_t BCHPBR3;         /*!< FMC BCH Parity Bits Register 3                         Address offset: 0x268 */
  __IO uint32_t BCHPBR4;         /*!< FMC BCH Parity Bits Register 4                         Address offset: 0x26C */
       uint32_t RESERVED6[3];    /*!< Reserved                                               Address offset: 0x270-0x278 */
  __IO uint32_t BCHDSR0;         /*!< FMC BCH Decoder Status register 0                      Address offset: 0x27C */
  __IO uint32_t BCHDSR1;         /*!< FMC BCH Decoder Status register for bank 1             Address offset: 0x280 */
  __IO uint32_t BCHDSR2;         /*!< FMC BCH Decoder Status register for bank 2             Address offset: 0x284 */
  __IO uint32_t BCHDSR3;         /*!< FMC BCH Decoder Status register for bank 3             Address offset: 0x288 */
  __IO uint32_t BCHDSR4;         /*!< FMC BCH Decoder Status register for bank 4             Address offset: 0x28C */
} FMC_Bank3_TypeDef;

/**
  * @brief Flexible Memory Controller Common
  */
typedef struct{
  __IO uint32_t CFGR;            /*!< FMC common configuration register                      Address offset: 0x020 */
} FMC_Common_TypeDef;

/**
  * @brief General Purpose I/O
  */
typedef struct
{
  __IO uint32_t MODER;         /*!< GPIO port mode register,                     Address offset: 0x00      */
  __IO uint32_t OTYPER;        /*!< GPIO port output type register,              Address offset: 0x04      */
  __IO uint32_t OSPEEDR;       /*!< GPIO port output speed register,             Address offset: 0x08      */
  __IO uint32_t PUPDR;         /*!< GPIO port pull-up/pull-down register,        Address offset: 0x0C      */
  __IO uint32_t IDR;           /*!< GPIO port input data register,               Address offset: 0x10      */
  __IO uint32_t ODR;           /*!< GPIO port output data register,              Address offset: 0x14      */
  __IO uint32_t BSRR;          /*!< GPIO port bit set/reset  register,           Address offset: 0x18      */
  __IO uint32_t LCKR;          /*!< GPIO port configuration lock register,       Address offset: 0x1C      */
  __IO uint32_t AFR[2];        /*!< GPIO alternate function registers,           Address offset: 0x20-0x24 */
  __IO uint32_t BRR;           /*!< GPIO bit reset register,                     Address offset: 0x28      */
       uint32_t RESERVED0;     /*!< Reserved,                                    Address offset: 0x2C      */
  __IO uint32_t SECCFGR;       /*!< GPIO port secure configuration register,     Address offset: 0x30      */
  __IO uint32_t PRIVCFGR;      /*!< GPIO port privileged configuration register, Address offset: 0x34      */
  __IO uint32_t RCFGLOCKR;     /*!< GPIO port resource configuration register,   Address offset: 0x38      */
       uint32_t RESERVED1;     /*!< Reserved,                                    Address offset: 0x3C      */
  __IO uint32_t DELAYR[2];     /*!< GPIO port delay register,                    Address offset: 0x40-0x44 */
  __IO uint32_t ADVCFGR[2];    /*!< GPIO port advanced configuration register,   Address offset: 0x48-0x4C */
} GPIO_TypeDef;

/**
  * @brief GFXMMU
  */
typedef struct
{
  __IO uint32_t CR;              /*!< GFXMMU configuration register,                     Address offset: 0x00 */
  __IO uint32_t SR;              /*!< GFXMMU status register,                            Address offset: 0x04 */
  __IO uint32_t FCR;             /*!< GFXMMU flag clear register,                        Address offset: 0x08 */
       uint32_t RESERVED0;       /*!< Reserved0,                                         Address offset: 0x0C */
  __IO uint32_t DVR;             /*!< GFXMMU default value register,                     Address offset: 0x10 */
  __IO uint32_t DAR;             /*!< GFXMMU default alpha register,                     Address offset: 0x14 */
       uint32_t RESERVED1[2];    /*!< Reserved1,                                 Address offset: 0x18 to 0x1C */
  __IO uint32_t B0CR;            /*!< GFXMMU buffer 0 configuration register,            Address offset: 0x20 */
  __IO uint32_t B1CR;            /*!< GFXMMU buffer 1 configuration register,            Address offset: 0x24 */
  __IO uint32_t B2CR;            /*!< GFXMMU buffer 2 configuration register,            Address offset: 0x28 */
  __IO uint32_t B3CR;            /*!< GFXMMU buffer 3 configuration register,            Address offset: 0x2C */
       uint32_t RESERVED2[1012]; /*!< Reserved2,                                 Address offset: 0x30 to 0xFFC */
  __IO uint32_t LUT[2048];       /*!< GFXMMU LUT registers,                      Address offset: 0x1000 to 0x2FFC
                                      For LUT line i, LUTiL = LUT[2*i] and LUTiH = LUT[(2*i)+1] */
} GFXMMU_TypeDef;

/**
  * @brief GFXTIM
  */
typedef struct
{
  __IO uint32_t CR;            /*!< GFXTIM configuration register,                    Address offset: 0x00 */
  __IO uint32_t CGCR;          /*!< GFXTIM clock generator configuration register,    Address offset: 0x04 */
  __IO uint32_t TCR;           /*!< GFXTIM timers configuration register,             Address offset: 0x08 */
  __IO uint32_t TDR;           /*!< GFXTIM timers disable register,                   Address offset: 0x0C */
  __IO uint32_t EVCR;          /*!< GFXTIM events control register,                   Address offset: 0x10 */
  __IO uint32_t EVSR;          /*!< GFXTIM events selection register,                 Address offset: 0x14 */
  uint32_t RESERVED1[2];       /*!< Reserved,                                         Address offset: 0x18-0x1C */
  __IO uint32_t WDGTCR;        /*!< GFXTIM watchdog timer configuration register,     Address offset: 0x20 */
  uint32_t RESERVED2[3];       /*!< Reserved,                                         Address offset: 0x24-0x2C */
  __IO uint32_t ISR;           /*!< GFXTIM interrupt status register,                 Address offset: 0x30 */
  __IO uint32_t ICR;           /*!< GFXTIM interrupt clear register,                  Address offset: 0x34 */
  __IO uint32_t IER;           /*!< GFXTIM interrupt enable register,                 Address offset: 0x38 */
  __IO uint32_t TSR;           /*!< GFXTIM timers status register,                    Address offset: 0x3C */
  __IO uint32_t LCCRR;         /*!< GFXTIM line clock counter reload register,        Address offset: 0x40 */
  __IO uint32_t FCCRR;         /*!< GFXTIM frame clock counter reload register,       Address offset: 0x44 */
  uint32_t RESERVED3[2];       /*!< Reserved,                                         Address offset: 0x48-0x4C */
  __IO uint32_t ATR;           /*!< GFXTIM absolute time register,                    Address offset: 0x50 */
  __IO uint32_t AFCR;          /*!< GFXTIM absolute frame counter register,           Address offset: 0x54 */
  __IO uint32_t ALCR;          /*!< GFXTIM absolute line counter register,            Address offset: 0x58 */
  uint32_t RESERVED4[1];       /*!< Reserved,                                         Address offset: 0x5C */
  __IO uint32_t AFCC1R;        /*!< GFXTIM absolute frame counter compare 1 register, Address offset: 0x60 */
  uint32_t RESERVED5[3];       /*!< Reserved,                                         Address offset: 0x64-0X6C */
  __IO uint32_t ALCC1R;        /*!< GFXTIM absolute line counter compare 1 register,  Address offset: 0x70 */
  __IO uint32_t ALCC2R;        /*!< GFXTIM absolute line counter compare 2 register,  Address offset: 0x74 */
  uint32_t RESERVED6[2];       /*!< Reserved,                                         Address offset: 0x78-0X7C */
  __IO uint32_t RFC1R;         /*!< GFXTIM relative frame counter 1 register,         Address offset: 0x80 */
  __IO uint32_t RFC1RR;        /*!< GFXTIM relative frame counter 1 reload register,  Address offset: 0x84 */
  __IO uint32_t RFC2R;         /*!< GFXTIM relative frame counter 2 register,         Address offset: 0x88 */
  __IO uint32_t RFC2RR;        /*!< GFXTIM relative frame counter 2 reload register,  Address offset: 0x8C */
  uint32_t RESERVED7[4];       /*!< Reserved,                                         Address offset: 0x90-0X9C */
  __IO uint32_t WDGCR;         /*!< GFXTIM watchdog counter register,                 Address offset: 0xA0 */
  __IO uint32_t WDGRR;         /*!< GFXTIM watchdog reload register,                  Address offset: 0xA4 */
  __IO uint32_t WDGPAR;        /*!< GFXTIM watchdog pre-alarm register,               Address offset: 0xA8 */
  uint32_t RESERVED8[209];     /*!< Reserved,                                         Address offset: 0xAC-0X3EC */
  __IO uint32_t HWCFGR;        /*!< GFXTIM HW configuration register,                 Address offset: 0x3F0 */
  __IO uint32_t VERR;          /*!< GFXTIM version register,                          Address offset: 0x3F4 */
  __IO uint32_t IPIDR;         /*!< GFXTIM identification register,                   Address offset: 0x3F8 */
  __IO uint32_t SIDR;          /*!< GFXTIM size identification register,              Address offset: 0x3FC */
} GFXTIM_TypeDef;

/**
  * @brief HASH
  */
typedef struct
{
  __IO uint32_t CR;               /*!< HASH control register,          Address offset: 0x00        */
  __IO uint32_t DIN;              /*!< HASH data input register,       Address offset: 0x04        */
  __IO uint32_t STR;              /*!< HASH start register,            Address offset: 0x08        */
  __IO uint32_t HR[5];            /*!< HASH digest registers,          Address offset: 0x0C-0x1C   */
  __IO uint32_t IMR;              /*!< HASH interrupt enable register, Address offset: 0x20        */
  __IO uint32_t SR;               /*!< HASH status register,           Address offset: 0x24        */
       uint32_t RESERVED[52];     /*!< Reserved, 0x28-0xF4                                         */
  __IO uint32_t CSR[103];         /*!< HASH context swap registers,    Address offset: 0x0F8-0x290 */
} HASH_TypeDef;

/**
  * @brief HASH_DIGEST
  */
typedef struct
{
  __IO uint32_t HR[16];           /*!< HASH digest registers,          Address offset: 0x310-0x34C */
} HASH_DIGEST_TypeDef;

/**
  * @brief Inter-integrated Circuit Interface
  */
typedef struct
{
  __IO uint32_t CR1;         /*!< I2C Control register 1,            Address offset: 0x00 */
  __IO uint32_t CR2;         /*!< I2C Control register 2,            Address offset: 0x04 */
  __IO uint32_t OAR1;        /*!< I2C Own address 1 register,        Address offset: 0x08 */
  __IO uint32_t OAR2;        /*!< I2C Own address 2 register,        Address offset: 0x0C */
  __IO uint32_t TIMINGR;     /*!< I2C Timing register,               Address offset: 0x10 */
  __IO uint32_t TIMEOUTR;    /*!< I2C Timeout register,              Address offset: 0x14 */
  __IO uint32_t ISR;         /*!< I2C Interrupt and status register, Address offset: 0x18 */
  __IO uint32_t ICR;         /*!< I2C Interrupt clear register,      Address offset: 0x1C */
  __IO uint32_t PECR;        /*!< I2C PEC register,                  Address offset: 0x20 */
  __IO uint32_t RXDR;        /*!< I2C Receive data register,         Address offset: 0x24 */
  __IO uint32_t TXDR;        /*!< I2C Transmit data register,        Address offset: 0x28 */
} I2C_TypeDef;

/**
  * @brief Improved Inter-integrated Circuit Interface
  */
typedef struct
{
  __IO uint32_t CR;             /*!< I3C Control register,                      Address offset: 0x00      */
  __IO uint32_t CFGR;           /*!< I3C Controller Configuration register,     Address offset: 0x04      */
  uint32_t      RESERVED1[2];   /*!< Reserved,                                  Address offset: 0x08-0x0C */
  __IO uint32_t RDR;            /*!< I3C Received Data register,                Address offset: 0x10      */
  __IO uint32_t RDWR;           /*!< I3C Received Data Word register,           Address offset: 0x14      */
  __IO uint32_t TDR;            /*!< I3C Transmit Data register,                Address offset: 0x18      */
  __IO uint32_t TDWR;           /*!< I3C Transmit Data Word register,           Address offset: 0x1C      */
  __IO uint32_t IBIDR;          /*!< I3C IBI payload Data register,             Address offset: 0x20      */
  __IO uint32_t TGTTDR;         /*!< I3C Target Transmit register,              Address offset: 0x24      */
  uint32_t      RESERVED2[2];   /*!< Reserved,                                  Address offset: 0x28-0x2C */
  __IO uint32_t SR;             /*!< I3C Status register,                       Address offset: 0x30      */
  __IO uint32_t SER;            /*!< I3C Status Error register,                 Address offset: 0x34      */
  uint32_t      RESERVED3[2];   /*!< Reserved,                                  Address offset: 0x38-0x3C */
  __IO uint32_t RMR;            /*!< I3C Received Message register,             Address offset: 0x40      */
  uint32_t      RESERVED4[3];   /*!< Reserved,                                  Address offset: 0x44-0x4C */
  __IO uint32_t EVR;            /*!< I3C Event register,                        Address offset: 0x50      */
  __IO uint32_t IER;            /*!< I3C Interrupt Enable register,             Address offset: 0x54      */
  __IO uint32_t CEVR;           /*!< I3C Clear Event register,                  Address offset: 0x58      */
  uint32_t RESERVED5;           /*!< Reserved,                                  Address offset: 0x5C      */
  __IO uint32_t DEVR0;          /*!< I3C own Target characteristics register,   Address offset: 0x60      */
  __IO uint32_t DEVRX[4];       /*!< I3C Target x (1<=x<=4) register,           Address offset: 0x64-0x70 */
  uint32_t      RESERVED6[7];   /*!< Reserved,                                  Address offset: 0x74-0x8C */
  __IO uint32_t MAXRLR;         /*!< I3C Maximum Read Length register,          Address offset: 0x90      */
  __IO uint32_t MAXWLR;         /*!< I3C Maximum Write Length register,         Address offset: 0x94      */
  uint32_t      RESERVED7[2];   /*!< Reserved,                                  Address offset: 0x98-0x9C */
  __IO uint32_t TIMINGR0;       /*!< I3C Timing 0 register,                     Address offset: 0xA0      */
  __IO uint32_t TIMINGR1;       /*!< I3C Timing 1 register,                     Address offset: 0xA4      */
  __IO uint32_t TIMINGR2;       /*!< I3C Timing 2 register,                     Address offset: 0xA8      */
  uint32_t      RESERVED9[5];   /*!< Reserved,                                  Address offset: 0xAC-0xBC */
  __IO uint32_t BCR;            /*!< I3C Bus Characteristics register,          Address offset: 0xC0      */
  __IO uint32_t DCR;            /*!< I3C Device Characteristics register,       Address offset: 0xC4      */
  __IO uint32_t GETCAPR;        /*!< I3C GET CAPabilities register,             Address offset: 0xC8      */
  __IO uint32_t CRCAPR;         /*!< I3C Controller CAPabilities register,      Address offset: 0xCC      */
  __IO uint32_t GETMXDSR;       /*!< I3C GET Max Data Speed register,           Address offset: 0xD0      */
  __IO uint32_t EPIDR;          /*!< I3C Extended Provisioned ID register,      Address offset: 0xD4      */
} I3C_TypeDef;

/**
  * @brief Illegal Access Controller
  */
typedef struct
{
  __IO uint32_t IER[5];         /*!< Interrupt Enable register,                 Address offset: 0x000       */
  uint32_t      RESERVED1[27];  /*!< Reserved,                                  Address offset: 0x014-0x07C */
  __IO uint32_t ISR[5];         /*!< Interrupt Status register,                 Address offset: 0x080       */
  uint32_t      RESERVED2[27];  /*!< Reserved,                                  Address offset: 0x094-0x0FC */
  __IO uint32_t ICR[5];         /*!< Interrupt Clear register,                  Address offset: 0x100       */
} IAC_TypeDef;

/**
  * @brief Instruction Cache
  */
typedef struct
{
  __IO uint32_t CR;             /*!< ICACHE control register,                Address offset: 0x00 */
  __IO uint32_t SR;             /*!< ICACHE status register,                 Address offset: 0x04 */
  __IO uint32_t IER;            /*!< ICACHE interrupt enable register,       Address offset: 0x08 */
  __IO uint32_t FCR;            /*!< ICACHE flag clear register,             Address offset: 0x0C */
  __IO uint32_t HMONR;          /*!< ICACHE hit monitor register,            Address offset: 0x10 */
  __IO uint32_t MMONR;          /*!< ICACHE miss monitor register,           Address offset: 0x14 */
} ICACHE_TypeDef;

typedef struct
{
  __IO uint32_t KR;              /*!< IWDG key register                    Address offset: 0x000 */
  __IO uint32_t PR;              /*!< IWDG prescaler register              Address offset: 0x004 */
  __IO uint32_t RLR;             /*!< IWDG reload register                 Address offset: 0x008 */
  __IO uint32_t SR;              /*!< IWDG status register                 Address offset: 0x00C */
  __IO uint32_t WINR;            /*!< IWDG window register                 Address offset: 0x010 */
  __IO uint32_t EWCR;            /*!< IWDG early wakeup interrupt register Address offset: 0x014 */
  __IO uint32_t ICR;             /*!< IWDG interrupt clear register        Address offset: 0x018 */
} IWDG_TypeDef;

/**
  * @brief JPEG Codec
  */
typedef struct
{
  __IO uint32_t CONFR0;          /*!< JPEG Codec Control Register (JPEG_CONFR0),        Address offset: 00h       */
  __IO uint32_t CONFR1;          /*!< JPEG Codec Control Register (JPEG_CONFR1),        Address offset: 04h       */
  __IO uint32_t CONFR2;          /*!< JPEG Codec Control Register (JPEG_CONFR2),        Address offset: 08h       */
  __IO uint32_t CONFR3;          /*!< JPEG Codec Control Register (JPEG_CONFR3),        Address offset: 0Ch       */
  __IO uint32_t CONFR4;          /*!< JPEG Codec Control Register (JPEG_CONFR4),        Address offset: 10h       */
  __IO uint32_t CONFR5;          /*!< JPEG Codec Control Register (JPEG_CONFR5),        Address offset: 14h       */
  __IO uint32_t CONFR6;          /*!< JPEG Codec Control Register (JPEG_CONFR6),        Address offset: 18h       */
  __IO uint32_t CONFR7;          /*!< JPEG Codec Control Register (JPEG_CONFR7),        Address offset: 1Ch       */
  uint32_t  Reserved20[4];       /* Reserved                                            Address offset: 20h-2Ch   */
  __IO uint32_t CR;              /*!< JPEG Control Register (JPEG_CR),                  Address offset: 30h       */
  __IO uint32_t SR;              /*!< JPEG Status Register (JPEG_SR),                   Address offset: 34h       */
  __IO uint32_t CFR;             /*!< JPEG Clear Flag Register (JPEG_CFR),              Address offset: 38h       */
  uint32_t  Reserved3c;          /* Reserved                                            Address offset: 3Ch       */
  __IO uint32_t DIR;             /*!< JPEG Data Input Register (JPEG_DIR),              Address offset: 40h       */
  __IO uint32_t DOR;             /*!< JPEG Data Output Register (JPEG_DOR),             Address offset: 44h       */
  uint32_t  Reserved48[2];       /* Reserved                                            Address offset: 48h-4Ch   */
  __IO uint32_t QMEM0[16];       /*!< JPEG quantization tables 0,                       Address offset: 50h-8Ch   */
  __IO uint32_t QMEM1[16];       /*!< JPEG quantization tables 1,                       Address offset: 90h-CCh   */
  __IO uint32_t QMEM2[16];       /*!< JPEG quantization tables 2,                       Address offset: D0h-10Ch  */
  __IO uint32_t QMEM3[16];       /*!< JPEG quantization tables 3,                       Address offset: 110h-14Ch */
  __IO uint32_t HUFFMIN[16];     /*!< JPEG HuffMin tables,                              Address offset: 150h-18Ch */
  __IO uint32_t HUFFBASE[32];    /*!< JPEG HuffSymb tables,                             Address offset: 190h-20Ch */
  __IO uint32_t HUFFSYMB[84];    /*!< JPEG HUFFSYMB tables,                             Address offset: 210h-35Ch */
  __IO uint32_t DHTMEM[103];     /*!< JPEG DHTMem tables,                               Address offset: 360h-4F8h */
  uint32_t  Reserved4FC;         /* Reserved                                            Address offset: 4FCh      */
  __IO uint32_t HUFFENC_AC0[88]; /*!< JPEG encodor, AC Huffman table 0,                 Address offset: 500h-65Ch */
  __IO uint32_t HUFFENC_AC1[88]; /*!< JPEG encodor, AC Huffman table 1,                 Address offset: 660h-7BCh */
  __IO uint32_t HUFFENC_DC0[8];  /*!< JPEG encodor, DC Huffman table 0,                 Address offset: 7C0h-7DCh */
  __IO uint32_t HUFFENC_DC1[8];  /*!< JPEG encodor, DC Huffman table 1,                 Address offset: 7E0h-7FCh */

} JPEG_TypeDef;


/**
  * @brief LCD-TFT Display Controller (LTDC)
  */
typedef struct
{
       uint32_t RESERVED0[2];   /*!< Reserved Address offset: 0x00-0x04 */
  __IO uint32_t SSCR;           /*!< LTDC synchronization size configuration register Address offset: 0x8 */
  __IO uint32_t BPCR;           /*!< LTDC back porch configuration register Address offset: 0xc */
  __IO uint32_t AWCR;           /*!< LTDC active width configuration register Address offset: 0x10 */
  __IO uint32_t TWCR;           /*!< LTDC total width configuration register Address offset: 0x14 */
  __IO uint32_t GCR;            /*!< LTDC global control register Address offset: 0x18 */
       uint32_t RESERVED1[2];   /*!< Reserved Address offset: */
  __IO uint32_t SRCR;           /*!< LTDC shadow reload configuration register Address offset: 0x24 */
  __IO uint32_t GCCR;           /*!< LTDC gamma correction configuration register Address offset: 0x28 */
  __IO uint32_t BCCR;           /*!< LTDC background color configuration register Address offset: 0x2c */
       uint32_t RESERVED2;      /*!< Reserved Address offset: 0x30 */
  __IO uint32_t IER;            /*!< LTDC interrupt enable register Address offset: 0x34 */
  __IO uint32_t ISR;            /*!< LTDC interrupt status register Address offset: 0x38 */
  __IO uint32_t ICR;            /*!< LTDC Interrupt Clear Register Address offset: 0x3c */
  __IO uint32_t LIPCR;          /*!< LTDC line interrupt position configuration register Address offset: 0x40 */
  __IO uint32_t CPSR;           /*!< LTDC current position status register Address offset: 0x44 */
  __IO uint32_t CDSR;           /*!< LTDC current display status register Address offset: 0x48 */
       uint32_t RESERVED3[5];   /*!< Reserved Address offset: 0x4c */
  __IO uint32_t EDCR;           /*!< LTDC external display control register Address offset: 0x60 */
  __IO uint32_t IER2;           /*!< LTDC interrupt enable register 2 Address offset: 0x64 */
  __IO uint32_t ISR2;           /*!< LTDC interrupt status register 2 Address offset: 0x68 */
  __IO uint32_t ICR2;           /*!< LTDC Interrupt Clear Register 2 Address offset: 0x6c */
  __IO uint32_t LIPCR2;         /*!< LTDC line interrupt position configuration register 2 Address offset: 0x70 */
       uint32_t RESERVED4;      /*!< Reserved Address offset: 0x74 */
  __IO uint32_t ECRCR;          /*!< LTDC expected CRC register Address offset: 0x78 */
  __IO uint32_t CCRCR;          /*!< LTDC computed CRC register Address offset: 0x7c */
  __IO uint32_t RB0AR;          /*!< LTDC rotation buffer 0 address register Address offset: 0x80 */
  __IO uint32_t RB1AR;          /*!< LTDC rotation buffer 1 address register Address offset: 0x84 */
  __IO uint32_t RBPR;           /*!< LTDC rotation buffer pitch register Address offset: 0x88 */
  __IO uint32_t RIFCR;          /*!< LTDC rotation intermediate frame color register Address offset: 0x8c */
  __IO uint32_t FUTR;           /*!< LTDC FIFO underrun threshold register Address offset: 0x90 */
} LTDC_TypeDef;

/**
  * @brief LCD-TFT Display layer x Controller (LTDC)
  */
typedef struct
{
  __IO uint32_t C0R;          /*!< LTDC layer x configuration 0 register Address offset: 0x100 */
  __IO uint32_t C1R;          /*!< LTDC layer x configuration 1 register Address offset: 0x104 */
  __IO uint32_t RCR;          /*!< LTDC layer x reload control register Address offset: 0x108 */
  __IO uint32_t CR;           /*!< LTDC layer x control register Address offset: 0x10c */
  __IO uint32_t WHPCR;        /*!< LTDC layer x window horizontal position configuration register Address offset: 0x110 */
  __IO uint32_t WVPCR;        /*!< LTDC layer x window vertical position configuration register Address offset: 0x114 */
  __IO uint32_t CKCR;         /*!< LTDC layer x color keying configuration register Address offset: 0x118 */
  __IO uint32_t PFCR;         /*!< LTDC layer x pixel format configuration register Address offset: 0x11c */
  __IO uint32_t CACR;         /*!< LTDC layer x constant alpha configuration register Address offset: 0x120 */
  __IO uint32_t DCCR;         /*!< LTDC layer x default color configuration register Address offset: 0x124 */
  __IO uint32_t BFCR;         /*!< LTDC layer x blending factors configuration register Address offset: 0x128 */
  __IO uint32_t BLCR;         /*!< LTDC layer x burst length configuration register Address offset: 0x12c */
  __IO uint32_t PCR;          /*!< LTDC layer x planar configuration register Address offset: 0x130 */
  __IO uint32_t CFBAR;        /*!< LTDC layer x color frame buffer address register Address offset: 0x134 */
  __IO uint32_t CFBLR;        /*!< LTDC layer x color frame buffer length register Address offset: 0x138 */
  __IO uint32_t CFBLNR;       /*!< LTDC layer x color frame buffer line number register Address offset: 0x13c */
  __IO uint32_t AFBA0R;       /*!< LTDC layer x auxiliary frame buffer address 0 register Address offset: 0x140 */
  __IO uint32_t AFBA1R;       /*!< LTDC layer x auxiliary frame buffer address 1 register Address offset: 0x144 */
  __IO uint32_t AFBLR;        /*!< LTDC layer x auxiliary frame buffer length register Address offset: 0x148 */
  __IO uint32_t AFBLNR;       /*!< LTDC layer x auxiliary frame buffer line number register Address offset: 0x14c */
  __IO uint32_t CLUTWR;       /*!< LTDC layer x CLUT write register Address offset: 0x150 */
  __IO uint32_t SISR;         /*!< LTDC layer x Scaler Input Size register Address offset: 0x154 */
  __IO uint32_t SOSR;         /*!< LTDC layer x Scaler Output Size register Address offset: 0x158 */
  __IO uint32_t SVSFR;        /*!< LTDC layer x Scaler Vertical Scaling Factor register Address offset: 0x15c */
  __IO uint32_t SVSPR;        /*!< LTDC layer x Scaler Vertical Scaling Phase register Address offset: 0x160 */
  __IO uint32_t SHSFR;        /*!< LTDC layer x Scaler Horizontal Scaling Factor register Address offset: 0x164 */
  __IO uint32_t SHSPR;        /*!< LTDC layer x Scaler Horizontal Scaling Phase register Address offset: 0x168 */
  __IO uint32_t CYR0R;        /*!< LTDC layer x Conversion YCbCr RGB 0 register Address offset: 0x16c */
  __IO uint32_t CYR1R;        /*!< LTDC layer x Conversion YCbCr RGB 1 register Address offset: 0x170 */
  __IO uint32_t FPF0R;        /*!< LTDC layer x Flexible Pixel Format 0 register Address offset: 0x174 */
  __IO uint32_t FPF1R;        /*!< LTDC layer x Flexible Pixel Format 1 register Address offset: 0x178 */
} LTDC_Layer_TypeDef;


/**
  * @brief LPTIMER
  */
typedef struct
{
  __IO uint32_t ISR;            /*!< LPTIM Interrupt and Status register,    Address offset: 0x00 */
  __IO uint32_t ICR;            /*!< LPTIM Interrupt Clear register,         Address offset: 0x04 */
  __IO uint32_t DIER;           /*!< LPTIM Interrupt Enable register,        Address offset: 0x08 */
  __IO uint32_t CFGR;           /*!< LPTIM Configuration register,           Address offset: 0x0C */
  __IO uint32_t CR;             /*!< LPTIM Control register,                 Address offset: 0x10 */
  __IO uint32_t CCR1;           /*!< LPTIM Capture/Compare register 1,       Address offset: 0x14 */
  __IO uint32_t ARR;            /*!< LPTIM Autoreload register,              Address offset: 0x18 */
  __IO uint32_t CNT;            /*!< LPTIM Counter register,                 Address offset: 0x1C */
  __IO uint32_t RESERVED1;      /*!< Reserved,                               Address offset: 0x20 */
  __IO uint32_t CFGR2;          /*!< LPTIM Configuration register 2,         Address offset: 0x24 */
  __IO uint32_t RCR;            /*!< LPTIM Repetition register,              Address offset: 0x28 */
  __IO uint32_t CCMR1;          /*!< LPTIM Capture/Compare mode register,    Address offset: 0x2C */
  __IO uint32_t RESERVED2;      /*!< Reserved,                               Address offset: 0x30 */
  __IO uint32_t CCR2;           /*!< LPTIM Capture/Compare register 2,       Address offset: 0x34 */
} LPTIM_TypeDef;

/**
  * @brief Memory Cipher Engine (MCE)
  */
typedef struct
{
  __IO uint32_t REGCR;            /*!< MCE region configuration register,             Address offset: 0x040 + 0x10 * (x-1) (x = 1 to 4) */
  __IO uint32_t SADDR;            /*!< MCE region start address register,             Address offset: 0x044 + 0x10 * (x-1) (x = 1 to 4) */
  __IO uint32_t EADDR;            /*!< MCE region end address register,               Address offset: 0x048 + 0x10 * (x-1) (x = 1 to 4) */
} MCE_Region_TypeDef;

typedef struct
{
  __IO uint32_t CCCFGR;           /*!< MCE cipher context configuration register,     Address offset: 0x240 + 0x30 * (x-1) (x = 1 to 2) */
  __IO uint32_t CCNR0;            /*!< MCE cipher context nonce register 0,           Address offset: 0x244 + 0x30 * (x-1) (x = 1 to 2) */
  __IO uint32_t CCNR1;            /*!< MCE cipher context nonce register 1,           Address offset: 0x248 + 0x30 * (x-1) (x = 1 to 2) */
  __IO uint32_t CCKEYR0;          /*!< MCE cipher context key register 0,             Address offset: 0x24C + 0x30 * (x-1) (x = 1 to 2) */
  __IO uint32_t CCKEYR1;          /*!< MCE cipher context key register 1,             Address offset: 0x250 + 0x30 * (x-1) (x = 1 to 2) */
  __IO uint32_t CCKEYR2;          /*!< MCE cipher context key register 2,             Address offset: 0x254 + 0x30 * (x-1) (x = 1 to 2) */
  __IO uint32_t CCKEYR3;          /*!< MCE cipher context key register 3,             Address offset: 0x258 + 0x30 * (x-1) (x = 1 to 2) */
} MCE_Context_TypeDef;

typedef struct
{
  __IO uint32_t CR;               /*!< MCE configuration register,                           Address offset: 0x000       */
  __IO uint32_t SR;               /*!< MCE status register,                                  Address offset: 0x004       */
  __IO uint32_t IASR;             /*!< MCE illegal access status register,                   Address offset: 0x008       */
  __IO uint32_t IACR;             /*!< MCE illegal access clear register,                    Address offset: 0x00C       */
  __IO uint32_t IAIER;            /*!< MCE illegal access interrupt enable register,         Address offset: 0x010       */
  uint32_t RESERVED0[4];          /*!< Reserved,                                             Address offset: 0x014-0x20  */
  __IO uint32_t IADDR;            /*!< MCE illegal address register,                         Address offset: 0x024       */
  uint32_t RESERVED1[118];        /*!< Reserved,                                             Address offset: 0x028-0x1FC */
  __IO uint32_t MKEYR0;           /*!< MCE master key register 0,                            Address offset: 0x200       */
  __IO uint32_t MKEYR1;           /*!< MCE master key register 1,                            Address offset: 0x204       */
  __IO uint32_t MKEYR2;           /*!< MCE master key register 2,                            Address offset: 0x208       */
  __IO uint32_t MKEYR3;           /*!< MCE master key register 3,                            Address offset: 0x20C       */
  __IO uint32_t MKEYR4;           /*!< MCE master key register 4,                            Address offset: 0x210       */
  __IO uint32_t MKEYR5;           /*!< MCE master key register 5,                            Address offset: 0x214       */
  __IO uint32_t MKEYR6;           /*!< MCE master key register 6,                            Address offset: 0x218       */
  __IO uint32_t MKEYR7;           /*!< MCE master key register 7,                            Address offset: 0x21C       */
  __IO uint32_t FMKEYR0;          /*!< MCE fast master key register 0,                       Address offset: 0x220       */
  __IO uint32_t FMKEYR1;          /*!< MCE fast master key register 1,                       Address offset: 0x224       */
  __IO uint32_t FMKEYR2;          /*!< MCE fast master key register 2,                       Address offset: 0x228       */
  __IO uint32_t FMKEYR3;          /*!< MCE fast master key register 3,                       Address offset: 0x22C       */
  __IO uint32_t FMKEYR4;          /*!< MCE fast master key register 4,                       Address offset: 0x230       */
  __IO uint32_t FMKEYR5;          /*!< MCE fast master key register 5,                       Address offset: 0x234       */
  __IO uint32_t FMKEYR6;          /*!< MCE fast master key register 6,                       Address offset: 0x238       */
  __IO uint32_t FMKEYR7;          /*!< MCE fast master key register 7,                       Address offset: 0x23C       */
} MCE_TypeDef;



/**
  * @brief ADF
  */
typedef struct
{
  __IO uint32_t GCR;            /*!< MDF Global Control register,             Address offset: 0x00  */
  __IO uint32_t CKGCR;          /*!< MDF Clock Generator Control Register,    Address offset: 0x04  */
  uint32_t      RESERVED1[6];   /*!< Reserved, 0x08-0x1C                                            */
  __IO uint32_t OR;             /*!< MDF  Option Register,                    Address offset: 0x20  */
} MDF_TypeDef;

/**
  * @brief ADF filter
  */
typedef struct
{
 __IO uint32_t SITFCR;         /*!< MDF Serial Interface Control Register,          Address offset: 0x80 */
 __IO uint32_t BSMXCR;         /*!< MDF Bitstream Matrix Control Register,          Address offset: 0x84 */
 __IO uint32_t DFLTCR;         /*!< MDF Digital Filter Control Register,            Address offset: 0x88 */
 __IO uint32_t DFLTCICR;       /*!< MDF MCIC Configuration Register,                Address offset: 0x8C */
 __IO uint32_t DFLTRSFR;       /*!< MDF Reshape Filter Configuration Register,      Address offset: 0x90 */
 __IO uint32_t DFLTINTR;       /*!< MDF Integrator Configuration Register,          Address offset: 0x94 */
 __IO uint32_t OLDCR;          /*!< MDF Out-Of Limit Detector Control Register,     Address offset: 0x98 */
 __IO uint32_t OLDTHLR;        /*!< MDF OLD Threshold Low Register,                 Address offset: 0x9C */
 __IO uint32_t OLDTHHR;        /*!< MDF OLD Threshold High Register,                Address offset: 0xA0 */
 __IO uint32_t DLYCR;          /*!< MDF Delay control Register,                     Address offset: 0xA4 */
 __IO uint32_t SCDCR;          /*!< MDF short circuit detector control Register,    Address offset: 0xA8 */
 __IO uint32_t DFLTIER;        /*!< MDF DFLT Interrupt enable Register,             Address offset: 0xAC */
 __IO uint32_t DFLTISR;        /*!< MDF DFLT Interrupt status Register,             Address offset: 0xB0 */
 __IO uint32_t OECCR;          /*!< MDF Offset Error Compensation Control Register, Address offset: 0xB4 */
 __IO uint32_t SADCR;          /*!< MDF SAD Control Register,                       Address offset: 0xB8 */
 __IO uint32_t SADCFGR;        /*!< MDF SAD configuration register,                 Address offset: 0xBC */
 __IO uint32_t SADSDLVR;       /*!< MDF SAD Sound level Register,                   Address offset: 0xC0 */
 __IO uint32_t SADANLVR;       /*!< MDF SAD Ambient Noise level Register,           Address offset: 0xC4 */
 uint32_t     RESERVED1[9];    /*!< Reserved, 0xC8-0xE8                                                  */
 __IO uint32_t SNPSDR;         /*!< MDF Snapshot Data Register,                     Address offset: 0xEC */
 __IO uint32_t DFLTDR;         /*!< MDF Digital Filter Data Register,               Address offset: 0xF0 */
} MDF_Filter_TypeDef;


/**
  * @brief MDIOS
  */

typedef struct
{
  __IO uint32_t CR;
  __IO uint32_t WRFR;
  __IO uint32_t CWRFR;
  __IO uint32_t RDFR;
  __IO uint32_t CRDFR;
  __IO uint32_t SR;
  __IO uint32_t CLRFR;
  uint32_t RESERVED[57];
  __IO uint32_t DINR0;
  __IO uint32_t DINR1;
  __IO uint32_t DINR2;
  __IO uint32_t DINR3;
  __IO uint32_t DINR4;
  __IO uint32_t DINR5;
  __IO uint32_t DINR6;
  __IO uint32_t DINR7;
  __IO uint32_t DINR8;
  __IO uint32_t DINR9;
  __IO uint32_t DINR10;
  __IO uint32_t DINR11;
  __IO uint32_t DINR12;
  __IO uint32_t DINR13;
  __IO uint32_t DINR14;
  __IO uint32_t DINR15;
  __IO uint32_t DINR16;
  __IO uint32_t DINR17;
  __IO uint32_t DINR18;
  __IO uint32_t DINR19;
  __IO uint32_t DINR20;
  __IO uint32_t DINR21;
  __IO uint32_t DINR22;
  __IO uint32_t DINR23;
  __IO uint32_t DINR24;
  __IO uint32_t DINR25;
  __IO uint32_t DINR26;
  __IO uint32_t DINR27;
  __IO uint32_t DINR28;
  __IO uint32_t DINR29;
  __IO uint32_t DINR30;
  __IO uint32_t DINR31;
  __IO uint32_t DOUTR0;
  __IO uint32_t DOUTR1;
  __IO uint32_t DOUTR2;
  __IO uint32_t DOUTR3;
  __IO uint32_t DOUTR4;
  __IO uint32_t DOUTR5;
  __IO uint32_t DOUTR6;
  __IO uint32_t DOUTR7;
  __IO uint32_t DOUTR8;
  __IO uint32_t DOUTR9;
  __IO uint32_t DOUTR10;
  __IO uint32_t DOUTR11;
  __IO uint32_t DOUTR12;
  __IO uint32_t DOUTR13;
  __IO uint32_t DOUTR14;
  __IO uint32_t DOUTR15;
  __IO uint32_t DOUTR16;
  __IO uint32_t DOUTR17;
  __IO uint32_t DOUTR18;
  __IO uint32_t DOUTR19;
  __IO uint32_t DOUTR20;
  __IO uint32_t DOUTR21;
  __IO uint32_t DOUTR22;
  __IO uint32_t DOUTR23;
  __IO uint32_t DOUTR24;
  __IO uint32_t DOUTR25;
  __IO uint32_t DOUTR26;
  __IO uint32_t DOUTR27;
  __IO uint32_t DOUTR28;
  __IO uint32_t DOUTR29;
  __IO uint32_t DOUTR30;
  __IO uint32_t DOUTR31;
} MDIOS_TypeDef;

/**
  * @brief PSSI
  */
typedef struct
{
  __IO uint32_t CR;             /*!< PSSI control register,                 Address offset: 0x000 */
  __IO uint32_t SR;             /*!< PSSI status register,                  Address offset: 0x004 */
  __IO uint32_t RIS;            /*!< PSSI raw interrupt status register,    Address offset: 0x008 */
  __IO uint32_t IER;            /*!< PSSI interrupt enable register,        Address offset: 0x00C */
  __IO uint32_t MIS;            /*!< PSSI masked interrupt status register, Address offset: 0x010 */
  __IO uint32_t ICR;            /*!< PSSI interrupt clear register,         Address offset: 0x014 */
  __IO uint32_t RESERVED1[4];   /*!< Reserved,                                      0x018 - 0x024 */
  __IO uint32_t DR;             /*!< PSSI data register,                    Address offset: 0x028 */
} PSSI_TypeDef;

/**
  * @brief Power Control
  */
typedef struct
{
  __IO uint32_t CR1;             /*!< PWR Control register 1                           Address offset: 0x000 */
  __IO uint32_t CR2;             /*!< PWR Control Register 2                           Address offset: 0x004 */
  __IO uint32_t CR3;             /*!< PWR Control Register 3                           Address offset: 0x008 */
  __IO uint32_t CR4;             /*!< PWR Control Register 4                           Address offset: 0x00C */
       uint32_t RESERVED0[4];    /*!< Reserved                                         Address offset: 0x010-0x01C */
  __IO uint32_t VOSCR;           /*!< PWR Voltage scaling control register             Address offset: 0x020 */
  __IO uint32_t BDCR1;           /*!< PWR Backup domain control register 1             Address offset: 0x024 */
  __IO uint32_t BDCR2;           /*!< PWR Backup domain control register 2             Address offset: 0x028 */
  __IO uint32_t DBPCR;           /*!< PWR Disable backup protection control register   Address offset: 0x02C */
  __IO uint32_t CPUCR;           /*!< PWR CPU control register                         Address offset: 0x030 */
  __IO uint32_t SVMCR1;          /*!< PWR Supply voltage monitoring control register 1 Address offset: 0x034 */
  __IO uint32_t SVMCR2;          /*!< PWR Supply voltage monitoring control register 2 Address offset: 0x038 */
  __IO uint32_t SVMCR3;          /*!< PWR Supply voltage monitoring control register 3 Address offset: 0x03C */
       uint32_t RESERVED1[4];    /*!< Reserved                                         Address offset: 0x040-0x04C */
  __IO uint32_t WKUPCR;          /*!< PWR Wakeup control register 1                    Address offset: 0x050 */
  __IO uint32_t WKUPSR;          /*!< PWR Wakeup control register 2                    Address offset: 0x054 */
  __IO uint32_t WKUPEPR;         /*!< PWR Wakeup control register 3                    Address offset: 0x058 */
       uint32_t RESERVED2[5];    /*!< Reserved                                         Address offset: 0x05C-0x06C */
  __IO uint32_t SECCFGR;         /*!< PWR Security configuration register              Address offset: 0x070 */
  __IO uint32_t PRIVCFGR;        /*!< PWR Privilege configuration register             Address offset: 0x074 */
} PWR_TypeDef;

/**
  * @brief PKA
  */
typedef struct
{
  __IO uint32_t CR;            /*!< PKA control register,             Address offset: 0x00 */
  __IO uint32_t SR;            /*!< PKA status register,              Address offset: 0x04 */
  __IO uint32_t CLRFR;         /*!< PKA clear flag register,          Address offset: 0x08 */
  uint32_t Reserved[253];      /*!< Reserved memory area              Address offset: 0x0C  -> 0x03FC */
  __IO uint32_t RAM[1334];     /*!< PKA RAM                           Address offset: 0x400 -> 0x18D4 */
} PKA_TypeDef;

/**
  * @brief RAMs configuration controller
  */
typedef struct
{
  __IO uint32_t CR;          /*!< Control Register,                    Address offset: 0x00 */
  __IO uint32_t IER;         /*!< Interrupt Enable Register,           Address offset: 0x04 */
  __IO uint32_t ISR;         /*!< Interrupt Status Register,           Address offset: 0x08 */
  __IO uint32_t ESEAR;       /*!< ECC Single Error Address Register,   Address offset: 0x0C */
  __IO uint32_t EDEAR;       /*!< ECC Double Error Address Register,   Address offset: 0x10 */
  __IO uint32_t ICR;         /*!< Interrupt Clear Register,            Address offset: 0x14 */
  uint32_t      RESERVED[3]; /*!< Reserved,                       Address offset: 0x18-0x20 */
  __IO uint32_t ECCKEYR;     /*!< RAM ECC Key Register,                Address offset: 0x24 */
  __IO uint32_t ERKEYR;      /*!< RAM Erase Key Register,              Address offset: 0x28 */
}RAMCFG_TypeDef;

/**
  * @brief Reset and Clock Control
  */

typedef struct
{
  __IO uint32_t CR;               /*!< RCC control register                                           Address offset: 0x0000 */
  __IO uint32_t SR;               /*!< RCC status register                                            Address offset: 0x0004 */
  __IO uint32_t STOPCR;           /*!< RCC Stop mode control register                                 Address offset: 0x0008 */
       uint32_t RESERVED0[5];     /*!< Reserved                                                       Address offset: 0x000C-0x001C */
  __IO uint32_t CFGR1;            /*!< RCC configuration register 1                                   Address offset: 0x0020 */
  __IO uint32_t CFGR2;            /*!< RCC configuration register 2                                   Address offset: 0x0024 */
       uint32_t RESERVED1;        /*!< Reserved                                                       Address offset: 0x0028 */
  __IO uint32_t BDCR;             /*!< RCC backup domain protection register                          Address offset: 0x002C */
  __IO uint32_t HWRSR;            /*!< RCC reset status register for hardware                         Address offset: 0x0030 */
  __IO uint32_t RSR;              /*!< RCC reset register                                             Address offset: 0x0034 */
       uint32_t RESERVED2[2];     /*!< Reserved                                                       Address offset: 0x0038-0x003C */
  __IO uint32_t LSECFGR;          /*!< RCC LSE configuration register                                 Address offset: 0x0040 */
  __IO uint32_t MSICFGR;          /*!< RCC MSI configuration register                                 Address offset: 0x0044 */
  __IO uint32_t HSICFGR;          /*!< RCC HSI configuration register                                 Address offset: 0x0048 */
  __IO uint32_t HSIMCR;           /*!< RCC HSI Monitor control register                               Address offset: 0x004C */
  __IO uint32_t HSIMSR;           /*!< RCC HSI Monitor status register                                Address offset: 0x0050 */
  __IO uint32_t HSECFGR;          /*!< RCC HSE configuration register                                 Address offset: 0x0054 */
       uint32_t RESERVED3[10];    /*!< Reserved                                                       Address offset: 0x0058-0x007C */
  __IO uint32_t PLL1CFGR1;        /*!< RCC PLL1 configuration register 1                              Address offset: 0x0080 */
  __IO uint32_t PLL1CFGR2;        /*!< RCC PLL1 configuration register 2                              Address offset: 0x0084 */
  __IO uint32_t PLL1CFGR3;        /*!< RCC PLL1 configuration register 3                              Address offset: 0x0088 */
       uint32_t RESERVED4;        /*!< Reserved                                                       Address offset: 0x008C */
  __IO uint32_t PLL2CFGR1;        /*!< RCC PLL2 configuration register 1                              Address offset: 0x0090 */
  __IO uint32_t PLL2CFGR2;        /*!< RCC PLL2 configuration register 2                              Address offset: 0x0094 */
  __IO uint32_t PLL2CFGR3;        /*!< RCC PLL2 configuration register 3                              Address offset: 0x0098 */
       uint32_t RESERVED5;        /*!< Reserved                                                       Address offset: 0x009C */
  __IO uint32_t PLL3CFGR1;        /*!< RCC PLL3 configuration register 1                              Address offset: 0x00A0 */
  __IO uint32_t PLL3CFGR2;        /*!< RCC PLL3 configuration register 2                              Address offset: 0x00A4 */
  __IO uint32_t PLL3CFGR3;        /*!< RCC PLL3 configuration register 3                              Address offset: 0x00A8 */
       uint32_t RESERVED6;        /*!< Reserved                                                       Address offset: 0x00AC */
  __IO uint32_t PLL4CFGR1;        /*!< RCC PLL4 configuration register 1                              Address offset: 0x00B0 */
  __IO uint32_t PLL4CFGR2;        /*!< RCC PLL4 configuration register 2                              Address offset: 0x00B4 */
  __IO uint32_t PLL4CFGR3;        /*!< RCC PLL4 configuration register 3                              Address offset: 0x00B8 */
       uint32_t RESERVED7[2];     /*!< Reserved                                                       Address offset: 0x00BC-0x00C0 */
  __IO uint32_t IC1CFGR;          /*!< RCC IC1 configuration register                                 Address offset: 0x00C4 */
  __IO uint32_t IC2CFGR;          /*!< RCC IC2 configuration register                                 Address offset: 0x00C8 */
  __IO uint32_t IC3CFGR;          /*!< RCC IC3 configuration register                                 Address offset: 0x00CC */
  __IO uint32_t IC4CFGR;          /*!< RCC IC4 configuration register                                 Address offset: 0x00D0 */
  __IO uint32_t IC5CFGR;          /*!< RCC IC5 configuration register                                 Address offset: 0x00D4 */
  __IO uint32_t IC6CFGR;          /*!< RCC IC6 configuration register                                 Address offset: 0x00D8 */
  __IO uint32_t IC7CFGR;          /*!< RCC IC7 configuration register                                 Address offset: 0x00DC */
  __IO uint32_t IC8CFGR;          /*!< RCC IC8 configuration register                                 Address offset: 0x00E0 */
  __IO uint32_t IC9CFGR;          /*!< RCC IC9 configuration register                                 Address offset: 0x00E4 */
  __IO uint32_t IC10CFGR;         /*!< RCC IC10 configuration register                                Address offset: 0x00E8 */
  __IO uint32_t IC11CFGR;         /*!< RCC IC11 configuration register                                Address offset: 0x00EC */
  __IO uint32_t IC12CFGR;         /*!< RCC IC12 configuration register                                Address offset: 0x00F0 */
  __IO uint32_t IC13CFGR;         /*!< RCC IC13 configuration register                                Address offset: 0x00F4 */
  __IO uint32_t IC14CFGR;         /*!< RCC IC14 configuration register                                Address offset: 0x00F8 */
  __IO uint32_t IC15CFGR;         /*!< RCC IC15 configuration register                                Address offset: 0x00FC */
  __IO uint32_t IC16CFGR;         /*!< RCC IC16 configuration register                                Address offset: 0x0100 */
  __IO uint32_t IC17CFGR;         /*!< RCC IC17 configuration register                                Address offset: 0x0104 */
  __IO uint32_t IC18CFGR;         /*!< RCC IC18 configuration register                                Address offset: 0x0108 */
  __IO uint32_t IC19CFGR;         /*!< RCC IC19 configuration register                                Address offset: 0x010C */
  __IO uint32_t IC20CFGR;         /*!< RCC IC20 configuration register                                Address offset: 0x0110 */
       uint32_t RESERVED8[4];     /*!< Reserved                                                       Address offset: 0x0114-0x0120 */
  __IO uint32_t CIER;             /*!< RCC clock-source interrupt enable register                     Address offset: 0x0124 */
  __IO uint32_t CIFR;             /*!< RCC clock-source interrupt flag register                       Address offset: 0x0128 */
  __IO uint32_t CICR;             /*!< RCC clock-source interrupt clear register                      Address offset: 0x012C */
       uint32_t RESERVED9[5];     /*!< Reserved                                                       Address offset: 0x0130-0x0140 */
  __IO uint32_t CCIPR1;           /*!< RCC clock configuration for independent peripheral register 1  Address offset: 0x0144 */
  __IO uint32_t CCIPR2;           /*!< RCC clock configuration for independent peripheral register 2  Address offset: 0x0148 */
  __IO uint32_t CCIPR3;           /*!< RCC clock configuration for independent peripheral register 3  Address offset: 0x014C */
  __IO uint32_t CCIPR4;           /*!< RCC clock configuration for independent peripheral register 4  Address offset: 0x0150 */
  __IO uint32_t CCIPR5;           /*!< RCC clock configuration for independent peripheral register 5  Address offset: 0x0154 */
  __IO uint32_t CCIPR6;           /*!< RCC clock configuration for independent peripheral register 6  Address offset: 0x0158 */
  __IO uint32_t CCIPR7;           /*!< RCC clock configuration for independent peripheral register 7  Address offset: 0x015C */
  __IO uint32_t CCIPR8;           /*!< RCC clock configuration for independent peripheral register 8  Address offset: 0x0160 */
  __IO uint32_t CCIPR9;           /*!< RCC clock configuration for independent peripheral register 9  Address offset: 0x0164 */
       uint32_t RESERVED10[2];    /*!< Reserved                                                       Address offset: 0x0168-0x016C */
  __IO uint32_t CCIPR12;          /*!< RCC clock configuration for independent peripheral register 12 Address offset: 0x0170 */
  __IO uint32_t CCIPR13;          /*!< RCC clock configuration for independent peripheral register 13 Address offset: 0x0174 */
  __IO uint32_t CCIPR14;          /*!< RCC clock configuration for independent peripheral register 14 Address offset: 0x0178 */
       uint32_t RESERVED11[35];   /*!< Reserved                                                       Address offset: 0x017C-0x0204 */
  __IO uint32_t MISCRSTR;         /*!< RCC miscellaneous configurations reset register                Address offset: 0x0208 */
  __IO uint32_t MEMRSTR;          /*!< RCC embedded memories reset register                           Address offset: 0x020C */
  __IO uint32_t AHB1RSTR;         /*!< RCC AHB1 reset register                                        Address offset: 0x0210 */
  __IO uint32_t AHB2RSTR;         /*!< RCC AHB2 reset register                                        Address offset: 0x0214 */
  __IO uint32_t AHB3RSTR;         /*!< RCC AHB3 reset register                                        Address offset: 0x0218 */
  __IO uint32_t AHB4RSTR;         /*!< RCC AHB4 reset register                                        Address offset: 0x021C */
  __IO uint32_t AHB5RSTR;         /*!< RCC AHB5 reset register                                        Address offset: 0x0220 */
  __IO uint32_t APB1RSTR1;        /*!< RCC APB1 reset register 1                                      Address offset: 0x0224 */
  __IO uint32_t APB1RSTR2;        /*!< RCC APB1 reset register 2                                      Address offset: 0x0228 */
  __IO uint32_t APB2RSTR;         /*!< RCC APB2 reset register                                        Address offset: 0x022C */
       uint32_t RESERVED12;       /*!< Reserved                                                       Address offset: 0x0230 */
  __IO uint32_t APB4RSTR1;        /*!< RCC APB4 reset register 1                                      Address offset: 0x0234 */
  __IO uint32_t APB4RSTR2;        /*!< RCC APB4 reset register 2                                      Address offset: 0x0238 */
  __IO uint32_t APB5RSTR;         /*!< RCC APB5 reset register                                        Address offset: 0x023C */
  __IO uint32_t DIVENR;           /*!< RCC IC dividers enable register                                Address offset: 0x0240 */
  __IO uint32_t BUSENR;           /*!< RCC embedded buses enable register                             Address offset: 0x0244 */
  __IO uint32_t MISCENR;          /*!< RCC miscellaneous configurations enable register               Address offset: 0x0248 */
  __IO uint32_t MEMENR;           /*!< RCC embedded memories enable register                          Address offset: 0x024C */
  __IO uint32_t AHB1ENR;          /*!< RCC AHB1 enable register                                       Address offset: 0x0250 */
  __IO uint32_t AHB2ENR;          /*!< RCC AHB2 enable register                                       Address offset: 0x0254 */
  __IO uint32_t AHB3ENR;          /*!< RCC AHB3 enable register                                       Address offset: 0x0258 */
  __IO uint32_t AHB4ENR;          /*!< RCC AHB4 enable register                                       Address offset: 0x025C */
  __IO uint32_t AHB5ENR;          /*!< RCC AHB5 enable register                                       Address offset: 0x0260 */
  __IO uint32_t APB1ENR1;         /*!< RCC APB1 enable register 1                                     Address offset: 0x0264 */
  __IO uint32_t APB1ENR2;         /*!< RCC APB1 enable register 2                                     Address offset: 0x0268 */
  __IO uint32_t APB2ENR;          /*!< RCC APB2 enable register                                       Address offset: 0x026C */
  __IO uint32_t APB3ENR;          /*!< RCC APB3 enable register                                       Address offset: 0x0270 */
  __IO uint32_t APB4ENR1;         /*!< RCC APB4 enable register 1                                     Address offset: 0x0274 */
  __IO uint32_t APB4ENR2;         /*!< RCC APB4 enable register 2                                     Address offset: 0x0278 */
  __IO uint32_t APB5ENR;          /*!< RCC APB5 enable register                                       Address offset: 0x027C */
       uint32_t RESERVED13;       /*!< Reserved                                                       Address offset: 0x0280 */
  __IO uint32_t BUSLPENR;         /*!< RCC embedded buses sleep enable register                       Address offset: 0x0284 */
  __IO uint32_t MISCLPENR;        /*!< RCC miscellaneous configurations sleep enable register         Address offset: 0x0288 */
  __IO uint32_t MEMLPENR;         /*!< RCC embedded memories sleep enable register                    Address offset: 0x028C */
  __IO uint32_t AHB1LPENR;        /*!< RCC AHB1 sleep enable register                                 Address offset: 0x0290 */
  __IO uint32_t AHB2LPENR;        /*!< RCC AHB2 sleep enable register                                 Address offset: 0x0294 */
  __IO uint32_t AHB3LPENR;        /*!< RCC AHB3 sleep enable register                                 Address offset: 0x0298 */
  __IO uint32_t AHB4LPENR;        /*!< RCC AHB4 sleep enable register                                 Address offset: 0x029C */
  __IO uint32_t AHB5LPENR;        /*!< RCC AHB5 sleep enable register                                 Address offset: 0x02A0 */
  __IO uint32_t APB1LPENR1;       /*!< RCC APB1 sleep enable register 1                               Address offset: 0x02A4 */
  __IO uint32_t APB1LPENR2;       /*!< RCC APB1 sleep enable register 2                               Address offset: 0x02A8 */
  __IO uint32_t APB2LPENR;        /*!< RCC APB2 sleep enable register                                 Address offset: 0x02AC */
  __IO uint32_t APB3LPENR;        /*!< RCC APB3 sleep enable register                                 Address offset: 0x02B0 */
  __IO uint32_t APB4LPENR1;       /*!< RCC APB4 sleep enable register 1                               Address offset: 0x02B4 */
  __IO uint32_t APB4LPENR2;       /*!< RCC APB4 sleep enable register 2                               Address offset: 0x02B8 */
  __IO uint32_t APB5LPENR;        /*!< RCC APB5 sleep enable register                                 Address offset: 0x02BC */
       uint32_t RESERVED14[99];   /*!< Reserved                                                       Address offset: 0x02C0-0x0448 */
  __IO uint32_t RDCR;             /*!< RCC reset duration control register                            Address offset: 0x044C */
       uint32_t RESERVED15[204];  /*!< Reserved                                                       Address offset: 0x0450-0x077C */
  __IO uint32_t SECCFGR0;         /*!< RCC oscillator secure configuration register 0                 Address offset: 0x0780 */
  __IO uint32_t PRIVCFGR0;        /*!< RCC oscillator privilege configuration register 0              Address offset: 0x0784 */
  __IO uint32_t LOCKCFGR0;        /*!< RCC oscillator lock configuration register 0                   Address offset: 0x0788 */
  __IO uint32_t PUBCFGR0;         /*!< RCC oscillator public configuration register 0                 Address offset: 0x078C */
  __IO uint32_t SECCFGR1;         /*!< RCC PLL secure configuration register 1                        Address offset: 0x0790 */
  __IO uint32_t PRIVCFGR1;        /*!< RCC PLL privilege configuration register 1                     Address offset: 0x0794 */
  __IO uint32_t LOCKCFGR1;        /*!< RCC PLL lock configuration register 1                          Address offset: 0x0798 */
  __IO uint32_t PUBCFGR1;         /*!< RCC PLL public configuration register 1                        Address offset: 0x079C */
  __IO uint32_t SECCFGR2;         /*!< RCC divider secure configuration register 2                    Address offset: 0x07A0 */
  __IO uint32_t PRIVCFGR2;        /*!< RCC divider privilege configuration register 2                 Address offset: 0x07A4 */
  __IO uint32_t LOCKCFGR2;        /*!< RCC divider lock configuration register 2                      Address offset: 0x07A8 */
  __IO uint32_t PUBCFGR2;         /*!< RCC divider public configuration register 2                    Address offset: 0x07AC */
  __IO uint32_t SECCFGR3;         /*!< RCC system secure configuration register 3                     Address offset: 0x07B0 */
  __IO uint32_t PRIVCFGR3;        /*!< RCC system privilege configuration register 3                  Address offset: 0x07B4 */
  __IO uint32_t LOCKCFGR3;        /*!< RCC system lock configuration register 3                       Address offset: 0x07B8 */
  __IO uint32_t PUBCFGR3;         /*!< RCC system public configuration register 3                     Address offset: 0x07BC */
  __IO uint32_t SECCFGR4;         /*!< RCC bus secure configuration register 4                        Address offset: 0x07C0 */
  __IO uint32_t PRIVCFGR4;        /*!< RCC bus privilege configuration register 4                     Address offset: 0x07C4 */
  __IO uint32_t LOCKCFGR4;        /*!< RCC bus lock configuration register 4                          Address offset: 0x07C8 */
  __IO uint32_t PUBCFGR4;         /*!< RCC bus public configuration register 4                        Address offset: 0x07CC */
  __IO uint32_t PUBCFGR5;         /*!< RCC bus public configuration register 4                        Address offset: 0x07D0 */
       uint32_t RESERVED16[11];   /*!< Reserved                                                       Address offset: 0x07D4-0x07FC */
  __IO uint32_t CSR;              /*!< RCC control Set register                                       Address offset: 0x0800 */
       uint32_t RESERVED17;       /*!< Reserved                                                       Address offset: 0x0804 */
  __IO uint32_t STOPCSR;          /*!< RCC STOPCSR configuration register                             Address offset: 0x0808 */
       uint32_t RESERVED18[127];  /*!< Reserved                                                       Address offset: 0x080C-0x0A00 */
  __IO uint32_t MISCRSTSR;        /*!< RCC miscellaneous reset register                               Address offset: 0x0A08 */
  __IO uint32_t MEMRSTSR;         /*!< RCC memory reset register                                      Address offset: 0x0A0C */
  __IO uint32_t AHB1RSTSR;        /*!< RCC AHB1 reset register                                        Address offset: 0x0A10 */
  __IO uint32_t AHB2RSTSR;        /*!< RCC AHB2 reset register                                        Address offset: 0x0A14 */
  __IO uint32_t AHB3RSTSR;        /*!< RCC AHB3 reset register                                        Address offset: 0x0A18 */
  __IO uint32_t AHB4RSTSR;        /*!< RCC AHB4 reset register                                        Address offset: 0x0A1C */
  __IO uint32_t AHB5RSTSR;        /*!< RCC AHB5 reset register                                        Address offset: 0x0A20 */
  __IO uint32_t APB1RSTSR1;       /*!< RCC APB1 reset register 1                                      Address offset: 0x0A24 */
  __IO uint32_t APB1RSTSR2;       /*!< RCC APB1 reset register 2                                      Address offset: 0x0A28 */
  __IO uint32_t APB2RSTSR;        /*!< RCC APB2 reset register                                        Address offset: 0x0A2C */
       uint32_t RESERVED19;       /*!< Reserved                                                       Address offset: 0x0A30 */
  __IO uint32_t APB4RSTSR1;       /*!< RCC APB4 reset register 1                                      Address offset: 0x0A34 */
  __IO uint32_t APB4RSTSR2;       /*!< RCC APB4 reset register 2                                      Address offset: 0x0A38 */
  __IO uint32_t APB5RSTSR;        /*!< RCC APB5 reset register                                        Address offset: 0x0A3C */
  __IO uint32_t DIVENSR;          /*!< RCC divider enable register                                    Address offset: 0x0A40 */
  __IO uint32_t BUSENSR;          /*!< RCC bus enable register                                        Address offset: 0x0A44 */
  __IO uint32_t MISCENSR;         /*!< RCC miscellaneous enable register                              Address offset: 0x0A48 */
  __IO uint32_t MEMENSR;          /*!< RCC memory enable register                                     Address offset: 0x0A4C */
  __IO uint32_t AHB1ENSR;         /*!< RCC AHB1 enable register                                       Address offset: 0x0A50 */
  __IO uint32_t AHB2ENSR;         /*!< RCC AHB2 enable register                                       Address offset: 0x0A54 */
  __IO uint32_t AHB3ENSR;         /*!< RCC AHB3 enable register                                       Address offset: 0x0A58 */
  __IO uint32_t AHB4ENSR;         /*!< RCC AHB4 enable register                                       Address offset: 0x0A5C */
  __IO uint32_t AHB5ENSR;         /*!< RCC AHB5 enable register                                       Address offset: 0x0A60 */
  __IO uint32_t APB1ENSR1;        /*!< RCC APB1 enable register 1                                     Address offset: 0x0A64 */
  __IO uint32_t APB1ENSR2;        /*!< RCC APB1 enable register 2                                     Address offset: 0x0A68 */
  __IO uint32_t APB2ENSR;         /*!< RCC APB2 enable register                                       Address offset: 0x0A6C */
  __IO uint32_t APB3ENSR;         /*!< RCC APB3 enable register                                       Address offset: 0x0A70 */
  __IO uint32_t APB4ENSR1;        /*!< RCC APB4 enable register 1                                     Address offset: 0x0A74 */
  __IO uint32_t APB4ENSR2;        /*!< RCC APB4 enable register 2                                     Address offset: 0x0A78 */
  __IO uint32_t APB5ENSR;         /*!< RCC APB5 enable register                                       Address offset: 0x0A7C */
       uint32_t RESERVED20;       /*!< Reserved                                                       Address offset: 0x0A80 */
  __IO uint32_t BUSLPENSR;        /*!< RCC bus sleep enable register                                  Address offset: 0x0A84 */
  __IO uint32_t MISCLPENSR;       /*!< RCC miscellaneous sleep enable register                        Address offset: 0x0A88 */
  __IO uint32_t MEMLPENSR;        /*!< RCC memory sleep enable register                               Address offset: 0x0A8C */
  __IO uint32_t AHB1LPENSR;       /*!< RCC AHB1 sleep enable register                                 Address offset: 0x0A90 */
  __IO uint32_t AHB2LPENSR;       /*!< RCC AHB2 sleep enable register                                 Address offset: 0x0A94 */
  __IO uint32_t AHB3LPENSR;       /*!< RCC AHB3 sleep enable register                                 Address offset: 0x0A98 */
  __IO uint32_t AHB4LPENSR;       /*!< RCC AHB4 sleep enable register                                 Address offset: 0x0A9C */
  __IO uint32_t AHB5LPENSR;       /*!< RCC AHB5 sleep enable register                                 Address offset: 0x0AA0 */
  __IO uint32_t APB1LPENSR1;      /*!< RCC APB1 sleep enable register 1                               Address offset: 0x0AA4 */
  __IO uint32_t APB1LPENSR2;      /*!< RCC APB1 sleep enable register 2                               Address offset: 0x0AA8 */
  __IO uint32_t APB2LPENSR;       /*!< RCC APB2 sleep enable register                                 Address offset: 0x0AAC */
  __IO uint32_t APB3LPENSR;       /*!< RCC APB3 sleep enable register                                 Address offset: 0x0AB0 */
  __IO uint32_t APB4LPENSR1;      /*!< RCC APB4 sleep enable register 1                               Address offset: 0x0AB4 */
  __IO uint32_t APB4LPENSR2;      /*!< RCC APB4 sleep enable register 2                               Address offset: 0x0AB8 */
  __IO uint32_t APB5LPENSR;       /*!< RCC APB5 sleep enable register                                 Address offset: 0x0ABC */
       uint32_t RESERVED21[305];  /*!< Reserved                                                       Address offset: 0x0AC0-0x0F80 */
  __IO uint32_t PRIVCFGSR0;       /*!< RCC oscillator privilege configuration set register 0          Address offset: 0x0F84 */
       uint32_t RESERVED22;       /*!< Reserved                                                       Address offset: 0x0F88 */
  __IO uint32_t PUBCFGSR0;        /*!< RCC oscillator public configuration set register 0             Address offset: 0x0F8C */
       uint32_t RESERVED23;       /*!< Reserved                                                       Address offset: 0x0F90 */
  __IO uint32_t PRIVCFGSR1;       /*!< RCC PLL privilege configuration set register 1                 Address offset: 0x0F94 */
       uint32_t RESERVED24;       /*!< Reserved                                                       Address offset: 0x0F98 */
  __IO uint32_t PUBCFGSR1;        /*!< RCC PLL public configuration set register 1                    Address offset: 0x0F9C */
       uint32_t RESERVED25;       /*!< Reserved                                                       Address offset: 0x0FA0 */
  __IO uint32_t PRIVCFGSR2;       /*!< RCC divider privilege configuration set register 2             Address offset: 0x0FA4 */
       uint32_t RESERVED26;       /*!< Reserved                                                       Address offset: 0x0FA8 */
  __IO uint32_t PUBCFGSR2;        /*!< RCC divider public configuration set register 2                Address offset: 0x0FAC */
       uint32_t RESERVED27;       /*!< Reserved                                                       Address offset: 0x0FB0 */
  __IO uint32_t PRIVCFGSR3;       /*!< RCC system privilege configuration set register 3              Address offset: 0x0FB4 */
       uint32_t RESERVED28;       /*!< Reserved                                                       Address offset: 0x0FB8 */
  __IO uint32_t PUBCFGSR3;        /*!< RCC system public configuration set register 3                 Address offset: 0x0FBC */
       uint32_t RESERVED29;       /*!< Reserved                                                       Address offset: 0x0FC0 */
  __IO uint32_t PRIVCFGSR4;       /*!< RCC privilege configuration set register 4                     Address offset: 0x0FC4 */
       uint32_t RESERVED30;       /*!< Reserved                                                       Address offset: 0x0FC8 */
  __IO uint32_t PUBCFGSR4;        /*!< RCC public configuration set register 4                            Address offset: 0x0FCC */
  __IO uint32_t PUBCFGSR5;        /*!< RCC public configuration set register 5                            Address offset: 0x0FD0 */
       uint32_t RESERVED31[11];   /*!< Reserved                                                       Address offset: 0x0FD4-0x0FFC */
  __IO uint32_t CCR;              /*!< RCC control clear register                                     Address offset: 0x1000 */
       uint32_t RESERVED32;       /*!< Reserved                                                       Address offset: 0x1004 */
  __IO uint32_t STOPCCR;          /*!< RCC Stop mode configuration clear register                     Address offset: 0x1008 */
       uint32_t RESERVED33[127];  /*!< Reserved                                                       Address offset: 0x100C-0x1200 */
  __IO uint32_t MISCRSTCR;        /*!< RCC miscellaneous reset clear register                         Address offset: 0x1208 */
  __IO uint32_t MEMRSTCR;         /*!< RCC memory reset clear register                                Address offset: 0x120C */
  __IO uint32_t AHB1RSTCR;        /*!< RCC AHB1 reset clear register                                  Address offset: 0x1210 */
  __IO uint32_t AHB2RSTCR;        /*!< RCC AHB2 reset clear register                                  Address offset: 0x1214 */
  __IO uint32_t AHB3RSTCR;        /*!< RCC AHB3 reset r clear register                                Address offset: 0x1218 */
  __IO uint32_t AHB4RSTCR;        /*!< RCC AHB4 reset clear register                                  Address offset: 0x121C */
  __IO uint32_t AHB5RSTCR;        /*!< RCC AHB5 reset clear register                                  Address offset: 0x1220 */
  __IO uint32_t APB1RSTCR1;       /*!< RCC APB1 reset clear register 1                                Address offset: 0x1224 */
  __IO uint32_t APB1RSTCR2;       /*!< RCC APB1 reset clear register 2                                Address offset: 0x1228 */
  __IO uint32_t APB2RSTCR;        /*!< RCC APB2 reset clear register                                  Address offset: 0x122C */
       uint32_t RESERVED34;       /*!< Reserved                                                       Address offset: 0x1230 */
  __IO uint32_t APB4RSTCR1;       /*!< RCC APB4 reset clear register 1                                Address offset: 0x1234 */
  __IO uint32_t APB4RSTCR2;       /*!< RCC APB4 reset clear register 2                                Address offset: 0x1238 */
  __IO uint32_t APB5RSTCR;        /*!< RCC APB5 reset clear register                                  Address offset: 0x123C */
  __IO uint32_t DIVENCR;          /*!< RCC divider enable clear register                              Address offset: 0x1240 */
  __IO uint32_t BUSENCR;          /*!< RCC bus enable clear register                                  Address offset: 0x1244 */
  __IO uint32_t MISCENCR;         /*!< RCC miscellaneous enable clear register                        Address offset: 0x1248 */
  __IO uint32_t MEMENCR;          /*!< RCC memory enable clear register                               Address offset: 0x124C */
  __IO uint32_t AHB1ENCR;         /*!< RCC AHB1 enable clear register                                 Address offset: 0x1250 */
  __IO uint32_t AHB2ENCR;         /*!< RCC AHB2 enable clear register                                 Address offset: 0x1254 */
  __IO uint32_t AHB3ENCR;         /*!< RCC AHB3 enable clear register                                 Address offset: 0x1258 */
  __IO uint32_t AHB4ENCR;         /*!< RCC AHB4 enable clear register                                 Address offset: 0x125C */
  __IO uint32_t AHB5ENCR;         /*!< RCC AHB5 enable clear register                                 Address offset: 0x1260 */
  __IO uint32_t APB1ENCR1;        /*!< RCC APB1 enable clear register 1                               Address offset: 0x1264 */
  __IO uint32_t APB1ENCR2;        /*!< RCC APB1 enable clear register 2                               Address offset: 0x1268 */
  __IO uint32_t APB2ENCR;         /*!< RCC APB2 enable clear register                                 Address offset: 0x126C */
  __IO uint32_t APB3ENCR;         /*!< RCC APB3 enable clear register                                 Address offset: 0x1270 */
  __IO uint32_t APB4ENCR1;        /*!< RCC APB4 enable clear register 1                               Address offset: 0x1274 */
  __IO uint32_t APB4ENCR2;        /*!< RCC APB4 enable clear register 2                               Address offset: 0x1278 */
  __IO uint32_t APB5ENCR;         /*!< RCC APB5 enable clear register                                 Address offset: 0x127C */
       uint32_t RESERVED35;       /*!< Reserved                                                       Address offset: 0x1280 */
  __IO uint32_t BUSLPENCR;        /*!< RCC bus sleep enable clear register                            Address offset: 0x1284 */
  __IO uint32_t MISCLPENCR;       /*!< RCC miscellaneous sleep enable clear register                  Address offset: 0x1288 */
  __IO uint32_t MEMLPENCR;        /*!< RCC memory sleep enable clear register                         Address offset: 0x128C */
  __IO uint32_t AHB1LPENCR;       /*!< RCC AHB1 sleep enable clear register                           Address offset: 0x1290 */
  __IO uint32_t AHB2LPENCR;       /*!< RCC AHB2 sleep enable clear register                           Address offset: 0x1294 */
  __IO uint32_t AHB3LPENCR;       /*!< RCC AHB3 sleep enable clear register                           Address offset: 0x1298 */
  __IO uint32_t AHB4LPENCR;       /*!< RCC AHB4 sleep enable clear register                           Address offset: 0x129C */
  __IO uint32_t AHB5LPENCR;       /*!< RCC AHB5 sleep enable clear register                           Address offset: 0x12A0 */
  __IO uint32_t APB1LPENCR1;      /*!< RCC APB1 sleep enable clear register 1                         Address offset: 0x12A4 */
  __IO uint32_t APB1LPENCR2;      /*!< RCC APB1 sleep enable clear register 2                         Address offset: 0x12A8 */
  __IO uint32_t APB2LPENCR;       /*!< RCC APB2 sleep enable clear register                           Address offset: 0x12AC */
  __IO uint32_t APB3LPENCR;       /*!< RCC APB3 sleep enable clear register                           Address offset: 0x12B0 */
  __IO uint32_t APB4LPENCR1;      /*!< RCC APB4 sleep enable clear register 1                         Address offset: 0x12B4 */
  __IO uint32_t APB4LPENCR2;      /*!< RCC APB4 sleep enable clear register 2                         Address offset: 0x12B8 */
  __IO uint32_t APB5LPENCR;       /*!< RCC APB5 sleep enable clear register                           Address offset: 0x12BC */
       uint32_t RESERVED36[305];  /*!< Reserved                                                       Address offset: 0x12C0-0x1780 */
  __IO uint32_t PRIVCFGCR0;       /*!< RCC oscillator privilege configuration clear register 0        Address offset: 0x1784 */
       uint32_t RESERVED37;       /*!< Reserved                                                       Address offset: 0x1788 */
  __IO uint32_t PUBCFGCR0;        /*!< RCC oscillator public configuration clear register 0           Address offset: 0x178C */
       uint32_t RESERVED38;       /*!< Reserved                                                       Address offset: 0x1790 */
  __IO uint32_t PRIVCFGCR1;       /*!< RCC PLL privilege configuration clear register 1               Address offset: 0x1794 */
       uint32_t RESERVED39;       /*!< Reserved                                                       Address offset: 0x1798 */
  __IO uint32_t PUBCFGCR1;        /*!< RCC PLL public configuration clear register 1                  Address offset: 0x179C */
       uint32_t RESERVED40;       /*!< Reserved                                                       Address offset: 0x17A0 */
  __IO uint32_t PRIVCFGCR2;       /*!< RCC divider privilege configuration clear register 2           Address offset: 0x17A4 */
       uint32_t RESERVED41;       /*!< Reserved                                                       Address offset: 0x17A8 */
  __IO uint32_t PUBCFGCR2;        /*!< RCC divider public configuration clear register 2              Address offset: 0x17AC */
       uint32_t RESERVED42;       /*!< Reserved                                                       Address offset: 0x17B0 */
  __IO uint32_t PRIVCFGCR3;       /*!< RCC system privilege configuration clear register 3            Address offset: 0x17B4 */
       uint32_t RESERVED43;       /*!< Reserved                                                       Address offset: 0x17B8 */
  __IO uint32_t PUBCFGCR3;        /*!< RCC system public configuration clear register 3               Address offset: 0x17BC */
       uint32_t RESERVED44;       /*!< Reserved                                                       Address offset: 0x17C0 */
  __IO uint32_t PRIVCFGCR4;       /*!< RCC privilege configuration clear register 4                   Address offset: 0x17C4 */
       uint32_t RESERVED45;       /*!< Reserved                                                       Address offset: 0x17C8 */
  __IO uint32_t PUBCFGCR4;        /*!< RCC public configuration clear register 4                      Address offset: 0x17CC */
  __IO uint32_t PUBCFGCR5;        /*!< RCC public configuration clear register 5                      Address offset: 0x17D0 */
} RCC_TypeDef;

/*
 * @brief  RIFSC Resource Isolation Framework Security Controller (full version) (RIFSC User Spec Rev 1.1)
 */
typedef struct
{
  __IO uint32_t RISC_CR;            /*!< RIFSC RISC slave configuration register x               Address offset: 0x000 */
       uint32_t RESERVED0[3];       /*!< Reserved                                                Address offset: 0x004-0x00C */
  __IO uint32_t RISC_SECCFGRx[6];   /*!< RIFSC RISC slave security configuration register x      Address offset: 0x010-0x24 */
       uint32_t RESERVED1[2];       /*!< Reserved                                                Address offset: 0x028-0x02C */
  __IO uint32_t RISC_PRIVCFGRx[6];  /*!< RIFSC RISFC slave privileged register x                 Address offset: 0x030-0x44 */
       uint32_t RESERVED2[2];       /*!< Reserved                                                Address offset: 0x048-0x04C */
  __IO uint32_t RISC_RCFGLOCKRx[6]; /*!< RIFSC RISC slave resource configuration lock register x Address offset: 0x050 - 0x64 */
       uint32_t RESERVED3[742];     /*!< Reserved                                                Address offset: 0x068-0xBFC */
  __IO uint32_t RIMC_CR;            /*!< RIFSC RIMC master configuration register                Address offset: 0xC00 */
       uint32_t RESERVED4[3];       /*!< Reserved                                                Address offset: 0xC04-0xC0C */
  __IO uint32_t RIMC_ATTRx[13];     /*!< RIFSC RIMC master attribute register x                  Address offset: 0xC10-0xC40 */
       uint32_t RESERVED5[219];     /*!< Reserved                                                Address offset: 0xC40-0xFAC */
  __IO uint32_t PPSRx[6];           /*!< RIFSC peripheral protection status register x           Address offset: 0xFB0-0xFC4 */
       uint32_t RESERVED6[8];       /*!< Reserved                                                Address offset: 0xFC8-0xFE4 */
} RIFSC_TypeDef;

/**
  * @brief RISAF Resource Isolation Slave Unit for Address Space Protection (full version)
  */
typedef struct
{
  __IO uint32_t CFGR;          /*!< RISAF Region X configuration register             */
  __IO uint32_t STARTR;        /*!< RISAF Region X start address register             */
  __IO uint32_t ENDR;          /*!< RISAF Region X end address register               */
  __IO uint32_t CIDCFGR;       /*!< RISAF Region X CID configuration register         */
  __IO uint32_t ACFGR;         /*!< RISAF Region X subregion A configuration register */
  __IO uint32_t ASTARTR;       /*!< RISAF Region X subregion A start address register */
  __IO uint32_t AENDR;         /*!< RISAF Region X subregion A end address register   */
  __IO uint32_t ANESTR;        /*!< RISAF Region X subregion A nested mode register   */
  __IO uint32_t BCFGR;         /*!< RISAF Region X subregion B configuration register */
  __IO uint32_t BSTARTR;       /*!< RISAF Region X subregion B start address register */
  __IO uint32_t BENDR;         /*!< RISAF Region X subregion B end address register   */
  __IO uint32_t BNESTR;        /*!< RISAF Region X subregion B nested mode register   */
       uint32_t RESERVED0[4];  /*!< Reserved                                          */
} RISAF_Region_TypeDef;

/**
  * @brief RISAF Resource Isolation Slave Unit for Address Space Protection (full version) Illegal Access Register (RIF User Spec Rev 1.0.14)
  */
typedef struct
{
  __IO uint32_t IAESR;         /*!< RISAF Illegal access error status register */
  __IO uint32_t IADDR;         /*!< RISAF Illegal address register,            */
} RISAF_Illegal_TypeDef;

/**
  * @brief RISAF Resource Isolation Slave Unit for Address Space Protection (full version) (RIF User Spec Rev 1.0.14)
  */
typedef struct
{
  __IO uint32_t              CR;            /*!< RISAF Configuration register,                            Address offset: 0x000 */
  __IO uint32_t              RESERVED0;     /*!< Reserved,                                                Address offset: 0x004 */
  __IO uint32_t              IASR;          /*!< RISAF Illegal access status register,                    Address offset: 0x008 */
  __IO uint32_t              IACR;          /*!< RISAF Illegal access clear register,                     Address offset: 0x00C */
       uint32_t              RESERVED1[4];  /*!< Reserved,                                                          0x010-0x01C */
       RISAF_Illegal_TypeDef IAR[1];        /*!< RISAF Illegal access error status and address register,            0x020-0x024 */
       uint32_t              RESERVED2[6];  /*!< Reserved,                                                          0x028-0x03C */
       RISAF_Region_TypeDef  REG[15];       /*!< RISAF Region X configuration register,                             0x040-0x3FC */
} RISAF_TypeDef;

/**
  * @brief RNG
  */
typedef struct
{
  __IO uint32_t CR;  /*!< RNG control register, Address offset: 0x00 */
  __IO uint32_t SR;  /*!< RNG status register,  Address offset: 0x04 */
  __IO uint32_t DR;  /*!< RNG data register,    Address offset: 0x08 */
  uint32_t RESERVED;
  __IO uint32_t HTCR;  /*!< RNG health test configuration register, Address offset: 0x10 */
} RNG_TypeDef;

/*
* @brief RTC Specific device feature definitions
*/
#define RTC_BKP_NB         32U
#define RTC_TAMP_NB        7U

/**
 * @brief Real-Time Clock
 */
typedef struct
{
 __IO uint32_t TR;          /*!< RTC time register,                              Address offset: 0x00 */
 __IO uint32_t DR;          /*!< RTC date register,                              Address offset: 0x04 */
 __IO uint32_t SSR;         /*!< RTC sub second register,                        Address offset: 0x08 */
 __IO uint32_t ICSR;        /*!< RTC initialization control and status register, Address offset: 0x0C */
 __IO uint32_t PRER;        /*!< RTC prescaler register,                         Address offset: 0x10 */
 __IO uint32_t WUTR;        /*!< RTC wakeup timer register,                      Address offset: 0x14 */
 __IO uint32_t CR;          /*!< RTC control register,                           Address offset: 0x18 */
 __IO uint32_t PRIVCFGR;    /*!< RTC privilege mode control register,            Address offset: 0x1C */
__IO uint32_t SECCFGR;      /*!< RTC secure mode control register,               Address offset: 0x20 */
 __IO uint32_t WPR;         /*!< RTC write protection register,                  Address offset: 0x24 */
 __IO uint32_t CALR;        /*!< RTC calibration register,                       Address offset: 0x28 */
 __IO uint32_t SHIFTR;      /*!< RTC shift control register,                     Address offset: 0x2C */
 __IO uint32_t TSTR;        /*!< RTC time stamp time register,                   Address offset: 0x30 */
 __IO uint32_t TSDR;        /*!< RTC time stamp date register,                   Address offset: 0x34 */
 __IO uint32_t TSSSR;       /*!< RTC time-stamp sub second register,             Address offset: 0x38 */
      uint32_t RESERVED1;   /*!< Reserved,                                       Address offset: 0x3C */
 __IO uint32_t ALRMAR;      /*!< RTC alarm A register,                           Address offset: 0x40 */
 __IO uint32_t ALRMASSR;    /*!< RTC alarm A sub second register,                Address offset: 0x44 */
 __IO uint32_t ALRMBR;      /*!< RTC alarm B register,                           Address offset: 0x48 */
 __IO uint32_t ALRMBSSR;    /*!< RTC alarm B sub second register,                Address offset: 0x4C */
 __IO uint32_t SR;          /*!< RTC Status register,                            Address offset: 0x50 */
 __IO uint32_t MISR;        /*!< RTC masked interrupt status register,           Address offset: 0x54 */
 __IO uint32_t SMISR;       /*!< RTC secure masked interrupt status register,    Address offset: 0x58 */
 __IO uint32_t SCR;         /*!< RTC status Clear register,                      Address offset: 0x5C */
      uint32_t RESERVED3[4];/*!< Reserved,                                       Address offset: 0x58 */
 __IO uint32_t ALRABINR;    /*!< RTC alarm A binary mode register,               Address offset: 0x70 */
 __IO uint32_t ALRBBINR;    /*!< RTC alarm B binary mode register,               Address offset: 0x74 */
} RTC_TypeDef;

/**
  * @brief SAES Processor
  */
typedef struct
{
  __IO uint32_t CR;             /*!< SAES control register,                      Address offset: 0x000 */
  __IO uint32_t SR;             /*!< SAES status register,                       Address offset: 0x004 */
  __IO uint32_t DINR;           /*!< SAES data input register,                   Address offset: 0x008 */
  __IO uint32_t DOUTR;          /*!< SAES data output register,                  Address offset: 0x00C */
  __IO uint32_t KEYR0;          /*!< SAES key register 0,                        Address offset: 0x010 */
  __IO uint32_t KEYR1;          /*!< SAES key register 1,                        Address offset: 0x014 */
  __IO uint32_t KEYR2;          /*!< SAES key register 2,                        Address offset: 0x018 */
  __IO uint32_t KEYR3;          /*!< SAES key register 3,                        Address offset: 0x01C */
  __IO uint32_t IVR0;           /*!< SAES initialization vector register 0,      Address offset: 0x020 */
  __IO uint32_t IVR1;           /*!< SAES initialization vector register 1,      Address offset: 0x024 */
  __IO uint32_t IVR2;           /*!< SAES initialization vector register 2,      Address offset: 0x028 */
  __IO uint32_t IVR3;           /*!< SAES initialization vector register 3,      Address offset: 0x02C */
  __IO uint32_t KEYR4;          /*!< SAES key register 4,                        Address offset: 0x030 */
  __IO uint32_t KEYR5;          /*!< SAES key register 5,                        Address offset: 0x034 */
  __IO uint32_t KEYR6;          /*!< SAES key register 6,                        Address offset: 0x038 */
  __IO uint32_t KEYR7;          /*!< SAES key register 7,                        Address offset: 0x03C */
       uint32_t RESERVED1[48];  /*!< Reserved,                                   Address offset: 0x040 -- 0x0FC */
  __IO uint32_t DPACFGR;        /*!< SAES DPA configuration register,            Address offset: 0x100 */
       uint32_t RESERVED2[127]; /*!< Reserved,                                   Address offset: 0x104 -- 0x2FC */
  __IO uint32_t IER;            /*!< SAES Interrupt Enable Register,             Address offset: 0x300 */
  __IO uint32_t ISR;            /*!< SAES Interrupt Status Register,             Address offset: 0x304 */
  __IO uint32_t ICR;            /*!< SAES Interrupt Clear Register,              Address offset: 0x308 */
} SAES_TypeDef;

/**
  * @brief Serial Audio Interface
  */
typedef struct
{
  __IO uint32_t GCR;          /*!< SAI global configuration register,        Address offset: 0x00 */
  uint32_t      RESERVED[16]; /*!< Reserved,                         Address offset: 0x04 to 0x40 */
  __IO uint32_t PDMCR;        /*!< SAI PDM control register,                 Address offset: 0x44 */
  __IO uint32_t PDMDLY;       /*!< SAI PDM delay register,                   Address offset: 0x48 */
} SAI_TypeDef;

typedef struct
{
  __IO uint32_t CR1;         /*!< SAI block x configuration register 1,     Address offset: 0x04 */
  __IO uint32_t CR2;         /*!< SAI block x configuration register 2,     Address offset: 0x08 */
  __IO uint32_t FRCR;        /*!< SAI block x frame configuration register, Address offset: 0x0C */
  __IO uint32_t SLOTR;       /*!< SAI block x slot register,                Address offset: 0x10 */
  __IO uint32_t IMR;         /*!< SAI block x interrupt mask register,      Address offset: 0x14 */
  __IO uint32_t SR;          /*!< SAI block x status register,              Address offset: 0x18 */
  __IO uint32_t CLRFR;       /*!< SAI block x clear flag register,          Address offset: 0x1C */
  __IO uint32_t DR;          /*!< SAI block x data register,                Address offset: 0x20 */
} SAI_Block_TypeDef;

/**
  * @brief Secure digital input/output Interface
  */
typedef struct
{
  __IO uint32_t POWER;          /*!< SDMMC power control register,              Address offset: 0x00 */
  __IO uint32_t CLKCR;          /*!< SDMMC clock control register,              Address offset: 0x04 */
  __IO uint32_t ARG;            /*!< SDMMC argument register,                   Address offset: 0x08 */
  __IO uint32_t CMD;            /*!< SDMMC command register,                    Address offset: 0x0C */
  __I uint32_t  RESPCMD;        /*!< SDMMC command response register,           Address offset: 0x10 */
  __I uint32_t  RESP1;          /*!< SDMMC response 1 register,                 Address offset: 0x14 */
  __I uint32_t  RESP2;          /*!< SDMMC response 2 register,                 Address offset: 0x18 */
  __I uint32_t  RESP3;          /*!< SDMMC response 3 register,                 Address offset: 0x1C */
  __I uint32_t  RESP4;          /*!< SDMMC response 4 register,                 Address offset: 0x20 */
  __IO uint32_t DTIMER;         /*!< SDMMC data timer register,                 Address offset: 0x24 */
  __IO uint32_t DLEN;           /*!< SDMMC data length register,                Address offset: 0x28 */
  __IO uint32_t DCTRL;          /*!< SDMMC data control register,               Address offset: 0x2C */
  __I uint32_t  DCOUNT;         /*!< SDMMC data counter register,               Address offset: 0x30 */
  __I uint32_t  STA;            /*!< SDMMC status register,                     Address offset: 0x34 */
  __IO uint32_t ICR;            /*!< SDMMC interrupt clear register,            Address offset: 0x38 */
  __IO uint32_t MASK;           /*!< SDMMC mask register,                       Address offset: 0x3C */
  __IO uint32_t ACKTIME;        /*!< SDMMC Acknowledgement timer register,      Address offset: 0x40 */
  __IO uint32_t FIFOTHR;        /*!< SDMMC data FIFO threshold register,        Address offset: 0x44 */
  uint32_t      RESERVED0[2];   /*!< Reserved, 0x48 - 0x4C                                           */
  __IO uint32_t IDMACTRL;       /*!< SDMMC DMA control register,                Address offset: 0x50 */
  __IO uint32_t IDMABSIZE;      /*!< SDMMC DMA buffer size register,            Address offset: 0x54 */
  __IO uint32_t IDMABASER;      /*!< SDMMC DMA buffer base address register,    Address offset: 0x58 */
  uint32_t      RESERVED1[2];   /*!< Reserved, 0x5C - 0x60                                           */
  __IO uint32_t IDMALAR;        /*!< SDMMC DMA linked list address register,    Address offset: 0x64 */
  __IO uint32_t IDMABAR;        /*!< SDMMC DMA linked list memory base register,Address offset: 0x68 */
  uint32_t      RESERVED2[5];   /*!< Reserved, 0x6C-0x7C                                             */
  __IO uint32_t FIFO;           /*!< SDMMC data FIFO register,                  Address offset: 0x80 */
} SDMMC_TypeDef;

/**
  * @brief SPI
  */
typedef struct
{
  __IO uint32_t CR1;           /*!< SPI/I2S Control register 1,                      Address offset: 0x00 */
  __IO uint32_t CR2;           /*!< SPI Control register 2,                          Address offset: 0x04 */
  __IO uint32_t CFG1;          /*!< SPI Configuration register 1,                    Address offset: 0x08 */
  __IO uint32_t CFG2;          /*!< SPI Configuration register 2,                    Address offset: 0x0C */
  __IO uint32_t IER;           /*!< SPI/I2S Interrupt Enable register,               Address offset: 0x10 */
  __IO uint32_t SR;            /*!< SPI/I2S Status register,                         Address offset: 0x14 */
  __IO uint32_t IFCR;          /*!< SPI/I2S Interrupt/Status flags clear register,   Address offset: 0x18 */
  uint32_t      RESERVED0;     /*!< Reserved, 0x1C                                                        */
  __IO uint32_t TXDR;          /*!< SPI/I2S Transmit data register,                  Address offset: 0x20 */
  uint32_t      RESERVED1[3];  /*!< Reserved, 0x24-0x2C                                                   */
  __IO uint32_t RXDR;          /*!< SPI/I2S Receive data register,                   Address offset: 0x30 */
  uint32_t      RESERVED2[3];  /*!< Reserved, 0x34-0x3C                                                   */
  __IO uint32_t CRCPOLY;       /*!< SPI CRC Polynomial register,                     Address offset: 0x40 */
  __IO uint32_t TXCRC;         /*!< SPI Transmitter CRC register,                    Address offset: 0x44 */
  __IO uint32_t RXCRC;         /*!< SPI Receiver CRC register,                       Address offset: 0x48 */
  __IO uint32_t UDRDR;         /*!< SPI Underrun data register,                      Address offset: 0x4C */
  __IO uint32_t I2SCFGR;       /*!< I2S Configuration register,                      Address offset: 0x50 */
} SPI_TypeDef;


/**
  * @brief UCPD
  */
typedef struct
{
  __IO uint32_t CFG1;        /*!< UCPD configuration register 1,            Address offset: 0x00 */
  __IO uint32_t CFG2;        /*!< UCPD configuration register 2,            Address offset: 0x04 */
  __IO uint32_t RESERVED0;   /*!< UCPD reserved register,                   Address offset: 0x08 */
  __IO uint32_t CR;          /*!< UCPD control register,                    Address offset: 0x0C */
  __IO uint32_t IMR;         /*!< UCPD interrupt mask register,             Address offset: 0x10 */
  __IO uint32_t SR;          /*!< UCPD status register,                     Address offset: 0x14 */
  __IO uint32_t ICR;         /*!< UCPD interrupt flag clear register        Address offset: 0x18 */
  __IO uint32_t TX_ORDSET;   /*!< UCPD Tx ordered set type register,        Address offset: 0x1C */
  __IO uint32_t TX_PAYSZ;    /*!< UCPD Tx payload size register,            Address offset: 0x20 */
  __IO uint32_t TXDR;        /*!< UCPD Tx data register,                    Address offset: 0x24 */
  __IO uint32_t RX_ORDSET;   /*!< UCPD Rx ordered set type register,        Address offset: 0x28 */
  __IO uint32_t RX_PAYSZ;    /*!< UCPD Rx payload size register,            Address offset: 0x2C */
  __IO uint32_t RXDR;        /*!< UCPD Rx data register,                    Address offset: 0x30 */
  __IO uint32_t RX_ORDEXT1;  /*!< UCPD Rx ordered set extension 1 register, Address offset: 0x34 */
  __IO uint32_t RX_ORDEXT2;  /*!< UCPD Rx ordered set extension 2 register, Address offset: 0x38 */
} UCPD_TypeDef;

/**
  * @brief USB_OTG_Core_register
  */
typedef struct
{
  __IO uint32_t GOTGCTL;             /*!< USB_OTG Control and Status Register,       Address offset: 000h */
  __IO uint32_t GOTGINT;             /*!< USB_OTG Interrupt Register,                Address offset: 004h */
  __IO uint32_t GAHBCFG;             /*!< Core AHB Configuration Register,           Address offset: 008h */
  __IO uint32_t GUSBCFG;             /*!< Core USB Configuration Register,           Address offset: 00Ch */
  __IO uint32_t GRSTCTL;             /*!< Core Reset Register,                       Address offset: 010h */
  __IO uint32_t GINTSTS;             /*!< Core Interrupt Register,                   Address offset: 014h */
  __IO uint32_t GINTMSK;             /*!< Core Interrupt Mask Register,              Address offset: 018h */
  __IO uint32_t GRXSTSR;             /*!< Receive Sts Q Read Register,               Address offset: 01Ch */
  __IO uint32_t GRXSTSP;             /*!< Receive Sts Q Read & POP Register,         Address offset: 020h */
  __IO uint32_t GRXFSIZ;             /*!< Receive FIFO Size Register,                Address offset: 024h */
  __IO uint32_t DIEPTXF0_HNPTXFSIZ;  /*!< EP0 / Non Periodic Tx FIFO Size Register,  Address offset: 028h */
  __IO uint32_t HNPTXSTS;            /*!< Non Periodic Tx FIFO/Queue Sts reg,        Address offset: 02Ch */
  __IO uint32_t Reserved30[2];       /*!< Reserved,                                  Address offset: 030h */
  __IO uint32_t GCCFG;               /*!< General Purpose IO Register,               Address offset: 038h */
  __IO uint32_t CID;                 /*!< User ID Register,                          Address offset: 03Ch */
  __IO uint32_t GSNPSID;             /*!< USB_OTG core ID,                           Address offset: 040h */
  __IO uint32_t GHWCFG1;             /*!< User HW config1,                           Address offset: 044h */
  __IO uint32_t GHWCFG2;             /*!< User HW config2,                           Address offset: 048h */
  __IO uint32_t GHWCFG3;             /*!< User HW config3,                           Address offset: 04Ch */
  __IO uint32_t Reserved6;           /*!< Reserved,                                  Address offset: 050h */
  __IO uint32_t GLPMCFG;             /*!< LPM Register,                              Address offset: 054h */
  __IO uint32_t GPWRDN;              /*!< Power Down Register,                       Address offset: 058h */
  __IO uint32_t GDFIFOCFG;           /*!< DFIFO Software Config Register,            Address offset: 05Ch */
  __IO uint32_t GADPCTL;             /*!< ADP Timer, Control and Status Register,    Address offset: 60Ch */
  __IO uint32_t Reserved43[39];      /*!< Reserved,                                  Address offset: 058h */
  __IO uint32_t HPTXFSIZ;            /*!< Host Periodic Tx FIFO Size Reg,            Address offset: 100h */
  __IO uint32_t DIEPTXF[0x0F];       /*!< dev Periodic Transmit FIFO                 Address offset: 104h */
} USB_OTG_GlobalTypeDef;

typedef struct
{
  __IO uint32_t USBPHYC_CR;          /*!< USB_OTG Control and Status Register,       Address offset: 000h */
  __IO uint32_t USBPHYC_TRIM1CR;     /*!< USB_OTG Interrupt Register,                Address offset: 004h */
  __IO uint32_t USBPHYC_TRIM2CR;     /*!< Core AHB Configuration Register,           Address offset: 008h */
} USB_PHY_GlobalTypeDef;

/**
  * @brief USB_OTG_device_Registers
  */
typedef struct
{
  __IO uint32_t DCFG;                /*!< dev Configuration Register,   Address offset: 800h */
  __IO uint32_t DCTL;                /*!< dev Control Register,         Address offset: 804h */
  __IO uint32_t DSTS;                /*!< dev Status Register (RO),     Address offset: 808h */
  __IO uint32_t Reserved0C;          /*!< Reserved,                     Address offset: 80Ch */
  __IO uint32_t DIEPMSK;             /*!< dev IN Endpoint Mask,         Address offset: 810h */
  __IO uint32_t DOEPMSK;             /*!< dev OUT Endpoint Mask,        Address offset: 814h */
  __IO uint32_t DAINT;               /*!< dev All Endpoints Itr Reg,    Address offset: 818h */
  __IO uint32_t DAINTMSK;            /*!< dev All Endpoints Itr Mask,   Address offset: 81Ch */
  __IO uint32_t Reserved20;          /*!< Reserved,                     Address offset: 820h */
  __IO uint32_t Reserved9;           /*!< Reserved,                     Address offset: 824h */
  __IO uint32_t DVBUSDIS;            /*!< dev VBUS discharge Register,  Address offset: 828h */
  __IO uint32_t DVBUSPULSE;          /*!< dev VBUS Pulse Register,      Address offset: 82Ch */
  __IO uint32_t DTHRCTL;             /*!< dev threshold,                Address offset: 830h */
  __IO uint32_t DIEPEMPMSK;          /*!< dev empty msk,                Address offset: 834h */
  __IO uint32_t DEACHINT;            /*!< dedicated EP interrupt,       Address offset: 838h */
  __IO uint32_t DEACHMSK;            /*!< dedicated EP msk,             Address offset: 83Ch */
  __IO uint32_t Reserved40;          /*!< dedicated EP mask,            Address offset: 840h */
  __IO uint32_t DINEP1MSK;           /*!< dedicated EP mask,            Address offset: 844h */
  __IO uint32_t Reserved44[15];      /*!< Reserved,                     Address offset: 844-87Ch */
  __IO uint32_t DOUTEP1MSK;          /*!< dedicated EP msk,             Address offset: 884h */
} USB_OTG_DeviceTypeDef;

/**
  * @brief USB_OTG_IN_Endpoint-Specific_Register
  */
typedef struct
{
  __IO uint32_t DIEPCTL;             /*!< dev IN Endpoint Control Register,          Address offset: 900h + (ep_num * 20h) + 00h */
  __IO uint32_t Reserved04;          /*!< Reserved,                                  Address offset: 900h + (ep_num * 20h) + 04h */
  __IO uint32_t DIEPINT;             /*!< dev IN Endpoint Itr Register,              Address offset: 900h + (ep_num * 20h) + 08h */
  __IO uint32_t Reserved0C;          /*!< Reserved,                                  Address offset: 900h + (ep_num * 20h) + 0Ch */
  __IO uint32_t DIEPTSIZ;            /*!< IN Endpoint Txfer Size Register,           Address offset: 900h + (ep_num * 20h) + 10h */
  __IO uint32_t DIEPDMA;             /*!< IN Endpoint DMA Address Register,          Address offset: 900h + (ep_num * 20h) + 14h */
  __IO uint32_t DTXFSTS;             /*!< IN Endpoint Tx FIFO Status Register,       Address offset: 900h + (ep_num * 20h) + 18h */
  __IO uint32_t Reserved18;          /*!< Reserved,                                  Address offset: 900h + (ep_num * 20h) + 1Ch */
} USB_OTG_INEndpointTypeDef;

/**
  * @brief USB_OTG_OUT_Endpoint-Specific_Registers
  */
typedef struct
{
  __IO uint32_t DOEPCTL;             /*!< dev OUT Endpoint Control Register,         Address offset: B00h + (ep_num * 20h) + 00h */
  __IO uint32_t Reserved04;          /*!< Reserved,                                  Address offset: B00h + (ep_num * 20h) + 04h */
  __IO uint32_t DOEPINT;             /*!< dev OUT Endpoint Itr Register,             Address offset: B00h + (ep_num * 20h) + 08h */
  __IO uint32_t Reserved0C;          /*!< Reserved,                                  Address offset: B00h + (ep_num * 20h) + 0Ch */
  __IO uint32_t DOEPTSIZ;            /*!< dev OUT Endpoint Txfer Size Register,      Address offset: B00h + (ep_num * 20h) + 10h */
  __IO uint32_t DOEPDMA;             /*!< dev OUT Endpoint DMA Address Register,     Address offset: B00h + (ep_num * 20h) + 14h */
  __IO uint32_t Reserved18[2];       /*!< Reserved,                                  Address offset: B00h + (ep_num * 20h) + 18h */
} USB_OTG_OUTEndpointTypeDef;

/**
  * @brief USB_OTG_Host_Mode_Register_Structures
  */
typedef struct
{
  __IO uint32_t HCFG;                 /*!< Host Configuration Register,              Address offset: 400h */
  __IO uint32_t HFIR;                 /*!< Host Frame Interval Register,             Address offset: 404h */
  __IO uint32_t HFNUM;                /*!< Host Frame Nbr/Frame Remaining,           Address offset: 408h */
  __IO uint32_t Reserved40C;          /*!< Reserved,                                 Address offset: 40Ch */
  __IO uint32_t HPTXSTS;              /*!< Host Periodic Tx FIFO/ Queue Status,      Address offset: 410h */
  __IO uint32_t HAINT;                /*!< Host All Channels Interrupt Register,     Address offset: 414h */
  __IO uint32_t HAINTMSK;             /*!< Host All Channels Interrupt Mask,         Address offset: 418h */
} USB_OTG_HostTypeDef;

/**
  * @brief USB_OTG_Host_Channel_Specific_Registers
  */
typedef struct
{
  __IO uint32_t HCCHAR;               /*!< Host Channel Characteristics Register,    Address offset: 500h */
  __IO uint32_t HCSPLT;               /*!< Host Channel Split Control Register,      Address offset: 504h */
  __IO uint32_t HCINT;                /*!< Host Channel Interrupt Register,          Address offset: 508h */
  __IO uint32_t HCINTMSK;             /*!< Host Channel Interrupt Mask Register,     Address offset: 50Ch */
  __IO uint32_t HCTSIZ;               /*!< Host Channel Transfer Size Register,      Address offset: 510h */
  __IO uint32_t HCDMA;                /*!< Host Channel DMA Address Register,        Address offset: 514h */
  uint32_t Reserved[2];               /*!< Reserved,                                 Address offset: 518h */
} USB_OTG_HostChannelTypeDef;

typedef struct
{
  __IO uint32_t USBPHYC_CR;           /*!< USB HS PHY Control Register,              Address offset: 000h */
  __IO uint32_t USBPHYC_TRIM1CR;      /*!< USB HS PHY Trimming_1 Register,           Address offset: 004h */
  __IO uint32_t USBPHYC_TRIM2CR;      /*!< USB HS PHY Trimming_2 Register,           Address offset: 008h */
} USB_HS_PHYC_GlobalTypeDef;

/**
  * @brief SPDIF-RX Interface
  */
typedef struct
{
  __IO uint32_t CR;          /*!< Control register,                   Address offset: 0x00 */
  __IO uint32_t IMR;         /*!< Interrupt mask register,            Address offset: 0x04 */
  __IO uint32_t SR;          /*!< Status register,                    Address offset: 0x08 */
  __IO uint32_t IFCR;        /*!< Interrupt Flag Clear register,      Address offset: 0x0C */
  __IO uint32_t DR;          /*!< Data input register,                Address offset: 0x10 */
  __IO uint32_t CSR;         /*!< Channel Status register,            Address offset: 0x14 */
  __IO uint32_t DIR;         /*!< Debug Information register,         Address offset: 0x18 */
} SPDIFRX_TypeDef;


/**
  * @brief System configuration controller
  */
typedef struct
{
  __IO uint32_t BOOTCR;         /*!< SYSCFG boot pin control register,                                            Address offset: 0x00 */
  __IO uint32_t CM55CR;         /*!< SYSCFG Cortex-M55 control register,                                          Address offset: 0x04 */
  __IO uint32_t CM55TCMCR;      /*!< SYSCFG Cortex-M55 TCM control register,                                      Address offset: 0x08 */
  __IO uint32_t CM55RWMCR;      /*!< SYSCFG Cortex-M55 memory RW margin register,                                 Address offset: 0x0C */
  __IO uint32_t INITSVTORCR;    /*!< SYSCFG Cortex-M55 SVTOR control register,                                    Address offset: 0x10 */
  __IO uint32_t INITNSVTORCR;   /*!< Cortex-M55 NSVTOR control register,                                          Address offset: 0x14 */
  __IO uint32_t CM55RSTCR;      /*!< SYSCFG Cortex-M55 reset type control register,                               Address offset: 0x18 */
  __IO uint32_t CM55PAHBWPR;    /*!< SYSCFG Cortex-M55 P-AHB write posting control register,                      Address offset: 0x1C */
  __IO uint32_t VENCRAMCR;      /*!< SYSCFG VENCRAM control register,                                             Address offset: 0x20 */
  __IO uint32_t POTTAMPRSTCR;   /*!< SYSCFG potential tamper reset register,                                      Address offset: 0x24 */
  __IO uint32_t NPUNICQOSCR;    /*!< SYSCFG NPUNIC QoS control register,                                          Address offset: 0x28 */
  uint32_t      RESERVED1[2];   /*!< Reserved,                                                                    Address offset: 0x2C-0x30 */
  __IO uint32_t ICNEWRCR;       /*!< SYSCFG AHB-AXI bridge early write response,                                  Address offset: 0x34 */
  __IO uint32_t ICNCGCR;        /*!< SYSCFG ICN clock gating control register,                                    Address offset: 0x38 */
  uint32_t      RESERVED2[2];   /*!< Reserved,                                                                    Address offset: 0x3C-0x40 */
  __IO uint32_t VDDIO4CCCR;     /*!< SYSCFG VDDIO4 compensation cell control register,                            Address offset: 0x44 */
  __IO uint32_t VDDIO4CCSR;     /*!< SYSCFG VDDIO4 compensation cell status register,                             Address offset: 0x48 */
  __IO uint32_t VDDIO5CCCR;     /*!< SYSCFG VDDIO5 compensation cell control register,                            Address offset: 0x4C */
  __IO uint32_t VDDIO5CCSR;     /*!< SYSCFG VDDIO5 compensation cell status register,                             Address offset: 0x50 */
  __IO uint32_t VDDIO2CCCR;     /*!< SYSCFG VDDIO2 compensation cell control register,                            Address offset: 0x54 */
  __IO uint32_t VDDIO2CCSR;     /*!< SYSCFG VDDIO2 compensation cell status register,                             Address offset: 0x58 */
  __IO uint32_t VDDIO3CCCR;     /*!< SYSCFG VDDIO3 compensation cell control register,                            Address offset: 0x5C */
  __IO uint32_t VDDIO3CCSR;     /*!< SYSCFG VDDIO3 compensation cell status register,                             Address offset: 0x60 */
  __IO uint32_t VDDCCCR;        /*!< SYSCFG VDD compensation cell control register,                               Address offset: 0x64 */
  __IO uint32_t VDDCCSR;        /*!< SYSCFG VDD compensation cell status register,                                Address offset: 0x68 */
  __IO uint32_t CBR;            /*!< SYSCFG control timer break register,                                         Address offset: 0x6C */
  __IO uint32_t SEC_AIDCR;      /*!< SYSCFG DMA CID secure control register,                                      Address offset: 0x70 */
  __IO uint32_t FMC_RETIMECR;   /*!< SYSCFG FMC retiming logic control register,                                  Address offset: 0x74 */
  __IO uint32_t NPU_ICNCR;      /*!< SYSCFG NPU RAM interleaving control register,                                Address offset: 0x78 */
  uint32_t      RESERVED3[33];  /*!< Reserved,                                                                    Address offset: 0x7C-0xFC */
  __IO uint32_t BOOTSR;         /*!< SYSCFG boot pin status register,                                             Address offset: 0x100 */
  __IO uint32_t AHBWP_ERROR_SR; /*!< SYSCFG AHB write posting address error register,                             Address offset: 0x104 */
  uint32_t      RESERVED4[446]; /*!< Reserved,                                                                    Address offset: 0x108-0x3FC */
  __IO uint32_t SECPRIV_AIDCR;  /*!< SYSCFG DMA CID non-secure control register,                                  Address offset: 0x800 */
  uint32_t      RESERVED5[507]; /*!< Reserved,                                                                    Address offset: 0x804-0xFEC */
  __IO uint32_t DEVICEID;       /*!< SYSCFG Device ID,                                                            Address offset: 0xFF0 */
} SYSCFG_TypeDef;

/**
 * @brief Tamper and backup registers
 */
typedef struct
{
 __IO uint32_t CR1;           /*!< TAMP configuration register 1,                    Address offset: 0x00 */
 __IO uint32_t CR2;           /*!< TAMP configuration register 2,                    Address offset: 0x04 */
 __IO uint32_t CR3;           /*!< TAMP configuration register 3,                    Address offset: 0x08 */
 __IO uint32_t FLTCR;         /*!< TAMP filter control register,                     Address offset: 0x0C */
 __IO uint32_t ATCR1;         /*!< TAMP filter control register 1                    Address offset: 0x10 */
 __IO uint32_t ATSEEDR;       /*!< TAMP active tamper seed register,                 Address offset: 0x14 */
 __IO uint32_t ATOR;          /*!< TAMP active tamper output register,               Address offset: 0x18 */
 __IO uint32_t ATCR2;         /*!< TAMP filter control register 2,                   Address offset: 0x1C */
 __IO uint32_t SECCFGR;       /*!< TAMP secure mode control register,                Address offset: 0x20 */
 __IO uint32_t PRIVCFGR;      /*!< TAMP privilege mode control register,             Address offset: 0x24 */
      uint32_t RESERVED2;     /*!< Reserved,                                         Address offset: 0x28 */
 __IO uint32_t IER;           /*!< TAMP interrupt enable register,                   Address offset: 0x2C */
 __IO uint32_t SR;            /*!< TAMP status register,                             Address offset: 0x30 */
 __IO uint32_t MISR;          /*!< TAMP masked interrupt status register,            Address offset: 0x34 */
 __IO uint32_t SMISR;         /*!< TAMP secure masked interrupt status register,     Address offset: 0x38 */
 __IO uint32_t SCR;           /*!< TAMP status clear register,                       Address offset: 0x3C */
 __IO uint32_t COUNT1R;       /*!< TAMP monotonic counter register,                  Address offset: 0x40 */
      uint32_t RESERVED4[3];  /*!< Reserved,                                         Address offset: 0x43 -- 0x4C */
 __IO uint32_t OR;            /*!< TAMP option register,                             Address offset: 0x50 */
 __IO uint32_t RPCFGR;        /*!< TAMP resources protection configuration register, Address offset: 0x54 */
      uint32_t RESERVED5[42]; /*!< Reserved,                                         Address offset: 0x58 -- 0xFC */
 __IO uint32_t BKP0R;         /*!< TAMP backup register 0,                           Address offset: 0x100 */
 __IO uint32_t BKP1R;         /*!< TAMP backup register 1,                           Address offset: 0x104 */
 __IO uint32_t BKP2R;         /*!< TAMP backup register 2,                           Address offset: 0x108 */
 __IO uint32_t BKP3R;         /*!< TAMP backup register 3,                           Address offset: 0x10C */
 __IO uint32_t BKP4R;         /*!< TAMP backup register 4,                           Address offset: 0x110 */
 __IO uint32_t BKP5R;         /*!< TAMP backup register 5,                           Address offset: 0x114 */
 __IO uint32_t BKP6R;         /*!< TAMP backup register 6,                           Address offset: 0x118 */
 __IO uint32_t BKP7R;         /*!< TAMP backup register 7,                           Address offset: 0x11C */
 __IO uint32_t BKP8R;         /*!< TAMP backup register 8,                           Address offset: 0x120 */
 __IO uint32_t BKP9R;         /*!< TAMP backup register 9,                           Address offset: 0x124 */
 __IO uint32_t BKP10R;        /*!< TAMP backup register 10,                          Address offset: 0x128 */
 __IO uint32_t BKP11R;        /*!< TAMP backup register 11,                          Address offset: 0x12C */
 __IO uint32_t BKP12R;        /*!< TAMP backup register 12,                          Address offset: 0x130 */
 __IO uint32_t BKP13R;        /*!< TAMP backup register 13,                          Address offset: 0x134 */
 __IO uint32_t BKP14R;        /*!< TAMP backup register 14,                          Address offset: 0x138 */
 __IO uint32_t BKP15R;        /*!< TAMP backup register 15,                          Address offset: 0x13C */
 __IO uint32_t BKP16R;        /*!< TAMP backup register 16,                          Address offset: 0x140 */
 __IO uint32_t BKP17R;        /*!< TAMP backup register 17,                          Address offset: 0x144 */
 __IO uint32_t BKP18R;        /*!< TAMP backup register 18,                          Address offset: 0x148 */
 __IO uint32_t BKP19R;        /*!< TAMP backup register 19,                          Address offset: 0x14C */
 __IO uint32_t BKP20R;        /*!< TAMP backup register 20,                          Address offset: 0x150 */
 __IO uint32_t BKP21R;        /*!< TAMP backup register 21,                          Address offset: 0x154 */
 __IO uint32_t BKP22R;        /*!< TAMP backup register 22,                          Address offset: 0x158 */
 __IO uint32_t BKP23R;        /*!< TAMP backup register 23,                          Address offset: 0x15C */
 __IO uint32_t BKP24R;        /*!< TAMP backup register 24,                          Address offset: 0x160 */
 __IO uint32_t BKP25R;        /*!< TAMP backup register 25,                          Address offset: 0x164 */
 __IO uint32_t BKP26R;        /*!< TAMP backup register 26,                          Address offset: 0x168 */
 __IO uint32_t BKP27R;        /*!< TAMP backup register 27,                          Address offset: 0x16C */
 __IO uint32_t BKP28R;        /*!< TAMP backup register 28,                          Address offset: 0x170 */
 __IO uint32_t BKP29R;        /*!< TAMP backup register 29,                          Address offset: 0x174 */
 __IO uint32_t BKP30R;        /*!< TAMP backup register 30,                          Address offset: 0x178 */
 __IO uint32_t BKP31R;        /*!< TAMP backup register 31,                          Address offset: 0x17C */
} TAMP_TypeDef;

/**
  * @brief TIM
  */
typedef struct
{
  __IO uint32_t CR1;            /*!< TIM control register 1,                   Address offset:  0x00 */
  __IO uint32_t CR2;            /*!< TIM control register 2,                   Address offset:  0x04 */
  __IO uint32_t SMCR;           /*!< TIM slave mode control register,          Address offset:  0x08 */
  __IO uint32_t DIER;           /*!< TIM DMA/interrupt enable register,        Address offset:  0x0C */
  __IO uint32_t SR;             /*!< TIM status register,                      Address offset:  0x10 */
  __IO uint32_t EGR;            /*!< TIM event generation register,            Address offset:  0x14 */
  __IO uint32_t CCMR1;          /*!< TIM capture/compare mode register 1,      Address offset:  0x18 */
  __IO uint32_t CCMR2;          /*!< TIM capture/compare mode register 2,      Address offset:  0x1C */
  __IO uint32_t CCER;           /*!< TIM capture/compare enable register,      Address offset:  0x20 */
  __IO uint32_t CNT;            /*!< TIM counter register,                     Address offset:  0x24 */
  __IO uint32_t PSC;            /*!< TIM prescaler,                            Address offset:  0x28 */
  __IO uint32_t ARR;            /*!< TIM auto-reload register,                 Address offset:  0x2C */
  __IO uint32_t RCR;            /*!< TIM repetition counter register,          Address offset:  0x30 */
  __IO uint32_t CCR1;           /*!< TIM capture/compare register 1,           Address offset:  0x34 */
  __IO uint32_t CCR2;           /*!< TIM capture/compare register 2,           Address offset:  0x38 */
  __IO uint32_t CCR3;           /*!< TIM capture/compare register 3,           Address offset:  0x3C */
  __IO uint32_t CCR4;           /*!< TIM capture/compare register 4,           Address offset:  0x40 */
  __IO uint32_t BDTR;           /*!< TIM break and dead-time register,         Address offset:  0x44 */
  __IO uint32_t CCR5;           /*!< TIM capture/compare register 5,           Address offset:  0x48 */
  __IO uint32_t CCR6;           /*!< TIM capture/compare register 6,           Address offset:  0x4C */
  __IO uint32_t CCMR3;          /*!< TIM capture/compare mode register 3,      Address offset:  0x50 */
  __IO uint32_t DTR2;           /*!< TIM deadtime register 2,                  Address offset:  0x54 */
  __IO uint32_t ECR;            /*!< TIM encoder control register,             Address offset:  0x58 */
  __IO uint32_t TISEL;          /*!< TIM Input Selection register,             Address offset:  0x5C */
  __IO uint32_t AF1;            /*!< TIM alternate function option register 1, Address offset:  0x60 */
  __IO uint32_t AF2;            /*!< TIM alternate function option register 2, Address offset:  0x64 */
       uint32_t RESERVED1[221]; /*!< Reserved,                                            0x6C-0x3D8 */
  __IO uint32_t DCR;            /*!< TIM DMA control register,                 Address offset: 0x3DC */
  __IO uint32_t DMAR;           /*!< TIM DMA address for full transfer,        Address offset: 0x3E0 */
} TIM_TypeDef;


/**
  * @brief Universal Synchronous Asynchronous Receiver Transmitter
  */
typedef struct
{
  __IO uint32_t CR1;         /*!< USART Control register 1,                 Address offset: 0x00 */
  __IO uint32_t CR2;         /*!< USART Control register 2,                 Address offset: 0x04 */
  __IO uint32_t CR3;         /*!< USART Control register 3,                 Address offset: 0x08 */
  __IO uint32_t BRR;         /*!< USART Baud rate register,                 Address offset: 0x0C */
  __IO uint32_t GTPR;        /*!< USART Guard time and prescaler register,  Address offset: 0x10 */
  __IO uint32_t RTOR;        /*!< USART Receiver Time Out register,         Address offset: 0x14 */
  __IO uint32_t RQR;         /*!< USART Request register,                   Address offset: 0x18 */
  __IO uint32_t ISR;         /*!< USART Interrupt and status register,      Address offset: 0x1C */
  __IO uint32_t ICR;         /*!< USART Interrupt flag Clear register,      Address offset: 0x20 */
  __IO uint32_t RDR;         /*!< USART Receive Data register,              Address offset: 0x24 */
  __IO uint32_t TDR;         /*!< USART Transmit Data register,             Address offset: 0x28 */
  __IO uint32_t PRESC;       /*!< USART Prescaler register,                 Address offset: 0x2C */
} USART_TypeDef;


/**
  * @brief VREFBUF
  */
typedef struct
{
  __IO uint32_t CSR;         /*!< VREFBUF control and status register,         Address offset: 0x00 */
  __IO uint32_t CCR;         /*!< VREFBUF calibration and control register,    Address offset: 0x04 */
} VREFBUF_TypeDef;


/**
  * @brief Window Watchdog
  */
typedef struct
{
  __IO uint32_t CR;          /*!< WWDG Control register,              Address offset: 0x00 */
  __IO uint32_t CFR;         /*!< WWDG Configuration register,        Address offset: 0x04 */
  __IO uint32_t SR;          /*!< WWDG Status register,               Address offset: 0x08 */
} WWDG_TypeDef;

/**
  * @brief Extended-SPI Interface
  */
typedef struct
{
  __IO uint32_t CR;             /*!< XSPI Control Register,                                Address offset: 0x000         */
       uint32_t RESERVED1;      /*!< Reserved,                                             Address offset: 0x004         */
  __IO uint32_t DCR1;           /*!< XSPI Device Configuration Register 1,                 Address offset: 0x008         */
  __IO uint32_t DCR2;           /*!< XSPI Device Configuration Register 2,                 Address offset: 0x00C         */
  __IO uint32_t DCR3;           /*!< XSPI Device Configuration Register 3,                 Address offset: 0x010         */
  __IO uint32_t DCR4;           /*!< XSPI Device Configuration Register 4,                 Address offset: 0x014         */
       uint32_t RESERVED2[2];   /*!< Reserved,                                             Address offset: 0x018 - 0x01C */
  __IO uint32_t SR;             /*!< XSPI Status Register,                                 Address offset: 0x020         */
  __IO uint32_t FCR;            /*!< XSPI Flag Clear Register,                             Address offset: 0x024         */
       uint32_t RESERVED3[6];   /*!< Reserved,                                             Address offset: 0x028 - 0x03C */
  __IO uint32_t DLR;            /*!< XSPI Data Length Register,                            Address offset: 0x040         */
       uint32_t RESERVED4;      /*!< Reserved,                                             Address offset: 0x044         */
  __IO uint32_t AR;             /*!< XSPI Address Register,                                Address offset: 0x048         */
       uint32_t RESERVED5;      /*!< Reserved,                                             Address offset: 0x04C         */
  __IO uint32_t DR;             /*!< XSPI Data Register,                                   Address offset: 0x050         */
       uint32_t RESERVED6[11];  /*!< Reserved,                                             Address offset: 0x054 - 0x07C */
  __IO uint32_t PSMKR;          /*!< XSPI Polling Status Mask Register,                    Address offset: 0x080         */
       uint32_t RESERVED7;      /*!< Reserved,                                             Address offset: 0x084         */
  __IO uint32_t PSMAR;          /*!< XSPI Polling Status Match Register,                   Address offset: 0x088         */
       uint32_t RESERVED8;      /*!< Reserved,                                             Address offset: 0x08C         */
  __IO uint32_t PIR;            /*!< XSPI Polling Interval Register,                       Address offset: 0x090         */
       uint32_t RESERVED9[27];  /*!< Reserved,                                             Address offset: 0x094 - 0x0FC */
  __IO uint32_t CCR;            /*!< XSPI Communication Configuration Register,            Address offset: 0x100         */
       uint32_t RESERVED10;     /*!< Reserved,                                             Address offset: 0x104         */
  __IO uint32_t TCR;            /*!< XSPI Timing Configuration Register,                   Address offset: 0x108         */
       uint32_t RESERVED11;     /*!< Reserved,                                             Address offset: 0x10C         */
  __IO uint32_t IR;             /*!< XSPI Instruction Register,                            Address offset: 0x110         */
       uint32_t RESERVED12[3];  /*!< Reserved,                                             Address offset: 0x114 - 0x11C */
  __IO uint32_t ABR;            /*!< XSPI Alternate Bytes Register,                        Address offset: 0x120         */
       uint32_t RESERVED13[3];  /*!< Reserved,                                             Address offset: 0x124 - 0x12C */
  __IO uint32_t LPTR;           /*!< XSPI Low-Power Timeout Register,                      Address offset: 0x130         */
       uint32_t RESERVED14[3];  /*!< Reserved,                                             Address offset: 0x134 - 0x13C */
  __IO uint32_t WPCCR;          /*!< XSPI Wrap Communication Configuration Register,       Address offset: 0x140         */
       uint32_t RESERVED15;     /*!< Reserved,                                             Address offset: 0x144         */
  __IO uint32_t WPTCR;          /*!< XSPI Wrap Timing Configuration Register,              Address offset: 0x148         */
       uint32_t RESERVED16;     /*!< Reserved,                                             Address offset: 0x14C         */
  __IO uint32_t WPIR;           /*!< XSPI Wrap Instruction Register,                       Address offset: 0x150         */
       uint32_t RESERVED17[3];  /*!< Reserved,                                             Address offset: 0x154 - 0x15C */
  __IO uint32_t WPABR;          /*!< XSPI Wrap Alternate Bytes Register,                   Address offset: 0x160         */
       uint32_t RESERVED18[7];  /*!< Reserved,                                             Address offset: 0x164 - 0x17C */
  __IO uint32_t WCCR;           /*!< XSPI Write Communication Configuration Register,      Address offset: 0x180         */
       uint32_t RESERVED19;     /*!< Reserved,                                             Address offset: 0x184         */
  __IO uint32_t WTCR;           /*!< XSPI Write Timing Configuration Register,             Address offset: 0x188         */
       uint32_t RESERVED20;     /*!< Reserved,                                             Address offset: 0x18C         */
  __IO uint32_t WIR;            /*!< XSPI Write Instruction Register,                      Address offset: 0x190         */
       uint32_t RESERVED21[3];  /*!< Reserved,                                             Address offset: 0x194 - 0x19C */
  __IO uint32_t WABR;           /*!< XSPI Write Alternate Bytes Register,                  Address offset: 0x1A0         */
       uint32_t RESERVED22[23]; /*!< Reserved,                                             Address offset: 0x1A4 - 0x1FC */
  __IO uint32_t HLCR;           /*!< XSPI HyperBus Latency Configuration Register,         Address offset: 0x200         */
       uint32_t RESERVED23[3];  /*!< Reserved,                                             Address offset: 0x204 - 0x20C */
  __IO uint32_t CALFCR;         /*!< XSPI Full-Cycle Calibration Configuration Register,   Address offset: 0x210         */
       uint32_t RESERVED24;     /*!< Reserved,                                             Address offset: 0x214         */
  __IO uint32_t CALMR;          /*!< XSPI DLL Master Calibration Configuration Register,   Address offset: 0x218         */
       uint32_t RESERVED25;     /*!< Reserved,                                             Address offset: 0x21C         */
  __IO uint32_t CALSOR;         /*!< XSPI Slave Output Calibration Configuration Register, Address offset: 0x220         */
       uint32_t RESERVED26;     /*!< Reserved,                                             Address offset: 0x224         */
  __IO uint32_t CALSIR;         /*!< XSPI Slave Input Calibration Configuration Register,  Address offset: 0x228         */
} XSPI_TypeDef;

/**
  * @brief XSPI IO Manager
  */
typedef struct
{
  __IO uint32_t CR;             /*!< XSPI IO Manager Control Register,                     Address offset: 0x00        */
} XSPIM_TypeDef;

/** @} */ /* End of group STM32N6xx_peripherals */

/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */
/** @addtogroup STM32N6xx_Peripheral_peripheralAddr
  * @{
  */

/* Internal RAMs sizes */
#define SRAM1_AXI_SIZE                  0x100000UL   /*!< SRAM1_AXI = 1024 Kbytes */
#define SRAM2_AXI_SIZE                  0x100000UL   /*!< SRAM2_AXI = 1024 Kbytes */
#define FLEXRAM_SIZE                     0x64000UL   /*!< FLEXRAM <= 400 Kbytes   */
#define SRAM3_AXI_SIZE                   0x70000UL   /*!< SRAM3_AXI = 448 Kbytes  */
#define SRAM4_AXI_SIZE                   0x70000UL   /*!< SRAM4_AXI = 448 Kbytes  */
#define SRAM5_AXI_SIZE                   0x70000UL   /*!< SRAM5_AXI = 448 Kbytes  */
#define SRAM6_AXI_SIZE                   0x70000UL   /*!< SRAM6_AXI = 448 Kbytes  */
#define SRAM1_AHB_SIZE                    0x4000UL   /*!< SRAM1_AHB = 16 Kbytes   */
#define SRAM2_AHB_SIZE                    0x4000UL   /*!< SRAM2_AHB = 16 Kbytes   */
#define VENC_RAM_SIZE                    0x20000UL   /*!< VENC RAM  = 128 Kbytes  */
#define CACHEAXI_RAM_SIZE                0x40000UL   /*!< CACHEAXI RAM = 256 Kbytes */
#define BKPSRAM_SIZE                      0x2000UL   /*!< BKPSRAM  = 8 Kbytes     */


#define FMC_BASE                        0x60000000UL /*!< Base address of : FMC NOR/RAM memories accessible over AXI */
#define FMC_BANK1                       FMC_BASE
#define FMC_BANK1_1                     FMC_BANK1
#define FMC_BANK1_2                     (FMC_BANK1 + 0x04000000UL)
#define FMC_BANK1_3                     (FMC_BANK1 + 0x08000000UL)
#define FMC_BANK1_4                     (FMC_BANK1 + 0x0C000000UL)
#define FMC_BANK5                       0xC0000000UL  /*!< Base address of : FMC SDRAM memories accessible over AXI */
#define FMC_BANK5_1                     FMC_BANK5
#define FMC_BANK5_2                     (FMC_BANK5 + 0x04000000UL)
#define FMC_BANK5_3                     (FMC_BANK5 + 0x08000000UL)
#define FMC_BANK5_4                     (FMC_BANK5 + 0x0C000000UL)
#define FMC_BANK6                       0xD0000000UL  /*!< Base address of : FMC SDRAM memories accessible over AXI */
#define FMC_BANK6_1                     FMC_BANK6
#define FMC_BANK6_2                     (FMC_BANK6 + 0x04000000UL)
#define FMC_BANK6_3                     (FMC_BANK6 + 0x08000000UL)
#define FMC_BANK6_4                     (FMC_BANK6 + 0x0C000000UL)
#define XSPI1_BASE                      0x90000000UL /*!< Base address of : XSPI1 memories accessible over AXI    */
#define XSPI2_BASE                      0x70000000UL /*!< Base address of : XSPI2 memories accessible over AXI    */
#define XSPI3_BASE                      0x80000000UL /*!< Base address of : XSPI3 memories accessible over AXI    */

/**************************************************************************/
/*                                                                        */
/* Peripheral and internal SRAMs base addresses - Non secure (aliased_NS) */
/*                                                                        */
/**************************************************************************/

#define ITCM_BASE_NS                    0x00000000UL /*!< Base address of ITCM from 64 KB up to 256 KB               */
#define BOOTROM_BASE_NS                 0x08000000UL /*!< Base address of 128 KB boot ROM accessible over AXI        */
#define DTCM_BASE_NS                    0x20000000UL /*!< Base address of DTCM from 128 KB up to 256 KB              */
#define SRAM1_AXI_BASE_NS               0x24000000UL /*!< Base address of up to 1 MB system RAM 1 accessible over AXI */
#define SRAM2_AXI_BASE_NS               0x24100000UL /*!< Base address of 1 MB system RAM 2 accessible over AXI      */
#define SRAM3_AXI_BASE_NS               0x24200000UL /*!< Base address of 448 KB system RAM 3 accessible over AXI      */
#define SRAM4_AXI_BASE_NS               0x24270000UL /*!< Base address of 448 KB system RAM 4 accessible over AXI */
#define SRAM5_AXI_BASE_NS               0x242E0000UL /*!< Base address of 448 KB system RAM 5 accessible over AXI */
#define SRAM6_AXI_BASE_NS               0x24350000UL /*!< Base address of 448 KB system RAM 6 accessible over AXI */
#define SRAM_AXI_BASE_NS                SRAM1_AXI_BASE_NS /*!< Base address of 3.792 MB system RAM accessible over AXI */
#define CACHEAXI_RAM_BASE_NS            0x243C0000UL /*!< Base address of 256 KB NPU Cache RAM accessible over AXI   */
#define VENC_RAM_BASE_NS                0x24400000UL /*!< Base address of 128 KB of Video Encoder RAM accessible over AXI */
#define GFXMMU_VIRTUAL_BUFFER0_BASE_NS  0x25000000UL /*!< Base address of 4 MB GFXMMU virtual buffer 0               */
#define GFXMMU_VIRTUAL_BUFFER1_BASE_NS  0x25400000UL /*!< Base address of 4 MB GFXMMU virtual buffer 1               */
#define GFXMMU_VIRTUAL_BUFFER2_BASE_NS  0x25800000UL /*!< Base address of 4 MB GFXMMU virtual buffer 2               */
#define GFXMMU_VIRTUAL_BUFFER3_BASE_NS  0x25C00000UL /*!< Base address of 4 MB GFXMMU virtual buffer 3               */
#define STM500_CHANNELS_BASE_NS         0x27F00000UL /*!< Base address of 1 MB of STM500 Channels (System Trace)     */
#define SRAM1_AHB_BASE_NS               0x28000000UL /*!< Base address of 16 KB system RAM 1 over AXI->AHB Bridge    */
#define SRAM2_AHB_BASE_NS               0x28004000UL /*!< Base address of 16 KB system RAM 2 over AXI->AHB Bridge    */
#define SRAM_AHB_BASE_NS                SRAM1_AHB_BASE_NS /*!< Base address of 32 KB system RAM over AXI->AHB Bridge */
#define BKPSRAM_BASE_NS                 0x2C000000UL /*!< Base address of 8 KB Backup SRAM over AXI->AHB Bridge      */
#define PERIPH_BASE_NS                  0x40000000UL /*!< Base address of : AHB/APB Peripherals                      */

/*!< Peripheral memory map */
#define APB1PERIPH_BASE_NS              PERIPH_BASE_NS
#define AHB1PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x00020000UL)
#define APB2PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x02000000UL)
#define AHB2PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x02020000UL)
#define APB3PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x04000000UL)
#define AHB3PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x04020000UL)
#define APB4PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x06000000UL)
#define AHB4PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x06020000UL)
#define APB5PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x08000000UL)
#define AHB5PERIPH_BASE_NS              (PERIPH_BASE_NS + 0x08020000UL)

/*!< APB1 peripherals */
#define TIM2_BASE_NS                    (APB1PERIPH_BASE_NS + 0x0000UL)
#define TIM3_BASE_NS                    (APB1PERIPH_BASE_NS + 0x0400UL)
#define TIM4_BASE_NS                    (APB1PERIPH_BASE_NS + 0x0800UL)
#define TIM5_BASE_NS                    (APB1PERIPH_BASE_NS + 0x0C00UL)
#define TIM6_BASE_NS                    (APB1PERIPH_BASE_NS + 0x1000UL)
#define TIM7_BASE_NS                    (APB1PERIPH_BASE_NS + 0x1400UL)
#define TIM12_BASE_NS                   (APB1PERIPH_BASE_NS + 0x1800UL)
#define TIM13_BASE_NS                   (APB1PERIPH_BASE_NS + 0x1C00UL)
#define TIM14_BASE_NS                   (APB1PERIPH_BASE_NS + 0x2000UL)
#define LPTIM1_BASE_NS                  (APB1PERIPH_BASE_NS + 0x2400UL)
#define WWDG_BASE_NS                    (APB1PERIPH_BASE_NS + 0x2C00UL)
#define TIM10_BASE_NS                   (APB1PERIPH_BASE_NS + 0x3000UL)
#define TIM11_BASE_NS                   (APB1PERIPH_BASE_NS + 0x3400UL)
#define SPI2_BASE_NS                    (APB1PERIPH_BASE_NS + 0x3800UL)
#define SPI3_BASE_NS                    (APB1PERIPH_BASE_NS + 0x3C00UL)
#define SPDIFRX_BASE_NS                 (APB1PERIPH_BASE_NS + 0x4000UL)
#define USART2_BASE_NS                  (APB1PERIPH_BASE_NS + 0x4400UL)
#define USART3_BASE_NS                  (APB1PERIPH_BASE_NS + 0x4800UL)
#define UART4_BASE_NS                   (APB1PERIPH_BASE_NS + 0x4C00UL)
#define UART5_BASE_NS                   (APB1PERIPH_BASE_NS + 0x5000UL)
#define I2C1_BASE_NS                    (APB1PERIPH_BASE_NS + 0x5400UL)
#define I2C2_BASE_NS                    (APB1PERIPH_BASE_NS + 0x5800UL)
#define I2C3_BASE_NS                    (APB1PERIPH_BASE_NS + 0x5C00UL)
#define I3C1_BASE_NS                    (APB1PERIPH_BASE_NS + 0x6000UL)
#define I3C2_BASE_NS                    (APB1PERIPH_BASE_NS + 0x6400UL)
#define UART7_BASE_NS                   (APB1PERIPH_BASE_NS + 0x7800UL)
#define UART8_BASE_NS                   (APB1PERIPH_BASE_NS + 0x7C00UL)
#define MDIOS_BASE_NS                   (APB1PERIPH_BASE_NS + 0x9400UL)
#define FDCAN1_BASE_NS                  (APB1PERIPH_BASE_NS + 0xA000UL)
#define FDCAN2_BASE_NS                  (APB1PERIPH_BASE_NS + 0xA400UL)
#define FDCAN_CCU_BASE_NS               (APB1PERIPH_BASE_NS + 0xA800UL)
#define SRAMCAN_BASE_NS                 (APB1PERIPH_BASE_NS + 0xC000UL)
#define FDCAN3_BASE_NS                  (APB1PERIPH_BASE_NS + 0xE800UL)
#define UCPD1_BASE_NS                   (APB1PERIPH_BASE_NS + 0xFC00UL)

/*!< AHB1 peripherals */
#define GPDMA1_BASE_NS                  (AHB1PERIPH_BASE_NS + 0x1000UL)
#define GPDMA1_Channel0_BASE_NS         (GPDMA1_BASE_NS + 0x0050UL)
#define GPDMA1_Channel1_BASE_NS         (GPDMA1_BASE_NS + 0x00D0UL)
#define GPDMA1_Channel2_BASE_NS         (GPDMA1_BASE_NS + 0x0150UL)
#define GPDMA1_Channel3_BASE_NS         (GPDMA1_BASE_NS + 0x01D0UL)
#define GPDMA1_Channel4_BASE_NS         (GPDMA1_BASE_NS + 0x0250UL)
#define GPDMA1_Channel5_BASE_NS         (GPDMA1_BASE_NS + 0x02D0UL)
#define GPDMA1_Channel6_BASE_NS         (GPDMA1_BASE_NS + 0x0350UL)
#define GPDMA1_Channel7_BASE_NS         (GPDMA1_BASE_NS + 0x03D0UL)
#define GPDMA1_Channel8_BASE_NS         (GPDMA1_BASE_NS + 0x0450UL)
#define GPDMA1_Channel9_BASE_NS         (GPDMA1_BASE_NS + 0x04D0UL)
#define GPDMA1_Channel10_BASE_NS        (GPDMA1_BASE_NS + 0x0550UL)
#define GPDMA1_Channel11_BASE_NS        (GPDMA1_BASE_NS + 0x05D0UL)
#define GPDMA1_Channel12_BASE_NS        (GPDMA1_BASE_NS + 0x0650UL)
#define GPDMA1_Channel13_BASE_NS        (GPDMA1_BASE_NS + 0x06D0UL)
#define GPDMA1_Channel14_BASE_NS        (GPDMA1_BASE_NS + 0x0750UL)
#define GPDMA1_Channel15_BASE_NS        (GPDMA1_BASE_NS + 0x07D0UL)
#define ADC1_BASE_NS                    (AHB1PERIPH_BASE_NS + 0x2000UL)
#define ADC2_BASE_NS                    (AHB1PERIPH_BASE_NS + 0x2100UL)
#define ADC12_COMMON_BASE_NS            (AHB1PERIPH_BASE_NS + 0x2300UL)

/*!< APB2 peripherals */
#define TIM1_BASE_NS                    (APB2PERIPH_BASE_NS + 0x0000UL)
#define TIM8_BASE_NS                    (APB2PERIPH_BASE_NS + 0x0400UL)
#define USART1_BASE_NS                  (APB2PERIPH_BASE_NS + 0x1000UL)
#define USART6_BASE_NS                  (APB2PERIPH_BASE_NS + 0x1400UL)
#define UART9_BASE_NS                   (APB2PERIPH_BASE_NS + 0x1800UL)
#define USART10_BASE_NS                 (APB2PERIPH_BASE_NS + 0x1C00UL)
#define SPI1_BASE_NS                    (APB2PERIPH_BASE_NS + 0x3000UL)
#define SPI4_BASE_NS                    (APB2PERIPH_BASE_NS + 0x3400UL)
#define TIM18_BASE_NS                   (APB2PERIPH_BASE_NS + 0x3C00UL)
#define TIM15_BASE_NS                   (APB2PERIPH_BASE_NS + 0x4000UL)
#define TIM16_BASE_NS                   (APB2PERIPH_BASE_NS + 0x4400UL)
#define TIM17_BASE_NS                   (APB2PERIPH_BASE_NS + 0x4800UL)
#define TIM9_BASE_NS                    (APB2PERIPH_BASE_NS + 0x4C00UL)
#define SPI5_BASE_NS                    (APB2PERIPH_BASE_NS + 0x5000UL)
#define SAI1_BASE_NS                    (APB2PERIPH_BASE_NS + 0x5800UL)
#define SAI1_Block_A_BASE_NS            (SAI1_BASE_NS + 0x0004UL)
#define SAI1_Block_B_BASE_NS            (SAI1_BASE_NS + 0x0024UL)
#define SAI2_BASE_NS                    (APB2PERIPH_BASE_NS + 0x5C00UL)
#define SAI2_Block_A_BASE_NS            (SAI2_BASE_NS + 0x0004UL)
#define SAI2_Block_B_BASE_NS            (SAI2_BASE_NS + 0x0024UL)

/*!< AHB2 peripherals */
#define RAMCFG_BASE_NS                  (AHB2PERIPH_BASE_NS + 0x3000UL)
#define RAMCFG_SRAM1_AXI_BASE_NS        (RAMCFG_BASE_NS)
#define RAMCFG_SRAM2_AXI_BASE_NS        (RAMCFG_BASE_NS + 0x0080UL)
#define RAMCFG_SRAM3_AXI_BASE_NS        (RAMCFG_BASE_NS + 0x0100UL)
#define RAMCFG_SRAM4_AXI_BASE_NS        (RAMCFG_BASE_NS + 0x0180UL)
#define RAMCFG_SRAM5_AXI_BASE_NS        (RAMCFG_BASE_NS + 0x0200UL)
#define RAMCFG_SRAM6_AXI_BASE_NS        (RAMCFG_BASE_NS + 0x0280UL)
#define RAMCFG_SRAM1_AHB_BASE_NS        (RAMCFG_BASE_NS + 0x0300UL)
#define RAMCFG_SRAM2_AHB_BASE_NS        (RAMCFG_BASE_NS + 0x0380UL)
#define RAMCFG_VENC_RAM_BASE_NS         (RAMCFG_BASE_NS + 0x0400UL)
#define RAMCFG_BKPSRAM_BASE_NS          (RAMCFG_BASE_NS + 0x0480UL)
#define RAMCFG_FLEXRAM_BASE_NS          (RAMCFG_BASE_NS + 0x0500UL)
#define MDF1_BASE_NS                    (AHB2PERIPH_BASE_NS + 0x5000UL)
#define MDF1_Filter0_BASE_NS            (MDF1_BASE_NS + 0x0080UL)
#define MDF1_Filter1_BASE_NS            (MDF1_BASE_NS + 0x0100UL)
#define MDF1_Filter2_BASE_NS            (MDF1_BASE_NS + 0x0180UL)
#define MDF1_Filter3_BASE_NS            (MDF1_BASE_NS + 0x0200UL)
#define MDF1_Filter4_BASE_NS            (MDF1_BASE_NS + 0x0280UL)
#define MDF1_Filter5_BASE_NS            (MDF1_BASE_NS + 0x0300UL)
#define ADF1_BASE_NS                    (AHB2PERIPH_BASE_NS + 0x6000UL)
#define ADF1_Filter0_BASE_NS            (ADF1_BASE_NS + 0x0080UL)

/*!< APB3 peripherals */
#define DAP_ROM_BASE_NS                 (APB3PERIPH_BASE_NS + 0x0000UL)
#define DBGMCU_BASE_NS                  (APB3PERIPH_BASE_NS + 0x1000UL)
#define DFT_APB_BASE_NS                 (APB3PERIPH_BASE_NS + 0x2000UL)

/*!< AHB3 peripherals */
#define RNG_BASE_NS                     (AHB3PERIPH_BASE_NS + 0x0000UL)
#define HASH_BASE_NS                    (AHB3PERIPH_BASE_NS + 0x0400UL)
#define HASH_DIGEST_BASE_NS             (AHB3PERIPH_BASE_NS + 0x0710UL)
#define CRYP_BASE_NS                    (AHB3PERIPH_BASE_NS + 0x0800UL)
#define SAES_BASE_NS                    (AHB3PERIPH_BASE_NS + 0x1000UL)
#define PKA_BASE_NS                     (AHB3PERIPH_BASE_NS + 0x2000UL)
#define RIFSC_BASE_NS                   (AHB3PERIPH_BASE_NS + 0x4000UL)
#define RISAF1_BASE_NS                  (AHB3PERIPH_BASE_NS + 0x6000UL)
#define RISAF2_BASE_NS                  (AHB3PERIPH_BASE_NS + 0x7000UL)
#define RISAF3_BASE_NS                  (AHB3PERIPH_BASE_NS + 0x8000UL)
#define RISAF4_BASE_NS                  (AHB3PERIPH_BASE_NS + 0x9000UL)
#define RISAF5_BASE_NS                  (AHB3PERIPH_BASE_NS + 0xA000UL)
#define RISAF6_BASE_NS                  (AHB3PERIPH_BASE_NS + 0xB000UL)
#define RISAF7_BASE_NS                  (AHB3PERIPH_BASE_NS + 0xC000UL)
#define RISAF8_BASE_NS                  (AHB3PERIPH_BASE_NS + 0xD000UL)
#define RISAF9_BASE_NS                  (AHB3PERIPH_BASE_NS + 0xE000UL)
#define RISAF11_BASE_NS                 (AHB3PERIPH_BASE_NS + 0x010000UL)
#define RISAF12_BASE_NS                 (AHB3PERIPH_BASE_NS + 0x011000UL)
#define RISAF13_BASE_NS                 (AHB3PERIPH_BASE_NS + 0x012000UL)
#define RISAF14_BASE_NS                 (AHB3PERIPH_BASE_NS + 0x013000UL)
#define RISAF15_BASE_NS                 (AHB3PERIPH_BASE_NS + 0x014000UL)
#define RISAF21_BASE_NS                 (AHB3PERIPH_BASE_NS + 0x015000UL)
#define RISAF22_BASE_NS                 (AHB3PERIPH_BASE_NS + 0x016000UL)
#define RISAF23_BASE_NS                 (AHB3PERIPH_BASE_NS + 0x017000UL)

/*!< APB4 peripherals */
#define HDP_BASE_NS                     (APB4PERIPH_BASE_NS + 0x0800UL)
#define LPUART1_BASE_NS                 (APB4PERIPH_BASE_NS + 0x0C00UL)
#define SPI6_BASE_NS                    (APB4PERIPH_BASE_NS + 0x1400UL)
#define I2C4_BASE_NS                    (APB4PERIPH_BASE_NS + 0x1C00UL)
#define LPTIM2_BASE_NS                  (APB4PERIPH_BASE_NS + 0x2400UL)
#define LPTIM3_BASE_NS                  (APB4PERIPH_BASE_NS + 0x2800UL)
#define LPTIM4_BASE_NS                  (APB4PERIPH_BASE_NS + 0x2C00UL)
#define LPTIM5_BASE_NS                  (APB4PERIPH_BASE_NS + 0x3000UL)
#define VREFBUF_BASE_NS                 (APB4PERIPH_BASE_NS + 0x3C00UL)
#define RTC_BASE_NS                     (APB4PERIPH_BASE_NS + 0x4000UL)
#define TAMP_BASE_NS                    (APB4PERIPH_BASE_NS + 0x4400UL)
#define IWDG_BASE_NS                    (APB4PERIPH_BASE_NS + 0x4800UL)
#define SERC_BASE_NS                    (APB4PERIPH_BASE_NS + 0x7C00UL)
#define SYSCFG_BASE_NS                  (APB4PERIPH_BASE_NS + 0x8000UL)
#define BSEC_BASE_NS                    (APB4PERIPH_BASE_NS + 0x9000UL)
#define DTS_BASE_NS                     (APB4PERIPH_BASE_NS + 0xA000UL)
#define DTS_Sensor0_BASE_NS             (DTS_BASE_NS + 0x0C0UL)
#define DTS_Sensor1_BASE_NS             (DTS_BASE_NS + 0x100UL)

/*!< AHB4 peripherals */
#define GPIOA_BASE_NS                   (AHB4PERIPH_BASE_NS + 0x0000UL)
#define GPIOB_BASE_NS                   (AHB4PERIPH_BASE_NS + 0x0400UL)
#define GPIOC_BASE_NS                   (AHB4PERIPH_BASE_NS + 0x0800UL)
#define GPIOD_BASE_NS                   (AHB4PERIPH_BASE_NS + 0x0C00UL)
#define GPIOE_BASE_NS                   (AHB4PERIPH_BASE_NS + 0x1000UL)
#define GPIOF_BASE_NS                   (AHB4PERIPH_BASE_NS + 0x1400UL)
#define GPIOG_BASE_NS                   (AHB4PERIPH_BASE_NS + 0x1800UL)
#define GPIOH_BASE_NS                   (AHB4PERIPH_BASE_NS + 0x1C00UL)
#define GPION_BASE_NS                   (AHB4PERIPH_BASE_NS + 0x3400UL)
#define GPIOO_BASE_NS                   (AHB4PERIPH_BASE_NS + 0x3800UL)
#define GPIOP_BASE_NS                   (AHB4PERIPH_BASE_NS + 0x3C00UL)
#define GPIOQ_BASE_NS                   (AHB4PERIPH_BASE_NS + 0x4000UL)
#define PWR_BASE_NS                     (AHB4PERIPH_BASE_NS + 0x4800UL)
#define CRC_BASE_NS                     (AHB4PERIPH_BASE_NS + 0x4C00UL)
#define EXTI_BASE_NS                    (AHB4PERIPH_BASE_NS + 0x5000UL)
#define RCC_BASE_NS                     (AHB4PERIPH_BASE_NS + 0x8000UL)

/*!< APB5 peripherals */
#define LTDC_BASE_NS                    (APB5PERIPH_BASE_NS + 0x1000UL)
#define LTDC_Layer1_BASE_NS             (LTDC_BASE_NS + 0x0100UL)
#define LTDC_Layer2_BASE_NS             (LTDC_BASE_NS + 0x0200UL)
#define DCMIPP_BASE_NS                  (APB5PERIPH_BASE_NS + 0x2000UL)
#define GFXTIM_BASE_NS                  (APB5PERIPH_BASE_NS + 0x4000UL)
#define VENC_BASE_NS                    (APB5PERIPH_BASE_NS + 0x5000UL)
#define CSI_BASE_NS                     (APB5PERIPH_BASE_NS + 0x6000UL)

/*!< AHB5 peripherals */
#define HPDMA1_BASE_NS                  (AHB5PERIPH_BASE_NS + 0x0000UL)
#define HPDMA1_Channel0_BASE_NS         (HPDMA1_BASE_NS + 0x0050UL)
#define HPDMA1_Channel1_BASE_NS         (HPDMA1_BASE_NS + 0x00D0UL)
#define HPDMA1_Channel2_BASE_NS         (HPDMA1_BASE_NS + 0x0150UL)
#define HPDMA1_Channel3_BASE_NS         (HPDMA1_BASE_NS + 0x01D0UL)
#define HPDMA1_Channel4_BASE_NS         (HPDMA1_BASE_NS + 0x0250UL)
#define HPDMA1_Channel5_BASE_NS         (HPDMA1_BASE_NS + 0x02D0UL)
#define HPDMA1_Channel6_BASE_NS         (HPDMA1_BASE_NS + 0x0350UL)
#define HPDMA1_Channel7_BASE_NS         (HPDMA1_BASE_NS + 0x03D0UL)
#define HPDMA1_Channel8_BASE_NS         (HPDMA1_BASE_NS + 0x0450UL)
#define HPDMA1_Channel9_BASE_NS         (HPDMA1_BASE_NS + 0x04D0UL)
#define HPDMA1_Channel10_BASE_NS        (HPDMA1_BASE_NS + 0x0550UL)
#define HPDMA1_Channel11_BASE_NS        (HPDMA1_BASE_NS + 0x05D0UL)
#define HPDMA1_Channel12_BASE_NS        (HPDMA1_BASE_NS + 0x0650UL)
#define HPDMA1_Channel13_BASE_NS        (HPDMA1_BASE_NS + 0x06D0UL)
#define HPDMA1_Channel14_BASE_NS        (HPDMA1_BASE_NS + 0x0750UL)
#define HPDMA1_Channel15_BASE_NS        (HPDMA1_BASE_NS + 0x07D0UL)
#define DMA2D_BASE_NS                   (AHB5PERIPH_BASE_NS + 0x1000UL)
#define JPEG_BASE_NS                    (AHB5PERIPH_BASE_NS + 0x3000UL)
#define FMC_R_BASE_NS                   (AHB5PERIPH_BASE_NS + 0x4000UL)
#define FMC_Bank1_R_BASE_NS             (FMC_R_BASE_NS + 0x0000UL)
#define FMC_Bank1E_R_BASE_NS            (FMC_R_BASE_NS + 0x0104UL)
#define FMC_Bank3_R_BASE_NS             (FMC_R_BASE_NS + 0x0080UL)
#define FMC_Bank5_6_R_BASE_NS           (FMC_R_BASE_NS + 0x0140UL)
#define FMC_Common_R_BASE_NS            (FMC_R_BASE_NS + 0x0020UL)
#define XSPI1_BASE_NS                   (AHB5PERIPH_BASE_NS + 0x5000UL)
#define PSSI_BASE_NS                    (AHB5PERIPH_BASE_NS + 0x6400UL)
#define SDMMC2_BASE_NS                  (AHB5PERIPH_BASE_NS + 0x6800UL)
#define DLYB_SDMMC2_BASE_NS             (AHB5PERIPH_BASE_NS + 0x6C00UL)
#define SDMMC1_BASE_NS                  (AHB5PERIPH_BASE_NS + 0x7000UL)
#define DLYB_SDMMC1_BASE_NS             (AHB5PERIPH_BASE_NS + 0x8000UL)
#define DCMI_BASE_NS                    (AHB5PERIPH_BASE_NS + 0x8400UL)
#define XSPI2_BASE_NS                   (AHB5PERIPH_BASE_NS + 0xA000UL)
#define XSPIM_BASE_NS                   (AHB5PERIPH_BASE_NS + 0xB400UL)
#define MCE1_BASE_NS                    (AHB5PERIPH_BASE_NS + 0xB800UL)
#define MCE1_REGION1_BASE_NS            (MCE1_BASE_NS + 0x040UL)
#define MCE1_REGION2_BASE_NS            (MCE1_BASE_NS + 0x050UL)
#define MCE1_REGION3_BASE_NS            (MCE1_BASE_NS + 0x060UL)
#define MCE1_REGION4_BASE_NS            (MCE1_BASE_NS + 0x070UL)
#define MCE1_CONTEXT1_BASE_NS           (MCE1_BASE_NS + 0x240UL)
#define MCE1_CONTEXT2_BASE_NS           (MCE1_BASE_NS + 0x270UL)
#define MCE2_BASE_NS                    (AHB5PERIPH_BASE_NS + 0xBC00UL)
#define MCE2_REGION1_BASE_NS            (MCE2_BASE_NS + 0x040UL)
#define MCE2_REGION2_BASE_NS            (MCE2_BASE_NS + 0x050UL)
#define MCE2_REGION3_BASE_NS            (MCE2_BASE_NS + 0x060UL)
#define MCE2_REGION4_BASE_NS            (MCE2_BASE_NS + 0x070UL)
#define MCE2_CONTEXT1_BASE_NS           (MCE2_BASE_NS + 0x240UL)
#define MCE2_CONTEXT2_BASE_NS           (MCE2_BASE_NS + 0x270UL)
#define MCE3_BASE_NS                    (AHB5PERIPH_BASE_NS + 0xC000UL)
#define MCE3_REGION1_BASE_NS            (MCE3_BASE_NS + 0x040UL)
#define MCE3_REGION2_BASE_NS            (MCE3_BASE_NS + 0x050UL)
#define MCE3_REGION3_BASE_NS            (MCE3_BASE_NS + 0x060UL)
#define MCE3_REGION4_BASE_NS            (MCE3_BASE_NS + 0x070UL)
#define MCE3_CONTEXT1_BASE_NS           (MCE3_BASE_NS + 0x240UL)
#define MCE3_CONTEXT2_BASE_NS           (MCE3_BASE_NS + 0x270UL)
#define MCE4_BASE_NS                    (AHB5PERIPH_BASE_NS + 0xE000UL)
#define MCE4_REGION1_BASE_NS            (MCE4_BASE_NS + 0x040UL)
#define MCE4_REGION2_BASE_NS            (MCE4_BASE_NS + 0x050UL)
#define MCE4_REGION3_BASE_NS            (MCE4_BASE_NS + 0x060UL)
#define MCE4_REGION4_BASE_NS            (MCE4_BASE_NS + 0x070UL)
#define MCE4_CONTEXT1_BASE_NS           (MCE4_BASE_NS + 0x240UL)
#define MCE4_CONTEXT2_BASE_NS           (MCE4_BASE_NS + 0x270UL)
#define XSPI3_BASE_NS                   (AHB5PERIPH_BASE_NS + 0xD000UL)
#define GFXMMU_BASE_NS                  (AHB5PERIPH_BASE_NS + 0x010000UL)
#define GPU2D_BASE_NS                   (AHB5PERIPH_BASE_NS + 0x014000UL)
#define GPUCACHE_BASE_NS                (AHB5PERIPH_BASE_NS + 0x015000UL)
#define ICACHE_BASE_NS                  (AHB5PERIPH_BASE_NS + 0x015000UL)
#define ETH1_BASE_NS                    (AHB5PERIPH_BASE_NS + 0x016000UL)
#define ETH1_MAC_BASE_NS                (ETH1_BASE_NS)
#define USB1_HS_PHYC_BASE_NS            (AHB5PERIPH_BASE_NS + 0x01FC00UL)
#define USB2_HS_PHYC_BASE_NS            (AHB5PERIPH_BASE_NS + 0x0A0000UL)
#define USB1_OTG_HS_BASE_NS             (AHB5PERIPH_BASE_NS + 0x020000UL)
#define USB2_OTG_HS_BASE_NS             (AHB5PERIPH_BASE_NS + 0x060000UL)
#define CACHEAXI_BASE_NS                (AHB5PERIPH_BASE_NS + 0x0BFC00UL)
#define NPU_BASE_NS                     (AHB5PERIPH_BASE_NS + 0x0C0000UL)


/*!< Unique device ID register base address */
#define UID_BASE_NS                     (0x46009014UL)

/*!< Revision ID base address */
#define REVID_BASE_NS                   (BOOTROM_BASE_NS + 0x0047ECUL)


#if defined (CPU_IN_SECURE_STATE)
/*********************************************************************/
/*                                                                   */
/* Peripheral and internal SRAMs base addresses - Secure (aliased_S) */
/*                                                                   */
/*********************************************************************/
#define ITCM_BASE_S                     0x10000000UL /*!< Base address of ITCM from 64 KB up to 256 KB               */
#define BOOTROM_BASE_S                  0x18000000UL /*!< Base address of 128 KB boot ROM accessible over AXI        */
#define DTCM_BASE_S                     0x30000000UL /*!< Base address of DTCM from 128 KB up to 256 KB              */
#define SRAM1_AXI_BASE_S                0x34000000UL /*!< Base address of up to 1 MB system RAM 1 accessible over AXI */
#define SRAM2_AXI_BASE_S                0x34100000UL /*!< Base address of 1 MB system RAM 2 accessible over AXI      */
#define SRAM3_AXI_BASE_S                0x34200000UL /*!< Base address of 448 KB system RAM 3 accessible over AXI      */
#define SRAM4_AXI_BASE_S                0x34270000UL /*!< Base address of 448 KB system RAM 4 accessible over AXI */
#define SRAM5_AXI_BASE_S                0x342E0000UL /*!< Base address of 448 KB system RAM 5 accessible over AXI */
#define SRAM6_AXI_BASE_S                0x34350000UL /*!< Base address of 448 KB system RAM 6 accessible over AXI */
#define SRAM_AXI_BASE_S                 SRAM1_AXI_BASE_NS /*!< Base address of 3.792 MB system RAM accessible over AXI */
#define CACHEAXI_RAM_BASE_S             0x343C0000UL /*!< Base address of 256 KB NPU Cache RAM accessible over AXI   */
#define VENC_RAM_BASE_S                 0x34400000UL /*!< Base address of 128 KB of Video Encoder RAM accessible over AXI */
#define GFXMMU_VIRTUAL_BUFFER0_BASE_S   0x35000000UL /*!< Base address of 4 MB GFXMMU virtual buffer 0               */
#define GFXMMU_VIRTUAL_BUFFER1_BASE_S   0x35400000UL /*!< Base address of 4 MB GFXMMU virtual buffer 1               */
#define GFXMMU_VIRTUAL_BUFFER2_BASE_S   0x35800000UL /*!< Base address of 4 MB GFXMMU virtual buffer 2               */
#define GFXMMU_VIRTUAL_BUFFER3_BASE_S   0x35C00000UL /*!< Base address of 4 MB GFXMMU virtual buffer 3               */
#define STM500_CHANNELS_BASE_S          0x37F00000UL /*!< Base address of 1 MB of STM500 Channels (System Trace)     */
#define SRAM1_AHB_BASE_S                0x38000000UL /*!< Base address of 16 KB system RAM 1 over AXI->AHB Bridge    */
#define SRAM2_AHB_BASE_S                0x38004000UL /*!< Base address of 16 KB system RAM 2 over AXI->AHB Bridge    */
#define SRAM_AHB_BASE_S                 SRAM1_AHB_BASE_S /*!< Base address of 32 KB system RAM over AXI->AHB Bridge  */
#define BKPSRAM_BASE_S                  0x3C000000UL   /*!< Base address of 8 KB Backup SRAM over AXI->AHB Bridge    */
#define PERIPH_BASE_S                   0x50000000UL   /*!< Base address of : AHB/APB Peripherals                    */

/*!< Peripheral memory map */
#define APB1PERIPH_BASE_S               PERIPH_BASE_S
#define AHB1PERIPH_BASE_S               (PERIPH_BASE_S + 0x00020000UL)
#define APB2PERIPH_BASE_S               (PERIPH_BASE_S + 0x02000000UL)
#define AHB2PERIPH_BASE_S               (PERIPH_BASE_S + 0x02020000UL)
#define APB3PERIPH_BASE_S               (PERIPH_BASE_S + 0x04000000UL)
#define AHB3PERIPH_BASE_S               (PERIPH_BASE_S + 0x04020000UL)
#define APB4PERIPH_BASE_S               (PERIPH_BASE_S + 0x06000000UL)
#define AHB4PERIPH_BASE_S               (PERIPH_BASE_S + 0x06020000UL)
#define APB5PERIPH_BASE_S               (PERIPH_BASE_S + 0x08000000UL)
#define AHB5PERIPH_BASE_S               (PERIPH_BASE_S + 0x08020000UL)

/*!< APB1 peripherals */
#define TIM2_BASE_S                     (APB1PERIPH_BASE_S + 0x0000UL)
#define TIM3_BASE_S                     (APB1PERIPH_BASE_S + 0x0400UL)
#define TIM4_BASE_S                     (APB1PERIPH_BASE_S + 0x0800UL)
#define TIM5_BASE_S                     (APB1PERIPH_BASE_S + 0x0C00UL)
#define TIM6_BASE_S                     (APB1PERIPH_BASE_S + 0x1000UL)
#define TIM7_BASE_S                     (APB1PERIPH_BASE_S + 0x1400UL)
#define TIM12_BASE_S                    (APB1PERIPH_BASE_S + 0x1800UL)
#define TIM13_BASE_S                    (APB1PERIPH_BASE_S + 0x1C00UL)
#define TIM14_BASE_S                    (APB1PERIPH_BASE_S + 0x2000UL)
#define LPTIM1_BASE_S                   (APB1PERIPH_BASE_S + 0x2400UL)
#define WWDG_BASE_S                     (APB1PERIPH_BASE_S + 0x2C00UL)
#define TIM10_BASE_S                    (APB1PERIPH_BASE_S + 0x3000UL)
#define TIM11_BASE_S                    (APB1PERIPH_BASE_S + 0x3400UL)
#define SPI2_BASE_S                     (APB1PERIPH_BASE_S + 0x3800UL)
#define SPI3_BASE_S                     (APB1PERIPH_BASE_S + 0x3C00UL)
#define SPDIFRX_BASE_S                  (APB1PERIPH_BASE_S + 0x4000UL)
#define USART2_BASE_S                   (APB1PERIPH_BASE_S + 0x4400UL)
#define USART3_BASE_S                   (APB1PERIPH_BASE_S + 0x4800UL)
#define UART4_BASE_S                    (APB1PERIPH_BASE_S + 0x4C00UL)
#define UART5_BASE_S                    (APB1PERIPH_BASE_S + 0x5000UL)
#define I2C1_BASE_S                     (APB1PERIPH_BASE_S + 0x5400UL)
#define I2C2_BASE_S                     (APB1PERIPH_BASE_S + 0x5800UL)
#define I2C3_BASE_S                     (APB1PERIPH_BASE_S + 0x5C00UL)
#define I3C1_BASE_S                     (APB1PERIPH_BASE_S + 0x6000UL)
#define I3C2_BASE_S                     (APB1PERIPH_BASE_S + 0x6400UL)
#define UART7_BASE_S                    (APB1PERIPH_BASE_S + 0x7800UL)
#define UART8_BASE_S                    (APB1PERIPH_BASE_S + 0x7C00UL)
#define MDIOS_BASE_S                    (APB1PERIPH_BASE_S + 0x9400UL)
#define FDCAN1_BASE_S                   (APB1PERIPH_BASE_S + 0xA000UL)
#define FDCAN2_BASE_S                   (APB1PERIPH_BASE_S + 0xA400UL)
#define FDCAN_CCU_BASE_S                (APB1PERIPH_BASE_S + 0xA800UL)
#define SRAMCAN_BASE_S                  (APB1PERIPH_BASE_S + 0xC000UL)
#define FDCAN3_BASE_S                   (APB1PERIPH_BASE_S + 0xE800UL)
#define UCPD1_BASE_S                    (APB1PERIPH_BASE_S + 0xFC00UL)

/*!< AHB1 peripherals */
#define GPDMA1_BASE_S                   (AHB1PERIPH_BASE_S + 0x1000UL)
#define GPDMA1_Channel0_BASE_S          (GPDMA1_BASE_S + 0x0050UL)
#define GPDMA1_Channel1_BASE_S          (GPDMA1_BASE_S + 0x00D0UL)
#define GPDMA1_Channel2_BASE_S          (GPDMA1_BASE_S + 0x0150UL)
#define GPDMA1_Channel3_BASE_S          (GPDMA1_BASE_S + 0x01D0UL)
#define GPDMA1_Channel4_BASE_S          (GPDMA1_BASE_S + 0x0250UL)
#define GPDMA1_Channel5_BASE_S          (GPDMA1_BASE_S + 0x02D0UL)
#define GPDMA1_Channel6_BASE_S          (GPDMA1_BASE_S + 0x0350UL)
#define GPDMA1_Channel7_BASE_S          (GPDMA1_BASE_S + 0x03D0UL)
#define GPDMA1_Channel8_BASE_S          (GPDMA1_BASE_S + 0x0450UL)
#define GPDMA1_Channel9_BASE_S          (GPDMA1_BASE_S + 0x04D0UL)
#define GPDMA1_Channel10_BASE_S         (GPDMA1_BASE_S + 0x0550UL)
#define GPDMA1_Channel11_BASE_S         (GPDMA1_BASE_S + 0x05D0UL)
#define GPDMA1_Channel12_BASE_S         (GPDMA1_BASE_S + 0x0650UL)
#define GPDMA1_Channel13_BASE_S         (GPDMA1_BASE_S + 0x06D0UL)
#define GPDMA1_Channel14_BASE_S         (GPDMA1_BASE_S + 0x0750UL)
#define GPDMA1_Channel15_BASE_S         (GPDMA1_BASE_S + 0x07D0UL)
#define ADC1_BASE_S                     (AHB1PERIPH_BASE_S + 0x2000UL)
#define ADC2_BASE_S                     (AHB1PERIPH_BASE_S + 0x2100UL)
#define ADC12_COMMON_BASE_S             (AHB1PERIPH_BASE_S + 0x2300UL)

/*!< APB2 peripherals */
#define TIM1_BASE_S                     (APB2PERIPH_BASE_S + 0x0000UL)
#define TIM8_BASE_S                     (APB2PERIPH_BASE_S + 0x0400UL)
#define USART1_BASE_S                   (APB2PERIPH_BASE_S + 0x1000UL)
#define USART6_BASE_S                   (APB2PERIPH_BASE_S + 0x1400UL)
#define UART9_BASE_S                    (APB2PERIPH_BASE_S + 0x1800UL)
#define USART10_BASE_S                  (APB2PERIPH_BASE_S + 0x1C00UL)
#define SPI1_BASE_S                     (APB2PERIPH_BASE_S + 0x3000UL)
#define SPI4_BASE_S                     (APB2PERIPH_BASE_S + 0x3400UL)
#define TIM18_BASE_S                    (APB2PERIPH_BASE_S + 0x3C00UL)
#define TIM15_BASE_S                    (APB2PERIPH_BASE_S + 0x4000UL)
#define TIM16_BASE_S                    (APB2PERIPH_BASE_S + 0x4400UL)
#define TIM17_BASE_S                    (APB2PERIPH_BASE_S + 0x4800UL)
#define TIM9_BASE_S                     (APB2PERIPH_BASE_S + 0x4C00UL)
#define SPI5_BASE_S                     (APB2PERIPH_BASE_S + 0x5000UL)
#define SAI1_BASE_S                     (APB2PERIPH_BASE_S + 0x5800UL)
#define SAI1_Block_A_BASE_S             (SAI1_BASE_S + 0x0004UL)
#define SAI1_Block_B_BASE_S             (SAI1_BASE_S + 0x0024UL)
#define SAI2_BASE_S                     (APB2PERIPH_BASE_S + 0x5C00UL)
#define SAI2_Block_A_BASE_S             (SAI2_BASE_S + 0x0004UL)
#define SAI2_Block_B_BASE_S             (SAI2_BASE_S + 0x0024UL)

/*!< AHB2 peripherals */
#define RAMCFG_BASE_S                   (AHB2PERIPH_BASE_S + 0x3000UL)
#define RAMCFG_SRAM1_AXI_BASE_S         (RAMCFG_BASE_S)
#define RAMCFG_SRAM2_AXI_BASE_S         (RAMCFG_BASE_S + 0x0080UL)
#define RAMCFG_SRAM3_AXI_BASE_S         (RAMCFG_BASE_S + 0x0100UL)
#define RAMCFG_SRAM4_AXI_BASE_S         (RAMCFG_BASE_S + 0x0180UL)
#define RAMCFG_SRAM5_AXI_BASE_S         (RAMCFG_BASE_S + 0x0200UL)
#define RAMCFG_SRAM6_AXI_BASE_S         (RAMCFG_BASE_S + 0x0280UL)
#define RAMCFG_SRAM1_AHB_BASE_S         (RAMCFG_BASE_S + 0x0300UL)
#define RAMCFG_SRAM2_AHB_BASE_S         (RAMCFG_BASE_S + 0x0380UL)
#define RAMCFG_VENC_RAM_BASE_S          (RAMCFG_BASE_S + 0x0400UL)
#define RAMCFG_BKPSRAM_BASE_S           (RAMCFG_BASE_S + 0x0480UL)
#define RAMCFG_FLEXRAM_BASE_S           (RAMCFG_BASE_S + 0x0500UL)
#define MDF1_BASE_S                     (AHB2PERIPH_BASE_S + 0x5000UL)
#define MDF1_Filter0_BASE_S             (MDF1_BASE_S + 0x0080UL)
#define MDF1_Filter1_BASE_S             (MDF1_BASE_S + 0x0100UL)
#define MDF1_Filter2_BASE_S             (MDF1_BASE_S + 0x0180UL)
#define MDF1_Filter3_BASE_S             (MDF1_BASE_S + 0x0200UL)
#define MDF1_Filter4_BASE_S             (MDF1_BASE_S + 0x0280UL)
#define MDF1_Filter5_BASE_S             (MDF1_BASE_S + 0x0300UL)
#define ADF1_BASE_S                     (AHB2PERIPH_BASE_S + 0x6000UL)
#define ADF1_Filter0_BASE_S             (ADF1_BASE_S + 0x0080UL)

/*!< APB3 peripherals */
#define DAP_ROM_BASE_S                  (APB3PERIPH_BASE_S + 0x0000UL)
#define DBGMCU_BASE_S                   (APB3PERIPH_BASE_S + 0x1000UL)
#define DFT_APB_BASE_S                  (APB3PERIPH_BASE_S + 0x2000UL)

/*!< AHB3 peripherals */
#define RNG_BASE_S                      (AHB3PERIPH_BASE_S + 0x0000UL)
#define HASH_BASE_S                     (AHB3PERIPH_BASE_S + 0x0400UL)
#define HASH_DIGEST_BASE_S              (AHB3PERIPH_BASE_S + 0x0710UL)
#define CRYP_BASE_S                     (AHB3PERIPH_BASE_S + 0x0800UL)
#define SAES_BASE_S                     (AHB3PERIPH_BASE_S + 0x1000UL)
#define PKA_BASE_S                      (AHB3PERIPH_BASE_S + 0x2000UL)
#define RIFSC_BASE_S                    (AHB3PERIPH_BASE_S + 0x4000UL)
#define IAC_BASE_S                      (AHB3PERIPH_BASE_S + 0x5000UL)
#define RISAF1_BASE_S                   (AHB3PERIPH_BASE_S + 0x6000UL)
#define RISAF2_BASE_S                   (AHB3PERIPH_BASE_S + 0x7000UL)
#define RISAF3_BASE_S                   (AHB3PERIPH_BASE_S + 0x8000UL)
#define RISAF4_BASE_S                   (AHB3PERIPH_BASE_S + 0x9000UL)
#define RISAF5_BASE_S                   (AHB3PERIPH_BASE_S + 0xA000UL)
#define RISAF6_BASE_S                   (AHB3PERIPH_BASE_S + 0xB000UL)
#define RISAF7_BASE_S                   (AHB3PERIPH_BASE_S + 0xC000UL)
#define RISAF8_BASE_S                   (AHB3PERIPH_BASE_S + 0xD000UL)
#define RISAF9_BASE_S                   (AHB3PERIPH_BASE_S + 0xE000UL)
#define RISAF11_BASE_S                  (AHB3PERIPH_BASE_S + 0x010000UL)
#define RISAF12_BASE_S                  (AHB3PERIPH_BASE_S + 0x011000UL)
#define RISAF13_BASE_S                  (AHB3PERIPH_BASE_S + 0x012000UL)
#define RISAF14_BASE_S                  (AHB3PERIPH_BASE_S + 0x013000UL)
#define RISAF15_BASE_S                  (AHB3PERIPH_BASE_S + 0x014000UL)
#define RISAF21_BASE_S                  (AHB3PERIPH_BASE_S + 0x015000UL)
#define RISAF22_BASE_S                  (AHB3PERIPH_BASE_S + 0x016000UL)
#define RISAF23_BASE_S                  (AHB3PERIPH_BASE_S + 0x017000UL)

/*!< APB4 peripherals */
#define HDP_BASE_S                      (APB4PERIPH_BASE_S + 0x0800UL)
#define LPUART1_BASE_S                  (APB4PERIPH_BASE_S + 0x0C00UL)
#define SPI6_BASE_S                     (APB4PERIPH_BASE_S + 0x1400UL)
#define I2C4_BASE_S                     (APB4PERIPH_BASE_S + 0x1C00UL)
#define LPTIM2_BASE_S                   (APB4PERIPH_BASE_S + 0x2400UL)
#define LPTIM3_BASE_S                   (APB4PERIPH_BASE_S + 0x2800UL)
#define LPTIM4_BASE_S                   (APB4PERIPH_BASE_S + 0x2C00UL)
#define LPTIM5_BASE_S                   (APB4PERIPH_BASE_S + 0x3000UL)
#define VREFBUF_BASE_S                  (APB4PERIPH_BASE_S + 0x3C00UL)
#define RTC_BASE_S                      (APB4PERIPH_BASE_S + 0x4000UL)
#define TAMP_BASE_S                     (APB4PERIPH_BASE_S + 0x4400UL)
#define IWDG_BASE_S                     (APB4PERIPH_BASE_S + 0x4800UL)

#define SERC_BASE_S                     (APB4PERIPH_BASE_S + 0x7C00UL)
#define SYSCFG_BASE_S                   (APB4PERIPH_BASE_S + 0x8000UL)
#define BSEC_BASE_S                     (APB4PERIPH_BASE_S + 0x9000UL)
#define DTS_BASE_S                      (APB4PERIPH_BASE_S + 0xA000UL)
#define DTS_Sensor0_BASE_S              (DTS_BASE_S + 0x0C0UL)
#define DTS_Sensor1_BASE_S              (DTS_BASE_S + 0x100UL)

/*!< AHB4 peripherals */
#define GPIOA_BASE_S                    (AHB4PERIPH_BASE_S + 0x0000UL)
#define GPIOB_BASE_S                    (AHB4PERIPH_BASE_S + 0x0400UL)
#define GPIOC_BASE_S                    (AHB4PERIPH_BASE_S + 0x0800UL)
#define GPIOD_BASE_S                    (AHB4PERIPH_BASE_S + 0x0C00UL)
#define GPIOE_BASE_S                    (AHB4PERIPH_BASE_S + 0x1000UL)
#define GPIOF_BASE_S                    (AHB4PERIPH_BASE_S + 0x1400UL)
#define GPIOG_BASE_S                    (AHB4PERIPH_BASE_S + 0x1800UL)
#define GPIOH_BASE_S                    (AHB4PERIPH_BASE_S + 0x1C00UL)
#define GPION_BASE_S                    (AHB4PERIPH_BASE_S + 0x3400UL)
#define GPIOO_BASE_S                    (AHB4PERIPH_BASE_S + 0x3800UL)
#define GPIOP_BASE_S                    (AHB4PERIPH_BASE_S + 0x3C00UL)
#define GPIOQ_BASE_S                    (AHB4PERIPH_BASE_S + 0x4000UL)
#define PWR_BASE_S                      (AHB4PERIPH_BASE_S + 0x4800UL)
#define CRC_BASE_S                      (AHB4PERIPH_BASE_S + 0x4C00UL)
#define EXTI_BASE_S                     (AHB4PERIPH_BASE_S + 0x5000UL)
#define RCC_BASE_S                      (AHB4PERIPH_BASE_S + 0x8000UL)

/*!< APB5 peripherals */
#define LTDC_BASE_S                     (APB5PERIPH_BASE_S + 0x1000UL)
#define LTDC_Layer1_BASE_S              (LTDC_BASE_S + 0x0100UL)
#define LTDC_Layer2_BASE_S              (LTDC_BASE_S + 0x0200UL)
#define DCMIPP_BASE_S                   (APB5PERIPH_BASE_S + 0x2000UL)
#define GFXTIM_BASE_S                   (APB5PERIPH_BASE_S + 0x4000UL)
#define VENC_BASE_S                     (APB5PERIPH_BASE_S + 0x5000UL)
#define CSI_BASE_S                      (APB5PERIPH_BASE_S + 0x6000UL)

/*!< AHB5 peripherals */
#define HPDMA1_BASE_S                   (AHB5PERIPH_BASE_S + 0x0000UL)
#define HPDMA1_Channel0_BASE_S          (HPDMA1_BASE_S + 0x0050UL)
#define HPDMA1_Channel1_BASE_S          (HPDMA1_BASE_S + 0x00D0UL)
#define HPDMA1_Channel2_BASE_S          (HPDMA1_BASE_S + 0x0150UL)
#define HPDMA1_Channel3_BASE_S          (HPDMA1_BASE_S + 0x01D0UL)
#define HPDMA1_Channel4_BASE_S          (HPDMA1_BASE_S + 0x0250UL)
#define HPDMA1_Channel5_BASE_S          (HPDMA1_BASE_S + 0x02D0UL)
#define HPDMA1_Channel6_BASE_S          (HPDMA1_BASE_S + 0x0350UL)
#define HPDMA1_Channel7_BASE_S          (HPDMA1_BASE_S + 0x03D0UL)
#define HPDMA1_Channel8_BASE_S          (HPDMA1_BASE_S + 0x0450UL)
#define HPDMA1_Channel9_BASE_S          (HPDMA1_BASE_S + 0x04D0UL)
#define HPDMA1_Channel10_BASE_S         (HPDMA1_BASE_S + 0x0550UL)
#define HPDMA1_Channel11_BASE_S         (HPDMA1_BASE_S + 0x05D0UL)
#define HPDMA1_Channel12_BASE_S         (HPDMA1_BASE_S + 0x0650UL)
#define HPDMA1_Channel13_BASE_S         (HPDMA1_BASE_S + 0x06D0UL)
#define HPDMA1_Channel14_BASE_S         (HPDMA1_BASE_S + 0x0750UL)
#define HPDMA1_Channel15_BASE_S         (HPDMA1_BASE_S + 0x07D0UL)
#define DMA2D_BASE_S                    (AHB5PERIPH_BASE_S + 0x1000UL)
#define JPEG_BASE_S                     (AHB5PERIPH_BASE_S + 0x3000UL)
#define FMC_R_BASE_S                    (AHB5PERIPH_BASE_S + 0x4000UL)
#define FMC_Bank1_R_BASE_S              (FMC_R_BASE_S + 0x0000UL)
#define FMC_Bank1E_R_BASE_S             (FMC_R_BASE_S + 0x0104UL)
#define FMC_Bank3_R_BASE_S              (FMC_R_BASE_S + 0x0080UL)
#define FMC_Bank5_6_R_BASE_S            (FMC_R_BASE_S + 0x0140UL)
#define FMC_Common_R_BASE_S             (FMC_R_BASE_S + 0x0020UL)
#define XSPI1_BASE_S                    (AHB5PERIPH_BASE_S + 0x5000UL)
#define PSSI_BASE_S                     (AHB5PERIPH_BASE_S + 0x6400UL)
#define SDMMC2_BASE_S                   (AHB5PERIPH_BASE_S + 0x6800UL)
#define DLYB_SDMMC2_BASE_S              (AHB5PERIPH_BASE_S + 0x6C00UL)
#define SDMMC1_BASE_S                   (AHB5PERIPH_BASE_S + 0x7000UL)
#define DLYB_SDMMC1_BASE_S              (AHB5PERIPH_BASE_S + 0x8000UL)
#define DCMI_BASE_S                     (AHB5PERIPH_BASE_S + 0x8400UL)
#define XSPI2_BASE_S                    (AHB5PERIPH_BASE_S + 0xA000UL)
#define XSPIM_BASE_S                    (AHB5PERIPH_BASE_S + 0xB400UL)
#define MCE1_BASE_S                     (AHB5PERIPH_BASE_S + 0xB800UL)
#define MCE1_REGION1_BASE_S             (MCE1_BASE_S + 0x040UL)
#define MCE1_REGION2_BASE_S             (MCE1_BASE_S + 0x050UL)
#define MCE1_REGION3_BASE_S             (MCE1_BASE_S + 0x060UL)
#define MCE1_REGION4_BASE_S             (MCE1_BASE_S + 0x070UL)
#define MCE1_CONTEXT1_BASE_S            (MCE1_BASE_S + 0x240UL)
#define MCE1_CONTEXT2_BASE_S            (MCE1_BASE_S + 0x270UL)
#define MCE2_BASE_S                     (AHB5PERIPH_BASE_S + 0xBC00UL)
#define MCE2_REGION1_BASE_S             (MCE2_BASE_S + 0x040UL)
#define MCE2_REGION2_BASE_S             (MCE2_BASE_S + 0x050UL)
#define MCE2_REGION3_BASE_S             (MCE2_BASE_S + 0x060UL)
#define MCE2_REGION4_BASE_S             (MCE2_BASE_S + 0x070UL)
#define MCE2_CONTEXT1_BASE_S            (MCE2_BASE_S + 0x240UL)
#define MCE2_CONTEXT2_BASE_S            (MCE2_BASE_S + 0x270UL)
#define MCE3_BASE_S                     (AHB5PERIPH_BASE_S + 0xC000UL)
#define MCE3_REGION1_BASE_S             (MCE3_BASE_S + 0x040UL)
#define MCE3_REGION2_BASE_S             (MCE3_BASE_S + 0x050UL)
#define MCE3_REGION3_BASE_S             (MCE3_BASE_S + 0x060UL)
#define MCE3_REGION4_BASE_S             (MCE3_BASE_S + 0x070UL)
#define MCE3_CONTEXT1_BASE_S            (MCE3_BASE_S + 0x240UL)
#define MCE3_CONTEXT2_BASE_S            (MCE3_BASE_S + 0x270UL)
#define MCE4_BASE_S                     (AHB5PERIPH_BASE_S + 0xE000UL)
#define MCE4_REGION1_BASE_S             (MCE4_BASE_S + 0x040UL)
#define MCE4_REGION2_BASE_S             (MCE4_BASE_S + 0x050UL)
#define MCE4_REGION3_BASE_S             (MCE4_BASE_S + 0x060UL)
#define MCE4_REGION4_BASE_S             (MCE4_BASE_S + 0x070UL)
#define MCE4_CONTEXT1_BASE_S            (MCE4_BASE_S + 0x240UL)
#define MCE4_CONTEXT2_BASE_S            (MCE4_BASE_S + 0x270UL)
#define XSPI3_BASE_S                    (AHB5PERIPH_BASE_S + 0xD000UL)
#define GFXMMU_BASE_S                   (AHB5PERIPH_BASE_S + 0x010000UL)
#define GPU2D_BASE_S                    (AHB5PERIPH_BASE_S + 0x014000UL)
#define GPUCACHE_BASE_S                 (AHB5PERIPH_BASE_S + 0x015000UL)
#define ICACHE_BASE_S                   (AHB5PERIPH_BASE_S + 0x015000UL)
#define ETH1_BASE_S                     (AHB5PERIPH_BASE_S + 0x016000UL)
#define ETH1_MAC_BASE_S                 (ETH1_BASE_S)
#define USB1_HS_PHYC_BASE_S             (AHB5PERIPH_BASE_S + 0x01FC00UL)
#define USB2_HS_PHYC_BASE_S             (AHB5PERIPH_BASE_S + 0x0A0000UL)
#define USB1_OTG_HS_BASE_S              (AHB5PERIPH_BASE_S + 0x020000UL)
#define USB2_OTG_HS_BASE_S              (AHB5PERIPH_BASE_S + 0x060000UL)
#define CACHEAXI_BASE_S                 (AHB5PERIPH_BASE_S + 0x0BFC00UL)
#define NPU_BASE_S                      (AHB5PERIPH_BASE_S + 0x0C0000UL)


/*!< Unique device ID register base address */
#define UID_BASE_S                      (0x56009014UL)

/*!< Revision ID base address */
#define REVID_BASE_S                    (BOOTROM_BASE_S + 0x0047ECUL)

#endif

/** @} */ /* End of group STM32N6xx_Peripheral_peripheralAddr */

/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */
/** @addtogroup STM32N6xx_Peripheral_declaration
  * @{
  */
#define ADC12_COMMON_NS           ((ADC_Common_TypeDef *) ADC12_COMMON_BASE_NS)
#define ADC1_NS                   ((ADC_TypeDef *) ADC1_BASE_NS)
#define ADC2_NS                   ((ADC_TypeDef *) ADC2_BASE_NS)
#define ADF1_NS                   ((MDF_TypeDef *) ADF1_BASE_NS)
#define ADF1_Filter0_NS           ((MDF_Filter_TypeDef *) ADF1_Filter0_BASE_NS)
#define BSEC_NS                   ((BSEC_TypeDef *) BSEC_BASE_NS)
#define CACHEAXI_NS               ((CACHEAXI_TypeDef *) CACHEAXI_BASE_NS)
#define CRC_NS                    ((CRC_TypeDef *) CRC_BASE_NS)
#define CRYP_NS                   ((CRYP_TypeDef *) CRYP_BASE_NS)
#define CSI_NS                    ((CSI_TypeDef *) CSI_BASE_NS)
#define DBGMCU_NS                 ((DBGMCU_TypeDef *) DBGMCU_BASE_NS)
#define DCMI_NS                   ((DCMI_TypeDef *) DCMI_BASE_NS)
#define DCMIPP_NS                 ((DCMIPP_TypeDef *) DCMIPP_BASE_NS)
#define DLYB_SDMMC1_NS            ((DLYB_TypeDef *) DLYB_SDMMC1_BASE_NS)
#define DLYB_SDMMC2_NS            ((DLYB_TypeDef *) DLYB_SDMMC2_BASE_NS)
#define DMA2D_NS                  ((DMA2D_TypeDef *) DMA2D_BASE_NS)
#define DTS_NS                    ((DTS_TypeDef *) DTS_BASE_NS)
#define DTS_Sensor0_NS            ((DTS_SensorTypeDef *) DTS_Sensor0_BASE_NS)
#define DTS_Sensor1_NS            ((DTS_SensorTypeDef *) DTS_Sensor1_BASE_NS)
#define ETH1_NS                   ((ETH_TypeDef *) ETH1_BASE_NS)
#define EXTI_NS                   ((EXTI_TypeDef *) EXTI_BASE_NS)
#define FDCAN1_NS                 ((FDCAN_GlobalTypeDef *) FDCAN1_BASE_NS)
#define FDCAN2_NS                 ((FDCAN_GlobalTypeDef *) FDCAN2_BASE_NS)
#define FDCAN3_NS                 ((FDCAN_GlobalTypeDef *) FDCAN3_BASE_NS)
#define FDCAN_CCU_NS              ((FDCAN_ClockCalibrationUnit_TypeDef *) FDCAN_CCU_BASE_NS)
#define FMC_Bank1E_R_NS           ((FMC_Bank1E_TypeDef *) FMC_Bank1E_R_BASE_NS)
#define FMC_Bank1_R_NS            ((FMC_Bank1_TypeDef *) FMC_Bank1_R_BASE_NS)
#define FMC_Bank3_R_NS            ((FMC_Bank3_TypeDef *) FMC_Bank3_R_BASE_NS)
#define FMC_Bank5_6_R_NS          ((FMC_Bank5_6_TypeDef *) FMC_Bank5_6_R_BASE_NS)
#define FMC_Common_R_NS           ((FMC_Common_TypeDef *) FMC_Common_R_BASE_NS)
#define GFXMMU_NS                 ((GFXMMU_TypeDef *) GFXMMU_BASE_NS)
#define GFXTIM_NS                 ((GFXTIM_TypeDef *) GFXTIM_BASE_NS)
#define GPDMA1_NS                 ((DMA_TypeDef *) GPDMA1_BASE_NS)
#define GPDMA1_Channel0_NS        ((DMA_Channel_TypeDef *) GPDMA1_Channel0_BASE_NS)
#define GPDMA1_Channel1_NS        ((DMA_Channel_TypeDef *) GPDMA1_Channel1_BASE_NS)
#define GPDMA1_Channel2_NS        ((DMA_Channel_TypeDef *) GPDMA1_Channel2_BASE_NS)
#define GPDMA1_Channel3_NS        ((DMA_Channel_TypeDef *) GPDMA1_Channel3_BASE_NS)
#define GPDMA1_Channel4_NS        ((DMA_Channel_TypeDef *) GPDMA1_Channel4_BASE_NS)
#define GPDMA1_Channel5_NS        ((DMA_Channel_TypeDef *) GPDMA1_Channel5_BASE_NS)
#define GPDMA1_Channel6_NS        ((DMA_Channel_TypeDef *) GPDMA1_Channel6_BASE_NS)
#define GPDMA1_Channel7_NS        ((DMA_Channel_TypeDef *) GPDMA1_Channel7_BASE_NS)
#define GPDMA1_Channel8_NS        ((DMA_Channel_TypeDef *) GPDMA1_Channel8_BASE_NS)
#define GPDMA1_Channel9_NS        ((DMA_Channel_TypeDef *) GPDMA1_Channel9_BASE_NS)
#define GPDMA1_Channel10_NS       ((DMA_Channel_TypeDef *) GPDMA1_Channel10_BASE_NS)
#define GPDMA1_Channel11_NS       ((DMA_Channel_TypeDef *) GPDMA1_Channel11_BASE_NS)
#define GPDMA1_Channel12_NS       ((DMA_Channel_TypeDef *) GPDMA1_Channel12_BASE_NS)
#define GPDMA1_Channel13_NS       ((DMA_Channel_TypeDef *) GPDMA1_Channel13_BASE_NS)
#define GPDMA1_Channel14_NS       ((DMA_Channel_TypeDef *) GPDMA1_Channel14_BASE_NS)
#define GPDMA1_Channel15_NS       ((DMA_Channel_TypeDef *) GPDMA1_Channel15_BASE_NS)
#define GPIOA_NS                  ((GPIO_TypeDef *) GPIOA_BASE_NS)
#define GPIOB_NS                  ((GPIO_TypeDef *) GPIOB_BASE_NS)
#define GPIOC_NS                  ((GPIO_TypeDef *) GPIOC_BASE_NS)
#define GPIOD_NS                  ((GPIO_TypeDef *) GPIOD_BASE_NS)
#define GPIOE_NS                  ((GPIO_TypeDef *) GPIOE_BASE_NS)
#define GPIOF_NS                  ((GPIO_TypeDef *) GPIOF_BASE_NS)
#define GPIOG_NS                  ((GPIO_TypeDef *) GPIOG_BASE_NS)
#define GPIOH_NS                  ((GPIO_TypeDef *) GPIOH_BASE_NS)
#define GPION_NS                  ((GPIO_TypeDef *) GPION_BASE_NS)
#define GPIOO_NS                  ((GPIO_TypeDef *) GPIOO_BASE_NS)
#define GPIOP_NS                  ((GPIO_TypeDef *) GPIOP_BASE_NS)
#define GPIOQ_NS                  ((GPIO_TypeDef *) GPIOQ_BASE_NS)
#define HASH_NS                   ((HASH_TypeDef *) HASH_BASE_NS)
#define HASH_DIGEST_NS            ((HASH_DIGEST_TypeDef *) HASH_DIGEST_BASE_NS)
#define HPDMA1_NS                 ((DMA_TypeDef *) HPDMA1_BASE_NS)
#define HPDMA1_Channel0_NS        ((DMA_Channel_TypeDef *) HPDMA1_Channel0_BASE_NS)
#define HPDMA1_Channel1_NS        ((DMA_Channel_TypeDef *) HPDMA1_Channel1_BASE_NS)
#define HPDMA1_Channel2_NS        ((DMA_Channel_TypeDef *) HPDMA1_Channel2_BASE_NS)
#define HPDMA1_Channel3_NS        ((DMA_Channel_TypeDef *) HPDMA1_Channel3_BASE_NS)
#define HPDMA1_Channel4_NS        ((DMA_Channel_TypeDef *) HPDMA1_Channel4_BASE_NS)
#define HPDMA1_Channel5_NS        ((DMA_Channel_TypeDef *) HPDMA1_Channel5_BASE_NS)
#define HPDMA1_Channel6_NS        ((DMA_Channel_TypeDef *) HPDMA1_Channel6_BASE_NS)
#define HPDMA1_Channel7_NS        ((DMA_Channel_TypeDef *) HPDMA1_Channel7_BASE_NS)
#define HPDMA1_Channel8_NS        ((DMA_Channel_TypeDef *) HPDMA1_Channel8_BASE_NS)
#define HPDMA1_Channel9_NS        ((DMA_Channel_TypeDef *) HPDMA1_Channel9_BASE_NS)
#define HPDMA1_Channel10_NS       ((DMA_Channel_TypeDef *) HPDMA1_Channel10_BASE_NS)
#define HPDMA1_Channel11_NS       ((DMA_Channel_TypeDef *) HPDMA1_Channel11_BASE_NS)
#define HPDMA1_Channel12_NS       ((DMA_Channel_TypeDef *) HPDMA1_Channel12_BASE_NS)
#define HPDMA1_Channel13_NS       ((DMA_Channel_TypeDef *) HPDMA1_Channel13_BASE_NS)
#define HPDMA1_Channel14_NS       ((DMA_Channel_TypeDef *) HPDMA1_Channel14_BASE_NS)
#define HPDMA1_Channel15_NS       ((DMA_Channel_TypeDef *) HPDMA1_Channel15_BASE_NS)
#define I2C1_NS                   ((I2C_TypeDef *) I2C1_BASE_NS)
#define I2C2_NS                   ((I2C_TypeDef *) I2C2_BASE_NS)
#define I2C3_NS                   ((I2C_TypeDef *) I2C3_BASE_NS)
#define I2C4_NS                   ((I2C_TypeDef *) I2C4_BASE_NS)
#define I3C1_NS                   ((I3C_TypeDef *) I3C1_BASE_NS)
#define I3C2_NS                   ((I3C_TypeDef *) I3C2_BASE_NS)
#define ICACHE_NS                 ((ICACHE_TypeDef *) ICACHE_BASE_NS)
#define IWDG_NS                   ((IWDG_TypeDef *) IWDG_BASE_NS)
#define JPEG_NS                   ((JPEG_TypeDef *) JPEG_BASE_NS)
#define LPTIM1_NS                 ((LPTIM_TypeDef *) LPTIM1_BASE_NS)
#define LPTIM2_NS                 ((LPTIM_TypeDef *) LPTIM2_BASE_NS)
#define LPTIM3_NS                 ((LPTIM_TypeDef *) LPTIM3_BASE_NS)
#define LPTIM4_NS                 ((LPTIM_TypeDef *) LPTIM4_BASE_NS)
#define LPTIM5_NS                 ((LPTIM_TypeDef *) LPTIM5_BASE_NS)
#define LPUART1_NS                ((USART_TypeDef *) LPUART1_BASE_NS)
#define LTDC_NS                   ((LTDC_TypeDef *)LTDC_BASE_NS)
#define LTDC_Layer1_NS            ((LTDC_Layer_TypeDef *)LTDC_Layer1_BASE_NS)
#define LTDC_Layer2_NS            ((LTDC_Layer_TypeDef *)LTDC_Layer2_BASE_NS)
#define MCE1_NS                   ((MCE_TypeDef *) MCE1_BASE_NS)
#define MCE1_REGION1_NS           ((MCE_Region_TypeDef *) MCE1_REGION1_BASE_NS)
#define MCE1_REGION2_NS           ((MCE_Region_TypeDef *) MCE1_REGION2_BASE_NS)
#define MCE1_REGION3_NS           ((MCE_Region_TypeDef *) MCE1_REGION3_BASE_NS)
#define MCE1_REGION4_NS           ((MCE_Region_TypeDef *) MCE1_REGION4_BASE_NS)
#define MCE1_CONTEXT1_NS          ((MCE_Context_TypeDef *) MCE1_CONTEXT1_BASE_NS)
#define MCE1_CONTEXT2_NS          ((MCE_Context_TypeDef *) MCE1_CONTEXT2_BASE_NS)
#define MCE2_NS                   ((MCE_TypeDef *) MCE2_BASE_NS)
#define MCE2_REGION1_NS           ((MCE_Region_TypeDef *) MCE2_REGION1_BASE_NS)
#define MCE2_REGION2_NS           ((MCE_Region_TypeDef *) MCE2_REGION2_BASE_NS)
#define MCE2_REGION3_NS           ((MCE_Region_TypeDef *) MCE2_REGION3_BASE_NS)
#define MCE2_REGION4_NS           ((MCE_Region_TypeDef *) MCE2_REGION4_BASE_NS)
#define MCE2_CONTEXT1_NS          ((MCE_Context_TypeDef *) MCE2_CONTEXT1_BASE_NS)
#define MCE2_CONTEXT2_NS          ((MCE_Context_TypeDef *) MCE2_CONTEXT2_BASE_NS)
#define MCE3_NS                   ((MCE_TypeDef *) MCE3_BASE_NS)
#define MCE3_REGION1_NS           ((MCE_Region_TypeDef *) MCE3_REGION1_BASE_NS)
#define MCE3_REGION2_NS           ((MCE_Region_TypeDef *) MCE3_REGION2_BASE_NS)
#define MCE3_REGION3_NS           ((MCE_Region_TypeDef *) MCE3_REGION3_BASE_NS)
#define MCE3_REGION4_NS           ((MCE_Region_TypeDef *) MCE3_REGION4_BASE_NS)
#define MCE3_CONTEXT1_NS          ((MCE_Context_TypeDef *) MCE3_CONTEXT1_BASE_NS)
#define MCE3_CONTEXT2_NS          ((MCE_Context_TypeDef *) MCE3_CONTEXT2_BASE_NS)
#define MCE4_NS                   ((MCE_TypeDef *) MCE4_BASE_NS)
#define MCE4_REGION1_NS           ((MCE_Region_TypeDef *) MCE4_REGION1_BASE_NS)
#define MCE4_REGION2_NS           ((MCE_Region_TypeDef *) MCE4_REGION2_BASE_NS)
#define MCE4_REGION3_NS           ((MCE_Region_TypeDef *) MCE4_REGION3_BASE_NS)
#define MCE4_REGION4_NS           ((MCE_Region_TypeDef *) MCE4_REGION4_BASE_NS)
#define MCE4_CONTEXT1_NS          ((MCE_Context_TypeDef *) MCE4_CONTEXT1_BASE_NS)
#define MCE4_CONTEXT2_NS          ((MCE_Context_TypeDef *) MCE4_CONTEXT2_BASE_NS)
#define MDF1_NS                   ((MDF_TypeDef *) MDF1_BASE_NS)
#define MDF1_Filter0_NS           ((MDF_Filter_TypeDef *) MDF1_Filter0_BASE_NS)
#define MDF1_Filter1_NS           ((MDF_Filter_TypeDef *) MDF1_Filter1_BASE_NS)
#define MDF1_Filter2_NS           ((MDF_Filter_TypeDef *) MDF1_Filter2_BASE_NS)
#define MDF1_Filter3_NS           ((MDF_Filter_TypeDef *) MDF1_Filter3_BASE_NS)
#define MDF1_Filter4_NS           ((MDF_Filter_TypeDef *) MDF1_Filter4_BASE_NS)
#define MDF1_Filter5_NS           ((MDF_Filter_TypeDef *) MDF1_Filter5_BASE_NS)
#define MDIOS_NS                  ((MDIOS_TypeDef *) MDIOS_BASE_NS)
#define PKA_NS                    ((PKA_TypeDef *) PKA_BASE_NS)
#define PSSI_NS                   ((PSSI_TypeDef *) PSSI_BASE_NS)
#define PWR_NS                    ((PWR_TypeDef *) PWR_BASE_NS)
#define RAMCFG_NS                 ((RAMCFG_TypeDef *) RAMCFG_BASE_NS)
#define RAMCFG_SRAM1_AXI_NS       ((RAMCFG_TypeDef *) RAMCFG_SRAM1_AXI_BASE_NS)
#define RAMCFG_SRAM2_AXI_NS       ((RAMCFG_TypeDef *) RAMCFG_SRAM2_AXI_BASE_NS)
#define RAMCFG_SRAM3_AXI_NS       ((RAMCFG_TypeDef *) RAMCFG_SRAM3_AXI_BASE_NS)
#define RAMCFG_SRAM4_AXI_NS       ((RAMCFG_TypeDef *) RAMCFG_SRAM4_AXI_BASE_NS)
#define RAMCFG_SRAM5_AXI_NS       ((RAMCFG_TypeDef *) RAMCFG_SRAM5_AXI_BASE_NS)
#define RAMCFG_SRAM6_AXI_NS       ((RAMCFG_TypeDef *) RAMCFG_SRAM6_AXI_BASE_NS)
#define RAMCFG_SRAM1_AHB_NS       ((RAMCFG_TypeDef *) RAMCFG_SRAM1_AHB_BASE_NS)
#define RAMCFG_SRAM2_AHB_NS       ((RAMCFG_TypeDef *) RAMCFG_SRAM2_AHB_BASE_NS)
#define RAMCFG_VENC_RAM_NS        ((RAMCFG_TypeDef *) RAMCFG_VENC_RAM_BASE_NS)
#define RAMCFG_BKPSRAM_NS         ((RAMCFG_TypeDef *) RAMCFG_BKPSRAM_BASE_NS)
#define RAMCFG_FLEXRAM_NS         ((RAMCFG_TypeDef *) RAMCFG_FLEXRAM_BASE_NS)
#define RCC_NS                    ((RCC_TypeDef *) RCC_BASE_NS)
#define RIFSC_NS                  ((RIFSC_TypeDef *) RIFSC_BASE_NS)
#define RISAF1_NS                 ((RISAF_TypeDef *) RISAF1_BASE_NS)
#define RISAF2_NS                 ((RISAF_TypeDef *) RISAF2_BASE_NS)
#define RISAF3_NS                 ((RISAF_TypeDef *) RISAF3_BASE_NS)
#define RISAF4_NS                 ((RISAF_TypeDef *) RISAF4_BASE_NS)
#define RISAF5_NS                 ((RISAF_TypeDef *) RISAF5_BASE_NS)
#define RISAF6_NS                 ((RISAF_TypeDef *) RISAF6_BASE_NS)
#define RISAF7_NS                 ((RISAF_TypeDef *) RISAF7_BASE_NS)
#define RISAF8_NS                 ((RISAF_TypeDef *) RISAF8_BASE_NS)
#define RISAF9_NS                 ((RISAF_TypeDef *) RISAF9_BASE_NS)
#define RISAF11_NS                ((RISAF_TypeDef *) RISAF11_BASE_NS)
#define RISAF12_NS                ((RISAF_TypeDef *) RISAF12_BASE_NS)
#define RISAF13_NS                ((RISAF_TypeDef *) RISAF13_BASE_NS)
#define RISAF14_NS                ((RISAF_TypeDef *) RISAF14_BASE_NS)
#define RISAF15_NS                ((RISAF_TypeDef *) RISAF15_BASE_NS)
#define RISAF21_NS                ((RISAF_TypeDef *) RISAF21_BASE_NS)
#define RISAF22_NS                ((RISAF_TypeDef *) RISAF22_BASE_NS)
#define RISAF23_NS                ((RISAF_TypeDef *) RISAF23_BASE_NS)
#define RNG_NS                    ((RNG_TypeDef *) RNG_BASE_NS)
#define RTC_NS                    ((RTC_TypeDef *) RTC_BASE_NS)
#define SAES_NS                   ((SAES_TypeDef *) SAES_BASE_NS)
#define SAI1_NS                   ((SAI_TypeDef *) SAI1_BASE_NS)
#define SAI1_Block_A_NS           ((SAI_Block_TypeDef *) SAI1_Block_A_BASE_NS)
#define SAI1_Block_B_NS           ((SAI_Block_TypeDef *) SAI1_Block_B_BASE_NS)
#define SAI2_NS                   ((SAI_TypeDef *) SAI2_BASE_NS)
#define SAI2_Block_A_NS           ((SAI_Block_TypeDef *) SAI2_Block_A_BASE_NS)
#define SAI2_Block_B_NS           ((SAI_Block_TypeDef *) SAI2_Block_B_BASE_NS)
#define SDMMC1_NS                 ((SDMMC_TypeDef *) SDMMC1_BASE_NS)
#define SDMMC2_NS                 ((SDMMC_TypeDef *) SDMMC2_BASE_NS)
#define SPDIFRX_NS                ((SPDIFRX_TypeDef *) SPDIFRX_BASE_NS)
#define SPI1_NS                   ((SPI_TypeDef *) SPI1_BASE_NS)
#define SPI2_NS                   ((SPI_TypeDef *) SPI2_BASE_NS)
#define SPI3_NS                   ((SPI_TypeDef *) SPI3_BASE_NS)
#define SPI4_NS                   ((SPI_TypeDef *) SPI4_BASE_NS)
#define SPI5_NS                   ((SPI_TypeDef *) SPI5_BASE_NS)
#define SPI6_NS                   ((SPI_TypeDef *) SPI6_BASE_NS)
#define SYSCFG_NS                 ((SYSCFG_TypeDef *) SYSCFG_BASE_NS)
#define TAMP_NS                   ((TAMP_TypeDef *) TAMP_BASE_NS)
#define TIM1_NS                   ((TIM_TypeDef *) TIM1_BASE_NS)
#define TIM2_NS                   ((TIM_TypeDef *) TIM2_BASE_NS)
#define TIM3_NS                   ((TIM_TypeDef *) TIM3_BASE_NS)
#define TIM4_NS                   ((TIM_TypeDef *) TIM4_BASE_NS)
#define TIM5_NS                   ((TIM_TypeDef *) TIM5_BASE_NS)
#define TIM6_NS                   ((TIM_TypeDef *) TIM6_BASE_NS)
#define TIM7_NS                   ((TIM_TypeDef *) TIM7_BASE_NS)
#define TIM8_NS                   ((TIM_TypeDef *) TIM8_BASE_NS)
#define TIM9_NS                   ((TIM_TypeDef *) TIM9_BASE_NS)
#define TIM10_NS                  ((TIM_TypeDef *) TIM10_BASE_NS)
#define TIM11_NS                  ((TIM_TypeDef *) TIM11_BASE_NS)
#define TIM12_NS                  ((TIM_TypeDef *) TIM12_BASE_NS)
#define TIM13_NS                  ((TIM_TypeDef *) TIM13_BASE_NS)
#define TIM14_NS                  ((TIM_TypeDef *) TIM14_BASE_NS)
#define TIM15_NS                  ((TIM_TypeDef *) TIM15_BASE_NS)
#define TIM16_NS                  ((TIM_TypeDef *) TIM16_BASE_NS)
#define TIM17_NS                  ((TIM_TypeDef *) TIM17_BASE_NS)
#define TIM18_NS                  ((TIM_TypeDef *) TIM18_BASE_NS)
#define UART4_NS                  ((USART_TypeDef *) UART4_BASE_NS)
#define UART5_NS                  ((USART_TypeDef *) UART5_BASE_NS)
#define UART7_NS                  ((USART_TypeDef *) UART7_BASE_NS)
#define UART8_NS                  ((USART_TypeDef *) UART8_BASE_NS)
#define UART9_NS                  ((USART_TypeDef *) UART9_BASE_NS)
#define UCPD1_NS                  ((UCPD_TypeDef *) UCPD1_BASE_NS)
#define USART1_NS                 ((USART_TypeDef *) USART1_BASE_NS)
#define USART2_NS                 ((USART_TypeDef *) USART2_BASE_NS)
#define USART3_NS                 ((USART_TypeDef *) USART3_BASE_NS)
#define USART6_NS                 ((USART_TypeDef *) USART6_BASE_NS)
#define USART10_NS                ((USART_TypeDef *) USART10_BASE_NS)
#define USB1_OTG_HS_NS            ((USB_OTG_GlobalTypeDef *) USB1_OTG_HS_BASE_NS)
#define USB2_OTG_HS_NS            ((USB_OTG_GlobalTypeDef *) USB2_OTG_HS_BASE_NS)
#define USB1_HS_PHYC_NS           ((USB_HS_PHYC_GlobalTypeDef *) USB1_HS_PHYC_BASE_NS)
#define USB2_HS_PHYC_NS           ((USB_HS_PHYC_GlobalTypeDef *) USB2_HS_PHYC_BASE_NS)
#define VENC_NS                   ((VENC_TypeDef *) VENC_BASE_NS)
#define VREFBUF_NS                ((VREFBUF_TypeDef *) VREFBUF_BASE_NS)
#define WWDG_NS                   ((WWDG_TypeDef *) WWDG_BASE_NS)
#define XSPI1_NS                  ((XSPI_TypeDef *) XSPI1_BASE_NS)
#define XSPI2_NS                  ((XSPI_TypeDef *) XSPI2_BASE_NS)
#define XSPI3_NS                  ((XSPI_TypeDef *) XSPI3_BASE_NS)
#define XSPIM_NS                  ((XSPIM_TypeDef *) XSPIM_BASE_NS)

#if defined (CPU_IN_SECURE_STATE)
#define ADC12_COMMON_S            ((ADC_Common_TypeDef *) ADC12_COMMON_BASE_S)
#define ADC1_S                    ((ADC_TypeDef *) ADC1_BASE_S)
#define ADC2_S                    ((ADC_TypeDef *) ADC2_BASE_S)
#define ADF1_S                    ((MDF_TypeDef *) ADF1_BASE_S)
#define ADF1_Filter0_S            ((MDF_Filter_TypeDef *) ADF1_Filter0_BASE_S)
#define BSEC_S                    ((BSEC_TypeDef *) BSEC_BASE_S)
#define CACHEAXI_S                ((CACHEAXI_TypeDef *) CACHEAXI_BASE_S)
#define CRC_S                     ((CRC_TypeDef *) CRC_BASE_S)
#define CRYP_S                    ((CRYP_TypeDef *) CRYP_BASE_S)
#define CSI_S                     ((CSI_TypeDef *) CSI_BASE_S)
#define DBGMCU_S                  ((DBGMCU_TypeDef *) DBGMCU_BASE_S)
#define DCMI_S                    ((DCMI_TypeDef *) DCMI_BASE_S)
#define DCMIPP_S                  ((DCMIPP_TypeDef *) DCMIPP_BASE_S)
#define DLYB_SDMMC1_S             ((DLYB_TypeDef *) DLYB_SDMMC1_BASE_S)
#define DLYB_SDMMC2_S             ((DLYB_TypeDef *) DLYB_SDMMC2_BASE_S)
#define DMA2D_S                   ((DMA2D_TypeDef *) DMA2D_BASE_S)
#define DTS_S                     ((DTS_TypeDef *) DTS_BASE_S)
#define DTS_Sensor0_S             ((DTS_SensorTypeDef *) DTS_Sensor0_BASE_S)
#define DTS_Sensor1_S             ((DTS_SensorTypeDef *) DTS_Sensor1_BASE_S)
#define ETH1_S                    ((ETH_TypeDef *) ETH1_BASE_S)
#define EXTI_S                    ((EXTI_TypeDef *) EXTI_BASE_S)
#define FDCAN1_S                  ((FDCAN_GlobalTypeDef *) FDCAN1_BASE_S)
#define FDCAN2_S                  ((FDCAN_GlobalTypeDef *) FDCAN2_BASE_S)
#define FDCAN3_S                  ((FDCAN_GlobalTypeDef *) FDCAN3_BASE_S)
#define FDCAN_CCU_S               ((FDCAN_ClockCalibrationUnit_TypeDef *) FDCAN_CCU_BASE_S)
#define FMC_Bank1E_R_S            ((FMC_Bank1E_TypeDef *) FMC_Bank1E_R_BASE_S)
#define FMC_Bank1_R_S             ((FMC_Bank1_TypeDef *) FMC_Bank1_R_BASE_S)
#define FMC_Bank3_R_S             ((FMC_Bank3_TypeDef *) FMC_Bank3_R_BASE_S)
#define FMC_Bank5_6_R_S           ((FMC_Bank5_6_TypeDef *) FMC_Bank5_6_R_BASE_S)
#define FMC_Common_R_S            ((FMC_Common_TypeDef *) FMC_Common_R_BASE_S)
#define GFXMMU_S                  ((GFXMMU_TypeDef *) GFXMMU_BASE_S)
#define GFXTIM_S                  ((GFXTIM_TypeDef *) GFXTIM_BASE_S)
#define GPDMA1_S                  ((DMA_TypeDef *) GPDMA1_BASE_S)
#define GPDMA1_Channel0_S         ((DMA_Channel_TypeDef *) GPDMA1_Channel0_BASE_S)
#define GPDMA1_Channel1_S         ((DMA_Channel_TypeDef *) GPDMA1_Channel1_BASE_S)
#define GPDMA1_Channel2_S         ((DMA_Channel_TypeDef *) GPDMA1_Channel2_BASE_S)
#define GPDMA1_Channel3_S         ((DMA_Channel_TypeDef *) GPDMA1_Channel3_BASE_S)
#define GPDMA1_Channel4_S         ((DMA_Channel_TypeDef *) GPDMA1_Channel4_BASE_S)
#define GPDMA1_Channel5_S         ((DMA_Channel_TypeDef *) GPDMA1_Channel5_BASE_S)
#define GPDMA1_Channel6_S         ((DMA_Channel_TypeDef *) GPDMA1_Channel6_BASE_S)
#define GPDMA1_Channel7_S         ((DMA_Channel_TypeDef *) GPDMA1_Channel7_BASE_S)
#define GPDMA1_Channel8_S         ((DMA_Channel_TypeDef *) GPDMA1_Channel8_BASE_S)
#define GPDMA1_Channel9_S         ((DMA_Channel_TypeDef *) GPDMA1_Channel9_BASE_S)
#define GPDMA1_Channel10_S        ((DMA_Channel_TypeDef *) GPDMA1_Channel10_BASE_S)
#define GPDMA1_Channel11_S        ((DMA_Channel_TypeDef *) GPDMA1_Channel11_BASE_S)
#define GPDMA1_Channel12_S        ((DMA_Channel_TypeDef *) GPDMA1_Channel12_BASE_S)
#define GPDMA1_Channel13_S        ((DMA_Channel_TypeDef *) GPDMA1_Channel13_BASE_S)
#define GPDMA1_Channel14_S        ((DMA_Channel_TypeDef *) GPDMA1_Channel14_BASE_S)
#define GPDMA1_Channel15_S        ((DMA_Channel_TypeDef *) GPDMA1_Channel15_BASE_S)
#define GPIOA_S                   ((GPIO_TypeDef *) GPIOA_BASE_S)
#define GPIOB_S                   ((GPIO_TypeDef *) GPIOB_BASE_S)
#define GPIOC_S                   ((GPIO_TypeDef *) GPIOC_BASE_S)
#define GPIOD_S                   ((GPIO_TypeDef *) GPIOD_BASE_S)
#define GPIOE_S                   ((GPIO_TypeDef *) GPIOE_BASE_S)
#define GPIOF_S                   ((GPIO_TypeDef *) GPIOF_BASE_S)
#define GPIOG_S                   ((GPIO_TypeDef *) GPIOG_BASE_S)
#define GPIOH_S                   ((GPIO_TypeDef *) GPIOH_BASE_S)
#define GPION_S                   ((GPIO_TypeDef *) GPION_BASE_S)
#define GPIOO_S                   ((GPIO_TypeDef *) GPIOO_BASE_S)
#define GPIOP_S                   ((GPIO_TypeDef *) GPIOP_BASE_S)
#define GPIOQ_S                   ((GPIO_TypeDef *) GPIOQ_BASE_S)
#define HASH_S                    ((HASH_TypeDef *) HASH_BASE_S)
#define HASH_DIGEST_S             ((HASH_DIGEST_TypeDef *) HASH_DIGEST_BASE_S)
#define HPDMA1_S                  ((DMA_TypeDef *) HPDMA1_BASE_S)
#define HPDMA1_Channel0_S         ((DMA_Channel_TypeDef *) HPDMA1_Channel0_BASE_S)
#define HPDMA1_Channel1_S         ((DMA_Channel_TypeDef *) HPDMA1_Channel1_BASE_S)
#define HPDMA1_Channel2_S         ((DMA_Channel_TypeDef *) HPDMA1_Channel2_BASE_S)
#define HPDMA1_Channel3_S         ((DMA_Channel_TypeDef *) HPDMA1_Channel3_BASE_S)
#define HPDMA1_Channel4_S         ((DMA_Channel_TypeDef *) HPDMA1_Channel4_BASE_S)
#define HPDMA1_Channel5_S         ((DMA_Channel_TypeDef *) HPDMA1_Channel5_BASE_S)
#define HPDMA1_Channel6_S         ((DMA_Channel_TypeDef *) HPDMA1_Channel6_BASE_S)
#define HPDMA1_Channel7_S         ((DMA_Channel_TypeDef *) HPDMA1_Channel7_BASE_S)
#define HPDMA1_Channel8_S         ((DMA_Channel_TypeDef *) HPDMA1_Channel8_BASE_S)
#define HPDMA1_Channel9_S         ((DMA_Channel_TypeDef *) HPDMA1_Channel9_BASE_S)
#define HPDMA1_Channel10_S        ((DMA_Channel_TypeDef *) HPDMA1_Channel10_BASE_S)
#define HPDMA1_Channel11_S        ((DMA_Channel_TypeDef *) HPDMA1_Channel11_BASE_S)
#define HPDMA1_Channel12_S        ((DMA_Channel_TypeDef *) HPDMA1_Channel12_BASE_S)
#define HPDMA1_Channel13_S        ((DMA_Channel_TypeDef *) HPDMA1_Channel13_BASE_S)
#define HPDMA1_Channel14_S        ((DMA_Channel_TypeDef *) HPDMA1_Channel14_BASE_S)
#define HPDMA1_Channel15_S        ((DMA_Channel_TypeDef *) HPDMA1_Channel15_BASE_S)
#define I2C1_S                    ((I2C_TypeDef *) I2C1_BASE_S)
#define I2C2_S                    ((I2C_TypeDef *) I2C2_BASE_S)
#define I2C3_S                    ((I2C_TypeDef *) I2C3_BASE_S)
#define I2C4_S                    ((I2C_TypeDef *) I2C4_BASE_S)
#define I3C1_S                    ((I3C_TypeDef *) I3C1_BASE_S)
#define I3C2_S                    ((I3C_TypeDef *) I3C2_BASE_S)
#define IAC_S                     ((IAC_TypeDef *) IAC_BASE_S)
#define ICACHE_S                  ((ICACHE_TypeDef *) ICACHE_BASE_S)
#define IWDG_S                    ((IWDG_TypeDef *) IWDG_BASE_S)
#define JPEG_S                    ((JPEG_TypeDef *) JPEG_BASE_S)
#define LPTIM1_S                  ((LPTIM_TypeDef *) LPTIM1_BASE_S)
#define LPTIM2_S                  ((LPTIM_TypeDef *) LPTIM2_BASE_S)
#define LPTIM3_S                  ((LPTIM_TypeDef *) LPTIM3_BASE_S)
#define LPTIM4_S                  ((LPTIM_TypeDef *) LPTIM4_BASE_S)
#define LPTIM5_S                  ((LPTIM_TypeDef *) LPTIM5_BASE_S)
#define LPUART1_S                 ((USART_TypeDef *) LPUART1_BASE_S)
#define LTDC_S                    ((LTDC_TypeDef *)LTDC_BASE_S)
#define LTDC_Layer1_S             ((LTDC_Layer_TypeDef *)LTDC_Layer1_BASE_S)
#define LTDC_Layer2_S             ((LTDC_Layer_TypeDef *)LTDC_Layer2_BASE_S)
#define MCE1_S                    ((MCE_TypeDef *) MCE1_BASE_S)
#define MCE1_REGION1_S            ((MCE_Region_TypeDef *) MCE1_REGION1_BASE_S)
#define MCE1_REGION2_S            ((MCE_Region_TypeDef *) MCE1_REGION2_BASE_S)
#define MCE1_REGION3_S            ((MCE_Region_TypeDef *) MCE1_REGION3_BASE_S)
#define MCE1_REGION4_S            ((MCE_Region_TypeDef *) MCE1_REGION4_BASE_S)
#define MCE1_CONTEXT1_S           ((MCE_Context_TypeDef *) MCE1_CONTEXT1_BASE_S)
#define MCE1_CONTEXT2_S           ((MCE_Context_TypeDef *) MCE1_CONTEXT2_BASE_S)
#define MCE2_S                    ((MCE_TypeDef *) MCE2_BASE_S)
#define MCE2_REGION1_S            ((MCE_Region_TypeDef *) MCE2_REGION1_BASE_S)
#define MCE2_REGION2_S            ((MCE_Region_TypeDef *) MCE2_REGION2_BASE_S)
#define MCE2_REGION3_S            ((MCE_Region_TypeDef *) MCE2_REGION3_BASE_S)
#define MCE2_REGION4_S            ((MCE_Region_TypeDef *) MCE2_REGION4_BASE_S)
#define MCE2_CONTEXT1_S           ((MCE_Context_TypeDef *) MCE2_CONTEXT1_BASE_S)
#define MCE2_CONTEXT2_S           ((MCE_Context_TypeDef *) MCE2_CONTEXT2_BASE_S)
#define MCE3_S                    ((MCE_TypeDef *) MCE3_BASE_S)
#define MCE3_REGION1_S            ((MCE_Region_TypeDef *) MCE3_REGION1_BASE_S)
#define MCE3_REGION2_S            ((MCE_Region_TypeDef *) MCE3_REGION2_BASE_S)
#define MCE3_REGION3_S            ((MCE_Region_TypeDef *) MCE3_REGION3_BASE_S)
#define MCE3_REGION4_S            ((MCE_Region_TypeDef *) MCE3_REGION4_BASE_S)
#define MCE3_CONTEXT1_S           ((MCE_Context_TypeDef *) MCE3_CONTEXT1_BASE_S)
#define MCE3_CONTEXT2_S           ((MCE_Context_TypeDef *) MCE3_CONTEXT2_BASE_S)
#define MCE4_S                    ((MCE_TypeDef *) MCE4_BASE_S)
#define MCE4_REGION1_S            ((MCE_Region_TypeDef *) MCE4_REGION1_BASE_S)
#define MCE4_REGION2_S            ((MCE_Region_TypeDef *) MCE4_REGION2_BASE_S)
#define MCE4_REGION3_S            ((MCE_Region_TypeDef *) MCE4_REGION3_BASE_S)
#define MCE4_REGION4_S            ((MCE_Region_TypeDef *) MCE4_REGION4_BASE_S)
#define MCE4_CONTEXT1_S           ((MCE_Context_TypeDef *) MCE4_CONTEXT1_BASE_S)
#define MCE4_CONTEXT2_S           ((MCE_Context_TypeDef *) MCE4_CONTEXT2_BASE_S)
#define MDF1_S                    ((MDF_TypeDef *) MDF1_BASE_S)
#define MDF1_Filter0_S            ((MDF_Filter_TypeDef *) MDF1_Filter0_BASE_S)
#define MDF1_Filter1_S            ((MDF_Filter_TypeDef *) MDF1_Filter1_BASE_S)
#define MDF1_Filter2_S            ((MDF_Filter_TypeDef *) MDF1_Filter2_BASE_S)
#define MDF1_Filter3_S            ((MDF_Filter_TypeDef *) MDF1_Filter3_BASE_S)
#define MDF1_Filter4_S            ((MDF_Filter_TypeDef *) MDF1_Filter4_BASE_S)
#define MDF1_Filter5_S            ((MDF_Filter_TypeDef *) MDF1_Filter5_BASE_S)
#define MDIOS_S                   ((MDIOS_TypeDef *) MDIOS_BASE_S)
#define PKA_S                     ((PKA_TypeDef *) PKA_BASE_S)
#define PSSI_S                    ((PSSI_TypeDef *) PSSI_BASE_S)
#define PWR_S                     ((PWR_TypeDef *) PWR_BASE_S)
#define RAMCFG_S                  ((RAMCFG_TypeDef *) RAMCFG_BASE_S)
#define RAMCFG_SRAM1_AXI_S        ((RAMCFG_TypeDef *) RAMCFG_SRAM1_AXI_BASE_S)
#define RAMCFG_SRAM2_AXI_S        ((RAMCFG_TypeDef *) RAMCFG_SRAM2_AXI_BASE_S)
#define RAMCFG_SRAM3_AXI_S        ((RAMCFG_TypeDef *) RAMCFG_SRAM3_AXI_BASE_S)
#define RAMCFG_SRAM4_AXI_S        ((RAMCFG_TypeDef *) RAMCFG_SRAM4_AXI_BASE_S)
#define RAMCFG_SRAM5_AXI_S        ((RAMCFG_TypeDef *) RAMCFG_SRAM5_AXI_BASE_S)
#define RAMCFG_SRAM6_AXI_S        ((RAMCFG_TypeDef *) RAMCFG_SRAM6_AXI_BASE_S)
#define RAMCFG_SRAM1_AHB_S        ((RAMCFG_TypeDef *) RAMCFG_SRAM1_AHB_BASE_S)
#define RAMCFG_SRAM2_AHB_S        ((RAMCFG_TypeDef *) RAMCFG_SRAM2_AHB_BASE_S)
#define RAMCFG_VENC_RAM_S         ((RAMCFG_TypeDef *) RAMCFG_VENC_RAM_BASE_NS)
#define RAMCFG_BKPSRAM_S          ((RAMCFG_TypeDef *) RAMCFG_BKPSRAM_BASE_S)
#define RAMCFG_FLEXRAM_S          ((RAMCFG_TypeDef *) RAMCFG_FLEXRAM_BASE_S)
#define RCC_S                     ((RCC_TypeDef *) RCC_BASE_S)
#define RIFSC_S                   ((RIFSC_TypeDef *) RIFSC_BASE_S)
#define RISAF1_S                  ((RISAF_TypeDef *) RISAF1_BASE_S)
#define RISAF2_S                  ((RISAF_TypeDef *) RISAF2_BASE_S)
#define RISAF3_S                  ((RISAF_TypeDef *) RISAF3_BASE_S)
#define RISAF4_S                  ((RISAF_TypeDef *) RISAF4_BASE_S)
#define RISAF5_S                  ((RISAF_TypeDef *) RISAF5_BASE_S)
#define RISAF6_S                  ((RISAF_TypeDef *) RISAF6_BASE_S)
#define RISAF7_S                  ((RISAF_TypeDef *) RISAF7_BASE_S)
#define RISAF8_S                  ((RISAF_TypeDef *) RISAF8_BASE_S)
#define RISAF9_S                  ((RISAF_TypeDef *) RISAF9_BASE_S)
#define RISAF11_S                 ((RISAF_TypeDef *) RISAF11_BASE_S)
#define RISAF12_S                 ((RISAF_TypeDef *) RISAF12_BASE_S)
#define RISAF13_S                 ((RISAF_TypeDef *) RISAF13_BASE_S)
#define RISAF14_S                 ((RISAF_TypeDef *) RISAF14_BASE_S)
#define RISAF15_S                 ((RISAF_TypeDef *) RISAF15_BASE_S)
#define RISAF21_S                 ((RISAF_TypeDef *) RISAF21_BASE_S)
#define RISAF22_S                 ((RISAF_TypeDef *) RISAF22_BASE_S)
#define RISAF23_S                 ((RISAF_TypeDef *) RISAF23_BASE_S)
#define RNG_S                     ((RNG_TypeDef *) RNG_BASE_S)
#define RTC_S                     ((RTC_TypeDef *) RTC_BASE_S)
#define SAES_S                    ((SAES_TypeDef *) SAES_BASE_S)
#define SAI1_S                    ((SAI_TypeDef *) SAI1_BASE_S)
#define SAI1_Block_A_S            ((SAI_Block_TypeDef *) SAI1_Block_A_BASE_S)
#define SAI1_Block_B_S            ((SAI_Block_TypeDef *) SAI1_Block_B_BASE_S)
#define SAI2_S                    ((SAI_TypeDef *) SAI2_BASE_S)
#define SAI2_Block_A_S            ((SAI_Block_TypeDef *) SAI2_Block_A_BASE_S)
#define SAI2_Block_B_S            ((SAI_Block_TypeDef *) SAI2_Block_B_BASE_S)
#define SDMMC1_S                  ((SDMMC_TypeDef *) SDMMC1_BASE_S)
#define SDMMC2_S                  ((SDMMC_TypeDef *) SDMMC2_BASE_S)
#define SPDIFRX_S                 ((SPDIFRX_TypeDef *) SPDIFRX_BASE_S)
#define SPI1_S                    ((SPI_TypeDef *) SPI1_BASE_S)
#define SPI2_S                    ((SPI_TypeDef *) SPI2_BASE_S)
#define SPI3_S                    ((SPI_TypeDef *) SPI3_BASE_S)
#define SPI4_S                    ((SPI_TypeDef *) SPI4_BASE_S)
#define SPI5_S                    ((SPI_TypeDef *) SPI5_BASE_S)
#define SPI6_S                    ((SPI_TypeDef *) SPI6_BASE_S)
#define SYSCFG_S                  ((SYSCFG_TypeDef *) SYSCFG_BASE_S)
#define TAMP_S                    ((TAMP_TypeDef *) TAMP_BASE_S)
#define TIM1_S                    ((TIM_TypeDef *) TIM1_BASE_S)
#define TIM2_S                    ((TIM_TypeDef *) TIM2_BASE_S)
#define TIM3_S                    ((TIM_TypeDef *) TIM3_BASE_S)
#define TIM4_S                    ((TIM_TypeDef *) TIM4_BASE_S)
#define TIM5_S                    ((TIM_TypeDef *) TIM5_BASE_S)
#define TIM6_S                    ((TIM_TypeDef *) TIM6_BASE_S)
#define TIM7_S                    ((TIM_TypeDef *) TIM7_BASE_S)
#define TIM8_S                    ((TIM_TypeDef *) TIM8_BASE_S)
#define TIM9_S                    ((TIM_TypeDef *) TIM9_BASE_S)
#define TIM10_S                   ((TIM_TypeDef *) TIM10_BASE_S)
#define TIM11_S                   ((TIM_TypeDef *) TIM11_BASE_S)
#define TIM12_S                   ((TIM_TypeDef *) TIM12_BASE_S)
#define TIM13_S                   ((TIM_TypeDef *) TIM13_BASE_S)
#define TIM14_S                   ((TIM_TypeDef *) TIM14_BASE_S)
#define TIM15_S                   ((TIM_TypeDef *) TIM15_BASE_S)
#define TIM16_S                   ((TIM_TypeDef *) TIM16_BASE_S)
#define TIM17_S                   ((TIM_TypeDef *) TIM17_BASE_S)
#define TIM18_S                   ((TIM_TypeDef *) TIM18_BASE_S)
#define UART4_S                   ((USART_TypeDef *) UART4_BASE_S)
#define UART5_S                   ((USART_TypeDef *) UART5_BASE_S)
#define UART7_S                   ((USART_TypeDef *) UART7_BASE_S)
#define UART8_S                   ((USART_TypeDef *) UART8_BASE_S)
#define UART9_S                   ((USART_TypeDef *) UART9_BASE_S)
#define UCPD1_S                   ((UCPD_TypeDef *) UCPD1_BASE_S)
#define USART1_S                  ((USART_TypeDef *) USART1_BASE_S)
#define USART2_S                  ((USART_TypeDef *) USART2_BASE_S)
#define USART3_S                  ((USART_TypeDef *) USART3_BASE_S)
#define USART6_S                  ((USART_TypeDef *) USART6_BASE_S)
#define USART10_S                 ((USART_TypeDef *) USART10_BASE_S)
#define USB1_OTG_HS_S             ((USB_OTG_GlobalTypeDef *) USB1_OTG_HS_BASE_S)
#define USB2_OTG_HS_S             ((USB_OTG_GlobalTypeDef *) USB2_OTG_HS_BASE_S)
#define USB1_HS_PHYC_S            ((USB_HS_PHYC_GlobalTypeDef *) USB1_HS_PHYC_BASE_S)
#define USB2_HS_PHYC_S            ((USB_HS_PHYC_GlobalTypeDef *) USB2_HS_PHYC_BASE_S)
#define VENC_S                    ((VENC_TypeDef *) VENC_BASE_S)
#define VREFBUF_S                 ((VREFBUF_TypeDef *) VREFBUF_BASE_S)
#define WWDG_S                    ((WWDG_TypeDef *) WWDG_BASE_S)
#define XSPI1_S                   ((XSPI_TypeDef *) XSPI1_BASE_S)
#define XSPI2_S                   ((XSPI_TypeDef *) XSPI2_BASE_S)
#define XSPI3_S                   ((XSPI_TypeDef *) XSPI3_BASE_S)
#define XSPIM_S                   ((XSPIM_TypeDef *) XSPIM_BASE_S)
#endif

/*!< Peripheral Instance aliases for Non-Secure/Secure execution  */
#if defined (CPU_IN_SECURE_STATE)
#define ADC12_COMMON              ADC12_COMMON_S
#define ADC12_COMMON_BASE         ADC12_COMMON_BASE_S

#define ADC1                      ADC1_S
#define ADC1_BASE                 ADC1_BASE_S

#define ADC2                      ADC2_S
#define ADC2_BASE                 ADC2_BASE_S

#define ADF1                      ADF1_S
#define ADF1_BASE                 ADF1_BASE_S

#define ADF1_Filter0              ADF1_Filter0_S
#define ADF1_Filter0_BASE         ADF1_Filter0_BASE_S

#define BSEC                      BSEC_S
#define BSEC_BASE                 BSEC_BASE_S

#define CACHEAXI                  CACHEAXI_S
#define CACHEAXI_BASE             CACHEAXI_BASE_S

#define CRC                       CRC_S
#define CRC_BASE                  CRC_BASE_S

#define CRYP                      CRYP_S
#define CRYP_BASE                 CRYP_BASE_S

#define CSI                       CSI_S
#define CSI_BASE                  CSI_BASE_S

#define DBGMCU                    DBGMCU_S
#define DBGMCU_BASE               DBGMCU_BASE_S

#define DCMI                      DCMI_S
#define DCMI_BASE                 DCMI_BASE_S

#define DCMIPP                    DCMIPP_S
#define DCMIPP_BASE               DCMIPP_BASE_S

#define DLYB_SDMMC1               DLYB_SDMMC1_S
#define DLYB_SDMMC1_BASE          DLYB_SDMMC1_BASE_S

#define DLYB_SDMMC2               DLYB_SDMMC2_S
#define DLYB_SDMMC2_BASE          DLYB_SDMMC2_BASE_S

#define DMA2D                     DMA2D_S
#define DMA2D_BASE                DMA2D_BASE_S

#define DTS                       DTS_S
#define DTS_BASE                  DTS_BASE_S

#define DTS_Sensor0               DTS_Sensor0_S
#define DTS_Sensor0_BASE          DTS_Sensor0_BASE_S

#define DTS_Sensor1               DTS_Sensor1_S
#define DTS_Sensor1_BASE          DTS_Sensor1_BASE_S

#define ETH1                      ETH1_S
#define ETH1_BASE                 ETH1_BASE_S

#define EXTI                      EXTI_S
#define EXTI_BASE                 EXTI_BASE_S

#define FDCAN1                    FDCAN1_S
#define FDCAN1_BASE               FDCAN1_BASE_S

#define FDCAN2                    FDCAN2_S
#define FDCAN2_BASE               FDCAN2_BASE_S

#define FDCAN3                    FDCAN3_S
#define FDCAN3_BASE               FDCAN3_BASE_S

#define FDCAN_CCU                 FDCAN_CCU_S
#define FDCAN_CCU_BASE            FDCAN_CCU_BASE_S

#define FMC_R_BASE                FMC_R_BASE_S

#define FMC_Bank1E_R              FMC_Bank1E_R_S
#define FMC_Bank1E_R_BASE         FMC_Bank1E_R_BASE_S

#define FMC_Bank1_R               FMC_Bank1_R_S
#define FMC_Bank1_R_BASE          FMC_Bank1_R_BASE_S

#define FMC_Bank3_R               FMC_Bank3_R_S
#define FMC_Bank3_R_BASE          FMC_Bank3_R_BASE_S

#define FMC_Bank5_6_R             FMC_Bank5_6_R_S
#define FMC_Bank5_6_R_BASE        FMC_Bank5_6_R_BASE_S

#define FMC_Common_R              FMC_Common_R_S
#define FMC_Common_R_BASE         FMC_Common_R_BASE_S

#define GFXMMU                       GFXMMU_S
#define GFXMMU_BASE                  GFXMMU_BASE_S
#define GFXMMU_VIRTUAL_BUFFER0_BASE  GFXMMU_VIRTUAL_BUFFER0_BASE_S
#define GFXMMU_VIRTUAL_BUFFER1_BASE  GFXMMU_VIRTUAL_BUFFER1_BASE_S
#define GFXMMU_VIRTUAL_BUFFER2_BASE  GFXMMU_VIRTUAL_BUFFER2_BASE_S
#define GFXMMU_VIRTUAL_BUFFER3_BASE  GFXMMU_VIRTUAL_BUFFER3_BASE_S

#define GFXTIM                    GFXTIM_S
#define GFXTIM_BASE               GFXTIM_BASE_S

#define GPDMA1                    GPDMA1_S
#define GPDMA1_BASE               GPDMA1_BASE_S

#define GPDMA1_Channel0           GPDMA1_Channel0_S
#define GPDMA1_Channel0_BASE      GPDMA1_Channel0_BASE_S

#define GPDMA1_Channel1           GPDMA1_Channel1_S
#define GPDMA1_Channel1_BASE      GPDMA1_Channel1_BASE_S

#define GPDMA1_Channel2           GPDMA1_Channel2_S
#define GPDMA1_Channel2_BASE      GPDMA1_Channel2_BASE_S

#define GPDMA1_Channel3           GPDMA1_Channel3_S
#define GPDMA1_Channel3_BASE      GPDMA1_Channel3_BASE_S

#define GPDMA1_Channel4           GPDMA1_Channel4_S
#define GPDMA1_Channel4_BASE      GPDMA1_Channel4_BASE_S

#define GPDMA1_Channel5           GPDMA1_Channel5_S
#define GPDMA1_Channel5_BASE      GPDMA1_Channel5_BASE_S

#define GPDMA1_Channel6           GPDMA1_Channel6_S
#define GPDMA1_Channel6_BASE      GPDMA1_Channel6_BASE_S

#define GPDMA1_Channel7           GPDMA1_Channel7_S
#define GPDMA1_Channel7_BASE      GPDMA1_Channel7_BASE_S

#define GPDMA1_Channel8           GPDMA1_Channel8_S
#define GPDMA1_Channel8_BASE      GPDMA1_Channel8_BASE_S

#define GPDMA1_Channel9           GPDMA1_Channel9_S
#define GPDMA1_Channel9_BASE      GPDMA1_Channel9_BASE_S

#define GPDMA1_Channel10          GPDMA1_Channel10_S
#define GPDMA1_Channel10_BASE     GPDMA1_Channel10_BASE_S

#define GPDMA1_Channel11          GPDMA1_Channel11_S
#define GPDMA1_Channel11_BASE     GPDMA1_Channel11_BASE_S

#define GPDMA1_Channel12          GPDMA1_Channel12_S
#define GPDMA1_Channel12_BASE     GPDMA1_Channel12_BASE_S

#define GPDMA1_Channel13          GPDMA1_Channel13_S
#define GPDMA1_Channel13_BASE     GPDMA1_Channel13_BASE_S

#define GPDMA1_Channel14          GPDMA1_Channel14_S
#define GPDMA1_Channel14_BASE     GPDMA1_Channel14_BASE_S

#define GPDMA1_Channel15          GPDMA1_Channel15_S
#define GPDMA1_Channel15_BASE     GPDMA1_Channel15_BASE_S

#define GPIOA                     GPIOA_S
#define GPIOA_BASE                GPIOA_BASE_S

#define GPIOB                     GPIOB_S
#define GPIOB_BASE                GPIOB_BASE_S

#define GPIOC                     GPIOC_S
#define GPIOC_BASE                GPIOC_BASE_S

#define GPIOD                     GPIOD_S
#define GPIOD_BASE                GPIOD_BASE_S

#define GPIOE                     GPIOE_S
#define GPIOE_BASE                GPIOE_BASE_S

#define GPIOF                     GPIOF_S
#define GPIOF_BASE                GPIOF_BASE_S

#define GPIOG                     GPIOG_S
#define GPIOG_BASE                GPIOG_BASE_S

#define GPIOH                     GPIOH_S
#define GPIOH_BASE                GPIOH_BASE_S

#define GPION                     GPION_S
#define GPION_BASE                GPION_BASE_S

#define GPIOO                     GPIOO_S
#define GPIOO_BASE                GPIOO_BASE_S

#define GPIOP                     GPIOP_S
#define GPIOP_BASE                GPIOP_BASE_S

#define GPIOQ                     GPIOQ_S
#define GPIOQ_BASE                GPIOQ_BASE_S

#define GPU2D                     GPU2D_BASE_S
#define GPU2D_BASE                GPU2D_BASE_S

#define HASH                      HASH_S
#define HASH_BASE                 HASH_BASE_S

#define HASH_DIGEST               HASH_DIGEST_S
#define HASH_DIGEST_BASE          HASH_DIGEST_BASE_S

#define HPDMA1                    HPDMA1_S
#define HPDMA1_BASE               HPDMA1_BASE_S

#define HPDMA1_Channel0           HPDMA1_Channel0_S
#define HPDMA1_Channel0_BASE      HPDMA1_Channel0_BASE_S

#define HPDMA1_Channel1           HPDMA1_Channel1_S
#define HPDMA1_Channel1_BASE      HPDMA1_Channel1_BASE_S

#define HPDMA1_Channel2           HPDMA1_Channel2_S
#define HPDMA1_Channel2_BASE      HPDMA1_Channel2_BASE_S

#define HPDMA1_Channel3           HPDMA1_Channel3_S
#define HPDMA1_Channel3_BASE      HPDMA1_Channel3_BASE_S

#define HPDMA1_Channel4           HPDMA1_Channel4_S
#define HPDMA1_Channel4_BASE      HPDMA1_Channel4_BASE_S

#define HPDMA1_Channel5           HPDMA1_Channel5_S
#define HPDMA1_Channel5_BASE      HPDMA1_Channel5_BASE_S

#define HPDMA1_Channel6           HPDMA1_Channel6_S
#define HPDMA1_Channel6_BASE      HPDMA1_Channel6_BASE_S

#define HPDMA1_Channel7           HPDMA1_Channel7_S
#define HPDMA1_Channel7_BASE      HPDMA1_Channel7_BASE_S

#define HPDMA1_Channel8           HPDMA1_Channel8_S
#define HPDMA1_Channel8_BASE      HPDMA1_Channel8_BASE_S

#define HPDMA1_Channel9           HPDMA1_Channel9_S
#define HPDMA1_Channel9_BASE      HPDMA1_Channel9_BASE_S

#define HPDMA1_Channel10          HPDMA1_Channel10_S
#define HPDMA1_Channel10_BASE     HPDMA1_Channel10_BASE_S

#define HPDMA1_Channel11          HPDMA1_Channel11_S
#define HPDMA1_Channel11_BASE     HPDMA1_Channel11_BASE_S

#define HPDMA1_Channel12          HPDMA1_Channel12_S
#define HPDMA1_Channel12_BASE     HPDMA1_Channel12_BASE_S

#define HPDMA1_Channel13          HPDMA1_Channel13_S
#define HPDMA1_Channel13_BASE     HPDMA1_Channel13_BASE_S

#define HPDMA1_Channel14          HPDMA1_Channel14_S
#define HPDMA1_Channel14_BASE     HPDMA1_Channel14_BASE_S

#define HPDMA1_Channel15          HPDMA1_Channel15_S
#define HPDMA1_Channel15_BASE     HPDMA1_Channel15_BASE_S

#define I2C1                      I2C1_S
#define I2C1_BASE                 I2C1_BASE_S

#define I2C2                      I2C2_S
#define I2C2_BASE                 I2C2_BASE_S

#define I2C3                      I2C3_S
#define I2C3_BASE                 I2C3_BASE_S

#define I2C4                      I2C4_S
#define I2C4_BASE                 I2C4_BASE_S

#define I3C1                      I3C1_S
#define I3C1_BASE                 I3C1_BASE_S

#define I3C2                      I3C2_S
#define I3C2_BASE                 I3C2_BASE_S

#define IAC                       IAC_S
#define IAC_BASE                  IAC_BASE_S

#define ICACHE                    ICACHE_S
#define ICACHE_BASE               ICACHE_BASE_S

#define IWDG                      IWDG_S
#define IWDG_BASE                 IWDG_BASE_S

#define JPEG                      JPEG_S
#define JPEG_BASE                 JPEG_BASE_S

#define LPTIM1                    LPTIM1_S
#define LPTIM1_BASE               LPTIM1_BASE_S

#define LPTIM2                    LPTIM2_S
#define LPTIM2_BASE               LPTIM2_BASE_S

#define LPTIM3                    LPTIM3_S
#define LPTIM3_BASE               LPTIM3_BASE_S

#define LPTIM4                    LPTIM4_S
#define LPTIM4_BASE               LPTIM4_BASE_S

#define LPTIM5                    LPTIM5_S
#define LPTIM5_BASE               LPTIM5_BASE_S

#define LPUART1                   LPUART1_S
#define LPUART1_BASE              LPUART1_BASE_S

#define LTDC                      LTDC_S
#define LTDC_BASE                 LTDC_BASE_S

#define LTDC_Layer1               LTDC_Layer1_S
#define LTDC_Layer1_BASE          LTDC_Layer1_BASE_S

#define LTDC_Layer2               LTDC_Layer2_S
#define LTDC_Layer2_BASE          LTDC_Layer2_BASE_S

#define MCE1                      MCE1_S
#define MCE1_BASE                 MCE1_BASE_S

#define MCE1_REGION1              MCE1_REGION1_S
#define MCE1_REGION1_BASE         MCE1_REGION1_BASE_S

#define MCE1_REGION2              MCE1_REGION2_S
#define MCE1_REGION2_BASE         MCE1_REGION2_BASE_S

#define MCE1_REGION3              MCE1_REGION3_S
#define MCE1_REGION3_BASE         MCE1_REGION3_BASE_S

#define MCE1_REGION4              MCE1_REGION4_S
#define MCE1_REGION4_BASE         MCE1_REGION4_BASE_S

#define MCE1_CONTEXT1             MCE1_CONTEXT1_S
#define MCE1_CONTEXT1_BASE        MCE1_CONTEXT1_BASE_S

#define MCE1_CONTEXT2             MCE1_CONTEXT2_S
#define MCE1_CONTEXT2_BASE        MCE1_CONTEXT2_BASE_S

#define MCE2                      MCE2_S
#define MCE2_BASE                 MCE2_BASE_S

#define MCE2_REGION1              MCE2_REGION1_S
#define MCE2_REGION1_BASE         MCE2_REGION1_BASE_S

#define MCE2_REGION2              MCE2_REGION2_S
#define MCE2_REGION2_BASE         MCE2_REGION2_BASE_S

#define MCE2_REGION3              MCE2_REGION3_S
#define MCE2_REGION3_BASE         MCE2_REGION3_BASE_S

#define MCE2_REGION4              MCE2_REGION4_S
#define MCE2_REGION4_BASE         MCE2_REGION4_BASE_S

#define MCE2_CONTEXT1             MCE2_CONTEXT1_S
#define MCE2_CONTEXT1_BASE        MCE2_CONTEXT1_BASE_S

#define MCE2_CONTEXT2             MCE2_CONTEXT2_S
#define MCE2_CONTEXT2_BASE        MCE2_CONTEXT2_BASE_S

#define MCE3                      MCE3_S
#define MCE3_BASE                 MCE3_BASE_S

#define MCE3_REGION1              MCE3_REGION1_S
#define MCE3_REGION1_BASE         MCE3_REGION1_BASE_S

#define MCE3_REGION2              MCE3_REGION2_S
#define MCE3_REGION2_BASE         MCE3_REGION2_BASE_S

#define MCE3_REGION3              MCE3_REGION3_S
#define MCE3_REGION3_BASE         MCE3_REGION3_BASE_S

#define MCE3_REGION4              MCE3_REGION4_S
#define MCE3_REGION4_BASE         MCE3_REGION4_BASE_S

#define MCE3_CONTEXT1             MCE3_CONTEXT1_S
#define MCE3_CONTEXT1_BASE        MCE3_CONTEXT1_BASE_S

#define MCE3_CONTEXT2             MCE3_CONTEXT2_S
#define MCE3_CONTEXT2_BASE        MCE3_CONTEXT2_BASE_S

#define MCE4                      MCE4_S
#define MCE4_BASE                 MCE4_BASE_S

#define MCE4_REGION1              MCE4_REGION1_S
#define MCE4_REGION1_BASE         MCE4_REGION1_BASE_S

#define MCE4_REGION2              MCE4_REGION2_S
#define MCE4_REGION2_BASE         MCE4_REGION2_BASE_S

#define MCE4_REGION3              MCE4_REGION3_S
#define MCE4_REGION3_BASE         MCE4_REGION3_BASE_S

#define MCE4_REGION4              MCE4_REGION4_S
#define MCE4_REGION4_BASE         MCE4_REGION4_BASE_S

#define MCE4_CONTEXT1             MCE4_CONTEXT1_S
#define MCE4_CONTEXT1_BASE        MCE4_CONTEXT1_BASE_S

#define MCE4_CONTEXT2             MCE4_CONTEXT2_S
#define MCE4_CONTEXT2_BASE        MCE4_CONTEXT2_BASE_S

#define MDF1                      MDF1_S
#define MDF1_BASE                 MDF1_BASE_S

#define MDF1_Filter0              MDF1_Filter0_S
#define MDF1_Filter0_BASE         MDF1_Filter0_BASE_S

#define MDF1_Filter1              MDF1_Filter1_S
#define MDF1_Filter1_BASE         MDF1_Filter1_BASE_S

#define MDF1_Filter2              MDF1_Filter2_S
#define MDF1_Filter2_BASE         MDF1_Filter2_BASE_S

#define MDF1_Filter3              MDF1_Filter3_S
#define MDF1_Filter3_BASE         MDF1_Filter3_BASE_S

#define MDF1_Filter4              MDF1_Filter4_S
#define MDF1_Filter4_BASE         MDF1_Filter4_BASE_S

#define MDF1_Filter5              MDF1_Filter5_S
#define MDF1_Filter5_BASE         MDF1_Filter5_BASE_S

#define MDIOS                     MDIOS_S
#define MDIOS_BASE                MDIOS_BASE_S

#define NPU_PRESENT
#define NPU_BASE                  NPU_BASE_S

#define PKA                       PKA_S
#define PKA_BASE                  PKA_BASE_S

#define PSSI                      PSSI_S
#define PSSI_BASE                 PSSI_BASE_S

#define PWR                       PWR_S
#define PWR_BASE                  PWR_BASE_S

#define RAMCFG                    RAMCFG_S
#define RAMCFG_BASE               RAMCFG_BASE_S

#define RAMCFG_SRAM1_AXI          RAMCFG_SRAM1_AXI_S
#define RAMCFG_SRAM1_AXI_BASE     RAMCFG_SRAM1_AXI_BASE_S

#define RAMCFG_SRAM2_AXI          RAMCFG_SRAM2_AXI_S
#define RAMCFG_SRAM2_AXI_BASE     RAMCFG_SRAM2_AXI_BASE_S

#define RAMCFG_SRAM3_AXI          RAMCFG_SRAM3_AXI_S
#define RAMCFG_SRAM3_AXI_BASE     RAMCFG_SRAM3_AXI_BASE_S

#define RAMCFG_SRAM4_AXI          RAMCFG_SRAM4_AXI_S
#define RAMCFG_SRAM4_AXI_BASE     RAMCFG_SRAM4_AXI_BASE_S

#define RAMCFG_SRAM5_AXI          RAMCFG_SRAM5_AXI_S
#define RAMCFG_SRAM5_AXI_BASE     RAMCFG_SRAM5_AXI_BASE_S

#define RAMCFG_SRAM6_AXI          RAMCFG_SRAM6_AXI_S
#define RAMCFG_SRAM6_AXI_BASE     RAMCFG_SRAM6_AXI_BASE_S

#define RAMCFG_SRAM1_AHB          RAMCFG_SRAM1_AHB_S
#define RAMCFG_SRAM1_AHB_BASE     RAMCFG_SRAM1_AHB_BASE_S

#define RAMCFG_SRAM2_AHB          RAMCFG_SRAM2_AHB_S
#define RAMCFG_SRAM2_AHB_BASE     RAMCFG_SRAM2_AHB_BASE_S

#define RAMCFG_VENC_RAM           RAMCFG_VENC_RAM_S
#define RAMCFG_VENC_RAM_BASE      RAMCFG_VENC_RAM_BASE_S

#define RAMCFG_BKPSRAM            RAMCFG_BKPSRAM_S
#define RAMCFG_BKPSRAM_BASE       RAMCFG_BKPSRAM_BASE_S

#define RAMCFG_FLEXRAM            RAMCFG_FLEXRAM_S
#define RAMCFG_FLEXRAM_BASE       RAMCFG_FLEXRAM_BASE_S

#define RCC                       RCC_S
#define RCC_BASE                  RCC_BASE_S

#define RIFSC                     RIFSC_S
#define RIFSC_BASE                RIFSC_BASE_S

#define RISAF1                    RISAF1_S
#define RISAF1_BASE               RISAF1_BASE_S

#define RISAF2                    RISAF2_S
#define RISAF2_BASE               RISAF2_BASE_S

#define RISAF3                    RISAF3_S
#define RISAF3_BASE               RISAF3_BASE_S

#define RISAF4                    RISAF4_S
#define RISAF4_BASE               RISAF4_BASE_S

#define RISAF5                    RISAF5_S
#define RISAF5_BASE               RISAF5_BASE_S

#define RISAF6                    RISAF6_S
#define RISAF6_BASE               RISAF6_BASE_S

#define RISAF7                    RISAF7_S
#define RISAF7_BASE               RISAF7_BASE_S

#define RISAF8                    RISAF8_S
#define RISAF8_BASE               RISAF8_BASE_S

#define RISAF9                    RISAF9_S
#define RISAF9_BASE               RISAF9_BASE_S

#define RISAF11                   RISAF11_S
#define RISAF11_BASE              RISAF11_BASE_S

#define RISAF12                   RISAF12_S
#define RISAF12_BASE              RISAF12_BASE_S

#define RISAF13                   RISAF13_S
#define RISAF13_BASE              RISAF13_BASE_S

#define RISAF14                   RISAF14_S
#define RISAF14_BASE              RISAF14_BASE_S

#define RISAF15                   RISAF15_S
#define RISAF15_BASE              RISAF15_BASE_S

#define RISAF21                   RISAF21_S
#define RISAF21_BASE              RISAF21_BASE_S

#define RISAF22                   RISAF22_S
#define RISAF22_BASE              RISAF22_BASE_S

#define RISAF23                   RISAF23_S
#define RISAF23_BASE              RISAF23_BASE_S

#define RNG                       RNG_S
#define RNG_BASE                  RNG_BASE_S

#define RTC                       RTC_S
#define RTC_BASE                  RTC_BASE_S

#define SAES                      SAES_S
#define SAES_BASE                 SAES_BASE_S

#define SAI1                      SAI1_S
#define SAI1_BASE                 SAI1_BASE_S

#define SAI1_Block_A              SAI1_Block_A_S
#define SAI1_Block_A_BASE         SAI1_Block_A_BASE_S

#define SAI1_Block_B              SAI1_Block_B_S
#define SAI1_Block_B_BASE         SAI1_Block_B_BASE_S

#define SAI2                      SAI2_S
#define SAI2_BASE                 SAI2_BASE_S

#define SAI2_Block_A              SAI2_Block_A_S
#define SAI2_Block_A_BASE         SAI2_Block_A_BASE_S

#define SAI2_Block_B              SAI2_Block_B_S
#define SAI2_Block_B_BASE         SAI2_Block_B_BASE_S

#define SDMMC1                    SDMMC1_S
#define SDMMC1_BASE               SDMMC1_BASE_S

#define SDMMC2                    SDMMC2_S
#define SDMMC2_BASE               SDMMC2_BASE_S

#define SPDIFRX                   SPDIFRX_S
#define SPDIFRX_BASE              SPDIFRX_BASE_S

#define SPI1                      SPI1_S
#define SPI1_BASE                 SPI1_BASE_S

#define SPI2                      SPI2_S
#define SPI2_BASE                 SPI2_BASE_S

#define SPI3                      SPI3_S
#define SPI3_BASE                 SPI3_BASE_S

#define SPI4                      SPI4_S
#define SPI4_BASE                 SPI4_BASE_S

#define SPI5                      SPI5_S
#define SPI5_BASE                 SPI5_BASE_S

#define SPI6                      SPI6_S
#define SPI6_BASE                 SPI6_BASE_S

#define SRAMCAN_BASE              SRAMCAN_BASE_S

#define SYSCFG                    SYSCFG_S
#define SYSCFG_BASE               SYSCFG_BASE_S

#define TAMP                      TAMP_S
#define TAMP_BASE                 TAMP_BASE_S

#define TIM1                      TIM1_S
#define TIM1_BASE                 TIM1_BASE_S

#define TIM2                      TIM2_S
#define TIM2_BASE                 TIM2_BASE_S

#define TIM3                      TIM3_S
#define TIM3_BASE                 TIM3_BASE_S

#define TIM4                      TIM4_S
#define TIM4_BASE                 TIM4_BASE_S

#define TIM5                      TIM5_S
#define TIM5_BASE                 TIM5_BASE_S

#define TIM6                      TIM6_S
#define TIM6_BASE                 TIM6_BASE_S

#define TIM7                      TIM7_S
#define TIM7_BASE                 TIM7_BASE_S

#define TIM8                      TIM8_S
#define TIM8_BASE                 TIM8_BASE_S

#define TIM9                      TIM9_S
#define TIM9_BASE                 TIM9_BASE_S

#define TIM10                     TIM10_S
#define TIM10_BASE                TIM10_BASE_S

#define TIM11                     TIM11_S
#define TIM11_BASE                TIM11_BASE_S

#define TIM12                     TIM12_S
#define TIM12_BASE                TIM12_BASE_S

#define TIM13                     TIM13_S
#define TIM13_BASE                TIM13_BASE_S

#define TIM14                     TIM14_S
#define TIM14_BASE                TIM14_BASE_S

#define TIM15                     TIM15_S
#define TIM15_BASE                TIM15_BASE_S

#define TIM16                     TIM16_S
#define TIM16_BASE                TIM16_BASE_S

#define TIM17                     TIM17_S
#define TIM17_BASE                TIM17_BASE_S

#define TIM18                     TIM18_S
#define TIM18_BASE                TIM18_BASE_S

#define UART4                     UART4_S
#define UART4_BASE                UART4_BASE_S

#define UART5                     UART5_S
#define UART5_BASE                UART5_BASE_S

#define UART7                     UART7_S
#define UART7_BASE                UART7_BASE_S

#define UART8                     UART8_S
#define UART8_BASE                UART8_BASE_S

#define UART9                     UART9_S
#define UART9_BASE                UART9_BASE_S

#define UCPD1                     UCPD1_S
#define UCPD1_BASE                UCPD1_BASE_S

#define USART1                    USART1_S
#define USART1_BASE               USART1_BASE_S

#define USART2                    USART2_S
#define USART2_BASE               USART2_BASE_S

#define USART3                    USART3_S
#define USART3_BASE               USART3_BASE_S

#define USART6                    USART6_S
#define USART6_BASE               USART6_BASE_S

#define USART10                   USART10_S
#define USART10_BASE              USART10_BASE_S

#define USB1_OTG_HS               USB1_OTG_HS_S
#define USB1_OTG_HS_BASE          USB1_OTG_HS_BASE_S

#define USB2_OTG_HS               USB2_OTG_HS_S
#define USB2_OTG_HS_BASE          USB2_OTG_HS_BASE_S

#define USB1_HS_PHYC              USB1_HS_PHYC_S
#define USB1_HS_PHYC_BASE         USB1_HS_PHYC_BASE_S

#define USB2_HS_PHYC              USB2_HS_PHYC_S
#define USB2_HS_PHYC_BASE         USB2_HS_PHYC_BASE_S

#define VENC                      VENC_S
#define VENC_BASE                 VENC_BASE_S

#define VREFBUF                   VREFBUF_S
#define VREFBUF_BASE              VREFBUF_BASE_S

#define WWDG                      WWDG_S
#define WWDG_BASE                 WWDG_BASE_S

#define XSPI1                     XSPI1_S

#define XSPI2                     XSPI2_S

#define XSPI3                     XSPI3_S

#define XSPIM                     XSPIM_S
#define XSPIM_BASE                XSPIM_BASE_S

/*!< Unique device ID register base address */
#define UID_BASE                  UID_BASE_S

/*!< Revision ID base address */
#define REVID_BASE                REVID_BASE_S

#else

#define ADC12_COMMON              ADC12_COMMON_NS
#define ADC12_COMMON_BASE         ADC12_COMMON_BASE_NS

#define ADC1                      ADC1_NS
#define ADC1_BASE                 ADC1_BASE_NS

#define ADC2                      ADC2_NS
#define ADC2_BASE                 ADC2_BASE_NS

#define ADF1                      ADF1_NS
#define ADF1_BASE                 ADF1_BASE_NS

#define ADF1_Filter0              ADF1_Filter0_NS
#define ADF1_Filter0_BASE         ADF1_Filter0_BASE_NS

#define BSEC                      BSEC_NS
#define BSEC_BASE                 BSEC_BASE_NS

#define CACHEAXI                  CACHEAXI_NS
#define CACHEAXI_BASE             CACHEAXI_BASE_NS

#define CRC                       CRC_NS
#define CRC_BASE                  CRC_BASE_NS

#define CRYP                      CRYP_NS
#define CRYP_BASE                 CRYP_BASE_NS

#define CSI                       CSI_NS
#define CSI_BASE                  CSI_BASE_NS

#define DBGMCU                    DBGMCU_NS
#define DBGMCU_BASE               DBGMCU_BASE_NS

#define DCMI                      DCMI_NS
#define DCMI_BASE                 DCMI_BASE_NS

#define DCMIPP                    DCMIPP_NS
#define DCMIPP_BASE               DCMIPP_BASE_NS

#define DLYB_SDMMC1               DLYB_SDMMC1_NS
#define DLYB_SDMMC1_BASE          DLYB_SDMMC1_BASE_NS

#define DLYB_SDMMC2               DLYB_SDMMC2_NS
#define DLYB_SDMMC2_BASE          DLYB_SDMMC2_BASE_NS

#define DMA2D                     DMA2D_NS
#define DMA2D_BASE                DMA2D_BASE_NS

#define DTS                       DTS_NS
#define DTS_BASE                  DTS_BASE_NS

#define DTS_Sensor0               DTS_Sensor0_NS
#define DTS_Sensor0_BASE          DTS_Sensor0_BASE_NS

#define DTS_Sensor1               DTS_Sensor1_NS
#define DTS_Sensor1_BASE          DTS_Sensor1_BASE_NS

#define ETH1                      ETH1_NS
#define ETH1_BASE                 ETH1_BASE_NS

#define EXTI                      EXTI_NS
#define EXTI_BASE                 EXTI_BASE_NS

#define FDCAN1                    FDCAN1_NS
#define FDCAN1_BASE               FDCAN1_BASE_NS

#define FDCAN2                    FDCAN2_NS
#define FDCAN2_BASE               FDCAN2_BASE_NS

#define FDCAN3                    FDCAN3_NS
#define FDCAN3_BASE               FDCAN3_BASE_NS

#define FDCAN_CCU                 FDCAN_CCU_NS
#define FDCAN_CCU_BASE            FDCAN_CCU_BASE_NS

#define FMC_R_BASE                FMC_R_BASE_NS
#define FMC_R_BASE_BASE           FMC_R_BASE_BASE_NS

#define FMC_Bank1E_R              FMC_Bank1E_R_NS
#define FMC_Bank1E_R_BASE         FMC_Bank1E_R_BASE_NS

#define FMC_Bank1_R               FMC_Bank1_R_NS
#define FMC_Bank1_Rv              FMC_Bank1_R_BASE_NS

#define FMC_Bank3_R               FMC_Bank3_R_NS
#define FMC_Bank3_R_BASE          FMC_Bank3_R_BASE_NS

#define FMC_Bank5_6_R             FMC_Bank5_6_R_NS
#define FMC_Bank5_6_R_BASE        FMC_Bank5_6_R_BASE_NS

#define FMC_Common_R              FMC_Common_R_NS
#define FMC_Common_R_BASE         FMC_Common_R_BASE_NS

#define GFXMMU                       GFXMMU_NS
#define GFXMMU_BASE                  GFXMMU_BASE_NS
#define GFXMMU_VIRTUAL_BUFFER0_BASE  GFXMMU_VIRTUAL_BUFFER0_BASE_NS
#define GFXMMU_VIRTUAL_BUFFER1_BASE  GFXMMU_VIRTUAL_BUFFER1_BASE_NS
#define GFXMMU_VIRTUAL_BUFFER2_BASE  GFXMMU_VIRTUAL_BUFFER2_BASE_NS
#define GFXMMU_VIRTUAL_BUFFER3_BASE  GFXMMU_VIRTUAL_BUFFER3_BASE_NS

#define GFXTIM                    GFXTIM_NS
#define GFXTIM_BASE               GFXTIM_BASE_NS

#define GPDMA1                    GPDMA1_NS
#define GPDMA1_BASE               GPDMA1_BASE_NS

#define GPDMA1_Channel0           GPDMA1_Channel0_NS
#define GPDMA1_Channel0_BASE      GPDMA1_Channel0_BASE_NS

#define GPDMA1_Channel1           GPDMA1_Channel1_NS
#define GPDMA1_Channel1_BASE      GPDMA1_Channel1_BASE_NS

#define GPDMA1_Channel2           GPDMA1_Channel2_NS
#define GPDMA1_Channel2_BASE      GPDMA1_Channel2_BASE_NS

#define GPDMA1_Channel3           GPDMA1_Channel3_NS
#define GPDMA1_Channel3_BASE      GPDMA1_Channel3_BASE_NS

#define GPDMA1_Channel4           GPDMA1_Channel4_NS
#define GPDMA1_Channel4_BASE      GPDMA1_Channel4_BASE_NS

#define GPDMA1_Channel5           GPDMA1_Channel5_NS
#define GPDMA1_Channel5_BASE      GPDMA1_Channel5_BASE_NS

#define GPDMA1_Channel6           GPDMA1_Channel6_NS
#define GPDMA1_Channel6_BASE      GPDMA1_Channel6_BASE_NS

#define GPDMA1_Channel7           GPDMA1_Channel7_NS
#define GPDMA1_Channel7_BASE      GPDMA1_Channel7_BASE_NS

#define GPDMA1_Channel8           GPDMA1_Channel8_NS
#define GPDMA1_Channel8_BASE      GPDMA1_Channel8_BASE_NS

#define GPDMA1_Channel9           GPDMA1_Channel9_NS
#define GPDMA1_Channel9_BASE      GPDMA1_Channel9_BASE_NS

#define GPDMA1_Channel10          GPDMA1_Channel10_NS
#define GPDMA1_Channel10_BASE     GPDMA1_Channel10_BASE_NS

#define GPDMA1_Channel11          GPDMA1_Channel11_NS
#define GPDMA1_Channel11_BASE     GPDMA1_Channel11_BASE_NS

#define GPDMA1_Channel12          GPDMA1_Channel12_NS
#define GPDMA1_Channel12_BASE     GPDMA1_Channel12_BASE_NS

#define GPDMA1_Channel13          GPDMA1_Channel13_NS
#define GPDMA1_Channel13_BASE     GPDMA1_Channel13_BASE_NS

#define GPDMA1_Channel14          GPDMA1_Channel14_NS
#define GPDMA1_Channel14_BASE     GPDMA1_Channel14_BASE_NS

#define GPDMA1_Channel15          GPDMA1_Channel15_NS
#define GPDMA1_Channel15_BASE     GPDMA1_Channel15_BASE_NS

#define GPIOA                     GPIOA_NS
#define GPIOA_BASE                GPIOA_BASE_NS

#define GPIOB                     GPIOB_NS
#define GPIOB_BASE                GPIOB_BASE_NS

#define GPIOC                     GPIOC_NS
#define GPIOC_BASE                GPIOC_BASE_NS

#define GPIOD                     GPIOD_NS
#define GPIOD_BASE                GPIOD_BASE_NS

#define GPIOE                     GPIOE_NS
#define GPIOE_BASE                GPIOE_BASE_NS

#define GPIOF                     GPIOF_NS
#define GPIOF_BASE                GPIOF_BASE_NS

#define GPIOG                     GPIOG_NS
#define GPIOG_BASE                GPIOG_BASE_NS

#define GPIOH                     GPIOH_NS
#define GPIOH_BASE                GPIOH_BASE_NS

#define GPION                     GPION_NS
#define GPION_BASE                GPION_BASE_NS

#define GPIOO                     GPIOO_NS
#define GPIOO_BASE                GPIOO_BASE_NS

#define GPIOP                     GPIOP_NS
#define GPIOP_BASE                GPIOP_BASE_NS

#define GPIOQ                     GPIOQ_NS
#define GPIOQ_BASE                GPIOQ_BASE_NS

#define GPU2D                     GPU2D_BASE_NS
#define GPU2D_BASE                GPU2D_BASE_NS

#define HASH                      HASH_NS
#define HASH_BASE                 HASH_BASE_NS

#define HASH_DIGEST               HASH_DIGEST_NS
#define HASH_DIGEST_BASE          HASH_DIGEST_BASE_NS

#define HPDMA1                    HPDMA1_NS
#define HPDMA1_BASE               HPDMA1_BASE_NS

#define HPDMA1_Channel0           HPDMA1_Channel0_NS
#define HPDMA1_Channel0_BASE      HPDMA1_Channel0_BASE_NS

#define HPDMA1_Channel1           HPDMA1_Channel1_NS
#define HPDMA1_Channel1_BASE      HPDMA1_Channel1_BASE_NS

#define HPDMA1_Channel2           HPDMA1_Channel2_NS
#define HPDMA1_Channel2_BASE      HPDMA1_Channel2_BASE_NS

#define HPDMA1_Channel3           HPDMA1_Channel3_NS
#define HPDMA1_Channel3_BASE      HPDMA1_Channel3_BASE_NS

#define HPDMA1_Channel4           HPDMA1_Channel4_NS
#define HPDMA1_Channel4_BASE      HPDMA1_Channel4_BASE_NS

#define HPDMA1_Channel5           HPDMA1_Channel5_NS
#define HPDMA1_Channel5_BASE      HPDMA1_Channel5_BASE_NS

#define HPDMA1_Channel6           HPDMA1_Channel6_NS
#define HPDMA1_Channel6_BASE      HPDMA1_Channel6_BASE_NS

#define HPDMA1_Channel7           HPDMA1_Channel7_NS
#define HPDMA1_Channel7_BASE      HPDMA1_Channel7_BASE_NS

#define HPDMA1_Channel8           HPDMA1_Channel8_NS
#define HPDMA1_Channel8_BASE      HPDMA1_Channel8_BASE_NS

#define HPDMA1_Channel9           HPDMA1_Channel9_NS
#define HPDMA1_Channel9_BASE      HPDMA1_Channel9_BASE_NS

#define HPDMA1_Channel10          HPDMA1_Channel10_NS
#define HPDMA1_Channel10_BASE     HPDMA1_Channel10_BASE_NS

#define HPDMA1_Channel11          HPDMA1_Channel11_NS
#define HPDMA1_Channel11_BASE     HPDMA1_Channel11_BASE_NS

#define HPDMA1_Channel12          HPDMA1_Channel12_NS
#define HPDMA1_Channel12_BASE     HPDMA1_Channel12_BASE_NS

#define HPDMA1_Channel13          HPDMA1_Channel13_NS
#define HPDMA1_Channel13_BASE     HPDMA1_Channel13_BASE_NS

#define HPDMA1_Channel14          HPDMA1_Channel14_NS
#define HPDMA1_Channel14_BASE     HPDMA1_Channel14_BASE_NS

#define HPDMA1_Channel15          HPDMA1_Channel15_NS
#define HPDMA1_Channel15_BASE     HPDMA1_Channel15_BASE_NS

#define I2C1                      I2C1_NS
#define I2C1_BASE                 I2C1_BASE_NS

#define I2C2                      I2C2_NS
#define I2C2_BASE                 I2C2_BASE_NS

#define I2C3                      I2C3_NS
#define I2C3_BASE                 I2C3_BASE_NS

#define I2C4                      I2C4_NS
#define I2C4_BASE                 I2C4_BASE_NS

#define I3C1                      I3C1_NS
#define I3C1_BASE                 I3C1_BASE_NS

#define I3C2                      I3C2_NS
#define I3C2_BASE                 I3C2_BASE_NS

#define ICACHE                    ICACHE_NS
#define ICACHE_BASE               ICACHE_BASE_NS

#define IWDG                      IWDG_NS
#define IWDG_BASE                 IWDG_BASE_NS

#define JPEG                      JPEG_NS
#define JPEG_BASE                 JPEG_BASE_NS

#define LPTIM1                    LPTIM1_NS
#define LPTIM1_BASE               LPTIM1_BASE_NS

#define LPTIM2                    LPTIM2_NS
#define LPTIM2_BASE               LPTIM2_BASE_NS

#define LPTIM3                    LPTIM3_NS
#define LPTIM3_BASE               LPTIM3_BASE_NS

#define LPTIM4                    LPTIM4_NS
#define LPTIM4_BASE               LPTIM4_BASE_NS

#define LPTIM5                    LPTIM5_NS
#define LPTIM5_BASE               LPTIM5_BASE_NS

#define LPUART1                   LPUART1_NS
#define LPUART1_BASE              LPUART1_BASE_NS

#define LTDC                      LTDC_NS
#define LTDC_BASE                 LTDC_BASE_NS

#define LTDC_Layer1               LTDC_Layer1_NS
#define LTDC_Layer1_BASE          LTDC_Layer1_BASE_NS

#define LTDC_Layer2               LTDC_Layer2_NS
#define LTDC_Layer2_BASE          LTDC_Layer2_BASE_NS

#define MCE1                      MCE1_NS
#define MCE1_BASE                 MCE1_BASE_NS

#define MCE1_REGION1              MCE1_REGION1_NS
#define MCE1_REGION1_BASE         MCE1_REGION1_BASE_NS

#define MCE1_REGION2              MCE1_REGION2_NS
#define MCE1_REGION2_BASE         MCE1_REGION2_BASE_NS

#define MCE1_REGION3              MCE1_REGION3_NS
#define MCE1_REGION3_BASE         MCE1_REGION3_BASE_NS

#define MCE1_REGION4              MCE1_REGION4_NS
#define MCE1_REGION4_BASE         MCE1_REGION4_BASE_NS

#define MCE1_CONTEXT1             MCE1_CONTEXT1_NS
#define MCE1_CONTEXT1_BASE        MCE1_CONTEXT1_BASE_NS

#define MCE1_CONTEXT2             MCE1_CONTEXT2_NS
#define MCE1_CONTEXT2_BASE        MCE1_CONTEXT2_BASE_NS

#define MCE2                      MCE2_NS
#define MCE2_BASE                 MCE2_BASE_NS

#define MCE2_REGION1              MCE2_REGION1_NS
#define MCE2_REGION1_BASE         MCE2_REGION1_BASE_NS

#define MCE2_REGION2              MCE2_REGION2_NS
#define MCE2_REGION2_BASE         MCE2_REGION2_BASE_NS

#define MCE2_REGION3              MCE2_REGION3_NS
#define MCE2_REGION3_BASE         MCE2_REGION3_BASE_NS

#define MCE2_REGION4              MCE2_REGION4_NS
#define MCE2_REGION4_BASE         MCE2_REGION4_BASE_NS

#define MCE2_CONTEXT1             MCE2_CONTEXT1_NS
#define MCE2_CONTEXT1_BASE        MCE2_CONTEXT1_BASE_NS

#define MCE2_CONTEXT2             MCE2_CONTEXT2_NS
#define MCE2_CONTEXT2_BASE        MCE2_CONTEXT2_BASE_NS

#define MCE3                      MCE3_NS
#define MCE3_BASE                 MCE3_BASE_NS

#define MCE3_REGION1              MCE3_REGION1_NS
#define MCE3_REGION1_BASE         MCE3_REGION1_BASE_NS

#define MCE3_REGION2              MCE3_REGION2_NS
#define MCE3_REGION2_BASE         MCE3_REGION2_BASE_NS

#define MCE3_REGION3              MCE3_REGION3_NS
#define MCE3_REGION3_BASE         MCE3_REGION3_BASE_NS

#define MCE3_REGION4              MCE3_REGION4_NS
#define MCE3_REGION4_BASE         MCE3_REGION4_BASE_NS

#define MCE3_CONTEXT1             MCE3_CONTEXT1_NS
#define MCE3_CONTEXT1_BASE        MCE3_CONTEXT1_BASE_NS

#define MCE3_CONTEXT2             MCE3_CONTEXT2_NS
#define MCE3_CONTEXT2_BASE        MCE3_CONTEXT2_BASE_NS

#define MCE4                      MCE4_NS
#define MCE4_BASE                 MCE4_BASE_NS

#define MCE4_REGION1              MCE4_REGION1_NS
#define MCE4_REGION1_BASE         MCE4_REGION1_BASE_NS

#define MCE4_REGION2              MCE4_REGION2_NS
#define MCE4_REGION2_BASE         MCE4_REGION2_BASE_NS

#define MCE4_REGION3              MCE4_REGION3_NS
#define MCE4_REGION3_BASE         MCE4_REGION3_BASE_NS

#define MCE4_REGION4              MCE4_REGION4_NS
#define MCE4_REGION4_BASE         MCE4_REGION4_BASE_NS

#define MCE4_CONTEXT1             MCE4_CONTEXT1_NS
#define MCE4_CONTEXT1_BASE        MCE4_CONTEXT1_BASE_NS

#define MCE4_CONTEXT2             MCE4_CONTEXT2_NS
#define MCE4_CONTEXT2_BASE        MCE4_CONTEXT2_BASE_NS

#define MDF1                      MDF1_NS
#define MDF1_BASE                 MDF1_BASE_NS

#define MDF1_Filter0              MDF1_Filter0_NS
#define MDF1_Filter0_BASE         MDF1_Filter0_BASE_NS

#define MDF1_Filter1              MDF1_Filter1_NS
#define MDF1_Filter1_BASE         MDF1_Filter1_BASE_NS

#define MDF1_Filter2              MDF1_Filter2_NS
#define MDF1_Filter2_BASE         MDF1_Filter2_BASE_NS

#define MDF1_Filter3              MDF1_Filter3_NS
#define MDF1_Filter3_BASE         MDF1_Filter3_BASE_NS

#define MDF1_Filter4              MDF1_Filter4_NS
#define MDF1_Filter4_BASE         MDF1_Filter4_BASE_NS

#define MDF1_Filter5              MDF1_Filter5_NS
#define MDF1_Filter5_BASE         MDF1_Filter5_BASE_NS

#define MDIOS                     MDIOS_NS
#define MDIOS_BASE                MDIOS_BASE_NS

#define NPU_PRESENT
#define NPU_BASE                  NPU_BASE_NS

#define PKA                       PKA_NS
#define PKA_BASE                  PKA_BASE_NS

#define PSSI                      PSSI_NS
#define PSSI_BASE                 PSSI_BASE_NS

#define PWR                       PWR_NS
#define PWR_BASE                  PWR_BASE_NS

#define RAMCFG                    RAMCFG_NS
#define RAMCFG_BASE               RAMCFG_BASE_NS

#define RAMCFG_SRAM1_AXI          RAMCFG_SRAM1_AXI_NS
#define RAMCFG_SRAM1_AXI_BASE     RAMCFG_SRAM1_AXI_BASE_NS

#define RAMCFG_SRAM2_AXI          RAMCFG_SRAM2_AXI_NS
#define RAMCFG_SRAM2_AXI_BASE     RAMCFG_SRAM2_AXI_BASE_NS

#define RAMCFG_SRAM3_AXI          RAMCFG_SRAM3_AXI_NS
#define RAMCFG_SRAM3_AXI_BASE     RAMCFG_SRAM3_AXI_BASE_NS

#define RAMCFG_SRAM4_AXI          RAMCFG_SRAM4_AXI_NS
#define RAMCFG_SRAM4_AXI_BASE     RAMCFG_SRAM4_AXI_BASE_NS

#define RAMCFG_SRAM5_AXI          RAMCFG_SRAM5_AXI_NS
#define RAMCFG_SRAM5_AXI_BASE     RAMCFG_SRAM5_AXI_BASE_NS

#define RAMCFG_SRAM6_AXI          RAMCFG_SRAM6_AXI_NS
#define RAMCFG_SRAM6_AXI_BASE     RAMCFG_SRAM6_AXI_BASE_NS

#define RAMCFG_SRAM1_AHB          RAMCFG_SRAM1_AHB_NS
#define RAMCFG_SRAM1_AHB_BASE     RAMCFG_SRAM1_AHB_BASE_NS

#define RAMCFG_SRAM2_AHB          RAMCFG_SRAM2_AHB_NS
#define RAMCFG_SRAM2_AHB_BASE     RAMCFG_SRAM2_AHB_BASE_NS

#define RAMCFG_VENC_RAM           RAMCFG_VENC_RAM_NS
#define RAMCFG_VENC_RAM_BASE      RAMCFG_VENC_RAM_BASE_NS

#define RAMCFG_BKPSRAM            RAMCFG_BKPSRAM_NS
#define RAMCFG_BKPSRAM_BASE       RAMCFG_BKPSRAM_BASE_NS

#define RAMCFG_FLEXRAM            RAMCFG_FLEXRAM_NS
#define RAMCFG_FLEXRAM_BASE       RAMCFG_FLEXRAM_BASE_NS

#define RCC                       RCC_NS
#define RCC_BASE                  RCC_BASE_NS

#define RIFSC                     RIFSC_NS
#define RIFSC_BASE                RIFSC_BASE_NS

#define RISAF1                    RISAF1_NS
#define RISAF1_BASE               RISAF1_BASE_NS

#define RISAF2                    RISAF2_NS
#define RISAF2_BASE               RISAF2_BASE_NS

#define RISAF3                    RISAF3_NS
#define RISAF3_BASE               RISAF3_BASE_NS

#define RISAF4                    RISAF4_NS
#define RISAF4_BASE               RISAF4_BASE_NS

#define RISAF5                    RISAF5_NS
#define RISAF5_BASE               RISAF5_BASE_NS

#define RISAF6                    RISAF6_NS
#define RISAF6_BASE               RISAF6_BASE_NS

#define RISAF7                    RISAF7_NS
#define RISAF7_BASE               RISAF7_BASE_NS

#define RISAF8                    RISAF8_NS
#define RISAF8_BASE               RISAF8_BASE_NS

#define RISAF9                    RISAF9_NS
#define RISAF9_BASE               RISAF9_BASE_NS

#define RISAF11                   RISAF11_NS
#define RISAF11_BASE              RISAF11_BASE_NS

#define RISAF12                   RISAF12_NS
#define RISAF12_BASE              RISAF12_BASE_NS

#define RISAF13                   RISAF13_NS
#define RISAF13_BASE              RISAF13_BASE_NS

#define RISAF14                   RISAF14_NS
#define RISAF14_BASE              RISAF14_BASE_NS

#define RISAF15                   RISAF15_NS
#define RISAF15_BASE              RISAF15_BASE_NS

#define RISAF21                   RISAF21_NS
#define RISAF21_BASE              RISAF21_BASE_NS

#define RISAF22                   RISAF22_NS
#define RISAF22_BASE              RISAF22_BASE_NS

#define RISAF23                   RISAF23_NS
#define RISAF23_BASE              RISAF23_BASE_NS

#define RNG                       RNG_NS
#define RNG_BASE                  RNG_BASE_NS

#define RTC                       RTC_NS
#define RTC_BASE                  RTC_BASE_NS

#define SAES                      SAES_NS
#define SAES_BASE                 SAES_BASE_NS

#define SAI1                      SAI1_NS
#define SAI1_BASE                 SAI1_BASE_NS

#define SAI1_Block_A              SAI1_Block_A_NS
#define SAI1_Block_A_BASE         SAI1_Block_A_BASE_NS

#define SAI1_Block_B              SAI1_Block_B_NS
#define SAI1_Block_B_BASE         SAI1_Block_B_BASE_NS

#define SAI2                      SAI2_NS
#define SAI2_BASE                 SAI2_BASE_NS

#define SAI2_Block_A              SAI2_Block_A_NS
#define SAI2_Block_A_BASE         SAI2_Block_A_BASE_NS

#define SAI2_Block_B              SAI2_Block_B_NS
#define SAI2_Block_B_BASE         SAI2_Block_B_BASE_NS

#define SDMMC1                    SDMMC1_NS
#define SDMMC1_BASE               SDMMC1_BASE_NS

#define SDMMC2                    SDMMC2_NS
#define SDMMC2_BASE               SDMMC2_BASE_NS

#define SPDIFRX                   SPDIFRX_NS
#define SPDIFRX_BASE              SPDIFRX_BASE_NS

#define SPI1                      SPI1_NS
#define SPI1_BASE                 SPI1_BASE_NS

#define SPI2                      SPI2_NS
#define SPI2_BASE                 SPI2_BASE_NS

#define SPI3                      SPI3_NS
#define SPI3_BASE                 SPI3_BASE_NS

#define SPI4                      SPI4_NS
#define SPI4_BASE                 SPI4_BASE_NS

#define SPI5                      SPI5_NS
#define SPI5_BASE                 SPI5_BASE_NS

#define SPI6                      SPI6_NS
#define SPI6_BASE                 SPI6_BASE_NS

#define SRAMCAN_BASE              SRAMCAN_BASE_NS

#define SYSCFG                    SYSCFG_NS
#define SYSCFG_BASE               SYSCFG_BASE_NS

#define TAMP                      TAMP_NS
#define TAMP_BASE                 TAMP_BASE_NS

#define TIM1                      TIM1_NS
#define TIM1_BASE                 TIM1_BASE_NS

#define TIM2                      TIM2_NS
#define TIM2_BASE                 TIM2_BASE_NS

#define TIM3                      TIM3_NS
#define TIM3_BASE                 TIM3_BASE_NS

#define TIM4                      TIM4_NS
#define TIM4_BASE                 TIM4_BASE_NS

#define TIM5                      TIM5_NS
#define TIM5_BASE                 TIM5_BASE_NS

#define TIM6                      TIM6_NS
#define TIM6_BASE                 TIM6_BASE_NS

#define TIM7                      TIM7_NS
#define TIM7_BASE                 TIM7_BASE_NS

#define TIM8                      TIM8_NS
#define TIM8_BASE                 TIM8_BASE_NS

#define TIM9                      TIM9_NS
#define TIM9_BASE                 TIM9_BASE_NS

#define TIM10                     TIM10_NS
#define TIM10_BASE                TIM10_BASE_NS

#define TIM11                     TIM11_NS
#define TIM11_BASE                TIM11_BASE_NS

#define TIM12                     TIM12_NS
#define TIM12_BASE                TIM12_BASE_NS

#define TIM13                     TIM13_NS
#define TIM13_BASE                TIM13_BASE_NS

#define TIM14                     TIM14_NS
#define TIM14_BASE                TIM14_BASE_NS

#define TIM15                     TIM15_NS
#define TIM15_BASE                TIM15_BASE_NS

#define TIM16                     TIM16_NS
#define TIM16_BASE                TIM16_BASE_NS

#define TIM17                     TIM17_NS
#define TIM17_BASE                TIM17_BASE_NS

#define TIM18                     TIM18_NS
#define TIM18_BASE                TIM18_BASE_NS

#define UART4                     UART4_NS
#define UART4_BASE                UART4_BASE_NS

#define UART5                     UART5_NS
#define UART5_BASE                UART5_BASE_NS

#define UART7                     UART7_NS
#define UART7_BASE                UART7_BASE_NS

#define UART8                     UART8_NS
#define UART8_BASE                UART8_BASE_NS

#define UART9                     UART9_NS
#define UART9_BASE                UART9_BASE_NS

#define UCPD1                     UCPD1_NS
#define UCPD1_BASE                UCPD1_BASE_NS

#define USART1                    USART1_NS
#define USART1_BASE               USART1_BASE_NS

#define USART2                    USART2_NS
#define USART2_BASE               USART2_BASE_NS

#define USART3                    USART3_NS
#define USART3_BASE               USART3_BASE_NS

#define USART6                    USART6_NS
#define USART6_BASE               USART6_BASE_NS

#define USART10                   USART10_NS
#define USART10_BASE              USART10_BASE_NS

#define USB1_OTG_HS               USB1_OTG_HS_NS
#define USB1_OTG_HS_BASE          USB1_OTG_HS_BASE_NS

#define USB2_OTG_HS               USB2_OTG_HS_NS
#define USB2_OTG_HS_BASE          USB2_OTG_HS_BASE_NS

#define USB1_HS_PHYC              USB1_HS_PHYC_NS
#define USB1_HS_PHYC_BASE         USB1_HS_PHYC_BASE_NS

#define USB2_HS_PHYC              USB2_HS_PHYC_NS
#define USB2_HS_PHYC_BASE         USB2_HS_PHYC_BASE_NS

#define VENC                      VENC_NS
#define VENC_BASE                 VENC_BASE_NS

#define VREFBUF                   VREFBUF_NS
#define VREFBUF_BASE              VREFBUF_BASE_NS

#define WWDG                      WWDG_NS
#define WWDG_BASE                 WWDG_BASE_NS

#define XSPI1                     XSPI1_NS

#define XSPI2                     XSPI2_NS

#define XSPI3                     XSPI3_NS

#define XSPIM                     XSPIM_NS
#define XSPIM_BASE                XSPIM_BASE_NS

/*!< Unique device ID register base address */
#define UID_BASE                  UID_BASE_NS

/*!< Revision ID base address */
#define REVID_BASE                REVID_BASE_NS

#endif

/** @} */ /* End of group STM32N6xx_Peripheral_declaration */

/** @addtogroup STM32N6xx_Peripheral_Timing_Definition
  * @{
  */

#define LSI_STARTUP_TIME                16000U /*!< LSI Maximum startup time in us : 4 cycles @ 250 Hz = 16 ms */

/** @} */ /* End of group STM32N6xx_Peripheral_Timing_Definition */

/** @addtogroup Peripheral_Registers_Bits_Definition
  * @{
  */

/******************************************************************************/
/*                                                                            */
/*                        Analog to Digital Converter (ADC)                   */
/*                                                                            */
/******************************************************************************/

/* Specific device feature definitions */
#define ADC_MULTIMODE_SUPPORT         /*!< ADC feature available only on specific devices: multimode available on devices with several ADC instances */

/********************  Bit definition for ADC_ISR register  *******************/
#define ADC_ISR_ADRDY_Pos              (0UL)
#define ADC_ISR_ADRDY_Msk              (0x1UL << ADC_ISR_ADRDY_Pos)            /*!< 0x00000001 */
#define ADC_ISR_ADRDY                  ADC_ISR_ADRDY_Msk                       /*!< ADC ready flag */
#define ADC_ISR_EOSMP_Pos              (1UL)
#define ADC_ISR_EOSMP_Msk              (0x1UL << ADC_ISR_EOSMP_Pos)            /*!< 0x00000002 */
#define ADC_ISR_EOSMP                  ADC_ISR_EOSMP_Msk                       /*!< ADC group regular end of sampling flag */
#define ADC_ISR_EOC_Pos                (2UL)
#define ADC_ISR_EOC_Msk                (0x1UL << ADC_ISR_EOC_Pos)              /*!< 0x00000004 */
#define ADC_ISR_EOC                    ADC_ISR_EOC_Msk                         /*!< ADC group regular end of unitary conversion flag */
#define ADC_ISR_EOS_Pos                (3UL)
#define ADC_ISR_EOS_Msk                (0x1UL << ADC_ISR_EOS_Pos)              /*!< 0x00000008 */
#define ADC_ISR_EOS                    ADC_ISR_EOS_Msk                         /*!< ADC group regular end of sequence conversions flag */
#define ADC_ISR_OVR_Pos                (4UL)
#define ADC_ISR_OVR_Msk                (0x1UL << ADC_ISR_OVR_Pos)              /*!< 0x00000010 */
#define ADC_ISR_OVR                    ADC_ISR_OVR_Msk                         /*!< ADC group regular overrun flag */
#define ADC_ISR_JEOC_Pos               (5UL)
#define ADC_ISR_JEOC_Msk               (0x1UL << ADC_ISR_JEOC_Pos)             /*!< 0x00000020 */
#define ADC_ISR_JEOC                   ADC_ISR_JEOC_Msk                        /*!< ADC group injected end of unitary conversion flag */
#define ADC_ISR_JEOS_Pos               (6UL)
#define ADC_ISR_JEOS_Msk               (0x1UL << ADC_ISR_JEOS_Pos)             /*!< 0x00000040 */
#define ADC_ISR_JEOS                   ADC_ISR_JEOS_Msk                        /*!< ADC group injected end of sequence conversions flag */
#define ADC_ISR_AWD1_Pos               (7UL)
#define ADC_ISR_AWD1_Msk               (0x1UL << ADC_ISR_AWD1_Pos)             /*!< 0x00000080 */
#define ADC_ISR_AWD1                   ADC_ISR_AWD1_Msk                        /*!< ADC analog watchdog 1 flag */
#define ADC_ISR_AWD2_Pos               (8UL)
#define ADC_ISR_AWD2_Msk               (0x1UL << ADC_ISR_AWD2_Pos)             /*!< 0x00000100 */
#define ADC_ISR_AWD2                   ADC_ISR_AWD2_Msk                        /*!< ADC analog watchdog 2 flag */
#define ADC_ISR_AWD3_Pos               (9UL)
#define ADC_ISR_AWD3_Msk               (0x1UL << ADC_ISR_AWD3_Pos)             /*!< 0x00000200 */
#define ADC_ISR_AWD3                   ADC_ISR_AWD3_Msk                        /*!< ADC analog watchdog 3 flag */

/********************  Bit definition for ADC_IER register  *******************/
#define ADC_IER_ADRDYIE_Pos            (0UL)
#define ADC_IER_ADRDYIE_Msk            (0x1UL << ADC_IER_ADRDYIE_Pos)          /*!< 0x00000001 */
#define ADC_IER_ADRDYIE                ADC_IER_ADRDYIE_Msk                     /*!< ADC ready interrupt */
#define ADC_IER_EOSMPIE_Pos            (1UL)
#define ADC_IER_EOSMPIE_Msk            (0x1UL << ADC_IER_EOSMPIE_Pos)          /*!< 0x00000002 */
#define ADC_IER_EOSMPIE                ADC_IER_EOSMPIE_Msk                     /*!< ADC group regular end of sampling interrupt */
#define ADC_IER_EOCIE_Pos              (2UL)
#define ADC_IER_EOCIE_Msk              (0x1UL << ADC_IER_EOCIE_Pos)            /*!< 0x00000004 */
#define ADC_IER_EOCIE                  ADC_IER_EOCIE_Msk                       /*!< ADC group regular end of unitary conversion interrupt */
#define ADC_IER_EOSIE_Pos              (3UL)
#define ADC_IER_EOSIE_Msk              (0x1UL << ADC_IER_EOSIE_Pos)            /*!< 0x00000008 */
#define ADC_IER_EOSIE                  ADC_IER_EOSIE_Msk                       /*!< ADC group regular end of sequence conversions interrupt */
#define ADC_IER_OVRIE_Pos              (4UL)
#define ADC_IER_OVRIE_Msk              (0x1UL << ADC_IER_OVRIE_Pos)            /*!< 0x00000010 */
#define ADC_IER_OVRIE                  ADC_IER_OVRIE_Msk                       /*!< ADC group regular overrun interrupt */
#define ADC_IER_JEOCIE_Pos             (5UL)
#define ADC_IER_JEOCIE_Msk             (0x1UL << ADC_IER_JEOCIE_Pos)           /*!< 0x00000020 */
#define ADC_IER_JEOCIE                 ADC_IER_JEOCIE_Msk                      /*!< ADC group injected end of unitary conversion interrupt */
#define ADC_IER_JEOSIE_Pos             (6UL)
#define ADC_IER_JEOSIE_Msk             (0x1UL << ADC_IER_JEOSIE_Pos)           /*!< 0x00000040 */
#define ADC_IER_JEOSIE                 ADC_IER_JEOSIE_Msk                      /*!< ADC group injected end of sequence conversions interrupt */
#define ADC_IER_AWD1IE_Pos             (7UL)
#define ADC_IER_AWD1IE_Msk             (0x1UL << ADC_IER_AWD1IE_Pos)           /*!< 0x00000080 */
#define ADC_IER_AWD1IE                 ADC_IER_AWD1IE_Msk                      /*!< ADC analog watchdog 1 interrupt */
#define ADC_IER_AWD2IE_Pos             (8UL)
#define ADC_IER_AWD2IE_Msk             (0x1UL << ADC_IER_AWD2IE_Pos)           /*!< 0x00000100 */
#define ADC_IER_AWD2IE                 ADC_IER_AWD2IE_Msk                      /*!< ADC analog watchdog 2 interrupt */
#define ADC_IER_AWD3IE_Pos             (9UL)
#define ADC_IER_AWD3IE_Msk             (0x1UL << ADC_IER_AWD3IE_Pos)           /*!< 0x00000200 */
#define ADC_IER_AWD3IE                 ADC_IER_AWD3IE_Msk                      /*!< ADC analog watchdog 3 interrupt */

/********************  Bit definition for ADC_CR register  ********************/
#define ADC_CR_ADEN_Pos                (0UL)
#define ADC_CR_ADEN_Msk                (0x1UL << ADC_CR_ADEN_Pos)              /*!< 0x00000001 */
#define ADC_CR_ADEN                    ADC_CR_ADEN_Msk                         /*!< ADC enable */
#define ADC_CR_ADDIS_Pos               (1UL)
#define ADC_CR_ADDIS_Msk               (0x1UL << ADC_CR_ADDIS_Pos)             /*!< 0x00000002 */
#define ADC_CR_ADDIS                   ADC_CR_ADDIS_Msk                        /*!< ADC disable */
#define ADC_CR_ADSTART_Pos             (2UL)
#define ADC_CR_ADSTART_Msk             (0x1UL << ADC_CR_ADSTART_Pos)           /*!< 0x00000004 */
#define ADC_CR_ADSTART                 ADC_CR_ADSTART_Msk                      /*!< ADC group regular conversion start */
#define ADC_CR_JADSTART_Pos            (3UL)
#define ADC_CR_JADSTART_Msk            (0x1UL << ADC_CR_JADSTART_Pos)          /*!< 0x00000008 */
#define ADC_CR_JADSTART                ADC_CR_JADSTART_Msk                     /*!< ADC group injected conversion start */
#define ADC_CR_ADSTP_Pos               (4UL)
#define ADC_CR_ADSTP_Msk               (0x1UL << ADC_CR_ADSTP_Pos)             /*!< 0x00000010 */
#define ADC_CR_ADSTP                   ADC_CR_ADSTP_Msk                        /*!< ADC group regular conversion stop */
#define ADC_CR_JADSTP_Pos              (5UL)
#define ADC_CR_JADSTP_Msk              (0x1UL << ADC_CR_JADSTP_Pos)            /*!< 0x00000020 */
#define ADC_CR_JADSTP                  ADC_CR_JADSTP_Msk                       /*!< ADC group injected conversion stop */
#define ADC_CR_DEEPPWD_Pos             (29UL)
#define ADC_CR_DEEPPWD_Msk             (0x1UL << ADC_CR_DEEPPWD_Pos)           /*!< 0x20000000 */
#define ADC_CR_DEEPPWD                 ADC_CR_DEEPPWD_Msk                      /*!< ADC deep power down enable */
#define ADC_CR_ADCALDIF_Pos            (30UL)
#define ADC_CR_ADCALDIF_Msk            (0x1UL << ADC_CR_ADCALDIF_Pos)          /*!< 0x40000000 */
#define ADC_CR_ADCALDIF                ADC_CR_ADCALDIF_Msk                     /*!< ADC differential mode for calibration */
#define ADC_CR_ADCAL_Pos               (31UL)
#define ADC_CR_ADCAL_Msk               (0x1UL << ADC_CR_ADCAL_Pos)             /*!< 0x80000000 */
#define ADC_CR_ADCAL                   ADC_CR_ADCAL_Msk                        /*!< ADC calibration */

/********************  Bit definition for ADC_CFGR1 register  ******************/
#define ADC_CFGR1_DMNGT_Pos            (0UL)
#define ADC_CFGR1_DMNGT_Msk            (0x3UL << ADC_CFGR1_DMNGT_Pos)          /*!< 0x00000003 */
#define ADC_CFGR1_DMNGT                ADC_CFGR1_DMNGT_Msk                     /*!< ADC data management configuration */
#define ADC_CFGR1_DMNGT_0              (0x1UL << ADC_CFGR1_DMNGT_Pos)          /*!< 0x00000001 */
#define ADC_CFGR1_DMNGT_1              (0x2UL << ADC_CFGR1_DMNGT_Pos)          /*!< 0x00000002 */

#define ADC_CFGR1_RES_Pos              (2UL)
#define ADC_CFGR1_RES_Msk              (0x3UL << ADC_CFGR1_RES_Pos)            /*!< 0x0000000C */
#define ADC_CFGR1_RES                  ADC_CFGR1_RES_Msk                       /*!< ADC data resolution */
#define ADC_CFGR1_RES_0                (0x1UL << ADC_CFGR1_RES_Pos)            /*!< 0x00000004 */
#define ADC_CFGR1_RES_1                (0x2UL << ADC_CFGR1_RES_Pos)            /*!< 0x00000008 */

#define ADC_CFGR1_EXTSEL_Pos           (5UL)
#define ADC_CFGR1_EXTSEL_Msk           (0x1FUL << ADC_CFGR1_EXTSEL_Pos)        /*!< 0x000003E0 */
#define ADC_CFGR1_EXTSEL               ADC_CFGR1_EXTSEL_Msk                    /*!< ADC group regular external trigger source */
#define ADC_CFGR1_EXTSEL_0             (0x01UL << ADC_CFGR1_EXTSEL_Pos)        /*!< 0x00000020 */
#define ADC_CFGR1_EXTSEL_1             (0x02UL << ADC_CFGR1_EXTSEL_Pos)        /*!< 0x00000040 */
#define ADC_CFGR1_EXTSEL_2             (0x04UL << ADC_CFGR1_EXTSEL_Pos)        /*!< 0x00000080 */
#define ADC_CFGR1_EXTSEL_3             (0x08UL << ADC_CFGR1_EXTSEL_Pos)        /*!< 0x00000100 */
#define ADC_CFGR1_EXTSEL_4             (0x10UL << ADC_CFGR1_EXTSEL_Pos)        /*!< 0x00000200 */

#define ADC_CFGR1_EXTEN_Pos            (10UL)
#define ADC_CFGR1_EXTEN_Msk            (0x3UL << ADC_CFGR1_EXTEN_Pos)          /*!< 0x00000C00 */
#define ADC_CFGR1_EXTEN                ADC_CFGR1_EXTEN_Msk                     /*!< ADC group regular external trigger polarity */
#define ADC_CFGR1_EXTEN_0              (0x1UL << ADC_CFGR1_EXTEN_Pos)          /*!< 0x00000400 */
#define ADC_CFGR1_EXTEN_1              (0x2UL << ADC_CFGR1_EXTEN_Pos)          /*!< 0x00000800 */

#define ADC_CFGR1_OVRMOD_Pos           (12UL)
#define ADC_CFGR1_OVRMOD_Msk           (0x1UL << ADC_CFGR1_OVRMOD_Pos)         /*!< 0x00001000 */
#define ADC_CFGR1_OVRMOD               ADC_CFGR1_OVRMOD_Msk                    /*!< ADC group regular overrun configuration */
#define ADC_CFGR1_CONT_Pos             (13UL)
#define ADC_CFGR1_CONT_Msk             (0x1UL << ADC_CFGR1_CONT_Pos)           /*!< 0x00002000 */
#define ADC_CFGR1_CONT                 ADC_CFGR1_CONT_Msk                      /*!< ADC group regular continuous conversion mode */
#define ADC_CFGR1_AUTDLY_Pos           (14UL)
#define ADC_CFGR1_AUTDLY_Msk           (0x1UL << ADC_CFGR1_AUTDLY_Pos)         /*!< 0x00004000 */
#define ADC_CFGR1_AUTDLY               ADC_CFGR1_AUTDLY_Msk                    /*!< ADC low power auto wait */

#define ADC_CFGR1_DISCEN_Pos           (16UL)
#define ADC_CFGR1_DISCEN_Msk           (0x1UL << ADC_CFGR1_DISCEN_Pos)         /*!< 0x00010000 */
#define ADC_CFGR1_DISCEN               ADC_CFGR1_DISCEN_Msk                    /*!< ADC group regular sequencer discontinuous mode */

#define ADC_CFGR1_DISCNUM_Pos          (17UL)
#define ADC_CFGR1_DISCNUM_Msk          (0x7UL << ADC_CFGR1_DISCNUM_Pos)        /*!< 0x000E0000 */
#define ADC_CFGR1_DISCNUM              ADC_CFGR1_DISCNUM_Msk                   /*!< ADC group regular sequencer discontinuous number of ranks */
#define ADC_CFGR1_DISCNUM_0            (0x1UL << ADC_CFGR1_DISCNUM_Pos)        /*!< 0x00020000 */
#define ADC_CFGR1_DISCNUM_1            (0x2UL << ADC_CFGR1_DISCNUM_Pos)        /*!< 0x00040000 */
#define ADC_CFGR1_DISCNUM_2            (0x4UL << ADC_CFGR1_DISCNUM_Pos)        /*!< 0x00080000 */

#define ADC_CFGR1_JDISCEN_Pos          (20UL)
#define ADC_CFGR1_JDISCEN_Msk          (0x1UL << ADC_CFGR1_JDISCEN_Pos)        /*!< 0x00100000 */
#define ADC_CFGR1_JDISCEN              ADC_CFGR1_JDISCEN_Msk                   /*!< ADC group injected sequencer discontinuous mode */

#define ADC_CFGR1_AWD1SGL_Pos          (22UL)
#define ADC_CFGR1_AWD1SGL_Msk          (0x1UL << ADC_CFGR1_AWD1SGL_Pos)        /*!< 0x00400000 */
#define ADC_CFGR1_AWD1SGL              ADC_CFGR1_AWD1SGL_Msk                   /*!< ADC analog watchdog 1 monitoring a single channel or all channels */
#define ADC_CFGR1_AWD1EN_Pos           (23UL)
#define ADC_CFGR1_AWD1EN_Msk           (0x1UL << ADC_CFGR1_AWD1EN_Pos)         /*!< 0x00800000 */
#define ADC_CFGR1_AWD1EN               ADC_CFGR1_AWD1EN_Msk                    /*!< ADC analog watchdog 1 enable on scope ADC group regular */
#define ADC_CFGR1_JAWD1EN_Pos          (24UL)
#define ADC_CFGR1_JAWD1EN_Msk          (0x1UL << ADC_CFGR1_JAWD1EN_Pos)        /*!< 0x01000000 */
#define ADC_CFGR1_JAWD1EN              ADC_CFGR1_JAWD1EN_Msk                   /*!< ADC analog watchdog 1 enable on scope ADC group injected */
#define ADC_CFGR1_JAUTO_Pos            (25UL)
#define ADC_CFGR1_JAUTO_Msk            (0x1UL << ADC_CFGR1_JAUTO_Pos)          /*!< 0x02000000 */
#define ADC_CFGR1_JAUTO                ADC_CFGR1_JAUTO_Msk                     /*!< ADC group injected automatic trigger mode */

#define ADC_CFGR1_AWD1CH_Pos           (26UL)
#define ADC_CFGR1_AWD1CH_Msk           (0x1FUL << ADC_CFGR1_AWD1CH_Pos)        /*!< 0x7C000000 */
#define ADC_CFGR1_AWD1CH               ADC_CFGR1_AWD1CH_Msk                    /*!< ADC analog watchdog 1 monitored channel selection */
#define ADC_CFGR1_AWD1CH_0             (0x01UL << ADC_CFGR1_AWD1CH_Pos)        /*!< 0x04000000 */
#define ADC_CFGR1_AWD1CH_1             (0x02UL << ADC_CFGR1_AWD1CH_Pos)        /*!< 0x08000000 */
#define ADC_CFGR1_AWD1CH_2             (0x04UL << ADC_CFGR1_AWD1CH_Pos)        /*!< 0x10000000 */
#define ADC_CFGR1_AWD1CH_3             (0x08UL << ADC_CFGR1_AWD1CH_Pos)        /*!< 0x20000000 */
#define ADC_CFGR1_AWD1CH_4             (0x10UL << ADC_CFGR1_AWD1CH_Pos)        /*!< 0x40000000 */

/********************  Bit definition for ADC_CFGR2 register  *****************/
#define ADC_CFGR2_ROVSE_Pos            (0UL)
#define ADC_CFGR2_ROVSE_Msk            (0x1UL << ADC_CFGR2_ROVSE_Pos)          /*!< 0x00000001 */
#define ADC_CFGR2_ROVSE                ADC_CFGR2_ROVSE_Msk                     /*!< ADC oversampler enable on scope ADC group regular */
#define ADC_CFGR2_JOVSE_Pos            (1UL)
#define ADC_CFGR2_JOVSE_Msk            (0x1UL << ADC_CFGR2_JOVSE_Pos)          /*!< 0x00000002 */
#define ADC_CFGR2_JOVSE                ADC_CFGR2_JOVSE_Msk                     /*!< ADC oversampler enable on scope ADC group injected */

#define ADC_CFGR2_OVSS_Pos             (5UL)
#define ADC_CFGR2_OVSS_Msk             (0xFUL << ADC_CFGR2_OVSS_Pos)           /*!< 0x000001E0 */
#define ADC_CFGR2_OVSS                 ADC_CFGR2_OVSS_Msk                      /*!< ADC oversampling shift */
#define ADC_CFGR2_OVSS_0               (0x1UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000020 */
#define ADC_CFGR2_OVSS_1               (0x2UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000040 */
#define ADC_CFGR2_OVSS_2               (0x4UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000080 */
#define ADC_CFGR2_OVSS_3               (0x8UL << ADC_CFGR2_OVSS_Pos)           /*!< 0x00000100 */

#define ADC_CFGR2_TROVS_Pos            (9UL)
#define ADC_CFGR2_TROVS_Msk            (0x1UL << ADC_CFGR2_TROVS_Pos)          /*!< 0x00000200 */
#define ADC_CFGR2_TROVS                ADC_CFGR2_TROVS_Msk                     /*!< ADC oversampling discontinuous mode (triggered mode) for ADC group regular */
#define ADC_CFGR2_ROVSM_Pos            (10UL)
#define ADC_CFGR2_ROVSM_Msk            (0x1UL << ADC_CFGR2_ROVSM_Pos)          /*!< 0x00000400 */
#define ADC_CFGR2_ROVSM                ADC_CFGR2_ROVSM_Msk                     /*!< ADC oversampling mode managing interlaced conversions of ADC group regular and group injected */

#define ADC_CFGR2_BULB_Pos             (13UL)
#define ADC_CFGR2_BULB_Msk             (0x1UL << ADC_CFGR2_BULB_Pos)            /*!< 0x00002000 */
#define ADC_CFGR2_BULB                 ADC_CFGR2_BULB_Msk                       /*!< ADC bulb sampling mode */

#define ADC_CFGR2_SWTRIG_Pos           (14UL)
#define ADC_CFGR2_SWTRIG_Msk           (0x1UL << ADC_CFGR2_SWTRIG_Pos)          /*!< 0x00004000 */
#define ADC_CFGR2_SWTRIG               ADC_CFGR2_SWTRIG_Msk                     /*!< ADC software trigger bit for sampling time control trigger mode */

#define ADC_CFGR2_SMPTRIG_Pos          (15UL)
#define ADC_CFGR2_SMPTRIG_Msk          (0x1UL << ADC_CFGR2_SMPTRIG_Pos)         /*!< 0x00008000 */
#define ADC_CFGR2_SMPTRIG              ADC_CFGR2_SMPTRIG_Msk                    /*!< ADC sampling time control trigger mode */

#define ADC_CFGR2_OVSR_Pos             (16UL)
#define ADC_CFGR2_OVSR_Msk             (0x3FFUL << ADC_CFGR2_OVSR_Pos)          /*!< 0x03FF0000 */
#define ADC_CFGR2_OVSR                 ADC_CFGR2_OVSR_Msk                       /*!< ADC oversampling ratio */
#define ADC_CFGR2_OVSR_0               (0x001UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x00010000 */
#define ADC_CFGR2_OVSR_1               (0x002UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x00020000 */
#define ADC_CFGR2_OVSR_2               (0x004UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x00040000 */
#define ADC_CFGR2_OVSR_3               (0x008UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x00080000 */
#define ADC_CFGR2_OVSR_4               (0x010UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x00100000 */
#define ADC_CFGR2_OVSR_5               (0x020UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x00200000 */
#define ADC_CFGR2_OVSR_6               (0x040UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x00400000 */
#define ADC_CFGR2_OVSR_7               (0x080UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x00800000 */
#define ADC_CFGR2_OVSR_8               (0x100UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x01000000 */
#define ADC_CFGR2_OVSR_9               (0x200UL << ADC_CFGR2_OVSR_Pos)          /*!< 0x02000000 */

#define ADC_CFGR2_LSHIFT_Pos           (28UL)
#define ADC_CFGR2_LSHIFT_Msk           (0xFUL << ADC_CFGR2_LSHIFT_Pos)          /*!< 0xF0000000 */
#define ADC_CFGR2_LSHIFT               ADC_CFGR2_LSHIFT_Msk                     /*!< ADC left shift factor */
#define ADC_CFGR2_LSHIFT_0             (0x1UL << ADC_CFGR2_LSHIFT_Pos)          /*!< 0x10000000 */
#define ADC_CFGR2_LSHIFT_1             (0x2UL << ADC_CFGR2_LSHIFT_Pos)          /*!< 0x20000000 */
#define ADC_CFGR2_LSHIFT_2             (0x4UL << ADC_CFGR2_LSHIFT_Pos)          /*!< 0x40000000 */
#define ADC_CFGR2_LSHIFT_3             (0x8UL << ADC_CFGR2_LSHIFT_Pos)          /*!< 0x80000000 */

/********************  Bit definition for ADC_SMPR1 register  *****************/
#define ADC_SMPR1_SMP0_Pos             (0UL)
#define ADC_SMPR1_SMP0_Msk             (0x7UL << ADC_SMPR1_SMP0_Pos)           /*!< 0x00000007 */
#define ADC_SMPR1_SMP0                 ADC_SMPR1_SMP0_Msk                      /*!< ADC channel 0 sampling time selection  */
#define ADC_SMPR1_SMP0_0               (0x1UL << ADC_SMPR1_SMP0_Pos)           /*!< 0x00000001 */
#define ADC_SMPR1_SMP0_1               (0x2UL << ADC_SMPR1_SMP0_Pos)           /*!< 0x00000002 */
#define ADC_SMPR1_SMP0_2               (0x4UL << ADC_SMPR1_SMP0_Pos)           /*!< 0x00000004 */

#define ADC_SMPR1_SMP1_Pos             (3UL)
#define ADC_SMPR1_SMP1_Msk             (0x7UL << ADC_SMPR1_SMP1_Pos)           /*!< 0x00000038 */
#define ADC_SMPR1_SMP1                 ADC_SMPR1_SMP1_Msk                      /*!< ADC channel 1 sampling time selection  */
#define ADC_SMPR1_SMP1_0               (0x1UL << ADC_SMPR1_SMP1_Pos)           /*!< 0x00000008 */
#define ADC_SMPR1_SMP1_1               (0x2UL << ADC_SMPR1_SMP1_Pos)           /*!< 0x00000010 */
#define ADC_SMPR1_SMP1_2               (0x4UL << ADC_SMPR1_SMP1_Pos)           /*!< 0x00000020 */

#define ADC_SMPR1_SMP2_Pos             (6UL)
#define ADC_SMPR1_SMP2_Msk             (0x7UL << ADC_SMPR1_SMP2_Pos)           /*!< 0x000001C0 */
#define ADC_SMPR1_SMP2                 ADC_SMPR1_SMP2_Msk                      /*!< ADC channel 2 sampling time selection  */
#define ADC_SMPR1_SMP2_0               (0x1UL << ADC_SMPR1_SMP2_Pos)           /*!< 0x00000040 */
#define ADC_SMPR1_SMP2_1               (0x2UL << ADC_SMPR1_SMP2_Pos)           /*!< 0x00000080 */
#define ADC_SMPR1_SMP2_2               (0x4UL << ADC_SMPR1_SMP2_Pos)           /*!< 0x00000100 */

#define ADC_SMPR1_SMP3_Pos             (9UL)
#define ADC_SMPR1_SMP3_Msk             (0x7UL << ADC_SMPR1_SMP3_Pos)           /*!< 0x00000E00 */
#define ADC_SMPR1_SMP3                 ADC_SMPR1_SMP3_Msk                      /*!< ADC channel 3 sampling time selection  */
#define ADC_SMPR1_SMP3_0               (0x1UL << ADC_SMPR1_SMP3_Pos)           /*!< 0x00000200 */
#define ADC_SMPR1_SMP3_1               (0x2UL << ADC_SMPR1_SMP3_Pos)           /*!< 0x00000400 */
#define ADC_SMPR1_SMP3_2               (0x4UL << ADC_SMPR1_SMP3_Pos)           /*!< 0x00000800 */

#define ADC_SMPR1_SMP4_Pos             (12UL)
#define ADC_SMPR1_SMP4_Msk             (0x7UL << ADC_SMPR1_SMP4_Pos)           /*!< 0x00007000 */
#define ADC_SMPR1_SMP4                 ADC_SMPR1_SMP4_Msk                      /*!< ADC channel 4 sampling time selection  */
#define ADC_SMPR1_SMP4_0               (0x1UL << ADC_SMPR1_SMP4_Pos)           /*!< 0x00001000 */
#define ADC_SMPR1_SMP4_1               (0x2UL << ADC_SMPR1_SMP4_Pos)           /*!< 0x00002000 */
#define ADC_SMPR1_SMP4_2               (0x4UL << ADC_SMPR1_SMP4_Pos)           /*!< 0x00004000 */

#define ADC_SMPR1_SMP5_Pos             (15UL)
#define ADC_SMPR1_SMP5_Msk             (0x7UL << ADC_SMPR1_SMP5_Pos)           /*!< 0x00038000 */
#define ADC_SMPR1_SMP5                 ADC_SMPR1_SMP5_Msk                      /*!< ADC channel 5 sampling time selection  */
#define ADC_SMPR1_SMP5_0               (0x1UL << ADC_SMPR1_SMP5_Pos)           /*!< 0x00008000 */
#define ADC_SMPR1_SMP5_1               (0x2UL << ADC_SMPR1_SMP5_Pos)           /*!< 0x00010000 */
#define ADC_SMPR1_SMP5_2               (0x4UL << ADC_SMPR1_SMP5_Pos)           /*!< 0x00020000 */

#define ADC_SMPR1_SMP6_Pos             (18UL)
#define ADC_SMPR1_SMP6_Msk             (0x7UL << ADC_SMPR1_SMP6_Pos)           /*!< 0x001C0000 */
#define ADC_SMPR1_SMP6                 ADC_SMPR1_SMP6_Msk                      /*!< ADC channel 6 sampling time selection  */
#define ADC_SMPR1_SMP6_0               (0x1UL << ADC_SMPR1_SMP6_Pos)           /*!< 0x00040000 */
#define ADC_SMPR1_SMP6_1               (0x2UL << ADC_SMPR1_SMP6_Pos)           /*!< 0x00080000 */
#define ADC_SMPR1_SMP6_2               (0x4UL << ADC_SMPR1_SMP6_Pos)           /*!< 0x00100000 */

#define ADC_SMPR1_SMP7_Pos             (21UL)
#define ADC_SMPR1_SMP7_Msk             (0x7UL << ADC_SMPR1_SMP7_Pos)           /*!< 0x00E00000 */
#define ADC_SMPR1_SMP7                 ADC_SMPR1_SMP7_Msk                      /*!< ADC channel 7 sampling time selection  */
#define ADC_SMPR1_SMP7_0               (0x1UL << ADC_SMPR1_SMP7_Pos)           /*!< 0x00200000 */
#define ADC_SMPR1_SMP7_1               (0x2UL << ADC_SMPR1_SMP7_Pos)           /*!< 0x00400000 */
#define ADC_SMPR1_SMP7_2               (0x4UL << ADC_SMPR1_SMP7_Pos)           /*!< 0x00800000 */

#define ADC_SMPR1_SMP8_Pos             (24UL)
#define ADC_SMPR1_SMP8_Msk             (0x7UL << ADC_SMPR1_SMP8_Pos)           /*!< 0x07000000 */
#define ADC_SMPR1_SMP8                 ADC_SMPR1_SMP8_Msk                      /*!< ADC channel 8 sampling time selection  */
#define ADC_SMPR1_SMP8_0               (0x1UL << ADC_SMPR1_SMP8_Pos)           /*!< 0x01000000 */
#define ADC_SMPR1_SMP8_1               (0x2UL << ADC_SMPR1_SMP8_Pos)           /*!< 0x02000000 */
#define ADC_SMPR1_SMP8_2               (0x4UL << ADC_SMPR1_SMP8_Pos)           /*!< 0x04000000 */

#define ADC_SMPR1_SMP9_Pos             (27UL)
#define ADC_SMPR1_SMP9_Msk             (0x7UL << ADC_SMPR1_SMP9_Pos)           /*!< 0x38000000 */
#define ADC_SMPR1_SMP9                 ADC_SMPR1_SMP9_Msk                      /*!< ADC channel 9 sampling time selection  */
#define ADC_SMPR1_SMP9_0               (0x1UL << ADC_SMPR1_SMP9_Pos)           /*!< 0x08000000 */
#define ADC_SMPR1_SMP9_1               (0x2UL << ADC_SMPR1_SMP9_Pos)           /*!< 0x10000000 */
#define ADC_SMPR1_SMP9_2               (0x4UL << ADC_SMPR1_SMP9_Pos)           /*!< 0x20000000 */

/********************  Bit definition for ADC_SMPR2 register  *****************/
#define ADC_SMPR2_SMP10_Pos            (0UL)
#define ADC_SMPR2_SMP10_Msk            (0x7UL << ADC_SMPR2_SMP10_Pos)          /*!< 0x00000007 */
#define ADC_SMPR2_SMP10                ADC_SMPR2_SMP10_Msk                     /*!< ADC channel 10 sampling time selection  */
#define ADC_SMPR2_SMP10_0              (0x1UL << ADC_SMPR2_SMP10_Pos)          /*!< 0x00000001 */
#define ADC_SMPR2_SMP10_1              (0x2UL << ADC_SMPR2_SMP10_Pos)          /*!< 0x00000002 */
#define ADC_SMPR2_SMP10_2              (0x4UL << ADC_SMPR2_SMP10_Pos)          /*!< 0x00000004 */

#define ADC_SMPR2_SMP11_Pos            (3UL)
#define ADC_SMPR2_SMP11_Msk            (0x7UL << ADC_SMPR2_SMP11_Pos)          /*!< 0x00000038 */
#define ADC_SMPR2_SMP11                ADC_SMPR2_SMP11_Msk                     /*!< ADC channel 11 sampling time selection  */
#define ADC_SMPR2_SMP11_0              (0x1UL << ADC_SMPR2_SMP11_Pos)          /*!< 0x00000008 */
#define ADC_SMPR2_SMP11_1              (0x2UL << ADC_SMPR2_SMP11_Pos)          /*!< 0x00000010 */
#define ADC_SMPR2_SMP11_2              (0x4UL << ADC_SMPR2_SMP11_Pos)          /*!< 0x00000020 */

#define ADC_SMPR2_SMP12_Pos            (6UL)
#define ADC_SMPR2_SMP12_Msk            (0x7UL << ADC_SMPR2_SMP12_Pos)          /*!< 0x000001C0 */
#define ADC_SMPR2_SMP12                ADC_SMPR2_SMP12_Msk                     /*!< ADC channel 12 sampling time selection  */
#define ADC_SMPR2_SMP12_0              (0x1UL << ADC_SMPR2_SMP12_Pos)          /*!< 0x00000040 */
#define ADC_SMPR2_SMP12_1              (0x2UL << ADC_SMPR2_SMP12_Pos)          /*!< 0x00000080 */
#define ADC_SMPR2_SMP12_2              (0x4UL << ADC_SMPR2_SMP12_Pos)          /*!< 0x00000100 */

#define ADC_SMPR2_SMP13_Pos            (9UL)
#define ADC_SMPR2_SMP13_Msk            (0x7UL << ADC_SMPR2_SMP13_Pos)          /*!< 0x00000E00 */
#define ADC_SMPR2_SMP13                ADC_SMPR2_SMP13_Msk                     /*!< ADC channel 13 sampling time selection  */
#define ADC_SMPR2_SMP13_0              (0x1UL << ADC_SMPR2_SMP13_Pos)          /*!< 0x00000200 */
#define ADC_SMPR2_SMP13_1              (0x2UL << ADC_SMPR2_SMP13_Pos)          /*!< 0x00000400 */
#define ADC_SMPR2_SMP13_2              (0x4UL << ADC_SMPR2_SMP13_Pos)          /*!< 0x00000800 */

#define ADC_SMPR2_SMP14_Pos            (12UL)
#define ADC_SMPR2_SMP14_Msk            (0x7UL << ADC_SMPR2_SMP14_Pos)          /*!< 0x00007000 */
#define ADC_SMPR2_SMP14                ADC_SMPR2_SMP14_Msk                     /*!< ADC channel 14 sampling time selection  */
#define ADC_SMPR2_SMP14_0              (0x1UL << ADC_SMPR2_SMP14_Pos)          /*!< 0x00001000 */
#define ADC_SMPR2_SMP14_1              (0x2UL << ADC_SMPR2_SMP14_Pos)          /*!< 0x00002000 */
#define ADC_SMPR2_SMP14_2              (0x4UL << ADC_SMPR2_SMP14_Pos)          /*!< 0x00004000 */

#define ADC_SMPR2_SMP15_Pos            (15UL)
#define ADC_SMPR2_SMP15_Msk            (0x7UL << ADC_SMPR2_SMP15_Pos)          /*!< 0x00038000 */
#define ADC_SMPR2_SMP15                ADC_SMPR2_SMP15_Msk                     /*!< ADC channel 15 sampling time selection  */
#define ADC_SMPR2_SMP15_0              (0x1UL << ADC_SMPR2_SMP15_Pos)          /*!< 0x00008000 */
#define ADC_SMPR2_SMP15_1              (0x2UL << ADC_SMPR2_SMP15_Pos)          /*!< 0x00010000 */
#define ADC_SMPR2_SMP15_2              (0x4UL << ADC_SMPR2_SMP15_Pos)          /*!< 0x00020000 */

#define ADC_SMPR2_SMP16_Pos            (18UL)
#define ADC_SMPR2_SMP16_Msk            (0x7UL << ADC_SMPR2_SMP16_Pos)          /*!< 0x001C0000 */
#define ADC_SMPR2_SMP16                ADC_SMPR2_SMP16_Msk                     /*!< ADC channel 16 sampling time selection  */
#define ADC_SMPR2_SMP16_0              (0x1UL << ADC_SMPR2_SMP16_Pos)          /*!< 0x00040000 */
#define ADC_SMPR2_SMP16_1              (0x2UL << ADC_SMPR2_SMP16_Pos)          /*!< 0x00080000 */
#define ADC_SMPR2_SMP16_2              (0x4UL << ADC_SMPR2_SMP16_Pos)          /*!< 0x00100000 */

#define ADC_SMPR2_SMP17_Pos            (21UL)
#define ADC_SMPR2_SMP17_Msk            (0x7UL << ADC_SMPR2_SMP17_Pos)          /*!< 0x00E00000 */
#define ADC_SMPR2_SMP17                ADC_SMPR2_SMP17_Msk                     /*!< ADC channel 17 sampling time selection  */
#define ADC_SMPR2_SMP17_0              (0x1UL << ADC_SMPR2_SMP17_Pos)          /*!< 0x00200000 */
#define ADC_SMPR2_SMP17_1              (0x2UL << ADC_SMPR2_SMP17_Pos)          /*!< 0x00400000 */
#define ADC_SMPR2_SMP17_2              (0x4UL << ADC_SMPR2_SMP17_Pos)          /*!< 0x00800000 */

#define ADC_SMPR2_SMP18_Pos            (24UL)
#define ADC_SMPR2_SMP18_Msk            (0x7UL << ADC_SMPR2_SMP18_Pos)          /*!< 0x07000000 */
#define ADC_SMPR2_SMP18                ADC_SMPR2_SMP18_Msk                     /*!< ADC channel 18 sampling time selection  */
#define ADC_SMPR2_SMP18_0              (0x1UL << ADC_SMPR2_SMP18_Pos)          /*!< 0x01000000 */
#define ADC_SMPR2_SMP18_1              (0x2UL << ADC_SMPR2_SMP18_Pos)          /*!< 0x02000000 */
#define ADC_SMPR2_SMP18_2              (0x4UL << ADC_SMPR2_SMP18_Pos)          /*!< 0x04000000 */

#define ADC_SMPR2_SMP19_Pos            (27UL)
#define ADC_SMPR2_SMP19_Msk            (0x7UL << ADC_SMPR2_SMP19_Pos)          /*!< 0x38000000 */
#define ADC_SMPR2_SMP19                ADC_SMPR2_SMP19_Msk                     /*!< ADC Channel 19 Sampling time selection  */
#define ADC_SMPR2_SMP19_0              (0x1UL << ADC_SMPR2_SMP19_Pos)          /*!< 0x08000000 */
#define ADC_SMPR2_SMP19_1              (0x2UL << ADC_SMPR2_SMP19_Pos)          /*!< 0x10000000 */
#define ADC_SMPR2_SMP19_2              (0x4UL << ADC_SMPR2_SMP19_Pos)          /*!< 0x20000000 */

/********************  Bit definition for ADC_PCSEL register  *****************/
#define ADC_PCSEL_PCSEL_Pos            (0UL)
#define ADC_PCSEL_PCSEL_Msk            (0xFFFFFUL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x000FFFFF */
#define ADC_PCSEL_PCSEL                ADC_PCSEL_PCSEL_Msk                   /*!< ADC channel preselection */
#define ADC_PCSEL_PCSEL_0              (0x00001UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000001 */
#define ADC_PCSEL_PCSEL_1              (0x00002UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000002 */
#define ADC_PCSEL_PCSEL_2              (0x00004UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000004 */
#define ADC_PCSEL_PCSEL_3              (0x00008UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000008 */
#define ADC_PCSEL_PCSEL_4              (0x00010UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000010 */
#define ADC_PCSEL_PCSEL_5              (0x00020UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000020 */
#define ADC_PCSEL_PCSEL_6              (0x00040UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000040 */
#define ADC_PCSEL_PCSEL_7              (0x00080UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000080 */
#define ADC_PCSEL_PCSEL_8              (0x00100UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000100 */
#define ADC_PCSEL_PCSEL_9              (0x00200UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000200 */
#define ADC_PCSEL_PCSEL_10             (0x00400UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000400 */
#define ADC_PCSEL_PCSEL_11             (0x00800UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000800 */
#define ADC_PCSEL_PCSEL_12             (0x01000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00001000 */
#define ADC_PCSEL_PCSEL_13             (0x02000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00002000 */
#define ADC_PCSEL_PCSEL_14             (0x04000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00004000 */
#define ADC_PCSEL_PCSEL_15             (0x08000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00008000 */
#define ADC_PCSEL_PCSEL_16             (0x10000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00010000 */
#define ADC_PCSEL_PCSEL_17             (0x20000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00020000 */
#define ADC_PCSEL_PCSEL_18             (0x40000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00040000 */
#define ADC_PCSEL_PCSEL_19             (0x80000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00080000 */

/********************  Bit definition for ADC_SQR1 register  ******************/
#define ADC_SQR1_L_Pos                 (0UL)
#define ADC_SQR1_L_Msk                 (0xFUL << ADC_SQR1_L_Pos)               /*!< 0x0000000F */
#define ADC_SQR1_L                     ADC_SQR1_L_Msk                          /*!< ADC group regular sequencer scan length */
#define ADC_SQR1_L_0                   (0x1UL << ADC_SQR1_L_Pos)               /*!< 0x00000001 */
#define ADC_SQR1_L_1                   (0x2UL << ADC_SQR1_L_Pos)               /*!< 0x00000002 */
#define ADC_SQR1_L_2                   (0x4UL << ADC_SQR1_L_Pos)               /*!< 0x00000004 */
#define ADC_SQR1_L_3                   (0x8UL << ADC_SQR1_L_Pos)               /*!< 0x00000008 */

#define ADC_SQR1_SQ1_Pos               (6UL)
#define ADC_SQR1_SQ1_Msk               (0x1FUL << ADC_SQR1_SQ1_Pos)            /*!< 0x000007C0 */
#define ADC_SQR1_SQ1                   ADC_SQR1_SQ1_Msk                        /*!< ADC group regular sequencer rank 1 */
#define ADC_SQR1_SQ1_0                 (0x01UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000040 */
#define ADC_SQR1_SQ1_1                 (0x02UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000080 */
#define ADC_SQR1_SQ1_2                 (0x04UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000100 */
#define ADC_SQR1_SQ1_3                 (0x08UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000200 */
#define ADC_SQR1_SQ1_4                 (0x10UL << ADC_SQR1_SQ1_Pos)            /*!< 0x00000400 */

#define ADC_SQR1_SQ2_Pos               (12UL)
#define ADC_SQR1_SQ2_Msk               (0x1FUL << ADC_SQR1_SQ2_Pos)            /*!< 0x0001F000 */
#define ADC_SQR1_SQ2                   ADC_SQR1_SQ2_Msk                        /*!< ADC group regular sequencer rank 2 */
#define ADC_SQR1_SQ2_0                 (0x01UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00001000 */
#define ADC_SQR1_SQ2_1                 (0x02UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00002000 */
#define ADC_SQR1_SQ2_2                 (0x04UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00004000 */
#define ADC_SQR1_SQ2_3                 (0x08UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00008000 */
#define ADC_SQR1_SQ2_4                 (0x10UL << ADC_SQR1_SQ2_Pos)            /*!< 0x00010000 */

#define ADC_SQR1_SQ3_Pos               (18UL)
#define ADC_SQR1_SQ3_Msk               (0x1FUL << ADC_SQR1_SQ3_Pos)            /*!< 0x007C0000 */
#define ADC_SQR1_SQ3                   ADC_SQR1_SQ3_Msk                        /*!< ADC group regular sequencer rank 3 */
#define ADC_SQR1_SQ3_0                 (0x01UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00040000 */
#define ADC_SQR1_SQ3_1                 (0x02UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00080000 */
#define ADC_SQR1_SQ3_2                 (0x04UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00100000 */
#define ADC_SQR1_SQ3_3                 (0x08UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00200000 */
#define ADC_SQR1_SQ3_4                 (0x10UL << ADC_SQR1_SQ3_Pos)            /*!< 0x00400000 */

#define ADC_SQR1_SQ4_Pos               (24UL)
#define ADC_SQR1_SQ4_Msk               (0x1FUL << ADC_SQR1_SQ4_Pos)            /*!< 0x1F000000 */
#define ADC_SQR1_SQ4                   ADC_SQR1_SQ4_Msk                        /*!< ADC group regular sequencer rank 4 */
#define ADC_SQR1_SQ4_0                 (0x01UL << ADC_SQR1_SQ4_Pos)            /*!< 0x01000000 */
#define ADC_SQR1_SQ4_1                 (0x02UL << ADC_SQR1_SQ4_Pos)            /*!< 0x02000000 */
#define ADC_SQR1_SQ4_2                 (0x04UL << ADC_SQR1_SQ4_Pos)            /*!< 0x04000000 */
#define ADC_SQR1_SQ4_3                 (0x08UL << ADC_SQR1_SQ4_Pos)            /*!< 0x08000000 */
#define ADC_SQR1_SQ4_4                 (0x10UL << ADC_SQR1_SQ4_Pos)            /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR2 register  ******************/
#define ADC_SQR2_SQ5_Pos               (0UL)
#define ADC_SQR2_SQ5_Msk               (0x1FUL << ADC_SQR2_SQ5_Pos)            /*!< 0x0000001F */
#define ADC_SQR2_SQ5                   ADC_SQR2_SQ5_Msk                        /*!< ADC group regular sequencer rank 5 */
#define ADC_SQR2_SQ5_0                 (0x01UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000001 */
#define ADC_SQR2_SQ5_1                 (0x02UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000002 */
#define ADC_SQR2_SQ5_2                 (0x04UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000004 */
#define ADC_SQR2_SQ5_3                 (0x08UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000008 */
#define ADC_SQR2_SQ5_4                 (0x10UL << ADC_SQR2_SQ5_Pos)            /*!< 0x00000010 */

#define ADC_SQR2_SQ6_Pos               (6UL)
#define ADC_SQR2_SQ6_Msk               (0x1FUL << ADC_SQR2_SQ6_Pos)            /*!< 0x000007C0 */
#define ADC_SQR2_SQ6                   ADC_SQR2_SQ6_Msk                        /*!< ADC group regular sequencer rank 6 */
#define ADC_SQR2_SQ6_0                 (0x01UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000040 */
#define ADC_SQR2_SQ6_1                 (0x02UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000080 */
#define ADC_SQR2_SQ6_2                 (0x04UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000100 */
#define ADC_SQR2_SQ6_3                 (0x08UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000200 */
#define ADC_SQR2_SQ6_4                 (0x10UL << ADC_SQR2_SQ6_Pos)            /*!< 0x00000400 */

#define ADC_SQR2_SQ7_Pos               (12UL)
#define ADC_SQR2_SQ7_Msk               (0x1FUL << ADC_SQR2_SQ7_Pos)            /*!< 0x0001F000 */
#define ADC_SQR2_SQ7                   ADC_SQR2_SQ7_Msk                        /*!< ADC group regular sequencer rank 7 */
#define ADC_SQR2_SQ7_0                 (0x01UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00001000 */
#define ADC_SQR2_SQ7_1                 (0x02UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00002000 */
#define ADC_SQR2_SQ7_2                 (0x04UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00004000 */
#define ADC_SQR2_SQ7_3                 (0x08UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00008000 */
#define ADC_SQR2_SQ7_4                 (0x10UL << ADC_SQR2_SQ7_Pos)            /*!< 0x00010000 */

#define ADC_SQR2_SQ8_Pos               (18UL)
#define ADC_SQR2_SQ8_Msk               (0x1FUL << ADC_SQR2_SQ8_Pos)            /*!< 0x007C0000 */
#define ADC_SQR2_SQ8                   ADC_SQR2_SQ8_Msk                        /*!< ADC group regular sequencer rank 8 */
#define ADC_SQR2_SQ8_0                 (0x01UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00040000 */
#define ADC_SQR2_SQ8_1                 (0x02UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00080000 */
#define ADC_SQR2_SQ8_2                 (0x04UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00100000 */
#define ADC_SQR2_SQ8_3                 (0x08UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00200000 */
#define ADC_SQR2_SQ8_4                 (0x10UL << ADC_SQR2_SQ8_Pos)            /*!< 0x00400000 */

#define ADC_SQR2_SQ9_Pos               (24UL)
#define ADC_SQR2_SQ9_Msk               (0x1FUL << ADC_SQR2_SQ9_Pos)            /*!< 0x1F000000 */
#define ADC_SQR2_SQ9                   ADC_SQR2_SQ9_Msk                        /*!< ADC group regular sequencer rank 9 */
#define ADC_SQR2_SQ9_0                 (0x01UL << ADC_SQR2_SQ9_Pos)            /*!< 0x01000000 */
#define ADC_SQR2_SQ9_1                 (0x02UL << ADC_SQR2_SQ9_Pos)            /*!< 0x02000000 */
#define ADC_SQR2_SQ9_2                 (0x04UL << ADC_SQR2_SQ9_Pos)            /*!< 0x04000000 */
#define ADC_SQR2_SQ9_3                 (0x08UL << ADC_SQR2_SQ9_Pos)            /*!< 0x08000000 */
#define ADC_SQR2_SQ9_4                 (0x10UL << ADC_SQR2_SQ9_Pos)            /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR3 register  ******************/
#define ADC_SQR3_SQ10_Pos              (0UL)
#define ADC_SQR3_SQ10_Msk              (0x1FUL << ADC_SQR3_SQ10_Pos)           /*!< 0x0000001F */
#define ADC_SQR3_SQ10                  ADC_SQR3_SQ10_Msk                       /*!< ADC group regular sequencer rank 10 */
#define ADC_SQR3_SQ10_0                (0x01UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000001 */
#define ADC_SQR3_SQ10_1                (0x02UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000002 */
#define ADC_SQR3_SQ10_2                (0x04UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000004 */
#define ADC_SQR3_SQ10_3                (0x08UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000008 */
#define ADC_SQR3_SQ10_4                (0x10UL << ADC_SQR3_SQ10_Pos)           /*!< 0x00000010 */

#define ADC_SQR3_SQ11_Pos              (6UL)
#define ADC_SQR3_SQ11_Msk              (0x1FUL << ADC_SQR3_SQ11_Pos)           /*!< 0x000007C0 */
#define ADC_SQR3_SQ11                  ADC_SQR3_SQ11_Msk                       /*!< ADC group regular sequencer rank 11 */
#define ADC_SQR3_SQ11_0                (0x01UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000040 */
#define ADC_SQR3_SQ11_1                (0x02UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000080 */
#define ADC_SQR3_SQ11_2                (0x04UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000100 */
#define ADC_SQR3_SQ11_3                (0x08UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000200 */
#define ADC_SQR3_SQ11_4                (0x10UL << ADC_SQR3_SQ11_Pos)           /*!< 0x00000400 */

#define ADC_SQR3_SQ12_Pos              (12UL)
#define ADC_SQR3_SQ12_Msk              (0x1FUL << ADC_SQR3_SQ12_Pos)           /*!< 0x0001F000 */
#define ADC_SQR3_SQ12                  ADC_SQR3_SQ12_Msk                       /*!< ADC group regular sequencer rank 12 */
#define ADC_SQR3_SQ12_0                (0x01UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00001000 */
#define ADC_SQR3_SQ12_1                (0x02UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00002000 */
#define ADC_SQR3_SQ12_2                (0x04UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00004000 */
#define ADC_SQR3_SQ12_3                (0x08UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00008000 */
#define ADC_SQR3_SQ12_4                (0x10UL << ADC_SQR3_SQ12_Pos)           /*!< 0x00010000 */

#define ADC_SQR3_SQ13_Pos              (18UL)
#define ADC_SQR3_SQ13_Msk              (0x1FUL << ADC_SQR3_SQ13_Pos)           /*!< 0x007C0000 */
#define ADC_SQR3_SQ13                  ADC_SQR3_SQ13_Msk                       /*!< ADC group regular sequencer rank 13 */
#define ADC_SQR3_SQ13_0                (0x01UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00040000 */
#define ADC_SQR3_SQ13_1                (0x02UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00080000 */
#define ADC_SQR3_SQ13_2                (0x04UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00100000 */
#define ADC_SQR3_SQ13_3                (0x08UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00200000 */
#define ADC_SQR3_SQ13_4                (0x10UL << ADC_SQR3_SQ13_Pos)           /*!< 0x00400000 */

#define ADC_SQR3_SQ14_Pos              (24UL)
#define ADC_SQR3_SQ14_Msk              (0x1FUL << ADC_SQR3_SQ14_Pos)           /*!< 0x1F000000 */
#define ADC_SQR3_SQ14                  ADC_SQR3_SQ14_Msk                       /*!< ADC group regular sequencer rank 14 */
#define ADC_SQR3_SQ14_0                (0x01UL << ADC_SQR3_SQ14_Pos)           /*!< 0x01000000 */
#define ADC_SQR3_SQ14_1                (0x02UL << ADC_SQR3_SQ14_Pos)           /*!< 0x02000000 */
#define ADC_SQR3_SQ14_2                (0x04UL << ADC_SQR3_SQ14_Pos)           /*!< 0x04000000 */
#define ADC_SQR3_SQ14_3                (0x08UL << ADC_SQR3_SQ14_Pos)           /*!< 0x08000000 */
#define ADC_SQR3_SQ14_4                (0x10UL << ADC_SQR3_SQ14_Pos)           /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR4 register  ******************/
#define ADC_SQR4_SQ15_Pos              (0UL)
#define ADC_SQR4_SQ15_Msk              (0x1FUL << ADC_SQR4_SQ15_Pos)           /*!< 0x0000001F */
#define ADC_SQR4_SQ15                  ADC_SQR4_SQ15_Msk                       /*!< ADC group regular sequencer rank 15 */
#define ADC_SQR4_SQ15_0                (0x01UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000001 */
#define ADC_SQR4_SQ15_1                (0x02UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000002 */
#define ADC_SQR4_SQ15_2                (0x04UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000004 */
#define ADC_SQR4_SQ15_3                (0x08UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000008 */
#define ADC_SQR4_SQ15_4                (0x10UL << ADC_SQR4_SQ15_Pos)           /*!< 0x00000010 */

#define ADC_SQR4_SQ16_Pos              (6UL)
#define ADC_SQR4_SQ16_Msk              (0x1FUL << ADC_SQR4_SQ16_Pos)           /*!< 0x000007C0 */
#define ADC_SQR4_SQ16                  ADC_SQR4_SQ16_Msk                       /*!< ADC group regular sequencer rank 16 */
#define ADC_SQR4_SQ16_0                (0x01UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000040 */
#define ADC_SQR4_SQ16_1                (0x02UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000080 */
#define ADC_SQR4_SQ16_2                (0x04UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000100 */
#define ADC_SQR4_SQ16_3                (0x08UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000200 */
#define ADC_SQR4_SQ16_4                (0x10UL << ADC_SQR4_SQ16_Pos)           /*!< 0x00000400 */

/********************  Bit definition for ADC_DR register  ********************/
#define ADC_DR_RDATA_Pos               (0UL)
#define ADC_DR_RDATA_Msk               (0xFFFFFFFFUL << ADC_DR_RDATA_Pos)      /*!< 0xFFFFFFFF */
#define ADC_DR_RDATA                   ADC_DR_RDATA_Msk                        /*!< ADC group regular conversion data */
#define ADC_DR_RDATA_0                 (0x00000001UL << ADC_DR_RDATA_Pos)      /*!< 0x00000001 */
#define ADC_DR_RDATA_1                 (0x00000002UL << ADC_DR_RDATA_Pos)      /*!< 0x00000002 */
#define ADC_DR_RDATA_2                 (0x00000004UL << ADC_DR_RDATA_Pos)      /*!< 0x00000004 */
#define ADC_DR_RDATA_3                 (0x00000008UL << ADC_DR_RDATA_Pos)      /*!< 0x00000008 */
#define ADC_DR_RDATA_4                 (0x00000010UL << ADC_DR_RDATA_Pos)      /*!< 0x00000010 */
#define ADC_DR_RDATA_5                 (0x00000020UL << ADC_DR_RDATA_Pos)      /*!< 0x00000020 */
#define ADC_DR_RDATA_6                 (0x00000040UL << ADC_DR_RDATA_Pos)      /*!< 0x00000040 */
#define ADC_DR_RDATA_7                 (0x00000080UL << ADC_DR_RDATA_Pos)      /*!< 0x00000080 */
#define ADC_DR_RDATA_8                 (0x00000100UL << ADC_DR_RDATA_Pos)      /*!< 0x00000100 */
#define ADC_DR_RDATA_9                 (0x00000200UL << ADC_DR_RDATA_Pos)      /*!< 0x00000200 */
#define ADC_DR_RDATA_10                (0x00000400UL << ADC_DR_RDATA_Pos)      /*!< 0x00000400 */
#define ADC_DR_RDATA_11                (0x00000800UL << ADC_DR_RDATA_Pos)      /*!< 0x00000800 */
#define ADC_DR_RDATA_12                (0x00001000UL << ADC_DR_RDATA_Pos)      /*!< 0x00001000 */
#define ADC_DR_RDATA_13                (0x00002000UL << ADC_DR_RDATA_Pos)      /*!< 0x00002000 */
#define ADC_DR_RDATA_14                (0x00004000UL << ADC_DR_RDATA_Pos)      /*!< 0x00004000 */
#define ADC_DR_RDATA_15                (0x00008000UL << ADC_DR_RDATA_Pos)      /*!< 0x00008000 */
#define ADC_DR_RDATA_16                (0x00010000UL << ADC_DR_RDATA_Pos)      /*!< 0x00010000 */
#define ADC_DR_RDATA_17                (0x00020000UL << ADC_DR_RDATA_Pos)      /*!< 0x00020000 */
#define ADC_DR_RDATA_18                (0x00040000UL << ADC_DR_RDATA_Pos)      /*!< 0x00040000 */
#define ADC_DR_RDATA_19                (0x00080000UL << ADC_DR_RDATA_Pos)      /*!< 0x00080000 */
#define ADC_DR_RDATA_20                (0x00100000UL << ADC_DR_RDATA_Pos)      /*!< 0x00100000 */
#define ADC_DR_RDATA_21                (0x00200000UL << ADC_DR_RDATA_Pos)      /*!< 0x00200000 */
#define ADC_DR_RDATA_22                (0x00400000UL << ADC_DR_RDATA_Pos)      /*!< 0x00400000 */
#define ADC_DR_RDATA_23                (0x00800000UL << ADC_DR_RDATA_Pos)      /*!< 0x00800000 */
#define ADC_DR_RDATA_24                (0x01000000UL << ADC_DR_RDATA_Pos)      /*!< 0x01000000 */
#define ADC_DR_RDATA_25                (0x02000000UL << ADC_DR_RDATA_Pos)      /*!< 0x02000000 */
#define ADC_DR_RDATA_26                (0x04000000UL << ADC_DR_RDATA_Pos)      /*!< 0x04000000 */
#define ADC_DR_RDATA_27                (0x08000000UL << ADC_DR_RDATA_Pos)      /*!< 0x08000000 */
#define ADC_DR_RDATA_28                (0x10000000UL << ADC_DR_RDATA_Pos)      /*!< 0x10000000 */
#define ADC_DR_RDATA_29                (0x20000000UL << ADC_DR_RDATA_Pos)      /*!< 0x20000000 */
#define ADC_DR_RDATA_30                (0x40000000UL << ADC_DR_RDATA_Pos)      /*!< 0x40000000 */
#define ADC_DR_RDATA_31                (0x80000000UL << ADC_DR_RDATA_Pos)      /*!< 0x80000000 */

/********************  Bit definition for ADC_JSQR register  ******************/
#define ADC_JSQR_JL_Pos                (0UL)
#define ADC_JSQR_JL_Msk                (0x3UL << ADC_JSQR_JL_Pos)              /*!< 0x00000003 */
#define ADC_JSQR_JL                    ADC_JSQR_JL_Msk                         /*!< ADC group injected sequencer scan length */
#define ADC_JSQR_JL_0                  (0x1UL << ADC_JSQR_JL_Pos)              /*!< 0x00000001 */
#define ADC_JSQR_JL_1                  (0x2UL << ADC_JSQR_JL_Pos)              /*!< 0x00000002 */

#define ADC_JSQR_JEXTSEL_Pos           (2UL)
#define ADC_JSQR_JEXTSEL_Msk           (0x1FUL << ADC_JSQR_JEXTSEL_Pos)        /*!< 0x0000007C */
#define ADC_JSQR_JEXTSEL               ADC_JSQR_JEXTSEL_Msk                    /*!< ADC group injected external trigger source */
#define ADC_JSQR_JEXTSEL_0             (0x01UL << ADC_JSQR_JEXTSEL_Pos)        /*!< 0x00000004 */
#define ADC_JSQR_JEXTSEL_1             (0x02UL << ADC_JSQR_JEXTSEL_Pos)        /*!< 0x00000008 */
#define ADC_JSQR_JEXTSEL_2             (0x04UL << ADC_JSQR_JEXTSEL_Pos)        /*!< 0x00000010 */
#define ADC_JSQR_JEXTSEL_3             (0x08UL << ADC_JSQR_JEXTSEL_Pos)        /*!< 0x00000020 */
#define ADC_JSQR_JEXTSEL_4             (0x10UL << ADC_JSQR_JEXTSEL_Pos)        /*!< 0x00000040 */

#define ADC_JSQR_JEXTEN_Pos            (7UL)
#define ADC_JSQR_JEXTEN_Msk            (0x3UL << ADC_JSQR_JEXTEN_Pos)          /*!< 0x00000180 */
#define ADC_JSQR_JEXTEN                ADC_JSQR_JEXTEN_Msk                     /*!< ADC group injected external trigger polarity */
#define ADC_JSQR_JEXTEN_0              (0x1UL << ADC_JSQR_JEXTEN_Pos)          /*!< 0x00000080 */
#define ADC_JSQR_JEXTEN_1              (0x2UL << ADC_JSQR_JEXTEN_Pos)          /*!< 0x00000100 */

#define ADC_JSQR_JSQ1_Pos              (9UL)
#define ADC_JSQR_JSQ1_Msk              (0x1FUL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00003E00 */
#define ADC_JSQR_JSQ1                  ADC_JSQR_JSQ1_Msk                       /*!< ADC group injected sequencer rank 1 */
#define ADC_JSQR_JSQ1_0                (0x01UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00000200 */
#define ADC_JSQR_JSQ1_1                (0x02UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00000400 */
#define ADC_JSQR_JSQ1_2                (0x04UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00000800 */
#define ADC_JSQR_JSQ1_3                (0x08UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00001000 */
#define ADC_JSQR_JSQ1_4                (0x10UL << ADC_JSQR_JSQ1_Pos)           /*!< 0x00002000 */

#define ADC_JSQR_JSQ2_Pos              (15UL)
#define ADC_JSQR_JSQ2_Msk              (0x1FUL << ADC_JSQR_JSQ2_Pos)           /*!< 0x000F8000 */
#define ADC_JSQR_JSQ2                  ADC_JSQR_JSQ2_Msk                       /*!< ADC group injected sequencer rank 2 */
#define ADC_JSQR_JSQ2_0                (0x01UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00008000 */
#define ADC_JSQR_JSQ2_1                (0x02UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00010000 */
#define ADC_JSQR_JSQ2_2                (0x04UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00020000 */
#define ADC_JSQR_JSQ2_3                (0x08UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00040000 */
#define ADC_JSQR_JSQ2_4                (0x10UL << ADC_JSQR_JSQ2_Pos)           /*!< 0x00080000 */

#define ADC_JSQR_JSQ3_Pos              (21UL)
#define ADC_JSQR_JSQ3_Msk              (0x1FUL << ADC_JSQR_JSQ3_Pos)           /*!< 0x03E00000 */
#define ADC_JSQR_JSQ3                  ADC_JSQR_JSQ3_Msk                       /*!< ADC group injected sequencer rank 3 */
#define ADC_JSQR_JSQ3_0                (0x01UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x00200000 */
#define ADC_JSQR_JSQ3_1                (0x02UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x00400000 */
#define ADC_JSQR_JSQ3_2                (0x04UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x00800000 */
#define ADC_JSQR_JSQ3_3                (0x08UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x01000000 */
#define ADC_JSQR_JSQ3_4                (0x10UL << ADC_JSQR_JSQ3_Pos)           /*!< 0x02000000 */

#define ADC_JSQR_JSQ4_Pos              (27UL)
#define ADC_JSQR_JSQ4_Msk              (0x1FUL << ADC_JSQR_JSQ4_Pos)           /*!< 0xF8000000 */
#define ADC_JSQR_JSQ4                  ADC_JSQR_JSQ4_Msk                       /*!< ADC group injected sequencer rank 4 */
#define ADC_JSQR_JSQ4_0                (0x01UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x08000000 */
#define ADC_JSQR_JSQ4_1                (0x02UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x10000000 */
#define ADC_JSQR_JSQ4_2                (0x04UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x20000000 */
#define ADC_JSQR_JSQ4_3                (0x08UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x40000000 */
#define ADC_JSQR_JSQ4_4                (0x10UL << ADC_JSQR_JSQ4_Pos)           /*!< 0x80000000 */

/********************  Bit definition for ADC_OFCFGR1 register  ***************/
#define ADC_OFCFGR1_POSOFF_Pos         (24UL)
#define ADC_OFCFGR1_POSOFF_Msk         (0x01UL << ADC_OFCFGR1_POSOFF_Pos)      /*!< 0x01000000 */
#define ADC_OFCFGR1_POSOFF             ADC_OFCFGR1_POSOFF_Msk                  /*!< ADC offset instance 1 positive offset enable */

#define ADC_OFCFGR1_USAT_Pos           (25UL)
#define ADC_OFCFGR1_USAT_Msk           (0x01UL << ADC_OFCFGR1_USAT_Pos)        /*!< 0x02000000 */
#define ADC_OFCFGR1_USAT               ADC_OFCFGR1_USAT_Msk                    /*!< ADC offset instance 1  unsigned saturation value */

#define ADC_OFCFGR1_SSAT_Pos           (26UL)
#define ADC_OFCFGR1_SSAT_Msk           (0x01UL << ADC_OFCFGR1_SSAT_Pos)        /*!< 0x04000000 */
#define ADC_OFCFGR1_SSAT               ADC_OFCFGR1_SSAT_Msk                    /*!< ADC offset instance 1 signed satuaration enable */

#define ADC_OFCFGR1_OFFSET_CH_Pos      (27UL)
#define ADC_OFCFGR1_OFFSET_CH_Msk      (0x1FUL << ADC_OFCFGR1_OFFSET_CH_Pos)   /*!< 0xF8000000 */
#define ADC_OFCFGR1_OFFSET_CH          ADC_OFCFGR1_OFFSET_CH_Msk               /*!< ADC offset instance 1 channel selection */
#define ADC_OFCFGR1_OFFSET_CH_0        (0x01UL << ADC_OFCFGR1_OFFSET1_CH_Pos)  /*!< 0x08000000 */
#define ADC_OFCFGR1_OFFSET_CH_1        (0x02UL << ADC_OFCFGR1_OFFSET1_CH_Pos)  /*!< 0x10000000 */
#define ADC_OFCFGR1_OFFSET_CH_2        (0x03UL << ADC_OFCFGR1_OFFSET1_CH_Pos)  /*!< 0x20000000 */
#define ADC_OFCFGR1_OFFSET_CH_3        (0x04UL << ADC_OFCFGR1_OFFSET1_CH_Pos)  /*!< 0x40000000 */
#define ADC_OFCFGR1_OFFSET_CH_4        (0x05UL << ADC_OFCFGR1_OFFSET1_CH_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_OFCFGR2 register  ***************/
#define ADC_OFCFGR2_POSOFF_Pos         (24UL)
#define ADC_OFCFGR2_POSOFF_Msk         (0x01UL << ADC_OFCFGR2_POSOFF_Pos)      /*!< 0x01000000 */
#define ADC_OFCFGR2_POSOFF             ADC_OFCFGR2_POSOFF_Msk                  /*!< ADC offset instance 2 positive offset enable */

#define ADC_OFCFGR2_USAT_Pos           (25UL)
#define ADC_OFCFGR2_USAT_Msk           (0x01UL << ADC_OFCFGR2_USAT_Pos)        /*!< 0x02000000 */
#define ADC_OFCFGR2_USAT               ADC_OFCFGR2_USAT_Msk                    /*!< ADC offset instance 2 unsigned saturation value */

#define ADC_OFCFGR2_SSAT_Pos           (26UL)
#define ADC_OFCFGR2_SSAT_Msk           (0x01UL << ADC_OFCFGR2_SSAT_Pos)        /*!< 0x04000000 */
#define ADC_OFCFGR2_SSAT               ADC_OFCFGR2_SSAT_Msk                    /*!< ADC offset instance 2 signed satuaration enable */

#define ADC_OFCFGR2_OFFSET_CH_Pos      (27UL)
#define ADC_OFCFGR2_OFFSET_CH_Msk      (0x1FUL << ADC_OFCFGR2_OFFSET_CH_Pos)   /*!< 0xF8000000 */
#define ADC_OFCFGR2_OFFSET_CH          ADC_OFCFGR2_OFFSET_CH_Msk               /*!< ADC offset instance 2 channel selection */
#define ADC_OFCFGR2_OFFSET_CH_0        (0x01UL << ADC_OFCFGR2_OFFSET2_CH_Pos)  /*!< 0x08000000 */
#define ADC_OFCFGR2_OFFSET_CH_1        (0x02UL << ADC_OFCFGR2_OFFSET2_CH_Pos)  /*!< 0x10000000 */
#define ADC_OFCFGR2_OFFSET_CH_2        (0x03UL << ADC_OFCFGR2_OFFSET2_CH_Pos)  /*!< 0x20000000 */
#define ADC_OFCFGR2_OFFSET_CH_3        (0x04UL << ADC_OFCFGR2_OFFSET2_CH_Pos)  /*!< 0x40000000 */
#define ADC_OFCFGR2_OFFSET_CH_4        (0x05UL << ADC_OFCFGR2_OFFSET1_CH_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_OFCFGR3 register  ***************/
#define ADC_OFCFGR3_POSOFF_Pos         (24UL)
#define ADC_OFCFGR3_POSOFF_Msk         (0x01UL << ADC_OFCFGR3_POSOFF_Pos)      /*!< 0x01000000 */
#define ADC_OFCFGR3_POSOFF             ADC_OFCFGR3_POSOFF_Msk                  /*!< ADC offset instance 3 positive offset enable */

#define ADC_OFCFGR3_USAT_Pos           (25UL)
#define ADC_OFCFGR3_USAT_Msk           (0x01UL << ADC_OFCFGR3_USAT_Pos)        /*!< 0x02000000 */
#define ADC_OFCFGR3_USAT               ADC_OFCFGR3_USAT_Msk                    /*!< ADC offset instance 3 unsigned saturation value */

#define ADC_OFCFGR3_SSAT_Pos           (26UL)
#define ADC_OFCFGR3_SSAT_Msk           (0x01UL << ADC_OFCFGR3_SSAT_Pos)        /*!< 0x04000000 */
#define ADC_OFCFGR3_SSAT               ADC_OFCFGR3_SSAT_Msk                    /*!< ADC offset instance 3 signed satuaration enable */

#define ADC_OFCFGR3_OFFSET_CH_Pos      (27UL)
#define ADC_OFCFGR3_OFFSET_CH_Msk      (0x1FUL << ADC_OFCFGR3_OFFSET_CH_Pos)   /*!< 0xF8000000 */
#define ADC_OFCFGR3_OFFSET_CH          ADC_OFCFGR3_OFFSET_CH_Msk               /*!< ADC offset instance 3 channel selection for the data offset */
#define ADC_OFCFGR3_OFFSET_CH_0        (0x01UL << ADC_OFCFGR3_OFFSET3_CH_Pos)  /*!< 0x08000000 */
#define ADC_OFCFGR3_OFFSET_CH_1        (0x02UL << ADC_OFCFGR3_OFFSET3_CH_Pos)  /*!< 0x10000000 */
#define ADC_OFCFGR3_OFFSET_CH_2        (0x03UL << ADC_OFCFGR3_OFFSET3_CH_Pos)  /*!< 0x20000000 */
#define ADC_OFCFGR3_OFFSET_CH_3        (0x04UL << ADC_OFCFGR3_OFFSET3_CH_Pos)  /*!< 0x40000000 */
#define ADC_OFCFGR3_OFFSET_CH_4        (0x05UL << ADC_OFCFGR3_OFFSET3_CH_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_OFCFGR4 register  ***************/
#define ADC_OFCFGR4_POSOFF_Pos         (24UL)
#define ADC_OFCFGR4_POSOFF_Msk         (0x01UL << ADC_OFCFGR4_POSOFF_Pos)      /*!< 0x01000000 */
#define ADC_OFCFGR4_POSOFF             ADC_OFCFGR4_POSOFF_Msk                  /*!< ADC offset instance 4 positive offset enable */

#define ADC_OFCFGR4_USAT_Pos           (25UL)
#define ADC_OFCFGR4_USAT_Msk           (0x01UL << ADC_OFCFGR4_USAT_Pos)        /*!< 0x02000000 */
#define ADC_OFCFGR4_USAT               ADC_OFCFGR4_USAT_Msk                    /*!< ADC offset instance 4 unsigned saturation value */

#define ADC_OFCFGR4_SSAT_Pos           (26UL)
#define ADC_OFCFGR4_SSAT_Msk           (0x01UL << ADC_OFCFGR4_SSAT_Pos)        /*!< 0x04000000 */
#define ADC_OFCFGR4_SSAT               ADC_OFCFGR4_SSAT_Msk                    /*!< ADC offset instance 4 signed satuaration enable */

#define ADC_OFCFGR4_OFFSET_CH_Pos      (27UL)
#define ADC_OFCFGR4_OFFSET_CH_Msk      (0x1FUL << ADC_OFCFGR4_OFFSET_CH_Pos)   /*!< 0xF8000000 */
#define ADC_OFCFGR4_OFFSET_CH          ADC_OFCFGR4_OFFSET_CH_Msk               /*!< ADC offset instance 4 channel selection for the data offset */
#define ADC_OFCFGR4_OFFSET_CH_0        (0x01UL << ADC_OFCFGR4_OFFSET4_CH_Pos)  /*!< 0x08000000 */
#define ADC_OFCFGR4_OFFSET_CH_1        (0x02UL << ADC_OFCFGR4_OFFSET4_CH_Pos)  /*!< 0x10000000 */
#define ADC_OFCFGR4_OFFSET_CH_2        (0x03UL << ADC_OFCFGR4_OFFSET4_CH_Pos)  /*!< 0x20000000 */
#define ADC_OFCFGR4_OFFSET_CH_3        (0x04UL << ADC_OFCFGR4_OFFSET4_CH_Pos)  /*!< 0x40000000 */
#define ADC_OFCFGR4_OFFSET_CH_4        (0x05UL << ADC_OFCFGR4_OFFSET4_CH_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_OFR1 register  ******************/
#define ADC_OFR1_OFFSET_Pos            (0UL)
#define ADC_OFR1_OFFSET_Msk            (0x03FFFFFUL << ADC_OFR1_OFFSET_Pos)    /*!< 0x003FFFFF */
#define ADC_OFR1_OFFSET                ADC_OFR1_OFFSET_Msk                     /*!< ADC offset instance 1 offset level */
#define ADC_OFR1_OFFSET_0              (0x0000001UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000001 */
#define ADC_OFR1_OFFSET_1              (0x0000002UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000002 */
#define ADC_OFR1_OFFSET_2              (0x0000004UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000004 */
#define ADC_OFR1_OFFSET_3              (0x0000008UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000008 */
#define ADC_OFR1_OFFSET_4              (0x0000010UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000010 */
#define ADC_OFR1_OFFSET_5              (0x0000020UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000020 */
#define ADC_OFR1_OFFSET_6              (0x0000040UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000040 */
#define ADC_OFR1_OFFSET_7              (0x0000080UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000080 */
#define ADC_OFR1_OFFSET_8              (0x0000100UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000100 */
#define ADC_OFR1_OFFSET_9              (0x0000200UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000200 */
#define ADC_OFR1_OFFSET_10             (0x0000400UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000400 */
#define ADC_OFR1_OFFSET_11             (0x0000800UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00000800 */
#define ADC_OFR1_OFFSET_12             (0x0001000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00001000 */
#define ADC_OFR1_OFFSET_13             (0x0002000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00002000 */
#define ADC_OFR1_OFFSET_14             (0x0004000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00004000 */
#define ADC_OFR1_OFFSET_15             (0x0008000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00008000 */
#define ADC_OFR1_OFFSET_16             (0x0010000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00010000 */
#define ADC_OFR1_OFFSET_17             (0x0020000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00020000 */
#define ADC_OFR1_OFFSET_18             (0x0040000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00040000 */
#define ADC_OFR1_OFFSET_19             (0x0080000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00080000 */
#define ADC_OFR1_OFFSET_20             (0x0100000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00100000 */
#define ADC_OFR1_OFFSET_21             (0x0200000UL << ADC_OFR1_OFFSET_Pos)    /*!< 0x00200000 */

/********************  Bit definition for ADC_OFR2 register  ******************/
#define ADC_OFR2_OFFSET_Pos            (0UL)
#define ADC_OFR2_OFFSET_Msk            (0x03FFFFFUL << ADC_OFR2_OFFSET_Pos)    /*!< 0x003FFFFF */
#define ADC_OFR2_OFFSET                ADC_OFR2_OFFSET_Msk                     /*!< ADC offset instance 2 offset level */
#define ADC_OFR2_OFFSET_0              (0x0000001UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000001 */
#define ADC_OFR2_OFFSET_1              (0x0000002UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000002 */
#define ADC_OFR2_OFFSET_2              (0x0000004UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000004 */
#define ADC_OFR2_OFFSET_3              (0x0000008UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000008 */
#define ADC_OFR2_OFFSET_4              (0x0000010UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000010 */
#define ADC_OFR2_OFFSET_5              (0x0000020UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000020 */
#define ADC_OFR2_OFFSET_6              (0x0000040UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000040 */
#define ADC_OFR2_OFFSET_7              (0x0000080UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000080 */
#define ADC_OFR2_OFFSET_8              (0x0000100UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000100 */
#define ADC_OFR2_OFFSET_9              (0x0000200UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000200 */
#define ADC_OFR2_OFFSET_10             (0x0000400UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000400 */
#define ADC_OFR2_OFFSET_11             (0x0000800UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00000800 */
#define ADC_OFR2_OFFSET_12             (0x0001000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00001000 */
#define ADC_OFR2_OFFSET_13             (0x0002000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00002000 */
#define ADC_OFR2_OFFSET_14             (0x0004000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00004000 */
#define ADC_OFR2_OFFSET_15             (0x0008000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00008000 */
#define ADC_OFR2_OFFSET_16             (0x0010000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00010000 */
#define ADC_OFR2_OFFSET_17             (0x0020000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00020000 */
#define ADC_OFR2_OFFSET_18             (0x0040000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00040000 */
#define ADC_OFR2_OFFSET_19             (0x0080000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00080000 */
#define ADC_OFR2_OFFSET_20             (0x0100000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00100000 */
#define ADC_OFR2_OFFSET_21             (0x0200000UL << ADC_OFR2_OFFSET_Pos)    /*!< 0x00200000 */

/********************  Bit definition for ADC_OFR3 register  ******************/
#define ADC_OFR3_OFFSET_Pos            (0UL)
#define ADC_OFR3_OFFSET_Msk            (0x03FFFFFUL << ADC_OFR3_OFFSET_Pos)    /*!< 0x003FFFFF */
#define ADC_OFR3_OFFSET                ADC_OFR3_OFFSET_Msk                     /*!< ADC offset instance 3 offset level */
#define ADC_OFR3_OFFSET_0              (0x0000001UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000001 */
#define ADC_OFR3_OFFSET_1              (0x0000002UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000002 */
#define ADC_OFR3_OFFSET_2              (0x0000004UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000004 */
#define ADC_OFR3_OFFSET_3              (0x0000008UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000008 */
#define ADC_OFR3_OFFSET_4              (0x0000010UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000010 */
#define ADC_OFR3_OFFSET_5              (0x0000020UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000020 */
#define ADC_OFR3_OFFSET_6              (0x0000040UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000040 */
#define ADC_OFR3_OFFSET_7              (0x0000080UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000080 */
#define ADC_OFR3_OFFSET_8              (0x0000100UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000100 */
#define ADC_OFR3_OFFSET_9              (0x0000200UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000200 */
#define ADC_OFR3_OFFSET_10             (0x0000400UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000400 */
#define ADC_OFR3_OFFSET_11             (0x0000800UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00000800 */
#define ADC_OFR3_OFFSET_12             (0x0001000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00001000 */
#define ADC_OFR3_OFFSET_13             (0x0002000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00002000 */
#define ADC_OFR3_OFFSET_14             (0x0004000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00004000 */
#define ADC_OFR3_OFFSET_15             (0x0008000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00008000 */
#define ADC_OFR3_OFFSET_16             (0x0010000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00010000 */
#define ADC_OFR3_OFFSET_17             (0x0020000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00020000 */
#define ADC_OFR3_OFFSET_18             (0x0040000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00040000 */
#define ADC_OFR3_OFFSET_19             (0x0080000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00080000 */
#define ADC_OFR3_OFFSET_20             (0x0100000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00100000 */
#define ADC_OFR3_OFFSET_21             (0x0200000UL << ADC_OFR3_OFFSET_Pos)    /*!< 0x00200000 */

/********************  Bit definition for ADC_OFR4 register  ******************/
#define ADC_OFR4_OFFSET_Pos            (0UL)
#define ADC_OFR4_OFFSET_Msk            (0x03FFFFFUL << ADC_OFR4_OFFSET_Pos)    /*!< 0x003FFFFF */
#define ADC_OFR4_OFFSET                ADC_OFR4_OFFSET_Msk                     /*!< ADC offset instance 4 offset level */
#define ADC_OFR4_OFFSET_0              (0x0000001UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000001 */
#define ADC_OFR4_OFFSET_1              (0x0000002UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000002 */
#define ADC_OFR4_OFFSET_2              (0x0000004UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000004 */
#define ADC_OFR4_OFFSET_3              (0x0000008UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000008 */
#define ADC_OFR4_OFFSET_4              (0x0000010UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000010 */
#define ADC_OFR4_OFFSET_5              (0x0000020UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000020 */
#define ADC_OFR4_OFFSET_6              (0x0000040UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000040 */
#define ADC_OFR4_OFFSET_7              (0x0000080UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000080 */
#define ADC_OFR4_OFFSET_8              (0x0000100UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000100 */
#define ADC_OFR4_OFFSET_9              (0x0000200UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000200 */
#define ADC_OFR4_OFFSET_10             (0x0000400UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000400 */
#define ADC_OFR4_OFFSET_11             (0x0000800UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00000800 */
#define ADC_OFR4_OFFSET_12             (0x0001000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00001000 */
#define ADC_OFR4_OFFSET_13             (0x0002000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00002000 */
#define ADC_OFR4_OFFSET_14             (0x0004000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00004000 */
#define ADC_OFR4_OFFSET_15             (0x0008000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00008000 */
#define ADC_OFR4_OFFSET_16             (0x0010000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00010000 */
#define ADC_OFR4_OFFSET_17             (0x0020000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00020000 */
#define ADC_OFR4_OFFSET_18             (0x0040000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00040000 */
#define ADC_OFR4_OFFSET_19             (0x0080000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00080000 */
#define ADC_OFR4_OFFSET_20             (0x0100000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00100000 */
#define ADC_OFR4_OFFSET_21             (0x0200000UL << ADC_OFR4_OFFSET_Pos)    /*!< 0x00200000 */

/********************  Bit definition for ADC_GCOMP register  *****************/
#define ADC_GCOMP_GCOMPCOEFF_Pos       (0UL)
#define ADC_GCOMP_GCOMPCOEFF_Msk       (0x3FFFUL << ADC_GCOMP_GCOMPCOEFF_Pos)  /*!< 0x00003FFF */
#define ADC_GCOMP_GCOMPCOEFF           ADC_GCOMP_GCOMPCOEFF_Msk                /*!< Gain compensation coefficient */
#define ADC_GCOMP_GCOMP_Pos            (31UL)
#define ADC_GCOMP_GCOMP_Msk            (0x1UL << ADC_GCOMP_GCOMP_Pos)          /*!< 0x80000000 */
#define ADC_GCOMP_GCOMP                ADC_GCOMP_GCOMP_Msk                     /*!< Gain compensation mode */

/********************  Bit definition for ADC_JDR1 register  ******************/
#define ADC_JDR1_JDATA_Pos             (0UL)
#define ADC_JDR1_JDATA_Msk             (0xFFFFFFFFUL << ADC_JDR1_JDATA_Pos)    /*!< 0xFFFFFFFF */
#define ADC_JDR1_JDATA                 ADC_JDR1_JDATA_Msk                      /*!< ADC group injected sequencer rank 1 conversion data */
#define ADC_JDR1_JDATA_0               (0x00000001UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000001 */
#define ADC_JDR1_JDATA_1               (0x00000002UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000002 */
#define ADC_JDR1_JDATA_2               (0x00000004UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000004 */
#define ADC_JDR1_JDATA_3               (0x00000008UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000008 */
#define ADC_JDR1_JDATA_4               (0x00000010UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000010 */
#define ADC_JDR1_JDATA_5               (0x00000020UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000020 */
#define ADC_JDR1_JDATA_6               (0x00000040UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000040 */
#define ADC_JDR1_JDATA_7               (0x00000080UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000080 */
#define ADC_JDR1_JDATA_8               (0x00000100UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000100 */
#define ADC_JDR1_JDATA_9               (0x00000200UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000200 */
#define ADC_JDR1_JDATA_10              (0x00000400UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000400 */
#define ADC_JDR1_JDATA_11              (0x00000800UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00000800 */
#define ADC_JDR1_JDATA_12              (0x00001000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00001000 */
#define ADC_JDR1_JDATA_13              (0x00002000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00002000 */
#define ADC_JDR1_JDATA_14              (0x00004000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00004000 */
#define ADC_JDR1_JDATA_15              (0x00008000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00008000 */
#define ADC_JDR1_JDATA_16              (0x00010000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00010000 */
#define ADC_JDR1_JDATA_17              (0x00020000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00020000 */
#define ADC_JDR1_JDATA_18              (0x00040000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00040000 */
#define ADC_JDR1_JDATA_19              (0x00080000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00080000 */
#define ADC_JDR1_JDATA_20              (0x00100000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00100000 */
#define ADC_JDR1_JDATA_21              (0x00200000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00200000 */
#define ADC_JDR1_JDATA_22              (0x00400000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00400000 */
#define ADC_JDR1_JDATA_23              (0x00800000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x00800000 */
#define ADC_JDR1_JDATA_24              (0x01000000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x01000000 */
#define ADC_JDR1_JDATA_25              (0x02000000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x02000000 */
#define ADC_JDR1_JDATA_26              (0x04000000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x04000000 */
#define ADC_JDR1_JDATA_27              (0x08000000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x08000000 */
#define ADC_JDR1_JDATA_28              (0x10000000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x10000000 */
#define ADC_JDR1_JDATA_29              (0x20000000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x20000000 */
#define ADC_JDR1_JDATA_30              (0x40000000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x40000000 */
#define ADC_JDR1_JDATA_31              (0x80000000UL << ADC_JDR1_JDATA_Pos)    /*!< 0x80000000 */

/********************  Bit definition for ADC_JDR2 register  ********************/
#define ADC_JDR2_JDATA_Pos             (0UL)
#define ADC_JDR2_JDATA_Msk             (0xFFFFFFFFUL << ADC_JDR2_JDATA_Pos)    /*!< 0xFFFFFFFF */
#define ADC_JDR2_JDATA                 ADC_JDR2_JDATA_Msk                      /*!< ADC group injected sequencer rank 2 conversion data */
#define ADC_JDR2_JDATA_0               (0x00000001UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000001 */
#define ADC_JDR2_JDATA_1               (0x00000002UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000002 */
#define ADC_JDR2_JDATA_2               (0x00000004UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000004 */
#define ADC_JDR2_JDATA_3               (0x00000008UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000008 */
#define ADC_JDR2_JDATA_4               (0x00000010UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000010 */
#define ADC_JDR2_JDATA_5               (0x00000020UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000020 */
#define ADC_JDR2_JDATA_6               (0x00000040UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000040 */
#define ADC_JDR2_JDATA_7               (0x00000080UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000080 */
#define ADC_JDR2_JDATA_8               (0x00000100UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000100 */
#define ADC_JDR2_JDATA_9               (0x00000200UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000200 */
#define ADC_JDR2_JDATA_10              (0x00000400UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000400 */
#define ADC_JDR2_JDATA_11              (0x00000800UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00000800 */
#define ADC_JDR2_JDATA_12              (0x00001000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00001000 */
#define ADC_JDR2_JDATA_13              (0x00002000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00002000 */
#define ADC_JDR2_JDATA_14              (0x00004000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00004000 */
#define ADC_JDR2_JDATA_15              (0x00008000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00008000 */
#define ADC_JDR2_JDATA_16              (0x00010000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00010000 */
#define ADC_JDR2_JDATA_17              (0x00020000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00020000 */
#define ADC_JDR2_JDATA_18              (0x00040000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00040000 */
#define ADC_JDR2_JDATA_19              (0x00080000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00080000 */
#define ADC_JDR2_JDATA_20              (0x00100000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00100000 */
#define ADC_JDR2_JDATA_21              (0x00200000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00200000 */
#define ADC_JDR2_JDATA_22              (0x00400000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00400000 */
#define ADC_JDR2_JDATA_23              (0x00800000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x00800000 */
#define ADC_JDR2_JDATA_24              (0x01000000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x01000000 */
#define ADC_JDR2_JDATA_25              (0x02000000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x02000000 */
#define ADC_JDR2_JDATA_26              (0x04000000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x04000000 */
#define ADC_JDR2_JDATA_27              (0x08000000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x08000000 */
#define ADC_JDR2_JDATA_28              (0x10000000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x10000000 */
#define ADC_JDR2_JDATA_29              (0x20000000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x20000000 */
#define ADC_JDR2_JDATA_30              (0x40000000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x40000000 */
#define ADC_JDR2_JDATA_31              (0x80000000UL << ADC_JDR2_JDATA_Pos)    /*!< 0x80000000 */

/********************  Bit definition for ADC_JDR3 register  ********************/
#define ADC_JDR3_JDATA_Pos             (0UL)
#define ADC_JDR3_JDATA_Msk             (0xFFFFFFFFUL << ADC_JDR3_JDATA_Pos)    /*!< 0xFFFFFFFF */
#define ADC_JDR3_JDATA                 ADC_JDR3_JDATA_Msk                      /*!< ADC group injected sequencer rank 3 conversion data */
#define ADC_JDR3_JDATA_0               (0x00000001UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000001 */
#define ADC_JDR3_JDATA_1               (0x00000002UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000002 */
#define ADC_JDR3_JDATA_2               (0x00000004UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000004 */
#define ADC_JDR3_JDATA_3               (0x00000008UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000008 */
#define ADC_JDR3_JDATA_4               (0x00000010UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000010 */
#define ADC_JDR3_JDATA_5               (0x00000020UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000020 */
#define ADC_JDR3_JDATA_6               (0x00000040UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000040 */
#define ADC_JDR3_JDATA_7               (0x00000080UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000080 */
#define ADC_JDR3_JDATA_8               (0x00000100UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000100 */
#define ADC_JDR3_JDATA_9               (0x00000200UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000200 */
#define ADC_JDR3_JDATA_10              (0x00000400UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000400 */
#define ADC_JDR3_JDATA_11              (0x00000800UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00000800 */
#define ADC_JDR3_JDATA_12              (0x00001000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00001000 */
#define ADC_JDR3_JDATA_13              (0x00002000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00002000 */
#define ADC_JDR3_JDATA_14              (0x00004000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00004000 */
#define ADC_JDR3_JDATA_15              (0x00008000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00008000 */
#define ADC_JDR3_JDATA_16              (0x00010000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00010000 */
#define ADC_JDR3_JDATA_17              (0x00020000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00020000 */
#define ADC_JDR3_JDATA_18              (0x00040000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00040000 */
#define ADC_JDR3_JDATA_19              (0x00080000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00080000 */
#define ADC_JDR3_JDATA_20              (0x00100000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00100000 */
#define ADC_JDR3_JDATA_21              (0x00200000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00200000 */
#define ADC_JDR3_JDATA_22              (0x00400000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00400000 */
#define ADC_JDR3_JDATA_23              (0x00800000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x00800000 */
#define ADC_JDR3_JDATA_24              (0x01000000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x01000000 */
#define ADC_JDR3_JDATA_25              (0x02000000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x02000000 */
#define ADC_JDR3_JDATA_26              (0x04000000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x04000000 */
#define ADC_JDR3_JDATA_27              (0x08000000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x08000000 */
#define ADC_JDR3_JDATA_28              (0x10000000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x10000000 */
#define ADC_JDR3_JDATA_29              (0x20000000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x20000000 */
#define ADC_JDR3_JDATA_30              (0x40000000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x40000000 */
#define ADC_JDR3_JDATA_31              (0x80000000UL << ADC_JDR3_JDATA_Pos)    /*!< 0x80000000 */

/********************  Bit definition for ADC_JDR4 register  ********************/
#define ADC_JDR4_JDATA_Pos             (0UL)
#define ADC_JDR4_JDATA_Msk             (0xFFFFFFFFUL << ADC_JDR4_JDATA_Pos)    /*!< 0xFFFFFFFF */
#define ADC_JDR4_JDATA                 ADC_JDR4_JDATA_Msk                      /*!< ADC group injected sequencer rank 4 conversion data */
#define ADC_JDR4_JDATA_0               (0x00000001UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000001 */
#define ADC_JDR4_JDATA_1               (0x00000002UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000002 */
#define ADC_JDR4_JDATA_2               (0x00000004UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000004 */
#define ADC_JDR4_JDATA_3               (0x00000008UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000008 */
#define ADC_JDR4_JDATA_4               (0x00000010UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000010 */
#define ADC_JDR4_JDATA_5               (0x00000020UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000020 */
#define ADC_JDR4_JDATA_6               (0x00000040UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000040 */
#define ADC_JDR4_JDATA_7               (0x00000080UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000080 */
#define ADC_JDR4_JDATA_8               (0x00000100UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000100 */
#define ADC_JDR4_JDATA_9               (0x00000200UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000200 */
#define ADC_JDR4_JDATA_10              (0x00000400UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000400 */
#define ADC_JDR4_JDATA_11              (0x00000800UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00000800 */
#define ADC_JDR4_JDATA_12              (0x00001000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00001000 */
#define ADC_JDR4_JDATA_13              (0x00002000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00002000 */
#define ADC_JDR4_JDATA_14              (0x00004000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00004000 */
#define ADC_JDR4_JDATA_15              (0x00008000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00008000 */
#define ADC_JDR4_JDATA_16              (0x00010000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00010000 */
#define ADC_JDR4_JDATA_17              (0x00020000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00020000 */
#define ADC_JDR4_JDATA_18              (0x00040000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00040000 */
#define ADC_JDR4_JDATA_19              (0x00080000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00080000 */
#define ADC_JDR4_JDATA_20              (0x00100000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00100000 */
#define ADC_JDR4_JDATA_21              (0x00200000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00200000 */
#define ADC_JDR4_JDATA_22              (0x00400000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00400000 */
#define ADC_JDR4_JDATA_23              (0x00800000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x00800000 */
#define ADC_JDR4_JDATA_24              (0x01000000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x01000000 */
#define ADC_JDR4_JDATA_25              (0x02000000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x02000000 */
#define ADC_JDR4_JDATA_26              (0x04000000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x04000000 */
#define ADC_JDR4_JDATA_27              (0x08000000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x08000000 */
#define ADC_JDR4_JDATA_28              (0x10000000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x10000000 */
#define ADC_JDR4_JDATA_29              (0x20000000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x20000000 */
#define ADC_JDR4_JDATA_30              (0x40000000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x40000000 */
#define ADC_JDR4_JDATA_31              (0x80000000UL << ADC_JDR4_JDATA_Pos)    /*!< 0x80000000 */

/********************  Bit definition for ADC_AWD2CR register  ****************/
#define ADC_AWD2CR_AWD2CH_Pos          (0UL)
#define ADC_AWD2CR_AWD2CH_Msk          (0xFFFFFUL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x000FFFFF */
#define ADC_AWD2CR_AWD2CH              ADC_AWD2CR_AWD2CH_Msk                   /*!< ADC analog watchdog 2 monitored channel selection */
#define ADC_AWD2CR_AWD2CH_0            (0x00001UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000001 */
#define ADC_AWD2CR_AWD2CH_1            (0x00002UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000002 */
#define ADC_AWD2CR_AWD2CH_2            (0x00004UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000004 */
#define ADC_AWD2CR_AWD2CH_3            (0x00008UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000008 */
#define ADC_AWD2CR_AWD2CH_4            (0x00010UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000010 */
#define ADC_AWD2CR_AWD2CH_5            (0x00020UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000020 */
#define ADC_AWD2CR_AWD2CH_6            (0x00040UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000040 */
#define ADC_AWD2CR_AWD2CH_7            (0x00080UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000080 */
#define ADC_AWD2CR_AWD2CH_8            (0x00100UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000100 */
#define ADC_AWD2CR_AWD2CH_9            (0x00200UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000200 */
#define ADC_AWD2CR_AWD2CH_10           (0x00400UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000400 */
#define ADC_AWD2CR_AWD2CH_11           (0x00800UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00000800 */
#define ADC_AWD2CR_AWD2CH_12           (0x01000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00001000 */
#define ADC_AWD2CR_AWD2CH_13           (0x02000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00002000 */
#define ADC_AWD2CR_AWD2CH_14           (0x04000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00004000 */
#define ADC_AWD2CR_AWD2CH_15           (0x08000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00008000 */
#define ADC_AWD2CR_AWD2CH_16           (0x10000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00010000 */
#define ADC_AWD2CR_AWD2CH_17           (0x20000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00020000 */
#define ADC_AWD2CR_AWD2CH_18           (0x40000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00040000 */
#define ADC_AWD2CR_AWD2CH_19           (0x80000UL << ADC_AWD2CR_AWD2CH_Pos)    /*!< 0x00080000 */

/********************  Bit definition for ADC_AWD3CR register  ****************/
#define ADC_AWD3CR_AWD3CH_Pos          (0UL)
#define ADC_AWD3CR_AWD3CH_Msk          (0xFFFFFUL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x000FFFFF */
#define ADC_AWD3CR_AWD3CH              ADC_AWD3CR_AWD3CH_Msk                   /*!< ADC analog watchdog 3 monitored channel selection */
#define ADC_AWD3CR_AWD3CH_0            (0x00001UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000001 */
#define ADC_AWD3CR_AWD3CH_1            (0x00002UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000002 */
#define ADC_AWD3CR_AWD3CH_2            (0x00004UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000004 */
#define ADC_AWD3CR_AWD3CH_3            (0x00008UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000008 */
#define ADC_AWD3CR_AWD3CH_4            (0x00010UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000010 */
#define ADC_AWD3CR_AWD3CH_5            (0x00020UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000020 */
#define ADC_AWD3CR_AWD3CH_6            (0x00040UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000040 */
#define ADC_AWD3CR_AWD3CH_7            (0x00080UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000080 */
#define ADC_AWD3CR_AWD3CH_8            (0x00100UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000100 */
#define ADC_AWD3CR_AWD3CH_9            (0x00200UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000200 */
#define ADC_AWD3CR_AWD3CH_10           (0x00400UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000400 */
#define ADC_AWD3CR_AWD3CH_11           (0x00800UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00000800 */
#define ADC_AWD3CR_AWD3CH_12           (0x01000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00001000 */
#define ADC_AWD3CR_AWD3CH_13           (0x02000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00002000 */
#define ADC_AWD3CR_AWD3CH_14           (0x04000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00004000 */
#define ADC_AWD3CR_AWD3CH_15           (0x08000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00008000 */
#define ADC_AWD3CR_AWD3CH_16           (0x10000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00010000 */
#define ADC_AWD3CR_AWD3CH_17           (0x20000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00020000 */
#define ADC_AWD3CR_AWD3CH_18           (0x40000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00040000 */
#define ADC_AWD3CR_AWD3CH_19           (0x80000UL << ADC_AWD3CR_AWD3CH_Pos)    /*!< 0x00080000 */

/********************  Bit definition for ADC_AWD1TR_LT register  *************/
#define ADC_AWD1LTR_LTR_Pos            (0UL)
#define ADC_AWD1LTR_LTR_Msk            (0x007FFFFFUL << ADC_AWD1LTR_LTR_Pos)  /*!< 0x007FFFFF */
#define ADC_AWD1LTR_LTR                ADC_AWD1LTR_LTR_Msk                    /*!< ADC analog watchdog 1 threshold low */
#define ADC_AWD1LTR_LTR_0              (0x000001UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00000001 */
#define ADC_AWD1LTR_LTR_1              (0x000002UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00000002 */
#define ADC_AWD1LTR_LTR_2              (0x000004UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00000004 */
#define ADC_AWD1LTR_LTR_3              (0x000008UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00000008 */
#define ADC_AWD1LTR_LTR_4              (0x000010UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00000010 */
#define ADC_AWD1LTR_LTR_5              (0x000020UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00000020 */
#define ADC_AWD1LTR_LTR_6              (0x000040UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00000040 */
#define ADC_AWD1LTR_LTR_7              (0x000080UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00000080 */
#define ADC_AWD1LTR_LTR_8              (0x000100UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00000100 */
#define ADC_AWD1LTR_LTR_9              (0x000200UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00000200 */
#define ADC_AWD1LTR_LTR_10             (0x000400UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00000400 */
#define ADC_AWD1LTR_LTR_11             (0x000800UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00000800 */
#define ADC_AWD1LTR_LTR_12             (0x001000UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00001000 */
#define ADC_AWD1LTR_LTR_13             (0x002000UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00002000 */
#define ADC_AWD1LTR_LTR_14             (0x004000UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00004000 */
#define ADC_AWD1LTR_LTR_15             (0x008000UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00008000 */
#define ADC_AWD1LTR_LTR_16             (0x010000UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00010000 */
#define ADC_AWD1LTR_LTR_17             (0x020000UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00020000 */
#define ADC_AWD1LTR_LTR_18             (0x040000UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00040000 */
#define ADC_AWD1LTR_LTR_19             (0x080000UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00080000 */
#define ADC_AWD1LTR_LTR_20             (0x100000UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00100000 */
#define ADC_AWD1LTR_LTR_21             (0x200000UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00200000 */
#define ADC_AWD1LTR_LTR_22             (0x400000UL << ADC_AWD1LTR_LTR_Pos)    /*!< 0x00400000 */

/********************  Bit definition for ADC_AWD1TR_HT register  *******************/
#define ADC_AWD1HTR_HTR_Pos            (0UL)
#define ADC_AWD1HTR_HTR_Msk            (0x007FFFFFUL << ADC_AWD1HTR_HTR_Pos)  /*!< 0x007FFFFF */
#define ADC_AWD1HTR_HTR                ADC_AWD1HTR_HTR_Msk                    /*!< ADC analog watchdog 1 threshold high */
#define ADC_AWD1HTR_HTR_0              (0x000001UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00000001 */
#define ADC_AWD1HTR_HTR_1              (0x000002UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00000002 */
#define ADC_AWD1HTR_HTR_2              (0x000004UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00000004 */
#define ADC_AWD1HTR_HTR_3              (0x000008UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00000008 */
#define ADC_AWD1HTR_HTR_4              (0x000010UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00000010 */
#define ADC_AWD1HTR_HTR_5              (0x000020UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00000020 */
#define ADC_AWD1HTR_HTR_6              (0x000040UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00000040 */
#define ADC_AWD1HTR_HTR_7              (0x000080UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00000080 */
#define ADC_AWD1HTR_HTR_8              (0x000100UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00000100 */
#define ADC_AWD1HTR_HTR_9              (0x000200UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00000200 */
#define ADC_AWD1HTR_HTR_10             (0x000400UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00000400 */
#define ADC_AWD1HTR_HTR_11             (0x000800UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00000800 */
#define ADC_AWD1HTR_HTR_12             (0x001000UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00001000 */
#define ADC_AWD1HTR_HTR_13             (0x002000UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00002000 */
#define ADC_AWD1HTR_HTR_14             (0x004000UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00004000 */
#define ADC_AWD1HTR_HTR_15             (0x008000UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00008000 */
#define ADC_AWD1HTR_HTR_16             (0x010000UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00010000 */
#define ADC_AWD1HTR_HTR_17             (0x020000UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00020000 */
#define ADC_AWD1HTR_HTR_18             (0x040000UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00040000 */
#define ADC_AWD1HTR_HTR_19             (0x080000UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00080000 */
#define ADC_AWD1HTR_HTR_20             (0x100000UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00100000 */
#define ADC_AWD1HTR_HTR_21             (0x200000UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00200000 */
#define ADC_AWD1HTR_HTR_22             (0x400000UL << ADC_AWD1HTR_HTR_Pos)    /*!< 0x00400000 */

#define ADC_AWD1HTR_AWDFILT_Pos         (29UL)
#define ADC_AWD1HTR_AWDFILT_Msk         (0x7UL << ADC_AWD1HTR_AWDFILT_Pos)      /*!< 0x00000007 */
#define ADC_AWD1HTR_AWDFILT             ADC_AWD1HTR_AWDFILT_Msk                 /*!< ADC analog watchdog 1 filtering */
#define ADC_AWD1HTR_AWDFILT_0           (0x000001UL << ADC_AWD1HTR_AWDFILT_Pos) /*!< 0x00000001 */
#define ADC_AWD1HTR_AWDFILT_1           (0x000002UL << ADC_AWD1HTR_AWDFILT_Pos) /*!< 0x00000002 */
#define ADC_AWD1HTR_AWDFILT_2           (0x000004UL << ADC_AWD1HTR_AWDFILT_Pos) /*!< 0x00000004 */

/********************  Bit definition for ADC_AWD2TR_LT register  *******************/
#define ADC_AWD2LTR_LTR_Pos            (0UL)
#define ADC_AWD2LTR_LTR_Msk            (0x007FFFFFUL << ADC_AWD2LTR_LTR_Pos)  /*!< 0x007FFFFF */
#define ADC_AWD2LTR_LTR                ADC_AWD2LTR_LTR_Msk                    /*!< ADC analog watchdog 2 threshold low */
#define ADC_AWD2LTR_LTR_0              (0x000001UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00000001 */
#define ADC_AWD2LTR_LTR_1              (0x000002UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00000002 */
#define ADC_AWD2LTR_LTR_2              (0x000004UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00000004 */
#define ADC_AWD2LTR_LTR_3              (0x000008UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00000008 */
#define ADC_AWD2LTR_LTR_4              (0x000010UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00000010 */
#define ADC_AWD2LTR_LTR_5              (0x000020UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00000020 */
#define ADC_AWD2LTR_LTR_6              (0x000040UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00000040 */
#define ADC_AWD2LTR_LTR_7              (0x000080UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00000080 */
#define ADC_AWD2LTR_LTR_8              (0x000100UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00000100 */
#define ADC_AWD2LTR_LTR_9              (0x000200UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00000200 */
#define ADC_AWD2LTR_LTR_10             (0x000400UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00000400 */
#define ADC_AWD2LTR_LTR_11             (0x000800UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00000800 */
#define ADC_AWD2LTR_LTR_12             (0x001000UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00001000 */
#define ADC_AWD2LTR_LTR_13             (0x002000UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00002000 */
#define ADC_AWD2LTR_LTR_14             (0x004000UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00004000 */
#define ADC_AWD2LTR_LTR_15             (0x008000UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00008000 */
#define ADC_AWD2LTR_LTR_16             (0x010000UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00010000 */
#define ADC_AWD2LTR_LTR_17             (0x020000UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00020000 */
#define ADC_AWD2LTR_LTR_18             (0x040000UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00040000 */
#define ADC_AWD2LTR_LTR_19             (0x080000UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00080000 */
#define ADC_AWD2LTR_LTR_20             (0x100000UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00100000 */
#define ADC_AWD2LTR_LTR_21             (0x200000UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00200000 */
#define ADC_AWD2LTR_LTR_22             (0x400000UL << ADC_AWD2LTR_LTR_Pos)    /*!< 0x00400000 */

/********************  Bit definition for ADC_AWD2TR_HT register  *******************/
#define ADC_AWD2HTR_HTR_Pos            (0UL)
#define ADC_AWD2HTR_HTR_Msk            (0x007FFFFFUL << ADC_AWD2HTR_HTR_Pos)  /*!< 0x007FFFFF */
#define ADC_AWD2HTR_HTR                ADC_AWD2HTR_HTR_Msk                    /*!< ADC analog watchdog 2 threshold high */
#define ADC_AWD2HTR_HTR_0              (0x000001UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00000001 */
#define ADC_AWD2HTR_HTR_1              (0x000002UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00000002 */
#define ADC_AWD2HTR_HTR_2              (0x000004UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00000004 */
#define ADC_AWD2HTR_HTR_3              (0x000008UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00000008 */
#define ADC_AWD2HTR_HTR_4              (0x000010UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00000010 */
#define ADC_AWD2HTR_HTR_5              (0x000020UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00000020 */
#define ADC_AWD2HTR_HTR_6              (0x000040UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00000040 */
#define ADC_AWD2HTR_HTR_7              (0x000080UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00000080 */
#define ADC_AWD2HTR_HTR_8              (0x000100UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00000100 */
#define ADC_AWD2HTR_HTR_9              (0x000200UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00000200 */
#define ADC_AWD2HTR_HTR_10             (0x000400UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00000400 */
#define ADC_AWD2HTR_HTR_11             (0x000800UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00000800 */
#define ADC_AWD2HTR_HTR_12             (0x001000UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00001000 */
#define ADC_AWD2HTR_HTR_13             (0x002000UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00002000 */
#define ADC_AWD2HTR_HTR_14             (0x004000UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00004000 */
#define ADC_AWD2HTR_HTR_15             (0x008000UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00008000 */
#define ADC_AWD2HTR_HTR_16             (0x010000UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00010000 */
#define ADC_AWD2HTR_HTR_17             (0x020000UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00020000 */
#define ADC_AWD2HTR_HTR_18             (0x040000UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00040000 */
#define ADC_AWD2HTR_HTR_19             (0x080000UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00080000 */
#define ADC_AWD2HTR_HTR_20             (0x100000UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00100000 */
#define ADC_AWD2HTR_HTR_21             (0x200000UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00200000 */
#define ADC_AWD2HTR_HTR_22             (0x400000UL << ADC_AWD2HTR_HTR_Pos)    /*!< 0x00400000 */

/********************  Bit definition for ADC_AWD3TR_LT register  *******************/
#define ADC_AWD3LTR_LTR_Pos            (0UL)
#define ADC_AWD3LTR_LTR_Msk            (0x007FFFFFUL << ADC_AWD3LTR_LTR_Pos)  /*!< 0x007FFFFF */
#define ADC_AWD3LTR_LTR                ADC_AWD3LTR_LTR_Msk                    /*!< ADC analog watchdog 3 threshold low */
#define ADC_AWD3LTR_LTR_0              (0x000001UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00000001 */
#define ADC_AWD3LTR_LTR_1              (0x000002UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00000002 */
#define ADC_AWD3LTR_LTR_2              (0x000004UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00000004 */
#define ADC_AWD3LTR_LTR_3              (0x000008UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00000008 */
#define ADC_AWD3LTR_LTR_4              (0x000010UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00000010 */
#define ADC_AWD3LTR_LTR_5              (0x000020UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00000020 */
#define ADC_AWD3LTR_LTR_6              (0x000040UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00000040 */
#define ADC_AWD3LTR_LTR_7              (0x000080UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00000080 */
#define ADC_AWD3LTR_LTR_8              (0x000100UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00000100 */
#define ADC_AWD3LTR_LTR_9              (0x000200UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00000200 */
#define ADC_AWD3LTR_LTR_10             (0x000400UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00000400 */
#define ADC_AWD3LTR_LTR_11             (0x000800UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00000800 */
#define ADC_AWD3LTR_LTR_12             (0x001000UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00001000 */
#define ADC_AWD3LTR_LTR_13             (0x002000UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00002000 */
#define ADC_AWD3LTR_LTR_14             (0x004000UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00004000 */
#define ADC_AWD3LTR_LTR_15             (0x008000UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00008000 */
#define ADC_AWD3LTR_LTR_16             (0x010000UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00010000 */
#define ADC_AWD3LTR_LTR_17             (0x020000UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00020000 */
#define ADC_AWD3LTR_LTR_18             (0x040000UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00040000 */
#define ADC_AWD3LTR_LTR_19             (0x080000UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00080000 */
#define ADC_AWD3LTR_LTR_20             (0x100000UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00100000 */
#define ADC_AWD3LTR_LTR_21             (0x200000UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00200000 */
#define ADC_AWD3LTR_LTR_22             (0x400000UL << ADC_AWD3LTR_LTR_Pos)    /*!< 0x00400000 */

/********************  Bit definition for ADC_AWD3TR_HT register  *******************/
#define ADC_AWD3HTR_HTR_Pos            (0UL)
#define ADC_AWD3HTR_HTR_Msk            (0x007FFFFFUL << ADC_AWD3HTR_HTR_Pos)  /*!< 0x007FFFFF */
#define ADC_AWD3HTR_HTR                ADC_AWD3HTR_HTR_Msk                    /*!< ADC analog watchdog 3 threshold high */
#define ADC_AWD3HTR_HTR_0              (0x000001UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00000001 */
#define ADC_AWD3HTR_HTR_1              (0x000002UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00000002 */
#define ADC_AWD3HTR_HTR_2              (0x000004UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00000004 */
#define ADC_AWD3HTR_HTR_3              (0x000008UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00000008 */
#define ADC_AWD3HTR_HTR_4              (0x000010UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00000010 */
#define ADC_AWD3HTR_HTR_5              (0x000020UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00000020 */
#define ADC_AWD3HTR_HTR_6              (0x000040UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00000040 */
#define ADC_AWD3HTR_HTR_7              (0x000080UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00000080 */
#define ADC_AWD3HTR_HTR_8              (0x000100UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00000100 */
#define ADC_AWD3HTR_HTR_9              (0x000200UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00000200 */
#define ADC_AWD3HTR_HTR_10             (0x000400UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00000400 */
#define ADC_AWD3HTR_HTR_11             (0x000800UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00000800 */
#define ADC_AWD3HTR_HTR_12             (0x001000UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00001000 */
#define ADC_AWD3HTR_HTR_13             (0x002000UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00002000 */
#define ADC_AWD3HTR_HTR_14             (0x004000UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00004000 */
#define ADC_AWD3HTR_HTR_15             (0x008000UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00008000 */
#define ADC_AWD3HTR_HTR_16             (0x010000UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00010000 */
#define ADC_AWD3HTR_HTR_17             (0x020000UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00020000 */
#define ADC_AWD3HTR_HTR_18             (0x040000UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00040000 */
#define ADC_AWD3HTR_HTR_19             (0x080000UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00080000 */
#define ADC_AWD3HTR_HTR_20             (0x100000UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00100000 */
#define ADC_AWD3HTR_HTR_21             (0x200000UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00200000 */
#define ADC_AWD3HTR_HTR_22             (0x400000UL << ADC_AWD3HTR_HTR_Pos)    /*!< 0x00400000 */

/********************  Bit definition for ADC_DIFSEL register  ****************/
#define ADC_DIFSEL_DIFSEL_Pos          (0UL)
#define ADC_DIFSEL_DIFSEL_Msk          (0xFFFFFUL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x000FFFFF */
#define ADC_DIFSEL_DIFSEL              ADC_DIFSEL_DIFSEL_Msk                   /*!< ADC channel differential or single-ended mode selection */
#define ADC_DIFSEL_DIFSEL_0            (0x00001UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000001 */
#define ADC_DIFSEL_DIFSEL_1            (0x00002UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000002 */
#define ADC_DIFSEL_DIFSEL_2            (0x00004UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000004 */
#define ADC_DIFSEL_DIFSEL_3            (0x00008UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000008 */
#define ADC_DIFSEL_DIFSEL_4            (0x00010UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000010 */
#define ADC_DIFSEL_DIFSEL_5            (0x00020UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000020 */
#define ADC_DIFSEL_DIFSEL_6            (0x00040UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000040 */
#define ADC_DIFSEL_DIFSEL_7            (0x00080UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000080 */
#define ADC_DIFSEL_DIFSEL_8            (0x00100UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000100 */
#define ADC_DIFSEL_DIFSEL_9            (0x00200UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000200 */
#define ADC_DIFSEL_DIFSEL_10           (0x00400UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000400 */
#define ADC_DIFSEL_DIFSEL_11           (0x00800UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00000800 */
#define ADC_DIFSEL_DIFSEL_12           (0x01000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00001000 */
#define ADC_DIFSEL_DIFSEL_13           (0x02000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00002000 */
#define ADC_DIFSEL_DIFSEL_14           (0x04000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00004000 */
#define ADC_DIFSEL_DIFSEL_15           (0x08000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00008000 */
#define ADC_DIFSEL_DIFSEL_16           (0x10000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00010000 */
#define ADC_DIFSEL_DIFSEL_17           (0x20000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00020000 */
#define ADC_DIFSEL_DIFSEL_18           (0x40000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00040000 */
#define ADC_DIFSEL_DIFSEL_19           (0x80000UL << ADC_DIFSEL_DIFSEL_Pos)    /*!< 0x00080000 */

/********************  Bit definition for ADC_CALFACT register  ***************/
#define ADC_CALFACT_CALFACT_S_Pos      (0UL)
#define ADC_CALFACT_CALFACT_S_Msk      (0x3FFUL << ADC_CALFACT_CALFACT_S_Pos)  /*!< 0x000003FF */
#define ADC_CALFACT_CALFACT_S          ADC_CALFACT_CALFACT_S_Msk               /*!< ADC calibration factor in single-ended mode */
#define ADC_CALFACT_CALFACT_S_0        (0x01UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000001 */
#define ADC_CALFACT_CALFACT_S_1        (0x02UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000002 */
#define ADC_CALFACT_CALFACT_S_2        (0x04UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000004 */
#define ADC_CALFACT_CALFACT_S_3        (0x08UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000008 */
#define ADC_CALFACT_CALFACT_S_4        (0x10UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000010 */
#define ADC_CALFACT_CALFACT_S_5        (0x20UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000020 */
#define ADC_CALFACT_CALFACT_S_6        (0x40UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000040 */
#define ADC_CALFACT_CALFACT_S_7        (0x80UL << ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000080 */
#define ADC_CALFACT_CALFACT_S_8        (0x100UL<< ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000100 */
#define ADC_CALFACT_CALFACT_S_9        (0x200UL<< ADC_CALFACT_CALFACT_S_Pos)   /*!< 0x00000200 */

#define ADC_CALFACT_CALFACT_D_Pos      (16UL)
#define ADC_CALFACT_CALFACT_D_Msk      (0x3FFUL << ADC_CALFACT_CALFACT_D_Pos)  /*!< 0x03FF0000 */
#define ADC_CALFACT_CALFACT_D          ADC_CALFACT_CALFACT_D_Msk               /*!< ADC calibration factor in differential mode */
#define ADC_CALFACT_CALFACT_D_0        (0x01UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00010000 */
#define ADC_CALFACT_CALFACT_D_1        (0x02UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00020000 */
#define ADC_CALFACT_CALFACT_D_2        (0x04UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00040000 */
#define ADC_CALFACT_CALFACT_D_3        (0x08UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00080000 */
#define ADC_CALFACT_CALFACT_D_4        (0x10UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00100000 */
#define ADC_CALFACT_CALFACT_D_5        (0x20UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00200000 */
#define ADC_CALFACT_CALFACT_D_6        (0x40UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00400000 */
#define ADC_CALFACT_CALFACT_D_7        (0x80UL << ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x00800000 */
#define ADC_CALFACT_CALFACT_D_8        (0x100UL<< ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x01000000 */
#define ADC_CALFACT_CALFACT_D_9        (0x200UL<< ADC_CALFACT_CALFACT_D_Pos)   /*!< 0x02000000 */

#define ADC_CALFACT_CALADDOS_Pos       (31UL)
#define ADC_CALFACT_CALADDOS_Msk       (0x01UL << ADC_CALFACT_CALADDOS_Pos)    /*!< 0x80000000 */
#define ADC_CALFACT_CALADDOS           ADC_CALFACT_CALADDOS_Msk                /*!< ADC calibration additional offset mode */

/********************  Bit definition for ADC_OR option register  ***************/
#define ADC_OR_OP0_Pos                 (0UL)
#define ADC_OR_OP0_Msk                 (0x1UL << ADC_OR_OP0_Pos)               /*!< 0x00000001 */
#define ADC_OR_OP0                     ADC_OR_OP0_Msk                          /*!< ADC internal reference voltage buffer */

#define ADC_OR_OP1_Pos                 (1UL)
#define ADC_OR_OP1_Msk                 (0x1UL << ADC_OR_OP1_Pos)               /*!< 0x00000002 */
#define ADC_OR_OP1                     ADC_OR_OP1_Msk                          /*!< ADC internal bandgap */

#define ADC_OR_OP2_Pos                 (2UL)
#define ADC_OR_OP2_Msk                 (0x1UL << ADC_OR_OP2_Pos)               /*!< 0x00000004 */
#define ADC_OR_OP2                     ADC_OR_OP2_Msk                          /*!< ADC internal path to VDDCORE */


/*************************  ADC Common registers  *****************************/
/********************  Bit definition for ADC_CSR register  *******************/
#define ADC_CSR_ADRDY_MST_Pos          (0UL)
#define ADC_CSR_ADRDY_MST_Msk          (0x1UL << ADC_CSR_ADRDY_MST_Pos)        /*!< 0x00000001 */
#define ADC_CSR_ADRDY_MST              ADC_CSR_ADRDY_MST_Msk                   /*!< ADC multimode master ready flag */
#define ADC_CSR_EOSMP_MST_Pos          (1UL)
#define ADC_CSR_EOSMP_MST_Msk          (0x1UL << ADC_CSR_EOSMP_MST_Pos)        /*!< 0x00000002 */
#define ADC_CSR_EOSMP_MST              ADC_CSR_EOSMP_MST_Msk                   /*!< ADC multimode master group regular end of sampling flag */
#define ADC_CSR_EOC_MST_Pos            (2UL)
#define ADC_CSR_EOC_MST_Msk            (0x1UL << ADC_CSR_EOC_MST_Pos)          /*!< 0x00000004 */
#define ADC_CSR_EOC_MST                ADC_CSR_EOC_MST_Msk                     /*!< ADC multimode master group regular end of unitary conversion flag */
#define ADC_CSR_EOS_MST_Pos            (3UL)
#define ADC_CSR_EOS_MST_Msk            (0x1UL << ADC_CSR_EOS_MST_Pos)          /*!< 0x00000008 */
#define ADC_CSR_EOS_MST                ADC_CSR_EOS_MST_Msk                     /*!< ADC multimode master group regular end of sequence conversions flag */
#define ADC_CSR_OVR_MST_Pos            (4UL)
#define ADC_CSR_OVR_MST_Msk            (0x1UL << ADC_CSR_OVR_MST_Pos)          /*!< 0x00000010 */
#define ADC_CSR_OVR_MST                ADC_CSR_OVR_MST_Msk                     /*!< ADC multimode master group regular overrun flag */
#define ADC_CSR_JEOC_MST_Pos           (5UL)
#define ADC_CSR_JEOC_MST_Msk           (0x1UL << ADC_CSR_JEOC_MST_Pos)         /*!< 0x00000020 */
#define ADC_CSR_JEOC_MST               ADC_CSR_JEOC_MST_Msk                    /*!< ADC multimode master group injected end of unitary conversion flag */
#define ADC_CSR_JEOS_MST_Pos           (6UL)
#define ADC_CSR_JEOS_MST_Msk           (0x1UL << ADC_CSR_JEOS_MST_Pos)         /*!< 0x00000040 */
#define ADC_CSR_JEOS_MST               ADC_CSR_JEOS_MST_Msk                    /*!< ADC multimode master group injected end of sequence conversions flag */
#define ADC_CSR_AWD1_MST_Pos           (7UL)
#define ADC_CSR_AWD1_MST_Msk           (0x1UL << ADC_CSR_AWD1_MST_Pos)         /*!< 0x00000080 */
#define ADC_CSR_AWD1_MST               ADC_CSR_AWD1_MST_Msk                    /*!< ADC multimode master analog watchdog 1 flag */
#define ADC_CSR_AWD2_MST_Pos           (8UL)
#define ADC_CSR_AWD2_MST_Msk           (0x1UL << ADC_CSR_AWD2_MST_Pos)         /*!< 0x00000100 */
#define ADC_CSR_AWD2_MST               ADC_CSR_AWD2_MST_Msk                    /*!< ADC multimode master analog watchdog 2 flag */
#define ADC_CSR_AWD3_MST_Pos           (9UL)
#define ADC_CSR_AWD3_MST_Msk           (0x1UL << ADC_CSR_AWD3_MST_Pos)         /*!< 0x00000200 */
#define ADC_CSR_AWD3_MST               ADC_CSR_AWD3_MST_Msk                    /*!< ADC multimode master analog watchdog 3 flag */

#define ADC_CSR_ADRDY_SLV_Pos          (16UL)
#define ADC_CSR_ADRDY_SLV_Msk          (0x1UL << ADC_CSR_ADRDY_SLV_Pos)        /*!< 0x00010000 */
#define ADC_CSR_ADRDY_SLV              ADC_CSR_ADRDY_SLV_Msk                   /*!< ADC multimode slave ready flag */
#define ADC_CSR_EOSMP_SLV_Pos          (17UL)
#define ADC_CSR_EOSMP_SLV_Msk          (0x1UL << ADC_CSR_EOSMP_SLV_Pos)        /*!< 0x00020000 */
#define ADC_CSR_EOSMP_SLV              ADC_CSR_EOSMP_SLV_Msk                   /*!< ADC multimode slave group regular end of sampling flag */
#define ADC_CSR_EOC_SLV_Pos            (18UL)
#define ADC_CSR_EOC_SLV_Msk            (0x1UL << ADC_CSR_EOC_SLV_Pos)          /*!< 0x00040000 */
#define ADC_CSR_EOC_SLV                ADC_CSR_EOC_SLV_Msk                     /*!< ADC multimode slave group regular end of unitary conversion flag */
#define ADC_CSR_EOS_SLV_Pos            (19UL)
#define ADC_CSR_EOS_SLV_Msk            (0x1UL << ADC_CSR_EOS_SLV_Pos)          /*!< 0x00080000 */
#define ADC_CSR_EOS_SLV                ADC_CSR_EOS_SLV_Msk                     /*!< ADC multimode slave group regular end of sequence conversions flag */
#define ADC_CSR_OVR_SLV_Pos            (20UL)
#define ADC_CSR_OVR_SLV_Msk            (0x1UL << ADC_CSR_OVR_SLV_Pos)          /*!< 0x00100000 */
#define ADC_CSR_OVR_SLV                ADC_CSR_OVR_SLV_Msk                     /*!< ADC multimode slave group regular overrun flag */
#define ADC_CSR_JEOC_SLV_Pos           (21UL)
#define ADC_CSR_JEOC_SLV_Msk           (0x1UL << ADC_CSR_JEOC_SLV_Pos)         /*!< 0x00200000 */
#define ADC_CSR_JEOC_SLV               ADC_CSR_JEOC_SLV_Msk                    /*!< ADC multimode slave group injected end of unitary conversion flag */
#define ADC_CSR_JEOS_SLV_Pos           (22UL)
#define ADC_CSR_JEOS_SLV_Msk           (0x1UL << ADC_CSR_JEOS_SLV_Pos)         /*!< 0x00400000 */
#define ADC_CSR_JEOS_SLV               ADC_CSR_JEOS_SLV_Msk                    /*!< ADC multimode slave group injected end of sequence conversions flag */
#define ADC_CSR_AWD1_SLV_Pos           (23UL)
#define ADC_CSR_AWD1_SLV_Msk           (0x1UL << ADC_CSR_AWD1_SLV_Pos)         /*!< 0x00800000 */
#define ADC_CSR_AWD1_SLV               ADC_CSR_AWD1_SLV_Msk                    /*!< ADC multimode slave analog watchdog 1 flag */
#define ADC_CSR_AWD2_SLV_Pos           (24UL)
#define ADC_CSR_AWD2_SLV_Msk           (0x1UL << ADC_CSR_AWD2_SLV_Pos)         /*!< 0x01000000 */
#define ADC_CSR_AWD2_SLV               ADC_CSR_AWD2_SLV_Msk                    /*!< ADC multimode slave analog watchdog 2 flag */
#define ADC_CSR_AWD3_SLV_Pos           (25UL)
#define ADC_CSR_AWD3_SLV_Msk           (0x1UL << ADC_CSR_AWD3_SLV_Pos)         /*!< 0x02000000 */
#define ADC_CSR_AWD3_SLV               ADC_CSR_AWD3_SLV_Msk                    /*!< ADC multimode slave analog watchdog 3 flag */

/********************  Bit definition for ADC_CCR register  *******************/
#define ADC_CCR_DUAL_Pos               (0UL)
#define ADC_CCR_DUAL_Msk               (0x1FUL << ADC_CCR_DUAL_Pos)            /*!< 0x0000001F */
#define ADC_CCR_DUAL                   ADC_CCR_DUAL_Msk                        /*!< ADC multimode mode selection */
#define ADC_CCR_DUAL_0                 (0x01UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000001 */
#define ADC_CCR_DUAL_1                 (0x02UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000002 */
#define ADC_CCR_DUAL_2                 (0x04UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000004 */
#define ADC_CCR_DUAL_3                 (0x08UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000008 */
#define ADC_CCR_DUAL_4                 (0x10UL << ADC_CCR_DUAL_Pos)            /*!< 0x00000010 */

#define ADC_CCR_DELAY_Pos              (8UL)
#define ADC_CCR_DELAY_Msk              (0xFUL << ADC_CCR_DELAY_Pos)            /*!< 0x00000F00 */
#define ADC_CCR_DELAY                  ADC_CCR_DELAY_Msk                       /*!< ADC multimode delay between 2 sampling phases */
#define ADC_CCR_DELAY_0                (0x1UL << ADC_CCR_DELAY_Pos)            /*!< 0x00000100 */
#define ADC_CCR_DELAY_1                (0x2UL << ADC_CCR_DELAY_Pos)            /*!< 0x00000200 */
#define ADC_CCR_DELAY_2                (0x4UL << ADC_CCR_DELAY_Pos)            /*!< 0x00000400 */
#define ADC_CCR_DELAY_3                (0x8UL << ADC_CCR_DELAY_Pos)            /*!< 0x00000800 */

#define ADC_CCR_DAMDF_Pos              (14UL)
#define ADC_CCR_DAMDF_Msk              (0x3UL << ADC_CCR_DAMDF_Pos)            /*!< 0x0000C000 */
#define ADC_CCR_DAMDF                  ADC_CCR_DAMDF_Msk                       /*!< ADC multimode data format */
#define ADC_CCR_DAMDF_0                (0x1UL << ADC_CCR_DAMDF_Pos)            /*!< 0x00004000 */
#define ADC_CCR_DAMDF_1                (0x2UL << ADC_CCR_DAMDF_Pos)            /*!< 0x00008000 */

#define ADC_CCR_VREFEN_Pos             (22UL)
#define ADC_CCR_VREFEN_Msk             (0x1UL << ADC_CCR_VREFEN_Pos)           /*!< 0x00400000 */
#define ADC_CCR_VREFEN                 ADC_CCR_VREFEN_Msk                      /*!< ADC internal path to VrefInt enable */

#define ADC_CCR_VBATEN_Pos             (24UL)
#define ADC_CCR_VBATEN_Msk             (0x1UL << ADC_CCR_VBATEN_Pos)           /*!< 0x01000000 */
#define ADC_CCR_VBATEN                 ADC_CCR_VBATEN_Msk                      /*!< ADC internal path to battery voltage enable */

/********************  Bit definition for ADC_CDR register  *******************/
#define ADC_CDR_RDATA_MST_Pos          (0UL)
#define ADC_CDR_RDATA_MST_Msk          (0xFFFFUL << ADC_CDR_RDATA_MST_Pos)     /*!< 0x0000FFFF */
#define ADC_CDR_RDATA_MST              ADC_CDR_RDATA_MST_Msk                   /*!< ADC multimode master group regular conversion data */

#define ADC_CDR_RDATA_SLV_Pos          (16UL)
#define ADC_CDR_RDATA_SLV_Msk          (0xFFFFUL << ADC_CDR_RDATA_SLV_Pos)     /*!< 0xFFFF0000 */
#define ADC_CDR_RDATA_SLV              ADC_CDR_RDATA_SLV_Msk                   /*!< ADC multimode slave group regular conversion data */

/********************  Bit definition for ADC_CDR2 register  ******************/
#define ADC_CDR2_RDATA_ALT_Pos         (0UL)
#define ADC_CDR2_RDATA_ALT_Msk         (0xFFFFFFFFUL << ADC_CDR2_RDATA_ALT_Pos) /*!< 0xFFFFFFFF */
#define ADC_CDR2_RDATA_ALT             ADC_CDR2_RDATA_ALT_Msk                   /*!< ADC multimode master or slave (alternated) group regular conversion data */


/******************************************************************************/
/*                                                                            */
/*                       BSEC unit (Boot and Security)                        */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for BSEC_FVRw register  *******************/
#define BSEC_FVRw_FV_Pos               (0UL)
#define BSEC_FVRw_FV_Msk               (0xFFFFFFFFUL << BSEC_FVRw_FV_Pos)           /*!< 0xFFFFFFFF */
#define BSEC_FVRw_FV                   BSEC_FVRw_FV_Msk                            /*!< Fuse value */

/*****************  Bit definition for BSEC_SPLOCKx register  *****************/
#define BSEC_SPLOCKx_SPLOCK0_Pos       (0UL)
#define BSEC_SPLOCKx_SPLOCK0_Msk       (0x1UL << BSEC_SPLOCKx_SPLOCK0_Pos)          /*!< 0x00000001 */
#define BSEC_SPLOCKx_SPLOCK0           BSEC_SPLOCKx_SPLOCK0_Msk                    /*!< Sticky programming lock for word (32*x) */
#define BSEC_SPLOCKx_SPLOCK1_Pos       (1UL)
#define BSEC_SPLOCKx_SPLOCK1_Msk       (0x1UL << BSEC_SPLOCKx_SPLOCK1_Pos)          /*!< 0x00000002 */
#define BSEC_SPLOCKx_SPLOCK1           BSEC_SPLOCKx_SPLOCK1_Msk                    /*!< Sticky programming lock for word (1+32*x) */
#define BSEC_SPLOCKx_SPLOCK2_Pos       (2UL)
#define BSEC_SPLOCKx_SPLOCK2_Msk       (0x1UL << BSEC_SPLOCKx_SPLOCK2_Pos)          /*!< 0x00000004 */
#define BSEC_SPLOCKx_SPLOCK2           BSEC_SPLOCKx_SPLOCK2_Msk                    /*!< Sticky programming lock for word (2+32*x) */
#define BSEC_SPLOCKx_SPLOCK3_Pos       (3UL)
#define BSEC_SPLOCKx_SPLOCK3_Msk       (0x1UL << BSEC_SPLOCKx_SPLOCK3_Pos)          /*!< 0x00000008 */
#define BSEC_SPLOCKx_SPLOCK3           BSEC_SPLOCKx_SPLOCK3_Msk                    /*!< Sticky programming lock for word (3+32*x) */
#define BSEC_SPLOCKx_SPLOCK4_Pos       (4UL)
#define BSEC_SPLOCKx_SPLOCK4_Msk       (0x1UL << BSEC_SPLOCKx_SPLOCK4_Pos)          /*!< 0x00000010 */
#define BSEC_SPLOCKx_SPLOCK4           BSEC_SPLOCKx_SPLOCK4_Msk                    /*!< Sticky programming lock for word (4+32*x) */
#define BSEC_SPLOCKx_SPLOCK5_Pos       (5UL)
#define BSEC_SPLOCKx_SPLOCK5_Msk       (0x1UL << BSEC_SPLOCKx_SPLOCK5_Pos)          /*!< 0x00000020 */
#define BSEC_SPLOCKx_SPLOCK5           BSEC_SPLOCKx_SPLOCK5_Msk                    /*!< Sticky programming lock for word (5+32*x) */
#define BSEC_SPLOCKx_SPLOCK6_Pos       (6UL)
#define BSEC_SPLOCKx_SPLOCK6_Msk       (0x1UL << BSEC_SPLOCKx_SPLOCK6_Pos)          /*!< 0x00000040 */
#define BSEC_SPLOCKx_SPLOCK6           BSEC_SPLOCKx_SPLOCK6_Msk                    /*!< Sticky programming lock for word (6+32*x) */
#define BSEC_SPLOCKx_SPLOCK7_Pos       (7UL)
#define BSEC_SPLOCKx_SPLOCK7_Msk       (0x1UL << BSEC_SPLOCKx_SPLOCK7_Pos)          /*!< 0x00000080 */
#define BSEC_SPLOCKx_SPLOCK7           BSEC_SPLOCKx_SPLOCK7_Msk                    /*!< Sticky programming lock for word (7+32*x) */
#define BSEC_SPLOCKx_SPLOCK8_Pos       (8UL)
#define BSEC_SPLOCKx_SPLOCK8_Msk       (0x1UL << BSEC_SPLOCKx_SPLOCK8_Pos)          /*!< 0x00000100 */
#define BSEC_SPLOCKx_SPLOCK8           BSEC_SPLOCKx_SPLOCK8_Msk                    /*!< Sticky programming lock for word (8+32*x) */
#define BSEC_SPLOCKx_SPLOCK9_Pos       (9UL)
#define BSEC_SPLOCKx_SPLOCK9_Msk       (0x1UL << BSEC_SPLOCKx_SPLOCK9_Pos)          /*!< 0x00000200 */
#define BSEC_SPLOCKx_SPLOCK9           BSEC_SPLOCKx_SPLOCK9_Msk                    /*!< Sticky programming lock for word (9+32*x) */
#define BSEC_SPLOCKx_SPLOCK10_Pos      (10UL)
#define BSEC_SPLOCKx_SPLOCK10_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK10_Pos)         /*!< 0x00000400 */
#define BSEC_SPLOCKx_SPLOCK10          BSEC_SPLOCKx_SPLOCK10_Msk                   /*!< Sticky programming lock for word (10+32*x) */
#define BSEC_SPLOCKx_SPLOCK11_Pos      (11UL)
#define BSEC_SPLOCKx_SPLOCK11_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK11_Pos)         /*!< 0x00000800 */
#define BSEC_SPLOCKx_SPLOCK11          BSEC_SPLOCKx_SPLOCK11_Msk                   /*!< Sticky programming lock for word (11+32*x) */
#define BSEC_SPLOCKx_SPLOCK12_Pos      (12UL)
#define BSEC_SPLOCKx_SPLOCK12_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK12_Pos)         /*!< 0x00001000 */
#define BSEC_SPLOCKx_SPLOCK12          BSEC_SPLOCKx_SPLOCK12_Msk                   /*!< Sticky programming lock for word (12+32*x) */
#define BSEC_SPLOCKx_SPLOCK13_Pos      (13UL)
#define BSEC_SPLOCKx_SPLOCK13_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK13_Pos)         /*!< 0x00002000 */
#define BSEC_SPLOCKx_SPLOCK13          BSEC_SPLOCKx_SPLOCK13_Msk                   /*!< Sticky programming lock for word (13+32*x) */
#define BSEC_SPLOCKx_SPLOCK14_Pos      (14UL)
#define BSEC_SPLOCKx_SPLOCK14_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK14_Pos)         /*!< 0x00004000 */
#define BSEC_SPLOCKx_SPLOCK14          BSEC_SPLOCKx_SPLOCK14_Msk                   /*!< Sticky programming lock for word (14+32*x) */
#define BSEC_SPLOCKx_SPLOCK15_Pos      (15UL)
#define BSEC_SPLOCKx_SPLOCK15_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK15_Pos)         /*!< 0x00008000 */
#define BSEC_SPLOCKx_SPLOCK15          BSEC_SPLOCKx_SPLOCK15_Msk                   /*!< Sticky programming lock for word (15+32*x) */
#define BSEC_SPLOCKx_SPLOCK16_Pos      (16UL)
#define BSEC_SPLOCKx_SPLOCK16_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK16_Pos)         /*!< 0x00010000 */
#define BSEC_SPLOCKx_SPLOCK16          BSEC_SPLOCKx_SPLOCK16_Msk                   /*!< Sticky programming lock for word (16+32*x) */
#define BSEC_SPLOCKx_SPLOCK17_Pos      (17UL)
#define BSEC_SPLOCKx_SPLOCK17_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK17_Pos)         /*!< 0x00020000 */
#define BSEC_SPLOCKx_SPLOCK17          BSEC_SPLOCKx_SPLOCK17_Msk                   /*!< Sticky programming lock for word (17+32*x) */
#define BSEC_SPLOCKx_SPLOCK18_Pos      (18UL)
#define BSEC_SPLOCKx_SPLOCK18_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK18_Pos)         /*!< 0x00040000 */
#define BSEC_SPLOCKx_SPLOCK18          BSEC_SPLOCKx_SPLOCK18_Msk                   /*!< Sticky programming lock for word (18+32*x) */
#define BSEC_SPLOCKx_SPLOCK19_Pos      (19UL)
#define BSEC_SPLOCKx_SPLOCK19_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK19_Pos)         /*!< 0x00080000 */
#define BSEC_SPLOCKx_SPLOCK19          BSEC_SPLOCKx_SPLOCK19_Msk                   /*!< Sticky programming lock for word (19+32*x) */
#define BSEC_SPLOCKx_SPLOCK20_Pos      (20UL)
#define BSEC_SPLOCKx_SPLOCK20_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK20_Pos)         /*!< 0x00100000 */
#define BSEC_SPLOCKx_SPLOCK20          BSEC_SPLOCKx_SPLOCK20_Msk                   /*!< Sticky programming lock for word (20+32*x) */
#define BSEC_SPLOCKx_SPLOCK21_Pos      (21UL)
#define BSEC_SPLOCKx_SPLOCK21_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK21_Pos)         /*!< 0x00200000 */
#define BSEC_SPLOCKx_SPLOCK21          BSEC_SPLOCKx_SPLOCK21_Msk                   /*!< Sticky programming lock for word (21+32*x) */
#define BSEC_SPLOCKx_SPLOCK22_Pos      (22UL)
#define BSEC_SPLOCKx_SPLOCK22_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK22_Pos)         /*!< 0x00400000 */
#define BSEC_SPLOCKx_SPLOCK22          BSEC_SPLOCKx_SPLOCK22_Msk                   /*!< Sticky programming lock for word (22+32*x) */
#define BSEC_SPLOCKx_SPLOCK23_Pos      (23UL)
#define BSEC_SPLOCKx_SPLOCK23_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK23_Pos)         /*!< 0x00800000 */
#define BSEC_SPLOCKx_SPLOCK23          BSEC_SPLOCKx_SPLOCK23_Msk                   /*!< Sticky programming lock for word (23+32*x) */
#define BSEC_SPLOCKx_SPLOCK24_Pos      (24UL)
#define BSEC_SPLOCKx_SPLOCK24_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK24_Pos)         /*!< 0x01000000 */
#define BSEC_SPLOCKx_SPLOCK24          BSEC_SPLOCKx_SPLOCK24_Msk                   /*!< Sticky programming lock for word (24+32*x) */
#define BSEC_SPLOCKx_SPLOCK25_Pos      (25UL)
#define BSEC_SPLOCKx_SPLOCK25_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK25_Pos)         /*!< 0x02000000 */
#define BSEC_SPLOCKx_SPLOCK25          BSEC_SPLOCKx_SPLOCK25_Msk                   /*!< Sticky programming lock for word (25+32*x) */
#define BSEC_SPLOCKx_SPLOCK26_Pos      (26UL)
#define BSEC_SPLOCKx_SPLOCK26_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK26_Pos)         /*!< 0x04000000 */
#define BSEC_SPLOCKx_SPLOCK26          BSEC_SPLOCKx_SPLOCK26_Msk                   /*!< Sticky programming lock for word (26+32*x) */
#define BSEC_SPLOCKx_SPLOCK27_Pos      (27UL)
#define BSEC_SPLOCKx_SPLOCK27_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK27_Pos)         /*!< 0x08000000 */
#define BSEC_SPLOCKx_SPLOCK27          BSEC_SPLOCKx_SPLOCK27_Msk                   /*!< Sticky programming lock for word (27+32*x) */
#define BSEC_SPLOCKx_SPLOCK28_Pos      (28UL)
#define BSEC_SPLOCKx_SPLOCK28_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK28_Pos)         /*!< 0x10000000 */
#define BSEC_SPLOCKx_SPLOCK28          BSEC_SPLOCKx_SPLOCK28_Msk                   /*!< Sticky programming lock for word (28+32*x) */
#define BSEC_SPLOCKx_SPLOCK29_Pos      (29UL)
#define BSEC_SPLOCKx_SPLOCK29_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK29_Pos)         /*!< 0x20000000 */
#define BSEC_SPLOCKx_SPLOCK29          BSEC_SPLOCKx_SPLOCK29_Msk                   /*!< Sticky programming lock for word (29+32*x) */
#define BSEC_SPLOCKx_SPLOCK30_Pos      (30UL)
#define BSEC_SPLOCKx_SPLOCK30_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK30_Pos)         /*!< 0x40000000 */
#define BSEC_SPLOCKx_SPLOCK30          BSEC_SPLOCKx_SPLOCK30_Msk                   /*!< Sticky programming lock for word (30+32*x) */
#define BSEC_SPLOCKx_SPLOCK31_Pos      (31UL)
#define BSEC_SPLOCKx_SPLOCK31_Msk      (0x1UL << BSEC_SPLOCKx_SPLOCK31_Pos)         /*!< 0x80000000 */
#define BSEC_SPLOCKx_SPLOCK31          BSEC_SPLOCKx_SPLOCK31_Msk                   /*!< Sticky programming lock for word (31+32*x) */

/*****************  Bit definition for BSEC_SWLOCKx register  *****************/
#define BSEC_SWLOCKx_SWLOCK0_Pos       (0UL)
#define BSEC_SWLOCKx_SWLOCK0_Msk       (0x1UL << BSEC_SWLOCKx_SWLOCK0_Pos)          /*!< 0x00000001 */
#define BSEC_SWLOCKx_SWLOCK0           BSEC_SWLOCKx_SWLOCK0_Msk                    /*!< Sticky write lock for shadow register (32*x) */
#define BSEC_SWLOCKx_SWLOCK1_Pos       (1UL)
#define BSEC_SWLOCKx_SWLOCK1_Msk       (0x1UL << BSEC_SWLOCKx_SWLOCK1_Pos)          /*!< 0x00000002 */
#define BSEC_SWLOCKx_SWLOCK1           BSEC_SWLOCKx_SWLOCK1_Msk                    /*!< Sticky write lock for shadow register (1+32*x) */
#define BSEC_SWLOCKx_SWLOCK2_Pos       (2UL)
#define BSEC_SWLOCKx_SWLOCK2_Msk       (0x1UL << BSEC_SWLOCKx_SWLOCK2_Pos)          /*!< 0x00000004 */
#define BSEC_SWLOCKx_SWLOCK2           BSEC_SWLOCKx_SWLOCK2_Msk                    /*!< Sticky write lock for shadow register (2+32*x) */
#define BSEC_SWLOCKx_SWLOCK3_Pos       (3UL)
#define BSEC_SWLOCKx_SWLOCK3_Msk       (0x1UL << BSEC_SWLOCKx_SWLOCK3_Pos)          /*!< 0x00000008 */
#define BSEC_SWLOCKx_SWLOCK3           BSEC_SWLOCKx_SWLOCK3_Msk                    /*!< Sticky write lock for shadow register (3+32*x) */
#define BSEC_SWLOCKx_SWLOCK4_Pos       (4UL)
#define BSEC_SWLOCKx_SWLOCK4_Msk       (0x1UL << BSEC_SWLOCKx_SWLOCK4_Pos)          /*!< 0x00000010 */
#define BSEC_SWLOCKx_SWLOCK4           BSEC_SWLOCKx_SWLOCK4_Msk                    /*!< Sticky write lock for shadow register (4+32*x) */
#define BSEC_SWLOCKx_SWLOCK5_Pos       (5UL)
#define BSEC_SWLOCKx_SWLOCK5_Msk       (0x1UL << BSEC_SWLOCKx_SWLOCK5_Pos)          /*!< 0x00000020 */
#define BSEC_SWLOCKx_SWLOCK5           BSEC_SWLOCKx_SWLOCK5_Msk                    /*!< Sticky write lock for shadow register (5+32*x) */
#define BSEC_SWLOCKx_SWLOCK6_Pos       (6UL)
#define BSEC_SWLOCKx_SWLOCK6_Msk       (0x1UL << BSEC_SWLOCKx_SWLOCK6_Pos)          /*!< 0x00000040 */
#define BSEC_SWLOCKx_SWLOCK6           BSEC_SWLOCKx_SWLOCK6_Msk                    /*!< Sticky write lock for shadow register (6+32*x) */
#define BSEC_SWLOCKx_SWLOCK7_Pos       (7UL)
#define BSEC_SWLOCKx_SWLOCK7_Msk       (0x1UL << BSEC_SWLOCKx_SWLOCK7_Pos)          /*!< 0x00000080 */
#define BSEC_SWLOCKx_SWLOCK7           BSEC_SWLOCKx_SWLOCK7_Msk                    /*!< Sticky write lock for shadow register (7+32*x) */
#define BSEC_SWLOCKx_SWLOCK8_Pos       (8UL)
#define BSEC_SWLOCKx_SWLOCK8_Msk       (0x1UL << BSEC_SWLOCKx_SWLOCK8_Pos)          /*!< 0x00000100 */
#define BSEC_SWLOCKx_SWLOCK8           BSEC_SWLOCKx_SWLOCK8_Msk                    /*!< Sticky write lock for shadow register (8+32*x) */
#define BSEC_SWLOCKx_SWLOCK9_Pos       (9UL)
#define BSEC_SWLOCKx_SWLOCK9_Msk       (0x1UL << BSEC_SWLOCKx_SWLOCK9_Pos)          /*!< 0x00000200 */
#define BSEC_SWLOCKx_SWLOCK9           BSEC_SWLOCKx_SWLOCK9_Msk                    /*!< Sticky write lock for shadow register (9+32*x) */
#define BSEC_SWLOCKx_SWLOCK10_Pos      (10UL)
#define BSEC_SWLOCKx_SWLOCK10_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK10_Pos)         /*!< 0x00000400 */
#define BSEC_SWLOCKx_SWLOCK10          BSEC_SWLOCKx_SWLOCK10_Msk                   /*!< Sticky write lock for shadow register (10+32*x) */
#define BSEC_SWLOCKx_SWLOCK11_Pos      (11UL)
#define BSEC_SWLOCKx_SWLOCK11_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK11_Pos)         /*!< 0x00000800 */
#define BSEC_SWLOCKx_SWLOCK11          BSEC_SWLOCKx_SWLOCK11_Msk                   /*!< Sticky write lock for shadow register (11+32*x) */
#define BSEC_SWLOCKx_SWLOCK12_Pos      (12UL)
#define BSEC_SWLOCKx_SWLOCK12_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK12_Pos)         /*!< 0x00001000 */
#define BSEC_SWLOCKx_SWLOCK12          BSEC_SWLOCKx_SWLOCK12_Msk                   /*!< Sticky write lock for shadow register (12+32*x) */
#define BSEC_SWLOCKx_SWLOCK13_Pos      (13UL)
#define BSEC_SWLOCKx_SWLOCK13_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK13_Pos)         /*!< 0x00002000 */
#define BSEC_SWLOCKx_SWLOCK13          BSEC_SWLOCKx_SWLOCK13_Msk                   /*!< Sticky write lock for shadow register (13+32*x) */
#define BSEC_SWLOCKx_SWLOCK14_Pos      (14UL)
#define BSEC_SWLOCKx_SWLOCK14_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK14_Pos)         /*!< 0x00004000 */
#define BSEC_SWLOCKx_SWLOCK14          BSEC_SWLOCKx_SWLOCK14_Msk                   /*!< Sticky write lock for shadow register (14+32*x) */
#define BSEC_SWLOCKx_SWLOCK15_Pos      (15UL)
#define BSEC_SWLOCKx_SWLOCK15_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK15_Pos)         /*!< 0x00008000 */
#define BSEC_SWLOCKx_SWLOCK15          BSEC_SWLOCKx_SWLOCK15_Msk                   /*!< Sticky write lock for shadow register (15+32*x) */
#define BSEC_SWLOCKx_SWLOCK16_Pos      (16UL)
#define BSEC_SWLOCKx_SWLOCK16_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK16_Pos)         /*!< 0x00010000 */
#define BSEC_SWLOCKx_SWLOCK16          BSEC_SWLOCKx_SWLOCK16_Msk                   /*!< Sticky write lock for shadow register (16+32*x) */
#define BSEC_SWLOCKx_SWLOCK17_Pos      (17UL)
#define BSEC_SWLOCKx_SWLOCK17_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK17_Pos)         /*!< 0x00020000 */
#define BSEC_SWLOCKx_SWLOCK17          BSEC_SWLOCKx_SWLOCK17_Msk                   /*!< Sticky write lock for shadow register (17+32*x) */
#define BSEC_SWLOCKx_SWLOCK18_Pos      (18UL)
#define BSEC_SWLOCKx_SWLOCK18_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK18_Pos)         /*!< 0x00040000 */
#define BSEC_SWLOCKx_SWLOCK18          BSEC_SWLOCKx_SWLOCK18_Msk                   /*!< Sticky write lock for shadow register (18+32*x) */
#define BSEC_SWLOCKx_SWLOCK19_Pos      (19UL)
#define BSEC_SWLOCKx_SWLOCK19_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK19_Pos)         /*!< 0x00080000 */
#define BSEC_SWLOCKx_SWLOCK19          BSEC_SWLOCKx_SWLOCK19_Msk                   /*!< Sticky write lock for shadow register (19+32*x) */
#define BSEC_SWLOCKx_SWLOCK20_Pos      (20UL)
#define BSEC_SWLOCKx_SWLOCK20_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK20_Pos)         /*!< 0x00100000 */
#define BSEC_SWLOCKx_SWLOCK20          BSEC_SWLOCKx_SWLOCK20_Msk                   /*!< Sticky write lock for shadow register (20+32*x) */
#define BSEC_SWLOCKx_SWLOCK21_Pos      (21UL)
#define BSEC_SWLOCKx_SWLOCK21_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK21_Pos)         /*!< 0x00200000 */
#define BSEC_SWLOCKx_SWLOCK21          BSEC_SWLOCKx_SWLOCK21_Msk                   /*!< Sticky write lock for shadow register (21+32*x) */
#define BSEC_SWLOCKx_SWLOCK22_Pos      (22UL)
#define BSEC_SWLOCKx_SWLOCK22_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK22_Pos)         /*!< 0x00400000 */
#define BSEC_SWLOCKx_SWLOCK22          BSEC_SWLOCKx_SWLOCK22_Msk                   /*!< Sticky write lock for shadow register (22+32*x) */
#define BSEC_SWLOCKx_SWLOCK23_Pos      (23UL)
#define BSEC_SWLOCKx_SWLOCK23_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK23_Pos)         /*!< 0x00800000 */
#define BSEC_SWLOCKx_SWLOCK23          BSEC_SWLOCKx_SWLOCK23_Msk                   /*!< Sticky write lock for shadow register (23+32*x) */
#define BSEC_SWLOCKx_SWLOCK24_Pos      (24UL)
#define BSEC_SWLOCKx_SWLOCK24_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK24_Pos)         /*!< 0x01000000 */
#define BSEC_SWLOCKx_SWLOCK24          BSEC_SWLOCKx_SWLOCK24_Msk                   /*!< Sticky write lock for shadow register (24+32*x) */
#define BSEC_SWLOCKx_SWLOCK25_Pos      (25UL)
#define BSEC_SWLOCKx_SWLOCK25_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK25_Pos)         /*!< 0x02000000 */
#define BSEC_SWLOCKx_SWLOCK25          BSEC_SWLOCKx_SWLOCK25_Msk                   /*!< Sticky write lock for shadow register (25+32*x) */
#define BSEC_SWLOCKx_SWLOCK26_Pos      (26UL)
#define BSEC_SWLOCKx_SWLOCK26_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK26_Pos)         /*!< 0x04000000 */
#define BSEC_SWLOCKx_SWLOCK26          BSEC_SWLOCKx_SWLOCK26_Msk                   /*!< Sticky write lock for shadow register (26+32*x) */
#define BSEC_SWLOCKx_SWLOCK27_Pos      (27UL)
#define BSEC_SWLOCKx_SWLOCK27_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK27_Pos)         /*!< 0x08000000 */
#define BSEC_SWLOCKx_SWLOCK27          BSEC_SWLOCKx_SWLOCK27_Msk                   /*!< Sticky write lock for shadow register (27+32*x) */
#define BSEC_SWLOCKx_SWLOCK28_Pos      (28UL)
#define BSEC_SWLOCKx_SWLOCK28_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK28_Pos)         /*!< 0x10000000 */
#define BSEC_SWLOCKx_SWLOCK28          BSEC_SWLOCKx_SWLOCK28_Msk                   /*!< Sticky write lock for shadow register (28+32*x) */
#define BSEC_SWLOCKx_SWLOCK29_Pos      (29UL)
#define BSEC_SWLOCKx_SWLOCK29_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK29_Pos)         /*!< 0x20000000 */
#define BSEC_SWLOCKx_SWLOCK29          BSEC_SWLOCKx_SWLOCK29_Msk                   /*!< Sticky write lock for shadow register (29+32*x) */
#define BSEC_SWLOCKx_SWLOCK30_Pos      (30UL)
#define BSEC_SWLOCKx_SWLOCK30_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK30_Pos)         /*!< 0x40000000 */
#define BSEC_SWLOCKx_SWLOCK30          BSEC_SWLOCKx_SWLOCK30_Msk                   /*!< Sticky write lock for shadow register (30+32*x) */
#define BSEC_SWLOCKx_SWLOCK31_Pos      (31UL)
#define BSEC_SWLOCKx_SWLOCK31_Msk      (0x1UL << BSEC_SWLOCKx_SWLOCK31_Pos)         /*!< 0x80000000 */
#define BSEC_SWLOCKx_SWLOCK31          BSEC_SWLOCKx_SWLOCK31_Msk                   /*!< Sticky write lock for shadow register (31+32*x) */

/*****************  Bit definition for BSEC_SRLOCKx register  *****************/
#define BSEC_SRLOCKx_SRLOCK0_Pos       (0UL)
#define BSEC_SRLOCKx_SRLOCK0_Msk       (0x1UL << BSEC_SRLOCKx_SRLOCK0_Pos)          /*!< 0x00000001 */
#define BSEC_SRLOCKx_SRLOCK0           BSEC_SRLOCKx_SRLOCK0_Msk                    /*!< Sticky reload lock for fuse word (32*x) */
#define BSEC_SRLOCKx_SRLOCK1_Pos       (1UL)
#define BSEC_SRLOCKx_SRLOCK1_Msk       (0x1UL << BSEC_SRLOCKx_SRLOCK1_Pos)          /*!< 0x00000002 */
#define BSEC_SRLOCKx_SRLOCK1           BSEC_SRLOCKx_SRLOCK1_Msk                    /*!< Sticky reload lock for fuse word (1+32*x) */
#define BSEC_SRLOCKx_SRLOCK2_Pos       (2UL)
#define BSEC_SRLOCKx_SRLOCK2_Msk       (0x1UL << BSEC_SRLOCKx_SRLOCK2_Pos)          /*!< 0x00000004 */
#define BSEC_SRLOCKx_SRLOCK2           BSEC_SRLOCKx_SRLOCK2_Msk                    /*!< Sticky reload lock for fuse word (2+32*x) */
#define BSEC_SRLOCKx_SRLOCK3_Pos       (3UL)
#define BSEC_SRLOCKx_SRLOCK3_Msk       (0x1UL << BSEC_SRLOCKx_SRLOCK3_Pos)          /*!< 0x00000008 */
#define BSEC_SRLOCKx_SRLOCK3           BSEC_SRLOCKx_SRLOCK3_Msk                    /*!< Sticky reload lock for fuse word (3+32*x) */
#define BSEC_SRLOCKx_SRLOCK4_Pos       (4UL)
#define BSEC_SRLOCKx_SRLOCK4_Msk       (0x1UL << BSEC_SRLOCKx_SRLOCK4_Pos)          /*!< 0x00000010 */
#define BSEC_SRLOCKx_SRLOCK4           BSEC_SRLOCKx_SRLOCK4_Msk                    /*!< Sticky reload lock for fuse word (4+32*x) */
#define BSEC_SRLOCKx_SRLOCK5_Pos       (5UL)
#define BSEC_SRLOCKx_SRLOCK5_Msk       (0x1UL << BSEC_SRLOCKx_SRLOCK5_Pos)          /*!< 0x00000020 */
#define BSEC_SRLOCKx_SRLOCK5           BSEC_SRLOCKx_SRLOCK5_Msk                    /*!< Sticky reload lock for fuse word (5+32*x) */
#define BSEC_SRLOCKx_SRLOCK6_Pos       (6UL)
#define BSEC_SRLOCKx_SRLOCK6_Msk       (0x1UL << BSEC_SRLOCKx_SRLOCK6_Pos)          /*!< 0x00000040 */
#define BSEC_SRLOCKx_SRLOCK6           BSEC_SRLOCKx_SRLOCK6_Msk                    /*!< Sticky reload lock for fuse word (6+32*x) */
#define BSEC_SRLOCKx_SRLOCK7_Pos       (7UL)
#define BSEC_SRLOCKx_SRLOCK7_Msk       (0x1UL << BSEC_SRLOCKx_SRLOCK7_Pos)          /*!< 0x00000080 */
#define BSEC_SRLOCKx_SRLOCK7           BSEC_SRLOCKx_SRLOCK7_Msk                    /*!< Sticky reload lock for fuse word (7+32*x) */
#define BSEC_SRLOCKx_SRLOCK8_Pos       (8UL)
#define BSEC_SRLOCKx_SRLOCK8_Msk       (0x1UL << BSEC_SRLOCKx_SRLOCK8_Pos)          /*!< 0x00000100 */
#define BSEC_SRLOCKx_SRLOCK8           BSEC_SRLOCKx_SRLOCK8_Msk                    /*!< Sticky reload lock for fuse word (8+32*x) */
#define BSEC_SRLOCKx_SRLOCK9_Pos       (9UL)
#define BSEC_SRLOCKx_SRLOCK9_Msk       (0x1UL << BSEC_SRLOCKx_SRLOCK9_Pos)          /*!< 0x00000200 */
#define BSEC_SRLOCKx_SRLOCK9           BSEC_SRLOCKx_SRLOCK9_Msk                    /*!< Sticky reload lock for fuse word (9+32*x) */
#define BSEC_SRLOCKx_SRLOCK10_Pos      (10UL)
#define BSEC_SRLOCKx_SRLOCK10_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK10_Pos)         /*!< 0x00000400 */
#define BSEC_SRLOCKx_SRLOCK10          BSEC_SRLOCKx_SRLOCK10_Msk                   /*!< Sticky reload lock for fuse word (10+2*x) */
#define BSEC_SRLOCKx_SRLOCK11_Pos      (11UL)
#define BSEC_SRLOCKx_SRLOCK11_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK11_Pos)         /*!< 0x00000800 */
#define BSEC_SRLOCKx_SRLOCK11          BSEC_SRLOCKx_SRLOCK11_Msk                   /*!< Sticky reload lock for fuse word (11+32*x) */
#define BSEC_SRLOCKx_SRLOCK12_Pos      (12UL)
#define BSEC_SRLOCKx_SRLOCK12_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK12_Pos)         /*!< 0x00001000 */
#define BSEC_SRLOCKx_SRLOCK12          BSEC_SRLOCKx_SRLOCK12_Msk                   /*!< Sticky reload lock for fuse word (12+32*x) */
#define BSEC_SRLOCKx_SRLOCK13_Pos      (13UL)
#define BSEC_SRLOCKx_SRLOCK13_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK13_Pos)         /*!< 0x00002000 */
#define BSEC_SRLOCKx_SRLOCK13          BSEC_SRLOCKx_SRLOCK13_Msk                   /*!< Sticky reload lock for fuse word (13+32*x) */
#define BSEC_SRLOCKx_SRLOCK14_Pos      (14UL)
#define BSEC_SRLOCKx_SRLOCK14_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK14_Pos)         /*!< 0x00004000 */
#define BSEC_SRLOCKx_SRLOCK14          BSEC_SRLOCKx_SRLOCK14_Msk                   /*!< Sticky reload lock for fuse word (14+32*x) */
#define BSEC_SRLOCKx_SRLOCK15_Pos      (15UL)
#define BSEC_SRLOCKx_SRLOCK15_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK15_Pos)         /*!< 0x00008000 */
#define BSEC_SRLOCKx_SRLOCK15          BSEC_SRLOCKx_SRLOCK15_Msk                   /*!< Sticky reload lock for fuse word (15+32*x) */
#define BSEC_SRLOCKx_SRLOCK16_Pos      (16UL)
#define BSEC_SRLOCKx_SRLOCK16_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK16_Pos)         /*!< 0x00010000 */
#define BSEC_SRLOCKx_SRLOCK16          BSEC_SRLOCKx_SRLOCK16_Msk                   /*!< Sticky reload lock for fuse word (16+32*x) */
#define BSEC_SRLOCKx_SRLOCK17_Pos      (17UL)
#define BSEC_SRLOCKx_SRLOCK17_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK17_Pos)         /*!< 0x00020000 */
#define BSEC_SRLOCKx_SRLOCK17          BSEC_SRLOCKx_SRLOCK17_Msk                   /*!< Sticky reload lock for fuse word (17+32*x) */
#define BSEC_SRLOCKx_SRLOCK18_Pos      (18UL)
#define BSEC_SRLOCKx_SRLOCK18_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK18_Pos)         /*!< 0x00040000 */
#define BSEC_SRLOCKx_SRLOCK18          BSEC_SRLOCKx_SRLOCK18_Msk                   /*!< Sticky reload lock for fuse word (18+32*x) */
#define BSEC_SRLOCKx_SRLOCK19_Pos      (19UL)
#define BSEC_SRLOCKx_SRLOCK19_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK19_Pos)         /*!< 0x00080000 */
#define BSEC_SRLOCKx_SRLOCK19          BSEC_SRLOCKx_SRLOCK19_Msk                   /*!< Sticky reload lock for fuse word (19+32*x) */
#define BSEC_SRLOCKx_SRLOCK20_Pos      (20UL)
#define BSEC_SRLOCKx_SRLOCK20_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK20_Pos)         /*!< 0x00100000 */
#define BSEC_SRLOCKx_SRLOCK20          BSEC_SRLOCKx_SRLOCK20_Msk                   /*!< Sticky reload lock for fuse word (20+32*x) */
#define BSEC_SRLOCKx_SRLOCK21_Pos      (21UL)
#define BSEC_SRLOCKx_SRLOCK21_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK21_Pos)         /*!< 0x00200000 */
#define BSEC_SRLOCKx_SRLOCK21          BSEC_SRLOCKx_SRLOCK21_Msk                   /*!< Sticky reload lock for fuse word (21+32*x) */
#define BSEC_SRLOCKx_SRLOCK22_Pos      (22UL)
#define BSEC_SRLOCKx_SRLOCK22_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK22_Pos)         /*!< 0x00400000 */
#define BSEC_SRLOCKx_SRLOCK22          BSEC_SRLOCKx_SRLOCK22_Msk                   /*!< Sticky reload lock for fuse word (22+32*x) */
#define BSEC_SRLOCKx_SRLOCK23_Pos      (23UL)
#define BSEC_SRLOCKx_SRLOCK23_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK23_Pos)         /*!< 0x00800000 */
#define BSEC_SRLOCKx_SRLOCK23          BSEC_SRLOCKx_SRLOCK23_Msk                   /*!< Sticky reload lock for fuse word (23+32*x) */
#define BSEC_SRLOCKx_SRLOCK24_Pos      (24UL)
#define BSEC_SRLOCKx_SRLOCK24_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK24_Pos)         /*!< 0x01000000 */
#define BSEC_SRLOCKx_SRLOCK24          BSEC_SRLOCKx_SRLOCK24_Msk                   /*!< Sticky reload lock for fuse word (24+32*x) */
#define BSEC_SRLOCKx_SRLOCK25_Pos      (25UL)
#define BSEC_SRLOCKx_SRLOCK25_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK25_Pos)         /*!< 0x02000000 */
#define BSEC_SRLOCKx_SRLOCK25          BSEC_SRLOCKx_SRLOCK25_Msk                   /*!< Sticky reload lock for fuse word (25+32*x) */
#define BSEC_SRLOCKx_SRLOCK26_Pos      (26UL)
#define BSEC_SRLOCKx_SRLOCK26_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK26_Pos)         /*!< 0x04000000 */
#define BSEC_SRLOCKx_SRLOCK26          BSEC_SRLOCKx_SRLOCK26_Msk                   /*!< Sticky reload lock for fuse word (26+32*x) */
#define BSEC_SRLOCKx_SRLOCK27_Pos      (27UL)
#define BSEC_SRLOCKx_SRLOCK27_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK27_Pos)         /*!< 0x08000000 */
#define BSEC_SRLOCKx_SRLOCK27          BSEC_SRLOCKx_SRLOCK27_Msk                   /*!< Sticky reload lock for fuse word (27+32*x) */
#define BSEC_SRLOCKx_SRLOCK28_Pos      (28UL)
#define BSEC_SRLOCKx_SRLOCK28_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK28_Pos)         /*!< 0x10000000 */
#define BSEC_SRLOCKx_SRLOCK28          BSEC_SRLOCKx_SRLOCK28_Msk                   /*!< Sticky reload lock for fuse word (28+32*x) */
#define BSEC_SRLOCKx_SRLOCK29_Pos      (29UL)
#define BSEC_SRLOCKx_SRLOCK29_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK29_Pos)         /*!< 0x20000000 */
#define BSEC_SRLOCKx_SRLOCK29          BSEC_SRLOCKx_SRLOCK29_Msk                   /*!< Sticky reload lock for fuse word (29+32*x) */
#define BSEC_SRLOCKx_SRLOCK30_Pos      (30UL)
#define BSEC_SRLOCKx_SRLOCK30_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK30_Pos)         /*!< 0x40000000 */
#define BSEC_SRLOCKx_SRLOCK30          BSEC_SRLOCKx_SRLOCK30_Msk                   /*!< Sticky reload lock for fuse word (30+32*x) */
#define BSEC_SRLOCKx_SRLOCK31_Pos      (31UL)
#define BSEC_SRLOCKx_SRLOCK31_Msk      (0x1UL << BSEC_SRLOCKx_SRLOCK31_Pos)         /*!< 0x80000000 */
#define BSEC_SRLOCKx_SRLOCK31          BSEC_SRLOCKx_SRLOCK31_Msk                   /*!< Sticky reload lock for fuse word (31+32*x) */

/****************  Bit definition for BSEC_OTPVLDRx register  *****************/
#define BSEC_OTPVLDRx_VLDF0_Pos        (0UL)
#define BSEC_OTPVLDRx_VLDF0_Msk        (0x1UL << BSEC_OTPVLDRx_VLDF0_Pos)           /*!< 0x00000001 */
#define BSEC_OTPVLDRx_VLDF0            BSEC_OTPVLDRx_VLDF0_Msk                     /*!< Valid flag for shadow register (32*x) */
#define BSEC_OTPVLDRx_VLDF1_Pos        (1UL)
#define BSEC_OTPVLDRx_VLDF1_Msk        (0x1UL << BSEC_OTPVLDRx_VLDF1_Pos)           /*!< 0x00000002 */
#define BSEC_OTPVLDRx_VLDF1            BSEC_OTPVLDRx_VLDF1_Msk                     /*!< Valid flag for shadow register (1+32*x) */
#define BSEC_OTPVLDRx_VLDF2_Pos        (2UL)
#define BSEC_OTPVLDRx_VLDF2_Msk        (0x1UL << BSEC_OTPVLDRx_VLDF2_Pos)           /*!< 0x00000004 */
#define BSEC_OTPVLDRx_VLDF2            BSEC_OTPVLDRx_VLDF2_Msk                     /*!< Valid flag for shadow register (2+32*x) */
#define BSEC_OTPVLDRx_VLDF3_Pos        (3UL)
#define BSEC_OTPVLDRx_VLDF3_Msk        (0x1UL << BSEC_OTPVLDRx_VLDF3_Pos)           /*!< 0x00000008 */
#define BSEC_OTPVLDRx_VLDF3            BSEC_OTPVLDRx_VLDF3_Msk                     /*!< Valid flag for shadow register (3+32*x) */
#define BSEC_OTPVLDRx_VLDF4_Pos        (4UL)
#define BSEC_OTPVLDRx_VLDF4_Msk        (0x1UL << BSEC_OTPVLDRx_VLDF4_Pos)           /*!< 0x00000010 */
#define BSEC_OTPVLDRx_VLDF4            BSEC_OTPVLDRx_VLDF4_Msk                     /*!< Valid flag for shadow register (4+32*x) */
#define BSEC_OTPVLDRx_VLDF5_Pos        (5UL)
#define BSEC_OTPVLDRx_VLDF5_Msk        (0x1UL << BSEC_OTPVLDRx_VLDF5_Pos)           /*!< 0x00000020 */
#define BSEC_OTPVLDRx_VLDF5            BSEC_OTPVLDRx_VLDF5_Msk                     /*!< Valid flag for shadow register (5+32*x) */
#define BSEC_OTPVLDRx_VLDF6_Pos        (6UL)
#define BSEC_OTPVLDRx_VLDF6_Msk        (0x1UL << BSEC_OTPVLDRx_VLDF6_Pos)           /*!< 0x00000040 */
#define BSEC_OTPVLDRx_VLDF6            BSEC_OTPVLDRx_VLDF6_Msk                     /*!< Valid flag for shadow register (6+32*x) */
#define BSEC_OTPVLDRx_VLDF7_Pos        (7UL)
#define BSEC_OTPVLDRx_VLDF7_Msk        (0x1UL << BSEC_OTPVLDRx_VLDF7_Pos)           /*!< 0x00000080 */
#define BSEC_OTPVLDRx_VLDF7            BSEC_OTPVLDRx_VLDF7_Msk                     /*!< Valid flag for shadow register (7+32*x) */
#define BSEC_OTPVLDRx_VLDF8_Pos        (8UL)
#define BSEC_OTPVLDRx_VLDF8_Msk        (0x1UL << BSEC_OTPVLDRx_VLDF8_Pos)           /*!< 0x00000100 */
#define BSEC_OTPVLDRx_VLDF8            BSEC_OTPVLDRx_VLDF8_Msk                     /*!< Valid flag for shadow register (8+32*x) */
#define BSEC_OTPVLDRx_VLDF9_Pos        (9UL)
#define BSEC_OTPVLDRx_VLDF9_Msk        (0x1UL << BSEC_OTPVLDRx_VLDF9_Pos)           /*!< 0x00000200 */
#define BSEC_OTPVLDRx_VLDF9            BSEC_OTPVLDRx_VLDF9_Msk                     /*!< Valid flag for shadow register (9+32*x) */
#define BSEC_OTPVLDRx_VLDF10_Pos       (10UL)
#define BSEC_OTPVLDRx_VLDF10_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF10_Pos)          /*!< 0x00000400 */
#define BSEC_OTPVLDRx_VLDF10           BSEC_OTPVLDRx_VLDF10_Msk                    /*!< Valid flag for shadow register (10+32*x) */
#define BSEC_OTPVLDRx_VLDF11_Pos       (11UL)
#define BSEC_OTPVLDRx_VLDF11_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF11_Pos)          /*!< 0x00000800 */
#define BSEC_OTPVLDRx_VLDF11           BSEC_OTPVLDRx_VLDF11_Msk                    /*!< Valid flag for shadow register (11+32*x) */
#define BSEC_OTPVLDRx_VLDF12_Pos       (12UL)
#define BSEC_OTPVLDRx_VLDF12_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF12_Pos)          /*!< 0x00001000 */
#define BSEC_OTPVLDRx_VLDF12           BSEC_OTPVLDRx_VLDF12_Msk                    /*!< Valid flag for shadow register (12+32*x) */
#define BSEC_OTPVLDRx_VLDF13_Pos       (13UL)
#define BSEC_OTPVLDRx_VLDF13_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF13_Pos)          /*!< 0x00002000 */
#define BSEC_OTPVLDRx_VLDF13           BSEC_OTPVLDRx_VLDF13_Msk                    /*!< Valid flag for shadow register (13+32*x) */
#define BSEC_OTPVLDRx_VLDF14_Pos       (14UL)
#define BSEC_OTPVLDRx_VLDF14_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF14_Pos)          /*!< 0x00004000 */
#define BSEC_OTPVLDRx_VLDF14           BSEC_OTPVLDRx_VLDF14_Msk                    /*!< Valid flag for shadow register (14+32*x) */
#define BSEC_OTPVLDRx_VLDF15_Pos       (15UL)
#define BSEC_OTPVLDRx_VLDF15_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF15_Pos)          /*!< 0x00008000 */
#define BSEC_OTPVLDRx_VLDF15           BSEC_OTPVLDRx_VLDF15_Msk                    /*!< Valid flag for shadow register (15+32*x) */
#define BSEC_OTPVLDRx_VLDF16_Pos       (16UL)
#define BSEC_OTPVLDRx_VLDF16_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF16_Pos)          /*!< 0x00010000 */
#define BSEC_OTPVLDRx_VLDF16           BSEC_OTPVLDRx_VLDF16_Msk                    /*!< Valid flag for shadow register (16+32*x) */
#define BSEC_OTPVLDRx_VLDF17_Pos       (17UL)
#define BSEC_OTPVLDRx_VLDF17_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF17_Pos)          /*!< 0x00020000 */
#define BSEC_OTPVLDRx_VLDF17           BSEC_OTPVLDRx_VLDF17_Msk                    /*!< Valid flag for shadow register (17+32*x) */
#define BSEC_OTPVLDRx_VLDF18_Pos       (18UL)
#define BSEC_OTPVLDRx_VLDF18_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF18_Pos)          /*!< 0x00040000 */
#define BSEC_OTPVLDRx_VLDF18           BSEC_OTPVLDRx_VLDF18_Msk                    /*!< Valid flag for shadow register (18+32*x) */
#define BSEC_OTPVLDRx_VLDF19_Pos       (19UL)
#define BSEC_OTPVLDRx_VLDF19_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF19_Pos)          /*!< 0x00080000 */
#define BSEC_OTPVLDRx_VLDF19           BSEC_OTPVLDRx_VLDF19_Msk                    /*!< Valid flag for shadow register (19+32*x) */
#define BSEC_OTPVLDRx_VLDF20_Pos       (20UL)
#define BSEC_OTPVLDRx_VLDF20_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF20_Pos)          /*!< 0x00100000 */
#define BSEC_OTPVLDRx_VLDF20           BSEC_OTPVLDRx_VLDF20_Msk                    /*!< Valid flag for shadow register (20+32*x) */
#define BSEC_OTPVLDRx_VLDF21_Pos       (21UL)
#define BSEC_OTPVLDRx_VLDF21_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF21_Pos)          /*!< 0x00200000 */
#define BSEC_OTPVLDRx_VLDF21           BSEC_OTPVLDRx_VLDF21_Msk                    /*!< Valid flag for shadow register (21+32*x) */
#define BSEC_OTPVLDRx_VLDF22_Pos       (22UL)
#define BSEC_OTPVLDRx_VLDF22_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF22_Pos)          /*!< 0x00400000 */
#define BSEC_OTPVLDRx_VLDF22           BSEC_OTPVLDRx_VLDF22_Msk                    /*!< Valid flag for shadow register (22+32*x) */
#define BSEC_OTPVLDRx_VLDF23_Pos       (23UL)
#define BSEC_OTPVLDRx_VLDF23_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF23_Pos)          /*!< 0x00800000 */
#define BSEC_OTPVLDRx_VLDF23           BSEC_OTPVLDRx_VLDF23_Msk                    /*!< Valid flag for shadow register (23+32*x) */
#define BSEC_OTPVLDRx_VLDF24_Pos       (24UL)
#define BSEC_OTPVLDRx_VLDF24_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF24_Pos)          /*!< 0x01000000 */
#define BSEC_OTPVLDRx_VLDF24           BSEC_OTPVLDRx_VLDF24_Msk                    /*!< Valid flag for shadow register (24+32*x) */
#define BSEC_OTPVLDRx_VLDF25_Pos       (25UL)
#define BSEC_OTPVLDRx_VLDF25_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF25_Pos)          /*!< 0x02000000 */
#define BSEC_OTPVLDRx_VLDF25           BSEC_OTPVLDRx_VLDF25_Msk                    /*!< Valid flag for shadow register (25+32*x) */
#define BSEC_OTPVLDRx_VLDF26_Pos       (26UL)
#define BSEC_OTPVLDRx_VLDF26_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF26_Pos)          /*!< 0x04000000 */
#define BSEC_OTPVLDRx_VLDF26           BSEC_OTPVLDRx_VLDF26_Msk                    /*!< Valid flag for shadow register (26+32*x) */
#define BSEC_OTPVLDRx_VLDF27_Pos       (27UL)
#define BSEC_OTPVLDRx_VLDF27_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF27_Pos)          /*!< 0x08000000 */
#define BSEC_OTPVLDRx_VLDF27           BSEC_OTPVLDRx_VLDF27_Msk                    /*!< Valid flag for shadow register (27+32*x) */
#define BSEC_OTPVLDRx_VLDF28_Pos       (28UL)
#define BSEC_OTPVLDRx_VLDF28_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF28_Pos)          /*!< 0x10000000 */
#define BSEC_OTPVLDRx_VLDF28           BSEC_OTPVLDRx_VLDF28_Msk                    /*!< Valid flag for shadow register (28+32*x) */
#define BSEC_OTPVLDRx_VLDF29_Pos       (29UL)
#define BSEC_OTPVLDRx_VLDF29_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF29_Pos)          /*!< 0x20000000 */
#define BSEC_OTPVLDRx_VLDF29           BSEC_OTPVLDRx_VLDF29_Msk                    /*!< Valid flag for shadow register (29+32*x) */
#define BSEC_OTPVLDRx_VLDF30_Pos       (30UL)
#define BSEC_OTPVLDRx_VLDF30_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF30_Pos)          /*!< 0x40000000 */
#define BSEC_OTPVLDRx_VLDF30           BSEC_OTPVLDRx_VLDF30_Msk                    /*!< Valid flag for shadow register (30+32*x) */
#define BSEC_OTPVLDRx_VLDF31_Pos       (31UL)
#define BSEC_OTPVLDRx_VLDF31_Msk       (0x1UL << BSEC_OTPVLDRx_VLDF31_Pos)          /*!< 0x80000000 */
#define BSEC_OTPVLDRx_VLDF31           BSEC_OTPVLDRx_VLDF31_Msk                    /*!< Valid flag for shadow register (31+32*x) */

/******************  Bit definition for BSEC_SFSRx register  ******************/
#define BSEC_SFSRx_SFW0_Pos            (0UL)
#define BSEC_SFSRx_SFW0_Msk            (0x1UL << BSEC_SFSRx_SFW0_Pos)               /*!< 0x00000001 */
#define BSEC_SFSRx_SFW0                BSEC_SFSRx_SFW0_Msk                         /*!< Shadowed fuse word (32*x) */
#define BSEC_SFSRx_SFW1_Pos            (1UL)
#define BSEC_SFSRx_SFW1_Msk            (0x1UL << BSEC_SFSRx_SFW1_Pos)               /*!< 0x00000002 */
#define BSEC_SFSRx_SFW1                BSEC_SFSRx_SFW1_Msk                         /*!< Shadowed fuse word (1+32*x) */
#define BSEC_SFSRx_SFW2_Pos            (2UL)
#define BSEC_SFSRx_SFW2_Msk            (0x1UL << BSEC_SFSRx_SFW2_Pos)               /*!< 0x00000004 */
#define BSEC_SFSRx_SFW2                BSEC_SFSRx_SFW2_Msk                         /*!< Shadowed fuse word (2+32*x) */
#define BSEC_SFSRx_SFW3_Pos            (3UL)
#define BSEC_SFSRx_SFW3_Msk            (0x1UL << BSEC_SFSRx_SFW3_Pos)               /*!< 0x00000008 */
#define BSEC_SFSRx_SFW3                BSEC_SFSRx_SFW3_Msk                         /*!< Shadowed fuse word (3+32*x) */
#define BSEC_SFSRx_SFW4_Pos            (4UL)
#define BSEC_SFSRx_SFW4_Msk            (0x1UL << BSEC_SFSRx_SFW4_Pos)               /*!< 0x00000010 */
#define BSEC_SFSRx_SFW4                BSEC_SFSRx_SFW4_Msk                         /*!< Shadowed fuse word (4+32*x) */
#define BSEC_SFSRx_SFW5_Pos            (5UL)
#define BSEC_SFSRx_SFW5_Msk            (0x1UL << BSEC_SFSRx_SFW5_Pos)               /*!< 0x00000020 */
#define BSEC_SFSRx_SFW5                BSEC_SFSRx_SFW5_Msk                         /*!< Shadowed fuse word (5+32*x) */
#define BSEC_SFSRx_SFW6_Pos            (6UL)
#define BSEC_SFSRx_SFW6_Msk            (0x1UL << BSEC_SFSRx_SFW6_Pos)               /*!< 0x00000040 */
#define BSEC_SFSRx_SFW6                BSEC_SFSRx_SFW6_Msk                         /*!< Shadowed fuse word (6+32*x) */
#define BSEC_SFSRx_SFW7_Pos            (7UL)
#define BSEC_SFSRx_SFW7_Msk            (0x1UL << BSEC_SFSRx_SFW7_Pos)               /*!< 0x00000080 */
#define BSEC_SFSRx_SFW7                BSEC_SFSRx_SFW7_Msk                         /*!< Shadowed fuse word (7+32*x) */
#define BSEC_SFSRx_SFW8_Pos            (8UL)
#define BSEC_SFSRx_SFW8_Msk            (0x1UL << BSEC_SFSRx_SFW8_Pos)               /*!< 0x00000100 */
#define BSEC_SFSRx_SFW8                BSEC_SFSRx_SFW8_Msk                         /*!< Shadowed fuse word (8+32*x) */
#define BSEC_SFSRx_SFW9_Pos            (9UL)
#define BSEC_SFSRx_SFW9_Msk            (0x1UL << BSEC_SFSRx_SFW9_Pos)               /*!< 0x00000200 */
#define BSEC_SFSRx_SFW9                BSEC_SFSRx_SFW9_Msk                         /*!< Shadowed fuse word (9+32*x) */
#define BSEC_SFSRx_SFW10_Pos           (10UL)
#define BSEC_SFSRx_SFW10_Msk           (0x1UL << BSEC_SFSRx_SFW10_Pos)              /*!< 0x00000400 */
#define BSEC_SFSRx_SFW10               BSEC_SFSRx_SFW10_Msk                        /*!< Shadowed fuse word (10+32*x) */
#define BSEC_SFSRx_SFW11_Pos           (11UL)
#define BSEC_SFSRx_SFW11_Msk           (0x1UL << BSEC_SFSRx_SFW11_Pos)              /*!< 0x00000800 */
#define BSEC_SFSRx_SFW11               BSEC_SFSRx_SFW11_Msk                        /*!< Shadowed fuse word (11+32*x) */
#define BSEC_SFSRx_SFW12_Pos           (12UL)
#define BSEC_SFSRx_SFW12_Msk           (0x1UL << BSEC_SFSRx_SFW12_Pos)              /*!< 0x00001000 */
#define BSEC_SFSRx_SFW12               BSEC_SFSRx_SFW12_Msk                        /*!< Shadowed fuse word (12+32*x) */
#define BSEC_SFSRx_SFW13_Pos           (13UL)
#define BSEC_SFSRx_SFW13_Msk           (0x1UL << BSEC_SFSRx_SFW13_Pos)              /*!< 0x00002000 */
#define BSEC_SFSRx_SFW13               BSEC_SFSRx_SFW13_Msk                        /*!< Shadowed fuse word (13+32*x) */
#define BSEC_SFSRx_SFW14_Pos           (14UL)
#define BSEC_SFSRx_SFW14_Msk           (0x1UL << BSEC_SFSRx_SFW14_Pos)              /*!< 0x00004000 */
#define BSEC_SFSRx_SFW14               BSEC_SFSRx_SFW14_Msk                        /*!< Shadowed fuse word (14+32*x) */
#define BSEC_SFSRx_SFW15_Pos           (15UL)
#define BSEC_SFSRx_SFW15_Msk           (0x1UL << BSEC_SFSRx_SFW15_Pos)              /*!< 0x00008000 */
#define BSEC_SFSRx_SFW15               BSEC_SFSRx_SFW15_Msk                        /*!< Shadowed fuse word (15+32*x) */
#define BSEC_SFSRx_SFW16_Pos           (16UL)
#define BSEC_SFSRx_SFW16_Msk           (0x1UL << BSEC_SFSRx_SFW16_Pos)              /*!< 0x00010000 */
#define BSEC_SFSRx_SFW16               BSEC_SFSRx_SFW16_Msk                        /*!< Shadowed fuse word (16+32*x) */
#define BSEC_SFSRx_SFW17_Pos           (17UL)
#define BSEC_SFSRx_SFW17_Msk           (0x1UL << BSEC_SFSRx_SFW17_Pos)              /*!< 0x00020000 */
#define BSEC_SFSRx_SFW17               BSEC_SFSRx_SFW17_Msk                        /*!< Shadowed fuse word (17+32*x) */
#define BSEC_SFSRx_SFW18_Pos           (18UL)
#define BSEC_SFSRx_SFW18_Msk           (0x1UL << BSEC_SFSRx_SFW18_Pos)              /*!< 0x00040000 */
#define BSEC_SFSRx_SFW18               BSEC_SFSRx_SFW18_Msk                        /*!< Shadowed fuse word (18+32*x) */
#define BSEC_SFSRx_SFW19_Pos           (19UL)
#define BSEC_SFSRx_SFW19_Msk           (0x1UL << BSEC_SFSRx_SFW19_Pos)              /*!< 0x00080000 */
#define BSEC_SFSRx_SFW19               BSEC_SFSRx_SFW19_Msk                        /*!< Shadowed fuse word (19+32*x) */
#define BSEC_SFSRx_SFW20_Pos           (20UL)
#define BSEC_SFSRx_SFW20_Msk           (0x1UL << BSEC_SFSRx_SFW20_Pos)              /*!< 0x00100000 */
#define BSEC_SFSRx_SFW20               BSEC_SFSRx_SFW20_Msk                        /*!< Shadowed fuse word (20+32*x) */
#define BSEC_SFSRx_SFW21_Pos           (21UL)
#define BSEC_SFSRx_SFW21_Msk           (0x1UL << BSEC_SFSRx_SFW21_Pos)              /*!< 0x00200000 */
#define BSEC_SFSRx_SFW21               BSEC_SFSRx_SFW21_Msk                        /*!< Shadowed fuse word (21+32*x) */
#define BSEC_SFSRx_SFW22_Pos           (22UL)
#define BSEC_SFSRx_SFW22_Msk           (0x1UL << BSEC_SFSRx_SFW22_Pos)              /*!< 0x00400000 */
#define BSEC_SFSRx_SFW22               BSEC_SFSRx_SFW22_Msk                        /*!< Shadowed fuse word (22+32*x) */
#define BSEC_SFSRx_SFW23_Pos           (23UL)
#define BSEC_SFSRx_SFW23_Msk           (0x1UL << BSEC_SFSRx_SFW23_Pos)              /*!< 0x00800000 */
#define BSEC_SFSRx_SFW23               BSEC_SFSRx_SFW23_Msk                        /*!< Shadowed fuse word (23+32*x) */
#define BSEC_SFSRx_SFW24_Pos           (24UL)
#define BSEC_SFSRx_SFW24_Msk           (0x1UL << BSEC_SFSRx_SFW24_Pos)              /*!< 0x01000000 */
#define BSEC_SFSRx_SFW24               BSEC_SFSRx_SFW24_Msk                        /*!< Shadowed fuse word (24+32*x) */
#define BSEC_SFSRx_SFW25_Pos           (25UL)
#define BSEC_SFSRx_SFW25_Msk           (0x1UL << BSEC_SFSRx_SFW25_Pos)              /*!< 0x02000000 */
#define BSEC_SFSRx_SFW25               BSEC_SFSRx_SFW25_Msk                        /*!< Shadowed fuse word (25+32*x) */
#define BSEC_SFSRx_SFW26_Pos           (26UL)
#define BSEC_SFSRx_SFW26_Msk           (0x1UL << BSEC_SFSRx_SFW26_Pos)              /*!< 0x04000000 */
#define BSEC_SFSRx_SFW26               BSEC_SFSRx_SFW26_Msk                        /*!< Shadowed fuse word (26+32*x) */
#define BSEC_SFSRx_SFW27_Pos           (27UL)
#define BSEC_SFSRx_SFW27_Msk           (0x1UL << BSEC_SFSRx_SFW27_Pos)              /*!< 0x08000000 */
#define BSEC_SFSRx_SFW27               BSEC_SFSRx_SFW27_Msk                        /*!< Shadowed fuse word (27+32*x) */
#define BSEC_SFSRx_SFW28_Pos           (28UL)
#define BSEC_SFSRx_SFW28_Msk           (0x1UL << BSEC_SFSRx_SFW28_Pos)              /*!< 0x10000000 */
#define BSEC_SFSRx_SFW28               BSEC_SFSRx_SFW28_Msk                        /*!< Shadowed fuse word (28+32*x) */
#define BSEC_SFSRx_SFW29_Pos           (29UL)
#define BSEC_SFSRx_SFW29_Msk           (0x1UL << BSEC_SFSRx_SFW29_Pos)              /*!< 0x20000000 */
#define BSEC_SFSRx_SFW29               BSEC_SFSRx_SFW29_Msk                        /*!< Shadowed fuse word (29+32*x) */
#define BSEC_SFSRx_SFW30_Pos           (30UL)
#define BSEC_SFSRx_SFW30_Msk           (0x1UL << BSEC_SFSRx_SFW30_Pos)              /*!< 0x40000000 */
#define BSEC_SFSRx_SFW30               BSEC_SFSRx_SFW30_Msk                        /*!< Shadowed fuse word (30+32*x) */
#define BSEC_SFSRx_SFW31_Pos           (31UL)
#define BSEC_SFSRx_SFW31_Msk           (0x1UL << BSEC_SFSRx_SFW31_Pos)              /*!< 0x80000000 */
#define BSEC_SFSRx_SFW31               BSEC_SFSRx_SFW31_Msk                        /*!< Shadowed fuse word (31+32*x) */

/******************  Bit definition for BSEC_OTPCR register  ******************/
#define BSEC_OTPCR_ADDR_Pos            (0UL)
#define BSEC_OTPCR_ADDR_Msk            (0x1FFUL << BSEC_OTPCR_ADDR_Pos)             /*!< 0x000001FF */
#define BSEC_OTPCR_ADDR                BSEC_OTPCR_ADDR_Msk                         /*!< Fuse word address */
#define BSEC_OTPCR_PROG_Pos            (13UL)
#define BSEC_OTPCR_PROG_Msk            (0x1UL << BSEC_OTPCR_PROG_Pos)               /*!< 0x00002000 */
#define BSEC_OTPCR_PROG                BSEC_OTPCR_PROG_Msk                         /*!< Fuse word programming */
#define BSEC_OTPCR_PPLOCK_Pos          (14UL)
#define BSEC_OTPCR_PPLOCK_Msk          (0x1UL << BSEC_OTPCR_PPLOCK_Pos)             /*!< 0x00004000 */
#define BSEC_OTPCR_PPLOCK              BSEC_OTPCR_PPLOCK_Msk                       /*!< Permanent programming lock */
#define BSEC_OTPCR_LASTCID_Pos         (19UL)
#define BSEC_OTPCR_LASTCID_Msk         (0x7UL << BSEC_OTPCR_LASTCID_Pos)            /*!< 0x00380000 */
#define BSEC_OTPCR_LASTCID             BSEC_OTPCR_LASTCID_Msk                      /*!< Last CID */

/*******************  Bit definition for BSEC_WDR register  *******************/
#define BSEC_WDR_WRDATA_Pos            (0UL)
#define BSEC_WDR_WRDATA_Msk            (0xFFFFFFFFUL << BSEC_WDR_WRDATA_Pos)        /*!< 0xFFFFFFFF */
#define BSEC_WDR_WRDATA                BSEC_WDR_WRDATA_Msk                         /*!< OTP write data */

/****************  Bit definition for BSEC_SCRATCHRx register  ****************/
#define BSEC_SCRATCHRx_SDATA_Pos       (0UL)
#define BSEC_SCRATCHRx_SDATA_Msk       (0xFFFFFFFFUL << BSEC_SCRATCHRx_SDATA_Pos)   /*!< 0xFFFFFFFF */
#define BSEC_SCRATCHRx_SDATA           BSEC_SCRATCHRx_SDATA_Msk                    /*!< Scratch data */

/******************  Bit definition for BSEC_LOCKR register  ******************/
#define BSEC_LOCKR_GWLOCK_Pos          (0UL)
#define BSEC_LOCKR_GWLOCK_Msk          (0x1UL << BSEC_LOCKR_GWLOCK_Pos)             /*!< 0x00000001 */
#define BSEC_LOCKR_GWLOCK              BSEC_LOCKR_GWLOCK_Msk                       /*!< Global write lock */
#define BSEC_LOCKR_HKLOCK_Pos          (2UL)
#define BSEC_LOCKR_HKLOCK_Msk          (0x1UL << BSEC_LOCKR_HKLOCK_Pos)             /*!< 0x00000004 */
#define BSEC_LOCKR_HKLOCK              BSEC_LOCKR_HKLOCK_Msk                       /*!< Hardware key lock */

/*****************  Bit definition for BSEC_JTAGINR register  *****************/
#define BSEC_JTAGINR_JDATAIN_Pos       (0UL)
#define BSEC_JTAGINR_JDATAIN_Msk       (0xFFFFFFFFUL << BSEC_JTAGINR_JDATAIN_Pos)   /*!< 0xFFFFFFFF */
#define BSEC_JTAGINR_JDATAIN           BSEC_JTAGINR_JDATAIN_Msk                    /*!< JTAG input data */

/****************  Bit definition for BSEC_JTAGOUTR register  *****************/
#define BSEC_JTAGOUTR_JDATAOUT_Pos     (0UL)
#define BSEC_JTAGOUTR_JDATAOUT_Msk     (0xFFFFFFFFUL << BSEC_JTAGOUTR_JDATAOUT_Pos) /*!< 0xFFFFFFFF */
#define BSEC_JTAGOUTR_JDATAOUT         BSEC_JTAGOUTR_JDATAOUT_Msk                  /*!< JTAG output data */

/*****************  Bit definition for BSEC_UNMAPR register  ******************/
#define BSEC_UNMAPR_UNMAP_Pos          (0UL)
#define BSEC_UNMAPR_UNMAP_Msk          (0xFFFFFFFFUL << BSEC_UNMAPR_UNMAP_Pos)      /*!< 0xFFFFFFFF */
#define BSEC_UNMAPR_UNMAP              BSEC_UNMAPR_UNMAP_Msk                       /*!< Unmap key */

/*******************  Bit definition for BSEC_SR register  ********************/
#define BSEC_SR_HVALID_Pos             (1UL)
#define BSEC_SR_HVALID_Msk             (0x1UL << BSEC_SR_HVALID_Pos)                /*!< 0x00000002 */
#define BSEC_SR_HVALID                 BSEC_SR_HVALID_Msk                          /*!< Hardware key valid */
#define BSEC_SR_DBGREQ_Pos             (16UL)
#define BSEC_SR_DBGREQ_Msk             (0x1UL << BSEC_SR_DBGREQ_Pos)                /*!< 0x00010000 */
#define BSEC_SR_DBGREQ                 BSEC_SR_DBGREQ_Msk                          /*!< Debug request */
#define BSEC_SR_NVSTATE_Pos            (26UL)
#define BSEC_SR_NVSTATE_Msk            (0x3FUL << BSEC_SR_NVSTATE_Pos)              /*!< 0xFC000000 */
#define BSEC_SR_NVSTATE                BSEC_SR_NVSTATE_Msk                         /*!< Non-volatile state */

/******************  Bit definition for BSEC_OTPSR register  ******************/
#define BSEC_OTPSR_BUSY_Pos            (0UL)
#define BSEC_OTPSR_BUSY_Msk            (0x1UL << BSEC_OTPSR_BUSY_Pos)               /*!< 0x00000001 */
#define BSEC_OTPSR_BUSY                BSEC_OTPSR_BUSY_Msk                         /*!< Busy flag */
#define BSEC_OTPSR_INIT_DONE_Pos       (1UL)
#define BSEC_OTPSR_INIT_DONE_Msk       (0x1UL << BSEC_OTPSR_INIT_DONE_Pos)          /*!< 0x00000002 */
#define BSEC_OTPSR_INIT_DONE           BSEC_OTPSR_INIT_DONE_Msk                    /*!< Initialization done */
#define BSEC_OTPSR_HIDEUP_Pos          (2UL)
#define BSEC_OTPSR_HIDEUP_Msk          (0x1UL << BSEC_OTPSR_HIDEUP_Pos)             /*!< 0x00000004 */
#define BSEC_OTPSR_HIDEUP              BSEC_OTPSR_HIDEUP_Msk                       /*!< Hide upper fuse words */
#define BSEC_OTPSR_OTPNVIR_Pos         (4UL)
#define BSEC_OTPSR_OTPNVIR_Msk         (0x1UL << BSEC_OTPSR_OTPNVIR_Pos)            /*!< 0x00000010 */
#define BSEC_OTPSR_OTPNVIR             BSEC_OTPSR_OTPNVIR_Msk                      /*!< OTP not virgin */
#define BSEC_OTPSR_OTPERR_Pos          (5UL)
#define BSEC_OTPSR_OTPERR_Msk          (0x1UL << BSEC_OTPSR_OTPERR_Pos)             /*!< 0x00000020 */
#define BSEC_OTPSR_OTPERR              BSEC_OTPSR_OTPERR_Msk                       /*!< OTP with error */
#define BSEC_OTPSR_OTPSEC_Pos          (6UL)
#define BSEC_OTPSR_OTPSEC_Msk          (0x1UL << BSEC_OTPSR_OTPSEC_Pos)             /*!< 0x00000040 */
#define BSEC_OTPSR_OTPSEC              BSEC_OTPSR_OTPSEC_Msk                       /*!< OTP with single error correction */
#define BSEC_OTPSR_PROGFAIL_Pos        (16UL)
#define BSEC_OTPSR_PROGFAIL_Msk        (0x1UL << BSEC_OTPSR_PROGFAIL_Pos)           /*!< 0x00010000 */
#define BSEC_OTPSR_PROGFAIL            BSEC_OTPSR_PROGFAIL_Msk                     /*!< Programming failed */
#define BSEC_OTPSR_DISTURBF_Pos        (17UL)
#define BSEC_OTPSR_DISTURBF_Msk        (0x1UL << BSEC_OTPSR_DISTURBF_Pos)           /*!< 0x00020000 */
#define BSEC_OTPSR_DISTURBF            BSEC_OTPSR_DISTURBF_Msk                     /*!< Disturb flag */
#define BSEC_OTPSR_DEDF_Pos            (18UL)
#define BSEC_OTPSR_DEDF_Msk            (0x1UL << BSEC_OTPSR_DEDF_Pos)               /*!< 0x00040000 */
#define BSEC_OTPSR_DEDF                BSEC_OTPSR_DEDF_Msk                         /*!< Double error detection flag */
#define BSEC_OTPSR_SECF_Pos            (19UL)
#define BSEC_OTPSR_SECF_Msk            (0x1UL << BSEC_OTPSR_SECF_Pos)               /*!< 0x00080000 */
#define BSEC_OTPSR_SECF                BSEC_OTPSR_SECF_Msk                         /*!< Single error correction flag */
#define BSEC_OTPSR_PPLF_Pos            (20UL)
#define BSEC_OTPSR_PPLF_Msk            (0x1UL << BSEC_OTPSR_PPLF_Pos)               /*!< 0x00100000 */
#define BSEC_OTPSR_PPLF                BSEC_OTPSR_PPLF_Msk                         /*!< Permanent programming lock flag */
#define BSEC_OTPSR_PPLMF_Pos           (21UL)
#define BSEC_OTPSR_PPLMF_Msk           (0x1UL << BSEC_OTPSR_PPLMF_Pos)              /*!< 0x00200000 */
#define BSEC_OTPSR_PPLMF               BSEC_OTPSR_PPLMF_Msk                        /*!< Permanent programming lock mismatch flag */
#define BSEC_OTPSR_AMEF_Pos            (22UL)
#define BSEC_OTPSR_AMEF_Msk            (0x1UL << BSEC_OTPSR_AMEF_Pos)               /*!< 0x00400000 */
#define BSEC_OTPSR_AMEF                BSEC_OTPSR_AMEF_Msk                         /*!< Addresses mismatch error flag */

/*****************  Bit definition for BSEC_EPOCHRx register  *****************/
#define BSEC_EPOCHRx_EPOCH_Pos         (0UL)
#define BSEC_EPOCHRx_EPOCH_Msk         (0xFFFFFFFFUL << BSEC_EPOCHRx_EPOCH_Pos)     /*!< 0xFFFFFFFF */
#define BSEC_EPOCHRx_EPOCH             BSEC_EPOCHRx_EPOCH_Msk                      /*!< Epoch */

/****************  Bit definition for BSEC_EPOCHSELR register  ****************/
#define BSEC_EPOCHSELR_EPSEL_Pos       (0UL)
#define BSEC_EPOCHSELR_EPSEL_Msk       (0x1UL << BSEC_EPOCHSELR_EPSEL_Pos)          /*!< 0x00000001 */
#define BSEC_EPOCHSELR_EPSEL           BSEC_EPOCHSELR_EPSEL_Msk                    /*!< Epoch selection */

/******************  Bit definition for BSEC_DBGCR register  ******************/
#define BSEC_DBGCR_UNLOCK_Pos          (8UL)
#define BSEC_DBGCR_UNLOCK_Msk          (0xFFUL << BSEC_DBGCR_UNLOCK_Pos)            /*!< 0x0000FF00 */
#define BSEC_DBGCR_UNLOCK              BSEC_DBGCR_UNLOCK_Msk                       /*!< Non-secure debug authorization */
#define BSEC_DBGCR_AUTH_HDPL_Pos       (16UL)
#define BSEC_DBGCR_AUTH_HDPL_Msk       (0xFFUL << BSEC_DBGCR_AUTH_HDPL_Pos)         /*!< 0x00FF0000 */
#define BSEC_DBGCR_AUTH_HDPL           BSEC_DBGCR_AUTH_HDPL_Msk                    /*!< Level at which debug may be opened */
#define BSEC_DBGCR_AUTH_SEC_Pos        (24UL)
#define BSEC_DBGCR_AUTH_SEC_Msk        (0xFFUL << BSEC_DBGCR_AUTH_SEC_Pos)          /*!< 0xFF000000 */
#define BSEC_DBGCR_AUTH_SEC            BSEC_DBGCR_AUTH_SEC_Msk                     /*!< Secure debug authorization */

/***************  Bit definition for BSEC_AP_UNLOCK register  *****************/
#define BSEC_AP_UNLOCK_UNLOCK_Pos      (0UL)
#define BSEC_AP_UNLOCK_UNLOCK_Msk      (0xFFUL << BSEC_AP_UNLOCK_UNLOCK_Pos)        /*!< 0x000000FF */
#define BSEC_AP_UNLOCK_UNLOCK          BSEC_AP_UNLOCK_UNLOCK_Msk                   /*!< Unlock DBG_MCU AP interface */

/*****************  Bit definition for BSEC_HDPLSR register  ******************/
#define BSEC_HDPLSR_HDPL_Pos           (0UL)
#define BSEC_HDPLSR_HDPL_Msk           (0xFFUL << BSEC_HDPLSR_HDPL_Pos)             /*!< 0x000000FF */
#define BSEC_HDPLSR_HDPL               BSEC_HDPLSR_HDPL_Msk                        /*!< Current HDPL */

/*****************  Bit definition for BSEC_HDPLCR register  ******************/
#define BSEC_HDPLCR_INCR_HDPL_Pos      (0UL)
#define BSEC_HDPLCR_INCR_HDPL_Msk      (0xFFFFFFFFUL << BSEC_HDPLCR_INCR_HDPL_Pos)  /*!< 0xFFFFFFFF */
#define BSEC_HDPLCR_INCR_HDPL          BSEC_HDPLCR_INCR_HDPL_Msk                   /*!< Increment HDPL */

/*****************  Bit definition for BSEC_NEXTLR register  ******************/
#define BSEC_NEXTLR_INCR_Pos           (0UL)
#define BSEC_NEXTLR_INCR_Msk           (0x3UL << BSEC_NEXTLR_INCR_Pos)              /*!< 0x00000003 */
#define BSEC_NEXTLR_INCR               BSEC_NEXTLR_INCR_Msk                        /*!< Increment */

/*****************  Bit definition for BSEC_WOSCRx register  ******************/
#define BSEC_WOSCRx_WOSDATA_Pos        (0UL)
#define BSEC_WOSCRx_WOSDATA_Msk        (0xFFFFFFFFUL << BSEC_WOSCRx_WOSDATA_Pos)    /*!< 0xFFFFFFFF */
#define BSEC_WOSCRx_WOSDATA            BSEC_WOSCRx_WOSDATA_Msk                     /*!< Write once scratch data */

/******************  Bit definition for BSEC_HRCR register  *******************/
#define BSEC_HRCR_HRC_Pos              (0UL)
#define BSEC_HRCR_HRC_Msk              (0xFFFFFFFFUL << BSEC_HRCR_HRC_Pos)          /*!< 0xFFFFFFFF */
#define BSEC_HRCR_HRC                  BSEC_HRCR_HRC_Msk                           /*!< Hot reset counter */

/******************  Bit definition for BSEC_WRCR register  *******************/
#define BSEC_WRCR_WRC_Pos              (0UL)
#define BSEC_WRCR_WRC_Msk              (0xFFFFFFFFUL << BSEC_WRCR_WRC_Pos)          /*!< 0xFFFFFFFF */
#define BSEC_WRCR_WRC                  BSEC_WRCR_WRC_Msk                           /*!< Warm reset counter */


/******************************************************************************/
/*                                                                            */
/*                                 CACHEAXI                                   */
/*                                                                            */
/******************************************************************************/
/****************  Bit definition for CACHEAXI_CR1 register  ******************/
#define CACHEAXI_CR1_EN_Pos                   (0UL)
#define CACHEAXI_CR1_EN_Msk                   (0x1UL << CACHEAXI_CR1_EN_Pos)             /*!< 0x00000001 */
#define CACHEAXI_CR1_EN                       CACHEAXI_CR1_EN_Msk                        /*!< Enable */
#define CACHEAXI_CR1_CACHEINV_Pos             (1UL)
#define CACHEAXI_CR1_CACHEINV_Msk             (0x1UL << CACHEAXI_CR1_CACHEINV_Pos)       /*!< 0x00000002 */
#define CACHEAXI_CR1_CACHEINV                 CACHEAXI_CR1_CACHEINV_Msk                  /*!< Cache invalidation */
#define CACHEAXI_CR1_RHITMEN_Pos              (16UL)
#define CACHEAXI_CR1_RHITMEN_Msk              (0x1UL << CACHEAXI_CR1_RHITMEN_Pos)        /*!< 0x00010000 */
#define CACHEAXI_CR1_RHITMEN                  CACHEAXI_CR1_RHITMEN_Msk                   /*!< Read Hit monitor enable */
#define CACHEAXI_CR1_RMISSMEN_Pos             (17UL)
#define CACHEAXI_CR1_RMISSMEN_Msk             (0x1UL << CACHEAXI_CR1_RMISSMEN_Pos)       /*!< 0x00020000 */
#define CACHEAXI_CR1_RMISSMEN                 CACHEAXI_CR1_RMISSMEN_Msk                  /*!< Read Miss monitor enable */
#define CACHEAXI_CR1_RHITMRST_Pos             (18UL)
#define CACHEAXI_CR1_RHITMRST_Msk             (0x1UL << CACHEAXI_CR1_RHITMRST_Pos)       /*!< 0x00040000 */
#define CACHEAXI_CR1_RHITMRST                 CACHEAXI_CR1_RHITMRST_Msk                  /*!< Read Hit monitor reset */
#define CACHEAXI_CR1_RMISSMRST_Pos            (19UL)
#define CACHEAXI_CR1_RMISSMRST_Msk            (0x1UL << CACHEAXI_CR1_RMISSMRST_Pos)      /*!< 0x00080000 */
#define CACHEAXI_CR1_RMISSMRST                CACHEAXI_CR1_RMISSMRST_Msk                 /*!< Read Miss monitor reset */
#define CACHEAXI_CR1_WHITMEN_Pos              (20UL)
#define CACHEAXI_CR1_WHITMEN_Msk              (0x1UL << CACHEAXI_CR1_WHITMEN_Pos)        /*!< 0x00100000 */
#define CACHEAXI_CR1_WHITMEN                  CACHEAXI_CR1_WHITMEN_Msk                   /*!< Write Hit monitor enable */
#define CACHEAXI_CR1_WMISSMEN_Pos             (21UL)
#define CACHEAXI_CR1_WMISSMEN_Msk             (0x1UL << CACHEAXI_CR1_WMISSMEN_Pos)       /*!< 0x00200000 */
#define CACHEAXI_CR1_WMISSMEN                 CACHEAXI_CR1_WMISSMEN_Msk                  /*!< Write Miss monitor enable */
#define CACHEAXI_CR1_WHITMRST_Pos             (22UL)
#define CACHEAXI_CR1_WHITMRST_Msk             (0x1UL << CACHEAXI_CR1_WHITMRST_Pos)       /*!< 0x00400000 */
#define CACHEAXI_CR1_WHITMRST                 CACHEAXI_CR1_WHITMRST_Msk                  /*!< Write Hit monitor reset */
#define CACHEAXI_CR1_WMISSMRST_Pos            (23UL)
#define CACHEAXI_CR1_WMISSMRST_Msk            (0x1UL << CACHEAXI_CR1_WMISSMRST_Pos)      /*!< 0x00800000 */
#define CACHEAXI_CR1_WMISSMRST                CACHEAXI_CR1_WMISSMRST_Msk                 /*!< Write Miss monitor reset */
#define CACHEAXI_CR1_RAMMEN_Pos               (24UL)
#define CACHEAXI_CR1_RAMMEN_Msk               (0x1UL << CACHEAXI_CR1_RAMMEN_Pos)         /*!< 0x01000000 */
#define CACHEAXI_CR1_RAMMEN                   CACHEAXI_CR1_RAMMEN_Msk                    /*!< Read-allocate miss monitor enable */
#define CACHEAXI_CR1_WAMMEN_Pos               (25UL)
#define CACHEAXI_CR1_WAMMEN_Msk               (0x1UL << CACHEAXI_CR1_WAMMEN_Pos)         /*!< 0x02000000 */
#define CACHEAXI_CR1_WAMMEN                   CACHEAXI_CR1_WAMMEN_Msk                    /*!< Write-allocate miss monitor enable */
#define CACHEAXI_CR1_RAMMRST_Pos              (26UL)
#define CACHEAXI_CR1_RAMMRST_Msk              (0x1UL << CACHEAXI_CR1_RAMMRST_Pos)        /*!< 0x04000000 */
#define CACHEAXI_CR1_RAMMRST                  CACHEAXI_CR1_RAMMRST_Msk                   /*!< Read-allocate miss monitor reset */
#define CACHEAXI_CR1_WAMMRST_Pos              (27UL)
#define CACHEAXI_CR1_WAMMRST_Msk              (0x1UL << CACHEAXI_CR1_WAMMRST_Pos)        /*!< 0x08000000 */
#define CACHEAXI_CR1_WAMMRST                  CACHEAXI_CR1_WAMMRST_Msk                   /*!< Write-allocate miss monitor reset */
#define CACHEAXI_CR1_WTMEN_Pos                (28UL)
#define CACHEAXI_CR1_WTMEN_Msk                (0x1UL << CACHEAXI_CR1_WTMEN_Pos)          /*!< 0x10000000 */
#define CACHEAXI_CR1_WTMEN                    CACHEAXI_CR1_WTMEN_Msk                     /*!< Write-through monitor enable */
#define CACHEAXI_CR1_EVIMEN_Pos               (29UL)
#define CACHEAXI_CR1_EVIMEN_Msk               (0x1UL << CACHEAXI_CR1_EVIMEN_Pos)         /*!< 0x20000000 */
#define CACHEAXI_CR1_EVIMEN                   CACHEAXI_CR1_EVIMEN_Msk                    /*!< Eviction monitor enable */
#define CACHEAXI_CR1_WTMRST_Pos               (30UL)
#define CACHEAXI_CR1_WTMRST_Msk               (0x1UL << CACHEAXI_CR1_WTMRST_Pos)         /*!< 0x40000000 */
#define CACHEAXI_CR1_WTMRST                   CACHEAXI_CR1_WTMRST_Msk                    /*!< Write-through monitor reset */
#define CACHEAXI_CR1_EVIMRST_Pos              (31UL)
#define CACHEAXI_CR1_EVIMRST_Msk              (0x1UL << CACHEAXI_CR1_EVIMRST_Pos)        /*!< 0x80000000 */
#define CACHEAXI_CR1_EVIMRST                  CACHEAXI_CR1_EVIMRST_Msk                   /*!< Eviction monitor reset */

/******************  Bit definition for CACHEAXI_SR register  *******************/
#define CACHEAXI_SR_BUSYF_Pos                 (0UL)
#define CACHEAXI_SR_BUSYF_Msk                 (0x1UL << CACHEAXI_SR_BUSYF_Pos)           /*!< 0x00000001 */
#define CACHEAXI_SR_BUSYF                     CACHEAXI_SR_BUSYF_Msk                      /*!< Busy flag */
#define CACHEAXI_SR_BSYENDF_Pos               (1UL)
#define CACHEAXI_SR_BSYENDF_Msk               (0x1UL << CACHEAXI_SR_BSYENDF_Pos)         /*!< 0x00000002 */
#define CACHEAXI_SR_BSYENDF                   CACHEAXI_SR_BSYENDF_Msk                    /*!< Busy end flag */
#define CACHEAXI_SR_ERRF_Pos                  (2UL)
#define CACHEAXI_SR_ERRF_Msk                  (0x1UL << CACHEAXI_SR_ERRF_Pos)            /*!< 0x00000004 */
#define CACHEAXI_SR_ERRF                      CACHEAXI_SR_ERRF_Msk                       /*!< Cache error flag */
#define CACHEAXI_SR_BUSYCMDF_Pos              (3UL)
#define CACHEAXI_SR_BUSYCMDF_Msk              (0x1UL << CACHEAXI_SR_BUSYCMDF_Pos)        /*!< 0x00000008 */
#define CACHEAXI_SR_BUSYCMDF                  CACHEAXI_SR_BUSYCMDF_Msk                   /*!< Busy command flag */
#define CACHEAXI_SR_CMDENDF_Pos               (4UL)
#define CACHEAXI_SR_CMDENDF_Msk               (0x1UL << CACHEAXI_SR_CMDENDF_Pos)         /*!< 0x00000010 */
#define CACHEAXI_SR_CMDENDF                   CACHEAXI_SR_CMDENDF_Msk                    /*!< Command end flag */

/******************  Bit definition for CACHEAXI_IER register  ******************/
#define CACHEAXI_IER_BSYENDIE_Pos             (1UL)
#define CACHEAXI_IER_BSYENDIE_Msk             (0x1UL << CACHEAXI_IER_BSYENDIE_Pos)       /*!< 0x00000002 */
#define CACHEAXI_IER_BSYENDIE                 CACHEAXI_IER_BSYENDIE_Msk                  /*!< Busy end interrupt enable */
#define CACHEAXI_IER_ERRIE_Pos                (2UL)
#define CACHEAXI_IER_ERRIE_Msk                (0x1UL << CACHEAXI_IER_ERRIE_Pos)          /*!< 0x00000004 */
#define CACHEAXI_IER_ERRIE                    CACHEAXI_IER_ERRIE_Msk                     /*!< Cache error interrupt enable */
#define CACHEAXI_IER_CMDENDIE_Pos             (4UL)
#define CACHEAXI_IER_CMDENDIE_Msk             (0x1UL << CACHEAXI_IER_CMDENDIE_Pos)       /*!< 0x00000010 */
#define CACHEAXI_IER_CMDENDIE                 CACHEAXI_IER_CMDENDIE_Msk                  /*!< Command end interrupt enable */

/******************  Bit definition for CACHEAXI_FCR register  ******************/
#define CACHEAXI_FCR_CBSYENDF_Pos             (1UL)
#define CACHEAXI_FCR_CBSYENDF_Msk             (0x1UL << CACHEAXI_FCR_CBSYENDF_Pos)       /*!< 0x00000002 */
#define CACHEAXI_FCR_CBSYENDF                 CACHEAXI_FCR_CBSYENDF_Msk                  /*!< Busy end flag clear */
#define CACHEAXI_FCR_CERRF_Pos                (2UL)
#define CACHEAXI_FCR_CERRF_Msk                (0x1UL << CACHEAXI_FCR_CERRF_Pos)          /*!< 0x00000004 */
#define CACHEAXI_FCR_CERRF                    CACHEAXI_FCR_CERRF_Msk                     /*!< Cache error flag clear */
#define CACHEAXI_FCR_CCMDENDF_Pos             (4UL)
#define CACHEAXI_FCR_CCMDENDF_Msk             (0x1UL << CACHEAXI_FCR_CCMDENDF_Pos)       /*!< 0x00000010 */
#define CACHEAXI_FCR_CCMDENDF                 CACHEAXI_FCR_CCMDENDF_Msk                  /*!< Command end flag clear */

/******************  Bit definition for CACHEAXI_RHMONR register  ****************/
#define CACHEAXI_RHMONR_RHITMON_Pos           (0UL)
#define CACHEAXI_RHMONR_RHITMON_Msk           (0xFFFFFFFFUL << CACHEAXI_RHMONR_RHITMON_Pos)  /*!< 0xFFFFFFFF */
#define CACHEAXI_RHMONR_RHITMON               CACHEAXI_RHMONR_RHITMON_Msk                    /*!< Cache read hit monitor register */

/******************  Bit definition for CACHEAXI_RMMONR register  ****************/
#define CACHEAXI_RMMONR_RMISSMON_Pos          (0UL)
#define CACHEAXI_RMMONR_RMISSMON_Msk          (0xFFFFFFFFUL << CACHEAXI_RMMONR_RMISSMON_Pos) /*!< 0xFFFFFFFF */
#define CACHEAXI_RMMONR_RMISSMON              CACHEAXI_RMMONR_RMISSMON_Msk                   /*!< Cache read miss monitor register */

/******************  Bit definition for CACHEAXI_RAMMONR register  ****************/
#define CACHEAXI_RAMMONR_RAMMON_Pos           (0UL)
#define CACHEAXI_RAMMONR_RAMMON_Msk           (0xFFFFFFFFUL << CACHEAXI_RAMMONR_RAMMON_Pos)  /*!< 0xFFFFFFFF */
#define CACHEAXI_RAMMONR_RAMMON               CACHEAXI_RAMMONR_RAMMON_Msk                    /*!< Cache read-allocate miss monitor counter */

/******************  Bit definition for CACHEAXI_EVIMONR register  ****************/
#define CACHEAXI_EVIMONR_EVIMON_Pos           (0UL)
#define CACHEAXI_EVIMONR_EVIMON_Msk           (0xFFFFFFFFUL << CACHEAXI_EVIMONR_EVIMON_Pos)  /*!< 0xFFFFFFFF */
#define CACHEAXI_EVIMONR_EVIMON               CACHEAXI_EVIMONR_EVIMON_Msk                    /*!< Cache eviction monitor counter */

/******************  Bit definition for CACHEAXI_WHMONR register  ****************/
#define CACHEAXI_WHMONR_WHITMON_Pos           (0UL)
#define CACHEAXI_WHMONR_WHITMON_Msk           (0xFFFFFFFFUL << CACHEAXI_WHMONR_WHITMON_Pos)  /*!< 0xFFFFFFFF */
#define CACHEAXI_WHMONR_WHITMON               CACHEAXI_WHMONR_WHITMON_Msk                    /*!< Cache write hit monitor register */

/******************  Bit definition for CACHEAXI_WMMONR register  ****************/
#define CACHEAXI_WMMONR_WMISSMON_Pos          (0UL)
#define CACHEAXI_WMMONR_WMISSMON_Msk          (0xFFFFFFFFUL << CACHEAXI_WMMONR_WMISSMON_Pos) /*!< 0xFFFFFFFF */
#define CACHEAXI_WMMONR_WMISSMON              CACHEAXI_WMMONR_WMISSMON_Msk                   /*!< Cache write miss monitor register */

/******************  Bit definition for CACHEAXI_WAMMONR register  ****************/
#define CACHEAXI_WAMMONR_WAMMON_Pos           (0UL)
#define CACHEAXI_WAMMONR_WAMMON_Msk           (0xFFFFFFFFUL << CACHEAXI_WAMMONR_WAMMON_Pos)  /*!< 0xFFFFFFFF */
#define CACHEAXI_WAMMONR_WAMMON               CACHEAXI_WAMMONR_WAMMON_Msk                    /*!< Cache write-allocate miss monitor register */

/******************  Bit definition for CACHEAXI_WTMONR register  ****************/
#define CACHEAXI_WTMONR_WTMON_Pos             (0UL)
#define CACHEAXI_WTMONR_WTMON_Msk             (0xFFFFFFFFUL << CACHEAXI_WTMONR_WTMON_Pos)    /*!< 0xFFFFFFFF */
#define CACHEAXI_WTMONR_WTMON                 CACHEAXI_WTMONR_WTMON_Msk                      /*!< Cache write-through monitor register */

/****************  Bit definition for CACHEAXI_CR2 register  ******************/
#define CACHEAXI_CR2_STARTCMD_Pos             (0UL)
#define CACHEAXI_CR2_STARTCMD_Msk             (0x1UL << CACHEAXI_CR2_STARTCMD_Pos)           /*!< 0x00000001 */
#define CACHEAXI_CR2_STARTCMD                 CACHEAXI_CR2_STARTCMD_Msk                      /*!< Starts maintenance range command */
#define CACHEAXI_CR2_CACHECMD_Pos             (1UL)
#define CACHEAXI_CR2_CACHECMD_Msk             (0x3UL << CACHEAXI_CR2_CACHECMD_Pos)           /*!< 0x00000006 */
#define CACHEAXI_CR2_CACHECMD                 CACHEAXI_CR2_CACHECMD_Msk                      /*!< Cache command maintenance operation */
#define CACHEAXI_CR2_CACHECMD_0               (0x1UL << CACHEAXI_CR2_CACHECMD_Pos)           /*!< 0x00000002 */
#define CACHEAXI_CR2_CACHECMD_1               (0x2UL << CACHEAXI_CR2_CACHECMD_Pos)           /*!< 0x00000004 */

/******************  Bit definition for CACHEAXI_CMDRSADDRR register  ****************/
#define CACHEAXI_CMDRSADDRR_CMDSTARTADDR_Pos  (0UL)
#define CACHEAXI_CMDRSADDRR_CMDSTARTADDR_Msk  (0xFFFFFFC0UL << CACHEAXI_CMDRSADDRR_CMDSTARTADDR_Pos) /*!< 0xFFFFFFC0 */
#define CACHEAXI_CMDRSADDRR_CMDSTARTADDR      CACHEAXI_CMDRSADDRR_CMDSTARTADDR_Msk           /*!< Command start address */

/******************  Bit definition for CACHEAXI_CMDREADDRR register  ****************/
#define CACHEAXI_CMDREADDRR_CMDENDADDR_Pos    (0UL)
#define CACHEAXI_CMDREADDRR_CMDENDADDR_Msk    (0xFFFFFFC0UL << CACHEAXI_CMDREADDRR_CMDENDADDR_Pos)   /*!< 0xFFFFFFC0 */
#define CACHEAXI_CMDREADDRR_CMDENDADDR        CACHEAXI_CMDREADDRR_CMDENDADDR_Msk             /*!< Command end address */


/******************************************************************************/
/*                                                                            */
/*                          CRC calculation unit                              */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for CRC_DR register  *********************/
#define CRC_DR_DR_Pos              (0UL)
#define CRC_DR_DR_Msk              (0xFFFFFFFFUL << CRC_DR_DR_Pos)             /*!< 0xFFFFFFFF */
#define CRC_DR_DR                  CRC_DR_DR_Msk                               /*!< Data register bits */

/*******************  Bit definition for CRC_IDR register  ********************/
#define CRC_IDR_IDR_Pos            (0UL)
#define CRC_IDR_IDR_Msk            (0xFFFFFFFFUL << CRC_IDR_IDR_Pos)           /*!< 0xFFFFFFFF */
#define CRC_IDR_IDR                CRC_IDR_IDR_Msk                             /*!< General-purpose 32-bits data register bits */

/********************  Bit definition for CRC_CR register  ********************/
#define CRC_CR_RESET_Pos           (0UL)
#define CRC_CR_RESET_Msk           (0x1UL << CRC_CR_RESET_Pos)                 /*!< 0x00000001 */
#define CRC_CR_RESET               CRC_CR_RESET_Msk                            /*!< RESET the CRC computation unit bit */
#define CRC_CR_POLYSIZE_Pos        (3UL)
#define CRC_CR_POLYSIZE_Msk        (0x3UL << CRC_CR_POLYSIZE_Pos)              /*!< 0x00000018 */
#define CRC_CR_POLYSIZE            CRC_CR_POLYSIZE_Msk                         /*!< Polynomial size bits */
#define CRC_CR_POLYSIZE_0          (0x1UL << CRC_CR_POLYSIZE_Pos)              /*!< 0x00000008 */
#define CRC_CR_POLYSIZE_1          (0x2UL << CRC_CR_POLYSIZE_Pos)              /*!< 0x00000010 */
#define CRC_CR_REV_IN_Pos          (5UL)
#define CRC_CR_REV_IN_Msk          (0x3UL << CRC_CR_REV_IN_Pos)                /*!< 0x00000060 */
#define CRC_CR_REV_IN              CRC_CR_REV_IN_Msk                           /*!< REV_IN Reverse Input Data bits */
#define CRC_CR_REV_IN_0            (0x1UL << CRC_CR_REV_IN_Pos)                /*!< 0x00000020 */
#define CRC_CR_REV_IN_1            (0x2UL << CRC_CR_REV_IN_Pos)                /*!< 0x00000040 */
#define CRC_CR_REV_OUT_Pos         (7UL)
#define CRC_CR_REV_OUT_Msk         (0x3UL << CRC_CR_REV_OUT_Pos)               /*!< 0x00000180 */
#define CRC_CR_REV_OUT             CRC_CR_REV_OUT_Msk                          /*!< REV_OUT Reverse Output Data bits */
#define CRC_CR_REV_OUT_0           (0x1UL << CRC_CR_REV_OUT_Pos)               /*!< 0x00000080 */
#define CRC_CR_REV_OUT_1           (0x2UL << CRC_CR_REV_OUT_Pos)               /*!< 0x00000100 */
#define CRC_CR_RTYPE_IN_Pos        (9UL)
#define CRC_CR_RTYPE_IN_Msk        (0x1UL << CRC_CR_RTYPE_IN_Pos)              /*!< 0x00000200 */
#define CRC_CR_RTYPE_IN            CRC_CR_RTYPE_IN_Msk                         /*!< Reverse type input */
#define CRC_CR_RTYPE_OUT_Pos       (10UL)
#define CRC_CR_RTYPE_OUT_Msk       (0x1UL << CRC_CR_RTYPE_OUT_Pos)             /*!< 0x00000400 */
#define CRC_CR_RTYPE_OUT           CRC_CR_RTYPE_OUT_Msk                        /*!< Reverse type output*/

/*******************  Bit definition for CRC_INIT register  *******************/
#define CRC_INIT_INIT_Pos          (0UL)
#define CRC_INIT_INIT_Msk          (0xFFFFFFFFUL << CRC_INIT_INIT_Pos)         /*!< 0xFFFFFFFF */
#define CRC_INIT_INIT              CRC_INIT_INIT_Msk                           /*!< Initial CRC value bits */

/*******************  Bit definition for CRC_POL register  ********************/
#define CRC_POL_POL_Pos            (0UL)
#define CRC_POL_POL_Msk            (0xFFFFFFFFUL << CRC_POL_POL_Pos)           /*!< 0xFFFFFFFF */
#define CRC_POL_POL                CRC_POL_POL_Msk                             /*!< Coefficients of the polynomial */


/******************************************************************************/
/*                                                                            */
/*                             Cryp Processor                                 */
/*                                                                            */
/******************************************************************************/
/******************* Bits definition for CRYP_CR register  ********************/
#define CRYP_CR_ALGODIR_Pos              (2UL)
#define CRYP_CR_ALGODIR_Msk              (0x1UL << CRYP_CR_ALGODIR_Pos)           /*!< 0x00000004 */
#define CRYP_CR_ALGODIR                  CRYP_CR_ALGODIR_Msk                      /*!< Algorithm direction (Encrypt/Decrypt) */

#define CRYP_CR_ALGOMODE_Pos             (3UL)
#define CRYP_CR_ALGOMODE_Msk             (0x10007UL << CRYP_CR_ALGOMODE_Pos)      /*!< 0x00080038 */
#define CRYP_CR_ALGOMODE                 CRYP_CR_ALGOMODE_Msk                     /*!< Algorithm mode */
#define CRYP_CR_ALGOMODE_0               (0x00001UL << CRYP_CR_ALGOMODE_Pos)      /*!< 0x00000008 */
#define CRYP_CR_ALGOMODE_1               (0x00002UL << CRYP_CR_ALGOMODE_Pos)      /*!< 0x00000010 */
#define CRYP_CR_ALGOMODE_2               (0x00004UL << CRYP_CR_ALGOMODE_Pos)      /*!< 0x00000020 */
#define CRYP_CR_ALGOMODE_3               (0x10000UL << CRYP_CR_ALGOMODE_Pos)      /*!< 0x00080000 */
#define CRYP_CR_ALGOMODE_AES_ECB_Pos     (5UL)
#define CRYP_CR_ALGOMODE_AES_ECB_Msk     (0x1UL << CRYP_CR_ALGOMODE_AES_ECB_Pos)  /*!< 0x00000020 */
#define CRYP_CR_ALGOMODE_AES_ECB         CRYP_CR_ALGOMODE_AES_ECB_Msk
#define CRYP_CR_ALGOMODE_AES_CBC_Pos     (3UL)
#define CRYP_CR_ALGOMODE_AES_CBC_Msk     (0x5UL << CRYP_CR_ALGOMODE_AES_CBC_Pos)  /*!< 0x00000028 */
#define CRYP_CR_ALGOMODE_AES_CBC         CRYP_CR_ALGOMODE_AES_CBC_Msk
#define CRYP_CR_ALGOMODE_AES_CTR_Pos     (4UL)
#define CRYP_CR_ALGOMODE_AES_CTR_Msk     (0x3UL << CRYP_CR_ALGOMODE_AES_CTR_Pos)  /*!< 0x00000030 */
#define CRYP_CR_ALGOMODE_AES_CTR         CRYP_CR_ALGOMODE_AES_CTR_Msk
#define CRYP_CR_ALGOMODE_AES_KEY_Pos     (3UL)
#define CRYP_CR_ALGOMODE_AES_KEY_Msk     (0x7UL << CRYP_CR_ALGOMODE_AES_KEY_Pos)  /*!< 0x00000038 */
#define CRYP_CR_ALGOMODE_AES_KEY         CRYP_CR_ALGOMODE_AES_KEY_Msk
#define CRYP_CR_ALGOMODE_AES_GCM_Pos     (19UL)
#define CRYP_CR_ALGOMODE_AES_GCM_Msk     (0x1UL << CRYP_CR_ALGOMODE_AES_GCM_Pos)  /*!< 0x00080000 */
#define CRYP_CR_ALGOMODE_AES_GCM         CRYP_CR_ALGOMODE_AES_GCM_Msk
#define CRYP_CR_ALGOMODE_AES_CCM_Pos     (3UL)
#define CRYP_CR_ALGOMODE_AES_CCM_Msk     (0x10001UL << CRYP_CR_ALGOMODE_AES_CCM_Pos) /*!< 0x00080008 */
#define CRYP_CR_ALGOMODE_AES_CCM         CRYP_CR_ALGOMODE_AES_CCM_Msk

#define CRYP_CR_DATATYPE_Pos             (6UL)
#define CRYP_CR_DATATYPE_Msk             (0x3UL << CRYP_CR_DATATYPE_Pos)          /*!< 0x000000C0 */
#define CRYP_CR_DATATYPE                 CRYP_CR_DATATYPE_Msk                     /*!< Data Type selection */
#define CRYP_CR_DATATYPE_0               (0x1UL << CRYP_CR_DATATYPE_Pos)          /*!< 0x00000040 */
#define CRYP_CR_DATATYPE_1               (0x2UL << CRYP_CR_DATATYPE_Pos)          /*!< 0x00000080 */
#define CRYP_CR_KEYSIZE_Pos              (8UL)
#define CRYP_CR_KEYSIZE_Msk              (0x3UL << CRYP_CR_KEYSIZE_Pos)           /*!< 0x00000300 */
#define CRYP_CR_KEYSIZE                  CRYP_CR_KEYSIZE_Msk                      /*!< Key Size selection */
#define CRYP_CR_KEYSIZE_0                (0x1UL << CRYP_CR_KEYSIZE_Pos)           /*!< 0x00000100 */
#define CRYP_CR_KEYSIZE_1                (0x2UL << CRYP_CR_KEYSIZE_Pos)           /*!< 0x00000200 */
#define CRYP_CR_FFLUSH_Pos               (14UL)
#define CRYP_CR_FFLUSH_Msk               (0x1UL << CRYP_CR_FFLUSH_Pos)            /*!< 0x00004000 */
#define CRYP_CR_FFLUSH                   CRYP_CR_FFLUSH_Msk                       /*!< CRYP FIFO Flush */
#define CRYP_CR_CRYPEN_Pos               (15UL)
#define CRYP_CR_CRYPEN_Msk               (0x1UL << CRYP_CR_CRYPEN_Pos)            /*!< 0x00008000 */
#define CRYP_CR_CRYPEN                   CRYP_CR_CRYPEN_Msk                       /*!< CRYP processor enable */

#define CRYP_CR_GCM_CCMPH_Pos            (16UL)
#define CRYP_CR_GCM_CCMPH_Msk            (0x3UL << CRYP_CR_GCM_CCMPH_Pos)         /*!< 0x00030000 */
#define CRYP_CR_GCM_CCMPH                CRYP_CR_GCM_CCMPH_Msk                    /*!< GCM or CCM Phase selection */
#define CRYP_CR_GCM_CCMPH_0              (0x1UL << CRYP_CR_GCM_CCMPH_Pos)         /*!< 0x00010000 */
#define CRYP_CR_GCM_CCMPH_1              (0x2UL << CRYP_CR_GCM_CCMPH_Pos)         /*!< 0x00020000 */

#define CRYP_CR_NPBLB_Pos                (20UL)
#define CRYP_CR_NPBLB_Msk                (0xFUL << CRYP_CR_NPBLB_Pos)             /*!< 0x00F00000 */
#define CRYP_CR_NPBLB                    CRYP_CR_NPBLB_Msk                        /*!< Number of Padding Bytes in Last Block of payload */

#define CRYP_CR_KMOD_Pos                (24UL)
#define CRYP_CR_KMOD_Msk                (0x3UL << CRYP_CR_KMOD_Pos)               /*!< 0x03000000 */
#define CRYP_CR_KMOD                    CRYP_CR_KMOD_Msk                          /*!< Key mode selection */
#define CRYP_CR_KMOD_0                  (0x1UL << CRYP_CR_KMOD_Pos)               /*!< 0x01000000 */
#define CRYP_CR_KMOD_1                  (0x2UL << CRYP_CR_KMOD_Pos)               /*!< 0x02000000 */

#define CRYP_CR_IPRST_Pos               (31UL)
#define CRYP_CR_IPRST_Msk               (0x1UL << CRYP_CR_IPRST_Pos)              /*!< 0x80000000 */
#define CRYP_CR_IPRST                   CRYP_CR_IPRST_Msk                         /*!< CRYP peripheral software reset */

/****************** Bits definition for CRYP_SR register  *********************/
#define CRYP_SR_IFEM_Pos                 (0UL)
#define CRYP_SR_IFEM_Msk                 (0x1UL << CRYP_SR_IFEM_Pos)              /*!< 0x00000001 */
#define CRYP_SR_IFEM                     CRYP_SR_IFEM_Msk                         /*!< Input FIFO empty flag */
#define CRYP_SR_IFNF_Pos                 (1UL)
#define CRYP_SR_IFNF_Msk                 (0x1UL << CRYP_SR_IFNF_Pos)              /*!< 0x00000002 */
#define CRYP_SR_IFNF                     CRYP_SR_IFNF_Msk                         /*!< Input FIFO not full flag */
#define CRYP_SR_OFNE_Pos                 (2UL)
#define CRYP_SR_OFNE_Msk                 (0x1UL << CRYP_SR_OFNE_Pos)              /*!< 0x00000004 */
#define CRYP_SR_OFNE                     CRYP_SR_OFNE_Msk                         /*!< Output FIFO not empty flag */
#define CRYP_SR_OFFU_Pos                 (3UL)
#define CRYP_SR_OFFU_Msk                 (0x1UL << CRYP_SR_OFFU_Pos)              /*!< 0x00000008 */
#define CRYP_SR_OFFU                     CRYP_SR_OFFU_Msk                         /*!< Output FIFO full flag */
#define CRYP_SR_BUSY_Pos                 (4UL)
#define CRYP_SR_BUSY_Msk                 (0x1UL << CRYP_SR_BUSY_Pos)              /*!< 0x00000010 */
#define CRYP_SR_BUSY                     CRYP_SR_BUSY_Msk                         /*!< Busy bit */
#define CRYP_SR_KERF_Pos                 (6UL)
#define CRYP_SR_KERF_Msk                 (0x1UL << CRYP_SR_KERF_Pos)              /*!< 0x00000040 */
#define CRYP_SR_KERF                     CRYP_SR_KERF_Msk                         /*!< Key error flag */
#define CRYP_SR_KEYVALID_Pos             (7UL)
#define CRYP_SR_KEYVALID_Msk             (0x1UL << CRYP_SR_KEYVALID_Pos)          /*!< 0x00000080 */
#define CRYP_SR_KEYVALID                 CRYP_SR_KEYVALID_Msk                     /*!< Key valid flag */

/*******************  Bit definition for CRYP_DIN register  *******************/
#define CRYP_DIN_DATAIN_Pos              (0UL)
#define CRYP_DIN_DATAIN_Msk              (0xFFFFFFFFUL << CRYP_DIN_DATAIN_Pos)    /*!< 0xFFFFFFFF */
#define CRYP_DIN_DATAIN                  CRYP_DIN_DATAIN_Msk                      /*!< CRYP Data Input */

/*******************  Bit definition for CRYP_DIN register  *******************/
#define CRYP_DOUT_DATAOUT_Pos            (0UL)
#define CRYP_DOUT_DATAOUT_Msk            (0xFFFFFFFFUL << CRYP_DOUT_DATAOUT_Pos)  /*!< 0xFFFFFFFF */
#define CRYP_DOUT_DATAOUT                CRYP_DOUT_DATAOUT_Msk                    /*!< CRYP Data Output */

/****************** Bits definition for CRYP_DMACR register  ******************/
#define CRYP_DMACR_DIEN_Pos              (0UL)
#define CRYP_DMACR_DIEN_Msk              (0x1UL << CRYP_DMACR_DIEN_Pos)           /*!< 0x00000001 */
#define CRYP_DMACR_DIEN                  CRYP_DMACR_DIEN_Msk                      /*!< DMA Input Enable */
#define CRYP_DMACR_DOEN_Pos              (1UL)
#define CRYP_DMACR_DOEN_Msk              (0x1UL << CRYP_DMACR_DOEN_Pos)           /*!< 0x00000002 */
#define CRYP_DMACR_DOEN                  CRYP_DMACR_DOEN_Msk                      /*!< DMA Output Enable */

/*****************  Bits definition for CRYP_IMSCR register  ******************/
#define CRYP_IMSCR_INIM_Pos              (0UL)
#define CRYP_IMSCR_INIM_Msk              (0x1UL << CRYP_IMSCR_INIM_Pos)           /*!< 0x00000001 */
#define CRYP_IMSCR_INIM                  CRYP_IMSCR_INIM_Msk                      /*!< Input FIFO service interrupt mask */
#define CRYP_IMSCR_OUTIM_Pos             (1UL)
#define CRYP_IMSCR_OUTIM_Msk             (0x1UL << CRYP_IMSCR_OUTIM_Pos)          /*!< 0x00000002 */
#define CRYP_IMSCR_OUTIM                 CRYP_IMSCR_OUTIM_Msk                     /*!< Output FIFO service interrupt mask */

/****************** Bits definition for CRYP_RISR register  *******************/
#define CRYP_RISR_INRIS_Pos              (0UL)
#define CRYP_RISR_INRIS_Msk              (0x1UL << CRYP_RISR_INRIS_Pos)           /*!< 0x00000001 */
#define CRYP_RISR_INRIS                  CRYP_RISR_INRIS_Msk                      /*!< Input FIFO service raw interrupt status */
#define CRYP_RISR_OUTRIS_Pos             (1UL)
#define CRYP_RISR_OUTRIS_Msk             (0x1UL << CRYP_RISR_OUTRIS_Pos)          /*!< 0x00000002 */
#define CRYP_RISR_OUTRIS                 CRYP_RISR_OUTRIS_Msk                     /*!< Output FIFO service raw interrupt mask */

/****************** Bits definition for CRYP_MISR register  *******************/
#define CRYP_MISR_INMIS_Pos              (0UL)
#define CRYP_MISR_INMIS_Msk              (0x1UL << CRYP_MISR_INMIS_Pos)           /*!< 0x00000001 */
#define CRYP_MISR_INMIS                  CRYP_MISR_INMIS_Msk                      /*!< Input FIFO service masked interrupt status */
#define CRYP_MISR_OUTMIS_Pos             (1UL)
#define CRYP_MISR_OUTMIS_Msk             (0x1UL << CRYP_MISR_OUTMIS_Pos)          /*!< 0x00000002 */
#define CRYP_MISR_OUTMIS                 CRYP_MISR_OUTMIS_Msk                     /*!< Output FIFO service masked interrupt status */

/*******************  Bit definition for CRYP_K0LR register  ******************/
#define CRYP_K0LR_K_Pos                  (0UL)
#define CRYP_K0LR_K_Msk                  (0xFFFFFFFFUL << CRYP_K0LR_K_Pos)        /*!< 0xFFFFFFFF */
#define CRYP_K0LR_K                      CRYP_K0LR_K_Msk                          /*!< AES key bit x (x= 224 to 255) */

/*******************  Bit definition for CRYP_K0RR register  ******************/
#define CRYP_K0RR_K_Pos                  (0UL)
#define CRYP_K0RR_K_Msk                  (0xFFFFFFFFUL << CRYP_K0RR_K_Pos)        /*!< 0xFFFFFFFF */
#define CRYP_K0RR_K                      CRYP_K0RR_K_Msk                          /*!< AES key bit x (x= 192 to 223) */

/*******************  Bit definition for CRYP_IV1LR register  ******************/
#define CRYP_IV1LR_K_Pos                  (0UL)
#define CRYP_IV1LR_K_Msk                  (0xFFFFFFFFUL << CRYP_IV1LR_K_Pos)        /*!< 0xFFFFFFFF */
#define CRYP_IV1LR_K                      CRYP_IV1LR_K_Msk                          /*!< AES key bit x (x= 160 to 291) */

/*******************  Bit definition for CRYP_IV1RR register  ******************/
#define CRYP_IV1RR_K_Pos                  (0UL)
#define CRYP_IV1RR_K_Msk                  (0xFFFFFFFFUL << CRYP_IV1RR_K_Pos)        /*!< 0xFFFFFFFF */
#define CRYP_IV1RR_K                      CRYP_IV1RR_K_Msk                          /*!< AES key bit x (x= 128 to 159) */

/*******************  Bit definition for CRYP_K2LR register  ******************/
#define CRYP_K2LR_K_Pos                  (0UL)
#define CRYP_K2LR_K_Msk                  (0xFFFFFFFFUL << CRYP_K2LR_K_Pos)        /*!< 0xFFFFFFFF */
#define CRYP_K2LR_K                      CRYP_K2LR_K_Msk                          /*!< AES key bit x (x= 96 to 127) */

/*******************  Bit definition for CRYP_K2RR register  ******************/
#define CRYP_K2RR_K_Pos                  (0UL)
#define CRYP_K2RR_K_Msk                  (0xFFFFFFFFUL << CRYP_K2RR_K_Pos)        /*!< 0xFFFFFFFF */
#define CRYP_K2RR_K                      CRYP_K2RR_K_Msk                          /*!< AES key bit x (x= 64 to 95) */

/*******************  Bit definition for CRYP_K3LR register  ******************/
#define CRYP_K3LR_K_Pos                  (0UL)
#define CRYP_K3LR_K_Msk                  (0xFFFFFFFFUL << CRYP_K3LR_K_Pos)        /*!< 0xFFFFFFFF */
#define CRYP_K3LR_K                      CRYP_K3LR_K_Msk                          /*!< AES key bit x (x= 32 to 63) */

/*******************  Bit definition for CRYP_K3RR register  ******************/
#define CRYP_K3RR_K_Pos                  (0UL)
#define CRYP_K3RR_K_Msk                  (0xFFFFFFFFUL << CRYP_K3RR_K_Pos)        /*!< 0xFFFFFFFF */
#define CRYP_K3RR_K                      CRYP_K3RR_K_Msk                          /*!< AES key bit x (x= 0 to 31) */

/*******************  Bit definition for CRYP_IV0LR register  ******************/
#define CRYP_IV0LR_IV_Pos                (0UL)
#define CRYP_IV0LR_IV_Msk                (0xFFFFFFFFUL << CRYP_IV0LR_IV_Pos)      /*!< 0xFFFFFFFF */
#define CRYP_IV0LR_IV                    CRYP_IV0LR_IV_Msk                        /*!< Initialization vector bit x (x= 0 to 31) */

/*******************  Bit definition for CRYP_IV0RR register  ******************/
#define CRYP_IV0RR_IV_Pos                (0UL)
#define CRYP_IV0RR_IV_Msk                (0xFFFFFFFFUL << CRYP_IV0RR_IV_Pos)      /*!< 0xFFFFFFFF */
#define CRYP_IV0RR_IV                    CRYP_IV0RR_IV_Msk                        /*!< Initialization vector bit x (x= 32 to 63) */

/*******************  Bit definition for CRYP_IV1LR register  ******************/
#define CRYP_IV1LR_IV_Pos                (0UL)
#define CRYP_IV1LR_IV_Msk                (0xFFFFFFFFUL << CRYP_IV1LR_IV_Pos)      /*!< 0xFFFFFFFF */
#define CRYP_IV1LR_IV                    CRYP_IV1LR_IV_Msk                        /*!< Initialization vector bit x (x= 64 to 95) */

/*******************  Bit definition for CRYP_IV1RR register  ******************/
#define CRYP_IV1RR_IV_Pos                (0UL)
#define CRYP_IV1RR_IV_Msk                (0xFFFFFFFFUL << CRYP_IV1RR_IV_Pos)      /*!< 0xFFFFFFFF */
#define CRYP_IV1RR_IV                    CRYP_IV1RR_IV_Msk                        /*!< Initialization vector bit x (x= 96 to 127) */

/*******************  Bit definition for CRYP_CSGCMCCM0R register  ******************/
#define CRYP_CSGCMCCM0R_CSGCMCCM0_Pos          (0UL)
#define CRYP_CSGCMCCM0R_CSGCMCCM0_Msk          (0xFFFFFFFFUL << CRYP_CSGCMCCM0R_CSGCMCCM0_Pos) /*!< 0xFFFFFFFF */
#define CRYP_CSGCMCCM0R_CSGCMCCM0              CRYP_CSGCMCCM0R_CSGCMCCM0_Msk                   /*!< CRYP internal state registers for GCM, GMAC and CCM modes */

/*******************  Bit definition for CRYP_CSGCMCCM1R register  ******************/
#define CRYP_CSGCMCCM1R_CSGCMCCM1_Pos          (0UL)
#define CRYP_CSGCMCCM1R_CSGCMCCM1_Msk          (0xFFFFFFFFUL << CRYP_CSGCMCCM1R_CSGCMCCM1_Pos) /*!< 0xFFFFFFFF */
#define CRYP_CSGCMCCM1R_CSGCMCCM1              CRYP_CSGCMCCM1R_CSGCMCCM1_Msk                   /*!< CRYP internal state registers for GCM, GMAC and CCM modes */

/*******************  Bit definition for CRYP_CSGCMCCM2R register  ******************/
#define CRYP_CSGCMCCM2R_CSGCMCCM2_Pos          (0UL)
#define CRYP_CSGCMCCM2R_CSGCMCCM2_Msk          (0xFFFFFFFFUL << CRYP_CSGCMCCM2R_CSGCMCCM2_Pos) /*!< 0xFFFFFFFF */
#define CRYP_CSGCMCCM2R_CSGCMCCM2              CRYP_CSGCMCCM2R_CSGCMCCM2_Msk                   /*!< CRYP internal state registers for GCM, GMAC and CCM modes */

/*******************  Bit definition for CRYP_CSGCMCCM3R register  ******************/
#define CRYP_CSGCMCCM3R_CSGCMCCM3_Pos          (0UL)
#define CRYP_CSGCMCCM3R_CSGCMCCM3_Msk          (0xFFFFFFFFUL << CRYP_CSGCMCCM3R_CSGCMCCM3_Pos) /*!< 0xFFFFFFFF */
#define CRYP_CSGCMCCM3R_CSGCMCCM3              CRYP_CSGCMCCM3R_CSGCMCCM3_Msk                   /*!< CRYP internal state registers for GCM, GMAC and CCM modes */

/*******************  Bit definition for CRYP_CSGCMCCM4R register  ******************/
#define CRYP_CSGCMCCM4R_CSGCMCCM4_Pos          (0UL)
#define CRYP_CSGCMCCM4R_CSGCMCCM4_Msk          (0xFFFFFFFFUL << CRYP_CSGCMCCM4R_CSGCMCCM4_Pos) /*!< 0xFFFFFFFF */
#define CRYP_CSGCMCCM4R_CSGCMCCM4              CRYP_CSGCMCCM4R_CSGCMCCM4_Msk                   /*!< CRYP internal state registers for GCM, GMAC and CCM modes */

/*******************  Bit definition for CRYP_CSGCMCCM5R register  ******************/
#define CRYP_CSGCMCCM5R_CSGCMCCM5_Pos          (0UL)
#define CRYP_CSGCMCCM5R_CSGCMCCM5_Msk          (0xFFFFFFFFUL << CRYP_CSGCMCCM5R_CSGCMCCM5_Pos) /*!< 0xFFFFFFFF */
#define CRYP_CSGCMCCM5R_CSGCMCCM5              CRYP_CSGCMCCM5R_CSGCMCCM5_Msk                   /*!< CRYP internal state registers for GCM, GMAC and CCM modes */

/*******************  Bit definition for CRYP_CSGCMCCM6R register  ******************/
#define CRYP_CSGCMCCM6R_CSGCMCCM6_Pos          (0UL)
#define CRYP_CSGCMCCM6R_CSGCMCCM6_Msk          (0xFFFFFFFFUL << CRYP_CSGCMCCM6R_CSGCMCCM6_Pos) /*!< 0xFFFFFFFF */
#define CRYP_CSGCMCCM6R_CSGCMCCM6              CRYP_CSGCMCCM6R_CSGCMCCM6_Msk                   /*!< CRYP internal state registers for GCM, GMAC and CCM modes */

/*******************  Bit definition for CRYP_CSGCMCCM7R register  ******************/
#define CRYP_CSGCMCCM7R_CSGCMCCM7_Pos          (0UL)
#define CRYP_CSGCMCCM7R_CSGCMCCM7_Msk          (0xFFFFFFFFUL << CRYP_CSGCMCCM7R_CSGCMCCM7_Pos) /*!< 0xFFFFFFFF */
#define CRYP_CSGCMCCM7R_CSGCMCCM7              CRYP_CSGCMCCM7R_CSGCMCCM7_Msk                   /*!< CRYP internal state registers for GCM, GMAC and CCM modes */

/*******************  Bit definition for CRYP_CSGCM0R register  ******************/
#define CRYP_CSGCM0R_CSGCM0_Pos          (0UL)
#define CRYP_CSGCM0R_CSGCM0_Msk          (0xFFFFFFFFUL << CRYP_CSGCM0R_CSGCM0_Pos) /*!< 0xFFFFFFFF */
#define CRYP_CSGCM0R_CSGCM0              CRYP_CSGCM0R_CSGCM0_Msk                   /*!< CRYP internal state registers for GCM and GMAC modes */

/*******************  Bit definition for CRYP_CSGCM1R register  ******************/
#define CRYP_CSGCM1R_CSGCM1_Pos          (0UL)
#define CRYP_CSGCM1R_CSGCM1_Msk          (0xFFFFFFFFUL << CRYP_CSGCM1R_CSGCM1_Pos) /*!< 0xFFFFFFFF */
#define CRYP_CSGCM1R_CSGCM1              CRYP_CSGCM1R_CSGCM1_Msk                   /*!< CRYP internal state registers for GCM and GMAC modes */

/*******************  Bit definition for CRYP_CSGCM2R register  ******************/
#define CRYP_CSGCM2R_CSGCM2_Pos          (0UL)
#define CRYP_CSGCM2R_CSGCM2_Msk          (0xFFFFFFFFUL << CRYP_CSGCM2R_CSGCM2_Pos) /*!< 0xFFFFFFFF */
#define CRYP_CSGCM2R_CSGCM2              CRYP_CSGCM2R_CSGCM2_Msk                   /*!< CRYP internal state registers for GCM and GMAC modes */

/*******************  Bit definition for CRYP_CSGCM3R register  ******************/
#define CRYP_CSGCM3R_CSGCM3_Pos          (0UL)
#define CRYP_CSGCM3R_CSGCM3_Msk          (0xFFFFFFFFUL << CRYP_CSGCM3R_CSGCM3_Pos) /*!< 0xFFFFFFFF */
#define CRYP_CSGCM3R_CSGCM3              CRYP_CSGCM3R_CSGCM3_Msk                   /*!< CRYP internal state registers for GCM and GMAC modes */

/*******************  Bit definition for CRYP_CSGCM4R register  ******************/
#define CRYP_CSGCM4R_CSGCM4_Pos          (0UL)
#define CRYP_CSGCM4R_CSGCM4_Msk          (0xFFFFFFFFUL << CRYP_CSGCM4R_CSGCM4_Pos) /*!< 0xFFFFFFFF */
#define CRYP_CSGCM4R_CSGCM4              CRYP_CSGCM4R_CSGCM4_Msk                   /*!< CRYP internal state registers for GCM and GMAC modes */

/*******************  Bit definition for CRYP_CSGCM5R register  ******************/
#define CRYP_CSGCM5R_CSGCM5_Pos          (0UL)
#define CRYP_CSGCM5R_CSGCM5_Msk          (0xFFFFFFFFUL << CRYP_CSGCM5R_CSGCM5_Pos) /*!< 0xFFFFFFFF */
#define CRYP_CSGCM5R_CSGCM5              CRYP_CSGCM5R_CSGCM5_Msk                   /*!< CRYP internal state registers for GCM and GMAC modes */

/*******************  Bit definition for CRYP_CSGCM6R register  ******************/
#define CRYP_CSGCM6R_CSGCM6_Pos          (0UL)
#define CRYP_CSGCM6R_CSGCM6_Msk          (0xFFFFFFFFUL << CRYP_CSGCM6R_CSGCM6_Pos) /*!< 0xFFFFFFFF */
#define CRYP_CSGCM6R_CSGCM6              CRYP_CSGCM6R_CSGCM6_Msk                   /*!< CRYP internal state registers for GCM and GMAC modes */

/*******************  Bit definition for CRYP_CSGCM7R register  ******************/
#define CRYP_CSGCM7R_CSGCM7_Pos          (0UL)
#define CRYP_CSGCM7R_CSGCM7_Msk          (0xFFFFFFFFUL << CRYP_CSGCM7R_CSGCM7_Pos) /*!< 0xFFFFFFFF */
#define CRYP_CSGCM7R_CSGCM7              CRYP_CSGCM7R_CSGCM7_Msk                   /*!< CRYP internal state registers for GCM and GMAC modes */


/******************************************************************************/
/*                                                                            */
/*                                    (CSI)                                   */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for CSI_CR register  ********************/
#define CSI_CR_CSIEN_Pos                (0UL)
#define CSI_CR_CSIEN_Msk                (0x1UL << CSI_CR_CSIEN_Pos)               /*!< 0x00000001 */
#define CSI_CR_CSIEN                    CSI_CR_CSIEN_Msk                         /*!< CSI-2 enable */
#define CSI_CR_VC0START_Pos             (2UL)
#define CSI_CR_VC0START_Msk             (0x1UL << CSI_CR_VC0START_Pos)            /*!< 0x00000004 */
#define CSI_CR_VC0START                 CSI_CR_VC0START_Msk                      /*!< Virtual channel 0 start */
#define CSI_CR_VC0STOP_Pos              (3UL)
#define CSI_CR_VC0STOP_Msk              (0x1UL << CSI_CR_VC0STOP_Pos)             /*!< 0x00000008 */
#define CSI_CR_VC0STOP                  CSI_CR_VC0STOP_Msk                       /*!< Virtual channel 0 stop */
#define CSI_CR_VC1START_Pos             (6UL)
#define CSI_CR_VC1START_Msk             (0x1UL << CSI_CR_VC1START_Pos)            /*!< 0x00000040 */
#define CSI_CR_VC1START                 CSI_CR_VC1START_Msk                      /*!< Virtual channel 1 start */
#define CSI_CR_VC1STOP_Pos              (7UL)
#define CSI_CR_VC1STOP_Msk              (0x1UL << CSI_CR_VC1STOP_Pos)             /*!< 0x00000080 */
#define CSI_CR_VC1STOP                  CSI_CR_VC1STOP_Msk                       /*!< Virtual channel 1 stop */
#define CSI_CR_VC2START_Pos             (10UL)
#define CSI_CR_VC2START_Msk             (0x1UL << CSI_CR_VC2START_Pos)            /*!< 0x00000400 */
#define CSI_CR_VC2START                 CSI_CR_VC2START_Msk                      /*!< Virtual channel 2 start */
#define CSI_CR_VC2STOP_Pos              (11UL)
#define CSI_CR_VC2STOP_Msk              (0x1UL << CSI_CR_VC2STOP_Pos)             /*!< 0x00000800 */
#define CSI_CR_VC2STOP                  CSI_CR_VC2STOP_Msk                       /*!< Virtual channel 2 stop */
#define CSI_CR_VC3START_Pos             (14UL)
#define CSI_CR_VC3START_Msk             (0x1UL << CSI_CR_VC3START_Pos)            /*!< 0x00004000 */
#define CSI_CR_VC3START                 CSI_CR_VC3START_Msk                      /*!< Virtual channel 3 start */
#define CSI_CR_VC3STOP_Pos              (15UL)
#define CSI_CR_VC3STOP_Msk              (0x1UL << CSI_CR_VC3STOP_Pos)             /*!< 0x00008000 */
#define CSI_CR_VC3STOP                  CSI_CR_VC3STOP_Msk                       /*!< Virtual channel 3 stop */

/*******************  Bit definition for CSI_PCR register  ********************/
#define CSI_PCR_PWRDOWN_Pos             (0UL)
#define CSI_PCR_PWRDOWN_Msk             (0x1UL << CSI_PCR_PWRDOWN_Pos)            /*!< 0x00000001 */
#define CSI_PCR_PWRDOWN                 CSI_PCR_PWRDOWN_Msk                      /*!< Virtual channel 3 start */
#define CSI_PCR_CLEN_Pos                (1UL)
#define CSI_PCR_CLEN_Msk                (0x1UL << CSI_PCR_CLEN_Pos)               /*!< 0x00000002 */
#define CSI_PCR_CLEN                    CSI_PCR_CLEN_Msk                         /*!< Clock lane enable */
#define CSI_PCR_DL0EN_Pos               (2UL)
#define CSI_PCR_DL0EN_Msk               (0x1UL << CSI_PCR_DL0EN_Pos)              /*!< 0x00000004 */
#define CSI_PCR_DL0EN                   CSI_PCR_DL0EN_Msk                        /*!< D-PHY_RX data lane 0 enable */
#define CSI_PCR_DL1EN_Pos               (3UL)
#define CSI_PCR_DL1EN_Msk               (0x1UL << CSI_PCR_DL1EN_Pos)              /*!< 0x00000008 */
#define CSI_PCR_DL1EN                   CSI_PCR_DL1EN_Msk                        /*!< D-PHY_RX data lane 1 enable */

/*****************  Bit definition for CSI_VC0CFGR1 register  *****************/
#define CSI_VC0CFGR1_ALLDT_Pos          (0UL)
#define CSI_VC0CFGR1_ALLDT_Msk          (0x1UL << CSI_VC0CFGR1_ALLDT_Pos)         /*!< 0x00000001 */
#define CSI_VC0CFGR1_ALLDT              CSI_VC0CFGR1_ALLDT_Msk                   /*!< All data types enable for the virtual channel x */
#define CSI_VC0CFGR1_DT0EN_Pos          (1UL)
#define CSI_VC0CFGR1_DT0EN_Msk          (0x1UL << CSI_VC0CFGR1_DT0EN_Pos)         /*!< 0x00000002 */
#define CSI_VC0CFGR1_DT0EN              CSI_VC0CFGR1_DT0EN_Msk                   /*!< Data type 0 enable */
#define CSI_VC0CFGR1_DT1EN_Pos          (2UL)
#define CSI_VC0CFGR1_DT1EN_Msk          (0x1UL << CSI_VC0CFGR1_DT1EN_Pos)         /*!< 0x00000004 */
#define CSI_VC0CFGR1_DT1EN              CSI_VC0CFGR1_DT1EN_Msk                   /*!< Data type 1 enable */
#define CSI_VC0CFGR1_DT2EN_Pos          (3UL)
#define CSI_VC0CFGR1_DT2EN_Msk          (0x1UL << CSI_VC0CFGR1_DT2EN_Pos)         /*!< 0x00000008 */
#define CSI_VC0CFGR1_DT2EN              CSI_VC0CFGR1_DT2EN_Msk                   /*!< Data type 2 enable */
#define CSI_VC0CFGR1_DT3EN_Pos          (4UL)
#define CSI_VC0CFGR1_DT3EN_Msk          (0x1UL << CSI_VC0CFGR1_DT3EN_Pos)         /*!< 0x00000010 */
#define CSI_VC0CFGR1_DT3EN              CSI_VC0CFGR1_DT3EN_Msk                   /*!< Data type 3 enable */
#define CSI_VC0CFGR1_DT4EN_Pos          (5UL)
#define CSI_VC0CFGR1_DT4EN_Msk          (0x1UL << CSI_VC0CFGR1_DT4EN_Pos)         /*!< 0x00000020 */
#define CSI_VC0CFGR1_DT4EN              CSI_VC0CFGR1_DT4EN_Msk                   /*!< Data type 4 enable */
#define CSI_VC0CFGR1_DT5EN_Pos          (6UL)
#define CSI_VC0CFGR1_DT5EN_Msk          (0x1UL << CSI_VC0CFGR1_DT5EN_Pos)         /*!< 0x00000040 */
#define CSI_VC0CFGR1_DT5EN              CSI_VC0CFGR1_DT5EN_Msk                   /*!< Data type 5 enable */
#define CSI_VC0CFGR1_DT6EN_Pos          (7UL)
#define CSI_VC0CFGR1_DT6EN_Msk          (0x1UL << CSI_VC0CFGR1_DT6EN_Pos)         /*!< 0x00000080 */
#define CSI_VC0CFGR1_DT6EN              CSI_VC0CFGR1_DT6EN_Msk                   /*!< Data type 6 enable */
#define CSI_VC0CFGR1_CDTFT_Pos          (8UL)
#define CSI_VC0CFGR1_CDTFT_Msk          (0x1FUL << CSI_VC0CFGR1_CDTFT_Pos)        /*!< 0x00001F00 */
#define CSI_VC0CFGR1_CDTFT              CSI_VC0CFGR1_CDTFT_Msk                   /*!< Common format for all data types */
#define CSI_VC0CFGR1_DT0_Pos            (16UL)
#define CSI_VC0CFGR1_DT0_Msk            (0x3FUL << CSI_VC0CFGR1_DT0_Pos)          /*!< 0x003F0000 */
#define CSI_VC0CFGR1_DT0                CSI_VC0CFGR1_DT0_Msk                     /*!< Data type 0 class selection for virtual channel x */
#define CSI_VC0CFGR1_DT0FT_Pos          (24UL)
#define CSI_VC0CFGR1_DT0FT_Msk          (0x1FUL << CSI_VC0CFGR1_DT0FT_Pos)        /*!< 0x1F000000 */
#define CSI_VC0CFGR1_DT0FT              CSI_VC0CFGR1_DT0FT_Msk                   /*!< Data type 0 format */

/*****************  Bit definition for CSI_VC0CFGR2 register  *****************/
#define CSI_VC0CFGR2_DT1_Pos            (0UL)
#define CSI_VC0CFGR2_DT1_Msk            (0x3FUL << CSI_VC0CFGR2_DT1_Pos)          /*!< 0x0000003F */
#define CSI_VC0CFGR2_DT1                CSI_VC0CFGR2_DT1_Msk                     /*!< Data type 1 class selection for virtual channel x */
#define CSI_VC0CFGR2_DT1FT_Pos          (8UL)
#define CSI_VC0CFGR2_DT1FT_Msk          (0x1FUL << CSI_VC0CFGR2_DT1FT_Pos)        /*!< 0x00001F00 */
#define CSI_VC0CFGR2_DT1FT              CSI_VC0CFGR2_DT1FT_Msk                   /*!< Data type 1 format */
#define CSI_VC0CFGR2_DT2_Pos            (16UL)
#define CSI_VC0CFGR2_DT2_Msk            (0x3FUL << CSI_VC0CFGR2_DT2_Pos)          /*!< 0x003F0000 */
#define CSI_VC0CFGR2_DT2                CSI_VC0CFGR2_DT2_Msk                     /*!< Data type 2 class selection for virtual channel x */
#define CSI_VC0CFGR2_DT2FT_Pos          (24UL)
#define CSI_VC0CFGR2_DT2FT_Msk          (0x1FUL << CSI_VC0CFGR2_DT2FT_Pos)        /*!< 0x1F000000 */
#define CSI_VC0CFGR2_DT2FT              CSI_VC0CFGR2_DT2FT_Msk                   /*!< Data type 2 format */

/*****************  Bit definition for CSI_VC0CFGR3 register  *****************/
#define CSI_VC0CFGR3_DT3_Pos            (0UL)
#define CSI_VC0CFGR3_DT3_Msk            (0x3FUL << CSI_VC0CFGR3_DT3_Pos)          /*!< 0x0000003F */
#define CSI_VC0CFGR3_DT3                CSI_VC0CFGR3_DT3_Msk                     /*!< Data type 3 class selection for virtual channel x */
#define CSI_VC0CFGR3_DT3FT_Pos          (8UL)
#define CSI_VC0CFGR3_DT3FT_Msk          (0x1FUL << CSI_VC0CFGR3_DT3FT_Pos)        /*!< 0x00001F00 */
#define CSI_VC0CFGR3_DT3FT              CSI_VC0CFGR3_DT3FT_Msk                   /*!< Data type 3 format */
#define CSI_VC0CFGR3_DT4_Pos            (16UL)
#define CSI_VC0CFGR3_DT4_Msk            (0x3FUL << CSI_VC0CFGR3_DT4_Pos)          /*!< 0x003F0000 */
#define CSI_VC0CFGR3_DT4                CSI_VC0CFGR3_DT4_Msk                     /*!< Data type 4 class selection for virtual channel x */
#define CSI_VC0CFGR3_DT4FT_Pos          (24UL)
#define CSI_VC0CFGR3_DT4FT_Msk          (0x1FUL << CSI_VC0CFGR3_DT4FT_Pos)        /*!< 0x1F000000 */
#define CSI_VC0CFGR3_DT4FT              CSI_VC0CFGR3_DT4FT_Msk                   /*!< Data type 4 format */

/*****************  Bit definition for CSI_VC0CFGR4 register  *****************/
#define CSI_VC0CFGR4_DT5_Pos            (0UL)
#define CSI_VC0CFGR4_DT5_Msk            (0x3FUL << CSI_VC0CFGR4_DT5_Pos)          /*!< 0x0000003F */
#define CSI_VC0CFGR4_DT5                CSI_VC0CFGR4_DT5_Msk                     /*!< Data type 5 class selection for virtual channel x */
#define CSI_VC0CFGR4_DT5FT_Pos          (8UL)
#define CSI_VC0CFGR4_DT5FT_Msk          (0x1FUL << CSI_VC0CFGR4_DT5FT_Pos)        /*!< 0x00001F00 */
#define CSI_VC0CFGR4_DT5FT              CSI_VC0CFGR4_DT5FT_Msk                   /*!< Data type 5 format */
#define CSI_VC0CFGR4_DT6_Pos            (16UL)
#define CSI_VC0CFGR4_DT6_Msk            (0x3FUL << CSI_VC0CFGR4_DT6_Pos)          /*!< 0x003F0000 */
#define CSI_VC0CFGR4_DT6                CSI_VC0CFGR4_DT6_Msk                     /*!< Data type 6 class selection for virtual channel x */
#define CSI_VC0CFGR4_DT6FT_Pos          (24UL)
#define CSI_VC0CFGR4_DT6FT_Msk          (0x1FUL << CSI_VC0CFGR4_DT6FT_Pos)        /*!< 0x1F000000 */
#define CSI_VC0CFGR4_DT6FT              CSI_VC0CFGR4_DT6FT_Msk                   /*!< Data type 6 format */

/*****************  Bit definition for CSI_VC1CFGR1 register  *****************/
#define CSI_VC1CFGR1_ALLDT_Pos          (0UL)
#define CSI_VC1CFGR1_ALLDT_Msk          (0x1UL << CSI_VC1CFGR1_ALLDT_Pos)         /*!< 0x00000001 */
#define CSI_VC1CFGR1_ALLDT              CSI_VC1CFGR1_ALLDT_Msk                   /*!< All data types enable for the virtual channel x */
#define CSI_VC1CFGR1_DT0EN_Pos          (1UL)
#define CSI_VC1CFGR1_DT0EN_Msk          (0x1UL << CSI_VC1CFGR1_DT0EN_Pos)         /*!< 0x00000002 */
#define CSI_VC1CFGR1_DT0EN              CSI_VC1CFGR1_DT0EN_Msk                   /*!< Data type 0 enable */
#define CSI_VC1CFGR1_DT1EN_Pos          (2UL)
#define CSI_VC1CFGR1_DT1EN_Msk          (0x1UL << CSI_VC1CFGR1_DT1EN_Pos)         /*!< 0x00000004 */
#define CSI_VC1CFGR1_DT1EN              CSI_VC1CFGR1_DT1EN_Msk                   /*!< Data type 1 enable */
#define CSI_VC1CFGR1_DT2EN_Pos          (3UL)
#define CSI_VC1CFGR1_DT2EN_Msk          (0x1UL << CSI_VC1CFGR1_DT2EN_Pos)         /*!< 0x00000008 */
#define CSI_VC1CFGR1_DT2EN              CSI_VC1CFGR1_DT2EN_Msk                   /*!< Data type 2 enable */
#define CSI_VC1CFGR1_DT3EN_Pos          (4UL)
#define CSI_VC1CFGR1_DT3EN_Msk          (0x1UL << CSI_VC1CFGR1_DT3EN_Pos)         /*!< 0x00000010 */
#define CSI_VC1CFGR1_DT3EN              CSI_VC1CFGR1_DT3EN_Msk                   /*!< Data type 3 enable */
#define CSI_VC1CFGR1_DT4EN_Pos          (5UL)
#define CSI_VC1CFGR1_DT4EN_Msk          (0x1UL << CSI_VC1CFGR1_DT4EN_Pos)         /*!< 0x00000020 */
#define CSI_VC1CFGR1_DT4EN              CSI_VC1CFGR1_DT4EN_Msk                   /*!< Data type 4 enable */
#define CSI_VC1CFGR1_DT5EN_Pos          (6UL)
#define CSI_VC1CFGR1_DT5EN_Msk          (0x1UL << CSI_VC1CFGR1_DT5EN_Pos)         /*!< 0x00000040 */
#define CSI_VC1CFGR1_DT5EN              CSI_VC1CFGR1_DT5EN_Msk                   /*!< Data type 5 enable */
#define CSI_VC1CFGR1_DT6EN_Pos          (7UL)
#define CSI_VC1CFGR1_DT6EN_Msk          (0x1UL << CSI_VC1CFGR1_DT6EN_Pos)         /*!< 0x00000080 */
#define CSI_VC1CFGR1_DT6EN              CSI_VC1CFGR1_DT6EN_Msk                   /*!< Data type 6 enable */
#define CSI_VC1CFGR1_CDTFT_Pos          (8UL)
#define CSI_VC1CFGR1_CDTFT_Msk          (0x1FUL << CSI_VC1CFGR1_CDTFT_Pos)        /*!< 0x00001F00 */
#define CSI_VC1CFGR1_CDTFT              CSI_VC1CFGR1_CDTFT_Msk                   /*!< Common format for all data types */
#define CSI_VC1CFGR1_DT0_Pos            (16UL)
#define CSI_VC1CFGR1_DT0_Msk            (0x3FUL << CSI_VC1CFGR1_DT0_Pos)          /*!< 0x003F0000 */
#define CSI_VC1CFGR1_DT0                CSI_VC1CFGR1_DT0_Msk                     /*!< Data type 0 class selection for virtual channel x */
#define CSI_VC1CFGR1_DT0FT_Pos          (24UL)
#define CSI_VC1CFGR1_DT0FT_Msk          (0x1FUL << CSI_VC1CFGR1_DT0FT_Pos)        /*!< 0x1F000000 */
#define CSI_VC1CFGR1_DT0FT              CSI_VC1CFGR1_DT0FT_Msk                   /*!< Data type 0 format */

/*****************  Bit definition for CSI_VC1CFGR2 register  *****************/
#define CSI_VC1CFGR2_DT1_Pos            (0UL)
#define CSI_VC1CFGR2_DT1_Msk            (0x3FUL << CSI_VC1CFGR2_DT1_Pos)          /*!< 0x0000003F */
#define CSI_VC1CFGR2_DT1                CSI_VC1CFGR2_DT1_Msk                     /*!< Data type 1 class selection for virtual channel x */
#define CSI_VC1CFGR2_DT1FT_Pos          (8UL)
#define CSI_VC1CFGR2_DT1FT_Msk          (0x1FUL << CSI_VC1CFGR2_DT1FT_Pos)        /*!< 0x00001F00 */
#define CSI_VC1CFGR2_DT1FT              CSI_VC1CFGR2_DT1FT_Msk                   /*!< Data type 1 format */
#define CSI_VC1CFGR2_DT2_Pos            (16UL)
#define CSI_VC1CFGR2_DT2_Msk            (0x3FUL << CSI_VC1CFGR2_DT2_Pos)          /*!< 0x003F0000 */
#define CSI_VC1CFGR2_DT2                CSI_VC1CFGR2_DT2_Msk                     /*!< Data type 2 class selection for virtual channel x */
#define CSI_VC1CFGR2_DT2FT_Pos          (24UL)
#define CSI_VC1CFGR2_DT2FT_Msk          (0x1FUL << CSI_VC1CFGR2_DT2FT_Pos)        /*!< 0x1F000000 */
#define CSI_VC1CFGR2_DT2FT              CSI_VC1CFGR2_DT2FT_Msk                   /*!< Data type 2 format */

/*****************  Bit definition for CSI_VC1CFGR3 register  *****************/
#define CSI_VC1CFGR3_DT3_Pos            (0UL)
#define CSI_VC1CFGR3_DT3_Msk            (0x3FUL << CSI_VC1CFGR3_DT3_Pos)          /*!< 0x0000003F */
#define CSI_VC1CFGR3_DT3                CSI_VC1CFGR3_DT3_Msk                     /*!< Data type 3 class selection for virtual channel x */
#define CSI_VC1CFGR3_DT3FT_Pos          (8UL)
#define CSI_VC1CFGR3_DT3FT_Msk          (0x1FUL << CSI_VC1CFGR3_DT3FT_Pos)        /*!< 0x00001F00 */
#define CSI_VC1CFGR3_DT3FT              CSI_VC1CFGR3_DT3FT_Msk                   /*!< Data type 3 format */
#define CSI_VC1CFGR3_DT4_Pos            (16UL)
#define CSI_VC1CFGR3_DT4_Msk            (0x3FUL << CSI_VC1CFGR3_DT4_Pos)          /*!< 0x003F0000 */
#define CSI_VC1CFGR3_DT4                CSI_VC1CFGR3_DT4_Msk                     /*!< Data type 4 class selection for virtual channel x */
#define CSI_VC1CFGR3_DT4FT_Pos          (24UL)
#define CSI_VC1CFGR3_DT4FT_Msk          (0x1FUL << CSI_VC1CFGR3_DT4FT_Pos)        /*!< 0x1F000000 */
#define CSI_VC1CFGR3_DT4FT              CSI_VC1CFGR3_DT4FT_Msk                   /*!< Data type 4 format */

/*****************  Bit definition for CSI_VC1CFGR4 register  *****************/
#define CSI_VC1CFGR4_DT5_Pos            (0UL)
#define CSI_VC1CFGR4_DT5_Msk            (0x3FUL << CSI_VC1CFGR4_DT5_Pos)          /*!< 0x0000003F */
#define CSI_VC1CFGR4_DT5                CSI_VC1CFGR4_DT5_Msk                     /*!< Data type 5 class selection for virtual channel x */
#define CSI_VC1CFGR4_DT5FT_Pos          (8UL)
#define CSI_VC1CFGR4_DT5FT_Msk          (0x1FUL << CSI_VC1CFGR4_DT5FT_Pos)        /*!< 0x00001F00 */
#define CSI_VC1CFGR4_DT5FT              CSI_VC1CFGR4_DT5FT_Msk                   /*!< Data type 5 format */
#define CSI_VC1CFGR4_DT6_Pos            (16UL)
#define CSI_VC1CFGR4_DT6_Msk            (0x3FUL << CSI_VC1CFGR4_DT6_Pos)          /*!< 0x003F0000 */
#define CSI_VC1CFGR4_DT6                CSI_VC1CFGR4_DT6_Msk                     /*!< Data type 6 class selection for virtual channel x */
#define CSI_VC1CFGR4_DT6FT_Pos          (24UL)
#define CSI_VC1CFGR4_DT6FT_Msk          (0x1FUL << CSI_VC1CFGR4_DT6FT_Pos)        /*!< 0x1F000000 */
#define CSI_VC1CFGR4_DT6FT              CSI_VC1CFGR4_DT6FT_Msk                   /*!< Data type 6 format */

/*****************  Bit definition for CSI_VC2CFGR1 register  *****************/
#define CSI_VC2CFGR1_ALLDT_Pos          (0UL)
#define CSI_VC2CFGR1_ALLDT_Msk          (0x1UL << CSI_VC2CFGR1_ALLDT_Pos)         /*!< 0x00000001 */
#define CSI_VC2CFGR1_ALLDT              CSI_VC2CFGR1_ALLDT_Msk                   /*!< All data types enable for the virtual channel x */
#define CSI_VC2CFGR1_DT0EN_Pos          (1UL)
#define CSI_VC2CFGR1_DT0EN_Msk          (0x1UL << CSI_VC2CFGR1_DT0EN_Pos)         /*!< 0x00000002 */
#define CSI_VC2CFGR1_DT0EN              CSI_VC2CFGR1_DT0EN_Msk                   /*!< Data type 0 enable */
#define CSI_VC2CFGR1_DT1EN_Pos          (2UL)
#define CSI_VC2CFGR1_DT1EN_Msk          (0x1UL << CSI_VC2CFGR1_DT1EN_Pos)         /*!< 0x00000004 */
#define CSI_VC2CFGR1_DT1EN              CSI_VC2CFGR1_DT1EN_Msk                   /*!< Data type 1 enable */
#define CSI_VC2CFGR1_DT2EN_Pos          (3UL)
#define CSI_VC2CFGR1_DT2EN_Msk          (0x1UL << CSI_VC2CFGR1_DT2EN_Pos)         /*!< 0x00000008 */
#define CSI_VC2CFGR1_DT2EN              CSI_VC2CFGR1_DT2EN_Msk                   /*!< Data type 2 enable */
#define CSI_VC2CFGR1_DT3EN_Pos          (4UL)
#define CSI_VC2CFGR1_DT3EN_Msk          (0x1UL << CSI_VC2CFGR1_DT3EN_Pos)         /*!< 0x00000010 */
#define CSI_VC2CFGR1_DT3EN              CSI_VC2CFGR1_DT3EN_Msk                   /*!< Data type 3 enable */
#define CSI_VC2CFGR1_DT4EN_Pos          (5UL)
#define CSI_VC2CFGR1_DT4EN_Msk          (0x1UL << CSI_VC2CFGR1_DT4EN_Pos)         /*!< 0x00000020 */
#define CSI_VC2CFGR1_DT4EN              CSI_VC2CFGR1_DT4EN_Msk                   /*!< Data type 4 enable */
#define CSI_VC2CFGR1_DT5EN_Pos          (6UL)
#define CSI_VC2CFGR1_DT5EN_Msk          (0x1UL << CSI_VC2CFGR1_DT5EN_Pos)         /*!< 0x00000040 */
#define CSI_VC2CFGR1_DT5EN              CSI_VC2CFGR1_DT5EN_Msk                   /*!< Data type 5 enable */
#define CSI_VC2CFGR1_DT6EN_Pos          (7UL)
#define CSI_VC2CFGR1_DT6EN_Msk          (0x1UL << CSI_VC2CFGR1_DT6EN_Pos)         /*!< 0x00000080 */
#define CSI_VC2CFGR1_DT6EN              CSI_VC2CFGR1_DT6EN_Msk                   /*!< Data type 6 enable */
#define CSI_VC2CFGR1_CDTFT_Pos          (8UL)
#define CSI_VC2CFGR1_CDTFT_Msk          (0x1FUL << CSI_VC2CFGR1_CDTFT_Pos)        /*!< 0x00001F00 */
#define CSI_VC2CFGR1_CDTFT              CSI_VC2CFGR1_CDTFT_Msk                   /*!< Common format for all data types */
#define CSI_VC2CFGR1_DT0_Pos            (16UL)
#define CSI_VC2CFGR1_DT0_Msk            (0x3FUL << CSI_VC2CFGR1_DT0_Pos)          /*!< 0x003F0000 */
#define CSI_VC2CFGR1_DT0                CSI_VC2CFGR1_DT0_Msk                     /*!< Data type 0 class selection for virtual channel x */
#define CSI_VC2CFGR1_DT0FT_Pos          (24UL)
#define CSI_VC2CFGR1_DT0FT_Msk          (0x1FUL << CSI_VC2CFGR1_DT0FT_Pos)        /*!< 0x1F000000 */
#define CSI_VC2CFGR1_DT0FT              CSI_VC2CFGR1_DT0FT_Msk                   /*!< Data type 0 format */

/*****************  Bit definition for CSI_VC2CFGR2 register  *****************/
#define CSI_VC2CFGR2_DT1_Pos            (0UL)
#define CSI_VC2CFGR2_DT1_Msk            (0x3FUL << CSI_VC2CFGR2_DT1_Pos)          /*!< 0x0000003F */
#define CSI_VC2CFGR2_DT1                CSI_VC2CFGR2_DT1_Msk                     /*!< Data type 1 class selection for virtual channel x */
#define CSI_VC2CFGR2_DT1FT_Pos          (8UL)
#define CSI_VC2CFGR2_DT1FT_Msk          (0x1FUL << CSI_VC2CFGR2_DT1FT_Pos)        /*!< 0x00001F00 */
#define CSI_VC2CFGR2_DT1FT              CSI_VC2CFGR2_DT1FT_Msk                   /*!< Data type 1 format */
#define CSI_VC2CFGR2_DT2_Pos            (16UL)
#define CSI_VC2CFGR2_DT2_Msk            (0x3FUL << CSI_VC2CFGR2_DT2_Pos)          /*!< 0x003F0000 */
#define CSI_VC2CFGR2_DT2                CSI_VC2CFGR2_DT2_Msk                     /*!< Data type 2 class selection for virtual channel x */
#define CSI_VC2CFGR2_DT2FT_Pos          (24UL)
#define CSI_VC2CFGR2_DT2FT_Msk          (0x1FUL << CSI_VC2CFGR2_DT2FT_Pos)        /*!< 0x1F000000 */
#define CSI_VC2CFGR2_DT2FT              CSI_VC2CFGR2_DT2FT_Msk                   /*!< Data type 2 format */

/*****************  Bit definition for CSI_VC2CFGR3 register  *****************/
#define CSI_VC2CFGR3_DT3_Pos            (0UL)
#define CSI_VC2CFGR3_DT3_Msk            (0x3FUL << CSI_VC2CFGR3_DT3_Pos)          /*!< 0x0000003F */
#define CSI_VC2CFGR3_DT3                CSI_VC2CFGR3_DT3_Msk                     /*!< Data type 3 class selection for virtual channel x */
#define CSI_VC2CFGR3_DT3FT_Pos          (8UL)
#define CSI_VC2CFGR3_DT3FT_Msk          (0x1FUL << CSI_VC2CFGR3_DT3FT_Pos)        /*!< 0x00001F00 */
#define CSI_VC2CFGR3_DT3FT              CSI_VC2CFGR3_DT3FT_Msk                   /*!< Data type 3 format */
#define CSI_VC2CFGR3_DT4_Pos            (16UL)
#define CSI_VC2CFGR3_DT4_Msk            (0x3FUL << CSI_VC2CFGR3_DT4_Pos)          /*!< 0x003F0000 */
#define CSI_VC2CFGR3_DT4                CSI_VC2CFGR3_DT4_Msk                     /*!< Data type 4 class selection for virtual channel x */
#define CSI_VC2CFGR3_DT4FT_Pos          (24UL)
#define CSI_VC2CFGR3_DT4FT_Msk          (0x1FUL << CSI_VC2CFGR3_DT4FT_Pos)        /*!< 0x1F000000 */
#define CSI_VC2CFGR3_DT4FT              CSI_VC2CFGR3_DT4FT_Msk                   /*!< Data type 4 format */

/*****************  Bit definition for CSI_VC2CFGR4 register  *****************/
#define CSI_VC2CFGR4_DT5_Pos            (0UL)
#define CSI_VC2CFGR4_DT5_Msk            (0x3FUL << CSI_VC2CFGR4_DT5_Pos)          /*!< 0x0000003F */
#define CSI_VC2CFGR4_DT5                CSI_VC2CFGR4_DT5_Msk                     /*!< Data type 5 class selection for virtual channel x */
#define CSI_VC2CFGR4_DT5FT_Pos          (8UL)
#define CSI_VC2CFGR4_DT5FT_Msk          (0x1FUL << CSI_VC2CFGR4_DT5FT_Pos)        /*!< 0x00001F00 */
#define CSI_VC2CFGR4_DT5FT              CSI_VC2CFGR4_DT5FT_Msk                   /*!< Data type 5 format */
#define CSI_VC2CFGR4_DT6_Pos            (16UL)
#define CSI_VC2CFGR4_DT6_Msk            (0x3FUL << CSI_VC2CFGR4_DT6_Pos)          /*!< 0x003F0000 */
#define CSI_VC2CFGR4_DT6                CSI_VC2CFGR4_DT6_Msk                     /*!< Data type 6 class selection for virtual channel x */
#define CSI_VC2CFGR4_DT6FT_Pos          (24UL)
#define CSI_VC2CFGR4_DT6FT_Msk          (0x1FUL << CSI_VC2CFGR4_DT6FT_Pos)        /*!< 0x1F000000 */
#define CSI_VC2CFGR4_DT6FT              CSI_VC2CFGR4_DT6FT_Msk                   /*!< Data type 6 format */

/*****************  Bit definition for CSI_VC3CFGR1 register  *****************/
#define CSI_VC3CFGR1_ALLDT_Pos          (0UL)
#define CSI_VC3CFGR1_ALLDT_Msk          (0x1UL << CSI_VC3CFGR1_ALLDT_Pos)         /*!< 0x00000001 */
#define CSI_VC3CFGR1_ALLDT              CSI_VC3CFGR1_ALLDT_Msk                   /*!< All data types enable for the virtual channel x */
#define CSI_VC3CFGR1_DT0EN_Pos          (1UL)
#define CSI_VC3CFGR1_DT0EN_Msk          (0x1UL << CSI_VC3CFGR1_DT0EN_Pos)         /*!< 0x00000002 */
#define CSI_VC3CFGR1_DT0EN              CSI_VC3CFGR1_DT0EN_Msk                   /*!< Data type 0 enable */
#define CSI_VC3CFGR1_DT1EN_Pos          (2UL)
#define CSI_VC3CFGR1_DT1EN_Msk          (0x1UL << CSI_VC3CFGR1_DT1EN_Pos)         /*!< 0x00000004 */
#define CSI_VC3CFGR1_DT1EN              CSI_VC3CFGR1_DT1EN_Msk                   /*!< Data type 1 enable */
#define CSI_VC3CFGR1_DT2EN_Pos          (3UL)
#define CSI_VC3CFGR1_DT2EN_Msk          (0x1UL << CSI_VC3CFGR1_DT2EN_Pos)         /*!< 0x00000008 */
#define CSI_VC3CFGR1_DT2EN              CSI_VC3CFGR1_DT2EN_Msk                   /*!< Data type 2 enable */
#define CSI_VC3CFGR1_DT3EN_Pos          (4UL)
#define CSI_VC3CFGR1_DT3EN_Msk          (0x1UL << CSI_VC3CFGR1_DT3EN_Pos)         /*!< 0x00000010 */
#define CSI_VC3CFGR1_DT3EN              CSI_VC3CFGR1_DT3EN_Msk                   /*!< Data type 3 enable */
#define CSI_VC3CFGR1_DT4EN_Pos          (5UL)
#define CSI_VC3CFGR1_DT4EN_Msk          (0x1UL << CSI_VC3CFGR1_DT4EN_Pos)         /*!< 0x00000020 */
#define CSI_VC3CFGR1_DT4EN              CSI_VC3CFGR1_DT4EN_Msk                   /*!< Data type 4 enable */
#define CSI_VC3CFGR1_DT5EN_Pos          (6UL)
#define CSI_VC3CFGR1_DT5EN_Msk          (0x1UL << CSI_VC3CFGR1_DT5EN_Pos)         /*!< 0x00000040 */
#define CSI_VC3CFGR1_DT5EN              CSI_VC3CFGR1_DT5EN_Msk                   /*!< Data type 5 enable */
#define CSI_VC3CFGR1_DT6EN_Pos          (7UL)
#define CSI_VC3CFGR1_DT6EN_Msk          (0x1UL << CSI_VC3CFGR1_DT6EN_Pos)         /*!< 0x00000080 */
#define CSI_VC3CFGR1_DT6EN              CSI_VC3CFGR1_DT6EN_Msk                   /*!< Data type 6 enable */
#define CSI_VC3CFGR1_CDTFT_Pos          (8UL)
#define CSI_VC3CFGR1_CDTFT_Msk          (0x1FUL << CSI_VC3CFGR1_CDTFT_Pos)        /*!< 0x00001F00 */
#define CSI_VC3CFGR1_CDTFT              CSI_VC3CFGR1_CDTFT_Msk                   /*!< Common format for all data types */
#define CSI_VC3CFGR1_DT0_Pos            (16UL)
#define CSI_VC3CFGR1_DT0_Msk            (0x3FUL << CSI_VC3CFGR1_DT0_Pos)          /*!< 0x003F0000 */
#define CSI_VC3CFGR1_DT0                CSI_VC3CFGR1_DT0_Msk                     /*!< Data type 0 class selection for virtual channel x */
#define CSI_VC3CFGR1_DT0FT_Pos          (24UL)
#define CSI_VC3CFGR1_DT0FT_Msk          (0x1FUL << CSI_VC3CFGR1_DT0FT_Pos)        /*!< 0x1F000000 */
#define CSI_VC3CFGR1_DT0FT              CSI_VC3CFGR1_DT0FT_Msk                   /*!< Data type 0 format */

/*****************  Bit definition for CSI_VC3CFGR2 register  *****************/
#define CSI_VC3CFGR2_DT1_Pos            (0UL)
#define CSI_VC3CFGR2_DT1_Msk            (0x3FUL << CSI_VC3CFGR2_DT1_Pos)          /*!< 0x0000003F */
#define CSI_VC3CFGR2_DT1                CSI_VC3CFGR2_DT1_Msk                     /*!< Data type 1 class selection for virtual channel x */
#define CSI_VC3CFGR2_DT1FT_Pos          (8UL)
#define CSI_VC3CFGR2_DT1FT_Msk          (0x1FUL << CSI_VC3CFGR2_DT1FT_Pos)        /*!< 0x00001F00 */
#define CSI_VC3CFGR2_DT1FT              CSI_VC3CFGR2_DT1FT_Msk                   /*!< Data type 1 format */
#define CSI_VC3CFGR2_DT2_Pos            (16UL)
#define CSI_VC3CFGR2_DT2_Msk            (0x3FUL << CSI_VC3CFGR2_DT2_Pos)          /*!< 0x003F0000 */
#define CSI_VC3CFGR2_DT2                CSI_VC3CFGR2_DT2_Msk                     /*!< Data type 2 class selection for virtual channel x */
#define CSI_VC3CFGR2_DT2FT_Pos          (24UL)
#define CSI_VC3CFGR2_DT2FT_Msk          (0x1FUL << CSI_VC3CFGR2_DT2FT_Pos)        /*!< 0x1F000000 */
#define CSI_VC3CFGR2_DT2FT              CSI_VC3CFGR2_DT2FT_Msk                   /*!< Data type 2 format */

/*****************  Bit definition for CSI_VC3CFGR3 register  *****************/
#define CSI_VC3CFGR3_DT3_Pos            (0UL)
#define CSI_VC3CFGR3_DT3_Msk            (0x3FUL << CSI_VC3CFGR3_DT3_Pos)          /*!< 0x0000003F */
#define CSI_VC3CFGR3_DT3                CSI_VC3CFGR3_DT3_Msk                     /*!< Data type 3 class selection for virtual channel x */
#define CSI_VC3CFGR3_DT3FT_Pos          (8UL)
#define CSI_VC3CFGR3_DT3FT_Msk          (0x1FUL << CSI_VC3CFGR3_DT3FT_Pos)        /*!< 0x00001F00 */
#define CSI_VC3CFGR3_DT3FT              CSI_VC3CFGR3_DT3FT_Msk                   /*!< Data type 3 format */
#define CSI_VC3CFGR3_DT4_Pos            (16UL)
#define CSI_VC3CFGR3_DT4_Msk            (0x3FUL << CSI_VC3CFGR3_DT4_Pos)          /*!< 0x003F0000 */
#define CSI_VC3CFGR3_DT4                CSI_VC3CFGR3_DT4_Msk                     /*!< Data type 4 class selection for virtual channel x */
#define CSI_VC3CFGR3_DT4FT_Pos          (24UL)
#define CSI_VC3CFGR3_DT4FT_Msk          (0x1FUL << CSI_VC3CFGR3_DT4FT_Pos)        /*!< 0x1F000000 */
#define CSI_VC3CFGR3_DT4FT              CSI_VC3CFGR3_DT4FT_Msk                   /*!< Data type 4 format */

/*****************  Bit definition for CSI_VC3CFGR4 register  *****************/
#define CSI_VC3CFGR4_DT5_Pos            (0UL)
#define CSI_VC3CFGR4_DT5_Msk            (0x3FUL << CSI_VC3CFGR4_DT5_Pos)          /*!< 0x0000003F */
#define CSI_VC3CFGR4_DT5                CSI_VC3CFGR4_DT5_Msk                     /*!< Data type 5 class selection for virtual channel x */
#define CSI_VC3CFGR4_DT5FT_Pos          (8UL)
#define CSI_VC3CFGR4_DT5FT_Msk          (0x1FUL << CSI_VC3CFGR4_DT5FT_Pos)        /*!< 0x00001F00 */
#define CSI_VC3CFGR4_DT5FT              CSI_VC3CFGR4_DT5FT_Msk                   /*!< Data type 5 format */
#define CSI_VC3CFGR4_DT6_Pos            (16UL)
#define CSI_VC3CFGR4_DT6_Msk            (0x3FUL << CSI_VC3CFGR4_DT6_Pos)          /*!< 0x003F0000 */
#define CSI_VC3CFGR4_DT6                CSI_VC3CFGR4_DT6_Msk                     /*!< Data type 6 class selection for virtual channel x */
#define CSI_VC3CFGR4_DT6FT_Pos          (24UL)
#define CSI_VC3CFGR4_DT6FT_Msk          (0x1FUL << CSI_VC3CFGR4_DT6FT_Pos)        /*!< 0x1F000000 */
#define CSI_VC3CFGR4_DT6FT              CSI_VC3CFGR4_DT6FT_Msk                   /*!< Data type 6 format */

/*****************  Bit definition for CSI_LB0CFGR register  ******************/
#define CSI_LB0CFGR_BYTECNT_Pos         (0UL)
#define CSI_LB0CFGR_BYTECNT_Msk         (0xFFFFUL << CSI_LB0CFGR_BYTECNT_Pos)     /*!< 0x0000FFFF */
#define CSI_LB0CFGR_BYTECNT             CSI_LB0CFGR_BYTECNT_Msk                  /*!< Byte counter */
#define CSI_LB0CFGR_LINECNT_Pos         (16UL)
#define CSI_LB0CFGR_LINECNT_Msk         (0xFFFFUL << CSI_LB0CFGR_LINECNT_Pos)     /*!< 0xFFFF0000 */
#define CSI_LB0CFGR_LINECNT             CSI_LB0CFGR_LINECNT_Msk                  /*!< Line counter */

/*****************  Bit definition for CSI_LB1CFGR register  ******************/
#define CSI_LB1CFGR_BYTECNT_Pos         (0UL)
#define CSI_LB1CFGR_BYTECNT_Msk         (0xFFFFUL << CSI_LB1CFGR_BYTECNT_Pos)     /*!< 0x0000FFFF */
#define CSI_LB1CFGR_BYTECNT             CSI_LB1CFGR_BYTECNT_Msk                  /*!< Byte counter */
#define CSI_LB1CFGR_LINECNT_Pos         (16UL)
#define CSI_LB1CFGR_LINECNT_Msk         (0xFFFFUL << CSI_LB1CFGR_LINECNT_Pos)     /*!< 0xFFFF0000 */
#define CSI_LB1CFGR_LINECNT             CSI_LB1CFGR_LINECNT_Msk                  /*!< Line counter */

/*****************  Bit definition for CSI_LB2CFGR register  ******************/
#define CSI_LB2CFGR_BYTECNT_Pos         (0UL)
#define CSI_LB2CFGR_BYTECNT_Msk         (0xFFFFUL << CSI_LB2CFGR_BYTECNT_Pos)     /*!< 0x0000FFFF */
#define CSI_LB2CFGR_BYTECNT             CSI_LB2CFGR_BYTECNT_Msk                  /*!< Byte counter */
#define CSI_LB2CFGR_LINECNT_Pos         (16UL)
#define CSI_LB2CFGR_LINECNT_Msk         (0xFFFFUL << CSI_LB2CFGR_LINECNT_Pos)     /*!< 0xFFFF0000 */
#define CSI_LB2CFGR_LINECNT             CSI_LB2CFGR_LINECNT_Msk                  /*!< Line counter */

/*****************  Bit definition for CSI_LB3CFGR register  ******************/
#define CSI_LB3CFGR_BYTECNT_Pos         (0UL)
#define CSI_LB3CFGR_BYTECNT_Msk         (0xFFFFUL << CSI_LB3CFGR_BYTECNT_Pos)     /*!< 0x0000FFFF */
#define CSI_LB3CFGR_BYTECNT             CSI_LB3CFGR_BYTECNT_Msk                  /*!< Byte counter */
#define CSI_LB3CFGR_LINECNT_Pos         (16UL)
#define CSI_LB3CFGR_LINECNT_Msk         (0xFFFFUL << CSI_LB3CFGR_LINECNT_Pos)     /*!< 0xFFFF0000 */
#define CSI_LB3CFGR_LINECNT             CSI_LB3CFGR_LINECNT_Msk                  /*!< Line counter */

/*****************  Bit definition for CSI_TIM0CFGR register  *****************/
#define CSI_TIM0CFGR_COUNT_Pos          (0UL)
#define CSI_TIM0CFGR_COUNT_Msk          (0x1FFFFFFUL << CSI_TIM0CFGR_COUNT_Pos)   /*!< 0x01FFFFFF */
#define CSI_TIM0CFGR_COUNT              CSI_TIM0CFGR_COUNT_Msk                   /*!< Clock cycle counter */

/*****************  Bit definition for CSI_TIM1CFGR register  *****************/
#define CSI_TIM1CFGR_COUNT_Pos          (0UL)
#define CSI_TIM1CFGR_COUNT_Msk          (0x1FFFFFFUL << CSI_TIM1CFGR_COUNT_Pos)   /*!< 0x01FFFFFF */
#define CSI_TIM1CFGR_COUNT              CSI_TIM1CFGR_COUNT_Msk                   /*!< Clock cycle counter */

/*****************  Bit definition for CSI_TIM2CFGR register  *****************/
#define CSI_TIM2CFGR_COUNT_Pos          (0UL)
#define CSI_TIM2CFGR_COUNT_Msk          (0x1FFFFFFUL << CSI_TIM2CFGR_COUNT_Pos)   /*!< 0x01FFFFFF */
#define CSI_TIM2CFGR_COUNT              CSI_TIM2CFGR_COUNT_Msk                   /*!< Clock cycle counter */

/*****************  Bit definition for CSI_TIM3CFGR register  *****************/
#define CSI_TIM3CFGR_COUNT_Pos          (0UL)
#define CSI_TIM3CFGR_COUNT_Msk          (0x1FFFFFFUL << CSI_TIM3CFGR_COUNT_Pos)   /*!< 0x01FFFFFF */
#define CSI_TIM3CFGR_COUNT              CSI_TIM3CFGR_COUNT_Msk                   /*!< Clock cycle counter */

/******************  Bit definition for CSI_LMCFGR register  ******************/
#define CSI_LMCFGR_LANENB_Pos           (8UL)
#define CSI_LMCFGR_LANENB_Msk           (0x7UL << CSI_LMCFGR_LANENB_Pos)          /*!< 0x00000700 */
#define CSI_LMCFGR_LANENB               CSI_LMCFGR_LANENB_Msk                    /*!< Number of lanes */
#define CSI_LMCFGR_DL0MAP_Pos           (16UL)
#define CSI_LMCFGR_DL0MAP_Msk           (0x7UL << CSI_LMCFGR_DL0MAP_Pos)          /*!< 0x00070000 */
#define CSI_LMCFGR_DL0MAP               CSI_LMCFGR_DL0MAP_Msk                    /*!< Physical mapping of logical data lane 0 */
#define CSI_LMCFGR_DL1MAP_Pos           (20UL)
#define CSI_LMCFGR_DL1MAP_Msk           (0x7UL << CSI_LMCFGR_DL1MAP_Pos)          /*!< 0x00700000 */
#define CSI_LMCFGR_DL1MAP               CSI_LMCFGR_DL1MAP_Msk                    /*!< Physical mapping of logical data lane 1 */

/******************  Bit definition for CSI_PRGITR register  ******************/
#define CSI_PRGITR_LB0VC_Pos            (0UL)
#define CSI_PRGITR_LB0VC_Msk            (0x3UL << CSI_PRGITR_LB0VC_Pos)           /*!< 0x00000003 */
#define CSI_PRGITR_LB0VC                CSI_PRGITR_LB0VC_Msk                     /*!< Line/Byte counter 0 linked to a virtual channel */
#define CSI_PRGITR_LB0EN_Pos            (3UL)
#define CSI_PRGITR_LB0EN_Msk            (0x1UL << CSI_PRGITR_LB0EN_Pos)           /*!< 0x00000008 */
#define CSI_PRGITR_LB0EN                CSI_PRGITR_LB0EN_Msk                     /*!< Line/Byte 0counter enable */
#define CSI_PRGITR_LB1VC_Pos            (4UL)
#define CSI_PRGITR_LB1VC_Msk            (0x3UL << CSI_PRGITR_LB1VC_Pos)           /*!< 0x00000030 */
#define CSI_PRGITR_LB1VC                CSI_PRGITR_LB1VC_Msk                     /*!< Line/Byte counter 1 linked to a virtual channel */
#define CSI_PRGITR_LB1EN_Pos            (7UL)
#define CSI_PRGITR_LB1EN_Msk            (0x1UL << CSI_PRGITR_LB1EN_Pos)           /*!< 0x00000080 */
#define CSI_PRGITR_LB1EN                CSI_PRGITR_LB1EN_Msk                     /*!< Line/Byte 1 counter enable */
#define CSI_PRGITR_LB2VC_Pos            (8UL)
#define CSI_PRGITR_LB2VC_Msk            (0x3UL << CSI_PRGITR_LB2VC_Pos)           /*!< 0x00000300 */
#define CSI_PRGITR_LB2VC                CSI_PRGITR_LB2VC_Msk                     /*!< Line/Byte counter 2 linked to a virtual channel */
#define CSI_PRGITR_LB2EN_Pos            (11UL)
#define CSI_PRGITR_LB2EN_Msk            (0x1UL << CSI_PRGITR_LB2EN_Pos)           /*!< 0x00000800 */
#define CSI_PRGITR_LB2EN                CSI_PRGITR_LB2EN_Msk                     /*!< Line/Byte 2 counter enable */
#define CSI_PRGITR_LB3VC_Pos            (12UL)
#define CSI_PRGITR_LB3VC_Msk            (0x3UL << CSI_PRGITR_LB3VC_Pos)           /*!< 0x00003000 */
#define CSI_PRGITR_LB3VC                CSI_PRGITR_LB3VC_Msk                     /*!< Line/Byte counter 3 linked to a virtual channel */
#define CSI_PRGITR_LB3EN_Pos            (15UL)
#define CSI_PRGITR_LB3EN_Msk            (0x1UL << CSI_PRGITR_LB3EN_Pos)           /*!< 0x00008000 */
#define CSI_PRGITR_LB3EN                CSI_PRGITR_LB3EN_Msk                     /*!< Line/Byte 3 counter enable */
#define CSI_PRGITR_TIM0VC_Pos           (16UL)
#define CSI_PRGITR_TIM0VC_Msk           (0x3UL << CSI_PRGITR_TIM0VC_Pos)          /*!< 0x00030000 */
#define CSI_PRGITR_TIM0VC               CSI_PRGITR_TIM0VC_Msk                    /*!< TIM0 base time linked to a virtual channel */
#define CSI_PRGITR_TIM0EOF_Pos          (18UL)
#define CSI_PRGITR_TIM0EOF_Msk          (0x1UL << CSI_PRGITR_TIM0EOF_Pos)         /*!< 0x00040000 */
#define CSI_PRGITR_TIM0EOF              CSI_PRGITR_TIM0EOF_Msk                   /*!< TIM0 base time starting from the end of frame */
#define CSI_PRGITR_TIM0EN_Pos           (19UL)
#define CSI_PRGITR_TIM0EN_Msk           (0x1UL << CSI_PRGITR_TIM0EN_Pos)          /*!< 0x00080000 */
#define CSI_PRGITR_TIM0EN               CSI_PRGITR_TIM0EN_Msk                    /*!< TIM0 base time enable */
#define CSI_PRGITR_TIM1VC_Pos           (20UL)
#define CSI_PRGITR_TIM1VC_Msk           (0x3UL << CSI_PRGITR_TIM1VC_Pos)          /*!< 0x00300000 */
#define CSI_PRGITR_TIM1VC               CSI_PRGITR_TIM1VC_Msk                    /*!< TIM1 base time linked to a virtual channel */
#define CSI_PRGITR_TIM1EOF_Pos          (22UL)
#define CSI_PRGITR_TIM1EOF_Msk          (0x1UL << CSI_PRGITR_TIM1EOF_Pos)         /*!< 0x00400000 */
#define CSI_PRGITR_TIM1EOF              CSI_PRGITR_TIM1EOF_Msk                   /*!< TIM1 base time starting from the end of frame */
#define CSI_PRGITR_TIM1EN_Pos           (23UL)
#define CSI_PRGITR_TIM1EN_Msk           (0x1UL << CSI_PRGITR_TIM1EN_Pos)          /*!< 0x00800000 */
#define CSI_PRGITR_TIM1EN               CSI_PRGITR_TIM1EN_Msk                    /*!< TIM1 base time enable */
#define CSI_PRGITR_TIM2VC_Pos           (24UL)
#define CSI_PRGITR_TIM2VC_Msk           (0x3UL << CSI_PRGITR_TIM2VC_Pos)          /*!< 0x03000000 */
#define CSI_PRGITR_TIM2VC               CSI_PRGITR_TIM2VC_Msk                    /*!< TIM2 base time linked to a virtual channel */
#define CSI_PRGITR_TIM2EOF_Pos          (26UL)
#define CSI_PRGITR_TIM2EOF_Msk          (0x1UL << CSI_PRGITR_TIM2EOF_Pos)         /*!< 0x04000000 */
#define CSI_PRGITR_TIM2EOF              CSI_PRGITR_TIM2EOF_Msk                   /*!< TIM2 base time starting from the end of frame */
#define CSI_PRGITR_TIM2EN_Pos           (27UL)
#define CSI_PRGITR_TIM2EN_Msk           (0x1UL << CSI_PRGITR_TIM2EN_Pos)          /*!< 0x08000000 */
#define CSI_PRGITR_TIM2EN               CSI_PRGITR_TIM2EN_Msk                    /*!< TIM2 base time enable */
#define CSI_PRGITR_TIM3VC_Pos           (28UL)
#define CSI_PRGITR_TIM3VC_Msk           (0x3UL << CSI_PRGITR_TIM3VC_Pos)          /*!< 0x30000000 */
#define CSI_PRGITR_TIM3VC               CSI_PRGITR_TIM3VC_Msk                    /*!< TIM3 base time linked to a virtual channel */
#define CSI_PRGITR_TIM3EOF_Pos          (30UL)
#define CSI_PRGITR_TIM3EOF_Msk          (0x1UL << CSI_PRGITR_TIM3EOF_Pos)         /*!< 0x40000000 */
#define CSI_PRGITR_TIM3EOF              CSI_PRGITR_TIM3EOF_Msk                   /*!< TIM3 base time starting from the end of frame */
#define CSI_PRGITR_TIM3EN_Pos           (31UL)
#define CSI_PRGITR_TIM3EN_Msk           (0x1UL << CSI_PRGITR_TIM3EN_Pos)          /*!< 0x80000000 */
#define CSI_PRGITR_TIM3EN               CSI_PRGITR_TIM3EN_Msk                    /*!< TIM3 base time enable */

/*******************  Bit definition for CSI_WDR register  ********************/
#define CSI_WDR_CNT_Pos                 (0UL)
#define CSI_WDR_CNT_Msk                 (0xFFFFFFFFUL << CSI_WDR_CNT_Pos)         /*!< 0xFFFFFFFF */
#define CSI_WDR_CNT                     CSI_WDR_CNT_Msk                          /*!< Watchdog counter */

/*******************  Bit definition for CSI_IER0 register  *******************/
#define CSI_IER0_LB0IE_Pos              (0UL)
#define CSI_IER0_LB0IE_Msk              (0x1UL << CSI_IER0_LB0IE_Pos)             /*!< 0x00000001 */
#define CSI_IER0_LB0IE                  CSI_IER0_LB0IE_Msk                       /*!< Line byte counter 0 interrupt enable */
#define CSI_IER0_LB1IE_Pos              (1UL)
#define CSI_IER0_LB1IE_Msk              (0x1UL << CSI_IER0_LB1IE_Pos)             /*!< 0x00000002 */
#define CSI_IER0_LB1IE                  CSI_IER0_LB1IE_Msk                       /*!< Line byte counter 1 interrupt enable */
#define CSI_IER0_LB2IE_Pos              (2UL)
#define CSI_IER0_LB2IE_Msk              (0x1UL << CSI_IER0_LB2IE_Pos)             /*!< 0x00000004 */
#define CSI_IER0_LB2IE                  CSI_IER0_LB2IE_Msk                       /*!< Line byte counter 2 interrupt enable */
#define CSI_IER0_LB3IE_Pos              (3UL)
#define CSI_IER0_LB3IE_Msk              (0x1UL << CSI_IER0_LB3IE_Pos)             /*!< 0x00000008 */
#define CSI_IER0_LB3IE                  CSI_IER0_LB3IE_Msk                       /*!< Line byte counter 3 interrupt enable */
#define CSI_IER0_TIM0IE_Pos             (4UL)
#define CSI_IER0_TIM0IE_Msk             (0x1UL << CSI_IER0_TIM0IE_Pos)            /*!< 0x00000010 */
#define CSI_IER0_TIM0IE                 CSI_IER0_TIM0IE_Msk                      /*!< Timer 0 interrupt enable */
#define CSI_IER0_TIM1IE_Pos             (5UL)
#define CSI_IER0_TIM1IE_Msk             (0x1UL << CSI_IER0_TIM1IE_Pos)            /*!< 0x00000020 */
#define CSI_IER0_TIM1IE                 CSI_IER0_TIM1IE_Msk                      /*!< Timer 1 interrupt enable */
#define CSI_IER0_TIM2IE_Pos             (6UL)
#define CSI_IER0_TIM2IE_Msk             (0x1UL << CSI_IER0_TIM2IE_Pos)            /*!< 0x00000040 */
#define CSI_IER0_TIM2IE                 CSI_IER0_TIM2IE_Msk                      /*!< Timer 2 interrupt enable */
#define CSI_IER0_TIM3IE_Pos             (7UL)
#define CSI_IER0_TIM3IE_Msk             (0x1UL << CSI_IER0_TIM3IE_Pos)            /*!< 0x00000080 */
#define CSI_IER0_TIM3IE                 CSI_IER0_TIM3IE_Msk                      /*!< Timer 3 interrupt enable */
#define CSI_IER0_SOF0IE_Pos             (8UL)
#define CSI_IER0_SOF0IE_Msk             (0x1UL << CSI_IER0_SOF0IE_Pos)            /*!< 0x00000100 */
#define CSI_IER0_SOF0IE                 CSI_IER0_SOF0IE_Msk                      /*!< Start of frame for virtual channel 0 interrupt enable */
#define CSI_IER0_SOF1IE_Pos             (9UL)
#define CSI_IER0_SOF1IE_Msk             (0x1UL << CSI_IER0_SOF1IE_Pos)            /*!< 0x00000200 */
#define CSI_IER0_SOF1IE                 CSI_IER0_SOF1IE_Msk                      /*!< Start of frame for virtual channel 1 interrupt enable */
#define CSI_IER0_SOF2IE_Pos             (10UL)
#define CSI_IER0_SOF2IE_Msk             (0x1UL << CSI_IER0_SOF2IE_Pos)            /*!< 0x00000400 */
#define CSI_IER0_SOF2IE                 CSI_IER0_SOF2IE_Msk                      /*!< Start of frame for virtual channel 2 interrupt enable */
#define CSI_IER0_SOF3IE_Pos             (11UL)
#define CSI_IER0_SOF3IE_Msk             (0x1UL << CSI_IER0_SOF3IE_Pos)            /*!< 0x00000800 */
#define CSI_IER0_SOF3IE                 CSI_IER0_SOF3IE_Msk                      /*!< Start of frame for virtual channel 3 interrupt enable */
#define CSI_IER0_EOF0IE_Pos             (12UL)
#define CSI_IER0_EOF0IE_Msk             (0x1UL << CSI_IER0_EOF0IE_Pos)            /*!< 0x00001000 */
#define CSI_IER0_EOF0IE                 CSI_IER0_EOF0IE_Msk                      /*!< End of frame for virtual channel 0 interrupt enable */
#define CSI_IER0_EOF1IE_Pos             (13UL)
#define CSI_IER0_EOF1IE_Msk             (0x1UL << CSI_IER0_EOF1IE_Pos)            /*!< 0x00002000 */
#define CSI_IER0_EOF1IE                 CSI_IER0_EOF1IE_Msk                      /*!< End of frame for virtual channel 1 interrupt enable */
#define CSI_IER0_EOF2IE_Pos             (14UL)
#define CSI_IER0_EOF2IE_Msk             (0x1UL << CSI_IER0_EOF2IE_Pos)            /*!< 0x00004000 */
#define CSI_IER0_EOF2IE                 CSI_IER0_EOF2IE_Msk                      /*!< End of frame for virtual channel 2 interrupt enable */
#define CSI_IER0_EOF3IE_Pos             (15UL)
#define CSI_IER0_EOF3IE_Msk             (0x1UL << CSI_IER0_EOF3IE_Pos)            /*!< 0x00008000 */
#define CSI_IER0_EOF3IE                 CSI_IER0_EOF3IE_Msk                      /*!< End of frame for virtual channel 3 interrupt enable */
#define CSI_IER0_SPKTIE_Pos             (16UL)
#define CSI_IER0_SPKTIE_Msk             (0x1UL << CSI_IER0_SPKTIE_Pos)            /*!< 0x00010000 */
#define CSI_IER0_SPKTIE                 CSI_IER0_SPKTIE_Msk                      /*!< Short packet interrupt enable */
#define CSI_IER0_CCFIFOFIE_Pos          (21UL)
#define CSI_IER0_CCFIFOFIE_Msk          (0x1UL << CSI_IER0_CCFIFOFIE_Pos)         /*!< 0x00200000 */
#define CSI_IER0_CCFIFOFIE              CSI_IER0_CCFIFOFIE_Msk                   /*!< Clock changer FIFO full interrupt enable */
#define CSI_IER0_CRCERRIE_Pos           (24UL)
#define CSI_IER0_CRCERRIE_Msk           (0x1UL << CSI_IER0_CRCERRIE_Pos)          /*!< 0x01000000 */
#define CSI_IER0_CRCERRIE               CSI_IER0_CRCERRIE_Msk                    /*!< CRC error interrupt enable */
#define CSI_IER0_ECCERRIE_Pos           (25UL)
#define CSI_IER0_ECCERRIE_Msk           (0x1UL << CSI_IER0_ECCERRIE_Pos)          /*!< 0x02000000 */
#define CSI_IER0_ECCERRIE               CSI_IER0_ECCERRIE_Msk                    /*!< ECC error interrupt enable */
#define CSI_IER0_CECCERRIE_Pos          (26UL)
#define CSI_IER0_CECCERRIE_Msk          (0x1UL << CSI_IER0_CECCERRIE_Pos)         /*!< 0x04000000 */
#define CSI_IER0_CECCERRIE              CSI_IER0_CECCERRIE_Msk                   /*!< Corrected ECC error interrupt enable */
#define CSI_IER0_IDERRIE_Pos            (27UL)
#define CSI_IER0_IDERRIE_Msk            (0x1UL << CSI_IER0_IDERRIE_Pos)           /*!< 0x08000000 */
#define CSI_IER0_IDERRIE                CSI_IER0_IDERRIE_Msk                     /*!< Data type ID error interrupt enable */
#define CSI_IER0_SPKTERRIE_Pos          (28UL)
#define CSI_IER0_SPKTERRIE_Msk          (0x1UL << CSI_IER0_SPKTERRIE_Pos)         /*!< 0x10000000 */
#define CSI_IER0_SPKTERRIE              CSI_IER0_SPKTERRIE_Msk                   /*!< Short packet error interrupt enable */
#define CSI_IER0_WDERRIE_Pos            (29UL)
#define CSI_IER0_WDERRIE_Msk            (0x1UL << CSI_IER0_WDERRIE_Pos)           /*!< 0x20000000 */
#define CSI_IER0_WDERRIE                CSI_IER0_WDERRIE_Msk                     /*!< Watchdog error interrupt enable */
#define CSI_IER0_SYNCERRIE_Pos          (30UL)
#define CSI_IER0_SYNCERRIE_Msk          (0x1UL << CSI_IER0_SYNCERRIE_Pos)         /*!< 0x40000000 */
#define CSI_IER0_SYNCERRIE              CSI_IER0_SYNCERRIE_Msk                   /*!< Invalid synchronization error interrupt enable */

/*******************  Bit definition for CSI_IER1 register  *******************/
#define CSI_IER1_ESOTDL0IE_Pos          (0UL)
#define CSI_IER1_ESOTDL0IE_Msk          (0x1UL << CSI_IER1_ESOTDL0IE_Pos)         /*!< 0x00000001 */
#define CSI_IER1_ESOTDL0IE              CSI_IER1_ESOTDL0IE_Msk                   /*!< Start of transmission error interrupt enable on lane 0 */
#define CSI_IER1_ESOTSYNCDL0IE_Pos      (1UL)
#define CSI_IER1_ESOTSYNCDL0IE_Msk      (0x1UL << CSI_IER1_ESOTSYNCDL0IE_Pos)     /*!< 0x00000002 */
#define CSI_IER1_ESOTSYNCDL0IE          CSI_IER1_ESOTSYNCDL0IE_Msk               /*!< Start of transmission synchronization interrupt error enable on lane 0 */
#define CSI_IER1_EESCDL0IE_Pos          (2UL)
#define CSI_IER1_EESCDL0IE_Msk          (0x1UL << CSI_IER1_EESCDL0IE_Pos)         /*!< 0x00000004 */
#define CSI_IER1_EESCDL0IE              CSI_IER1_EESCDL0IE_Msk                   /*!< D-PHY_RX lane 0 escape entry error interrupt enable */
#define CSI_IER1_ESYNCESCDL0IE_Pos      (3UL)
#define CSI_IER1_ESYNCESCDL0IE_Msk      (0x1UL << CSI_IER1_ESYNCESCDL0IE_Pos)     /*!< 0x00000008 */
#define CSI_IER1_ESYNCESCDL0IE          CSI_IER1_ESYNCESCDL0IE_Msk               /*!< D-PHY_RX lane 0 low power data transmission synchronization error interrupt enable */
#define CSI_IER1_ECTRLDL0IE_Pos         (4UL)
#define CSI_IER1_ECTRLDL0IE_Msk         (0x1UL << CSI_IER1_ECTRLDL0IE_Pos)        /*!< 0x00000010 */
#define CSI_IER1_ECTRLDL0IE             CSI_IER1_ECTRLDL0IE_Msk                  /*!< D-PHY_RX lane 0 control error interrupt enable */
#define CSI_IER1_ESOTDL1IE_Pos          (8UL)
#define CSI_IER1_ESOTDL1IE_Msk          (0x1UL << CSI_IER1_ESOTDL1IE_Pos)         /*!< 0x00000100 */
#define CSI_IER1_ESOTDL1IE              CSI_IER1_ESOTDL1IE_Msk                   /*!< Start of transmission error interrupt enable on lane 1 */
#define CSI_IER1_ESOTSYNCDL1IE_Pos      (9UL)
#define CSI_IER1_ESOTSYNCDL1IE_Msk      (0x1UL << CSI_IER1_ESOTSYNCDL1IE_Pos)     /*!< 0x00000200 */
#define CSI_IER1_ESOTSYNCDL1IE          CSI_IER1_ESOTSYNCDL1IE_Msk               /*!< Start of transmission synchronization interrupt error enable on lane 1 */
#define CSI_IER1_EESCDL1IE_Pos          (10UL)
#define CSI_IER1_EESCDL1IE_Msk          (0x1UL << CSI_IER1_EESCDL1IE_Pos)         /*!< 0x00000400 */
#define CSI_IER1_EESCDL1IE              CSI_IER1_EESCDL1IE_Msk                   /*!< D-PHY_RX lane 1 escape entry error interrupt enable */
#define CSI_IER1_ESYNCESCDL1IE_Pos      (11UL)
#define CSI_IER1_ESYNCESCDL1IE_Msk      (0x1UL << CSI_IER1_ESYNCESCDL1IE_Pos)     /*!< 0x00000800 */
#define CSI_IER1_ESYNCESCDL1IE          CSI_IER1_ESYNCESCDL1IE_Msk               /*!< D-PHY_RX lane 1 low power data transmission synchronization error interrupt enable */
#define CSI_IER1_ECTRLDL1IE_Pos         (12UL)
#define CSI_IER1_ECTRLDL1IE_Msk         (0x1UL << CSI_IER1_ECTRLDL1IE_Pos)        /*!< 0x00001000 */
#define CSI_IER1_ECTRLDL1IE             CSI_IER1_ECTRLDL1IE_Msk                  /*!< D-PHY_RX lane 1 control error interrupt enable */

/*******************  Bit definition for CSI_SR0 register  ********************/
#define CSI_SR0_LB0F_Pos                (0UL)
#define CSI_SR0_LB0F_Msk                (0x1UL << CSI_SR0_LB0F_Pos)               /*!< 0x00000001 */
#define CSI_SR0_LB0F                    CSI_SR0_LB0F_Msk                         /*!< Line byte counter 0 flag */
#define CSI_SR0_LB1F_Pos                (1UL)
#define CSI_SR0_LB1F_Msk                (0x1UL << CSI_SR0_LB1F_Pos)               /*!< 0x00000002 */
#define CSI_SR0_LB1F                    CSI_SR0_LB1F_Msk                         /*!< Line byte counter 1 flag */
#define CSI_SR0_LB2F_Pos                (2UL)
#define CSI_SR0_LB2F_Msk                (0x1UL << CSI_SR0_LB2F_Pos)               /*!< 0x00000004 */
#define CSI_SR0_LB2F                    CSI_SR0_LB2F_Msk                         /*!< Line byte counter 2 flag */
#define CSI_SR0_LB3F_Pos                (3UL)
#define CSI_SR0_LB3F_Msk                (0x1UL << CSI_SR0_LB3F_Pos)               /*!< 0x00000008 */
#define CSI_SR0_LB3F                    CSI_SR0_LB3F_Msk                         /*!< Line byte counter 3 flag */
#define CSI_SR0_TIM0F_Pos               (4UL)
#define CSI_SR0_TIM0F_Msk               (0x1UL << CSI_SR0_TIM0F_Pos)              /*!< 0x00000010 */
#define CSI_SR0_TIM0F                   CSI_SR0_TIM0F_Msk                        /*!< Timer 0 flag */
#define CSI_SR0_TIM1F_Pos               (5UL)
#define CSI_SR0_TIM1F_Msk               (0x1UL << CSI_SR0_TIM1F_Pos)              /*!< 0x00000020 */
#define CSI_SR0_TIM1F                   CSI_SR0_TIM1F_Msk                        /*!< Timer 1 flag */
#define CSI_SR0_TIM2F_Pos               (6UL)
#define CSI_SR0_TIM2F_Msk               (0x1UL << CSI_SR0_TIM2F_Pos)              /*!< 0x00000040 */
#define CSI_SR0_TIM2F                   CSI_SR0_TIM2F_Msk                        /*!< Timer 2 flag */
#define CSI_SR0_TIM3F_Pos               (7UL)
#define CSI_SR0_TIM3F_Msk               (0x1UL << CSI_SR0_TIM3F_Pos)              /*!< 0x00000080 */
#define CSI_SR0_TIM3F                   CSI_SR0_TIM3F_Msk                        /*!< Timer 3 flag */
#define CSI_SR0_SOF0F_Pos               (8UL)
#define CSI_SR0_SOF0F_Msk               (0x1UL << CSI_SR0_SOF0F_Pos)              /*!< 0x00000100 */
#define CSI_SR0_SOF0F                   CSI_SR0_SOF0F_Msk                        /*!< Start of frame flag for virtual channel 0 */
#define CSI_SR0_SOF1F_Pos               (9UL)
#define CSI_SR0_SOF1F_Msk               (0x1UL << CSI_SR0_SOF1F_Pos)              /*!< 0x00000200 */
#define CSI_SR0_SOF1F                   CSI_SR0_SOF1F_Msk                        /*!< Start of frame flag for virtual channel 1 */
#define CSI_SR0_SOF2F_Pos               (10UL)
#define CSI_SR0_SOF2F_Msk               (0x1UL << CSI_SR0_SOF2F_Pos)              /*!< 0x00000400 */
#define CSI_SR0_SOF2F                   CSI_SR0_SOF2F_Msk                        /*!< Start of frame flag for virtual channel 2 */
#define CSI_SR0_SOF3F_Pos               (11UL)
#define CSI_SR0_SOF3F_Msk               (0x1UL << CSI_SR0_SOF3F_Pos)              /*!< 0x00000800 */
#define CSI_SR0_SOF3F                   CSI_SR0_SOF3F_Msk                        /*!< Start of frame flag for virtual channel 3 */
#define CSI_SR0_EOF0F_Pos               (12UL)
#define CSI_SR0_EOF0F_Msk               (0x1UL << CSI_SR0_EOF0F_Pos)              /*!< 0x00001000 */
#define CSI_SR0_EOF0F                   CSI_SR0_EOF0F_Msk                        /*!< End of frame flag for virtual channel 0 */
#define CSI_SR0_EOF1F_Pos               (13UL)
#define CSI_SR0_EOF1F_Msk               (0x1UL << CSI_SR0_EOF1F_Pos)              /*!< 0x00002000 */
#define CSI_SR0_EOF1F                   CSI_SR0_EOF1F_Msk                        /*!< End of frame flag for virtual channel 1 */
#define CSI_SR0_EOF2F_Pos               (14UL)
#define CSI_SR0_EOF2F_Msk               (0x1UL << CSI_SR0_EOF2F_Pos)              /*!< 0x00004000 */
#define CSI_SR0_EOF2F                   CSI_SR0_EOF2F_Msk                        /*!< End of frame flag for virtual channel 2 */
#define CSI_SR0_EOF3F_Pos               (15UL)
#define CSI_SR0_EOF3F_Msk               (0x1UL << CSI_SR0_EOF3F_Pos)              /*!< 0x00008000 */
#define CSI_SR0_EOF3F                   CSI_SR0_EOF3F_Msk                        /*!< End of frame flag for virtual channel 3 */
#define CSI_SR0_SPKTF_Pos               (16UL)
#define CSI_SR0_SPKTF_Msk               (0x1UL << CSI_SR0_SPKTF_Pos)              /*!< 0x00010000 */
#define CSI_SR0_SPKTF                   CSI_SR0_SPKTF_Msk                        /*!< Short packet flag */
#define CSI_SR0_VC0STATEF_Pos           (17UL)
#define CSI_SR0_VC0STATEF_Msk           (0x1UL << CSI_SR0_VC0STATEF_Pos)          /*!< 0x00020000 */
#define CSI_SR0_VC0STATEF               CSI_SR0_VC0STATEF_Msk                    /*!< Virtual channel 0 state flag */
#define CSI_SR0_VC1STATEF_Pos           (18UL)
#define CSI_SR0_VC1STATEF_Msk           (0x1UL << CSI_SR0_VC1STATEF_Pos)          /*!< 0x00040000 */
#define CSI_SR0_VC1STATEF               CSI_SR0_VC1STATEF_Msk                    /*!< Virtual channel 1 state flag */
#define CSI_SR0_VC2STATEF_Pos           (19UL)
#define CSI_SR0_VC2STATEF_Msk           (0x1UL << CSI_SR0_VC2STATEF_Pos)          /*!< 0x00080000 */
#define CSI_SR0_VC2STATEF               CSI_SR0_VC2STATEF_Msk                    /*!< Virtual channel 2 state flag */
#define CSI_SR0_VC3STATEF_Pos           (20UL)
#define CSI_SR0_VC3STATEF_Msk           (0x1UL << CSI_SR0_VC3STATEF_Pos)          /*!< 0x00100000 */
#define CSI_SR0_VC3STATEF               CSI_SR0_VC3STATEF_Msk                    /*!< Virtual channel 3 state flag */
#define CSI_SR0_CCFIFOFF_Pos            (21UL)
#define CSI_SR0_CCFIFOFF_Msk            (0x1UL << CSI_SR0_CCFIFOFF_Pos)           /*!< 0x00200000 */
#define CSI_SR0_CCFIFOFF                CSI_SR0_CCFIFOFF_Msk                     /*!< Clock changer FIFO full flag */
#define CSI_SR0_CRCERRF_Pos             (24UL)
#define CSI_SR0_CRCERRF_Msk             (0x1UL << CSI_SR0_CRCERRF_Pos)            /*!< 0x01000000 */
#define CSI_SR0_CRCERRF                 CSI_SR0_CRCERRF_Msk                      /*!< CRC error flag */
#define CSI_SR0_ECCERRF_Pos             (25UL)
#define CSI_SR0_ECCERRF_Msk             (0x1UL << CSI_SR0_ECCERRF_Pos)            /*!< 0x02000000 */
#define CSI_SR0_ECCERRF                 CSI_SR0_ECCERRF_Msk                      /*!< ECC error flag */
#define CSI_SR0_CECCERRF_Pos            (26UL)
#define CSI_SR0_CECCERRF_Msk            (0x1UL << CSI_SR0_CECCERRF_Pos)           /*!< 0x04000000 */
#define CSI_SR0_CECCERRF                CSI_SR0_CECCERRF_Msk                     /*!< Corrected ECC error flag */
#define CSI_SR0_IDERRF_Pos              (27UL)
#define CSI_SR0_IDERRF_Msk              (0x1UL << CSI_SR0_IDERRF_Pos)             /*!< 0x08000000 */
#define CSI_SR0_IDERRF                  CSI_SR0_IDERRF_Msk                       /*!< Data type ID error flag */
#define CSI_SR0_SPKTERRF_Pos            (28UL)
#define CSI_SR0_SPKTERRF_Msk            (0x1UL << CSI_SR0_SPKTERRF_Pos)           /*!< 0x10000000 */
#define CSI_SR0_SPKTERRF                CSI_SR0_SPKTERRF_Msk                     /*!< Short packet error flag */
#define CSI_SR0_WDERRF_Pos              (29UL)
#define CSI_SR0_WDERRF_Msk              (0x1UL << CSI_SR0_WDERRF_Pos)             /*!< 0x20000000 */
#define CSI_SR0_WDERRF                  CSI_SR0_WDERRF_Msk                       /*!< Watchdog error flag */
#define CSI_SR0_SYNCERRF_Pos            (30UL)
#define CSI_SR0_SYNCERRF_Msk            (0x1UL << CSI_SR0_SYNCERRF_Pos)           /*!< 0x40000000 */
#define CSI_SR0_SYNCERRF                CSI_SR0_SYNCERRF_Msk                     /*!< Invalid synchronization error flag */

/*******************  Bit definition for CSI_SR1 register  ********************/
#define CSI_SR1_ESOTDL0F_Pos            (0UL)
#define CSI_SR1_ESOTDL0F_Msk            (0x1UL << CSI_SR1_ESOTDL0F_Pos)           /*!< 0x00000001 */
#define CSI_SR1_ESOTDL0F                CSI_SR1_ESOTDL0F_Msk                     /*!< Start of transmission error flag on lane 0 */
#define CSI_SR1_ESOTSYNCDL0F_Pos        (1UL)
#define CSI_SR1_ESOTSYNCDL0F_Msk        (0x1UL << CSI_SR1_ESOTSYNCDL0F_Pos)       /*!< 0x00000002 */
#define CSI_SR1_ESOTSYNCDL0F            CSI_SR1_ESOTSYNCDL0F_Msk                 /*!< Start of transmission synchronization error flag on lane 0 */
#define CSI_SR1_EESCDL0F_Pos            (2UL)
#define CSI_SR1_EESCDL0F_Msk            (0x1UL << CSI_SR1_EESCDL0F_Pos)           /*!< 0x00000004 */
#define CSI_SR1_EESCDL0F                CSI_SR1_EESCDL0F_Msk                     /*!< D-PHY_RX lane 0 escape entry error flag */
#define CSI_SR1_ESYNCESCDL0F_Pos        (3UL)
#define CSI_SR1_ESYNCESCDL0F_Msk        (0x1UL << CSI_SR1_ESYNCESCDL0F_Pos)       /*!< 0x00000008 */
#define CSI_SR1_ESYNCESCDL0F            CSI_SR1_ESYNCESCDL0F_Msk                 /*!< D-PHY_RX lane 0 low power data transmission synchronization error flag */
#define CSI_SR1_ECTRLDL0F_Pos           (4UL)
#define CSI_SR1_ECTRLDL0F_Msk           (0x1UL << CSI_SR1_ECTRLDL0F_Pos)          /*!< 0x00000010 */
#define CSI_SR1_ECTRLDL0F               CSI_SR1_ECTRLDL0F_Msk                    /*!< D-PHY_RX lane 0 control error flag */
#define CSI_SR1_ESOTDL1F_Pos            (8UL)
#define CSI_SR1_ESOTDL1F_Msk            (0x1UL << CSI_SR1_ESOTDL1F_Pos)           /*!< 0x00000100 */
#define CSI_SR1_ESOTDL1F                CSI_SR1_ESOTDL1F_Msk                     /*!< Start of transmission error flag on lane 1 */
#define CSI_SR1_ESOTSYNCDL1F_Pos        (9UL)
#define CSI_SR1_ESOTSYNCDL1F_Msk        (0x1UL << CSI_SR1_ESOTSYNCDL1F_Pos)       /*!< 0x00000200 */
#define CSI_SR1_ESOTSYNCDL1F            CSI_SR1_ESOTSYNCDL1F_Msk                 /*!< Start of transmission synchronization error flag on lane 1 */
#define CSI_SR1_EESCDL1F_Pos            (10UL)
#define CSI_SR1_EESCDL1F_Msk            (0x1UL << CSI_SR1_EESCDL1F_Pos)           /*!< 0x00000400 */
#define CSI_SR1_EESCDL1F                CSI_SR1_EESCDL1F_Msk                     /*!< D-PHY_RX lane 1 escape entry error flag */
#define CSI_SR1_ESYNCESCDL1F_Pos        (11UL)
#define CSI_SR1_ESYNCESCDL1F_Msk        (0x1UL << CSI_SR1_ESYNCESCDL1F_Pos)       /*!< 0x00000800 */
#define CSI_SR1_ESYNCESCDL1F            CSI_SR1_ESYNCESCDL1F_Msk                 /*!< D-PHY_RX lane 1 low power data transmission synchronization error flag */
#define CSI_SR1_ECTRLDL1F_Pos           (12UL)
#define CSI_SR1_ECTRLDL1F_Msk           (0x1UL << CSI_SR1_ECTRLDL1F_Pos)          /*!< 0x00001000 */
#define CSI_SR1_ECTRLDL1F               CSI_SR1_ECTRLDL1F_Msk                    /*!< D-PHY_RX lane 1 control error flag */
#define CSI_SR1_ACTDL0F_Pos             (16UL)
#define CSI_SR1_ACTDL0F_Msk             (0x1UL << CSI_SR1_ACTDL0F_Pos)            /*!< 0x00010000 */
#define CSI_SR1_ACTDL0F                 CSI_SR1_ACTDL0F_Msk                      /*!< D-PHY_RX lane 0 High speed reception active */
#define CSI_SR1_SYNCDL0F_Pos            (17UL)
#define CSI_SR1_SYNCDL0F_Msk            (0x1UL << CSI_SR1_SYNCDL0F_Pos)           /*!< 0x00020000 */
#define CSI_SR1_SYNCDL0F                CSI_SR1_SYNCDL0F_Msk                     /*!< D-PHY_RX lane 0 receiver synchronization observed */
#define CSI_SR1_SKCALDL0F_Pos           (18UL)
#define CSI_SR1_SKCALDL0F_Msk           (0x1UL << CSI_SR1_SKCALDL0F_Pos)          /*!< 0x00040000 */
#define CSI_SR1_SKCALDL0F               CSI_SR1_SKCALDL0F_Msk                    /*!< D-PHY_RX lane 0 High speed skew calibration */
#define CSI_SR1_STOPDL0F_Pos            (19UL)
#define CSI_SR1_STOPDL0F_Msk            (0x1UL << CSI_SR1_STOPDL0F_Pos)           /*!< 0x00080000 */
#define CSI_SR1_STOPDL0F                CSI_SR1_STOPDL0F_Msk                     /*!< D-PHY_RX receiver data lane 0 in stop state */
#define CSI_SR1_ULPNDL0F_Pos            (20UL)
#define CSI_SR1_ULPNDL0F_Msk            (0x1UL << CSI_SR1_ULPNDL0F_Pos)           /*!< 0x00100000 */
#define CSI_SR1_ULPNDL0F                CSI_SR1_ULPNDL0F_Msk                     /*!< D-PHY_RX receiver Ultra low power state (not) Active on data lane 00 */
#define CSI_SR1_ACTDL1F_Pos             (22UL)
#define CSI_SR1_ACTDL1F_Msk             (0x1UL << CSI_SR1_ACTDL1F_Pos)            /*!< 0x00400000 */
#define CSI_SR1_ACTDL1F                 CSI_SR1_ACTDL1F_Msk                      /*!< D-PHY_RX lane 1 High speed reception active */
#define CSI_SR1_SYNCDL1F_Pos            (23UL)
#define CSI_SR1_SYNCDL1F_Msk            (0x1UL << CSI_SR1_SYNCDL1F_Pos)           /*!< 0x00800000 */
#define CSI_SR1_SYNCDL1F                CSI_SR1_SYNCDL1F_Msk                     /*!< D-PHY_RX lane 1 receiver synchronization observed */
#define CSI_SR1_SKCALDL1F_Pos           (24UL)
#define CSI_SR1_SKCALDL1F_Msk           (0x1UL << CSI_SR1_SKCALDL1F_Pos)          /*!< 0x01000000 */
#define CSI_SR1_SKCALDL1F               CSI_SR1_SKCALDL1F_Msk                    /*!< D-PHY_RX lane 1 High speed skew calibration */
#define CSI_SR1_STOPDL1F_Pos            (25UL)
#define CSI_SR1_STOPDL1F_Msk            (0x1UL << CSI_SR1_STOPDL1F_Pos)           /*!< 0x02000000 */
#define CSI_SR1_STOPDL1F                CSI_SR1_STOPDL1F_Msk                     /*!< D-PHY_RX receiver data lane 1 in stop state */
#define CSI_SR1_ULPNDL1F_Pos            (26UL)
#define CSI_SR1_ULPNDL1F_Msk            (0x1UL << CSI_SR1_ULPNDL1F_Pos)           /*!< 0x04000000 */
#define CSI_SR1_ULPNDL1F                CSI_SR1_ULPNDL1F_Msk                     /*!< D-PHY_RX receiver Ultra low power state (not) Active on data lane 1 */
#define CSI_SR1_STOPCLF_Pos             (28UL)
#define CSI_SR1_STOPCLF_Msk             (0x1UL << CSI_SR1_STOPCLF_Pos)            /*!< 0x10000000 */
#define CSI_SR1_STOPCLF                 CSI_SR1_STOPCLF_Msk                      /*!< D-PHY_RX receiver in stop state for the clock lane */
#define CSI_SR1_ULPNACTF_Pos            (29UL)
#define CSI_SR1_ULPNACTF_Msk            (0x1UL << CSI_SR1_ULPNACTF_Pos)           /*!< 0x20000000 */
#define CSI_SR1_ULPNACTF                CSI_SR1_ULPNACTF_Msk                     /*!< D-PHY_RX receiver ULP state (not) active */
#define CSI_SR1_ULPNCLF_Pos             (30UL)
#define CSI_SR1_ULPNCLF_Msk             (0x1UL << CSI_SR1_ULPNCLF_Pos)            /*!< 0x40000000 */
#define CSI_SR1_ULPNCLF                 CSI_SR1_ULPNCLF_Msk                      /*!< D-PHY_RX receiver Ultra-Low power state (not) on clock lane */
#define CSI_SR1_ACTCLF_Pos              (31UL)
#define CSI_SR1_ACTCLF_Msk              (0x1UL << CSI_SR1_ACTCLF_Pos)             /*!< 0x80000000 */
#define CSI_SR1_ACTCLF                  CSI_SR1_ACTCLF_Msk                       /*!< D-PHY_RX receiver clock active flag */

/*******************  Bit definition for CSI_FCR0 register  *******************/
#define CSI_FCR0_CLB0F_Pos              (0UL)
#define CSI_FCR0_CLB0F_Msk              (0x1UL << CSI_FCR0_CLB0F_Pos)             /*!< 0x00000001 */
#define CSI_FCR0_CLB0F                  CSI_FCR0_CLB0F_Msk                       /*!< Clear Line byte counter 0 flag */
#define CSI_FCR0_CLB1F_Pos              (1UL)
#define CSI_FCR0_CLB1F_Msk              (0x1UL << CSI_FCR0_CLB1F_Pos)             /*!< 0x00000002 */
#define CSI_FCR0_CLB1F                  CSI_FCR0_CLB1F_Msk                       /*!< Clear Line byte counter 1 flag */
#define CSI_FCR0_CLB2F_Pos              (2UL)
#define CSI_FCR0_CLB2F_Msk              (0x1UL << CSI_FCR0_CLB2F_Pos)             /*!< 0x00000004 */
#define CSI_FCR0_CLB2F                  CSI_FCR0_CLB2F_Msk                       /*!< Clear Line byte counter 2 flag */
#define CSI_FCR0_CLB3F_Pos              (3UL)
#define CSI_FCR0_CLB3F_Msk              (0x1UL << CSI_FCR0_CLB3F_Pos)             /*!< 0x00000008 */
#define CSI_FCR0_CLB3F                  CSI_FCR0_CLB3F_Msk                       /*!< Clear Line byte counter 3 flag */
#define CSI_FCR0_CTIM0F_Pos             (4UL)
#define CSI_FCR0_CTIM0F_Msk             (0x1UL << CSI_FCR0_CTIM0F_Pos)            /*!< 0x00000010 */
#define CSI_FCR0_CTIM0F                 CSI_FCR0_CTIM0F_Msk                      /*!< Clear Timer 0 flag */
#define CSI_FCR0_CTIM1F_Pos             (5UL)
#define CSI_FCR0_CTIM1F_Msk             (0x1UL << CSI_FCR0_CTIM1F_Pos)            /*!< 0x00000020 */
#define CSI_FCR0_CTIM1F                 CSI_FCR0_CTIM1F_Msk                      /*!< Clear Timer 1 flag */
#define CSI_FCR0_CTIM2F_Pos             (6UL)
#define CSI_FCR0_CTIM2F_Msk             (0x1UL << CSI_FCR0_CTIM2F_Pos)            /*!< 0x00000040 */
#define CSI_FCR0_CTIM2F                 CSI_FCR0_CTIM2F_Msk                      /*!< Clear Timer 2 flag */
#define CSI_FCR0_CTIM3F_Pos             (7UL)
#define CSI_FCR0_CTIM3F_Msk             (0x1UL << CSI_FCR0_CTIM3F_Pos)            /*!< 0x00000080 */
#define CSI_FCR0_CTIM3F                 CSI_FCR0_CTIM3F_Msk                      /*!< Clear Timer 3 flag */
#define CSI_FCR0_CSOF0F_Pos             (8UL)
#define CSI_FCR0_CSOF0F_Msk             (0x1UL << CSI_FCR0_CSOF0F_Pos)            /*!< 0x00000100 */
#define CSI_FCR0_CSOF0F                 CSI_FCR0_CSOF0F_Msk                      /*!< Clear Start of frame flag for virtual channel 0 */
#define CSI_FCR0_CSOF1F_Pos             (9UL)
#define CSI_FCR0_CSOF1F_Msk             (0x1UL << CSI_FCR0_CSOF1F_Pos)            /*!< 0x00000200 */
#define CSI_FCR0_CSOF1F                 CSI_FCR0_CSOF1F_Msk                      /*!< Clear Start of frame flag for virtual channel 1 */
#define CSI_FCR0_CSOF2F_Pos             (10UL)
#define CSI_FCR0_CSOF2F_Msk             (0x1UL << CSI_FCR0_CSOF2F_Pos)            /*!< 0x00000400 */
#define CSI_FCR0_CSOF2F                 CSI_FCR0_CSOF2F_Msk                      /*!< Clear Start of frame flag for virtual channel 2 */
#define CSI_FCR0_CSOF3F_Pos             (11UL)
#define CSI_FCR0_CSOF3F_Msk             (0x1UL << CSI_FCR0_CSOF3F_Pos)            /*!< 0x00000800 */
#define CSI_FCR0_CSOF3F                 CSI_FCR0_CSOF3F_Msk                      /*!< Clear Start of frame flag for virtual channel 3 */
#define CSI_FCR0_CEOF0F_Pos             (12UL)
#define CSI_FCR0_CEOF0F_Msk             (0x1UL << CSI_FCR0_CEOF0F_Pos)            /*!< 0x00001000 */
#define CSI_FCR0_CEOF0F                 CSI_FCR0_CEOF0F_Msk                      /*!< Clear End of frame flag for virtual channel 0 */
#define CSI_FCR0_CEOF1F_Pos             (13UL)
#define CSI_FCR0_CEOF1F_Msk             (0x1UL << CSI_FCR0_CEOF1F_Pos)            /*!< 0x00002000 */
#define CSI_FCR0_CEOF1F                 CSI_FCR0_CEOF1F_Msk                      /*!< Clear End of frame flag for virtual channel 1 */
#define CSI_FCR0_CEOF2F_Pos             (14UL)
#define CSI_FCR0_CEOF2F_Msk             (0x1UL << CSI_FCR0_CEOF2F_Pos)            /*!< 0x00004000 */
#define CSI_FCR0_CEOF2F                 CSI_FCR0_CEOF2F_Msk                      /*!< Clear End of frame flag for virtual channel 2 */
#define CSI_FCR0_CEOF3F_Pos             (15UL)
#define CSI_FCR0_CEOF3F_Msk             (0x1UL << CSI_FCR0_CEOF3F_Pos)            /*!< 0x00008000 */
#define CSI_FCR0_CEOF3F                 CSI_FCR0_CEOF3F_Msk                      /*!< Clear End of frame flag for virtual channel 3 */
#define CSI_FCR0_CSPKTF_Pos             (16UL)
#define CSI_FCR0_CSPKTF_Msk             (0x1UL << CSI_FCR0_CSPKTF_Pos)            /*!< 0x00010000 */
#define CSI_FCR0_CSPKTF                 CSI_FCR0_CSPKTF_Msk                      /*!< Clear Short packet flag */
#define CSI_FCR0_CCCFIFOFF_Pos          (21UL)
#define CSI_FCR0_CCCFIFOFF_Msk          (0x1UL << CSI_FCR0_CCCFIFOFF_Pos)         /*!< 0x00200000 */
#define CSI_FCR0_CCCFIFOFF              CSI_FCR0_CCCFIFOFF_Msk                   /*!< Clear Clock changer FIFO full flag */
#define CSI_FCR0_CCRCERRF_Pos           (24UL)
#define CSI_FCR0_CCRCERRF_Msk           (0x1UL << CSI_FCR0_CCRCERRF_Pos)          /*!< 0x01000000 */
#define CSI_FCR0_CCRCERRF               CSI_FCR0_CCRCERRF_Msk                    /*!< Clear CRC error flag */
#define CSI_FCR0_CECCERRF_Pos           (25UL)
#define CSI_FCR0_CECCERRF_Msk           (0x1UL << CSI_FCR0_CECCERRF_Pos)          /*!< 0x02000000 */
#define CSI_FCR0_CECCERRF               CSI_FCR0_CECCERRF_Msk                    /*!< Clear ECC error flag */
#define CSI_FCR0_CCECCERRF_Pos          (26UL)
#define CSI_FCR0_CCECCERRF_Msk          (0x1UL << CSI_FCR0_CCECCERRF_Pos)         /*!< 0x04000000 */
#define CSI_FCR0_CCECCERRF              CSI_FCR0_CCECCERRF_Msk                   /*!< Clear Corrected ECC error flag */
#define CSI_FCR0_CIDERRF_Pos            (27UL)
#define CSI_FCR0_CIDERRF_Msk            (0x1UL << CSI_FCR0_CIDERRF_Pos)           /*!< 0x08000000 */
#define CSI_FCR0_CIDERRF                CSI_FCR0_CIDERRF_Msk                     /*!< Clear Data type ID error flag */
#define CSI_FCR0_CSPKTERRF_Pos          (28UL)
#define CSI_FCR0_CSPKTERRF_Msk          (0x1UL << CSI_FCR0_CSPKTERRF_Pos)         /*!< 0x10000000 */
#define CSI_FCR0_CSPKTERRF              CSI_FCR0_CSPKTERRF_Msk                   /*!< Clear Short packet error flag */
#define CSI_FCR0_CWDERRF_Pos            (29UL)
#define CSI_FCR0_CWDERRF_Msk            (0x1UL << CSI_FCR0_CWDERRF_Pos)           /*!< 0x20000000 */
#define CSI_FCR0_CWDERRF                CSI_FCR0_CWDERRF_Msk                     /*!< Clear Watchdog error flag */
#define CSI_FCR0_CSYNCERRF_Pos          (30UL)
#define CSI_FCR0_CSYNCERRF_Msk          (0x1UL << CSI_FCR0_CSYNCERRF_Pos)         /*!< 0x40000000 */
#define CSI_FCR0_CSYNCERRF              CSI_FCR0_CSYNCERRF_Msk                   /*!< Clear Invalid synchronization error flag */

/*******************  Bit definition for CSI_FCR1 register  *******************/
#define CSI_FCR1_CESOTDL0F_Pos          (0UL)
#define CSI_FCR1_CESOTDL0F_Msk          (0x1UL << CSI_FCR1_CESOTDL0F_Pos)         /*!< 0x00000001 */
#define CSI_FCR1_CESOTDL0F              CSI_FCR1_CESOTDL0F_Msk                   /*!< Clear Start of transmission error flag on lane 0 */
#define CSI_FCR1_CESOTSYNCDL0F_Pos      (1UL)
#define CSI_FCR1_CESOTSYNCDL0F_Msk      (0x1UL << CSI_FCR1_CESOTSYNCDL0F_Pos)     /*!< 0x00000002 */
#define CSI_FCR1_CESOTSYNCDL0F          CSI_FCR1_CESOTSYNCDL0F_Msk               /*!< Clear Start of transmission synchronization error flag on lane 0 */
#define CSI_FCR1_CEESCDL0F_Pos          (2UL)
#define CSI_FCR1_CEESCDL0F_Msk          (0x1UL << CSI_FCR1_CEESCDL0F_Pos)         /*!< 0x00000004 */
#define CSI_FCR1_CEESCDL0F              CSI_FCR1_CEESCDL0F_Msk                   /*!< Clear D-PHY_RX lane 0 escape entry error flag */
#define CSI_FCR1_CESYNCESCDL0F_Pos      (3UL)
#define CSI_FCR1_CESYNCESCDL0F_Msk      (0x1UL << CSI_FCR1_CESYNCESCDL0F_Pos)     /*!< 0x00000008 */
#define CSI_FCR1_CESYNCESCDL0F          CSI_FCR1_CESYNCESCDL0F_Msk               /*!< Clear D-PHY_RX lane 0 low power data transmission synchronization error flag */
#define CSI_FCR1_CECTRLDL0F_Pos         (4UL)
#define CSI_FCR1_CECTRLDL0F_Msk         (0x1UL << CSI_FCR1_CECTRLDL0F_Pos)        /*!< 0x00000010 */
#define CSI_FCR1_CECTRLDL0F             CSI_FCR1_CECTRLDL0F_Msk                  /*!< Clear D-PHY_RX lane 0 control error flag */
#define CSI_FCR1_CESOTDL1F_Pos          (8UL)
#define CSI_FCR1_CESOTDL1F_Msk          (0x1UL << CSI_FCR1_CESOTDL1F_Pos)         /*!< 0x00000100 */
#define CSI_FCR1_CESOTDL1F              CSI_FCR1_CESOTDL1F_Msk                   /*!< Clear Start of transmission error flag on lane 1 */
#define CSI_FCR1_CESOTSYNCDL1F_Pos      (9UL)
#define CSI_FCR1_CESOTSYNCDL1F_Msk      (0x1UL << CSI_FCR1_CESOTSYNCDL1F_Pos)     /*!< 0x00000200 */
#define CSI_FCR1_CESOTSYNCDL1F          CSI_FCR1_CESOTSYNCDL1F_Msk               /*!< Clear Start of transmission synchronization error flag on lane 1 */
#define CSI_FCR1_CEESCDL1F_Pos          (10UL)
#define CSI_FCR1_CEESCDL1F_Msk          (0x1UL << CSI_FCR1_CEESCDL1F_Pos)         /*!< 0x00000400 */
#define CSI_FCR1_CEESCDL1F              CSI_FCR1_CEESCDL1F_Msk                   /*!< Clear D-PHY_RX lane 1 escape entry error flag */
#define CSI_FCR1_CESYNCESCDL1F_Pos      (11UL)
#define CSI_FCR1_CESYNCESCDL1F_Msk      (0x1UL << CSI_FCR1_CESYNCESCDL1F_Pos)     /*!< 0x00000800 */
#define CSI_FCR1_CESYNCESCDL1F          CSI_FCR1_CESYNCESCDL1F_Msk               /*!< Clear D-PHY_RX lane 1 low power data transmission synchronization error flag */
#define CSI_FCR1_CECTRLDL1F_Pos         (12UL)
#define CSI_FCR1_CECTRLDL1F_Msk         (0x1UL << CSI_FCR1_CECTRLDL1F_Pos)        /*!< 0x00001000 */
#define CSI_FCR1_CECTRLDL1F             CSI_FCR1_CECTRLDL1F_Msk                  /*!< Clear D-PHY_RX lane 1 control error flag */

/******************  Bit definition for CSI_SPDFR register  *******************/
#define CSI_SPDFR_DATAFIELD_Pos         (0UL)
#define CSI_SPDFR_DATAFIELD_Msk         (0xFFFFUL << CSI_SPDFR_DATAFIELD_Pos)     /*!< 0x0000FFFF */
#define CSI_SPDFR_DATAFIELD             CSI_SPDFR_DATAFIELD_Msk                  /*!< Data field */
#define CSI_SPDFR_DATATYPE_Pos          (16UL)
#define CSI_SPDFR_DATATYPE_Msk          (0x3FUL << CSI_SPDFR_DATATYPE_Pos)        /*!< 0x003F0000 */
#define CSI_SPDFR_DATATYPE              CSI_SPDFR_DATATYPE_Msk                   /*!< Data type class */
#define CSI_SPDFR_VCHANNEL_Pos          (22UL)
#define CSI_SPDFR_VCHANNEL_Msk          (0x3UL << CSI_SPDFR_VCHANNEL_Pos)         /*!< 0x00C00000 */
#define CSI_SPDFR_VCHANNEL              CSI_SPDFR_VCHANNEL_Msk                   /*!< Virtual channel */

/*******************  Bit definition for CSI_ERR1 register  *******************/
#define CSI_ERR1_CRCDTERR_Pos           (0UL)
#define CSI_ERR1_CRCDTERR_Msk           (0x3FUL << CSI_ERR1_CRCDTERR_Pos)         /*!< 0x0000003F */
#define CSI_ERR1_CRCDTERR               CSI_ERR1_CRCDTERR_Msk                    /*!< Data type having a CRC error */
#define CSI_ERR1_CRCVCERR_Pos           (6UL)
#define CSI_ERR1_CRCVCERR_Msk           (0x3UL << CSI_ERR1_CRCVCERR_Pos)          /*!< 0x000000C0 */
#define CSI_ERR1_CRCVCERR               CSI_ERR1_CRCVCERR_Msk                    /*!< Virtual channel having a CRC error */
#define CSI_ERR1_CECCDTERR_Pos          (8UL)
#define CSI_ERR1_CECCDTERR_Msk          (0x3FUL << CSI_ERR1_CECCDTERR_Pos)        /*!< 0x00003F00 */
#define CSI_ERR1_CECCDTERR              CSI_ERR1_CECCDTERR_Msk                   /*!< Data type having a corrected ECC error */
#define CSI_ERR1_CECCVCERR_Pos          (14UL)
#define CSI_ERR1_CECCVCERR_Msk          (0x3UL << CSI_ERR1_CECCVCERR_Pos)         /*!< 0x0000C000 */
#define CSI_ERR1_CECCVCERR              CSI_ERR1_CECCVCERR_Msk                   /*!< Virtual channel having a corrected ECC error */
#define CSI_ERR1_IDDTERR_Pos            (16UL)
#define CSI_ERR1_IDDTERR_Msk            (0x3FUL << CSI_ERR1_IDDTERR_Pos)          /*!< 0x003F0000 */
#define CSI_ERR1_IDDTERR                CSI_ERR1_IDDTERR_Msk                     /*!< Data type in error */
#define CSI_ERR1_IDVCERR_Pos            (22UL)
#define CSI_ERR1_IDVCERR_Msk            (0x3UL << CSI_ERR1_IDVCERR_Pos)           /*!< 0x00C00000 */
#define CSI_ERR1_IDVCERR                CSI_ERR1_IDVCERR_Msk                     /*!< Virtual channel having ID error */

/*******************  Bit definition for CSI_ERR2 register  *******************/
#define CSI_ERR2_SPKTDTERR_Pos          (0UL)
#define CSI_ERR2_SPKTDTERR_Msk          (0x3FUL << CSI_ERR2_SPKTDTERR_Pos)        /*!< 0x0000003F */
#define CSI_ERR2_SPKTDTERR              CSI_ERR2_SPKTDTERR_Msk                   /*!< Data type having a short packet error */
#define CSI_ERR2_SPKTVCERR_Pos          (6UL)
#define CSI_ERR2_SPKTVCERR_Msk          (0x3UL << CSI_ERR2_SPKTVCERR_Pos)         /*!< 0x000000C0 */
#define CSI_ERR2_SPKTVCERR              CSI_ERR2_SPKTVCERR_Msk                   /*!< Virtual channel having a short packet error */
#define CSI_ERR2_WDVCERR_Pos            (16UL)
#define CSI_ERR2_WDVCERR_Msk            (0x3UL << CSI_ERR2_WDVCERR_Pos)           /*!< 0x00030000 */
#define CSI_ERR2_WDVCERR                CSI_ERR2_WDVCERR_Msk                     /*!< Virtual channel having a watchdog error */
#define CSI_ERR2_SYNCVCERR_Pos          (18UL)
#define CSI_ERR2_SYNCVCERR_Msk          (0x3UL << CSI_ERR2_SYNCVCERR_Pos)         /*!< 0x000C0000 */
#define CSI_ERR2_SYNCVCERR              CSI_ERR2_SYNCVCERR_Msk                   /*!< Virtual channel having synchronization error */

/*******************  Bit definition for CSI_PRCR register  *******************/
#define CSI_PRCR_PEN_Pos                (1UL)
#define CSI_PRCR_PEN_Msk                (0x1UL << CSI_PRCR_PEN_Pos)               /*!< 0x00000002 */
#define CSI_PRCR_PEN                    CSI_PRCR_PEN_Msk                         /*!< When set to 0, this bit places the digital section of the D-PHY in the reset state */

/*******************  Bit definition for CSI_PMCR register  *******************/
#define CSI_PMCR_FRXMDL0_Pos            (0UL)
#define CSI_PMCR_FRXMDL0_Msk            (0x1UL << CSI_PMCR_FRXMDL0_Pos)           /*!< 0x00000001 */
#define CSI_PMCR_FRXMDL0                CSI_PMCR_FRXMDL0_Msk                     /*!< Force to Rx Mode the Data Lane 0 */
#define CSI_PMCR_FRXMDL1_Pos            (1UL)
#define CSI_PMCR_FRXMDL1_Msk            (0x1UL << CSI_PMCR_FRXMDL1_Pos)           /*!< 0x00000002 */
#define CSI_PMCR_FRXMDL1                CSI_PMCR_FRXMDL1_Msk                     /*!< Force to Rx Mode the Data Lane 1 */
#define CSI_PMCR_FTXSMDL0_Pos           (2UL)
#define CSI_PMCR_FTXSMDL0_Msk           (0x1UL << CSI_PMCR_FTXSMDL0_Pos)          /*!< 0x00000004 */
#define CSI_PMCR_FTXSMDL0               CSI_PMCR_FTXSMDL0_Msk                    /*!< Force to Tx Stop Mode the Data Lane 0 */
#define CSI_PMCR_DTDL_Pos               (4UL)
#define CSI_PMCR_DTDL_Msk               (0x1UL << CSI_PMCR_DTDL_Pos)              /*!< 0x00000010 */
#define CSI_PMCR_DTDL                   CSI_PMCR_DTDL_Msk                        /*!< Disable Turn-around Data Lane 0 */
#define CSI_PMCR_RTDL0_Pos              (8UL)
#define CSI_PMCR_RTDL0_Msk              (0x1UL << CSI_PMCR_RTDL0_Pos)             /*!< 0x00000100 */
#define CSI_PMCR_RTDL0                  CSI_PMCR_RTDL0_Msk                       /*!< Turn-around Request Data Lane 0 */
#define CSI_PMCR_TUESDL0_Pos            (12UL)
#define CSI_PMCR_TUESDL0_Msk            (0x1UL << CSI_PMCR_TUESDL0_Pos)           /*!< 0x00001000 */
#define CSI_PMCR_TUESDL0                CSI_PMCR_TUESDL0_Msk                     /*!< Tx ULP Escape-mode Data Lane 0 */
#define CSI_PMCR_TUEXDL0_Pos            (16UL)
#define CSI_PMCR_TUEXDL0_Msk            (0x1UL << CSI_PMCR_TUEXDL0_Pos)           /*!< 0x00010000 */
#define CSI_PMCR_TUEXDL0                CSI_PMCR_TUEXDL0_Msk                     /*!< Tx ULP Exit-sequence Data Lane 0 */

/*******************  Bit definition for CSI_PFCR register  *******************/
#define CSI_PFCR_CCFR_Pos               (0UL)
#define CSI_PFCR_CCFR_Msk               (0x3FUL << CSI_PFCR_CCFR_Pos)             /*!< 0x0000003F */
#define CSI_PFCR_CCFR                   CSI_PFCR_CCFR_Msk                        /*!< Configuration Clock Frequency Range selection */
#define CSI_PFCR_HSFR_Pos               (8UL)
#define CSI_PFCR_HSFR_Msk               (0x7FUL << CSI_PFCR_HSFR_Pos)             /*!< 0x00007F00 */
#define CSI_PFCR_HSFR                   CSI_PFCR_HSFR_Msk                        /*!< PHY-high-speed Frequency Range selection */
#define CSI_PFCR_DLD_Pos                (16UL)
#define CSI_PFCR_DLD_Msk                (0x1UL << CSI_PFCR_DLD_Pos)               /*!< 0x00010000 */
#define CSI_PFCR_DLD                    CSI_PFCR_DLD_Msk                         /*!< Data Lane Direction of lane0 */

/******************  Bit definition for CSI_PTCR0 register  *******************/
#define CSI_PTCR0_TCKEN_Pos             (0UL)
#define CSI_PTCR0_TCKEN_Msk             (0x1UL << CSI_PTCR0_TCKEN_Pos)            /*!< 0x00000001 */
#define CSI_PTCR0_TCKEN                 CSI_PTCR0_TCKEN_Msk                      /*!< Test-interface Clock Enable for the TDI bus into the PHY */
#define CSI_PTCR0_TRSEN_Pos             (1UL)
#define CSI_PTCR0_TRSEN_Msk             (0x1UL << CSI_PTCR0_TRSEN_Pos)            /*!< 0x00000002 */
#define CSI_PTCR0_TRSEN                 CSI_PTCR0_TRSEN_Msk                      /*!< Test-interface Reset Enable for the TDI bus into the PHY */

/******************  Bit definition for CSI_PTCR1 register  *******************/
#define CSI_PTCR1_TDI_Pos               (0UL)
#define CSI_PTCR1_TDI_Msk               (0xFFUL << CSI_PTCR1_TDI_Pos)             /*!< 0x000000FF */
#define CSI_PTCR1_TDI                   CSI_PTCR1_TDI_Msk                        /*!< Test-interface Data In */
#define CSI_PTCR1_TWM_Pos               (16UL)
#define CSI_PTCR1_TWM_Msk               (0x1UL << CSI_PTCR1_TWM_Pos)              /*!< 0x00010000 */
#define CSI_PTCR1_TWM                   CSI_PTCR1_TWM_Msk                        /*!< Test-interface Write Mode selector */

/*******************  Bit definition for CSI_PTSR register  *******************/
#define CSI_PTSR_TDO_Pos                (0UL)
#define CSI_PTSR_TDO_Msk                (0xFFUL << CSI_PTSR_TDO_Pos)              /*!< 0x000000FF */
#define CSI_PTSR_TDO                    CSI_PTSR_TDO_Msk                         /*!< CSI PHY test interface data output bus for read-back and internal probing functionalities */


/*********************************************************************************/
/*                                                                               */
/*                                DBGMCU                                         */
/*                                                                               */
/*********************************************************************************/
/********************  Bit definition for DBGMCU_IDCODE register  ****************/
#define DBGMCU_IDCODE_DEV_ID_Pos             (0UL)
#define DBGMCU_IDCODE_DEV_ID_Msk             (0xFFFUL << DBGMCU_IDCODE_DEV_ID_Pos)          /*!< 0x00000FFF */
#define DBGMCU_IDCODE_DEV_ID                 DBGMCU_IDCODE_DEV_ID_Msk                       /*!< Device ID */
#define DBGMCU_IDCODE_REV_ID_Pos             (16UL)
#define DBGMCU_IDCODE_REV_ID_Msk             (0xFFFFUL << DBGMCU_IDCODE_REV_ID_Pos)         /*!< 0xFFFF0000 */
#define DBGMCU_IDCODE_REV_ID                 DBGMCU_IDCODE_REV_ID_Msk                       /*!< Revision ID */

/********************  Bit definition for DBGMCU_CR register  ********************/
#define DBGMCU_CR_DBG_SLEEP_Pos              (0UL)
#define DBGMCU_CR_DBG_SLEEP_Msk              (0x1UL << DBGMCU_CR_DBG_SLEEP_Pos)             /*!< 0x00000001 */
#define DBGMCU_CR_DBG_SLEEP                  DBGMCU_CR_DBG_SLEEP_Msk                        /*!< Allow debug in Sleep mode */
#define DBGMCU_CR_DBG_STOP_Pos               (1UL)
#define DBGMCU_CR_DBG_STOP_Msk               (0x1UL << DBGMCU_CR_DBG_STOP_Pos)              /*!< 0x00000002 */
#define DBGMCU_CR_DBG_STOP                   DBGMCU_CR_DBG_STOP_Msk                         /*!< Allow debug in Stop mode */
#define DBGMCU_CR_DBG_STANDBY_Pos            (2UL)
#define DBGMCU_CR_DBG_STANDBY_Msk            (0x1UL << DBGMCU_CR_DBG_STANDBY_Pos)           /*!< 0x00000004 */
#define DBGMCU_CR_DBG_STANDBY                DBGMCU_CR_DBG_STANDBY_Msk                      /*!< Allow debug in Standby mode */
#define DBGMCU_CR_DBGCLKEN_Pos               (20UL)
#define DBGMCU_CR_DBGCLKEN_Msk               (0x1UL << DBGMCU_CR_DBGCLKEN_Pos)              /*!< 0x00100000 */
#define DBGMCU_CR_DBGCLKEN                   DBGMCU_CR_DBGCLKEN_Msk                         /*!< Debug clock enable through software */
#define DBGMCU_CR_TRACECLKEN_Pos             (21UL)
#define DBGMCU_CR_TRACECLKEN_Msk             (0x1UL << DBGMCU_CR_TRACECLKEN_Pos)            /*!< 0x00200000 */
#define DBGMCU_CR_TRACECLKEN                 DBGMCU_CR_TRACECLKEN_Msk                       /*!< TPIU export clock enable through software */
#define DBGMCU_CR_DBTRGOEN_Pos               (28UL)
#define DBGMCU_CR_DBTRGOEN_Msk               (0x1UL << DBGMCU_CR_DBTRGOEN_Pos)              /*!< 0x10000000 */
#define DBGMCU_CR_DBTRGOEN                   DBGMCU_CR_DBTRGOEN_Msk                         /*!< DBTRGIO connection control */
#define DBGMCU_CR_HLT_TSGEN_EN_Pos           (31UL)
#define DBGMCU_CR_HLT_TSGEN_EN_Msk           (0x1UL << DBGMCU_CR_HLT_TSGEN_EN_Pos)          /*!< 0x80000000 */
#define DBGMCU_CR_HLT_TSGEN_EN               DBGMCU_CR_HLT_TSGEN_EN_Msk                     /*!< TSGEN halt enable */

/********************  Bit definition for DBGMCU_APB1LFZ1 register  ***************/
#define DBGMCU_APB1LFZ1_DBG_TIM2_STOP_Pos    (0UL)
#define DBGMCU_APB1LFZ1_DBG_TIM2_STOP_Msk    (0x1UL << DBGMCU_APB1LFZ1_DBG_TIM2_STOP_Pos)   /*!< 0x00000001 */
#define DBGMCU_APB1LFZ1_DBG_TIM2_STOP        DBGMCU_APB1LFZ1_DBG_TIM2_STOP_Msk              /*!< TIM2 stop in debug */
#define DBGMCU_APB1LFZ1_DBG_TIM3_STOP_Pos    (1UL)
#define DBGMCU_APB1LFZ1_DBG_TIM3_STOP_Msk    (0x1UL << DBGMCU_APB1LFZ1_DBG_TIM3_STOP_Pos)   /*!< 0x00000002 */
#define DBGMCU_APB1LFZ1_DBG_TIM3_STOP        DBGMCU_APB1LFZ1_DBG_TIM3_STOP_Msk              /*!< TIM3 stop in debug */
#define DBGMCU_APB1LFZ1_DBG_TIM4_STOP_Pos    (2UL)
#define DBGMCU_APB1LFZ1_DBG_TIM4_STOP_Msk    (0x1UL << DBGMCU_APB1LFZ1_DBG_TIM4_STOP_Pos)   /*!< 0x00000004 */
#define DBGMCU_APB1LFZ1_DBG_TIM4_STOP        DBGMCU_APB1LFZ1_DBG_TIM4_STOP_Msk              /*!< TIM4 stop in debug */
#define DBGMCU_APB1LFZ1_DBG_TIM5_STOP_Pos    (3UL)
#define DBGMCU_APB1LFZ1_DBG_TIM5_STOP_Msk    (0x1UL << DBGMCU_APB1LFZ1_DBG_TIM5_STOP_Pos)   /*!< 0x00000008 */
#define DBGMCU_APB1LFZ1_DBG_TIM5_STOP        DBGMCU_APB1LFZ1_DBG_TIM5_STOP_Msk              /*!< TIM5 stop in debug */
#define DBGMCU_APB1LFZ1_DBG_TIM6_STOP_Pos    (4UL)
#define DBGMCU_APB1LFZ1_DBG_TIM6_STOP_Msk    (0x1UL << DBGMCU_APB1LFZ1_DBG_TIM6_STOP_Pos)   /*!< 0x00000010 */
#define DBGMCU_APB1LFZ1_DBG_TIM6_STOP        DBGMCU_APB1LFZ1_DBG_TIM6_STOP_Msk              /*!< TIM6 stop in debug */
#define DBGMCU_APB1LFZ1_DBG_TIM7_STOP_Pos    (5UL)
#define DBGMCU_APB1LFZ1_DBG_TIM7_STOP_Msk    (0x1UL << DBGMCU_APB1LFZ1_DBG_TIM7_STOP_Pos)  /*!< 0x00000020 */
#define DBGMCU_APB1LFZ1_DBG_TIM7_STOP        DBGMCU_APB1LFZ1_DBG_TIM7_STOP_Msk             /*!< TIM7 stop in debug */
#define DBGMCU_APB1LFZ1_DBG_TIM12_STOP_Pos   (6UL)
#define DBGMCU_APB1LFZ1_DBG_TIM12_STOP_Msk   (0x1UL << DBGMCU_APB1LFZ1_DBG_TIM12_STOP_Pos)  /*!< 0x00000040 */
#define DBGMCU_APB1LFZ1_DBG_TIM12_STOP       DBGMCU_APB1LFZ1_DBG_TIM12_STOP_Msk             /*!< TIM12 stop in debug */
#define DBGMCU_APB1LFZ1_DBG_TIM13_STOP_Pos   (7UL)
#define DBGMCU_APB1LFZ1_DBG_TIM13_STOP_Msk   (0x1UL << DBGMCU_APB1LFZ1_DBG_TIM13_STOP_Pos)  /*!< 0x00000080 */
#define DBGMCU_APB1LFZ1_DBG_TIM13_STOP       DBGMCU_APB1LFZ1_DBG_TIM13_STOP_Msk             /*!< TIM13 stop in debug */
#define DBGMCU_APB1LFZ1_DBG_TIM14_STOP_Pos   (8UL)
#define DBGMCU_APB1LFZ1_DBG_TIM14_STOP_Msk   (0x1UL << DBGMCU_APB1LFZ1_DBG_TIM14_STOP_Pos)  /*!< 0x00000100 */
#define DBGMCU_APB1LFZ1_DBG_TIM14_STOP       DBGMCU_APB1LFZ1_DBG_TIM14_STOP_Msk             /*!< TIM14 stop in debug */
#define DBGMCU_APB1LFZ1_DBG_LPTIM1_STOP_Pos  (9UL)
#define DBGMCU_APB1LFZ1_DBG_LPTIM1_STOP_Msk  (0x1UL << DBGMCU_APB1LFZ1_DBG_LPTIM1_STOP_Pos) /*!< 0x00000200 */
#define DBGMCU_APB1LFZ1_DBG_LPTIM1_STOP      DBGMCU_APB1LFZ1_DBG_LPTIM1_STOP_Msk            /*!< LPTIM1 stop in debug */
#define DBGMCU_APB1LFZ1_DBG_WWDG1_STOP_Pos   (11UL)
#define DBGMCU_APB1LFZ1_DBG_WWDG1_STOP_Msk   (0x1UL << DBGMCU_APB1LFZ1_DBG_WWDG1_STOP_Pos)  /*!< 0x00000800 */
#define DBGMCU_APB1LFZ1_DBG_WWDG1_STOP       DBGMCU_APB1LFZ1_DBG_WWDG1_STOP_Msk             /*!< WWDG1 stop in debug */
#define DBGMCU_APB1LFZ1_DBG_TIM10_STOP_Pos   (12UL)
#define DBGMCU_APB1LFZ1_DBG_TIM10_STOP_Msk   (0x1UL << DBGMCU_APB1LFZ1_DBG_TIM10_STOP_Pos)  /*!< 0x00001000 */
#define DBGMCU_APB1LFZ1_DBG_TIM10_STOP       DBGMCU_APB1LFZ1_DBG_TIM10_STOP_Msk             /*!< TIM10 stop in debug */
#define DBGMCU_APB1LFZ1_DBG_TIM11_STOP_Pos   (13UL)
#define DBGMCU_APB1LFZ1_DBG_TIM11_STOP_Msk   (0x1UL << DBGMCU_APB1LFZ1_DBG_TIM11_STOP_Pos)  /*!< 0x00002000 */
#define DBGMCU_APB1LFZ1_DBG_TIM11_STOP       DBGMCU_APB1LFZ1_DBG_TIM11_STOP_Msk             /*!< TIM11 stop in debug */
#define DBGMCU_APB1LFZ1_DBG_I2C1_STOP_Pos    (21UL)
#define DBGMCU_APB1LFZ1_DBG_I2C1_STOP_Msk    (0x1UL << DBGMCU_APB1LFZ1_DBG_I2C1_STOP_Pos)   /*!< 0x00200000 */
#define DBGMCU_APB1LFZ1_DBG_I2C1_STOP        DBGMCU_APB1LFZ1_DBG_I2C1_STOP_Msk              /*!< I2C1 SMBUS timeout stop in debug */
#define DBGMCU_APB1LFZ1_DBG_I2C2_STOP_Pos    (22UL)
#define DBGMCU_APB1LFZ1_DBG_I2C2_STOP_Msk    (0x1UL << DBGMCU_APB1LFZ1_DBG_I2C2_STOP_Pos)   /*!< 0x00400000 */
#define DBGMCU_APB1LFZ1_DBG_I2C2_STOP        DBGMCU_APB1LFZ1_DBG_I2C2_STOP_Msk              /*!< I2C2 SMBUS timeout stop in debug */
#define DBGMCU_APB1LFZ1_DBG_I2C3_STOP_Pos    (23UL)
#define DBGMCU_APB1LFZ1_DBG_I2C3_STOP_Msk    (0x1UL << DBGMCU_APB1LFZ1_DBG_I2C3_STOP_Pos)   /*!< 0x00800000 */
#define DBGMCU_APB1LFZ1_DBG_I2C3_STOP        DBGMCU_APB1LFZ1_DBG_I2C3_STOP_Msk              /*!< I2C3 SMBUS timeout stop in debug */
#define DBGMCU_APB1LFZ1_DBG_I3C1_STOP_Pos    (24UL)
#define DBGMCU_APB1LFZ1_DBG_I3C1_STOP_Msk    (0x1UL << DBGMCU_APB1LFZ1_DBG_I3C1_STOP_Pos)   /*!< 0x01000000 */
#define DBGMCU_APB1LFZ1_DBG_I3C1_STOP        DBGMCU_APB1LFZ1_DBG_I3C1_STOP_Msk              /*!< I3C1 SMBUS timeout stop in debug */
#define DBGMCU_APB1LFZ1_DBG_I3C2_STOP_Pos    (25UL)
#define DBGMCU_APB1LFZ1_DBG_I3C2_STOP_Msk    (0x1UL << DBGMCU_APB1LFZ1_DBG_I3C2_STOP_Pos)   /*!< 0x00008000 */
#define DBGMCU_APB1LFZ1_DBG_I3C2_STOP        DBGMCU_APB1LFZ1_DBG_I3C2_STOP_Msk              /*!< I3C2 SMBUS timeout stop in debug */

/********************  Bit definition for DBGMCU_APB1HFZ1 register  ***************/
#define DBGMCU_APB1HFZ1_DBG_FDCAN_STOP_Pos   (8UL)
#define DBGMCU_APB1HFZ1_DBG_FDCAN_STOP_Msk   (0x1UL << DBGMCU_APB1HFZ1_DBG_FDCAN_STOP_Pos)  /*!< 0x00000100 */
#define DBGMCU_APB1HFZ1_DBG_FDCAN_STOP       DBGMCU_APB1HFZ1_DBG_FDCAN_STOP_Msk             /*!< FDCAN stop in debug */

/********************  Bit definition for DBGMCU_APB2FZ1 register  ***************/
#define DBGMCU_APB2FZ1_DBG_TIM1_STOP_Pos     (0UL)
#define DBGMCU_APB2FZ1_DBG_TIM1_STOP_Msk     (0x1UL << DBGMCU_APB2FZ1_DBG_TIM1_STOP_Pos)    /*!< 0x00000001 */
#define DBGMCU_APB2FZ1_DBG_TIM1_STOP         DBGMCU_APB2FZ1_DBG_TIM1_STOP_Msk               /*!< TIM1 stop in debug */
#define DBGMCU_APB2FZ1_DBG_TIM8_STOP_Pos     (1UL)
#define DBGMCU_APB2FZ1_DBG_TIM8_STOP_Msk     (0x1UL << DBGMCU_APB2FZ1_DBG_TIM8_STOP_Pos)    /*!< 0x00000002 */
#define DBGMCU_APB2FZ1_DBG_TIM8_STOP         DBGMCU_APB2FZ1_DBG_TIM8_STOP_Msk               /*!< TIM8 stop in debug */
#define DBGMCU_APB2FZ1_DBG_TIM18_STOP_Pos    (15UL)
#define DBGMCU_APB2FZ1_DBG_TIM18_STOP_Msk    (0x1UL << DBGMCU_APB2FZ1_DBG_TIM18_STOP_Pos)   /*!< 0x00008000 */
#define DBGMCU_APB2FZ1_DBG_TIM18_STOP        DBGMCU_APB2FZ1_DBG_TIM18_STOP_Msk              /*!< TIM18 stop in debug */
#define DBGMCU_APB2FZ1_DBG_TIM15_STOP_Pos    (16UL)
#define DBGMCU_APB2FZ1_DBG_TIM15_STOP_Msk    (0x1UL << DBGMCU_APB2FZ1_DBG_TIM15_STOP_Pos)   /*!< 0x00010000 */
#define DBGMCU_APB2FZ1_DBG_TIM15_STOP        DBGMCU_APB2FZ1_DBG_TIM15_STOP_Msk              /*!< TIM15 stop in debug */
#define DBGMCU_APB2FZ1_DBG_TIM16_STOP_Pos    (17UL)
#define DBGMCU_APB2FZ1_DBG_TIM16_STOP_Msk    (0x1UL << DBGMCU_APB2FZ1_DBG_TIM16_STOP_Pos)   /*!< 0x00020000 */
#define DBGMCU_APB2FZ1_DBG_TIM16_STOP        DBGMCU_APB2FZ1_DBG_TIM16_STOP_Msk              /*!< TIM16 stop in debug */
#define DBGMCU_APB2FZ1_DBG_TIM17_STOP_Pos    (18UL)
#define DBGMCU_APB2FZ1_DBG_TIM17_STOP_Msk    (0x1UL << DBGMCU_APB2FZ1_DBG_TIM17_STOP_Pos)   /*!< 0x00040000 */
#define DBGMCU_APB2FZ1_DBG_TIM17_STOP        DBGMCU_APB2FZ1_DBG_TIM17_STOP_Msk              /*!< TIM17 stop in debug */
#define DBGMCU_APB2FZ1_DBG_TIM9_STOP_Pos     (19UL)
#define DBGMCU_APB2FZ1_DBG_TIM9_STOP_Msk     (0x1UL << DBGMCU_APB2FZ1_DBG_TIM9_STOP_Pos)    /*!< 0x00080000 */
#define DBGMCU_APB2FZ1_DBG_TIM9_STOP         DBGMCU_APB2FZ1_DBG_TIM9_STOP_Msk               /*!< TIM9 stop in debug */

/********************  Bit definition for DBGMCU_APB4FZ1 register  ***************/
#define DBGMCU_APB4FZ1_DBG_I2C4_STOP_Pos     (8UL)
#define DBGMCU_APB4FZ1_DBG_I2C4_STOP_Msk     (0x1UL << DBGMCU_APB4FZ1_DBG_I2C4_STOP_Pos)    /*!< 0x00000100 */
#define DBGMCU_APB4FZ1_DBG_I2C4_STOP         DBGMCU_APB4FZ1_DBG_I2C4_STOP_Msk               /*!< I2C4 stop in debug */
#define DBGMCU_APB4FZ1_DBG_LPTIM2_STOP_Pos   (9UL)
#define DBGMCU_APB4FZ1_DBG_LPTIM2_STOP_Msk   (0x1UL << DBGMCU_APB4FZ1_DBG_LPTIM2_STOP_Pos)  /*!< 0x00000200 */
#define DBGMCU_APB4FZ1_DBG_LPTIM2_STOP       DBGMCU_APB4FZ1_DBG_LPTIM2_STOP_Msk             /*!< LPTIM2 stop in debug */
#define DBGMCU_APB4FZ1_DBG_LPTIM3_STOP_Pos   (10UL)
#define DBGMCU_APB4FZ1_DBG_LPTIM3_STOP_Msk   (0x1UL << DBGMCU_APB4FZ1_DBG_LPTIM3_STOP_Pos)  /*!< 0x00000400 */
#define DBGMCU_APB4FZ1_DBG_LPTIM3_STOP       DBGMCU_APB4FZ1_DBG_LPTIM3_STOP_Msk             /*!< LPTIM3 stop in debug */
#define DBGMCU_APB4FZ1_DBG_LPTIM4_STOP_Pos   (11UL)
#define DBGMCU_APB4FZ1_DBG_LPTIM4_STOP_Msk   (0x1UL << DBGMCU_APB4FZ1_DBG_LPTIM4_STOP_Pos)  /*!< 0x00000800 */
#define DBGMCU_APB4FZ1_DBG_LPTIM4_STOP       DBGMCU_APB4FZ1_DBG_LPTIM4_STOP_Msk             /*!< LPTIM4 stop in debug */
#define DBGMCU_APB4FZ1_DBG_LPTIM5_STOP_Pos   (12UL)
#define DBGMCU_APB4FZ1_DBG_LPTIM5_STOP_Msk   (0x1UL << DBGMCU_APB4FZ1_DBG_LPTIM5_STOP_Pos)  /*!< 0x00001000 */
#define DBGMCU_APB4FZ1_DBG_LPTIM5_STOP       DBGMCU_APB4FZ1_DBG_LPTIM5_STOP_Msk             /*!< LPTIM5 stop in debug */
#define DBGMCU_APB4FZ1_DBG_RTC_STOP_Pos      (16UL)
#define DBGMCU_APB4FZ1_DBG_RTC_STOP_Msk      (0x1UL << DBGMCU_APB4FZ1_DBG_RTC_STOP_Pos)     /*!< 0x00010000 */
#define DBGMCU_APB4FZ1_DBG_RTC_STOP          DBGMCU_APB4FZ1_DBG_RTC_STOP_Msk                /*!< RTC stop in debug */
#define DBGMCU_APB4FZ1_DBG_IWDG_STOP_Pos     (18UL)
#define DBGMCU_APB4FZ1_DBG_IWDG_STOP_Msk     (0x1UL << DBGMCU_APB4FZ1_DBG_IWDG_STOP_Pos)    /*!< 0x00040000 */
#define DBGMCU_APB4FZ1_DBG_IWDG_STOP         DBGMCU_APB4FZ1_DBG_IWDG_STOP_Msk               /*!< IWDG stop in debug */

/********************  Bit definition for DBGMCU_APB5FZ1 register  ***************/
#define DBGMCU_APB5FZ1_DBG_GFXTIM_STOP_Pos   (4UL)
#define DBGMCU_APB5FZ1_DBG_GFXTIM_STOP_Msk   (0x1UL << DBGMCU_APB5FZ1_DBG_GFXTIM_STOP_Pos)  /*!< 0x00000010 */
#define DBGMCU_APB5FZ1_DBG_GFXTIM_STOP       DBGMCU_APB5FZ1_DBG_GFXTIM_STOP_Msk             /*!< GFXTIM stop in debug */

/********************  Bit definition for DBGMCU_AHB1FZ1 register  ***************/
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH0_STOP_Pos    (0UL)
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH0_STOP_Msk    (0x1UL << DBGMCU_AHB1FZ1_DBG_GPDMA1_CH0_STOP_Pos)   /*!< 0x00000001 */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH0_STOP        DBGMCU_AHB1FZ1_DBG_GPDMA1_CH0_STOP_Msk              /*!< GPDMA1_CH0 suspend in debug */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH1_STOP_Pos    (1UL)
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH1_STOP_Msk    (0x1UL << DBGMCU_AHB1FZ1_DBG_GPDMA1_CH1_STOP_Pos)   /*!< 0x00000002 */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH1_STOP        DBGMCU_AHB1FZ1_DBG_GPDMA1_CH1_STOP_Msk              /*!< GPDMA1_CH1 suspend in debug */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH2_STOP_Pos    (2UL)
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH2_STOP_Msk    (0x1UL << DBGMCU_AHB1FZ1_DBG_GPDMA1_CH2_STOP_Pos)   /*!< 0x00000004 */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH2_STOP        DBGMCU_AHB1FZ1_DBG_GPDMA1_CH2_STOP_Msk              /*!< GPDMA1_CH2 suspend in debug */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH3_STOP_Pos    (3UL)
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH3_STOP_Msk    (0x1UL << DBGMCU_AHB1FZ1_DBG_GPDMA1_CH3_STOP_Pos)   /*!< 0x00000008 */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH3_STOP        DBGMCU_AHB1FZ1_DBG_GPDMA1_CH3_STOP_Msk              /*!< GPDMA1_CH3 suspend in debug */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH4_STOP_Pos    (4UL)
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH4_STOP_Msk    (0x1UL << DBGMCU_AHB1FZ1_DBG_GPDMA1_CH4_STOP_Pos)   /*!< 0x00000010 */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH4_STOP        DBGMCU_AHB1FZ1_DBG_GPDMA1_CH4_STOP_Msk              /*!< GPDMA1_CH4 suspend in debug */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH5_STOP_Pos    (5UL)
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH5_STOP_Msk    (0x1UL << DBGMCU_AHB1FZ1_DBG_GPDMA1_CH5_STOP_Pos)   /*!< 0x00000020 */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH5_STOP        DBGMCU_AHB1FZ1_DBG_GPDMA1_CH5_STOP_Msk              /*!< GPDMA1_CH5 suspend in debug */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH6_STOP_Pos    (6UL)
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH6_STOP_Msk    (0x1UL << DBGMCU_AHB1FZ1_DBG_GPDMA1_CH6_STOP_Pos)   /*!< 0x00000040 */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH6_STOP        DBGMCU_AHB1FZ1_DBG_GPDMA1_CH6_STOP_Msk              /*!< GPDMA1_CH6 suspend in debug */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH7_STOP_Pos    (7UL)
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH7_STOP_Msk    (0x1UL << DBGMCU_AHB1FZ1_DBG_GPDMA1_CH7_STOP_Pos)   /*!< 0x00000080 */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH7_STOP        DBGMCU_AHB1FZ1_DBG_GPDMA1_CH7_STOP_Msk              /*!< GPDMA1_CH7 suspend in debug */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH8_STOP_Pos    (8UL)
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH8_STOP_Msk    (0x1UL << DBGMCU_AHB1FZ1_DBG_GPDMA1_CH8_STOP_Pos)   /*!< 0x00000100 */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH8_STOP        DBGMCU_AHB1FZ1_DBG_GPDMA1_CH8_STOP_Msk              /*!< GPDMA1_CH8 suspend in debug */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH9_STOP_Pos    (9UL)
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH9_STOP_Msk    (0x1UL << DBGMCU_AHB1FZ1_DBG_GPDMA1_CH9_STOP_Pos)   /*!< 0x00000200 */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH9_STOP        DBGMCU_AHB1FZ1_DBG_GPDMA1_CH9_STOP_Msk              /*!< GPDMA1_CH9 suspend in debug */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH10_STOP_Pos   (10UL)
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH10_STOP_Msk   (0x1UL << DBGMCU_AHB1FZ1_DBG_GPDMA1_CH10_STOP_Pos)  /*!< 0x00000400 */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH10_STOP       DBGMCU_AHB1FZ1_DBG_GPDMA1_CH10_STOP_Msk             /*!< GPDMA1_CH10 suspend in debug */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH11_STOP_Pos   (11UL)
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH11_STOP_Msk   (0x1UL << DBGMCU_AHB1FZ1_DBG_GPDMA1_CH11_STOP_Pos)  /*!< 0x00000800 */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH11_STOP       DBGMCU_AHB1FZ1_DBG_GPDMA1_CH11_STOP_Msk             /*!< GPDMA1_CH11 suspend in debug */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH12_STOP_Pos   (12UL)
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH12_STOP_Msk   (0x1UL << DBGMCU_AHB1FZ1_DBG_GPDMA1_CH12_STOP_Pos)  /*!< 0x00001000 */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH12_STOP       DBGMCU_AHB1FZ1_DBG_GPDMA1_CH12_STOP_Msk             /*!< GPDMA1_CH12 suspend in debug */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH13_STOP_Pos   (13UL)
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH13_STOP_Msk   (0x1UL << DBGMCU_AHB1FZ1_DBG_GPDMA1_CH13_STOP_Pos)  /*!< 0x00002000 */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH13_STOP       DBGMCU_AHB1FZ1_DBG_GPDMA1_CH13_STOP_Msk             /*!< GPDMA1_CH13 suspend in debug */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH14_STOP_Pos   (14UL)
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH14_STOP_Msk   (0x1UL << DBGMCU_AHB1FZ1_DBG_GPDMA1_CH14_STOP_Pos)  /*!< 0x00004000 */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH14_STOP       DBGMCU_AHB1FZ1_DBG_GPDMA1_CH14_STOP_Msk             /*!< GPDMA1_CH14 suspend in debug */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH15_STOP_Pos   (15UL)
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH15_STOP_Msk   (0x1UL << DBGMCU_AHB1FZ1_DBG_GPDMA1_CH15_STOP_Pos)  /*!< 0x00008000 */
#define DBGMCU_AHB1FZ1_DBG_GPDMA1_CH15_STOP       DBGMCU_AHB1FZ1_DBG_GPDMA1_CH15_STOP_Msk             /*!< GPDMA1_CH15 suspend in debug */

/********************  Bit definition for DBGMCU_AHB5FZ1 register  ***************/
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH0_STOP_Pos    (0UL)
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH0_STOP_Msk    (0x1UL << DBGMCU_AHB5FZ1_DBG_HPDMA1_CH0_STOP_Pos)   /*!< 0x00000001 */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH0_STOP        DBGMCU_AHB5FZ1_DBG_HPDMA1_CH0_STOP_Msk              /*!< HPDMA1_CH0 suspend in debug */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH1_STOP_Pos    (1UL)
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH1_STOP_Msk    (0x1UL << DBGMCU_AHB5FZ1_DBG_HPDMA1_CH1_STOP_Pos)   /*!< 0x00000002 */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH1_STOP        DBGMCU_AHB5FZ1_DBG_HPDMA1_CH1_STOP_Msk              /*!< HPDMA1_CH1 suspend in debug */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH2_STOP_Pos    (2UL)
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH2_STOP_Msk    (0x1UL << DBGMCU_AHB5FZ1_DBG_HPDMA1_CH2_STOP_Pos)   /*!< 0x00000004 */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH2_STOP        DBGMCU_AHB5FZ1_DBG_HPDMA1_CH2_STOP_Msk              /*!< HPDMA1_CH2 suspend in debug */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH3_STOP_Pos    (3UL)
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH3_STOP_Msk    (0x1UL << DBGMCU_AHB5FZ1_DBG_HPDMA1_CH3_STOP_Pos)   /*!< 0x00000008 */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH3_STOP        DBGMCU_AHB5FZ1_DBG_HPDMA1_CH3_STOP_Msk              /*!< HPDMA1_CH3 suspend in debug */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH4_STOP_Pos    (4UL)
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH4_STOP_Msk    (0x1UL << DBGMCU_AHB5FZ1_DBG_HPDMA1_CH4_STOP_Pos)   /*!< 0x00000010 */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH4_STOP        DBGMCU_AHB5FZ1_DBG_HPDMA1_CH4_STOP_Msk              /*!< HPDMA1_CH4 suspend in debug */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH5_STOP_Pos    (5UL)
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH5_STOP_Msk    (0x1UL << DBGMCU_AHB5FZ1_DBG_HPDMA1_CH5_STOP_Pos)   /*!< 0x00000020 */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH5_STOP        DBGMCU_AHB5FZ1_DBG_HPDMA1_CH5_STOP_Msk              /*!< HPDMA1_CH5 suspend in debug */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH6_STOP_Pos    (6UL)
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH6_STOP_Msk    (0x1UL << DBGMCU_AHB5FZ1_DBG_HPDMA1_CH6_STOP_Pos)   /*!< 0x00000040 */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH6_STOP        DBGMCU_AHB5FZ1_DBG_HPDMA1_CH6_STOP_Msk              /*!< HPDMA1_CH6 suspend in debug */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH7_STOP_Pos    (7UL)
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH7_STOP_Msk    (0x1UL << DBGMCU_AHB5FZ1_DBG_HPDMA1_CH7_STOP_Pos)   /*!< 0x00000080 */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH7_STOP        DBGMCU_AHB5FZ1_DBG_HPDMA1_CH7_STOP_Msk              /*!< HPDMA1_CH7 suspend in debug */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH8_STOP_Pos    (8UL)
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH8_STOP_Msk    (0x1UL << DBGMCU_AHB5FZ1_DBG_HPDMA1_CH8_STOP_Pos)   /*!< 0x00000100 */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH8_STOP        DBGMCU_AHB5FZ1_DBG_HPDMA1_CH8_STOP_Msk              /*!< HPDMA1_CH8 suspend in debug */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH9_STOP_Pos    (9UL)
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH9_STOP_Msk    (0x1UL << DBGMCU_AHB5FZ1_DBG_HPDMA1_CH9_STOP_Pos)   /*!< 0x00000200 */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH9_STOP        DBGMCU_AHB5FZ1_DBG_HPDMA1_CH9_STOP_Msk              /*!< HPDMA1_CH9 suspend in debug */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH10_STOP_Pos   (10UL)
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH10_STOP_Msk   (0x1UL << DBGMCU_AHB5FZ1_DBG_HPDMA1_CH10_STOP_Pos)  /*!< 0x00000400 */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH10_STOP       DBGMCU_AHB5FZ1_DBG_HPDMA1_CH10_STOP_Msk             /*!< HPDMA1_CH10 suspend in debug */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH11_STOP_Pos   (11UL)
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH11_STOP_Msk   (0x1UL << DBGMCU_AHB5FZ1_DBG_HPDMA1_CH11_STOP_Pos)  /*!< 0x00000800 */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH11_STOP       DBGMCU_AHB5FZ1_DBG_HPDMA1_CH11_STOP_Msk             /*!< HPDMA1_CH11 suspend in debug */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH12_STOP_Pos   (12UL)
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH12_STOP_Msk   (0x1UL << DBGMCU_AHB5FZ1_DBG_HPDMA1_CH12_STOP_Pos)  /*!< 0x00001000 */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH12_STOP       DBGMCU_AHB5FZ1_DBG_HPDMA1_CH12_STOP_Msk             /*!< HPDMA1_CH12 suspend in debug */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH13_STOP_Pos   (13UL)
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH13_STOP_Msk   (0x1UL << DBGMCU_AHB5FZ1_DBG_HPDMA1_CH13_STOP_Pos)  /*!< 0x00002000 */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH13_STOP       DBGMCU_AHB5FZ1_DBG_HPDMA1_CH13_STOP_Msk             /*!< HPDMA1_CH13 suspend in debug */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH14_STOP_Pos   (14UL)
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH14_STOP_Msk   (0x1UL << DBGMCU_AHB5FZ1_DBG_HPDMA1_CH14_STOP_Pos)  /*!< 0x00004000 */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH14_STOP       DBGMCU_AHB5FZ1_DBG_HPDMA1_CH14_STOP_Msk             /*!< HPDMA1_CH14 suspend in debug */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH15_STOP_Pos   (15UL)
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH15_STOP_Msk   (0x1UL << DBGMCU_AHB5FZ1_DBG_HPDMA1_CH15_STOP_Pos)  /*!< 0x00008000 */
#define DBGMCU_AHB5FZ1_DBG_HPDMA1_CH15_STOP       DBGMCU_AHB5FZ1_DBG_HPDMA1_CH15_STOP_Msk             /*!< HPDMA1_CH15 suspend in debug */
#define DBGMCU_AHB5FZ1_NPU_DBG_FREEZE_Pos         (16UL)
#define DBGMCU_AHB5FZ1_NPU_DBG_FREEZE_Msk         (0x1UL << DBGMCU_AHB5FZ1_NPU_DBG_FREEZE_Pos)        /*!< 0x00010000 */
#define DBGMCU_AHB5FZ1_NPU_DBG_FREEZE             DBGMCU_AHB5FZ1_NPU_DBG_FREEZE_Msk                   /*!< NPU stop in debug mode */

/********************  Bit definition for DBGMCU_SR register  ***************/
#define DBGMCU_SR_AP0_PRESENT_Pos            (0UL)
#define DBGMCU_SR_AP0_PRESENT_Msk            (0x1UL << DBGMCU_SR_AP0_PRESENT_Pos)           /*!< 0x00000001 */
#define DBGMCU_SR_AP0_PRESENT                DBGMCU_SR_AP0_PRESENT_Msk                      /*!< Access point 0 presence */
#define DBGMCU_SR_AP1_PRESENT_Pos            (1UL)
#define DBGMCU_SR_AP1_PRESENT_Msk            (0x1UL << DBGMCU_SR_AP1_PRESENT_Pos)           /*!< 0x00000002 */
#define DBGMCU_SR_AP1_PRESENT                DBGMCU_SR_AP1_PRESENT_Msk                      /*!< Access point 1 presence */
#define DBGMCU_SR_AP0_ENABLE_Pos             (16UL)
#define DBGMCU_SR_AP0_ENABLE_Msk             (0x1UL << DBGMCU_SR_AP0_ENABLE_Pos)            /*!< 0x00010000 */
#define DBGMCU_SR_AP0_ENABLE                 DBGMCU_SR_AP0_ENABLE_Msk                       /*!< Access point 0 enable */
#define DBGMCU_SR_AP1_ENABLE_Pos             (17UL)
#define DBGMCU_SR_AP1_ENABLE_Msk             (0x1UL << DBGMCU_SR_AP1_ENABLE_Pos)            /*!< 0x00020000 */
#define DBGMCU_SR_AP1_ENABLE                 DBGMCU_SR_AP1_ENABLE_Msk                       /*!< Access point 1 enable */

/******************  Bit definition for DBGMCU_DBG_AUTH_HOST register  **********************/
#define DBGMCU_DBG_AUTH_HOST_MESSAGE_Pos     (0UL)
#define DBGMCU_DBG_AUTH_HOST_MESSAGE_Msk     (0xFFFFFFFFUL << DBGMCU_DBG_AUTH_HOST_MESSAGE_Pos) /*!< 0xFFFFFFFF */
#define DBGMCU_DBG_AUTH_HOST_MESSAGE         DBGMCU_DBG_AUTH_HOST_MESSAGE_Msk                   /*!< Message[31:0] */

/******************  Bit definition for DBGMCU_DBG_AUTH_DEV register  ***********/
#define DBGMCU_DBG_AUTH_DEV_MESSAGE_Pos      (0UL)
#define DBGMCU_DBG_AUTH_DEV_MESSAGE_Msk      (0xFFFFFFFFUL << DBGMCU_DBG_AUTH_DEV_MESSAGE_Pos)  /*!< 0xFFFFFFFF */
#define DBGMCU_DBG_AUTH_DEV_MESSAGE          DBGMCU_DBG_AUTH_DEV_MESSAGE_Msk                    /*!< Message[31:0] */

/********************  Bit definition for DBGMCU_DBG_AUTH_ACK register  ***************/
#define DBGMCU_DBG_AUTH_ACK_HOST_ACK_Pos     (0UL)
#define DBGMCU_DBG_AUTH_ACK_HOST_ACK_Msk     (0x1UL << DBGMCU_DBG_AUTH_ACK_HOST_ACK_Pos)    /*!< 0x00000001 */
#define DBGMCU_DBG_AUTH_ACK_HOST_ACK         DBGMCU_DBG_AUTH_ACK_HOST_ACK_Msk               /*!< Access status to DBG_AUTH_HOST register */
#define DBGMCU_DBG_AUTH_ACK_DEVICE_ACK_Pos   (1UL)
#define DBGMCU_DBG_AUTH_ACK_DEVICE_ACK_Msk   (0x1UL << DBGMCU_DBG_AUTH_ACK_DEVICE_ACK_Pos)  /*!< 0x00000002 */
#define DBGMCU_DBG_AUTH_ACK_DEVICE_ACK       DBGMCU_DBG_AUTH_ACK_DEVICE_ACK_Msk             /*!< Access status to DBG_AUTH_DEV register */


/******************************************************************************/
/*                                                                            */
/*                                    DCMI                                    */
/*                                                                            */
/******************************************************************************/
/********************  Bits definition for DCMI_CR register  ******************/
#define DCMI_CR_CAPTURE_Pos                 (0UL)
#define DCMI_CR_CAPTURE_Msk                 (0x1UL << DCMI_CR_CAPTURE_Pos)          /*!< 0x00000001 */
#define DCMI_CR_CAPTURE                     DCMI_CR_CAPTURE_Msk
#define DCMI_CR_CM_Pos                      (1UL)
#define DCMI_CR_CM_Msk                      (0x1UL << DCMI_CR_CM_Pos)               /*!< 0x00000002 */
#define DCMI_CR_CM                          DCMI_CR_CM_Msk
#define DCMI_CR_CROP_Pos                    (2UL)
#define DCMI_CR_CROP_Msk                    (0x1UL << DCMI_CR_CROP_Pos)             /*!< 0x00000004 */
#define DCMI_CR_CROP                        DCMI_CR_CROP_Msk
#define DCMI_CR_JPEG_Pos                    (3UL)
#define DCMI_CR_JPEG_Msk                    (0x1UL << DCMI_CR_JPEG_Pos)             /*!< 0x00000008 */
#define DCMI_CR_JPEG                        DCMI_CR_JPEG_Msk
#define DCMI_CR_ESS_Pos                     (4UL)
#define DCMI_CR_ESS_Msk                     (0x1UL << DCMI_CR_ESS_Pos)              /*!< 0x00000010 */
#define DCMI_CR_ESS                         DCMI_CR_ESS_Msk
#define DCMI_CR_PCKPOL_Pos                  (5UL)
#define DCMI_CR_PCKPOL_Msk                  (0x1UL << DCMI_CR_PCKPOL_Pos)           /*!< 0x00000020 */
#define DCMI_CR_PCKPOL                      DCMI_CR_PCKPOL_Msk
#define DCMI_CR_HSPOL_Pos                   (6UL)
#define DCMI_CR_HSPOL_Msk                   (0x1UL << DCMI_CR_HSPOL_Pos)            /*!< 0x00000040 */
#define DCMI_CR_HSPOL                       DCMI_CR_HSPOL_Msk
#define DCMI_CR_VSPOL_Pos                   (7UL)
#define DCMI_CR_VSPOL_Msk                   (0x1UL << DCMI_CR_VSPOL_Pos)            /*!< 0x00000080 */
#define DCMI_CR_VSPOL                       DCMI_CR_VSPOL_Msk
#define DCMI_CR_FCRC_Pos                    (8UL)
#define DCMI_CR_FCRC_Msk                    (0x3UL << DCMI_CR_FCRC_Pos)             /*!< 0x00000300 */
#define DCMI_CR_FCRC                        DCMI_CR_FCRC_Msk                        /*!< DCMI Frame capture rate control FCRC[1:0] */
#define DCMI_CR_FCRC_0                      (0x1UL << DCMI_CR_FCRC_Pos)             /*!< 0x00000100 */
#define DCMI_CR_FCRC_1                      (0x2UL << DCMI_CR_FCRC_Pos)             /*!< 0x00000200 */
#define DCMI_CR_EDM_Pos                     (10UL)
#define DCMI_CR_EDM_Msk                     (0x3UL << DCMI_CR_EDM_Pos)              /*!< 0x00000C00 */
#define DCMI_CR_EDM                         DCMI_CR_EDM_Msk                         /*!< DCMI Extended data mode EDM[1:0] */
#define DCMI_CR_EDM_0                       (0x1UL << DCMI_CR_EDM_Pos)              /*!< 0x00000400 */
#define DCMI_CR_EDM_1                       (0x2UL << DCMI_CR_EDM_Pos)              /*!< 0x00000800 */
#define DCMI_CR_ENABLE_Pos                  (14UL)
#define DCMI_CR_ENABLE_Msk                  (0x1UL << DCMI_CR_ENABLE_Pos)           /*!< 0x00004000 */
#define DCMI_CR_ENABLE                      DCMI_CR_ENABLE_Msk
#define DCMI_CR_BSM_Pos                     (16UL)
#define DCMI_CR_BSM_Msk                     (0x3UL << DCMI_CR_BSM_Pos)              /*!< 0x00030000 */
#define DCMI_CR_BSM                         DCMI_CR_BSM_Msk
#define DCMI_CR_BSM_0                       (0x1UL << DCMI_CR_BSM_Pos)              /*!< 0x00010000 */
#define DCMI_CR_BSM_1                       (0x2UL << DCMI_CR_BSM_Pos)              /*!< 0x00020000 */
#define DCMI_CR_OEBS_Pos                    (18UL)
#define DCMI_CR_OEBS_Msk                    (0x1UL << DCMI_CR_OEBS_Pos)             /*!< 0x00040000 */
#define DCMI_CR_OEBS                        DCMI_CR_OEBS_Msk
#define DCMI_CR_LSM_Pos                     (19UL)
#define DCMI_CR_LSM_Msk                     (0x1UL << DCMI_CR_LSM_Pos)              /*!< 0x00080000 */
#define DCMI_CR_LSM                         DCMI_CR_LSM_Msk
#define DCMI_CR_OELS_Pos                    (20UL)
#define DCMI_CR_OELS_Msk                    (0x1UL << DCMI_CR_OELS_Pos)             /*!< 0x00100000 */
#define DCMI_CR_OELS                        DCMI_CR_OELS_Msk
#define DCMI_CR_PSDM_Pos                    (31UL)
#define DCMI_CR_PSDM_Msk                    (0x0UL << DCMI_CR_PSDM_Pos)             /*!< 0x00000000 */
#define DCMI_CR_PSDM                        DCMI_CR_PSDM_Msk                        /*PSDM: Parallel Synchronous raw Data Mode (PSDM = 0)*/

/********************  Bits definition for DCMI_SR register  ******************/
#define DCMI_SR_HSYNC_Pos                   (0UL)
#define DCMI_SR_HSYNC_Msk                   (0x1UL << DCMI_SR_HSYNC_Pos)            /*!< 0x00000001 */
#define DCMI_SR_HSYNC                       DCMI_SR_HSYNC_Msk
#define DCMI_SR_VSYNC_Pos                   (1UL)
#define DCMI_SR_VSYNC_Msk                   (0x1UL << DCMI_SR_VSYNC_Pos)            /*!< 0x00000002 */
#define DCMI_SR_VSYNC                       DCMI_SR_VSYNC_Msk
#define DCMI_SR_FNE_Pos                     (2UL)
#define DCMI_SR_FNE_Msk                     (0x1UL << DCMI_SR_FNE_Pos)              /*!< 0x00000004 */
#define DCMI_SR_FNE                         DCMI_SR_FNE_Msk

/********************  Bits definition for DCMI_RIS register   ****************/
#define DCMI_RIS_FRAME_RIS_Pos              (0UL)
#define DCMI_RIS_FRAME_RIS_Msk              (0x1UL << DCMI_RIS_FRAME_RIS_Pos)       /*!< 0x00000001 */
#define DCMI_RIS_FRAME_RIS                  DCMI_RIS_FRAME_RIS_Msk
#define DCMI_RIS_OVR_RIS_Pos                (1UL)
#define DCMI_RIS_OVR_RIS_Msk                (0x1UL << DCMI_RIS_OVR_RIS_Pos)         /*!< 0x00000002 */
#define DCMI_RIS_OVR_RIS                    DCMI_RIS_OVR_RIS_Msk
#define DCMI_RIS_ERR_RIS_Pos                (2UL)
#define DCMI_RIS_ERR_RIS_Msk                (0x1UL << DCMI_RIS_ERR_RIS_Pos)         /*!< 0x00000004 */
#define DCMI_RIS_ERR_RIS                    DCMI_RIS_ERR_RIS_Msk
#define DCMI_RIS_VSYNC_RIS_Pos              (3UL)
#define DCMI_RIS_VSYNC_RIS_Msk              (0x1UL << DCMI_RIS_VSYNC_RIS_Pos)       /*!< 0x00000008 */
#define DCMI_RIS_VSYNC_RIS                  DCMI_RIS_VSYNC_RIS_Msk
#define DCMI_RIS_LINE_RIS_Pos               (4UL)
#define DCMI_RIS_LINE_RIS_Msk               (0x1UL << DCMI_RIS_LINE_RIS_Pos)        /*!< 0x00000010 */
#define DCMI_RIS_LINE_RIS                   DCMI_RIS_LINE_RIS_Msk

/********************  Bits definition for DCMI_IER register  *****************/
#define DCMI_IER_FRAME_IE_Pos               (0UL)
#define DCMI_IER_FRAME_IE_Msk               (0x1UL << DCMI_IER_FRAME_IE_Pos)        /*!< 0x00000001 */
#define DCMI_IER_FRAME_IE                   DCMI_IER_FRAME_IE_Msk
#define DCMI_IER_OVR_IE_Pos                 (1UL)
#define DCMI_IER_OVR_IE_Msk                 (0x1UL << DCMI_IER_OVR_IE_Pos)          /*!< 0x00000002 */
#define DCMI_IER_OVR_IE                     DCMI_IER_OVR_IE_Msk
#define DCMI_IER_ERR_IE_Pos                 (2UL)
#define DCMI_IER_ERR_IE_Msk                 (0x1UL << DCMI_IER_ERR_IE_Pos)          /*!< 0x00000004 */
#define DCMI_IER_ERR_IE                     DCMI_IER_ERR_IE_Msk
#define DCMI_IER_VSYNC_IE_Pos               (3UL)
#define DCMI_IER_VSYNC_IE_Msk               (0x1UL << DCMI_IER_VSYNC_IE_Pos)        /*!< 0x00000008 */
#define DCMI_IER_VSYNC_IE                   DCMI_IER_VSYNC_IE_Msk
#define DCMI_IER_LINE_IE_Pos                (4UL)
#define DCMI_IER_LINE_IE_Msk                (0x1UL << DCMI_IER_LINE_IE_Pos)         /*!< 0x00000010 */
#define DCMI_IER_LINE_IE                    DCMI_IER_LINE_IE_Msk

/********************  Bits definition for DCMI_MIS register  *****************/
#define DCMI_MIS_FRAME_MIS_Pos              (0UL)
#define DCMI_MIS_FRAME_MIS_Msk              (0x1UL << DCMI_MIS_FRAME_MIS_Pos)       /*!< 0x00000001 */
#define DCMI_MIS_FRAME_MIS                  DCMI_MIS_FRAME_MIS_Msk
#define DCMI_MIS_OVR_MIS_Pos                (1UL)
#define DCMI_MIS_OVR_MIS_Msk                (0x1UL << DCMI_MIS_OVR_MIS_Pos)         /*!< 0x00000002 */
#define DCMI_MIS_OVR_MIS                    DCMI_MIS_OVR_MIS_Msk
#define DCMI_MIS_ERR_MIS_Pos                (2UL)
#define DCMI_MIS_ERR_MIS_Msk                (0x1UL << DCMI_MIS_ERR_MIS_Pos)         /*!< 0x00000004 */
#define DCMI_MIS_ERR_MIS                    DCMI_MIS_ERR_MIS_Msk
#define DCMI_MIS_VSYNC_MIS_Pos              (3UL)
#define DCMI_MIS_VSYNC_MIS_Msk              (0x1UL << DCMI_MIS_VSYNC_MIS_Pos)       /*!< 0x00000008 */
#define DCMI_MIS_VSYNC_MIS                  DCMI_MIS_VSYNC_MIS_Msk
#define DCMI_MIS_LINE_MIS_Pos               (4UL)
#define DCMI_MIS_LINE_MIS_Msk               (0x1UL << DCMI_MIS_LINE_MIS_Pos)        /*!< 0x00000010 */
#define DCMI_MIS_LINE_MIS                   DCMI_MIS_LINE_MIS_Msk

/********************  Bits definition for DCMI_ICR register  *****************/
#define DCMI_ICR_FRAME_ISC_Pos              (0UL)
#define DCMI_ICR_FRAME_ISC_Msk              (0x1UL << DCMI_ICR_FRAME_ISC_Pos)       /*!< 0x00000001 */
#define DCMI_ICR_FRAME_ISC                  DCMI_ICR_FRAME_ISC_Msk
#define DCMI_ICR_OVR_ISC_Pos                (1UL)
#define DCMI_ICR_OVR_ISC_Msk                (0x1UL << DCMI_ICR_OVR_ISC_Pos)         /*!< 0x00000002 */
#define DCMI_ICR_OVR_ISC                    DCMI_ICR_OVR_ISC_Msk
#define DCMI_ICR_ERR_ISC_Pos                (2UL)
#define DCMI_ICR_ERR_ISC_Msk                (0x1UL << DCMI_ICR_ERR_ISC_Pos)         /*!< 0x00000004 */
#define DCMI_ICR_ERR_ISC                    DCMI_ICR_ERR_ISC_Msk
#define DCMI_ICR_VSYNC_ISC_Pos              (3UL)
#define DCMI_ICR_VSYNC_ISC_Msk              (0x1UL << DCMI_ICR_VSYNC_ISC_Pos)       /*!< 0x00000008 */
#define DCMI_ICR_VSYNC_ISC                  DCMI_ICR_VSYNC_ISC_Msk
#define DCMI_ICR_LINE_ISC_Pos               (4UL)
#define DCMI_ICR_LINE_ISC_Msk               (0x1UL << DCMI_ICR_LINE_ISC_Pos)        /*!< 0x00000010 */
#define DCMI_ICR_LINE_ISC                   DCMI_ICR_LINE_ISC_Msk

/********************  Bits definition for DCMI_ESCR register  ******************/
#define DCMI_ESCR_FSC_Pos                   (0UL)
#define DCMI_ESCR_FSC_Msk                   (0xFFUL << DCMI_ESCR_FSC_Pos)           /*!< 0x000000FF */
#define DCMI_ESCR_FSC                       DCMI_ESCR_FSC_Msk
#define DCMI_ESCR_LSC_Pos                   (8UL)
#define DCMI_ESCR_LSC_Msk                   (0xFFUL << DCMI_ESCR_LSC_Pos)           /*!< 0x0000FF00 */
#define DCMI_ESCR_LSC                       DCMI_ESCR_LSC_Msk
#define DCMI_ESCR_LEC_Pos                   (16UL)
#define DCMI_ESCR_LEC_Msk                   (0xFFUL << DCMI_ESCR_LEC_Pos)           /*!< 0x00FF0000 */
#define DCMI_ESCR_LEC                       DCMI_ESCR_LEC_Msk
#define DCMI_ESCR_FEC_Pos                   (24UL)
#define DCMI_ESCR_FEC_Msk                   (0xFFUL << DCMI_ESCR_FEC_Pos)           /*!< 0xFF000000 */
#define DCMI_ESCR_FEC                       DCMI_ESCR_FEC_Msk

/********************  Bits definition for DCMI_ESUR register  ******************/
#define DCMI_ESUR_FSU_Pos                   (0UL)
#define DCMI_ESUR_FSU_Msk                   (0xFFUL << DCMI_ESUR_FSU_Pos)           /*!< 0x000000FF */
#define DCMI_ESUR_FSU                       DCMI_ESUR_FSU_Msk
#define DCMI_ESUR_LSU_Pos                   (8UL)
#define DCMI_ESUR_LSU_Msk                   (0xFFUL << DCMI_ESUR_LSU_Pos)           /*!< 0x0000FF00 */
#define DCMI_ESUR_LSU                       DCMI_ESUR_LSU_Msk
#define DCMI_ESUR_LEU_Pos                   (16UL)
#define DCMI_ESUR_LEU_Msk                   (0xFFUL << DCMI_ESUR_LEU_Pos)           /*!< 0x00FF0000 */
#define DCMI_ESUR_LEU                       DCMI_ESUR_LEU_Msk
#define DCMI_ESUR_FEU_Pos                   (24UL)
#define DCMI_ESUR_FEU_Msk                   (0xFFUL << DCMI_ESUR_FEU_Pos)           /*!< 0xFF000000 */
#define DCMI_ESUR_FEU                       DCMI_ESUR_FEU_Msk

/********************  Bits definition for DCMI_CWSTRT register  ******************/
#define DCMI_CWSTRT_HOFFCNT_Pos             (0UL)
#define DCMI_CWSTRT_HOFFCNT_Msk             (0x3FFFUL << DCMI_CWSTRT_HOFFCNT_Pos)   /*!< 0x00003FFF */
#define DCMI_CWSTRT_HOFFCNT                 DCMI_CWSTRT_HOFFCNT_Msk
#define DCMI_CWSTRT_VST_Pos                 (16UL)
#define DCMI_CWSTRT_VST_Msk                 (0x1FFFUL << DCMI_CWSTRT_VST_Pos)       /*!< 0x1FFF0000 */
#define DCMI_CWSTRT_VST                     DCMI_CWSTRT_VST_Msk

/********************  Bits definition for DCMI_CWSIZE register  ******************/
#define DCMI_CWSIZE_CAPCNT_Pos              (0UL)
#define DCMI_CWSIZE_CAPCNT_Msk              (0x3FFFUL << DCMI_CWSIZE_CAPCNT_Pos)    /*!< 0x00003FFF */
#define DCMI_CWSIZE_CAPCNT                  DCMI_CWSIZE_CAPCNT_Msk
#define DCMI_CWSIZE_VLINE_Pos               (16UL)
#define DCMI_CWSIZE_VLINE_Msk               (0x3FFFUL << DCMI_CWSIZE_VLINE_Pos)     /*!< 0x3FFF0000 */
#define DCMI_CWSIZE_VLINE                   DCMI_CWSIZE_VLINE_Msk

/********************  Bits definition for DCMI_DR register  ******************/
#define DCMI_DR_BYTE0_Pos                   (0UL)
#define DCMI_DR_BYTE0_Msk                   (0xFFUL << DCMI_DR_BYTE0_Pos)           /*!< 0x000000FF */
#define DCMI_DR_BYTE0                       DCMI_DR_BYTE0_Msk
#define DCMI_DR_BYTE1_Pos                   (8UL)
#define DCMI_DR_BYTE1_Msk                   (0xFFUL << DCMI_DR_BYTE1_Pos)           /*!< 0x0000FF00 */
#define DCMI_DR_BYTE1                       DCMI_DR_BYTE1_Msk
#define DCMI_DR_BYTE2_Pos                   (16UL)
#define DCMI_DR_BYTE2_Msk                   (0xFFUL << DCMI_DR_BYTE2_Pos)           /*!< 0x00FF0000 */
#define DCMI_DR_BYTE2                       DCMI_DR_BYTE2_Msk
#define DCMI_DR_BYTE3_Pos                   (24UL)
#define DCMI_DR_BYTE3_Msk                   (0xFFUL << DCMI_DR_BYTE3_Pos)           /*!< 0xFF000000 */
#define DCMI_DR_BYTE3                       DCMI_DR_BYTE3_Msk


/******************************************************************************/
/*                                                                            */
/*                                   DCMIPP                                   */
/*                                                                            */
/******************************************************************************/
/*****************  Bit definition for DCMIPP_IPGR1 register  *****************/
#define DCMIPP_IPGR1_MEMORYPAGE_Pos         (0UL)
#define DCMIPP_IPGR1_MEMORYPAGE_Msk         (0x7UL << DCMIPP_IPGR1_MEMORYPAGE_Pos)           /*!< 0x00000007 */
#define DCMIPP_IPGR1_MEMORYPAGE             DCMIPP_IPGR1_MEMORYPAGE_Msk                     /*!< Memory page size, as power of 2 of 64-byte units: */
#define DCMIPP_IPGR1_QOS_MODE_Pos           (24UL)
#define DCMIPP_IPGR1_QOS_MODE_Msk           (0x1UL << DCMIPP_IPGR1_QOS_MODE_Pos)             /*!< 0x01000000 */
#define DCMIPP_IPGR1_QOS_MODE               DCMIPP_IPGR1_QOS_MODE_Msk                       /*!< Quality of service */

/*****************  Bit definition for DCMIPP_IPGR2 register  *****************/
#define DCMIPP_IPGR2_PSTART_Pos             (0UL)
#define DCMIPP_IPGR2_PSTART_Msk             (0x1UL << DCMIPP_IPGR2_PSTART_Pos)               /*!< 0x00000001 */
#define DCMIPP_IPGR2_PSTART                 DCMIPP_IPGR2_PSTART_Msk                         /*!< Request to lock the IP-Plug, to allow reconfiguration */

/*****************  Bit definition for DCMIPP_IPGR3 register  *****************/
#define DCMIPP_IPGR3_IDLE_Pos               (0UL)
#define DCMIPP_IPGR3_IDLE_Msk               (0x1UL << DCMIPP_IPGR3_IDLE_Pos)                 /*!< 0x00000001 */
#define DCMIPP_IPGR3_IDLE                   DCMIPP_IPGR3_IDLE_Msk                           /*!< Status of IP-Plug */

/*****************  Bit definition for DCMIPP_IPGR8 register  *****************/
#define DCMIPP_IPGR8_DID_Pos                (0UL)
#define DCMIPP_IPGR8_DID_Msk                (0x3FUL << DCMIPP_IPGR8_DID_Pos)                 /*!< 0x0000003F */
#define DCMIPP_IPGR8_DID                    DCMIPP_IPGR8_DID_Msk                            /*!< Division identifier (0x14) */
#define DCMIPP_IPGR8_REVID_Pos              (8UL)
#define DCMIPP_IPGR8_REVID_Msk              (0x1FUL << DCMIPP_IPGR8_REVID_Pos)               /*!< 0x00001F00 */
#define DCMIPP_IPGR8_REVID                  DCMIPP_IPGR8_REVID_Msk                          /*!< Revision identifier (0x03) */
#define DCMIPP_IPGR8_ARCHIID_Pos            (16UL)
#define DCMIPP_IPGR8_ARCHIID_Msk            (0x1FUL << DCMIPP_IPGR8_ARCHIID_Pos)             /*!< 0x001F0000 */
#define DCMIPP_IPGR8_ARCHIID                DCMIPP_IPGR8_ARCHIID_Msk                        /*!< Architecture identifier (0x04) */
#define DCMIPP_IPGR8_IPPID_Pos              (24UL)
#define DCMIPP_IPGR8_IPPID_Msk              (0xFFUL << DCMIPP_IPGR8_IPPID_Pos)               /*!< 0xFF000000 */
#define DCMIPP_IPGR8_IPPID                  DCMIPP_IPGR8_IPPID_Msk                          /*!< IP identifier (0xAA) */

/****************  Bit definition for DCMIPP_IPC1R1 register  *****************/
#define DCMIPP_IPC1R1_TRAFFIC_Pos           (0UL)
#define DCMIPP_IPC1R1_TRAFFIC_Msk           (0x7UL << DCMIPP_IPC1R1_TRAFFIC_Pos)             /*!< 0x00000007 */
#define DCMIPP_IPC1R1_TRAFFIC               DCMIPP_IPC1R1_TRAFFIC_Msk                       /*!< Burst size as power of 2 of 8 bytes units */
#define DCMIPP_IPC1R1_OTR_Pos               (8UL)
#define DCMIPP_IPC1R1_OTR_Msk               (0xFUL << DCMIPP_IPC1R1_OTR_Pos)                 /*!< 0x00000F00 */
#define DCMIPP_IPC1R1_OTR                   DCMIPP_IPC1R1_OTR_Msk                           /*!< max outstanding transactions: */

/****************  Bit definition for DCMIPP_IPC1R2 register  *****************/
#define DCMIPP_IPC1R2_WLRU_Pos              (16UL)
#define DCMIPP_IPC1R2_WLRU_Msk              (0xFUL << DCMIPP_IPC1R2_WLRU_Pos)                /*!< 0x000F0000 */
#define DCMIPP_IPC1R2_WLRU                  DCMIPP_IPC1R2_WLRU_Msk                          /*!< Ratio for WLRU[3:0] arbitration: */

/****************  Bit definition for DCMIPP_IPC1R3 register  *****************/
#define DCMIPP_IPC1R3_DPREGSTART_Pos        (0UL)
#define DCMIPP_IPC1R3_DPREGSTART_Msk        (0x3FFUL << DCMIPP_IPC1R3_DPREGSTART_Pos)        /*!< 0x000003FF */
#define DCMIPP_IPC1R3_DPREGSTART            DCMIPP_IPC1R3_DPREGSTART_Msk                    /*!< Start word (AXI width = 64 bits) of the FIFO of this client */
#define DCMIPP_IPC1R3_DPREGEND_Pos          (16UL)
#define DCMIPP_IPC1R3_DPREGEND_Msk          (0x3FFUL << DCMIPP_IPC1R3_DPREGEND_Pos)          /*!< 0x03FF0000 */
#define DCMIPP_IPC1R3_DPREGEND              DCMIPP_IPC1R3_DPREGEND_Msk                      /*!< End word (AXI width = 64 bits) of the FIFO of this client */

/****************  Bit definition for DCMIPP_IPC2R1 register  *****************/
#define DCMIPP_IPC2R1_TRAFFIC_Pos           (0UL)
#define DCMIPP_IPC2R1_TRAFFIC_Msk           (0x7UL << DCMIPP_IPC2R1_TRAFFIC_Pos)             /*!< 0x00000007 */
#define DCMIPP_IPC2R1_TRAFFIC               DCMIPP_IPC2R1_TRAFFIC_Msk                       /*!< Burst size as power of 2 of 8 bytes units */
#define DCMIPP_IPC2R1_OTR_Pos               (8UL)
#define DCMIPP_IPC2R1_OTR_Msk               (0xFUL << DCMIPP_IPC2R1_OTR_Pos)                 /*!< 0x00000F00 */
#define DCMIPP_IPC2R1_OTR                   DCMIPP_IPC2R1_OTR_Msk                           /*!< max outstanding transactions: */

/****************  Bit definition for DCMIPP_IPC2R2 register  *****************/
#define DCMIPP_IPC2R2_WLRU_Pos              (16UL)
#define DCMIPP_IPC2R2_WLRU_Msk              (0xFUL << DCMIPP_IPC2R2_WLRU_Pos)                /*!< 0x000F0000 */
#define DCMIPP_IPC2R2_WLRU                  DCMIPP_IPC2R2_WLRU_Msk                          /*!< Ratio for WLRU[3:0] arbitration: */

/****************  Bit definition for DCMIPP_IPC2R3 register  *****************/
#define DCMIPP_IPC2R3_DPREGSTART_Pos        (0UL)
#define DCMIPP_IPC2R3_DPREGSTART_Msk        (0x3FFUL << DCMIPP_IPC2R3_DPREGSTART_Pos)        /*!< 0x000003FF */
#define DCMIPP_IPC2R3_DPREGSTART            DCMIPP_IPC2R3_DPREGSTART_Msk                    /*!< Start word (AXI width = 64 bits) of the FIFO of this client */
#define DCMIPP_IPC2R3_DPREGEND_Pos          (16UL)
#define DCMIPP_IPC2R3_DPREGEND_Msk          (0x3FFUL << DCMIPP_IPC2R3_DPREGEND_Pos)          /*!< 0x03FF0000 */
#define DCMIPP_IPC2R3_DPREGEND              DCMIPP_IPC2R3_DPREGEND_Msk                      /*!< End word (AXI width = 64 bits) of the FIFO of this client */

/****************  Bit definition for DCMIPP_IPC3R1 register  *****************/
#define DCMIPP_IPC3R1_TRAFFIC_Pos           (0UL)
#define DCMIPP_IPC3R1_TRAFFIC_Msk           (0x7UL << DCMIPP_IPC3R1_TRAFFIC_Pos)             /*!< 0x00000007 */
#define DCMIPP_IPC3R1_TRAFFIC               DCMIPP_IPC3R1_TRAFFIC_Msk                       /*!< Burst size as power of 2 of 8 bytes units */
#define DCMIPP_IPC3R1_OTR_Pos               (8UL)
#define DCMIPP_IPC3R1_OTR_Msk               (0xFUL << DCMIPP_IPC3R1_OTR_Pos)                 /*!< 0x00000F00 */
#define DCMIPP_IPC3R1_OTR                   DCMIPP_IPC3R1_OTR_Msk                           /*!< max outstanding transactions: */

/****************  Bit definition for DCMIPP_IPC3R2 register  *****************/
#define DCMIPP_IPC3R2_WLRU_Pos              (16UL)
#define DCMIPP_IPC3R2_WLRU_Msk              (0xFUL << DCMIPP_IPC3R2_WLRU_Pos)                /*!< 0x000F0000 */
#define DCMIPP_IPC3R2_WLRU                  DCMIPP_IPC3R2_WLRU_Msk                          /*!< Ratio for WLRU[3:0] arbitration: */

/****************  Bit definition for DCMIPP_IPC3R3 register  *****************/
#define DCMIPP_IPC3R3_DPREGSTART_Pos        (0UL)
#define DCMIPP_IPC3R3_DPREGSTART_Msk        (0x3FFUL << DCMIPP_IPC3R3_DPREGSTART_Pos)        /*!< 0x000003FF */
#define DCMIPP_IPC3R3_DPREGSTART            DCMIPP_IPC3R3_DPREGSTART_Msk                    /*!< Start word (AXI width = 64 bits) of the FIFO of this client */
#define DCMIPP_IPC3R3_DPREGEND_Pos          (16UL)
#define DCMIPP_IPC3R3_DPREGEND_Msk          (0x3FFUL << DCMIPP_IPC3R3_DPREGEND_Pos)          /*!< 0x03FF0000 */
#define DCMIPP_IPC3R3_DPREGEND              DCMIPP_IPC3R3_DPREGEND_Msk                      /*!< End word (AXI width = 64 bits) of the FIFO of this client */

/****************  Bit definition for DCMIPP_IPC4R1 register  *****************/
#define DCMIPP_IPC4R1_TRAFFIC_Pos           (0UL)
#define DCMIPP_IPC4R1_TRAFFIC_Msk           (0x7UL << DCMIPP_IPC4R1_TRAFFIC_Pos)             /*!< 0x00000007 */
#define DCMIPP_IPC4R1_TRAFFIC               DCMIPP_IPC4R1_TRAFFIC_Msk                       /*!< Burst size as power of 2 of 8 bytes units */
#define DCMIPP_IPC4R1_OTR_Pos               (8UL)
#define DCMIPP_IPC4R1_OTR_Msk               (0xFUL << DCMIPP_IPC4R1_OTR_Pos)                 /*!< 0x00000F00 */
#define DCMIPP_IPC4R1_OTR                   DCMIPP_IPC4R1_OTR_Msk                           /*!< max outstanding transactions: */

/****************  Bit definition for DCMIPP_IPC4R2 register  *****************/
#define DCMIPP_IPC4R2_WLRU_Pos              (16UL)
#define DCMIPP_IPC4R2_WLRU_Msk              (0xFUL << DCMIPP_IPC4R2_WLRU_Pos)                /*!< 0x000F0000 */
#define DCMIPP_IPC4R2_WLRU                  DCMIPP_IPC4R2_WLRU_Msk                          /*!< Ratio for WLRU[3:0] arbitration: */

/****************  Bit definition for DCMIPP_IPC4R3 register  *****************/
#define DCMIPP_IPC4R3_DPREGSTART_Pos        (0UL)
#define DCMIPP_IPC4R3_DPREGSTART_Msk        (0x3FFUL << DCMIPP_IPC4R3_DPREGSTART_Pos)        /*!< 0x000003FF */
#define DCMIPP_IPC4R3_DPREGSTART            DCMIPP_IPC4R3_DPREGSTART_Msk                    /*!< Start word (AXI width = 64 bits) of the FIFO of this client */
#define DCMIPP_IPC4R3_DPREGEND_Pos          (16UL)
#define DCMIPP_IPC4R3_DPREGEND_Msk          (0x3FFUL << DCMIPP_IPC4R3_DPREGEND_Pos)          /*!< 0x03FF0000 */
#define DCMIPP_IPC4R3_DPREGEND              DCMIPP_IPC4R3_DPREGEND_Msk                      /*!< End word (AXI width = 64 bits) of the FIFO of this client */

/****************  Bit definition for DCMIPP_IPC5R1 register  *****************/
#define DCMIPP_IPC5R1_TRAFFIC_Pos           (0UL)
#define DCMIPP_IPC5R1_TRAFFIC_Msk           (0x7UL << DCMIPP_IPC5R1_TRAFFIC_Pos)             /*!< 0x00000007 */
#define DCMIPP_IPC5R1_TRAFFIC               DCMIPP_IPC5R1_TRAFFIC_Msk                       /*!< Burst size as power of 2 of 8 bytes units */
#define DCMIPP_IPC5R1_OTR_Pos               (8UL)
#define DCMIPP_IPC5R1_OTR_Msk               (0xFUL << DCMIPP_IPC5R1_OTR_Pos)                 /*!< 0x00000F00 */
#define DCMIPP_IPC5R1_OTR                   DCMIPP_IPC5R1_OTR_Msk                           /*!< max outstanding transactions: */

/****************  Bit definition for DCMIPP_IPC5R2 register  *****************/
#define DCMIPP_IPC5R2_WLRU_Pos              (16UL)
#define DCMIPP_IPC5R2_WLRU_Msk              (0xFUL << DCMIPP_IPC5R2_WLRU_Pos)                /*!< 0x000F0000 */
#define DCMIPP_IPC5R2_WLRU                  DCMIPP_IPC5R2_WLRU_Msk                          /*!< Ratio for WLRU[3:0] arbitration: */

/****************  Bit definition for DCMIPP_IPC5R3 register  *****************/
#define DCMIPP_IPC5R3_DPREGSTART_Pos        (0UL)
#define DCMIPP_IPC5R3_DPREGSTART_Msk        (0x3FFUL << DCMIPP_IPC5R3_DPREGSTART_Pos)        /*!< 0x000003FF */
#define DCMIPP_IPC5R3_DPREGSTART            DCMIPP_IPC5R3_DPREGSTART_Msk                    /*!< Start word (AXI width = 64 bits) of the FIFO of this client */
#define DCMIPP_IPC5R3_DPREGEND_Pos          (16UL)
#define DCMIPP_IPC5R3_DPREGEND_Msk          (0x3FFUL << DCMIPP_IPC5R3_DPREGEND_Pos)          /*!< 0x03FF0000 */
#define DCMIPP_IPC5R3_DPREGEND              DCMIPP_IPC5R3_DPREGEND_Msk                      /*!< End word (AXI width = 64 bits) of the FIFO of this client */

/***************  Bit definition for DCMIPP_PRHWCFGR register  ****************/

/*****************  Bit definition for DCMIPP_PRCR register  ******************/
#define DCMIPP_PRCR_ESS_Pos                 (4UL)
#define DCMIPP_PRCR_ESS_Msk                 (0x1UL << DCMIPP_PRCR_ESS_Pos)                   /*!< 0x00000010 */
#define DCMIPP_PRCR_ESS                     DCMIPP_PRCR_ESS_Msk                             /*!< Embedded synchronization select */
#define DCMIPP_PRCR_PCKPOL_Pos              (5UL)
#define DCMIPP_PRCR_PCKPOL_Msk              (0x1UL << DCMIPP_PRCR_PCKPOL_Pos)                /*!< 0x00000020 */
#define DCMIPP_PRCR_PCKPOL                  DCMIPP_PRCR_PCKPOL_Msk                          /*!< Pixel clock polarity */
#define DCMIPP_PRCR_HSPOL_Pos               (6UL)
#define DCMIPP_PRCR_HSPOL_Msk               (0x1UL << DCMIPP_PRCR_HSPOL_Pos)                 /*!< 0x00000040 */
#define DCMIPP_PRCR_HSPOL                   DCMIPP_PRCR_HSPOL_Msk                           /*!< Horizontal synchronization polarity */
#define DCMIPP_PRCR_VSPOL_Pos               (7UL)
#define DCMIPP_PRCR_VSPOL_Msk               (0x1UL << DCMIPP_PRCR_VSPOL_Pos)                 /*!< 0x00000080 */
#define DCMIPP_PRCR_VSPOL                   DCMIPP_PRCR_VSPOL_Msk                           /*!< Vertical synchronization polarity */
#define DCMIPP_PRCR_EDM_Pos                 (10UL)
#define DCMIPP_PRCR_EDM_Msk                 (0x7UL << DCMIPP_PRCR_EDM_Pos)                   /*!< 0x00001C00 */
#define DCMIPP_PRCR_EDM                     DCMIPP_PRCR_EDM_Msk                             /*!< Extended data mode */
#define DCMIPP_PRCR_ENABLE_Pos              (14UL)
#define DCMIPP_PRCR_ENABLE_Msk              (0x1UL << DCMIPP_PRCR_ENABLE_Pos)                /*!< 0x00004000 */
#define DCMIPP_PRCR_ENABLE                  DCMIPP_PRCR_ENABLE_Msk                          /*!< Parallel interface enable */
#define DCMIPP_PRCR_FORMAT_Pos              (16UL)
#define DCMIPP_PRCR_FORMAT_Msk              (0xFFUL << DCMIPP_PRCR_FORMAT_Pos)               /*!< 0x00FF0000 */
#define DCMIPP_PRCR_FORMAT                  DCMIPP_PRCR_FORMAT_Msk                          /*!< Other values: Data is captured and output as-is through the data/dump pipeline only (e */
#define DCMIPP_PRCR_SWAPCYCLES_Pos          (25UL)
#define DCMIPP_PRCR_SWAPCYCLES_Msk          (0x1UL << DCMIPP_PRCR_SWAPCYCLES_Pos)            /*!< 0x02000000 */
#define DCMIPP_PRCR_SWAPCYCLES              DCMIPP_PRCR_SWAPCYCLES_Msk                      /*!< Swap data from cycle 0 vs */
#define DCMIPP_PRCR_SWAPBITS_Pos            (26UL)
#define DCMIPP_PRCR_SWAPBITS_Msk            (0x1UL << DCMIPP_PRCR_SWAPBITS_Pos)              /*!< 0x04000000 */
#define DCMIPP_PRCR_SWAPBITS                DCMIPP_PRCR_SWAPBITS_Msk                        /*!< Swap LSB vs */

/****************  Bit definition for DCMIPP_PRESCR register  *****************/
#define DCMIPP_PRESCR_FSC_Pos               (0UL)
#define DCMIPP_PRESCR_FSC_Msk               (0xFFUL << DCMIPP_PRESCR_FSC_Pos)                /*!< 0x000000FF */
#define DCMIPP_PRESCR_FSC                   DCMIPP_PRESCR_FSC_Msk                           /*!< Frame start delimiter code */
#define DCMIPP_PRESCR_LSC_Pos               (8UL)
#define DCMIPP_PRESCR_LSC_Msk               (0xFFUL << DCMIPP_PRESCR_LSC_Pos)                /*!< 0x0000FF00 */
#define DCMIPP_PRESCR_LSC                   DCMIPP_PRESCR_LSC_Msk                           /*!< Line start delimiter code */
#define DCMIPP_PRESCR_LEC_Pos               (16UL)
#define DCMIPP_PRESCR_LEC_Msk               (0xFFUL << DCMIPP_PRESCR_LEC_Pos)                /*!< 0x00FF0000 */
#define DCMIPP_PRESCR_LEC                   DCMIPP_PRESCR_LEC_Msk                           /*!< Line end delimiter code */
#define DCMIPP_PRESCR_FEC_Pos               (24UL)
#define DCMIPP_PRESCR_FEC_Msk               (0xFFUL << DCMIPP_PRESCR_FEC_Pos)                /*!< 0xFF000000 */
#define DCMIPP_PRESCR_FEC                   DCMIPP_PRESCR_FEC_Msk                           /*!< Frame end delimiter code */

/****************  Bit definition for DCMIPP_PRESUR register  *****************/
#define DCMIPP_PRESUR_FSU_Pos               (0UL)
#define DCMIPP_PRESUR_FSU_Msk               (0xFFUL << DCMIPP_PRESUR_FSU_Pos)                /*!< 0x000000FF */
#define DCMIPP_PRESUR_FSU                   DCMIPP_PRESUR_FSU_Msk                           /*!< Frame start delimiter unmask */
#define DCMIPP_PRESUR_LSU_Pos               (8UL)
#define DCMIPP_PRESUR_LSU_Msk               (0xFFUL << DCMIPP_PRESUR_LSU_Pos)                /*!< 0x0000FF00 */
#define DCMIPP_PRESUR_LSU                   DCMIPP_PRESUR_LSU_Msk                           /*!< Line start delimiter unmask */
#define DCMIPP_PRESUR_LEU_Pos               (16UL)
#define DCMIPP_PRESUR_LEU_Msk               (0xFFUL << DCMIPP_PRESUR_LEU_Pos)                /*!< 0x00FF0000 */
#define DCMIPP_PRESUR_LEU                   DCMIPP_PRESUR_LEU_Msk                           /*!< Line end delimiter unmask */
#define DCMIPP_PRESUR_FEU_Pos               (24UL)
#define DCMIPP_PRESUR_FEU_Msk               (0xFFUL << DCMIPP_PRESUR_FEU_Pos)                /*!< 0xFF000000 */
#define DCMIPP_PRESUR_FEU                   DCMIPP_PRESUR_FEU_Msk                           /*!< Frame end delimiter unmask */

/*****************  Bit definition for DCMIPP_PRIER register  *****************/
#define DCMIPP_PRIER_ERRIE_Pos              (6UL)
#define DCMIPP_PRIER_ERRIE_Msk              (0x1UL << DCMIPP_PRIER_ERRIE_Pos)                /*!< 0x00000040 */
#define DCMIPP_PRIER_ERRIE                  DCMIPP_PRIER_ERRIE_Msk                          /*!< Synchronization error interrupt enable */

/*****************  Bit definition for DCMIPP_PRSR register  ******************/
#define DCMIPP_PRSR_ERRF_Pos                (6UL)
#define DCMIPP_PRSR_ERRF_Msk                (0x1UL << DCMIPP_PRSR_ERRF_Pos)                  /*!< 0x00000040 */
#define DCMIPP_PRSR_ERRF                    DCMIPP_PRSR_ERRF_Msk                            /*!< Synchronization error raw interrupt status */
#define DCMIPP_PRSR_HSYNC_Pos               (16UL)
#define DCMIPP_PRSR_HSYNC_Msk               (0x1UL << DCMIPP_PRSR_HSYNC_Pos)                 /*!< 0x00010000 */
#define DCMIPP_PRSR_HSYNC                   DCMIPP_PRSR_HSYNC_Msk                           /*!< This bit gives the state of the HSYNC pin with the correct programmed polarity if the ENABLE bit is */
#define DCMIPP_PRSR_VSYNC_Pos               (17UL)
#define DCMIPP_PRSR_VSYNC_Msk               (0x1UL << DCMIPP_PRSR_VSYNC_Pos)                 /*!< 0x00020000 */
#define DCMIPP_PRSR_VSYNC                   DCMIPP_PRSR_VSYNC_Msk                           /*!< This bit gives the state of the VSYNC pin with the correct programmed polarity if the ENABLE bit is */

/*****************  Bit definition for DCMIPP_PRFCR register  *****************/
#define DCMIPP_PRFCR_CERRF_Pos              (6UL)
#define DCMIPP_PRFCR_CERRF_Msk              (0x1UL << DCMIPP_PRFCR_CERRF_Pos)                /*!< 0x00000040 */
#define DCMIPP_PRFCR_CERRF                  DCMIPP_PRFCR_CERRF_Msk                          /*!< Synchronization error interrupt status clear */

/*****************  Bit definition for DCMIPP_CMCR register  ******************/
#define DCMIPP_CMCR_INSEL_Pos               (0UL)
#define DCMIPP_CMCR_INSEL_Msk               (0x1UL << DCMIPP_CMCR_INSEL_Pos)                 /*!< 0x00000001 */
#define DCMIPP_CMCR_INSEL                   DCMIPP_CMCR_INSEL_Msk                           /*!< input selection */
#define DCMIPP_CMCR_PSFC_Pos                (1UL)
#define DCMIPP_CMCR_PSFC_Msk                (0x3UL << DCMIPP_CMCR_PSFC_Pos)                  /*!< 0x00000006 */
#define DCMIPP_CMCR_PSFC                    DCMIPP_CMCR_PSFC_Msk                            /*!< Pipe selection for the frame counter */
#define DCMIPP_CMCR_CFC_Pos                 (4UL)
#define DCMIPP_CMCR_CFC_Msk                 (0x1UL << DCMIPP_CMCR_CFC_Pos)                   /*!< 0x00000010 */
#define DCMIPP_CMCR_CFC                     DCMIPP_CMCR_CFC_Msk                             /*!< Clear frame counter */
#define DCMIPP_CMCR_SWAPRB_Pos              (7UL)
#define DCMIPP_CMCR_SWAPRB_Msk              (0x1UL << DCMIPP_CMCR_SWAPRB_Pos)                /*!< 0x00000080 */
#define DCMIPP_CMCR_SWAPRB                  DCMIPP_CMCR_SWAPRB_Msk                          /*!< Swap R/U and B/V */

/****************  Bit definition for DCMIPP_CMFRCR register  *****************/
#define DCMIPP_CMFRCR_FRMCNT_Pos            (0UL)
#define DCMIPP_CMFRCR_FRMCNT_Msk            (0xFFFFFFFFUL << DCMIPP_CMFRCR_FRMCNT_Pos)       /*!< 0xFFFFFFFF */
#define DCMIPP_CMFRCR_FRMCNT                DCMIPP_CMFRCR_FRMCNT_Msk                        /*!< Frame counter, read-only, loops around */

/*****************  Bit definition for DCMIPP_CMIER register  *****************/
#define DCMIPP_CMIER_ATXERRIE_Pos           (5UL)
#define DCMIPP_CMIER_ATXERRIE_Msk           (0x1UL << DCMIPP_CMIER_ATXERRIE_Pos)             /*!< 0x00000020 */
#define DCMIPP_CMIER_ATXERRIE               DCMIPP_CMIER_ATXERRIE_Msk                       /*!< AXI Transfer error interrupt enable for IPPLUG */
#define DCMIPP_CMIER_PRERRIE_Pos            (6UL)
#define DCMIPP_CMIER_PRERRIE_Msk            (0x1UL << DCMIPP_CMIER_PRERRIE_Pos)              /*!< 0x00000040 */
#define DCMIPP_CMIER_PRERRIE                DCMIPP_CMIER_PRERRIE_Msk                        /*!< limit interrupt enable for the Parallel Interface */
#define DCMIPP_CMIER_P0LINEIE_Pos           (8UL)
#define DCMIPP_CMIER_P0LINEIE_Msk           (0x1UL << DCMIPP_CMIER_P0LINEIE_Pos)             /*!< 0x00000100 */
#define DCMIPP_CMIER_P0LINEIE               DCMIPP_CMIER_P0LINEIE_Msk                       /*!< multi-Line Capture complete interrupt enable for the Pipe0 */
#define DCMIPP_CMIER_P0FRAMEIE_Pos          (9UL)
#define DCMIPP_CMIER_P0FRAMEIE_Msk          (0x1UL << DCMIPP_CMIER_P0FRAMEIE_Pos)            /*!< 0x00000200 */
#define DCMIPP_CMIER_P0FRAMEIE              DCMIPP_CMIER_P0FRAMEIE_Msk                      /*!< Frame Capture complete interrupt enable for the Pipe0 */
#define DCMIPP_CMIER_P0VSYNCIE_Pos          (10UL)
#define DCMIPP_CMIER_P0VSYNCIE_Msk          (0x1UL << DCMIPP_CMIER_P0VSYNCIE_Pos)            /*!< 0x00000400 */
#define DCMIPP_CMIER_P0VSYNCIE              DCMIPP_CMIER_P0VSYNCIE_Msk                      /*!< Vertical sync interrupt enable for the Pipe0 */
#define DCMIPP_CMIER_P0LIMITIE_Pos          (14UL)
#define DCMIPP_CMIER_P0LIMITIE_Msk          (0x1UL << DCMIPP_CMIER_P0LIMITIE_Pos)            /*!< 0x00004000 */
#define DCMIPP_CMIER_P0LIMITIE              DCMIPP_CMIER_P0LIMITIE_Msk                      /*!< limit interrupt enable for the Pipe0 */
#define DCMIPP_CMIER_P0OVRIE_Pos            (15UL)
#define DCMIPP_CMIER_P0OVRIE_Msk            (0x1UL << DCMIPP_CMIER_P0OVRIE_Pos)              /*!< 0x00008000 */
#define DCMIPP_CMIER_P0OVRIE                DCMIPP_CMIER_P0OVRIE_Msk                        /*!< Overrun interrupt enable for the Pipe0 */
#define DCMIPP_CMIER_P1LINEIE_Pos           (16UL)
#define DCMIPP_CMIER_P1LINEIE_Msk           (0x1UL << DCMIPP_CMIER_P1LINEIE_Pos)             /*!< 0x00010000 */
#define DCMIPP_CMIER_P1LINEIE               DCMIPP_CMIER_P1LINEIE_Msk                       /*!< multi-Line Capture complete interrupt status clear for the Pipe1 */
#define DCMIPP_CMIER_P1FRAMEIE_Pos          (17UL)
#define DCMIPP_CMIER_P1FRAMEIE_Msk          (0x1UL << DCMIPP_CMIER_P1FRAMEIE_Pos)            /*!< 0x00020000 */
#define DCMIPP_CMIER_P1FRAMEIE              DCMIPP_CMIER_P1FRAMEIE_Msk                      /*!< Frame Capture complete interrupt enable for the Pipe1 */
#define DCMIPP_CMIER_P1VSYNCIE_Pos          (18UL)
#define DCMIPP_CMIER_P1VSYNCIE_Msk          (0x1UL << DCMIPP_CMIER_P1VSYNCIE_Pos)            /*!< 0x00040000 */
#define DCMIPP_CMIER_P1VSYNCIE              DCMIPP_CMIER_P1VSYNCIE_Msk                      /*!< Vertical sync interrupt enable for the Pipe1 */
#define DCMIPP_CMIER_P1OVRIE_Pos            (23UL)
#define DCMIPP_CMIER_P1OVRIE_Msk            (0x1UL << DCMIPP_CMIER_P1OVRIE_Pos)              /*!< 0x00800000 */
#define DCMIPP_CMIER_P1OVRIE                DCMIPP_CMIER_P1OVRIE_Msk                        /*!< Overrun interrupt enable for the Pipe1 */
#define DCMIPP_CMIER_P2LINEIE_Pos           (24UL)
#define DCMIPP_CMIER_P2LINEIE_Msk           (0x1UL << DCMIPP_CMIER_P2LINEIE_Pos)             /*!< 0x01000000 */
#define DCMIPP_CMIER_P2LINEIE               DCMIPP_CMIER_P2LINEIE_Msk                       /*!< multi-Line Capture complete interrupt enable for the Pipe2 */
#define DCMIPP_CMIER_P2FRAMEIE_Pos          (25UL)
#define DCMIPP_CMIER_P2FRAMEIE_Msk          (0x1UL << DCMIPP_CMIER_P2FRAMEIE_Pos)            /*!< 0x02000000 */
#define DCMIPP_CMIER_P2FRAMEIE              DCMIPP_CMIER_P2FRAMEIE_Msk                      /*!< Frame Capture complete interrupt enable for the Pipe2 */
#define DCMIPP_CMIER_P2VSYNCIE_Pos          (26UL)
#define DCMIPP_CMIER_P2VSYNCIE_Msk          (0x1UL << DCMIPP_CMIER_P2VSYNCIE_Pos)            /*!< 0x04000000 */
#define DCMIPP_CMIER_P2VSYNCIE              DCMIPP_CMIER_P2VSYNCIE_Msk                      /*!< Vertical sync interrupt enable for the Pipe2 */
#define DCMIPP_CMIER_P2OVRIE_Pos            (31UL)
#define DCMIPP_CMIER_P2OVRIE_Msk            (0x1UL << DCMIPP_CMIER_P2OVRIE_Pos)              /*!< 0x80000000 */
#define DCMIPP_CMIER_P2OVRIE                DCMIPP_CMIER_P2OVRIE_Msk                        /*!< Overrun interrupt status enable for the Pipe2 */

/*****************  Bit definition for DCMIPP_CMSR1 register  *****************/
#define DCMIPP_CMSR1_PRHSYNC_Pos            (0UL)
#define DCMIPP_CMSR1_PRHSYNC_Msk            (0x1UL << DCMIPP_CMSR1_PRHSYNC_Pos)              /*!< 0x00000001 */
#define DCMIPP_CMSR1_PRHSYNC                DCMIPP_CMSR1_PRHSYNC_Msk                        /*!< This bit gives the state of the HSYNC pin with the correct programmed polarity on the parallel inte */
#define DCMIPP_CMSR1_PRVSYNC_Pos            (1UL)
#define DCMIPP_CMSR1_PRVSYNC_Msk            (0x1UL << DCMIPP_CMSR1_PRVSYNC_Pos)              /*!< 0x00000002 */
#define DCMIPP_CMSR1_PRVSYNC                DCMIPP_CMSR1_PRVSYNC_Msk                        /*!< This bit gives the state of the VSYNC pin with the correct programmed polarity on the parallel inte */
#define DCMIPP_CMSR1_P0LSTLINE_Pos          (8UL)
#define DCMIPP_CMSR1_P0LSTLINE_Msk          (0x1UL << DCMIPP_CMSR1_P0LSTLINE_Pos)            /*!< 0x00000100 */
#define DCMIPP_CMSR1_P0LSTLINE              DCMIPP_CMSR1_P0LSTLINE_Msk                      /*!< Last Line LSB bit, sampled at Frame capture complete event for Pipe0 */
#define DCMIPP_CMSR1_P0LSTFRM_Pos           (9UL)
#define DCMIPP_CMSR1_P0LSTFRM_Msk           (0x1UL << DCMIPP_CMSR1_P0LSTFRM_Pos)             /*!< 0x00000200 */
#define DCMIPP_CMSR1_P0LSTFRM               DCMIPP_CMSR1_P0LSTFRM_Msk                       /*!< Last frame LSB bit, sampled at Frame capture complete event for Pipe0 */
#define DCMIPP_CMSR1_P0CPTACT_Pos           (15UL)
#define DCMIPP_CMSR1_P0CPTACT_Msk           (0x1UL << DCMIPP_CMSR1_P0CPTACT_Pos)             /*!< 0x00008000 */
#define DCMIPP_CMSR1_P0CPTACT               DCMIPP_CMSR1_P0CPTACT_Msk                       /*!< Active frame capture (active from start-of-frame to frame complete) for Pipe0 */
#define DCMIPP_CMSR1_P1LSTLINE_Pos          (16UL)
#define DCMIPP_CMSR1_P1LSTLINE_Msk          (0x1UL << DCMIPP_CMSR1_P1LSTLINE_Pos)            /*!< 0x00010000 */
#define DCMIPP_CMSR1_P1LSTLINE              DCMIPP_CMSR1_P1LSTLINE_Msk                      /*!< Last Line LSB bit, sampled at Frame capture complete event for Pipe1 */
#define DCMIPP_CMSR1_P1LSTFRM_Pos           (17UL)
#define DCMIPP_CMSR1_P1LSTFRM_Msk           (0x1UL << DCMIPP_CMSR1_P1LSTFRM_Pos)             /*!< 0x00020000 */
#define DCMIPP_CMSR1_P1LSTFRM               DCMIPP_CMSR1_P1LSTFRM_Msk                       /*!< Last frame LSB bit, sampled at frame capture complete event for Pipe1 */
#define DCMIPP_CMSR1_P1CPTACT_Pos           (23UL)
#define DCMIPP_CMSR1_P1CPTACT_Msk           (0x1UL << DCMIPP_CMSR1_P1CPTACT_Pos)             /*!< 0x00800000 */
#define DCMIPP_CMSR1_P1CPTACT               DCMIPP_CMSR1_P1CPTACT_Msk                       /*!< Active frame capture (active from start-of-frame to frame complete) for Pipe1 */
#define DCMIPP_CMSR1_P2LSTLINE_Pos          (24UL)
#define DCMIPP_CMSR1_P2LSTLINE_Msk          (0x1UL << DCMIPP_CMSR1_P2LSTLINE_Pos)            /*!< 0x01000000 */
#define DCMIPP_CMSR1_P2LSTLINE              DCMIPP_CMSR1_P2LSTLINE_Msk                      /*!< Last line LSB bit, sampled at Frame capture complete event for Pipe2 */
#define DCMIPP_CMSR1_P2LSTFRM_Pos           (25UL)
#define DCMIPP_CMSR1_P2LSTFRM_Msk           (0x1UL << DCMIPP_CMSR1_P2LSTFRM_Pos)             /*!< 0x02000000 */
#define DCMIPP_CMSR1_P2LSTFRM               DCMIPP_CMSR1_P2LSTFRM_Msk                       /*!< Last frame LSB bit, sampled at frame capture complete event for Pipe2 */
#define DCMIPP_CMSR1_P2CPTACT_Pos           (31UL)
#define DCMIPP_CMSR1_P2CPTACT_Msk           (0x1UL << DCMIPP_CMSR1_P2CPTACT_Pos)             /*!< 0x80000000 */
#define DCMIPP_CMSR1_P2CPTACT               DCMIPP_CMSR1_P2CPTACT_Msk                       /*!< Active frame capture (active from start-of-frame to frame complete) for Pipe2 */

/*****************  Bit definition for DCMIPP_CMSR2 register  *****************/
#define DCMIPP_CMSR2_ATXERRF_Pos            (5UL)
#define DCMIPP_CMSR2_ATXERRF_Msk            (0x1UL << DCMIPP_CMSR2_ATXERRF_Pos)              /*!< 0x00000020 */
#define DCMIPP_CMSR2_ATXERRF                DCMIPP_CMSR2_ATXERRF_Msk                        /*!< AXI transfer error interrupt status flag for the IPPLUG */
#define DCMIPP_CMSR2_PRERRF_Pos             (6UL)
#define DCMIPP_CMSR2_PRERRF_Msk             (0x1UL << DCMIPP_CMSR2_PRERRF_Pos)               /*!< 0x00000040 */
#define DCMIPP_CMSR2_PRERRF                 DCMIPP_CMSR2_PRERRF_Msk                         /*!< Synchronization error raw interrupt status for the parallel interface */
#define DCMIPP_CMSR2_P0LINEF_Pos            (8UL)
#define DCMIPP_CMSR2_P0LINEF_Msk            (0x1UL << DCMIPP_CMSR2_P0LINEF_Pos)              /*!< 0x00000100 */
#define DCMIPP_CMSR2_P0LINEF                DCMIPP_CMSR2_P0LINEF_Msk                        /*!< Multi-line capture completed raw interrupt status for Pipe0 */
#define DCMIPP_CMSR2_P0FRAMEF_Pos           (9UL)
#define DCMIPP_CMSR2_P0FRAMEF_Msk           (0x1UL << DCMIPP_CMSR2_P0FRAMEF_Pos)             /*!< 0x00000200 */
#define DCMIPP_CMSR2_P0FRAMEF               DCMIPP_CMSR2_P0FRAMEF_Msk                       /*!< Frame capture completed raw interrupt status for Pipe0 */
#define DCMIPP_CMSR2_P0VSYNCF_Pos           (10UL)
#define DCMIPP_CMSR2_P0VSYNCF_Msk           (0x1UL << DCMIPP_CMSR2_P0VSYNCF_Pos)             /*!< 0x00000400 */
#define DCMIPP_CMSR2_P0VSYNCF               DCMIPP_CMSR2_P0VSYNCF_Msk                       /*!< VSYNC raw interrupt status for Pipe0 */
#define DCMIPP_CMSR2_P0LIMITF_Pos           (14UL)
#define DCMIPP_CMSR2_P0LIMITF_Msk           (0x1UL << DCMIPP_CMSR2_P0LIMITF_Pos)             /*!< 0x00004000 */
#define DCMIPP_CMSR2_P0LIMITF               DCMIPP_CMSR2_P0LIMITF_Msk                       /*!< Limit raw interrupt status for Pipe0 */
#define DCMIPP_CMSR2_P0OVRF_Pos             (15UL)
#define DCMIPP_CMSR2_P0OVRF_Msk             (0x1UL << DCMIPP_CMSR2_P0OVRF_Pos)               /*!< 0x00008000 */
#define DCMIPP_CMSR2_P0OVRF                 DCMIPP_CMSR2_P0OVRF_Msk                         /*!< Overrun raw interrupt status for Pipe0 */
#define DCMIPP_CMSR2_P1LINEF_Pos            (16UL)
#define DCMIPP_CMSR2_P1LINEF_Msk            (0x1UL << DCMIPP_CMSR2_P1LINEF_Pos)              /*!< 0x00010000 */
#define DCMIPP_CMSR2_P1LINEF                DCMIPP_CMSR2_P1LINEF_Msk                        /*!< Multi-line capture completed raw interrupt status for Pipe1 */
#define DCMIPP_CMSR2_P1FRAMEF_Pos           (17UL)
#define DCMIPP_CMSR2_P1FRAMEF_Msk           (0x1UL << DCMIPP_CMSR2_P1FRAMEF_Pos)             /*!< 0x00020000 */
#define DCMIPP_CMSR2_P1FRAMEF               DCMIPP_CMSR2_P1FRAMEF_Msk                       /*!< Frame capture completed raw interrupt status for Pipe1 */
#define DCMIPP_CMSR2_P1VSYNCF_Pos           (18UL)
#define DCMIPP_CMSR2_P1VSYNCF_Msk           (0x1UL << DCMIPP_CMSR2_P1VSYNCF_Pos)             /*!< 0x00040000 */
#define DCMIPP_CMSR2_P1VSYNCF               DCMIPP_CMSR2_P1VSYNCF_Msk                       /*!< VSYNC raw interrupt status for Pipe1 */
#define DCMIPP_CMSR2_P1OVRF_Pos             (23UL)
#define DCMIPP_CMSR2_P1OVRF_Msk             (0x1UL << DCMIPP_CMSR2_P1OVRF_Pos)               /*!< 0x00800000 */
#define DCMIPP_CMSR2_P1OVRF                 DCMIPP_CMSR2_P1OVRF_Msk                         /*!< Overrun raw interrupt status for Pipe1 */
#define DCMIPP_CMSR2_P2LINEF_Pos            (24UL)
#define DCMIPP_CMSR2_P2LINEF_Msk            (0x1UL << DCMIPP_CMSR2_P2LINEF_Pos)              /*!< 0x01000000 */
#define DCMIPP_CMSR2_P2LINEF                DCMIPP_CMSR2_P2LINEF_Msk                        /*!< Multi-line capture completed raw interrupt status for Pipe2 */
#define DCMIPP_CMSR2_P2FRAMEF_Pos           (25UL)
#define DCMIPP_CMSR2_P2FRAMEF_Msk           (0x1UL << DCMIPP_CMSR2_P2FRAMEF_Pos)             /*!< 0x02000000 */
#define DCMIPP_CMSR2_P2FRAMEF               DCMIPP_CMSR2_P2FRAMEF_Msk                       /*!< Frame capture completed raw interrupt status for Pipe2 */
#define DCMIPP_CMSR2_P2VSYNCF_Pos           (26UL)
#define DCMIPP_CMSR2_P2VSYNCF_Msk           (0x1UL << DCMIPP_CMSR2_P2VSYNCF_Pos)             /*!< 0x04000000 */
#define DCMIPP_CMSR2_P2VSYNCF               DCMIPP_CMSR2_P2VSYNCF_Msk                       /*!< VSYNC raw interrupt status for Pipe2 */
#define DCMIPP_CMSR2_P2OVRF_Pos             (31UL)
#define DCMIPP_CMSR2_P2OVRF_Msk             (0x1UL << DCMIPP_CMSR2_P2OVRF_Pos)               /*!< 0x80000000 */
#define DCMIPP_CMSR2_P2OVRF                 DCMIPP_CMSR2_P2OVRF_Msk                         /*!< Overrun raw interrupt status for Pipe2 */

/*****************  Bit definition for DCMIPP_CMFCR register  *****************/
#define DCMIPP_CMFCR_CATXERRF_Pos           (5UL)
#define DCMIPP_CMFCR_CATXERRF_Msk           (0x1UL << DCMIPP_CMFCR_CATXERRF_Pos)             /*!< 0x00000020 */
#define DCMIPP_CMFCR_CATXERRF               DCMIPP_CMFCR_CATXERRF_Msk                       /*!< AXI Transfer error interrupt status clear */
#define DCMIPP_CMFCR_CPRERRF_Pos            (6UL)
#define DCMIPP_CMFCR_CPRERRF_Msk            (0x1UL << DCMIPP_CMFCR_CPRERRF_Pos)              /*!< 0x00000040 */
#define DCMIPP_CMFCR_CPRERRF                DCMIPP_CMFCR_CPRERRF_Msk                        /*!< Synchronization error interrupt status clear */
#define DCMIPP_CMFCR_CP0LINEF_Pos           (8UL)
#define DCMIPP_CMFCR_CP0LINEF_Msk           (0x1UL << DCMIPP_CMFCR_CP0LINEF_Pos)             /*!< 0x00000100 */
#define DCMIPP_CMFCR_CP0LINEF               DCMIPP_CMFCR_CP0LINEF_Msk                       /*!< Multi-line capture complete interrupt status clear */
#define DCMIPP_CMFCR_CP0FRAMEF_Pos          (9UL)
#define DCMIPP_CMFCR_CP0FRAMEF_Msk          (0x1UL << DCMIPP_CMFCR_CP0FRAMEF_Pos)            /*!< 0x00000200 */
#define DCMIPP_CMFCR_CP0FRAMEF              DCMIPP_CMFCR_CP0FRAMEF_Msk                      /*!< Frame capture complete interrupt status clear */
#define DCMIPP_CMFCR_CP0VSYNCF_Pos          (10UL)
#define DCMIPP_CMFCR_CP0VSYNCF_Msk          (0x1UL << DCMIPP_CMFCR_CP0VSYNCF_Pos)            /*!< 0x00000400 */
#define DCMIPP_CMFCR_CP0VSYNCF              DCMIPP_CMFCR_CP0VSYNCF_Msk                      /*!< Vertical synchronization interrupt status clear */
#define DCMIPP_CMFCR_CP0LIMITF_Pos          (14UL)
#define DCMIPP_CMFCR_CP0LIMITF_Msk          (0x1UL << DCMIPP_CMFCR_CP0LIMITF_Pos)            /*!< 0x00004000 */
#define DCMIPP_CMFCR_CP0LIMITF              DCMIPP_CMFCR_CP0LIMITF_Msk                      /*!< limit interrupt status clear */
#define DCMIPP_CMFCR_CP0OVRF_Pos            (15UL)
#define DCMIPP_CMFCR_CP0OVRF_Msk            (0x1UL << DCMIPP_CMFCR_CP0OVRF_Pos)              /*!< 0x00008000 */
#define DCMIPP_CMFCR_CP0OVRF                DCMIPP_CMFCR_CP0OVRF_Msk                        /*!< Overrun interrupt status clear */
#define DCMIPP_CMFCR_CP1LINEF_Pos           (16UL)
#define DCMIPP_CMFCR_CP1LINEF_Msk           (0x1UL << DCMIPP_CMFCR_CP1LINEF_Pos)             /*!< 0x00010000 */
#define DCMIPP_CMFCR_CP1LINEF               DCMIPP_CMFCR_CP1LINEF_Msk                       /*!< Multi-line capture complete interrupt status clear */
#define DCMIPP_CMFCR_CP1FRAMEF_Pos          (17UL)
#define DCMIPP_CMFCR_CP1FRAMEF_Msk          (0x1UL << DCMIPP_CMFCR_CP1FRAMEF_Pos)            /*!< 0x00020000 */
#define DCMIPP_CMFCR_CP1FRAMEF              DCMIPP_CMFCR_CP1FRAMEF_Msk                      /*!< Frame capture complete interrupt status clear */
#define DCMIPP_CMFCR_CP1VSYNCF_Pos          (18UL)
#define DCMIPP_CMFCR_CP1VSYNCF_Msk          (0x1UL << DCMIPP_CMFCR_CP1VSYNCF_Pos)            /*!< 0x00040000 */
#define DCMIPP_CMFCR_CP1VSYNCF              DCMIPP_CMFCR_CP1VSYNCF_Msk                      /*!< Vertical synchronization interrupt status clear */
#define DCMIPP_CMFCR_CP1OVRF_Pos            (23UL)
#define DCMIPP_CMFCR_CP1OVRF_Msk            (0x1UL << DCMIPP_CMFCR_CP1OVRF_Pos)              /*!< 0x00800000 */
#define DCMIPP_CMFCR_CP1OVRF                DCMIPP_CMFCR_CP1OVRF_Msk                        /*!< Overrun interrupt status clear */
#define DCMIPP_CMFCR_CP2LINEF_Pos           (24UL)
#define DCMIPP_CMFCR_CP2LINEF_Msk           (0x1UL << DCMIPP_CMFCR_CP2LINEF_Pos)             /*!< 0x01000000 */
#define DCMIPP_CMFCR_CP2LINEF               DCMIPP_CMFCR_CP2LINEF_Msk                       /*!< Multi-line capture complete interrupt status clear */
#define DCMIPP_CMFCR_CP2FRAMEF_Pos          (25UL)
#define DCMIPP_CMFCR_CP2FRAMEF_Msk          (0x1UL << DCMIPP_CMFCR_CP2FRAMEF_Pos)            /*!< 0x02000000 */
#define DCMIPP_CMFCR_CP2FRAMEF              DCMIPP_CMFCR_CP2FRAMEF_Msk                      /*!< Frame capture complete interrupt status clear */
#define DCMIPP_CMFCR_CP2VSYNCF_Pos          (26UL)
#define DCMIPP_CMFCR_CP2VSYNCF_Msk          (0x1UL << DCMIPP_CMFCR_CP2VSYNCF_Pos)            /*!< 0x04000000 */
#define DCMIPP_CMFCR_CP2VSYNCF              DCMIPP_CMFCR_CP2VSYNCF_Msk                      /*!< Vertical synchronization interrupt status clear */
#define DCMIPP_CMFCR_CP2OVRF_Pos            (31UL)
#define DCMIPP_CMFCR_CP2OVRF_Msk            (0x1UL << DCMIPP_CMFCR_CP2OVRF_Pos)              /*!< 0x80000000 */
#define DCMIPP_CMFCR_CP2OVRF                DCMIPP_CMFCR_CP2OVRF_Msk                        /*!< Overrun interrupt status clear */

/****************  Bit definition for DCMIPP_P0FSCR register  *****************/
#define DCMIPP_P0FSCR_DTIDA_Pos             (0UL)
#define DCMIPP_P0FSCR_DTIDA_Msk             (0x3FUL << DCMIPP_P0FSCR_DTIDA_Pos)              /*!< 0x0000003F */
#define DCMIPP_P0FSCR_DTIDA                 DCMIPP_P0FSCR_DTIDA_Msk                         /*!< Data type selection ID A */
#define DCMIPP_P0FSCR_DTIDB_Pos             (8UL)
#define DCMIPP_P0FSCR_DTIDB_Msk             (0x3FUL << DCMIPP_P0FSCR_DTIDB_Pos)              /*!< 0x00003F00 */
#define DCMIPP_P0FSCR_DTIDB                 DCMIPP_P0FSCR_DTIDB_Msk                         /*!< Data type selection ID B */
#define DCMIPP_P0FSCR_DTMODE_Pos            (16UL)
#define DCMIPP_P0FSCR_DTMODE_Msk            (0x3UL << DCMIPP_P0FSCR_DTMODE_Pos)              /*!< 0x00030000 */
#define DCMIPP_P0FSCR_DTMODE                DCMIPP_P0FSCR_DTMODE_Msk                        /*!< Flow selection mode */
#define DCMIPP_P0FSCR_VC_Pos                (19UL)
#define DCMIPP_P0FSCR_VC_Msk                (0x3UL << DCMIPP_P0FSCR_VC_Pos)                  /*!< 0x00180000 */
#define DCMIPP_P0FSCR_VC                    DCMIPP_P0FSCR_VC_Msk                            /*!< Flow selection mode */
#define DCMIPP_P0FSCR_PIPEN_Pos             (31UL)
#define DCMIPP_P0FSCR_PIPEN_Msk             (0x1UL << DCMIPP_P0FSCR_PIPEN_Pos)               /*!< 0x80000000 */
#define DCMIPP_P0FSCR_PIPEN                 DCMIPP_P0FSCR_PIPEN_Msk                         /*!< Activation of PipeN */

/****************  Bit definition for DCMIPP_P0FCTCR register  ****************/
#define DCMIPP_P0FCTCR_FRATE_Pos            (0UL)
#define DCMIPP_P0FCTCR_FRATE_Msk            (0x3UL << DCMIPP_P0FCTCR_FRATE_Pos)              /*!< 0x00000003 */
#define DCMIPP_P0FCTCR_FRATE                DCMIPP_P0FCTCR_FRATE_Msk                        /*!< Frame capture rate control */
#define DCMIPP_P0FCTCR_CPTMODE_Pos          (2UL)
#define DCMIPP_P0FCTCR_CPTMODE_Msk          (0x1UL << DCMIPP_P0FCTCR_CPTMODE_Pos)            /*!< 0x00000004 */
#define DCMIPP_P0FCTCR_CPTMODE              DCMIPP_P0FCTCR_CPTMODE_Msk                      /*!< Capture mode */
#define DCMIPP_P0FCTCR_CPTREQ_Pos           (3UL)
#define DCMIPP_P0FCTCR_CPTREQ_Msk           (0x1UL << DCMIPP_P0FCTCR_CPTREQ_Pos)             /*!< 0x00000008 */
#define DCMIPP_P0FCTCR_CPTREQ               DCMIPP_P0FCTCR_CPTREQ_Msk                       /*!< Capture requested */

/****************  Bit definition for DCMIPP_P0SCSTR register  ****************/
#define DCMIPP_P0SCSTR_HSTART_Pos           (0UL)
#define DCMIPP_P0SCSTR_HSTART_Msk           (0xFFFUL << DCMIPP_P0SCSTR_HSTART_Pos)           /*!< 0x00000FFF */
#define DCMIPP_P0SCSTR_HSTART               DCMIPP_P0SCSTR_HSTART_Msk                       /*!< Horizontal start, from 0 to 4094 words wide */
#define DCMIPP_P0SCSTR_VSTART_Pos           (16UL)
#define DCMIPP_P0SCSTR_VSTART_Msk           (0xFFFUL << DCMIPP_P0SCSTR_VSTART_Pos)           /*!< 0x0FFF0000 */
#define DCMIPP_P0SCSTR_VSTART               DCMIPP_P0SCSTR_VSTART_Msk                       /*!< Vertical start, from 0 to 4094 pixels high */

/****************  Bit definition for DCMIPP_P0SCSZR register  ****************/
#define DCMIPP_P0SCSZR_HSIZE_Pos            (0UL)
#define DCMIPP_P0SCSZR_HSIZE_Msk            (0xFFFUL << DCMIPP_P0SCSZR_HSIZE_Pos)            /*!< 0x00000FFF */
#define DCMIPP_P0SCSZR_HSIZE                DCMIPP_P0SCSZR_HSIZE_Msk                        /*!< Horizontal size, from 0 to 4094 word wide (data 32-bit) */
#define DCMIPP_P0SCSZR_VSIZE_Pos            (16UL)
#define DCMIPP_P0SCSZR_VSIZE_Msk            (0xFFFUL << DCMIPP_P0SCSZR_VSIZE_Pos)            /*!< 0x0FFF0000 */
#define DCMIPP_P0SCSZR_VSIZE                DCMIPP_P0SCSZR_VSIZE_Msk                        /*!< Vertical size, from 0 to 4094 pixels high */
#define DCMIPP_P0SCSZR_POSNEG_Pos           (30UL)
#define DCMIPP_P0SCSZR_POSNEG_Msk           (0x1UL << DCMIPP_P0SCSZR_POSNEG_Pos)             /*!< 0x40000000 */
#define DCMIPP_P0SCSZR_POSNEG               DCMIPP_P0SCSZR_POSNEG_Msk                       /*!< This bit is set and cleared by software */
#define DCMIPP_P0SCSZR_ENABLE_Pos           (31UL)
#define DCMIPP_P0SCSZR_ENABLE_Msk           (0x1UL << DCMIPP_P0SCSZR_ENABLE_Pos)             /*!< 0x80000000 */
#define DCMIPP_P0SCSZR_ENABLE               DCMIPP_P0SCSZR_ENABLE_Msk                       /*!< This bit is set and cleared by software */

/***************  Bit definition for DCMIPP_P0DCCNTR register  ****************/
#define DCMIPP_P0DCCNTR_CNT_Pos             (0UL)
#define DCMIPP_P0DCCNTR_CNT_Msk             (0x3FFFFFFUL << DCMIPP_P0DCCNTR_CNT_Pos)         /*!< 0x03FFFFFF */
#define DCMIPP_P0DCCNTR_CNT                 DCMIPP_P0DCCNTR_CNT_Msk                         /*!< Number of data dumped during the frame */

/***************  Bit definition for DCMIPP_P0DCLMTR register  ****************/
#define DCMIPP_P0DCLMTR_LIMIT_Pos           (0UL)
#define DCMIPP_P0DCLMTR_LIMIT_Msk           (0xFFFFFFUL << DCMIPP_P0DCLMTR_LIMIT_Pos)        /*!< 0x00FFFFFF */
#define DCMIPP_P0DCLMTR_LIMIT               DCMIPP_P0DCLMTR_LIMIT_Msk                       /*!< Maximum number of 32-bit data that can be dumped during a frame, after the crop 2D operation */
#define DCMIPP_P0DCLMTR_ENABLE_Pos          (31UL)
#define DCMIPP_P0DCLMTR_ENABLE_Msk          (0x1UL << DCMIPP_P0DCLMTR_ENABLE_Pos)            /*!< 0x80000000 */
#define DCMIPP_P0DCLMTR_ENABLE              DCMIPP_P0DCLMTR_ENABLE_Msk                      /*!<  */

/****************  Bit definition for DCMIPP_P0PPCR register  *****************/
#define DCMIPP_P0PPCR_SWAPYUV_Pos           (0UL)
#define DCMIPP_P0PPCR_SWAPYUV_Msk           (0x1UL << DCMIPP_P0PPCR_SWAPYUV_Pos)             /*!< 0x00000001 */
#define DCMIPP_P0PPCR_SWAPYUV               DCMIPP_P0PPCR_SWAPYUV_Msk                       /*!< SwapY vs UV bits, when the YUV mode is active */
#define DCMIPP_P0PPCR_PAD_Pos               (5UL)
#define DCMIPP_P0PPCR_PAD_Msk               (0x1UL << DCMIPP_P0PPCR_PAD_Pos)                 /*!< 0x00000020 */
#define DCMIPP_P0PPCR_PAD                   DCMIPP_P0PPCR_PAD_Msk                           /*!< Pad mode for monochrome and raw Bayer 10/12/14 bpp: MSB vs */
#define DCMIPP_P0PPCR_HEADEREN_Pos          (6UL)
#define DCMIPP_P0PPCR_HEADEREN_Msk          (0x1UL << DCMIPP_P0PPCR_HEADEREN_Pos)            /*!< 0x00000040 */
#define DCMIPP_P0PPCR_HEADEREN              DCMIPP_P0PPCR_HEADEREN_Msk                      /*!< CSI header dump enable */
#define DCMIPP_P0PPCR_BSM_Pos               (7UL)
#define DCMIPP_P0PPCR_BSM_Msk               (0x3UL << DCMIPP_P0PPCR_BSM_Pos)                 /*!< 0x00000180 */
#define DCMIPP_P0PPCR_BSM                   DCMIPP_P0PPCR_BSM_Msk                           /*!< Byte select mode */
#define DCMIPP_P0PPCR_OEBS_Pos              (9UL)
#define DCMIPP_P0PPCR_OEBS_Msk              (0x1UL << DCMIPP_P0PPCR_OEBS_Pos)                /*!< 0x00000200 */
#define DCMIPP_P0PPCR_OEBS                  DCMIPP_P0PPCR_OEBS_Msk                          /*!< Odd/even byte select (byte select start) */
#define DCMIPP_P0PPCR_LSM_Pos               (10UL)
#define DCMIPP_P0PPCR_LSM_Msk               (0x1UL << DCMIPP_P0PPCR_LSM_Pos)                 /*!< 0x00000400 */
#define DCMIPP_P0PPCR_LSM                   DCMIPP_P0PPCR_LSM_Msk                           /*!< Line select mode */
#define DCMIPP_P0PPCR_OELS_Pos              (11UL)
#define DCMIPP_P0PPCR_OELS_Msk              (0x1UL << DCMIPP_P0PPCR_OELS_Pos)                /*!< 0x00000800 */
#define DCMIPP_P0PPCR_OELS                  DCMIPP_P0PPCR_OELS_Msk                          /*!< Odd/even line select (line select start) */
#define DCMIPP_P0PPCR_LINEMULT_Pos          (13UL)
#define DCMIPP_P0PPCR_LINEMULT_Msk          (0x7UL << DCMIPP_P0PPCR_LINEMULT_Pos)            /*!< 0x0000E000 */
#define DCMIPP_P0PPCR_LINEMULT              DCMIPP_P0PPCR_LINEMULT_Msk                      /*!< Amount of capture completed lines for LINE Event and Interrupt */
#define DCMIPP_P0PPCR_DBM_Pos               (16UL)
#define DCMIPP_P0PPCR_DBM_Msk               (0x1UL << DCMIPP_P0PPCR_DBM_Pos)                 /*!< 0x00010000 */
#define DCMIPP_P0PPCR_DBM                   DCMIPP_P0PPCR_DBM_Msk                           /*!< Double buffer mode */

/***************  Bit definition for DCMIPP_P0PPM0AR1 register  ***************/
#define DCMIPP_P0PPM0AR1_M0A_Pos            (0UL)
#define DCMIPP_P0PPM0AR1_M0A_Msk            (0xFFFFFFFFUL << DCMIPP_P0PPM0AR1_M0A_Pos)       /*!< 0xFFFFFFFF */
#define DCMIPP_P0PPM0AR1_M0A                DCMIPP_P0PPM0AR1_M0A_Msk                        /*!< Memory0 address */

/***************  Bit definition for DCMIPP_P0PPM0AR2 register  ***************/
#define DCMIPP_P0PPM0AR2_M0A_Pos            (0UL)
#define DCMIPP_P0PPM0AR2_M0A_Msk            (0xFFFFFFFFUL << DCMIPP_P0PPM0AR2_M0A_Pos)       /*!< 0xFFFFFFFF */
#define DCMIPP_P0PPM0AR2_M0A                DCMIPP_P0PPM0AR2_M0A_Msk                        /*!< Memory0 address */

/*****************  Bit definition for DCMIPP_P0IER register  *****************/
#define DCMIPP_P0IER_LINEIE_Pos             (0UL)
#define DCMIPP_P0IER_LINEIE_Msk             (0x1UL << DCMIPP_P0IER_LINEIE_Pos)               /*!< 0x00000001 */
#define DCMIPP_P0IER_LINEIE                 DCMIPP_P0IER_LINEIE_Msk                         /*!< Multi-line capture completed interrupt enable */
#define DCMIPP_P0IER_FRAMEIE_Pos            (1UL)
#define DCMIPP_P0IER_FRAMEIE_Msk            (0x1UL << DCMIPP_P0IER_FRAMEIE_Pos)              /*!< 0x00000002 */
#define DCMIPP_P0IER_FRAMEIE                DCMIPP_P0IER_FRAMEIE_Msk                        /*!< Frame capture completed interrupt enable */
#define DCMIPP_P0IER_VSYNCIE_Pos            (2UL)
#define DCMIPP_P0IER_VSYNCIE_Msk            (0x1UL << DCMIPP_P0IER_VSYNCIE_Pos)              /*!< 0x00000004 */
#define DCMIPP_P0IER_VSYNCIE                DCMIPP_P0IER_VSYNCIE_Msk                        /*!< VSYNC interrupt enable */
#define DCMIPP_P0IER_LIMITIE_Pos            (6UL)
#define DCMIPP_P0IER_LIMITIE_Msk            (0x1UL << DCMIPP_P0IER_LIMITIE_Pos)              /*!< 0x00000040 */
#define DCMIPP_P0IER_LIMITIE                DCMIPP_P0IER_LIMITIE_Msk                        /*!< Limit interrupt enable */
#define DCMIPP_P0IER_OVRIE_Pos              (7UL)
#define DCMIPP_P0IER_OVRIE_Msk              (0x1UL << DCMIPP_P0IER_OVRIE_Pos)                /*!< 0x00000080 */
#define DCMIPP_P0IER_OVRIE                  DCMIPP_P0IER_OVRIE_Msk                          /*!< Overrun interrupt enable */

/*****************  Bit definition for DCMIPP_P0SR register  ******************/
#define DCMIPP_P0SR_LINEF_Pos               (0UL)
#define DCMIPP_P0SR_LINEF_Msk               (0x1UL << DCMIPP_P0SR_LINEF_Pos)                 /*!< 0x00000001 */
#define DCMIPP_P0SR_LINEF                   DCMIPP_P0SR_LINEF_Msk                           /*!< Multi-line capture completed raw interrupt status */
#define DCMIPP_P0SR_FRAMEF_Pos              (1UL)
#define DCMIPP_P0SR_FRAMEF_Msk              (0x1UL << DCMIPP_P0SR_FRAMEF_Pos)                /*!< 0x00000002 */
#define DCMIPP_P0SR_FRAMEF                  DCMIPP_P0SR_FRAMEF_Msk                          /*!< Frame capture completed raw interrupt status */
#define DCMIPP_P0SR_VSYNCF_Pos              (2UL)
#define DCMIPP_P0SR_VSYNCF_Msk              (0x1UL << DCMIPP_P0SR_VSYNCF_Pos)                /*!< 0x00000004 */
#define DCMIPP_P0SR_VSYNCF                  DCMIPP_P0SR_VSYNCF_Msk                          /*!< VSYNC raw interrupt status */
#define DCMIPP_P0SR_LIMITF_Pos              (6UL)
#define DCMIPP_P0SR_LIMITF_Msk              (0x1UL << DCMIPP_P0SR_LIMITF_Pos)                /*!< 0x00000040 */
#define DCMIPP_P0SR_LIMITF                  DCMIPP_P0SR_LIMITF_Msk                          /*!< Limit raw interrupt status */
#define DCMIPP_P0SR_OVRF_Pos                (7UL)
#define DCMIPP_P0SR_OVRF_Msk                (0x1UL << DCMIPP_P0SR_OVRF_Pos)                  /*!< 0x00000080 */
#define DCMIPP_P0SR_OVRF                    DCMIPP_P0SR_OVRF_Msk                            /*!< Overrun raw interrupt status */
#define DCMIPP_P0SR_LSTLINE_Pos             (16UL)
#define DCMIPP_P0SR_LSTLINE_Msk             (0x1UL << DCMIPP_P0SR_LSTLINE_Pos)               /*!< 0x00010000 */
#define DCMIPP_P0SR_LSTLINE                 DCMIPP_P0SR_LSTLINE_Msk                         /*!< Last line LSB bit, sampled at frame capture complete event */
#define DCMIPP_P0SR_LSTFRM_Pos              (17UL)
#define DCMIPP_P0SR_LSTFRM_Msk              (0x1UL << DCMIPP_P0SR_LSTFRM_Pos)                /*!< 0x00020000 */
#define DCMIPP_P0SR_LSTFRM                  DCMIPP_P0SR_LSTFRM_Msk                          /*!< Last frame LSB bit, sampled at frame capture complete event */
#define DCMIPP_P0SR_CPTACT_Pos              (23UL)
#define DCMIPP_P0SR_CPTACT_Msk              (0x1UL << DCMIPP_P0SR_CPTACT_Pos)                /*!< 0x00800000 */
#define DCMIPP_P0SR_CPTACT                  DCMIPP_P0SR_CPTACT_Msk                          /*!< Capture immediate status */

/*****************  Bit definition for DCMIPP_P0FCR register  *****************/
#define DCMIPP_P0FCR_CLINEF_Pos             (0UL)
#define DCMIPP_P0FCR_CLINEF_Msk             (0x1UL << DCMIPP_P0FCR_CLINEF_Pos)               /*!< 0x00000001 */
#define DCMIPP_P0FCR_CLINEF                 DCMIPP_P0FCR_CLINEF_Msk                         /*!< Multi-line capture complete interrupt status clear */
#define DCMIPP_P0FCR_CFRAMEF_Pos            (1UL)
#define DCMIPP_P0FCR_CFRAMEF_Msk            (0x1UL << DCMIPP_P0FCR_CFRAMEF_Pos)              /*!< 0x00000002 */
#define DCMIPP_P0FCR_CFRAMEF                DCMIPP_P0FCR_CFRAMEF_Msk                        /*!< Frame capture complete interrupt status clear */
#define DCMIPP_P0FCR_CVSYNCF_Pos            (2UL)
#define DCMIPP_P0FCR_CVSYNCF_Msk            (0x1UL << DCMIPP_P0FCR_CVSYNCF_Pos)              /*!< 0x00000004 */
#define DCMIPP_P0FCR_CVSYNCF                DCMIPP_P0FCR_CVSYNCF_Msk                        /*!< Vertical synchronization interrupt status clear */
#define DCMIPP_P0FCR_CLIMITF_Pos            (6UL)
#define DCMIPP_P0FCR_CLIMITF_Msk            (0x1UL << DCMIPP_P0FCR_CLIMITF_Pos)              /*!< 0x00000040 */
#define DCMIPP_P0FCR_CLIMITF                DCMIPP_P0FCR_CLIMITF_Msk                        /*!< limit interrupt status clear */
#define DCMIPP_P0FCR_COVRF_Pos              (7UL)
#define DCMIPP_P0FCR_COVRF_Msk              (0x1UL << DCMIPP_P0FCR_COVRF_Pos)                /*!< 0x00000080 */
#define DCMIPP_P0FCR_COVRF                  DCMIPP_P0FCR_COVRF_Msk                          /*!< Overrun interrupt status clear */

/****************  Bit definition for DCMIPP_P0CFSCR register  ****************/
#define DCMIPP_P0CFSCR_DTIDA_Pos            (0UL)
#define DCMIPP_P0CFSCR_DTIDA_Msk            (0x3FUL << DCMIPP_P0CFSCR_DTIDA_Pos)             /*!< 0x0000003F */
#define DCMIPP_P0CFSCR_DTIDA                DCMIPP_P0CFSCR_DTIDA_Msk                        /*!< Current Data type selection ID A */
#define DCMIPP_P0CFSCR_DTIDB_Pos            (8UL)
#define DCMIPP_P0CFSCR_DTIDB_Msk            (0x3FUL << DCMIPP_P0CFSCR_DTIDB_Pos)             /*!< 0x00003F00 */
#define DCMIPP_P0CFSCR_DTIDB                DCMIPP_P0CFSCR_DTIDB_Msk                        /*!< Current Data type selection ID B */
#define DCMIPP_P0CFSCR_DTMODE_Pos           (16UL)
#define DCMIPP_P0CFSCR_DTMODE_Msk           (0x3UL << DCMIPP_P0CFSCR_DTMODE_Pos)             /*!< 0x00030000 */
#define DCMIPP_P0CFSCR_DTMODE               DCMIPP_P0CFSCR_DTMODE_Msk                       /*!< Flow selection mode */
#define DCMIPP_P0CFSCR_VC_Pos               (19UL)
#define DCMIPP_P0CFSCR_VC_Msk               (0x3UL << DCMIPP_P0CFSCR_VC_Pos)                 /*!< 0x00180000 */
#define DCMIPP_P0CFSCR_VC                   DCMIPP_P0CFSCR_VC_Msk                           /*!< Current flow selection mode */
#define DCMIPP_P0CFSCR_PIPEN_Pos            (31UL)
#define DCMIPP_P0CFSCR_PIPEN_Msk            (0x1UL << DCMIPP_P0CFSCR_PIPEN_Pos)              /*!< 0x80000000 */
#define DCMIPP_P0CFSCR_PIPEN                DCMIPP_P0CFSCR_PIPEN_Msk                        /*!< Current activation of PipeN */

/***************  Bit definition for DCMIPP_P0CFCTCR register  ****************/
#define DCMIPP_P0CFCTCR_FRATE_Pos           (0UL)
#define DCMIPP_P0CFCTCR_FRATE_Msk           (0x3UL << DCMIPP_P0CFCTCR_FRATE_Pos)             /*!< 0x00000003 */
#define DCMIPP_P0CFCTCR_FRATE               DCMIPP_P0CFCTCR_FRATE_Msk                       /*!< Frame capture rate control */
#define DCMIPP_P0CFCTCR_CPTMODE_Pos         (2UL)
#define DCMIPP_P0CFCTCR_CPTMODE_Msk         (0x1UL << DCMIPP_P0CFCTCR_CPTMODE_Pos)           /*!< 0x00000004 */
#define DCMIPP_P0CFCTCR_CPTMODE             DCMIPP_P0CFCTCR_CPTMODE_Msk                     /*!< Capture mode */
#define DCMIPP_P0CFCTCR_CPTREQ_Pos          (3UL)
#define DCMIPP_P0CFCTCR_CPTREQ_Msk          (0x1UL << DCMIPP_P0CFCTCR_CPTREQ_Pos)            /*!< 0x00000008 */
#define DCMIPP_P0CFCTCR_CPTREQ              DCMIPP_P0CFCTCR_CPTREQ_Msk                      /*!< Capture requested */

/***************  Bit definition for DCMIPP_P0CSCSTR register  ****************/
#define DCMIPP_P0CSCSTR_HSTART_Pos          (0UL)
#define DCMIPP_P0CSCSTR_HSTART_Msk          (0xFFFUL << DCMIPP_P0CSCSTR_HSTART_Pos)          /*!< 0x00000FFF */
#define DCMIPP_P0CSCSTR_HSTART              DCMIPP_P0CSCSTR_HSTART_Msk                      /*!< Current horizontal start, from 0 to 4094 words wide */
#define DCMIPP_P0CSCSTR_VSTART_Pos          (16UL)
#define DCMIPP_P0CSCSTR_VSTART_Msk          (0xFFFUL << DCMIPP_P0CSCSTR_VSTART_Pos)          /*!< 0x0FFF0000 */
#define DCMIPP_P0CSCSTR_VSTART              DCMIPP_P0CSCSTR_VSTART_Msk                      /*!< Current vertical start, from 0 to 4094 pixels high */

/***************  Bit definition for DCMIPP_P0CSCSZR register  ****************/
#define DCMIPP_P0CSCSZR_HSIZE_Pos           (0UL)
#define DCMIPP_P0CSCSZR_HSIZE_Msk           (0xFFFUL << DCMIPP_P0CSCSZR_HSIZE_Pos)           /*!< 0x00000FFF */
#define DCMIPP_P0CSCSZR_HSIZE               DCMIPP_P0CSCSZR_HSIZE_Msk                       /*!< Current horizontal size, from 0 to 4094 word wide (data 32-bit) */
#define DCMIPP_P0CSCSZR_VSIZE_Pos           (16UL)
#define DCMIPP_P0CSCSZR_VSIZE_Msk           (0xFFFUL << DCMIPP_P0CSCSZR_VSIZE_Pos)           /*!< 0x0FFF0000 */
#define DCMIPP_P0CSCSZR_VSIZE               DCMIPP_P0CSCSZR_VSIZE_Msk                       /*!< Current vertical size, from 0 to 4094 pixels high */
#define DCMIPP_P0CSCSZR_POSNEG_Pos          (30UL)
#define DCMIPP_P0CSCSZR_POSNEG_Msk          (0x1UL << DCMIPP_P0CSCSZR_POSNEG_Pos)            /*!< 0x40000000 */
#define DCMIPP_P0CSCSZR_POSNEG              DCMIPP_P0CSCSZR_POSNEG_Msk                      /*!< Current value of the POSNEG bit */
#define DCMIPP_P0CSCSZR_ENABLE_Pos          (31UL)
#define DCMIPP_P0CSCSZR_ENABLE_Msk          (0x1UL << DCMIPP_P0CSCSZR_ENABLE_Pos)            /*!< 0x80000000 */
#define DCMIPP_P0CSCSZR_ENABLE              DCMIPP_P0CSCSZR_ENABLE_Msk                      /*!< Current value of the ENABLE bit */

/****************  Bit definition for DCMIPP_P0CPPCR register  ****************/
#define DCMIPP_P0CPPCR_SWAPYUV_Pos          (0UL)
#define DCMIPP_P0CPPCR_SWAPYUV_Msk          (0x1UL << DCMIPP_P0CPPCR_SWAPYUV_Pos)            /*!< 0x00000001 */
#define DCMIPP_P0CPPCR_SWAPYUV              DCMIPP_P0CPPCR_SWAPYUV_Msk                      /*!< SwapY vs UV bits, when the YUV mode is active */
#define DCMIPP_P0CPPCR_PAD_Pos              (5UL)
#define DCMIPP_P0CPPCR_PAD_Msk              (0x1UL << DCMIPP_P0CPPCR_PAD_Pos)                /*!< 0x00000020 */
#define DCMIPP_P0CPPCR_PAD                  DCMIPP_P0CPPCR_PAD_Msk                          /*!< Current Pad mode for monochrome and raw Bayer 10/12/14 bpp: MSB vs */
#define DCMIPP_P0CPPCR_HEADEREN_Pos         (6UL)
#define DCMIPP_P0CPPCR_HEADEREN_Msk         (0x1UL << DCMIPP_P0CPPCR_HEADEREN_Pos)           /*!< 0x00000040 */
#define DCMIPP_P0CPPCR_HEADEREN             DCMIPP_P0CPPCR_HEADEREN_Msk                     /*!< Current CSI header dump enable */
#define DCMIPP_P0CPPCR_BSM_Pos              (7UL)
#define DCMIPP_P0CPPCR_BSM_Msk              (0x3UL << DCMIPP_P0CPPCR_BSM_Pos)                /*!< 0x00000180 */
#define DCMIPP_P0CPPCR_BSM                  DCMIPP_P0CPPCR_BSM_Msk                          /*!< Current Byte select mode */
#define DCMIPP_P0CPPCR_OEBS_Pos             (9UL)
#define DCMIPP_P0CPPCR_OEBS_Msk             (0x1UL << DCMIPP_P0CPPCR_OEBS_Pos)               /*!< 0x00000200 */
#define DCMIPP_P0CPPCR_OEBS                 DCMIPP_P0CPPCR_OEBS_Msk                         /*!< Current odd/even byte select (Byte select start) */
#define DCMIPP_P0CPPCR_LSM_Pos              (10UL)
#define DCMIPP_P0CPPCR_LSM_Msk              (0x1UL << DCMIPP_P0CPPCR_LSM_Pos)                /*!< 0x00000400 */
#define DCMIPP_P0CPPCR_LSM                  DCMIPP_P0CPPCR_LSM_Msk                          /*!< Current Line select mode */
#define DCMIPP_P0CPPCR_OELS_Pos             (11UL)
#define DCMIPP_P0CPPCR_OELS_Msk             (0x1UL << DCMIPP_P0CPPCR_OELS_Pos)               /*!< 0x00000800 */
#define DCMIPP_P0CPPCR_OELS                 DCMIPP_P0CPPCR_OELS_Msk                         /*!< Current odd/even line select (Line select start) */
#define DCMIPP_P0CPPCR_LINEMULT_Pos         (13UL)
#define DCMIPP_P0CPPCR_LINEMULT_Msk         (0x7UL << DCMIPP_P0CPPCR_LINEMULT_Pos)           /*!< 0x0000E000 */
#define DCMIPP_P0CPPCR_LINEMULT             DCMIPP_P0CPPCR_LINEMULT_Msk                     /*!< Current amount of capture completed lines for LINE Event and Interrupt */
#define DCMIPP_P0CPPCR_DBM_Pos              (16UL)
#define DCMIPP_P0CPPCR_DBM_Msk              (0x1UL << DCMIPP_P0CPPCR_LINEMULT_Pos)           /*!< 0x00010000 */
#define DCMIPP_P0CPPCR_DBM                  DCMIPP_P0CPPCR_LINEMULT_Msk                     /*!< Double buffer mode */

/**************  Bit definition for DCMIPP_P0CPPM0AR1 register  ***************/
#define DCMIPP_P0CPPM0AR1_M0A_Pos           (0UL)
#define DCMIPP_P0CPPM0AR1_M0A_Msk           (0xFFFFFFFFUL << DCMIPP_P0CPPM0AR1_M0A_Pos)      /*!< 0xFFFFFFFF */
#define DCMIPP_P0CPPM0AR1_M0A               DCMIPP_P0CPPM0AR1_M0A_Msk                       /*!< Memory0 address */

/****************  Bit definition for DCMIPP_P1FSCR register  *****************/
#define DCMIPP_P1FSCR_DTIDA_Pos             (0UL)
#define DCMIPP_P1FSCR_DTIDA_Msk             (0x3FUL << DCMIPP_P1FSCR_DTIDA_Pos)              /*!< 0x0000003F */
#define DCMIPP_P1FSCR_DTIDA                 DCMIPP_P1FSCR_DTIDA_Msk                         /*!< Data type ID A */
#define DCMIPP_P1FSCR_DTIDB_Pos             (8UL)
#define DCMIPP_P1FSCR_DTIDB_Msk             (0x3FUL << DCMIPP_P1FSCR_DTIDB_Pos)              /*!< 0x00003F00 */
#define DCMIPP_P1FSCR_DTIDB                 DCMIPP_P1FSCR_DTIDB_Msk                         /*!< Data type ID B */
#define DCMIPP_P1FSCR_DTMODE_Pos            (16UL)
#define DCMIPP_P1FSCR_DTMODE_Msk            (0x3UL << DCMIPP_P1FSCR_DTMODE_Pos)              /*!< 0x00030000 */
#define DCMIPP_P1FSCR_DTMODE                DCMIPP_P1FSCR_DTMODE_Msk                        /*!< Flow selection mode */
#define DCMIPP_P1FSCR_PIPEDIFF_Pos          (18UL)
#define DCMIPP_P1FSCR_PIPEDIFF_Msk          (0x1UL << DCMIPP_P1FSCR_PIPEDIFF_Pos)            /*!< 0x00040000 */
#define DCMIPP_P1FSCR_PIPEDIFF              DCMIPP_P1FSCR_PIPEDIFF_Msk                      /*!< Differentiates Pipe2 vs */
#define DCMIPP_P1FSCR_VC_Pos                (19UL)
#define DCMIPP_P1FSCR_VC_Msk                (0x3UL << DCMIPP_P1FSCR_VC_Pos)                  /*!< 0x00180000 */
#define DCMIPP_P1FSCR_VC                    DCMIPP_P1FSCR_VC_Msk                            /*!< Flow selection mode */
#define DCMIPP_P1FSCR_FDTF_Pos              (24UL)
#define DCMIPP_P1FSCR_FDTF_Msk              (0x3FUL << DCMIPP_P1FSCR_FDTF_Pos)               /*!< 0x3F000000 */
#define DCMIPP_P1FSCR_FDTF                  DCMIPP_P1FSCR_FDTF_Msk                          /*!< Force Data type format */
#define DCMIPP_P1FSCR_FDTFEN_Pos            (30UL)
#define DCMIPP_P1FSCR_FDTFEN_Msk            (0x1UL << DCMIPP_P1FSCR_FDTFEN_Pos)              /*!< 0x40000000 */
#define DCMIPP_P1FSCR_FDTFEN                DCMIPP_P1FSCR_FDTFEN_Msk                        /*!< Force Data type format enable */
#define DCMIPP_P1FSCR_PIPEN_Pos             (31UL)
#define DCMIPP_P1FSCR_PIPEN_Msk             (0x1UL << DCMIPP_P1FSCR_PIPEN_Pos)               /*!< 0x80000000 */
#define DCMIPP_P1FSCR_PIPEN                 DCMIPP_P1FSCR_PIPEN_Msk                         /*!< Activation of PipeN */

/****************  Bit definition for DCMIPP_P1SRCR register  *****************/
#define DCMIPP_P1SRCR_LASTLINE_Pos          (0UL)
#define DCMIPP_P1SRCR_LASTLINE_Msk          (0xFFFUL << DCMIPP_P1SRCR_LASTLINE_Pos)          /*!< 0x00000FFF */
#define DCMIPP_P1SRCR_LASTLINE              DCMIPP_P1SRCR_LASTLINE_Msk                      /*!< Number of the last line to be kept when CROPEN = 1 */
#define DCMIPP_P1SRCR_FIRSTLINEDEL_Pos      (12UL)
#define DCMIPP_P1SRCR_FIRSTLINEDEL_Msk      (0x7UL << DCMIPP_P1SRCR_FIRSTLINEDEL_Pos)        /*!< 0x00007000 */
#define DCMIPP_P1SRCR_FIRSTLINEDEL          DCMIPP_P1SRCR_FIRSTLINEDEL_Msk                  /*!< Number of lines to be deleted when CROPEN = 1 */
#define DCMIPP_P1SRCR_CROPEN_Pos            (15UL)
#define DCMIPP_P1SRCR_CROPEN_Msk            (0x1UL << DCMIPP_P1SRCR_CROPEN_Pos)              /*!< 0x00008000 */
#define DCMIPP_P1SRCR_CROPEN                DCMIPP_P1SRCR_CROPEN_Msk                        /*!< Crop line enable */

/****************  Bit definition for DCMIPP_P1BPRCR register  ****************/
#define DCMIPP_P1BPRCR_ENABLE_Pos           (0UL)
#define DCMIPP_P1BPRCR_ENABLE_Msk           (0x1UL << DCMIPP_P1BPRCR_ENABLE_Pos)             /*!< 0x00000001 */
#define DCMIPP_P1BPRCR_ENABLE               DCMIPP_P1BPRCR_ENABLE_Msk                       /*!< Bad pixel detection must be enabled only for raw Bayer flows, as it corrupts RGB flows */
#define DCMIPP_P1BPRCR_STRENGTH_Pos         (1UL)
#define DCMIPP_P1BPRCR_STRENGTH_Msk         (0x7UL << DCMIPP_P1BPRCR_STRENGTH_Pos)           /*!< 0x0000000E */
#define DCMIPP_P1BPRCR_STRENGTH             DCMIPP_P1BPRCR_STRENGTH_Msk                     /*!< Strength (aggressivity) of the bad pixel detection: */

/****************  Bit definition for DCMIPP_P1BPRSR register  ****************/
#define DCMIPP_P1BPRSR_BADCNT_Pos           (0UL)
#define DCMIPP_P1BPRSR_BADCNT_Msk           (0xFFFUL << DCMIPP_P1BPRSR_BADCNT_Pos)           /*!< 0x00000FFF */
#define DCMIPP_P1BPRSR_BADCNT               DCMIPP_P1BPRSR_BADCNT_Msk                       /*!< Amount of detected bad pixels */

/****************  Bit definition for DCMIPP_P1DECR register  *****************/
#define DCMIPP_P1DECR_ENABLE_Pos            (0UL)
#define DCMIPP_P1DECR_ENABLE_Msk            (0x1UL << DCMIPP_P1DECR_ENABLE_Pos)              /*!< 0x00000001 */
#define DCMIPP_P1DECR_ENABLE                DCMIPP_P1DECR_ENABLE_Msk                        /*!<  */
#define DCMIPP_P1DECR_HDEC_Pos              (1UL)
#define DCMIPP_P1DECR_HDEC_Msk              (0x3UL << DCMIPP_P1DECR_HDEC_Pos)                /*!< 0x00000006 */
#define DCMIPP_P1DECR_HDEC                  DCMIPP_P1DECR_HDEC_Msk                          /*!< Horizontal decimation ratio */
#define DCMIPP_P1DECR_VDEC_Pos              (3UL)
#define DCMIPP_P1DECR_VDEC_Msk              (0x3UL << DCMIPP_P1DECR_VDEC_Pos)                /*!< 0x00000018 */
#define DCMIPP_P1DECR_VDEC                  DCMIPP_P1DECR_VDEC_Msk                          /*!< Vertical decimation ratio */

/****************  Bit definition for DCMIPP_P1BLCCR register  ****************/
#define DCMIPP_P1BLCCR_ENABLE_Pos           (0UL)
#define DCMIPP_P1BLCCR_ENABLE_Msk           (0x1UL << DCMIPP_P1BLCCR_ENABLE_Pos)             /*!< 0x00000001 */
#define DCMIPP_P1BLCCR_ENABLE               DCMIPP_P1BLCCR_ENABLE_Msk                       /*!< Black level calibration */
#define DCMIPP_P1BLCCR_BLCB_Pos             (8UL)
#define DCMIPP_P1BLCCR_BLCB_Msk             (0xFFUL << DCMIPP_P1BLCCR_BLCB_Pos)              /*!< 0x0000FF00 */
#define DCMIPP_P1BLCCR_BLCB                 DCMIPP_P1BLCCR_BLCB_Msk                         /*!< Black level calibration - Blue */
#define DCMIPP_P1BLCCR_BLCG_Pos             (16UL)
#define DCMIPP_P1BLCCR_BLCG_Msk             (0xFFUL << DCMIPP_P1BLCCR_BLCG_Pos)              /*!< 0x00FF0000 */
#define DCMIPP_P1BLCCR_BLCG                 DCMIPP_P1BLCCR_BLCG_Msk                         /*!< Black level calibration - Green */
#define DCMIPP_P1BLCCR_BLCR_Pos             (24UL)
#define DCMIPP_P1BLCCR_BLCR_Msk             (0xFFUL << DCMIPP_P1BLCCR_BLCR_Pos)              /*!< 0xFF000000 */
#define DCMIPP_P1BLCCR_BLCR                 DCMIPP_P1BLCCR_BLCR_Msk                         /*!< Black level calibration - Red */

/****************  Bit definition for DCMIPP_P1EXCR1 register  ****************/
#define DCMIPP_P1EXCR1_ENABLE_Pos           (0UL)
#define DCMIPP_P1EXCR1_ENABLE_Msk           (0x1UL << DCMIPP_P1EXCR1_ENABLE_Pos)             /*!< 0x00000001 */
#define DCMIPP_P1EXCR1_ENABLE               DCMIPP_P1EXCR1_ENABLE_Msk                       /*!< Exposure control (multiplication and shift) of all red, green and blue */
#define DCMIPP_P1EXCR1_MULTR_Pos            (20UL)
#define DCMIPP_P1EXCR1_MULTR_Msk            (0xFFUL << DCMIPP_P1EXCR1_MULTR_Pos)             /*!< 0x0FF00000 */
#define DCMIPP_P1EXCR1_MULTR                DCMIPP_P1EXCR1_MULTR_Msk                        /*!< Exposure multiplier - Red */
#define DCMIPP_P1EXCR1_SHFR_Pos             (28UL)
#define DCMIPP_P1EXCR1_SHFR_Msk             (0x7UL << DCMIPP_P1EXCR1_SHFR_Pos)               /*!< 0x70000000 */
#define DCMIPP_P1EXCR1_SHFR                 DCMIPP_P1EXCR1_SHFR_Msk                         /*!< Exposure shift - Red */

/****************  Bit definition for DCMIPP_P1EXCR2 register  ****************/
#define DCMIPP_P1EXCR2_MULTB_Pos            (4UL)
#define DCMIPP_P1EXCR2_MULTB_Msk            (0xFFUL << DCMIPP_P1EXCR2_MULTB_Pos)             /*!< 0x00000FF0 */
#define DCMIPP_P1EXCR2_MULTB                DCMIPP_P1EXCR2_MULTB_Msk                        /*!< Exposure multiplier - Blue */
#define DCMIPP_P1EXCR2_SHFB_Pos             (12UL)
#define DCMIPP_P1EXCR2_SHFB_Msk             (0x7UL << DCMIPP_P1EXCR2_SHFB_Pos)               /*!< 0x00007000 */
#define DCMIPP_P1EXCR2_SHFB                 DCMIPP_P1EXCR2_SHFB_Msk                         /*!< Exposure shift - Blue */
#define DCMIPP_P1EXCR2_MULTG_Pos            (20UL)
#define DCMIPP_P1EXCR2_MULTG_Msk            (0xFFUL << DCMIPP_P1EXCR2_MULTG_Pos)             /*!< 0x0FF00000 */
#define DCMIPP_P1EXCR2_MULTG                DCMIPP_P1EXCR2_MULTG_Msk                        /*!< Exposure multiplier - Green */
#define DCMIPP_P1EXCR2_SHFG_Pos             (28UL)
#define DCMIPP_P1EXCR2_SHFG_Msk             (0x7UL << DCMIPP_P1EXCR2_SHFG_Pos)               /*!< 0x70000000 */
#define DCMIPP_P1EXCR2_SHFG                 DCMIPP_P1EXCR2_SHFG_Msk                         /*!< Exposure shift - Green */

/****************  Bit definition for DCMIPP_P1ST1CR register  ****************/
#define DCMIPP_P1ST1CR_ENABLE_Pos           (0UL)
#define DCMIPP_P1ST1CR_ENABLE_Msk           (0x1UL << DCMIPP_P1ST1CR_ENABLE_Pos)             /*!< 0x00000001 */
#define DCMIPP_P1ST1CR_ENABLE               DCMIPP_P1ST1CR_ENABLE_Msk                       /*!<  */
#define DCMIPP_P1ST1CR_BINS_Pos             (2UL)
#define DCMIPP_P1ST1CR_BINS_Msk             (0x3UL << DCMIPP_P1ST1CR_BINS_Pos)               /*!< 0x0000000C */
#define DCMIPP_P1ST1CR_BINS                 DCMIPP_P1ST1CR_BINS_Msk                         /*!< Bin definition */
#define DCMIPP_P1ST1CR_SRC_Pos              (4UL)
#define DCMIPP_P1ST1CR_SRC_Msk              (0x7UL << DCMIPP_P1ST1CR_SRC_Pos)                /*!< 0x00000070 */
#define DCMIPP_P1ST1CR_SRC                  DCMIPP_P1ST1CR_SRC_Msk                          /*!< Statistics source */
#define DCMIPP_P1ST1CR_MODE_Pos             (7UL)
#define DCMIPP_P1ST1CR_MODE_Msk             (0x1UL << DCMIPP_P1ST1CR_MODE_Pos)               /*!< 0x00000080 */
#define DCMIPP_P1ST1CR_MODE                 DCMIPP_P1ST1CR_MODE_Msk                         /*!< Statistics mode */

/****************  Bit definition for DCMIPP_P1ST2CR register  ****************/
#define DCMIPP_P1ST2CR_ENABLE_Pos           (0UL)
#define DCMIPP_P1ST2CR_ENABLE_Msk           (0x1UL << DCMIPP_P1ST2CR_ENABLE_Pos)             /*!< 0x00000001 */
#define DCMIPP_P1ST2CR_ENABLE               DCMIPP_P1ST2CR_ENABLE_Msk                       /*!<  */
#define DCMIPP_P1ST2CR_BINS_Pos             (2UL)
#define DCMIPP_P1ST2CR_BINS_Msk             (0x3UL << DCMIPP_P1ST2CR_BINS_Pos)               /*!< 0x0000000C */
#define DCMIPP_P1ST2CR_BINS                 DCMIPP_P1ST2CR_BINS_Msk                         /*!< Bin definition */
#define DCMIPP_P1ST2CR_SRC_Pos              (4UL)
#define DCMIPP_P1ST2CR_SRC_Msk              (0x7UL << DCMIPP_P1ST2CR_SRC_Pos)                /*!< 0x00000070 */
#define DCMIPP_P1ST2CR_SRC                  DCMIPP_P1ST2CR_SRC_Msk                          /*!< Statistics source */
#define DCMIPP_P1ST2CR_MODE_Pos             (7UL)
#define DCMIPP_P1ST2CR_MODE_Msk             (0x1UL << DCMIPP_P1ST2CR_MODE_Pos)               /*!< 0x00000080 */
#define DCMIPP_P1ST2CR_MODE                 DCMIPP_P1ST2CR_MODE_Msk                         /*!< Statistics mode */

/****************  Bit definition for DCMIPP_P1ST3CR register  ****************/
#define DCMIPP_P1ST3CR_ENABLE_Pos           (0UL)
#define DCMIPP_P1ST3CR_ENABLE_Msk           (0x1UL << DCMIPP_P1ST3CR_ENABLE_Pos)             /*!< 0x00000001 */
#define DCMIPP_P1ST3CR_ENABLE               DCMIPP_P1ST3CR_ENABLE_Msk                       /*!<  */
#define DCMIPP_P1ST3CR_BINS_Pos             (2UL)
#define DCMIPP_P1ST3CR_BINS_Msk             (0x3UL << DCMIPP_P1ST3CR_BINS_Pos)               /*!< 0x0000000C */
#define DCMIPP_P1ST3CR_BINS                 DCMIPP_P1ST3CR_BINS_Msk                         /*!< Bin definition */
#define DCMIPP_P1ST3CR_SRC_Pos              (4UL)
#define DCMIPP_P1ST3CR_SRC_Msk              (0x7UL << DCMIPP_P1ST3CR_SRC_Pos)                /*!< 0x00000070 */
#define DCMIPP_P1ST3CR_SRC                  DCMIPP_P1ST3CR_SRC_Msk                          /*!< Statistics source */
#define DCMIPP_P1ST3CR_MODE_Pos             (7UL)
#define DCMIPP_P1ST3CR_MODE_Msk             (0x1UL << DCMIPP_P1ST3CR_MODE_Pos)               /*!< 0x00000080 */
#define DCMIPP_P1ST3CR_MODE                 DCMIPP_P1ST3CR_MODE_Msk                         /*!< Statistics mode */

/****************  Bit definition for DCMIPP_P1STSTR register  ****************/
#define DCMIPP_P1STSTR_HSTART_Pos           (0UL)
#define DCMIPP_P1STSTR_HSTART_Msk           (0xFFFUL << DCMIPP_P1STSTR_HSTART_Pos)           /*!< 0x00000FFF */
#define DCMIPP_P1STSTR_HSTART               DCMIPP_P1STSTR_HSTART_Msk                       /*!< Horizontal start, from 0 to 4094 pixels wide */
#define DCMIPP_P1STSTR_VSTART_Pos           (16UL)
#define DCMIPP_P1STSTR_VSTART_Msk           (0xFFFUL << DCMIPP_P1STSTR_VSTART_Pos)           /*!< 0x0FFF0000 */
#define DCMIPP_P1STSTR_VSTART               DCMIPP_P1STSTR_VSTART_Msk                       /*!< Vertical start, from 0 to 4094 pixels high */

/****************  Bit definition for DCMIPP_P1STSZR register  ****************/
#define DCMIPP_P1STSZR_HSIZE_Pos            (0UL)
#define DCMIPP_P1STSZR_HSIZE_Msk            (0xFFFUL << DCMIPP_P1STSZR_HSIZE_Pos)            /*!< 0x00000FFF */
#define DCMIPP_P1STSZR_HSIZE                DCMIPP_P1STSZR_HSIZE_Msk                        /*!< Horizontal size, from 0 to 4094 pixels wide */
#define DCMIPP_P1STSZR_VSIZE_Pos            (16UL)
#define DCMIPP_P1STSZR_VSIZE_Msk            (0xFFFUL << DCMIPP_P1STSZR_VSIZE_Pos)            /*!< 0x0FFF0000 */
#define DCMIPP_P1STSZR_VSIZE                DCMIPP_P1STSZR_VSIZE_Msk                        /*!< Vertical size, from 0 to 4094 pixels high */
#define DCMIPP_P1STSZR_CROPEN_Pos           (31UL)
#define DCMIPP_P1STSZR_CROPEN_Msk           (0x1UL << DCMIPP_P1STSZR_CROPEN_Pos)             /*!< 0x80000000 */
#define DCMIPP_P1STSZR_CROPEN               DCMIPP_P1STSZR_CROPEN_Msk                       /*!<  */

/****************  Bit definition for DCMIPP_P1ST1SR register  ****************/
#define DCMIPP_P1ST1SR_ACCU_Pos             (0UL)
#define DCMIPP_P1ST1SR_ACCU_Msk             (0xFFFFFFUL << DCMIPP_P1ST1SR_ACCU_Pos)          /*!< 0x00FFFFFF */
#define DCMIPP_P1ST1SR_ACCU                 DCMIPP_P1ST1SR_ACCU_Msk                         /*!< Accumulation result, divided by 256 */

/****************  Bit definition for DCMIPP_P1ST2SR register  ****************/
#define DCMIPP_P1ST2SR_ACCU_Pos             (0UL)
#define DCMIPP_P1ST2SR_ACCU_Msk             (0xFFFFFFUL << DCMIPP_P1ST2SR_ACCU_Pos)          /*!< 0x00FFFFFF */
#define DCMIPP_P1ST2SR_ACCU                 DCMIPP_P1ST2SR_ACCU_Msk                         /*!< accumulation result, divided by 256 */

/****************  Bit definition for DCMIPP_P1ST3SR register  ****************/
#define DCMIPP_P1ST3SR_ACCU_Pos             (0UL)
#define DCMIPP_P1ST3SR_ACCU_Msk             (0xFFFFFFUL << DCMIPP_P1ST3SR_ACCU_Pos)          /*!< 0x00FFFFFF */
#define DCMIPP_P1ST3SR_ACCU                 DCMIPP_P1ST3SR_ACCU_Msk                         /*!< accumulation result, divided by 256 */

/****************  Bit definition for DCMIPP_P1DMCR register  *****************/
#define DCMIPP_P1DMCR_ENABLE_Pos            (0UL)
#define DCMIPP_P1DMCR_ENABLE_Msk            (0x1UL << DCMIPP_P1DMCR_ENABLE_Pos)              /*!< 0x00000001 */
#define DCMIPP_P1DMCR_ENABLE                DCMIPP_P1DMCR_ENABLE_Msk                        /*!<  */
#define DCMIPP_P1DMCR_TYPE_Pos              (1UL)
#define DCMIPP_P1DMCR_TYPE_Msk              (0x3UL << DCMIPP_P1DMCR_TYPE_Pos)                /*!< 0x00000006 */
#define DCMIPP_P1DMCR_TYPE                  DCMIPP_P1DMCR_TYPE_Msk                          /*!< Raw Bayer type */
#define DCMIPP_P1DMCR_PEAK_Pos              (16UL)
#define DCMIPP_P1DMCR_PEAK_Msk              (0x7UL << DCMIPP_P1DMCR_PEAK_Pos)                /*!< 0x00070000 */
#define DCMIPP_P1DMCR_PEAK                  DCMIPP_P1DMCR_PEAK_Msk                          /*!< Strength of the peak detection */
#define DCMIPP_P1DMCR_LINEV_Pos             (20UL)
#define DCMIPP_P1DMCR_LINEV_Msk             (0x7UL << DCMIPP_P1DMCR_LINEV_Pos)               /*!< 0x00700000 */
#define DCMIPP_P1DMCR_LINEV                 DCMIPP_P1DMCR_LINEV_Msk                         /*!< Strength of the vertical line detection */
#define DCMIPP_P1DMCR_LINEH_Pos             (24UL)
#define DCMIPP_P1DMCR_LINEH_Msk             (0x7UL << DCMIPP_P1DMCR_LINEH_Pos)               /*!< 0x07000000 */
#define DCMIPP_P1DMCR_LINEH                 DCMIPP_P1DMCR_LINEH_Msk                         /*!< Strength of the horizontal line detection */
#define DCMIPP_P1DMCR_EDGE_Pos              (28UL)
#define DCMIPP_P1DMCR_EDGE_Msk              (0x7UL << DCMIPP_P1DMCR_EDGE_Pos)                /*!< 0x70000000 */
#define DCMIPP_P1DMCR_EDGE                  DCMIPP_P1DMCR_EDGE_Msk                          /*!< Strength of the edge detection */

/****************  Bit definition for DCMIPP_P1CCCR register  *****************/
#define DCMIPP_P1CCCR_ENABLE_Pos            (0UL)
#define DCMIPP_P1CCCR_ENABLE_Msk            (0x1UL << DCMIPP_P1CCCR_ENABLE_Pos)              /*!< 0x00000001 */
#define DCMIPP_P1CCCR_ENABLE                DCMIPP_P1CCCR_ENABLE_Msk                        /*!<  */
#define DCMIPP_P1CCCR_TYPE_Pos              (1UL)
#define DCMIPP_P1CCCR_TYPE_Msk              (0x1UL << DCMIPP_P1CCCR_TYPE_Pos)                /*!< 0x00000002 */
#define DCMIPP_P1CCCR_TYPE                  DCMIPP_P1CCCR_TYPE_Msk                          /*!< output samples type used while CLAMP is activated */
#define DCMIPP_P1CCCR_CLAMP_Pos             (2UL)
#define DCMIPP_P1CCCR_CLAMP_Msk             (0x1UL << DCMIPP_P1CCCR_CLAMP_Pos)               /*!< 0x00000004 */
#define DCMIPP_P1CCCR_CLAMP                 DCMIPP_P1CCCR_CLAMP_Msk                         /*!< Clamp the output samples */

/****************  Bit definition for DCMIPP_P1CCRR1 register  ****************/
#define DCMIPP_P1CCRR1_RR_Pos               (0UL)
#define DCMIPP_P1CCRR1_RR_Msk               (0x7FFUL << DCMIPP_P1CCRR1_RR_Pos)               /*!< 0x000007FF */
#define DCMIPP_P1CCRR1_RR                   DCMIPP_P1CCRR1_RR_Msk                           /*!< Coefficient row 1 column 1 of the matrix */
#define DCMIPP_P1CCRR1_RG_Pos               (16UL)
#define DCMIPP_P1CCRR1_RG_Msk               (0x7FFUL << DCMIPP_P1CCRR1_RG_Pos)               /*!< 0x07FF0000 */
#define DCMIPP_P1CCRR1_RG                   DCMIPP_P1CCRR1_RG_Msk                           /*!< Coefficient row 1 column 2 of the matrix */

/****************  Bit definition for DCMIPP_P1CCRR2 register  ****************/
#define DCMIPP_P1CCRR2_RB_Pos               (0UL)
#define DCMIPP_P1CCRR2_RB_Msk               (0x7FFUL << DCMIPP_P1CCRR2_RB_Pos)               /*!< 0x000007FF */
#define DCMIPP_P1CCRR2_RB                   DCMIPP_P1CCRR2_RB_Msk                           /*!< Coefficient row 1 column 3 of the matrix */
#define DCMIPP_P1CCRR2_RA_Pos               (16UL)
#define DCMIPP_P1CCRR2_RA_Msk               (0x3FFUL << DCMIPP_P1CCRR2_RA_Pos)               /*!< 0x03FF0000 */
#define DCMIPP_P1CCRR2_RA                   DCMIPP_P1CCRR2_RA_Msk                           /*!< Coefficient row 1 of the added column (signed integer value) */

/****************  Bit definition for DCMIPP_P1CCGR1 register  ****************/
#define DCMIPP_P1CCGR1_GR_Pos               (0UL)
#define DCMIPP_P1CCGR1_GR_Msk               (0x7FFUL << DCMIPP_P1CCGR1_GR_Pos)               /*!< 0x000007FF */
#define DCMIPP_P1CCGR1_GR                   DCMIPP_P1CCGR1_GR_Msk                           /*!< Coefficient row 2 column 1 of the matrix */
#define DCMIPP_P1CCGR1_GG_Pos               (16UL)
#define DCMIPP_P1CCGR1_GG_Msk               (0x7FFUL << DCMIPP_P1CCGR1_GG_Pos)               /*!< 0x07FF0000 */
#define DCMIPP_P1CCGR1_GG                   DCMIPP_P1CCGR1_GG_Msk                           /*!< Coefficient row 2 column 2 of the matrix */

/****************  Bit definition for DCMIPP_P1CCGR2 register  ****************/
#define DCMIPP_P1CCGR2_GB_Pos               (0UL)
#define DCMIPP_P1CCGR2_GB_Msk               (0x7FFUL << DCMIPP_P1CCGR2_GB_Pos)               /*!< 0x000007FF */
#define DCMIPP_P1CCGR2_GB                   DCMIPP_P1CCGR2_GB_Msk                           /*!< Coefficient row 2 column 3 of the matrix */
#define DCMIPP_P1CCGR2_GA_Pos               (16UL)
#define DCMIPP_P1CCGR2_GA_Msk               (0x3FFUL << DCMIPP_P1CCGR2_GA_Pos)               /*!< 0x03FF0000 */
#define DCMIPP_P1CCGR2_GA                   DCMIPP_P1CCGR2_GA_Msk                           /*!< Coefficient row 2 of the added column (signed integer value) */

/****************  Bit definition for DCMIPP_P1CCBR1 register  ****************/
#define DCMIPP_P1CCBR1_BR_Pos               (0UL)
#define DCMIPP_P1CCBR1_BR_Msk               (0x7FFUL << DCMIPP_P1CCBR1_BR_Pos)               /*!< 0x000007FF */
#define DCMIPP_P1CCBR1_BR                   DCMIPP_P1CCBR1_BR_Msk                           /*!< Coefficient row 3 column 1 of the matrix */
#define DCMIPP_P1CCBR1_BG_Pos               (16UL)
#define DCMIPP_P1CCBR1_BG_Msk               (0x7FFUL << DCMIPP_P1CCBR1_BG_Pos)               /*!< 0x07FF0000 */
#define DCMIPP_P1CCBR1_BG                   DCMIPP_P1CCBR1_BG_Msk                           /*!< Coefficient row 3 column 2 of the matrix */

/****************  Bit definition for DCMIPP_P1CCBR2 register  ****************/
#define DCMIPP_P1CCBR2_BB_Pos               (0UL)
#define DCMIPP_P1CCBR2_BB_Msk               (0x7FFUL << DCMIPP_P1CCBR2_BB_Pos)               /*!< 0x000007FF */
#define DCMIPP_P1CCBR2_BB                   DCMIPP_P1CCBR2_BB_Msk                           /*!< Coefficient row 3 column 3 of the matrix */
#define DCMIPP_P1CCBR2_BA_Pos               (16UL)
#define DCMIPP_P1CCBR2_BA_Msk               (0x3FFUL << DCMIPP_P1CCBR2_BA_Pos)               /*!< 0x03FF0000 */
#define DCMIPP_P1CCBR2_BA                   DCMIPP_P1CCBR2_BA_Msk                           /*!< Coefficient row 3 of the added column (signed integer value) */

/****************  Bit definition for DCMIPP_P1CTCR1 register  ****************/
#define DCMIPP_P1CTCR1_ENABLE_Pos           (0UL)
#define DCMIPP_P1CTCR1_ENABLE_Msk           (0x1UL << DCMIPP_P1CTCR1_ENABLE_Pos)             /*!< 0x00000001 */
#define DCMIPP_P1CTCR1_ENABLE               DCMIPP_P1CTCR1_ENABLE_Msk                       /*!<  */
#define DCMIPP_P1CTCR1_LUM0_Pos             (9UL)
#define DCMIPP_P1CTCR1_LUM0_Msk             (0x3FUL << DCMIPP_P1CTCR1_LUM0_Pos)              /*!< 0x00007E00 */
#define DCMIPP_P1CTCR1_LUM0                 DCMIPP_P1CTCR1_LUM0_Msk                         /*!< Luminance increase for input luminance of 0 (increase is idle with LUMx = 16) */

/****************  Bit definition for DCMIPP_P1CTCR2 register  ****************/
#define DCMIPP_P1CTCR2_LUM4_Pos             (1UL)
#define DCMIPP_P1CTCR2_LUM4_Msk             (0x3FUL << DCMIPP_P1CTCR2_LUM4_Pos)              /*!< 0x0000007E */
#define DCMIPP_P1CTCR2_LUM4                 DCMIPP_P1CTCR2_LUM4_Msk                         /*!< Luminance increase for input luminance of 128 (increase is idle with LUMx = 16) */
#define DCMIPP_P1CTCR2_LUM3_Pos             (9UL)
#define DCMIPP_P1CTCR2_LUM3_Msk             (0x3FUL << DCMIPP_P1CTCR2_LUM3_Pos)              /*!< 0x00007E00 */
#define DCMIPP_P1CTCR2_LUM3                 DCMIPP_P1CTCR2_LUM3_Msk                         /*!< Luminance increase for input luminance of 96 (increase is idle with LUMx = 16) */
#define DCMIPP_P1CTCR2_LUM2_Pos             (17UL)
#define DCMIPP_P1CTCR2_LUM2_Msk             (0x3FUL << DCMIPP_P1CTCR2_LUM2_Pos)              /*!< 0x007E0000 */
#define DCMIPP_P1CTCR2_LUM2                 DCMIPP_P1CTCR2_LUM2_Msk                         /*!< Luminance increase for input luminance of 64 (increase is idle with LUMx = 16) */
#define DCMIPP_P1CTCR2_LUM1_Pos             (25UL)
#define DCMIPP_P1CTCR2_LUM1_Msk             (0x3FUL << DCMIPP_P1CTCR2_LUM1_Pos)              /*!< 0x7E000000 */
#define DCMIPP_P1CTCR2_LUM1                 DCMIPP_P1CTCR2_LUM1_Msk                         /*!< Luminance increase for input luminance of 32 (increase is idle with LUMx = 16) */

/****************  Bit definition for DCMIPP_P1CTCR3 register  ****************/
#define DCMIPP_P1CTCR3_LUM8_Pos             (1UL)
#define DCMIPP_P1CTCR3_LUM8_Msk             (0x3FUL << DCMIPP_P1CTCR3_LUM8_Pos)              /*!< 0x0000007E */
#define DCMIPP_P1CTCR3_LUM8                 DCMIPP_P1CTCR3_LUM8_Msk                         /*!< Luminance increase for input luminance of 256 (increase is idle with LUMx = 16) */
#define DCMIPP_P1CTCR3_LUM7_Pos             (9UL)
#define DCMIPP_P1CTCR3_LUM7_Msk             (0x3FUL << DCMIPP_P1CTCR3_LUM7_Pos)              /*!< 0x00007E00 */
#define DCMIPP_P1CTCR3_LUM7                 DCMIPP_P1CTCR3_LUM7_Msk                         /*!< Luminance increase for input luminance of 224 (increase is idle with LUMx = 16) */
#define DCMIPP_P1CTCR3_LUM6_Pos             (17UL)
#define DCMIPP_P1CTCR3_LUM6_Msk             (0x3FUL << DCMIPP_P1CTCR3_LUM6_Pos)              /*!< 0x007E0000 */
#define DCMIPP_P1CTCR3_LUM6                 DCMIPP_P1CTCR3_LUM6_Msk                         /*!< Luminance increase for input luminance of 192 (increase is idle with LUMx = 16) */
#define DCMIPP_P1CTCR3_LUM5_Pos             (25UL)
#define DCMIPP_P1CTCR3_LUM5_Msk             (0x3FUL << DCMIPP_P1CTCR3_LUM5_Pos)              /*!< 0x7E000000 */
#define DCMIPP_P1CTCR3_LUM5                 DCMIPP_P1CTCR3_LUM5_Msk                         /*!< Luminance increase for input luminance of 160 (increase is idle with LUMx = 16) */

/****************  Bit definition for DCMIPP_P1FCTCR register  ****************/
#define DCMIPP_P1FCTCR_FRATE_Pos            (0UL)
#define DCMIPP_P1FCTCR_FRATE_Msk            (0x3UL << DCMIPP_P1FCTCR_FRATE_Pos)              /*!< 0x00000003 */
#define DCMIPP_P1FCTCR_FRATE                DCMIPP_P1FCTCR_FRATE_Msk                        /*!< Frame capture rate control */
#define DCMIPP_P1FCTCR_CPTMODE_Pos          (2UL)
#define DCMIPP_P1FCTCR_CPTMODE_Msk          (0x1UL << DCMIPP_P1FCTCR_CPTMODE_Pos)            /*!< 0x00000004 */
#define DCMIPP_P1FCTCR_CPTMODE              DCMIPP_P1FCTCR_CPTMODE_Msk                      /*!< Capture mode */
#define DCMIPP_P1FCTCR_CPTREQ_Pos           (3UL)
#define DCMIPP_P1FCTCR_CPTREQ_Msk           (0x1UL << DCMIPP_P1FCTCR_CPTREQ_Pos)             /*!< 0x00000008 */
#define DCMIPP_P1FCTCR_CPTREQ               DCMIPP_P1FCTCR_CPTREQ_Msk                       /*!< Capture requested */

/****************  Bit definition for DCMIPP_P1CRSTR register  ****************/
#define DCMIPP_P1CRSTR_HSTART_Pos           (0UL)
#define DCMIPP_P1CRSTR_HSTART_Msk           (0xFFFUL << DCMIPP_P1CRSTR_HSTART_Pos)           /*!< 0x00000FFF */
#define DCMIPP_P1CRSTR_HSTART               DCMIPP_P1CRSTR_HSTART_Msk                       /*!< Horizontal start, from 0 to 4094 pixels wide */
#define DCMIPP_P1CRSTR_VSTART_Pos           (16UL)
#define DCMIPP_P1CRSTR_VSTART_Msk           (0xFFFUL << DCMIPP_P1CRSTR_VSTART_Pos)           /*!< 0x0FFF0000 */
#define DCMIPP_P1CRSTR_VSTART               DCMIPP_P1CRSTR_VSTART_Msk                       /*!< Vertical start, from 0 to 4094 pixels high */

/****************  Bit definition for DCMIPP_P1CRSZR register  ****************/
#define DCMIPP_P1CRSZR_HSIZE_Pos            (0UL)
#define DCMIPP_P1CRSZR_HSIZE_Msk            (0xFFFUL << DCMIPP_P1CRSZR_HSIZE_Pos)            /*!< 0x00000FFF */
#define DCMIPP_P1CRSZR_HSIZE                DCMIPP_P1CRSZR_HSIZE_Msk                        /*!< Horizontal size, from 0 to 4094 pixels wide */
#define DCMIPP_P1CRSZR_VSIZE_Pos            (16UL)
#define DCMIPP_P1CRSZR_VSIZE_Msk            (0xFFFUL << DCMIPP_P1CRSZR_VSIZE_Pos)            /*!< 0x0FFF0000 */
#define DCMIPP_P1CRSZR_VSIZE                DCMIPP_P1CRSZR_VSIZE_Msk                        /*!< Vertical size, from 0 to 4094 pixels high */
#define DCMIPP_P1CRSZR_ENABLE_Pos           (31UL)
#define DCMIPP_P1CRSZR_ENABLE_Msk           (0x1UL << DCMIPP_P1CRSZR_ENABLE_Pos)             /*!< 0x80000000 */
#define DCMIPP_P1CRSZR_ENABLE               DCMIPP_P1CRSZR_ENABLE_Msk                       /*!<  */

/****************  Bit definition for DCMIPP_P1DCCR register  *****************/
#define DCMIPP_P1DCCR_ENABLE_Pos            (0UL)
#define DCMIPP_P1DCCR_ENABLE_Msk            (0x1UL << DCMIPP_P1DCCR_ENABLE_Pos)             /*!< 0x00000001 */
#define DCMIPP_P1DCCR_ENABLE                DCMIPP_P1DCCR_ENABLE_Msk                        /*!< Decimation enable */
#define DCMIPP_P1DCCR_HDEC_Pos              (1UL)
#define DCMIPP_P1DCCR_HDEC_Msk              (0x3UL << DCMIPP_P1DCCR_HDEC_Pos)               /*!< 0x00000006 */
#define DCMIPP_P1DCCR_HDEC                  DCMIPP_P1DCCR_HDEC_Msk                          /*!< Horizontal decimation ratio */
#define DCMIPP_P1DCCR_VDEC_Pos              (3UL)
#define DCMIPP_P1DCCR_VDEC_Msk              (0x3UL << DCMIPP_P1DCCR_VDEC_Pos)               /*!< 0x00000018 */
#define DCMIPP_P1DCCR_VDEC                  DCMIPP_P1DCCR_VDEC_Msk                          /*!< Vertical decimation ratio */

/****************  Bit definition for DCMIPP_P1DSCR register  *****************/
#define DCMIPP_P1DSCR_HDIV_Pos              (0UL)
#define DCMIPP_P1DSCR_HDIV_Msk              (0x3FFUL << DCMIPP_P1DSCR_HDIV_Pos)              /*!< 0x000003FF */
#define DCMIPP_P1DSCR_HDIV                  DCMIPP_P1DSCR_HDIV_Msk                          /*!< Horizontal division factor, from 128 (8x) to 1023 (1x) */
#define DCMIPP_P1DSCR_VDIV_Pos              (16UL)
#define DCMIPP_P1DSCR_VDIV_Msk              (0x3FFUL << DCMIPP_P1DSCR_VDIV_Pos)              /*!< 0x03FF0000 */
#define DCMIPP_P1DSCR_VDIV                  DCMIPP_P1DSCR_VDIV_Msk                          /*!< Vertical division factor, from 128 (8x) to 1023 (1x) */
#define DCMIPP_P1DSCR_ENABLE_Pos            (31UL)
#define DCMIPP_P1DSCR_ENABLE_Msk            (0x1UL << DCMIPP_P1DSCR_ENABLE_Pos)              /*!< 0x80000000 */
#define DCMIPP_P1DSCR_ENABLE                DCMIPP_P1DSCR_ENABLE_Msk                        /*!<  Downscaler Enable */

/***************  Bit definition for DCMIPP_P1DSRTIOR register  ***************/
#define DCMIPP_P1DSRTIOR_HRATIO_Pos         (0UL)
#define DCMIPP_P1DSRTIOR_HRATIO_Msk         (0xFFFFUL << DCMIPP_P1DSRTIOR_HRATIO_Pos)        /*!< 0x0000FFFF */
#define DCMIPP_P1DSRTIOR_HRATIO             DCMIPP_P1DSRTIOR_HRATIO_Msk                     /*!< Horizontal ratio, from 8192 (1x) to 65535 (8x) */
#define DCMIPP_P1DSRTIOR_VRATIO_Pos         (16UL)
#define DCMIPP_P1DSRTIOR_VRATIO_Msk         (0xFFFFUL << DCMIPP_P1DSRTIOR_VRATIO_Pos)        /*!< 0xFFFF0000 */
#define DCMIPP_P1DSRTIOR_VRATIO             DCMIPP_P1DSRTIOR_VRATIO_Msk                     /*!< Vertical ratio, from 8192 (1x) to 65535 (8x) */

/****************  Bit definition for DCMIPP_P1DSSZR register  ****************/
#define DCMIPP_P1DSSZR_HSIZE_Pos            (0UL)
#define DCMIPP_P1DSSZR_HSIZE_Msk            (0xFFFUL << DCMIPP_P1DSSZR_HSIZE_Pos)            /*!< 0x00000FFF */
#define DCMIPP_P1DSSZR_HSIZE                DCMIPP_P1DSSZR_HSIZE_Msk                        /*!< Horizontal size, from 0 to 4094 pixels wide */
#define DCMIPP_P1DSSZR_VSIZE_Pos            (16UL)
#define DCMIPP_P1DSSZR_VSIZE_Msk            (0xFFFUL << DCMIPP_P1DSSZR_VSIZE_Pos)            /*!< 0x0FFF0000 */
#define DCMIPP_P1DSSZR_VSIZE                DCMIPP_P1DSSZR_VSIZE_Msk                        /*!< Vertical size, from 0 to 4094 pixels high */

/***************  Bit definition for DCMIPP_P1CMRICR register  ***************/
#define DCMIPP_P1CMRICR_ROILSZ_Pos          (0UL)
#define DCMIPP_P1CMRICR_ROILSZ_Msk          (0x3UL << DCMIPP_P1CMRICR_ROILSZ_Pos)           /*!< 0x00000003 */
#define DCMIPP_P1CMRICR_ROILSZ              DCMIPP_P1CMRICR_ROILSZ_Msk                      /*!< Region of interest line size width */
#define DCMIPP_P1CMRICR_ROI1EN_Pos          (16UL)
#define DCMIPP_P1CMRICR_ROI1EN_Msk          (0x1UL << DCMIPP_P1CMRICR_ROI1EN_Pos)           /*!< 0x00010000 */
#define DCMIPP_P1CMRICR_ROI1EN              DCMIPP_P1CMRICR_ROI1EN_Msk                      /*!< Region Of Interest 1 Enable */
#define DCMIPP_P1CMRICR_ROI2EN_Pos          (17UL)
#define DCMIPP_P1CMRICR_ROI2EN_Msk          (0x1UL << DCMIPP_P1CMRICR_ROI2EN_Pos)           /*!< 0x00020000 */
#define DCMIPP_P1CMRICR_ROI2EN              DCMIPP_P1CMRICR_ROI2EN_Msk                      /*!< Region Of Interest 2 Enable */
#define DCMIPP_P1CMRICR_ROI3EN_Pos          (18UL)
#define DCMIPP_P1CMRICR_ROI3EN_Msk          (0x1UL << DCMIPP_P1CMRICR_ROI3EN_Pos)           /*!< 0x00040000 */
#define DCMIPP_P1CMRICR_ROI3EN              DCMIPP_P1CMRICR_ROI3EN_Msk                      /*!< Region Of Interest 3 Enable */
#define DCMIPP_P1CMRICR_ROI4EN_Pos          (19UL)
#define DCMIPP_P1CMRICR_ROI4EN_Msk          (0x1UL << DCMIPP_P1CMRICR_ROI4EN_Pos)           /*!< 0x00080000 */
#define DCMIPP_P1CMRICR_ROI4EN              DCMIPP_P1CMRICR_ROI4EN_Msk                      /*!< Region Of Interest 4 Enable */
#define DCMIPP_P1CMRICR_ROI5EN_Pos          (20UL)
#define DCMIPP_P1CMRICR_ROI5EN_Msk          (0x1UL << DCMIPP_P1CMRICR_ROI5EN_Pos)           /*!< 0x00100000 */
#define DCMIPP_P1CMRICR_ROI5EN              DCMIPP_P1CMRICR_ROI5EN_Msk                      /*!< Region Of Interest 5 Enable */
#define DCMIPP_P1CMRICR_ROI6EN_Pos          (21UL)
#define DCMIPP_P1CMRICR_ROI6EN_Msk          (0x1UL << DCMIPP_P1CMRICR_ROI6EN_Pos)           /*!< 0x00200000 */
#define DCMIPP_P1CMRICR_ROI6EN              DCMIPP_P1CMRICR_ROI6EN_Msk                      /*!< Region Of Interest 6 Enable */
#define DCMIPP_P1CMRICR_ROI7EN_Pos          (22UL)
#define DCMIPP_P1CMRICR_ROI7EN_Msk          (0x1UL << DCMIPP_P1CMRICR_ROI7EN_Pos)           /*!< 0x00400000 */
#define DCMIPP_P1CMRICR_ROI7EN              DCMIPP_P1CMRICR_ROI7EN_Msk                      /*!< Region Of Interest 7 Enable */
#define DCMIPP_P1CMRICR_ROI8EN_Pos          (23UL)
#define DCMIPP_P1CMRICR_ROI8EN_Msk          (0x1UL << DCMIPP_P1CMRICR_ROI8EN_Pos)           /*!< 0x00800000 */
#define DCMIPP_P1CMRICR_ROI8EN              DCMIPP_P1CMRICR_ROI8EN_Msk                      /*!< Region Of Interest 8 Enable */

/***************  Bit definition for DCMIPP_P1RIxCR1 register  ***************/
#define DCMIPP_P1RIxCR1_HSTART_Pos          (0UL)
#define DCMIPP_P1RIxCR1_HSTART_Msk          (0xFFFUL << DCMIPP_P1RIxCR1_HSTART_Pos)        /*!< 0x00000FFF */
#define DCMIPP_P1RIxCR1_HSTART              DCMIPP_P1RIxCR1_HSTART_Msk                     /*!< Horizontal start */
#define DCMIPP_P1RIxCR1_CLB_Pos             (12UL)
#define DCMIPP_P1RIxCR1_CLB_Msk             (0x3UL << DCMIPP_P1RIxCR1_CLB_Pos)             /*!< 0x00003000 */
#define DCMIPP_P1RIxCR1_CLB                 DCMIPP_P1RIxCR1_CLB_Msk                        /*!< Color line blue */
#define DCMIPP_P1RIxCR1_CLG_Pos             (14UL)
#define DCMIPP_P1RIxCR1_CLG_Msk             (0x3UL << DCMIPP_P1RIxCR1_CLG_Pos)             /*!< 0x0000C000 */
#define DCMIPP_P1RIxCR1_CLG                 DCMIPP_P1RIxCR1_CLG_Msk                        /*!< Color line green */
#define DCMIPP_P1RIxCR1_VSTART_Pos          (16UL)
#define DCMIPP_P1RIxCR1_VSTART_Msk          (0xFFFUL << DCMIPP_P1RIxCR1_VSTART_Pos)        /*!< 0x0FFF0000 */
#define DCMIPP_P1RIxCR1_VSTART              DCMIPP_P1RIxCR1_VSTART_Msk                     /*!< Vertical start */
#define DCMIPP_P1RIxCR1_CLR_Pos             (28UL)
#define DCMIPP_P1RIxCR1_CLR_Msk             (0x3UL << DCMIPP_P1RIxCR1_CLR_Pos)             /*!< 0x30000000 */
#define DCMIPP_P1RIxCR1_CLR                 DCMIPP_P1RIxCR1_CLR_Msk                        /*!< Color line red */

/***************  Bit definition for DCMIPP_P1RIxCR2 register  ***************/
#define DCMIPP_P1RIxCR2_VSIZE_Pos           (0UL)
#define DCMIPP_P1RIxCR2_VSIZE_Msk           (0xFFFUL << DCMIPP_P1RIxCR2_VSIZE_Pos)        /*!<  0x00000FFF */
#define DCMIPP_P1RIxCR2_VSIZE               DCMIPP_P1RIxCR2_VSIZE_Msk                     /*!< Vertical Size */
#define DCMIPP_P1RIxCR2_HSIZE_Pos           (16UL)
#define DCMIPP_P1RIxCR2_HSIZE_Msk           (0xFFFUL << DCMIPP_P1RIxCR2_HSIZE_Pos)        /*!<  0x07FF8000 */
#define DCMIPP_P1RIxCR2_HSIZE               DCMIPP_P1RIxCR2_HSIZE_Msk                     /*!< Horizontal Size */

/****************  Bit definition for DCMIPP_P1GMCR register  *****************/
#define DCMIPP_P1GMCR_ENABLE_Pos            (0UL)
#define DCMIPP_P1GMCR_ENABLE_Msk            (0x1UL << DCMIPP_P1GMCR_ENABLE_Pos)              /*!< 0x00000001   */
#define DCMIPP_P1GMCR_ENABLE                DCMIPP_P1GMCR_ENABLE_Msk                        /*!<  Gamma  enable*/

/****************  Bit definition for DCMIPP_P1YUVCR register  ****************/
#define DCMIPP_P1YUVCR_ENABLE_Pos           (0UL)
#define DCMIPP_P1YUVCR_ENABLE_Msk           (0x1UL << DCMIPP_P1YUVCR_ENABLE_Pos)             /*!< 0x00000001 */
#define DCMIPP_P1YUVCR_ENABLE               DCMIPP_P1YUVCR_ENABLE_Msk                       /*!<  */
#define DCMIPP_P1YUVCR_TYPE_Pos             (1UL)
#define DCMIPP_P1YUVCR_TYPE_Msk             (0x1UL << DCMIPP_P1YUVCR_TYPE_Pos)               /*!< 0x00000002 */
#define DCMIPP_P1YUVCR_TYPE                 DCMIPP_P1YUVCR_TYPE_Msk                         /*!< Output samples type used while CLAMP is activated */
#define DCMIPP_P1YUVCR_CLAMP_Pos            (2UL)
#define DCMIPP_P1YUVCR_CLAMP_Msk            (0x1UL << DCMIPP_P1YUVCR_CLAMP_Pos)              /*!< 0x00000004 */
#define DCMIPP_P1YUVCR_CLAMP                DCMIPP_P1YUVCR_CLAMP_Msk                        /*!< Clamp the output samples */

/***************  Bit definition for DCMIPP_P1YUVRR1 register  ****************/
#define DCMIPP_P1YUVRR1_RR_Pos              (0UL)
#define DCMIPP_P1YUVRR1_RR_Msk              (0x7FFUL << DCMIPP_P1YUVRR1_RR_Pos)              /*!< 0x000007FF */
#define DCMIPP_P1YUVRR1_RR                  DCMIPP_P1YUVRR1_RR_Msk                          /*!< Coefficient row 1 column 1 of the matrix */
#define DCMIPP_P1YUVRR1_RG_Pos              (16UL)
#define DCMIPP_P1YUVRR1_RG_Msk              (0x7FFUL << DCMIPP_P1YUVRR1_RG_Pos)              /*!< 0x07FF0000 */
#define DCMIPP_P1YUVRR1_RG                  DCMIPP_P1YUVRR1_RG_Msk                          /*!< Coefficient row 1 column 2 of the matrix */

/***************  Bit definition for DCMIPP_P1YUVRR2 register  ****************/
#define DCMIPP_P1YUVRR2_RB_Pos              (0UL)
#define DCMIPP_P1YUVRR2_RB_Msk              (0x7FFUL << DCMIPP_P1YUVRR2_RB_Pos)              /*!< 0x000007FF */
#define DCMIPP_P1YUVRR2_RB                  DCMIPP_P1YUVRR2_RB_Msk                          /*!< Coefficient row 1 column 3 of the matrix */
#define DCMIPP_P1YUVRR2_RA_Pos              (16UL)
#define DCMIPP_P1YUVRR2_RA_Msk              (0x3FFUL << DCMIPP_P1YUVRR2_RA_Pos)              /*!< 0x03FF0000 */
#define DCMIPP_P1YUVRR2_RA                  DCMIPP_P1YUVRR2_RA_Msk                          /*!< Coefficient row 1 of the added column (signed integer value) */

/***************  Bit definition for DCMIPP_P1YUVGR1 register  ****************/
#define DCMIPP_P1YUVGR1_GR_Pos              (0UL)
#define DCMIPP_P1YUVGR1_GR_Msk              (0x7FFUL << DCMIPP_P1YUVGR1_GR_Pos)              /*!< 0x000007FF */
#define DCMIPP_P1YUVGR1_GR                  DCMIPP_P1YUVGR1_GR_Msk                          /*!< Coefficient row 2 column 1 of the matrix */
#define DCMIPP_P1YUVGR1_GG_Pos              (16UL)
#define DCMIPP_P1YUVGR1_GG_Msk              (0x7FFUL << DCMIPP_P1YUVGR1_GG_Pos)              /*!< 0x07FF0000 */
#define DCMIPP_P1YUVGR1_GG                  DCMIPP_P1YUVGR1_GG_Msk                          /*!< Coefficient row 2 column 2 of the matrix */

/***************  Bit definition for DCMIPP_P1YUVGR2 register  ****************/
#define DCMIPP_P1YUVGR2_GB_Pos              (0UL)
#define DCMIPP_P1YUVGR2_GB_Msk              (0x7FFUL << DCMIPP_P1YUVGR2_GB_Pos)              /*!< 0x000007FF */
#define DCMIPP_P1YUVGR2_GB                  DCMIPP_P1YUVGR2_GB_Msk                          /*!< Coefficient row 2 column 3 of the matrix */
#define DCMIPP_P1YUVGR2_GA_Pos              (16UL)
#define DCMIPP_P1YUVGR2_GA_Msk              (0x3FFUL << DCMIPP_P1YUVGR2_GA_Pos)              /*!< 0x03FF0000 */
#define DCMIPP_P1YUVGR2_GA                  DCMIPP_P1YUVGR2_GA_Msk                          /*!< Coefficient row 2 of the added column (signed integer value) */

/***************  Bit definition for DCMIPP_P1YUVBR1 register  ****************/
#define DCMIPP_P1YUVBR1_BR_Pos              (0UL)
#define DCMIPP_P1YUVBR1_BR_Msk              (0x7FFUL << DCMIPP_P1YUVBR1_BR_Pos)              /*!< 0x000007FF */
#define DCMIPP_P1YUVBR1_BR                  DCMIPP_P1YUVBR1_BR_Msk                          /*!< Coefficient row 3 column 1 of the matrix */
#define DCMIPP_P1YUVBR1_BG_Pos              (16UL)
#define DCMIPP_P1YUVBR1_BG_Msk              (0x7FFUL << DCMIPP_P1YUVBR1_BG_Pos)              /*!< 0x07FF0000 */
#define DCMIPP_P1YUVBR1_BG                  DCMIPP_P1YUVBR1_BG_Msk                          /*!< Coefficient row 3 column 2 of the matrix */

/***************  Bit definition for DCMIPP_P1YUVBR2 register  ****************/
#define DCMIPP_P1YUVBR2_BB_Pos              (0UL)
#define DCMIPP_P1YUVBR2_BB_Msk              (0x7FFUL << DCMIPP_P1YUVBR2_BB_Pos)              /*!< 0x000007FF */
#define DCMIPP_P1YUVBR2_BB                  DCMIPP_P1YUVBR2_BB_Msk                          /*!< Coefficient row 3 column 3 of the matrix */
#define DCMIPP_P1YUVBR2_BA_Pos              (16UL)
#define DCMIPP_P1YUVBR2_BA_Msk              (0x3FFUL << DCMIPP_P1YUVBR2_BA_Pos)              /*!< 0x03FF0000 */
#define DCMIPP_P1YUVBR2_BA                  DCMIPP_P1YUVBR2_BA_Msk                          /*!< Coefficient row 3 of the added column (signed integer value) */

/****************  Bit definition for DCMIPP_P1PPCR register  *****************/
#define DCMIPP_P1PPCR_FORMAT_Pos            (0UL)
#define DCMIPP_P1PPCR_FORMAT_Msk            (0xFUL << DCMIPP_P1PPCR_FORMAT_Pos)              /*!< 0x0000000F */
#define DCMIPP_P1PPCR_FORMAT                DCMIPP_P1PPCR_FORMAT_Msk                        /*!< Memory format */
#define DCMIPP_P1PPCR_SWAPRB_Pos            (4UL)
#define DCMIPP_P1PPCR_SWAPRB_Msk            (0x1UL << DCMIPP_P1PPCR_SWAPRB_Pos)              /*!< 0x00000010 */
#define DCMIPP_P1PPCR_SWAPRB                DCMIPP_P1PPCR_SWAPRB_Msk                        /*!< Swaps R-vs-B components if RGB, and U-vs-V components if YUV */
#define DCMIPP_P1PPCR_LINEMULT_Pos          (13UL)
#define DCMIPP_P1PPCR_LINEMULT_Msk          (0x7UL << DCMIPP_P1PPCR_LINEMULT_Pos)            /*!< 0x0000E000 */
#define DCMIPP_P1PPCR_LINEMULT              DCMIPP_P1PPCR_LINEMULT_Msk                      /*!< Amount of capture completed lines for LINE Event and Interrupt */
#define DCMIPP_P1PPCR_DBM_Pos               (16UL)
#define DCMIPP_P1PPCR_DBM_Msk               (0x1UL << DCMIPP_P1PPCR_DBM_Pos)                 /*!< 0x00010000 */
#define DCMIPP_P1PPCR_DBM                   DCMIPP_P1PPCR_DBM_Msk                           /*!< Double buffer mode */
#define DCMIPP_P1PPCR_LMAWM_Pos             (17UL)
#define DCMIPP_P1PPCR_LMAWM_Msk             (0x7UL << DCMIPP_P1PPCR_LMAWM_Pos)                /*!< 0x000E0000 */
#define DCMIPP_P1PPCR_LMAWM                 DCMIPP_P1PPCR_LMAWM_Msk                          /*!< Line multi address wrapping modulo */
#define DCMIPP_P1PPCR_LMAWE_Pos             (20UL)
#define DCMIPP_P1PPCR_LMAWE_Msk             (0x1UL << DCMIPP_P1PPCR_LMAWE_Pos)                /*!< 0x00100000 */
#define DCMIPP_P1PPCR_LMAWE                 DCMIPP_P1PPCR_LMAWE_Msk                           /*!< Line multi address wrapping enable */

/***************  Bit definition for DCMIPP_P1PPM0AR1 register  ***************/
#define DCMIPP_P1PPM0AR1_M0A_Pos            (0UL)
#define DCMIPP_P1PPM0AR1_M0A_Msk            (0xFFFFFFFFUL << DCMIPP_P1PPM0AR1_M0A_Pos)       /*!< 0xFFFFFFFF */
#define DCMIPP_P1PPM0AR1_M0A                DCMIPP_P1PPM0AR1_M0A_Msk                        /*!< Memory0 address register 1*/

/***************  Bit definition for DCMIPP_P1PPM0AR2 register  ***************/
#define DCMIPP_P1PPM0AR2_M0A_Pos            (0UL)
#define DCMIPP_P1PPM0AR2_M0A_Msk            (0xFFFFFFFFUL << DCMIPP_P1PPM0AR2_M0A_Pos)       /*!< 0xFFFFFFFF */
#define DCMIPP_P1PPM0AR2_M0A                DCMIPP_P1PPM0AR2_M0A_Msk                        /*!< Memory0 address register 2 */

/***************  Bit definition for DCMIPP_P1PPM0PR register  ****************/
#define DCMIPP_P1PPM0PR_PITCH_Pos           (0UL)
#define DCMIPP_P1PPM0PR_PITCH_Msk           (0x7FFFUL << DCMIPP_P1PPM0PR_PITCH_Pos)          /*!< 0x00007FFF */
#define DCMIPP_P1PPM0PR_PITCH               DCMIPP_P1PPM0PR_PITCH_Msk                       /*!< Number of bytes between the address of two consecutive lines */

/***************  Bit definition for DCMIPP_P1PPM1AR1 register  ***************/
#define DCMIPP_P1PPM1AR1_M1A_Pos            (0UL)
#define DCMIPP_P1PPM1AR1_M1A_Msk            (0xFFFFFFFFUL << DCMIPP_P1PPM1AR1_M1A_Pos)       /*!< 0xFFFFFFFF */
#define DCMIPP_P1PPM1AR1_M1A                DCMIPP_P1PPM1AR1_M1A_Msk                        /*!< Memory1 address */

/***************  Bit definition for DCMIPP_P1PPM1AR2 register  ***************/
#define DCMIPP_P1PPM1AR2_M1A_Pos            (0UL)
#define DCMIPP_P1PPM1AR2_M1A_Msk            (0xFFFFFFFFUL << DCMIPP_P1PPM1AR2_M1A_Pos)       /*!< 0xFFFFFFFF */
#define DCMIPP_P1PPM1AR2_M1A                DCMIPP_P1PPM1AR2_M1A_Msk                        /*!< Memory1 address */

/***************  Bit definition for DCMIPP_P1PPM1PR register  ****************/
#define DCMIPP_P1PPM1PR_PITCH_Pos           (0UL)
#define DCMIPP_P1PPM1PR_PITCH_Msk           (0x7FFFUL << DCMIPP_P1PPM1PR_PITCH_Pos)          /*!< 0x00007FFF */
#define DCMIPP_P1PPM1PR_PITCH               DCMIPP_P1PPM1PR_PITCH_Msk                       /*!< Number of bytes between the address of two consecutive lines */

/***************  Bit definition for DCMIPP_P1STM1AR register  ****************/
#define DCMIPP_P1STM1AR_M1A_Pos             (0UL)
#define DCMIPP_P1STM1AR_M1A_Msk             (0x7FFFUL << DCMIPP_P1STM1AR_M1A_Pos)           /*!< 0xFFFFFFFF */
#define DCMIPP_P1STM1AR_M1A                 DCMIPP_P1STM1AR_M1A_Msk                         /*!< status Memory1 address register */

/***************  Bit definition for DCMIPP_P1PPM2AR1 register  ***************/
#define DCMIPP_P1PPM2AR1_M2A_Pos            (0UL)
#define DCMIPP_P1PPM2AR1_M2A_Msk            (0xFFFFFFFFUL << DCMIPP_P1PPM2AR1_M2A_Pos)       /*!< 0xFFFFFFFF */
#define DCMIPP_P1PPM2AR1_M2A                DCMIPP_P1PPM2AR1_M2A_Msk                        /*!< Memory2 address register 1*/

/***************  Bit definition for DCMIPP_P1PPM2AR2 register  ***************/
#define DCMIPP_P1PPM2AR2_M2A_Pos            (0UL)
#define DCMIPP_P1PPM2AR2_M2A_Msk            (0xFFFFFFFFUL << DCMIPP_P1PPM2AR2_M2A_Pos)       /*!< 0xFFFFFFFF */
#define DCMIPP_P1PPM2AR2_M2A                DCMIPP_P1PPM2AR2_M2A_Msk                        /*!< Memory2 address register 2 */

/***************  Bit definition for DCMIPP_P1STM2AR register  ****************/
#define DCMIPP_P1STM2AR_M2A_Pos             (0UL)
#define DCMIPP_P1STM2AR_M2A_Msk             (0xFFFFFFFFUL << DCMIPP_P1STM2AR_M2A_Pos)       /*!< 0xFFFFFFFF */
#define DCMIPP_P1STM2AR_M2A                 DCMIPP_P1STM2AR_M2A_Msk                         /*!< status Memory2 address register */

/*****************  Bit definition for DCMIPP_P1IER register  *****************/
#define DCMIPP_P1IER_LINEIE_Pos             (0UL)
#define DCMIPP_P1IER_LINEIE_Msk             (0x1UL << DCMIPP_P1IER_LINEIE_Pos)               /*!< 0x00000001 */
#define DCMIPP_P1IER_LINEIE                 DCMIPP_P1IER_LINEIE_Msk                         /*!< Multi-line capture completed interrupt enable */
#define DCMIPP_P1IER_FRAMEIE_Pos            (1UL)
#define DCMIPP_P1IER_FRAMEIE_Msk            (0x1UL << DCMIPP_P1IER_FRAMEIE_Pos)              /*!< 0x00000002 */
#define DCMIPP_P1IER_FRAMEIE                DCMIPP_P1IER_FRAMEIE_Msk                        /*!< Frame capture completed interrupt enable */
#define DCMIPP_P1IER_VSYNCIE_Pos            (2UL)
#define DCMIPP_P1IER_VSYNCIE_Msk            (0x1UL << DCMIPP_P1IER_VSYNCIE_Pos)              /*!< 0x00000004 */
#define DCMIPP_P1IER_VSYNCIE                DCMIPP_P1IER_VSYNCIE_Msk                        /*!< VSYNC interrupt enable */
#define DCMIPP_P1IER_OVRIE_Pos              (7UL)
#define DCMIPP_P1IER_OVRIE_Msk              (0x1UL << DCMIPP_P1IER_OVRIE_Pos)                /*!< 0x00000080 */
#define DCMIPP_P1IER_OVRIE                  DCMIPP_P1IER_OVRIE_Msk                          /*!< Overrun interrupt enable */

/*****************  Bit definition for DCMIPP_P1SR register  ******************/
#define DCMIPP_P1SR_LINEF_Pos               (0UL)
#define DCMIPP_P1SR_LINEF_Msk               (0x1UL << DCMIPP_P1SR_LINEF_Pos)                 /*!< 0x00000001 */
#define DCMIPP_P1SR_LINEF                   DCMIPP_P1SR_LINEF_Msk                           /*!< Multi-line capture completed raw interrupt status */
#define DCMIPP_P1SR_FRAMEF_Pos              (1UL)
#define DCMIPP_P1SR_FRAMEF_Msk              (0x1UL << DCMIPP_P1SR_FRAMEF_Pos)                /*!< 0x00000002 */
#define DCMIPP_P1SR_FRAMEF                  DCMIPP_P1SR_FRAMEF_Msk                          /*!< Frame capture completed raw interrupt status */
#define DCMIPP_P1SR_VSYNCF_Pos              (2UL)
#define DCMIPP_P1SR_VSYNCF_Msk              (0x1UL << DCMIPP_P1SR_VSYNCF_Pos)                /*!< 0x00000004 */
#define DCMIPP_P1SR_VSYNCF                  DCMIPP_P1SR_VSYNCF_Msk                          /*!< VSYNC raw interrupt status */
#define DCMIPP_P1SR_OVRF_Pos                (7UL)
#define DCMIPP_P1SR_OVRF_Msk                (0x1UL << DCMIPP_P1SR_OVRF_Pos)                  /*!< 0x00000080 */
#define DCMIPP_P1SR_OVRF                    DCMIPP_P1SR_OVRF_Msk                            /*!< Overrun raw interrupt status */
#define DCMIPP_P1SR_LSTLINE_Pos             (16UL)
#define DCMIPP_P1SR_LSTLINE_Msk             (0x1UL << DCMIPP_P1SR_LSTLINE_Pos)               /*!< 0x00010000 */
#define DCMIPP_P1SR_LSTLINE                 DCMIPP_P1SR_LSTLINE_Msk                         /*!< Last line LSB bit, sampled at frame capture complete event */
#define DCMIPP_P1SR_LSTFRM_Pos              (17UL)
#define DCMIPP_P1SR_LSTFRM_Msk              (0x1UL << DCMIPP_P1SR_LSTFRM_Pos)                /*!< 0x00020000 */
#define DCMIPP_P1SR_LSTFRM                  DCMIPP_P1SR_LSTFRM_Msk                          /*!< Last frame LSB bit, sampled at frame capture complete event */
#define DCMIPP_P1SR_CPTACT_Pos              (23UL)
#define DCMIPP_P1SR_CPTACT_Msk              (0x1UL << DCMIPP_P1SR_CPTACT_Pos)                /*!< 0x00800000 */
#define DCMIPP_P1SR_CPTACT                  DCMIPP_P1SR_CPTACT_Msk                          /*!< Capture immediate status */

/*****************  Bit definition for DCMIPP_P1FCR register  *****************/
#define DCMIPP_P1FCR_CLINEF_Pos             (0UL)
#define DCMIPP_P1FCR_CLINEF_Msk             (0x1UL << DCMIPP_P1FCR_CLINEF_Pos)               /*!< 0x00000001 */
#define DCMIPP_P1FCR_CLINEF                 DCMIPP_P1FCR_CLINEF_Msk                         /*!< Multi-line capture complete interrupt status clear */
#define DCMIPP_P1FCR_CFRAMEF_Pos            (1UL)
#define DCMIPP_P1FCR_CFRAMEF_Msk            (0x1UL << DCMIPP_P1FCR_CFRAMEF_Pos)              /*!< 0x00000002 */
#define DCMIPP_P1FCR_CFRAMEF                DCMIPP_P1FCR_CFRAMEF_Msk                        /*!< Frame capture complete interrupt status clear */
#define DCMIPP_P1FCR_CVSYNCF_Pos            (2UL)
#define DCMIPP_P1FCR_CVSYNCF_Msk            (0x1UL << DCMIPP_P1FCR_CVSYNCF_Pos)              /*!< 0x00000004 */
#define DCMIPP_P1FCR_CVSYNCF                DCMIPP_P1FCR_CVSYNCF_Msk                        /*!< Vertical synchronization interrupt status clear */
#define DCMIPP_P1FCR_COVRF_Pos              (7UL)
#define DCMIPP_P1FCR_COVRF_Msk              (0x1UL << DCMIPP_P1FCR_COVRF_Pos)                /*!< 0x00000080 */
#define DCMIPP_P1FCR_COVRF                  DCMIPP_P1FCR_COVRF_Msk                          /*!< Overrun interrupt status clear */

/****************  Bit definition for DCMIPP_P1CFSCR register  ****************/
#define DCMIPP_P1CFSCR_DTIDA_Pos            (0UL)
#define DCMIPP_P1CFSCR_DTIDA_Msk            (0x3FUL << DCMIPP_P1CFSCR_DTIDA_Pos)             /*!< 0x0000003F */
#define DCMIPP_P1CFSCR_DTIDA                DCMIPP_P1CFSCR_DTIDA_Msk                        /*!< Current Data type ID A */
#define DCMIPP_P1CFSCR_DTIDB_Pos            (8UL)
#define DCMIPP_P1CFSCR_DTIDB_Msk            (0x3FUL << DCMIPP_P1CFSCR_DTIDB_Pos)             /*!< 0x00003F00 */
#define DCMIPP_P1CFSCR_DTIDB                DCMIPP_P1CFSCR_DTIDB_Msk                        /*!< Current Data type ID B */
#define DCMIPP_P1CFSCR_DTMODE_Pos           (16UL)
#define DCMIPP_P1CFSCR_DTMODE_Msk           (0x3UL << DCMIPP_P1CFSCR_DTMODE_Pos)             /*!< 0x00030000 */
#define DCMIPP_P1CFSCR_DTMODE               DCMIPP_P1CFSCR_DTMODE_Msk                       /*!< Flow selection mode */
#define DCMIPP_P1CFSCR_PIPEDIFF_Pos         (18UL)
#define DCMIPP_P1CFSCR_PIPEDIFF_Msk         (0x1UL << DCMIPP_P1CFSCR_PIPEDIFF_Pos)           /*!< 0x00040000 */
#define DCMIPP_P1CFSCR_PIPEDIFF             DCMIPP_P1CFSCR_PIPEDIFF_Msk                     /*!< Current differentiates Pipe2 vs */
#define DCMIPP_P1CFSCR_VC_Pos               (19UL)
#define DCMIPP_P1CFSCR_VC_Msk               (0x3UL << DCMIPP_P1CFSCR_VC_Pos)                 /*!< 0x00180000 */
#define DCMIPP_P1CFSCR_VC                   DCMIPP_P1CFSCR_VC_Msk                           /*!< Current flow selection mode */
#define DCMIPP_P1CFSCR_FDTF_Pos             (24UL)
#define DCMIPP_P1CFSCR_FDTF_Msk             (0x3FUL << DCMIPP_P1CFSCR_FDTF_Pos)              /*!< 0x3F000000 */
#define DCMIPP_P1CFSCR_FDTF                 DCMIPP_P1CFSCR_FDTF_Msk                         /*!< Current force Data type format */
#define DCMIPP_P1CFSCR_FDTFEN_Pos           (30UL)
#define DCMIPP_P1CFSCR_FDTFEN_Msk           (0x1UL << DCMIPP_P1CFSCR_FDTFEN_Pos)             /*!< 0x40000000 */
#define DCMIPP_P1CFSCR_FDTFEN               DCMIPP_P1CFSCR_FDTFEN_Msk                       /*!< Current force Data type format enable */
#define DCMIPP_P1CFSCR_PIPEN_Pos            (31UL)
#define DCMIPP_P1CFSCR_PIPEN_Msk            (0x1UL << DCMIPP_P1CFSCR_PIPEN_Pos)              /*!< 0x80000000 */
#define DCMIPP_P1CFSCR_PIPEN                DCMIPP_P1CFSCR_PIPEN_Msk                        /*!< Current activation of PipeN */

/***************  Bit definition for DCMIPP_P1CBPRCR register  ****************/
#define DCMIPP_P1CBPRCR_ENABLE_Pos          (0UL)
#define DCMIPP_P1CBPRCR_ENABLE_Msk          (0x1UL << DCMIPP_P1CBPRCR_ENABLE_Pos)            /*!< 0x00000001 */
#define DCMIPP_P1CBPRCR_ENABLE              DCMIPP_P1CBPRCR_ENABLE_Msk                      /*!< Current status of enable bit */
#define DCMIPP_P1CBPRCR_STRENGTH_Pos        (1UL)
#define DCMIPP_P1CBPRCR_STRENGTH_Msk        (0x7UL << DCMIPP_P1CBPRCR_STRENGTH_Pos)          /*!< 0x0000000E */
#define DCMIPP_P1CBPRCR_STRENGTH            DCMIPP_P1CBPRCR_STRENGTH_Msk                    /*!< Current strength (aggressivity) of the bad pixel detection: */

/***************  Bit definition for DCMIPP_P1CBLCCR register  ****************/
#define DCMIPP_P1CBLCCR_ENABLE_Pos          (0UL)
#define DCMIPP_P1CBLCCR_ENABLE_Msk          (0x1UL << DCMIPP_P1CBLCCR_ENABLE_Pos)            /*!< 0x00000001 */
#define DCMIPP_P1CBLCCR_ENABLE              DCMIPP_P1CBLCCR_ENABLE_Msk                      /*!< For current black level calibration */
#define DCMIPP_P1CBLCCR_BLCB_Pos            (8UL)
#define DCMIPP_P1CBLCCR_BLCB_Msk            (0xFFUL << DCMIPP_P1CBLCCR_BLCB_Pos)             /*!< 0x0000FF00 */
#define DCMIPP_P1CBLCCR_BLCB                DCMIPP_P1CBLCCR_BLCB_Msk                        /*!< Current black level calibration - Blue */
#define DCMIPP_P1CBLCCR_BLCG_Pos            (16UL)
#define DCMIPP_P1CBLCCR_BLCG_Msk            (0xFFUL << DCMIPP_P1CBLCCR_BLCG_Pos)             /*!< 0x00FF0000 */
#define DCMIPP_P1CBLCCR_BLCG                DCMIPP_P1CBLCCR_BLCG_Msk                        /*!< Current black level calibration - Green */
#define DCMIPP_P1CBLCCR_BLCR_Pos            (24UL)
#define DCMIPP_P1CBLCCR_BLCR_Msk            (0xFFUL << DCMIPP_P1CBLCCR_BLCR_Pos)             /*!< 0xFF000000 */
#define DCMIPP_P1CBLCCR_BLCR                DCMIPP_P1CBLCCR_BLCR_Msk                        /*!< Current black level calibration - Red */

/***************  Bit definition for DCMIPP_P1CEXCR1 register  ****************/
#define DCMIPP_P1CEXCR1_ENABLE_Pos          (0UL)
#define DCMIPP_P1CEXCR1_ENABLE_Msk          (0x1UL << DCMIPP_P1CEXCR1_ENABLE_Pos)            /*!< 0x00000001 */
#define DCMIPP_P1CEXCR1_ENABLE              DCMIPP_P1CEXCR1_ENABLE_Msk                      /*!< for exposure control (multiplication and shift) */
#define DCMIPP_P1CEXCR1_MULTR_Pos           (20UL)
#define DCMIPP_P1CEXCR1_MULTR_Msk           (0xFFUL << DCMIPP_P1CEXCR1_MULTR_Pos)            /*!< 0x0FF00000 */
#define DCMIPP_P1CEXCR1_MULTR               DCMIPP_P1CEXCR1_MULTR_Msk                       /*!< Current exposure multiplier - Red */
#define DCMIPP_P1CEXCR1_SHFR_Pos            (28UL)
#define DCMIPP_P1CEXCR1_SHFR_Msk            (0x7UL << DCMIPP_P1CEXCR1_SHFR_Pos)              /*!< 0x70000000 */
#define DCMIPP_P1CEXCR1_SHFR                DCMIPP_P1CEXCR1_SHFR_Msk                        /*!< Current exposure shift - Red */

/***************  Bit definition for DCMIPP_P1CEXCR2 register  ****************/
#define DCMIPP_P1CEXCR2_MULTB_Pos           (4UL)
#define DCMIPP_P1CEXCR2_MULTB_Msk           (0xFFUL << DCMIPP_P1CEXCR2_MULTB_Pos)            /*!< 0x00000FF0 */
#define DCMIPP_P1CEXCR2_MULTB               DCMIPP_P1CEXCR2_MULTB_Msk                       /*!< Current exposure multiplier - Blue */
#define DCMIPP_P1CEXCR2_SHFB_Pos            (12UL)
#define DCMIPP_P1CEXCR2_SHFB_Msk            (0x7UL << DCMIPP_P1CEXCR2_SHFB_Pos)              /*!< 0x00007000 */
#define DCMIPP_P1CEXCR2_SHFB                DCMIPP_P1CEXCR2_SHFB_Msk                        /*!< Current exposure shift - Blue */
#define DCMIPP_P1CEXCR2_MULTG_Pos           (20UL)
#define DCMIPP_P1CEXCR2_MULTG_Msk           (0xFFUL << DCMIPP_P1CEXCR2_MULTG_Pos)            /*!< 0x0FF00000 */
#define DCMIPP_P1CEXCR2_MULTG               DCMIPP_P1CEXCR2_MULTG_Msk                       /*!< Current exposure multiplier - Green */
#define DCMIPP_P1CEXCR2_SHFG_Pos            (28UL)
#define DCMIPP_P1CEXCR2_SHFG_Msk            (0x7UL << DCMIPP_P1CEXCR2_SHFG_Pos)              /*!< 0x70000000 */
#define DCMIPP_P1CEXCR2_SHFG                DCMIPP_P1CEXCR2_SHFG_Msk                        /*!< Current exposure shift - Green */

/***************  Bit definition for DCMIPP_P1CST1CR register  ****************/
#define DCMIPP_P1CST1CR_ENABLE_Pos          (0UL)
#define DCMIPP_P1CST1CR_ENABLE_Msk          (0x1UL << DCMIPP_P1CST1CR_ENABLE_Pos)            /*!< 0x00000001 */
#define DCMIPP_P1CST1CR_ENABLE              DCMIPP_P1CST1CR_ENABLE_Msk                      /*!< Current enable bit value */
#define DCMIPP_P1CST1CR_BINS_Pos            (2UL)
#define DCMIPP_P1CST1CR_BINS_Msk            (0x3UL << DCMIPP_P1CST1CR_BINS_Pos)              /*!< 0x0000000C */
#define DCMIPP_P1CST1CR_BINS                DCMIPP_P1CST1CR_BINS_Msk                        /*!< Current bin definition */
#define DCMIPP_P1CST1CR_SRC_Pos             (4UL)
#define DCMIPP_P1CST1CR_SRC_Msk             (0x7UL << DCMIPP_P1CST1CR_SRC_Pos)               /*!< 0x00000070 */
#define DCMIPP_P1CST1CR_SRC                 DCMIPP_P1CST1CR_SRC_Msk                         /*!< Current source of statistics */
#define DCMIPP_P1CST1CR_MODE_Pos            (7UL)
#define DCMIPP_P1CST1CR_MODE_Msk            (0x1UL << DCMIPP_P1CST1CR_MODE_Pos)              /*!< 0x00000080 */
#define DCMIPP_P1CST1CR_MODE                DCMIPP_P1CST1CR_MODE_Msk                        /*!< Current statistics mode */
#define DCMIPP_P1CST1CR_ACCU_Pos            (8UL)
#define DCMIPP_P1CST1CR_ACCU_Msk            (0xFFFFFFUL << DCMIPP_P1CST1CR_ACCU_Pos)         /*!< 0xFFFFFF00 */
#define DCMIPP_P1CST1CR_ACCU                DCMIPP_P1CST1CR_ACCU_Msk                        /*!< Current accumulation result, divided by 256 */

/***************  Bit definition for DCMIPP_P1CST2CR register  ****************/
#define DCMIPP_P1CST2CR_ENABLE_Pos          (0UL)
#define DCMIPP_P1CST2CR_ENABLE_Msk          (0x1UL << DCMIPP_P1CST2CR_ENABLE_Pos)            /*!< 0x00000001 */
#define DCMIPP_P1CST2CR_ENABLE              DCMIPP_P1CST2CR_ENABLE_Msk                      /*!<  */
#define DCMIPP_P1CST2CR_BINS_Pos            (2UL)
#define DCMIPP_P1CST2CR_BINS_Msk            (0x3UL << DCMIPP_P1CST2CR_BINS_Pos)              /*!< 0x0000000C */
#define DCMIPP_P1CST2CR_BINS                DCMIPP_P1CST2CR_BINS_Msk                        /*!< Bin definition */
#define DCMIPP_P1CST2CR_SRC_Pos             (4UL)
#define DCMIPP_P1CST2CR_SRC_Msk             (0x7UL << DCMIPP_P1CST2CR_SRC_Pos)               /*!< 0x00000070 */
#define DCMIPP_P1CST2CR_SRC                 DCMIPP_P1CST2CR_SRC_Msk                         /*!< source of stat */
#define DCMIPP_P1CST2CR_MODE_Pos            (7UL)
#define DCMIPP_P1CST2CR_MODE_Msk            (0x1UL << DCMIPP_P1CST2CR_MODE_Pos)              /*!< 0x00000080 */
#define DCMIPP_P1CST2CR_MODE                DCMIPP_P1CST2CR_MODE_Msk                        /*!< statistics mode */
#define DCMIPP_P1CST2CR_ACCU_Pos            (8UL)
#define DCMIPP_P1CST2CR_ACCU_Msk            (0xFFFFFFUL << DCMIPP_P1CST2CR_ACCU_Pos)         /*!< 0xFFFFFF00 */
#define DCMIPP_P1CST2CR_ACCU                DCMIPP_P1CST2CR_ACCU_Msk                        /*!< Accumulation result, divided by 256 */

/***************  Bit definition for DCMIPP_P1CST3CR register  ****************/
#define DCMIPP_P1CST3CR_ENABLE_Pos          (0UL)
#define DCMIPP_P1CST3CR_ENABLE_Msk          (0x1UL << DCMIPP_P1CST3CR_ENABLE_Pos)            /*!< 0x00000001 */
#define DCMIPP_P1CST3CR_ENABLE              DCMIPP_P1CST3CR_ENABLE_Msk                      /*!<  */
#define DCMIPP_P1CST3CR_BINS_Pos            (2UL)
#define DCMIPP_P1CST3CR_BINS_Msk            (0x3UL << DCMIPP_P1CST3CR_BINS_Pos)              /*!< 0x0000000C */
#define DCMIPP_P1CST3CR_BINS                DCMIPP_P1CST3CR_BINS_Msk                        /*!< Bin definition */
#define DCMIPP_P1CST3CR_SRC_Pos             (4UL)
#define DCMIPP_P1CST3CR_SRC_Msk             (0x7UL << DCMIPP_P1CST3CR_SRC_Pos)               /*!< 0x00000070 */
#define DCMIPP_P1CST3CR_SRC                 DCMIPP_P1CST3CR_SRC_Msk                         /*!< Statistics source */
#define DCMIPP_P1CST3CR_MODE_Pos            (7UL)
#define DCMIPP_P1CST3CR_MODE_Msk            (0x1UL << DCMIPP_P1CST3CR_MODE_Pos)              /*!< 0x00000080 */
#define DCMIPP_P1CST3CR_MODE                DCMIPP_P1CST3CR_MODE_Msk                        /*!< Statistics mode */
#define DCMIPP_P1CST3CR_ACCU_Pos            (8UL)
#define DCMIPP_P1CST3CR_ACCU_Msk            (0xFFFFFFUL << DCMIPP_P1CST3CR_ACCU_Pos)         /*!< 0xFFFFFF00 */
#define DCMIPP_P1CST3CR_ACCU                DCMIPP_P1CST3CR_ACCU_Msk                        /*!< Accumulation result, divided by 256 */

/***************  Bit definition for DCMIPP_P1CSTSTR register  ****************/
#define DCMIPP_P1CSTSTR_HSTART_Pos          (0UL)
#define DCMIPP_P1CSTSTR_HSTART_Msk          (0xFFFUL << DCMIPP_P1CSTSTR_HSTART_Pos)          /*!< 0x00000FFF */
#define DCMIPP_P1CSTSTR_HSTART              DCMIPP_P1CSTSTR_HSTART_Msk                      /*!< Current horizontal start, from 0 to 4094 pixels wide */
#define DCMIPP_P1CSTSTR_VSTART_Pos          (16UL)
#define DCMIPP_P1CSTSTR_VSTART_Msk          (0xFFFUL << DCMIPP_P1CSTSTR_VSTART_Pos)          /*!< 0x0FFF0000 */
#define DCMIPP_P1CSTSTR_VSTART              DCMIPP_P1CSTSTR_VSTART_Msk                      /*!< Current vertical start, from 0 to 4094 pixels high */

/***************  Bit definition for DCMIPP_P1CSTSZR register  ****************/
#define DCMIPP_P1CSTSZR_HSIZE_Pos           (0UL)
#define DCMIPP_P1CSTSZR_HSIZE_Msk           (0xFFFUL << DCMIPP_P1CSTSZR_HSIZE_Pos)           /*!< 0x00000FFF */
#define DCMIPP_P1CSTSZR_HSIZE               DCMIPP_P1CSTSZR_HSIZE_Msk                       /*!< Current horizontal size, from 0 to 4094 pixels wide */
#define DCMIPP_P1CSTSZR_VSIZE_Pos           (16UL)
#define DCMIPP_P1CSTSZR_VSIZE_Msk           (0xFFFUL << DCMIPP_P1CSTSZR_VSIZE_Pos)           /*!< 0x0FFF0000 */
#define DCMIPP_P1CSTSZR_VSIZE               DCMIPP_P1CSTSZR_VSIZE_Msk                       /*!< Current vertical size, from 0 to 4094 pixels high */
#define DCMIPP_P1CSTSZR_CROPEN_Pos          (31UL)
#define DCMIPP_P1CSTSZR_CROPEN_Msk          (0x1UL << DCMIPP_P1CSTSZR_CROPEN_Pos)            /*!< 0x80000000 */
#define DCMIPP_P1CSTSZR_CROPEN              DCMIPP_P1CSTSZR_CROPEN_Msk                      /*!< Current CROPEN bit value */

/****************  Bit definition for DCMIPP_P1CCCCR register  ****************/
#define DCMIPP_P1CCCCR_ENABLE_Pos           (0UL)
#define DCMIPP_P1CCCCR_ENABLE_Msk           (0x1UL << DCMIPP_P1CCCCR_ENABLE_Pos)             /*!< 0x00000001 */
#define DCMIPP_P1CCCCR_ENABLE               DCMIPP_P1CCCCR_ENABLE_Msk                       /*!< This bit indicates the current value applied */
#define DCMIPP_P1CCCCR_TYPE_Pos             (1UL)
#define DCMIPP_P1CCCCR_TYPE_Msk             (0x1UL << DCMIPP_P1CCCCR_TYPE_Pos)               /*!< 0x00000002 */
#define DCMIPP_P1CCCCR_TYPE                 DCMIPP_P1CCCCR_TYPE_Msk                         /*!< output samples type used while CLAMP is activated */
#define DCMIPP_P1CCCCR_CLAMP_Pos            (2UL)
#define DCMIPP_P1CCCCR_CLAMP_Msk            (0x1UL << DCMIPP_P1CCCCR_CLAMP_Pos)              /*!< 0x00000004 */
#define DCMIPP_P1CCCCR_CLAMP                DCMIPP_P1CCCCR_CLAMP_Msk                        /*!< Clamp the output samples */

/***************  Bit definition for DCMIPP_P1CCCRR1 register  ****************/
#define DCMIPP_P1CCCRR1_RR_Pos              (0UL)
#define DCMIPP_P1CCCRR1_RR_Msk              (0x7FFUL << DCMIPP_P1CCCRR1_RR_Pos)              /*!< 0x000007FF */
#define DCMIPP_P1CCCRR1_RR                  DCMIPP_P1CCCRR1_RR_Msk                          /*!< Current coefficient row 1 column 1 of the matrix */
#define DCMIPP_P1CCCRR1_RG_Pos              (16UL)
#define DCMIPP_P1CCCRR1_RG_Msk              (0x7FFUL << DCMIPP_P1CCCRR1_RG_Pos)              /*!< 0x07FF0000 */
#define DCMIPP_P1CCCRR1_RG                  DCMIPP_P1CCCRR1_RG_Msk                          /*!< Current coefficient row 1 column 2 of the matrix */

/***************  Bit definition for DCMIPP_P1CCCRR2 register  ****************/
#define DCMIPP_P1CCCRR2_RB_Pos              (0UL)
#define DCMIPP_P1CCCRR2_RB_Msk              (0x7FFUL << DCMIPP_P1CCCRR2_RB_Pos)              /*!< 0x000007FF */
#define DCMIPP_P1CCCRR2_RB                  DCMIPP_P1CCCRR2_RB_Msk                          /*!< Current coefficient row 1 column 3 of the matrix */
#define DCMIPP_P1CCCRR2_RA_Pos              (16UL)
#define DCMIPP_P1CCCRR2_RA_Msk              (0x3FFUL << DCMIPP_P1CCCRR2_RA_Pos)              /*!< 0x03FF0000 */
#define DCMIPP_P1CCCRR2_RA                  DCMIPP_P1CCCRR2_RA_Msk                          /*!< Current coefficient row 1 of the added column (signed integer value) */

/***************  Bit definition for DCMIPP_P1CCCGR1 register  ****************/
#define DCMIPP_P1CCCGR1_GR_Pos              (0UL)
#define DCMIPP_P1CCCGR1_GR_Msk              (0x7FFUL << DCMIPP_P1CCCGR1_GR_Pos)              /*!< 0x000007FF */
#define DCMIPP_P1CCCGR1_GR                  DCMIPP_P1CCCGR1_GR_Msk                          /*!< Current coefficient row 2 column 1 of the matrix */
#define DCMIPP_P1CCCGR1_GG_Pos              (16UL)
#define DCMIPP_P1CCCGR1_GG_Msk              (0x7FFUL << DCMIPP_P1CCCGR1_GG_Pos)              /*!< 0x07FF0000 */
#define DCMIPP_P1CCCGR1_GG                  DCMIPP_P1CCCGR1_GG_Msk                          /*!< Current coefficient row 2 column 2 of the matrix */

/***************  Bit definition for DCMIPP_P1CCCGR2 register  ****************/
#define DCMIPP_P1CCCGR2_GB_Pos              (0UL)
#define DCMIPP_P1CCCGR2_GB_Msk              (0x7FFUL << DCMIPP_P1CCCGR2_GB_Pos)              /*!< 0x000007FF */
#define DCMIPP_P1CCCGR2_GB                  DCMIPP_P1CCCGR2_GB_Msk                          /*!< Current coefficient row 2 column 3 of the matrix */
#define DCMIPP_P1CCCGR2_GA_Pos              (16UL)
#define DCMIPP_P1CCCGR2_GA_Msk              (0x3FFUL << DCMIPP_P1CCCGR2_GA_Pos)              /*!< 0x03FF0000 */
#define DCMIPP_P1CCCGR2_GA                  DCMIPP_P1CCCGR2_GA_Msk                          /*!< Current coefficient row 2 of the added column (signed integer value) */

/***************  Bit definition for DCMIPP_P1CCCBR1 register  ****************/
#define DCMIPP_P1CCCBR1_BR_Pos              (0UL)
#define DCMIPP_P1CCCBR1_BR_Msk              (0x7FFUL << DCMIPP_P1CCCBR1_BR_Pos)              /*!< 0x000007FF */
#define DCMIPP_P1CCCBR1_BR                  DCMIPP_P1CCCBR1_BR_Msk                          /*!< Current coefficient row 3 column 1 of the matrix */
#define DCMIPP_P1CCCBR1_BG_Pos              (16UL)
#define DCMIPP_P1CCCBR1_BG_Msk              (0x7FFUL << DCMIPP_P1CCCBR1_BG_Pos)              /*!< 0x07FF0000 */
#define DCMIPP_P1CCCBR1_BG                  DCMIPP_P1CCCBR1_BG_Msk                          /*!< Current coefficient row 3 column 2 of the matrix */

/***************  Bit definition for DCMIPP_P1CCCBR2 register  ****************/
#define DCMIPP_P1CCCBR2_BB_Pos              (0UL)
#define DCMIPP_P1CCCBR2_BB_Msk              (0x7FFUL << DCMIPP_P1CCCBR2_BB_Pos)              /*!< 0x000007FF */
#define DCMIPP_P1CCCBR2_BB                  DCMIPP_P1CCCBR2_BB_Msk                          /*!< Current coefficient row 3 column 3 of the matrix */
#define DCMIPP_P1CCCBR2_BA_Pos              (16UL)
#define DCMIPP_P1CCCBR2_BA_Msk              (0x3FFUL << DCMIPP_P1CCCBR2_BA_Pos)              /*!< 0x03FF0000 */
#define DCMIPP_P1CCCBR2_BA                  DCMIPP_P1CCCBR2_BA_Msk                          /*!< Current coefficient row 3 of the added column (signed integer value) */

/***************  Bit definition for DCMIPP_P1CCTCR1 register  ****************/
#define DCMIPP_P1CCTCR1_ENABLE_Pos          (0UL)
#define DCMIPP_P1CCTCR1_ENABLE_Msk          (0x1UL << DCMIPP_P1CCTCR1_ENABLE_Pos)            /*!< 0x00000001 */
#define DCMIPP_P1CCTCR1_ENABLE              DCMIPP_P1CCTCR1_ENABLE_Msk                      /*!< Current ENABLE bit value */
#define DCMIPP_P1CCTCR1_LUM0_Pos            (9UL)
#define DCMIPP_P1CCTCR1_LUM0_Msk            (0x3FUL << DCMIPP_P1CCTCR1_LUM0_Pos)             /*!< 0x00007E00 */
#define DCMIPP_P1CCTCR1_LUM0                DCMIPP_P1CCTCR1_LUM0_Msk                        /*!< Current luminance increase for input luminance of 0 (increase is idle with LUMx = 16) */

/***************  Bit definition for DCMIPP_P1CCTCR2 register  ****************/
#define DCMIPP_P1CCTCR2_LUM4_Pos            (1UL)
#define DCMIPP_P1CCTCR2_LUM4_Msk            (0x3FUL << DCMIPP_P1CCTCR2_LUM4_Pos)             /*!< 0x0000007E */
#define DCMIPP_P1CCTCR2_LUM4                DCMIPP_P1CCTCR2_LUM4_Msk                        /*!< Current luminance increase for input luminance of 128 (increase is idle with LUMx = 16) */
#define DCMIPP_P1CCTCR2_LUM3_Pos            (9UL)
#define DCMIPP_P1CCTCR2_LUM3_Msk            (0x3FUL << DCMIPP_P1CCTCR2_LUM3_Pos)             /*!< 0x00007E00 */
#define DCMIPP_P1CCTCR2_LUM3                DCMIPP_P1CCTCR2_LUM3_Msk                        /*!< Current luminance increase for input luminance of 96 (increase is idle with LUMx = 16) */
#define DCMIPP_P1CCTCR2_LUM2_Pos            (17UL)
#define DCMIPP_P1CCTCR2_LUM2_Msk            (0x3FUL << DCMIPP_P1CCTCR2_LUM2_Pos)             /*!< 0x007E0000 */
#define DCMIPP_P1CCTCR2_LUM2                DCMIPP_P1CCTCR2_LUM2_Msk                        /*!< Current luminance increase for input luminance of 64 (increase is idle with LUMx = 16) */
#define DCMIPP_P1CCTCR2_LUM1_Pos            (25UL)
#define DCMIPP_P1CCTCR2_LUM1_Msk            (0x3FUL << DCMIPP_P1CCTCR2_LUM1_Pos)             /*!< 0x7E000000 */
#define DCMIPP_P1CCTCR2_LUM1                DCMIPP_P1CCTCR2_LUM1_Msk                        /*!< Current luminance increase for input luminance of 32 (increase is idle with LUMx = 16) */

/***************  Bit definition for DCMIPP_P1CCTCR3 register  ****************/
#define DCMIPP_P1CCTCR3_LUM8_Pos            (1UL)
#define DCMIPP_P1CCTCR3_LUM8_Msk            (0x3FUL << DCMIPP_P1CCTCR3_LUM8_Pos)             /*!< 0x0000007E */
#define DCMIPP_P1CCTCR3_LUM8                DCMIPP_P1CCTCR3_LUM8_Msk                        /*!< Luminance increase for input luminance of 256 (increase is idle with LUMx = 16) */
#define DCMIPP_P1CCTCR3_LUM7_Pos            (9UL)
#define DCMIPP_P1CCTCR3_LUM7_Msk            (0x3FUL << DCMIPP_P1CCTCR3_LUM7_Pos)             /*!< 0x00007E00 */
#define DCMIPP_P1CCTCR3_LUM7                DCMIPP_P1CCTCR3_LUM7_Msk                        /*!< Luminance increase for input luminance of 224 (increase is idle with LUMx = 16) */
#define DCMIPP_P1CCTCR3_LUM6_Pos            (17UL)
#define DCMIPP_P1CCTCR3_LUM6_Msk            (0x3FUL << DCMIPP_P1CCTCR3_LUM6_Pos)             /*!< 0x007E0000 */
#define DCMIPP_P1CCTCR3_LUM6                DCMIPP_P1CCTCR3_LUM6_Msk                        /*!< Luminance increase for input luminance of 192 (increase is idle with LUMx = 16) */
#define DCMIPP_P1CCTCR3_LUM5_Pos            (25UL)
#define DCMIPP_P1CCTCR3_LUM5_Msk            (0x3FUL << DCMIPP_P1CCTCR3_LUM5_Pos)             /*!< 0x7E000000 */
#define DCMIPP_P1CCTCR3_LUM5                DCMIPP_P1CCTCR3_LUM5_Msk                        /*!< Luminance increase for input luminance of 160 (increase is idle with LUMx = 16) */

/***************  Bit definition for DCMIPP_P1CFCTCR register  ****************/
#define DCMIPP_P1CFCTCR_FRATE_Pos           (0UL)
#define DCMIPP_P1CFCTCR_FRATE_Msk           (0x3UL << DCMIPP_P1CFCTCR_FRATE_Pos)             /*!< 0x00000003 */
#define DCMIPP_P1CFCTCR_FRATE               DCMIPP_P1CFCTCR_FRATE_Msk                       /*!< Frame capture rate control */
#define DCMIPP_P1CFCTCR_CPTMODE_Pos         (2UL)
#define DCMIPP_P1CFCTCR_CPTMODE_Msk         (0x1UL << DCMIPP_P1CFCTCR_CPTMODE_Pos)           /*!< 0x00000004 */
#define DCMIPP_P1CFCTCR_CPTMODE             DCMIPP_P1CFCTCR_CPTMODE_Msk                     /*!< Capture mode */
#define DCMIPP_P1CFCTCR_CPTREQ_Pos          (3UL)
#define DCMIPP_P1CFCTCR_CPTREQ_Msk          (0x1UL << DCMIPP_P1CFCTCR_CPTREQ_Pos)            /*!< 0x00000008 */
#define DCMIPP_P1CFCTCR_CPTREQ              DCMIPP_P1CFCTCR_CPTREQ_Msk                      /*!< Capture requested */

/***************  Bit definition for DCMIPP_P1CCRSTR register  ****************/
#define DCMIPP_P1CCRSTR_HSTART_Pos          (0UL)
#define DCMIPP_P1CCRSTR_HSTART_Msk          (0xFFFUL << DCMIPP_P1CCRSTR_HSTART_Pos)          /*!< 0x00000FFF */
#define DCMIPP_P1CCRSTR_HSTART              DCMIPP_P1CCRSTR_HSTART_Msk                      /*!< Current horizontal start, from 0 to 4094 pixels wide */
#define DCMIPP_P1CCRSTR_VSTART_Pos          (16UL)
#define DCMIPP_P1CCRSTR_VSTART_Msk          (0xFFFUL << DCMIPP_P1CCRSTR_VSTART_Pos)          /*!< 0x0FFF0000 */
#define DCMIPP_P1CCRSTR_VSTART              DCMIPP_P1CCRSTR_VSTART_Msk                      /*!< Current vertical start, from 0 to 4094 pixels high */

/***************  Bit definition for DCMIPP_P1CCRSZR register  ****************/
#define DCMIPP_P1CCRSZR_HSIZE_Pos           (0UL)
#define DCMIPP_P1CCRSZR_HSIZE_Msk           (0xFFFUL << DCMIPP_P1CCRSZR_HSIZE_Pos)           /*!< 0x00000FFF */
#define DCMIPP_P1CCRSZR_HSIZE               DCMIPP_P1CCRSZR_HSIZE_Msk                       /*!< Current horizontal size, from 0 to 4094 pixels wide */
#define DCMIPP_P1CCRSZR_VSIZE_Pos           (16UL)
#define DCMIPP_P1CCRSZR_VSIZE_Msk           (0xFFFUL << DCMIPP_P1CCRSZR_VSIZE_Pos)           /*!< 0x0FFF0000 */
#define DCMIPP_P1CCRSZR_VSIZE               DCMIPP_P1CCRSZR_VSIZE_Msk                       /*!< Current vertical size, from 0 to 4094 pixels high */
#define DCMIPP_P1CCRSZR_ENABLE_Pos          (31UL)
#define DCMIPP_P1CCRSZR_ENABLE_Msk          (0x1UL << DCMIPP_P1CCRSZR_ENABLE_Pos)            /*!< 0x80000000 */
#define DCMIPP_P1CCRSZR_ENABLE              DCMIPP_P1CCRSZR_ENABLE_Msk                      /*!< Current ENABLE bit value */

/****************  Bit definition for DCMIPP_P1CDCCR register  *****************/
#define DCMIPP_P1CDCCR_ENABLE_Pos           (0UL)
#define DCMIPP_P1CDCCR_ENABLE_Msk           (0x1UL << DCMIPP_P1CDCCR_ENABLE_Pos)            /*!< 0x00000001 */
#define DCMIPP_P1CDCCR_ENABLE               DCMIPP_P1CDCCR_ENABLE_Msk                       /*!< Decimation enable */
#define DCMIPP_P1CDCCR_HDEC_Pos             (1UL)
#define DCMIPP_P1CDCCR_HDEC_Msk             (0x3UL << DCMIPP_P1CDCCR_HDEC_Pos)               /*!< 0x00000006 */
#define DCMIPP_P1CDCCR_HDEC                 DCMIPP_P1CDCCR_HDEC_Msk                         /*!< Horizontal decimation ratio */
#define DCMIPP_P1CDCCR_VDEC_Pos             (3UL)
#define DCMIPP_P1CDCCR_VDEC_Msk             (0x3UL << DCMIPP_P1CDCCR_VDEC_Pos)               /*!< 0x00000018 */
#define DCMIPP_P1CDCCR_VDEC                 DCMIPP_P1CDCCR_VDEC_Msk                         /*!< Vertical decimation ratio */

/****************  Bit definition for DCMIPP_P1CDSCR register  ****************/
#define DCMIPP_P1CDSCR_HDIV_Pos             (0UL)
#define DCMIPP_P1CDSCR_HDIV_Msk             (0x3FFUL << DCMIPP_P1CDSCR_HDIV_Pos)             /*!< 0x000003FF */
#define DCMIPP_P1CDSCR_HDIV                 DCMIPP_P1CDSCR_HDIV_Msk                         /*!< Current horizontal division factor, from 128 (8x) to 1023 (1x) */
#define DCMIPP_P1CDSCR_VDIV_Pos             (16UL)
#define DCMIPP_P1CDSCR_VDIV_Msk             (0x3FFUL << DCMIPP_P1CDSCR_VDIV_Pos)             /*!< 0x03FF0000 */
#define DCMIPP_P1CDSCR_VDIV                 DCMIPP_P1CDSCR_VDIV_Msk                         /*!< Current vertical division factor, from 128 (8x) to 1023 (1x) */
#define DCMIPP_P1CDSCR_ENABLE_Pos           (31UL)
#define DCMIPP_P1CDSCR_ENABLE_Msk           (0x1UL << DCMIPP_P1CDSCR_ENABLE_Pos)             /*!< 0x80000000 */
#define DCMIPP_P1CDSCR_ENABLE               DCMIPP_P1CDSCR_ENABLE_Msk                       /*!< Current value of the bit ENABLE */

/**************  Bit definition for DCMIPP_P1CDSRTIOR register  ***************/
#define DCMIPP_P1CDSRTIOR_HRATIO_Pos        (0UL)
#define DCMIPP_P1CDSRTIOR_HRATIO_Msk        (0xFFFFUL << DCMIPP_P1CDSRTIOR_HRATIO_Pos)       /*!< 0x0000FFFF */
#define DCMIPP_P1CDSRTIOR_HRATIO            DCMIPP_P1CDSRTIOR_HRATIO_Msk                    /*!< Current horizontal ratio, from 8192 (1x) to 65535 (8x) */
#define DCMIPP_P1CDSRTIOR_VRATIO_Pos        (16UL)
#define DCMIPP_P1CDSRTIOR_VRATIO_Msk        (0xFFFFUL << DCMIPP_P1CDSRTIOR_VRATIO_Pos)       /*!< 0xFFFF0000 */
#define DCMIPP_P1CDSRTIOR_VRATIO            DCMIPP_P1CDSRTIOR_VRATIO_Msk                    /*!< Current vertical ratio, from 8192 (1x) to 65535 (8x) */

/***************  Bit definition for DCMIPP_P1CDSSZR register  ****************/
#define DCMIPP_P1CDSSZR_HSIZE_Pos           (0UL)
#define DCMIPP_P1CDSSZR_HSIZE_Msk           (0xFFFUL << DCMIPP_P1CDSSZR_HSIZE_Pos)           /*!< 0x00000FFF */
#define DCMIPP_P1CDSSZR_HSIZE               DCMIPP_P1CDSSZR_HSIZE_Msk                       /*!< Current horizontal size, from 0 to 4094 pixels wide */
#define DCMIPP_P1CDSSZR_VSIZE_Pos           (16UL)
#define DCMIPP_P1CDSSZR_VSIZE_Msk           (0xFFFUL << DCMIPP_P1CDSSZR_VSIZE_Pos)           /*!< 0x0FFF0000 */
#define DCMIPP_P1CDSSZR_VSIZE               DCMIPP_P1CDSSZR_VSIZE_Msk                       /*!< Current vertical size, from 0 to 4094 pixels high */

/****************  Bit definition for DCMIPP_P1CPPCR register  ****************/
#define DCMIPP_P1CPPCR_FORMAT_Pos           (0UL)
#define DCMIPP_P1CPPCR_FORMAT_Msk           (0xFUL << DCMIPP_P1CPPCR_FORMAT_Pos)             /*!< 0x0000000F */
#define DCMIPP_P1CPPCR_FORMAT               DCMIPP_P1CPPCR_FORMAT_Msk                       /*!< Memory format */
#define DCMIPP_P1CPPCR_SWAPRB_Pos           (4UL)
#define DCMIPP_P1CPPCR_SWAPRB_Msk           (0x1UL << DCMIPP_P1CPPCR_SWAPRB_Pos)             /*!< 0x00000010 */
#define DCMIPP_P1CPPCR_SWAPRB               DCMIPP_P1CPPCR_SWAPRB_Msk                       /*!< Swaps R-vs-B components if RGB, and U-vs-V components if YUV */
#define DCMIPP_P1CPPCR_LINEMULT_Pos         (13UL)
#define DCMIPP_P1CPPCR_LINEMULT_Msk         (0x7UL << DCMIPP_P1CPPCR_LINEMULT_Pos)           /*!< 0x0000E000 */
#define DCMIPP_P1CPPCR_LINEMULT             DCMIPP_P1CPPCR_LINEMULT_Msk                     /*!< Amount of capture completed lines for LINE Event and Interrupt */

/**************  Bit definition for DCMIPP_P1CPPM0AR1 register  ***************/
#define DCMIPP_P1CPPM0AR1_M0A_Pos           (0UL)
#define DCMIPP_P1CPPM0AR1_M0A_Msk           (0xFFFFFFFFUL << DCMIPP_P1CPPM0AR1_M0A_Pos)      /*!< 0xFFFFFFFF */
#define DCMIPP_P1CPPM0AR1_M0A               DCMIPP_P1CPPM0AR1_M0A_Msk                       /*!< Memory0 address */

/***************  Bit definition for DCMIPP_P1CPPM0PR register  ***************/
#define DCMIPP_P1CPPM0PR_PITCH_Pos          (0UL)
#define DCMIPP_P1CPPM0PR_PITCH_Msk          (0x7FFFUL << DCMIPP_P1CPPM0PR_PITCH_Pos)         /*!< 0x00007FFF */
#define DCMIPP_P1CPPM0PR_PITCH              DCMIPP_P1CPPM0PR_PITCH_Msk                      /*!< Number of bytes between the address of two consecutive lines */

/**************  Bit definition for DCMIPP_P1CPPM1AR1 register  ***************/
#define DCMIPP_P1CPPM1AR1_M1A_Pos           (0UL)
#define DCMIPP_P1CPPM1AR1_M1A_Msk           (0xFFFFFFFFUL << DCMIPP_P1CPPM1AR1_M1A_Pos)      /*!< 0xFFFFFFFF */
#define DCMIPP_P1CPPM1AR1_M1A               DCMIPP_P1CPPM1AR1_M1A_Msk                       /*!< Memory1 address */

/***************  Bit definition for DCMIPP_P1CPPM1PR register  ***************/
#define DCMIPP_P1CPPM1PR_PITCH_Pos          (0UL)
#define DCMIPP_P1CPPM1PR_PITCH_Msk          (0x7FFFUL << DCMIPP_P1CPPM1PR_PITCH_Pos)         /*!< 0x00007FFF */
#define DCMIPP_P1CPPM1PR_PITCH              DCMIPP_P1CPPM1PR_PITCH_Msk                      /*!< Number of bytes between the address of two consecutive lines */

/**************  Bit definition for DCMIPP_P1CPPM2AR1 register  ***************/
#define DCMIPP_P1CPPM2AR1_M2A_Pos           (0UL)
#define DCMIPP_P1CPPM2AR1_M2A_Msk           (0xFFFFFFFFUL << DCMIPP_P1CPPM2AR1_M2A_Pos)      /*!< 0xFFFFFFFF */
#define DCMIPP_P1CPPM2AR1_M2A               DCMIPP_P1CPPM2AR1_M2A_Msk                       /*!< Memory 2 address */

/****************  Bit definition for DCMIPP_P2FSCR register  *****************/
#define DCMIPP_P2FSCR_DTIDA_Pos             (0UL)
#define DCMIPP_P2FSCR_DTIDA_Msk             (0x3FUL << DCMIPP_P2FSCR_DTIDA_Pos)              /*!< 0x0000003F */
#define DCMIPP_P2FSCR_DTIDA                 DCMIPP_P2FSCR_DTIDA_Msk                         /*!< Data type ID */
#define DCMIPP_P2FSCR_VC_Pos                (19UL)
#define DCMIPP_P2FSCR_VC_Msk                (0x3UL << DCMIPP_P2FSCR_VC_Pos)                  /*!< 0x00180000 */
#define DCMIPP_P2FSCR_VC                    DCMIPP_P2FSCR_VC_Msk                            /*!< Flow selection mode */
#define DCMIPP_P2FSCR_FDTF_Pos              (24UL)
#define DCMIPP_P2FSCR_FDTF_Msk              (0x3FUL << DCMIPP_P2FSCR_FDTF_Pos)               /*!< 0x3F000000 */
#define DCMIPP_P2FSCR_FDTF                  DCMIPP_P2FSCR_FDTF_Msk                          /*!< Force Data type format */
#define DCMIPP_P2FSCR_FDTFEN_Pos            (30UL)
#define DCMIPP_P2FSCR_FDTFEN_Msk            (0x1UL << DCMIPP_P2FSCR_FDTFEN_Pos)              /*!< 0x40000000 */
#define DCMIPP_P2FSCR_FDTFEN                DCMIPP_P2FSCR_FDTFEN_Msk                        /*!< Force Data type format enable */
#define DCMIPP_P2FSCR_PIPEN_Pos             (31UL)
#define DCMIPP_P2FSCR_PIPEN_Msk             (0x1UL << DCMIPP_P2FSCR_PIPEN_Pos)               /*!< 0x80000000 */
#define DCMIPP_P2FSCR_PIPEN                 DCMIPP_P2FSCR_PIPEN_Msk                         /*!< Activation of PipeN */

/****************  Bit definition for DCMIPP_P2FCTCR register  ****************/
#define DCMIPP_P2FCTCR_FRATE_Pos            (0UL)
#define DCMIPP_P2FCTCR_FRATE_Msk            (0x3UL << DCMIPP_P2FCTCR_FRATE_Pos)              /*!< 0x00000003 */
#define DCMIPP_P2FCTCR_FRATE                DCMIPP_P2FCTCR_FRATE_Msk                        /*!< Frame capture rate control */
#define DCMIPP_P2FCTCR_CPTMODE_Pos          (2UL)
#define DCMIPP_P2FCTCR_CPTMODE_Msk          (0x1UL << DCMIPP_P2FCTCR_CPTMODE_Pos)            /*!< 0x00000004 */
#define DCMIPP_P2FCTCR_CPTMODE              DCMIPP_P2FCTCR_CPTMODE_Msk                      /*!< Capture mode */
#define DCMIPP_P2FCTCR_CPTREQ_Pos           (3UL)
#define DCMIPP_P2FCTCR_CPTREQ_Msk           (0x1UL << DCMIPP_P2FCTCR_CPTREQ_Pos)             /*!< 0x00000008 */
#define DCMIPP_P2FCTCR_CPTREQ               DCMIPP_P2FCTCR_CPTREQ_Msk                       /*!< Capture requested */

/****************  Bit definition for DCMIPP_P2CRSTR register  ****************/
#define DCMIPP_P2CRSTR_HSTART_Pos           (0UL)
#define DCMIPP_P2CRSTR_HSTART_Msk           (0xFFFUL << DCMIPP_P2CRSTR_HSTART_Pos)           /*!< 0x00000FFF */
#define DCMIPP_P2CRSTR_HSTART               DCMIPP_P2CRSTR_HSTART_Msk                       /*!< Horizontal start, from 0 to 4094 pixels wide */
#define DCMIPP_P2CRSTR_VSTART_Pos           (16UL)
#define DCMIPP_P2CRSTR_VSTART_Msk           (0xFFFUL << DCMIPP_P2CRSTR_VSTART_Pos)           /*!< 0x0FFF0000 */
#define DCMIPP_P2CRSTR_VSTART               DCMIPP_P2CRSTR_VSTART_Msk                       /*!< Vertical start, from 0 to 4094 pixels high */

/****************  Bit definition for DCMIPP_P2CRSZR register  ****************/
#define DCMIPP_P2CRSZR_HSIZE_Pos            (0UL)
#define DCMIPP_P2CRSZR_HSIZE_Msk            (0xFFFUL << DCMIPP_P2CRSZR_HSIZE_Pos)            /*!< 0x00000FFF */
#define DCMIPP_P2CRSZR_HSIZE                DCMIPP_P2CRSZR_HSIZE_Msk                        /*!< Horizontal size, from 0 to 4094 pixels wide */
#define DCMIPP_P2CRSZR_VSIZE_Pos            (16UL)
#define DCMIPP_P2CRSZR_VSIZE_Msk            (0xFFFUL << DCMIPP_P2CRSZR_VSIZE_Pos)            /*!< 0x0FFF0000 */
#define DCMIPP_P2CRSZR_VSIZE                DCMIPP_P2CRSZR_VSIZE_Msk                        /*!< Vertical size, from 0 to 4094 pixels high */
#define DCMIPP_P2CRSZR_ENABLE_Pos           (31UL)
#define DCMIPP_P2CRSZR_ENABLE_Msk           (0x1UL << DCMIPP_P2CRSZR_ENABLE_Pos)             /*!< 0x80000000 */
#define DCMIPP_P2CRSZR_ENABLE               DCMIPP_P2CRSZR_ENABLE_Msk                       /*!<  */

/****************  Bit definition for DCMIPP_P2DCCR register  *****************/
#define DCMIPP_P2DCCR_ENABLE_Pos            (0UL)
#define DCMIPP_P2DCCR_ENABLE_Msk            (0x1UL << DCMIPP_P2DCCR_ENABLE_Pos)             /*!< 0x00000001 */
#define DCMIPP_P2DCCR_ENABLE                DCMIPP_P2DCCR_ENABLE_Msk                        /*!< Decimation enable */
#define DCMIPP_P2DCCR_HDEC_Pos              (1UL)
#define DCMIPP_P2DCCR_HDEC_Msk              (0x3UL << DCMIPP_P2DCCR_HDEC_Pos)               /*!< 0x00000006 */
#define DCMIPP_P2DCCR_HDEC                  DCMIPP_P2DCCR_HDEC_Msk                          /*!< Horizontal decimation ratio */
#define DCMIPP_P2DCCR_VDEC_Pos              (3UL)
#define DCMIPP_P2DCCR_VDEC_Msk              (0x3UL << DCMIPP_P2DCCR_VDEC_Pos)               /*!< 0x00000018 */
#define DCMIPP_P2DCCR_VDEC                  DCMIPP_P2DCCR_VDEC_Msk                          /*!< Vertical decimation ratio */

/****************  Bit definition for DCMIPP_P2DSCR register  *****************/
#define DCMIPP_P2DSCR_HDIV_Pos              (0UL)
#define DCMIPP_P2DSCR_HDIV_Msk              (0x3FFUL << DCMIPP_P2DSCR_HDIV_Pos)              /*!< 0x000003FF */
#define DCMIPP_P2DSCR_HDIV                  DCMIPP_P2DSCR_HDIV_Msk                          /*!< Horizontal division factor, from 128 (8x) to 1023 (1x) */
#define DCMIPP_P2DSCR_VDIV_Pos              (16UL)
#define DCMIPP_P2DSCR_VDIV_Msk              (0x3FFUL << DCMIPP_P2DSCR_VDIV_Pos)              /*!< 0x03FF0000 */
#define DCMIPP_P2DSCR_VDIV                  DCMIPP_P2DSCR_VDIV_Msk                          /*!< Vertical division factor, from 128 (8x) to 1023 (1x) */
#define DCMIPP_P2DSCR_ENABLE_Pos            (31UL)
#define DCMIPP_P2DSCR_ENABLE_Msk            (0x1UL << DCMIPP_P2DSCR_ENABLE_Pos)              /*!< 0x80000000 */
#define DCMIPP_P2DSCR_ENABLE                DCMIPP_P2DSCR_ENABLE_Msk                        /*!<  */

/***************  Bit definition for DCMIPP_P2DSRTIOR register  ***************/
#define DCMIPP_P2DSRTIOR_HRATIO_Pos         (0UL)
#define DCMIPP_P2DSRTIOR_HRATIO_Msk         (0xFFFFUL << DCMIPP_P2DSRTIOR_HRATIO_Pos)        /*!< 0x0000FFFF */
#define DCMIPP_P2DSRTIOR_HRATIO             DCMIPP_P2DSRTIOR_HRATIO_Msk                     /*!< Horizontal ratio, from 8192 (1x) to 65535 (8x) */
#define DCMIPP_P2DSRTIOR_VRATIO_Pos         (16UL)
#define DCMIPP_P2DSRTIOR_VRATIO_Msk         (0xFFFFUL << DCMIPP_P2DSRTIOR_VRATIO_Pos)        /*!< 0xFFFF0000 */
#define DCMIPP_P2DSRTIOR_VRATIO             DCMIPP_P2DSRTIOR_VRATIO_Msk                     /*!< Vertical ratio, from 8192 (1x) to 65535 (8x) */

/****************  Bit definition for DCMIPP_P2DSSZR register  ****************/
#define DCMIPP_P2DSSZR_HSIZE_Pos            (0UL)
#define DCMIPP_P2DSSZR_HSIZE_Msk            (0xFFFUL << DCMIPP_P2DSSZR_HSIZE_Pos)            /*!< 0x00000FFF */
#define DCMIPP_P2DSSZR_HSIZE                DCMIPP_P2DSSZR_HSIZE_Msk                        /*!< Horizontal size, from 0 to 4094 pixels wide */
#define DCMIPP_P2DSSZR_VSIZE_Pos            (16UL)
#define DCMIPP_P2DSSZR_VSIZE_Msk            (0xFFFUL << DCMIPP_P2DSSZR_VSIZE_Pos)            /*!< 0x0FFF0000 */
#define DCMIPP_P2DSSZR_VSIZE                DCMIPP_P2DSSZR_VSIZE_Msk                        /*!< Vertical size, from 0 to 4094 pixels high */

/****************  Bit definition for DCMIPP_P2GMCR register  *****************/
#define DCMIPP_P2GMCR_ENABLE_Pos            (0UL)
#define DCMIPP_P2GMCR_ENABLE_Msk            (0x1UL << DCMIPP_P2GMCR_ENABLE_Pos)              /*!< 0x00000001 */
#define DCMIPP_P2GMCR_ENABLE                DCMIPP_P2GMCR_ENABLE_Msk                        /*!<  */

/***************  Bit definition for DCMIPP_P2CMRICR register  ***************/
#define DCMIPP_P2CMRICR_ROILSZ_Pos          (0UL)
#define DCMIPP_P2CMRICR_ROILSZ_Msk          (0x3UL << DCMIPP_P2CMRICR_ROILSZ_Pos)           /*!< 0x00000003 */
#define DCMIPP_P2CMRICR_ROILSZ              DCMIPP_P2CMRICR_ROILSZ_Msk                      /*!< Region of interest line size width */
#define DCMIPP_P2CMRICR_ROI1EN_Pos          (16UL)
#define DCMIPP_P2CMRICR_ROI1EN_Msk          (0x1UL << DCMIPP_P2CMRICR_ROI1EN_Pos)           /*!< 0x00010000 */
#define DCMIPP_P2CMRICR_ROI1EN              DCMIPP_P2CMRICR_ROI1EN_Msk                      /*!< Region Of Interest 1 Enable */
#define DCMIPP_P2CMRICR_ROI2EN_Pos          (17UL)
#define DCMIPP_P2CMRICR_ROI2EN_Msk          (0x1UL << DCMIPP_P2CMRICR_ROI2EN_Pos)           /*!< 0x00020000 */
#define DCMIPP_P2CMRICR_ROI2EN              DCMIPP_P2CMRICR_ROI2EN_Msk                      /*!< Region Of Interest 2 Enable */
#define DCMIPP_P2CMRICR_ROI3EN_Pos          (18UL)
#define DCMIPP_P2CMRICR_ROI3EN_Msk          (0x1UL << DCMIPP_P2CMRICR_ROI3EN_Pos)           /*!< 0x00040000 */
#define DCMIPP_P2CMRICR_ROI3EN              DCMIPP_P2CMRICR_ROI3EN_Msk                      /*!< Region Of Interest 3 Enable */
#define DCMIPP_P2CMRICR_ROI4EN_Pos          (19UL)
#define DCMIPP_P2CMRICR_ROI4EN_Msk          (0x1UL << DCMIPP_P2CMRICR_ROI4EN_Pos)           /*!< 0x00080000 */
#define DCMIPP_P2CMRICR_ROI4EN              DCMIPP_P2CMRICR_ROI4EN_Msk                      /*!< Region Of Interest 4 Enable */
#define DCMIPP_P2CMRICR_ROI5EN_Pos          (20UL)
#define DCMIPP_P2CMRICR_ROI5EN_Msk          (0x1UL << DCMIPP_P2CMRICR_ROI5EN_Pos)           /*!< 0x00100000 */
#define DCMIPP_P2CMRICR_ROI5EN              DCMIPP_P2CMRICR_ROI5EN_Msk                      /*!< Region Of Interest 5 Enable */
#define DCMIPP_P2CMRICR_ROI6EN_Pos          (21UL)
#define DCMIPP_P2CMRICR_ROI6EN_Msk          (0x1UL << DCMIPP_P2CMRICR_ROI6EN_Pos)           /*!< 0x00200000 */
#define DCMIPP_P2CMRICR_ROI6EN              DCMIPP_P2CMRICR_ROI6EN_Msk                      /*!< Region Of Interest 6 Enable */
#define DCMIPP_P2CMRICR_ROI7EN_Pos          (22UL)
#define DCMIPP_P2CMRICR_ROI7EN_Msk          (0x1UL << DCMIPP_P2CMRICR_ROI7EN_Pos)           /*!< 0x00400000 */
#define DCMIPP_P2CMRICR_ROI7EN              DCMIPP_P2CMRICR_ROI7EN_Msk                      /*!< Region Of Interest 7 Enable */
#define DCMIPP_P2CMRICR_ROI8EN_Pos          (23UL)
#define DCMIPP_P2CMRICR_ROI8EN_Msk          (0x1UL << DCMIPP_P2CMRICR_ROI8EN_Pos)           /*!< 0x00800000 */
#define DCMIPP_P2CMRICR_ROI8EN              DCMIPP_P2CMRICR_ROI8EN_Msk                      /*!< Region Of Interest 8 Enable */

/***************  Bit definition for DCMIPP_P2RIxCR1 register  ***************/
#define DCMIPP_P2RIxCR1_HSTART_Pos          (0UL)
#define DCMIPP_P2RIxCR1_HSTART_Msk          (0xFFFUL << DCMIPP_P2RIxCR1_HSTART_Pos)        /*!< 0x00000FFF */
#define DCMIPP_P2RIxCR1_HSTART              DCMIPP_P2RIxCR1_HSTART_Msk                     /*!< Horizontal start */
#define DCMIPP_P2RIxCR1_CLB_Pos             (12UL)
#define DCMIPP_P2RIxCR1_CLB_Msk             (0x3UL << DCMIPP_P2RIxCR1_CLB_Pos)             /*!< 0x00003000 */
#define DCMIPP_P2RIxCR1_CLB                 DCMIPP_P2RIxCR1_CLB_Msk                        /*!< Color line blue */
#define DCMIPP_P2RIxCR1_CLG_Pos             (14UL)
#define DCMIPP_P2RIxCR1_CLG_Msk             (0x3UL << DCMIPP_P2RIxCR1_CLG_Pos)             /*!< 0x0000C000 */
#define DCMIPP_P2RIxCR1_CLG                 DCMIPP_P2RIxCR1_CLG_Msk                        /*!< Color line green */
#define DCMIPP_P2RIxCR1_VSTART_Pos          (16UL)
#define DCMIPP_P2RIxCR1_VSTART_Msk          (0xFFFUL << DCMIPP_P2RIxCR1_VSTART_Pos)        /*!< 0x0FFF0000 */
#define DCMIPP_P2RIxCR1_VSTART              DCMIPP_P2RIxCR1_VSTART_Msk                     /*!< Vertical start */
#define DCMIPP_P2RIxCR1_CLR_Pos             (28UL)
#define DCMIPP_P2RIxCR1_CLR_Msk             (0x3UL << DCMIPP_P2RIxCR1_CLR_Pos)             /*!< 0x30000000 */
#define DCMIPP_P2RIxCR1_CLR                 DCMIPP_P2RIxCR1_CLR_Msk                        /*!< Color line red */

/***************  Bit definition for DCMIPP_P2RIxCR2 register  ***************/
#define DCMIPP_P2RIxCR2_VSIZE_Pos           (0UL)
#define DCMIPP_P2RIxCR2_VSIZE_Msk           (0xFFFUL << DCMIPP_P2RIxCR2_VSIZE_Pos)        /*!<  0x00000FFF */
#define DCMIPP_P2RIxCR2_VSIZE               DCMIPP_P2RIxCR2_VSIZE_Msk                     /*!< Vertical Size */
#define DCMIPP_P2RIxCR2_HSIZE_Pos           (16UL)
#define DCMIPP_P2RIxCR2_HSIZE_Msk           (0xFFFUL << DCMIPP_P2RIxCR2_HSIZE_Pos)        /*!<  0x07FF8000 */
#define DCMIPP_P2RIxCR2_HSIZE               DCMIPP_P2RIxCR2_HSIZE_Msk                     /*!< Horizontal Size */

/****************  Bit definition for DCMIPP_P2PPCR register  *****************/
#define DCMIPP_P2PPCR_FORMAT_Pos            (0UL)
#define DCMIPP_P2PPCR_FORMAT_Msk            (0xFUL << DCMIPP_P2PPCR_FORMAT_Pos)              /*!< 0x0000000F */
#define DCMIPP_P2PPCR_FORMAT                DCMIPP_P2PPCR_FORMAT_Msk                         /*!< Memory format (only coplanar formats are supported in Pipe2) */
#define DCMIPP_P2PPCR_SWAPRB_Pos            (4UL)
#define DCMIPP_P2PPCR_SWAPRB_Msk            (0x1UL << DCMIPP_P2PPCR_SWAPRB_Pos)              /*!< 0x00000010 */
#define DCMIPP_P2PPCR_SWAPRB                DCMIPP_P2PPCR_SWAPRB_Msk                         /*!< Swaps R-vs-B components if RGB, and if YUV, swaps U-vs-V components */
#define DCMIPP_P2PPCR_LINEMULT_Pos          (13UL)
#define DCMIPP_P2PPCR_LINEMULT_Msk          (0x7UL << DCMIPP_P2PPCR_LINEMULT_Pos)            /*!< 0x0000E000 */
#define DCMIPP_P2PPCR_LINEMULT              DCMIPP_P2PPCR_LINEMULT_Msk                       /*!< Amount of capture completed lines for LINE Event and Interrupt */
#define DCMIPP_P2PPCR_DBM_Pos               (16UL)
#define DCMIPP_P2PPCR_DBM_Msk               (0x1UL << DCMIPP_P2PPCR_DBM_Pos)                 /*!< 0x00010000 */
#define DCMIPP_P2PPCR_DBM                   DCMIPP_P2PPCR_DBM_Msk                            /*!< Double buffer mode */
#define DCMIPP_P2PPCR_LMAWM_Pos             (17UL)
#define DCMIPP_P2PPCR_LMAWM_Msk             (0x7UL << DCMIPP_P2PPCR_LMAWM_Pos)               /*!< 0x000E0000 */
#define DCMIPP_P2PPCR_LMAWM                 DCMIPP_P2PPCR_LMAWM_Msk                          /*!< Line multi address wrapping modulo */
#define DCMIPP_P2PPCR_LMAWE_Pos             (20UL)
#define DCMIPP_P2PPCR_LMAWE_Msk             (0x7UL << DCMIPP_P2PPCR_LMAWE_Pos)               /*!< 0x00100000 */
#define DCMIPP_P2PPCR_LMAWE                 DCMIPP_P2PPCR_LMAWE_Msk                          /*!< Line multi address wrapping enable */

/***************  Bit definition for DCMIPP_P2PPM0AR1 register  ***************/
#define DCMIPP_P2PPM0AR1_M0A_Pos            (0UL)
#define DCMIPP_P2PPM0AR1_M0A_Msk            (0xFFFFFFFFUL << DCMIPP_P2PPM0AR1_M0A_Pos)       /*!< 0xFFFFFFFF */
#define DCMIPP_P2PPM0AR1_M0A                DCMIPP_P2PPM0AR1_M0A_Msk                        /*!< Memory0 address register 1 */

/***************  Bit definition for DCMIPP_P2PPM0AR2 register  ***************/
#define DCMIPP_P2PPM0AR2_M0A_Pos            (0UL)
#define DCMIPP_P2PPM0AR2_M0A_Msk            (0xFFFFFFFFUL << DCMIPP_P2PPM0AR2_M0A_Pos)       /*!< 0xFFFFFFFF */
#define DCMIPP_P2PPM0AR2_M0A                DCMIPP_P2PPM0AR2_M0A_Msk                        /*!< Memory0 address register 2*/

/***************  Bit definition for DCMIPP_P2PPM0PR register  ****************/
#define DCMIPP_P2PPM0PR_PITCH_Pos           (0UL)
#define DCMIPP_P2PPM0PR_PITCH_Msk           (0x7FFFUL << DCMIPP_P2PPM0PR_PITCH_Pos)          /*!< 0x00007FFF */
#define DCMIPP_P2PPM0PR_PITCH               DCMIPP_P2PPM0PR_PITCH_Msk                       /*!< Number of bytes between the address of two consecutive lines */

/***************  Bit definition for DCMIPP_P2PPM0PR register  ****************/
#define DCMIPP_P2STM0AR_Pos                 (0UL)
#define DCMIPP_P2STM0AR_Msk                 (0xFFFFFFFFUL << DCMIPP_P2STM0AR_Pos)           /*!< 0xFFFFFFFF */
#define DCMIPP_P2STM0AR                     DCMIPP_P2STM0AR_Msk                             /*!< Pipe2 status Memory0 address register */

/*****************  Bit definition for DCMIPP_P2IER register  *****************/
#define DCMIPP_P2IER_LINEIE_Pos             (0UL)
#define DCMIPP_P2IER_LINEIE_Msk             (0x1UL << DCMIPP_P2IER_LINEIE_Pos)               /*!< 0x00000001 */
#define DCMIPP_P2IER_LINEIE                 DCMIPP_P2IER_LINEIE_Msk                         /*!< Multi-line capture completed interrupt enable */
#define DCMIPP_P2IER_FRAMEIE_Pos            (1UL)
#define DCMIPP_P2IER_FRAMEIE_Msk            (0x1UL << DCMIPP_P2IER_FRAMEIE_Pos)              /*!< 0x00000002 */
#define DCMIPP_P2IER_FRAMEIE                DCMIPP_P2IER_FRAMEIE_Msk                        /*!< Frame capture completed interrupt enable */
#define DCMIPP_P2IER_VSYNCIE_Pos            (2UL)
#define DCMIPP_P2IER_VSYNCIE_Msk            (0x1UL << DCMIPP_P2IER_VSYNCIE_Pos)              /*!< 0x00000004 */
#define DCMIPP_P2IER_VSYNCIE                DCMIPP_P2IER_VSYNCIE_Msk                        /*!< VSYNC interrupt enable */
#define DCMIPP_P2IER_OVRIE_Pos              (7UL)
#define DCMIPP_P2IER_OVRIE_Msk              (0x1UL << DCMIPP_P2IER_OVRIE_Pos)                /*!< 0x00000080 */
#define DCMIPP_P2IER_OVRIE                  DCMIPP_P2IER_OVRIE_Msk                          /*!< Overrun interrupt enable */

/*****************  Bit definition for DCMIPP_P2SR register  ******************/
#define DCMIPP_P2SR_LINEF_Pos               (0UL)
#define DCMIPP_P2SR_LINEF_Msk               (0x1UL << DCMIPP_P2SR_LINEF_Pos)                 /*!< 0x00000001 */
#define DCMIPP_P2SR_LINEF                   DCMIPP_P2SR_LINEF_Msk                           /*!< Multi-line capture completed raw interrupt status */
#define DCMIPP_P2SR_FRAMEF_Pos              (1UL)
#define DCMIPP_P2SR_FRAMEF_Msk              (0x1UL << DCMIPP_P2SR_FRAMEF_Pos)                /*!< 0x00000002 */
#define DCMIPP_P2SR_FRAMEF                  DCMIPP_P2SR_FRAMEF_Msk                          /*!< Frame capture completed raw interrupt status */
#define DCMIPP_P2SR_VSYNCF_Pos              (2UL)
#define DCMIPP_P2SR_VSYNCF_Msk              (0x1UL << DCMIPP_P2SR_VSYNCF_Pos)                /*!< 0x00000004 */
#define DCMIPP_P2SR_VSYNCF                  DCMIPP_P2SR_VSYNCF_Msk                          /*!< VSYNC raw interrupt status */
#define DCMIPP_P2SR_OVRF_Pos                (7UL)
#define DCMIPP_P2SR_OVRF_Msk                (0x1UL << DCMIPP_P2SR_OVRF_Pos)                  /*!< 0x00000080 */
#define DCMIPP_P2SR_OVRF                    DCMIPP_P2SR_OVRF_Msk                            /*!< Overrun raw interrupt status */
#define DCMIPP_P2SR_LSTLINE_Pos             (16UL)
#define DCMIPP_P2SR_LSTLINE_Msk             (0x1UL << DCMIPP_P2SR_LSTLINE_Pos)               /*!< 0x00010000 */
#define DCMIPP_P2SR_LSTLINE                 DCMIPP_P2SR_LSTLINE_Msk                         /*!< Last line LSB bit, sampled at frame capture complete event */
#define DCMIPP_P2SR_LSTFRM_Pos              (17UL)
#define DCMIPP_P2SR_LSTFRM_Msk              (0x1UL << DCMIPP_P2SR_LSTFRM_Pos)                /*!< 0x00020000 */
#define DCMIPP_P2SR_LSTFRM                  DCMIPP_P2SR_LSTFRM_Msk                          /*!< Last frame LSB bit, sampled at frame capture complete event */
#define DCMIPP_P2SR_CPTACT_Pos              (23UL)
#define DCMIPP_P2SR_CPTACT_Msk              (0x1UL << DCMIPP_P2SR_CPTACT_Pos)                /*!< 0x00800000 */
#define DCMIPP_P2SR_CPTACT                  DCMIPP_P2SR_CPTACT_Msk                          /*!< Capture immediate status */

/*****************  Bit definition for DCMIPP_P2FCR register  *****************/
#define DCMIPP_P2FCR_CLINEF_Pos             (0UL)
#define DCMIPP_P2FCR_CLINEF_Msk             (0x1UL << DCMIPP_P2FCR_CLINEF_Pos)               /*!< 0x00000001 */
#define DCMIPP_P2FCR_CLINEF                 DCMIPP_P2FCR_CLINEF_Msk                         /*!< Multi-line capture complete interrupt status clear */
#define DCMIPP_P2FCR_CFRAMEF_Pos            (1UL)
#define DCMIPP_P2FCR_CFRAMEF_Msk            (0x1UL << DCMIPP_P2FCR_CFRAMEF_Pos)              /*!< 0x00000002 */
#define DCMIPP_P2FCR_CFRAMEF                DCMIPP_P2FCR_CFRAMEF_Msk                        /*!< Frame capture complete interrupt status clear */
#define DCMIPP_P2FCR_CVSYNCF_Pos            (2UL)
#define DCMIPP_P2FCR_CVSYNCF_Msk            (0x1UL << DCMIPP_P2FCR_CVSYNCF_Pos)              /*!< 0x00000004 */
#define DCMIPP_P2FCR_CVSYNCF                DCMIPP_P2FCR_CVSYNCF_Msk                        /*!< Vertical synchronization interrupt status clear */
#define DCMIPP_P2FCR_COVRF_Pos              (7UL)
#define DCMIPP_P2FCR_COVRF_Msk              (0x1UL << DCMIPP_P2FCR_COVRF_Pos)                /*!< 0x00000080 */
#define DCMIPP_P2FCR_COVRF                  DCMIPP_P2FCR_COVRF_Msk                          /*!< Overrun interrupt status clear */

/****************  Bit definition for DCMIPP_P2CFSCR register  ****************/
#define DCMIPP_P2CFSCR_DTID_Pos             (0UL)
#define DCMIPP_P2CFSCR_DTID_Msk             (0x3FUL << DCMIPP_P2CFSCR_DTID_Pos)              /*!< 0x0000003F */
#define DCMIPP_P2CFSCR_DTID                 DCMIPP_P2CFSCR_DTID_Msk                         /*!< Current Data type ID */
#define DCMIPP_P2CFSCR_VC_Pos               (19UL)
#define DCMIPP_P2CFSCR_VC_Msk               (0x3UL << DCMIPP_P2CFSCR_VC_Pos)                 /*!< 0x00180000 */
#define DCMIPP_P2CFSCR_VC                   DCMIPP_P2CFSCR_VC_Msk                           /*!< Current flow selection mode */
#define DCMIPP_P2CFSCR_FDTF_Pos             (24UL)
#define DCMIPP_P2CFSCR_FDTF_Msk             (0x3FUL << DCMIPP_P2CFSCR_FDTF_Pos)              /*!< 0x3F000000 */
#define DCMIPP_P2CFSCR_FDTF                 DCMIPP_P2CFSCR_FDTF_Msk                         /*!< Current force Data type format */
#define DCMIPP_P2CFSCR_FDTFEN_Pos           (30UL)
#define DCMIPP_P2CFSCR_FDTFEN_Msk           (0x1UL << DCMIPP_P2CFSCR_FDTFEN_Pos)             /*!< 0x40000000 */
#define DCMIPP_P2CFSCR_FDTFEN               DCMIPP_P2CFSCR_FDTFEN_Msk                       /*!< Current force Data type format enable */
#define DCMIPP_P2CFSCR_PIPEN_Pos            (31UL)
#define DCMIPP_P2CFSCR_PIPEN_Msk            (0x1UL << DCMIPP_P2CFSCR_PIPEN_Pos)              /*!< 0x80000000 */
#define DCMIPP_P2CFSCR_PIPEN                DCMIPP_P2CFSCR_PIPEN_Msk                        /*!< Current activation of PipeN */

/***************  Bit definition for DCMIPP_P2CFCTCR register  ****************/
#define DCMIPP_P2CFCTCR_FRATE_Pos           (0UL)
#define DCMIPP_P2CFCTCR_FRATE_Msk           (0x3UL << DCMIPP_P2CFCTCR_FRATE_Pos)             /*!< 0x00000003 */
#define DCMIPP_P2CFCTCR_FRATE               DCMIPP_P2CFCTCR_FRATE_Msk                       /*!< Frame capture rate control */
#define DCMIPP_P2CFCTCR_CPTMODE_Pos         (2UL)
#define DCMIPP_P2CFCTCR_CPTMODE_Msk         (0x1UL << DCMIPP_P2CFCTCR_CPTMODE_Pos)           /*!< 0x00000004 */
#define DCMIPP_P2CFCTCR_CPTMODE             DCMIPP_P2CFCTCR_CPTMODE_Msk                     /*!< Capture mode */
#define DCMIPP_P2CFCTCR_CPTREQ_Pos          (3UL)
#define DCMIPP_P2CFCTCR_CPTREQ_Msk          (0x1UL << DCMIPP_P2CFCTCR_CPTREQ_Pos)            /*!< 0x00000008 */
#define DCMIPP_P2CFCTCR_CPTREQ              DCMIPP_P2CFCTCR_CPTREQ_Msk                      /*!< Capture requested */

/***************  Bit definition for DCMIPP_P2CCRSTR register  ****************/
#define DCMIPP_P2CCRSTR_HSTART_Pos          (0UL)
#define DCMIPP_P2CCRSTR_HSTART_Msk          (0xFFFUL << DCMIPP_P2CCRSTR_HSTART_Pos)          /*!< 0x00000FFF */
#define DCMIPP_P2CCRSTR_HSTART              DCMIPP_P2CCRSTR_HSTART_Msk                      /*!< Current horizontal start, from 0 to 4094 pixels wide */
#define DCMIPP_P2CCRSTR_VSTART_Pos          (16UL)
#define DCMIPP_P2CCRSTR_VSTART_Msk          (0xFFFUL << DCMIPP_P2CCRSTR_VSTART_Pos)          /*!< 0x0FFF0000 */
#define DCMIPP_P2CCRSTR_VSTART              DCMIPP_P2CCRSTR_VSTART_Msk                      /*!< Current vertical start, from 0 to 4094 pixels high */

/***************  Bit definition for DCMIPP_P2CCRSZR register  ****************/
#define DCMIPP_P2CCRSZR_HSIZE_Pos           (0UL)
#define DCMIPP_P2CCRSZR_HSIZE_Msk           (0xFFFUL << DCMIPP_P2CCRSZR_HSIZE_Pos)           /*!< 0x00000FFF */
#define DCMIPP_P2CCRSZR_HSIZE               DCMIPP_P2CCRSZR_HSIZE_Msk                       /*!< Current horizontal size, from 0 to 4094 pixels wide */
#define DCMIPP_P2CCRSZR_VSIZE_Pos           (16UL)
#define DCMIPP_P2CCRSZR_VSIZE_Msk           (0xFFFUL << DCMIPP_P2CCRSZR_VSIZE_Pos)           /*!< 0x0FFF0000 */
#define DCMIPP_P2CCRSZR_VSIZE               DCMIPP_P2CCRSZR_VSIZE_Msk                       /*!< Current vertical size, from 0 to 4094 pixels high */
#define DCMIPP_P2CCRSZR_ENABLE_Pos          (31UL)
#define DCMIPP_P2CCRSZR_ENABLE_Msk          (0x1UL << DCMIPP_P2CCRSZR_ENABLE_Pos)            /*!< 0x80000000 */
#define DCMIPP_P2CCRSZR_ENABLE              DCMIPP_P2CCRSZR_ENABLE_Msk                      /*!< Current ENABLE bit value */

/****************  Bit definition for DCMIPP_P2CDCCR register  *****************/
#define DCMIPP_P2CDCCR_ENABLE_Pos           (0UL)
#define DCMIPP_P2CDCCR_ENABLE_Msk           (0x1UL << DCMIPP_P2CDCCR_ENABLE_Pos)            /*!< 0x00000001 */
#define DCMIPP_P2CDCCR_ENABLE               DCMIPP_P2CDCCR_ENABLE_Msk                       /*!< Decimation enable */
#define DCMIPP_P2CDCCR_HDEC_Pos             (1UL)
#define DCMIPP_P2CDCCR_HDEC_Msk             (0x3UL << DCMIPP_P2CDCCR_HDEC_Pos)              /*!< 0x00000006 */
#define DCMIPP_P2CDCCR_HDEC                 DCMIPP_P2CDCCR_HDEC_Msk                         /*!< Horizontal decimation ratio */
#define DCMIPP_P2CDCCR_VDEC_Pos             (3UL)
#define DCMIPP_P2CDCCR_VDEC_Msk             (0x3UL << DCMIPP_P2CDCCR_VDEC_Pos)              /*!< 0x00000018 */
#define DCMIPP_P2CDCCR_VDEC                 DCMIPP_P2CDCCR_VDEC_Msk                         /*!< Vertical decimation ratio */

/****************  Bit definition for DCMIPP_P2CDSCR register  ****************/
#define DCMIPP_P2CDSCR_HDIV_Pos             (0UL)
#define DCMIPP_P2CDSCR_HDIV_Msk             (0x3FFUL << DCMIPP_P2CDSCR_HDIV_Pos)             /*!< 0x000003FF */
#define DCMIPP_P2CDSCR_HDIV                 DCMIPP_P2CDSCR_HDIV_Msk                         /*!< Current horizontal division factor, from 128 (8x) to 1023 (1x) */
#define DCMIPP_P2CDSCR_VDIV_Pos             (16UL)
#define DCMIPP_P2CDSCR_VDIV_Msk             (0x3FFUL << DCMIPP_P2CDSCR_VDIV_Pos)             /*!< 0x03FF0000 */
#define DCMIPP_P2CDSCR_VDIV                 DCMIPP_P2CDSCR_VDIV_Msk                         /*!< Current vertical division factor, from 128 (8x) to 1023 (1x) */
#define DCMIPP_P2CDSCR_ENABLE_Pos           (31UL)
#define DCMIPP_P2CDSCR_ENABLE_Msk           (0x1UL << DCMIPP_P2CDSCR_ENABLE_Pos)             /*!< 0x80000000 */
#define DCMIPP_P2CDSCR_ENABLE               DCMIPP_P2CDSCR_ENABLE_Msk                       /*!< Current value of the bit ENABLE */

/**************  Bit definition for DCMIPP_P2CDSRTIOR register  ***************/
#define DCMIPP_P2CDSRTIOR_HRATIO_Pos        (0UL)
#define DCMIPP_P2CDSRTIOR_HRATIO_Msk        (0xFFFFUL << DCMIPP_P2CDSRTIOR_HRATIO_Pos)       /*!< 0x0000FFFF */
#define DCMIPP_P2CDSRTIOR_HRATIO            DCMIPP_P2CDSRTIOR_HRATIO_Msk                    /*!< Current horizontal ratio, from 8192 (1x) to 65535 (8x) */
#define DCMIPP_P2CDSRTIOR_VRATIO_Pos        (16UL)
#define DCMIPP_P2CDSRTIOR_VRATIO_Msk        (0xFFFFUL << DCMIPP_P2CDSRTIOR_VRATIO_Pos)       /*!< 0xFFFF0000 */
#define DCMIPP_P2CDSRTIOR_VRATIO            DCMIPP_P2CDSRTIOR_VRATIO_Msk                    /*!< Current vertical ratio, from 8192 (1x) to 65535 (8x) */

/***************  Bit definition for DCMIPP_P2CDSSZR register  ****************/
#define DCMIPP_P2CDSSZR_HSIZE_Pos           (0UL)
#define DCMIPP_P2CDSSZR_HSIZE_Msk           (0xFFFUL << DCMIPP_P2CDSSZR_HSIZE_Pos)           /*!< 0x00000FFF */
#define DCMIPP_P2CDSSZR_HSIZE               DCMIPP_P2CDSSZR_HSIZE_Msk                       /*!< Current horizontal size, from 0 to 4094 pixels wide */
#define DCMIPP_P2CDSSZR_VSIZE_Pos           (16UL)
#define DCMIPP_P2CDSSZR_VSIZE_Msk           (0xFFFUL << DCMIPP_P2CDSSZR_VSIZE_Pos)           /*!< 0x0FFF0000 */
#define DCMIPP_P2CDSSZR_VSIZE               DCMIPP_P2CDSSZR_VSIZE_Msk                       /*!< Current vertical size, from 0 to 4094 pixels high */

/****************  Bit definition for DCMIPP_P2CPPCR register  ****************/
#define DCMIPP_P2CPPCR_FORMAT_Pos           (0UL)
#define DCMIPP_P2CPPCR_FORMAT_Msk           (0xFUL << DCMIPP_P2CPPCR_FORMAT_Pos)             /*!< 0x0000000F */
#define DCMIPP_P2CPPCR_FORMAT               DCMIPP_P2CPPCR_FORMAT_Msk                       /*!< Memory format (only coplanar formats are supported in Pipe2) */
#define DCMIPP_P2CPPCR_SWAPRB_Pos           (4UL)
#define DCMIPP_P2CPPCR_SWAPRB_Msk           (0x1UL << DCMIPP_P2CPPCR_SWAPRB_Pos)             /*!< 0x00000010 */
#define DCMIPP_P2CPPCR_SWAPRB               DCMIPP_P2CPPCR_SWAPRB_Msk                       /*!< Swaps R-vs-B components if RGB, and if YUV, swaps U-vs-V components */
#define DCMIPP_P2CPPCR_LINEMULT_Pos         (13UL)
#define DCMIPP_P2CPPCR_LINEMULT_Msk         (0x7UL << DCMIPP_P2CPPCR_LINEMULT_Pos)           /*!< 0x0000E000 */
#define DCMIPP_P2CPPCR_LINEMULT             DCMIPP_P2CPPCR_LINEMULT_Msk                     /*!< Amount of capture completed lines for LINE Event and Interrupt */
#define DCMIPP_P2CPPCR_DBM_Pos              (16UL)
#define DCMIPP_P2CPPCR_DBM_Msk              (0x1UL << DCMIPP_P2CPPCR_DBM_Pos)                /*!< 0x00010000 */
#define DCMIPP_P2CPPCR_DBM                  DCMIPP_P2CPPCR_DBM_Msk                           /*!< Double buffer mode */
#define DCMIPP_P2CPPCR_LMAWM_Pos            (17UL)
#define DCMIPP_P2CPPCR_LMAWM_Msk            (0x7UL << DCMIPP_P2CPPCR_LMAWM_Pos)              /*!< 0x000E0000 */
#define DCMIPP_P2CPPCR_LMAWM                DCMIPP_P2CPPCR_LMAWM_Msk                         /*!< Line multi address wrapping modulo */
#define DCMIPP_P2CPPCR_LMAWE_Pos            (20UL)
#define DCMIPP_P2CPPCR_LMAWE_Msk            (0x7UL << DCMIPP_P2CPPCR_LMAWE_Pos)              /*!< 0x00100000 */
#define DCMIPP_P2CPPCR_LMAWE                DCMIPP_P2CPPCR_LMAWE_Msk                         /*!< Line multi address wrapping enable */

/**************  Bit definition for DCMIPP_P2CPPM0AR1 register  ***************/
#define DCMIPP_P2CPPM0AR1_M0A_Pos           (0UL)
#define DCMIPP_P2CPPM0AR1_M0A_Msk           (0xFFFFFFFFUL << DCMIPP_P2CPPM0AR1_M0A_Pos)      /*!< 0xFFFFFFFF */
#define DCMIPP_P2CPPM0AR1_M0A               DCMIPP_P2CPPM0AR1_M0A_Msk                       /*!< Memory0 address */

/**************  Bit definition for DCMIPP_P2CPPM0AR2 register  ***************/
#define DCMIPP_P2CPPM0AR2_M0A_Pos           (0UL)
#define DCMIPP_P2CPPM0AR2_M0A_Msk           (0xFFFFFFFFUL << DCMIPP_P2CPPM0AR1_M0A_Pos)      /*!< 0xFFFFFFFF */
#define DCMIPP_P2CPPM0AR2_M0A               DCMIPP_P2CPPM0AR1_M0A_Msk                       /*!< Memory0 address Register 2 */

/***************  Bit definition for DCMIPP_P2CPPM0PR register  ***************/
#define DCMIPP_P2CPPM0PR_PITCH_Pos          (0UL)
#define DCMIPP_P2CPPM0PR_PITCH_Msk          (0x7FFFUL << DCMIPP_P2CPPM0PR_PITCH_Pos)         /*!< 0x00007FFF */
#define DCMIPP_P2CPPM0PR_PITCH              DCMIPP_P2CPPM0PR_PITCH_Msk                      /*!< Number of bytes between the address of two consecutive lines */

/****************  Bit definition for DCMIPP_HWCFGR2 register  ****************/
#define DCMIPP_HWCFGR2_VPFT_Pos             (0UL)
#define DCMIPP_HWCFGR2_VPFT_Msk             (0x7U << DCMIPP_HWCFGR2_VPFT_Pos)               /*!< 0x00000007 */
#define DCMIPP_HWCFGR2_VPFT                 DCMIPP_HWCFGR2_VPFT_Msk                         /*!< Virtual pipe function */
#define DCMIPP_HWCFGR2_DBMFT_Pos            (4UL)
#define DCMIPP_HWCFGR2_DBMFT_Msk            (0x1U << DCMIPP_HWCFGR2_DBMFT_Pos)              /*!< 0x00000010 */
#define DCMIPP_HWCFGR2_DBMFT                DCMIPP_HWCFGR2_DBMFT_Msk                        /*!< Double buffer mode featured */
#define DCMIPP_HWCFGR2_PROCCLK_Pos          (8UL)
#define DCMIPP_HWCFGR2_PROCCLK_Msk          (0x1U << DCMIPP_HWCFGR2_PROCCLK_Pos)            /*!< 0x00000100 */
#define DCMIPP_HWCFGR2_PROCCLK              DCMIPP_HWCFGR2_PROCCLK_Msk                      /*!< Processing clock linked to AXI clock featured */
#define DCMIPP_HWCFGR2_ADDMOD_Pos           (12UL)
#define DCMIPP_HWCFGR2_ADDMOD_Msk           (0x1U << DCMIPP_HWCFGR2_ADDMOD_Pos)             /*!< 0x00001000 */
#define DCMIPP_HWCFGR2_ADDMOD               DCMIPP_HWCFGR2_ADDMOD_Msk                       /*!< Address modulo computation to access a small buffer in streaming featured */
#define DCMIPP_HWCFGR2_DEC1_Pos             (16UL)
#define DCMIPP_HWCFGR2_DEC1_Msk             (0x1U << DCMIPP_HWCFGR2_DEC1_Pos)               /*!< 0x00010000 */
#define DCMIPP_HWCFGR2_DEC1                 DCMIPP_HWCFGR2_DEC1_Msk                         /*!< Decimation on Pipe1 before downsize */
#define DCMIPP_HWCFGR2_DEC2_Pos             (17UL)
#define DCMIPP_HWCFGR2_DEC2_Msk             (0x1U << DCMIPP_HWCFGR2_DEC2_Pos)               /*!< 0x00020000 */
#define DCMIPP_HWCFGR2_DEC2                 DCMIPP_HWCFGR2_DEC2_Msk                         /*!< Decimation on Pipe2 before downsize */
#define DCMIPP_HWCFGR2_MCU_Pos              (20UL)
#define DCMIPP_HWCFGR2_MCU_Msk              (0x1U << DCMIPP_HWCFGR2_MCU_Pos)                /*!< 0x00100000 */
#define DCMIPP_HWCFGR2_MCU                  DCMIPP_HWCFGR2_MCU_Msk                          /*!< Macroblock unit as pixel format  */
#define DCMIPP_HWCFGR2_TPG_Pos              (24UL)
#define DCMIPP_HWCFGR2_TPG_Msk              (0x1U << DCMIPP_HWCFGR2_TPG_Pos)                /*!< 0x01000000 */
#define DCMIPP_HWCFGR2_TPG                  DCMIPP_HWCFGR2_TPG_Msk                          /*!< Test Pattern Generator */
#define DCMIPP_HWCFGR2_STV_Pos              (28UL)
#define DCMIPP_HWCFGR2_STV_Msk              (0x1U << DCMIPP_HWCFGR2_STV_Pos)                /*!< 0x10000000 */
#define DCMIPP_HWCFGR2_STV                  DCMIPP_HWCFGR2_STV_Msk                          /*!< Statistic Version */

/****************  Bit definition for DCMIPP_HWCFGR1 register  ****************/
#define DCMIPP_HWCFGR1_CSIFT_Pos            (0UL)
#define DCMIPP_HWCFGR1_CSIFT_Msk            (0x1U << DCMIPP_HWCFGR1_CSIFT_Pos)              /*!< 0x00000001 */
#define DCMIPP_HWCFGR1_CSIFT                DCMIPP_HWCFGR1_CSIFT_Msk                        /*!< CSI2 host protocol compliant */
#define DCMIPP_HWCFGR1_PIPENB_Pos           (4UL)
#define DCMIPP_HWCFGR1_PIPENB_Msk           (0x3U << DCMIPP_HWCFGR1_PIPENB_Pos)             /*!< 0x00000030 */
#define DCMIPP_HWCFGR1_PIPENB               DCMIPP_HWCFGR1_PIPENB_Msk                       /*!< Number of pipes */
#define DCMIPP_HWCFGR1_IPPLUGCFG_Pos        (8UL)
#define DCMIPP_HWCFGR1_IPPLUGCFG_Msk        (0x1U << DCMIPP_HWCFGR1_IPPLUGCFG_Pos)          /*!< 0x00000100 */
#define DCMIPP_HWCFGR1_IPPLUGCFG            DCMIPP_HWCFGR1_IPPLUGCFG_Msk                    /*!< IP-Plug configuration */
#define DCMIPP_HWCFGR1_DSP1FT_Pos           (12UL)
#define DCMIPP_HWCFGR1_DSP1FT_Msk           (0x1U << DCMIPP_HWCFGR1_DSP1FT_Pos)             /*!< 0x00001000 */
#define DCMIPP_HWCFGR1_DSP1FT               DCMIPP_HWCFGR1_DSP1FT_Msk                       /*!< Down-sampling feature for the pixel Pipe1 */
#define DCMIPP_HWCFGR1_DSP2FT_Pos           (13UL)
#define DCMIPP_HWCFGR1_DSP2FT_Msk           (0x1U << DCMIPP_HWCFGR1_DSP2FT_Pos)             /*!< 0x00002000 */
#define DCMIPP_HWCFGR1_DSP2FT               DCMIPP_HWCFGR1_DSP2FT_Msk                       /*!< Down-sampling feature for the pixel Pipe2 */
#define DCMIPP_HWCFGR1_RB2RGB_Pos           (16UL)
#define DCMIPP_HWCFGR1_RB2RGB_Msk           (0x1U << DCMIPP_HWCFGR1_RB2RGB_Pos)             /*!< 0x00010000 */
#define DCMIPP_HWCFGR1_RB2RGB               DCMIPP_HWCFGR1_RB2RGB_Msk                       /*!< Raw Bayer to RGB feature (demosaicer) */
#define DCMIPP_HWCFGR1_PLANARFT_Pos         (20UL)
#define DCMIPP_HWCFGR1_PLANARFT_Msk         (0x3U << DCMIPP_HWCFGR1_PLANARFT_Pos)           /*!< 0x00300000 */
#define DCMIPP_HWCFGR1_PLANARFT             DCMIPP_HWCFGR1_PLANARFT_Msk                     /*!< Buffer features for Pipe1 */
#define DCMIPP_HWCFGR1_ROI1NB_Pos           (24UL)
#define DCMIPP_HWCFGR1_ROI1NB_Msk           (0xFU << DCMIPP_HWCFGR1_ROI1NB_Pos)             /*!< 0x0F000000 */
#define DCMIPP_HWCFGR1_ROI1NB               DCMIPP_HWCFGR1_ROI1NB_Msk                       /*!< Number of ROIs for Pipe1 */
#define DCMIPP_HWCFGR1_ROI2NB_Pos           (28UL)
#define DCMIPP_HWCFGR1_ROI2NB_Msk           (0xFU << DCMIPP_HWCFGR1_ROI2NB_Pos)             /*!< 0xF0000000 */
#define DCMIPP_HWCFGR1_ROI2NB               DCMIPP_HWCFGR1_ROI2NB_Msk                       /*!< Number of ROIs for Pipe2 */

/*****************  Bit definition for DCMIPP_VERR register  ******************/
#define DCMIPP_VERR_MINREV_Pos              (0UL)
#define DCMIPP_VERR_MINREV_Msk              (0xFU << DCMIPP_VERR_MINREV_Pos)                /*!< 0x0000000F */
#define DCMIPP_VERR_MINREV                  DCMIPP_VERR_MINREV_Msk                          /*!< DCMIPP minor revision */
#define DCMIPP_VERR_MAJREV_Pos              (4UL)
#define DCMIPP_VERR_MAJREV_Msk              (0xFU << DCMIPP_VERR_MAJREV_Pos)                /*!< 0x000000F0 */
#define DCMIPP_VERR_MAJREV                  DCMIPP_VERR_MAJREV_Msk                          /*!< DCMIPP major revision */

/*****************  Bit definition for DCMIPP_IPIDR register  *****************/
#define DCMIPP_IPIDR_IDR_Pos                (0UL)
#define DCMIPP_IPIDR_IDR_Msk                (0xFFFFFFFFU << DCMIPP_IPIDR_IDR_Pos)           /*!< 0xFFFFFFFF */
#define DCMIPP_IPIDR_IDR                    DCMIPP_IPIDR_IDR_Msk                            /*!< Parallel camera interface (DCMI) and optional pixel processing (PP) */

/*****************  Bit definition for DCMIPP_SIDR register  ******************/
#define DCMIPP_SIDR_SID_Pos                 (0UL)
#define DCMIPP_SIDR_SID_Msk                 (0xFFFFFFFFU << DCMIPP_SIDR_SID_Pos)            /*!< 0xFFFFFFFF */
#define DCMIPP_SIDR_SID                     DCMIPP_SIDR_SID_Msk                             /*!< 4-Kbyte decoding space */

/******************************************************************************/
/*                                                                            */
/*                        Delay Block Interface (DLYB)                        */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for DLYB_CR register  ********************/
#define DLYB_CR_DEN_Pos                     (0UL)
#define DLYB_CR_DEN_Msk                     (0x1UL << DLYB_CR_DEN_Pos)              /*!< 0x00000001 */
#define DLYB_CR_DEN                         DLYB_CR_DEN_Msk                         /*!<Delay Block enable */
#define DLYB_CR_SEN_Pos                     (1UL)
#define DLYB_CR_SEN_Msk                     (0x1UL << DLYB_CR_SEN_Pos)              /*!< 0x00000002 */
#define DLYB_CR_SEN                         DLYB_CR_SEN_Msk                         /*!<Sampler length enable */

/*******************  Bit definition for DLYB_CFGR register  ********************/
#define DLYB_CFGR_SEL_Pos                   (0UL)
#define DLYB_CFGR_SEL_Msk                   (0xFUL << DLYB_CFGR_SEL_Pos)            /*!< 0x0000000F */
#define DLYB_CFGR_SEL                       DLYB_CFGR_SEL_Msk                       /*!<Select the phase for the Output clock[3:0] */
#define DLYB_CFGR_SEL_0                     (0x1UL << DLYB_CFGR_SEL_Pos)            /*!< 0x00000001 */
#define DLYB_CFGR_SEL_1                     (0x2UL << DLYB_CFGR_SEL_Pos)            /*!< 0x00000002 */
#define DLYB_CFGR_SEL_2                     (0x3UL << DLYB_CFGR_SEL_Pos)            /*!< 0x00000003 */
#define DLYB_CFGR_SEL_3                     (0x8UL << DLYB_CFGR_SEL_Pos)            /*!< 0x00000008 */

#define DLYB_CFGR_UNIT_Pos                  (8UL)
#define DLYB_CFGR_UNIT_Msk                  (0x7FUL << DLYB_CFGR_UNIT_Pos)          /*!< 0x00007F00 */
#define DLYB_CFGR_UNIT                      DLYB_CFGR_UNIT_Msk                      /*!<Delay Defines the delay of a Unit delay cell[6:0] */
#define DLYB_CFGR_UNIT_0                    (0x01UL << DLYB_CFGR_UNIT_Pos)          /*!< 0x00000100 */
#define DLYB_CFGR_UNIT_1                    (0x02UL << DLYB_CFGR_UNIT_Pos)          /*!< 0x00000200 */
#define DLYB_CFGR_UNIT_2                    (0x04UL << DLYB_CFGR_UNIT_Pos)          /*!< 0x00000400 */
#define DLYB_CFGR_UNIT_3                    (0x08UL << DLYB_CFGR_UNIT_Pos)          /*!< 0x00000800 */
#define DLYB_CFGR_UNIT_4                    (0x10UL << DLYB_CFGR_UNIT_Pos)          /*!< 0x00001000 */
#define DLYB_CFGR_UNIT_5                    (0x20UL << DLYB_CFGR_UNIT_Pos)          /*!< 0x00002000 */
#define DLYB_CFGR_UNIT_6                    (0x40UL << DLYB_CFGR_UNIT_Pos)          /*!< 0x00004000 */

#define DLYB_CFGR_LNG_Pos                   (16UL)
#define DLYB_CFGR_LNG_Msk                   (0xFFFUL << DLYB_CFGR_LNG_Pos)          /*!< 0x0FFF0000 */
#define DLYB_CFGR_LNG                       DLYB_CFGR_LNG_Msk                       /*!<Delay line length value[11:0] */
#define DLYB_CFGR_LNG_0                     (0x001UL << DLYB_CFGR_LNG_Pos)          /*!< 0x00010000 */
#define DLYB_CFGR_LNG_1                     (0x002UL << DLYB_CFGR_LNG_Pos)          /*!< 0x00020000 */
#define DLYB_CFGR_LNG_2                     (0x004UL << DLYB_CFGR_LNG_Pos)          /*!< 0x00040000 */
#define DLYB_CFGR_LNG_3                     (0x008UL << DLYB_CFGR_LNG_Pos)          /*!< 0x00080000 */
#define DLYB_CFGR_LNG_4                     (0x010UL << DLYB_CFGR_LNG_Pos)          /*!< 0x00100000 */
#define DLYB_CFGR_LNG_5                     (0x020UL << DLYB_CFGR_LNG_Pos)          /*!< 0x00200000 */
#define DLYB_CFGR_LNG_6                     (0x040UL << DLYB_CFGR_LNG_Pos)          /*!< 0x00400000 */
#define DLYB_CFGR_LNG_7                     (0x080UL << DLYB_CFGR_LNG_Pos)          /*!< 0x00800000 */
#define DLYB_CFGR_LNG_8                     (0x100UL << DLYB_CFGR_LNG_Pos)          /*!< 0x01000000 */
#define DLYB_CFGR_LNG_9                     (0x200UL << DLYB_CFGR_LNG_Pos)          /*!< 0x02000000 */
#define DLYB_CFGR_LNG_10                    (0x400UL << DLYB_CFGR_LNG_Pos)          /*!< 0x04000000 */
#define DLYB_CFGR_LNG_11                    (0x800UL << DLYB_CFGR_LNG_Pos)          /*!< 0x08000000 */

#define DLYB_CFGR_LNGF_Pos                  (31UL)
#define DLYB_CFGR_LNGF_Msk                  (0x1UL << DLYB_CFGR_LNGF_Pos)            /*!< 0x80000000 */
#define DLYB_CFGR_LNGF                      DLYB_CFGR_LNGF_Msk                       /*!<Length valid flag */


/******************************************************************************/
/*                                                                            */
/*                           DMA Controller (DMA)                             */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for DMA_SECCFGR register  ****************/
#define DMA_SECCFGR_SEC0_Pos     (0UL)
#define DMA_SECCFGR_SEC0_Msk     (0x1UL << DMA_SECCFGR_SEC0_Pos)                /*!< 0x00000001 */
#define DMA_SECCFGR_SEC0         DMA_SECCFGR_SEC0_Msk                          /*!< Secure State of Channel 0 */
#define DMA_SECCFGR_SEC1_Pos     (1UL)
#define DMA_SECCFGR_SEC1_Msk     (0x1UL << DMA_SECCFGR_SEC1_Pos)                /*!< 0x00000002 */
#define DMA_SECCFGR_SEC1         DMA_SECCFGR_SEC1_Msk                          /*!< Secure State of Channel 1 */
#define DMA_SECCFGR_SEC2_Pos     (2UL)
#define DMA_SECCFGR_SEC2_Msk     (0x1UL << DMA_SECCFGR_SEC2_Pos)                /*!< 0x00000004 */
#define DMA_SECCFGR_SEC2         DMA_SECCFGR_SEC2_Msk                          /*!< Secure State of Channel 2 */
#define DMA_SECCFGR_SEC3_Pos     (3UL)
#define DMA_SECCFGR_SEC3_Msk     (0x1UL << DMA_SECCFGR_SEC3_Pos)                /*!< 0x00000008 */
#define DMA_SECCFGR_SEC3         DMA_SECCFGR_SEC3_Msk                          /*!< Secure State of Channel 3 */
#define DMA_SECCFGR_SEC4_Pos     (4UL)
#define DMA_SECCFGR_SEC4_Msk     (0x1UL << DMA_SECCFGR_SEC4_Pos)                /*!< 0x00000010 */
#define DMA_SECCFGR_SEC4         DMA_SECCFGR_SEC4_Msk                          /*!< Secure State of Channel 4 */
#define DMA_SECCFGR_SEC5_Pos     (5UL)
#define DMA_SECCFGR_SEC5_Msk     (0x1UL << DMA_SECCFGR_SEC5_Pos)                /*!< 0x00000020 */
#define DMA_SECCFGR_SEC5         DMA_SECCFGR_SEC5_Msk                          /*!< Secure State of Channel 5 */
#define DMA_SECCFGR_SEC6_Pos     (6UL)
#define DMA_SECCFGR_SEC6_Msk     (0x1UL << DMA_SECCFGR_SEC6_Pos)                /*!< 0x00000040 */
#define DMA_SECCFGR_SEC6         DMA_SECCFGR_SEC6_Msk                          /*!< Secure State of Channel 6 */
#define DMA_SECCFGR_SEC7_Pos     (7UL)
#define DMA_SECCFGR_SEC7_Msk     (0x1UL << DMA_SECCFGR_SEC7_Pos)                /*!< 0x00000080 */
#define DMA_SECCFGR_SEC7         DMA_SECCFGR_SEC7_Msk                          /*!< Secure State of Channel 7 */
#define DMA_SECCFGR_SEC8_Pos     (8UL)
#define DMA_SECCFGR_SEC8_Msk     (0x1UL << DMA_SECCFGR_SEC8_Pos)                /*!< 0x00000100 */
#define DMA_SECCFGR_SEC8         DMA_SECCFGR_SEC8_Msk                          /*!< Secure State of Channel 8 */
#define DMA_SECCFGR_SEC9_Pos     (9UL)
#define DMA_SECCFGR_SEC9_Msk     (0x1UL << DMA_SECCFGR_SEC9_Pos)                /*!< 0x00000200 */
#define DMA_SECCFGR_SEC9         DMA_SECCFGR_SEC9_Msk                          /*!< Secure State of Channel 9 */
#define DMA_SECCFGR_SEC10_Pos    (10UL)
#define DMA_SECCFGR_SEC10_Msk    (0x1UL << DMA_SECCFGR_SEC10_Pos)               /*!< 0x00000400 */
#define DMA_SECCFGR_SEC10        DMA_SECCFGR_SEC10_Msk                         /*!< Secure State of Channel 10 */
#define DMA_SECCFGR_SEC11_Pos    (11UL)
#define DMA_SECCFGR_SEC11_Msk    (0x1UL << DMA_SECCFGR_SEC11_Pos)               /*!< 0x00000800 */
#define DMA_SECCFGR_SEC11        DMA_SECCFGR_SEC11_Msk                         /*!< Secure State of Channel 11 */
#define DMA_SECCFGR_SEC12_Pos    (12UL)
#define DMA_SECCFGR_SEC12_Msk    (0x1UL << DMA_SECCFGR_SEC12_Pos)               /*!< 0x00001000 */
#define DMA_SECCFGR_SEC12        DMA_SECCFGR_SEC12_Msk                         /*!< Secure State of Channel 12 */
#define DMA_SECCFGR_SEC13_Pos    (13UL)
#define DMA_SECCFGR_SEC13_Msk    (0x1UL << DMA_SECCFGR_SEC13_Pos)               /*!< 0x00002000 */
#define DMA_SECCFGR_SEC13        DMA_SECCFGR_SEC13_Msk                         /*!< Secure State of Channel 13 */
#define DMA_SECCFGR_SEC14_Pos    (14UL)
#define DMA_SECCFGR_SEC14_Msk    (0x1UL << DMA_SECCFGR_SEC14_Pos)               /*!< 0x00004000 */
#define DMA_SECCFGR_SEC14        DMA_SECCFGR_SEC14_Msk                         /*!< Secure State of Channel 14 */
#define DMA_SECCFGR_SEC15_Pos    (15UL)
#define DMA_SECCFGR_SEC15_Msk    (0x1UL << DMA_SECCFGR_SEC15_Pos)               /*!< 0x00008000 */
#define DMA_SECCFGR_SEC15        DMA_SECCFGR_SEC14_Msk                         /*!< Secure State of Channel 15 */

/*******************  Bit definition for DMA_PRIVCFGR register  ****************/
#define DMA_PRIVCFGR_PRIV0_Pos              (0UL)
#define DMA_PRIVCFGR_PRIV0_Msk              (0x1UL << DMA_PRIVCFGR_PRIV0_Pos)       /*!< 0x00000001 */
#define DMA_PRIVCFGR_PRIV0                  DMA_PRIVCFGR_PRIV0_Msk                  /*!< Privileged State of Channel 0 */
#define DMA_PRIVCFGR_PRIV1_Pos              (1UL)
#define DMA_PRIVCFGR_PRIV1_Msk              (0x1UL << DMA_PRIVCFGR_PRIV1_Pos)       /*!< 0x00000002 */
#define DMA_PRIVCFGR_PRIV1                  DMA_PRIVCFGR_PRIV1_Msk                  /*!< Privileged State of Channel 1 */
#define DMA_PRIVCFGR_PRIV2_Pos              (2UL)
#define DMA_PRIVCFGR_PRIV2_Msk              (0x1UL << DMA_PRIVCFGR_PRIV2_Pos)       /*!< 0x00000004 */
#define DMA_PRIVCFGR_PRIV2                  DMA_PRIVCFGR_PRIV2_Msk                  /*!< Privileged State of Channel 2 */
#define DMA_PRIVCFGR_PRIV3_Pos              (3UL)
#define DMA_PRIVCFGR_PRIV3_Msk              (0x1UL << DMA_PRIVCFGR_PRIV3_Pos)       /*!< 0x00000008 */
#define DMA_PRIVCFGR_PRIV3                  DMA_PRIVCFGR_PRIV3_Msk                  /*!< Privileged State of Channel 3 */
#define DMA_PRIVCFGR_PRIV4_Pos              (4UL)
#define DMA_PRIVCFGR_PRIV4_Msk              (0x1UL << DMA_PRIVCFGR_PRIV4_Pos)       /*!< 0x00000010 */
#define DMA_PRIVCFGR_PRIV4                  DMA_PRIVCFGR_PRIV4_Msk                  /*!< Privileged State of Channel 4 */
#define DMA_PRIVCFGR_PRIV5_Pos              (5UL)
#define DMA_PRIVCFGR_PRIV5_Msk              (0x1UL << DMA_PRIVCFGR_PRIV5_Pos)       /*!< 0x00000020 */
#define DMA_PRIVCFGR_PRIV5                  DMA_PRIVCFGR_PRIV5_Msk                  /*!< Privileged State of Channel 5 */
#define DMA_PRIVCFGR_PRIV6_Pos              (6UL)
#define DMA_PRIVCFGR_PRIV6_Msk              (0x1UL << DMA_PRIVCFGR_PRIV6_Pos)       /*!< 0x00000040 */
#define DMA_PRIVCFGR_PRIV6                  DMA_PRIVCFGR_PRIV6_Msk                  /*!< Privileged State of Channel 6 */
#define DMA_PRIVCFGR_PRIV7_Pos              (7UL)
#define DMA_PRIVCFGR_PRIV7_Msk              (0x1UL << DMA_PRIVCFGR_PRIV7_Pos)       /*!< 0x00000080 */
#define DMA_PRIVCFGR_PRIV7                  DMA_PRIVCFGR_PRIV7_Msk                  /*!< Privileged State of Channel 7 */
#define DMA_PRIVCFGR_PRIV8_Pos              (8UL)
#define DMA_PRIVCFGR_PRIV8_Msk              (0x1UL << DMA_PRIVCFGR_PRIV8_Pos)       /*!< 0x00000100 */
#define DMA_PRIVCFGR_PRIV8                  DMA_PRIVCFGR_PRIV8_Msk                  /*!< Privileged State of Channel 8 */
#define DMA_PRIVCFGR_PRIV9_Pos              (9UL)
#define DMA_PRIVCFGR_PRIV9_Msk              (0x1UL << DMA_PRIVCFGR_PRIV9_Pos)       /*!< 0x00000200 */
#define DMA_PRIVCFGR_PRIV9                  DMA_PRIVCFGR_PRIV9_Msk                  /*!< Privileged State of Channel 9 */
#define DMA_PRIVCFGR_PRIV10_Pos             (10UL)
#define DMA_PRIVCFGR_PRIV10_Msk             (0x1UL << DMA_PRIVCFGR_PRIV10_Pos)      /*!< 0x00000400 */
#define DMA_PRIVCFGR_PRIV10                 DMA_PRIVCFGR_PRIV10_Msk                 /*!< Privileged State of Channel 10 */
#define DMA_PRIVCFGR_PRIV11_Pos             (11UL)
#define DMA_PRIVCFGR_PRIV11_Msk             (0x1UL << DMA_PRIVCFGR_PRIV11_Pos)      /*!< 0x00000800 */
#define DMA_PRIVCFGR_PRIV11                 DMA_PRIVCFGR_PRIV11_Msk                 /*!< Privileged State of Channel 11 */
#define DMA_PRIVCFGR_PRIV12_Pos             (12UL)
#define DMA_PRIVCFGR_PRIV12_Msk             (0x1UL << DMA_PRIVCFGR_PRIV12_Pos)      /*!< 0x00001000 */
#define DMA_PRIVCFGR_PRIV12                 DMA_PRIVCFGR_PRIV12_Msk                 /*!< Privileged State of Channel 12 */
#define DMA_PRIVCFGR_PRIV13_Pos             (13UL)
#define DMA_PRIVCFGR_PRIV13_Msk             (0x1UL << DMA_PRIVCFGR_PRIV13_Pos)      /*!< 0x00002000 */
#define DMA_PRIVCFGR_PRIV13                 DMA_PRIVCFGR_PRIV13_Msk                 /*!< Privileged State of Channel 13 */
#define DMA_PRIVCFGR_PRIV14_Pos             (14UL)
#define DMA_PRIVCFGR_PRIV14_Msk             (0x1UL << DMA_PRIVCFGR_PRIV14_Pos)      /*!< 0x00004000 */
#define DMA_PRIVCFGR_PRIV14                 DMA_PRIVCFGR_PRIV14_Msk                 /*!< Privileged State of Channel 14 */
#define DMA_PRIVCFGR_PRIV15_Pos             (15UL)
#define DMA_PRIVCFGR_PRIV15_Msk             (0x1UL << DMA_PRIVCFGR_PRIV15_Pos)      /*!< 0x00008000 */
#define DMA_PRIVCFGR_PRIV15                 DMA_PRIVCFGR_PRIV15_Msk                 /*!< Privileged State of Channel 15 */

/*******************  Bit definition for DMA_RCFGLOCKR register  ****************/
#define DMA_RCFGLOCKR_LOCK0_Pos              (0UL)
#define DMA_RCFGLOCKR_LOCK0_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK0_Pos)       /*!< 0x00000001 */
#define DMA_RCFGLOCKR_LOCK0                  DMA_RCFGLOCKR_LOCK0_Msk                  /*!< Lock the configuration of Channel 0  */
#define DMA_RCFGLOCKR_LOCK1_Pos              (1UL)
#define DMA_RCFGLOCKR_LOCK1_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK1_Pos)       /*!< 0x00000002 */
#define DMA_RCFGLOCKR_LOCK1                  DMA_RCFGLOCKR_LOCK1_Msk                  /*!< Lock the configuration of Channel 1  */
#define DMA_RCFGLOCKR_LOCK2_Pos              (2UL)
#define DMA_RCFGLOCKR_LOCK2_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK2_Pos)       /*!< 0x00000004 */
#define DMA_RCFGLOCKR_LOCK2                  DMA_RCFGLOCKR_LOCK2_Msk                  /*!< Lock the configuration of Channel 2  */
#define DMA_RCFGLOCKR_LOCK3_Pos              (3UL)
#define DMA_RCFGLOCKR_LOCK3_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK3_Pos)       /*!< 0x00000008 */
#define DMA_RCFGLOCKR_LOCK3                  DMA_RCFGLOCKR_LOCK3_Msk                  /*!< Lock the configuration of Channel 3  */
#define DMA_RCFGLOCKR_LOCK4_Pos              (4UL)
#define DMA_RCFGLOCKR_LOCK4_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK4_Pos)       /*!< 0x00000010 */
#define DMA_RCFGLOCKR_LOCK4                  DMA_RCFGLOCKR_LOCK4_Msk                  /*!< Lock the configuration of Channel 4  */
#define DMA_RCFGLOCKR_LOCK5_Pos              (5UL)
#define DMA_RCFGLOCKR_LOCK5_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK5_Pos)       /*!< 0x00000020 */
#define DMA_RCFGLOCKR_LOCK5                  DMA_RCFGLOCKR_LOCK5_Msk                  /*!< Lock the configuration of Channel 5  */
#define DMA_RCFGLOCKR_LOCK6_Pos              (6UL)
#define DMA_RCFGLOCKR_LOCK6_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK6_Pos)       /*!< 0x00000040 */
#define DMA_RCFGLOCKR_LOCK6                  DMA_RCFGLOCKR_LOCK6_Msk                  /*!< Lock the configuration of Channel 6  */
#define DMA_RCFGLOCKR_LOCK7_Pos              (7UL)
#define DMA_RCFGLOCKR_LOCK7_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK7_Pos)       /*!< 0x00000080 */
#define DMA_RCFGLOCKR_LOCK7                  DMA_RCFGLOCKR_LOCK7_Msk                  /*!< Lock the configuration of Channel 7  */
#define DMA_RCFGLOCKR_LOCK8_Pos              (8UL)
#define DMA_RCFGLOCKR_LOCK8_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK8_Pos)       /*!< 0x00000100 */
#define DMA_RCFGLOCKR_LOCK8                  DMA_RCFGLOCKR_LOCK8_Msk                  /*!< Lock the configuration of Channel 8  */
#define DMA_RCFGLOCKR_LOCK9_Pos              (9UL)
#define DMA_RCFGLOCKR_LOCK9_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK9_Pos)       /*!< 0x00000200 */
#define DMA_RCFGLOCKR_LOCK9                  DMA_RCFGLOCKR_LOCK9_Msk                  /*!< Lock the configuration of Channel 9  */
#define DMA_RCFGLOCKR_LOCK10_Pos             (10UL)
#define DMA_RCFGLOCKR_LOCK10_Msk             (0x1UL << DMA_RCFGLOCKR_LOCK10_Pos)      /*!< 0x00000400 */
#define DMA_RCFGLOCKR_LOCK10                 DMA_RCFGLOCKR_LOCK10_Msk                 /*!< Lock the configuration of Channel 10 */
#define DMA_RCFGLOCKR_LOCK11_Pos             (11UL)
#define DMA_RCFGLOCKR_LOCK11_Msk             (0x1UL << DMA_RCFGLOCKR_LOCK11_Pos)      /*!< 0x00000800 */
#define DMA_RCFGLOCKR_LOCK11                 DMA_RCFGLOCKR_LOCK11_Msk                 /*!< Lock the configuration of Channel 11 */
#define DMA_RCFGLOCKR_LOCK12_Pos             (12UL)
#define DMA_RCFGLOCKR_LOCK12_Msk             (0x1UL << DMA_RCFGLOCKR_LOCK12_Pos)      /*!< 0x00001000 */
#define DMA_RCFGLOCKR_LOCK12                 DMA_RCFGLOCKR_LOCK12_Msk                 /*!< Lock the configuration of Channel 12 */
#define DMA_RCFGLOCKR_LOCK13_Pos             (13UL)
#define DMA_RCFGLOCKR_LOCK13_Msk             (0x1UL << DMA_RCFGLOCKR_LOCK13_Pos)      /*!< 0x00002000 */
#define DMA_RCFGLOCKR_LOCK13                 DMA_RCFGLOCKR_LOCK13_Msk                 /*!< Lock the configuration of Channel 13 */
#define DMA_RCFGLOCKR_LOCK14_Pos             (14UL)
#define DMA_RCFGLOCKR_LOCK14_Msk             (0x1UL << DMA_RCFGLOCKR_LOCK14_Pos)      /*!< 0x00004000 */
#define DMA_RCFGLOCKR_LOCK14                 DMA_RCFGLOCKR_LOCK14_Msk                 /*!< Lock the configuration of Channel 14 */
#define DMA_RCFGLOCKR_LOCK15_Pos             (15UL)
#define DMA_RCFGLOCKR_LOCK15_Msk             (0x1UL << DMA_RCFGLOCKR_LOCK15_Pos)      /*!< 0x00008000 */
#define DMA_RCFGLOCKR_LOCK15                 DMA_RCFGLOCKR_LOCK15_Msk                 /*!< Lock the configuration of Channel 15 */

/*******************  Bit definition for DMA_MISR register  ****************/
#define DMA_MISR_MIS0_Pos                   (0UL)
#define DMA_MISR_MIS0_Msk                   (0x1UL << DMA_MISR_MIS0_Pos)            /*!< 0x00000001 */
#define DMA_MISR_MIS0                       DMA_MISR_MIS0_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 0 */
#define DMA_MISR_MIS1_Pos                   (1UL)
#define DMA_MISR_MIS1_Msk                   (0x1UL << DMA_MISR_MIS1_Pos)            /*!< 0x00000002 */
#define DMA_MISR_MIS1                       DMA_MISR_MIS1_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 1 */
#define DMA_MISR_MIS2_Pos                   (2UL)
#define DMA_MISR_MIS2_Msk                   (0x1UL << DMA_MISR_MIS2_Pos)            /*!< 0x00000004 */
#define DMA_MISR_MIS2                       DMA_MISR_MIS2_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 2 */
#define DMA_MISR_MIS3_Pos                   (3UL)
#define DMA_MISR_MIS3_Msk                   (0x1UL << DMA_MISR_MIS3_Pos)            /*!< 0x00000008 */
#define DMA_MISR_MIS3                       DMA_MISR_MIS3_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 3 */
#define DMA_MISR_MIS4_Pos                   (4UL)
#define DMA_MISR_MIS4_Msk                   (0x1UL << DMA_MISR_MIS4_Pos)            /*!< 0x00000010 */
#define DMA_MISR_MIS4                       DMA_MISR_MIS4_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 4 */
#define DMA_MISR_MIS5_Pos                   (5UL)
#define DMA_MISR_MIS5_Msk                   (0x1UL << DMA_MISR_MIS5_Pos)            /*!< 0x00000020 */
#define DMA_MISR_MIS5                       DMA_MISR_MIS5_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 5 */
#define DMA_MISR_MIS6_Pos                   (6UL)
#define DMA_MISR_MIS6_Msk                   (0x1UL << DMA_MISR_MIS6_Pos)            /*!< 0x00000040 */
#define DMA_MISR_MIS6                       DMA_MISR_MIS6_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 6 */
#define DMA_MISR_MIS7_Pos                   (7UL)
#define DMA_MISR_MIS7_Msk                   (0x1UL << DMA_MISR_MIS7_Pos)            /*!< 0x00000080 */
#define DMA_MISR_MIS7                       DMA_MISR_MIS7_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 7 */
#define DMA_MISR_MIS8_Pos                   (8UL)
#define DMA_MISR_MIS8_Msk                   (0x1UL << DMA_MISR_MIS8_Pos)            /*!< 0x00000100 */
#define DMA_MISR_MIS8                       DMA_MISR_MIS8_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 8 */
#define DMA_MISR_MIS9_Pos                   (9UL)
#define DMA_MISR_MIS9_Msk                   (0x1UL << DMA_MISR_MIS9_Pos)            /*!< 0x00000200 */
#define DMA_MISR_MIS9                       DMA_MISR_MIS9_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 9 */
#define DMA_MISR_MIS10_Pos                  (10UL)
#define DMA_MISR_MIS10_Msk                  (0x1UL << DMA_MISR_MIS10_Pos)           /*!< 0x00000400 */
#define DMA_MISR_MIS10                      DMA_MISR_MIS10_Msk                      /*!< Masked Interrupt State of Non-Secure Channel 10 */
#define DMA_MISR_MIS11_Pos                  (11UL)
#define DMA_MISR_MIS11_Msk                  (0x1UL << DMA_MISR_MIS11_Pos)           /*!< 0x00000800 */
#define DMA_MISR_MIS11                      DMA_MISR_MIS11_Msk                      /*!< Masked Interrupt State of Non-Secure Channel 11 */
#define DMA_MISR_MIS12_Pos                  (12UL)
#define DMA_MISR_MIS12_Msk                  (0x1UL << DMA_MISR_MIS12_Pos)           /*!< 0x00001000 */
#define DMA_MISR_MIS12                      DMA_MISR_MIS12_Msk                      /*!< Masked Interrupt State of Non-Secure Channel 12 */
#define DMA_MISR_MIS13_Pos                  (13UL)
#define DMA_MISR_MIS13_Msk                  (0x1UL << DMA_MISR_MIS13_Pos)           /*!< 0x00002000 */
#define DMA_MISR_MIS13                      DMA_MISR_MIS13_Msk                      /*!< Masked Interrupt State of Non-Secure Channel 13 */
#define DMA_MISR_MIS14_Pos                  (14UL)
#define DMA_MISR_MIS14_Msk                  (0x1UL << DMA_MISR_MIS14_Pos)           /*!< 0x00004000 */
#define DMA_MISR_MIS14                      DMA_MISR_MIS14_Msk                      /*!< Masked Interrupt State of Non-Secure Channel 14 */
#define DMA_MISR_MIS15_Pos                  (15UL)
#define DMA_MISR_MIS15_Msk                  (0x1UL << DMA_MISR_MIS15_Pos)           /*!< 0x00008000 */
#define DMA_MISR_MIS15                      DMA_MISR_MIS14_Msk                      /*!< Masked Interrupt State of Non-Secure Channel 15 */

/*******************  Bit definition for DMA_SMISR register  ****************/
#define DMA_SMISR_MIS0_Pos       (0UL)
#define DMA_SMISR_MIS0_Msk       (0x1UL << DMA_SMISR_MIS0_Pos)                  /*!< 0x00000001 */
#define DMA_SMISR_MIS0           DMA_SMISR_MIS0_Msk                            /*!< Masked Interrupt State of Secure Channel 0 */
#define DMA_SMISR_MIS1_Pos       (1UL)
#define DMA_SMISR_MIS1_Msk       (0x1UL << DMA_SMISR_MIS1_Pos)                  /*!< 0x00000002 */
#define DMA_SMISR_MIS1           DMA_SMISR_MIS1_Msk                            /*!< Masked Interrupt State of Secure Channel 1 */
#define DMA_SMISR_MIS2_Pos       (2UL)
#define DMA_SMISR_MIS2_Msk       (0x1UL << DMA_SMISR_MIS2_Pos)                  /*!< 0x00000004 */
#define DMA_SMISR_MIS2           DMA_SMISR_MIS2_Msk                            /*!< Masked Interrupt State of Secure Channel 2 */
#define DMA_SMISR_MIS3_Pos       (3UL)
#define DMA_SMISR_MIS3_Msk       (0x1UL << DMA_SMISR_MIS3_Pos)                  /*!< 0x00000008 */
#define DMA_SMISR_MIS3           DMA_SMISR_MIS3_Msk                            /*!< Masked Interrupt State of Secure Channel 3 */
#define DMA_SMISR_MIS4_Pos       (4UL)
#define DMA_SMISR_MIS4_Msk       (0x1UL << DMA_SMISR_MIS4_Pos)                  /*!< 0x00000010 */
#define DMA_SMISR_MIS4           DMA_SMISR_MIS4_Msk                            /*!< Masked Interrupt State of Secure Channel 4 */
#define DMA_SMISR_MIS5_Pos       (5UL)
#define DMA_SMISR_MIS5_Msk       (0x1UL << DMA_SMISR_MIS5_Pos)                  /*!< 0x00000020 */
#define DMA_SMISR_MIS5           DMA_SMISR_MIS5_Msk                            /*!< Masked Interrupt State of Secure Channel 5 */
#define DMA_SMISR_MIS6_Pos       (6UL)
#define DMA_SMISR_MIS6_Msk       (0x1UL << DMA_SMISR_MIS6_Pos)                  /*!< 0x00000040 */
#define DMA_SMISR_MIS6           DMA_SMISR_MIS6_Msk                            /*!< Masked Interrupt State of Secure Channel 6 */
#define DMA_SMISR_MIS7_Pos       (7UL)
#define DMA_SMISR_MIS7_Msk       (0x1UL << DMA_SMISR_MIS7_Pos)                  /*!< 0x00000080 */
#define DMA_SMISR_MIS7           DMA_SMISR_MIS7_Msk                            /*!< Masked Interrupt State of Secure Channel 7 */
#define DMA_SMISR_MIS8_Pos       (8UL)
#define DMA_SMISR_MIS8_Msk       (0x1UL << DMA_SMISR_MIS8_Pos)                  /*!< 0x00000100 */
#define DMA_SMISR_MIS8           DMA_SMISR_MIS8_Msk                            /*!< Masked Interrupt State of Secure Channel 8 */
#define DMA_SMISR_MIS9_Pos       (9UL)
#define DMA_SMISR_MIS9_Msk       (0x1UL << DMA_SMISR_MIS9_Pos)                  /*!< 0x00000200 */
#define DMA_SMISR_MIS9           DMA_SMISR_MIS9_Msk                            /*!< Masked Interrupt State of Secure Channel 9 */
#define DMA_SMISR_MIS10_Pos      (10UL)
#define DMA_SMISR_MIS10_Msk      (0x1UL << DMA_SMISR_MIS10_Pos)                 /*!< 0x00000400 */
#define DMA_SMISR_MIS10          DMA_SMISR_MIS10_Msk                           /*!< Masked Interrupt State of Secure Channel 10 */
#define DMA_SMISR_MIS11_Pos      (11UL)
#define DMA_SMISR_MIS11_Msk      (0x1UL << DMA_SMISR_MIS11_Pos)                 /*!< 0x00000800 */
#define DMA_SMISR_MIS11          DMA_SMISR_MIS11_Msk                           /*!< Masked Interrupt State of Secure Channel 11 */
#define DMA_SMISR_MIS12_Pos      (12UL)
#define DMA_SMISR_MIS12_Msk      (0x1UL << DMA_SMISR_MIS12_Pos)                 /*!< 0x00001000 */
#define DMA_SMISR_MIS12          DMA_SMISR_MIS12_Msk                           /*!< Masked Interrupt State of Secure Channel 12 */
#define DMA_SMISR_MIS13_Pos      (13UL)
#define DMA_SMISR_MIS13_Msk      (0x1UL << DMA_SMISR_MIS13_Pos)                 /*!< 0x00002000 */
#define DMA_SMISR_MIS13          DMA_SMISR_MIS13_Msk                           /*!< Masked Interrupt State of Secure Channel 13 */
#define DMA_SMISR_MIS14_Pos      (14UL)
#define DMA_SMISR_MIS14_Msk      (0x1UL << DMA_SMISR_MIS14_Pos)                 /*!< 0x00004000 */
#define DMA_SMISR_MIS14          DMA_SMISR_MIS14_Msk                           /*!< Masked Interrupt State of Secure Channel 14 */
#define DMA_SMISR_MIS15_Pos      (15UL)
#define DMA_SMISR_MIS15_Msk      (0x1UL << DMA_SMISR_MIS15_Pos)                 /*!< 0x00008000 */
#define DMA_SMISR_MIS15          DMA_SMISR_MIS14_Msk                           /*!< Masked Interrupt State of Secure Channel 15 */

/*******************  Bit definition for DMA_CLBAR register  ****************/
#define DMA_CLBAR_LBA_Pos                   (16UL)
#define DMA_CLBAR_LBA_Msk                   (0xFFFFUL << DMA_CLBAR_LBA_Pos)         /*!< 0xFFFF0000 */
#define DMA_CLBAR_LBA                       DMA_CLBAR_LBA_Msk                       /*!< Linked-list Base Address of DMA channel x */

/*******************  Bit definition for DMA_CCIDCFGR register  *******************/
#define DMA_CCIDCFGR_CFEN_Pos           (0UL)
#define DMA_CCIDCFGR_CFEN_Msk           (0x1UL << DMA_CCIDCFGR_CFEN_Pos)         /*!< 0x00000001 */
#define DMA_CCIDCFGR_CFEN               DMA_CCIDCFGR_CFEN_Msk                   /*!< CID filtering enable of the channel x */
#define DMA_CCIDCFGR_SCID_Pos           (4UL)
#define DMA_CCIDCFGR_SCID_Msk           (0x7UL << DMA_CCIDCFGR_SCID_Pos)         /*!< 0x00000070 */
#define DMA_CCIDCFGR_SCID               DMA_CCIDCFGR_SCID_Msk                   /*!< select a static CID to the channel x */

/*******************  Bit definition for DMA_CFCR register  *******************/
#define DMA_CFCR_TCF_Pos                    (8UL)
#define DMA_CFCR_TCF_Msk                    (0x1UL << DMA_CFCR_TCF_Pos)             /*!< 0x00000100 */
#define DMA_CFCR_TCF                        DMA_CFCR_TCF_Msk                        /*!< Transfer complete flag clear */
#define DMA_CFCR_HTF_Pos                    (9UL)
#define DMA_CFCR_HTF_Msk                    (0x1UL << DMA_CFCR_HTF_Pos)             /*!< 0x00000200 */
#define DMA_CFCR_HTF                        DMA_CFCR_HTF_Msk                        /*!< Half transfer complete flag clear */
#define DMA_CFCR_DTEF_Pos                   (10UL)
#define DMA_CFCR_DTEF_Msk                   (0x1UL << DMA_CFCR_DTEF_Pos)            /*!< 0x00000400 */
#define DMA_CFCR_DTEF                       DMA_CFCR_DTEF_Msk                       /*!< Data transfer error flag clear */
#define DMA_CFCR_ULEF_Pos                   (11UL)
#define DMA_CFCR_ULEF_Msk                   (0x1UL << DMA_CFCR_ULEF_Pos)            /*!< 0x00000800 */
#define DMA_CFCR_ULEF                       DMA_CFCR_ULEF_Msk                       /*!< Update linked-list item error flag clear */
#define DMA_CFCR_USEF_Pos                   (12UL)
#define DMA_CFCR_USEF_Msk                   (0x1UL << DMA_CFCR_USEF_Pos)            /*!< 0x00001000 */
#define DMA_CFCR_USEF                       DMA_CFCR_USEF_Msk                       /*!< User setting error flag clear */
#define DMA_CFCR_SUSPF_Pos                  (13UL)
#define DMA_CFCR_SUSPF_Msk                  (0x1UL << DMA_CFCR_SUSPF_Pos)           /*!< 0x00002000 */
#define DMA_CFCR_SUSPF                      DMA_CFCR_SUSPF_Msk                      /*!< Completed suspension flag clear */
#define DMA_CFCR_TOF_Pos                    (14UL)
#define DMA_CFCR_TOF_Msk                    (0x1UL << DMA_CFCR_TOF_Pos)             /*!< 0x00004000 */
#define DMA_CFCR_TOF                        DMA_CFCR_TOF_Msk                        /*!< Trigger overrun clear flag */

/*******************  Bit definition for DMA_CSR register  *******************/
#define DMA_CSR_IDLEF_Pos                   (0UL)
#define DMA_CSR_IDLEF_Msk                   (0x1UL << DMA_CSR_IDLEF_Pos)            /*!< 0x00000001 */
#define DMA_CSR_IDLEF                       DMA_CSR_IDLEF_Msk                       /*!< Idle flag */
#define DMA_CSR_TCF_Pos                     (8UL)
#define DMA_CSR_TCF_Msk                     (0x1UL << DMA_CSR_TCF_Pos)              /*!< 0x00000100 */
#define DMA_CSR_TCF                         DMA_CSR_TCF_Msk                         /*!< Transfer complete flag */
#define DMA_CSR_HTF_Pos                     (9UL)
#define DMA_CSR_HTF_Msk                     (0x1UL << DMA_CSR_HTF_Pos)              /*!< 0x00000200 */
#define DMA_CSR_HTF                         DMA_CSR_HTF_Msk                         /*!< Half transfer complete flag */
#define DMA_CSR_DTEF_Pos                    (10UL)
#define DMA_CSR_DTEF_Msk                    (0x1UL << DMA_CSR_DTEF_Pos)             /*!< 0x00000400 */
#define DMA_CSR_DTEF                        DMA_CSR_DTEF_Msk                        /*!< Data transfer error flag */
#define DMA_CSR_ULEF_Pos                    (11UL)
#define DMA_CSR_ULEF_Msk                    (0x1UL << DMA_CSR_ULEF_Pos)             /*!< 0x00000800 */
#define DMA_CSR_ULEF                        DMA_CSR_ULEF_Msk                        /*!< Update linked-list item error flag */
#define DMA_CSR_USEF_Pos                    (12UL)
#define DMA_CSR_USEF_Msk                    (0x1UL << DMA_CSR_USEF_Pos)             /*!< 0x00001000 */
#define DMA_CSR_USEF                        DMA_CSR_USEF_Msk                        /*!< User setting error flag */
#define DMA_CSR_SUSPF_Pos                   (13UL)
#define DMA_CSR_SUSPF_Msk                   (0x1UL << DMA_CSR_SUSPF_Pos)            /*!< 0x00002000 */
#define DMA_CSR_SUSPF                       DMA_CSR_SUSPF_Msk                       /*!< User setting error flag */
#define DMA_CSR_TOF_Pos                     (14UL)
#define DMA_CSR_TOF_Msk                     (0x1UL << DMA_CSR_TOF_Pos)              /*!< 0x00004000 */
#define DMA_CSR_TOF                         DMA_CSR_TOF_Msk                         /*!< Trigger overrun flag */
#define DMA_CSR_FIFOL_Pos                   (16UL)
#define DMA_CSR_FIFOL_Msk                   (0xFFUL << DMA_CSR_FIFOL_Pos)           /*!< 0x00FF0000 */
#define DMA_CSR_FIFOL                       DMA_CSR_FIFOL_Msk                       /*!< Monitored FIFO level in bytes */

/*******************  Bit definition for DMA_CCR register  ********************/
#define DMA_CCR_EN_Pos                      (0UL)
#define DMA_CCR_EN_Msk                      (0x1UL << DMA_CCR_EN_Pos)               /*!< 0x00000001 */
#define DMA_CCR_EN                          DMA_CCR_EN_Msk                          /*!< Channel enable */
#define DMA_CCR_RESET_Pos                   (1UL)
#define DMA_CCR_RESET_Msk                   (0x1UL << DMA_CCR_RESET_Pos)            /*!< 0x00000002 */
#define DMA_CCR_RESET                       DMA_CCR_RESET_Msk                       /*!< Channel reset */
#define DMA_CCR_SUSP_Pos                    (2UL)
#define DMA_CCR_SUSP_Msk                    (0x1UL << DMA_CCR_SUSP_Pos)             /*!< 0x00000004 */
#define DMA_CCR_SUSP                        DMA_CCR_SUSP_Msk                        /*!< Channel suspend */
#define DMA_CCR_TCIE_Pos                    (8UL)
#define DMA_CCR_TCIE_Msk                    (0x1UL << DMA_CCR_TCIE_Pos)             /*!< 0x00000100 */
#define DMA_CCR_TCIE                        DMA_CCR_TCIE_Msk                        /*!< Transfer complete interrupt enable */
#define DMA_CCR_HTIE_Pos                    (9UL)
#define DMA_CCR_HTIE_Msk                    (0x1UL << DMA_CCR_HTIE_Pos)             /*!< 0x00000200 */
#define DMA_CCR_HTIE                        DMA_CCR_HTIE_Msk                        /*!< Half transfer complete interrupt enable */
#define DMA_CCR_DTEIE_Pos                   (10UL)
#define DMA_CCR_DTEIE_Msk                   (0x1UL << DMA_CCR_DTEIE_Pos)            /*!< 0x00000400 */
#define DMA_CCR_DTEIE                       DMA_CCR_DTEIE_Msk                       /*!< Data transfer error interrupt enable */
#define DMA_CCR_ULEIE_Pos                   (11UL)
#define DMA_CCR_ULEIE_Msk                   (0x1UL << DMA_CCR_ULEIE_Pos)            /*!< 0x00000800 */
#define DMA_CCR_ULEIE                       DMA_CCR_ULEIE_Msk                       /*!< Update linked-list item error interrupt enable */
#define DMA_CCR_USEIE_Pos                   (12UL)
#define DMA_CCR_USEIE_Msk                   (0x1UL << DMA_CCR_USEIE_Pos)            /*!< 0x00001000 */
#define DMA_CCR_USEIE                       DMA_CCR_USEIE_Msk                       /*!< User setting error interrupt enable */
#define DMA_CCR_SUSPIE_Pos                  (13UL)
#define DMA_CCR_SUSPIE_Msk                  (0x1UL << DMA_CCR_SUSPIE_Pos)           /*!< 0x00002000 */
#define DMA_CCR_SUSPIE                      DMA_CCR_SUSPIE_Msk                      /*!< Completed suspension interrupt enable */
#define DMA_CCR_TOIE_Pos                    (14UL)
#define DMA_CCR_TOIE_Msk                    (0x1UL << DMA_CCR_TOIE_Pos)             /*!< 0x00004000 */
#define DMA_CCR_TOIE                        DMA_CCR_TOIE_Msk                        /*!< Trigger overrun interrupt enable */
#define DMA_CCR_LSM_Pos                     (16UL)
#define DMA_CCR_LSM_Msk                     (0x1UL << DMA_CCR_LSM_Pos)              /*!< 0x00010000 */
#define DMA_CCR_LSM                         DMA_CCR_LSM_Msk                         /*!< Link step mode */
#define DMA_CCR_LAP_Pos                     (17UL)
#define DMA_CCR_LAP_Msk                     (0x1UL << DMA_CCR_LAP_Pos)              /*!< 0x00020000 */
#define DMA_CCR_LAP                         DMA_CCR_LAP_Msk                         /*!< Linked-list allocated port */
#define DMA_CCR_PRIO_Pos                    (22UL)
#define DMA_CCR_PRIO_Msk                    (0x3UL << DMA_CCR_PRIO_Pos)             /*!< 0x00C00000 */
#define DMA_CCR_PRIO                        DMA_CCR_PRIO_Msk                        /*!< Priority level */
#define DMA_CCR_PRIO_0                      (0x1UL << DMA_CCR_PRIO_Pos)             /*!< 0x00400000 */
#define DMA_CCR_PRIO_1                      (0x2UL << DMA_CCR_PRIO_Pos)             /*!< 0x00800000 */

/*******************  Bit definition for DMA_CTR1 register  *******************/
#define DMA_CTR1_SDW_LOG2_Pos               (0UL)
#define DMA_CTR1_SDW_LOG2_Msk               (0x3UL << DMA_CTR1_SDW_LOG2_Pos)        /*!< 0x00000003 */
#define DMA_CTR1_SDW_LOG2                   DMA_CTR1_SDW_LOG2_Msk                   /*!< Binary logarithm of the source data width of a burst */
#define DMA_CTR1_SDW_LOG2_0                 (0x1UL << DMA_CTR1_SDW_LOG2_Pos)        /*!< Bit 0 */
#define DMA_CTR1_SDW_LOG2_1                 (0x2UL << DMA_CTR1_SDW_LOG2_Pos)        /*!< Bit 1 */
#define DMA_CTR1_SINC_Pos                   (3UL)
#define DMA_CTR1_SINC_Msk                   (0x1UL << DMA_CTR1_SINC_Pos)            /*!< 0x00000008 */
#define DMA_CTR1_SINC                       DMA_CTR1_SINC_Msk                       /*!< Source incrementing burst */
#define DMA_CTR1_SBL_1_Pos                  (4UL)
#define DMA_CTR1_SBL_1_Msk                  (0x3FUL << DMA_CTR1_SBL_1_Pos)          /*!< 0x000003F0 */
#define DMA_CTR1_SBL_1                      DMA_CTR1_SBL_1_Msk                      /*!< Source burst length minus 1 */
#define DMA_CTR1_PAM_Pos                    (11UL)
#define DMA_CTR1_PAM_Msk                    (0x3UL << DMA_CTR1_PAM_Pos)             /*!< 0x0001800 */
#define DMA_CTR1_PAM                        DMA_CTR1_PAM_Msk                        /*!< Padding / alignment mode */
#define DMA_CTR1_PAM_0                      (0x1UL << DMA_CTR1_PAM_Pos)             /*!< Bit 0 */
#define DMA_CTR1_PAM_1                      (0x2UL << DMA_CTR1_PAM_Pos)             /*!< Bit 1 */
#define DMA_CTR1_SBX_Pos                    (13UL)
#define DMA_CTR1_SBX_Msk                    (0x1UL << DMA_CTR1_SBX_Pos)             /*!< 0x00002000 */
#define DMA_CTR1_SBX                        DMA_CTR1_SBX_Msk                        /*!< Source byte exchange within the unaligned half-word of each source word */
#define DMA_CTR1_SAP_Pos                    (14UL)
#define DMA_CTR1_SAP_Msk                    (0x1UL << DMA_CTR1_SAP_Pos)             /*!< 0x00004000 */
#define DMA_CTR1_SAP                        DMA_CTR1_SAP_Msk                        /*!< Source allocated port */
#define DMA_CTR1_SSEC_Pos                   (15UL)
#define DMA_CTR1_SSEC_Msk                   (0x1UL << DMA_CTR1_SSEC_Pos)            /*!< 0x00008000 */
#define DMA_CTR1_SSEC                       DMA_CTR1_SSEC_Msk                       /*!< Security attribute of the DMA transfer from the source */
#define DMA_CTR1_DDW_LOG2_Pos               (16UL)
#define DMA_CTR1_DDW_LOG2_Msk               (0x3UL << DMA_CTR1_DDW_LOG2_Pos)        /*!< 0x00030000 */
#define DMA_CTR1_DDW_LOG2                   DMA_CTR1_DDW_LOG2_Msk                   /*!< Binary logarithm of the destination data width of a burst */
#define DMA_CTR1_DDW_LOG2_0                 (0x1UL << DMA_CTR1_DDW_LOG2_Pos)        /*!< Bit 0 */
#define DMA_CTR1_DDW_LOG2_1                 (0x2UL << DMA_CTR1_DDW_LOG2_Pos)        /*!< Bit 1 */
#define DMA_CTR1_DINC_Pos                   (19UL)
#define DMA_CTR1_DINC_Msk                   (0x1UL << DMA_CTR1_DINC_Pos)            /*!< 0x00080000 */
#define DMA_CTR1_DINC                       DMA_CTR1_DINC_Msk                       /*!< Destination incrementing burst */
#define DMA_CTR1_DBL_1_Pos                  (20UL)
#define DMA_CTR1_DBL_1_Msk                  (0x3FUL << DMA_CTR1_DBL_1_Pos)          /*!< 0x03F00000 */
#define DMA_CTR1_DBL_1                      DMA_CTR1_DBL_1_Msk                      /*!< Destination burst length minus 1 */
#define DMA_CTR1_DBX_Pos                    (26UL)
#define DMA_CTR1_DBX_Msk                    (0x1UL << DMA_CTR1_DBX_Pos)             /*!< 0x04000000 */
#define DMA_CTR1_DBX                        DMA_CTR1_DBX_Msk                        /*!< Destination byte exchange */
#define DMA_CTR1_DHX_Pos                    (27UL)
#define DMA_CTR1_DHX_Msk                    (0x1UL << DMA_CTR1_DHX_Pos)             /*!< 0x08000000 */
#define DMA_CTR1_DHX                        DMA_CTR1_DHX_Msk                        /*!< Destination half-word exchange */
#define DMA_CTR1_DWX_Pos                    (28UL)
#define DMA_CTR1_DWX_Msk                    (0x1UL << DMA_CTR1_DWX_Pos)             /*!< 0x10000000 */
#define DMA_CTR1_DWX                        DMA_CTR1_DWX_Msk                        /*!< Destination word-word exchange */
#define DMA_CTR1_DAP_Pos                    (30UL)
#define DMA_CTR1_DAP_Msk                    (0x1UL << DMA_CTR1_DAP_Pos)             /*!< 0x40000000 */
#define DMA_CTR1_DAP                        DMA_CTR1_DAP_Msk                        /*!< Destination allocated port */
#define DMA_CTR1_DSEC_Pos                   (31UL)
#define DMA_CTR1_DSEC_Msk                   (0x1UL << DMA_CTR1_DSEC_Pos)            /*!< 0x80000000 */
#define DMA_CTR1_DSEC                       DMA_CTR1_DSEC_Msk                       /*!< Security attribute of the DMA transfer from the destination */

/******************  Bit definition for DMA_CTR2 register  *******************/
#define DMA_CTR2_REQSEL_Pos                 (0UL)
#define DMA_CTR2_REQSEL_Msk                 (0xFFUL << DMA_CTR2_REQSEL_Pos)         /*!< 0x000000FF */
#define DMA_CTR2_REQSEL                     DMA_CTR2_REQSEL_Msk                     /*!< DMA hardware request selection */
#define DMA_CTR2_SWREQ_Pos                  (9UL)
#define DMA_CTR2_SWREQ_Msk                  (0x1UL << DMA_CTR2_SWREQ_Pos)           /*!< 0x00000200 */
#define DMA_CTR2_SWREQ                      DMA_CTR2_SWREQ_Msk                      /*!< Software request */
#define DMA_CTR2_DREQ_Pos                   (10UL)
#define DMA_CTR2_DREQ_Msk                   (0x1UL << DMA_CTR2_DREQ_Pos)            /*!< 0x00000400 */
#define DMA_CTR2_DREQ                       DMA_CTR2_DREQ_Msk                       /*!< Destination hardware request */
#define DMA_CTR2_BREQ_Pos                   (11UL)
#define DMA_CTR2_BREQ_Msk                   (0x1UL << DMA_CTR2_BREQ_Pos)            /*!< 0x00000800 */
#define DMA_CTR2_BREQ                       DMA_CTR2_BREQ_Msk                       /*!< Block hardware request */
#define DMA_CTR2_PFREQ_Pos                  (12UL)
#define DMA_CTR2_PFREQ_Msk                  (0x1UL << DMA_CTR2_PFREQ_Pos)           /*!< 0x00001000 */
#define DMA_CTR2_PFREQ                      DMA_CTR2_PFREQ_Msk                      /*!< Hardware request in peripheral flow control mode */
#define DMA_CTR2_TRIGM_Pos                  (14UL)
#define DMA_CTR2_TRIGM_Msk                  (0x3UL << DMA_CTR2_TRIGM_Pos)           /*!< 0x0000C000 */
#define DMA_CTR2_TRIGM                      DMA_CTR2_TRIGM_Msk                      /*!< Trigger mode */
#define DMA_CTR2_TRIGM_0                    (0x1UL << DMA_CTR2_TRIGM_Pos)           /*!< Bit 0 */
#define DMA_CTR2_TRIGM_1                    (0x2UL << DMA_CTR2_TRIGM_Pos)           /*!< Bit 1 */
#define DMA_CTR2_TRIGSEL_Pos                (16UL)
#define DMA_CTR2_TRIGSEL_Msk                (0x7FUL << DMA_CTR2_TRIGSEL_Pos)        /*!< 0x007F0000 */
#define DMA_CTR2_TRIGSEL                    DMA_CTR2_TRIGSEL_Msk                    /*!< Trigger event input selection */
#define DMA_CTR2_TRIGPOL_Pos                (24UL)
#define DMA_CTR2_TRIGPOL_Msk                (0x3UL << DMA_CTR2_TRIGPOL_Pos)         /*!< 0x03000000 */
#define DMA_CTR2_TRIGPOL                    DMA_CTR2_TRIGPOL_Msk                    /*!< Trigger event polarity */
#define DMA_CTR2_TRIGPOL_0                  (0x1UL << DMA_CTR2_TRIGPOL_Pos)         /*!< Bit 0 */
#define DMA_CTR2_TRIGPOL_1                  (0x2UL << DMA_CTR2_TRIGPOL_Pos)         /*!< Bit 1 */
#define DMA_CTR2_TCEM_Pos                   (30UL)
#define DMA_CTR2_TCEM_Msk                   (0x3UL << DMA_CTR2_TCEM_Pos)            /*!< 0xC0000000 */
#define DMA_CTR2_TCEM                       DMA_CTR2_TCEM_Msk                       /*!< Transfer complete event mode */
#define DMA_CTR2_TCEM_0                     (0x1UL << DMA_CTR2_TCEM_Pos)            /*!< Bit 0 */
#define DMA_CTR2_TCEM_1                     (0x2UL << DMA_CTR2_TCEM_Pos)            /*!< Bit 1 */

/******************  Bit definition for DMA_CBR1 register  *******************/
#define DMA_CBR1_BNDT_Pos                   (0UL)
#define DMA_CBR1_BNDT_Msk                   (0xFFFFUL << DMA_CBR1_BNDT_Pos)         /*!< 0x0000FFFF */
#define DMA_CBR1_BNDT                       DMA_CBR1_BNDT_Msk                       /*!< Block number of data bytes to transfer from the source */
#define DMA_CBR1_BRC_Pos                    (16UL)
#define DMA_CBR1_BRC_Msk                    (0x7FFUL << DMA_CBR1_BRC_Pos)           /*!< 0x07FF0000 */
#define DMA_CBR1_BRC                        DMA_CBR1_BRC_Msk                        /*!< Block repeat counter */
#define DMA_CBR1_SDEC_Pos                   (28UL)
#define DMA_CBR1_SDEC_Msk                   (0x1UL << DMA_CBR1_SDEC_Pos)            /*!< 0x10000000 */
#define DMA_CBR1_SDEC                       DMA_CBR1_SDEC_Msk                       /*!< Source address decrement */
#define DMA_CBR1_DDEC_Pos                   (29UL)
#define DMA_CBR1_DDEC_Msk                   (0x1UL << DMA_CBR1_DDEC_Pos)            /*!< 0x20000000 */
#define DMA_CBR1_DDEC                       DMA_CBR1_DDEC_Msk                       /*!< Destination address decrement */
#define DMA_CBR1_BRSDEC_Pos                 (30UL)
#define DMA_CBR1_BRSDEC_Msk                 (0x1UL << DMA_CBR1_BRSDEC_Pos)          /*!< 0x40000000 */
#define DMA_CBR1_BRSDEC                     DMA_CBR1_BRSDEC_Msk                     /*!< Block repeat source address decrement */
#define DMA_CBR1_BRDDEC_Pos                 (31UL)
#define DMA_CBR1_BRDDEC_Msk                 (0x1UL << DMA_CBR1_BRDDEC_Pos)          /*!< 0x80000000 */
#define DMA_CBR1_BRDDEC                     DMA_CBR1_BRDDEC_Msk                     /*!< Block repeat destination address decrement */

/******************  Bit definition for DMA_CSAR register  ********************/
#define DMA_CSAR_SA_Pos                     (0UL)
#define DMA_CSAR_SA_Msk                     (0xFFFFFFFFUL << DMA_CSAR_SA_Pos)       /*!< 0xFFFFFFFF */
#define DMA_CSAR_SA                         DMA_CSAR_SA_Msk                         /*!< Source Address */

/******************  Bit definition for DMA_CDAR register  *******************/
#define DMA_CDAR_DA_Pos                     (0UL)
#define DMA_CDAR_DA_Msk                     (0xFFFFFFFFUL << DMA_CDAR_DA_Pos)       /*!< 0xFFFFFFFF */
#define DMA_CDAR_DA                         DMA_CDAR_DA_Msk                         /*!< Destination address */

/******************  Bit definition for DMA_CTR3 register  *******************/
#define DMA_CTR3_SAO_Pos                    (0UL)
#define DMA_CTR3_SAO_Msk                    (0x1FFFUL << DMA_CTR3_SAO_Pos)          /*!< 0x00001FFF */
#define DMA_CTR3_SAO                        DMA_CTR3_SAO_Msk                        /*!< Source address offset increment */
#define DMA_CTR3_DAO_Pos                    (16UL)
#define DMA_CTR3_DAO_Msk                    (0x1FFFUL << DMA_CTR3_DAO_Pos)          /*!< 0x1FFF0000 */
#define DMA_CTR3_DAO                        DMA_CTR3_DAO_Msk                        /*!< Destination address offset increment */

/******************  Bit definition for DMA_CBR2 register  *******************/
#define DMA_CBR2_BRSAO_Pos                  (0UL)
#define DMA_CBR2_BRSAO_Msk                  (0xFFFFUL << DMA_CBR2_BRSAO_Pos)        /*!< 0x0000FFFF */
#define DMA_CBR2_BRSAO                      DMA_CBR2_BRSAO_Msk                      /*!< Block repeated source address offset */
#define DMA_CBR2_BRDAO_Pos                  (16UL)
#define DMA_CBR2_BRDAO_Msk                  (0xFFFFUL << DMA_CBR2_BRDAO_Pos)        /*!< 0xFFFF0000 */
#define DMA_CBR2_BRDAO                      DMA_CBR2_BRDAO_Msk                      /*!< Block repeated destination address offset */

/******************  Bit definition for DMA_CLLR register  *******************/
#define DMA_CLLR_LA_Pos                     (2UL)
#define DMA_CLLR_LA_Msk                     (0x3FFFUL << DMA_CLLR_LA_Pos)           /*!< 0x0000FFFC */
#define DMA_CLLR_LA                         DMA_CLLR_LA_Msk                         /*!< Pointer to the next linked-list data structure */
#define DMA_CLLR_ULL_Pos                    (16UL)
#define DMA_CLLR_ULL_Msk                    (0x1UL << DMA_CLLR_ULL_Pos)             /*!< 0x00010000 */
#define DMA_CLLR_ULL                        DMA_CLLR_ULL_Msk                        /*!< Update link address register from memory */
#define DMA_CLLR_UB2_Pos                    (25UL)
#define DMA_CLLR_UB2_Msk                    (0x1UL << DMA_CLLR_UB2_Pos)             /*!< 0x02000000 */
#define DMA_CLLR_UB2                        DMA_CLLR_UB2_Msk                        /*!< Update block register 2 from memory */
#define DMA_CLLR_UT3_Pos                    (26UL)
#define DMA_CLLR_UT3_Msk                    (0x1UL << DMA_CLLR_UT3_Pos)             /*!< 0x04000000 */
#define DMA_CLLR_UT3                        DMA_CLLR_UT3_Msk                        /*!< Update transfer register 3 from SRAM */
#define DMA_CLLR_UDA_Pos                    (27UL)
#define DMA_CLLR_UDA_Msk                    (0x1UL << DMA_CLLR_UDA_Pos)             /*!< 0x08000000 */
#define DMA_CLLR_UDA                        DMA_CLLR_UDA_Msk                        /*!< Update destination address register from SRAM */
#define DMA_CLLR_USA_Pos                    (28UL)
#define DMA_CLLR_USA_Msk                    (0x1UL << DMA_CLLR_USA_Pos)             /*!< 0x10000000 */
#define DMA_CLLR_USA                        DMA_CLLR_USA_Msk                        /*!< Update source address register from SRAM */
#define DMA_CLLR_UB1_Pos                    (29UL)
#define DMA_CLLR_UB1_Msk                    (0x1UL << DMA_CLLR_UB1_Pos)             /*!< 0x20000000 */
#define DMA_CLLR_UB1                        DMA_CLLR_UB1_Msk                        /*!< Update block register 1 from SRAM */
#define DMA_CLLR_UT2_Pos                    (30UL)
#define DMA_CLLR_UT2_Msk                    (0x1UL << DMA_CLLR_UT2_Pos)             /*!< 0x40000000 */
#define DMA_CLLR_UT2                        DMA_CLLR_UT2_Msk                        /*!< Update transfer register 2 from SRAM */
#define DMA_CLLR_UT1_Pos                    (31UL)
#define DMA_CLLR_UT1_Msk                    (0x1UL << DMA_CLLR_UT1_Pos)             /*!< 0x80000000 */
#define DMA_CLLR_UT1                        DMA_CLLR_UT1_Msk                        /*!< Update transfer register 1 from SRAM */


/******************************************************************************/
/*                                                                            */
/*                          DMA2D Controller (DMA2D)                          */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for DMA2D_CR register  ******************/
#define DMA2D_CR_START_Pos         (0UL)
#define DMA2D_CR_START_Msk         (0x1UL << DMA2D_CR_START_Pos)               /*!< 0x00000001 */
#define DMA2D_CR_START             DMA2D_CR_START_Msk                          /*!< Start transfer */
#define DMA2D_CR_SUSP_Pos          (1UL)
#define DMA2D_CR_SUSP_Msk          (0x1UL << DMA2D_CR_SUSP_Pos)                /*!< 0x00000002 */
#define DMA2D_CR_SUSP              DMA2D_CR_SUSP_Msk                           /*!< Suspend transfer */
#define DMA2D_CR_ABORT_Pos         (2UL)
#define DMA2D_CR_ABORT_Msk         (0x1UL << DMA2D_CR_ABORT_Pos)               /*!< 0x00000004 */
#define DMA2D_CR_ABORT             DMA2D_CR_ABORT_Msk                          /*!< Abort transfer */
#define DMA2D_CR_LOM_Pos           (6UL)
#define DMA2D_CR_LOM_Msk           (0x1UL << DMA2D_CR_LOM_Pos)                 /*!< 0x00000040 */
#define DMA2D_CR_LOM               DMA2D_CR_LOM_Msk                            /*!< Line Offset Mode */
#define DMA2D_CR_TEIE_Pos          (8UL)
#define DMA2D_CR_TEIE_Msk          (0x1UL << DMA2D_CR_TEIE_Pos)                /*!< 0x00000100 */
#define DMA2D_CR_TEIE              DMA2D_CR_TEIE_Msk                           /*!< Transfer Error Interrupt Enable */
#define DMA2D_CR_TCIE_Pos          (9UL)
#define DMA2D_CR_TCIE_Msk          (0x1UL << DMA2D_CR_TCIE_Pos)                /*!< 0x00000200 */
#define DMA2D_CR_TCIE              DMA2D_CR_TCIE_Msk                           /*!< Transfer Complete Interrupt Enable */
#define DMA2D_CR_TWIE_Pos          (10UL)
#define DMA2D_CR_TWIE_Msk          (0x1UL << DMA2D_CR_TWIE_Pos)                /*!< 0x00000400 */
#define DMA2D_CR_TWIE              DMA2D_CR_TWIE_Msk                           /*!< Transfer Watermark Interrupt Enable */
#define DMA2D_CR_CAEIE_Pos         (11UL)
#define DMA2D_CR_CAEIE_Msk         (0x1UL << DMA2D_CR_CAEIE_Pos)               /*!< 0x00000800 */
#define DMA2D_CR_CAEIE             DMA2D_CR_CAEIE_Msk                          /*!< CLUT Access Error Interrupt Enable */
#define DMA2D_CR_CTCIE_Pos         (12UL)
#define DMA2D_CR_CTCIE_Msk         (0x1UL << DMA2D_CR_CTCIE_Pos)               /*!< 0x00001000 */
#define DMA2D_CR_CTCIE             DMA2D_CR_CTCIE_Msk                          /*!< CLUT Transfer Complete Interrupt Enable */
#define DMA2D_CR_CEIE_Pos          (13UL)
#define DMA2D_CR_CEIE_Msk          (0x1UL << DMA2D_CR_CEIE_Pos)                /*!< 0x00002000 */
#define DMA2D_CR_CEIE              DMA2D_CR_CEIE_Msk                           /*!< Configuration Error Interrupt Enable */
#define DMA2D_CR_MODE_Pos          (16UL)
#define DMA2D_CR_MODE_Msk          (0x7UL << DMA2D_CR_MODE_Pos)                /*!< 0x00070000 */
#define DMA2D_CR_MODE              DMA2D_CR_MODE_Msk                           /*!< DMA2D Mode[2:0] */
#define DMA2D_CR_MODE_0            (0x1UL << DMA2D_CR_MODE_Pos)                /*!< 0x00010000 */
#define DMA2D_CR_MODE_1            (0x2UL << DMA2D_CR_MODE_Pos)                /*!< 0x00020000 */
#define DMA2D_CR_MODE_2            (0x4UL << DMA2D_CR_MODE_Pos)                /*!< 0x00040000 */

/********************  Bit definition for DMA2D_ISR register  *****************/
#define DMA2D_ISR_TEIF_Pos         (0UL)
#define DMA2D_ISR_TEIF_Msk         (0x1UL << DMA2D_ISR_TEIF_Pos)               /*!< 0x00000001 */
#define DMA2D_ISR_TEIF             DMA2D_ISR_TEIF_Msk                          /*!< Transfer Error Interrupt Flag */
#define DMA2D_ISR_TCIF_Pos         (1UL)
#define DMA2D_ISR_TCIF_Msk         (0x1UL << DMA2D_ISR_TCIF_Pos)               /*!< 0x00000002 */
#define DMA2D_ISR_TCIF             DMA2D_ISR_TCIF_Msk                          /*!< Transfer Complete Interrupt Flag */
#define DMA2D_ISR_TWIF_Pos         (2UL)
#define DMA2D_ISR_TWIF_Msk         (0x1UL << DMA2D_ISR_TWIF_Pos)               /*!< 0x00000004 */
#define DMA2D_ISR_TWIF             DMA2D_ISR_TWIF_Msk                          /*!< Transfer Watermark Interrupt Flag */
#define DMA2D_ISR_CAEIF_Pos        (3UL)
#define DMA2D_ISR_CAEIF_Msk        (0x1UL << DMA2D_ISR_CAEIF_Pos)              /*!< 0x00000008 */
#define DMA2D_ISR_CAEIF            DMA2D_ISR_CAEIF_Msk                         /*!< CLUT Access Error Interrupt Flag */
#define DMA2D_ISR_CTCIF_Pos        (4UL)
#define DMA2D_ISR_CTCIF_Msk        (0x1UL << DMA2D_ISR_CTCIF_Pos)              /*!< 0x00000010 */
#define DMA2D_ISR_CTCIF            DMA2D_ISR_CTCIF_Msk                         /*!< CLUT Transfer Complete Interrupt Flag */
#define DMA2D_ISR_CEIF_Pos         (5UL)
#define DMA2D_ISR_CEIF_Msk         (0x1UL << DMA2D_ISR_CEIF_Pos)               /*!< 0x00000020 */
#define DMA2D_ISR_CEIF             DMA2D_ISR_CEIF_Msk                          /*!< Configuration Error Interrupt Flag */

/********************  Bit definition for DMA2D_IFCR register  ****************/
#define DMA2D_IFCR_CTEIF_Pos       (0UL)
#define DMA2D_IFCR_CTEIF_Msk       (0x1UL << DMA2D_IFCR_CTEIF_Pos)             /*!< 0x00000001 */
#define DMA2D_IFCR_CTEIF           DMA2D_IFCR_CTEIF_Msk                        /*!< Clears Transfer Error Interrupt Flag */
#define DMA2D_IFCR_CTCIF_Pos       (1UL)
#define DMA2D_IFCR_CTCIF_Msk       (0x1UL << DMA2D_IFCR_CTCIF_Pos)             /*!< 0x00000002 */
#define DMA2D_IFCR_CTCIF           DMA2D_IFCR_CTCIF_Msk                        /*!< Clears Transfer Complete Interrupt Flag */
#define DMA2D_IFCR_CTWIF_Pos       (2UL)
#define DMA2D_IFCR_CTWIF_Msk       (0x1UL << DMA2D_IFCR_CTWIF_Pos)             /*!< 0x00000004 */
#define DMA2D_IFCR_CTWIF           DMA2D_IFCR_CTWIF_Msk                        /*!< Clears Transfer Watermark Interrupt Flag */
#define DMA2D_IFCR_CAECIF_Pos      (3UL)
#define DMA2D_IFCR_CAECIF_Msk      (0x1UL << DMA2D_IFCR_CAECIF_Pos)            /*!< 0x00000008 */
#define DMA2D_IFCR_CAECIF          DMA2D_IFCR_CAECIF_Msk                       /*!< Clears CLUT Access Error Interrupt Flag */
#define DMA2D_IFCR_CCTCIF_Pos      (4UL)
#define DMA2D_IFCR_CCTCIF_Msk      (0x1UL << DMA2D_IFCR_CCTCIF_Pos)            /*!< 0x00000010 */
#define DMA2D_IFCR_CCTCIF          DMA2D_IFCR_CCTCIF_Msk                       /*!< Clears CLUT Transfer Complete Interrupt Flag */
#define DMA2D_IFCR_CCEIF_Pos       (5UL)
#define DMA2D_IFCR_CCEIF_Msk       (0x1UL << DMA2D_IFCR_CCEIF_Pos)             /*!< 0x00000020 */
#define DMA2D_IFCR_CCEIF           DMA2D_IFCR_CCEIF_Msk                        /*!< Clears Configuration Error Interrupt Flag */

/********************  Bit definition for DMA2D_FGMAR register  ***************/
#define DMA2D_FGMAR_MA_Pos         (0UL)
#define DMA2D_FGMAR_MA_Msk         (0xFFFFFFFFUL << DMA2D_FGMAR_MA_Pos)        /*!< 0xFFFFFFFF */
#define DMA2D_FGMAR_MA             DMA2D_FGMAR_MA_Msk                          /*!< Memory Address */

/********************  Bit definition for DMA2D_FGOR register  ****************/
#define DMA2D_FGOR_LO_Pos          (0UL)
#define DMA2D_FGOR_LO_Msk          (0xFFFFUL << DMA2D_FGOR_LO_Pos)             /*!< 0x0000FFFF */
#define DMA2D_FGOR_LO              DMA2D_FGOR_LO_Msk                           /*!< Line Offset */

/********************  Bit definition for DMA2D_BGMAR register  ***************/
#define DMA2D_BGMAR_MA_Pos         (0UL)
#define DMA2D_BGMAR_MA_Msk         (0xFFFFFFFFUL << DMA2D_BGMAR_MA_Pos)        /*!< 0xFFFFFFFF */
#define DMA2D_BGMAR_MA             DMA2D_BGMAR_MA_Msk                          /*!< Memory Address */

/********************  Bit definition for DMA2D_BGOR register  ****************/
#define DMA2D_BGOR_LO_Pos          (0UL)
#define DMA2D_BGOR_LO_Msk          (0xFFFFUL << DMA2D_BGOR_LO_Pos)             /*!< 0x0000FFFF */
#define DMA2D_BGOR_LO              DMA2D_BGOR_LO_Msk                           /*!< Line Offset */

/********************  Bit definition for DMA2D_FGPFCCR register  *************/
#define DMA2D_FGPFCCR_CM_Pos       (0UL)
#define DMA2D_FGPFCCR_CM_Msk       (0xFUL << DMA2D_FGPFCCR_CM_Pos)             /*!< 0x0000000F */
#define DMA2D_FGPFCCR_CM           DMA2D_FGPFCCR_CM_Msk                        /*!< Input color mode CM[3:0] */
#define DMA2D_FGPFCCR_CM_0         (0x1UL << DMA2D_FGPFCCR_CM_Pos)             /*!< 0x00000001 */
#define DMA2D_FGPFCCR_CM_1         (0x2UL << DMA2D_FGPFCCR_CM_Pos)             /*!< 0x00000002 */
#define DMA2D_FGPFCCR_CM_2         (0x4UL << DMA2D_FGPFCCR_CM_Pos)             /*!< 0x00000004 */
#define DMA2D_FGPFCCR_CM_3         (0x8UL << DMA2D_FGPFCCR_CM_Pos)             /*!< 0x00000008 */
#define DMA2D_FGPFCCR_CCM_Pos      (4UL)
#define DMA2D_FGPFCCR_CCM_Msk      (0x1UL << DMA2D_FGPFCCR_CCM_Pos)            /*!< 0x00000010 */
#define DMA2D_FGPFCCR_CCM          DMA2D_FGPFCCR_CCM_Msk                       /*!< CLUT Color mode */
#define DMA2D_FGPFCCR_START_Pos    (5UL)
#define DMA2D_FGPFCCR_START_Msk    (0x1UL << DMA2D_FGPFCCR_START_Pos)          /*!< 0x00000020 */
#define DMA2D_FGPFCCR_START        DMA2D_FGPFCCR_START_Msk                     /*!< Start */
#define DMA2D_FGPFCCR_CS_Pos       (8UL)
#define DMA2D_FGPFCCR_CS_Msk       (0xFFUL << DMA2D_FGPFCCR_CS_Pos)            /*!< 0x0000FF00 */
#define DMA2D_FGPFCCR_CS           DMA2D_FGPFCCR_CS_Msk                        /*!< CLUT size */
#define DMA2D_FGPFCCR_AM_Pos       (16UL)
#define DMA2D_FGPFCCR_AM_Msk       (0x3UL << DMA2D_FGPFCCR_AM_Pos)             /*!< 0x00030000 */
#define DMA2D_FGPFCCR_AM           DMA2D_FGPFCCR_AM_Msk                        /*!< Alpha mode AM[1:0] */
#define DMA2D_FGPFCCR_AM_0         (0x1UL << DMA2D_FGPFCCR_AM_Pos)             /*!< 0x00010000 */
#define DMA2D_FGPFCCR_AM_1         (0x2UL << DMA2D_FGPFCCR_AM_Pos)             /*!< 0x00020000 */
#define DMA2D_FGPFCCR_CSS_Pos      (18UL)
#define DMA2D_FGPFCCR_CSS_Msk      (0x3UL << DMA2D_FGPFCCR_CSS_Pos)            /*!< 0x000C0000 */
#define DMA2D_FGPFCCR_CSS          DMA2D_FGPFCCR_CSS_Msk                       /*!< Chroma Sub-Sampling */
#define DMA2D_FGPFCCR_CSS_0        (0x1UL << DMA2D_FGPFCCR_CSS_Pos)            /*!< 0x00040000 */
#define DMA2D_FGPFCCR_CSS_1        (0x2UL << DMA2D_FGPFCCR_CSS_Pos)            /*!< 0x00080000 */
#define DMA2D_FGPFCCR_AI_Pos       (20UL)
#define DMA2D_FGPFCCR_AI_Msk       (0x1UL << DMA2D_FGPFCCR_AI_Pos)             /*!< 0x00100000 */
#define DMA2D_FGPFCCR_AI           DMA2D_FGPFCCR_AI_Msk                        /*!< Alpha Inverted */
#define DMA2D_FGPFCCR_RBS_Pos      (21UL)
#define DMA2D_FGPFCCR_RBS_Msk      (0x1UL << DMA2D_FGPFCCR_RBS_Pos)            /*!< 0x00200000 */
#define DMA2D_FGPFCCR_RBS          DMA2D_FGPFCCR_RBS_Msk                       /*!< Red Blue Swap */
#define DMA2D_FGPFCCR_ALPHA_Pos    (24UL)
#define DMA2D_FGPFCCR_ALPHA_Msk    (0xFFUL << DMA2D_FGPFCCR_ALPHA_Pos)         /*!< 0xFF000000 */
#define DMA2D_FGPFCCR_ALPHA        DMA2D_FGPFCCR_ALPHA_Msk                     /*!< Alpha value */

/********************  Bit definition for DMA2D_FGCOLR register  **************/
#define DMA2D_FGCOLR_BLUE_Pos      (0UL)
#define DMA2D_FGCOLR_BLUE_Msk      (0xFFUL << DMA2D_FGCOLR_BLUE_Pos)           /*!< 0x000000FF */
#define DMA2D_FGCOLR_BLUE          DMA2D_FGCOLR_BLUE_Msk                       /*!< Blue Value */
#define DMA2D_FGCOLR_GREEN_Pos     (8UL)
#define DMA2D_FGCOLR_GREEN_Msk     (0xFFUL << DMA2D_FGCOLR_GREEN_Pos)          /*!< 0x0000FF00 */
#define DMA2D_FGCOLR_GREEN         DMA2D_FGCOLR_GREEN_Msk                      /*!< Green Value */
#define DMA2D_FGCOLR_RED_Pos       (16UL)
#define DMA2D_FGCOLR_RED_Msk       (0xFFUL << DMA2D_FGCOLR_RED_Pos)            /*!< 0x00FF0000 */
#define DMA2D_FGCOLR_RED           DMA2D_FGCOLR_RED_Msk                        /*!< Red Value */

/********************  Bit definition for DMA2D_BGPFCCR register  *************/
#define DMA2D_BGPFCCR_CM_Pos       (0UL)
#define DMA2D_BGPFCCR_CM_Msk       (0xFUL << DMA2D_BGPFCCR_CM_Pos)             /*!< 0x0000000F */
#define DMA2D_BGPFCCR_CM           DMA2D_BGPFCCR_CM_Msk                        /*!< Input color mode CM[3:0] */
#define DMA2D_BGPFCCR_CM_0         (0x1UL << DMA2D_BGPFCCR_CM_Pos)             /*!< 0x00000001 */
#define DMA2D_BGPFCCR_CM_1         (0x2UL << DMA2D_BGPFCCR_CM_Pos)             /*!< 0x00000002 */
#define DMA2D_BGPFCCR_CM_2         (0x4UL << DMA2D_BGPFCCR_CM_Pos)             /*!< 0x00000004 */
#define DMA2D_BGPFCCR_CM_3         (0x8UL << DMA2D_BGPFCCR_CM_Pos)             /*!< 0x00000008 */
#define DMA2D_BGPFCCR_CCM_Pos      (4UL)
#define DMA2D_BGPFCCR_CCM_Msk      (0x1UL << DMA2D_BGPFCCR_CCM_Pos)            /*!< 0x00000010 */
#define DMA2D_BGPFCCR_CCM          DMA2D_BGPFCCR_CCM_Msk                       /*!< CLUT Color mode */
#define DMA2D_BGPFCCR_START_Pos    (5UL)
#define DMA2D_BGPFCCR_START_Msk    (0x1UL << DMA2D_BGPFCCR_START_Pos)          /*!< 0x00000020 */
#define DMA2D_BGPFCCR_START        DMA2D_BGPFCCR_START_Msk                     /*!< Start */
#define DMA2D_BGPFCCR_CS_Pos       (8UL)
#define DMA2D_BGPFCCR_CS_Msk       (0xFFUL << DMA2D_BGPFCCR_CS_Pos)            /*!< 0x0000FF00 */
#define DMA2D_BGPFCCR_CS           DMA2D_BGPFCCR_CS_Msk                        /*!< CLUT size */
#define DMA2D_BGPFCCR_AM_Pos       (16UL)
#define DMA2D_BGPFCCR_AM_Msk       (0x3UL << DMA2D_BGPFCCR_AM_Pos)             /*!< 0x00030000 */
#define DMA2D_BGPFCCR_AM           DMA2D_BGPFCCR_AM_Msk                        /*!< Alpha mode AM[1:0] */
#define DMA2D_BGPFCCR_AM_0         (0x1UL << DMA2D_BGPFCCR_AM_Pos)             /*!< 0x00010000 */
#define DMA2D_BGPFCCR_AM_1         (0x2UL << DMA2D_BGPFCCR_AM_Pos)             /*!< 0x00020000 */
#define DMA2D_BGPFCCR_AI_Pos       (20UL)
#define DMA2D_BGPFCCR_AI_Msk       (0x1UL << DMA2D_BGPFCCR_AI_Pos)             /*!< 0x00100000 */
#define DMA2D_BGPFCCR_AI           DMA2D_BGPFCCR_AI_Msk                        /*!< Alpha Inverted */
#define DMA2D_BGPFCCR_RBS_Pos      (21UL)
#define DMA2D_BGPFCCR_RBS_Msk      (0x1UL << DMA2D_BGPFCCR_RBS_Pos)            /*!< 0x00200000 */
#define DMA2D_BGPFCCR_RBS          DMA2D_BGPFCCR_RBS_Msk                       /*!< Red Blue Swap */
#define DMA2D_BGPFCCR_ALPHA_Pos    (24UL)
#define DMA2D_BGPFCCR_ALPHA_Msk    (0xFFUL << DMA2D_BGPFCCR_ALPHA_Pos)         /*!< 0xFF000000 */
#define DMA2D_BGPFCCR_ALPHA        DMA2D_BGPFCCR_ALPHA_Msk                     /*!< Alpha value */

/********************  Bit definition for DMA2D_BGCOLR register  **************/
#define DMA2D_BGCOLR_BLUE_Pos      (0UL)
#define DMA2D_BGCOLR_BLUE_Msk      (0xFFUL << DMA2D_BGCOLR_BLUE_Pos)           /*!< 0x000000FF */
#define DMA2D_BGCOLR_BLUE          DMA2D_BGCOLR_BLUE_Msk                       /*!< Blue Value */
#define DMA2D_BGCOLR_GREEN_Pos     (8UL)
#define DMA2D_BGCOLR_GREEN_Msk     (0xFFUL << DMA2D_BGCOLR_GREEN_Pos)          /*!< 0x0000FF00 */
#define DMA2D_BGCOLR_GREEN         DMA2D_BGCOLR_GREEN_Msk                      /*!< Green Value */
#define DMA2D_BGCOLR_RED_Pos       (16UL)
#define DMA2D_BGCOLR_RED_Msk       (0xFFUL << DMA2D_BGCOLR_RED_Pos)            /*!< 0x00FF0000 */
#define DMA2D_BGCOLR_RED           DMA2D_BGCOLR_RED_Msk                        /*!< Red Value */

/********************  Bit definition for DMA2D_FGCMAR register  **************/
#define DMA2D_FGCMAR_MA_Pos        (0UL)
#define DMA2D_FGCMAR_MA_Msk        (0xFFFFFFFFUL << DMA2D_FGCMAR_MA_Pos)       /*!< 0xFFFFFFFF */
#define DMA2D_FGCMAR_MA            DMA2D_FGCMAR_MA_Msk                         /*!< Memory Address */

/********************  Bit definition for DMA2D_BGCMAR register  **************/
#define DMA2D_BGCMAR_MA_Pos        (0UL)
#define DMA2D_BGCMAR_MA_Msk        (0xFFFFFFFFUL << DMA2D_BGCMAR_MA_Pos)       /*!< 0xFFFFFFFF */
#define DMA2D_BGCMAR_MA            DMA2D_BGCMAR_MA_Msk                         /*!< Memory Address */

/********************  Bit definition for DMA2D_OPFCCR register  **************/
#define DMA2D_OPFCCR_CM_Pos        (0UL)
#define DMA2D_OPFCCR_CM_Msk        (0x7UL << DMA2D_OPFCCR_CM_Pos)              /*!< 0x00000007 */
#define DMA2D_OPFCCR_CM            DMA2D_OPFCCR_CM_Msk                         /*!< Color mode CM[2:0] */
#define DMA2D_OPFCCR_CM_0          (0x1UL << DMA2D_OPFCCR_CM_Pos)              /*!< 0x00000001 */
#define DMA2D_OPFCCR_CM_1          (0x2UL << DMA2D_OPFCCR_CM_Pos)              /*!< 0x00000002 */
#define DMA2D_OPFCCR_CM_2          (0x4UL << DMA2D_OPFCCR_CM_Pos)              /*!< 0x00000004 */
#define DMA2D_OPFCCR_SB_Pos        (8UL)
#define DMA2D_OPFCCR_SB_Msk        (0x1UL << DMA2D_OPFCCR_SB_Pos)              /*!< 0x00000100 */
#define DMA2D_OPFCCR_SB            DMA2D_OPFCCR_SB_Msk                         /*!< Swap Bytes */
#define DMA2D_OPFCCR_AI_Pos        (20UL)
#define DMA2D_OPFCCR_AI_Msk        (0x1UL << DMA2D_OPFCCR_AI_Pos)              /*!< 0x00100000 */
#define DMA2D_OPFCCR_AI            DMA2D_OPFCCR_AI_Msk                         /*!< Alpha Inverted */
#define DMA2D_OPFCCR_RBS_Pos       (21UL)
#define DMA2D_OPFCCR_RBS_Msk       (0x1UL << DMA2D_OPFCCR_RBS_Pos)             /*!< 0x00200000 */
#define DMA2D_OPFCCR_RBS           DMA2D_OPFCCR_RBS_Msk                        /*!< Red Blue Swap */

/********************  Bit definition for DMA2D_OCOLR register  ***************/
/*!<Mode_ARGB8888/RGB888 */
#define DMA2D_OCOLR_BLUE_1         (0x000000FFUL)                              /*!< Blue Value */
#define DMA2D_OCOLR_GREEN_1        (0x0000FF00UL)                              /*!< Green Value  */
#define DMA2D_OCOLR_RED_1          (0x00FF0000UL)                              /*!< Red Value */
#define DMA2D_OCOLR_ALPHA_1        (0xFF000000UL)                              /*!< Alpha Channel Value */

/*!<Mode_RGB565 */
#define DMA2D_OCOLR_BLUE_2         (0x0000001FUL)                              /*!< Blue Value */
#define DMA2D_OCOLR_GREEN_2        (0x000007E0UL)                              /*!< Green Value  */
#define DMA2D_OCOLR_RED_2          (0x0000F800UL)                              /*!< Red Value */

/*!<Mode_ARGB1555 */
#define DMA2D_OCOLR_BLUE_3         (0x0000001FUL)                              /*!< Blue Value */
#define DMA2D_OCOLR_GREEN_3        (0x000003E0UL)                              /*!< Green Value  */
#define DMA2D_OCOLR_RED_3          (0x00007C00UL)                              /*!< Red Value */
#define DMA2D_OCOLR_ALPHA_3        (0x00008000UL)                              /*!< Alpha Channel Value */

/*!<Mode_ARGB4444 */
#define DMA2D_OCOLR_BLUE_4         (0x0000000FUL)                              /*!< Blue Value */
#define DMA2D_OCOLR_GREEN_4        (0x000000F0UL)                              /*!< Green Value  */
#define DMA2D_OCOLR_RED_4          (0x00000F00UL)                              /*!< Red Value */
#define DMA2D_OCOLR_ALPHA_4        (0x0000F000UL)                              /*!< Alpha Channel Value */

/********************  Bit definition for DMA2D_OMAR register  ****************/
#define DMA2D_OMAR_MA_Pos          (0UL)
#define DMA2D_OMAR_MA_Msk          (0xFFFFFFFFUL << DMA2D_OMAR_MA_Pos)         /*!< 0xFFFFFFFF */
#define DMA2D_OMAR_MA              DMA2D_OMAR_MA_Msk                           /*!< Memory Address */

/********************  Bit definition for DMA2D_OOR register  *****************/
#define DMA2D_OOR_LO_Pos           (0UL)
#define DMA2D_OOR_LO_Msk           (0xFFFFUL << DMA2D_OOR_LO_Pos)              /*!< 0x0000FFFF */
#define DMA2D_OOR_LO               DMA2D_OOR_LO_Msk                            /*!< Line Offset */

/********************  Bit definition for DMA2D_NLR register  *****************/
#define DMA2D_NLR_NL_Pos           (0UL)
#define DMA2D_NLR_NL_Msk           (0xFFFFUL << DMA2D_NLR_NL_Pos)              /*!< 0x0000FFFF */
#define DMA2D_NLR_NL               DMA2D_NLR_NL_Msk                            /*!< Number of Lines */
#define DMA2D_NLR_PL_Pos           (16UL)
#define DMA2D_NLR_PL_Msk           (0x3FFFUL << DMA2D_NLR_PL_Pos)              /*!< 0x3FFF0000 */
#define DMA2D_NLR_PL               DMA2D_NLR_PL_Msk                            /*!< Pixel per Lines */

/********************  Bit definition for DMA2D_LWR register  *****************/
#define DMA2D_LWR_LW_Pos           (0UL)
#define DMA2D_LWR_LW_Msk           (0xFFFFUL << DMA2D_LWR_LW_Pos)              /*!< 0x0000FFFF */
#define DMA2D_LWR_LW               DMA2D_LWR_LW_Msk                            /*!< Line Watermark */

/********************  Bit definition for DMA2D_AMTCR register  ***************/
#define DMA2D_AMTCR_EN_Pos         (0UL)
#define DMA2D_AMTCR_EN_Msk         (0x1UL << DMA2D_AMTCR_EN_Pos)               /*!< 0x00000001 */
#define DMA2D_AMTCR_EN             DMA2D_AMTCR_EN_Msk                          /*!< Enable */
#define DMA2D_AMTCR_DT_Pos         (8UL)
#define DMA2D_AMTCR_DT_Msk         (0xFFUL << DMA2D_AMTCR_DT_Pos)              /*!< 0x0000FF00 */
#define DMA2D_AMTCR_DT             DMA2D_AMTCR_DT_Msk                          /*!< Dead Time */

/********************  Bit definition for DMA2D_FGCLUT register  **************/

/********************  Bit definition for DMA2D_BGCLUT register  **************/


/******************************************************************************/
/*                                                                            */
/*                    Digital Temperature Sensor                              */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for DTS_PVTREG_LOCKR register  *****************/
#define DTS_PVTREG_LOCKR_LOCK_Pos                 (0UL)
#define DTS_PVTREG_LOCKR_LOCK_Msk                 (0xFFFFFFFFUL << DTS_PVTREG_LOCKR_LOCK_Pos)         /*!< 0xFFFFFFFF */
#define DTS_PVTREG_LOCKR_LOCK                     DTS_PVTREG_LOCKR_LOCK_Msk                           /*!< PVT software lock */

/*******************  Bit definition for DTS_PVTLOCK_SR register  *****************/
#define DTS_PVTLOCK_SR_SW_LOCK_STATUS_Pos         (0UL)
#define DTS_PVTLOCK_SR_SW_LOCK_STATUS_Msk         (0x1UL << DTS_PVTLOCK_SR_SW_LOCK_STATUS_Pos)        /*!< 0x00000001 */
#define DTS_PVTLOCK_SR_SW_LOCK_STATUS             DTS_PVTLOCK_SR_SW_LOCK_STATUS_Msk                   /*!< Software lock status */
#define DTS_PVTLOCK_SR_HW_LOCK_STATUS_Pos         (1UL)
#define DTS_PVTLOCK_SR_HW_LOCK_STATUS_Msk         (0x1UL << DTS_PVTLOCK_SR_HW_LOCK_STATUS_Pos)        /*!< 0x00000002 */
#define DTS_PVTLOCK_SR_HW_LOCK_STATUS             DTS_PVTLOCK_SR_HW_LOCK_STATUS_Msk                   /*!< Hardware lock status */

/*******************  Bit definition for DTS_PVTTMR_CR register  *****************/
#define DTS_PVTTMR_CR_TMR_DELAY_Pos               (0UL)
#define DTS_PVTTMR_CR_TMR_DELAY_Msk               (0xFFFFUL << DTS_PVTTMR_CR_TMR_DELAY_Pos)           /*!< 0x0000FFFF */
#define DTS_PVTTMR_CR_TMR_DELAY                   DTS_PVTTMR_CR_TMR_DELAY_Msk                         /*!< Timer delay */
#define DTS_PVTTMR_CR_TMR_RUN_Pos                 (16UL)
#define DTS_PVTTMR_CR_TMR_RUN_Msk                 (0x1UL << DTS_PVTTMR_CR_TMR_RUN_Pos)                /*!< 0x00010000 */
#define DTS_PVTTMR_CR_TMR_RUN                     DTS_PVTTMR_CR_TMR_RUN_Msk                           /*!< Enable */

/*******************  Bit definition for DTS_PVTTMR_SR register  *****************/
#define DTS_PVTTMR_SR_TMR_BUSY_Pos                (0UL)
#define DTS_PVTTMR_SR_TMR_BUSY_Msk                (0x1UL << DTS_PVTTMR_SR_TMR_BUSY_Pos)               /*!< 0x00000001 */
#define DTS_PVTTMR_SR_TMR_BUSY                    DTS_PVTTMR_SR_TMR_BUSY_Msk                          /*!< Counter busy flag */
#define DTS_PVTTMR_SR_TMR_DONE_Pos                (1UL)
#define DTS_PVTTMR_SR_TMR_DONE_Msk                (0x1UL << DTS_PVTTMR_SR_TMR_DONE_Pos)               /*!< 0x00000002 */
#define DTS_PVTTMR_SR_TMR_DONE                    DTS_PVTTMR_SR_TMR_DONE_Msk                          /*!< Cnt delay timeout */

/*******************  Bit definition for DTS_PVT_IER register  *****************/
#define DTS_PVT_IER_TMR_IRQ_ENABLE_Pos            (0UL)
#define DTS_PVT_IER_TMR_IRQ_ENABLE_Msk            (0x1UL << DTS_PVT_IER_TMR_IRQ_ENABLE_Pos)           /*!< 0x00000001 */
#define DTS_PVT_IER_TMR_IRQ_ENABLE                DTS_PVT_IER_TMR_IRQ_ENABLE_Msk                      /*!< Timer IRQ enable */
#define DTS_PVT_IER_TS_IRQ_ENABLE_Pos             (1UL)
#define DTS_PVT_IER_TS_IRQ_ENABLE_Msk             (0x1UL << DTS_PVT_IER_TS_IRQ_ENABLE_Pos)            /*!< 0x00000002 */
#define DTS_PVT_IER_TS_IRQ_ENABLE                 DTS_PVT_IER_TS_IRQ_ENABLE_Msk                       /*!< TS IRQ enable */

/*******************  Bit definition for DTS_PVTIRQTRMASKR register  *****************/
#define DTS_PVTIRQTRMASKR_TMR_IRQ_MASK_Pos        (0UL)
#define DTS_PVTIRQTRMASKR_TMR_IRQ_MASK_Msk        (0x1UL << DTS_PVTIRQTRMASKR_TMR_IRQ_MASK_Pos)       /*!< 0x00000001 */
#define DTS_PVTIRQTRMASKR_TMR_IRQ_MASK            DTS_PVTIRQTRMASKR_TMR_IRQ_MASK_Msk                  /*!< Timer IRQ mask */

/*******************  Bit definition for DTS_TS_MR register  *****************/
#define DTS_TS_MR_TS0_IRQ_MASK_Pos                (0UL)
#define DTS_TS_MR_TS0_IRQ_MASK_Msk                (0x1UL << DTS_TS_MR_TS0_IRQ_MASK_Pos)               /*!< 0x00000001 */
#define DTS_TS_MR_TS0_IRQ_MASK                    DTS_TS_MR_TS0_IRQ_MASK_Msk                          /*!< TS0 IRQ mask */
#define DTS_TS_MR_TS1_IRQ_MASK_Pos                (1UL)
#define DTS_TS_MR_TS1_IRQ_MASK_Msk                (0x1UL << DTS_TS_MR_TS1_IRQ_MASK_Pos)               /*!< 0x00000002 */
