;;; lookup-text-table.el --- tables for lookup-text.el
;; Copyright (C) 2009 Kazuhiro Ito

;; Author: Kazuhiro Ito <kzhr@d1.dion.ne.jp>
;; Version: $Id: lookup-text-table.el,v 1.1.2.4 2011-02-10 12:26:31 kazuhiro Exp $

;; This file is part of Lookup.

;; Lookup is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; Lookup is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with Lookup; if not, write to the Free Software Foundation,
;; Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;;; Commentary:

;;; Code:

(defconst lookup-text-new-old-alist
  (eval-when-compile
    (let ((table
	   '(("\xe4\xb8\x87" . "\xe8\x90\xac")
	     ("\xe4\xb8\x8e" . "\xe8\x88\x87")
	     ("\xe4\xb8\xa1" . "\xe5\x85\xa9")
	     ("\xe4\xb8\xa6" . "\xe7\xab\x9d")
	     ("\xe4\xb9\x97" . "\xe4\xb9\x98")
	     ("\xe4\xb9\xb1" . "\xe4\xba\x82")
	     ("\xe4\xba\x88" . "\xe8\xb1\xab")
	     ("\xe4\xba\x89" . "\xe7\x88\xad")
	     ("\xe4\xba\x9c" . "\xe4\xba\x9e")
	     ("\xe4\xbb\x8f" . "\xe4\xbd\x9b")
	     ("\xe4\xbb\xae" . "\xe5\x81\x87")
	     ("\xe4\xbc\x9a" . "\xe6\x9c\x83")
	     ("\xe4\xbc\x9d" . "\xe5\x82\xb3")
	     ("\xe4\xbd\x93" . "\xe9\xab\x94")
	     ("\xe4\xbd\x99" . "\xe9\xa4\x98")
	     ("\xe4\xbd\xb5" . "\xe5\x80\x82")
	     ("\xe4\xbe\xa1" . "\xe5\x83\xb9")
	     ("\xe4\xbe\xae" . "\xef\xa8\xb0")
	     ("\xe5\x80\xb9" . "\xe5\x84\x89")
	     ("\xe5\x81\xbd" . "\xe5\x83\x9e")
	     ("\xe5\x83\xa7" . "\xef\xa8\xb1")
	     ("\xe5\x85\x8d" . "\xef\xa8\xb2")
	     ("\xe5\x85\x90" . "\xe5\x85\x92")
	     ("\xe5\x85\x9a" . "\xe9\xbb\xa8")
	     ("\xe5\x86\x86" . "\xe5\x9c\x93")
	     ("\xe5\x86\x99" . "\xe5\xaf\xab")
	     ("\xe5\x87\xa6" . "\xe8\x99\x95")
	     ("\xe5\x89\xa3" . "\xe5\x8a\x8d")
	     ("\xe5\x89\xa4" . "\xe5\x8a\x91")
	     ("\xe5\x89\xb0" . "\xe5\x89\xa9")
	     ("\xe5\x8a\xb1" . "\xe5\x8b\xb5")
	     ("\xe5\x8a\xb4" . "\xe5\x8b\x9e")
	     ("\xe5\x8a\xb9" . "\xe6\x95\x88")
	     ("\xe5\x8b\x85" . "\xe6\x95\x95")
	     ("\xe5\x8b\x89" . "\xef\xa8\xb3")
	     ("\xe5\x8b\xa4" . "\xef\xa8\xb4")
	     ("\xe5\x8b\xa7" . "\xe5\x8b\xb8")
	     ("\xe5\x8b\xb2" . "\xe5\x8b\xb3")
	     ("\xe5\x8c\xba" . "\xe5\x8d\x80")
	     ("\xe5\x8c\xbb" . "\xe9\x86\xab")
	     ("\xe5\x8d\x91" . "\xef\xa8\xb5")
	     ("\xe5\x8d\x98" . "\xe5\x96\xae")
	     ("\xe5\x8d\xb3" . "\xe5\x8d\xbd")
	     ("\xe5\x8e\xb3" . "\xe5\x9a\xb4")
	     ("\xe5\x8f\x82" . "\xe5\x8f\x83")
	     ("\xe5\x8f\x8c" . "\xe9\x9b\x99")
	     ("\xe5\x8f\x8e" . "\xe6\x94\xb6")
	     ("\xe5\x8f\x99" . "\xe6\x95\x8d")
	     ("\xe5\x8f\xb0" . "\xe8\x87\xba")
	     ("\xe5\x8f\xb7" . "\xe8\x99\x9f")
	     ("\xe5\x96\x9d" . "\xef\xa8\xb6")
	     ("\xe5\x96\xb6" . "\xe7\x87\x9f")
	     ("\xe5\x98\x86" . "\xef\xa8\xb7")
	     ("\xe5\x98\xb1" . "\xe5\x9b\x91")
	     ("\xe5\x99\xa8" . "\xef\xa8\xb8")
	     ("\xe5\x9b\xa3" . "\xe5\x9c\x98")
	     ("\xe5\x9b\xb2" . "\xe5\x9c\x8d")
	     ("\xe5\x9b\xb3" . "\xe5\x9c\x96")
	     ("\xe5\x9b\xbd" . "\xe5\x9c\x8b")
	     ("\xe5\x9c\x8f" . "\xe5\x9c\x88")
	     ("\xe5\x9c\xa7" . "\xe5\xa3\x93")
	     ("\xe5\xa0\x95" . "\xe5\xa2\xae")
	     ("\xe5\xa1\x80" . "\xef\xa8\xb9")
	     ("\xe5\xa1\x81" . "\xe5\xa3\x98")
	     ("\xe5\xa1\x9a" . "\xef\xa8\x90")
	     ("\xe5\xa1\xa9" . "\xe9\xb9\xbd")
	     ("\xe5\xa2\x97" . "\xe5\xa2\x9e")
	     ("\xe5\xa2\xa8" . "\xef\xa8\xba")
	     ("\xe5\xa3\x8a" . "\xe5\xa3\x9e")
	     ("\xe5\xa3\x8c" . "\xe5\xa3\xa4")
	     ("\xe5\xa3\xae" . "\xe5\xa3\xaf")
	     ("\xe5\xa3\xb0" . "\xe8\x81\xb2")
	     ("\xe5\xa3\xb1" . "\xe5\xa3\xb9")
	     ("\xe5\xa3\xb2" . "\xe8\xb3\xa3")
	     ("\xe5\xa4\x89" . "\xe8\xae\x8a")
	     ("\xe5\xa5\xa5" . "\xe5\xa5\xa7")
	     ("\xe5\xa5\xa8" . "\xe5\xa5\xac")
	     ("\xe5\xac\xa2" . "\xe5\xad\x83")
	     ("\xe5\xad\xa6" . "\xe5\xad\xb8")
	     ("\xe5\xae\x9d" . "\xe5\xaf\xb6")
	     ("\xe5\xae\x9f" . "\xe5\xaf\xa6")
	     ("\xe5\xaf\x9b" . "\xe5\xaf\xac")
	     ("\xe5\xaf\x9d" . "\xe5\xaf\xa2")
	     ("\xe5\xaf\xbe" . "\xe5\xb0\x8d")
	     ("\xe5\xaf\xbf" . "\xe5\xa3\xbd")
	     ("\xe5\xb0\x82" . "\xe5\xb0\x88")
	     ("\xe5\xb0\x86" . "\xe5\xb0\x87")
	     ("\xe5\xb0\xbd" . "\xe7\x9b\xa1")
	     ("\xe5\xb1\x8a" . "\xe5\xb1\x86")
	     ("\xe5\xb1\x9e" . "\xe5\xb1\xac")
	     ("\xe5\xb1\xa4" . "\xef\xa8\xbb")
	     ("\xe5\xb2\xb3" . "\xe5\xb6\xbd")
	     ("\xe5\xb3\xa1" . "\xe5\xb3\xbd")
	     ("\xe5\xb7\xa3" . "\xe5\xb7\xa2")
	     ("\xe5\xb7\xbb" . "\xe5\x8d\xb7")
	     ("\xe5\xb8\xaf" . "\xe5\xb8\xb6")
	     ("\xe5\xb8\xb0" . "\xe6\xad\xb8")
	     ("\xe5\xba\x81" . "\xe5\xbb\xb3")
	     ("\xe5\xba\x83" . "\xe5\xbb\xa3")
	     ("\xe5\xbb\x83" . "\xe5\xbb\xa2")
	     ("\xe5\xbb\x8a" . "\xef\xa4\xa8")
	     ("\xe5\xbc\x81" . "\xe7\x93\xa3")
	     ("\xe5\xbc\x81" . "\xe8\xbe\xaf")
	     ("\xe5\xbc\x81" . "\xe8\xbe\xa8")
	     ("\xe5\xbc\x90" . "\xe8\xb2\xb3")
	     ("\xe5\xbc\xbe" . "\xe5\xbd\x88")
	     ("\xe5\xbd\x93" . "\xe7\x95\xb6")
	     ("\xe5\xbe\x84" . "\xe5\xbe\x91")
	     ("\xe5\xbe\x93" . "\xe5\xbe\x9e")
	     ("\xe5\xbe\xb3" . "\xe5\xbe\xb7")
	     ("\xe5\xbe\xb4" . "\xe5\xbe\xb5")
	     ("\xe5\xbf\x9c" . "\xe6\x87\x89")
	     ("\xe6\x81\x8b" . "\xe6\x88\x80")
	     ("\xe6\x81\x92" . "\xe6\x81\x86")
	     ("\xe6\x81\xb5" . "\xe6\x83\xa0")
	     ("\xe6\x82\x94" . "\xef\xa8\xbd")
	     ("\xe6\x82\xa9" . "\xe6\x83\xb1")
	     ("\xe6\x82\xaa" . "\xe6\x83\xa1")
	     ("\xe6\x83\xa8" . "\xe6\x85\x98")
	     ("\xe6\x85\x8e" . "\xe6\x84\xbc")
	     ("\xe6\x85\xa8" . "\xef\xa8\xbe")
	     ("\xe6\x86\x8e" . "\xef\xa8\xbf")
	     ("\xe6\x87\x90" . "\xe6\x87\xb7")
	     ("\xe6\x87\xb2" . "\xef\xa9\x80")
	     ("\xe6\x88\xa6" . "\xe6\x88\xb0")
	     ("\xe6\x88\xaf" . "\xe6\x88\xb2")
	     ("\xe6\x88\xbb" . "\xe6\x88\xbe")
	     ("\xe6\x89\x95" . "\xe6\x8b\x82")
	     ("\xe6\x8a\x9c" . "\xe6\x8b\x94")
	     ("\xe6\x8a\x9e" . "\xe6\x93\x87")
	     ("\xe6\x8b\x85" . "\xe6\x93\x94")
	     ("\xe6\x8b\x9d" . "\xe6\x8b\x9c")
	     ("\xe6\x8b\xa0" . "\xe6\x93\x9a")
	     ("\xe6\x8b\xa1" . "\xe6\x93\xb4")
	     ("\xe6\x8c\x99" . "\xe6\x93\xa7")
	     ("\xe6\x8c\x9f" . "\xe6\x8c\xbe")
	     ("\xe6\x8c\xbf" . "\xe6\x8f\x92")
	     ("\xe6\x8d\x9c" . "\xe6\x90\x9c")
	     ("\xe6\x8e\xb2" . "\xe6\x8f\xad")
	     ("\xe6\x8f\xba" . "\xe6\x90\x96")
	     ("\xe6\x91\x82" . "\xe6\x94\x9d")
	     ("\xe6\x92\x83" . "\xe6\x93\x8a")
	     ("\xe6\x95\x8f" . "\xef\xa9\x81")
	     ("\xe6\x95\xb0" . "\xe6\x95\xb8")
	     ("\xe6\x96\x89" . "\xe9\xbd\x8a")
	     ("\xe6\x96\x8e" . "\xe9\xbd\x8b")
	     ("\xe6\x96\xad" . "\xe6\x96\xb7")
	     ("\xe6\x97\xa2" . "\xef\xa9\x82")
	     ("\xe6\x97\xa7" . "\xe8\x88\x8a")
	     ("\xe6\x98\xbc" . "\xe6\x99\x9d")
	     ("\xe6\x99\xa9" . "\xe6\x99\x9a")
	     ("\xe6\x9a\x81" . "\xe6\x9b\x89")
	     ("\xe6\x9a\x91" . "\xef\xa9\x83")
	     ("\xe6\x9a\xa6" . "\xe6\x9b\x86")
	     ("\xe6\x9c\x97" . "\xef\xa4\xa9")
	     ("\xe6\x9d\xa1" . "\xe6\xa2\x9d")
	     ("\xe6\x9d\xa5" . "\xe4\xbe\x86")
	     ("\xe6\x9e\xa2" . "\xe6\xa8\x9e")
	     ("\xe6\xa0\x84" . "\xe6\xa6\xae")
	     ("\xe6\xa1\x9c" . "\xe6\xab\xbb")
	     ("\xe6\xa1\x9f" . "\xe6\xa3\xa7")
	     ("\xe6\xa2\x85" . "\xef\xa9\x84")
	     ("\xe6\xa4\x9c" . "\xe6\xaa\xa2")
	     ("\xe6\xa5\xbc" . "\xe6\xa8\x93")
	     ("\xe6\xa5\xbd" . "\xe6\xa8\x82")
	     ("\xe6\xa6\x82" . "\xe6\xa7\xaa")
	     ("\xe6\xa7\x98" . "\xe6\xa8\xa3")
	     ("\xe6\xa8\xa9" . "\xe6\xac\x8a")
	     ("\xe6\xa8\xaa" . "\xe6\xa9\xab")
	     ("\xe6\xac\x84" . "\xef\xa4\x9d")
	     ("\xe6\xac\xa0" . "\xe7\xbc\xba")
	     ("\xe6\xac\xa7" . "\xe6\xad\x90")
	     ("\xe6\xad\x93" . "\xe6\xad\xa1")
	     ("\xe6\xad\xa9" . "\xe6\xad\xa5")
	     ("\xe6\xad\xaf" . "\xe9\xbd\x92")
	     ("\xe6\xad\xb4" . "\xe6\xad\xb7")
	     ("\xe6\xae\x8b" . "\xe6\xae\x98")
	     ("\xe6\xae\xb4" . "\xe6\xaf\x86")
	     ("\xe6\xae\xba" . "\xef\xa5\xb0")
	     ("\xe6\xae\xbb" . "\xe6\xae\xbc")
	     ("\xe6\xaf\x8e" . "\xe6\xaf\x8f")
	     ("\xe6\xb0\x97" . "\xe6\xb0\xa3")
	     ("\xe6\xb2\xa2" . "\xe6\xbe\xa4")
	     ("\xe6\xb5\x84" . "\xe6\xb7\xa8")
	     ("\xe6\xb5\x85" . "\xe6\xb7\xba")
	     ("\xe6\xb5\x9c" . "\xe6\xbf\xb1")
	     ("\xe6\xb5\xb7" . "\xef\xa9\x85")
	     ("\xe6\xb6\x99" . "\xe6\xb7\x9a")
	     ("\xe6\xb8\x87" . "\xe6\xb8\xb4")
	     ("\xe6\xb8\x88" . "\xe6\xbf\x9f")
	     ("\xe6\xb8\x89" . "\xe6\xb6\x89")
	     ("\xe6\xb8\x8b" . "\xe6\xbe\x81")
	     ("\xe6\xb8\x93" . "\xe6\xba\xaa")
	     ("\xe6\xb8\xa9" . "\xe6\xba\xab")
	     ("\xe6\xb9\xbe" . "\xe7\x81\xa3")
	     ("\xe6\xb9\xbf" . "\xe6\xbf\x95")
	     ("\xe6\xba\x80" . "\xe6\xbb\xbf")
	     ("\xe6\xbb\x9d" . "\xe7\x80\xa7")
	     ("\xe6\xbb\x9e" . "\xe6\xbb\xaf")
	     ("\xe6\xbc\xa2" . "\xef\xa9\x87")
	     ("\xe6\xbd\x9c" . "\xe6\xbd\x9b")
	     ("\xe7\x80\xac" . "\xe7\x80\xa8")
	     ("\xe7\x81\xaf" . "\xe7\x87\x88")
	     ("\xe7\x82\x89" . "\xe7\x88\x90")
	     ("\xe7\x82\xb9" . "\xe9\xbb\x9e")
	     ("\xe7\x82\xba" . "\xe7\x88\xb2")
	     ("\xe7\x84\xbc" . "\xe7\x87\x92")
	     ("\xe7\x85\xae" . "\xef\xa9\x88")
	     ("\xe7\x8a\xa0" . "\xe7\x8a\xa7")
	     ("\xe7\x8a\xb6" . "\xe7\x8b\x80")
	     ("\xe7\x8b\xac" . "\xe7\x8d\xa8")
	     ("\xe7\x8b\xad" . "\xe7\x8b\xb9")
	     ("\xe7\x8c\x9f" . "\xe7\x8d\xb5")
	     ("\xe7\x8c\xae" . "\xe7\x8d\xbb")
	     ("\xe7\x8d\xa3" . "\xe7\x8d\xb8")
	     ("\xe7\x93\xb6" . "\xe7\x94\x81")
	     ("\xe7\x94\xbb" . "\xe7\x95\xab")
	     ("\xe7\x95\xb3" . "\xe7\x96\x8a")
	     ("\xe7\x97\xb4" . "\xe7\x99\xa1")
	     ("\xe7\x99\xba" . "\xe7\x99\xbc")
	     ("\xe7\x9b\x97" . "\xe7\x9b\x9c")
	     ("\xe7\x9c\x8c" . "\xe7\xb8\xa3")
	     ("\xe7\x9c\x9f" . "\xe7\x9c\x9e")
	     ("\xe7\xa0\x94" . "\xe7\xa1\x8f")
	     ("\xe7\xa0\x95" . "\xe7\xa2\x8e")
	     ("\xe7\xa2\x91" . "\xef\xa9\x8b")
	     ("\xe7\xa4\xbc" . "\xe7\xa6\xae")
	     ("\xe7\xa4\xbe" . "\xef\xa9\x8c")
	     ("\xe7\xa5\x88" . "\xef\xa9\x8e")
	     ("\xe7\xa5\x89" . "\xef\xa9\x8d")
	     ("\xe7\xa5\x96" . "\xef\xa9\x90")
	     ("\xe7\xa5\x9d" . "\xef\xa9\x91")
	     ("\xe7\xa5\x9e" . "\xef\xa8\x99")
	     ("\xe7\xa5\xa5" . "\xef\xa8\x9a")
	     ("\xe7\xa6\x85" . "\xe7\xa6\xaa")
	     ("\xe7\xa6\x8d" . "\xef\xa9\x92")
	     ("\xe7\xa6\x8f" . "\xef\xa8\x9b")
	     ("\xe7\xa7\x98" . "\xe7\xa5\x95")
	     ("\xe7\xa7\xb0" . "\xe7\xa8\xb1")
	     ("\xe7\xa8\xb2" . "\xe7\xa8\xbb")
	     ("\xe7\xa9\x80" . "\xef\xa9\x94")
	     ("\xe7\xa9\x82" . "\xe7\xa9\x97")
	     ("\xe7\xa9\x8f" . "\xe7\xa9\xa9")
	     ("\xe7\xaa\x81" . "\xef\xa9\x95")
	     ("\xe7\xaa\x83" . "\xe7\xab\x8a")
	     ("\xe7\xab\x9c" . "\xe9\xbe\x8d")
	     ("\xe7\xaf\x80" . "\xef\xa9\x96")
	     ("\xe7\xb2\x8b" . "\xe7\xb2\xb9")
	     ("\xe7\xb2\x9b" . "\xe8\x82\x85")
	     ("\xe7\xb3\xb8" . "\xe7\xb5\xb2")
	     ("\xe7\xb5\x8c" . "\xe7\xb6\x93")
	     ("\xe7\xb5\xb5" . "\xe7\xb9\xaa")
	     ("\xe7\xb6\x99" . "\xe7\xb9\xbc")
	     ("\xe7\xb6\x9a" . "\xe7\xba\x8c")
	     ("\xe7\xb7\x8f" . "\xe7\xb8\xbd")
	     ("\xe7\xb7\x91" . "\xe7\xb6\xa0")
	     ("\xe7\xb7\x92" . "\xe7\xb7\x96")
	     ("\xe7\xb7\xb4" . "\xef\xa9\x97")
	     ("\xe7\xb8\x81" . "\xe7\xb7\xa3")
	     ("\xe7\xb8\x84" . "\xe7\xb9\xa9")
	     ("\xe7\xb8\xa6" . "\xe7\xb8\xb1")
	     ("\xe7\xb9\x81" . "\xef\xa9\x99")
	     ("\xe7\xb9\x8a" . "\xe7\xba\x96")
	     ("\xe7\xbc\xb6" . "\xe7\xbd\x90")
	     ("\xe7\xbd\xb2" . "\xef\xa9\x9a")
	     ("\xe7\xbf\xbb" . "\xe9\xa3\x9c")
	     ("\xe8\x80\x85" . "\xef\xa9\x9b")
	     ("\xe8\x81\xb4" . "\xe8\x81\xbd")
	     ("\xe8\x83\x86" . "\xe8\x86\xbd")
	     ("\xe8\x84\xb3" . "\xe8\x85\xa6")
	     ("\xe8\x87\x93" . "\xe8\x87\x9f")
	     ("\xe8\x87\xad" . "\xef\xa9\x9c")
	     ("\xe8\x8a\xb8" . "\xe8\x97\x9d")
	     ("\xe8\x8c\x8e" . "\xe8\x8e\x96")
	     ("\xe8\x8d\x98" . "\xe8\x8e\x8a")
	     ("\xe8\x91\x97" . "\xef\xa9\x9f")
	     ("\xe8\x94\xb5" . "\xe8\x97\x8f")
	     ("\xe8\x96\xab" . "\xe8\x96\xb0")
	     ("\xe8\x96\xac" . "\xe8\x97\xa5")
	     ("\xe8\x99\x9a" . "\xe8\x99\x9b")
	     ("\xe8\x99\x9c" . "\xef\xa4\xb6")
	     ("\xe8\x99\xab" . "\xe8\x9f\xb2")
	     ("\xe8\x9a\x95" . "\xe8\xa0\xb6")
	     ("\xe8\x9b\x8d" . "\xe8\x9e\xa2")
	     ("\xe8\x9b\xae" . "\xe8\xa0\xbb")
	     ("\xe8\xa1\x9b" . "\xe8\xa1\x9e")
	     ("\xe8\xa3\x85" . "\xe8\xa3\x9d")
	     ("\xe8\xa4\x90" . "\xef\xa9\xa0")
	     ("\xe8\xa4\x92" . "\xe8\xa5\x83")
	     ("\xe8\xa6\x87" . "\xe9\x9c\xb8")
	     ("\xe8\xa6\x96" . "\xef\xa9\xa1")
	     ("\xe8\xa6\x9a" . "\xe8\xa6\xba")
	     ("\xe8\xa6\xa7" . "\xe8\xa6\xbd")
	     ("\xe8\xa6\xb3" . "\xe8\xa7\x80")
	     ("\xe8\xa7\xa6" . "\xe8\xa7\xb8")
	     ("\xe8\xa8\xb3" . "\xe8\xad\xaf")
	     ("\xe8\xa8\xbc" . "\xe8\xad\x89")
	     ("\xe8\xaa\x89" . "\xe8\xad\xbd")
	     ("\xe8\xaa\xad" . "\xe8\xae\x80")
	     ("\xe8\xab\xb8" . "\xef\xa8\xa2")
	     ("\xe8\xac\x81" . "\xef\xa9\xa2")
	     ("\xe8\xac\xa1" . "\xe8\xac\xa0")
	     ("\xe8\xac\xb9" . "\xef\xa9\xa3")
	     ("\xe8\xad\xb2" . "\xe8\xae\x93")
	     ("\xe8\xb1\x8a" . "\xe8\xb1\x90")
	     ("\xe8\xb3\x93" . "\xef\xa9\xa4")
	     ("\xe8\xb3\x9b" . "\xe8\xb4\x8a")
	     ("\xe8\xb4\x88" . "\xef\xa9\xa5")
	     ("\xe8\xb7\xb5" . "\xe8\xb8\x90")
	     ("\xe8\xbb\xa2" . "\xe8\xbd\x89")
	     ("\xe8\xbb\xbd" . "\xe8\xbc\x95")
	     ("\xe8\xbe\x9e" . "\xe8\xbe\xad")
	     ("\xe8\xbe\xba" . "\xe9\x82\x8a")
	     ("\xe9\x80\x93" . "\xe9\x81\x9e")
	     ("\xe9\x80\xb8" . "\xef\xa9\xa7")
	     ("\xe9\x81\x85" . "\xe9\x81\xb2")
	     ("\xe9\x83\x8e" . "\xe9\x83\x9e")
	     ("\xe9\x83\xb7" . "\xe9\x84\x95")
	     ("\xe9\x83\xbd" . "\xef\xa8\xa6")
	     ("\xe9\x85\x94" . "\xe9\x86\x89")
	     ("\xe9\x86\xb8" . "\xe9\x87\x80")
	     ("\xe9\x87\x88" . "\xe9\x87\x8b")
	     ("\xe9\x89\x84" . "\xe9\x90\xb5")
	     ("\xe9\x89\xb1" . "\xe9\x91\x9b")
	     ("\xe9\x8a\xad" . "\xe9\x8c\xa2")
	     ("\xe9\x8b\xb3" . "\xe9\x91\x84")
	     ("\xe9\x8c\xac" . "\xe9\x8d\x8a")
	     ("\xe9\x8c\xb2" . "\xe9\x8c\x84")
	     ("\xe9\x8e\xae" . "\xe9\x8e\xad")
	     ("\xe9\x96\xa2" . "\xe9\x97\x9c")
	     ("\xe9\x97\x98" . "\xe9\xac\xaa")
	     ("\xe9\x99\xa5" . "\xe9\x99\xb7")
	     ("\xe9\x99\xba" . "\xe9\x9a\xaa")
	     ("\xe9\x9a\x86" . "\xef\xa7\x9c")
	     ("\xe9\x9a\x8f" . "\xe9\x9a\xa8")
	     ("\xe9\x9a\xa0" . "\xe9\x9a\xb1")
	     ("\xe9\x9b\x91" . "\xe9\x9b\x9c")
	     ("\xe9\x9b\xa3" . "\xef\xa9\xa8")
	     ("\xe9\x9c\x8a" . "\xe9\x9d\x88")
	     ("\xe9\x9d\x99" . "\xe9\x9d\x9c")
	     ("\xe9\x9f\xbf" . "\xef\xa9\xa9")
	     ("\xe9\xa0\xbb" . "\xef\xa9\xaa")
	     ("\xe9\xa0\xbc" . "\xe8\xb3\xb4")
	     ("\xe9\xa1\x95" . "\xe9\xa1\xaf")
	     ("\xe9\xa1\x9e" . "\xef\xa7\x90")
	     ("\xe9\xa7\x85" . "\xe9\xa9\x9b")
	     ("\xe9\xa7\x86" . "\xe9\xa9\x85")
	     ("\xe9\xa8\x92" . "\xe9\xa8\xb7")
	     ("\xe9\xa8\x93" . "\xe9\xa9\x97")
	     ("\xe9\xab\x84" . "\xe9\xab\x93")
	     ("\xe9\xab\xaa" . "\xe9\xab\xae")
	     ("\xe9\xb6\x8f" . "\xe9\xb7\x84")
	     ("\xe9\xba\xa6" . "\xe9\xba\xa5")
	     ("\xe9\xbb\x84" . "\xe9\xbb\x83")
	     ("\xe9\xbb\x92" . "\xe9\xbb\x91")
	     ("\xe9\xbb\x99" . "\xe9\xbb\x98")
	     ("\xe9\xbd\xa2" . "\xe9\xbd\xa1"))))
      (if (string-lessp "6" mule-version)
	  (mapcar (lambda (elt)
		    (cons (string-to-char
			   (decode-coding-string (car elt) 'utf-8))
			  (string-to-char
			   (decode-coding-string (cdr elt) 'utf-8))))
		  table)
	(mapcar (lambda (elt)
		  (cons (string-make-unibyte (car elt))
			(string-make-unibyte (cdr elt))))
		table))
	;; table)
	)))

(defconst lookup-text-old-new-alist
  (eval-when-compile
    (mapcar (lambda (elt) (cons (cdr elt) (car elt)))
	    lookup-text-new-old-alist)))

(defconst lookup-latin-alphabet-accent-alist
  (eval-when-compile
    (let ((table
	   '(("\xc3\x80" . "\x41")
	     ("\xc3\x81" . "\x41")
	     ("\xc3\x82" . "\x41")
	     ("\xc3\x83" . "\x41")
	     ("\xc3\x84" . "\x41")
	     ("\xc3\x85" . "\x41")
	     ("\xc3\x87" . "\x43")
	     ("\xc3\x88" . "\x45")
	     ("\xc3\x89" . "\x45")
	     ("\xc3\x8a" . "\x45")
	     ("\xc3\x8b" . "\x45")
	     ("\xc3\x8c" . "\x49")
	     ("\xc3\x8d" . "\x49")
	     ("\xc3\x8e" . "\x49")
	     ("\xc3\x8f" . "\x49")
	     ("\xc3\x91" . "\x4e")
	     ("\xc3\x92" . "\x4f")
	     ("\xc3\x93" . "\x4f")
	     ("\xc3\x94" . "\x4f")
	     ("\xc3\x95" . "\x4f")
	     ("\xc3\x96" . "\x4f")
	     ("\xc3\x99" . "\x55")
	     ("\xc3\x9a" . "\x55")
	     ("\xc3\x9b" . "\x55")
	     ("\xc3\x9c" . "\x55")
	     ("\xc3\x9d" . "\x59")
	     ("\xc3\xa0" . "\x61")
	     ("\xc3\xa1" . "\x61")
	     ("\xc3\xa2" . "\x61")
	     ("\xc3\xa3" . "\x61")
	     ("\xc3\xa4" . "\x61")
	     ("\xc3\xa5" . "\x61")
	     ("\xc3\xa7" . "\x63")
	     ("\xc3\xa8" . "\x65")
	     ("\xc3\xa9" . "\x65")
	     ("\xc3\xaa" . "\x65")
	     ("\xc3\xab" . "\x65")
	     ("\xc3\xac" . "\x69")
	     ("\xc3\xad" . "\x69")
	     ("\xc3\xae" . "\x69")
	     ("\xc3\xaf" . "\x69")
	     ("\xc3\xb1" . "\x6e")
	     ("\xc3\xb2" . "\x6f")
	     ("\xc3\xb3" . "\x6f")
	     ("\xc3\xb4" . "\x6f")
	     ("\xc3\xb5" . "\x6f")
	     ("\xc3\xb6" . "\x6f")
	     ("\xc3\xb9" . "\x75")
	     ("\xc3\xba" . "\x75")
	     ("\xc3\xbb" . "\x75")
	     ("\xc3\xbc" . "\x75")
	     ("\xc3\xbd" . "\x79")
	     ("\xc3\xbf" . "\x79")
	     ("\xc4\x80" . "\x41")
	     ("\xc4\x81" . "\x61")
	     ("\xc4\x82" . "\x41")
	     ("\xc4\x83" . "\x61")
	     ("\xc4\x84" . "\x41")
	     ("\xc4\x85" . "\x61")
	     ("\xc4\x86" . "\x43")
	     ("\xc4\x87" . "\x63")
	     ("\xc4\x88" . "\x43")
	     ("\xc4\x89" . "\x63")
	     ("\xc4\x8a" . "\x43")
	     ("\xc4\x8b" . "\x63")
	     ("\xc4\x8c" . "\x43")
	     ("\xc4\x8d" . "\x63")
	     ("\xc4\x8e" . "\x44")
	     ("\xc4\x8f" . "\x64")
	     ("\xc4\x92" . "\x45")
	     ("\xc4\x93" . "\x65")
	     ("\xc4\x96" . "\x45")
	     ("\xc4\x97" . "\x65")
	     ("\xc4\x98" . "\x45")
	     ("\xc4\x99" . "\x65")
	     ("\xc4\x9a" . "\x45")
	     ("\xc4\x9b" . "\x65")
	     ("\xc4\x9c" . "\x47")
	     ("\xc4\x9d" . "\x67")
	     ("\xc4\x9e" . "\x47")
	     ("\xc4\x9f" . "\x67")
	     ("\xc4\xa0" . "\x47")
	     ("\xc4\xa1" . "\x67")
	     ("\xc4\xa2" . "\x47")
	     ("\xc4\xa3" . "\x67")
	     ("\xc4\xa4" . "\x48")
	     ("\xc4\xa5" . "\x68")
	     ("\xc4\xa8" . "\x49")
	     ("\xc4\xa9" . "\x69")
	     ("\xc4\xaa" . "\x49")
	     ("\xc4\xab" . "\x69")
	     ("\xc4\xae" . "\x49")
	     ("\xc4\xaf" . "\x69")
	     ("\xc4\xb0" . "\x49")
	     ("\xc4\xb1" . "\x69")
	     ("\xc4\xb4" . "\x4a")
	     ("\xc4\xb5" . "\x6a")
	     ("\xc4\xb6" . "\x4b")
	     ("\xc4\xb7" . "\x6b")
	     ("\xc4\xb9" . "\x4c")
	     ("\xc4\xba" . "\x6c")
	     ("\xc4\xbb" . "\x4c")
	     ("\xc4\xbc" . "\x6c")
	     ("\xc4\xbd" . "\x4c")
	     ("\xc4\xbe" . "\x6c")
	     ("\xc4\xbf" . "\x4c")
	     ("\xc5\x80" . "\x6c")
	     ("\xc5\x83" . "\x4e")
	     ("\xc5\x84" . "\x6e")
	     ("\xc5\x85" . "\x4e")
	     ("\xc5\x86" . "\x6e")
	     ("\xc5\x87" . "\x4e")
	     ("\xc5\x88" . "\x6e")
	     ("\xc5\x89" . "\x6e")
	     ("\xc5\x8c" . "\x4f")
	     ("\xc5\x8d" . "\x6f")
	     ("\xc5\x90" . "\x4f")
	     ("\xc5\x91" . "\x6f")
	     ("\xc5\x94" . "\x52")
	     ("\xc5\x95" . "\x72")
	     ("\xc5\x96" . "\x52")
	     ("\xc5\x97" . "\x72")
	     ("\xc5\x98" . "\x52")
	     ("\xc5\x99" . "\x72")
	     ("\xc5\x9a" . "\x53")
	     ("\xc5\x9b" . "\x73")
	     ("\xc5\x9c" . "\x53")
	     ("\xc5\x9d" . "\x73")
	     ("\xc5\x9e" . "\x53")
	     ("\xc5\x9f" . "\x73")
	     ("\xc5\xa0" . "\x53")
	     ("\xc5\xa1" . "\x73")
	     ("\xc5\xa2" . "\x54")
	     ("\xc5\xa3" . "\x74")
	     ("\xc5\xa4" . "\x54")
	     ("\xc5\xa5" . "\x74")
	     ("\xc5\xa8" . "\x55")
	     ("\xc5\xa9" . "\x75")
	     ("\xc5\xaa" . "\x55")
	     ("\xc5\xab" . "\x75")
	     ("\xc5\xac" . "\x55")
	     ("\xc5\xad" . "\x75")
	     ("\xc5\xae" . "\x55")
	     ("\xc5\xaf" . "\x75")
	     ("\xc5\xb0" . "\x55")
	     ("\xc5\xb1" . "\x75")
	     ("\xc5\xb2" . "\x55")
	     ("\xc5\xb3" . "\x75")
	     ("\xc5\xb4" . "\x57")
	     ("\xc5\xb5" . "\x77")
	     ("\xc5\xb6" . "\x59")
	     ("\xc5\xb7" . "\x79")
	     ("\xc5\xb8" . "\x59")
	     ("\xc5\xb9" . "\x5a")
	     ("\xc5\xba" . "\x7a")
	     ("\xc5\xbb" . "\x5a")
	     ("\xc5\xbc" . "\x7a")
	     ("\xc5\xbd" . "\x5a")
	     ("\xc5\xbe" . "\x7a")
	     ("\xc6\xa0" . "\x4f")
	     ("\xc6\xa1" . "\x4f")
	     ("\xc6\xaf" . "\x55")
	     ("\xc6\xb0" . "\x55")
	     ("\xc7\x8d" . "\x41")
	     ("\xc7\x8e" . "\x61")
	     ("\xc7\x8f" . "\x49")
	     ("\xc7\x90" . "\x69")
	     ("\xc7\x91" . "\x4f")
	     ("\xc7\x92" . "\x6f")
	     ("\xc7\x93" . "\x55")
	     ("\xc7\x94" . "\x75")
	     ("\xc7\x95" . "\x55")
	     ("\xc7\x96" . "\x75")
	     ("\xc7\x97" . "\x55")
	     ("\xc7\x98" . "\x75")
	     ("\xc7\x99" . "\x55")
	     ("\xc7\x9a" . "\x75")
	     ("\xc7\x9b" . "\x55")
	     ("\xc7\x9c" . "\x75")
	     ("\xc7\xb5" . "\x67")
	     ("\xe1\xba\xa0" . "\x41")
	     ("\xe1\xba\xa1" . "\x61")
	     ("\xe1\xba\xa2" . "\x41")
	     ("\xe1\xba\xa3" . "\x61")
	     ("\xe1\xba\xa4" . "\x41")
	     ("\xe1\xba\xa5" . "\x61")
	     ("\xe1\xba\xa6" . "\x41")
	     ("\xe1\xba\xa7" . "\x61")
	     ("\xe1\xba\xa8" . "\x41")
	     ("\xe1\xba\xa9" . "\x61")
	     ("\xe1\xba\xaa" . "\x41")
	     ("\xe1\xba\xab" . "\x61")
	     ("\xe1\xba\xac" . "\x41")
	     ("\xe1\xba\xad" . "\x61")
	     ("\xe1\xba\xae" . "\x41")
	     ("\xe1\xba\xaf" . "\x61")
	     ("\xe1\xba\xb0" . "\x41")
	     ("\xe1\xba\xb1" . "\x61")
	     ("\xe1\xba\xb2" . "\x41")
	     ("\xe1\xba\xb3" . "\x61")
	     ("\xe1\xba\xb4" . "\x41")
	     ("\xe1\xba\xb5" . "\x61")
	     ("\xe1\xba\xb6" . "\x41")
	     ("\xe1\xba\xb7" . "\x61")
	     ("\xe1\xba\xb8" . "\x45")
	     ("\xe1\xba\xb9" . "\x65")
	     ("\xe1\xba\xba" . "\x45")
	     ("\xe1\xba\xbb" . "\x65")
	     ("\xe1\xba\xbc" . "\x45")
	     ("\xe1\xba\xbd" . "\x65")
	     ("\xe1\xba\xbe" . "\x45")
	     ("\xe1\xba\xbf" . "\x65")
	     ("\xe1\xbb\x80" . "\x45")
	     ("\xe1\xbb\x81" . "\x65")
	     ("\xe1\xbb\x82" . "\x45")
	     ("\xe1\xbb\x83" . "\x65")
	     ("\xe1\xbb\x84" . "\x45")
	     ("\xe1\xbb\x85" . "\x65")
	     ("\xe1\xbb\x86" . "\x45")
	     ("\xe1\xbb\x87" . "\x65")
	     ("\xe1\xbb\x88" . "\x49")
	     ("\xe1\xbb\x89" . "\x69")
	     ("\xe1\xbb\x8a" . "\x49")
	     ("\xe1\xbb\x8b" . "\x69")
	     ("\xe1\xbb\x8c" . "\x4f")
	     ("\xe1\xbb\x8d" . "\x6f")
	     ("\xe1\xbb\x8e" . "\x4f")
	     ("\xe1\xbb\x8f" . "\x6f")
	     ("\xe1\xbb\x90" . "\x4f")
	     ("\xe1\xbb\x91" . "\x6f")
	     ("\xe1\xbb\x92" . "\x4f")
	     ("\xe1\xbb\x93" . "\x6f")
	     ("\xe1\xbb\x94" . "\x4f")
	     ("\xe1\xbb\x95" . "\x6f")
	     ("\xe1\xbb\x96" . "\x4f")
	     ("\xe1\xbb\x97" . "\x6f")
	     ("\xe1\xbb\x98" . "\x4f")
	     ("\xe1\xbb\x99" . "\x6f")
	     ("\xe1\xbb\x9a" . "\x4f")
	     ("\xe1\xbb\x9b" . "\x6f")
	     ("\xe1\xbb\x9c" . "\x4f")
	     ("\xe1\xbb\x9d" . "\x6f")
	     ("\xe1\xbb\x9e" . "\x4f")
	     ("\xe1\xbb\x9f" . "\x6f")
	     ("\xe1\xbb\xa0" . "\x4f")
	     ("\xe1\xbb\xa1" . "\x6f")
	     ("\xe1\xbb\xa2" . "\x4f")
	     ("\xe1\xbb\xa3" . "\x6f")
	     ("\xe1\xbb\xa4" . "\x55")
	     ("\xe1\xbb\xa5" . "\x75")
	     ("\xe1\xbb\xa6" . "\x55")
	     ("\xe1\xbb\xa7" . "\x75")
	     ("\xe1\xbb\xa8" . "\x55")
	     ("\xe1\xbb\xa9" . "\x75")
	     ("\xe1\xbb\xaa" . "\x55")
	     ("\xe1\xbb\xab" . "\x75")
	     ("\xe1\xbb\xac" . "\x55")
	     ("\xe1\xbb\xad" . "\x75")
	     ("\xe1\xbb\xae" . "\x55")
	     ("\xe1\xbb\xaf" . "\x75")
	     ("\xe1\xbb\xb0" . "\x55")
	     ("\xe1\xbb\xb1" . "\x75")
	     ("\xe1\xbb\xb4" . "\x59")
	     ("\xe1\xbb\xb5" . "\x79")
	     ("\xe1\xbb\xb6" . "\x59")
	     ("\xe1\xbb\xb7" . "\x79")
	     ("\xe1\xbb\xb8" . "\x59")
	     ("\xe1\xbb\xb9" . "\x79"))))
      (if (string-lessp "6" mule-version)
	  (mapcar (lambda (elt)
		    (cons (string-to-char
			   (decode-coding-string (car elt) 'utf-8))
			  (string-to-char
			   (decode-coding-string (cdr elt) 'utf-8))))
		  table)
	(mapcar (lambda (elt)
		  (cons (string-make-unibyte (car elt))
			(string-make-unibyte (cdr elt))))
		table))
	)))

(provide 'lookup-text-table)
