// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _ --version 5
// RUN: %clang_cc1 -verify -Wno-vla -fopenmp -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -triple powerpc64le-unknown-unknown -emit-llvm %s -o - | FileCheck %s
// RUN: %clang_cc1 -fopenmp -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -triple powerpc64le-unknown-unknown -std=c++11 -include-pch %t -verify -Wno-vla %s -emit-llvm -o - | FileCheck %s

// RUN: %clang_cc1 -DOMP60 -verify -Wno-vla -fopenmp -fopenmp-version=60 -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -triple powerpc64le-unknown-unknown -emit-llvm %s -o - | FileCheck --check-prefix OMP60 %s
// RUN: %clang_cc1 -DOMP60 -fopenmp -fopenmp-version=60 -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -emit-pch -o %t %s
// RUN: %clang_cc1 -DOMP60 -fopenmp -fopenmp-version=60 -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -triple powerpc64le-unknown-unknown -std=c++11 -include-pch %t -verify -Wno-vla %s -emit-llvm -o - | FileCheck --check-prefix OMP60 %s

// RUN: %clang_cc1 -verify -Wno-vla -fopenmp-simd -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -triple powerpc64le-unknown-unknown -emit-llvm %s -o - | FileCheck --check-prefix SIMD-ONLY0 %s
// RUN: %clang_cc1 -fopenmp-simd -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp-simd -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -triple powerpc64le-unknown-unknown -std=c++11 -include-pch %t -verify -Wno-vla %s -emit-llvm -o - | FileCheck --check-prefix SIMD-ONLY0 %s

// RUN: %clang_cc1 -DOMP60 -verify -Wno-vla -fopenmp-simd -fopenmp-version=60 -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -triple powerpc64le-unknown-unknown -emit-llvm %s -o - | FileCheck --check-prefix SIMD-ONLY0-OMP60 %s
// RUN: %clang_cc1 -DOMP60 -fopenmp-simd -fopenmp-version=60 -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -emit-pch -o %t %s
// RUN: %clang_cc1 -DOMP60 -fopenmp-simd -fopenmp-version=60 -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -triple powerpc64le-unknown-unknown -std=c++11 -include-pch %t -verify -Wno-vla %s -emit-llvm -o - | FileCheck --check-prefix SIMD-ONLY0-OMP60 %s
// expected-no-diagnostics

#ifndef HEADER
#define HEADER

// 64 = 0x40 = OMP_MAP_RETURN_PARAM
// 0 = OMP_MAP_NONE
// 281474976710720 = 0x1000000000040 = OMP_MAP_MEMBER_OF | OMP_MAP_RETURN_PARAM

struct S {
  int a = 0;
  int *ptr = &a;
  int &ref = a;
  int arr[4];
  S() {}
  void foo() {
#ifdef OMP60
#pragma omp target data map(tofrom: a, ptr [3:4], ref, ptr[0], arr[:a], ptr[:]) use_device_addr(a, ptr [3:4], ref, ptr[0], arr[:a], ptr[:])
#else
#pragma omp target data map(tofrom: a, ptr [3:4], ref, ptr[0], arr[:a]) use_device_addr(a, ptr [3:4], ref, ptr[0], arr[:a])
#endif // OMP60
    ++a, ++*ptr, ++ref, ++arr[0];
  }
};

#ifdef OMP60
int main(int argc, char *argv[]) {
#else
int main() {
#endif // OMP60
  float a = 0;
  float *ptr = &a;
  float &ref = a;
  float arr[4];
  float vla[(int)a];
  S s;
  s.foo();
#ifdef OMP60
#pragma omp target data map(tofrom: a, ptr [3:4], ref, ptr[0], arr[:(int)a], vla[0], ptr[:], argv[0][:]) use_device_addr(a, ptr [3:4], ref, ptr[0], arr[:(int)a], vla[0], ptr[:], argv[0][:])
#else
#pragma omp target data map(tofrom: a, ptr [3:4], ref, ptr[0], arr[:(int)a], vla[0]) use_device_addr(a, ptr [3:4], ref, ptr[0], arr[:(int)a], vla[0])
#endif // OMP60
  ++a, ++*ptr, ++ref, ++arr[0], ++vla[0];
  return a;
}






#endif
// CHECK-LABEL: define dso_local noundef signext i32 @main(
// CHECK-SAME: ) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[A:%.*]] = alloca float, align 4
// CHECK-NEXT:    [[PTR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[REF:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[ARR:%.*]] = alloca [4 x float], align 4
// CHECK-NEXT:    [[SAVED_STACK:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[S:%.*]] = alloca [[STRUCT_S:%.*]], align 8
// CHECK-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [6 x ptr], align 8
// CHECK-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [6 x ptr], align 8
// CHECK-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [6 x ptr], align 8
// CHECK-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [6 x i64], align 8
// CHECK-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK-NEXT:    store float 0.000000e+00, ptr [[A]], align 4
// CHECK-NEXT:    store ptr [[A]], ptr [[PTR]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[REF]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load float, ptr [[A]], align 4
// CHECK-NEXT:    [[CONV:%.*]] = fptosi float [[TMP0]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = zext i32 [[CONV]] to i64
// CHECK-NEXT:    [[TMP2:%.*]] = call ptr @llvm.stacksave.p0()
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[SAVED_STACK]], align 8
// CHECK-NEXT:    [[VLA:%.*]] = alloca float, i64 [[TMP1]], align 4
// CHECK-NEXT:    store i64 [[TMP1]], ptr [[__VLA_EXPR0]], align 8
// CHECK-NEXT:    call void @_ZN1SC1Ev(ptr noundef nonnull align 8 dereferenceable(40) [[S]])
// CHECK-NEXT:    call void @_ZN1S3fooEv(ptr noundef nonnull align 8 dereferenceable(40) [[S]])
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[PTR]], align 8
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds nuw float, ptr [[TMP3]], i64 3
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[PTR]], align 8
// CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds float, ptr [[TMP4]], i64 0
// CHECK-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[REF]], align 8, !nonnull [[META3:![0-9]+]], !align [[META4:![0-9]+]]
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[REF]], align 8, !nonnull [[META3]], !align [[META4]]
// CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds nuw [4 x float], ptr [[ARR]], i64 0, i64 0
// CHECK-NEXT:    [[TMP7:%.*]] = load float, ptr [[A]], align 4
// CHECK-NEXT:    [[CONV3:%.*]] = fptosi float [[TMP7]] to i32
// CHECK-NEXT:    [[CONV4:%.*]] = sext i32 [[CONV3]] to i64
// CHECK-NEXT:    [[TMP8:%.*]] = mul nuw i64 [[CONV4]], 4
// CHECK-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, ptr [[VLA]], i64 0
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[DOTOFFLOAD_SIZES]], ptr align 8 @.offload_sizes, i64 48, i1 false)
// CHECK-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-NEXT:    store ptr [[A]], ptr [[TMP9]], align 8
// CHECK-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-NEXT:    store ptr [[A]], ptr [[TMP10]], align 8
// CHECK-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK-NEXT:    store ptr null, ptr [[TMP11]], align 8
// CHECK-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK-NEXT:    store ptr [[PTR]], ptr [[TMP12]], align 8
// CHECK-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK-NEXT:    store ptr [[ARRAYIDX]], ptr [[TMP13]], align 8
// CHECK-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK-NEXT:    store ptr null, ptr [[TMP14]], align 8
// CHECK-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK-NEXT:    store ptr [[PTR]], ptr [[TMP15]], align 8
// CHECK-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK-NEXT:    store ptr [[ARRAYIDX1]], ptr [[TMP16]], align 8
// CHECK-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK-NEXT:    store ptr null, ptr [[TMP17]], align 8
// CHECK-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK-NEXT:    store ptr [[TMP5]], ptr [[TMP18]], align 8
// CHECK-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK-NEXT:    store ptr [[TMP6]], ptr [[TMP19]], align 8
// CHECK-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK-NEXT:    store ptr null, ptr [[TMP20]], align 8
// CHECK-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK-NEXT:    store ptr [[ARR]], ptr [[TMP21]], align 8
// CHECK-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK-NEXT:    store ptr [[ARRAYIDX2]], ptr [[TMP22]], align 8
// CHECK-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [6 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 4
// CHECK-NEXT:    store i64 [[TMP8]], ptr [[TMP23]], align 8
// CHECK-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK-NEXT:    store ptr null, ptr [[TMP24]], align 8
// CHECK-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 5
// CHECK-NEXT:    store ptr [[VLA]], ptr [[TMP25]], align 8
// CHECK-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 5
// CHECK-NEXT:    store ptr [[ARRAYIDX5]], ptr [[TMP26]], align 8
// CHECK-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 5
// CHECK-NEXT:    store ptr null, ptr [[TMP27]], align 8
// CHECK-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [6 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-NEXT:    call void @__tgt_target_data_begin_mapper(ptr @[[GLOB1:[0-9]+]], i64 -1, i32 6, ptr [[TMP28]], ptr [[TMP29]], ptr [[TMP30]], ptr @.offload_maptypes, ptr null, ptr null)
// CHECK-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[TMP9]], align 8
// CHECK-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[TMP18]], align 8
// CHECK-NEXT:    store ptr [[TMP32]], ptr [[TMP]], align 8
// CHECK-NEXT:    [[TMP33:%.*]] = load ptr, ptr [[TMP21]], align 8
// CHECK-NEXT:    [[TMP34:%.*]] = load ptr, ptr [[TMP25]], align 8
// CHECK-NEXT:    [[TMP35:%.*]] = load float, ptr [[TMP31]], align 4
// CHECK-NEXT:    [[INC:%.*]] = fadd float [[TMP35]], 1.000000e+00
// CHECK-NEXT:    store float [[INC]], ptr [[TMP31]], align 4
// CHECK-NEXT:    [[TMP36:%.*]] = load ptr, ptr [[TMP12]], align 8
// CHECK-NEXT:    [[TMP37:%.*]] = load float, ptr [[TMP36]], align 4
// CHECK-NEXT:    [[INC6:%.*]] = fadd float [[TMP37]], 1.000000e+00
// CHECK-NEXT:    store float [[INC6]], ptr [[TMP36]], align 4
// CHECK-NEXT:    [[TMP38:%.*]] = load ptr, ptr [[TMP]], align 8, !nonnull [[META3]], !align [[META4]]
// CHECK-NEXT:    [[TMP39:%.*]] = load float, ptr [[TMP38]], align 4
// CHECK-NEXT:    [[INC7:%.*]] = fadd float [[TMP39]], 1.000000e+00
// CHECK-NEXT:    store float [[INC7]], ptr [[TMP38]], align 4
// CHECK-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [4 x float], ptr [[TMP33]], i64 0, i64 0
// CHECK-NEXT:    [[TMP40:%.*]] = load float, ptr [[ARRAYIDX8]], align 4
// CHECK-NEXT:    [[INC9:%.*]] = fadd float [[TMP40]], 1.000000e+00
// CHECK-NEXT:    store float [[INC9]], ptr [[ARRAYIDX8]], align 4
// CHECK-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, ptr [[TMP34]], i64 0
// CHECK-NEXT:    [[TMP41:%.*]] = load float, ptr [[ARRAYIDX10]], align 4
// CHECK-NEXT:    [[INC11:%.*]] = fadd float [[TMP41]], 1.000000e+00
// CHECK-NEXT:    store float [[INC11]], ptr [[ARRAYIDX10]], align 4
// CHECK-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [6 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-NEXT:    call void @__tgt_target_data_end_mapper(ptr @[[GLOB1]], i64 -1, i32 6, ptr [[TMP42]], ptr [[TMP43]], ptr [[TMP44]], ptr @.offload_maptypes, ptr null, ptr null)
// CHECK-NEXT:    [[TMP45:%.*]] = load float, ptr [[A]], align 4
// CHECK-NEXT:    [[CONV12:%.*]] = fptosi float [[TMP45]] to i32
// CHECK-NEXT:    store i32 [[CONV12]], ptr [[RETVAL]], align 4
// CHECK-NEXT:    [[TMP46:%.*]] = load ptr, ptr [[SAVED_STACK]], align 8
// CHECK-NEXT:    call void @llvm.stackrestore.p0(ptr [[TMP46]])
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK-NEXT:    ret i32 [[TMP47]]
//
//
// CHECK-LABEL: define linkonce_odr void @_ZN1SC1Ev(
// CHECK-SAME: ptr noundef nonnull align 8 dereferenceable(40) [[THIS:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] comdat {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    call void @_ZN1SC2Ev(ptr noundef nonnull align 8 dereferenceable(40) [[THIS1]])
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define linkonce_odr void @_ZN1S3fooEv(
// CHECK-SAME: ptr noundef nonnull align 8 dereferenceable(40) [[THIS:%.*]]) #[[ATTR2]] comdat {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [6 x ptr], align 8
// CHECK-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [6 x ptr], align 8
// CHECK-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [6 x ptr], align 8
// CHECK-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [6 x i64], align 8
// CHECK-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[_TMP11:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[_TMP12:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[_TMP13:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[_TMP14:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-NEXT:    [[PTR:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// CHECK-NEXT:    [[PTR2:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR2]], align 8
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP0]], i64 3
// CHECK-NEXT:    [[REF:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 2
// CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[REF]], align 8, !nonnull [[META3]], !align [[META4]]
// CHECK-NEXT:    [[PTR3:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// CHECK-NEXT:    [[PTR4:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// CHECK-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[PTR4]], align 8
// CHECK-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds i32, ptr [[TMP2]], i64 0
// CHECK-NEXT:    [[ARR:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 3
// CHECK-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw [4 x i32], ptr [[ARR]], i64 0, i64 0
// CHECK-NEXT:    [[A7:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 0
// CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[A7]], align 8
// CHECK-NEXT:    [[CONV:%.*]] = sext i32 [[TMP3]] to i64
// CHECK-NEXT:    [[TMP4:%.*]] = mul nuw i64 [[CONV]], 4
// CHECK-NEXT:    [[A8:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 0
// CHECK-NEXT:    [[TMP5:%.*]] = load i32, ptr [[A8]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = sext i32 [[TMP5]] to i64
// CHECK-NEXT:    [[LB_ADD_LEN:%.*]] = add nsw i64 -1, [[TMP6]]
// CHECK-NEXT:    [[ARR9:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 3
// CHECK-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds nuw [4 x i32], ptr [[ARR9]], i64 0, i64 [[LB_ADD_LEN]]
// CHECK-NEXT:    [[TMP7:%.*]] = getelementptr i32, ptr [[ARRAYIDX10]], i32 1
// CHECK-NEXT:    [[TMP8:%.*]] = ptrtoint ptr [[TMP7]] to i64
// CHECK-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[A]] to i64
// CHECK-NEXT:    [[TMP10:%.*]] = sub i64 [[TMP8]], [[TMP9]]
// CHECK-NEXT:    [[TMP11:%.*]] = sdiv exact i64 [[TMP10]], ptrtoint (ptr getelementptr (i8, ptr null, i32 1) to i64)
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[DOTOFFLOAD_SIZES]], ptr align 8 @.offload_sizes.1, i64 48, i1 false)
// CHECK-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-NEXT:    store ptr [[THIS1]], ptr [[TMP12]], align 8
// CHECK-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-NEXT:    store ptr [[A]], ptr [[TMP13]], align 8
// CHECK-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [6 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-NEXT:    store i64 [[TMP11]], ptr [[TMP14]], align 8
// CHECK-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK-NEXT:    store ptr null, ptr [[TMP15]], align 8
// CHECK-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK-NEXT:    store ptr [[THIS1]], ptr [[TMP16]], align 8
// CHECK-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK-NEXT:    store ptr [[A]], ptr [[TMP17]], align 8
// CHECK-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK-NEXT:    store ptr null, ptr [[TMP18]], align 8
// CHECK-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK-NEXT:    store ptr [[PTR]], ptr [[TMP19]], align 8
// CHECK-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK-NEXT:    store ptr [[ARRAYIDX]], ptr [[TMP20]], align 8
// CHECK-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK-NEXT:    store ptr null, ptr [[TMP21]], align 8
// CHECK-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK-NEXT:    store ptr [[THIS1]], ptr [[TMP22]], align 8
// CHECK-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[TMP23]], align 8
// CHECK-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK-NEXT:    store ptr null, ptr [[TMP24]], align 8
// CHECK-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK-NEXT:    store ptr [[PTR3]], ptr [[TMP25]], align 8
// CHECK-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK-NEXT:    store ptr [[ARRAYIDX5]], ptr [[TMP26]], align 8
// CHECK-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK-NEXT:    store ptr null, ptr [[TMP27]], align 8
// CHECK-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 5
// CHECK-NEXT:    store ptr [[THIS1]], ptr [[TMP28]], align 8
// CHECK-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 5
// CHECK-NEXT:    store ptr [[ARRAYIDX6]], ptr [[TMP29]], align 8
// CHECK-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [6 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 5
// CHECK-NEXT:    store i64 [[TMP4]], ptr [[TMP30]], align 8
// CHECK-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 5
// CHECK-NEXT:    store ptr null, ptr [[TMP31]], align 8
// CHECK-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [6 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-NEXT:    call void @__tgt_target_data_begin_mapper(ptr @[[GLOB1]], i64 -1, i32 6, ptr [[TMP32]], ptr [[TMP33]], ptr [[TMP34]], ptr @.offload_maptypes.2, ptr null, ptr null)
// CHECK-NEXT:    [[TMP35:%.*]] = load ptr, ptr [[TMP16]], align 8
// CHECK-NEXT:    store ptr [[TMP35]], ptr [[TMP]], align 8
// CHECK-NEXT:    [[TMP36:%.*]] = load ptr, ptr [[TMP19]], align 8
// CHECK-NEXT:    store ptr [[TMP36]], ptr [[_TMP11]], align 8
// CHECK-NEXT:    [[TMP37:%.*]] = load ptr, ptr [[TMP22]], align 8
// CHECK-NEXT:    store ptr [[TMP37]], ptr [[_TMP12]], align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load ptr, ptr [[TMP19]], align 8
// CHECK-NEXT:    store ptr [[TMP38]], ptr [[_TMP13]], align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load ptr, ptr [[TMP28]], align 8
// CHECK-NEXT:    store ptr [[TMP39]], ptr [[_TMP14]], align 8
// CHECK-NEXT:    [[TMP40:%.*]] = load ptr, ptr [[TMP]], align 8, !nonnull [[META3]], !align [[META4]]
// CHECK-NEXT:    [[TMP41:%.*]] = load i32, ptr [[TMP40]], align 4
// CHECK-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP41]], 1
// CHECK-NEXT:    store i32 [[INC]], ptr [[TMP40]], align 4
// CHECK-NEXT:    [[TMP42:%.*]] = load ptr, ptr [[_TMP13]], align 8, !nonnull [[META3]], !align [[META5:![0-9]+]]
// CHECK-NEXT:    [[TMP43:%.*]] = load ptr, ptr [[TMP42]], align 8
// CHECK-NEXT:    [[TMP44:%.*]] = load i32, ptr [[TMP43]], align 4
// CHECK-NEXT:    [[INC15:%.*]] = add nsw i32 [[TMP44]], 1
// CHECK-NEXT:    store i32 [[INC15]], ptr [[TMP43]], align 4
// CHECK-NEXT:    [[TMP45:%.*]] = load ptr, ptr [[_TMP12]], align 8, !nonnull [[META3]], !align [[META4]]
// CHECK-NEXT:    [[TMP46:%.*]] = load i32, ptr [[TMP45]], align 4
// CHECK-NEXT:    [[INC16:%.*]] = add nsw i32 [[TMP46]], 1
// CHECK-NEXT:    store i32 [[INC16]], ptr [[TMP45]], align 4
// CHECK-NEXT:    [[TMP47:%.*]] = load ptr, ptr [[_TMP14]], align 8, !nonnull [[META3]], !align [[META4]]
// CHECK-NEXT:    [[ARRAYIDX17:%.*]] = getelementptr inbounds [4 x i32], ptr [[TMP47]], i64 0, i64 0
// CHECK-NEXT:    [[TMP48:%.*]] = load i32, ptr [[ARRAYIDX17]], align 4
// CHECK-NEXT:    [[INC18:%.*]] = add nsw i32 [[TMP48]], 1
// CHECK-NEXT:    store i32 [[INC18]], ptr [[ARRAYIDX17]], align 4
// CHECK-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [6 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [6 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-NEXT:    call void @__tgt_target_data_end_mapper(ptr @[[GLOB1]], i64 -1, i32 6, ptr [[TMP49]], ptr [[TMP50]], ptr [[TMP51]], ptr @.offload_maptypes.2, ptr null, ptr null)
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define linkonce_odr void @_ZN1SC2Ev(
// CHECK-SAME: ptr noundef nonnull align 8 dereferenceable(40) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-NEXT:    store i32 0, ptr [[A]], align 8
// CHECK-NEXT:    [[PTR:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// CHECK-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 0
// CHECK-NEXT:    store ptr [[A2]], ptr [[PTR]], align 8
// CHECK-NEXT:    [[REF:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 2
// CHECK-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 0
// CHECK-NEXT:    store ptr [[A3]], ptr [[REF]], align 8
// CHECK-NEXT:    ret void
//
//
// OMP60-LABEL: define dso_local noundef signext i32 @main(
// OMP60-SAME: i32 noundef signext [[ARGC:%.*]], ptr noundef [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// OMP60-NEXT:  [[ENTRY:.*:]]
// OMP60-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// OMP60-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// OMP60-NEXT:    [[ARGV_ADDR:%.*]] = alloca ptr, align 8
// OMP60-NEXT:    [[A:%.*]] = alloca float, align 4
// OMP60-NEXT:    [[PTR:%.*]] = alloca ptr, align 8
// OMP60-NEXT:    [[REF:%.*]] = alloca ptr, align 8
// OMP60-NEXT:    [[ARR:%.*]] = alloca [4 x float], align 4
// OMP60-NEXT:    [[SAVED_STACK:%.*]] = alloca ptr, align 8
// OMP60-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// OMP60-NEXT:    [[S:%.*]] = alloca [[STRUCT_S:%.*]], align 8
// OMP60-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [9 x ptr], align 8
// OMP60-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [9 x ptr], align 8
// OMP60-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [9 x ptr], align 8
// OMP60-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [9 x i64], align 8
// OMP60-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// OMP60-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// OMP60-NEXT:    store i32 [[ARGC]], ptr [[ARGC_ADDR]], align 4
// OMP60-NEXT:    store ptr [[ARGV]], ptr [[ARGV_ADDR]], align 8
// OMP60-NEXT:    store float 0.000000e+00, ptr [[A]], align 4
// OMP60-NEXT:    store ptr [[A]], ptr [[PTR]], align 8
// OMP60-NEXT:    store ptr [[A]], ptr [[REF]], align 8
// OMP60-NEXT:    [[TMP0:%.*]] = load float, ptr [[A]], align 4
// OMP60-NEXT:    [[CONV:%.*]] = fptosi float [[TMP0]] to i32
// OMP60-NEXT:    [[TMP1:%.*]] = zext i32 [[CONV]] to i64
// OMP60-NEXT:    [[TMP2:%.*]] = call ptr @llvm.stacksave.p0()
// OMP60-NEXT:    store ptr [[TMP2]], ptr [[SAVED_STACK]], align 8
// OMP60-NEXT:    [[VLA:%.*]] = alloca float, i64 [[TMP1]], align 4
// OMP60-NEXT:    store i64 [[TMP1]], ptr [[__VLA_EXPR0]], align 8
// OMP60-NEXT:    call void @_ZN1SC1Ev(ptr noundef nonnull align 8 dereferenceable(40) [[S]])
// OMP60-NEXT:    call void @_ZN1S3fooEv(ptr noundef nonnull align 8 dereferenceable(40) [[S]])
// OMP60-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[PTR]], align 8
// OMP60-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds nuw float, ptr [[TMP3]], i64 3
// OMP60-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[PTR]], align 8
// OMP60-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds float, ptr [[TMP4]], i64 0
// OMP60-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[PTR]], align 8
// OMP60-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds nuw float, ptr [[TMP5]], i64 0
// OMP60-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[REF]], align 8, !nonnull [[META3:![0-9]+]], !align [[META4:![0-9]+]]
// OMP60-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[REF]], align 8, !nonnull [[META3]], !align [[META4]]
// OMP60-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds nuw [4 x float], ptr [[ARR]], i64 0, i64 0
// OMP60-NEXT:    [[TMP8:%.*]] = load float, ptr [[A]], align 4
// OMP60-NEXT:    [[CONV4:%.*]] = fptosi float [[TMP8]] to i32
// OMP60-NEXT:    [[CONV5:%.*]] = sext i32 [[CONV4]] to i64
// OMP60-NEXT:    [[TMP9:%.*]] = mul nuw i64 [[CONV5]], 4
// OMP60-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, ptr [[VLA]], i64 0
// OMP60-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[ARGV_ADDR]], align 8
// OMP60-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[ARGV_ADDR]], align 8
// OMP60-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds ptr, ptr [[TMP11]], i64 0
// OMP60-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[ARGV_ADDR]], align 8
// OMP60-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds ptr, ptr [[TMP12]], i64 0
// OMP60-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[ARRAYIDX8]], align 8
// OMP60-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw i8, ptr [[TMP13]], i64 0
// OMP60-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[DOTOFFLOAD_SIZES]], ptr align 8 @.offload_sizes, i64 72, i1 false)
// OMP60-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// OMP60-NEXT:    store ptr [[A]], ptr [[TMP14]], align 8
// OMP60-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// OMP60-NEXT:    store ptr [[A]], ptr [[TMP15]], align 8
// OMP60-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// OMP60-NEXT:    store ptr null, ptr [[TMP16]], align 8
// OMP60-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// OMP60-NEXT:    store ptr [[PTR]], ptr [[TMP17]], align 8
// OMP60-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// OMP60-NEXT:    store ptr [[ARRAYIDX]], ptr [[TMP18]], align 8
// OMP60-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// OMP60-NEXT:    store ptr null, ptr [[TMP19]], align 8
// OMP60-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// OMP60-NEXT:    store ptr [[PTR]], ptr [[TMP20]], align 8
// OMP60-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// OMP60-NEXT:    store ptr [[ARRAYIDX1]], ptr [[TMP21]], align 8
// OMP60-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// OMP60-NEXT:    store ptr null, ptr [[TMP22]], align 8
// OMP60-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// OMP60-NEXT:    store ptr [[PTR]], ptr [[TMP23]], align 8
// OMP60-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// OMP60-NEXT:    store ptr [[ARRAYIDX2]], ptr [[TMP24]], align 8
// OMP60-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// OMP60-NEXT:    store ptr null, ptr [[TMP25]], align 8
// OMP60-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// OMP60-NEXT:    store ptr [[TMP6]], ptr [[TMP26]], align 8
// OMP60-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// OMP60-NEXT:    store ptr [[TMP7]], ptr [[TMP27]], align 8
// OMP60-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// OMP60-NEXT:    store ptr null, ptr [[TMP28]], align 8
// OMP60-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 5
// OMP60-NEXT:    store ptr [[ARR]], ptr [[TMP29]], align 8
// OMP60-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 5
// OMP60-NEXT:    store ptr [[ARRAYIDX3]], ptr [[TMP30]], align 8
// OMP60-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [9 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 5
// OMP60-NEXT:    store i64 [[TMP9]], ptr [[TMP31]], align 8
// OMP60-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 5
// OMP60-NEXT:    store ptr null, ptr [[TMP32]], align 8
// OMP60-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 6
// OMP60-NEXT:    store ptr [[VLA]], ptr [[TMP33]], align 8
// OMP60-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 6
// OMP60-NEXT:    store ptr [[ARRAYIDX6]], ptr [[TMP34]], align 8
// OMP60-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 6
// OMP60-NEXT:    store ptr null, ptr [[TMP35]], align 8
// OMP60-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 7
// OMP60-NEXT:    store ptr [[TMP10]], ptr [[TMP36]], align 8
// OMP60-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 7
// OMP60-NEXT:    store ptr [[ARRAYIDX7]], ptr [[TMP37]], align 8
// OMP60-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 7
// OMP60-NEXT:    store ptr null, ptr [[TMP38]], align 8
// OMP60-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 8
// OMP60-NEXT:    store ptr [[ARRAYIDX7]], ptr [[TMP39]], align 8
// OMP60-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 8
// OMP60-NEXT:    store ptr [[ARRAYIDX9]], ptr [[TMP40]], align 8
// OMP60-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 8
// OMP60-NEXT:    store ptr null, ptr [[TMP41]], align 8
// OMP60-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// OMP60-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// OMP60-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [9 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// OMP60-NEXT:    call void @__tgt_target_data_begin_mapper(ptr @[[GLOB1:[0-9]+]], i64 -1, i32 9, ptr [[TMP42]], ptr [[TMP43]], ptr [[TMP44]], ptr @.offload_maptypes, ptr null, ptr null)
// OMP60-NEXT:    [[TMP45:%.*]] = load ptr, ptr [[TMP14]], align 8
// OMP60-NEXT:    [[TMP46:%.*]] = load ptr, ptr [[TMP26]], align 8
// OMP60-NEXT:    store ptr [[TMP46]], ptr [[TMP]], align 8
// OMP60-NEXT:    [[TMP47:%.*]] = load ptr, ptr [[TMP29]], align 8
// OMP60-NEXT:    [[TMP48:%.*]] = load ptr, ptr [[TMP33]], align 8
// OMP60-NEXT:    [[TMP49:%.*]] = load float, ptr [[TMP45]], align 4
// OMP60-NEXT:    [[INC:%.*]] = fadd float [[TMP49]], 1.000000e+00
// OMP60-NEXT:    store float [[INC]], ptr [[TMP45]], align 4
// OMP60-NEXT:    [[TMP50:%.*]] = load ptr, ptr [[TMP17]], align 8
// OMP60-NEXT:    [[TMP51:%.*]] = load float, ptr [[TMP50]], align 4
// OMP60-NEXT:    [[INC10:%.*]] = fadd float [[TMP51]], 1.000000e+00
// OMP60-NEXT:    store float [[INC10]], ptr [[TMP50]], align 4
// OMP60-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[TMP]], align 8, !nonnull [[META3]], !align [[META4]]
// OMP60-NEXT:    [[TMP53:%.*]] = load float, ptr [[TMP52]], align 4
// OMP60-NEXT:    [[INC11:%.*]] = fadd float [[TMP53]], 1.000000e+00
// OMP60-NEXT:    store float [[INC11]], ptr [[TMP52]], align 4
// OMP60-NEXT:    [[ARRAYIDX12:%.*]] = getelementptr inbounds [4 x float], ptr [[TMP47]], i64 0, i64 0
// OMP60-NEXT:    [[TMP54:%.*]] = load float, ptr [[ARRAYIDX12]], align 4
// OMP60-NEXT:    [[INC13:%.*]] = fadd float [[TMP54]], 1.000000e+00
// OMP60-NEXT:    store float [[INC13]], ptr [[ARRAYIDX12]], align 4
// OMP60-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds float, ptr [[TMP48]], i64 0
// OMP60-NEXT:    [[TMP55:%.*]] = load float, ptr [[ARRAYIDX14]], align 4
// OMP60-NEXT:    [[INC15:%.*]] = fadd float [[TMP55]], 1.000000e+00
// OMP60-NEXT:    store float [[INC15]], ptr [[ARRAYIDX14]], align 4
// OMP60-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// OMP60-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// OMP60-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [9 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// OMP60-NEXT:    call void @__tgt_target_data_end_mapper(ptr @[[GLOB1]], i64 -1, i32 9, ptr [[TMP56]], ptr [[TMP57]], ptr [[TMP58]], ptr @.offload_maptypes, ptr null, ptr null)
// OMP60-NEXT:    [[TMP59:%.*]] = load float, ptr [[A]], align 4
// OMP60-NEXT:    [[CONV16:%.*]] = fptosi float [[TMP59]] to i32
// OMP60-NEXT:    store i32 [[CONV16]], ptr [[RETVAL]], align 4
// OMP60-NEXT:    [[TMP60:%.*]] = load ptr, ptr [[SAVED_STACK]], align 8
// OMP60-NEXT:    call void @llvm.stackrestore.p0(ptr [[TMP60]])
// OMP60-NEXT:    [[TMP61:%.*]] = load i32, ptr [[RETVAL]], align 4
// OMP60-NEXT:    ret i32 [[TMP61]]
//
//
// OMP60-LABEL: define linkonce_odr void @_ZN1SC1Ev(
// OMP60-SAME: ptr noundef nonnull align 8 dereferenceable(40) [[THIS:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] comdat {
// OMP60-NEXT:  [[ENTRY:.*:]]
// OMP60-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// OMP60-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// OMP60-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// OMP60-NEXT:    call void @_ZN1SC2Ev(ptr noundef nonnull align 8 dereferenceable(40) [[THIS1]])
// OMP60-NEXT:    ret void
//
//
// OMP60-LABEL: define linkonce_odr void @_ZN1S3fooEv(
// OMP60-SAME: ptr noundef nonnull align 8 dereferenceable(40) [[THIS:%.*]]) #[[ATTR2]] comdat {
// OMP60-NEXT:  [[ENTRY:.*:]]
// OMP60-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// OMP60-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [7 x ptr], align 8
// OMP60-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [7 x ptr], align 8
// OMP60-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [7 x ptr], align 8
// OMP60-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [7 x i64], align 8
// OMP60-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// OMP60-NEXT:    [[_TMP14:%.*]] = alloca ptr, align 8
// OMP60-NEXT:    [[_TMP15:%.*]] = alloca ptr, align 8
// OMP60-NEXT:    [[_TMP16:%.*]] = alloca ptr, align 8
// OMP60-NEXT:    [[_TMP17:%.*]] = alloca ptr, align 8
// OMP60-NEXT:    [[_TMP18:%.*]] = alloca ptr, align 8
// OMP60-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// OMP60-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// OMP60-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// OMP60-NEXT:    [[PTR:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// OMP60-NEXT:    [[PTR2:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// OMP60-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR2]], align 8
// OMP60-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP0]], i64 3
// OMP60-NEXT:    [[REF:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 2
// OMP60-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[REF]], align 8, !nonnull [[META3]], !align [[META4]]
// OMP60-NEXT:    [[PTR3:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// OMP60-NEXT:    [[PTR4:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// OMP60-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[PTR4]], align 8
// OMP60-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds i32, ptr [[TMP2]], i64 0
// OMP60-NEXT:    [[ARR:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 3
// OMP60-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw [4 x i32], ptr [[ARR]], i64 0, i64 0
// OMP60-NEXT:    [[A7:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 0
// OMP60-NEXT:    [[TMP3:%.*]] = load i32, ptr [[A7]], align 8
// OMP60-NEXT:    [[CONV:%.*]] = sext i32 [[TMP3]] to i64
// OMP60-NEXT:    [[TMP4:%.*]] = mul nuw i64 [[CONV]], 4
// OMP60-NEXT:    [[A8:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 0
// OMP60-NEXT:    [[TMP5:%.*]] = load i32, ptr [[A8]], align 8
// OMP60-NEXT:    [[TMP6:%.*]] = sext i32 [[TMP5]] to i64
// OMP60-NEXT:    [[LB_ADD_LEN:%.*]] = add nsw i64 -1, [[TMP6]]
// OMP60-NEXT:    [[ARR9:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 3
// OMP60-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds nuw [4 x i32], ptr [[ARR9]], i64 0, i64 [[LB_ADD_LEN]]
// OMP60-NEXT:    [[PTR11:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// OMP60-NEXT:    [[PTR12:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// OMP60-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[PTR12]], align 8
// OMP60-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP7]], i64 0
// OMP60-NEXT:    [[TMP8:%.*]] = getelementptr i32, ptr [[ARRAYIDX10]], i32 1
// OMP60-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[TMP8]] to i64
// OMP60-NEXT:    [[TMP10:%.*]] = ptrtoint ptr [[A]] to i64
// OMP60-NEXT:    [[TMP11:%.*]] = sub i64 [[TMP9]], [[TMP10]]
// OMP60-NEXT:    [[TMP12:%.*]] = sdiv exact i64 [[TMP11]], ptrtoint (ptr getelementptr (i8, ptr null, i32 1) to i64)
// OMP60-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[DOTOFFLOAD_SIZES]], ptr align 8 @.offload_sizes.1, i64 56, i1 false)
// OMP60-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// OMP60-NEXT:    store ptr [[THIS1]], ptr [[TMP13]], align 8
// OMP60-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// OMP60-NEXT:    store ptr [[A]], ptr [[TMP14]], align 8
// OMP60-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [7 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// OMP60-NEXT:    store i64 [[TMP12]], ptr [[TMP15]], align 8
// OMP60-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// OMP60-NEXT:    store ptr null, ptr [[TMP16]], align 8
// OMP60-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// OMP60-NEXT:    store ptr [[THIS1]], ptr [[TMP17]], align 8
// OMP60-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// OMP60-NEXT:    store ptr [[A]], ptr [[TMP18]], align 8
// OMP60-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// OMP60-NEXT:    store ptr null, ptr [[TMP19]], align 8
// OMP60-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// OMP60-NEXT:    store ptr [[PTR]], ptr [[TMP20]], align 8
// OMP60-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// OMP60-NEXT:    store ptr [[ARRAYIDX]], ptr [[TMP21]], align 8
// OMP60-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// OMP60-NEXT:    store ptr null, ptr [[TMP22]], align 8
// OMP60-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// OMP60-NEXT:    store ptr [[THIS1]], ptr [[TMP23]], align 8
// OMP60-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// OMP60-NEXT:    store ptr [[TMP1]], ptr [[TMP24]], align 8
// OMP60-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// OMP60-NEXT:    store ptr null, ptr [[TMP25]], align 8
// OMP60-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// OMP60-NEXT:    store ptr [[PTR3]], ptr [[TMP26]], align 8
// OMP60-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// OMP60-NEXT:    store ptr [[ARRAYIDX5]], ptr [[TMP27]], align 8
// OMP60-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// OMP60-NEXT:    store ptr null, ptr [[TMP28]], align 8
// OMP60-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 5
// OMP60-NEXT:    store ptr [[THIS1]], ptr [[TMP29]], align 8
// OMP60-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 5
// OMP60-NEXT:    store ptr [[ARRAYIDX6]], ptr [[TMP30]], align 8
// OMP60-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [7 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 5
// OMP60-NEXT:    store i64 [[TMP4]], ptr [[TMP31]], align 8
// OMP60-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 5
// OMP60-NEXT:    store ptr null, ptr [[TMP32]], align 8
// OMP60-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 6
// OMP60-NEXT:    store ptr [[PTR11]], ptr [[TMP33]], align 8
// OMP60-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 6
// OMP60-NEXT:    store ptr [[ARRAYIDX13]], ptr [[TMP34]], align 8
// OMP60-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 6
// OMP60-NEXT:    store ptr null, ptr [[TMP35]], align 8
// OMP60-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// OMP60-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// OMP60-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [7 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// OMP60-NEXT:    call void @__tgt_target_data_begin_mapper(ptr @[[GLOB1]], i64 -1, i32 7, ptr [[TMP36]], ptr [[TMP37]], ptr [[TMP38]], ptr @.offload_maptypes.2, ptr null, ptr null)
// OMP60-NEXT:    [[TMP39:%.*]] = load ptr, ptr [[TMP17]], align 8
// OMP60-NEXT:    store ptr [[TMP39]], ptr [[TMP]], align 8
// OMP60-NEXT:    [[TMP40:%.*]] = load ptr, ptr [[TMP20]], align 8
// OMP60-NEXT:    store ptr [[TMP40]], ptr [[_TMP14]], align 8
// OMP60-NEXT:    [[TMP41:%.*]] = load ptr, ptr [[TMP23]], align 8
// OMP60-NEXT:    store ptr [[TMP41]], ptr [[_TMP15]], align 8
// OMP60-NEXT:    [[TMP42:%.*]] = load ptr, ptr [[TMP20]], align 8
// OMP60-NEXT:    store ptr [[TMP42]], ptr [[_TMP16]], align 8
// OMP60-NEXT:    [[TMP43:%.*]] = load ptr, ptr [[TMP29]], align 8
// OMP60-NEXT:    store ptr [[TMP43]], ptr [[_TMP17]], align 8
// OMP60-NEXT:    [[TMP44:%.*]] = load ptr, ptr [[TMP20]], align 8
// OMP60-NEXT:    store ptr [[TMP44]], ptr [[_TMP18]], align 8
// OMP60-NEXT:    [[TMP45:%.*]] = load ptr, ptr [[TMP]], align 8, !nonnull [[META3]], !align [[META4]]
// OMP60-NEXT:    [[TMP46:%.*]] = load i32, ptr [[TMP45]], align 4
// OMP60-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP46]], 1
// OMP60-NEXT:    store i32 [[INC]], ptr [[TMP45]], align 4
// OMP60-NEXT:    [[TMP47:%.*]] = load ptr, ptr [[_TMP18]], align 8, !nonnull [[META3]], !align [[META5:![0-9]+]]
// OMP60-NEXT:    [[TMP48:%.*]] = load ptr, ptr [[TMP47]], align 8
// OMP60-NEXT:    [[TMP49:%.*]] = load i32, ptr [[TMP48]], align 4
// OMP60-NEXT:    [[INC19:%.*]] = add nsw i32 [[TMP49]], 1
// OMP60-NEXT:    store i32 [[INC19]], ptr [[TMP48]], align 4
// OMP60-NEXT:    [[TMP50:%.*]] = load ptr, ptr [[_TMP15]], align 8, !nonnull [[META3]], !align [[META4]]
// OMP60-NEXT:    [[TMP51:%.*]] = load i32, ptr [[TMP50]], align 4
// OMP60-NEXT:    [[INC20:%.*]] = add nsw i32 [[TMP51]], 1
// OMP60-NEXT:    store i32 [[INC20]], ptr [[TMP50]], align 4
// OMP60-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[_TMP17]], align 8, !nonnull [[META3]], !align [[META4]]
// OMP60-NEXT:    [[ARRAYIDX21:%.*]] = getelementptr inbounds [4 x i32], ptr [[TMP52]], i64 0, i64 0
// OMP60-NEXT:    [[TMP53:%.*]] = load i32, ptr [[ARRAYIDX21]], align 4
// OMP60-NEXT:    [[INC22:%.*]] = add nsw i32 [[TMP53]], 1
// OMP60-NEXT:    store i32 [[INC22]], ptr [[ARRAYIDX21]], align 4
// OMP60-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// OMP60-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [7 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// OMP60-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [7 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// OMP60-NEXT:    call void @__tgt_target_data_end_mapper(ptr @[[GLOB1]], i64 -1, i32 7, ptr [[TMP54]], ptr [[TMP55]], ptr [[TMP56]], ptr @.offload_maptypes.2, ptr null, ptr null)
// OMP60-NEXT:    ret void
//
//
// OMP60-LABEL: define linkonce_odr void @_ZN1SC2Ev(
// OMP60-SAME: ptr noundef nonnull align 8 dereferenceable(40) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat {
// OMP60-NEXT:  [[ENTRY:.*:]]
// OMP60-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// OMP60-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// OMP60-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// OMP60-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// OMP60-NEXT:    store i32 0, ptr [[A]], align 8
// OMP60-NEXT:    [[PTR:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// OMP60-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 0
// OMP60-NEXT:    store ptr [[A2]], ptr [[PTR]], align 8
// OMP60-NEXT:    [[REF:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 2
// OMP60-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 0
// OMP60-NEXT:    store ptr [[A3]], ptr [[REF]], align 8
// OMP60-NEXT:    ret void
//
//
// SIMD-ONLY0-LABEL: define dso_local noundef signext i32 @main(
// SIMD-ONLY0-SAME: ) #[[ATTR0:[0-9]+]] {
// SIMD-ONLY0-NEXT:  [[ENTRY:.*:]]
// SIMD-ONLY0-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// SIMD-ONLY0-NEXT:    [[A:%.*]] = alloca float, align 4
// SIMD-ONLY0-NEXT:    [[PTR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[REF:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[ARR:%.*]] = alloca [4 x float], align 4
// SIMD-ONLY0-NEXT:    [[SAVED_STACK:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// SIMD-ONLY0-NEXT:    [[S:%.*]] = alloca [[STRUCT_S:%.*]], align 8
// SIMD-ONLY0-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// SIMD-ONLY0-NEXT:    store float 0.000000e+00, ptr [[A]], align 4
// SIMD-ONLY0-NEXT:    store ptr [[A]], ptr [[PTR]], align 8
// SIMD-ONLY0-NEXT:    store ptr [[A]], ptr [[REF]], align 8
// SIMD-ONLY0-NEXT:    [[TMP0:%.*]] = load float, ptr [[A]], align 4
// SIMD-ONLY0-NEXT:    [[CONV:%.*]] = fptosi float [[TMP0]] to i32
// SIMD-ONLY0-NEXT:    [[TMP1:%.*]] = zext i32 [[CONV]] to i64
// SIMD-ONLY0-NEXT:    [[TMP2:%.*]] = call ptr @llvm.stacksave.p0()
// SIMD-ONLY0-NEXT:    store ptr [[TMP2]], ptr [[SAVED_STACK]], align 8
// SIMD-ONLY0-NEXT:    [[VLA:%.*]] = alloca float, i64 [[TMP1]], align 4
// SIMD-ONLY0-NEXT:    store i64 [[TMP1]], ptr [[__VLA_EXPR0]], align 8
// SIMD-ONLY0-NEXT:    call void @_ZN1SC1Ev(ptr noundef nonnull align 8 dereferenceable(40) [[S]])
// SIMD-ONLY0-NEXT:    call void @_ZN1S3fooEv(ptr noundef nonnull align 8 dereferenceable(40) [[S]])
// SIMD-ONLY0-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[REF]], align 8, !nonnull [[META2:![0-9]+]], !align [[META3:![0-9]+]]
// SIMD-ONLY0-NEXT:    store ptr [[TMP3]], ptr [[TMP]], align 8
// SIMD-ONLY0-NEXT:    [[TMP4:%.*]] = load float, ptr [[A]], align 4
// SIMD-ONLY0-NEXT:    [[INC:%.*]] = fadd float [[TMP4]], 1.000000e+00
// SIMD-ONLY0-NEXT:    store float [[INC]], ptr [[A]], align 4
// SIMD-ONLY0-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[PTR]], align 8
// SIMD-ONLY0-NEXT:    [[TMP6:%.*]] = load float, ptr [[TMP5]], align 4
// SIMD-ONLY0-NEXT:    [[INC1:%.*]] = fadd float [[TMP6]], 1.000000e+00
// SIMD-ONLY0-NEXT:    store float [[INC1]], ptr [[TMP5]], align 4
// SIMD-ONLY0-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP]], align 8, !nonnull [[META2]], !align [[META3]]
// SIMD-ONLY0-NEXT:    [[TMP8:%.*]] = load float, ptr [[TMP7]], align 4
// SIMD-ONLY0-NEXT:    [[INC2:%.*]] = fadd float [[TMP8]], 1.000000e+00
// SIMD-ONLY0-NEXT:    store float [[INC2]], ptr [[TMP7]], align 4
// SIMD-ONLY0-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [4 x float], ptr [[ARR]], i64 0, i64 0
// SIMD-ONLY0-NEXT:    [[TMP9:%.*]] = load float, ptr [[ARRAYIDX]], align 4
// SIMD-ONLY0-NEXT:    [[INC3:%.*]] = fadd float [[TMP9]], 1.000000e+00
// SIMD-ONLY0-NEXT:    store float [[INC3]], ptr [[ARRAYIDX]], align 4
// SIMD-ONLY0-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, ptr [[VLA]], i64 0
// SIMD-ONLY0-NEXT:    [[TMP10:%.*]] = load float, ptr [[ARRAYIDX4]], align 4
// SIMD-ONLY0-NEXT:    [[INC5:%.*]] = fadd float [[TMP10]], 1.000000e+00
// SIMD-ONLY0-NEXT:    store float [[INC5]], ptr [[ARRAYIDX4]], align 4
// SIMD-ONLY0-NEXT:    [[TMP11:%.*]] = load float, ptr [[A]], align 4
// SIMD-ONLY0-NEXT:    [[CONV6:%.*]] = fptosi float [[TMP11]] to i32
// SIMD-ONLY0-NEXT:    store i32 [[CONV6]], ptr [[RETVAL]], align 4
// SIMD-ONLY0-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[SAVED_STACK]], align 8
// SIMD-ONLY0-NEXT:    call void @llvm.stackrestore.p0(ptr [[TMP12]])
// SIMD-ONLY0-NEXT:    [[TMP13:%.*]] = load i32, ptr [[RETVAL]], align 4
// SIMD-ONLY0-NEXT:    ret i32 [[TMP13]]
//
//
// SIMD-ONLY0-LABEL: define linkonce_odr void @_ZN1SC1Ev(
// SIMD-ONLY0-SAME: ptr noundef nonnull align 8 dereferenceable(40) [[THIS:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] comdat {
// SIMD-ONLY0-NEXT:  [[ENTRY:.*:]]
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    call void @_ZN1SC2Ev(ptr noundef nonnull align 8 dereferenceable(40) [[THIS1]])
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY0-LABEL: define linkonce_odr void @_ZN1S3fooEv(
// SIMD-ONLY0-SAME: ptr noundef nonnull align 8 dereferenceable(40) [[THIS:%.*]]) #[[ATTR2]] comdat {
// SIMD-ONLY0-NEXT:  [[ENTRY:.*:]]
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[A:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[PTR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[REF:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[PTR5:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[ARR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[_TMP8:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[_TMP9:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[_TMP10:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY0-NEXT:    store ptr [[A2]], ptr [[A]], align 8
// SIMD-ONLY0-NEXT:    [[PTR3:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// SIMD-ONLY0-NEXT:    store ptr [[PTR3]], ptr [[PTR]], align 8
// SIMD-ONLY0-NEXT:    [[REF4:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 2
// SIMD-ONLY0-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[REF4]], align 8, !nonnull [[META2]], !align [[META3]]
// SIMD-ONLY0-NEXT:    store ptr [[TMP0]], ptr [[REF]], align 8
// SIMD-ONLY0-NEXT:    [[PTR6:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// SIMD-ONLY0-NEXT:    store ptr [[PTR6]], ptr [[PTR5]], align 8
// SIMD-ONLY0-NEXT:    [[ARR7:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 3
// SIMD-ONLY0-NEXT:    store ptr [[ARR7]], ptr [[ARR]], align 8
// SIMD-ONLY0-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A]], align 8, !nonnull [[META2]], !align [[META3]]
// SIMD-ONLY0-NEXT:    store ptr [[TMP1]], ptr [[TMP]], align 8
// SIMD-ONLY0-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[PTR5]], align 8, !nonnull [[META2]], !align [[META4:![0-9]+]]
// SIMD-ONLY0-NEXT:    store ptr [[TMP2]], ptr [[_TMP8]], align 8
// SIMD-ONLY0-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[REF]], align 8, !nonnull [[META2]], !align [[META3]]
// SIMD-ONLY0-NEXT:    store ptr [[TMP3]], ptr [[_TMP9]], align 8
// SIMD-ONLY0-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[ARR]], align 8, !nonnull [[META2]], !align [[META3]]
// SIMD-ONLY0-NEXT:    store ptr [[TMP4]], ptr [[_TMP10]], align 8
// SIMD-ONLY0-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP]], align 8, !nonnull [[META2]], !align [[META3]]
// SIMD-ONLY0-NEXT:    [[TMP6:%.*]] = load i32, ptr [[TMP5]], align 4
// SIMD-ONLY0-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP6]], 1
// SIMD-ONLY0-NEXT:    store i32 [[INC]], ptr [[TMP5]], align 4
// SIMD-ONLY0-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[_TMP8]], align 8, !nonnull [[META2]], !align [[META4]]
// SIMD-ONLY0-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[TMP7]], align 8
// SIMD-ONLY0-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP8]], align 4
// SIMD-ONLY0-NEXT:    [[INC11:%.*]] = add nsw i32 [[TMP9]], 1
// SIMD-ONLY0-NEXT:    store i32 [[INC11]], ptr [[TMP8]], align 4
// SIMD-ONLY0-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[_TMP9]], align 8, !nonnull [[META2]], !align [[META3]]
// SIMD-ONLY0-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP10]], align 4
// SIMD-ONLY0-NEXT:    [[INC12:%.*]] = add nsw i32 [[TMP11]], 1
// SIMD-ONLY0-NEXT:    store i32 [[INC12]], ptr [[TMP10]], align 4
// SIMD-ONLY0-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[_TMP10]], align 8, !nonnull [[META2]], !align [[META3]]
// SIMD-ONLY0-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [4 x i32], ptr [[TMP12]], i64 0, i64 0
// SIMD-ONLY0-NEXT:    [[TMP13:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// SIMD-ONLY0-NEXT:    [[INC13:%.*]] = add nsw i32 [[TMP13]], 1
// SIMD-ONLY0-NEXT:    store i32 [[INC13]], ptr [[ARRAYIDX]], align 4
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY0-LABEL: define linkonce_odr void @_ZN1SC2Ev(
// SIMD-ONLY0-SAME: ptr noundef nonnull align 8 dereferenceable(40) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat {
// SIMD-ONLY0-NEXT:  [[ENTRY:.*:]]
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY0-NEXT:    store i32 0, ptr [[A]], align 8
// SIMD-ONLY0-NEXT:    [[PTR:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// SIMD-ONLY0-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY0-NEXT:    store ptr [[A2]], ptr [[PTR]], align 8
// SIMD-ONLY0-NEXT:    [[REF:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 2
// SIMD-ONLY0-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY0-NEXT:    store ptr [[A3]], ptr [[REF]], align 8
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY0-OMP60-LABEL: define dso_local noundef signext i32 @main(
// SIMD-ONLY0-OMP60-SAME: i32 noundef signext [[ARGC:%.*]], ptr noundef [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// SIMD-ONLY0-OMP60-NEXT:  [[ENTRY:.*:]]
// SIMD-ONLY0-OMP60-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// SIMD-ONLY0-OMP60-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// SIMD-ONLY0-OMP60-NEXT:    [[ARGV_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-OMP60-NEXT:    [[A:%.*]] = alloca float, align 4
// SIMD-ONLY0-OMP60-NEXT:    [[PTR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-OMP60-NEXT:    [[REF:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-OMP60-NEXT:    [[ARR:%.*]] = alloca [4 x float], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[SAVED_STACK:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-OMP60-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// SIMD-ONLY0-OMP60-NEXT:    [[S:%.*]] = alloca [[STRUCT_S:%.*]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-OMP60-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// SIMD-ONLY0-OMP60-NEXT:    store i32 [[ARGC]], ptr [[ARGC_ADDR]], align 4
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[ARGV]], ptr [[ARGV_ADDR]], align 8
// SIMD-ONLY0-OMP60-NEXT:    store float 0.000000e+00, ptr [[A]], align 4
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[A]], ptr [[PTR]], align 8
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[A]], ptr [[REF]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[TMP0:%.*]] = load float, ptr [[A]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[CONV:%.*]] = fptosi float [[TMP0]] to i32
// SIMD-ONLY0-OMP60-NEXT:    [[TMP1:%.*]] = zext i32 [[CONV]] to i64
// SIMD-ONLY0-OMP60-NEXT:    [[TMP2:%.*]] = call ptr @llvm.stacksave.p0()
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[TMP2]], ptr [[SAVED_STACK]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[VLA:%.*]] = alloca float, i64 [[TMP1]], align 4
// SIMD-ONLY0-OMP60-NEXT:    store i64 [[TMP1]], ptr [[__VLA_EXPR0]], align 8
// SIMD-ONLY0-OMP60-NEXT:    call void @_ZN1SC1Ev(ptr noundef nonnull align 8 dereferenceable(40) [[S]])
// SIMD-ONLY0-OMP60-NEXT:    call void @_ZN1S3fooEv(ptr noundef nonnull align 8 dereferenceable(40) [[S]])
// SIMD-ONLY0-OMP60-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[REF]], align 8, !nonnull [[META2:![0-9]+]], !align [[META3:![0-9]+]]
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[TMP3]], ptr [[TMP]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[TMP4:%.*]] = load float, ptr [[A]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[INC:%.*]] = fadd float [[TMP4]], 1.000000e+00
// SIMD-ONLY0-OMP60-NEXT:    store float [[INC]], ptr [[A]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[PTR]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[TMP6:%.*]] = load float, ptr [[TMP5]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[INC1:%.*]] = fadd float [[TMP6]], 1.000000e+00
// SIMD-ONLY0-OMP60-NEXT:    store float [[INC1]], ptr [[TMP5]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP]], align 8, !nonnull [[META2]], !align [[META3]]
// SIMD-ONLY0-OMP60-NEXT:    [[TMP8:%.*]] = load float, ptr [[TMP7]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[INC2:%.*]] = fadd float [[TMP8]], 1.000000e+00
// SIMD-ONLY0-OMP60-NEXT:    store float [[INC2]], ptr [[TMP7]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [4 x float], ptr [[ARR]], i64 0, i64 0
// SIMD-ONLY0-OMP60-NEXT:    [[TMP9:%.*]] = load float, ptr [[ARRAYIDX]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[INC3:%.*]] = fadd float [[TMP9]], 1.000000e+00
// SIMD-ONLY0-OMP60-NEXT:    store float [[INC3]], ptr [[ARRAYIDX]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, ptr [[VLA]], i64 0
// SIMD-ONLY0-OMP60-NEXT:    [[TMP10:%.*]] = load float, ptr [[ARRAYIDX4]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[INC5:%.*]] = fadd float [[TMP10]], 1.000000e+00
// SIMD-ONLY0-OMP60-NEXT:    store float [[INC5]], ptr [[ARRAYIDX4]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[TMP11:%.*]] = load float, ptr [[A]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[CONV6:%.*]] = fptosi float [[TMP11]] to i32
// SIMD-ONLY0-OMP60-NEXT:    store i32 [[CONV6]], ptr [[RETVAL]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[SAVED_STACK]], align 8
// SIMD-ONLY0-OMP60-NEXT:    call void @llvm.stackrestore.p0(ptr [[TMP12]])
// SIMD-ONLY0-OMP60-NEXT:    [[TMP13:%.*]] = load i32, ptr [[RETVAL]], align 4
// SIMD-ONLY0-OMP60-NEXT:    ret i32 [[TMP13]]
//
//
// SIMD-ONLY0-OMP60-LABEL: define linkonce_odr void @_ZN1SC1Ev(
// SIMD-ONLY0-OMP60-SAME: ptr noundef nonnull align 8 dereferenceable(40) [[THIS:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] comdat {
// SIMD-ONLY0-OMP60-NEXT:  [[ENTRY:.*:]]
// SIMD-ONLY0-OMP60-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-OMP60-NEXT:    call void @_ZN1SC2Ev(ptr noundef nonnull align 8 dereferenceable(40) [[THIS1]])
// SIMD-ONLY0-OMP60-NEXT:    ret void
//
//
// SIMD-ONLY0-OMP60-LABEL: define linkonce_odr void @_ZN1S3fooEv(
// SIMD-ONLY0-OMP60-SAME: ptr noundef nonnull align 8 dereferenceable(40) [[THIS:%.*]]) #[[ATTR2]] comdat {
// SIMD-ONLY0-OMP60-NEXT:  [[ENTRY:.*:]]
// SIMD-ONLY0-OMP60-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-OMP60-NEXT:    [[A:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-OMP60-NEXT:    [[PTR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-OMP60-NEXT:    [[REF:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-OMP60-NEXT:    [[PTR5:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-OMP60-NEXT:    [[ARR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-OMP60-NEXT:    [[PTR8:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-OMP60-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-OMP60-NEXT:    [[_TMP10:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-OMP60-NEXT:    [[_TMP11:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-OMP60-NEXT:    [[_TMP12:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[A2]], ptr [[A]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[PTR3:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[PTR3]], ptr [[PTR]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[REF4:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 2
// SIMD-ONLY0-OMP60-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[REF4]], align 8, !nonnull [[META2]], !align [[META3]]
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[TMP0]], ptr [[REF]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[PTR6:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[PTR6]], ptr [[PTR5]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[ARR7:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 3
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[ARR7]], ptr [[ARR]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[PTR9:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[PTR9]], ptr [[PTR8]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A]], align 8, !nonnull [[META2]], !align [[META3]]
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[TMP1]], ptr [[TMP]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[PTR8]], align 8, !nonnull [[META2]], !align [[META4:![0-9]+]]
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[TMP2]], ptr [[_TMP10]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[REF]], align 8, !nonnull [[META2]], !align [[META3]]
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[TMP3]], ptr [[_TMP11]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[ARR]], align 8, !nonnull [[META2]], !align [[META3]]
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[TMP4]], ptr [[_TMP12]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP]], align 8, !nonnull [[META2]], !align [[META3]]
// SIMD-ONLY0-OMP60-NEXT:    [[TMP6:%.*]] = load i32, ptr [[TMP5]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP6]], 1
// SIMD-ONLY0-OMP60-NEXT:    store i32 [[INC]], ptr [[TMP5]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[_TMP10]], align 8, !nonnull [[META2]], !align [[META4]]
// SIMD-ONLY0-OMP60-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[TMP7]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP8]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[INC13:%.*]] = add nsw i32 [[TMP9]], 1
// SIMD-ONLY0-OMP60-NEXT:    store i32 [[INC13]], ptr [[TMP8]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[_TMP11]], align 8, !nonnull [[META2]], !align [[META3]]
// SIMD-ONLY0-OMP60-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP10]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[INC14:%.*]] = add nsw i32 [[TMP11]], 1
// SIMD-ONLY0-OMP60-NEXT:    store i32 [[INC14]], ptr [[TMP10]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[_TMP12]], align 8, !nonnull [[META2]], !align [[META3]]
// SIMD-ONLY0-OMP60-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [4 x i32], ptr [[TMP12]], i64 0, i64 0
// SIMD-ONLY0-OMP60-NEXT:    [[TMP13:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// SIMD-ONLY0-OMP60-NEXT:    [[INC15:%.*]] = add nsw i32 [[TMP13]], 1
// SIMD-ONLY0-OMP60-NEXT:    store i32 [[INC15]], ptr [[ARRAYIDX]], align 4
// SIMD-ONLY0-OMP60-NEXT:    ret void
//
//
// SIMD-ONLY0-OMP60-LABEL: define linkonce_odr void @_ZN1SC2Ev(
// SIMD-ONLY0-OMP60-SAME: ptr noundef nonnull align 8 dereferenceable(40) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat {
// SIMD-ONLY0-OMP60-NEXT:  [[ENTRY:.*:]]
// SIMD-ONLY0-OMP60-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY0-OMP60-NEXT:    store i32 0, ptr [[A]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[PTR:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 1
// SIMD-ONLY0-OMP60-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[A2]], ptr [[PTR]], align 8
// SIMD-ONLY0-OMP60-NEXT:    [[REF:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 2
// SIMD-ONLY0-OMP60-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY0-OMP60-NEXT:    store ptr [[A3]], ptr [[REF]], align 8
// SIMD-ONLY0-OMP60-NEXT:    ret void
//
//.
// CHECK: [[META3]] = !{}
// CHECK: [[META4]] = !{i64 4}
// CHECK: [[META5]] = !{i64 8}
//.
// OMP60: [[META3]] = !{}
// OMP60: [[META4]] = !{i64 4}
// OMP60: [[META5]] = !{i64 8}
//.
// SIMD-ONLY0: [[META2]] = !{}
// SIMD-ONLY0: [[META3]] = !{i64 4}
// SIMD-ONLY0: [[META4]] = !{i64 8}
//.
// SIMD-ONLY0-OMP60: [[META2]] = !{}
// SIMD-ONLY0-OMP60: [[META3]] = !{i64 4}
// SIMD-ONLY0-OMP60: [[META4]] = !{i64 8}
//.
