// Copyright (c) Microsoft Corporation.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception


// Copyright 2018 Ulf Adams
// Copyright (c) Microsoft Corporation. All rights reserved.

// Boost Software License - Version 1.0 - August 17th, 2003

// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:

// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.


// This file contains test cases derived from:
// https://github.com/ulfjack/ryu
// See xcharconv_ryu.h for the exact commit.
// (Keep the cgmanifest.json commitHash in sync.)


#ifndef DOUBLE_FIXED_PRECISION_TO_CHARS_TEST_CASES_2_HPP
#define DOUBLE_FIXED_PRECISION_TO_CHARS_TEST_CASES_2_HPP

#include <charconv>

#include "test.hpp"
using namespace std;

inline constexpr DoublePrecisionToCharsTestCase double_fixed_precision_to_chars_test_cases_2[] = {
    // Ryu Printf d2fixed_test.cc D2fixedTest AllPowersOfTen
    // These values test every power of ten that's within the range of doubles.
    {1e-323, chars_format::fixed, 1073,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000098813129168249308835313758573644274473011960522864952885117136500135101454041750373059967272327198475"
        "9593129390891435461853313420711879592797549592021563756252601426380622809055691634335697964207377437272113"
        "9974614461000127748183071299687746249467945463392302800634307707961482524771311823420533171133735363740791"
        "2062124986389054318298491065861091308880225496025941999908386397881816083312664904951429573802945356031871"
        "0477223100269607052986944038758053621421498340666445368950667144166486387218476578691673612021202301233961"
        "9506156684554636658495809965049461552751854495749312169556407468939399067294035945355435170251321102398263"
        "0097822029020757254763345019116747794671979873296198823284114052741805584855350891304581750773650128394365"
        "3106689453125"},
    {1e-322, chars_format::fixed, 1072,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000988131291682493088353137585736442744730119605228649528851171365001351014540417503730599672723271984759"
        "5931293908914354618533134207118795927975495920215637562526014263806228090556916343356979642073774372721139"
        "9746144610001277481830712996877462494679454633923028006343077079614825247713118234205331711337353637407912"
        "0621249863890543182984910658610913088802254960259419999083863978818160833126649049514295738029453560318710"
        "4772231002696070529869440387580536214214983406664453689506671441664863872184765786916736120212023012339619"
        "5061566845546366584958099650494615527518544957493121695564074689393990672940359453554351702513211023982630"
        "0978220290207572547633450191167477946719798732961988232841140527418055848553508913045817507736501283943653"
        "106689453125"},
    {1e-321, chars_format::fixed, 1073,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0009980126045993180192366689615938071721774208012809360241396830786513645246858216787679056694505047046071"
        "8906068480034981647184655491899838872552508794177939381512744064442903714624855067905494384945121164483513"
        "7436060561012902566490201268462371196262491802622582864065078504109735001902494165473850284507271737819911"
        "8274623625294486148147597651970222196902775098620141990747026186063424414579155400094386954097480959218975"
        "8199533127230312351681347914563415763571332407310982264017381560815125109066134447859034814141432424630157"
        "0121825140018302508076806469995616827937304070680529125197154362879305796697630480898952195383431342224563"
        "9880024931096482731097846930791527261869967202916081151695519326922364070390440021762756828138662967830896"
        "3775634765625"},
    {1e-320, chars_format::fixed, 1071,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0099998886718268300541337523676528005766688104049139332319738542138136722671490251377536686879595124857670"
        "8246943582132687395553181760422147911120187125822521327632643497190282764359933947726339777865966519379365"
        "4309834532129281161268155283999204461560808953010434241919400457020315068567565301579569187340188105680700"
        "6870486225722970118072958651424404586788201978253303907287034656397876312416883810846728688580700304253500"
        "2949777472842337622787367223150264878556320754442713378075149896484223865098297635973695365456728848769494"
        "0230564769292298397759684630055091384876749698303915591084358566671856101564376699700392294336955627042165"
        "8995893369006341820505159346148768208043631775753209163523421374707251873615102000236731782933929935097694"
        "39697265625"},
    {1e-319, chars_format::fixed, 1070,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0999988867182683005413375236765280057666881040491393323197385421381367226714902513775366868795951248576708"
        "2469435821326873955531817604221479111201871258225213276326434971902827643599339477263397778659665193793654"
        "3098345321292811612681552839992044615608089530104342419194004570203150685675653015795691873401881056807006"
        "8704862257229701180729586514244045867882019782533039072870346563978763124168838108467286885807003042535002"
        "9497774728423376227873672231502648785563207544427133780751498964842238650982976359736953654567288487694940"
        "2305647692922983977596846300550913848767496983039155910843585666718561015643766997003922943369556270421658"
        "9958933690063418205051593461487682080436317757532091635234213747072518736151020002367317829339299350976943"
        "9697265625"},
    {1e-318, chars_format::fixed, 1073,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "9999987484955998303442587681411374220943283416874456096926739330950172402250479179504041747926784812965558"
        "4287487604160175017171489462926670704816262174273696519516951145408899245049086406969675750804029375208657"
        "0958067673928243874998599699608192405548840764435726992574353409992989381527841981377451905152545931810859"
        "9110747558686066125594356208301549987700423321356332728611852037669447325001045989624298431872975781381900"
        "5454970384503369331723666353784541477053573784937783176465656792588872897048240176061210157694087178183364"
        "2562633613784476434464272970558600040426824326140871277992264136125009223731705915394664603946883806614852"
        "9687158929654939305279279633993568599035157448617115175626251523466992946365550914977760044166643638163805"
        "0079345703125"},
    {1e-317, chars_format::fixed, 1074,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010"
        "0000023069253735408389129784751602675844543686685345266696720985206474225156972857665977069218756620453298"
        "2264570127938903364494864760334526437358946130769310829548413593659926664074401521200304454351359907994741"
        "9542598430782630372260603945613543429690325839445724126694995661872117602435387548905318808226062363719785"
        "9200663066444242733391298681807136840324571457602240285981099973517197374979457253670128679434175847866812"
        "0265538495438103896717079595982495202667985360377499818082568642138458551310116628649611994972675233684585"
        "4885571164676719332386444653160192733396025005032681034257252564659190838258113071979798794845819719745924"
        "2018322340080528934937813868610807682359544296115449991188686313782637840938535486734473067826911574229598"
        "04534912109375"},
    {1e-316, chars_format::fixed, 1074,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000099"
        "9999983659714433460619209563119592647759254336952145504584997059223491913816093472283838042269385386536792"
        "3662877802160444990315364051565565391595587327639198904852632370647709618104786126163799632995155486767134"
        "5489448155325984352148361206916068673233394735976484265364187348817469712425595930501855154426285227845881"
        "1851318198469791538166759153418640131045150835957547860040033740467433541512910274322712859834395088588442"
        "6462327203707021334703435862929817973126107752108884758449018560968369545054974839766935919673746583760950"
        "0090319935380601677624921618978273452080613810953529918681506974243410714346040856409400022829894441463584"
        "4938668328253396212469776138316207336915493277914002853676578005971864447246977639083276301334990421310067"
        "17681884765625"},
    {1e-315, chars_format::fixed, 1074,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000999"
        "9999984816838086980155348601833786944004252887462239343279298267939669340813115785463940012644762356165637"
        "6018472107941603095933610646723473305152197664424334682905225846048030394631398713141543276262621023579516"
        "4856403244760035143758219018692306106535865554853296854593335050116920911412927040149351300963455324069998"
        "6606369464281496859115328132978038273771846603614391600262917001497059540098100100654272959048368919932233"
        "0339106687474623926514774687435260163393325032088515637916186325933425031377463265706869614769269289460443"
        "0162434380637971763992931137356926849933919853159267441149680945843205744401462482127152983675926068233239"
        "4533416326065098006842778911837195061162902589084326771691951138831352849752802727789635639510379405692219"
        "73419189453125"},
    {1e-314, chars_format::fixed, 1074,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009999"
        "9999996388074622175516738988975729906454238392563177730222310355101443610783338917264959716398532052454089"
        "9574415165753184152116076598302552440718301032275692463431160600051238159897524582918979708937276391703335"
        "8525954139100543059856797136454680439560573743621422746884812063111432901286238136624312766335156286311173"
        "4156882122398550068601017928572019701038804280182829002491749611793319525949998363969873951188107233370136"
        "9106901525150649844628162932489682066065497831884824432587863975583979894602347525106206565724496346455373"
        "0883578833211672627673026321143460828466980275216642665831420661841156044955678739304682592136242335929789"
        "0480896304182115950572806647047072303636995700787565951845682467426236874811053614853229021264269249513745"
        "30792236328125"},
    {1e-313, chars_format::fixed, 1074,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000"
        "0000013287310805879821807546636585886679620431612038734699546109582686175384116193524783693968956688140137"
        "5540716352977559252087422693381464203581785118767706512437906713702693003503091646357646071476452635669415"
        "5246848621505494472659507014390677520339710167910378869165274485095070275248037277953394248918430544982129"
        "7599883717180027845159424818650742664828155549841261024871689316874103301156316092174454298782545011717304"
        "6307626801641301972775101344275847471365727489181467010353973327923042139632713540407902463255564615170711"
        "8588866674394044605978168193959339061045730000041082743092410352881259983203805365724543506488083910497021"
        "9857874056331538133109738980029096933705946944523758930098881700633271540538211594184581088029517559334635"
        "73455810546875"},
    {1e-312, chars_format::fixed, 1074,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000999999"
        "9999984653414306424254822495727998400384494798179603049566133420122111551188980872622277349738658390603661"
        "6017469443438439328094256802746822646621526799644719490000164997455995821447379012072913768453460200785984"
        "2506564523554753104320463194375155829195183484015334490701283289008478965323405044403142732483702404210110"
        "7905649692216696974146511587715789684961217254373697248854313571918308886594163564317398627121032083125239"
        "7360433366008609148270597384621394281525027380815002050113732562980691815499420536041514214523842699856175"
        "6629431717108491072037966992019198281329518256786859176589492325403501231096999739212282309503857451372825"
        "3432007519784245448952372271615847645051499635293291066062645927220007028099089604888938254134700400754809"
        "37957763671875"},
    {1e-311, chars_format::fixed, 1074,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009999999"
        "9999994753836816616511477927917844470256657499736814793090661876925865714541989788848333087337492396834329"
        "9564388520721546473722538158536045855411592384479540534380552114130892428057327572232684630845668163768013"
        "5027566927047722665479238893283177666153753035241799107964294452027013440391018179162227081537627087712294"
        "7149684401750551218912852475949533812932510787775885488405715316005812990910633000601130631914738865300203"
        "9320168310490502062186389904351023247382521319149688554563326346056647735821920228452652563270230450412699"
        "5553552197916865708123384867766175142422964311492560020229534457444110911911051310155975850415556167325647"
        "9466808241373590371668740244833598142522966162877208895552630351312778658273922385846255167507479200139641"
        "76177978515625"},
    {1e-310, chars_format::fixed, 1074,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000099999999"
        "9999996944932750289769196936057731524703811503348409363383061327826907212970624909358517403358560131942537"
        "5440449902661182468152038295716398350514698640806187221931821854499235685101121539494695290560370356316192"
        "0262976500977290528883924582675649786271503084114142479960098374250875666295837703332537400943138558993342"
        "7527906510700039348277770292425883783765220625771825884011346358999037950762662458487021106048861331017974"
        "8440294655039824148357371062889259284535962361830108230108597032649720551828440573872362438712905654743976"
        "5288600321445975410481753660186482200605570362800256287073548308910808652757531074237476089281222224455610"
        "9716993428246282344069074957894355322565651565420188367168360539498689375166899304114842550461617065593600"
        "27313232421875"},
    {1e-309, chars_format::fixed, 1074,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000"
        "0000018855892087022346387017456602069175351539464355066307055836837322197256976114460360563569237483024613"
        "4201063722057542412447039667519923301545761204072654097444519258182668255539061212114801887707392281797977"
        "2617072240272969162930781476600370987449003572837576199918137596489497925344032945035640594998253271803823"
        "1310127600194920641926948457189383492092319005731229840067656788931287549282957037345925847390085988195683"
        "9641558100533045010067182648271619656070372788634304985561303898580448711893644028069461193139657698056746"
        "2639081556737072434065441584389552782431630875877218955513686823577786061222328715052478477937882795755241"
        "2218845296973202068072422088501927122992505590849983083325662421357796544096668486800716380002995720133185"
        "38665771484375"},
    {1e-308, chars_format::fixed, 1073,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009999999999"
        "9999990932662533724846199547048873403204569370722504933164788134100221702366853061102859515757830175849182"
        "2824378438792553200763769833775473829862512856683413461939989729065436937279228852476622948659167943435544"
        "6221493480729436132941672166628217375554144801591156397912760548972014203897705803515339607715061990556648"
        "8977026029171097782672502440171652303162739065260414400859795093549243326204240563556399326294969169893097"
        "5461134804791235994697938405200089317860731205010159117711704697471514344499487123311264707354172378099538"
        "7378502198261451023662795913796604718812599767273565216024053297899062477635215259813914438876185752755886"
        "1992808911690506171197530846785775640581096161907433186688396108094354271255983085398000298482656944543123"
        "2452392578125"},
    {1e-307, chars_format::fixed, 1072,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000099999999999"
        "9999909326625337248461995470488734032045693707225049331647881341002217023668530611028595157578301758491822"
        "8243784387925532007637698337754738298625128566834134619399897290654369372792288524766229486591679434355446"
        "2214934807294361329416721666282173755541448015911563979127605489720142038977058035153396077150619905566488"
        "9770260291710977826725024401716523031627390652604144008597950935492433262042405635563993262949691698930975"
        "4611348047912359946979384052000893178607312050101591177117046974715143444994871233112647073541723780995387"
        "3785021982614510236627959137966047188125997672735652160240532978990624776352152598139144388761857527558861"
        "9928089116905061711975308467857756405810961619074331866883961080943542712559830853980002984826569445431232"
        "452392578125"},
    {1e-306, chars_format::fixed, 1069,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000"
        "0000279023803391476325978469990224051750613215776767695913434815660171857902754611290428295390285511299939"
        "7555396569952545618616744426089938099821880772600111269030190023111167436591184859690670436405323590819830"
        "1844721604945146272364072259074692549029825719823273398887747392739210687026322232580358825111023420554384"
        "2448102753778430086832136807498326022836612478352744084880146129506125620176035215057087515132261261692207"
        "1840157682358884105637168985105575243131100589013256198578475477149271096570431275426554079671665424761417"
        "1924100040800742268229310960254010514282230676348267637082219417179036571049957325656665930634428504367776"
        "0454755517299704176913224907978537594173374670297704548248979442337094143862519235455010857549495995044708"
        "251953125"},
    {1e-305, chars_format::fixed, 1066,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009999999999999"
        "9999628217900530785377054659627883900722995775030945280642024408233714255781016776892345034950140642648166"
        "8573825190999521406861414798119234028697220781311072490218654586931744476129716298164369509417157915490653"
        "9259553297447374781782441000739045507324002369679044368579627272624666077581243976346526774830702565838523"
        "8493027973334562682769653967428338344198908910697296851733096562843141535755075192125128789628361223902198"
        "3130437614961415360789480610798036545823058988806310179363406158165146574713062236131985212038180608127389"
        "5043986502259049610427190720957335454762962899504686945017155165729595557090423005192733858302009766933344"
        "1417250244332809616705208468049446512230390757498683137398144735633162723253963832803492550738155841827392"
        "578125"},
    {1e-304, chars_format::fixed, 1062,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000099999999999999"
        "9970986017938236030708706274083986072964866688415599378481654095393107971837933080827946997879690663671822"
        "9897127841787735834165912278951164530799512255590403301520580715878005643040104591705016257082955213245355"
        "9094230958441044282958157287327415209445985068360926723413499488107134434356612967808775938070772540742689"
        "7026283217747721343282826813844008368651362124331816540784047770686498029508536253685317002729601094862994"
        "9135262480594748043237132185918638374327014677453087342263272675030950619200618216251407442954016965379635"
        "6863753776603511529344556156911197043154878083222954043731239608809794343631028040935934998681895455378110"
        "9130063014014238947635759786607029686277060011159932613248249854429397509569810154061997309327125549316406"
        "25"},
    {1e-303, chars_format::fixed, 1059,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000999999999999999"
        "9305121602309211138097617585722213781407209893854338937799101162826526342823575798751416352849454431760700"
        "5513293326557706590487351553652833209231993635578887404550364703749030538288111678031301177411569065874625"
        "4921477327887186271721529352265514273755232628736995836010623070838922880272900947583890416927675525146116"
        "3798887927910725682208862371410082513109989521059733783089791982946303046409911855797635730431832642086137"
        "6646806101636991397848539106198750400812943404770642200700104244381264145126115841418959590695543799488207"
        "1419757830243362094607944726517450359952766243046893934267403312319363799939048233496892637407719130495821"
        "06215992711206739656963995638713298863410390903689459607513385138582995281808507570531219244003295898437"
        "5"},
    {1e-302, chars_format::fixed, 1054,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009999999999999999"
        "6289124639677304732891737098163313400003754860956628154130529957101690432681798063738592536074161957267240"
        "2796813996134279914247685423398828882424967718390038930747186677738512519784590692463902921459555191377723"
        "7381431331057915180095641690724245303189270726348129545101205190248600509074839319869855879517154309707408"
        "9700433275639158827043869850340834518328948988664790828903405620812448453502724006420631679231752873211868"
        "4114610650853826254667653085888570747787061005788271782462022491238577826301688982950514617712444829347269"
        "1939817788767646536780382005930664172295779143930111367033975329422275090360339741868585169367074691240515"
        "1648239663380463742253582056305034674846879073532500981362665382068399821946513839066028594970703125"},
    {1e-301, chars_format::fixed, 1052,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000006"
        "6504322127499234590215330691750752749850538126789922377769886093782568469091263076567653603289384041799915"
        "3212323339173647442450290613844186107610680787137665635265135265327753578757072113467545929599216957984239"
        "5147370980532830613127558285453735132274929310782773370851235321985899693814948207689013522864312960953935"
        "1774060645412452429006574863088645574619210784806404225209601531305860195942614414423096789547175207334420"
        "5835694812023455384508915623719843146914672716501910639371586430015742264313868029854544921348666996359020"
        "7149841450365284270233731763503780051537526270058618449857903893539137814638834439474933142947015273438897"
        "03142991033638081518025859259858927144364121703023337768036216122169435038813389837741851806640625"},
    {1e-300, chars_format::fixed, 1049,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000025"
        "0590918352087596856961468077037052499253423199004660431840514846763028121819501008949623062702782541489103"
        "1146499880413081224609160619018271942662793458427551041478278701507022263926060379361392435977509403014386"
        "6141479125513590882591017341692222921220404918621822029155619541859418525883262040928316317872050154019969"
        "8661694898041067655794243192165254180873224255430058507393834020333099315764646743363847906553166172481259"
        "9598594906293782493759617177861888792970476530542335134710418229637566637950767497147854236589795152044892"
        "0491760252897567092617670818249247201056323377556165380506436538125830502246596311593005632365079290253988"
        "78153811554013986009587978081167432804936359631140419153283449560376539011485874652862548828125"},
    {1e-299, chars_format::fixed, 1046,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000009999999999999999919"
        "0290760137637976208079970046606724998518567438890097551538379739129028665449972035680926865499362402810630"
        "3651130713543666646941642034794006359075819280682667925398195400906114450103317751101389479657812615519797"
        "8756945816618186836433649314161201999972943672570926856702325994597557960702860121588611892551865896044643"
        "3985656531743023483770388411882929286181173813228715116320889861526972008354488226701519154182974517909032"
        "5919123351411654126959859303926546520294760229609181275060613732216818338004372560297782550722953028086399"
        "6864368522933466048419533648184045496011719191321500860483546203133923869331978450679449946810205349460035"
        "55329325281205226730514864672299618939724737118660523316204802313222899101674556732177734375"},
    {1e-298, chars_format::fixed, 1042,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000099999999999999991232"
        "8065440178667945403966643095736050128809725161144813110581347907260225388618807065241978378310511738176684"
        "8978472961345172089817280618610949969507425520598459508751755269122547961258312490713057673763372204220340"
        "3781167641756540616899914675347366906182904398174226130530393770056524451914354311216888057471403500725107"
        "6705546549406561057574839884358592320586088346562272180390090411973212500537381300528153669461252213404717"
        "7587416437488441814327093646649271377107480476551731021560491782355830383964467734639589943029566464163497"
        "5366069084321743418023147658438218610880841891451337934895801756354091018104152540779946423927952220683901"
        "2428228659762106653639065937800317076591475056075719596293538415920920670032501220703125"},
    {1e-297, chars_format::fixed, 1039,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000039647"
        "8128980950068520868995348882659698990112439255546729582652670817083234140282683317496428210034914020640749"
        "0310076398915630971759041855375317635086531785636111011200732530243024248980965231943970702669785257845617"
        "8424324808370650127984402213708118558573561222302940289189796515270127000971493586876574463470122362792297"
        "7471765782444391057813106595117131865471280037220785529001835372476246333493828469074142652508409585016908"
        "1535237600934009427614926748351814984516753878158617880335246460555951776912803239807668457495085708842964"
        "6102549163424107238986497758817967696590019262732110067992581963303272984491636864032312946065142589502281"
        "0699832540710987766403439129992000576046943562114055481515606516040861606597900390625"},
    {1e-296, chars_format::fixed, 1035,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000056958"
        "8024265064981030478409707692465796029083892171204366554955530185549727391907866068093230295203015836077090"
        "1699839227919216188027123435710995177499246977290400982185512398383456792748744786603989786601684003410274"
        "2609519041559184055883340909789320261083566248200925601535674980154916724840401269545227598018324013146388"
        "0274190388767162625958511947088095562418409514613018689749203717444806459951576787294477304028395980916466"
        "6922847406541184184565293398560546609322341147876025030738254906899123269746363348978633835752400909208341"
        "4513869447023277566518254456350926065149258365404485429166981233666429035716071423702199575889771541254094"
        "321820289220342105066697862794979293345025428418892943227547220885753631591796875"},
    {1e-295, chars_format::fixed, 1032,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000006001897"
        "2491361621077156168797575070757062243486927860250533894694149620019098093782134390869131834368148286057303"
        "9413188458985658353283956245784850548849603838035355899004130448583139080461968391411373707555537234837209"
        "2234855089948916142204308734563047805268398079264892661153392562290819806396566282980548567109633967889311"
        "3837382858499593494345983536212525100894348867647572501798437291530574599303094328095960577175157717206504"
        "4100931710194403310996519344927117866746573618122710669209904247557544687570338275355150184699307959624288"
        "9324649465717492838730114672769275063507531844710698303811226726525103304365469702956873915084185072840405"
        "266398916053751632054838903102133456680944423311530044884420931339263916015625"},
    {1e-294, chars_format::fixed, 1029,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000016560498"
        "6923928440636750610371765538777806813685229416850392185830714084016387540193554229196687284977563458281821"
        "4813515151508611748737787348449315297638965859302790372849252767842821580823519711141930343245794742496359"
        "3231233504632556755075890252271716497222096014603833445160783536974977600025234129579304975685188987489664"
        "9609996818372197065372922839472695195261458904336640183533171978645665994732331639750105476621993907730344"
        "2029655943683541387216510574697964479280439066327423797480201047044950954849744469001007229590688655915893"
        "9758854693297190998920585853612635338955732921780230940980952146364529466016653302089713901350093446008356"
        "278420969734871669445506829802610380963923120134495547972619533538818359375"},
    {1e-293, chars_format::fixed, 1022,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000513272777"
        "3156786567445994724549536738120593106324687653743495947193397769560622582957859727923921319406989801147958"
        "2682107021869891760192074359686674503246238761434052666028941422336769598604510735193757290934568271969456"
        "5250874205178404886496479269587257415916038370399079782592972057215539711775770897602495320141095406124240"
        "6210622316711873678424528575947398462070827220479080510941327279737299933712209527177057127256605191981041"
        "2133848702919347654154568743565358298286767582471701131752741898693476915326550966414029235126014081774902"
        "5489666643993809096250345528767275758514013420416326186860042414737323281270882840729341009434992719249133"
        "86875522376987390327812590777589729640340010519139468669891357421875"},
    {1e-292, chars_format::fixed, 1021,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000005132727773"
        "1567865674459947245495367381205931063246876537434959471933977695606225829578597279239213194069898011479582"
        "6821070218698917601920743596866745032462387614340526660289414223367695986045107351937572909345682719694565"
        "2508742051784048864964792695872574159160383703990797825929720572155397117757708976024953201410954061242406"
        "2106223167118736784245285759473984620708272204790805109413272797372999337122095271770571272566051919810412"
        "1338487029193476541545687435653582982867675824717011317527418986934769153265509664140292351260140817749025"
        "4896666439938090962503455287672757585140134204163261868600424147373232812708828407293410094349927192491338"
        "6875522376987390327812590777589729640340010519139468669891357421875"},
    {1e-291, chars_format::fixed, 1019,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000999999999999999962324323391"
        "2798103508506385521992048124372918447536033153018627964458003030494979954072709187387723715072044222381502"
        "4190092450342962178772011919125939449339353031431138593572223793087189525906785833115541323441890363444649"
        "2821395851514130700828279759982076005663811603557173527102213730318461027579111697031467812072924618160763"
        "2734773625772193520456011202305539786285748707062310138073209693886156855664311520649108300273993840638730"
        "3038818174447717226154347230593172425188266932619544995886944238892045624403889881989947072504762387803780"
        "6280018377774738221645882760651449398490186172444323761070877994173001124374730195890389984380357578527189"
        "23186761317114486910984268164259702871277113445103168487548828125"},
    {1e-290, chars_format::fixed, 1015,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000691278685996"
        "2547673918180898415459989495965890694553118186157880703161317411757139641286255133930135858243672932786917"
        "0148241343184187872945207785757524996807807658000922047585259217949139273599310566277666474598145636458531"
        "5406254511057602394118563984744747087918421271781392057362041198010732075766853728931448545168638112767218"
        "7277232802704027068522268732267074912421167160771992853446316296987606743322809571170336107378242695971995"
        "4540807154321750533173797817243613093744565100802268111516389954388207143053379932855188006207373354275497"
        "5039936037021439057122868999428011419835732154702776709909141696441935276309948483428431353230547941906264"
        "0425332975063941955314039677915616266545839607715606689453125"},
    {1e-289, chars_format::fixed, 1012,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000001216597782184"
        "1121332071851420445055850947729807109836319696396934719179642881265582543213680619019232142312832213352408"
        "4163390286484192941584938686918553949868597413665027879249811981746091325158693742124647465025499020521108"
        "9036966465689115216728219127852873379022584791362417713140924541034671157797941243358376521342957494821061"
        "9815013120469114077424518206875138193205377793592507346653993059870530437603059100080677849044804081934928"
        "3260736024046421216376242112106057114182206876786317634380179194720733302456566726121387895888403002820621"
        "8454014987419420754353802565408021212043345918976891903356154272622424589432036703486812148694961250345991"
        "2314280908242325983381615372991291224025189876556396484375"},
    {1e-288, chars_format::fixed, 1009,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000057735490444068"
        "6056577598174714126910861572730869783922094285424325691264678703102336389327771952449332944119499049658178"
        "0186088027703415718786500234439107644361807467403819565320361399423324538262232786462612897902648957724741"
        "0574293815986421962941557035285513791518871325236200015245144922927908376944180801232636656176964011019622"
        "1808650457260393636630534995116269380104128448944442969013289878749600341030883893788244288349023841629492"
        "9786044393832885086656309603701161727929621817754084190071554740498038049183528080657816288366674347681044"
        "0102912936553966078537125085056956010945264214175920599443644260599671283659952081248132555833757853193105"
        "8655199821600008391886404979231883771717548370361328125"},
    {1e-287, chars_format::fixed, 1006,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000212798803462866"
        "1819720944463063858289798963846308354749764282603428916900787907451276235749993426437237273265575167509029"
        "3443398974142266764368095422362531278211408028009869470625681338533955089219964942897022997845219557138194"
        "4105904887102061264140644298800897904844525959465817081764253128629509377723661071135395019790527607724202"
        "8818350552049913467222526540243594216638480385289473670346024547141635690306495794030716500282374238053252"
        "0430970711379467483411988175886892590435793778413579130557445058654740294892394251026664247805588921011835"
        "6527024866661592505378455402755608985358201946503193467379630330993309721882840441441237007264415734065510"
        "2452872302586095454302039797767065465450286865234375"},
    {1e-286, chars_format::fixed, 1003,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000100000000000000005044436842451220"
        "8165649742903257869448523746162199423267071399152913134975872063089463617721743048821110076091074307672300"
        "1773840164557791031656209599853674105367413448325304166880274630933873239418552802803077827902355732255673"
        "4155315053117879563605851420442899131198757937827635383140100091491688910981786240881722533738176097018180"
        "2328737684931317864887852689788738841607236686134384861755239394251298663083703091120976068486655806465942"
        "3745492929389741899328744647866723415241332977153893466839269357152524524467034954678631564945125656507192"
        "1287084657640471293726917610067698846337541027080034890250801509960322136561847382733078481229459723579489"
        "7321730333172862259516477934084832668304443359375"},
    {1e-285, chars_format::fixed, 999,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000001000000000000000073775958887092680"
        "1404019815213532986889510323214921238826142576478123077502664539508246258991900763800999508393324137379055"
        "6457205030658897420364139008363631639700799829065917353790436274093311171936755018693561074624838609546568"
        "6323279987956931013653781663900351974015566123632070355381551356489650179779266645039404024044961128391013"
        "6449234164770644190179225196709761817851829527261033883912345325192520710986992117720249210169865472126799"
        "2941215818657955514958349590649614239480491315683751958511243736366217849015089102082228344565148136182606"
        "1005534504601082856808084760769860405419582767185150634144000699821020707486017573896452080977016299189995"
        "556136179022388432713341899216175079345703125"},
    {1e-284, chars_format::fixed, 996,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000010000000000000000364454141469639249"
        "8079839973240061190426737446662380289774568405597363131123542857264701281527483228571615124211944403293694"
        "5071196145293180542808701926406067020581352757653162578101323304859851275347918336331086016627885503628334"
        "6910728571119144095013537287461749147707873310629239170126706499732324678410198670839181253838408752562755"
        "3902624600386993240981079185939643750046892617935374577364231129052661827470541873034675696845736201789984"
        "1631573790410970802849046114778061001730328450520442943215634726206616820635058136087680323829216224055103"
        "9900338194868909855458309046212652981489067729694678635264237394725417604979475793913844510851457977578383"
        "810868256631465555983595550060272216796875"},
    {1e-283, chars_format::fixed, 993,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000099999999999999994685210677065491259"
        "7749803438914163621026595614939832534061107435560807857560967665020741413878246459195032208808316741012258"
        "2691461581832757568102503490534685171574034784387362745740286582840262097008018948802266655386840832186907"
        "7377574308387455953552668437614997258331822889697246492735695433382995918922759999075196859715226773290408"
        "4873036868203164550342645111605051217155262467154603491420980341585531497120315430319163251987317550427630"
        "9581712396063683706863666146546656583513251553594590026633083963132688137970592127246328314557798934048071"
        "5283217521283049451642164986463704069928438685182921404423903463619228772657959257922213934465659432066116"
        "096837760096605052240192890167236328125"},
    {1e-282, chars_format::fixed, 986,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000001000000000000000018526752671702122504"
        "1886804737033222476192186962870088250087687318910666205005363911217585349955151204119274354572185745520077"
        "1078614787119958560901161093554731989656290181027731739586437554468626221849504804091414641004521954640590"
        "7613434306306439508188319872169926333293510629733626595607910845351966110661413665284894026503153751601248"
        "1956041767365788379171625098381602438061934369139173171980451007384009191883980703412382251633531244053994"
        "9689328025005031641651021475338193305452779148824615510516946022794721926745835141507082535452895792504462"
        "2593490632078887339949053669939646658982295745940133629986798505271865943673982028951988737047957070402937"
        "06313605071045458316802978515625"},
    {1e-281, chars_format::fixed, 985,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000010000000000000000185267526717021225041"
        "8868047370332224761921869628700882500876873189106662050053639112175853499551512041192743545721857455200771"
        "0786147871199585609011610935547319896562901810277317395864375544686262218495048040914146410045219546405907"
        "6134343063064395081883198721699263332935106297336265956079108453519661106614136652848940265031537516012481"
        "9560417673657883791716250983816024380619343691391731719804510073840091918839807034123822516335312440539949"
        "6893280250050316416510214753381933054527791488246155105169460227947219267458351415070825354528957925044622"
        "5934906320788873399490536699396466589822957459401336299867985052718659436739820289519887370479570704029370"
        "6313605071045458316802978515625"},
    {1e-280, chars_format::fixed, 981,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000099999999999999995736438816947517005069"
        "4172070683240219593513666870751723400097759022579142792104411515557258308779196173510175383489009931421520"
        "5866900041712517007353341295067415591468605332289608545645634822563507367302240104608293998170498800889934"
        "0527112983123526485039091556623246664793688444410197203376128885318687103789266301679766012373101564633549"
        "3680073454731979186907663345907207730732342719302852534949839594619012356967550855734248053136101277703677"
        "1838055674417227267876760024773786411282086583477850214480190207549799327177530658970705609297562011086483"
        "9716814098692546387233575608142290670674682296548225014870667032395919842010303184918392220732752395662146"
        "227550692856311798095703125"},
    {1e-279, chars_format::fixed, 979,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000001000000000000000055224171373038293976285"
        "3855155153714644346417139367630859739713156121591071255955788854793010075566749549777915014563133243594249"
        "0582259141658595397737701917166689901252657650633132064426278214420910755394245918613661618212134619605613"
        "8332212191562054191077246132142653280854876907341369752400579251233654435526266645751846330807393174195816"
        "7586387056869531553154177335120654514700934306859959959022574246700632872563820325406114294833382820169887"
        "1896505961547263034373800392466570256754118618517715540232495226256286830271042457507823068847895940620711"
        "1284126734064465595084418254580910347625099724924457889653606240609990826309427213671625952334798270726423"
        "6523769795894622802734375"},
    {1e-278, chars_format::fixed, 976,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000009999999999999999377924315287625452655759"
        "2938171681397062528805745754945088532304770466314992540617804157284976902370041721665215989554925283393972"
        "2863486722184850086925551573756491173727324573486761348623622278779062565480320715767956544035586867580858"
        "6589133591699069822536494530504293213532859514540924900334307735775143583659422910068228823157401407634290"
        "6436040454098439322611246838623618658479257702622384275935602860880217090978462037297537786665387684101487"
        "6773669006972746076463602187921228840342152780306594657157834453463345600761594161469026978011649449136654"
        "3449438374976635277860236467913059785711676135938086005172831406290399388617527762863814583260690938004700"
        "0013291835784912109375"},
    {1e-277, chars_format::fixed, 973,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000099999999999999996910756215390274492176511"
        "7684063095968974449032518673086908962585813328738512123351599947903432632493627286289317645086338574069104"
        "9859146406918111243792762665325999307404584222453104941273982428937412290702243078662657808584560218409332"
        "3845971447447957127327523414168904388704353969069975999800370095248504560869545227216246858018094967873244"
        "9501284846576063116593872419790657220872804668829750264129734225138468602210596951011658297769718221274568"
        "0247065025727152144034426510530885009285616882720775225357325358898849879479489384314813008029321043554428"
        "6205927658214407906559554220186714365221617661531507762030263395729350884779929292244665672839687431405764"
        "0731334686279296875"},
    {1e-276, chars_format::fixed, 957,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000001000000000000000094368084654463543546521870"
        "8934482239623710929327631676310035207382479910928589920458334481180870676664675648379486432346815345866334"
        "7562631471965527419417503763703495879299381727950707614250209935245588342983867625950272814993263888123155"
        "6645135692769927351778358506727934022073892637128839856295410452367794579708097333520813637944185339945990"
        "0648060689427426785194885540085397651937152392533802832245566904836593719145032631567800222330837423133330"
        "2885648497259176616280450358052714327419732013400898404732486559604253669336804628129859196806272523059693"
        "0521032920066284183883123844111803976410428701340986032380607270307788791985359466707450337707996368408203"
        "125"},
    {1e-275, chars_format::fixed, 966,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000009999999999999999340346158537457213068332267"
        "8543526013082338874045021461456248630313162327929500011721456784332939064523200829570096560480254512419700"
        "8795371964014762431104610623358122885748511635735451163169163085301125849532284716159435616842569069649709"
        "3677965333582715712943593194781546492350408656996176376820222925178758968119116549821319640072436935926581"
        "4349890431339283925469990220965010846294970911113385878318393484181518669350318361102421491997587538371382"
        "3544507500749779910821332345405681071783711350736713312486683572160874299231588233532459276695530510399722"
        "8899848075258616324750193420386387614417860312278232649208014296495104634271942900536345177897601388394832"
        "611083984375"},
    {1e-274, chars_format::fixed, 963,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000099999999999999996610130961388928575477095560"
        "7037852897132929578912805217850693190154896842007798502938343898280926049479119604150501130778343016684302"
        "1615605151428647837186960260934900671975727644897761590357503387320773655935630248280941234605830319660788"
        "2326436524060272739115915692811052380281121998546208140469992448785963339114879068986829879463202286332452"
        "7760337239262807107657632569428039809102815139583143671458485970184023737703199520175376382597448769637664"
        "6069029951181771612179665924299735122664331073911674594543199769372067780588798430856858149689694544391644"
        "1619443003394614275664024245327180443551456525045581841276259778116612913882732538439768177340738475322723"
        "388671875"},
    {1e-273, chars_format::fixed, 954,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000001000000000000000094368084654463543546521870893"
        "4482239623710929327631676310035207382479910928589920458334481180870676664675648379486432346815345866334756"
        "2631471965527419417503763703495879299381727950707614250209935245588342983867625950272814993263888123155664"
        "5135692769927351778358506727934022073892637128839856295410452367794579708097333520813637944185339945990064"
        "8060689427426785194885540085397651937152392533802832245566904836593719145032631567800222330837423133330288"
        "5648497259176616280450358052714327419732013400898404732486559604253669336804628129859196806272523059693052"
        "103292006628418388312384411180397641042870134098603238060727030778879198535946670745033770799636840820312"
        "5"},
    {1e-272, chars_format::fixed, 956,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000009999999999999999301866126025284935730806993268"
        "4294899886624383983470374216790147668883045176946431092771471673520639672235493868702134168544937709853359"
        "1429337879390148790920375029878823974624300284932163665172614889411667604931319119196596048407394171745033"
        "1403935323918325627433389841599442869084231853163044353009766814778484224031986972036038327570940801781773"
        "8753236228844311234497456647675670141133638771994459659098870641092624819918170192607554446128657740296261"
        "7020041425572240773736235762765978925784739938178814850567203587714401772313240386072092102717837114989906"
        "8396528248914912412248339888827962825386071451073585017660894737117835417983258139429381117224693298339843"
        "75"},
    {1e-271, chars_format::fixed, 953,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000099999999999999996302290701291550356776893364016"
        "4003991567213658420396519935025329000662579987369857908861397005578650671396918539345720284666419005521998"
        "4064142345669578677438274308948177784628961293609594325579624027060200516803071959029068252536915837073555"
        "3945337989893640586637253291475984430526597402101480732287181874119467954202566192561065504274325334055487"
        "1239678379290193773690454889358399872116960852012322184129061860615381459997992896864882185777724588975864"
        "9130276588110251798897047156414379800918187523398613454268820786788600914598485685760672947193158113780296"
        "78306273170029769604636013467032308116625984283093277534325640527185230510553992644418030977249145507812"
        "5"},
    {1e-270, chars_format::fixed, 948,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000001000000000000000041830013597844327555020695992134"
        "5359740495412230260591865761225745490596877103431706636134296544720601490976701849242289227873195822941751"
        "5139748699129965212011319333320290767552615599006927428279643461246592387787857999805268968480537241692929"
        "7197013915985629361653049926317182057688666912319700175420148173225696675210377258427028528301268930260832"
        "1372369973231892026085870796024761779903363689748636076659149398693012859570912267592927245564778354076598"
        "5619461858410775465803020254253971042880790632637293309011045699356005741170820658560775552286468270952449"
        "1074549038522237716160872469198769503871198304856739378092440884149283419901621527969837188720703125"},
    {1e-269, chars_format::fixed, 944,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000009999999999999999577690999072535819686188161500326"
        "3519273505848744668567549228551263076943947250497039187792816231909003955020176297381970879169230040385329"
        "0082017738668415452075046732258769848720794252352109776306800578923660200469103629897100958283997793383955"
        "6038042977997909666871651139893551217711278282611477993685967790592783998133475700895634770393856345744738"
        "4650780475466074509591274334212811839206915088148608922660498866512013826738634153858814985914103921374525"
        "0149861492819674905149683181364531402686142074093906249333520124546760396391259375431263999079219955930024"
        "121721445463605063867689533554544024142970014975713411407853836720960316597484052181243896484375"},
    {1e-268, chars_format::fixed, 943,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000099999999999999995776909990725358196861881615003263"
        "5192735058487446685675492285512630769439472504970391877928162319090039550201762973819708791692300403853290"
        "0820177386684154520750467322587698487207942523521097763068005789236602004691036298971009582839977933839556"
        "0380429779979096668716511398935512177112782826114779936859677905927839981334757008956347703938563457447384"
        "6507804754660745095912743342128118392069150881486089226604988665120138267386341538588149859141039213745250"
        "1498614928196749051496831813645314026861420740939062493335201245467603963912593754312639990792199559300241"
        "21721445463605063867689533554544024142970014975713411407853836720960316597484052181243896484375"},
    {1e-267, chars_format::fixed, 935,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000999999999999999984668592288242620556267417699505243"
        "4427556929628320851990391133724446223189086131944788332886398080404746053916579979506572702930306087562857"
        "0296789951041118584725364456089395329851000842160241838348346965718457724013606770688935077083767291846491"
        "3631375619259253076248253934259741264740335159884559705093225192532247940397070357552293443188289194108499"
        "5411463765898514999685309454394974635146606713668951271841730504581055280919048092136137622888139957979240"
        "8418376203186042607144937694058869104510663482319483838213992263101544129268248268774128669056803708025354"
        "662627524236751260150807296069617765600306773764172074692169189802370965480804443359375"},
    {1e-266, chars_format::fixed, 934,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000009999999999999999846685922882426205562674176995052434"
        "4275569296283208519903911337244462231890861319447883328863980804047460539165799795065727029303060875628570"
        "2967899510411185847253644560893953298510008421602418383483469657184577240136067706889350770837672918464913"
        "6313756192592530762482539342597412647403351598845597050932251925322479403970703575522934431882891941084995"
        "4114637658985149996853094543949746351466067136689512718417305045810552809190480921361376228881399579792408"
        "4183762031860426071449376940588691045106634823194838382139922631015441292682482687741286690568037080253546"
        "62627524236751260150807296069617765600306773764172074692169189802370965480804443359375"},
    {1e-265, chars_format::fixed, 933,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000099999999999999998466859228824262055626741769950524344"
        "2755692962832085199039113372444622318908613194478833288639808040474605391657997950657270293030608756285702"
        "9678995104111858472536445608939532985100084216024183834834696571845772401360677068893507708376729184649136"
        "3137561925925307624825393425974126474033515988455970509322519253224794039707035755229344318828919410849954"
        "1146376589851499968530945439497463514660671366895127184173050458105528091904809213613762288813995797924084"
        "1837620318604260714493769405886910451066348231948383821399226310154412926824826877412866905680370802535466"
        "2627524236751260150807296069617765600306773764172074692169189802370965480804443359375"},
    {1e-264, chars_format::fixed, 925,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000001000000000000000012213672486375396070019585686165194290"
        "7768226656267343111510651008940076674511880159438755777687567257201019061105026607485123801783385769532188"
        "2086421261481722999352275826903638609094263676288387000674976831353905367328402411266467736170956180244689"
        "4303306394778338669389237842071626199542224191002289665586032984188422495758631972841440682207524614384247"
        "2881974452564577216574512303496326748626962048403693772578610441840030544015983340887991121353726198621929"
        "2976570513839949533796121047135432468634500998635356792659586929260727173974451837402920458847217808847772"
        "88209358202601049382573125959828533489137658563095101271755993366241455078125"},
    {1e-263, chars_format::fixed, 924,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000010000000000000000122136724863753960700195856861651942907"
        "7682266562673431115106510089400766745118801594387557776875672572010190611050266074851238017833857695321882"
        "0864212614817229993522758269036386090942636762883870006749768313539053673284024112664677361709561802446894"
        "3033063947783386693892378420716261995422241910022896655860329841884224957586319728414406822075246143842472"
        "8819744525645772165745123034963267486269620484036937725786104418400305440159833408879911213537261986219292"
        "9765705138399495337961210471354324686345009986353567926595869292607271739744518374029204588472178088477728"
        "8209358202601049382573125959828533489137658563095101271755993366241455078125"},
    {1e-262, chars_format::fixed, 923,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000100000000000000001221367248637539607001958568616519429077"
        "6822665626734311151065100894007667451188015943875577768756725720101906110502660748512380178338576953218820"
        "8642126148172299935227582690363860909426367628838700067497683135390536732840241126646773617095618024468943"
        "0330639477833866938923784207162619954222419100228966558603298418842249575863197284144068220752461438424728"
        "8197445256457721657451230349632674862696204840369377257861044184003054401598334088799112135372619862192929"
        "7657051383994953379612104713543246863450099863535679265958692926072717397445183740292045884721780884777288"
        "209358202601049382573125959828533489137658563095101271755993366241455078125"},
    {1e-261, chars_format::fixed, 920,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000999999999999999984007510363487433943937365667825404622403"
        "1858499650136203484265309618370705435913987636722737007132720287134753111378376150804829390632405896825874"
        "2835755829869406788748415695130440806600043856721180691093451748215661117451527599123708109603902481283306"
        "5354768000469950146686973765336065314190341205083063488532361401368826701838966200291248435154176358308198"
        "9728893217809824559093005170114548158227707844413715390150040396446928048862747223614050542827541975695738"
        "5794370175470927605091811150712639672177871184201768104247329678930918510840380610087023154663790550827981"
        "414572464666142574853625058233126676743296457061660476028919219970703125"},
    {1e-260, chars_format::fixed, 916,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000009999999999999999614425806651770642430715896531535728877042"
        "7639743563706770631567501610059301751410501950963044627850907560273067164597910833496514764297149885360067"
        "9673513083865327379264867283239061764691379113885247039867480636638961486908206652484856605220802705584074"
        "9934665781749747526462791203039579317632613673177818105318631717258914564045608873717014172578259375569275"
        "9324457403959109467575665091447877832402353969896696393817192415800352751662722921123938941086166587088913"
        "1734552438880426522684223629367765023193692232777484599756500134939141399512151758202746006205759132720608"
        "71364815590661574151517426191360105036665117950178682804107666015625"},
    {1e-259, chars_format::fixed, 909,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000100000000000000006975424321706683880722731452357836521425904"
        "1769576644520388447783555635685142685114991490318067565371250534304941206899940713450546460263134832737073"
        "3569301150432818187174576899527240109748644898527344209892574951236799874221394784955341611482688203792287"
        "2771340519085664404161341645807336741324458859113386493425467401198063448970638938552710316030795716303021"
        "5539363198269628596767208179963758318010314462508924306966078494112058890935196332034580795945818024575817"
        "5384691548589042582068854426091971764017863571304275247971240759153512021920926030066766002800617354047947"
        "8761531152970377521634059991839649228495545685291290283203125"},
    {1e-258, chars_format::fixed, 910,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000999999999999999954221803161717745938794541328458586732600625"
        "3726262365708608402011134649202091693710213775846048593849306072923870085843861763994543884853897883249200"
        "9461861512013041663469458945815094827248008882074788112602884607331358687394446408414476815897163126439807"
        "7850123040582626553256833893683569386595819232891673571703738240152177865551187237446371530993802916520751"
        "7582547623458590810226137634464463244244213813974999135856472022629587583400314031863766518560557273100193"
        "4762465781519467364937950848500287964648595782062173808712520554072741266682236854915063326747229254166297"
        "53836788650765392684298393799480209054308943450450897216796875"},
    {1e-257, chars_format::fixed, 904,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000009999999999999999773282911727875645124810959674825424289323086"
        "5201631816076636171760189907319587251981540013129740058219459269489784824749708380967280284093879720735074"
        "7080915104760697051247209557065560812956969027145189098674575883386866983583466966422646756831069087364207"
        "8227794706374300509281504065615289919255731045401118442139253945178691903822276670625178568566337658226445"
        "1447644953061298417153264674990872314159999761978479226173346063277878485906438895601748067400818676317898"
        "5793557223936590560880695309841738997546037682582895429124979615652170571876415440655826669990181114289337"
        "83000539800198645801199148763771518133580684661865234375"},
    {1e-256, chars_format::fixed, 903,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000099999999999999997732829117278756451248109596748254242893230865"
        "2016318160766361717601899073195872519815400131297400582194592694897848247497083809672802840938797207350747"
        "0809151047606970512472095570655608129569690271451890986745758833868669835834669664226467568310690873642078"
        "2277947063743005092815040656152899192557310454011184421392539451786919038222766706251785685663376582264451"
        "4476449530612984171532646749908723141599997619784792261733460632778784859064388956017480674008186763178985"
        "7935572239365905608806953098417389975460376825828954291249796156521705718764154406558266699901811142893378"
        "3000539800198645801199148763771518133580684661865234375"},
    {1e-255, chars_format::fixed, 898,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000001000000000000000006904595826956932286799885905433205720236863249"
        "6356225958454292587070947890188525502717489910638533146924940101117230162790452947523732160415285768619822"
        "3265908508745598443456328367626486476737569133374330366111004028066552392139065573833136209114950076085418"
        "7779701107578527947435543045317286747658060250112833026964952105954086165959416971185153961057252929067242"
        "4402091270979802021488173783405934995886263843094369671238713461484188034266107411577415609873348632233226"
        "4974846712624420760221444563547896690293990589317682688469043155586069034559546178247422521307848725108176"
        "13033601465588606771461854805238544940948486328125"},
    {1e-254, chars_format::fixed, 894,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000009999999999999999122604209336149554089797581039910831880622885372"
        "5384840359241312717046849838531645281143263981120457069920980142732375617676854249774801571278819442602974"
        "7078348041827398235031358522011898974074365930369847704200738220510194840034849928140625258892177891585819"
        "7789636031034014857231062971947433169862019781096688252383678240824196580178172634498032269020941885145129"
        "5617841834599290417707136735860835402501433783057390987455706336559018146750102870890672265406094308144470"
        "9936488919352538093353211095511064960852791300276354053615820664052311244219394177202048499806893773501181"
        "1498812839271721486511523835361003875732421875"},
    {1e-253, chars_format::fixed, 890,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000100000000000000006369110076296211841349196258629847923954160807706"
        "4687111197238937629070563398974208747938801815442561088464535322362572340411346105148336238772806323553724"
        "0075273148331361542824387688166442433564865757673772352556215167587213702041392244458041905038944824152085"
        "8014361026360382446300509419081280606117521331473154800090267507708607072437679582636440155034817339888013"
        "0627552349172580931864984929784586926793612196754801473459915818115976602076568627042463987299215308449413"
        "6356540503792093075311863594597080681921746489171105833351980909457178064211023456375312410414433376301093"
        "954474641378737942432053387165069580078125"},
    {1e-252, chars_format::fixed, 890,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000999999999999999942546556899484388009882199000452562398358152445216"
        "0161451133782892621889113880480039987338722120521687770607482063315194094971032192280798179851168055345424"
        "6418389642854581888157457137284802793079005944935361041171487975990014606870778740166104521452120975169753"
        "9199604535441953471086056593957214801196625150681369790874794281352940559129169925115461831744985491386391"
        "0682451466288395280300908728436006053701927038100881943376338560953404944161366925338709207085975268456506"
        "7632194555787233618880614830079358232066797000450535955969614943099255665973581088914504805380368632696679"
        "899451996931247776956297457218170166015625"},
    {1e-251, chars_format::fixed, 886,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000010000000000000000152332832175710262520480571519601125030682258243252"
        "1872476369467828231790259460372684825682997408640416390302047595015116804564895078023367045773051634605139"
        "0189947471300020122093089839125757186207969240167785318058861959192880549966649628146932388145173349804163"
        "7660079723390760662374791520705695571837780491114767168915227587928186582777454658648256629068982358826348"
        "0382946815508437033102730700819239822424439957691616181100303330772215901239585323902676066296819580790845"
        "1921208450674518994234274996142273843571977352068493824997314339827706516555731738176763846387477108852356"
        "86628647044926765374839305877685546875"},
    {1e-250, chars_format::fixed, 881,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000100000000000000005399953725388389998120318149943080589224693162651679"
        "3433910530085759720031238100112368002407447171329703552232353080088105938206674274715725109791162112189484"
        "0598413607689274503696330211405461224308544619353452681089857988156722733047094822727388807446206021276968"
        "6808980535087478365157118306435876037692626160753374410044461342742031115698575426448637285991836628063146"
        "2807772969081619558193405229308021079738637319224411130133261154325713463734072281776541971965885921112598"
        "9074819935023498237959425669949093224541146041021654331579356245397864401930228576603456024321655258579877"
        "312286043888889253139495849609375"},
    {1e-249, chars_format::fixed, 880,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000001000000000000000053999537253883899981203181499430805892246931626516793"
        "4339105300857597200312381001123680024074471713297035522323530800881059382066742747157251097911621121894840"
        "5984136076892745036963302114054612243085446193534526810898579881567227330470948227273888074462060212769686"
        "8089805350874783651571183064358760376926261607533744100444613427420311156985754264486372859918366280631462"
        "8077729690816195581934052293080210797386373192244111301332611543257134637340722817765419719658859211125989"
        "0748199350234982379594256699490932245411460410216543315793562453978644019302285766034560243216552585798773"
        "12286043888889253139495849609375"},
    {1e-248, chars_format::fixed, 876,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000009999999999999999795683295041631824212253427522870745850238164863089699"
        "9234860610340310794424258705217009089869884827266742574554899060918518449584516531018017783472224120434382"
        "9645092988625380078670111672151364882914836141630164012748026739912164495634562351190414953681877666513312"
        "0926859682212462165144835562834902460816936151042518593146525289851376288444005371378097501197159164778775"
        "6942772620690104203449664476602519718970085399257243740322368884688891716469171969696185869032090376063669"
        "3836791272914631037540830957849203000411080197515945489542757892592986809423908251868630826363765207176470"
        "5397072248160839080810546875"},
    {1e-247, chars_format::fixed, 872,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000100000000000000001926497363734756511988019008409706461554281122775314249"
        "4514965560659967723973527350942310370031287236420026538511171664609586474954023659804141544823505729751952"
        "4164358047864842338503300552952355751493032316115528640748385136508891938078529760162633755158640458112086"
        "2448297230313284854472329392363431586546321106664772125063167481723017718645585839037674201232944402645636"
        "3211855740084250652581223188423001215800302116219740192577003768928675335028019472737919103955579681683207"
        "7808991286134005086884235109479333757196262799956722460189534377628286140100146030563490161247042209424762"
        "404523789882659912109375"},
    {1e-246, chars_format::fixed, 870,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000999999999999999955750343024252552802032434353201080566712419641442466491"
        "0487904290489920764040228729067592158993848944158652697716819759305433083798503004057996086614824890989559"
        "8228729892871758556198064226504246757415588764133070195193967566892967673058797629490590058148583893457417"
        "3607765772114237296339713699403804211431857526814342153065041485882099839167344386269554984147799948730293"
        "1572484869911168636458977125865147740411851183840557296116998936650622624899398314962224421400982080087854"
        "7032655949536935485227542598996477522595254802810943565704056549108172667224444115599991250720179891686711"
        "9260132312774658203125"},
    {1e-245, chars_format::fixed, 863,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000009999999999999999303444907790145478748933320608426869471802630069181960896"
        "6232037640460181737622108169253875424662395761420076227588610045892604175018095664646283419667319283775740"
        "8627896585610926246640877052965224544096950053241837102780140476145869899681976406362910607734556183920393"
        "2576831597067927969862816097115995498193161108809905140383881533428689002519387846266801728751423176398651"
        "3540558575386334807176752225192019733753831924978194442557834355961703347470797499954377741390561853901654"
        "6097531848156893317816192006777335028483055241084311512275416582382971737136376395860271060200830106623470"
        "783233642578125"},
    {1e-244, chars_format::fixed, 862,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000099999999999999993034449077901454787489333206084268694718026300691819608966"
        "2320376404601817376221081692538754246623957614200762275886100458926041750180956646462834196673192837757408"
        "6278965856109262466408770529652245440969500532418371027801404761458698996819764063629106077345561839203932"
        "5768315970679279698628160971159954981931611088099051403838815334286890025193878462668017287514231763986513"
        "5405585753863348071767522251920197337538319249781944425578343559617033474707974999543777413905618539016546"
        "0975318481568933178161920067773350284830552410843115122754165823829717371363763958602710602008301066234707"
        "83233642578125"},
    {1e-243, chars_format::fixed, 860,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000999999999999999995383472526823840488369433929280174613182583991300328317211"
        "6837111742408804873936672009431360776919558264619014651235416662662443221344766703649768265849912664257571"
        "9596658396397409391067599588296670104783027874933111662855056967241538680133612103296494053784002559407095"
        "3894647469850715331067759323643483547422135670370709946620684643300103875377124832439689733145853231360871"
        "3234129212323479415408095084823136988741250335228345020495118295568197537015276310411591129586475816249921"
        "2384262502079484603183100373718193400495677586862932287419778865178437101302218181775316452331026084721088"
        "409423828125"},
    {1e-242, chars_format::fixed, 850,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000009999999999999999693678798277001234429789931819051795467816555975474754261919"
        "3837726638525524292463299758138334526475654155744578942856518333016329335306866080411977462027189495841776"
        "8738584622754955002756418715869838267478188546333511089186532261797191953592235164943207416526488924599875"
        "4100523646275479931532994788259100561797257546186315833276721231276224260017887501358829899444389947625769"
        "5628205428474799363149460585746715433980272002647847146104452158090524210410657844220643333743596458161371"
        "3318314275234234745575404953243171796196161954902198634685306144259317462363867434760322794318199157714843"
        "75"},
    {1e-241, chars_format::fixed, 849,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000099999999999999996936787982770012344297899318190517954678165559754747542619193"
        "8377266385255242924632997581383345264756541557445789428565183330163293353068660804119774620271894958417768"
        "7385846227549550027564187158698382674781885463335110891865322617971919535922351649432074165264889245998754"
        "1005236462754799315329947882591005617972575461863158332767212312762242600178875013588298994443899476257695"
        "6282054284747993631494605857467154339802720026478471461044521580905242104106578442206433337435964581613713"
        "3183142752342347455754049532431717961961619549021986346853061442593174623638674347603227943181991577148437"
        "5"},
    {1e-240, chars_format::fixed, 848,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000999999999999999969367879827700123442978993181905179546781655597547475426191938"
        "3772663852552429246329975813833452647565415574457894285651833301632933530686608041197746202718949584177687"
        "3858462275495500275641871586983826747818854633351108918653226179719195359223516494320741652648892459987541"
        "0052364627547993153299478825910056179725754618631583327672123127622426001788750135882989944438994762576956"
        "2820542847479936314946058574671543398027200264784714610445215809052421041065784422064333374359645816137133"
        "183142752342347455754049532431717961961619549021986346853061442593174623638674347603227943181991577148437"
        "5"},
    {1e-239, chars_format::fixed, 845,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000010000000000000000759277475233108684608982384831531593387598582983591608678088152"
        "6495296189624426979709455112253728656481252609623707518885743635118724171586796539025946776244048864006266"
        "4469924388547969595006792298588215800350017811703378421629495689318049951191680360226281426735122753412882"
        "9539156216414092509270031986910763086367695391445593758514057541064426431653432522754100974317078691906840"
        "5008530211738026804844700883860075238691610755277275140661505025108160714320988751660906591874799129168282"
        "5891089050498574078337572256341803279636545528499519728434495081936805860323147499002516269683837890625"},
    {1e-238, chars_format::fixed, 840,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000099999999999999999067985336682227244656284224215477550517729613770981251451531375"
        "4803700583443193665816975331183669118195751175878957889918151400872130798102236373871589770004064462227523"
        "7616830816735961241363311555882571426208406291495470335517085756171728640264680266111895065381642305829046"
        "3267482636667637282498370046626020550795760273417853730797965291922933006406875916147397503753738389970183"
        "5660488221870958805374087741443622319559242693331719116940274774410004713904731268468483132521263549307219"
        "82963799748751127599147704580579761285687302745881169393181442384133106315857730805873870849609375"},
    {1e-237, chars_format::fixed, 839,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000999999999999999990679853366822272446562842242154775505177296137709812514515313754"
        "8037005834431936658169753311836691181957511758789578899181514008721307981022363738715897700040644622275237"
        "6168308167359612413633115558825714262084062914954703355170857561717286402646802661118950653816423058290463"
        "2674826366676372824983700466260205507957602734178537307979652919229330064068759161473975037537383899701835"
        "6604882218709588053740877414436223195592426933317191169402747744100047139047312684684831325212635493072198"
        "2963799748751127599147704580579761285687302745881169393181442384133106315857730805873870849609375"},
    {1e-236, chars_format::fixed, 835,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000010000000000000000452385056269749738957374958363937411586701359205253954606231547212"
        "9922782363588238983462383764998428403048712490815296123929376907380178547230294435983168516337593604201381"
        "4957518073195145493426287108230683567514025983999121921492328385734199812203920124848335464217685194090758"
        "2689353425054148102761793301425115103972420368222739757723576790458504488844347543930933698064944859304528"
        "9236911499691672094075724362418556266763620337397978233213107947983026866003126727845611570636930442760770"
        "896667141459146949297798054884123959586342812486483601353004502243493334390223026275634765625"},
    {1e-235, chars_format::fixed, 829,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000099999999999999995794466201073065157705805008561139611308159226802046274685060917490"
        "6384239327580431406386227303880018694909606461440847125465979951128205680196431578644620908477577938829729"
        "7184198338367113220740766762730180528365910488757805298383239560360625550264905029942091825321578161929573"
        "1836098117894763380821314793082190649381915259229530730403006333941783317935380572250403817591754796466532"
        "1359685995384056034086040135284373694206587306362717705160991368109381051551269182499342610200096234987102"
        "040793131263159890576484959971436813478787059179808682785051132668741047382354736328125"},
    {1e-234, chars_format::fixed, 828,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000999999999999999957944662010730651577058050085611396113081592268020462746850609174906"
        "3842393275804314063862273038800186949096064614408471254659799511282056801964315786446209084775779388297297"
        "1841983383671132207407667627301805283659104887578052983832395603606255502649050299420918253215781619295731"
        "8360981178947633808213147930821906493819152592295307304030063339417833179353805722504038175917547964665321"
        "3596859953840560340860401352843736942065873063627177051609913681093810515512691824993426102000962349871020"
        "40793131263159890576484959971436813478787059179808682785051132668741047382354736328125"},
    {1e-233, chars_format::fixed, 827,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000009999999999999999579446620107306515770580500856113961130815922680204627468506091749063"
        "8423932758043140638622730388001869490960646144084712546597995112820568019643157864462090847757793882972971"
        "8419833836711322074076676273018052836591048875780529838323956036062555026490502994209182532157816192957318"
        "3609811789476338082131479308219064938191525922953073040300633394178331793538057225040381759175479646653213"
        "5968599538405603408604013528437369420658730636271770516099136810938105155126918249934261020009623498710204"
        "0793131263159890576484959971436813478787059179808682785051132668741047382354736328125"},
    {1e-232, chars_format::fixed, 823,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000100000000000000002498633390800629111780386442221223710809359379314425107102792415453608"
        "8112076356335479272712049688094472633140628515750764885721997341514960534233394596286256239516962075107182"
        "0472816639887656725742880165051681088610790505067186285993580442319685387564525781781668666428424184684484"
        "0209067767442533561117586939952229164792768091892468770567220195808204085597430151664486820063632239017589"
        "4927468561142682409524414760486825800532446292623338674019037911022734863907720194144348058048126919728159"
        "867652859301665220833572223445350350191397625909672797206440009176731109619140625"},
    {1e-231, chars_format::fixed, 819,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000999999999999999989230775562792616696072763442691788577420526313078230631466689498733579"
        "3799436758533070665868519237873911805890727424688238618595726944166776874057594220647374331494830109058681"
        "1264282277412908670889508664537329698372962398608460711914363987494799888127946672804188825082843152917904"
        "6832278353469854332227635491460532805914300319662083078680808603282648054817726043254632316322531603586809"
        "4653495333631366369994657065598222837617049966736674670709473501471704305005000902500878671404512223275630"
        "27908008026052077180979022374130685442417121322478124056942760944366455078125"},
    {1e-230, chars_format::fixed, 817,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000010000000000000000464396689151344957708425250099245062264974342811838633347646649480175933"
        "5135596462478259638716834667872150467156197971992950003945212977393024232997570081916752333744951362797040"
        "8064968717547624093523774421044995987488706419099041487486686846180862681556445048241853678050810632010015"
        "2457172669986243785448097443593469531357092784822504818670379709616765366682468006790097312245968621293462"
        "0473997781040987303938419284302791059489107019314139818789224754807352395205225648090417259273233816851797"
        "149977006703310702512814408808214904078592866198960109613835811614990234375"},
    {1e-229, chars_format::fixed, 813,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000100000000000000006932322625607124740075042963681759328612819746842611641608385512773119893"
        "9920880133372808307294915835253634304557674620371755311403903916831264299662212320939559412636114716811326"
        "2338270949150390473752495313136755889923393923048152348239056346740082016672363763218398489397622731424026"
        "1109283241013239707167944551887261202427286201031744314152971803328792940845510364876069718542296554636090"
        "0496155589319167455351587356310161328165499600930970634670206508434761332673122973230694773644784504899948"
        "93647488342551896278779277366273448013345159779419191181659698486328125"},
    {1e-228, chars_format::fixed, 810,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000001000000000000000032709534510572444792897782233788653990718976368838511485973150840189429998"
        "2170153196284692350924051848022268917645627796641468762810652881896291481637939181043016923375529746658571"
        "6365369112717512121288935488378822658652663517557723908435557308497536948997025139386197551743964733058282"
        "6491927751719567428687923663631557802571128365410305102342922718709701024121818897159151648101200079137387"
        "2862711430642963898037561350585601549264125484676547198254721718567815236797365855082592841848703666887850"
        "37747177197659862532354876733797777177414900506846606731414794921875"},
    {1e-227, chars_format::fixed, 807,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000009999999999999999448366743213753185340514284665191996817368457298282596537074605500891845381"
        "2773976664205546180637962371884910106109436196588663198625257944970478456758975129968316362100479351673139"
        "5237522036301698423224931452058556812576018065406049309435425271296572264531551566715079303865345382215343"
        "4497565715287762855082712110530276704869676176331738082946139637219529017219354933154423585289629578009555"
        "8254847205260583248896120405471733915260362255569652419810976406962998209560925497441410948107643498199168"
        "08006822507980219193039241043496900829268270172178745269775390625"},
    {1e-226, chars_format::fixed, 803,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000099999999999999992140391160425608486502573412858067853267494422609219249843660980606245241543"
        "7266285845678455596772807429948356873502783913017233507635857119058287608601973485118222629925278543631190"
        "3265436120687856793144185369306448728558535026937320361233858543155596710812316128092403135788648626506813"
        "0517759014456531399369722369875296859785808489260546321506496239188673574863325229045321464303305877790712"
        "8222426449488350538349222453692588279587908979174338697479788659722904339841966832055396226731386526846785"
        "6149502649681977558236700698302001910633407533168792724609375"},
    {1e-225, chars_format::fixed, 799,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000999999999999999958896331951646858735466845069282312371173986632069899946869970996505223811742"
        "0238551198816655321437134921895475736493087976082710734226128480926827429824179884221282156525025005915181"
        "8410909084144606957123920113530397640811680303343967342264892148517982060174353905858269803723369395414073"
        "6503960359302868417015603465592491620433337277514815342343364519992601305916837930435844860520897214784655"
        "1440994144763216593283930153321896764130507016098354984877493155742287490696278598293374336834640550786179"
        "121214422959164173920765250613840180449187755584716796875"},
    {1e-224, chars_format::fixed, 796,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000010000000000000000188842045074720969281726225744049265127724544816342318643633489012136580458296"
        "3596595860680142873716319177545269388374861295393117868142201454771495799112919370837715281606083172804275"
        "6213856877702693982152263862758542091738083576971893101469828956572059834562621057530513170623824039675826"
        "6261527028829554943250110925357284565537410933697787459888079249619861975705749544080532085014387137886982"
        "1877615845707545289506591395555191133327745750663038010048636493634780383388550426764336480678810024954958"
        "759532602026627590152685343127814121544361114501953125"},
    {1e-223, chars_format::fixed, 792,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000099999999999999997089390646281190637400800057030683519949368020198276633036864657744691065855954"
        "6277287626692711462403432106728597696196760677403094474374681383689185984160229479378003085214166818823098"
        "5300440486973944534218136807948895448410591421461173584131029794582684483073554583722610639117199712477545"
        "2839882801888583247748499098113898765741804068580802307245320098647828424758533523028653011700551458546375"
        "9034763272472418041727595056862123397096052789194474810296725446652560022479388716998619908128864112804247"
        "21621904078638909396659073536284267902374267578125"},
    {1e-222, chars_format::fixed, 790,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000001000000000000000047678383334268211260671395776863781300739719049425111184760170295473706478191689"
        "7791611948666591020190475766871515962797243198480292056504144461304211953105722457766426545688306735745508"
        "2414457510587369939053397193673361987629823786735854730386454284033466631578041702546443465108648073266988"
        "4805027801397291433526753468482137891534924980161179738620759347290945564368725914713215532098633310638894"
        "6209955678372738070689052947657840949863003370919232746001486301649501207291735980302117459836419315967918"
        "227902079542079860630110488273203372955322265625"},
    {1e-221, chars_format::fixed, 787,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000010000000000000000169645925856856893060060376942410028602413035104481732430035608082629881503388323"
        "7841176759708004617280138870373003624653886287005531314012122115392711085043513921718682682696513167396990"
        "6504364542482001003045855479995989862202599578862071747559917487508179112410433564183086355339876938703742"
        "2425478883927078511100484735448777978881712624199170721537360029658810376553696409425413660613858205688403"
        "8650264969133150093238119960431981583020131793294388887877935675999408142925964561757501084173080407977398"
        "016174108708042922444292344152927398681640625"},
    {1e-220, chars_format::fixed, 783,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000099999999999999999239355998681967174227375122814278010784257107926662288959827321849441348805654645"
        "7812225781416801495804438316992788219990497287676199131886641172731843282325453969622164633472698153505172"
        "3921960917686422930553623146058858509260889480648913025162172052469893497144467951580077187425939035308281"
        "9256395798904098517668447759506972297076828822690693898011732750582941628468462192600203323158782851279699"
        "8908315174577656023161923475148392505322102605760380301683938036029249989328483687465622728201902066159706"
        "05896759337838375358842313289642333984375"},
    {1e-219, chars_format::fixed, 777,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000001000000000000000031707212145005299844245409573899936511680542969157103455046733362124132947708203930"
        "7714926864779929789995589357723850624678822194827815450619691426442713913009503657256241430605917862487469"
        "7166561291001622904015137923005226896850595734038001458613765686489297002802562559813353729824675980749067"
        "2538246634907970670066871114762642838613046935723152057907208241912010477780652352464965759264615802466419"
        "0592504013838078779127652818226698251288471292539940250366079943729802932183427756406437098481452879425446"
        "23405183301656506955623626708984375"},
    {1e-218, chars_format::fixed, 776,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000010000000000000000317072121450052998442454095738999365116805429691571034550467333621241329477082039307"
        "7149268647799297899955893577238506246788221948278154506196914264427139130095036572562414306059178624874697"
        "1665612910016229040151379230052268968505957340380014586137656864892970028025625598133537298246759807490672"
        "5382466349079706700668711147626428386130469357231520579072082419120104777806523524649657592646158024664190"
        "5925040138380787791276528182266982512884712925399402503660799437298029321834277564064370984814528794254462"
        "3405183301656506955623626708984375"},
    {1e-217, chars_format::fixed, 773,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000100000000000000008202868690748290381476913225646909670859314698821691857882076234597017385606232549615"
        "9354324956318077489313327810269020838934932195207033926388944132179370789585752738052315333095636160522433"
        "3865999709748671006813819489852840627997292130055660356358349358096040294065285614945850494824158416186469"
        "0533610161771210159633481996958026945433808300790479747825558409773104494357129833751939469090353324327685"
        "2447491695682251993842794365744794481480119325819590928025541052955082197362408504670566355336611824577985"
        "8852984034456312656402587890625"},
    {1e-216, chars_format::fixed, 768,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0001000000000000000041771507097500820638350154110413768551063063772969066479801539158893341129379028243849"
        "0650141736579986975098141799618541420927620252666428348531029418529871986774431281097775150925562311020640"
        "0981032220795665225737977383887198736471171490512487603729247907629682830180619080574684849389101431626741"
        "1664528249918956372763855804030324781305165180102605821417710349154591213236141639476486349873348621790617"
        "8898194461827527289807843312848189993737272683591382148915037089752510141467022134490811495835527189512959"
        "01206322014331817626953125"},
    {1e-215, chars_format::fixed, 767,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0010000000000000000417715070975008206383501541104137685510630637729690664798015391588933411293790282438490"
        "6501417365799869750981417996185414209276202526664283485310294185298719867744312810977751509255623110206400"
        "9810322207956652257379773838871987364711714905124876037292479076296828301806190805746848493891014316267411"
        "6645282499189563727638558040303247813051651801026058214177103491545912132361416394764863498733486217906178"
        "8981944618275272898078433128481899937372726835913821489150370897525101414670221344908114958355271895129590"
        "1206322014331817626953125"},
    {1e-214, chars_format::fixed, 763,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0099999999999999991294853170555815447380942404303671844696679748417593976294002496024747640399247703645613"
        "9219669145746563738570562978920712197817481457391341938411132808559707770852376293656497482700456956882004"
        "0834461538432173005728133703533459726557209837131653219566175297137847666946046014646053306115669486530319"
        "1549347298089165733677047427050182759982813113559251953651435370993927616364020573917965857675783303466730"
        "5268247784355081422352221012897456633272684485689532862584208239791227856442081540328491173763580945887952"
        "111661434173583984375"},
    {1e-213, chars_format::fixed, 758,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0999999999999999954171883830979807646462457664597374480277602696589740312335709503814153116116173422821875"
        "4739105896672465453685204134594097641997354763518196711125117027765048609614168748152231178543046833402459"
        "1604649115951648675104072027931121811363903856491275086409322462035869793031218683492314286099010628963343"
        "5184601601072366273437779793645172785535986805036776138497072252227896026840664535117799791666885436571492"
        "3246312718423286410504962999123503102181513251931111118384484751383594693253237511293418648961051076184958"
        "2195281982421875"},
    {1e-212, chars_format::fixed, 757,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "9999999999999999541718838309798076464624576645973744802776026965897403123357095038141531161161734228218754"
        "7391058966724654536852041345940976419973547635181967111251170277650486096141687481522311785430468334024591"
        "6046491159516486751040720279311218113639038564912750864093224620358697930312186834923142860990106289633435"
        "1846016010723662734377797936451727855359868050367761384970722522278960268406645351177997916668854365714923"
        "2463127184232864105049629991235031021815132519311111183844847513835946932532375112934186489610510761849582"
        "195281982421875"},
    {1e-211, chars_format::fixed, 753,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010"
        "0000000000000008608661063232909779895216525359147378687217937631390207040190004322751859491200185919223148"
        "7483210213431527121984203983241976622948337025348415756924164270255549310346734523145150346617408006619780"
        "3675705716738825213682400424000035789768140905045233680154483213952778845764600199401420591442107267582981"
        "9621318565063487077315746770387737980112494725839726484177158755147958908213268211985167937585312266489090"
        "5058431801519740884977218360010076443645211604561509452017228249180630551698825692064076520182425156235694"
        "88525390625"},
    {1e-210, chars_format::fixed, 747,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100"
        "0000000000000043873898055897324950155458825113362008761914838802170307820719070615241641697336759553717563"
        "1399716386523329608757910156156686475202216098192174707121765922553290386891794166100999490773361133801437"
        "8482515978351587486343371821159223006872592231515616676033673706357229921189260073470231573489730687834203"
        "2497478585588919625836612005091909636280741747478504411467800247932849164862875079195075308983463115003359"
        "3217406145785889379433244567589512514871679528973822156752272537178589592588018319929688004776835441589355"
        "46875"},
    {1e-209, chars_format::fixed, 746,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000"
        "0000000000000438738980558973249501554588251133620087619148388021703078207190706152416416973367595537175631"
        "3997163865233296087579101561566864752022160981921747071217659225532903868917941661009994907733611338014378"
        "4825159783515874863433718211592230068725922315156166760336737063572299211892600734702315734897306878342032"
        "4974785855889196258366120050919096362807417474785044114678002479328491648628750791950753089834631150033593"
        "2174061457858893794332445675895125148716795289738221567522725371785895925880183199296880047768354415893554"
        "6875"},
    {1e-208, chars_format::fixed, 740,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000"
        "0000000000009790617015372999419661524305356534508474305344681718696392463071555895614181210808709101538629"
        "9317014369701487094559614177342856068209341696591277063520820095610986410849952974964457928628136726878610"
        "7392870031851823895858131727587566710787775975461843668795650081554484785388973176651872988184843246859220"
        "5358362884773709440730729953731144728132480145451776225664799647267625896822809123552851457662733885941786"
        "47053338632634301467086529203914974494638270274650781929885279102065975820323728839866816997528076171875"},
    {1e-207, chars_format::fixed, 740,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000099999"
        "9999999999925002899440665452607943933522518999241603409901169133664392113451739069741444839838971662352189"
        "4118120741222031945000987799853887146485996889950967392192910067087537015042366073980296044936620173271678"
        "1407990024339830589910929702587154354964069389812802594251558548937082527074825218399829427071649638547547"
        "4047490419521194981082357312025652079459028731275039732335201145229557831098452706078256678501822520030527"
        "21823215230505509587922520378271037011702981119991813615245049469415494769464203272946178913116455078125"},
    {1e-206, chars_format::fixed, 737,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000"
        "0000000000287448618685041775611467192411468067474871960285579656441116238100310015816652007878432741726553"
        "5493345146977353453580801839986912678504489355280493380020846005009332711166642793788659897434684305803356"
        "9204162008468756111131622465602620067122836086961830504745239089017417231637691472711696999377193365743421"
        "7691734764507346368173226471971292005784923652206732469228783416975785133762358237484114173771323236629297"
        "10493178880080126376881833747982617725108140959014170254096944001620528297280543483793735504150390625"},
    {1e-205, chars_format::fixed, 731,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000"
        "0000000000108033855441385090695930971617939141258485306125427711618642104781981975760643786814417768719777"
        "0101084177088110526285554822674350215326172337416081911963805825736093616351809127258067112830889529802701"
        "1710255377833027212590023483409996624609315032728159548173314624449927087338409957214562717343408376719690"
        "4339132793619072862133189115140196827996872950183764303283108930610633143549365903637015367704970936095571"
        "25569051267401182441733990905766850296205863565885611603245575196297068032436072826385498046875"},
    {1e-204, chars_format::fixed, 730,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000"
        "0000000001080338554413850906959309716179391412584853061254277116186421047819819757606437868144177687197770"
        "1010841770881105262855548226743502153261723374160819119638058257360936163518091272580671128308895298027011"
        "7102553778330272125900234834099966246093150327281595481733146244499270873384099572145627173434083767196904"
        "3391327936190728621331891151401968279968729501837643032831089306106331435493659036370153677049709360955712"
        "5569051267401182441733990905766850296205863565885611603245575196297068032436072826385498046875"},
    {1e-203, chars_format::fixed, 723,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000"
        "0000000364909283964494690243191939081376830412598520594029984319306805834501324924016544053590211885834786"
        "8651431172545325847430820148366422456613549311381232891696323291335249035452120486258789557131004593821225"
        "3440220260683060295956098435873780428169370394754578725053224457696098050769606268964403117192073603428532"
        "3924780348069311122000588899328256220789832219472160120915723671907243196436298677829712131554556674824299"
        "153355310153286540401954520562788798446562476933408003532122165779583156108856201171875"},
    {1e-202, chars_format::fixed, 722,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000"
        "0000003649092839644946902431919390813768304125985205940299843193068058345013249240165440535902118858347868"
        "6514311725453258474308201483664224566135493113812328916963232913352490354521204862587895571310045938212253"
        "4402202606830602959560984358737804281693703947545787250532244576960980507696062689644031171920736034285323"
        "9247803480693111220005888993282562207898322194721601209157236719072431964362986778297121315545566748242991"
        "53355310153286540401954520562788798446562476933408003532122165779583156108856201171875"},
    {1e-201, chars_format::fixed, 720,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000099999999999"
        "9999945839818400838286643877890376724456471851854624142271863625376172236531891325900070089021825036064707"
        "8131670538558640710995517318203609118298145276224615168802705395697729075782861950146917558335246313038824"
        "5863311858939236135449819299603843204043056259170152128551370517542139943236326734358677709290961889224054"
        "9533782349452735577549479293830826276733698466709185184735730814678536219704539366158320724745122774033477"
        "753696070790004781196766668518623271037326465104921879856192390434443950653076171875"},
    {1e-200, chars_format::fixed, 715,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000999999999999"
        "9999821002623990827595960544117892897470996150535982465624909474979367219721317562018041970215704550302992"
        "9362492249482183238301163255790637355208596209840847691345548908285988635545366204397328202413315406723085"
        "1267975426859535195138290147135230492006495456852402792598006183692059967260467991913313132575212706757286"
        "7114833324440862265532435494287445976335078589119159474703853650968495892746707328834776970293406573920527"
        "8643004860546448479624082362272590048489495639927326919860206544399261474609375"},
    {1e-199, chars_format::fixed, 714,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009999999999999"
        "9998210026239908275959605441178928974709961505359824656249094749793672197213175620180419702157045503029929"
        "3624922494821832383011632557906373552085962098408476913455489082859886355453662043973282024133154067230851"
        "2679754268595351951382901471352304920064954568524027925980061836920599672604679919133131325752127067572867"
        "1148333244408622655324354942874459763350785891191594747038536509684958927467073288347769702934065739205278"
        "643004860546448479624082362272590048489495639927326919860206544399261474609375"},
    {1e-198, chars_format::fixed, 709,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000099999999999999"
        "9912480209922453371527875490677164389094309711567966324486489024148909926870130022474709662059250616363651"
        "1458147080229307187686231418190870453248079045903136497403860177328871032921253477527517381647903616019374"
        "0905029892256142110930361702937746498070435576271029899614824781239174025784274712636393641727258288515133"
        "0297445100692980466016178680741421505873825882672883019848628293687919700018508771176310243642321343588723"
        "5808111997818538852504458228488519455634531141186016611754894256591796875"},
    {1e-197, chars_format::fixed, 706,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000999999999999999"
        "9867415992308580521339330065300981042999687430669319116912447295225761084825312804261628455378686578950031"
        "2352968060842582729449985231219265253670571132968779770316262053501963893109782372131737653104498093944552"
        "5237102055333446740222582475620693808214863591715625504796712750704515727309674899109745652408715015429070"
        "2290582669791096257253741452781427086834611138654851004211475503937005796475478242977894817205464619503906"
        "1999776584332685697351547605103705418372328495024703443050384521484375"},
    {1e-196, chars_format::fixed, 703,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000"
        "4615071067758179661877901921244507646449596826610438145504929382150905377245228678732539232076309112008470"
        "5701658676821914115201220706677138306223956721187116073383902776725667442275804496169887224048676409452018"
        "1865445615510672449577548326152768702232698549198867117154847013547361028832171173063930405176207196512621"
        "7434880000801295349273051690751967093116929881956676487916295575832528335077906679497287218312655663972425"
        "1347018692505234351971198612785141079939421615563333034515380859375"},
    {1e-195, chars_format::fixed, 699,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000009"
        "3677999834960792206655829358322654196117748425442357266092945260655410004389091876255429747078637700149971"
        "4392411315387835717623154222647269218385530343865707695609285700904902512181891160518957784516327854572125"
        "4609856652516364874589271821094331982999486548329567725050226187491240334205089186371095100474528302901573"
        "0581226431135615706615614211021240729335846782832096445575280050025046313364060792719584553190632391191156"
        "426420971847936254735776662183610596912330947816371917724609375"},
    {1e-194, chars_format::fixed, 697,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000017"
        "6343371831543992660529331249185298255229001705015959684231029580212400332902037339673698649737631720455462"
        "5910920399179244126456387732458513685519893326744325567768730070677375691037372424068209140690258384890157"
        "0812158566609402684872101257877000459234848581841332394474165042630322607916852572002294225345981624610040"
        "6093441541393561643994585254187290522693700416075659393155611833054255732280703963248447610881111888441082"
        "9937732489961321031245178314605936975567601621150970458984375"},
    {1e-193, chars_format::fixed, 693,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000480"
        "5180224387695644229409161828017957376083947247790048749103987907490802172975899088259381781571298328731633"
        "1161975010588893463664495300641850848540573715094261230983808460260354633499880965167566224794664492225960"
        "9267217500311011092803480391035282075388553424230703368854037755431549015704682886857569371057021863723165"
        "9809706493785998128592079965973372309596073809737814181944872999327386928246655488274067792911966978292755"
        "019478367894242808178173476107986061833798885345458984375"},
    {1e-192, chars_format::fixed, 689,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000009671"
        "9746341033047924279945207658819170941542355639987717999738952760776803233047401946952142362832681274148446"
        "4464086406632169822254840623325932378871984313358701162582208658389109905017317243443259334219935215449851"
        "1002284350581858833354288906597260482526615935385104474338574820368657141625343537929727592125508519195818"
        "0101722215466088304260438445341196418505852481077665825668804693831142969500408575374144874733239285038351"
        "50271772586917651270965734511264599859714508056640625"},
    {1e-191, chars_format::fixed, 684,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000018851"
        "0357855833015531025794646529958154524177425806481491858204348633867528277859442439788230874411644952170619"
        "9131483254429935252790204362740541493259888534929589981916101691322081929877050966151039961826707463454641"
        "6741093946270621848431129126061569167008852264601912170614591946835899662997200669632733816370447080531648"
        "8942705712963170749170163883692391024336694671584274157166851729395050702462426671605977617515280816610694"
        "100232507863790232249812106601893901824951171875"},
    {1e-190, chars_format::fixed, 683,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000188510"
        "3578558330155310257946465299581545241774258064814918582043486338675282778594424397882308744116449521706199"
        "1314832544299352527902043627405414932598885349295899819161016913220819298770509661510399618267074634546416"
        "7410939462706218484311291260615691670088522646019121706145919468358996629972006696327338163704470805316488"
        "9427057129631707491701638836923910243366946715842741571668517293950507024624266716059776175152808166106941"
        "00232507863790232249812106601893901824951171875"},
    {1e-189, chars_format::fixed, 680,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000006868701"
        "0541071139230656093540176722762965457494938625473226728286317716385087153277173881747423691735233733148042"
        "5748697404066355343545355987256216235425947807033983401593202256625288686656870585123412526520006572271804"
        "4141366438132039890265548760463198829352880172135701718813195122032958508119088381804076349661547184462886"
        "7039623564970661696806504831291784719866596066739998086041666310153325768908848417267914059823251822529949"
        "34771483936941649517393670976161956787109375"},
    {1e-188, chars_format::fixed, 676,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000999999999999999949080671"
        "1279003288045276597589197780889341620892794798955285494428273252676646716781421147290166903654612945415195"
        "5078046974915631886855486755712556527769214532540188976339227580242590091726130570768133012817820279334756"
        "0646340915643877770992219901281217210305112634689385411635940697697772079614369773304090393811332693476932"
        "3938981202020534253102253223653472329934866867898003995860822205975125145100134012595485199148434350246549"
        "6900111219247264671139419078826904296875"},
    {1e-187, chars_format::fixed, 672,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000128707188"
        "1492476103179615777559014858175085297229769087030091149268886719695666186429239047216709109600659513166516"
        "3628080766478567127744590846990129685640217526999996641220515727814150383088373870166622140883511824725097"
        "0555800973380223745459626764016284546910801475787890257671463097680723471218439304969827153068735740912975"
        "3828502407864450344157439379278055932581168942990583236239373502727958352272540979734347453266124169414530"
        "431510002017603255808353424072265625"},
    {1e-186, chars_format::fixed, 669,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000099999999999999991080664251"
        "5685669468166560948917555793244147559468553310665132212910400110089477566451949283126449927134114187432183"
        "0719031387629699130410335832068266329233020044430256366953318471929512377650648101901549205550173745210388"
        "0079740662739100885997423620897046367353212695574324315721733045559191910988527898835500091400816510831330"
        "7265977876098778431415879508887237194091685205737139920295311939652273102386196136871547144152751022960767"
        "812719495850615203380584716796875"},
    {1e-185, chars_format::fixed, 666,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000999999999999999992457903555"
        "0769427190702384102556300240495118897318633583737556367331737795832250047243022343589628622320989428185675"
        "1684524093544768480387939423346907509683442248860244031547895168991055402371205817132869681781293468428540"
        "4623559195896101408764988363096856487570543454179869245160513905576261519452200195257172428300492294700692"
        "0812148381353584395426909360018948994676885850720938739740504097541214386575670652490890549595435599083970"
        "146239153109490871429443359375"},
    {1e-184, chars_format::fixed, 663,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000577789123865"
        "8996131979318037932608940869380335394251139654065437579139271517822295534218459534497321031048674712767507"
        "2798922673429902214156043054783028835660356925063883211596635287478007030629856556267717828049382814882687"
        "6844812507001754477975900863979707388012766529291701155150606655637354471057371607789096397343540438105999"
        "3340440776462244604414007769362106376849128854005703691704118583560010767466380795112258360497758946650037"
        "614745087921619415283203125"},
    {1e-183, chars_format::fixed, 660,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000552210532137"
        "9546439214826804069721900978370182573992966007135384544817566702224594847878706556164931847776503680389028"
        "0359772830441282859347239977318658445996093758947288947024884094240446250956178483165010198602243104048612"
        "3574360685691621657150870775707933781669009392972941923142325757375630498290758836151987058726464452267365"
        "1652752061211240842980764340240132327849125765686506562648564970417172460986413789495760688630365820017686"
        "928622424602508544921875"},
    {1e-182, chars_format::fixed, 655,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000047327550973547"
        "8783436775096642748159071507167196688077104339505775420776854830232832433234175872115546179446984382178638"
        "4633359535274742851177924337279623744820741523005234821780591186721454952300881467747446641155111398712239"
        "4733721931523601552373810669792458604359341129281976258333183965739618681171246295431685904936163953014677"
        "0540766239402050039082150229448774803628559851829308461626616625635206319283291187972190217081447372038383"
        "0368518829345703125"},
    {1e-181, chars_format::fixed, 654,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000473275509735478"
        "7834367750966427481590715071671966880771043395057754207768548302328324332341758721155461794469843821786384"
        "6333595352747428511779243372796237448207415230052348217805911867214549523008814677474466411551113987122394"
        "7337219315236015523738106697924586043593411292819762583331839657396186811712462954316859049361639530146770"
        "5407662394020500390821502294487748036285598518293084616266166256352063192832911879721902170814473720383830"
        "368518829345703125"},
    {1e-180, chars_format::fixed, 647,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000000100000000000000002057206575616014"
        "5924821392633743555743200414935928126274000788854023831209463312122670238802527341716045037053793207408927"
        "7055554752311772624638861626007860251046700554453379680027103035857978894785962064514606187019596944752529"
        "8004828377487516462014480565606130025102292156833976111083107487029791428250521772812410162639151759642079"
        "7228903793667940914646586013840582754068644705219304713639779589857802525503308044285688538366230204701423"
        "64501953125"},
    {1e-179, chars_format::fixed, 646,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000001000000000000000020572065756160145"
        "9248213926337435557432004149359281262740007888540238312094633121226702388025273417160450370537932074089277"
        "0555547523117726246388616260078602510467005544533796800271030358579788947859620645146061870195969447525298"
        "0048283774875164620144805656061300251022921568339761110831074870297914282505217728124101626391517596420797"
        "2289037936679409146465860138405827540686447052193047136397795898578025255033080442856885383662302047014236"
        "4501953125"},
    {1e-178, chars_format::fixed, 641,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000009999999999999999520780235996475509"
        "3254973303558352972348764236955198179673189484181712023085285155160314218797407492929839348350198064433601"
        "7773388789574064216571704500430381961642408451391728506514300696193707641236920632565789008124705298570090"
        "6437455381356119707601934668842017337283098214303282216076742448367510473280588070058851533740829256847796"
        "9874021853305965111138747038612487557305308227775860414375917728095925426923251677635562373325228691101074"
        "21875"},
    {1e-177, chars_format::fixed, 640,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000099999999999999995207802359964755093"
        "2549733035583529723487642369551981796731894841817120230852851551603142187974074929298393483501980644336017"
        "7733887895740642165717045004303819616424084513917285065143006961937076412369206325657890081247052985700906"
        "4374553813561197076019346688420173372830982143032822160767424483675104732805880700588515337408292568477969"
        "8740218533059651111387470386124875573053082277758604143759177280959254269232516776355623733252286911010742"
        "1875"},
    {1e-176, chars_format::fixed, 632,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000000999999999999999995914210579815611727"
        "6035951784059463761038168120327142621839870096294152571635463170860840212881656728162453684883657736746979"
        "5392411220011109485295768465799357318010252751732178407974254554038401714686355665848001217909837164713986"
        "2650009648925666366345267957544784796861339452365270710650645131895517841440516521543696105241114955830918"
        "044906619383659773914538196977917810231720960348114221212241330138947859040854382328689098358154296875"},
    {1e-175, chars_format::fixed, 631,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000009999999999999999959142105798156117276"
        "0359517840594637610381681203271426218398700962941525716354631708608402128816567281624536848836577367469795"
        "3924112200111094852957684657993573180102527517321784079742545540384017146863556658480012179098371647139862"
        "6500096489256663663452679575447847968613394523652707106506451318955178414405165215436961052411149558309180"
        "44906619383659773914538196977917810231720960348114221212241330138947859040854382328689098358154296875"},
    {1e-174, chars_format::fixed, 630,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000000099999999999999999591421057981561172760"
        "3595178405946376103816812032714262183987009629415257163546317086084021288165672816245368488365773674697953"
        "9241122001110948529576846579935731801025275173217840797425455403840171468635566584800121790983716471398626"
        "5000964892566636634526795754478479686133945236527071065064513189551784144051652154369610524111495583091804"
        "4906619383659773914538196977917810231720960348114221212241330138947859040854382328689098358154296875"},
    {1e-173, chars_format::fixed, 624,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000001000000000000000040802466047507705981738"
        "7500126561010283827794411329843068069293894692053641056977569406164586017945941785256987144241461175064587"
        "9228256918309821296094530706786339470126146992930030675499927138062607864511092939560033079687847803826280"
        "8188478558890667044712256648069091058093906931208992098479034123455647143387065578043861947100769387366612"
        "9072197794446443422556352914330611026469713197725405241789164989540950045920908451080322265625"},
    {1e-172, chars_format::fixed, 623,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000010000000000000000408024660475077059817387"
        "5001265610102838277944113298430680692938946920536410569775694061645860179459417852569871442414611750645879"
        "2282569183098212960945307067863394701261469929300306754999271380626078645110929395600330796878478038262808"
        "1884785588906670447122566480690910580939069312089920984790341234556471433870655780438619471007693873666129"
        "072197794446443422556352914330611026469713197725405241789164989540950045920908451080322265625"},
    {1e-171, chars_format::fixed, 618,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000099999999999999998334549904886182533644575"
        "1824815903073465707275884638649689563143274274027219743913926814938840349574834806876025069429390711572561"
        "0244967709339121567716762527719200148820105916795361790584957049666459647214626236474966227897344883106057"
        "1957662836356214942355379586519448624820508680799184525163927169525584371276921407873336343892803511244586"
        "6451272840010194777314250133539987861677276049891804898805958146112971007823944091796875"},
    {1e-170, chars_format::fixed, 617,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000000999999999999999983345499048861825336445751"
        "8248159030734657072758846386496895631432742740272197439139268149388403495748348068760250694293907115725610"
        "2449677093391215677167625277192001488201059167953617905849570496664596472146262364749662278973448831060571"
        "9576628363562149423553795865194486248205086807991845251639271695255843712769214078733363438928035112445866"
        "451272840010194777314250133539987861677276049891804898805958146112971007823944091796875"},
    {1e-169, chars_format::fixed, 614,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000010000000000000000201179579279951889494332706"
        "6503362976461263346164357987024467754083903008282675437345564791148767438721478692254625644809586029974902"
        "9663114719064671442799974430463814164864567756829347660592137388682880170721357697310494206530360280015299"
        "6738639009092824083236212756882922294542672246320073171719768219062755043188870164156569825065005551127725"
        "431170669760491634397165652335013242654640323869852380767042632214725017547607421875"},
    {1e-168, chars_format::fixed, 610,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000000100000000000000004953592503130187983982328573"
        "7207811117530174410250732846688769058890834927312362741078714289605534237118770959763206063059979281499433"
        "7961897471866831796989517572988535911477486186638825422692833263124125301283449371615913399670578555429637"
        "5165233078698879613948160408333701445361155794413696959814092322662093755862536656149181736927290924629741"
        "65924485487326723400897105883120943360144183831295094933011569082736968994140625"},
    {1e-167, chars_format::fixed, 607,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000001000000000000000002467177666011174415199261621"
        "7291209528621088924792880843782226300079471761353893528818080846169584772723965002160866791173889106987871"
        "8326970219146440066058803436279050909465923972862673158584982610516075507716535339983592646834173469870122"
        "7190842982658575634105078651265358454660624644729525716278361114068244375044006328156081588837142632657619"
        "03183803243905809949267802061486222313380078929867522674612700939178466796875"},
    {1e-166, chars_format::fixed, 604,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000010000000000000000401221755582437387548984809141"
        "1207308459656130669644389422665977311425737707696806343933304860781908514949606785378218627146120733930447"
        "3605738187639423891279012711640974737130742876831380132596626270962175118109020409240257267314631374111246"
        "7600332261227520384062989969226832538213712842554808217684108041103989219090945148246702131857559235694570"
        "80326445473949491970304074772647913438294864363342639990150928497314453125"},
    {1e-165, chars_format::fixed, 600,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000100000000000000000999817724445768728313910548020"
        "5711379208999375322719246347910058629209216323705094993313077415130598847816413743625780548203370026890641"
        "3369093906994053067262300325606022231535403582676612951991861383210390853540868017167926281363140337832311"
        "0468103135141091496532272039682341449277397263471673737637105207667528441702396548979931370686529083998664"
        "1535715046036377988203231446419361194699604311608709394931793212890625"},
    {1e-164, chars_format::fixed, 597,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000000999999999999999961799779942400004928324104785955"
        "5326505889002851247598097419105154531321591184843454796811235068290207651289671673755313909908303270285097"
        "0678331559537557144177774603200620079001632856571115536328192609522143294619302967924920545100628925840605"
        "6117519717265117459760677955447671567018274041494202349107448822717464429711086554005874540640278472833939"
        "4705463613753956168418821244536776049471882288344204425811767578125"},
    {1e-163, chars_format::fixed, 594,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000009999999999999999232410621007538590444721042305553"
        "8966769282101296639226045711088091227051335430774586877556038018775829897900990637533206522079856713880440"
        "2682455512151783214215916809129382899197104804151043494558556314567311019878012049214467302760093638546017"
        "2667104099484794553110440023470772264137151669161743272965662195512084398607834053711232076602685791117778"
        "1841141364660971975280266688113073314525536261498928070068359375"},
    {1e-162, chars_format::fixed, 591,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000000099999999999999995408803637407077575155370467487550"
        "4054009684430693086299884950588544959829965649025557500010881500768271898975715175491525836823975050568645"
        "9631435787308137962653801874308372118524838133991329895372521390906085609300261532422578213570501344340483"
        "4735785580178985887075116482755269889736226657859674474527230208421323174102592427892427404427649408950714"
        "0119371829638437424066232939168230586801655590534210205078125"},
    {1e-161, chars_format::fixed, 587,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000001000000000000000028120774630031375848549545741243778"
        "5811701566332371519945117658868634141898328680968104386920846519922069068936562958742313152849540388028298"
        "3679493852048719318409229535432756222539343559454777748612211794652265945486000290895506598974572456532294"
        "0911725849734827414048354780693832858115305768410546622166900163424732253607969657646833365895490036057512"
        "218471468907359835098791478458224446512758731842041015625"},
    {1e-160, chars_format::fixed, 582,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000009999999999999999886366475601857224634850971725140321"
        "6668457145854698362404413106109357186457035125880887139544297133944156933742103167012172677243191174459843"
        "7514213299328048160779171128466042026508303756993223913391462556701806908281949753383202185641409828643157"
        "6829951574975108576231868056852280790470182005098522878231145211785986468975454556614683943653588645639804"
        "3228499463060121588142692417022772133350372314453125"},
    {1e-159, chars_format::fixed, 581,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000000099999999999999998863664756018572246348509717251403216"
        "6684571458546983624044131061093571864570351258808871395442971339441569337421031670121726772431911744598437"
        "5142132993280481607791711284660420265083037569932239133914625567018069082819497533832021856414098286431576"
        "8299515749751085762318680568522807904701820050985228782311452117859864689754545566146839436535886456398043"
        "228499463060121588142692417022772133350372314453125"},
    {1e-158, chars_format::fixed, 577,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000001000000000000000064446171534289376962808838424475145282"
        "4968949939521068953419899265716691290743835877718806049949981927510174453927389420121367164743956964027241"
        "3320572395360660554036964212016080836775688509796677303432090515784379771181181208118068952169412306834148"
        "2158086593158645959509317701749254858130330879185409763182954291175171781559923473369139703210713831561461"
        "76302524197776477876686840318143367767333984375"},
    {1e-157, chars_format::fixed, 574,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000009999999999999999431509331757235297638908524213373642971"
        "9717733730390966126541574180671350586793186143106586971175522745590047263800730698748080600642137351586554"
        "2817844552713093922452020273570757392631880130378197605747547628184774624032518164415083313239251988047403"
        "4974000401221846213932984753153735603509222882524146590734613110527319671367749743279471626477550034318145"
        "98176263775286543022957630455493927001953125"},
    {1e-156, chars_format::fixed, 571,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000000100000000000000004018712386257620752302524122384758908543"
        "6951462622467448526675089618678004433093242503717657938349599691994050841792615007205534380800831825352415"
        "1281480734279032167861177508427981727318841044490579486062336519119930942559532978275682800031488522826664"
        "2594928255135369188611385646247859857444916099881074236105569515068381867529377356090119509812206593553233"
        "00554463372691316180862486362457275390625"},
    {1e-155, chars_format::fixed, 567,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000001000000000000000014310806346082160120589404209844862475239"
        "6783625375187052570059302021541381490502075510105144112577670957024299874498662019456068142996429428225825"
        "1206713457062073829702509023692063137188304469682852384391737891806816886303726225090562219944302181992964"
        "5002817903575273088029754823250588381508661599771786817697192724563324931688760432113453111357515934540934"
        "8876643207404413260519504547119140625"},
    {1e-154, chars_format::fixed, 563,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000009999999999999999729086983196916842766920649874404998989240"
        "4140240160071602553527513571595209458135162667908476791083494163583662050146811352972270789774073077485032"
        "6337632398968772714476833267516565195881349093261444224211342127788288234371605328245369713513693079550795"
        "4884744671298030110951922004857720728038625613094579483235888427705349419207394260530659325342359329547026"
        "192130942945368587970733642578125"},
    {1e-153, chars_format::fixed, 561,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000000100000000000000003915207116191644562692780774328748002102906"
        "0538619069498795888323242017049781731521105609372197265926388142386007618905054995137278140784270051221823"
        "5048358736119176465540444185630710774840620589687716157410009922360972402366564045017736910006190641569547"
        "1142396544255513419049239690947816673154102284918413932135505363899892554957303574968541865148393549267424"
        "8735056607984006404876708984375"},
    {1e-152, chars_format::fixed, 557,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000001000000000000000065649420298806350167022104845626272069871068"
        "1931060570119040295424845374888565915888971814871690079629667450057624658798315813031062380016857617704223"
        "7171726346917561938492887898167343012514724525170257235286453801522084258267683500433528199538945799941840"
        "0603764767655983428612475478960604302612407465074615720461537986384519001106479628333213098383136507862900"
        "543841533362865447998046875"},
    {1e-151, chars_format::fixed, 553,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000009999999999999999384621444417348083745694787544000702354294314"
        "5156851694898495169012043938129726326349763533530464618738945243093920040090396770713137135809035113714781"
        "0686592154337349796683468972382137447938351093633980615919518275427551321778768592039645220491567555592692"
        "5407280071719070856360983454449039614697613088003290047504131189336704337459490108237997532669716349573718"
        "61673891544342041015625"},
    {1e-150, chars_format::fixed, 551,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000100000000000000000629535823217296399721087933638737788046497104"
        "7055204982541793211381291705328905037044059949632305801030675137511608656332028291651300234674570141560909"
        "9029501889177602437476876440041602091164279779372295422901954699839733275910706785973181671037757922997368"
        "4101427943008113522349948331994414341250592547994858646301304824078966967156534016215353732892623384032049"
        "216330051422119140625"},
    {1e-149, chars_format::fixed, 547,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000000999999999999999979162072715997701748154319103592454822450755208"
        "8605297691190566028769507757162483276254901039012419555741860548826453541608040578433286840408825397956702"
        "1640697508559606492200017535535110464519722421592997174192459216140452526614984397424898845889249761691912"
        "0899770526811515388539028169928070635408078808100753777973076517941975301318808426812023704144394287141039"
        "96753692626953125"},
    {1e-148, chars_format::fixed, 544,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000009999999999999999357488158901172821496638227311205779296280098677"
        "4904942764267802927000528833599759255577835073153980284380352267630407068684528375057420302698237697128671"
        "7937832954133378800900225517256537491228018261850658864691187645294441546276508577338302627079226124410768"
        "7165562815801236526022999299023541920515241331442214819091217613856643089243576502656019044934510020539164"
        "54315185546875"},
    {1e-147, chars_format::fixed, 540,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000000099999999999999997047942135082161782845621982909807944388620614063"
        "8233700823780888155561678240198180611547753267301525028109548441377097466012303024777787838102507230793516"
        "7131466593035276977801853877321912144033830251141091664779112581825085221751768948668512925298433184174504"
        "6312767776523704135168252192292734673676787310944731876028556663071310283991827150273934421420563012361526"
        "4892578125"},
    {1e-146, chars_format::fixed, 538,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000001000000000000000026048390087948554914524055185862081866699320177260"
        "9285379135454623724519020869191215007787973245202805229991896654939403126795338635035235358947156460043947"
        "5364858757576593278812118049323717148396664633562964933666903880341568361304620291252915725083082882814125"
        "7641911661418463350694669155844394233157857053808657722147655022791173104815265482159247767413035035133361"
        "81640625"},
    {1e-145, chars_format::fixed, 534,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000009999999999999999149104526136946807423883844723340770210730921040155"
        "3886373401631393867145439347723972231670921008276953321990721726025461934507218605205214031029881558263867"
        "2644731031289462772249594971145257322799403892588683619153477561601360737307586821173427808855808006759668"
        "6134438690556193526703746900102992403778891650859797984234782386350325750212775233194406609982252120971679"
        "6875"},
    {1e-144, chars_format::fixed, 527,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000099999999999999995047459260545592047747179910066303857167348508745406"
        "3559471465641437481197655378641891424577406702773049949277600695034041212099922836522986897312201317600618"
        "5659651255219331773285023382146698543729214743617926487584571589819440575439439704072612302878146696017771"
        "0255356261172943203814891907720963806747888947723673401521480956499754455535367014817893505096435546875"},
    {1e-143, chars_format::fixed, 526,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000000999999999999999950474592605455920477471799100663038571673485087454063"
        "5594714656414374811976553786418914245774067027730499492776006950340412120999228365229868973122013176006185"
        "6596512552193317732850233821466985437292147436179264875845715898194405754394397040726123028781466960177710"
        "255356261172943203814891907720963806747888947723673401521480956499754455535367014817893505096435546875"},
    {1e-142, chars_format::fixed, 521,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000010000000000000000415187909843646941992853405491851801412104911250566867"
        "8055933591983443414040584623144434071999004998205277646578228806936119169092900476835416006646879910320012"
        "4324406757057414330505197912365935201126483700951764547204928276237357349018272445874789153751726477574834"
        "6743781153712352196509454885002561528285839188544891300604311457078665625886060297489166259765625"},
    {1e-141, chars_format::fixed, 520,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000100000000000000004151879098436469419928534054918518014121049112505668678"
        "0559335919834434140405846231444340719990049982052776465782288069361191690929004768354160066468799103200124"
        "3244067570574143305051979123659352011264837009517645472049282762373573490182724458747891537517264775748346"
        "743781153712352196509454885002561528285839188544891300604311457078665625886060297489166259765625"},
    {1e-140, chars_format::fixed, 517,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000000999999999999999983250504021863079017324674022131009536706807260991007919"
        "0630989416603842570455469741304743887367077682909670653460685267564047526850570913191119037376109415479269"
        "7446676657790264922336770584044347107527772388993044240635592788964547377071914116211147955201007706428611"
        "705619304048118348964858527426057820477947621912585655923333405326047795824706554412841796875"},
    {1e-139, chars_format::fixed, 514,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000010000000000000000298651335918643711628932072437743460203097543522435510082"
        "6008852419962416373378637998156745373938153930041458569504416084023430328021523294715043392256147086968485"
        "4418758961511994248831871060836855116242505539397726245213806567814973968761784932253618911783197472724962"
        "913730905084412418686107855057037903823030327416475360191583376945345662534236907958984375"},
    {1e-138, chars_format::fixed, 511,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000100000000000000006715683724786540487934803382108901520719211202524558547961"
        "7680190231016089084377904662441905741520556107972601974224668107297943756341746249581258070521894327091158"
        "3803528683994702692032032371515623490143308589715533163001095103505741271958999483673303996016937994760395"
        "997611967669955619161259196942056630578736140489704009581828358932398259639739990234375"},
    {1e-137, chars_format::fixed, 508,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000000999999999999999977656748473462923959856450035533809158674453610040702748359"
        "4601917556754682429582454283432209363869157698333629041914506663452066136381143237472801154168780293160288"
        "7252749186952782031200601399626499036195009199436834569298244826513374695402390969442282883730261527345555"
        "328849672879601816408256456500304089424972613098230311834413441829383373260498046875"},
    {1e-136, chars_format::fixed, 504,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000010000000000000000015234388133035855383875390450151974382791625207620048100283"
        "1885801576630046733682122410287021775588652667049332286697531726593651835908283730300757011154904205606340"
        "7947592277512473349658606837677619335918296521617671188216331487917848351857520007198181041140264394144632"
        "34788340564922983129412593279040680454942957577912920896778814494609832763671875"},
    {1e-135, chars_format::fixed, 499,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000000100000000000000003971014335704864406403728146018541868564669677791608810869849"
        "2724031911632026342542497318309067946239737609901992747814758739104365912632458992171497623022662440118664"
        "6197529302879182099027553839378256942674237652165919805905446443724105883912965076387445672805029872471588"
        "429020886143684988326241212501922610289550874540509539656341075897216796875"},
    {1e-134, chars_format::fixed, 498,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000001000000000000000039710143357048644064037281460185418685646696777916088108698492"
        "7240319116320263425424973183090679462397376099019927478147587391043659126324589921714976230226624401186646"
        "1975293028791820990275538393782569426742376521659198059054464437241058839129650763874456728050298724715884"
        "29020886143684988326241212501922610289550874540509539656341075897216796875"},
    {1e-133, chars_format::fixed, 493,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000010000000000000000641496342650454815204531166058943602839619187024947014198474039"
        "9828224464422410620411217618993206806579261112354147155200128193178834690421687323641123036577948591402888"
        "9935748064202920459010453544357763610865201119901287710041064503330419772913467920705224010255686832775799"
        "714045712057246057262961864454953175851414926000870764255523681640625"},
    {1e-132, chars_format::fixed, 487,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000099999999999999998594326335945560165992244413962574716935320854384313882417088792"
        "0681179005191262486944630971166878222416607214585555592825144884036557234591653828687686867804939368863225"
        "3507311800918466789942308034551417118526062293115049276525200843869593517391950184311224750470481588015379"
        "157829994532549384186718988143383057831670157611370086669921875"},
    {1e-131, chars_format::fixed, 486,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000000999999999999999985943263359455601659922444139625747169353208543843138824170887920"
        "6811790051912624869446309711668782224166072145855555928251448840365572345916538286876868678049393688632253"
        "5073118009184667899423080345514171185260622931150492765252008438695935173919501843112247504704815880153791"
        "57829994532549384186718988143383057831670157611370086669921875"},
    {1e-130, chars_format::fixed, 482,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000010000000000000000860474181186106478814017048964495719560523575469171389466368285000"
        "1054302315330244491908885118632122193789221804912802057060030515884801171193467057382254521235894667527601"
        "9552791754021117414995911810497742588727689266426889109856940634588690842264333341972440114105661488593017"
        "5592715863635705393630548343253394705243408679962158203125"},
    {1e-129, chars_format::fixed, 477,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000000099999999999999992588077050396257392703488768553145229733371914199873875069132357308"
        "3560594414038512159956243155212422703836212507412136177871631363182768319485323556005461360487622175994949"
        "4382130945420159417717384419280934109333533385517507781179706383817482773534294846124960068136571893048547"
        "17236173389759146257205202346085570752620697021484375"},
    {1e-128, chars_format::fixed, 478,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000001000000000000000054014088595681033090528341454265948024308629865933458907447727514625"
        "1465374054496583672623295800994620910810169407848436920545703997149630334448011702591284419846817754198055"
        "2987602212529712035107713678381275316882208085186144350914663534730232928215257050045129264726062873538499"
        "086450376880826074188490792948869056999683380126953125"},
    {1e-127, chars_format::fixed, 473,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000010000000000000000283874249773373412578296507005190488789136477211465148760964467263168"
        "2934880716742912580111229512205421363205605411030218921798259240852409065290564740839502568526985553483431"
        "1543436608640884635209397812668884721728332391839310430911435954191518896407953322860235480539940849278936"
        "1388376929984378449489668128080666065216064453125"},
    {1e-126, chars_format::fixed, 470,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000000099999999999999994638210139863752739319384028852897161364970485782829397577234820373021"
        "4345292664295553125216983194349005795381216751769380140901609027919473718839974286048093527151711902926412"
        "8791629553409303444326331050085056910283373197684845805587978962369256620251783545688525470337396137395610"
        "1670625040700457475395523943006992340087890625"},
    {1e-125, chars_format::fixed, 468,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000001000000000000000011986360261597378484902488618121033425860859148482870696031627021799506"
        "3481042668024112659332327365131720647210866385956274025663957324031672660925127839256392536462268084527318"
        "1058187798089377705404487113680891558833337742514526084090834260060024953139832920195889383870060217106111"
        "44114044801511909099644981324672698974609375"},
    {1e-124, chars_format::fixed, 464,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000009999999999999999332612496260455571748521106226105592512074739996973786317204924401163559"
        "4473034379418149707373328591617254151324277440413068856865168702273500938946658647258438185280892182114909"
        "2879170812937657908350751782845046116338108237152444502375806964190744523934359642231277672747416053260997"
        "1652195923752515227533876895904541015625"},
    {1e-123, chars_format::fixed, 459,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000000100000000000000005922142664292847127093271541542731793065289023775416593461830777080939659"
        "0128620607349127248932406871371778645792957110525430965042159631426620114340502397472176722277540431681441"
        "2035022816674485414613427491872372715305389379409506440278639824459525358767109377954635382725138417411847"
        "59115412816754542291164398193359375"},
    {1e-122, chars_format::fixed, 458,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000001000000000000000059221426642928471270932715415427317930652890237754165934618307770809396590"
        "1286206073491272489324068713717786457929571105254309650421596314266201143405023974721767222775404316814412"
        "0350228166744854146134274918723727153053893794095064402786398244595253587671093779546353827251384174118475"
        "9115412816754542291164398193359375"},
    {1e-121, chars_format::fixed, 452,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000009999999999999999786069133521234062494411283480245923758078238453978220607637059591658505770"
        "7372344692184393680496946004426688096084017843279583135225716186398925042119620554398800581762452094073827"
        "5930141680382536270564530728234932207383289436306713370547490762619408233606108634384584336451257113864699"
        "0220877341926097869873046875"},
    {1e-120, chars_format::fixed, 451,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000000099999999999999997860691335212340624944112834802459237580782384539782206076370595916585057707"
        "3723446921843936804969460044266880960840178432795831352257161863989250421196205543988005817624520940738275"
        "9301416803825362705645307282349322073832894363067133705474907626194082336061086343845843364512571138646990"
        "220877341926097869873046875"},
    {1e-119, chars_format::fixed, 448,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000001000000000000000013002439022866900658610872163449755279208385506136528780275002732133763542643"
        "8129020374848166460094222106719006225434027923201550599488822107117523601001807666818581738553095234381916"
        "9425474153069848529657060407593031859636613162145711766919388084154269466416907644493801583795988818792466"
        "190643608570098876953125"},
    {1e-118, chars_format::fixed, 444,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000009999999999999999854860184862721051312750771111096249564879361775455634046659653137594331701877"
        "4133794497211277317745247754788489318082330470069609379550593333375080897700058852677628887067865727825908"
        "2964292612168713510938703403131829625904775369662119971831386263835125817720722796655072328597668729344150"
        "05147457122802734375"},
    {1e-117, chars_format::fixed, 441,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000100000000000000002951229134482377797501234919485383347284065510329110800564042518315836176611745"
        "5840492992438969708604050546310060160950484891830439640907977138553290774088873574907304846088043134151261"
        "0290108818163483679497444796094119786429453725341162876113775881672359720380886339077819435772198630729690"
        "19412994384765625"},
    {1e-116, chars_format::fixed, 437,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000000999999999999999994291273057982439700022531527858466659758479962694672324860857287639218889373684"
        "2384545761780124836827921475699265768487407389229629645863420947113053364182455364024920657605344494375185"
        "7723626609824048234091161842734609645240937023651923498738452870154784858419596410561425159357895608991384"
        "5062255859375"},
    {1e-115, chars_format::fixed, 431,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000010000000000000000506449023169285809400062397950510535606899601876489694141081659204698474921637188"
        "0171604219554404355680558555414031141153138357492564670095816485848203669125039801019251428454834497950650"
        "0075651247213099315044196318651507957266973912674519185773423846648846110424235789082558767404407262802124"
        "0234375"},
    {1e-114, chars_format::fixed, 430,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000100000000000000005064490231692858094000623979505105356068996018764896941410816592046984749216371880"
        "1716042195544043556805585554140311411531383574925646700958164858482036691250398010192514284548344979506500"
        "0756512472130993150441963186515079572669739126745191857734238466488461104242357890825587674044072628021240"
        "234375"},
    {1e-113, chars_format::fixed, 428,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000000999999999999999978512256865477520152827093213044542327497665499707469139871610870446642880592474560"
        "7413656931036469180683849343467311711593584204134135942495950700958603418041751523359401738105586857619588"
        "4123825652814958815449661778058123104924120719575541183563806091956927685204803424312558490782976150512695"
        "3125"},
    {1e-112, chars_format::fixed, 424,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000009999999999999999496591986848970958379554345802419378342207476245308690301769888504373610359639768643"
        "5149509212748826257350468642929907501054835860852035156616715474138980202568600919331052951544416826414234"
        "747306025416969739861673743221054056214812500424990226052374662785854342317293230735231190919876098632812"
        "5"},
    {1e-111, chars_format::fixed, 421,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0000100000000000000008815387795168313254933939601769443940194995342537854955671117454648191389018076580702"
        "2873976813049808948929876432973136524836655272007916446621148442848392962433896277932822131993852253661517"
        "5460023692731730268401631043898549001949195234763482210724552280700638817734215990640223026275634765625"},
    {1e-110, chars_format::fixed, 417,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0001000000000000000051221963480540189426303672967707105650555498545152501416302058360870033129056288755643"
        "8396075635667299154831590986600534543597761617445658118334167891261020459677930553668774342472698564564055"
        "265511385789128593139162584753710767157743183492959649261329346803250928132911212742328643798828125"},
    {1e-109, chars_format::fixed, 414,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0009999999999999999921309003267114804294465160877273716483243707367908243916474724638910239112571254734373"
        "8461676439380346196841136375912054159676958532320479617304614317043657962202789926136591785273802092822629"
        "542916946809659127192130501219695914914199014601235509201726525674303047708235681056976318359375"},
    {1e-108, chars_format::fixed, 411,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "0100000000000000003940375084977444762693224159171115885010927298348016601137114118147423128549645609920254"
        "8609403732144624780209551679866871807174846460293608701342659934968952698640024145775130968363489350769680"
        "326744756749605705517267782736253202447852708639242959309800795608680346049368381500244140625"},
    {1e-107, chars_format::fixed, 407,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "1000000000000000001585470431324073868943661188524129088681351186128692715592206207407665386104991598590417"
        "4152922614716945307710013432698076388506375506225586787054465233430542373503242382477604758631146127349724"
        "08684525827194158640497566304817959803162658537732665475772364516160450875759124755859375"},
    {1e-106, chars_format::fixed, 405,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        "9999999999999999410762217618034758561619325434248814703966763103663354423459102489011599470786483976110075"
        "0471390839500613166932080471450496953190329514887864248590506474161669928680438620396768786251503187943973"
        "978815635133568363766522001452157157165857837531619534132687476812861859798431396484375"},
    {1e-105, chars_format::fixed, 401,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009"
        "9999999999999996527992122961171506127462400146458051771054626067127835164442863230376212268918567800277146"
        "8945249625681491309993020136626037259396997338350656973721648182191714512212327021484803062754864221652807"
        "34670414167907363879815853064012686426021044028278339510507066734135150909423828125"},
    {1e-104, chars_format::fixed, 398,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000099"
        "9999999999999926554002081118532333094317668601062042008354340183369696766799218859598641712326029375949126"
        "1751036566009158849174754612323288954070738351954337932151146772716901515596217134574187423711324741118992"
        "53027677129649636985456904850438396097599136336242509059957228600978851318359375"},
    {1e-103, chars_format::fixed, 395,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000999"
        "9999999999999575347373999130785156385627348918768225701078765736966206689027496149294264938137482774070003"
        "9122043186537622497791120154729558659901263771961233762034148120770964008178595987932619867811787214462572"
        "79688487691888384356182054821891706276881794934752178960479795932769775390625"},
    {1e-102, chars_format::fixed, 391,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009999"
        "9999999999993275014914487744156960316668185922499812070504746143508154721992501066479866862357315624070101"
        "8327011653807952929562609295322233645461595700269502096160038058894049264054562741800233632529553718444548"
        "0159114575574772754891649767885510036169449676890508271753787994384765625"},
    {1e-101, chars_format::fixed, 388,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000"
        "0000000000051716172769048498910573067736415953755477838627200290469331297483111135012229536413737838938008"
        "2154286693356587616358521047943278225065973931151126122309651732088851891652690019248658513534821641142117"
        "9001055338801084410855940271152519915887069146265275776386260986328125"},
    {1e-100, chars_format::fixed, 381,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000"
        "0000000000199918998026028836196477607885341594201826030059365956992555434676176762886132929895827460748109"
        "1185079852827053974965402226843604196126360835628314127871794272492894246908066589163059300043457860230145"
        "025079449986855914338755579873208034769049845635890960693359375"},
    {1e-99, chars_format::fixed, 380,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000"
        "0000000001999189980260288361964776078853415942018260300593659569925554346761767628861329298958274607481091"
        "1850798528270539749654022268436041961263608356283141278717942724928942469080665891630593000434578602301450"
        "25079449986855914338755579873208034769049845635890960693359375"},
    {1e-98, chars_format::fixed, 378,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000099999999"
        "9999999938777761008502108474878975001956765921826799815501537087861613187954421956155709823745708345025814"
        "6914492613566917209869310021530837652091193736796956409650326860009509268385256465483316166327596918109804"
        "658117462243096325476277019816961910692043602466583251953125"},
    {1e-97, chars_format::fixed, 375,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000"
        "0000000362347275614230386486015179458496381198537636440236074215343295235503271551048096227501536207679312"
        "8266838165330935538744052169263360047450615280383040626852473271454077752909394064704527719494238439954420"
        "779105059740904555554141808215717901475727558135986328125"},
    {1e-96, chars_format::fixed, 370,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009999999999"
        "9999990629210549086179841697146068732580852248447853932751364330404107608912022317267655741089325311177582"
        "7709554591152509520094495639900486787323780638317385863868670429754309941669548515427063112032127614792551"
        "8186447666098282116564632815425284206867218017578125"},
    {1e-95, chars_format::fixed, 368,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000099999999999"
        "9999989455383616020992165214697332781059464800821006333013661371425682464292659609241719228019888411715318"
        "8832039109328908751959523136496795471204988242457189228485502920176491976211594796627201250946919570336116"
        "40984498321327311742834353935904800891876220703125"},
    {1e-94, chars_format::fixed, 364,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000999999999999"
        "9999561900723659573146659174026745989590878742840195308136541444718399142236850346156545011692342917395224"
        "1374418302073833315536964415000244320181154987438569925659834711231349524051509396845731986966622013718771"
        "2048605636727671708285924978554248809814453125"},
    {1e-93, chars_format::fixed, 360,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009999999999999"
        "9990296557436585543066704173122150759848479182484064729364258134569183411332571521395093820818769977824806"
        "2608618361294265890437372950519076931911910880252541509475235263776371431484076857636831509625041102909425"
        "751177341368247653008438646793365478515625"},
    {1e-92, chars_format::fixed, 358,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000099999999999999"
        "9988124771166018445065242805546453775449723759526860925661082347528762289900626256676638945862246916287024"
        "4255218164047735143290068696924629637513332708655939048722142214357695259337042349496128856909275577546838"
        "2706261394332614145241677761077880859375"},
    {1e-91, chars_format::fixed, 355,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000"
        "0221884498860836508245232352764322462356965334013463784684827482635335605305906737669192409320657715026091"
        "5228319844897656388566043736181737648710222711081486303100580449952876371355518587472543611728213969278705"
        "7416722973357536830008029937744140625"},
    {1e-90, chars_format::fixed, 351,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009999999999999999"
        "9493750691003148621709889149244946960691831430175801622256242767571654402661914009469500487621068733014137"
        "0874092813614124240337583226333846298487062114638096503972538048521373489674425134635395776198474142304473"
        "133435749332420527935028076171875"},
    {1e-89, chars_format::fixed, 348,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000003"
        "8539015671714949588977841546821912212963464861099395816034940616223770432973593970253782565578822006089821"
        "1286618301940276728541498431074946002713261085209229472257643701331978478836423187794603219323390230766079"
        "866953077726066112518310546875"},
    {1e-88, chars_format::fixed, 345,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000999999999999999933"
        "8953946436746374964683614163280499584551035186800847917009095590064270577229046689127161110952987838135405"
        "1769619040225943481438996285073867598909252320213948341802119826481938818152107683370541217106330922348433"
        "887236751616001129150390625"},
    {1e-87, chars_format::fixed, 342,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000176"
        "1029146610688717047594552072313976206179259261553361116813440478030175792345610998556927468211736163456500"
        "6468702235674025246197867056143415414879391457166254464215735759522155943218070390309339980083880305983257"
        "130719721317291259765625"},
    {1e-86, chars_format::fixed, 338,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000008458"
        "2208924052686909682012804239211604947143851763892666741914281399401518083897262843851805551572223891384597"
        "4867117024056975916441904204672069555088860611876713011713657552843701525756652355924822273003371719823917"
        "37401485443115234375"},
    {1e-85, chars_format::fixed, 334,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000999999999999999977427"
        "1409913394073269523051506134966563305818371265181778238664788088419018271914182705997561604444442804732518"
        "5789655563502183893007303754914049050169469475340436204235776206482741760351348313945463175400618638377636"
        "6710662841796875"},
    {1e-84, chars_format::fixed, 328,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000345765"
        "1055545315643774148256588054462892608157826645123858015864019047369716410120204300084916904592673962596952"
        "6597967246048907044268975105442605172196756851680062911162025115250209588661084447736016045382712036371231"
        "0791015625"},
    {1e-83, chars_format::fixed, 327,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000003457651"
        "0555453156437741482565880544628926081578266451238580158640190473697164101202043000849169045926739625969526"
        "5979672460489070442689751054426051721967568516800629111620251152502095886610844477360160453827120363712310"
        "791015625"},
    {1e-82, chars_format::fixed, 320,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000000999999999999999961425317"
        "5133875575759313354743387232240038419096073369208121046736219849991328566788143274501180360291919104909106"
        "6016038393425985809817503337589839395411736588716579909256841070903584767215477313584415242075920104980468"
        "75"},
    {1e-81, chars_format::fixed, 319,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000009999999999999999614253175"
        "1338755757593133547433872322400384190960733692081210467362198499913285667881432745011803602919191049091066"
        "0160383934259858098175033375898393954117365887165799092568410709035847672154773135844152420759201049804687"
        "5"},
    {1e-80, chars_format::fixed, 318,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000099999999999999996142531751"
        "3387557575931335474338723224003841909607336920812104673621984999132856678814327450118036029191910490910660"
        "160383934259858098175033375898393954117365887165799092568410709035847672154773135844152420759201049804687"
        "5"},
    {1e-79, chars_format::fixed, 313,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000000999999999999999998878728350"
        "9251441931781307852081357833240286199608034515093483045050512125248538747074082304321530967363408159620203"
        "17497336959217417624670274052264414348782613129120472130243434116803058486766531132161617279052734375"},
    {1e-78, chars_format::fixed, 312,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000009999999999999999988787283509"
        "2514419317813078520813578332402861996080345150934830450505121252485387470740823043215309673634081596202031"
        "7497336959217417624670274052264414348782613129120472130243434116803058486766531132161617279052734375"},
    {1e-77, chars_format::fixed, 306,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000099999999999999992696817954285"
        "2977888064283788338863669429270136082147712570640533209564082812219258592693132229048327051034591863408815"
        "8396037764475242813674295968331307044624992795434233715246019613687167293392121791839599609375"},
    {1e-76, chars_format::fixed, 305,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000000999999999999999926968179542852"
        "9778880642837883388636694292701360821477125706405332095640828122192585926931322290483270510345918634088158"
        "396037764475242813674295968331307044624992795434233715246019613687167293392121791839599609375"},
    {1e-75, chars_format::fixed, 299,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000009999999999999999576500137009637"
        "6884491285850700308643802436708920370749451782251562897192482294336146830490746237302878343191414548305654"
        "690326776267877450997656448381172603908118869629750857797034768736921250820159912109375"},
    {1e-74, chars_format::fixed, 298,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000099999999999999995765001370096376"
        "8844912858507003086438024367089203707494517822515628971924822943361468304907462373028783431914145483056546"
        "90326776267877450997656448381172603908118869629750857797034768736921250820159912109375"},
    {1e-73, chars_format::fixed, 295,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000000999999999999999996922761423345581"
        "2696790341468932915818260911891993040154102154531258139625966702131490879797610286470009004866665380846522"
        "46616646076525732436683076683433657106032411976404006281882175244390964508056640625"},
    {1e-72, chars_format::fixed, 291,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000009999999999999999655045632454401313"
        "2986609363498112746678471190920282679869630110312834033237768873180446152192210415242692562864969406216797"
        "1937539358324754468588202386067562686157439433287663632654584944248199462890625"},
    {1e-71, chars_format::fixed, 287,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000099999999999999991523544616079141142"
        "6165388815921664882718505061208463251954038143132382524027318361653059189379824961108565855822743626193132"
        "450968609203189719636403510281811614357483364301515393890440464019775390625"},
    {1e-70, chars_format::fixed, 285,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000000999999999999999995666033496229363272"
        "0865165264168050172244360179994449267416588791259150173879109538953029214474716672179414923458643237528756"
        "2948180779769331795928171153901332923741307467935257591307163238525390625"},
    {1e-69, chars_format::fixed, 280,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000009999999999999999634937985620541825337"
        "1806544221874896342206363528305225682661058472850202004367391699840542862041298477419123773661604472897835"
        "80765283598918786301304310361326432854411905282177031040191650390625"},
    {1e-68, chars_format::fixed, 278,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000100000000000000006644495035141476089649"
        "7108911652528335589655259975508800554765126800223611545232435068477405667000768594192052486210537605449626"
        "573422560856484483414528645350838331751219811849296092987060546875"},
    {1e-67, chars_format::fixed, 275,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000000999999999999999942903568204182066861162"
        "2567483319930889885453103445609480809796763141577017433622133843910332110954280101910747866971461536841043"
        "771495196989574594736115142890042761791846714913845062255859375"},
    {1e-66, chars_format::fixed, 271,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000009999999999999999758479367767774519372515"
        "5065855080248808217463024614704207398912977710861102386093916681406586600351883259133550656738387415491029"
        "61556640076313325245227492388266909983940422534942626953125"},
    {1e-65, chars_format::fixed, 268,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000099999999999999992313694706062483581550868"
        "0402200707449532367718403609291685174004236387156175062977914937213618150573516750918354775003521401620825"
        "74583311375313564306477331911082728765904903411865234375"},
    {1e-64, chars_format::fixed, 265,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000000999999999999999965305738833546928712902976"
        "6072807834803722132478776394919962261046689643200541013469164386954164329297694232520762089078036042524020"
        "73697828855693148231154054883518256247043609619140625"},
    {1e-63, chars_format::fixed, 262,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000010000000000000000665108390885599516666492874"
        "9947296595438784251861531197274275114570714951336379343252004225173231058477583685300765027808089056818526"
        "05731451018311606304678207379765808582305908203125"},
    {1e-62, chars_format::fixed, 255,
        "0."
        "0000000000000000000000000000000000000000000000000000000000000100000000000000003952281235388981221231693792"
        "8221717294650341379751932644543677801430300128481208876359081303381409876774126559425932579340280883976410"
        "7397274361943573239841498434543609619140625"},
    {1e-61, chars_format::fixed, 254,
        "0."
        "0000000000000000000000000000000000000000000000000000000000001000000000000000039522812353889812212316937928"
        "2217172946503413797519326445436778014303001284812088763590813033814098767741265594259325793402808839764107"
        "397274361943573239841498434543609619140625"},
    {1e-60, chars_format::fixed, 251,
        "0."
        "0000000000000000000000000000000000000000000000000000000000009999999999999999704334639131342552092261230258"
        "1852072572233846426168156435405004008156570318179241258702127560310406428974820785673527056432009240175516"
        "617821216414085938595235347747802734375"},
    {1e-59, chars_format::fixed, 245,
        "0."
        "0000000000000000000000000000000000000000000000000000000000100000000000000002570494266573870081169877494774"
        "1077980864740796653882428505752249160553243421325583604669297825748714277250889112093117585088725661479625"
        "017591388314031064510345458984375"},
    {1e-58, chars_format::fixed, 244,
        "0."
        "0000000000000000000000000000000000000000000000000000000001000000000000000025704942665738700811698774947741"
        "0779808647407966538824285057522491605532434213255836046692978257487142772508891120931175850887256614796250"
        "17591388314031064510345458984375"},
    {1e-57, chars_format::fixed, 242,
        "0."
        "0000000000000000000000000000000000000000000000000000000009999999999999999549574498624050104405337804876802"
        "0469428246581119186532239157342153944919191472312470207982938076356229324745710523507339850487508903231770"
        "318598137237131595611572265625"},
    {1e-56, chars_format::fixed, 238,
        "0."
        "0000000000000000000000000000000000000000000000000000000100000000000000003985444122640543888593177383975325"
        "2638181195793746285849728588014684774053722646075385187191514745744674051575513464726422405495775969086480"
        "47246970236301422119140625"},
    {1e-55, chars_format::fixed, 235,
        "0."
        "0000000000000000000000000000000000000000000000000000000999999999999999994576045832271877048386177385314293"
        "7347685398030505949018155135650072674607584205016875299317099552474042893790290755781429918314096028097992"
        "53009259700775146484375"},
    {1e-54, chars_format::fixed, 230,
        "0."
        "0000000000000000000000000000000000000000000000000000010000000000000000307987621475787265184226545488654608"
        "5749866459560714766014597312474927273512980096064565573955378764522009913621658689676652276290269583114422"
        "857761383056640625"},
    {1e-53, chars_format::fixed, 229,
        "0."
        "0000000000000000000000000000000000000000000000000000100000000000000003079876214757872651842265454886546085"
        "7498664595607147660145973124749272735129800960645655739553787645220099136216586896766522762902695831144228"
        "57761383056640625"},
    {1e-52, chars_format::fixed, 221,
        "0."
        "0000000000000000000000000000000000000000000000000001000000000000000007616223705782342857599309164192713898"
        "9513847283709538948144790065143893595321174669124552225337349106179808916165796528474629667471162974834442"
        "138671875"},
    {1e-51, chars_format::fixed, 220,
        "0."
        "0000000000000000000000000000000000000000000000000010000000000000000076162237057823428575993091641927138989"
        "5138472837095389481447900651438935953211746691245522253373491061798089161657965284746296674711629748344421"
        "38671875"},
    {1e-50, chars_format::fixed, 219,
        "0."
        "0000000000000000000000000000000000000000000000000100000000000000000761622370578234285759930916419271389895"
        "1384728370953894814479006514389359532117466912455222533734910617980891616579652847462966747116297483444213"
        "8671875"},
    {1e-49, chars_format::fixed, 215,
        "0."
        "0000000000000000000000000000000000000000000000000999999999999999936399465612583852251549992142478035242294"
        "1409762213666477161290752968276296960337741640632342481329099202736442053573995281112729571759700775146484"
        "375"},
    {1e-48, chars_format::fixed, 209,
        "0."
        "0000000000000000000000000000000000000000000000009999999999999999743817365956230472414429612207258638591780"
        "0431070114651283524903861286055227527841029653896133378731029238417615800926796509884297847747802734375"},
    {1e-47, chars_format::fixed, 208,
        "0."
        "0000000000000000000000000000000000000000000000099999999999999997438173659562304724144296122072586385917800"
        "431070114651283524903861286055227527841029653896133378731029238417615800926796509884297847747802734375"},
    {1e-46, chars_format::fixed, 205,
        "0."
        "0000000000000000000000000000000000000000000001000000000000000022999043453913216828505961640883084488789349"
        "378835264740187722591657382693176711544546107892003424942768685657057403659564442932605743408203125"},
    {1e-45, chars_format::fixed, 202,
        "0."
        "0000000000000000000000000000000000000000000009999999999999999841051979672810811588555613047573079851002733"
        "243279701583057437492217649804555650371464527474677148367876444723378881462849676609039306640625"},
    {1e-44, chars_format::fixed, 199,
        "0."
        "0000000000000000000000000000000000000000000099999999999999995299012157797537262313524103585668678214901248"
        "072213449280016067527327081027864783122672863183914675200281152456227573566138744354248046875"},
    {1e-43, chars_format::fixed, 195,
        "0."
        "0000000000000000000000000000000000000000001000000000000000077450427135198206766016522111459171593954055855"
        "14547715482249297106724749098631665490562509435341909114214331566472537815570831298828125"},
    {1e-42, chars_format::fixed, 192,
        "0."
        "0000000000000000000000000000000000000000010000000000000000376231293568868998402945121672663764541764419753"
        "30007502975346636413174953159862631328378226348851942617557142511941492557525634765625"},
    {1e-41, chars_format::fixed, 189,
        "0."
        "0000000000000000000000000000000000000000100000000000000000576129113423785429971690421191214034235435087147"
        "76317814976295686899169228986994124665807319451982237978882039897143840789794921875"},
    {1e-40, chars_format::fixed, 183,
        "0."
        "0000000000000000000000000000000000000000999999999999999929292879399880145002330645119061973673981332222231"
        "93004995110860615409765027190768719826674537642929863068275153636932373046875"},
    {1e-39, chars_format::fixed, 182,
        "0."
        "0000000000000000000000000000000000000009999999999999999292928793998801450023306451190619736739813322222319"
        "3004995110860615409765027190768719826674537642929863068275153636932373046875"},
    {1e-38, chars_format::fixed, 177,
        "0."
        "0000000000000000000000000000000000000099999999999999996191940173987276763588211566534471145248715351257676"
        "27887442908835027138732593388233127473796457707067020237445831298828125"},
    {1e-37, chars_format::fixed, 175,
        "0."
        "0000000000000000000000000000000000001000000000000000066324273227849160063246821413449472343705781641680227"
        "552882474171018285786819118458879085409307663212530314922332763671875"},
    {1e-36, chars_format::fixed, 171,
        "0."
        "0000000000000000000000000000000000009999999999999999410384274422774891504091745157237592742434278867560698"
        "35916654225999599490547382896199479773713392205536365509033203125"},
    {1e-35, chars_format::fixed, 169,
        "0."
        "0000000000000000000000000000000000100000000000000000785754519458238030392258619451080624462334988938228728"
        "496509153000956551522564186296193611269700340926647186279296875"},
    {1e-34, chars_format::fixed, 165,
        "0."
        "0000000000000000000000000000000000999999999999999927674603891816510919706492179966349880167443486230826346"
        "10696676519760628561173110284698850591666996479034423828125"},
    {1e-33, chars_format::fixed, 160,
        "0."
        "0000000000000000000000000000000010000000000000000559673099762419019344522426032374800632968937312731638482"
        "799663888967410529939883190309046767652034759521484375"},
    {1e-32, chars_format::fixed, 159,
        "0."
        "0000000000000000000000000000000100000000000000005596730997624190193445224260323748006329689373127316384827"
        "99663888967410529939883190309046767652034759521484375"},
    {1e-31, chars_format::fixed, 148,
        "0."
        "0000000000000000000000000000001000000000000000083336420607585985350931336026868654502364509783548862515410"
        "206308619223136702203191816806793212890625"},
    {1e-30, chars_format::fixed, 147,
        "0."
        "0000000000000000000000000000010000000000000000833364206075859853509313360268686545023645097835488625154102"
        "06308619223136702203191816806793212890625"},
    {1e-29, chars_format::fixed, 149,
        "0."
        "0000000000000000000000000000099999999999999994320657417510427825855837769787704137433831559589728533970337"
        "7919640114868116143043152987957000732421875"},
    {1e-28, chars_format::fixed, 146,
        "0."
        "0000000000000000000000000000999999999999999971232543461600619677032969363675363999943554433427600774844743"
        "5974359365218333550728857517242431640625"},
    {1e-27, chars_format::fixed, 138,
        "0."
        "0000000000000000000000000010000000000000000384948697491918390813719893615913383013961276435003578191840212"
        "24145908490754663944244384765625"},
    {1e-26, chars_format::fixed, 137,
        "0."
        "0000000000000000000000000100000000000000003849486974919183908137198936159133830139612764350035781918402122"
        "4145908490754663944244384765625"},
    {1e-25, chars_format::fixed, 136,
        "0."
        "0000000000000000000000001000000000000000038494869749191839081371989361591338301396127643500357819184021224"
        "145908490754663944244384765625"},
    {1e-24, chars_format::fixed, 132,
        "0."
        "0000000000000000000000009999999999999999237004995517028246313000618984814088269170693649761857968449874078"
        "94222997128963470458984375"},
    {1e-23, chars_format::fixed, 129,
        "0."
        "0000000000000000000000099999999999999996043469801489930925532307868667658625875036801410392084399347822909"
        "47623550891876220703125"},
    {1e-22, chars_format::fixed, 125,
        "0."
        "0000000000000000000001000000000000000048596774326570872352978318978345012095150284772010484957149856199976"
        "0568141937255859375"},
    {1e-21, chars_format::fixed, 122,
        "0."
        "0000000000000000000009999999999999999075374522278963713967299345116755307569104179593599823760996514465659"
        "8567962646484375"},
    {1e-20, chars_format::fixed, 119,
        "0."
        "0000000000000000000099999999999999994515327145420957165172950370278739244710771577606678306437970604747533"
        "7982177734375"},
    {1e-19, chars_format::fixed, 114,
        "0."
        "0000000000000000000999999999999999975245926835260131855729159055676881799265554029432223615003749728202819"
        "82421875"},
    {1e-18, chars_format::fixed, 110,
        "0."
        "0000000000000000010000000000000000715424240546219245085280561849232477261706364402016333770006895065307617"
        "1875"},
    {1e-17, chars_format::fixed, 109,
        "0."
        "0000000000000000100000000000000007154242405462192450852805618492324772617063644020163337700068950653076171"
        "875"},
    {1e-16, chars_format::fixed, 104,
        "0."
        "00000000000000009999999999999999790977867240346035618411149408467364363417573258630000054836273193359375"},
    {1e-15, chars_format::fixed, 101,
        "0.00000000000000100000000000000007770539987666107923830718560119501514549256171449087560176849365234375"},
    {1e-14, chars_format::fixed, 99,
        "0.000000000000009999999999999999988193093545598986971343290729163921781719182035885751247406005859375"},
    {1e-13, chars_format::fixed, 95,
        "0.00000000000010000000000000000303737455634003709136034716842278413651001756079494953155517578125"},
    {1e-12, chars_format::fixed, 92,
        "0.00000000000099999999999999997988664762925561536725284350612952266601496376097202301025390625"},
    {1e-11, chars_format::fixed, 89,
        "0.00000000000999999999999999939496969281939810930172340963650867706746794283390045166015625"},
    {1e-10, chars_format::fixed, 86,
        "0.00000000010000000000000000364321973154977415791655470655996396089904010295867919921875"},
    {1e-09, chars_format::fixed, 82,
        "0.0000000010000000000000000622815914577798564188970686927859787829220294952392578125"},
    {1e-08, chars_format::fixed, 78,
        "0.000000010000000000000000209225608301284726753266340892878361046314239501953125"},
    {1e-07, chars_format::fixed, 73, "0.0000000999999999999999954748111825886258685613938723690807819366455078125"},
    {1e-06, chars_format::fixed, 72, "0.000000999999999999999954748111825886258685613938723690807819366455078125"},
    {1e-05, chars_format::fixed, 69, "0.000010000000000000000818030539140313095458623138256371021270751953125"},
    {1e-04, chars_format::fixed, 66, "0.000100000000000000004792173602385929598312941379845142364501953125"},
    {1e-03, chars_format::fixed, 60, "0.001000000000000000020816681711721685132943093776702880859375"},
    {1e-02, chars_format::fixed, 59, "0.01000000000000000020816681711721685132943093776702880859375"},
    {1e-01, chars_format::fixed, 55, "0.1000000000000000055511151231257827021181583404541015625"},
    {1e+00, chars_format::fixed, 0, "1"},
    {1e+01, chars_format::fixed, 0, "10"},
    {1e+02, chars_format::fixed, 0, "100"},
    {1e+03, chars_format::fixed, 0, "1000"},
    {1e+04, chars_format::fixed, 0, "10000"},
    {1e+05, chars_format::fixed, 0, "100000"},
    {1e+06, chars_format::fixed, 0, "1000000"},
    {1e+07, chars_format::fixed, 0, "10000000"},
    {1e+08, chars_format::fixed, 0, "100000000"},
    {1e+09, chars_format::fixed, 0, "1000000000"},
    {1e+10, chars_format::fixed, 0, "10000000000"},
    {1e+11, chars_format::fixed, 0, "100000000000"},
    {1e+12, chars_format::fixed, 0, "1000000000000"},
    {1e+13, chars_format::fixed, 0, "10000000000000"},
    {1e+14, chars_format::fixed, 0, "100000000000000"},
    {1e+15, chars_format::fixed, 0, "1000000000000000"},
    {1e+16, chars_format::fixed, 0, "10000000000000000"},
    {1e+17, chars_format::fixed, 0, "100000000000000000"},
    {1e+18, chars_format::fixed, 0, "1000000000000000000"},
    {1e+19, chars_format::fixed, 0, "10000000000000000000"},
    {1e+20, chars_format::fixed, 0, "100000000000000000000"},
    {1e+21, chars_format::fixed, 0, "1000000000000000000000"},
    {1e+22, chars_format::fixed, 0, "10000000000000000000000"},
    {1e+23, chars_format::fixed, 0, "99999999999999991611392"},
    {1e+24, chars_format::fixed, 0, "999999999999999983222784"},
    {1e+25, chars_format::fixed, 0, "10000000000000000905969664"},
    {1e+26, chars_format::fixed, 0, "100000000000000004764729344"},
    {1e+27, chars_format::fixed, 0, "1000000000000000013287555072"},
    {1e+28, chars_format::fixed, 0, "9999999999999999583119736832"},
    {1e+29, chars_format::fixed, 0, "99999999999999991433150857216"},
    {1e+30, chars_format::fixed, 0, "1000000000000000019884624838656"},
    {1e+31, chars_format::fixed, 0, "9999999999999999635896294965248"},
    {1e+32, chars_format::fixed, 0, "100000000000000005366162204393472"},
    {1e+33, chars_format::fixed, 0, "999999999999999945575230987042816"},
    {1e+34, chars_format::fixed, 0, "9999999999999999455752309870428160"},
    {1e+35, chars_format::fixed, 0, "99999999999999996863366107917975552"},
    {1e+36, chars_format::fixed, 0, "1000000000000000042420637374017961984"},
    {1e+37, chars_format::fixed, 0, "9999999999999999538762658202121142272"},
    {1e+38, chars_format::fixed, 0, "99999999999999997748809823456034029568"},
    {1e+39, chars_format::fixed, 0, "999999999999999939709166371603178586112"},
    {1e+40, chars_format::fixed, 0, "10000000000000000303786028427003666890752"},
    {1e+41, chars_format::fixed, 0, "100000000000000000620008645040778319495168"},
    {1e+42, chars_format::fixed, 0, "1000000000000000044885712678075916785549312"},
    {1e+43, chars_format::fixed, 0, "10000000000000000139372116959414099130712064"},
    {1e+44, chars_format::fixed, 0, "100000000000000008821361405306422640701865984"},
    {1e+45, chars_format::fixed, 0, "999999999999999929757289024535551219930759168"},
    {1e+46, chars_format::fixed, 0, "9999999999999999931398190359470212947659194368"},
    {1e+47, chars_format::fixed, 0, "100000000000000004384584304507619735463404765184"},
    {1e+48, chars_format::fixed, 0, "1000000000000000043845843045076197354634047651840"},
    {1e+49, chars_format::fixed, 0, "9999999999999999464902769475481793196872414789632"},
    {1e+50, chars_format::fixed, 0, "100000000000000007629769841091887003294964970946560"},
    {1e+51, chars_format::fixed, 0, "999999999999999993220948674361627976461708441944064"},
    {1e+52, chars_format::fixed, 0, "9999999999999999932209486743616279764617084419440640"},
    {1e+53, chars_format::fixed, 0, "99999999999999999322094867436162797646170844194406400"},
    {1e+54, chars_format::fixed, 0, "1000000000000000078291540404596243842305360299886116864"},
    {1e+55, chars_format::fixed, 0, "10000000000000000102350670204085511496304388135324745728"},
    {1e+56, chars_format::fixed, 0, "100000000000000009190283508143378238084034459715684532224"},
    {1e+57, chars_format::fixed, 0, "1000000000000000048346692115553659057528394845890514255872"},
    {1e+58, chars_format::fixed, 0, "9999999999999999438119489974413630815797154428513196965888"},
    {1e+59, chars_format::fixed, 0, "99999999999999997168788049560464200849936328366177157906432"},
    {1e+60, chars_format::fixed, 0, "999999999999999949387135297074018866963645011013410073083904"},
    {1e+61, chars_format::fixed, 0, "9999999999999999493871352970740188669636450110134100730839040"},
    {1e+62, chars_format::fixed, 0, "100000000000000003502199685943161173046080317798311825604870144"},
    {1e+63, chars_format::fixed, 0, "1000000000000000057857959942726969827393378689175040438172647424"},
    {1e+64, chars_format::fixed, 0, "10000000000000000213204190094543968723012578712679649467743338496"},
    {1e+65, chars_format::fixed, 0, "99999999999999999209038626283633850822756121694230455365568299008"},
    {1e+66, chars_format::fixed, 0, "999999999999999945322333868247445125709646570021247924665841614848"},
    {1e+67, chars_format::fixed, 0, "9999999999999999827367757839185598317239782875580932278577147150336"},
    {1e+68, chars_format::fixed, 0, "99999999999999995280522225138166806691251291352861698530421623488512"},
    {1e+69, chars_format::fixed, 0, "1000000000000000072531436381529235126158374409646521955518210155479040"},
    {1e+70, chars_format::fixed, 0, "10000000000000000725314363815292351261583744096465219555182101554790400"},
    {1e+71, chars_format::fixed, 0, "100000000000000004188152556421145795899143386664033828314342771180699648"},
    {1e+72, chars_format::fixed, 0, "999999999999999943801810948794571024057224129020550531544123892056457216"},
    {1e+73, chars_format::fixed, 0, "9999999999999999830336967949613257980309080240684656321838454199566729216"},
    {1e+74, chars_format::fixed, 0, "99999999999999995164818811802792197885196090803013355167206819763650035712"},
    {1e+75, chars_format::fixed, 0, "999999999999999926539781176481198923508803215199467887262646419780362305536"},
    {1e+76, chars_format::fixed, 0, "10000000000000000470601344959054695891559601407866630764278709534898249531392"},
    {1e+77, chars_format::fixed, 0, "99999999999999998278261272554585856747747644714015897553975120217811154108416"},
    {1e+78, chars_format::fixed, 0, "1000000000000000008493621433689702976148869924598760615894999102702796905906176"},
    {1e+79, chars_format::fixed, 0, "9999999999999999673560075006595519222746403606649979913266024618633003221909504"},
    {1e+80, chars_format::fixed, 0,
        "100000000000000000026609864708367276537402401181200809098131977453489758916313088"},
    {1e+81, chars_format::fixed, 0,
        "999999999999999921281879895665782741935503249059183851809998224123064148429897728"},
    {1e+82, chars_format::fixed, 0,
        "9999999999999999634067965630886574211027143225273567793680363843427086501542887424"},
    {1e+83, chars_format::fixed, 0,
        "100000000000000003080666323096525690777025204007643346346089744069413985291331436544"},
    {1e+84, chars_format::fixed, 0,
        "1000000000000000057766609898115896702437267127096064137098041863234712334016924614656"},
    {1e+85, chars_format::fixed, 0,
        "10000000000000000146306952306748730309700429878646550592786107871697963642511482159104"},
    {1e+86, chars_format::fixed, 0,
        "100000000000000001463069523067487303097004298786465505927861078716979636425114821591040"},
    {1e+87, chars_format::fixed, 0,
        "999999999999999959416724456350362731491996089648451439669739009806703922950954425516032"},
    {1e+88, chars_format::fixed, 0,
        "9999999999999999594167244563503627314919960896484514396697390098067039229509544255160320"},
    {1e+89, chars_format::fixed, 0,
        "99999999999999999475366575191804932315794610450682175621941694731908308538307845136842752"},
    {1e+90, chars_format::fixed, 0,
        "999999999999999966484112715463900049825186092620125502979674597309179755437379230686511104"},
    {1e+91, chars_format::fixed, 0,
        "10000000000000000795623248612804971431562261401669105159386439973487930752201761134141767680"},
    {1e+92, chars_format::fixed, 0,
        "100000000000000004337729697461918607329029332495193931179177378933611681288968111094132375552"},
    {1e+93, chars_format::fixed, 0,
        "1000000000000000043377296974619186073290293324951939311791773789336116812889681110941323755520"},
    {1e+94, chars_format::fixed, 0,
        "10000000000000000202188791271559469885760963232143577411377768562080040049981643093586978275328"},
    {1e+95, chars_format::fixed, 0,
        "100000000000000002021887912715594698857609632321435774113777685620800400499816430935869782753280"},
    {1e+96, chars_format::fixed, 0,
        "1000000000000000049861653971908893017010268485438462151574892930611988399099305815384459015356416"},
    {1e+97, chars_format::fixed, 0,
        "10000000000000000735758738477112498397576062152177456799245857901351759143802190202050679656153088"},
    {1e+98, chars_format::fixed, 0,
        "99999999999999999769037024514370800696612547992403838920556863966097586548129676477911932478685184"},
    {1e+99, chars_format::fixed, 0,
        "999999999999999967336168804116691273849533185806555472917961779471295845921727862608739868455469056"},
    {1e+100, chars_format::fixed, 0,
        "10000000000000000159028911097599180468360808563945281389781327557747838772170381060813469985856815104"},
    {1e+101, chars_format::fixed, 0,
        "99999999999999997704951326524533662844684271992415000612999597473199345218078991130326129448151154688"},
    {1e+102, chars_format::fixed, 0,
        "999999999999999977049513265245336628446842719924150006129995974731993452180789911303261294481511546880"},
    {1e+103, chars_format::fixed, 0,
        "10000000000000000019156750857346687362159551272651920111528035145993793242039887559612361451081803235328"},
    {1e+104, chars_format::fixed, 0,
        "10000000000000000019156750857346687362159551272651920111528035145993793242039887559612361451081803235328"
        "0"},
    {1e+105, chars_format::fixed, 0,
        "99999999999999993825830082528197854032702736447212447829441621253887149182459971363682052750390825530163"
        "2"},
    {1e+106, chars_format::fixed, 0,
        "1000000000000000091035999050368435010460453995175486557154545737484090289535133415215418009754161219056435"
        "2"},
    {1e+107, chars_format::fixed, 0,
        "9999999999999999688138404702992698343537126906127968940664421175279152513667064539525400239539588480525926"
        "4"},
    {1e+108, chars_format::fixed, 0,
        "1000000000000000033998991713002824594943974719712898047713430714837875271723200833292741616380733445921308"
        "672"},
    {1e+109, chars_format::fixed, 0,
        "9999999999999999818508707188399807864717650964328171247958398369899072554380053298205803424393137676263358"
        "464"},
    {1e+110, chars_format::fixed, 0,
        "1000000000000000023569367514170255833249532795056881863129912539268281668466161732598309361592449510262314"
        "10688"},
    {1e+111, chars_format::fixed, 0,
        "9999999999999999568197726416418157584051044772583782817953962156228826076211114881539429309474323220447488"
        "90112"},
    {1e+112, chars_format::fixed, 0,
        "9999999999999999301199346926304397284673331501389768492615896861647229832830913903761963586894254467577228"
        "034048"},
    {1e+113, chars_format::fixed, 0,
        "1000000000000000015559416129466843024268201396921061433369770580430833781164755703264985389915047447676206"
        "28086784"},
    {1e+114, chars_format::fixed, 0,
        "1000000000000000015559416129466843024268201396921061433369770580430833781164755703264985389915047447676206"
        "280867840"},
    {1e+115, chars_format::fixed, 0,
        "1000000000000000015559416129466843024268201396921061433369770580430833781164755703264985389915047447676206"
        "2808678400"},
    {1e+116, chars_format::fixed, 0,
        "1000000000000000015559416129466843024268201396921061433369770580430833781164755703264985389915047447676206"
        "28086784000"},
    {1e+117, chars_format::fixed, 0,
        "1000000000000000050555427725995033814228237030803003279020481474722232763977085405824233377105062219252417"
        "113236701184"},
    {1e+118, chars_format::fixed, 0,
        "9999999999999999665649998943273759183241515094863428494587753284228752052274941196820382078490267674695111"
        "155514343424"},
    {1e+119, chars_format::fixed, 0,
        "9999999999999999441675524725493338127497287038019000682423203560763798562276031100441194960474173136607361"
        "8283536318464"},
    {1e+120, chars_format::fixed, 0,
        "9999999999999999800034683473942011816688051928970085181886483118307724146274287254647894349299924397547760"
        "75181077037056"},
    {1e+121, chars_format::fixed, 0,
        "1000000000000000037340933747145988971939327575449182038102773041037800508067149710137861337142112641505239"
        "9029342192009216"},
    {1e+122, chars_format::fixed, 0,
        "1000000000000000014405947587245273855831118622428312630137123149354989270691261316268632576257264560805054"
        "37183296233537536"},
    {1e+123, chars_format::fixed, 0,
        "9999999999999999777099697314041296700579842975949215773920833226624912908898398860778665588415076316847575"
        "22070951350501376"},
    {1e+124, chars_format::fixed, 0,
        "9999999999999999483531874467312143214394768377282087351960514613084929070487027419252537449089020883885200"
        "422613425626021888"},
    {1e+125, chars_format::fixed, 0,
        "9999999999999999248677616189928820425446708698348384614392259722252941999757930266031634937628176537515300"
        "5841365553228283904"},
    {1e+126, chars_format::fixed, 0,
        "9999999999999999248677616189928820425446708698348384614392259722252941999757930266031634937628176537515300"
        "58413655532282839040"},
    {1e+127, chars_format::fixed, 0,
        "9999999999999999549291066784979473595300225087383524118479625982517885450291174622154390152298057300868772"
        "377386949310916067328"},
    {1e+128, chars_format::fixed, 0,
        "1000000000000000075174486916518208627471429064352408213482909102357765925242415204664541101097758035428265"
        "95503885252632667750400"},
    {1e+129, chars_format::fixed, 0,
        "9999999999999999982174435641852414159889288687594125004365433397299404019059046494971157661422685600097771"
        "75966751665376232210432"},
    {1e+130, chars_format::fixed, 0,
        "1000000000000000059783078246051615185174929025233809070873635949832200820575113093631056034106660140344568"
        "1992244323541365884452864"},
    {1e+131, chars_format::fixed, 0,
        "9999999999999999120255550095723181391285286496952573018246136855867758157690128277095993909921203475410697"
        "4340599870111173348163584"},
    {1e+132, chars_format::fixed, 0,
        "9999999999999999908295674023612765636866088499824849119840922265176691516655996362010429339865415703696022"
        "53175829982724989462249472"},
    {1e+133, chars_format::fixed, 0,
        "1000000000000000022351172359476859933509840930097375956047883642890026486024234359597620351184310059501015"
        "2570837624953702918544949248"},
    {1e+134, chars_format::fixed, 0,
        "9999999999999999214820364967069931500754982737297246150437511104984830160766032447285726161514508942804936"
        "4457837845490532419930947584"},
    {1e+135, chars_format::fixed, 0,
        "9999999999999999618296908418149398634492353362767851514454041234551004040556556906761917101645945603687022"
        "89580532071091311261383655424"},
    {1e+136, chars_format::fixed, 0,
        "1000000000000000058664061270074011975546204286389730438809371354550982135205381560950477535796139358980403"
        "0375857007499376802103616864256"},
    {1e+137, chars_format::fixed, 0,
        "1000000000000000032841562489204926078987012566359611695512313426258747006898787995544001315627727412683949"
        "50478432243557864849063421149184"},
    {1e+138, chars_format::fixed, 0,
        "1000000000000000032841562489204926078987012566359611695512313426258747006898787995544001315627727412683949"
        "504784322435578648490634211491840"},
    {1e+139, chars_format::fixed, 0,
        "1000000000000000032841562489204926078987012566359611695512313426258747006898787995544001315627727412683949"
        "5047843224355786484906342114918400"},
    {1e+140, chars_format::fixed, 0,
        "1000000000000000059283801240814870037063624887670453288648500744829995778284739806520232965080181245691517"
        "92237293382948229697163514582401024"},
    {1e+141, chars_format::fixed, 0,
        "1000000000000000016976219238238959704141045173573106739630601035115997744067216908958262325956255112879408"
        "454231155599236459402033650892537856"},
    {1e+142, chars_format::fixed, 0,
        "1000000000000000050822284840299687970479108944850983978844920802887196171441235227007838837255396019129096"
        "0287445781834331294577148468377157632"},
    {1e+143, chars_format::fixed, 0,
        "1000000000000000023745432358651105357408657927828682187473464988670237429542020572568177628216083294129345"
        "96913384011607579341316989008157343744"},
    {1e+144, chars_format::fixed, 0,
        "1000000000000000023745432358651105357408657927828682187473464988670237429542020572568177628216083294129345"
        "969133840116075793413169890081573437440"},
    {1e+145, chars_format::fixed, 0,
        "9999999999999999890870611821409196126784806260401358945180015464725302399110258148854112806457630061296658"
        "928320953898584032761523454337112604672"},
    {1e+146, chars_format::fixed, 0,
        "9999999999999999336336672997246224211101969431784618257892600389561987365014342025929851245332505453301777"
        "7074930382791057905692427399713177731072"},
    {1e+147, chars_format::fixed, 0,
        "9999999999999999779963824056576601743648238894678010807722532449692639392291074924269260494232605139697682"
        "68415537077468838432306731146395363835904"},
    {1e+148, chars_format::fixed, 0,
        "1000000000000000048976726575150520579572227003530743888745042374590168263593384756161231529247276463793113"
        "0646815102767620534329186625852171022761984"},
    {1e+149, chars_format::fixed, 0,
        "1000000000000000048976726575150520579572227003530743888745042374590168263593384756161231529247276463793113"
        "06468151027676205343291866258521710227619840"},
    {1e+150, chars_format::fixed, 0,
        "9999999999999999808355961724373745905731200140303187930911648101541001122036785829762982686162211519627020"
        "60266176005440567032331208403948233373515776"},
    {1e+151, chars_format::fixed, 0,
        "1000000000000000017177532387217719118039310408430545510773232844520003126278188542008262674286117318272254"
        "5959543542834786931126445173006249634549465088"},
    {1e+152, chars_format::fixed, 0,
        "1000000000000000046251081359041994740012262723950726884918887272012725537537796509233834198822034251319896"
        "62450489690590919397689516441796634752009109504"},
    {1e+153, chars_format::fixed, 0,
        "9999999999999999997334030041231537448555390191184366862858401880243696795224237616729197595645671584436693"
        "78824028710020392594094129030220133015859757056"},
    {1e+154, chars_format::fixed, 0,
        "1000000000000000036947545688058226540980917982984268845192277855215054365934721959721651310970540832744651"
        "1753687232667314337003349573404171046192448274432"},
    {1e+155, chars_format::fixed, 0,
        "1000000000000000007176231540910168304080614811891603118067127721462506616804883401282666069845761893303865"
        "73813296762136260081534229469225952733653677113344"},
    {1e+156, chars_format::fixed, 0,
        "9999999999999999833591802231917217145603722750174705363670076144604684175010125545314778769459387417512373"
        "88344363105067534507348164573733465510370326085632"},
    {1e+157, chars_format::fixed, 0,
        "9999999999999999833591802231917217145603722750174705363670076144604684175010125545314778769459387417512373"
        "883443631050675345073481645737334655103703260856320"},
    {1e+158, chars_format::fixed, 0,
        "9999999999999999528733545365121100799744618278185808317908538774978595223920578706899569900341651077638731"
        "0061494932420984963311567802202010637287727642443776"},
    {1e+159, chars_format::fixed, 0,
        "9999999999999999284846939871684207723057334700594690681299308879277724063048941236167402805047462005739816"
        "70431418299523701733729688780649419062882836695482368"},
    {1e+160, chars_format::fixed, 0,
        "1000000000000000006528407745068226556845664214888626711844884454552051177783818114251033750998886703581634"
        "2470187175785193750117648543530356184548650438281396224"},
    {1e+161, chars_format::fixed, 0,
        "1000000000000000037745893248228148870661636512820289769330865881201762686375387710504751139196542904784695"
        "27765363729011764432297892058199009821165792668120252416"},
    {1e+162, chars_format::fixed, 0,
        "9999999999999999378499396381163974664505251594389679853757253159226858588823650024928554969640430609348999"
        "79621894213003182527093908649335762989920701551401238528"},
    {1e+163, chars_format::fixed, 0,
        "9999999999999999378499396381163974664505251594389679853757253159226858588823650024928554969640430609348999"
        "796218942130031825270939086493357629899207015514012385280"},
    {1e+164, chars_format::fixed, 0,
        "1000000000000000001783349948587918365145636425603013927107015277701295028477899535620468707992842960998768"
        "97036220978235643807646031628623453753183252563447406133248"},
    {1e+165, chars_format::fixed, 0,
        "9999999999999998994898934518334849272334583997405404203369513388555203571250442826162875703467631208965785"
        "85177704871391229197474064067196498264773607101557544845312"},
    {1e+166, chars_format::fixed, 0,
        "9999999999999999404072760505352583023983296100855298230449769143938302256661863838179600254051950569374547"
        "392515068357773127490685649548117139715971745147241514401792"},
    {1e+167, chars_format::fixed, 0,
        "1000000000000000038608994287419514402794020514913504389544238295685773910164927426701973917545431703435557"
        "50902863155030391327289536708508823166797373630632400726786048"},
    {1e+168, chars_format::fixed, 0,
        "9999999999999999338604948347429745623719502164303315186116928223077006466996036476256924325958459471709145"
        "54599698521475539380813444812793279458505403728617494385000448"},
    {1e+169, chars_format::fixed, 0,
        "9999999999999999338604948347429745623719502164303315186116928223077006466996036476256924325958459471709145"
        "545996985214755393808134448127932794585054037286174943850004480"},
    {1e+170, chars_format::fixed, 0,
        "1000000000000000034419054309312452809177137702974177474706936476750650979626314475538922658147448273184971"
        "79085147422915077831721209019419643357959500300321574675254607872"},
    {1e+171, chars_format::fixed, 0,
        "9999999999999999539722067296568702117329877137391007098307415531962907132849458132083384777061664123737260"
        "01850053663010587168093173889073910282723323583537144858509574144"},
    {1e+172, chars_format::fixed, 0,
        "1000000000000000082687162857105802367643627696515223533632653430883267139431135672937273166412217389671719"
        "2642523265688348930066834399772699475577180106550229078889679814656"},
    {1e+173, chars_format::fixed, 0,
        "1000000000000000014039186255799705217824619705701291360938300429450213045486501081081841332435656868446122"
        "85763778101906192989276863139689872767772084421689716760605683089408"},
    {1e+174, chars_format::fixed, 0,
        "1000000000000000068957567536844582937679826098352437099093782830596656320642208754566186799616905285426599"
        "982929417458880300383900478261195703581718577367397759832385751351296"},
    {1e+175, chars_format::fixed, 0,
        "9999999999999999371534524623368764100273307559896873275206250678451924602685103382037576783819090846734548"
        "822294900033162112051840457868829614121240178061963384891963422539776"},
    {1e+176, chars_format::fixed, 0,
        "1000000000000000007448980502074319891441994938583153872359642541312639852467816160263719876373907058408465"
        "60260278464628372543383280977318309056924111623883709653889736043921408"},
    {1e+177, chars_format::fixed, 0,
        "1000000000000000007448980502074319891441994938583153872359642541312639852467816160263719876373907058408465"
        "602602784646283725433832809773183090569241116238837096538897360439214080"},
    {1e+178, chars_format::fixed, 0,
        "1000000000000000052438118447506283719547380015442972461056613724331806183475371886382095683088785761598872"
        "4636416932177829345401680187244151732297960592357271816907060120777654272"},
    {1e+179, chars_format::fixed, 0,
        "9999999999999999804554977348151415945787638924672627191414598315011400538632827245926943923449798364942214"
        "8597943950338419997003168440244384097290815044070304544781216945608327168"},
    {1e+180, chars_format::fixed, 0,
        "1000000000000000009248546019891598444566210341657546615907521388633406505708118389308454908642502206536081"
        "877044340989143693798086218131232373875663313958712699944969706504756133888"},
    {1e+181, chars_format::fixed, 0,
        "9999999999999999171107915076469365246063817042486381462561244058101538598046442622180212564904306224021286"
        "256366562347133135483117101991090685868467907010818055540655879490029748224"},
    {1e+182, chars_format::fixed, 0,
        "1000000000000000064531198727238395596542107524102891697698359578327358093250202865562715099933745157016453"
        "82788895184180192194795092289050635704895322791329123657951217763820802932736"},
    {1e+183, chars_format::fixed, 0,
        "9999999999999999465948729515652283389935268682194888565445714403135947064937559828869600251790935293249936"
        "66087115356131035228239552737388526279268078143523691759154905886843985723392"},
    {1e+184, chars_format::fixed, 0,
        "1000000000000000017356668416969128693522675261749530561236844323121852738547624112492413070031884505939869"
        "7631682172475335672600663748292592247410791680053842186513692689376624118857728"},
    {1e+185, chars_format::fixed, 0,
        "9999999999999999796170441687537151711071294518668416520676321189574484547855611100361714461103959850786025"
        "1139162957211888350975873638026151889477992007905860430885494197722591793250304"},
    {1e+186, chars_format::fixed, 0,
        "9999999999999999796170441687537151711071294518668416520676321189574484547855611100361714461103959850786025"
        "11391629572118883509758736380261518894779920079058604308854941977225917932503040"},
    {1e+187, chars_format::fixed, 0,
        "9999999999999999071569656121801212080692814968920789464627446869617922299624001453201875281811380250249693"
        "879805812353226907091680705581859236698853640605134247712274342131878495422251008"},
    {1e+188, chars_format::fixed, 0,
        "1000000000000000023093091302697871548929838224851699275430564578154842189679457688865761796867950761110782"
        "38543825857419659919011313587350687602971665369018571203143144663564875896666980352"},
    {1e+189, chars_format::fixed, 0,
        "1000000000000000023093091302697871548929838224851699275430564578154842189679457688865761796867950761110782"
        "385438258574196599190113135873506876029716653690185712031431446635648758966669803520"},
    {1e+190, chars_format::fixed, 0,
        "1000000000000000072559171597318778361030342428781137282456834398397210172492068907445206818174324195174062"
        "5976868675721161334753163637413771490365780039321792212624518252692320803210995433472"},
    {1e+191, chars_format::fixed, 0,
        "1000000000000000072559171597318778361030342428781137282456834398397210172492068907445206818174324195174062"
        "59768686757211613347531636374137714903657800393217922126245182526923208032109954334720"},
    {1e+192, chars_format::fixed, 0,
        "1000000000000000040900880208761398001286019738266296957960021713442094663491997727554362004538245197373563"
        "261847757813447631532786297905940174312186739777303375354598782943738754654264509857792"},
    {1e+193, chars_format::fixed, 0,
        "1000000000000000066227513319607302289081477890678169217557471861406187070692054671467037855447108395613962"
        "7305190456203824330868103505742897540916997511012040520808812168041334151877325366493184"},
    {1e+194, chars_format::fixed, 0,
        "9999999999999999446596743875469617076632787591011823714897111511785435161317813406861937710845650440600452"
        "8089686414709538562749489776621177115003729674648080379472553427423904462708600804999168"},
    {1e+195, chars_format::fixed, 0,
        "9999999999999999770777647694297191960414651941883788637744473405725817973478542288944188602479099378077566"
        "00796112539971931616645685181699233267813951241073670004367049615544210109925082343145472"},
    {1e+196, chars_format::fixed, 0,
        "9999999999999999511432924639235132053389160461186216699466583890573511723749959183278387889172340228095875"
        "448767138256706948253250552493092635735926276453993770366538373425000777236538229086224384"},
    {1e+197, chars_format::fixed, 0,
        "9999999999999999511432924639235132053389160461186216699466583890573511723749959183278387889172340228095875"
        "4487671382567069482532505524930926357359262764539937703665383734250007772365382290862243840"},
    {1e+198, chars_format::fixed, 0,
        "1000000000000000017535541566019400541537441865177200086145798104936341572305513193378283771523764365204900"
        "328030374534281861011105867876227585990799216050325567033999660761493056632508247061001404416"},
    {1e+199, chars_format::fixed, 0,
        "1000000000000000097206240488534465344975672848047494185584765763991130052222133923438817750651600776079275"
        "6678147673846152604340428430285295728914471221362369950308146488642846313231335560438561636352"},
    {1e+200, chars_format::fixed, 0,
        "9999999999999999697331222125103616594745032754550236264824175095034684843555407553419633840470625186802751"
        "2415973882408182135734368278484639385041047239877871023591066789981811181813306167128854888448"},
    {1e+201, chars_format::fixed, 0,
        "1000000000000000037718785293056550291741793714171007924670336578563554653884390444993619046236149589293075"
        "414109087389699655531583234914810756005630018925423128793192791080866922220799992003324610084864"},
    {1e+202, chars_format::fixed, 0,
        "9999999999999999017474591319641730272072128367390393282944984404433823148266910656903077218579754480674748"
        "342103902584639871831041306548820316951909258721342916786285447187693014154661313392524876840960"},
    {1e+203, chars_format::fixed, 0,
        "9999999999999999887691078750632944765093445982954992299750348488402926118236186684444269694600068984518592"
        "0534555642245481492613075738123641525387194542623914743194966239051177873087980216425864602058752"},
    {1e+204, chars_format::fixed, 0,
        "9999999999999999887691078750632944765093445982954992299750348488402926118236186684444269694600068984518592"
        "05345556422454814926130757381236415253871945426239147431949662390511778730879802164258646020587520"},
    {1e+205, chars_format::fixed, 0,
        "1000000000000000016616035472855013340286026761993566398512806499527303906862635501325745128692656962574862"
        "2041088095949318798038992779336698179926498716835527012730124200454693714718121768282606166882648064"},
    {1e+206, chars_format::fixed, 0,
        "1000000000000000038893577551088388431307372492952020133343023820076912942893848967630799656078777013873264"
        "60311941213291353170611409437561654018367221268940354434586262616943544566455807655946219322240663552"},
    {1e+207, chars_format::fixed, 0,
        "1000000000000000038893577551088388431307372492952020133343023820076912942893848967630799656078777013873264"
        "603119412132913531706114094375616540183672212689403544345862626169435445664558076559462193222406635520"},
    {1e+208, chars_format::fixed, 0,
        "9999999999999999818630698308109481982927274216983785721776674794699138106539424938898600659703096825493544"
        "616522696356805028364441642842329313746550197144253860793660984920822957311285732475861572950035529728"},
    {1e+209, chars_format::fixed, 0,
        "1000000000000000073111882183254852571116159535704205070042237624441112422237792851875363410143857412667610"
        "68799969763125334902791605243044670546908252847439043930576054277584733562461577854658781477884848504832"},
    {1e+210, chars_format::fixed, 0,
        "9999999999999999271137824193446055745986681532948826734589253924871946437036322790985580594661810444784007"
        "25843812838336795121561031396504666917998514458446354143529431921823271795036250068185162804696593727488"},
    {1e+211, chars_format::fixed, 0,
        "9999999999999999563134023721266549739021664297767471527755878388779781994104643936539191296017163181162427"
        "18274989796920105902832035603293074628215317261635171175975654092628084560952155763865693199526971991654"
        "4"},
    {1e+212, chars_format::fixed, 0,
        "9999999999999999095940104476753759350165691874057639858689279246527245102795330103653414173848598802956955"
        "303851066631868086527984288724316222918684327765330639240616986193403841354867066507768445677983667689881"
        "6"},
    {1e+213, chars_format::fixed, 0,
        "9999999999999999843450375267974223972335247751993370529195837874131304128890232236270657569318301808085710"
        "3100891967716008425285219964180994603002344795269643552712402737660070481623142523171900237856413512525414"
        "4"},
    {1e+214, chars_format::fixed, 0,
        "9999999999999999544446266951486038123467425400819078260993214423089680518452271383223760211130420606034208"
        "3075939447157077401283069133405861653476144188223108688589909587369657654393353779934213925425782778274775"
        "04"},
    {1e+215, chars_format::fixed, 0,
        "9999999999999999066039693645104940765278909638940210631869016901423082741751534018348724438029810682751805"
        "1036015414262787762879627804165648934234223216948652905993920546904997130825691790753915825536773603473752"
        "064"},
    {1e+216, chars_format::fixed, 0,
        "1000000000000000021421546958041957442493134746744949294176709095342291740583330369404881029347127449862957"
        "2793183309320908289504788699434215946041483354800734678422429424402018238738808056478663126527039562299620"
        "72064"},
    {1e+217, chars_format::fixed, 0,
        "9999999999999999601855055748251769806450047292244542376488118125689672251656359867008764503902493796828096"
        "6920730331104392157891482092914687179785174704776043382501428272225416917221473218635849697412463879250897"
        "79712"},
    {1e+218, chars_format::fixed, 0,
        "1000000000000000082657588341258737904341264764265444350704606378115616256001024752108885608304005520043104"
        "8894293585531377363220429189576963174104449239123865018594716021581494785755468791093741283312832736674151"
        "6615680"},
    {1e+219, chars_format::fixed, 0,
        "9999999999999999650843888854825194175928551306260938421710435951908331863990515373171968167067996252972214"
        "7801618552072767416863994485028884962235547412234547654639257549968998154834801806327912222841098418750522"
        "5498624"},
    {1e+220, chars_format::fixed, 0,
        "9999999999999999964372420736895110140590976995965873111133270039707753382929110612616471611327211972294570"
        "5439303166270369074288073794559750769917932739968974996321364927527918075560104767557112385584359471548120"
        "96741376"},
    {1e+221, chars_format::fixed, 0,
        "1000000000000000046601807174820697568405085809949376861420980458018682781323086299572767712214195712321033"
        "9765959854898653172616660068980913606220974926434405874301273673162218994872058950552383264597357715602427"
        "8435495936"},
    {1e+222, chars_format::fixed, 0,
        "1000000000000000046601807174820697568405085809949376861420980458018682781323086299572767712214195712321033"
        "9765959854898653172616660068980913606220974926434405874301273673162218994872058950552383264597357715602427"
        "84354959360"},
    {1e+223, chars_format::fixed, 0,
        "1000000000000000046601807174820697568405085809949376861420980458018682781323086299572767712214195712321033"
        "9765959854898653172616660068980913606220974926434405874301273673162218994872058950552383264597357715602427"
        "843549593600"},
    {1e+224, chars_format::fixed, 0,
        "9999999999999999695490351794831950209296480724474921121484247526010969488287371335268865457530508571403718"
        "2409224841134505892881183378706080253249519082903930108094789640533388351546084948006950326015738792668900"
        "564521713664"},
    {1e+225, chars_format::fixed, 0,
        "9999999999999999284542234486365269956094146124464869125363950430450511714984175783024165903071069343773520"
        "0942358863613425448462294146117783821804062986135861502805217858619360833053015850664613088704891665546032"
        "3666687950848"},
    {1e+226, chars_format::fixed, 0,
        "9999999999999999613300728333138614158656013804472910722260188106898877933626732224819925546638620725877678"
        "6115851645630289803997405532188420966960427863550316387036875284150582847847471128538482878553569367244326"
        "92495112994816"},
    {1e+227, chars_format::fixed, 0,
        "1000000000000000092833470372023199096890348452450507710984513881269234280819695799200296412090882625429431"
        "2680982277369774722613785107647096954758588737320813592396350498627547090702529224003396203794828017403750"
        "5158080469401600"},
    {1e+228, chars_format::fixed, 0,
        "9999999999999999245091215224752468651786722002863904133736401909276707768747069010008674745842963177921021"
        "0721539729771401725798080779789307364385299200846126916697418967555614191277681217319748713923050341342237"
        "0196749149011968"},
    {1e+229, chars_format::fixed, 0,
        "9999999999999999918388610622944277578633427011520373324179896670642961784527024602806390495869308408470337"
        "7156852947341939925933988898461972237665534469790930519603853375043556877576725626405434043533142274420344"
        "27503713670135808"},
    {1e+230, chars_format::fixed, 0,
        "1000000000000000099566444326005117186158815502537072402888948828882896820977495355128273569591146077734924"
        "4345335409545480104615144188833823603491391090010261628425414842702426517565519668094253057090928936734531"
        "5883616691581616128"},
    {1e+231, chars_format::fixed, 0,
        "1000000000000000056475411020520841414840626381983058374700565164155456563967578197189219761589459982979768"
        "1693475363620965659806446069238773051601456032797794197839403040623198185642380825912769195995883053017532"
        "72401848696295129088"},
    {1e+232, chars_format::fixed, 0,
        "1000000000000000056475411020520841414840626381983058374700565164155456563967578197189219761589459982979768"
        "1693475363620965659806446069238773051601456032797794197839403040623198185642380825912769195995883053017532"
        "724018486962951290880"},
    {1e+233, chars_format::fixed, 0,
        "9999999999999999737406270739910319339097032705193514405788685278787712705085372539462364502262226810498681"
        "4019040754458979257737456796162759919727807229498567311142603806310797883499542489243201826933949562808949"
        "044795771481474727936"},
    {1e+234, chars_format::fixed, 0,
        "1000000000000000017865845178806930323739528929966661805443773400559670093686692423675827549619949242079148"
        "1557408762472600717257852554081607757108074221535423380034336465960209600239248423318159656454721941207101"
        "74156699571604284243968"},
    {1e+235, chars_format::fixed, 0,
        "1000000000000000053166019662659649035603389457524510097335697298704389152229216559459500429134930490902572"
        "1681812512093962950445138053653873169216309020403876699170397334223513449750683762833231235463783529148067"
        "211236930570359138156544"},
    {1e+236, chars_format::fixed, 0,
        "1000000000000000053166019662659649035603389457524510097335697298704389152229216559459500429134930490902572"
        "1681812512093962950445138053653873169216309020403876699170397334223513449750683762833231235463783529148067"
        "2112369305703591381565440"},
    {1e+237, chars_format::fixed, 0,
        "9999999999999999402054613143309491576390357693393955632815408246412881648931393249517472146869904946676153"
        "2837205133056038042458244550226238504699576640248260779350025557809411313140906763850021826347864477369777"
        "0829313903654699186257920"},
    {1e+238, chars_format::fixed, 0,
        "1000000000000000048647597328726501040484815309997105515973531039741865112735773470079190300557012891053173"
        "8945888832142428584597165509708623196466454966148714674320981543085810557013220039375302073350623645891623"
        "631119178909006652304785408"},
    {1e+239, chars_format::fixed, 0,
        "9999999999999999908117914543822067029670662216463268745378029250215574072197019260112206547596676129808759"
        "9260657287627887017431169472094235452683230716826407562484594165232135299736843791138087983021771402091458"
        "056119576436948334022754304"},
    {1e+240, chars_format::fixed, 0,
        "1000000000000000013946113804119924437974165856986638331112094170909680489426130543638408513078605724209795"
        "1533994970114644654884736372209103405747575829469070323477468267148252340789498643218406108321555742482136"
        "93581484614981956096327942144"},
    {1e+241, chars_format::fixed, 0,
        "1000000000000000050961029563700272813985525273531136661630960164330677420956416331841909086388906702176065"
        "8106681756277614179911327452208591182514380241927357631043882428148314438094801465785761804352561506118922"
        "744139467759619125060885807104"},
    {1e+242, chars_format::fixed, 0,
        "1000000000000000050961029563700272813985525273531136661630960164330677420956416331841909086388906702176065"
        "8106681756277614179911327452208591182514380241927357631043882428148314438094801465785761804352561506118922"
        "7441394677596191250608858071040"},
    {1e+243, chars_format::fixed, 0,
        "1000000000000000074650575649831695774632795300119615593163034400120115457135799236292149453307499328074479"
        "0313201299421914675928345743408263359645135065900661507886387491188354180370195272228869449812405194846465"
        "66146722558989084608335389392896"},
    {1e+244, chars_format::fixed, 0,
        "1000000000000000074650575649831695774632795300119615593163034400120115457135799236292149453307499328074479"
        "0313201299421914675928345743408263359645135065900661507886387491188354180370195272228869449812405194846465"
        "661467225589890846083353893928960"},
    {1e+245, chars_format::fixed, 0,
        "1000000000000000044327956659583474385004289666086362560801979378309634770826189118595841783651700766924510"
        "1088856284197210041026562330672682972917768891214832545527981010497103310257691199981691663623805273275210"
        "7272876955671430431745947427930112"},
    {1e+246, chars_format::fixed, 0,
        "1000000000000000068586051851782051496707094173312964986690823395758019319873877212752887919376339615844485"
        "2468332296376973748947989060861147282299661830963495715414706195050104006347694457779433892574685210532214"
        "67463131958534128550160206370177024"},
    {1e+247, chars_format::fixed, 0,
        "9999999999999999521471949292288813605336325386252733424243721120057734844449743607990664678980731410286045"
        "8468474379141079509251407559565185972665757201699124999584253091957006651156788203502711936104615116985957"
        "27381924297989722331966923339726848"},
    {1e+248, chars_format::fixed, 0,
        "1000000000000000045298280467271417469472401846375426657837533139007570152788096642362123629080686320881309"
        "1144035324684400589343419399880221545293044608804779072323450017879223338101291330293601352781840470765490"
        "8851814405278709728676750356293615616"},
    {1e+249, chars_format::fixed, 0,
        "9999999999999999210968330832147026575540427693752222372866517696718412616639336002780474141705354144110364"
        "0811181423240104047857145413152842812577527572916236425034170729678597741204746503691611405533351920096306"
        "7478208555469597215339755257651527680"},
    {1e+250, chars_format::fixed, 0,
        "9999999999999999210968330832147026575540427693752222372866517696718412616639336002780474141705354144110364"
        "0811181423240104047857145413152842812577527572916236425034170729678597741204746503691611405533351920096306"
        "74782085554695972153397552576515276800"},
    {1e+251, chars_format::fixed, 0,
        "1000000000000000048279115204488778624958442464223431563930754291871627646175076555372141458238529942636595"
        "6593545337061049953772804316485780039629891613241094802639130808557096063636830930611787917875324597455631"
        "5302310250472271728848176952226298724352"},
    {1e+252, chars_format::fixed, 0,
        "1000000000000000099152028052998409011920202342162715294588395300751542199979533737409779075865727753926819"
        "3598516214955865773367640226553978342978747155620883266693416302792790579443373442708838628804120359634031"
        "87241060084423965317738575228107571068928"},
    {1e+253, chars_format::fixed, 0,
        "9999999999999999363587069377675917736425707327570073564839440723358156278052707548893386994586947577981035"
        "1826094056924551506641653143357437722624094200055601817197027212385681288624374039982763538319739206631507"
        "77435958293799716241167969694049028276224"},
    {1e+254, chars_format::fixed, 0,
        "9999999999999999363587069377675917736425707327570073564839440723358156278052707548893386994586947577981035"
        "1826094056924551506641653143357437722624094200055601817197027212385681288624374039982763538319739206631507"
        "774359582937997162411679696940490282762240"},
    {1e+255, chars_format::fixed, 0,
        "9999999999999999884525696946414532898914128477668338966773684654288481309010349092958796199089453165592925"
        "8756995846567465499292772862455788348916374954024635689112910673359193130483369363856562818230607811338327"
        "2782784390994049606075766012189756664840192"},
    {1e+256, chars_format::fixed, 0,
        "1000000000000000030127659900140542502890486539774695128832107979903274133377646232821112356269145763568243"
        "8430171727828179669341366863773446884995019955719986278664561744213800260397056562295560224215930269510378"
        "288141352402853119916429412464176397346144256"},
    {1e+257, chars_format::fixed, 0,
        "1000000000000000030127659900140542502890486539774695128832107979903274133377646232821112356269145763568243"
        "8430171727828179669341366863773446884995019955719986278664561744213800260397056562295560224215930269510378"
        "2881413524028531199164294124641763973461442560"},
    {1e+258, chars_format::fixed, 0,
        "1000000000000000056799717631659959599209893702659726317411141269166906774962677479877261307539674049653972"
        "6465033899457896865765104193391282437061184730323200812906654977415644066700237122877898747347366742071367"
        "44674199783831719918405933396323484899269935104"},
    {1e+259, chars_format::fixed, 0,
        "9999999999999999287738405203667575368767393208115766122317814807014700953545274940077463414411382764424743"
        "8976954756352543229311650112256717871435938122277710485446074580467937964449704320826738363164716737786194"
        "85458899748089618699435710767754281089234894848"},
    {1e+260, chars_format::fixed, 0,
        "1000000000000000065334776105746173070032103994782936297756431921731269220269887478935228971946243101201405"
        "8636189794379406368620700138868989813722357458196229463864124812040234084717254902264247074749426413290883"
        "9774942043776657045497009088429335535195969814528"},
    {1e+261, chars_format::fixed, 0,
        "9999999999999999287738405203667575368767393208115766122317814807014700953545274940077463414411382764424743"
        "8976954756352543229311650112256717871435938122277710485446074580467937964449704320826738363164716737786194"
        "8545889974808961869943571076775428108923489484800"},
    {1e+262, chars_format::fixed, 0,
        "1000000000000000016172839295009583478096172712153246810967557762960541535300357884361335224964405364288190"
        "5330331839631511632172467492917395324154002545647584434349098564602595580939232492998880708913562707066468"
        "760361494711018313643605437535869015444666630275072"},
    {1e+263, chars_format::fixed, 0,
        "1000000000000000016172839295009583478096172712153246810967557762960541535300357884361335224964405364288190"
        "5330331839631511632172467492917395324154002545647584434349098564602595580939232492998880708913562707066468"
        "7603614947110183136436054375358690154446666302750720"},
    {1e+264, chars_format::fixed, 0,
        "1000000000000000044140518902895287779286391397382581274563006173283444396083023609274483667691850832398819"
        "6988775476110313971129684287058746855997333340341924717806535718700452151977396352492066908144631837718580"
        "52833032509915549602573975010166573043840478561173504"},
    {1e+265, chars_format::fixed, 0,
        "1000000000000000066514662589203851220238566345566048845439364901541766684709156189205002421873807206887323"
        "0315530385293355842295457722371828081471997976097396944572485441978737408807927440086615867529487142240269"
        "942705389409665241931447200154303102433395309881065472"},
    {1e+266, chars_format::fixed, 0,
        "1000000000000000030716032691110149714715086428472500732037190936328451022907344061316172415182677007705717"
        "6992722530600488848430220225870898120712534558888641381746965884733480997879077699935337532513718655005566"
        "8797052865128496484823152800700833072414104710501367808"},
    {1e+267, chars_format::fixed, 0,
        "9999999999999999734382248541602273058775185611228237505937125919871459640244446566940444044768686890151491"
        "6762299630919016582458402314694101834973930913546324812261345931410707403929181156932921964884890754300419"
        "7890512187794469896370420793533163493423472892065087488"},
    {1e+268, chars_format::fixed, 0,
        "9999999999999999734382248541602273058775185611228237505937125919871459640244446566940444044768686890151491"
        "6762299630919016582458402314694101834973930913546324812261345931410707403929181156932921964884890754300419"
        "78905121877944698963704207935331634934234728920650874880"},
    {1e+269, chars_format::fixed, 0,
        "1000000000000000046753818885456127989189605431330410286841364872744016439394555894610368258180303336939076"
        "8881340449502893261681846624303314743132774169798163873892798646379355869975202383523110226600782937286713"
        "8519293326106230343475263802678137754874196788463928344576"},
    {1e+270, chars_format::fixed, 0,
        "1000000000000000046753818885456127989189605431330410286841364872744016439394555894610368258180303336939076"
        "8881340449502893261681846624303314743132774169798163873892798646379355869975202383523110226600782937286713"
        "85192933261062303434752638026781377548741967884639283445760"},
    {1e+271, chars_format::fixed, 0,
        "9999999999999999529098585253973751145501342374646995204443699533752222309208135100774737254399069875964494"
        "0587990268968240092837584414759169067994863893904436912794686582343509041098785207009431480570467941101738"
        "54458342872794765056233999682236635579342942941443126198272"},
    {1e+272, chars_format::fixed, 0,
        "1000000000000000065522610957467878564117499670103552440120763856617775281089304371516947164728382606807602"
        "3845848734024107112161464260868794310399431725879707910415464644008356863148267156087543642309530165922021"
        "8514235305581886882057848563849292034690350260273827761094656"},
    {1e+273, chars_format::fixed, 0,
        "9999999999999999454023416965926748845789765419554426591326103598257186942429141193148421628206752796490392"
        "0729957130883384690919113868497250798928233669578260766704022591827505068406526116751697817735479026560506"
        "5466066369376850351293060923539046438669680406904714953752576"},
    {1e+274, chars_format::fixed, 0,
        "9999999999999999213782878444176341486712719163258207029349796604673073768736360688744211624391338142173265"
        "7184251089011847404780008120459112337915016951734497099213897822176292355791297027926950096663514500028564"
        "15308090320884466574359759805482716570229159677380024223137792"},
    {1e+275, chars_format::fixed, 0,
        "9999999999999999598167740078976993261235993173332158328511887794407654846644809495790947630496001589080667"
        "8857380756006307062602577317320133875536163700284518967198097453618232695975663570046546450378657742479671"
        "982722077174989256760731188933351130765773907040474247261585408"},
    {1e+276, chars_format::fixed, 0,
        "1000000000000000052069140800249855752009185079750964144650090664977064943362508663270311404514719386165843"
        "3087289195679301024137674338978658556582691589680457145036017656907888951241814327113357769929500152436233"
        "07738608946937362752018518070418086469181314516804918593340833792"},
    {1e+277, chars_format::fixed, 0,
        "1000000000000000002867878510995372324870206006461498378357342992691038565390227215968329195733322464961695"
        "8313128598304010187936385481780447799767184805866054345934040104083320587698215409722049436653961817402491"
        "275192019201707119869992081071729797163687409453914913289541779456"},
    {1e+278, chars_format::fixed, 0,
        "9999999999999999635068686795917855831590227478299257653231448548622174630124020581267434287082049279983778"
        "4938001204037775189753543960218791943147793788145321066524580618236658968633362758090027700335311493754978"
        "334367629875739137498376013657689431411868208826074951744485326848"},
    {1e+279, chars_format::fixed, 0,
        "1000000000000000057973292274960393763265862568545700036605220385651388108719182436946549269568487016710341"
        "0060188467364335924481829001842443847400552403738185480928254963246837154867046197200314769922564752640282"
        "09364937790149360843820835266007499279518823345374529865067232493568"},
    {1e+280, chars_format::fixed, 0,
        "1000000000000000032782245982862098248570705283021493564263333577440942603197374335927934378672411793053817"
        "4975818241508187016346769106956959939911012930425211247788042456200658152732723551495964903285489125103006"
        "290926013924448356521309485648260046220787856768108551057012647002112"},
    {1e+281, chars_format::fixed, 0,
        "1000000000000000032782245982862098248570705283021493564263333577440942603197374335927934378672411793053817"
        "4975818241508187016346769106956959939911012930425211247788042456200658152732723551495964903285489125103006"
        "2909260139244483565213094856482600462207878567681085510570126470021120"},
    {1e+282, chars_format::fixed, 0,
        "1000000000000000032782245982862098248570705283021493564263333577440942603197374335927934378672411793053817"
        "4975818241508187016346769106956959939911012930425211247788042456200658152732723551495964903285489125103006"
        "29092601392444835652130948564826004622078785676810855105701264700211200"},
    {1e+283, chars_format::fixed, 0,
        "9999999999999999553953517735361344274271821018911312812290573026184540102343798495987494338396687059809772"
        "7966329076780975705558651098687533761031476684077544035813096345547962581760843838922021129763927973084950"
        "24959839786965342632596166187964530344229899589832462449290116390191104"},
    {1e+284, chars_format::fixed, 0,
        "1000000000000000079214382508457676541256819191699710934083899342334435758975171027725445345572057645297521"
        "6283329441806240683821311505209883878195732087635685354312082149188175289466707052058222577470946921779713"
        "0505057184069381648545374773244373557467226310750742042216461653692645376"},
    {1e+285, chars_format::fixed, 0,
        "9999999999999999801591579205204428501931095198528472118000257105616503599825380852240886161861464938442861"
        "4939722145037261932089543889369794765216645522533405937274641374814720644342089175254062058753036222027386"
        "3006901551095990707698442841525909542472844588688081080376132618600579072"},
    {1e+286, chars_format::fixed, 0,
        "1000000000000000032988611034086967485427088011504507863684758314173802572778608987891478871858632441286011"
        "7381629402398400588202211517615861824081167237790591132705927077058380451118207922609574937392980048643791"
        "654301923722148311225012721166820834263125344653917287293299907083743789056"},
    {1e+287, chars_format::fixed, 0,
        "1000000000000000075252173524940187193614270804825836385192544397063524343015465710025391076396621199239392"
        "2091755152714140104196817220558967702128769386220391563888697428719907160465407126676909922607121189796634"
        "0736882502910990345434353553680702253338428636675464684849307718019341877248"},
    {1e+288, chars_format::fixed, 0,
        "1000000000000000007630473539575035660514778335511710750780086664439969510636494954611131549135839186513983"
        "4555553952208956878605448095849998297252605948732710873996264866061464425509888400169173946264495363952086"
        "20267012778077787723395914064607119962069483324573977857832138825282954985472"},
    {1e+289, chars_format::fixed, 0,
        "1000000000000000061727833527867156886994372310963011258310052850538813376539671558942539170944464796694310"
        "4584514912613103459078543395617173821153536698722855425910210916188218613474303381375362727338596024627724"
        "499484625789034803081540112423670420191213257583185130503608895092113260150784"},
    {1e+290, chars_format::fixed, 0,
        "1000000000000000061727833527867156886994372310963011258310052850538813376539671558942539170944464796694310"
        "4584514912613103459078543395617173821153536698722855425910210916188218613474303381375362727338596024627724"
        "4994846257890348030815401124236704201912132575831851305036088950921132601507840"},
    {1e+291, chars_format::fixed, 0,
        "9999999999999999578609023503462841321535518780965142838525177732290331540055724786262365370719036251480826"
        "1289098686371420245702004200641968152637496587417778862354344999448505725826266174594802676763227561304989"
        "6960078961318150545418464661067991669581788285529005480705688196068853638234112"},
    {1e+292, chars_format::fixed, 0,
        "1000000000000000013256598978357416268068656108958646003563203147794249272690425321461597941803936249972737"
        "4638565892090988122974650007025784551738302746731685907395315255274646861058187558214617579496201832662352"
        "585538835573636597522107561710941518560028749376834095178551288964115055725510656"},
    {1e+293, chars_format::fixed, 0,
        "9999999999999999246234843735396048506044893395792352520261065484899034827946607729250196942326840502532897"
        "0231162545648343655275306678872441733790178059478330735395060467469727994972900530063978805843953102113868"
        "000379620369084502134308975505229555772913629423636305841602377586326247764393984"},
    {1e+294, chars_format::fixed, 0,
        "1000000000000000066436467741248103118547156170586292454485461107376856746627884050583544890346687569804406"
        "1207835674606680377442921610508908778753873711201997607708800780391251297994726061339549398843285746132932"
        "05683935969567348590731356020719265634967118123751637393518591968740451429495341056"},
    {1e+295, chars_format::fixed, 0,
        "9999999999999999813486777206230041577815560719820581330098483720446847883279500839884297726782854580737362"
        "6970040225815727702936870449359100155289601680494988872072239402046841988962644563396584878879514845800049"
        "02758521100414464490983962613190835886243290260424727924570510530141380583845003264"},
    {1e+296, chars_format::fixed, 0,
        "9999999999999999813486777206230041577815560719820581330098483720446847883279500839884297726782854580737362"
        "6970040225815727702936870449359100155289601680494988872072239402046841988962644563396584878879514845800049"
        "027585211004144644909839626131908358862432902604247279245705105301413805838450032640"},
    {1e+297, chars_format::fixed, 0,
        "1000000000000000017652801462756379714374878780719864776839443139119744823869255243069012222883470359078822"
        "0728292194112285349344027126247056154504923279794565007954563392017619494511608074472945276562227436175920"
        "48849967890105831362861792425329827928397252374398383022243308510390698430058459037696"},
    {1e+298, chars_format::fixed, 0,
        "9999999999999999595662034753429788238255624467393741467120915117996487670031669885400803025551745174706847"
        "8782311196631452228634829961492223321433823010024592147588202691169230215270582854596864146833859136224555"
        "51313826420028155008403585629126369847605750170289266545852965785882018353801250996224"},
    {1e+299, chars_format::fixed, 0,
        "1000000000000000052504760255204420248704468581108159154915854115511802457988908195786371375080447864043704"
        "4438328838781769425232353604305756447921847867069828483872009265758037378302337947880900593689532349707999"
        "4508111903896764088007465274278014249457925878882005684283811566947219638686545940054016"},
    {1e+300, chars_format::fixed, 0,
        "1000000000000000052504760255204420248704468581108159154915854115511802457988908195786371375080447864043704"
        "4438328838781769425232353604305756447921847867069828483872009265758037378302337947880900593689532349707999"
        "45081119038967640880074652742780142494579258788820056842838115669472196386865459400540160"},
    {1e+301, chars_format::fixed, 0,
        "1000000000000000052504760255204420248704468581108159154915854115511802457988908195786371375080447864043704"
        "4438328838781769425232353604305756447921847867069828483872009265758037378302337947880900593689532349707999"
        "450811190389676408800746527427801424945792587888200568428381156694721963868654594005401600"},
    {1e+302, chars_format::fixed, 0,
        "1000000000000000076297030790848949253473468551506568117016017342062113802881257944841421889646917840766397"
        "4757713854876137221038784479993829181561135051983075016764985648898162653636809541460731423515105837345898"
        "6890825155659063617715863205282622390509284183439858617103083735673849899204570498157510656"},
    {1e+303, chars_format::fixed, 0,
        "1000000000000000000161765076786456438212668646231659438295495017101117499225738747865260243034213915253779"
        "7735681803374160274458205677791996433915416060260686111507461222849761772566500442005272768073270676904621"
        "12661427500197051226489898260678763391449376088547292320814127957486330655468919122263277568"},
    {1e+304, chars_format::fixed, 0,
        "9999999999999999392535525055364621860040287220117324953190771571323204563013233902843309257440507748436856"
        "1180561621725787171937426360305302357988408668827749873014416820110410677102531624409058437198025485515990"
        "76639682550821832659549112269607949805346034918662572406407604380845959862074904348138143744"},
    {1e+305, chars_format::fixed, 0,
        "9999999999999999392535525055364621860040287220117324953190771571323204563013233902843309257440507748436856"
        "1180561621725787171937426360305302357988408668827749873014416820110410677102531624409058437198025485515990"
        "766396825508218326595491122696079498053460349186625724064076043808459598620749043481381437440"},
    {1e+306, chars_format::fixed, 0,
        "1000000000000000017216064596736454828831087825013238982328892017892380671244575047987920451875459594568606"
        "1388616982910603110492255329485206969388057114406501226285146694284603569926249680283295506892241752843467"
        "30060716088829214255439694630119794546505512415617982143262670862918816362862119154749127262208"},
    {1e+307, chars_format::fixed, 0,
        "9999999999999999860310597602564577717002641838126363875249660735883565852672743849064846414228960666786379"
        "2803926546153933531728502521033362759523706153970107306916646893751785690398510731463396416232660711267200"
        "11020169553304018596457812688561947201171488461172921822139066929851282122002676667750021070848"},
    {1e+308, chars_format::fixed, 0,
        "1000000000000000010979063629440455417404923096773118463368106829031575854049114915371633289784946888990612"
        "4966972117251561159028374314008832830700919814604603127166450293302718569748969958855904333838446616500117"
        "8426897626212945177628091195786707458122783970171784415105291802893207873272974885715430223118336"},
};

#endif // DOUBLE_FIXED_PRECISION_TO_CHARS_TEST_CASES_2_HPP
