; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-amd-mesa3d -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck -check-prefix=GFX10 %s

define float @test_fmed3_f32_known_nnan_ieee_true(float %a) #0 {
; GFX10-LABEL: test_fmed3_f32_known_nnan_ieee_true:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_mul_f32_e64 v0, v0, 2.0 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fmul = fmul float %a, 2.0
  %fmed = call nnan float @llvm.amdgcn.fmed3.f32(float %fmul, float 0.0, float 1.0)
  ret float %fmed
}

define half @test_fmed3_f16_known_nnan_ieee_false(half %a) #1 {
; GFX10-LABEL: test_fmed3_f16_known_nnan_ieee_false:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_mul_f16_e64 v0, v0, 2.0 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fmul = fmul half %a, 2.0
  %fmed = call nnan half @llvm.amdgcn.fmed3.f16(half %fmul, half 0.0, half 1.0)
  ret half %fmed
}

; %fmin is known non-SNaN because fmin inputs are fcanonicalized
define float @test_fmed3_non_SNaN_input_ieee_true_dx10clamp_true(float %a) #2 {
; GFX10-LABEL: test_fmed3_non_SNaN_input_ieee_true_dx10clamp_true:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX10-NEXT:    v_min_f32_e64 v0, 0x41200000, v0 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fmin = call float @llvm.minnum.f32(float %a, float 10.0)
  %fmed = call float @llvm.amdgcn.fmed3.f32(float %fmin, float 0.0, float 1.0)
  ret float %fmed
}

; input may be SNaN. It's safe to clamp since third operand in fmed3 is 0.0
define float @test_fmed3_maybe_SNaN_input_zero_third_operand_ieee_true_dx10clamp_true(float %a) #2 {
; GFX10-LABEL: test_fmed3_maybe_SNaN_input_zero_third_operand_ieee_true_dx10clamp_true:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_mul_f32_e64 v0, v0, 2.0 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fmul = fmul float %a, 2.0
  %fmed = call float @llvm.amdgcn.fmed3.f32(float %fmul, float 1.0, float 0.0)
  ret float %fmed
}

; global nnan function attribute always forces clamp combine

define float @test_fmed3_global_nnan(float %a) #3 {
; GFX10-LABEL: test_fmed3_global_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_mul_f32_e64 v0, v0, 2.0 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fmul = fmul float %a, 2.0
  %fmed = call float @llvm.amdgcn.fmed3.f32(float %fmul, float 0.0, float 1.0)
  ret float %fmed
}

; ------------------------------------------------------------------------------
; Negative patterns
; ------------------------------------------------------------------------------

; ieee=false requires known never NaN input
define float @test_fmed3_f32_maybe_NaN_ieee_false(float %a) #1 {
; GFX10-LABEL: test_fmed3_f32_maybe_NaN_ieee_false:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_mul_f32_e32 v0, 2.0, v0
; GFX10-NEXT:    v_med3_f32 v0, v0, 1.0, 0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fmul = fmul float %a, 2.0
  %fmed = call float @llvm.amdgcn.fmed3.f32(float %fmul, float 1.0, float 0.0)
  ret float %fmed
}

; ieee=true input is known non-SNaN but dx10_clamp=false
define float @test_fmed3_non_SNaN_input_ieee_true_dx10clamp_false(float %a) #4 {
; GFX10-LABEL: test_fmed3_non_SNaN_input_ieee_true_dx10clamp_false:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX10-NEXT:    v_min_f32_e32 v0, 0x41200000, v0
; GFX10-NEXT:    v_med3_f32 v0, v0, 0, 1.0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fmin = call float @llvm.minnum.f32(float %a, float 10.0)
  %fmed = call float @llvm.amdgcn.fmed3.f32(float %fmin, float 0.0, float 1.0)
  ret float %fmed
}

; ieee=true dx10_clamp=true but input may be SNaN, clamp requires third operand in fmed3 to be 0.0
define float @test_fmed3_maybe_SNaN_input_ieee_true_dx10clamp_true(float %a) #2 {
; GFX10-LABEL: test_fmed3_maybe_SNaN_input_ieee_true_dx10clamp_true:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_mul_f32_e32 v0, 2.0, v0
; GFX10-NEXT:    v_med3_f32 v0, v0, 0, 1.0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %fmul = fmul float %a, 2.0
  %fmed = call float @llvm.amdgcn.fmed3.f32(float %fmul, float 0.0, float 1.0)
  ret float %fmed
}

declare half @llvm.amdgcn.fmed3.f16(half, half, half)
declare float @llvm.amdgcn.fmed3.f32(float, float, float)
declare float @llvm.minnum.f32(float, float)

attributes #0 = {"amdgpu-ieee"="true"}
attributes #1 = {"amdgpu-ieee"="false"}
attributes #2 = {"amdgpu-ieee"="true" "amdgpu-dx10-clamp"="true"}
attributes #3 = {"no-nans-fp-math"="true"}
attributes #4 = {"amdgpu-ieee"="true" "amdgpu-dx10-clamp"="false"}
