//
// Copyright (C) 2011-14 Irwin Zaid, DyND Developers
// BSD 2-Clause License, see LICENSE.txt
//

#include "inc_gtest.hpp"

#include <dynd/pp/comparison.hpp>

using namespace std;

TEST(PPComparision, LessThan) {
    EXPECT_FALSE(DYND_PP_LT(0, 0));

    EXPECT_TRUE(DYND_PP_LT(0, 1));
    EXPECT_FALSE(DYND_PP_LT(1, 0));
    EXPECT_FALSE(DYND_PP_LT(1, 1));

    EXPECT_FALSE(DYND_PP_LT(4, 2));

    EXPECT_TRUE(DYND_PP_LT(3, 4));
    EXPECT_FALSE(DYND_PP_LT(4, 3));

    EXPECT_FALSE(DYND_PP_LT(4, 4));

    EXPECT_TRUE(DYND_PP_LT(0, 8));
    EXPECT_FALSE(DYND_PP_LT(8, 0));
    EXPECT_FALSE(DYND_PP_LT(8, 8));

    EXPECT_TRUE(DYND_PP_LT(0, DYND_PP_LEN_MAX));
    EXPECT_FALSE(DYND_PP_LT(DYND_PP_LEN_MAX, 0));
    EXPECT_TRUE(DYND_PP_LT(3, DYND_PP_LEN_MAX));
    EXPECT_FALSE(DYND_PP_LT(DYND_PP_LEN_MAX, 4));
    EXPECT_FALSE(DYND_PP_LT(DYND_PP_LEN_MAX, DYND_PP_LEN_MAX));
}

TEST(PPComparision, LessEqual) {
    EXPECT_TRUE(DYND_PP_LE(0, 0));

    EXPECT_TRUE(DYND_PP_LE(0, 1));
    EXPECT_FALSE(DYND_PP_LE(1, 0));
    EXPECT_TRUE(DYND_PP_LE(1, 1));

    EXPECT_FALSE(DYND_PP_LE(4, 2));

    EXPECT_TRUE(DYND_PP_LE(3, 4));
    EXPECT_FALSE(DYND_PP_LE(4, 3));

    EXPECT_TRUE(DYND_PP_LE(4, 4));

    EXPECT_TRUE(DYND_PP_LE(0, 8));
    EXPECT_FALSE(DYND_PP_LE(8, 0));
    EXPECT_TRUE(DYND_PP_LE(8, 8));

    EXPECT_TRUE(DYND_PP_LE(0, DYND_PP_LEN_MAX));
    EXPECT_FALSE(DYND_PP_LE(DYND_PP_LEN_MAX, 0));
    EXPECT_TRUE(DYND_PP_LE(3, DYND_PP_LEN_MAX));
    EXPECT_FALSE(DYND_PP_LE(DYND_PP_LEN_MAX, 4));
    EXPECT_TRUE(DYND_PP_LE(DYND_PP_LEN_MAX, DYND_PP_LEN_MAX));
}

TEST(PPComparision, Equal) {
    EXPECT_TRUE(DYND_PP_EQ(0, 0));

    EXPECT_FALSE(DYND_PP_EQ(0, 1));
    EXPECT_FALSE(DYND_PP_EQ(1, 0));
    EXPECT_TRUE(DYND_PP_EQ(1, 1));

    EXPECT_FALSE(DYND_PP_EQ(4, 2));

    EXPECT_FALSE(DYND_PP_EQ(3, 4));
    EXPECT_FALSE(DYND_PP_EQ(4, 3));

    EXPECT_TRUE(DYND_PP_EQ(4, 4));

    EXPECT_FALSE(DYND_PP_EQ(0, 8));
    EXPECT_FALSE(DYND_PP_EQ(8, 0));
    EXPECT_TRUE(DYND_PP_EQ(8, 8));

    EXPECT_FALSE(DYND_PP_EQ(0, DYND_PP_LEN_MAX));
    EXPECT_FALSE(DYND_PP_EQ(DYND_PP_LEN_MAX, 0));
    EXPECT_FALSE(DYND_PP_EQ(3, DYND_PP_LEN_MAX));
    EXPECT_FALSE(DYND_PP_EQ(DYND_PP_LEN_MAX, 4));
    EXPECT_TRUE(DYND_PP_EQ(DYND_PP_LEN_MAX, DYND_PP_LEN_MAX));

    EXPECT_TRUE(DYND_PP_EQ(A, A));
    EXPECT_FALSE(DYND_PP_EQ(A, B));
    EXPECT_FALSE(DYND_PP_EQ(B, A));

    EXPECT_TRUE(DYND_PP_EQ(P, P));
    EXPECT_FALSE(DYND_PP_EQ(P, Q));
    EXPECT_FALSE(DYND_PP_EQ(Q, P));
    EXPECT_TRUE(DYND_PP_EQ(Q, Q));

    EXPECT_FALSE(DYND_PP_EQ(Z, A));
    EXPECT_FALSE(DYND_PP_EQ(A, Z));
    EXPECT_FALSE(DYND_PP_EQ(P, Z));
    EXPECT_FALSE(DYND_PP_EQ(Z, Q));
    EXPECT_TRUE(DYND_PP_EQ(Z, Z));

    EXPECT_TRUE(DYND_PP_EQ(a, a));
    EXPECT_FALSE(DYND_PP_EQ(a, b));
    EXPECT_FALSE(DYND_PP_EQ(b, a));

    EXPECT_TRUE(DYND_PP_EQ(p, p));
    EXPECT_FALSE(DYND_PP_EQ(p, q));
    EXPECT_FALSE(DYND_PP_EQ(q, p));
    EXPECT_TRUE(DYND_PP_EQ(q, q));

    EXPECT_FALSE(DYND_PP_EQ(z, a));
    EXPECT_FALSE(DYND_PP_EQ(a, z));
    EXPECT_FALSE(DYND_PP_EQ(p, z));
    EXPECT_FALSE(DYND_PP_EQ(z, q));
    EXPECT_TRUE(DYND_PP_EQ(z, z));

    EXPECT_FALSE(DYND_PP_EQ(A, a));
    EXPECT_FALSE(DYND_PP_EQ(a, A));
    EXPECT_FALSE(DYND_PP_EQ(P, q));
    EXPECT_FALSE(DYND_PP_EQ(Z, z));
    EXPECT_FALSE(DYND_PP_EQ(z, Z));

    EXPECT_FALSE(DYND_PP_EQ(A0, A0));
#define DYND_PP_A0_EQ_A0
    EXPECT_TRUE(DYND_PP_EQ(A0, A0));
#undef DYND_PP_A0_EQ_A0
    EXPECT_FALSE(DYND_PP_EQ(A0, A0));

    EXPECT_FALSE(DYND_PP_EQ(ABC, ABC));
#define DYND_PP_ABC_EQ_ABC
    EXPECT_TRUE(DYND_PP_EQ(ABC, ABC));
#undef DYND_PP_ABC_EQ_ABC
    EXPECT_FALSE(DYND_PP_EQ(ABC, ABC));

    EXPECT_FALSE(DYND_PP_EQ(abc, abc));
#define DYND_PP_abc_EQ_abc
    EXPECT_TRUE(DYND_PP_EQ(abc, abc));
#undef DYND_PP_abc_EQ_abc
    EXPECT_FALSE(DYND_PP_EQ(abc, abc));

    EXPECT_FALSE(DYND_PP_EQ(qy7Z, qy7Z));
#define DYND_PP_qy7Z_EQ_qy7Z
    EXPECT_TRUE(DYND_PP_EQ(qy7Z, qy7Z));
#undef DYND_PP_qy7Z_EQ_qy7Z
    EXPECT_FALSE(DYND_PP_EQ(qy7Z, qy7Z));

    EXPECT_FALSE(DYND_PP_EQ(_dw11_, _dw11_));
#define DYND_PP__dw11__EQ__dw11_
    EXPECT_TRUE(DYND_PP_EQ(_dw11_, _dw11_));
#undef DYND_PP__dw11__EQ__dw11_
    EXPECT_FALSE(DYND_PP_EQ(_dw11_, _dw11_));

#undef DYND_PP_A_EQ_A
    EXPECT_FALSE(DYND_PP_EQ(A, A));
#define DYND_PP_A_EQ_A
    EXPECT_TRUE(DYND_PP_EQ(A, A));

#undef DYND_PP_Z_EQ_Z
    EXPECT_FALSE(DYND_PP_EQ(Z, Z));
#define DYND_PP_Z_EQ_Z
    EXPECT_TRUE(DYND_PP_EQ(Z, Z));

#undef DYND_PP_a_EQ_a
    EXPECT_FALSE(DYND_PP_EQ(a, a));
#define DYND_PP_a_EQ_a
    EXPECT_TRUE(DYND_PP_EQ(a, a));

#undef DYND_PP_z_EQ_z
    EXPECT_FALSE(DYND_PP_EQ(z, z));
#define DYND_PP_z_EQ_z
    EXPECT_TRUE(DYND_PP_EQ(z, z));

#define DYND_PP_A_EQ_B
    EXPECT_TRUE(DYND_PP_EQ(A, B));
    EXPECT_TRUE(DYND_PP_EQ(B, A));
#undef DYND_PP_A_EQ_B
    EXPECT_FALSE(DYND_PP_EQ(A, B));
    EXPECT_FALSE(DYND_PP_EQ(B, A));

#define DYND_PP_B_EQ_A
    EXPECT_TRUE(DYND_PP_EQ(A, B));
    EXPECT_TRUE(DYND_PP_EQ(B, A));
#undef DYND_PP_B_EQ_A
    EXPECT_FALSE(DYND_PP_EQ(A, B));
    EXPECT_FALSE(DYND_PP_EQ(B, A));

#define DYND_PP_ABC_EQ_abc
    EXPECT_FALSE(DYND_PP_EQ(ABC, ABC));
    EXPECT_TRUE(DYND_PP_EQ(ABC, abc));
    EXPECT_TRUE(DYND_PP_EQ(abc, ABC));
    EXPECT_FALSE(DYND_PP_EQ(abc, abc));
#undef DYND_PP_ABC_EQ_abc
    EXPECT_FALSE(DYND_PP_EQ(ABC, ABC));
    EXPECT_FALSE(DYND_PP_EQ(ABC, abc));
    EXPECT_FALSE(DYND_PP_EQ(abc, ABC));
    EXPECT_FALSE(DYND_PP_EQ(abc, abc));
}

TEST(PPComparision, NotEqual) {
    EXPECT_FALSE(DYND_PP_NE(0, 0));

    EXPECT_TRUE(DYND_PP_NE(0, 1));
    EXPECT_TRUE(DYND_PP_NE(1, 0));
    EXPECT_FALSE(DYND_PP_NE(1, 1));

    EXPECT_TRUE(DYND_PP_NE(4, 2));

    EXPECT_TRUE(DYND_PP_NE(3, 4));
    EXPECT_TRUE(DYND_PP_NE(4, 3));

    EXPECT_FALSE(DYND_PP_NE(4, 4));

    EXPECT_TRUE(DYND_PP_NE(0, 8));
    EXPECT_TRUE(DYND_PP_NE(8, 0));
    EXPECT_FALSE(DYND_PP_NE(8, 8));

    EXPECT_TRUE(DYND_PP_NE(0, DYND_PP_LEN_MAX));
    EXPECT_TRUE(DYND_PP_NE(DYND_PP_LEN_MAX, 0));
    EXPECT_TRUE(DYND_PP_NE(3, DYND_PP_LEN_MAX));
    EXPECT_TRUE(DYND_PP_NE(DYND_PP_LEN_MAX, 4));
    EXPECT_FALSE(DYND_PP_NE(DYND_PP_LEN_MAX, DYND_PP_LEN_MAX));

    EXPECT_FALSE(DYND_PP_NE(A, A));
    EXPECT_TRUE(DYND_PP_NE(A, B));
    EXPECT_TRUE(DYND_PP_NE(B, A));

    EXPECT_FALSE(DYND_PP_NE(P, P));
    EXPECT_TRUE(DYND_PP_NE(P, Q));
    EXPECT_TRUE(DYND_PP_NE(Q, P));
    EXPECT_FALSE(DYND_PP_NE(Q, Q));

    EXPECT_TRUE(DYND_PP_NE(Z, A));
    EXPECT_TRUE(DYND_PP_NE(A, Z));
    EXPECT_TRUE(DYND_PP_NE(P, Z));
    EXPECT_TRUE(DYND_PP_NE(Z, Q));
    EXPECT_FALSE(DYND_PP_NE(Z, Z));

    EXPECT_FALSE(DYND_PP_NE(a, a));
    EXPECT_TRUE(DYND_PP_NE(a, b));
    EXPECT_TRUE(DYND_PP_NE(b, a));

    EXPECT_FALSE(DYND_PP_NE(p, p));
    EXPECT_TRUE(DYND_PP_NE(p, q));
    EXPECT_TRUE(DYND_PP_NE(q, p));
    EXPECT_FALSE(DYND_PP_NE(q, q));

    EXPECT_TRUE(DYND_PP_NE(z, a));
    EXPECT_TRUE(DYND_PP_NE(a, z));
    EXPECT_TRUE(DYND_PP_NE(p, z));
    EXPECT_TRUE(DYND_PP_NE(z, q));
    EXPECT_FALSE(DYND_PP_NE(z, z));

    EXPECT_TRUE(DYND_PP_NE(A, a));
    EXPECT_TRUE(DYND_PP_NE(a, A));
    EXPECT_TRUE(DYND_PP_NE(P, q));
    EXPECT_TRUE(DYND_PP_NE(Z, z));
    EXPECT_TRUE(DYND_PP_NE(z, Z));

    EXPECT_TRUE(DYND_PP_NE(A0, A0));
#define DYND_PP_A0_EQ_A0
    EXPECT_FALSE(DYND_PP_NE(A0, A0));
#undef DYND_PP_A0_EQ_A0
    EXPECT_TRUE(DYND_PP_NE(A0, A0));

    EXPECT_TRUE(DYND_PP_NE(ABC, ABC));
#define DYND_PP_ABC_EQ_ABC
    EXPECT_FALSE(DYND_PP_NE(ABC, ABC));
#undef DYND_PP_ABC_EQ_ABC
    EXPECT_TRUE(DYND_PP_NE(ABC, ABC));

    EXPECT_TRUE(DYND_PP_NE(abc, abc));
#define DYND_PP_abc_EQ_abc
    EXPECT_FALSE(DYND_PP_NE(abc, abc));
#undef DYND_PP_abc_EQ_abc
    EXPECT_TRUE(DYND_PP_NE(abc, abc));

    EXPECT_TRUE(DYND_PP_NE(qy7Z, qy7Z));
#define DYND_PP_qy7Z_EQ_qy7Z
    EXPECT_FALSE(DYND_PP_NE(qy7Z, qy7Z));
#undef DYND_PP_qy7Z_EQ_qy7Z
    EXPECT_TRUE(DYND_PP_NE(qy7Z, qy7Z));

    EXPECT_TRUE(DYND_PP_NE(_dw11_, _dw11_));
#define DYND_PP__dw11__EQ__dw11_
    EXPECT_FALSE(DYND_PP_NE(_dw11_, _dw11_));
#undef DYND_PP__dw11__EQ__dw11_
    EXPECT_TRUE(DYND_PP_NE(_dw11_, _dw11_));

#undef DYND_PP_A_EQ_A
    EXPECT_TRUE(DYND_PP_NE(A, A));
#define DYND_PP_A_EQ_A
    EXPECT_FALSE(DYND_PP_NE(A, A));

#undef DYND_PP_Z_EQ_Z
    EXPECT_TRUE(DYND_PP_NE(Z, Z));
#define DYND_PP_Z_EQ_Z
    EXPECT_FALSE(DYND_PP_NE(Z, Z));

#undef DYND_PP_a_EQ_a
    EXPECT_TRUE(DYND_PP_NE(a, a));
#define DYND_PP_a_EQ_a
    EXPECT_FALSE(DYND_PP_NE(a, a));

#undef DYND_PP_z_EQ_z
    EXPECT_TRUE(DYND_PP_NE(z, z));
#define DYND_PP_z_EQ_z
    EXPECT_FALSE(DYND_PP_NE(z, z));

#define DYND_PP_A_EQ_B
    EXPECT_FALSE(DYND_PP_NE(A, B));
    EXPECT_FALSE(DYND_PP_NE(B, A));
#undef DYND_PP_A_EQ_B
    EXPECT_TRUE(DYND_PP_NE(A, B));
    EXPECT_TRUE(DYND_PP_NE(B, A));

#define DYND_PP_B_EQ_A
    EXPECT_FALSE(DYND_PP_NE(A, B));
    EXPECT_FALSE(DYND_PP_NE(B, A));
#undef DYND_PP_B_EQ_A
    EXPECT_TRUE(DYND_PP_NE(A, B));
    EXPECT_TRUE(DYND_PP_NE(B, A));

#define DYND_PP_ABC_EQ_abc
    EXPECT_TRUE(DYND_PP_NE(ABC, ABC));
    EXPECT_FALSE(DYND_PP_NE(ABC, abc));
    EXPECT_FALSE(DYND_PP_NE(abc, ABC));
    EXPECT_TRUE(DYND_PP_NE(abc, abc));
#undef DYND_PP_ABC_EQ_abc
    EXPECT_TRUE(DYND_PP_NE(ABC, ABC));
    EXPECT_TRUE(DYND_PP_NE(ABC, abc));
    EXPECT_TRUE(DYND_PP_NE(abc, ABC));
    EXPECT_TRUE(DYND_PP_NE(abc, abc));
}

TEST(PPComparision, GreaterEqual) {
    EXPECT_TRUE(DYND_PP_GE(0, 0));

    EXPECT_FALSE(DYND_PP_GE(0, 1));
    EXPECT_TRUE(DYND_PP_GE(1, 0));
    EXPECT_TRUE(DYND_PP_GE(1, 1));

    EXPECT_TRUE(DYND_PP_GE(4, 2));

    EXPECT_FALSE(DYND_PP_GE(3, 4));
    EXPECT_TRUE(DYND_PP_GE(4, 3));

    EXPECT_TRUE(DYND_PP_GE(4, 4));

    EXPECT_FALSE(DYND_PP_GE(0, 8));
    EXPECT_TRUE(DYND_PP_GE(8, 0));
    EXPECT_TRUE(DYND_PP_GE(8, 8));

    EXPECT_FALSE(DYND_PP_GE(0, DYND_PP_LEN_MAX));
    EXPECT_TRUE(DYND_PP_GE(DYND_PP_LEN_MAX, 0));
    EXPECT_FALSE(DYND_PP_GE(3, DYND_PP_LEN_MAX));
    EXPECT_TRUE(DYND_PP_GE(DYND_PP_LEN_MAX, 4));
    EXPECT_TRUE(DYND_PP_GE(DYND_PP_LEN_MAX, DYND_PP_LEN_MAX));
}

TEST(PPComparision, GreaterThan) {
    EXPECT_FALSE(DYND_PP_GT(0, 0));

    EXPECT_FALSE(DYND_PP_GT(0, 1));
    EXPECT_TRUE(DYND_PP_GT(1, 0));
    EXPECT_FALSE(DYND_PP_GT(1, 1));

    EXPECT_TRUE(DYND_PP_GT(4, 2));

    EXPECT_FALSE(DYND_PP_GT(3, 4));
    EXPECT_TRUE(DYND_PP_GT(4, 3));

    EXPECT_FALSE(DYND_PP_GT(4, 4));

    EXPECT_FALSE(DYND_PP_GT(0, 8));
    EXPECT_TRUE(DYND_PP_GT(8, 0));
    EXPECT_FALSE(DYND_PP_GT(8, 8));

    EXPECT_FALSE(DYND_PP_GT(0, DYND_PP_LEN_MAX));
    EXPECT_TRUE(DYND_PP_GT(DYND_PP_LEN_MAX, 0));
    EXPECT_FALSE(DYND_PP_GT(3, DYND_PP_LEN_MAX));
    EXPECT_TRUE(DYND_PP_GT(DYND_PP_LEN_MAX, 4));
    EXPECT_FALSE(DYND_PP_GT(DYND_PP_LEN_MAX, DYND_PP_LEN_MAX));
}
