#include <diskcache_config.h>

#include "diskcacheAPI/ServerInterface.hh"

using LDASTools::AL::CommandLineOptions;

namespace diskCache
{
  //=====================================================================
  //
  //===================================================================== 
  std::string ServerInterface::DEFAULT_EXTENSION( ".gwf" );
  void ServerInterface::
  FilenamesRDS( filenames_rds_results_type& Results,
		const std::string& IFO,
		const std::string& Desc,
		time_type StartTime,
		time_type EndTime,
		bool Resampling,
		const std::string& Extension )
  {
    std::list< std::string >	args;
    std::ostringstream		start_str;
    std::ostringstream		end_str;


    start_str << StartTime;
    end_str << EndTime;

    args.push_back( "filenames-rds" );
    args.push_back( "--extension" );
    args.push_back( Extension );
    args.push_back( "--ifo" );
    args.push_back( IFO );
    args.push_back( "--type" );
    args.push_back( Desc );
    args.push_back( "--start-time" );
    args.push_back( start_str.str( ) );
    args.push_back( "--end-time" );
    args.push_back( end_str.str( ) );
    if ( Resampling )
    {
      args.push_back( "--resample" );
    }

    CommandLineOptions	cl( args );

    diskCache::MetaCommand::FilenamesRDS	diskcache_query( cl, *this );

    diskcache_query();

    std::insert_iterator< filenames_rds_results_type >
      insert_it( Results, Results.begin( ) );

    std::copy( diskcache_query.Results( ).begin( ),
	       diskcache_query.Results( ).end( ),
	       insert_it );
  }
 
} // namespace - diskCache
