/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.IdentifierChecker;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00172\u0006\u0010\f\u001a\u00020\rH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmSimpleNameBacktickChecker;", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "()V", "INVALID_CHARS", "", "", "getINVALID_CHARS", "()Ljava/util/Set;", "checkDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkIdentifier", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "checkNamed", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "reportIfNeeded", "name", "", "reportOn", "Lkotlin/Function0;", "Lcom/intellij/psi/PsiElement;", "frontend.java"})
public final class JvmSimpleNameBacktickChecker
implements IdentifierChecker {
    @NotNull
    private static final Set<Character> INVALID_CHARS;
    public static final JvmSimpleNameBacktickChecker INSTANCE;

    @NotNull
    public final Set<Character> getINVALID_CHARS() {
        return INVALID_CHARS;
    }

    @Override
    public void checkIdentifier(@NotNull KtSimpleNameExpression simpleNameExpression, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkNotNullParameter(simpleNameExpression, "simpleNameExpression");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        this.reportIfNeeded(simpleNameExpression.getReferencedName(), (Function0<? extends PsiElement>)new Function0<PsiElement>(simpleNameExpression){
            final /* synthetic */ KtSimpleNameExpression $simpleNameExpression;

            @Nullable
            public final PsiElement invoke() {
                return this.$simpleNameExpression.getIdentifier();
            }
            {
                this.$simpleNameExpression = ktSimpleNameExpression;
                super(0);
            }
        }, diagnosticHolder);
    }

    @Override
    public void checkDeclaration(@NotNull KtDeclaration declaration2, @NotNull DiagnosticSink diagnosticHolder) {
        ASTDelegatePsiElement it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        if (declaration2 instanceof KtDestructuringDeclaration) {
            List<KtDestructuringDeclarationEntry> list2 = ((KtDestructuringDeclaration)declaration2).getEntries();
            Intrinsics.checkNotNullExpressionValue(list2, "declaration.entries");
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtDestructuringDeclarationEntry)element$iv;
                boolean bl = false;
                ASTDelegatePsiElement aSTDelegatePsiElement = it;
                Intrinsics.checkNotNullExpressionValue(aSTDelegatePsiElement, "it");
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)aSTDelegatePsiElement), diagnosticHolder);
            }
        }
        if (declaration2 instanceof KtCallableDeclaration) {
            List<KtParameter> list3 = ((KtCallableDeclaration)declaration2).getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list3, "declaration.valueParameters");
            $this$forEach$iv = list3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtParameter)element$iv;
                boolean bl = false;
                ASTDelegatePsiElement aSTDelegatePsiElement = it;
                Intrinsics.checkNotNullExpressionValue(aSTDelegatePsiElement, "it");
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)aSTDelegatePsiElement), diagnosticHolder);
            }
        }
        if (declaration2 instanceof KtTypeParameterListOwner) {
            List<KtTypeParameter> list4 = ((KtTypeParameterListOwner)declaration2).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list4, "declaration.typeParameters");
            $this$forEach$iv = list4;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtTypeParameter)element$iv;
                boolean bl = false;
                ASTDelegatePsiElement aSTDelegatePsiElement = it;
                Intrinsics.checkNotNullExpressionValue(aSTDelegatePsiElement, "it");
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)aSTDelegatePsiElement), diagnosticHolder);
            }
        }
        if (declaration2 instanceof KtNamedDeclaration) {
            this.checkNamed((KtNamedDeclaration)declaration2, diagnosticHolder);
        }
    }

    private final void checkNamed(KtNamedDeclaration declaration2, DiagnosticSink diagnosticHolder) {
        String string2 = declaration2.getName();
        if (string2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue(string2, "declaration.name ?: return");
        String name = string2;
        this.reportIfNeeded(name, (Function0<? extends PsiElement>)new Function0<PsiElement>(declaration2){
            final /* synthetic */ KtNamedDeclaration $declaration;

            @Nullable
            public final PsiElement invoke() {
                PsiElement psiElement = this.$declaration.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = this.$declaration;
                }
                return psiElement;
            }
            {
                this.$declaration = ktNamedDeclaration;
                super(0);
            }
        }, diagnosticHolder);
    }

    private final void reportIfNeeded(String name, Function0<? extends PsiElement> reportOn, DiagnosticSink diagnosticHolder) {
        String string2 = KtPsiUtil.unquoteIdentifier(name);
        Intrinsics.checkNotNullExpressionValue(string2, "KtPsiUtil.unquoteIdentifier(name)");
        String text2 = string2;
        CharSequence charSequence = text2;
        boolean bl = false;
        if (charSequence.length() == 0) {
            PsiElement psiElement = reportOn.invoke();
            if (psiElement == null) {
                return;
            }
            diagnosticHolder.report(Errors.INVALID_CHARACTERS.on(psiElement, "should not be empty"));
        } else {
            boolean bl2;
            block6: {
                CharSequence $this$any$iv = text2;
                boolean $i$f$any = false;
                CharSequence charSequence2 = $this$any$iv;
                for (int i = 0; i < charSequence2.length(); ++i) {
                    char element$iv;
                    char it = element$iv = charSequence2.charAt(i);
                    boolean bl3 = false;
                    if (!INVALID_CHARS.contains(Character.valueOf(it))) continue;
                    bl2 = true;
                    break block6;
                }
                bl2 = false;
            }
            if (bl2) {
                PsiElement psiElement = reportOn.invoke();
                if (psiElement == null) {
                    return;
                }
                diagnosticHolder.report(Errors.INVALID_CHARACTERS.on(psiElement, "contains illegal characters: " + CollectionsKt.joinToString$default(CollectionsKt.intersect((Iterable)INVALID_CHARS, (Iterable)StringsKt.toSet(text2)), "", null, null, 0, null, null, 62, null)));
            }
        }
    }

    private JvmSimpleNameBacktickChecker() {
    }

    static {
        JvmSimpleNameBacktickChecker jvmSimpleNameBacktickChecker;
        INSTANCE = jvmSimpleNameBacktickChecker = new JvmSimpleNameBacktickChecker();
        INVALID_CHARS = SetsKt.setOf(Character.valueOf('.'), Character.valueOf(';'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('/'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('\\'));
    }
}

