#!/usr/bin/env ruby
# -*- coding: cp932 -*-
require 'vector_operators'

ByName = 0; ByArray = 1;
array_symbol = 'r'

naming_rule = ["", "x", "xy", "xyz", "xyzw"].map{|str|
  (0...str.length).map{|i|
    str[i..i]
  }
}

open('vector.h','w'){|fp|
  fp.puts <<CPPEND
///generated by vector_h.rb

#pragma once
#include <cmath>
#include <iostream>

namespace pfi{
namespace math{
namespace vector{
CPPEND

  (2..10).each{|dim| 
    is = (0...dim).to_a
    myname = "vector#{dim}"
    [ByName, ByArray].each{|approach|
      cs,namespace =
      if approach == ByName
        next unless naming_rule[dim]
        [naming_rule[dim], 'component_by_name']
      else
        [is.map{|i| "#{array_symbol}[#{i}]"}, 'component_by_array']
      end
      
      fp.puts <<CPPEND
namespace #{namespace}{    
  ///linear-algebraic vector of type t, dimension #{dim}.
  template<class t> class #{myname}{
  public:
CPPEND

      if approach == ByName
        fp.puts <<CPPEND
    ///member
    t  #{cs.jk};
    ///zero constructor
    #{myname}():#{cs.mjk{|x|"#{x}(0)"}}{}
    ///constructor from components
    #{myname}(#{cs.mjk{|x|"t #{x}"}}):#{cs.mjk{|x| "#{x}(#{x})"}}{}
    ///constructor from a pointer
    #{myname}(t *v):#{is.map{|i|"#{cs[i]}(v[#{i}])"}.jk}{}
CPPEND
      else
        fp.puts <<CPPEND
    ///member
    t  #{array_symbol}[#{dim}];
    ///zero constructor
    #{myname}(){
      #{cs.map{|x| "#{x}=0; "}.join}
    }
    ///constructor from components
    #{myname}(#{is.mjk{|i|"t #{array_symbol}#{i}"}}){
      #{is.map{|i| "#{cs[i]}=#{array_symbol}#{i}; "}}
    }
    ///constructor from a pointer
    #{myname}(t *v){
      #{is.map{|i|"#{cs[i]}=v[#{i}]; "}.join}
    }
CPPEND
      end
      fp.puts <<CPPEND
  
    ///default normalization;
    #{myname} normalize(t a = 1);
    void writeToArray(t *v) const {
      #{is.map{|i|"v[#{i}]=#{cs[i]};"}.join};
    }

    ///component access operator.
    t& operator[](int index){
      switch(index){
#{is.map{|i|"        case #{i}: return #{cs[i]};"}.jr}
      }
    }
  };

#{vector_operators('template<class t>', 't', "#{myname}<t>", lambda{|*args|"#{myname}<t>(#{args.join(',')})"}, dim, cs)}
  /// normalization also provided as class method
  template<class t>
    #{myname}<t> #{myname}<t>::normalize(t a){
    return (a/abs(*this))*(*this);
  }


  ///read from istream
  template<class t> 
    std::istream& operator>>(std::istream& cin, #{myname}<t>& a){
    t #{is.mjk{|i| "tmp#{i}"}}; 
    cin #{is.map{|i| " >> tmp#{i}" }.join};
    a = #{myname}<t>(#{is.mjk{|i| "tmp#{i}"}});
    return cin;
  }

  ///write to ostream
  template<class t> 
    std::ostream& operator<<(std::ostream& cout, const #{myname}<t> &a){
    return cout << #{cs.map{|x| "a.#{x}" }.join('<< " " << ') };
  }

}//#{namespace}


CPPEND
    } # approach
  } #dim
  
  fp.puts <<CPPEND
}//vector
}//math
}//pfi
CPPEND
} # open
