/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

public enum OperandType {
    ARRAY("ary", 65),
    BIGNUM("big", 66),
    BOOLEAN("bool", 98),
    BUILTIN_CLASS("cls", 79),
    COMPLEX("com", 67),
    CURRENT_SCOPE("scope", 115),
    DYNAMIC_SYMBOL("dsym", 100),
    FIXNUM("fix", 102),
    FLOAT("flo", 70),
    GLOBAL_VARIABLE("$", 36),
    HASH("hash", 123),
    INTEGER("int", 73),
    IR_EXCEPTION("ir_ex", 33),
    LABEL("ipc", 76),
    LOCAL_VARIABLE("*", 108),
    NIL("nil", 78),
    NTH_REF("nth", 49),
    RANGE("rng", 46),
    RATIONAL("rat", 114),
    REGEXP("reg", 47),
    SCOPE_MODULE("mod", 95),
    SELF("self", 83),
    SPLAT("splat", 42),
    STANDARD_ERROR("stderr", 69),
    STRING_LITERAL("str", 39),
    SVALUE("sval", 86),
    SYMBOL("sym", 58),
    TEMPORARY_VARIABLE("reg", 116),
    UNBOXED_BOOLEAN("rawbool", 118),
    UNBOXED_FIXNUM("rawfix", 106),
    UNBOXED_FLOAT("rawflo", 74),
    UNDEFINED_VALUE("undef", 117),
    UNEXECUTABLE_NIL("noex", 110),
    WRAPPED_IR_CLOSURE("block", 119),
    FROZEN_STRING("fstr", 122),
    NULL_BLOCK("noblock", 111),
    FILENAME("file", 109),
    SYMBOL_PROC("symproc", 80),
    SCOPE("scope", 35),
    CHILLED_STRING("chilled", 99);

    private final String shortName;
    private final byte coded;
    private static final OperandType[] byteToOperand;

    private OperandType(String shortName, byte coded) {
        this.shortName = shortName;
        this.coded = coded;
    }

    public byte getCoded() {
        return this.coded;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public String shortName() {
        return this.shortName;
    }

    public static OperandType fromCoded(byte coded) {
        return byteToOperand[coded];
    }

    public static OperandType fromOrdinal(int value2) {
        return value2 < 0 || value2 >= OperandType.values().length ? null : OperandType.values()[value2];
    }

    static {
        byteToOperand = new OperandType[256];
        OperandType[] operandTypeArray = OperandType.values();
        int n = operandTypeArray.length;
        for (int j = 0; j < n; ++j) {
            OperandType type2;
            OperandType.byteToOperand[type2.coded] = type2 = operandTypeArray[j];
        }
    }
}

