/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jreleaser.model.api.packagers.JibConfiguration;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.util.StringUtils;

public interface JibConfiguration
extends Domain,
ExtraProperties,
Activatable {
    public static final String TYPE = "jib";

    public String getTemplateDirectory();

    public void setTemplateDirectory(String var1);

    public List<String> getSkipTemplates();

    public void setSkipTemplates(List<String> var1);

    public void addSkipTemplates(List<String> var1);

    public void addSkipTemplate(String var1);

    public String getBaseImage();

    public void setBaseImage(String var1);

    public Set<String> getImageNames();

    public void setImageNames(Set<String> var1);

    public void addImageName(String var1);

    public String getWorkingDirectory();

    public void setWorkingDirectory(String var1);

    public String getUser();

    public void setUser(String var1);

    public String getCreationTime();

    public void setCreationTime(String var1);

    public JibConfiguration.Format getFormat();

    public void setFormat(JibConfiguration.Format var1);

    public void setFormat(String var1);

    public Map<String, String> getEnvironment();

    public void setEnvironment(Map<String, String> var1);

    public void addEnvironment(Map<String, String> var1);

    public void addEnvironment(String var1, String var2);

    public Map<String, String> getLabels();

    public void setLabels(Map<String, String> var1);

    public void addLabels(Map<String, String> var1);

    public void addLabel(String var1, String var2);

    public Set<String> getVolumes();

    public void setVolumes(Set<String> var1);

    public void addVolumes(Set<String> var1);

    public void addVolume(String var1);

    public Set<String> getExposedPorts();

    public void setExposedPorts(Set<String> var1);

    public void addExposedPorts(Set<String> var1);

    public void addExposedPort(String var1);

    public Set<? extends Registry> getRegistries();

    public void setRegistries(Set<? extends Registry> var1);

    public void addRegistry(Registry var1);

    public static final class Registry
    extends AbstractModelObject<Registry>
    implements Domain,
    Comparable<Registry> {
        private static final long serialVersionUID = -3827873114784273276L;
        private String name;
        private String server;
        private String username;
        private String toUsername;
        private String fromUsername;
        private String password;
        private String toPassword;
        private String fromPassword;
        @JsonIgnore
        private final JibConfiguration.Registry immutable = new JibConfiguration.Registry(){
            private static final long serialVersionUID = -7511037078052130015L;

            public String getName() {
                return name;
            }

            public String getServer() {
                return server;
            }

            public String getUsername() {
                return username;
            }

            public String getToUsername() {
                return toUsername;
            }

            public String getFromUsername() {
                return fromUsername;
            }

            public String getPassword() {
                return password;
            }

            public String getToPassword() {
                return toPassword;
            }

            public String getFromPassword() {
                return fromPassword;
            }

            public int compareTo(JibConfiguration.Registry o) {
                if (null == o) {
                    return -1;
                }
                return name.compareTo(o.getName());
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public JibConfiguration.Registry asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Registry source) {
            this.name = this.merge(this.name, source.name);
            this.server = this.merge(this.server, source.server);
            this.username = this.merge(this.username, source.username);
            this.toUsername = this.merge(this.toUsername, source.toUsername);
            this.fromUsername = this.merge(this.fromUsername, source.fromUsername);
            this.password = this.merge(this.password, source.password);
            this.toPassword = this.merge(this.toPassword, source.toPassword);
            this.fromPassword = this.merge(this.fromPassword, source.fromPassword);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getServer() {
            return this.server;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getToUsername() {
            return this.toUsername;
        }

        public void setToUsername(String toUsername) {
            this.toUsername = toUsername;
        }

        public String getFromUsername() {
            return this.fromUsername;
        }

        public void setFromUsername(String fromUsername) {
            this.fromUsername = fromUsername;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getToPassword() {
            return this.toPassword;
        }

        public void setToPassword(String toPassword) {
            this.toPassword = toPassword;
        }

        public String getFromPassword() {
            return this.fromPassword;
        }

        public void setFromPassword(String fromPassword) {
            this.fromPassword = fromPassword;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", this.name);
            map.put("server", this.server);
            map.put("username", StringUtils.isNotBlank((String)this.username) ? "************" : "**unset**");
            map.put("toUsername", StringUtils.isNotBlank((String)this.toUsername) ? "************" : "**unset**");
            map.put("fromUsername", StringUtils.isNotBlank((String)this.fromUsername) ? "************" : "**unset**");
            map.put("password", StringUtils.isNotBlank((String)this.password) ? "************" : "**unset**");
            map.put("toPassword", StringUtils.isNotBlank((String)this.toPassword) ? "************" : "**unset**");
            map.put("fromPassword", StringUtils.isNotBlank((String)this.fromPassword) ? "************" : "**unset**");
            return map;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            Registry that = (Registry)o;
            return this.server.equals(that.server);
        }

        public int hashCode() {
            return Objects.hash(this.server);
        }

        @Override
        public int compareTo(Registry o) {
            if (null == o) {
                return -1;
            }
            return this.server.compareTo(o.server);
        }
    }
}

